#!/usr/bin/env python

""" 
build the 'py' documentation and api docs in a specified
directory, defaulting to 'html'.  You need to be a directory
where your "py" package is.  

This script generates API documentation and static
documentation.  The API documentation is generated by using
the "apigen" facility of the py lib which currently only works
on windows. 
"""

import sys
sys.path.insert(0, '.')

import py
import os

def sysexec(cmd):
    print "executing", cmd
    os.system(cmd)

if __name__ == '__main__':
    pydir = py.path.local().join("py")
    assert pydir.check(dir=1), "py directory not found"
    pypath = py.path.local(py.__file__).dirpath()
    assert pydir == pypath, "directory %s and %s differ" %(pydir, pypath)
    
    args = sys.argv[1:]
    if not args:
        htmldir = py.path.local('html')
    else:
        htmldir = py.path.local(sys.argv.pop(0))

    print "generating docs into", htmldir
    print "pypath", pypath
    pytest = pypath.join("bin/py.test")
    assert pytest.check()

    print 
    print "*" * 30, "apigen", "*"*30
    apigendir = htmldir.join("apigen")
    env = 'DOCPATH="%s" APIGENPATH="%s"' %(htmldir, apigendir)
    if apigendir.check():
        print apigendir, "exists, not re-generating - remove to trigger regeneration"
    else:
        sysexec('%(env)s %(pytest)s --apigen=%(pypath)s/apigen/apigen.py py' % locals())
    print 
    print "*" * 30, "static generation", "*" * 30
    sysexec('%(env)s %(pytest)s --forcegen %(pypath)s/doc' % locals())
