/* File: libphshmodule.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * See http://cens.ioc.ee/projects/f2py2e/
 * Generation date: Mon Jun 02 08:55:21 2014
 * $Revision:$
 * $Date:$
 * Do not edit this file directly unless you know what you are doing!!!
 */
#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include "Python.h"
#include <stdarg.h>
#include "fortranobject.h"
#include <string.h>
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *libphsh_error;
static PyObject *libphsh_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef char * string;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#define PRINTPYOBJERR(obj)\
  fprintf(stderr,"libphsh.error is related to ");\
  PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
  fprintf(stderr,"\n");

\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
  if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
    PyErr_SetString(PyExc_MemoryError, "out of memory");\
    goto capi_fail;\
  } else {\
    (str)[len] = '\0';\
  }

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (((PyArrayObject *)(capi_ ## var ## _tmp))->nd)
#define old_shape(var,dim) (((PyArrayObject *)(capi_ ## var ## _tmp))->dimensions[dim])
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
  PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
  fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f##_,F##_)
#else
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f,F)
#endif

#define CHECKSCALAR(check,tcheck,name,show,var)\
  if (!(check)) {\
    char errstring[256];\
    sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
    PyErr_SetString(libphsh_error,errstring);\
    /*goto capi_fail;*/\
  } else 
#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess) {
  PyArrayObject *arr = NULL;
  PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
  if (obj == Py_None) {
    if (*len == -1)
      *len = strlen(inistr); /* Will this cause problems? */
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,inistr,*len+1);
    return 1;
  }
  if (PyArray_Check(obj)) {
    if ((arr = (PyArrayObject *)obj) == NULL)
      goto capi_fail;
    if (!ISCONTIGUOUS(arr)) {
      PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
      goto capi_fail;
    }
    if (*len == -1)
      *len = (arr->descr->elsize)*PyArray_SIZE(arr);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,arr->data,*len+1);
    return 1;
  }
  if (PyString_Check(obj)) {
    tmp = obj;
    Py_INCREF(tmp);
  }
#if PY_VERSION_HEX >= 0x03000000
  else if (PyUnicode_Check(obj)) {
    tmp = PyUnicode_AsASCIIString(obj);
  }
  else {
    PyObject *tmp2;
    tmp2 = PyObject_Str(obj);
    if (tmp2) {
      tmp = PyUnicode_AsASCIIString(tmp2);
      Py_DECREF(tmp2);
    }
    else {
      tmp = NULL;
    }
  }
#else
  else {
    tmp = PyObject_Str(obj);
  }
#endif
  if (tmp == NULL) goto capi_fail;
  if (*len == -1)
    *len = PyString_GET_SIZE(tmp);
  STRINGMALLOC(*str,*len);
  STRINGCOPYN(*str,PyString_AS_STRING(tmp),*len+1);
  Py_DECREF(tmp);
  return 1;
capi_fail:
  Py_XDECREF(tmp);
  {
    PyObject* err = PyErr_Occurred();
    if (err==NULL) err = libphsh_error;
    PyErr_SetString(err,errmess);
  }
  return 0;
}

static int double_from_pyobj(double* v,PyObject *obj,const char *errmess) {
  PyObject* tmp = NULL;
  if (PyFloat_Check(obj)) {
#ifdef __sgi
    *v = PyFloat_AsDouble(obj);
#else
    *v = PyFloat_AS_DOUBLE(obj);
#endif
    return 1;
  }
  tmp = PyNumber_Float(obj);
  if (tmp) {
#ifdef __sgi
    *v = PyFloat_AsDouble(tmp);
#else
    *v = PyFloat_AS_DOUBLE(tmp);
#endif
    Py_DECREF(tmp);
    return 1;
  }
  if (PyComplex_Check(obj))
    tmp = PyObject_GetAttrString(obj,"real");
  else if (PyString_Check(obj) || PyUnicode_Check(obj))
    /*pass*/;
  else if (PySequence_Check(obj))
    tmp = PySequence_GetItem(obj,0);
  if (tmp) {
    PyErr_Clear();
    if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
    Py_DECREF(tmp);
  }
  {
    PyObject* err = PyErr_Occurred();
    if (err==NULL) err = libphsh_error;
    PyErr_SetString(err,errmess);
  }
  return 0;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
  PyObject* tmp = NULL;
  if (PyInt_Check(obj)) {
    *v = (int)PyInt_AS_LONG(obj);
    return 1;
  }
  tmp = PyNumber_Int(obj);
  if (tmp) {
    *v = PyInt_AS_LONG(tmp);
    Py_DECREF(tmp);
    return 1;
  }
  if (PyComplex_Check(obj))
    tmp = PyObject_GetAttrString(obj,"real");
  else if (PyString_Check(obj) || PyUnicode_Check(obj))
    /*pass*/;
  else if (PySequence_Check(obj))
    tmp = PySequence_GetItem(obj,0);
  if (tmp) {
    PyErr_Clear();
    if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
    Py_DECREF(tmp);
  }
  {
    PyObject* err = PyErr_Occurred();
    if (err==NULL) err = libphsh_error;
    PyErr_SetString(err,errmess);
  }
  return 0;
}

static int try_pyarr_from_string(PyObject *obj,const string str) {
  PyArrayObject *arr = NULL;
  if (PyArray_Check(obj) && (!((arr = (PyArrayObject *)obj) == NULL)))
    { STRINGCOPYN(arr->data,str,PyArray_NBYTES(arr)); }
  return 1;
capi_fail:
  PRINTPYOBJERR(obj);
  PyErr_SetString(libphsh_error,"try_pyarr_from_string failed");
  return 0;
}

static int float_from_pyobj(float* v,PyObject *obj,const char *errmess) {
  double d=0.0;
  if (double_from_pyobj(&d,obj,errmess)) {
    *v = (float)d;
    return 1;
  }
  return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC(hartfock,HARTFOCK)(string,size_t);
extern void F_FUNC(abinitio,ABINITIO)(double*,int*,double*,double*,int*,double*,double*,double*,double*,double*,int*,double*,double*,double*,int*,int*,int*,double*,double*,double*,int*,double*,double*,int*);
extern void F_FUNC(atsolve,ATSOLVE)(double*,int*,double*,double*,double*,int*,int*,double*,double*,double*,double*,double*,int*,double*,double*,double*,int*,int*,int*,int*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*,int*);
extern void F_FUNC(getpot,GETPOT)(double*,int*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*,double*,double*,int*,int*,int*,int*,int*,double*,double*,double*,double*,int*);
extern void F_FUNC(elsolve,ELSOLVE)(int*,double*,int*,int*,double*,double*,double*,double*,double*,double*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*);
extern void F_FUNC(augment,AUGMENT)(double*,int*,double*,double*,double*,int*,double*,double*);
extern void F_FUNC(setqmm,SETQMM)(int*,double*,int*,int*,int*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*,int*,double*);
extern void F_FUNC(initiali,INITIALI)(double*,int*,double*,double*,double*,double*,double*,double*,int*,double*,int*);
extern void F_FUNC(setgrid,SETGRID)(int*,double*,double*,double*,double*,double*,double*);
extern void F_FUNC(integ,INTEG)(double*,int*,double*,int*,int*,int*,int*,double*,double*,double*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*);
extern void F_FUNC(clebschgordan,CLEBSCHGORDAN)(int*,int*,double*);
extern void F_FUNC(pseudo,PSEUDO)(double*,int*,double*,double*,int*,double*,double*,double*,double*,double*,double*,double*,double*,int*,double*,double*,double*,int*,int*,int*,double*,double*,double*,int*,double*,int*,double*);
extern void F_FUNC(parabreg,PARABREG)(double*,double*,double*,double*,double*);
extern void F_WRAPPEDFUNC(hb,HB)(double*,double*,double*);
extern void F_FUNC(fitx0,FITX0)(int*,double*,double*,int*,double*,int*,double*,int*,int*,double*,double*,double*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*);
extern void F_FUNC(pseudize,PSEUDIZE)(int*,double*,double*,int*,double*,int*,int*,double*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*,double*);
extern void F_FUNC(fourier,FOURIER)(int*,double*,double*,double*,double*);
extern void F_FUNC(GETILLLS,GETILLLS)(double*);
extern void F_FUNC(hfdisk,HFDISK)(int*,int*,double*,int*,double*,int*,double*,double*,double*,double*,double*,double*,int*,int*,int*,int*,double*,int*,double*,double*,double*,int*,double*,double*,double*);
extern void F_FUNC(exchcorr,EXCHCORR)(int*,double*,double*,double*,double*,double*,double*,double*,double*,double*,double*);
extern void F_WRAPPEDFUNC(cavpot,CAVPOT)(float*,string,int*,string,string,string,string,string,size_t,size_t,size_t,size_t,size_t,size_t);
extern void F_FUNC(CHGRID,CHGRID)(double*,double*,int*,double*,double*,int*);
extern void F_FUNC(CLEMIN,CLEMIN)(double*,double*,int*,int*);
extern void F_FUNC(Hsin,HSIN)(double*,double*,int*,int*);
extern void F_FUNC(MAD,MAD)(double*,double*,int*,double*,int*,int*,int*,double*,double*,double*,int*,double*);
extern void F_FUNC(MTZ,MTZ)(double*,double*,double*,int*,double*,int*,int*,int*,double*,double*,int*,double*,double*,double*,double*,int*);
extern void F_FUNC(MTZM,MTZM)(double*,double*,double*,int*,double*,double*,int*,int*,double*,double*);
extern void F_FUNC(NBR,NBR)(int*,int*,double*,int*,int*,int*,double*,double*,int*,double*,int*);
extern void F_FUNC(POISON,POISON)(double*,double*,int*,double*);
extern void F_FUNC(RELA,RELA)(double*,double*,int*,int*);
extern void F_FUNC(SUMAX,SUMAX)(double*,double*,double*,int*,int*,int*,int*,double*,int*,int*,int*);
extern void F_FUNC_US(PHSH_CAV,PHSH_CAV)(string,string,string,string,size_t,size_t,size_t,size_t);
extern void F_FUNC(PS,PS)(double*,double*,int*,double*,double*,double*,int*,int*);
extern void F_FUNC(CALCBF,CALCBF)(double*,double*,int*,double*,int*);
extern void F_FUNC_US(PHSH_WIL,PHSH_WIL)(string,string,string,string,size_t,size_t,size_t,size_t);
extern void F_FUNC(S16,S16)(void);
extern void F_WRAPPEDFUNC(f12,F12)(double*,float*,float*,double*,int*);
extern void F_FUNC(S5,S5)(double*);
extern void F_FUNC(S10,S10)(double*);
extern void F_WRAPPEDFUNC(f44,F44)(double*,int*,double*);
extern void F_WRAPPEDFUNC(f45,F45)(double*,int*,double*);
extern void F_FUNC(S41,S41)(double*,double*,int*);
extern void F_FUNC_US(PHSH_REL,PHSH_REL)(string,string,string,string,size_t,size_t,size_t,size_t);
extern void F_WRAPPEDFUNC(dlgkap,DLGKAP)(double*,double*,int*);
extern void F_FUNC(SBFIT,SBFIT)(double*,double*,int*,double*,float*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/********************************** hartfock **********************************/
static char doc_f2py_rout_libphsh_hartfock[] = "\
hartfock(input_file)\n\nWrapper for ``hartfock``.\
\n\nParameters\n----------\n"
"input_file : input string(len=255)";
/* extern void F_FUNC(hartfock,HARTFOCK)(string,size_t); */
static PyObject *f2py_rout_libphsh_hartfock(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string input_file = NULL;
  int slen(input_file);
  PyObject *input_file_capi = Py_None;
  static char *capi_kwlist[] = {"input_file",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:libphsh.hartfock",\
    capi_kwlist,&input_file_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable input_file */
  slen(input_file) = 255;
  f2py_success = string_from_pyobj(&input_file,&slen(input_file),"",input_file_capi,"string_from_pyobj failed in converting 1st argument `input_file' of libphsh.hartfock to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(input_file,slen(input_file));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(input_file);
  }  /*if (f2py_success) of input_file*/
  /* End of cleaning variable input_file */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of hartfock ******************************/

/********************************** abinitio **********************************/
static char doc_f2py_rout_libphsh_abinitio[] = "\
abinitio(etot,nst,rel,alfa,nr,r,dr,r2,dl,phe,njrc,vi,zorig,xntot,nel,no,nl,xnj,ev,occ,is,ek,orb,iuflag)\n\nWrapper for ``abinitio``.\
\n\nParameters\n----------\n"
"etot : input float\n"
"nst : input int\n"
"rel : input float\n"
"alfa : input float\n"
"nr : input int\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"dr : input rank-1 array('d') with bounds (4000)\n"
"r2 : input rank-1 array('d') with bounds (4000)\n"
"dl : input float\n"
"phe : input rank-2 array('d') with bounds (4000,33)\n"
"njrc : input rank-1 array('i') with bounds (4)\n"
"vi : input rank-2 array('d') with bounds (4000,7)\n"
"zorig : input float\n"
"xntot : input float\n"
"nel : input int\n"
"no : input rank-1 array('i') with bounds (33)\n"
"nl : input rank-1 array('i') with bounds (33)\n"
"xnj : input rank-1 array('d') with bounds (33)\n"
"ev : input rank-1 array('d') with bounds (33)\n"
"occ : input rank-1 array('d') with bounds (33)\n"
"is : input rank-1 array('i') with bounds (33)\n"
"ek : input rank-1 array('d') with bounds (33)\n"
"orb : input rank-2 array('d') with bounds (4000,33)\n"
"iuflag : input int";
/* extern void F_FUNC(abinitio,ABINITIO)(double*,int*,double*,double*,int*,double*,double*,double*,double*,double*,int*,double*,double*,double*,int*,int*,int*,double*,double*,double*,int*,double*,double*,int*); */
static PyObject *f2py_rout_libphsh_abinitio(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,double*,int*,double*,double*,double*,double*,double*,int*,double*,double*,double*,int*,int*,int*,double*,double*,double*,int*,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double etot = 0;
  PyObject *etot_capi = Py_None;
  int nst = 0;
  PyObject *nst_capi = Py_None;
  double rel = 0;
  PyObject *rel_capi = Py_None;
  double alfa = 0;
  PyObject *alfa_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *dr = NULL;
  npy_intp dr_Dims[1] = {-1};
  const int dr_Rank = 1;
  PyArrayObject *capi_dr_tmp = NULL;
  int capi_dr_intent = 0;
  PyObject *dr_capi = Py_None;
  double *r2 = NULL;
  npy_intp r2_Dims[1] = {-1};
  const int r2_Rank = 1;
  PyArrayObject *capi_r2_tmp = NULL;
  int capi_r2_intent = 0;
  PyObject *r2_capi = Py_None;
  double dl = 0;
  PyObject *dl_capi = Py_None;
  double *phe = NULL;
  npy_intp phe_Dims[2] = {-1, -1};
  const int phe_Rank = 2;
  PyArrayObject *capi_phe_tmp = NULL;
  int capi_phe_intent = 0;
  PyObject *phe_capi = Py_None;
  int *njrc = NULL;
  npy_intp njrc_Dims[1] = {-1};
  const int njrc_Rank = 1;
  PyArrayObject *capi_njrc_tmp = NULL;
  int capi_njrc_intent = 0;
  PyObject *njrc_capi = Py_None;
  double *vi = NULL;
  npy_intp vi_Dims[2] = {-1, -1};
  const int vi_Rank = 2;
  PyArrayObject *capi_vi_tmp = NULL;
  int capi_vi_intent = 0;
  PyObject *vi_capi = Py_None;
  double zorig = 0;
  PyObject *zorig_capi = Py_None;
  double xntot = 0;
  PyObject *xntot_capi = Py_None;
  int nel = 0;
  PyObject *nel_capi = Py_None;
  int *no = NULL;
  npy_intp no_Dims[1] = {-1};
  const int no_Rank = 1;
  PyArrayObject *capi_no_tmp = NULL;
  int capi_no_intent = 0;
  PyObject *no_capi = Py_None;
  int *nl = NULL;
  npy_intp nl_Dims[1] = {-1};
  const int nl_Rank = 1;
  PyArrayObject *capi_nl_tmp = NULL;
  int capi_nl_intent = 0;
  PyObject *nl_capi = Py_None;
  double *xnj = NULL;
  npy_intp xnj_Dims[1] = {-1};
  const int xnj_Rank = 1;
  PyArrayObject *capi_xnj_tmp = NULL;
  int capi_xnj_intent = 0;
  PyObject *xnj_capi = Py_None;
  double *ev = NULL;
  npy_intp ev_Dims[1] = {-1};
  const int ev_Rank = 1;
  PyArrayObject *capi_ev_tmp = NULL;
  int capi_ev_intent = 0;
  PyObject *ev_capi = Py_None;
  double *occ = NULL;
  npy_intp occ_Dims[1] = {-1};
  const int occ_Rank = 1;
  PyArrayObject *capi_occ_tmp = NULL;
  int capi_occ_intent = 0;
  PyObject *occ_capi = Py_None;
  int *is = NULL;
  npy_intp is_Dims[1] = {-1};
  const int is_Rank = 1;
  PyArrayObject *capi_is_tmp = NULL;
  int capi_is_intent = 0;
  PyObject *is_capi = Py_None;
  double *ek = NULL;
  npy_intp ek_Dims[1] = {-1};
  const int ek_Rank = 1;
  PyArrayObject *capi_ek_tmp = NULL;
  int capi_ek_intent = 0;
  PyObject *ek_capi = Py_None;
  double *orb = NULL;
  npy_intp orb_Dims[2] = {-1, -1};
  const int orb_Rank = 2;
  PyArrayObject *capi_orb_tmp = NULL;
  int capi_orb_intent = 0;
  PyObject *orb_capi = Py_None;
  int iuflag = 0;
  PyObject *iuflag_capi = Py_None;
  static char *capi_kwlist[] = {"etot","nst","rel","alfa","nr","r","dr","r2","dl","phe","njrc","vi","zorig","xntot","nel","no","nl","xnj","ev","occ","is","ek","orb","iuflag",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOOOOOOOOOOOOOO:libphsh.abinitio",\
    capi_kwlist,&etot_capi,&nst_capi,&rel_capi,&alfa_capi,&nr_capi,&r_capi,&dr_capi,&r2_capi,&dl_capi,&phe_capi,&njrc_capi,&vi_capi,&zorig_capi,&xntot_capi,&nel_capi,&no_capi,&nl_capi,&xnj_capi,&ev_capi,&occ_capi,&is_capi,&ek_capi,&orb_capi,&iuflag_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable alfa */
    f2py_success = double_from_pyobj(&alfa,alfa_capi,"libphsh.abinitio() 4th argument (alfa) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ek */
  ek_Dims[0]=33;
  capi_ek_intent |= F2PY_INTENT_IN;
  capi_ek_tmp = array_from_pyobj(NPY_DOUBLE,ek_Dims,ek_Rank,capi_ek_intent,ek_capi);
  if (capi_ek_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 22nd argument `ek' of libphsh.abinitio to C/Fortran array" );
  } else {
    ek = (double *)(capi_ek_tmp->data);

  /* Processing variable vi */
  vi_Dims[0]=4000,vi_Dims[1]=7;
  capi_vi_intent |= F2PY_INTENT_IN;
  capi_vi_tmp = array_from_pyobj(NPY_DOUBLE,vi_Dims,vi_Rank,capi_vi_intent,vi_capi);
  if (capi_vi_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 12nd argument `vi' of libphsh.abinitio to C/Fortran array" );
  } else {
    vi = (double *)(capi_vi_tmp->data);

  /* Processing variable is */
  is_Dims[0]=33;
  capi_is_intent |= F2PY_INTENT_IN;
  capi_is_tmp = array_from_pyobj(NPY_INT,is_Dims,is_Rank,capi_is_intent,is_capi);
  if (capi_is_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 21st argument `is' of libphsh.abinitio to C/Fortran array" );
  } else {
    is = (int *)(capi_is_tmp->data);

  /* Processing variable ev */
  ev_Dims[0]=33;
  capi_ev_intent |= F2PY_INTENT_IN;
  capi_ev_tmp = array_from_pyobj(NPY_DOUBLE,ev_Dims,ev_Rank,capi_ev_intent,ev_capi);
  if (capi_ev_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 19th argument `ev' of libphsh.abinitio to C/Fortran array" );
  } else {
    ev = (double *)(capi_ev_tmp->data);

  /* Processing variable nst */
    f2py_success = int_from_pyobj(&nst,nst_capi,"libphsh.abinitio() 2nd argument (nst) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nel */
    f2py_success = int_from_pyobj(&nel,nel_capi,"libphsh.abinitio() 15th argument (nel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nl */
  nl_Dims[0]=33;
  capi_nl_intent |= F2PY_INTENT_IN;
  capi_nl_tmp = array_from_pyobj(NPY_INT,nl_Dims,nl_Rank,capi_nl_intent,nl_capi);
  if (capi_nl_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 17th argument `nl' of libphsh.abinitio to C/Fortran array" );
  } else {
    nl = (int *)(capi_nl_tmp->data);

  /* Processing variable xntot */
    f2py_success = double_from_pyobj(&xntot,xntot_capi,"libphsh.abinitio() 14th argument (xntot) can't be converted to double");
  if (f2py_success) {
  /* Processing variable no */
  no_Dims[0]=33;
  capi_no_intent |= F2PY_INTENT_IN;
  capi_no_tmp = array_from_pyobj(NPY_INT,no_Dims,no_Rank,capi_no_intent,no_capi);
  if (capi_no_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 16th argument `no' of libphsh.abinitio to C/Fortran array" );
  } else {
    no = (int *)(capi_no_tmp->data);

  /* Processing variable dr */
  dr_Dims[0]=4000;
  capi_dr_intent |= F2PY_INTENT_IN;
  capi_dr_tmp = array_from_pyobj(NPY_DOUBLE,dr_Dims,dr_Rank,capi_dr_intent,dr_capi);
  if (capi_dr_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 7th argument `dr' of libphsh.abinitio to C/Fortran array" );
  } else {
    dr = (double *)(capi_dr_tmp->data);

  /* Processing variable rel */
    f2py_success = double_from_pyobj(&rel,rel_capi,"libphsh.abinitio() 3rd argument (rel) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.abinitio() 5th argument (nr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable etot */
    f2py_success = double_from_pyobj(&etot,etot_capi,"libphsh.abinitio() 1st argument (etot) can't be converted to double");
  if (f2py_success) {
  /* Processing variable dl */
    f2py_success = double_from_pyobj(&dl,dl_capi,"libphsh.abinitio() 9th argument (dl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable iuflag */
    f2py_success = int_from_pyobj(&iuflag,iuflag_capi,"libphsh.abinitio() 24th argument (iuflag) can't be converted to int");
  if (f2py_success) {
  /* Processing variable zorig */
    f2py_success = double_from_pyobj(&zorig,zorig_capi,"libphsh.abinitio() 13rd argument (zorig) can't be converted to double");
  if (f2py_success) {
  /* Processing variable phe */
  phe_Dims[0]=4000,phe_Dims[1]=33;
  capi_phe_intent |= F2PY_INTENT_IN;
  capi_phe_tmp = array_from_pyobj(NPY_DOUBLE,phe_Dims,phe_Rank,capi_phe_intent,phe_capi);
  if (capi_phe_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 10th argument `phe' of libphsh.abinitio to C/Fortran array" );
  } else {
    phe = (double *)(capi_phe_tmp->data);

  /* Processing variable njrc */
  njrc_Dims[0]=4;
  capi_njrc_intent |= F2PY_INTENT_IN;
  capi_njrc_tmp = array_from_pyobj(NPY_INT,njrc_Dims,njrc_Rank,capi_njrc_intent,njrc_capi);
  if (capi_njrc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 11st argument `njrc' of libphsh.abinitio to C/Fortran array" );
  } else {
    njrc = (int *)(capi_njrc_tmp->data);

  /* Processing variable orb */
  orb_Dims[0]=4000,orb_Dims[1]=33;
  capi_orb_intent |= F2PY_INTENT_IN;
  capi_orb_tmp = array_from_pyobj(NPY_DOUBLE,orb_Dims,orb_Rank,capi_orb_intent,orb_capi);
  if (capi_orb_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 23rd argument `orb' of libphsh.abinitio to C/Fortran array" );
  } else {
    orb = (double *)(capi_orb_tmp->data);

  /* Processing variable xnj */
  xnj_Dims[0]=33;
  capi_xnj_intent |= F2PY_INTENT_IN;
  capi_xnj_tmp = array_from_pyobj(NPY_DOUBLE,xnj_Dims,xnj_Rank,capi_xnj_intent,xnj_capi);
  if (capi_xnj_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 18th argument `xnj' of libphsh.abinitio to C/Fortran array" );
  } else {
    xnj = (double *)(capi_xnj_tmp->data);

  /* Processing variable r2 */
  r2_Dims[0]=4000;
  capi_r2_intent |= F2PY_INTENT_IN;
  capi_r2_tmp = array_from_pyobj(NPY_DOUBLE,r2_Dims,r2_Rank,capi_r2_intent,r2_capi);
  if (capi_r2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 8th argument `r2' of libphsh.abinitio to C/Fortran array" );
  } else {
    r2 = (double *)(capi_r2_tmp->data);

  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 6th argument `r' of libphsh.abinitio to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

  /* Processing variable occ */
  occ_Dims[0]=33;
  capi_occ_intent |= F2PY_INTENT_IN;
  capi_occ_tmp = array_from_pyobj(NPY_DOUBLE,occ_Dims,occ_Rank,capi_occ_intent,occ_capi);
  if (capi_occ_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 20th argument `occ' of libphsh.abinitio to C/Fortran array" );
  } else {
    occ = (double *)(capi_occ_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&etot,&nst,&rel,&alfa,&nr,r,dr,r2,&dl,phe,njrc,vi,&zorig,&xntot,&nel,no,nl,xnj,ev,occ,is,ek,orb,&iuflag);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_occ_tmp!=occ_capi) {
    Py_XDECREF(capi_occ_tmp); }
  }  /*if (capi_occ_tmp == NULL) ... else of occ*/
  /* End of cleaning variable occ */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  if((PyObject *)capi_r2_tmp!=r2_capi) {
    Py_XDECREF(capi_r2_tmp); }
  }  /*if (capi_r2_tmp == NULL) ... else of r2*/
  /* End of cleaning variable r2 */
  if((PyObject *)capi_xnj_tmp!=xnj_capi) {
    Py_XDECREF(capi_xnj_tmp); }
  }  /*if (capi_xnj_tmp == NULL) ... else of xnj*/
  /* End of cleaning variable xnj */
  if((PyObject *)capi_orb_tmp!=orb_capi) {
    Py_XDECREF(capi_orb_tmp); }
  }  /*if (capi_orb_tmp == NULL) ... else of orb*/
  /* End of cleaning variable orb */
  if((PyObject *)capi_njrc_tmp!=njrc_capi) {
    Py_XDECREF(capi_njrc_tmp); }
  }  /*if (capi_njrc_tmp == NULL) ... else of njrc*/
  /* End of cleaning variable njrc */
  if((PyObject *)capi_phe_tmp!=phe_capi) {
    Py_XDECREF(capi_phe_tmp); }
  }  /*if (capi_phe_tmp == NULL) ... else of phe*/
  /* End of cleaning variable phe */
  } /*if (f2py_success) of zorig*/
  /* End of cleaning variable zorig */
  } /*if (f2py_success) of iuflag*/
  /* End of cleaning variable iuflag */
  } /*if (f2py_success) of dl*/
  /* End of cleaning variable dl */
  } /*if (f2py_success) of etot*/
  /* End of cleaning variable etot */
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of rel*/
  /* End of cleaning variable rel */
  if((PyObject *)capi_dr_tmp!=dr_capi) {
    Py_XDECREF(capi_dr_tmp); }
  }  /*if (capi_dr_tmp == NULL) ... else of dr*/
  /* End of cleaning variable dr */
  if((PyObject *)capi_no_tmp!=no_capi) {
    Py_XDECREF(capi_no_tmp); }
  }  /*if (capi_no_tmp == NULL) ... else of no*/
  /* End of cleaning variable no */
  } /*if (f2py_success) of xntot*/
  /* End of cleaning variable xntot */
  if((PyObject *)capi_nl_tmp!=nl_capi) {
    Py_XDECREF(capi_nl_tmp); }
  }  /*if (capi_nl_tmp == NULL) ... else of nl*/
  /* End of cleaning variable nl */
  } /*if (f2py_success) of nel*/
  /* End of cleaning variable nel */
  } /*if (f2py_success) of nst*/
  /* End of cleaning variable nst */
  if((PyObject *)capi_ev_tmp!=ev_capi) {
    Py_XDECREF(capi_ev_tmp); }
  }  /*if (capi_ev_tmp == NULL) ... else of ev*/
  /* End of cleaning variable ev */
  if((PyObject *)capi_is_tmp!=is_capi) {
    Py_XDECREF(capi_is_tmp); }
  }  /*if (capi_is_tmp == NULL) ... else of is*/
  /* End of cleaning variable is */
  if((PyObject *)capi_vi_tmp!=vi_capi) {
    Py_XDECREF(capi_vi_tmp); }
  }  /*if (capi_vi_tmp == NULL) ... else of vi*/
  /* End of cleaning variable vi */
  if((PyObject *)capi_ek_tmp!=ek_capi) {
    Py_XDECREF(capi_ek_tmp); }
  }  /*if (capi_ek_tmp == NULL) ... else of ek*/
  /* End of cleaning variable ek */
  } /*if (f2py_success) of alfa*/
  /* End of cleaning variable alfa */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of abinitio ******************************/

/********************************** atsolve **********************************/
static char doc_f2py_rout_libphsh_atsolve[] = "\
atsolve(etot,nst,rel,alfa,eerror,nfc,nr,r,dr,r2,dl,phe,njrc,vi,zorig,xntot,nel,no,nl,nm,xnj,ev,occ,is,ek,ratio,orb,rpower,xnum,etot2,iuflag)\n\nWrapper for ``atsolve``.\
\n\nParameters\n----------\n"
"etot : input float\n"
"nst : input int\n"
"rel : input float\n"
"alfa : input float\n"
"eerror : input float\n"
"nfc : input int\n"
"nr : input int\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"dr : input rank-1 array('d') with bounds (4000)\n"
"r2 : input rank-1 array('d') with bounds (4000)\n"
"dl : input float\n"
"phe : input rank-2 array('d') with bounds (4000,33)\n"
"njrc : input rank-1 array('i') with bounds (4)\n"
"vi : input rank-2 array('d') with bounds (4000,7)\n"
"zorig : input float\n"
"xntot : input float\n"
"nel : input int\n"
"no : input rank-1 array('i') with bounds (33)\n"
"nl : input rank-1 array('i') with bounds (33)\n"
"nm : input rank-1 array('i') with bounds (33)\n"
"xnj : input rank-1 array('d') with bounds (33)\n"
"ev : input rank-1 array('d') with bounds (33)\n"
"occ : input rank-1 array('d') with bounds (33)\n"
"is : input rank-1 array('i') with bounds (33)\n"
"ek : input rank-1 array('d') with bounds (33)\n"
"ratio : input float\n"
"orb : input rank-2 array('d') with bounds (4000,33)\n"
"rpower : input rank-2 array('d') with bounds (4000,16)\n"
"xnum : input float\n"
"etot2 : input float\n"
"iuflag : input int";
/* extern void F_FUNC(atsolve,ATSOLVE)(double*,int*,double*,double*,double*,int*,int*,double*,double*,double*,double*,double*,int*,double*,double*,double*,int*,int*,int*,int*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*,int*); */
static PyObject *f2py_rout_libphsh_atsolve(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,double*,double*,int*,int*,double*,double*,double*,double*,double*,int*,double*,double*,double*,int*,int*,int*,int*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double etot = 0;
  PyObject *etot_capi = Py_None;
  int nst = 0;
  PyObject *nst_capi = Py_None;
  double rel = 0;
  PyObject *rel_capi = Py_None;
  double alfa = 0;
  PyObject *alfa_capi = Py_None;
  double eerror = 0;
  PyObject *eerror_capi = Py_None;
  int nfc = 0;
  PyObject *nfc_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *dr = NULL;
  npy_intp dr_Dims[1] = {-1};
  const int dr_Rank = 1;
  PyArrayObject *capi_dr_tmp = NULL;
  int capi_dr_intent = 0;
  PyObject *dr_capi = Py_None;
  double *r2 = NULL;
  npy_intp r2_Dims[1] = {-1};
  const int r2_Rank = 1;
  PyArrayObject *capi_r2_tmp = NULL;
  int capi_r2_intent = 0;
  PyObject *r2_capi = Py_None;
  double dl = 0;
  PyObject *dl_capi = Py_None;
  double *phe = NULL;
  npy_intp phe_Dims[2] = {-1, -1};
  const int phe_Rank = 2;
  PyArrayObject *capi_phe_tmp = NULL;
  int capi_phe_intent = 0;
  PyObject *phe_capi = Py_None;
  int *njrc = NULL;
  npy_intp njrc_Dims[1] = {-1};
  const int njrc_Rank = 1;
  PyArrayObject *capi_njrc_tmp = NULL;
  int capi_njrc_intent = 0;
  PyObject *njrc_capi = Py_None;
  double *vi = NULL;
  npy_intp vi_Dims[2] = {-1, -1};
  const int vi_Rank = 2;
  PyArrayObject *capi_vi_tmp = NULL;
  int capi_vi_intent = 0;
  PyObject *vi_capi = Py_None;
  double zorig = 0;
  PyObject *zorig_capi = Py_None;
  double xntot = 0;
  PyObject *xntot_capi = Py_None;
  int nel = 0;
  PyObject *nel_capi = Py_None;
  int *no = NULL;
  npy_intp no_Dims[1] = {-1};
  const int no_Rank = 1;
  PyArrayObject *capi_no_tmp = NULL;
  int capi_no_intent = 0;
  PyObject *no_capi = Py_None;
  int *nl = NULL;
  npy_intp nl_Dims[1] = {-1};
  const int nl_Rank = 1;
  PyArrayObject *capi_nl_tmp = NULL;
  int capi_nl_intent = 0;
  PyObject *nl_capi = Py_None;
  int *nm = NULL;
  npy_intp nm_Dims[1] = {-1};
  const int nm_Rank = 1;
  PyArrayObject *capi_nm_tmp = NULL;
  int capi_nm_intent = 0;
  PyObject *nm_capi = Py_None;
  double *xnj = NULL;
  npy_intp xnj_Dims[1] = {-1};
  const int xnj_Rank = 1;
  PyArrayObject *capi_xnj_tmp = NULL;
  int capi_xnj_intent = 0;
  PyObject *xnj_capi = Py_None;
  double *ev = NULL;
  npy_intp ev_Dims[1] = {-1};
  const int ev_Rank = 1;
  PyArrayObject *capi_ev_tmp = NULL;
  int capi_ev_intent = 0;
  PyObject *ev_capi = Py_None;
  double *occ = NULL;
  npy_intp occ_Dims[1] = {-1};
  const int occ_Rank = 1;
  PyArrayObject *capi_occ_tmp = NULL;
  int capi_occ_intent = 0;
  PyObject *occ_capi = Py_None;
  int *is = NULL;
  npy_intp is_Dims[1] = {-1};
  const int is_Rank = 1;
  PyArrayObject *capi_is_tmp = NULL;
  int capi_is_intent = 0;
  PyObject *is_capi = Py_None;
  double *ek = NULL;
  npy_intp ek_Dims[1] = {-1};
  const int ek_Rank = 1;
  PyArrayObject *capi_ek_tmp = NULL;
  int capi_ek_intent = 0;
  PyObject *ek_capi = Py_None;
  double ratio = 0;
  PyObject *ratio_capi = Py_None;
  double *orb = NULL;
  npy_intp orb_Dims[2] = {-1, -1};
  const int orb_Rank = 2;
  PyArrayObject *capi_orb_tmp = NULL;
  int capi_orb_intent = 0;
  PyObject *orb_capi = Py_None;
  double *rpower = NULL;
  npy_intp rpower_Dims[2] = {-1, -1};
  const int rpower_Rank = 2;
  PyArrayObject *capi_rpower_tmp = NULL;
  int capi_rpower_intent = 0;
  PyObject *rpower_capi = Py_None;
  double xnum = 0;
  PyObject *xnum_capi = Py_None;
  double etot2 = 0;
  PyObject *etot2_capi = Py_None;
  int iuflag = 0;
  PyObject *iuflag_capi = Py_None;
  static char *capi_kwlist[] = {"etot","nst","rel","alfa","eerror","nfc","nr","r","dr","r2","dl","phe","njrc","vi","zorig","xntot","nel","no","nl","nm","xnj","ev","occ","is","ek","ratio","orb","rpower","xnum","etot2","iuflag",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO:libphsh.atsolve",\
    capi_kwlist,&etot_capi,&nst_capi,&rel_capi,&alfa_capi,&eerror_capi,&nfc_capi,&nr_capi,&r_capi,&dr_capi,&r2_capi,&dl_capi,&phe_capi,&njrc_capi,&vi_capi,&zorig_capi,&xntot_capi,&nel_capi,&no_capi,&nl_capi,&nm_capi,&xnj_capi,&ev_capi,&occ_capi,&is_capi,&ek_capi,&ratio_capi,&orb_capi,&rpower_capi,&xnum_capi,&etot2_capi,&iuflag_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable alfa */
    f2py_success = double_from_pyobj(&alfa,alfa_capi,"libphsh.atsolve() 4th argument (alfa) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ek */
  ek_Dims[0]=33;
  capi_ek_intent |= F2PY_INTENT_IN;
  capi_ek_tmp = array_from_pyobj(NPY_DOUBLE,ek_Dims,ek_Rank,capi_ek_intent,ek_capi);
  if (capi_ek_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 25th argument `ek' of libphsh.atsolve to C/Fortran array" );
  } else {
    ek = (double *)(capi_ek_tmp->data);

  /* Processing variable vi */
  vi_Dims[0]=4000,vi_Dims[1]=7;
  capi_vi_intent |= F2PY_INTENT_IN;
  capi_vi_tmp = array_from_pyobj(NPY_DOUBLE,vi_Dims,vi_Rank,capi_vi_intent,vi_capi);
  if (capi_vi_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 14th argument `vi' of libphsh.atsolve to C/Fortran array" );
  } else {
    vi = (double *)(capi_vi_tmp->data);

  /* Processing variable is */
  is_Dims[0]=33;
  capi_is_intent |= F2PY_INTENT_IN;
  capi_is_tmp = array_from_pyobj(NPY_INT,is_Dims,is_Rank,capi_is_intent,is_capi);
  if (capi_is_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 24th argument `is' of libphsh.atsolve to C/Fortran array" );
  } else {
    is = (int *)(capi_is_tmp->data);

  /* Processing variable occ */
  occ_Dims[0]=33;
  capi_occ_intent |= F2PY_INTENT_IN;
  capi_occ_tmp = array_from_pyobj(NPY_DOUBLE,occ_Dims,occ_Rank,capi_occ_intent,occ_capi);
  if (capi_occ_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 23rd argument `occ' of libphsh.atsolve to C/Fortran array" );
  } else {
    occ = (double *)(capi_occ_tmp->data);

  /* Processing variable ev */
  ev_Dims[0]=33;
  capi_ev_intent |= F2PY_INTENT_IN;
  capi_ev_tmp = array_from_pyobj(NPY_DOUBLE,ev_Dims,ev_Rank,capi_ev_intent,ev_capi);
  if (capi_ev_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 22nd argument `ev' of libphsh.atsolve to C/Fortran array" );
  } else {
    ev = (double *)(capi_ev_tmp->data);

  /* Processing variable xnum */
    f2py_success = double_from_pyobj(&xnum,xnum_capi,"libphsh.atsolve() 29th argument (xnum) can't be converted to double");
  if (f2py_success) {
  /* Processing variable etot2 */
    f2py_success = double_from_pyobj(&etot2,etot2_capi,"libphsh.atsolve() 30th argument (etot2) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nel */
    f2py_success = int_from_pyobj(&nel,nel_capi,"libphsh.atsolve() 17th argument (nel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nl */
  nl_Dims[0]=33;
  capi_nl_intent |= F2PY_INTENT_IN;
  capi_nl_tmp = array_from_pyobj(NPY_INT,nl_Dims,nl_Rank,capi_nl_intent,nl_capi);
  if (capi_nl_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 19th argument `nl' of libphsh.atsolve to C/Fortran array" );
  } else {
    nl = (int *)(capi_nl_tmp->data);

  /* Processing variable nm */
  nm_Dims[0]=33;
  capi_nm_intent |= F2PY_INTENT_IN;
  capi_nm_tmp = array_from_pyobj(NPY_INT,nm_Dims,nm_Rank,capi_nm_intent,nm_capi);
  if (capi_nm_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 20th argument `nm' of libphsh.atsolve to C/Fortran array" );
  } else {
    nm = (int *)(capi_nm_tmp->data);

  /* Processing variable xntot */
    f2py_success = double_from_pyobj(&xntot,xntot_capi,"libphsh.atsolve() 16th argument (xntot) can't be converted to double");
  if (f2py_success) {
  /* Processing variable no */
  no_Dims[0]=33;
  capi_no_intent |= F2PY_INTENT_IN;
  capi_no_tmp = array_from_pyobj(NPY_INT,no_Dims,no_Rank,capi_no_intent,no_capi);
  if (capi_no_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 18th argument `no' of libphsh.atsolve to C/Fortran array" );
  } else {
    no = (int *)(capi_no_tmp->data);

  /* Processing variable nst */
    f2py_success = int_from_pyobj(&nst,nst_capi,"libphsh.atsolve() 2nd argument (nst) can't be converted to int");
  if (f2py_success) {
  /* Processing variable rel */
    f2py_success = double_from_pyobj(&rel,rel_capi,"libphsh.atsolve() 3rd argument (rel) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.atsolve() 7th argument (nr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable etot */
    f2py_success = double_from_pyobj(&etot,etot_capi,"libphsh.atsolve() 1st argument (etot) can't be converted to double");
  if (f2py_success) {
  /* Processing variable dl */
    f2py_success = double_from_pyobj(&dl,dl_capi,"libphsh.atsolve() 11st argument (dl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable iuflag */
    f2py_success = int_from_pyobj(&iuflag,iuflag_capi,"libphsh.atsolve() 31st argument (iuflag) can't be converted to int");
  if (f2py_success) {
  /* Processing variable zorig */
    f2py_success = double_from_pyobj(&zorig,zorig_capi,"libphsh.atsolve() 15th argument (zorig) can't be converted to double");
  if (f2py_success) {
  /* Processing variable phe */
  phe_Dims[0]=4000,phe_Dims[1]=33;
  capi_phe_intent |= F2PY_INTENT_IN;
  capi_phe_tmp = array_from_pyobj(NPY_DOUBLE,phe_Dims,phe_Rank,capi_phe_intent,phe_capi);
  if (capi_phe_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 12nd argument `phe' of libphsh.atsolve to C/Fortran array" );
  } else {
    phe = (double *)(capi_phe_tmp->data);

  /* Processing variable njrc */
  njrc_Dims[0]=4;
  capi_njrc_intent |= F2PY_INTENT_IN;
  capi_njrc_tmp = array_from_pyobj(NPY_INT,njrc_Dims,njrc_Rank,capi_njrc_intent,njrc_capi);
  if (capi_njrc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 13rd argument `njrc' of libphsh.atsolve to C/Fortran array" );
  } else {
    njrc = (int *)(capi_njrc_tmp->data);

  /* Processing variable eerror */
    f2py_success = double_from_pyobj(&eerror,eerror_capi,"libphsh.atsolve() 5th argument (eerror) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ratio */
    f2py_success = double_from_pyobj(&ratio,ratio_capi,"libphsh.atsolve() 26th argument (ratio) can't be converted to double");
  if (f2py_success) {
  /* Processing variable orb */
  orb_Dims[0]=4000,orb_Dims[1]=33;
  capi_orb_intent |= F2PY_INTENT_IN;
  capi_orb_tmp = array_from_pyobj(NPY_DOUBLE,orb_Dims,orb_Rank,capi_orb_intent,orb_capi);
  if (capi_orb_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 27th argument `orb' of libphsh.atsolve to C/Fortran array" );
  } else {
    orb = (double *)(capi_orb_tmp->data);

  /* Processing variable xnj */
  xnj_Dims[0]=33;
  capi_xnj_intent |= F2PY_INTENT_IN;
  capi_xnj_tmp = array_from_pyobj(NPY_DOUBLE,xnj_Dims,xnj_Rank,capi_xnj_intent,xnj_capi);
  if (capi_xnj_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 21st argument `xnj' of libphsh.atsolve to C/Fortran array" );
  } else {
    xnj = (double *)(capi_xnj_tmp->data);

  /* Processing variable nfc */
    f2py_success = int_from_pyobj(&nfc,nfc_capi,"libphsh.atsolve() 6th argument (nfc) can't be converted to int");
  if (f2py_success) {
  /* Processing variable r2 */
  r2_Dims[0]=4000;
  capi_r2_intent |= F2PY_INTENT_IN;
  capi_r2_tmp = array_from_pyobj(NPY_DOUBLE,r2_Dims,r2_Rank,capi_r2_intent,r2_capi);
  if (capi_r2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 10th argument `r2' of libphsh.atsolve to C/Fortran array" );
  } else {
    r2 = (double *)(capi_r2_tmp->data);

  /* Processing variable dr */
  dr_Dims[0]=4000;
  capi_dr_intent |= F2PY_INTENT_IN;
  capi_dr_tmp = array_from_pyobj(NPY_DOUBLE,dr_Dims,dr_Rank,capi_dr_intent,dr_capi);
  if (capi_dr_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 9th argument `dr' of libphsh.atsolve to C/Fortran array" );
  } else {
    dr = (double *)(capi_dr_tmp->data);

  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 8th argument `r' of libphsh.atsolve to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

  /* Processing variable rpower */
  rpower_Dims[0]=4000,rpower_Dims[1]=16;
  capi_rpower_intent |= F2PY_INTENT_IN;
  capi_rpower_tmp = array_from_pyobj(NPY_DOUBLE,rpower_Dims,rpower_Rank,capi_rpower_intent,rpower_capi);
  if (capi_rpower_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 28th argument `rpower' of libphsh.atsolve to C/Fortran array" );
  } else {
    rpower = (double *)(capi_rpower_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&etot,&nst,&rel,&alfa,&eerror,&nfc,&nr,r,dr,r2,&dl,phe,njrc,vi,&zorig,&xntot,&nel,no,nl,nm,xnj,ev,occ,is,ek,&ratio,orb,rpower,&xnum,&etot2,&iuflag);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_rpower_tmp!=rpower_capi) {
    Py_XDECREF(capi_rpower_tmp); }
  }  /*if (capi_rpower_tmp == NULL) ... else of rpower*/
  /* End of cleaning variable rpower */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  if((PyObject *)capi_dr_tmp!=dr_capi) {
    Py_XDECREF(capi_dr_tmp); }
  }  /*if (capi_dr_tmp == NULL) ... else of dr*/
  /* End of cleaning variable dr */
  if((PyObject *)capi_r2_tmp!=r2_capi) {
    Py_XDECREF(capi_r2_tmp); }
  }  /*if (capi_r2_tmp == NULL) ... else of r2*/
  /* End of cleaning variable r2 */
  } /*if (f2py_success) of nfc*/
  /* End of cleaning variable nfc */
  if((PyObject *)capi_xnj_tmp!=xnj_capi) {
    Py_XDECREF(capi_xnj_tmp); }
  }  /*if (capi_xnj_tmp == NULL) ... else of xnj*/
  /* End of cleaning variable xnj */
  if((PyObject *)capi_orb_tmp!=orb_capi) {
    Py_XDECREF(capi_orb_tmp); }
  }  /*if (capi_orb_tmp == NULL) ... else of orb*/
  /* End of cleaning variable orb */
  } /*if (f2py_success) of ratio*/
  /* End of cleaning variable ratio */
  } /*if (f2py_success) of eerror*/
  /* End of cleaning variable eerror */
  if((PyObject *)capi_njrc_tmp!=njrc_capi) {
    Py_XDECREF(capi_njrc_tmp); }
  }  /*if (capi_njrc_tmp == NULL) ... else of njrc*/
  /* End of cleaning variable njrc */
  if((PyObject *)capi_phe_tmp!=phe_capi) {
    Py_XDECREF(capi_phe_tmp); }
  }  /*if (capi_phe_tmp == NULL) ... else of phe*/
  /* End of cleaning variable phe */
  } /*if (f2py_success) of zorig*/
  /* End of cleaning variable zorig */
  } /*if (f2py_success) of iuflag*/
  /* End of cleaning variable iuflag */
  } /*if (f2py_success) of dl*/
  /* End of cleaning variable dl */
  } /*if (f2py_success) of etot*/
  /* End of cleaning variable etot */
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of rel*/
  /* End of cleaning variable rel */
  } /*if (f2py_success) of nst*/
  /* End of cleaning variable nst */
  if((PyObject *)capi_no_tmp!=no_capi) {
    Py_XDECREF(capi_no_tmp); }
  }  /*if (capi_no_tmp == NULL) ... else of no*/
  /* End of cleaning variable no */
  } /*if (f2py_success) of xntot*/
  /* End of cleaning variable xntot */
  if((PyObject *)capi_nm_tmp!=nm_capi) {
    Py_XDECREF(capi_nm_tmp); }
  }  /*if (capi_nm_tmp == NULL) ... else of nm*/
  /* End of cleaning variable nm */
  if((PyObject *)capi_nl_tmp!=nl_capi) {
    Py_XDECREF(capi_nl_tmp); }
  }  /*if (capi_nl_tmp == NULL) ... else of nl*/
  /* End of cleaning variable nl */
  } /*if (f2py_success) of nel*/
  /* End of cleaning variable nel */
  } /*if (f2py_success) of etot2*/
  /* End of cleaning variable etot2 */
  } /*if (f2py_success) of xnum*/
  /* End of cleaning variable xnum */
  if((PyObject *)capi_ev_tmp!=ev_capi) {
    Py_XDECREF(capi_ev_tmp); }
  }  /*if (capi_ev_tmp == NULL) ... else of ev*/
  /* End of cleaning variable ev */
  if((PyObject *)capi_occ_tmp!=occ_capi) {
    Py_XDECREF(capi_occ_tmp); }
  }  /*if (capi_occ_tmp == NULL) ... else of occ*/
  /* End of cleaning variable occ */
  if((PyObject *)capi_is_tmp!=is_capi) {
    Py_XDECREF(capi_is_tmp); }
  }  /*if (capi_is_tmp == NULL) ... else of is*/
  /* End of cleaning variable is */
  if((PyObject *)capi_vi_tmp!=vi_capi) {
    Py_XDECREF(capi_vi_tmp); }
  }  /*if (capi_vi_tmp == NULL) ... else of vi*/
  /* End of cleaning variable vi */
  if((PyObject *)capi_ek_tmp!=ek_capi) {
    Py_XDECREF(capi_ek_tmp); }
  }  /*if (capi_ek_tmp == NULL) ... else of ek*/
  /* End of cleaning variable ek */
  } /*if (f2py_success) of alfa*/
  /* End of cleaning variable alfa */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of atsolve *******************************/

/*********************************** getpot ***********************************/
static char doc_f2py_rout_libphsh_getpot[] = "\
getpot(etot,nst,rel,alfa,dl,nr,dr,r,r2,xntot,phe,ratio,orb,occ,is,nel,nl,nm,no,xnj,rpower,xnum,etot2,iuflag)\n\nWrapper for ``getpot``.\
\n\nParameters\n----------\n"
"etot : input float\n"
"nst : input int\n"
"rel : input float\n"
"alfa : input float\n"
"dl : input float\n"
"nr : input int\n"
"dr : input rank-1 array('d') with bounds (4000)\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"r2 : input rank-1 array('d') with bounds (4000)\n"
"xntot : input float\n"
"phe : input rank-2 array('d') with bounds (4000,33)\n"
"ratio : input float\n"
"orb : input rank-2 array('d') with bounds (4000,33)\n"
"occ : input rank-1 array('d') with bounds (33)\n"
"is : input rank-1 array('i') with bounds (33)\n"
"nel : input int\n"
"nl : input rank-1 array('i') with bounds (33)\n"
"nm : input rank-1 array('i') with bounds (33)\n"
"no : input rank-1 array('i') with bounds (33)\n"
"xnj : input rank-1 array('d') with bounds (33)\n"
"rpower : input rank-2 array('d') with bounds (4000,16)\n"
"xnum : input float\n"
"etot2 : input float\n"
"iuflag : input int";
/* extern void F_FUNC(getpot,GETPOT)(double*,int*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*,double*,double*,int*,int*,int*,int*,int*,double*,double*,double*,double*,int*); */
static PyObject *f2py_rout_libphsh_getpot(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*,double*,double*,int*,int*,int*,int*,int*,double*,double*,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double etot = 0;
  PyObject *etot_capi = Py_None;
  int nst = 0;
  PyObject *nst_capi = Py_None;
  double rel = 0;
  PyObject *rel_capi = Py_None;
  double alfa = 0;
  PyObject *alfa_capi = Py_None;
  double dl = 0;
  PyObject *dl_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  double *dr = NULL;
  npy_intp dr_Dims[1] = {-1};
  const int dr_Rank = 1;
  PyArrayObject *capi_dr_tmp = NULL;
  int capi_dr_intent = 0;
  PyObject *dr_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *r2 = NULL;
  npy_intp r2_Dims[1] = {-1};
  const int r2_Rank = 1;
  PyArrayObject *capi_r2_tmp = NULL;
  int capi_r2_intent = 0;
  PyObject *r2_capi = Py_None;
  double xntot = 0;
  PyObject *xntot_capi = Py_None;
  double *phe = NULL;
  npy_intp phe_Dims[2] = {-1, -1};
  const int phe_Rank = 2;
  PyArrayObject *capi_phe_tmp = NULL;
  int capi_phe_intent = 0;
  PyObject *phe_capi = Py_None;
  double ratio = 0;
  PyObject *ratio_capi = Py_None;
  double *orb = NULL;
  npy_intp orb_Dims[2] = {-1, -1};
  const int orb_Rank = 2;
  PyArrayObject *capi_orb_tmp = NULL;
  int capi_orb_intent = 0;
  PyObject *orb_capi = Py_None;
  double *occ = NULL;
  npy_intp occ_Dims[1] = {-1};
  const int occ_Rank = 1;
  PyArrayObject *capi_occ_tmp = NULL;
  int capi_occ_intent = 0;
  PyObject *occ_capi = Py_None;
  int *is = NULL;
  npy_intp is_Dims[1] = {-1};
  const int is_Rank = 1;
  PyArrayObject *capi_is_tmp = NULL;
  int capi_is_intent = 0;
  PyObject *is_capi = Py_None;
  int nel = 0;
  PyObject *nel_capi = Py_None;
  int *nl = NULL;
  npy_intp nl_Dims[1] = {-1};
  const int nl_Rank = 1;
  PyArrayObject *capi_nl_tmp = NULL;
  int capi_nl_intent = 0;
  PyObject *nl_capi = Py_None;
  int *nm = NULL;
  npy_intp nm_Dims[1] = {-1};
  const int nm_Rank = 1;
  PyArrayObject *capi_nm_tmp = NULL;
  int capi_nm_intent = 0;
  PyObject *nm_capi = Py_None;
  int *no = NULL;
  npy_intp no_Dims[1] = {-1};
  const int no_Rank = 1;
  PyArrayObject *capi_no_tmp = NULL;
  int capi_no_intent = 0;
  PyObject *no_capi = Py_None;
  double *xnj = NULL;
  npy_intp xnj_Dims[1] = {-1};
  const int xnj_Rank = 1;
  PyArrayObject *capi_xnj_tmp = NULL;
  int capi_xnj_intent = 0;
  PyObject *xnj_capi = Py_None;
  double *rpower = NULL;
  npy_intp rpower_Dims[2] = {-1, -1};
  const int rpower_Rank = 2;
  PyArrayObject *capi_rpower_tmp = NULL;
  int capi_rpower_intent = 0;
  PyObject *rpower_capi = Py_None;
  double xnum = 0;
  PyObject *xnum_capi = Py_None;
  double etot2 = 0;
  PyObject *etot2_capi = Py_None;
  int iuflag = 0;
  PyObject *iuflag_capi = Py_None;
  static char *capi_kwlist[] = {"etot","nst","rel","alfa","dl","nr","dr","r","r2","xntot","phe","ratio","orb","occ","is","nel","nl","nm","no","xnj","rpower","xnum","etot2","iuflag",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOOOOOOOOOOOOOO:libphsh.getpot",\
    capi_kwlist,&etot_capi,&nst_capi,&rel_capi,&alfa_capi,&dl_capi,&nr_capi,&dr_capi,&r_capi,&r2_capi,&xntot_capi,&phe_capi,&ratio_capi,&orb_capi,&occ_capi,&is_capi,&nel_capi,&nl_capi,&nm_capi,&no_capi,&xnj_capi,&rpower_capi,&xnum_capi,&etot2_capi,&iuflag_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable alfa */
    f2py_success = double_from_pyobj(&alfa,alfa_capi,"libphsh.getpot() 4th argument (alfa) can't be converted to double");
  if (f2py_success) {
  /* Processing variable orb */
  orb_Dims[0]=4000,orb_Dims[1]=33;
  capi_orb_intent |= F2PY_INTENT_IN;
  capi_orb_tmp = array_from_pyobj(NPY_DOUBLE,orb_Dims,orb_Rank,capi_orb_intent,orb_capi);
  if (capi_orb_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 13rd argument `orb' of libphsh.getpot to C/Fortran array" );
  } else {
    orb = (double *)(capi_orb_tmp->data);

  /* Processing variable is */
  is_Dims[0]=33;
  capi_is_intent |= F2PY_INTENT_IN;
  capi_is_tmp = array_from_pyobj(NPY_INT,is_Dims,is_Rank,capi_is_intent,is_capi);
  if (capi_is_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 15th argument `is' of libphsh.getpot to C/Fortran array" );
  } else {
    is = (int *)(capi_is_tmp->data);

  /* Processing variable xnum */
    f2py_success = double_from_pyobj(&xnum,xnum_capi,"libphsh.getpot() 22nd argument (xnum) can't be converted to double");
  if (f2py_success) {
  /* Processing variable etot2 */
    f2py_success = double_from_pyobj(&etot2,etot2_capi,"libphsh.getpot() 23rd argument (etot2) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nel */
    f2py_success = int_from_pyobj(&nel,nel_capi,"libphsh.getpot() 16th argument (nel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nl */
  nl_Dims[0]=33;
  capi_nl_intent |= F2PY_INTENT_IN;
  capi_nl_tmp = array_from_pyobj(NPY_INT,nl_Dims,nl_Rank,capi_nl_intent,nl_capi);
  if (capi_nl_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 17th argument `nl' of libphsh.getpot to C/Fortran array" );
  } else {
    nl = (int *)(capi_nl_tmp->data);

  /* Processing variable nm */
  nm_Dims[0]=33;
  capi_nm_intent |= F2PY_INTENT_IN;
  capi_nm_tmp = array_from_pyobj(NPY_INT,nm_Dims,nm_Rank,capi_nm_intent,nm_capi);
  if (capi_nm_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 18th argument `nm' of libphsh.getpot to C/Fortran array" );
  } else {
    nm = (int *)(capi_nm_tmp->data);

  /* Processing variable xntot */
    f2py_success = double_from_pyobj(&xntot,xntot_capi,"libphsh.getpot() 10th argument (xntot) can't be converted to double");
  if (f2py_success) {
  /* Processing variable no */
  no_Dims[0]=33;
  capi_no_intent |= F2PY_INTENT_IN;
  capi_no_tmp = array_from_pyobj(NPY_INT,no_Dims,no_Rank,capi_no_intent,no_capi);
  if (capi_no_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 19th argument `no' of libphsh.getpot to C/Fortran array" );
  } else {
    no = (int *)(capi_no_tmp->data);

  /* Processing variable nst */
    f2py_success = int_from_pyobj(&nst,nst_capi,"libphsh.getpot() 2nd argument (nst) can't be converted to int");
  if (f2py_success) {
  /* Processing variable rel */
    f2py_success = double_from_pyobj(&rel,rel_capi,"libphsh.getpot() 3rd argument (rel) can't be converted to double");
  if (f2py_success) {
  /* Processing variable etot */
    f2py_success = double_from_pyobj(&etot,etot_capi,"libphsh.getpot() 1st argument (etot) can't be converted to double");
  if (f2py_success) {
  /* Processing variable dl */
    f2py_success = double_from_pyobj(&dl,dl_capi,"libphsh.getpot() 5th argument (dl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable iuflag */
    f2py_success = int_from_pyobj(&iuflag,iuflag_capi,"libphsh.getpot() 24th argument (iuflag) can't be converted to int");
  if (f2py_success) {
  /* Processing variable phe */
  phe_Dims[0]=4000,phe_Dims[1]=33;
  capi_phe_intent |= F2PY_INTENT_IN;
  capi_phe_tmp = array_from_pyobj(NPY_DOUBLE,phe_Dims,phe_Rank,capi_phe_intent,phe_capi);
  if (capi_phe_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 11st argument `phe' of libphsh.getpot to C/Fortran array" );
  } else {
    phe = (double *)(capi_phe_tmp->data);

  /* Processing variable ratio */
    f2py_success = double_from_pyobj(&ratio,ratio_capi,"libphsh.getpot() 12nd argument (ratio) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.getpot() 6th argument (nr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable rpower */
  rpower_Dims[0]=4000,rpower_Dims[1]=16;
  capi_rpower_intent |= F2PY_INTENT_IN;
  capi_rpower_tmp = array_from_pyobj(NPY_DOUBLE,rpower_Dims,rpower_Rank,capi_rpower_intent,rpower_capi);
  if (capi_rpower_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 21st argument `rpower' of libphsh.getpot to C/Fortran array" );
  } else {
    rpower = (double *)(capi_rpower_tmp->data);

  /* Processing variable r2 */
  r2_Dims[0]=4000;
  capi_r2_intent |= F2PY_INTENT_IN;
  capi_r2_tmp = array_from_pyobj(NPY_DOUBLE,r2_Dims,r2_Rank,capi_r2_intent,r2_capi);
  if (capi_r2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 9th argument `r2' of libphsh.getpot to C/Fortran array" );
  } else {
    r2 = (double *)(capi_r2_tmp->data);

  /* Processing variable dr */
  dr_Dims[0]=4000;
  capi_dr_intent |= F2PY_INTENT_IN;
  capi_dr_tmp = array_from_pyobj(NPY_DOUBLE,dr_Dims,dr_Rank,capi_dr_intent,dr_capi);
  if (capi_dr_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 7th argument `dr' of libphsh.getpot to C/Fortran array" );
  } else {
    dr = (double *)(capi_dr_tmp->data);

  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 8th argument `r' of libphsh.getpot to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

  /* Processing variable xnj */
  xnj_Dims[0]=33;
  capi_xnj_intent |= F2PY_INTENT_IN;
  capi_xnj_tmp = array_from_pyobj(NPY_DOUBLE,xnj_Dims,xnj_Rank,capi_xnj_intent,xnj_capi);
  if (capi_xnj_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 20th argument `xnj' of libphsh.getpot to C/Fortran array" );
  } else {
    xnj = (double *)(capi_xnj_tmp->data);

  /* Processing variable occ */
  occ_Dims[0]=33;
  capi_occ_intent |= F2PY_INTENT_IN;
  capi_occ_tmp = array_from_pyobj(NPY_DOUBLE,occ_Dims,occ_Rank,capi_occ_intent,occ_capi);
  if (capi_occ_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 14th argument `occ' of libphsh.getpot to C/Fortran array" );
  } else {
    occ = (double *)(capi_occ_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&etot,&nst,&rel,&alfa,&dl,&nr,dr,r,r2,&xntot,phe,&ratio,orb,occ,is,&nel,nl,nm,no,xnj,rpower,&xnum,&etot2,&iuflag);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_occ_tmp!=occ_capi) {
    Py_XDECREF(capi_occ_tmp); }
  }  /*if (capi_occ_tmp == NULL) ... else of occ*/
  /* End of cleaning variable occ */
  if((PyObject *)capi_xnj_tmp!=xnj_capi) {
    Py_XDECREF(capi_xnj_tmp); }
  }  /*if (capi_xnj_tmp == NULL) ... else of xnj*/
  /* End of cleaning variable xnj */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  if((PyObject *)capi_dr_tmp!=dr_capi) {
    Py_XDECREF(capi_dr_tmp); }
  }  /*if (capi_dr_tmp == NULL) ... else of dr*/
  /* End of cleaning variable dr */
  if((PyObject *)capi_r2_tmp!=r2_capi) {
    Py_XDECREF(capi_r2_tmp); }
  }  /*if (capi_r2_tmp == NULL) ... else of r2*/
  /* End of cleaning variable r2 */
  if((PyObject *)capi_rpower_tmp!=rpower_capi) {
    Py_XDECREF(capi_rpower_tmp); }
  }  /*if (capi_rpower_tmp == NULL) ... else of rpower*/
  /* End of cleaning variable rpower */
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of ratio*/
  /* End of cleaning variable ratio */
  if((PyObject *)capi_phe_tmp!=phe_capi) {
    Py_XDECREF(capi_phe_tmp); }
  }  /*if (capi_phe_tmp == NULL) ... else of phe*/
  /* End of cleaning variable phe */
  } /*if (f2py_success) of iuflag*/
  /* End of cleaning variable iuflag */
  } /*if (f2py_success) of dl*/
  /* End of cleaning variable dl */
  } /*if (f2py_success) of etot*/
  /* End of cleaning variable etot */
  } /*if (f2py_success) of rel*/
  /* End of cleaning variable rel */
  } /*if (f2py_success) of nst*/
  /* End of cleaning variable nst */
  if((PyObject *)capi_no_tmp!=no_capi) {
    Py_XDECREF(capi_no_tmp); }
  }  /*if (capi_no_tmp == NULL) ... else of no*/
  /* End of cleaning variable no */
  } /*if (f2py_success) of xntot*/
  /* End of cleaning variable xntot */
  if((PyObject *)capi_nm_tmp!=nm_capi) {
    Py_XDECREF(capi_nm_tmp); }
  }  /*if (capi_nm_tmp == NULL) ... else of nm*/
  /* End of cleaning variable nm */
  if((PyObject *)capi_nl_tmp!=nl_capi) {
    Py_XDECREF(capi_nl_tmp); }
  }  /*if (capi_nl_tmp == NULL) ... else of nl*/
  /* End of cleaning variable nl */
  } /*if (f2py_success) of nel*/
  /* End of cleaning variable nel */
  } /*if (f2py_success) of etot2*/
  /* End of cleaning variable etot2 */
  } /*if (f2py_success) of xnum*/
  /* End of cleaning variable xnum */
  if((PyObject *)capi_is_tmp!=is_capi) {
    Py_XDECREF(capi_is_tmp); }
  }  /*if (capi_is_tmp == NULL) ... else of is*/
  /* End of cleaning variable is */
  if((PyObject *)capi_orb_tmp!=orb_capi) {
    Py_XDECREF(capi_orb_tmp); }
  }  /*if (capi_orb_tmp == NULL) ... else of orb*/
  /* End of cleaning variable orb */
  } /*if (f2py_success) of alfa*/
  /* End of cleaning variable alfa */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of getpot *******************************/

/********************************** elsolve **********************************/
static char doc_f2py_rout_libphsh_elsolve[] = "\
elsolve(i,occ,n,l,xkappa,xj,zorig,zeff,e,phi,v,q0,xm1,xm2,nr,r,dr,r2,dl,rel)\n\nWrapper for ``elsolve``.\
\n\nParameters\n----------\n"
"i : input int\n"
"occ : input float\n"
"n : input int\n"
"l : input int\n"
"xkappa : input float\n"
"xj : input float\n"
"zorig : input float\n"
"zeff : input float\n"
"e : input float\n"
"phi : input rank-1 array('d') with bounds (4000)\n"
"v : input rank-1 array('d') with bounds (4000)\n"
"q0 : input rank-1 array('d') with bounds (4000)\n"
"xm1 : input rank-1 array('d') with bounds (4000)\n"
"xm2 : input rank-1 array('d') with bounds (4000)\n"
"nr : input int\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"dr : input rank-1 array('d') with bounds (4000)\n"
"r2 : input rank-1 array('d') with bounds (4000)\n"
"dl : input float\n"
"rel : input float";
/* extern void F_FUNC(elsolve,ELSOLVE)(int*,double*,int*,int*,double*,double*,double*,double*,double*,double*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_libphsh_elsolve(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,int*,int*,double*,double*,double*,double*,double*,double*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  double occ = 0;
  PyObject *occ_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  double xkappa = 0;
  PyObject *xkappa_capi = Py_None;
  double xj = 0;
  PyObject *xj_capi = Py_None;
  double zorig = 0;
  PyObject *zorig_capi = Py_None;
  double zeff = 0;
  PyObject *zeff_capi = Py_None;
  double e = 0;
  PyObject *e_capi = Py_None;
  double *phi = NULL;
  npy_intp phi_Dims[1] = {-1};
  const int phi_Rank = 1;
  PyArrayObject *capi_phi_tmp = NULL;
  int capi_phi_intent = 0;
  PyObject *phi_capi = Py_None;
  double *v = NULL;
  npy_intp v_Dims[1] = {-1};
  const int v_Rank = 1;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
  PyObject *v_capi = Py_None;
  double *q0 = NULL;
  npy_intp q0_Dims[1] = {-1};
  const int q0_Rank = 1;
  PyArrayObject *capi_q0_tmp = NULL;
  int capi_q0_intent = 0;
  PyObject *q0_capi = Py_None;
  double *xm1 = NULL;
  npy_intp xm1_Dims[1] = {-1};
  const int xm1_Rank = 1;
  PyArrayObject *capi_xm1_tmp = NULL;
  int capi_xm1_intent = 0;
  PyObject *xm1_capi = Py_None;
  double *xm2 = NULL;
  npy_intp xm2_Dims[1] = {-1};
  const int xm2_Rank = 1;
  PyArrayObject *capi_xm2_tmp = NULL;
  int capi_xm2_intent = 0;
  PyObject *xm2_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *dr = NULL;
  npy_intp dr_Dims[1] = {-1};
  const int dr_Rank = 1;
  PyArrayObject *capi_dr_tmp = NULL;
  int capi_dr_intent = 0;
  PyObject *dr_capi = Py_None;
  double *r2 = NULL;
  npy_intp r2_Dims[1] = {-1};
  const int r2_Rank = 1;
  PyArrayObject *capi_r2_tmp = NULL;
  int capi_r2_intent = 0;
  PyObject *r2_capi = Py_None;
  double dl = 0;
  PyObject *dl_capi = Py_None;
  double rel = 0;
  PyObject *rel_capi = Py_None;
  static char *capi_kwlist[] = {"i","occ","n","l","xkappa","xj","zorig","zeff","e","phi","v","q0","xm1","xm2","nr","r","dr","r2","dl","rel",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOOOOOOOOOO:libphsh.elsolve",\
    capi_kwlist,&i_capi,&occ_capi,&n_capi,&l_capi,&xkappa_capi,&xj_capi,&zorig_capi,&zeff_capi,&e_capi,&phi_capi,&v_capi,&q0_capi,&xm1_capi,&xm2_capi,&nr_capi,&r_capi,&dr_capi,&r2_capi,&dl_capi,&rel_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable xj */
    f2py_success = double_from_pyobj(&xj,xj_capi,"libphsh.elsolve() 6th argument (xj) can't be converted to double");
  if (f2py_success) {
  /* Processing variable dl */
    f2py_success = double_from_pyobj(&dl,dl_capi,"libphsh.elsolve() 19th argument (dl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable v */
  v_Dims[0]=4000;
  capi_v_intent |= F2PY_INTENT_IN;
  capi_v_tmp = array_from_pyobj(NPY_DOUBLE,v_Dims,v_Rank,capi_v_intent,v_capi);
  if (capi_v_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 11st argument `v' of libphsh.elsolve to C/Fortran array" );
  } else {
    v = (double *)(capi_v_tmp->data);

  /* Processing variable zeff */
    f2py_success = double_from_pyobj(&zeff,zeff_capi,"libphsh.elsolve() 8th argument (zeff) can't be converted to double");
  if (f2py_success) {
  /* Processing variable zorig */
    f2py_success = double_from_pyobj(&zorig,zorig_capi,"libphsh.elsolve() 7th argument (zorig) can't be converted to double");
  if (f2py_success) {
  /* Processing variable occ */
    f2py_success = double_from_pyobj(&occ,occ_capi,"libphsh.elsolve() 2nd argument (occ) can't be converted to double");
  if (f2py_success) {
  /* Processing variable dr */
  dr_Dims[0]=4000;
  capi_dr_intent |= F2PY_INTENT_IN;
  capi_dr_tmp = array_from_pyobj(NPY_DOUBLE,dr_Dims,dr_Rank,capi_dr_intent,dr_capi);
  if (capi_dr_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 17th argument `dr' of libphsh.elsolve to C/Fortran array" );
  } else {
    dr = (double *)(capi_dr_tmp->data);

  /* Processing variable q0 */
  q0_Dims[0]=4000;
  capi_q0_intent |= F2PY_INTENT_IN;
  capi_q0_tmp = array_from_pyobj(NPY_DOUBLE,q0_Dims,q0_Rank,capi_q0_intent,q0_capi);
  if (capi_q0_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 12nd argument `q0' of libphsh.elsolve to C/Fortran array" );
  } else {
    q0 = (double *)(capi_q0_tmp->data);

  /* Processing variable e */
    f2py_success = double_from_pyobj(&e,e_capi,"libphsh.elsolve() 9th argument (e) can't be converted to double");
  if (f2py_success) {
  /* Processing variable r2 */
  r2_Dims[0]=4000;
  capi_r2_intent |= F2PY_INTENT_IN;
  capi_r2_tmp = array_from_pyobj(NPY_DOUBLE,r2_Dims,r2_Rank,capi_r2_intent,r2_capi);
  if (capi_r2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 18th argument `r2' of libphsh.elsolve to C/Fortran array" );
  } else {
    r2 = (double *)(capi_r2_tmp->data);

  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"libphsh.elsolve() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable l */
    f2py_success = int_from_pyobj(&l,l_capi,"libphsh.elsolve() 4th argument (l) can't be converted to int");
  if (f2py_success) {
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"libphsh.elsolve() 3rd argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable phi */
  phi_Dims[0]=4000;
  capi_phi_intent |= F2PY_INTENT_IN;
  capi_phi_tmp = array_from_pyobj(NPY_DOUBLE,phi_Dims,phi_Rank,capi_phi_intent,phi_capi);
  if (capi_phi_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 10th argument `phi' of libphsh.elsolve to C/Fortran array" );
  } else {
    phi = (double *)(capi_phi_tmp->data);

  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 16th argument `r' of libphsh.elsolve to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

  /* Processing variable rel */
    f2py_success = double_from_pyobj(&rel,rel_capi,"libphsh.elsolve() 20th argument (rel) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.elsolve() 15th argument (nr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable xkappa */
    f2py_success = double_from_pyobj(&xkappa,xkappa_capi,"libphsh.elsolve() 5th argument (xkappa) can't be converted to double");
  if (f2py_success) {
  /* Processing variable xm1 */
  xm1_Dims[0]=4000;
  capi_xm1_intent |= F2PY_INTENT_IN;
  capi_xm1_tmp = array_from_pyobj(NPY_DOUBLE,xm1_Dims,xm1_Rank,capi_xm1_intent,xm1_capi);
  if (capi_xm1_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 13rd argument `xm1' of libphsh.elsolve to C/Fortran array" );
  } else {
    xm1 = (double *)(capi_xm1_tmp->data);

  /* Processing variable xm2 */
  xm2_Dims[0]=4000;
  capi_xm2_intent |= F2PY_INTENT_IN;
  capi_xm2_tmp = array_from_pyobj(NPY_DOUBLE,xm2_Dims,xm2_Rank,capi_xm2_intent,xm2_capi);
  if (capi_xm2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 14th argument `xm2' of libphsh.elsolve to C/Fortran array" );
  } else {
    xm2 = (double *)(capi_xm2_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,&occ,&n,&l,&xkappa,&xj,&zorig,&zeff,&e,phi,v,q0,xm1,xm2,&nr,r,dr,r2,&dl,&rel);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_xm2_tmp!=xm2_capi) {
    Py_XDECREF(capi_xm2_tmp); }
  }  /*if (capi_xm2_tmp == NULL) ... else of xm2*/
  /* End of cleaning variable xm2 */
  if((PyObject *)capi_xm1_tmp!=xm1_capi) {
    Py_XDECREF(capi_xm1_tmp); }
  }  /*if (capi_xm1_tmp == NULL) ... else of xm1*/
  /* End of cleaning variable xm1 */
  } /*if (f2py_success) of xkappa*/
  /* End of cleaning variable xkappa */
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of rel*/
  /* End of cleaning variable rel */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  if((PyObject *)capi_phi_tmp!=phi_capi) {
    Py_XDECREF(capi_phi_tmp); }
  }  /*if (capi_phi_tmp == NULL) ... else of phi*/
  /* End of cleaning variable phi */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
  if((PyObject *)capi_r2_tmp!=r2_capi) {
    Py_XDECREF(capi_r2_tmp); }
  }  /*if (capi_r2_tmp == NULL) ... else of r2*/
  /* End of cleaning variable r2 */
  } /*if (f2py_success) of e*/
  /* End of cleaning variable e */
  if((PyObject *)capi_q0_tmp!=q0_capi) {
    Py_XDECREF(capi_q0_tmp); }
  }  /*if (capi_q0_tmp == NULL) ... else of q0*/
  /* End of cleaning variable q0 */
  if((PyObject *)capi_dr_tmp!=dr_capi) {
    Py_XDECREF(capi_dr_tmp); }
  }  /*if (capi_dr_tmp == NULL) ... else of dr*/
  /* End of cleaning variable dr */
  } /*if (f2py_success) of occ*/
  /* End of cleaning variable occ */
  } /*if (f2py_success) of zorig*/
  /* End of cleaning variable zorig */
  } /*if (f2py_success) of zeff*/
  /* End of cleaning variable zeff */
  if((PyObject *)capi_v_tmp!=v_capi) {
    Py_XDECREF(capi_v_tmp); }
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  } /*if (f2py_success) of dl*/
  /* End of cleaning variable dl */
  } /*if (f2py_success) of xj*/
  /* End of cleaning variable xj */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of elsolve *******************************/

/********************************** augment **********************************/
static char doc_f2py_rout_libphsh_augment[] = "\
augment(e,l,xj,phi,v,nr,r,dl)\n\nWrapper for ``augment``.\
\n\nParameters\n----------\n"
"e : input float\n"
"l : input int\n"
"xj : input float\n"
"phi : input rank-1 array('d') with bounds (4000)\n"
"v : input rank-1 array('d') with bounds (4000)\n"
"nr : input int\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"dl : input float";
/* extern void F_FUNC(augment,AUGMENT)(double*,int*,double*,double*,double*,int*,double*,double*); */
static PyObject *f2py_rout_libphsh_augment(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,double*,double*,int*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double e = 0;
  PyObject *e_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  double xj = 0;
  PyObject *xj_capi = Py_None;
  double *phi = NULL;
  npy_intp phi_Dims[1] = {-1};
  const int phi_Rank = 1;
  PyArrayObject *capi_phi_tmp = NULL;
  int capi_phi_intent = 0;
  PyObject *phi_capi = Py_None;
  double *v = NULL;
  npy_intp v_Dims[1] = {-1};
  const int v_Rank = 1;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
  PyObject *v_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double dl = 0;
  PyObject *dl_capi = Py_None;
  static char *capi_kwlist[] = {"e","l","xj","phi","v","nr","r","dl",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOO:libphsh.augment",\
    capi_kwlist,&e_capi,&l_capi,&xj_capi,&phi_capi,&v_capi,&nr_capi,&r_capi,&dl_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable xj */
    f2py_success = double_from_pyobj(&xj,xj_capi,"libphsh.augment() 3rd argument (xj) can't be converted to double");
  if (f2py_success) {
  /* Processing variable phi */
  phi_Dims[0]=4000;
  capi_phi_intent |= F2PY_INTENT_IN;
  capi_phi_tmp = array_from_pyobj(NPY_DOUBLE,phi_Dims,phi_Rank,capi_phi_intent,phi_capi);
  if (capi_phi_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 4th argument `phi' of libphsh.augment to C/Fortran array" );
  } else {
    phi = (double *)(capi_phi_tmp->data);

  /* Processing variable dl */
    f2py_success = double_from_pyobj(&dl,dl_capi,"libphsh.augment() 8th argument (dl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable e */
    f2py_success = double_from_pyobj(&e,e_capi,"libphsh.augment() 1st argument (e) can't be converted to double");
  if (f2py_success) {
  /* Processing variable l */
    f2py_success = int_from_pyobj(&l,l_capi,"libphsh.augment() 2nd argument (l) can't be converted to int");
  if (f2py_success) {
  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 7th argument `r' of libphsh.augment to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

  /* Processing variable v */
  v_Dims[0]=4000;
  capi_v_intent |= F2PY_INTENT_IN;
  capi_v_tmp = array_from_pyobj(NPY_DOUBLE,v_Dims,v_Rank,capi_v_intent,v_capi);
  if (capi_v_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 5th argument `v' of libphsh.augment to C/Fortran array" );
  } else {
    v = (double *)(capi_v_tmp->data);

  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.augment() 6th argument (nr) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&e,&l,&xj,phi,v,&nr,r,&dl);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  if((PyObject *)capi_v_tmp!=v_capi) {
    Py_XDECREF(capi_v_tmp); }
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*if (f2py_success) of e*/
  /* End of cleaning variable e */
  } /*if (f2py_success) of dl*/
  /* End of cleaning variable dl */
  if((PyObject *)capi_phi_tmp!=phi_capi) {
    Py_XDECREF(capi_phi_tmp); }
  }  /*if (capi_phi_tmp == NULL) ... else of phi*/
  /* End of cleaning variable phi */
  } /*if (f2py_success) of xj*/
  /* End of cleaning variable xj */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of augment *******************************/

/*********************************** setqmm ***********************************/
static char doc_f2py_rout_libphsh_setqmm[] = "\
setqmm(i,orb,l,ns,idoflag,v,zeff,zorig,rel,nr,r,r2,dl,q0,xm1,xm2,njrc,vi)\n\nWrapper for ``setqmm``.\
\n\nParameters\n----------\n"
"i : input int\n"
"orb : input rank-2 array('d') with bounds (4000,33)\n"
"l : input int\n"
"ns : input int\n"
"idoflag : input int\n"
"v : input rank-1 array('d') with bounds (4000)\n"
"zeff : input float\n"
"zorig : input float\n"
"rel : input float\n"
"nr : input int\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"r2 : input rank-1 array('d') with bounds (4000)\n"
"dl : input float\n"
"q0 : input rank-1 array('d') with bounds (4000)\n"
"xm1 : input rank-1 array('d') with bounds (4000)\n"
"xm2 : input rank-1 array('d') with bounds (4000)\n"
"njrc : input rank-1 array('i') with bounds (4)\n"
"vi : input rank-2 array('d') with bounds (4000,7)";
/* extern void F_FUNC(setqmm,SETQMM)(int*,double*,int*,int*,int*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*,int*,double*); */
static PyObject *f2py_rout_libphsh_setqmm(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,int*,int*,int*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*,int*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  double *orb = NULL;
  npy_intp orb_Dims[2] = {-1, -1};
  const int orb_Rank = 2;
  PyArrayObject *capi_orb_tmp = NULL;
  int capi_orb_intent = 0;
  PyObject *orb_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  int ns = 0;
  PyObject *ns_capi = Py_None;
  int idoflag = 0;
  PyObject *idoflag_capi = Py_None;
  double *v = NULL;
  npy_intp v_Dims[1] = {-1};
  const int v_Rank = 1;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
  PyObject *v_capi = Py_None;
  double zeff = 0;
  PyObject *zeff_capi = Py_None;
  double zorig = 0;
  PyObject *zorig_capi = Py_None;
  double rel = 0;
  PyObject *rel_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *r2 = NULL;
  npy_intp r2_Dims[1] = {-1};
  const int r2_Rank = 1;
  PyArrayObject *capi_r2_tmp = NULL;
  int capi_r2_intent = 0;
  PyObject *r2_capi = Py_None;
  double dl = 0;
  PyObject *dl_capi = Py_None;
  double *q0 = NULL;
  npy_intp q0_Dims[1] = {-1};
  const int q0_Rank = 1;
  PyArrayObject *capi_q0_tmp = NULL;
  int capi_q0_intent = 0;
  PyObject *q0_capi = Py_None;
  double *xm1 = NULL;
  npy_intp xm1_Dims[1] = {-1};
  const int xm1_Rank = 1;
  PyArrayObject *capi_xm1_tmp = NULL;
  int capi_xm1_intent = 0;
  PyObject *xm1_capi = Py_None;
  double *xm2 = NULL;
  npy_intp xm2_Dims[1] = {-1};
  const int xm2_Rank = 1;
  PyArrayObject *capi_xm2_tmp = NULL;
  int capi_xm2_intent = 0;
  PyObject *xm2_capi = Py_None;
  int *njrc = NULL;
  npy_intp njrc_Dims[1] = {-1};
  const int njrc_Rank = 1;
  PyArrayObject *capi_njrc_tmp = NULL;
  int capi_njrc_intent = 0;
  PyObject *njrc_capi = Py_None;
  double *vi = NULL;
  npy_intp vi_Dims[2] = {-1, -1};
  const int vi_Rank = 2;
  PyArrayObject *capi_vi_tmp = NULL;
  int capi_vi_intent = 0;
  PyObject *vi_capi = Py_None;
  static char *capi_kwlist[] = {"i","orb","l","ns","idoflag","v","zeff","zorig","rel","nr","r","r2","dl","q0","xm1","xm2","njrc","vi",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOOOOOOOO:libphsh.setqmm",\
    capi_kwlist,&i_capi,&orb_capi,&l_capi,&ns_capi,&idoflag_capi,&v_capi,&zeff_capi,&zorig_capi,&rel_capi,&nr_capi,&r_capi,&r2_capi,&dl_capi,&q0_capi,&xm1_capi,&xm2_capi,&njrc_capi,&vi_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable dl */
    f2py_success = double_from_pyobj(&dl,dl_capi,"libphsh.setqmm() 13rd argument (dl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable v */
  v_Dims[0]=4000;
  capi_v_intent |= F2PY_INTENT_IN;
  capi_v_tmp = array_from_pyobj(NPY_DOUBLE,v_Dims,v_Rank,capi_v_intent,v_capi);
  if (capi_v_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 6th argument `v' of libphsh.setqmm to C/Fortran array" );
  } else {
    v = (double *)(capi_v_tmp->data);

  /* Processing variable vi */
  vi_Dims[0]=4000,vi_Dims[1]=7;
  capi_vi_intent |= F2PY_INTENT_IN;
  capi_vi_tmp = array_from_pyobj(NPY_DOUBLE,vi_Dims,vi_Rank,capi_vi_intent,vi_capi);
  if (capi_vi_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 18th argument `vi' of libphsh.setqmm to C/Fortran array" );
  } else {
    vi = (double *)(capi_vi_tmp->data);

  /* Processing variable zeff */
    f2py_success = double_from_pyobj(&zeff,zeff_capi,"libphsh.setqmm() 7th argument (zeff) can't be converted to double");
  if (f2py_success) {
  /* Processing variable zorig */
    f2py_success = double_from_pyobj(&zorig,zorig_capi,"libphsh.setqmm() 8th argument (zorig) can't be converted to double");
  if (f2py_success) {
  /* Processing variable orb */
  orb_Dims[0]=4000,orb_Dims[1]=33;
  capi_orb_intent |= F2PY_INTENT_IN;
  capi_orb_tmp = array_from_pyobj(NPY_DOUBLE,orb_Dims,orb_Rank,capi_orb_intent,orb_capi);
  if (capi_orb_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `orb' of libphsh.setqmm to C/Fortran array" );
  } else {
    orb = (double *)(capi_orb_tmp->data);

  /* Processing variable idoflag */
    f2py_success = int_from_pyobj(&idoflag,idoflag_capi,"libphsh.setqmm() 5th argument (idoflag) can't be converted to int");
  if (f2py_success) {
  /* Processing variable q0 */
  q0_Dims[0]=4000;
  capi_q0_intent |= F2PY_INTENT_IN;
  capi_q0_tmp = array_from_pyobj(NPY_DOUBLE,q0_Dims,q0_Rank,capi_q0_intent,q0_capi);
  if (capi_q0_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 14th argument `q0' of libphsh.setqmm to C/Fortran array" );
  } else {
    q0 = (double *)(capi_q0_tmp->data);

  /* Processing variable r2 */
  r2_Dims[0]=4000;
  capi_r2_intent |= F2PY_INTENT_IN;
  capi_r2_tmp = array_from_pyobj(NPY_DOUBLE,r2_Dims,r2_Rank,capi_r2_intent,r2_capi);
  if (capi_r2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 12nd argument `r2' of libphsh.setqmm to C/Fortran array" );
  } else {
    r2 = (double *)(capi_r2_tmp->data);

  /* Processing variable njrc */
  njrc_Dims[0]=4;
  capi_njrc_intent |= F2PY_INTENT_IN;
  capi_njrc_tmp = array_from_pyobj(NPY_INT,njrc_Dims,njrc_Rank,capi_njrc_intent,njrc_capi);
  if (capi_njrc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 17th argument `njrc' of libphsh.setqmm to C/Fortran array" );
  } else {
    njrc = (int *)(capi_njrc_tmp->data);

  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"libphsh.setqmm() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable l */
    f2py_success = int_from_pyobj(&l,l_capi,"libphsh.setqmm() 3rd argument (l) can't be converted to int");
  if (f2py_success) {
  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 11st argument `r' of libphsh.setqmm to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

  /* Processing variable rel */
    f2py_success = double_from_pyobj(&rel,rel_capi,"libphsh.setqmm() 9th argument (rel) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.setqmm() 10th argument (nr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ns */
    f2py_success = int_from_pyobj(&ns,ns_capi,"libphsh.setqmm() 4th argument (ns) can't be converted to int");
  if (f2py_success) {
  /* Processing variable xm1 */
  xm1_Dims[0]=4000;
  capi_xm1_intent |= F2PY_INTENT_IN;
  capi_xm1_tmp = array_from_pyobj(NPY_DOUBLE,xm1_Dims,xm1_Rank,capi_xm1_intent,xm1_capi);
  if (capi_xm1_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 15th argument `xm1' of libphsh.setqmm to C/Fortran array" );
  } else {
    xm1 = (double *)(capi_xm1_tmp->data);

  /* Processing variable xm2 */
  xm2_Dims[0]=4000;
  capi_xm2_intent |= F2PY_INTENT_IN;
  capi_xm2_tmp = array_from_pyobj(NPY_DOUBLE,xm2_Dims,xm2_Rank,capi_xm2_intent,xm2_capi);
  if (capi_xm2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 16th argument `xm2' of libphsh.setqmm to C/Fortran array" );
  } else {
    xm2 = (double *)(capi_xm2_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,orb,&l,&ns,&idoflag,v,&zeff,&zorig,&rel,&nr,r,r2,&dl,q0,xm1,xm2,njrc,vi);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_xm2_tmp!=xm2_capi) {
    Py_XDECREF(capi_xm2_tmp); }
  }  /*if (capi_xm2_tmp == NULL) ... else of xm2*/
  /* End of cleaning variable xm2 */
  if((PyObject *)capi_xm1_tmp!=xm1_capi) {
    Py_XDECREF(capi_xm1_tmp); }
  }  /*if (capi_xm1_tmp == NULL) ... else of xm1*/
  /* End of cleaning variable xm1 */
  } /*if (f2py_success) of ns*/
  /* End of cleaning variable ns */
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of rel*/
  /* End of cleaning variable rel */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
  if((PyObject *)capi_njrc_tmp!=njrc_capi) {
    Py_XDECREF(capi_njrc_tmp); }
  }  /*if (capi_njrc_tmp == NULL) ... else of njrc*/
  /* End of cleaning variable njrc */
  if((PyObject *)capi_r2_tmp!=r2_capi) {
    Py_XDECREF(capi_r2_tmp); }
  }  /*if (capi_r2_tmp == NULL) ... else of r2*/
  /* End of cleaning variable r2 */
  if((PyObject *)capi_q0_tmp!=q0_capi) {
    Py_XDECREF(capi_q0_tmp); }
  }  /*if (capi_q0_tmp == NULL) ... else of q0*/
  /* End of cleaning variable q0 */
  } /*if (f2py_success) of idoflag*/
  /* End of cleaning variable idoflag */
  if((PyObject *)capi_orb_tmp!=orb_capi) {
    Py_XDECREF(capi_orb_tmp); }
  }  /*if (capi_orb_tmp == NULL) ... else of orb*/
  /* End of cleaning variable orb */
  } /*if (f2py_success) of zorig*/
  /* End of cleaning variable zorig */
  } /*if (f2py_success) of zeff*/
  /* End of cleaning variable zeff */
  if((PyObject *)capi_vi_tmp!=vi_capi) {
    Py_XDECREF(capi_vi_tmp); }
  }  /*if (capi_vi_tmp == NULL) ... else of vi*/
  /* End of cleaning variable vi */
  if((PyObject *)capi_v_tmp!=v_capi) {
    Py_XDECREF(capi_v_tmp); }
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  } /*if (f2py_success) of dl*/
  /* End of cleaning variable dl */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of setqmm *******************************/

/********************************** initiali **********************************/
static char doc_f2py_rout_libphsh_initiali[] = "\
initiali(zorig,nr,rmin,rmax,r,dr,r2,dl,njrc,xntot,nel)\n\nWrapper for ``initiali``.\
\n\nParameters\n----------\n"
"zorig : input float\n"
"nr : input int\n"
"rmin : input float\n"
"rmax : input float\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"dr : input rank-1 array('d') with bounds (4000)\n"
"r2 : input rank-1 array('d') with bounds (4000)\n"
"dl : input float\n"
"njrc : input rank-1 array('i') with bounds (4)\n"
"xntot : input float\n"
"nel : input int";
/* extern void F_FUNC(initiali,INITIALI)(double*,int*,double*,double*,double*,double*,double*,double*,int*,double*,int*); */
static PyObject *f2py_rout_libphsh_initiali(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,double*,double*,double*,double*,double*,int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double zorig = 0;
  PyObject *zorig_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  double rmin = 0;
  PyObject *rmin_capi = Py_None;
  double rmax = 0;
  PyObject *rmax_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *dr = NULL;
  npy_intp dr_Dims[1] = {-1};
  const int dr_Rank = 1;
  PyArrayObject *capi_dr_tmp = NULL;
  int capi_dr_intent = 0;
  PyObject *dr_capi = Py_None;
  double *r2 = NULL;
  npy_intp r2_Dims[1] = {-1};
  const int r2_Rank = 1;
  PyArrayObject *capi_r2_tmp = NULL;
  int capi_r2_intent = 0;
  PyObject *r2_capi = Py_None;
  double dl = 0;
  PyObject *dl_capi = Py_None;
  int *njrc = NULL;
  npy_intp njrc_Dims[1] = {-1};
  const int njrc_Rank = 1;
  PyArrayObject *capi_njrc_tmp = NULL;
  int capi_njrc_intent = 0;
  PyObject *njrc_capi = Py_None;
  double xntot = 0;
  PyObject *xntot_capi = Py_None;
  int nel = 0;
  PyObject *nel_capi = Py_None;
  static char *capi_kwlist[] = {"zorig","nr","rmin","rmax","r","dr","r2","dl","njrc","xntot","nel",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOO:libphsh.initiali",\
    capi_kwlist,&zorig_capi,&nr_capi,&rmin_capi,&rmax_capi,&r_capi,&dr_capi,&r2_capi,&dl_capi,&njrc_capi,&xntot_capi,&nel_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable dl */
    f2py_success = double_from_pyobj(&dl,dl_capi,"libphsh.initiali() 8th argument (dl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nel */
    f2py_success = int_from_pyobj(&nel,nel_capi,"libphsh.initiali() 11st argument (nel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable zorig */
    f2py_success = double_from_pyobj(&zorig,zorig_capi,"libphsh.initiali() 1st argument (zorig) can't be converted to double");
  if (f2py_success) {
  /* Processing variable rmax */
    f2py_success = double_from_pyobj(&rmax,rmax_capi,"libphsh.initiali() 4th argument (rmax) can't be converted to double");
  if (f2py_success) {
  /* Processing variable njrc */
  njrc_Dims[0]=4;
  capi_njrc_intent |= F2PY_INTENT_IN;
  capi_njrc_tmp = array_from_pyobj(NPY_INT,njrc_Dims,njrc_Rank,capi_njrc_intent,njrc_capi);
  if (capi_njrc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 9th argument `njrc' of libphsh.initiali to C/Fortran array" );
  } else {
    njrc = (int *)(capi_njrc_tmp->data);

  /* Processing variable dr */
  dr_Dims[0]=4000;
  capi_dr_intent |= F2PY_INTENT_IN;
  capi_dr_tmp = array_from_pyobj(NPY_DOUBLE,dr_Dims,dr_Rank,capi_dr_intent,dr_capi);
  if (capi_dr_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 6th argument `dr' of libphsh.initiali to C/Fortran array" );
  } else {
    dr = (double *)(capi_dr_tmp->data);

  /* Processing variable rmin */
    f2py_success = double_from_pyobj(&rmin,rmin_capi,"libphsh.initiali() 3rd argument (rmin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable xntot */
    f2py_success = double_from_pyobj(&xntot,xntot_capi,"libphsh.initiali() 10th argument (xntot) can't be converted to double");
  if (f2py_success) {
  /* Processing variable r2 */
  r2_Dims[0]=4000;
  capi_r2_intent |= F2PY_INTENT_IN;
  capi_r2_tmp = array_from_pyobj(NPY_DOUBLE,r2_Dims,r2_Rank,capi_r2_intent,r2_capi);
  if (capi_r2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 7th argument `r2' of libphsh.initiali to C/Fortran array" );
  } else {
    r2 = (double *)(capi_r2_tmp->data);

  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 5th argument `r' of libphsh.initiali to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.initiali() 2nd argument (nr) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&zorig,&nr,&rmin,&rmax,r,dr,r2,&dl,njrc,&xntot,&nel);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  if((PyObject *)capi_r2_tmp!=r2_capi) {
    Py_XDECREF(capi_r2_tmp); }
  }  /*if (capi_r2_tmp == NULL) ... else of r2*/
  /* End of cleaning variable r2 */
  } /*if (f2py_success) of xntot*/
  /* End of cleaning variable xntot */
  } /*if (f2py_success) of rmin*/
  /* End of cleaning variable rmin */
  if((PyObject *)capi_dr_tmp!=dr_capi) {
    Py_XDECREF(capi_dr_tmp); }
  }  /*if (capi_dr_tmp == NULL) ... else of dr*/
  /* End of cleaning variable dr */
  if((PyObject *)capi_njrc_tmp!=njrc_capi) {
    Py_XDECREF(capi_njrc_tmp); }
  }  /*if (capi_njrc_tmp == NULL) ... else of njrc*/
  /* End of cleaning variable njrc */
  } /*if (f2py_success) of rmax*/
  /* End of cleaning variable rmax */
  } /*if (f2py_success) of zorig*/
  /* End of cleaning variable zorig */
  } /*if (f2py_success) of nel*/
  /* End of cleaning variable nel */
  } /*if (f2py_success) of dl*/
  /* End of cleaning variable dl */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of initiali ******************************/

/********************************** setgrid **********************************/
static char doc_f2py_rout_libphsh_setgrid[] = "\
setgrid(nr,rmin,rmax,r,dr,r2,dl)\n\nWrapper for ``setgrid``.\
\n\nParameters\n----------\n"
"nr : input int\n"
"rmin : input float\n"
"rmax : input float\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"dr : input rank-1 array('d') with bounds (4000)\n"
"r2 : input rank-1 array('d') with bounds (4000)\n"
"dl : input float";
/* extern void F_FUNC(setgrid,SETGRID)(int*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_libphsh_setgrid(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nr = 0;
  PyObject *nr_capi = Py_None;
  double rmin = 0;
  PyObject *rmin_capi = Py_None;
  double rmax = 0;
  PyObject *rmax_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *dr = NULL;
  npy_intp dr_Dims[1] = {-1};
  const int dr_Rank = 1;
  PyArrayObject *capi_dr_tmp = NULL;
  int capi_dr_intent = 0;
  PyObject *dr_capi = Py_None;
  double *r2 = NULL;
  npy_intp r2_Dims[1] = {-1};
  const int r2_Rank = 1;
  PyArrayObject *capi_r2_tmp = NULL;
  int capi_r2_intent = 0;
  PyObject *r2_capi = Py_None;
  double dl = 0;
  PyObject *dl_capi = Py_None;
  static char *capi_kwlist[] = {"nr","rmin","rmax","r","dr","r2","dl",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOO:libphsh.setgrid",\
    capi_kwlist,&nr_capi,&rmin_capi,&rmax_capi,&r_capi,&dr_capi,&r2_capi,&dl_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable dl */
    f2py_success = double_from_pyobj(&dl,dl_capi,"libphsh.setgrid() 7th argument (dl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable rmax */
    f2py_success = double_from_pyobj(&rmax,rmax_capi,"libphsh.setgrid() 3rd argument (rmax) can't be converted to double");
  if (f2py_success) {
  /* Processing variable dr */
  dr_Dims[0]=4000;
  capi_dr_intent |= F2PY_INTENT_IN;
  capi_dr_tmp = array_from_pyobj(NPY_DOUBLE,dr_Dims,dr_Rank,capi_dr_intent,dr_capi);
  if (capi_dr_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 5th argument `dr' of libphsh.setgrid to C/Fortran array" );
  } else {
    dr = (double *)(capi_dr_tmp->data);

  /* Processing variable rmin */
    f2py_success = double_from_pyobj(&rmin,rmin_capi,"libphsh.setgrid() 2nd argument (rmin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable r2 */
  r2_Dims[0]=4000;
  capi_r2_intent |= F2PY_INTENT_IN;
  capi_r2_tmp = array_from_pyobj(NPY_DOUBLE,r2_Dims,r2_Rank,capi_r2_intent,r2_capi);
  if (capi_r2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 6th argument `r2' of libphsh.setgrid to C/Fortran array" );
  } else {
    r2 = (double *)(capi_r2_tmp->data);

  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 4th argument `r' of libphsh.setgrid to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.setgrid() 1st argument (nr) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nr,&rmin,&rmax,r,dr,r2,&dl);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  if((PyObject *)capi_r2_tmp!=r2_capi) {
    Py_XDECREF(capi_r2_tmp); }
  }  /*if (capi_r2_tmp == NULL) ... else of r2*/
  /* End of cleaning variable r2 */
  } /*if (f2py_success) of rmin*/
  /* End of cleaning variable rmin */
  if((PyObject *)capi_dr_tmp!=dr_capi) {
    Py_XDECREF(capi_dr_tmp); }
  }  /*if (capi_dr_tmp == NULL) ... else of dr*/
  /* End of cleaning variable dr */
  } /*if (f2py_success) of rmax*/
  /* End of cleaning variable rmax */
  } /*if (f2py_success) of dl*/
  /* End of cleaning variable dl */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of setgrid *******************************/

/*********************************** integ ***********************************/
static char doc_f2py_rout_libphsh_integ[] = "\
integ(e,l,xkappa,n,nn,istop,ief,x0,phi,z,v,q0,xm1,xm2,nr,r,dr,r2,dl,rel)\n\nWrapper for ``integ``.\
\n\nParameters\n----------\n"
"e : input float\n"
"l : input int\n"
"xkappa : input float\n"
"n : input int\n"
"nn : input int\n"
"istop : input int\n"
"ief : input int\n"
"x0 : input float\n"
"phi : input rank-1 array('d') with bounds (4000)\n"
"z : input float\n"
"v : input rank-1 array('d') with bounds (4000)\n"
"q0 : input rank-1 array('d') with bounds (4000)\n"
"xm1 : input rank-1 array('d') with bounds (4000)\n"
"xm2 : input rank-1 array('d') with bounds (4000)\n"
"nr : input int\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"dr : input rank-1 array('d') with bounds (4000)\n"
"r2 : input rank-1 array('d') with bounds (4000)\n"
"dl : input float\n"
"rel : input float";
/* extern void F_FUNC(integ,INTEG)(double*,int*,double*,int*,int*,int*,int*,double*,double*,double*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_libphsh_integ(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,int*,int*,int*,int*,double*,double*,double*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double e = 0;
  PyObject *e_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  double xkappa = 0;
  PyObject *xkappa_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int nn = 0;
  PyObject *nn_capi = Py_None;
  int istop = 0;
  PyObject *istop_capi = Py_None;
  int ief = 0;
  PyObject *ief_capi = Py_None;
  double x0 = 0;
  PyObject *x0_capi = Py_None;
  double *phi = NULL;
  npy_intp phi_Dims[1] = {-1};
  const int phi_Rank = 1;
  PyArrayObject *capi_phi_tmp = NULL;
  int capi_phi_intent = 0;
  PyObject *phi_capi = Py_None;
  double z = 0;
  PyObject *z_capi = Py_None;
  double *v = NULL;
  npy_intp v_Dims[1] = {-1};
  const int v_Rank = 1;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
  PyObject *v_capi = Py_None;
  double *q0 = NULL;
  npy_intp q0_Dims[1] = {-1};
  const int q0_Rank = 1;
  PyArrayObject *capi_q0_tmp = NULL;
  int capi_q0_intent = 0;
  PyObject *q0_capi = Py_None;
  double *xm1 = NULL;
  npy_intp xm1_Dims[1] = {-1};
  const int xm1_Rank = 1;
  PyArrayObject *capi_xm1_tmp = NULL;
  int capi_xm1_intent = 0;
  PyObject *xm1_capi = Py_None;
  double *xm2 = NULL;
  npy_intp xm2_Dims[1] = {-1};
  const int xm2_Rank = 1;
  PyArrayObject *capi_xm2_tmp = NULL;
  int capi_xm2_intent = 0;
  PyObject *xm2_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *dr = NULL;
  npy_intp dr_Dims[1] = {-1};
  const int dr_Rank = 1;
  PyArrayObject *capi_dr_tmp = NULL;
  int capi_dr_intent = 0;
  PyObject *dr_capi = Py_None;
  double *r2 = NULL;
  npy_intp r2_Dims[1] = {-1};
  const int r2_Rank = 1;
  PyArrayObject *capi_r2_tmp = NULL;
  int capi_r2_intent = 0;
  PyObject *r2_capi = Py_None;
  double dl = 0;
  PyObject *dl_capi = Py_None;
  double rel = 0;
  PyObject *rel_capi = Py_None;
  static char *capi_kwlist[] = {"e","l","xkappa","n","nn","istop","ief","x0","phi","z","v","q0","xm1","xm2","nr","r","dr","r2","dl","rel",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOOOOOOOOOO:libphsh.integ",\
    capi_kwlist,&e_capi,&l_capi,&xkappa_capi,&n_capi,&nn_capi,&istop_capi,&ief_capi,&x0_capi,&phi_capi,&z_capi,&v_capi,&q0_capi,&xm1_capi,&xm2_capi,&nr_capi,&r_capi,&dr_capi,&r2_capi,&dl_capi,&rel_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable dl */
    f2py_success = double_from_pyobj(&dl,dl_capi,"libphsh.integ() 19th argument (dl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable v */
  v_Dims[0]=4000;
  capi_v_intent |= F2PY_INTENT_IN;
  capi_v_tmp = array_from_pyobj(NPY_DOUBLE,v_Dims,v_Rank,capi_v_intent,v_capi);
  if (capi_v_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 11st argument `v' of libphsh.integ to C/Fortran array" );
  } else {
    v = (double *)(capi_v_tmp->data);

  /* Processing variable x0 */
    f2py_success = double_from_pyobj(&x0,x0_capi,"libphsh.integ() 8th argument (x0) can't be converted to double");
  if (f2py_success) {
  /* Processing variable dr */
  dr_Dims[0]=4000;
  capi_dr_intent |= F2PY_INTENT_IN;
  capi_dr_tmp = array_from_pyobj(NPY_DOUBLE,dr_Dims,dr_Rank,capi_dr_intent,dr_capi);
  if (capi_dr_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 17th argument `dr' of libphsh.integ to C/Fortran array" );
  } else {
    dr = (double *)(capi_dr_tmp->data);

  /* Processing variable q0 */
  q0_Dims[0]=4000;
  capi_q0_intent |= F2PY_INTENT_IN;
  capi_q0_tmp = array_from_pyobj(NPY_DOUBLE,q0_Dims,q0_Rank,capi_q0_intent,q0_capi);
  if (capi_q0_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 12nd argument `q0' of libphsh.integ to C/Fortran array" );
  } else {
    q0 = (double *)(capi_q0_tmp->data);

  /* Processing variable z */
    f2py_success = double_from_pyobj(&z,z_capi,"libphsh.integ() 10th argument (z) can't be converted to double");
  if (f2py_success) {
  /* Processing variable e */
    f2py_success = double_from_pyobj(&e,e_capi,"libphsh.integ() 1st argument (e) can't be converted to double");
  if (f2py_success) {
  /* Processing variable r2 */
  r2_Dims[0]=4000;
  capi_r2_intent |= F2PY_INTENT_IN;
  capi_r2_tmp = array_from_pyobj(NPY_DOUBLE,r2_Dims,r2_Rank,capi_r2_intent,r2_capi);
  if (capi_r2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 18th argument `r2' of libphsh.integ to C/Fortran array" );
  } else {
    r2 = (double *)(capi_r2_tmp->data);

  /* Processing variable nn */
    f2py_success = int_from_pyobj(&nn,nn_capi,"libphsh.integ() 5th argument (nn) can't be converted to int");
  if (f2py_success) {
  /* Processing variable l */
    f2py_success = int_from_pyobj(&l,l_capi,"libphsh.integ() 2nd argument (l) can't be converted to int");
  if (f2py_success) {
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"libphsh.integ() 4th argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable phi */
  phi_Dims[0]=4000;
  capi_phi_intent |= F2PY_INTENT_IN;
  capi_phi_tmp = array_from_pyobj(NPY_DOUBLE,phi_Dims,phi_Rank,capi_phi_intent,phi_capi);
  if (capi_phi_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 9th argument `phi' of libphsh.integ to C/Fortran array" );
  } else {
    phi = (double *)(capi_phi_tmp->data);

  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 16th argument `r' of libphsh.integ to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

  /* Processing variable istop */
    f2py_success = int_from_pyobj(&istop,istop_capi,"libphsh.integ() 6th argument (istop) can't be converted to int");
  if (f2py_success) {
  /* Processing variable rel */
    f2py_success = double_from_pyobj(&rel,rel_capi,"libphsh.integ() 20th argument (rel) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.integ() 15th argument (nr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable xkappa */
    f2py_success = double_from_pyobj(&xkappa,xkappa_capi,"libphsh.integ() 3rd argument (xkappa) can't be converted to double");
  if (f2py_success) {
  /* Processing variable xm1 */
  xm1_Dims[0]=4000;
  capi_xm1_intent |= F2PY_INTENT_IN;
  capi_xm1_tmp = array_from_pyobj(NPY_DOUBLE,xm1_Dims,xm1_Rank,capi_xm1_intent,xm1_capi);
  if (capi_xm1_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 13rd argument `xm1' of libphsh.integ to C/Fortran array" );
  } else {
    xm1 = (double *)(capi_xm1_tmp->data);

  /* Processing variable xm2 */
  xm2_Dims[0]=4000;
  capi_xm2_intent |= F2PY_INTENT_IN;
  capi_xm2_tmp = array_from_pyobj(NPY_DOUBLE,xm2_Dims,xm2_Rank,capi_xm2_intent,xm2_capi);
  if (capi_xm2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 14th argument `xm2' of libphsh.integ to C/Fortran array" );
  } else {
    xm2 = (double *)(capi_xm2_tmp->data);

  /* Processing variable ief */
    f2py_success = int_from_pyobj(&ief,ief_capi,"libphsh.integ() 7th argument (ief) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&e,&l,&xkappa,&n,&nn,&istop,&ief,&x0,phi,&z,v,q0,xm1,xm2,&nr,r,dr,r2,&dl,&rel);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of ief*/
  /* End of cleaning variable ief */
  if((PyObject *)capi_xm2_tmp!=xm2_capi) {
    Py_XDECREF(capi_xm2_tmp); }
  }  /*if (capi_xm2_tmp == NULL) ... else of xm2*/
  /* End of cleaning variable xm2 */
  if((PyObject *)capi_xm1_tmp!=xm1_capi) {
    Py_XDECREF(capi_xm1_tmp); }
  }  /*if (capi_xm1_tmp == NULL) ... else of xm1*/
  /* End of cleaning variable xm1 */
  } /*if (f2py_success) of xkappa*/
  /* End of cleaning variable xkappa */
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of rel*/
  /* End of cleaning variable rel */
  } /*if (f2py_success) of istop*/
  /* End of cleaning variable istop */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  if((PyObject *)capi_phi_tmp!=phi_capi) {
    Py_XDECREF(capi_phi_tmp); }
  }  /*if (capi_phi_tmp == NULL) ... else of phi*/
  /* End of cleaning variable phi */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*if (f2py_success) of nn*/
  /* End of cleaning variable nn */
  if((PyObject *)capi_r2_tmp!=r2_capi) {
    Py_XDECREF(capi_r2_tmp); }
  }  /*if (capi_r2_tmp == NULL) ... else of r2*/
  /* End of cleaning variable r2 */
  } /*if (f2py_success) of e*/
  /* End of cleaning variable e */
  } /*if (f2py_success) of z*/
  /* End of cleaning variable z */
  if((PyObject *)capi_q0_tmp!=q0_capi) {
    Py_XDECREF(capi_q0_tmp); }
  }  /*if (capi_q0_tmp == NULL) ... else of q0*/
  /* End of cleaning variable q0 */
  if((PyObject *)capi_dr_tmp!=dr_capi) {
    Py_XDECREF(capi_dr_tmp); }
  }  /*if (capi_dr_tmp == NULL) ... else of dr*/
  /* End of cleaning variable dr */
  } /*if (f2py_success) of x0*/
  /* End of cleaning variable x0 */
  if((PyObject *)capi_v_tmp!=v_capi) {
    Py_XDECREF(capi_v_tmp); }
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  } /*if (f2py_success) of dl*/
  /* End of cleaning variable dl */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of integ ********************************/

/******************************* clebschgordan *******************************/
static char doc_f2py_rout_libphsh_clebschgordan[] = "\
clebschgordan(nel,nl,cg)\n\nWrapper for ``clebschgordan``.\
\n\nParameters\n----------\n"
"nel : input int\n"
"nl : input rank-1 array('i') with bounds (33)\n"
"cg : input rank-5 array('d') with bounds (7,7,13,13,13)";
/* extern void F_FUNC(clebschgordan,CLEBSCHGORDAN)(int*,int*,double*); */
static PyObject *f2py_rout_libphsh_clebschgordan(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nel = 0;
  PyObject *nel_capi = Py_None;
  int *nl = NULL;
  npy_intp nl_Dims[1] = {-1};
  const int nl_Rank = 1;
  PyArrayObject *capi_nl_tmp = NULL;
  int capi_nl_intent = 0;
  PyObject *nl_capi = Py_None;
  double *cg = NULL;
  npy_intp cg_Dims[5] = {-1, -1, -1, -1, -1};
  const int cg_Rank = 5;
  PyArrayObject *capi_cg_tmp = NULL;
  int capi_cg_intent = 0;
  PyObject *cg_capi = Py_None;
  static char *capi_kwlist[] = {"nel","nl","cg",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO:libphsh.clebschgordan",\
    capi_kwlist,&nel_capi,&nl_capi,&cg_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nel */
    f2py_success = int_from_pyobj(&nel,nel_capi,"libphsh.clebschgordan() 1st argument (nel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nl */
  nl_Dims[0]=33;
  capi_nl_intent |= F2PY_INTENT_IN;
  capi_nl_tmp = array_from_pyobj(NPY_INT,nl_Dims,nl_Rank,capi_nl_intent,nl_capi);
  if (capi_nl_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `nl' of libphsh.clebschgordan to C/Fortran array" );
  } else {
    nl = (int *)(capi_nl_tmp->data);

  /* Processing variable cg */
  cg_Dims[0]=7,cg_Dims[1]=7,cg_Dims[2]=13,cg_Dims[3]=13,cg_Dims[4]=13;
  capi_cg_intent |= F2PY_INTENT_IN;
  capi_cg_tmp = array_from_pyobj(NPY_DOUBLE,cg_Dims,cg_Rank,capi_cg_intent,cg_capi);
  if (capi_cg_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 3rd argument `cg' of libphsh.clebschgordan to C/Fortran array" );
  } else {
    cg = (double *)(capi_cg_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nel,nl,cg);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_cg_tmp!=cg_capi) {
    Py_XDECREF(capi_cg_tmp); }
  }  /*if (capi_cg_tmp == NULL) ... else of cg*/
  /* End of cleaning variable cg */
  if((PyObject *)capi_nl_tmp!=nl_capi) {
    Py_XDECREF(capi_nl_tmp); }
  }  /*if (capi_nl_tmp == NULL) ... else of nl*/
  /* End of cleaning variable nl */
  } /*if (f2py_success) of nel*/
  /* End of cleaning variable nel */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of clebschgordan ****************************/

/*********************************** pseudo ***********************************/
static char doc_f2py_rout_libphsh_pseudo[] = "\
pseudo(etot,nst,rel,alfa,nr,rmin,rmax,r,dr,r2,dl,phe,orb,njrc,vi,zorig,xntot,nel,no,nl,xnj,ev,occ,is,ek,iuflag,vctab)\n\nWrapper for ``pseudo``.\
\n\nParameters\n----------\n"
"etot : input float\n"
"nst : input int\n"
"rel : input float\n"
"alfa : input float\n"
"nr : input int\n"
"rmin : input float\n"
"rmax : input float\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"dr : input rank-1 array('d') with bounds (4000)\n"
"r2 : input rank-1 array('d') with bounds (4000)\n"
"dl : input float\n"
"phe : input rank-2 array('d') with bounds (4000,33)\n"
"orb : input rank-2 array('d') with bounds (4000,33)\n"
"njrc : input rank-1 array('i') with bounds (4)\n"
"vi : input rank-2 array('d') with bounds (4000,7)\n"
"zorig : input float\n"
"xntot : input float\n"
"nel : input int\n"
"no : input rank-1 array('i') with bounds (33)\n"
"nl : input rank-1 array('i') with bounds (33)\n"
"xnj : input rank-1 array('d') with bounds (33)\n"
"ev : input rank-1 array('d') with bounds (33)\n"
"occ : input rank-1 array('d') with bounds (33)\n"
"is : input rank-1 array('i') with bounds (33)\n"
"ek : input rank-1 array('d') with bounds (33)\n"
"iuflag : input int\n"
"vctab : input rank-2 array('d') with bounds (4000,4)";
/* extern void F_FUNC(pseudo,PSEUDO)(double*,int*,double*,double*,int*,double*,double*,double*,double*,double*,double*,double*,double*,int*,double*,double*,double*,int*,int*,int*,double*,double*,double*,int*,double*,int*,double*); */
static PyObject *f2py_rout_libphsh_pseudo(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,double*,int*,double*,double*,double*,double*,double*,double*,double*,double*,int*,double*,double*,double*,int*,int*,int*,double*,double*,double*,int*,double*,int*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double etot = 0;
  PyObject *etot_capi = Py_None;
  int nst = 0;
  PyObject *nst_capi = Py_None;
  double rel = 0;
  PyObject *rel_capi = Py_None;
  double alfa = 0;
  PyObject *alfa_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  double rmin = 0;
  PyObject *rmin_capi = Py_None;
  double rmax = 0;
  PyObject *rmax_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *dr = NULL;
  npy_intp dr_Dims[1] = {-1};
  const int dr_Rank = 1;
  PyArrayObject *capi_dr_tmp = NULL;
  int capi_dr_intent = 0;
  PyObject *dr_capi = Py_None;
  double *r2 = NULL;
  npy_intp r2_Dims[1] = {-1};
  const int r2_Rank = 1;
  PyArrayObject *capi_r2_tmp = NULL;
  int capi_r2_intent = 0;
  PyObject *r2_capi = Py_None;
  double dl = 0;
  PyObject *dl_capi = Py_None;
  double *phe = NULL;
  npy_intp phe_Dims[2] = {-1, -1};
  const int phe_Rank = 2;
  PyArrayObject *capi_phe_tmp = NULL;
  int capi_phe_intent = 0;
  PyObject *phe_capi = Py_None;
  double *orb = NULL;
  npy_intp orb_Dims[2] = {-1, -1};
  const int orb_Rank = 2;
  PyArrayObject *capi_orb_tmp = NULL;
  int capi_orb_intent = 0;
  PyObject *orb_capi = Py_None;
  int *njrc = NULL;
  npy_intp njrc_Dims[1] = {-1};
  const int njrc_Rank = 1;
  PyArrayObject *capi_njrc_tmp = NULL;
  int capi_njrc_intent = 0;
  PyObject *njrc_capi = Py_None;
  double *vi = NULL;
  npy_intp vi_Dims[2] = {-1, -1};
  const int vi_Rank = 2;
  PyArrayObject *capi_vi_tmp = NULL;
  int capi_vi_intent = 0;
  PyObject *vi_capi = Py_None;
  double zorig = 0;
  PyObject *zorig_capi = Py_None;
  double xntot = 0;
  PyObject *xntot_capi = Py_None;
  int nel = 0;
  PyObject *nel_capi = Py_None;
  int *no = NULL;
  npy_intp no_Dims[1] = {-1};
  const int no_Rank = 1;
  PyArrayObject *capi_no_tmp = NULL;
  int capi_no_intent = 0;
  PyObject *no_capi = Py_None;
  int *nl = NULL;
  npy_intp nl_Dims[1] = {-1};
  const int nl_Rank = 1;
  PyArrayObject *capi_nl_tmp = NULL;
  int capi_nl_intent = 0;
  PyObject *nl_capi = Py_None;
  double *xnj = NULL;
  npy_intp xnj_Dims[1] = {-1};
  const int xnj_Rank = 1;
  PyArrayObject *capi_xnj_tmp = NULL;
  int capi_xnj_intent = 0;
  PyObject *xnj_capi = Py_None;
  double *ev = NULL;
  npy_intp ev_Dims[1] = {-1};
  const int ev_Rank = 1;
  PyArrayObject *capi_ev_tmp = NULL;
  int capi_ev_intent = 0;
  PyObject *ev_capi = Py_None;
  double *occ = NULL;
  npy_intp occ_Dims[1] = {-1};
  const int occ_Rank = 1;
  PyArrayObject *capi_occ_tmp = NULL;
  int capi_occ_intent = 0;
  PyObject *occ_capi = Py_None;
  int *is = NULL;
  npy_intp is_Dims[1] = {-1};
  const int is_Rank = 1;
  PyArrayObject *capi_is_tmp = NULL;
  int capi_is_intent = 0;
  PyObject *is_capi = Py_None;
  double *ek = NULL;
  npy_intp ek_Dims[1] = {-1};
  const int ek_Rank = 1;
  PyArrayObject *capi_ek_tmp = NULL;
  int capi_ek_intent = 0;
  PyObject *ek_capi = Py_None;
  int iuflag = 0;
  PyObject *iuflag_capi = Py_None;
  double *vctab = NULL;
  npy_intp vctab_Dims[2] = {-1, -1};
  const int vctab_Rank = 2;
  PyArrayObject *capi_vctab_tmp = NULL;
  int capi_vctab_intent = 0;
  PyObject *vctab_capi = Py_None;
  static char *capi_kwlist[] = {"etot","nst","rel","alfa","nr","rmin","rmax","r","dr","r2","dl","phe","orb","njrc","vi","zorig","xntot","nel","no","nl","xnj","ev","occ","is","ek","iuflag","vctab",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOOOOOOOOOOOOOOOOO:libphsh.pseudo",\
    capi_kwlist,&etot_capi,&nst_capi,&rel_capi,&alfa_capi,&nr_capi,&rmin_capi,&rmax_capi,&r_capi,&dr_capi,&r2_capi,&dl_capi,&phe_capi,&orb_capi,&njrc_capi,&vi_capi,&zorig_capi,&xntot_capi,&nel_capi,&no_capi,&nl_capi,&xnj_capi,&ev_capi,&occ_capi,&is_capi,&ek_capi,&iuflag_capi,&vctab_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable alfa */
    f2py_success = double_from_pyobj(&alfa,alfa_capi,"libphsh.pseudo() 4th argument (alfa) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ek */
  ek_Dims[0]=33;
  capi_ek_intent |= F2PY_INTENT_IN;
  capi_ek_tmp = array_from_pyobj(NPY_DOUBLE,ek_Dims,ek_Rank,capi_ek_intent,ek_capi);
  if (capi_ek_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 25th argument `ek' of libphsh.pseudo to C/Fortran array" );
  } else {
    ek = (double *)(capi_ek_tmp->data);

  /* Processing variable vi */
  vi_Dims[0]=4000,vi_Dims[1]=7;
  capi_vi_intent |= F2PY_INTENT_IN;
  capi_vi_tmp = array_from_pyobj(NPY_DOUBLE,vi_Dims,vi_Rank,capi_vi_intent,vi_capi);
  if (capi_vi_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 15th argument `vi' of libphsh.pseudo to C/Fortran array" );
  } else {
    vi = (double *)(capi_vi_tmp->data);

  /* Processing variable is */
  is_Dims[0]=33;
  capi_is_intent |= F2PY_INTENT_IN;
  capi_is_tmp = array_from_pyobj(NPY_INT,is_Dims,is_Rank,capi_is_intent,is_capi);
  if (capi_is_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 24th argument `is' of libphsh.pseudo to C/Fortran array" );
  } else {
    is = (int *)(capi_is_tmp->data);

  /* Processing variable ev */
  ev_Dims[0]=33;
  capi_ev_intent |= F2PY_INTENT_IN;
  capi_ev_tmp = array_from_pyobj(NPY_DOUBLE,ev_Dims,ev_Rank,capi_ev_intent,ev_capi);
  if (capi_ev_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 22nd argument `ev' of libphsh.pseudo to C/Fortran array" );
  } else {
    ev = (double *)(capi_ev_tmp->data);

  /* Processing variable nst */
    f2py_success = int_from_pyobj(&nst,nst_capi,"libphsh.pseudo() 2nd argument (nst) can't be converted to int");
  if (f2py_success) {
  /* Processing variable rmin */
    f2py_success = double_from_pyobj(&rmin,rmin_capi,"libphsh.pseudo() 6th argument (rmin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nl */
  nl_Dims[0]=33;
  capi_nl_intent |= F2PY_INTENT_IN;
  capi_nl_tmp = array_from_pyobj(NPY_INT,nl_Dims,nl_Rank,capi_nl_intent,nl_capi);
  if (capi_nl_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 20th argument `nl' of libphsh.pseudo to C/Fortran array" );
  } else {
    nl = (int *)(capi_nl_tmp->data);

  /* Processing variable xntot */
    f2py_success = double_from_pyobj(&xntot,xntot_capi,"libphsh.pseudo() 17th argument (xntot) can't be converted to double");
  if (f2py_success) {
  /* Processing variable no */
  no_Dims[0]=33;
  capi_no_intent |= F2PY_INTENT_IN;
  capi_no_tmp = array_from_pyobj(NPY_INT,no_Dims,no_Rank,capi_no_intent,no_capi);
  if (capi_no_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 19th argument `no' of libphsh.pseudo to C/Fortran array" );
  } else {
    no = (int *)(capi_no_tmp->data);

  /* Processing variable dr */
  dr_Dims[0]=4000;
  capi_dr_intent |= F2PY_INTENT_IN;
  capi_dr_tmp = array_from_pyobj(NPY_DOUBLE,dr_Dims,dr_Rank,capi_dr_intent,dr_capi);
  if (capi_dr_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 9th argument `dr' of libphsh.pseudo to C/Fortran array" );
  } else {
    dr = (double *)(capi_dr_tmp->data);

  /* Processing variable occ */
  occ_Dims[0]=33;
  capi_occ_intent |= F2PY_INTENT_IN;
  capi_occ_tmp = array_from_pyobj(NPY_DOUBLE,occ_Dims,occ_Rank,capi_occ_intent,occ_capi);
  if (capi_occ_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 23rd argument `occ' of libphsh.pseudo to C/Fortran array" );
  } else {
    occ = (double *)(capi_occ_tmp->data);

  /* Processing variable rel */
    f2py_success = double_from_pyobj(&rel,rel_capi,"libphsh.pseudo() 3rd argument (rel) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.pseudo() 5th argument (nr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable etot */
    f2py_success = double_from_pyobj(&etot,etot_capi,"libphsh.pseudo() 1st argument (etot) can't be converted to double");
  if (f2py_success) {
  /* Processing variable rmax */
    f2py_success = double_from_pyobj(&rmax,rmax_capi,"libphsh.pseudo() 7th argument (rmax) can't be converted to double");
  if (f2py_success) {
  /* Processing variable iuflag */
    f2py_success = int_from_pyobj(&iuflag,iuflag_capi,"libphsh.pseudo() 26th argument (iuflag) can't be converted to int");
  if (f2py_success) {
  /* Processing variable zorig */
    f2py_success = double_from_pyobj(&zorig,zorig_capi,"libphsh.pseudo() 16th argument (zorig) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nel */
    f2py_success = int_from_pyobj(&nel,nel_capi,"libphsh.pseudo() 18th argument (nel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable phe */
  phe_Dims[0]=4000,phe_Dims[1]=33;
  capi_phe_intent |= F2PY_INTENT_IN;
  capi_phe_tmp = array_from_pyobj(NPY_DOUBLE,phe_Dims,phe_Rank,capi_phe_intent,phe_capi);
  if (capi_phe_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 12nd argument `phe' of libphsh.pseudo to C/Fortran array" );
  } else {
    phe = (double *)(capi_phe_tmp->data);

  /* Processing variable njrc */
  njrc_Dims[0]=4;
  capi_njrc_intent |= F2PY_INTENT_IN;
  capi_njrc_tmp = array_from_pyobj(NPY_INT,njrc_Dims,njrc_Rank,capi_njrc_intent,njrc_capi);
  if (capi_njrc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 14th argument `njrc' of libphsh.pseudo to C/Fortran array" );
  } else {
    njrc = (int *)(capi_njrc_tmp->data);

  /* Processing variable orb */
  orb_Dims[0]=4000,orb_Dims[1]=33;
  capi_orb_intent |= F2PY_INTENT_IN;
  capi_orb_tmp = array_from_pyobj(NPY_DOUBLE,orb_Dims,orb_Rank,capi_orb_intent,orb_capi);
  if (capi_orb_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 13rd argument `orb' of libphsh.pseudo to C/Fortran array" );
  } else {
    orb = (double *)(capi_orb_tmp->data);

  /* Processing variable xnj */
  xnj_Dims[0]=33;
  capi_xnj_intent |= F2PY_INTENT_IN;
  capi_xnj_tmp = array_from_pyobj(NPY_DOUBLE,xnj_Dims,xnj_Rank,capi_xnj_intent,xnj_capi);
  if (capi_xnj_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 21st argument `xnj' of libphsh.pseudo to C/Fortran array" );
  } else {
    xnj = (double *)(capi_xnj_tmp->data);

  /* Processing variable dl */
    f2py_success = double_from_pyobj(&dl,dl_capi,"libphsh.pseudo() 11st argument (dl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable r2 */
  r2_Dims[0]=4000;
  capi_r2_intent |= F2PY_INTENT_IN;
  capi_r2_tmp = array_from_pyobj(NPY_DOUBLE,r2_Dims,r2_Rank,capi_r2_intent,r2_capi);
  if (capi_r2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 10th argument `r2' of libphsh.pseudo to C/Fortran array" );
  } else {
    r2 = (double *)(capi_r2_tmp->data);

  /* Processing variable vctab */
  vctab_Dims[0]=4000,vctab_Dims[1]=4;
  capi_vctab_intent |= F2PY_INTENT_IN;
  capi_vctab_tmp = array_from_pyobj(NPY_DOUBLE,vctab_Dims,vctab_Rank,capi_vctab_intent,vctab_capi);
  if (capi_vctab_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 27th argument `vctab' of libphsh.pseudo to C/Fortran array" );
  } else {
    vctab = (double *)(capi_vctab_tmp->data);

  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 8th argument `r' of libphsh.pseudo to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&etot,&nst,&rel,&alfa,&nr,&rmin,&rmax,r,dr,r2,&dl,phe,orb,njrc,vi,&zorig,&xntot,&nel,no,nl,xnj,ev,occ,is,ek,&iuflag,vctab);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  if((PyObject *)capi_vctab_tmp!=vctab_capi) {
    Py_XDECREF(capi_vctab_tmp); }
  }  /*if (capi_vctab_tmp == NULL) ... else of vctab*/
  /* End of cleaning variable vctab */
  if((PyObject *)capi_r2_tmp!=r2_capi) {
    Py_XDECREF(capi_r2_tmp); }
  }  /*if (capi_r2_tmp == NULL) ... else of r2*/
  /* End of cleaning variable r2 */
  } /*if (f2py_success) of dl*/
  /* End of cleaning variable dl */
  if((PyObject *)capi_xnj_tmp!=xnj_capi) {
    Py_XDECREF(capi_xnj_tmp); }
  }  /*if (capi_xnj_tmp == NULL) ... else of xnj*/
  /* End of cleaning variable xnj */
  if((PyObject *)capi_orb_tmp!=orb_capi) {
    Py_XDECREF(capi_orb_tmp); }
  }  /*if (capi_orb_tmp == NULL) ... else of orb*/
  /* End of cleaning variable orb */
  if((PyObject *)capi_njrc_tmp!=njrc_capi) {
    Py_XDECREF(capi_njrc_tmp); }
  }  /*if (capi_njrc_tmp == NULL) ... else of njrc*/
  /* End of cleaning variable njrc */
  if((PyObject *)capi_phe_tmp!=phe_capi) {
    Py_XDECREF(capi_phe_tmp); }
  }  /*if (capi_phe_tmp == NULL) ... else of phe*/
  /* End of cleaning variable phe */
  } /*if (f2py_success) of nel*/
  /* End of cleaning variable nel */
  } /*if (f2py_success) of zorig*/
  /* End of cleaning variable zorig */
  } /*if (f2py_success) of iuflag*/
  /* End of cleaning variable iuflag */
  } /*if (f2py_success) of rmax*/
  /* End of cleaning variable rmax */
  } /*if (f2py_success) of etot*/
  /* End of cleaning variable etot */
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of rel*/
  /* End of cleaning variable rel */
  if((PyObject *)capi_occ_tmp!=occ_capi) {
    Py_XDECREF(capi_occ_tmp); }
  }  /*if (capi_occ_tmp == NULL) ... else of occ*/
  /* End of cleaning variable occ */
  if((PyObject *)capi_dr_tmp!=dr_capi) {
    Py_XDECREF(capi_dr_tmp); }
  }  /*if (capi_dr_tmp == NULL) ... else of dr*/
  /* End of cleaning variable dr */
  if((PyObject *)capi_no_tmp!=no_capi) {
    Py_XDECREF(capi_no_tmp); }
  }  /*if (capi_no_tmp == NULL) ... else of no*/
  /* End of cleaning variable no */
  } /*if (f2py_success) of xntot*/
  /* End of cleaning variable xntot */
  if((PyObject *)capi_nl_tmp!=nl_capi) {
    Py_XDECREF(capi_nl_tmp); }
  }  /*if (capi_nl_tmp == NULL) ... else of nl*/
  /* End of cleaning variable nl */
  } /*if (f2py_success) of rmin*/
  /* End of cleaning variable rmin */
  } /*if (f2py_success) of nst*/
  /* End of cleaning variable nst */
  if((PyObject *)capi_ev_tmp!=ev_capi) {
    Py_XDECREF(capi_ev_tmp); }
  }  /*if (capi_ev_tmp == NULL) ... else of ev*/
  /* End of cleaning variable ev */
  if((PyObject *)capi_is_tmp!=is_capi) {
    Py_XDECREF(capi_is_tmp); }
  }  /*if (capi_is_tmp == NULL) ... else of is*/
  /* End of cleaning variable is */
  if((PyObject *)capi_vi_tmp!=vi_capi) {
    Py_XDECREF(capi_vi_tmp); }
  }  /*if (capi_vi_tmp == NULL) ... else of vi*/
  /* End of cleaning variable vi */
  if((PyObject *)capi_ek_tmp!=ek_capi) {
    Py_XDECREF(capi_ek_tmp); }
  }  /*if (capi_ek_tmp == NULL) ... else of ek*/
  /* End of cleaning variable ek */
  } /*if (f2py_success) of alfa*/
  /* End of cleaning variable alfa */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pseudo *******************************/

/********************************** parabreg **********************************/
static char doc_f2py_rout_libphsh_parabreg[] = "\
parabreg(f,fp,fpp,rf,vf)\n\nWrapper for ``parabreg``.\
\n\nParameters\n----------\n"
"f : input float\n"
"fp : input float\n"
"fpp : input float\n"
"rf : input rank-1 array('d') with bounds (3)\n"
"vf : input rank-1 array('d') with bounds (3)";
/* extern void F_FUNC(parabreg,PARABREG)(double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_libphsh_parabreg(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double f = 0;
  PyObject *f_capi = Py_None;
  double fp = 0;
  PyObject *fp_capi = Py_None;
  double fpp = 0;
  PyObject *fpp_capi = Py_None;
  double *rf = NULL;
  npy_intp rf_Dims[1] = {-1};
  const int rf_Rank = 1;
  PyArrayObject *capi_rf_tmp = NULL;
  int capi_rf_intent = 0;
  PyObject *rf_capi = Py_None;
  double *vf = NULL;
  npy_intp vf_Dims[1] = {-1};
  const int vf_Rank = 1;
  PyArrayObject *capi_vf_tmp = NULL;
  int capi_vf_intent = 0;
  PyObject *vf_capi = Py_None;
  static char *capi_kwlist[] = {"f","fp","fpp","rf","vf",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO:libphsh.parabreg",\
    capi_kwlist,&f_capi,&fp_capi,&fpp_capi,&rf_capi,&vf_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable fp */
    f2py_success = double_from_pyobj(&fp,fp_capi,"libphsh.parabreg() 2nd argument (fp) can't be converted to double");
  if (f2py_success) {
  /* Processing variable rf */
  rf_Dims[0]=3;
  capi_rf_intent |= F2PY_INTENT_IN;
  capi_rf_tmp = array_from_pyobj(NPY_DOUBLE,rf_Dims,rf_Rank,capi_rf_intent,rf_capi);
  if (capi_rf_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 4th argument `rf' of libphsh.parabreg to C/Fortran array" );
  } else {
    rf = (double *)(capi_rf_tmp->data);

  /* Processing variable fpp */
    f2py_success = double_from_pyobj(&fpp,fpp_capi,"libphsh.parabreg() 3rd argument (fpp) can't be converted to double");
  if (f2py_success) {
  /* Processing variable vf */
  vf_Dims[0]=3;
  capi_vf_intent |= F2PY_INTENT_IN;
  capi_vf_tmp = array_from_pyobj(NPY_DOUBLE,vf_Dims,vf_Rank,capi_vf_intent,vf_capi);
  if (capi_vf_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 5th argument `vf' of libphsh.parabreg to C/Fortran array" );
  } else {
    vf = (double *)(capi_vf_tmp->data);

  /* Processing variable f */
    f2py_success = double_from_pyobj(&f,f_capi,"libphsh.parabreg() 1st argument (f) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&f,&fp,&fpp,rf,vf);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of f*/
  /* End of cleaning variable f */
  if((PyObject *)capi_vf_tmp!=vf_capi) {
    Py_XDECREF(capi_vf_tmp); }
  }  /*if (capi_vf_tmp == NULL) ... else of vf*/
  /* End of cleaning variable vf */
  } /*if (f2py_success) of fpp*/
  /* End of cleaning variable fpp */
  if((PyObject *)capi_rf_tmp!=rf_capi) {
    Py_XDECREF(capi_rf_tmp); }
  }  /*if (capi_rf_tmp == NULL) ... else of rf*/
  /* End of cleaning variable rf */
  } /*if (f2py_success) of fp*/
  /* End of cleaning variable fp */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of parabreg ******************************/

/************************************* hb *************************************/
static char doc_f2py_rout_libphsh_hb[] = "\
hb = hb(x,factor)\n\nWrapper for ``hb``.\
\n\nParameters\n----------\n"
"x : input float\n"
"factor : input float\n"
"\nReturns\n-------\n"
"hb : float";
/* extern void F_WRAPPEDFUNC(hb,HB)(double*,double*,double*); */
static PyObject *f2py_rout_libphsh_hb(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double hb = 0;
  double x = 0;
  PyObject *x_capi = Py_None;
  double factor = 0;
  PyObject *factor_capi = Py_None;
  static char *capi_kwlist[] = {"x","factor",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO:libphsh.hb",\
    capi_kwlist,&x_capi,&factor_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable hb */
  /* Processing variable x */
    f2py_success = double_from_pyobj(&x,x_capi,"libphsh.hb() 1st argument (x) can't be converted to double");
  if (f2py_success) {
  /* Processing variable factor */
    f2py_success = double_from_pyobj(&factor,factor_capi,"libphsh.hb() 2nd argument (factor) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&hb,&x,&factor);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",hb);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of factor*/
  /* End of cleaning variable factor */
  } /*if (f2py_success) of x*/
  /* End of cleaning variable x */
  /* End of cleaning variable hb */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of hb *********************************/

/*********************************** fitx0 ***********************************/
static char doc_f2py_rout_libphsh_fitx0[] = "\
fitx0(i,orb,rcut,njrc,e,l,xj,n,jrt,xideal,phi,zeff,v,q0,xm1,xm2,nr,r,dr,r2,dl,rel,factor)\n\nWrapper for ``fitx0``.\
\n\nParameters\n----------\n"
"i : input int\n"
"orb : input rank-2 array('d') with bounds (4000,33)\n"
"rcut : input float\n"
"njrc : input rank-1 array('i') with bounds (4)\n"
"e : input float\n"
"l : input int\n"
"xj : input float\n"
"n : input int\n"
"jrt : input int\n"
"xideal : input float\n"
"phi : input rank-1 array('d') with bounds (4000)\n"
"zeff : input float\n"
"v : input rank-1 array('d') with bounds (4000)\n"
"q0 : input rank-1 array('d') with bounds (4000)\n"
"xm1 : input rank-1 array('d') with bounds (4000)\n"
"xm2 : input rank-1 array('d') with bounds (4000)\n"
"nr : input int\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"dr : input rank-1 array('d') with bounds (4000)\n"
"r2 : input rank-1 array('d') with bounds (4000)\n"
"dl : input float\n"
"rel : input float\n"
"factor : input float";
/* extern void F_FUNC(fitx0,FITX0)(int*,double*,double*,int*,double*,int*,double*,int*,int*,double*,double*,double*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_libphsh_fitx0(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,int*,double*,int*,double*,int*,int*,double*,double*,double*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  double *orb = NULL;
  npy_intp orb_Dims[2] = {-1, -1};
  const int orb_Rank = 2;
  PyArrayObject *capi_orb_tmp = NULL;
  int capi_orb_intent = 0;
  PyObject *orb_capi = Py_None;
  double rcut = 0;
  PyObject *rcut_capi = Py_None;
  int *njrc = NULL;
  npy_intp njrc_Dims[1] = {-1};
  const int njrc_Rank = 1;
  PyArrayObject *capi_njrc_tmp = NULL;
  int capi_njrc_intent = 0;
  PyObject *njrc_capi = Py_None;
  double e = 0;
  PyObject *e_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  double xj = 0;
  PyObject *xj_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int jrt = 0;
  PyObject *jrt_capi = Py_None;
  double xideal = 0;
  PyObject *xideal_capi = Py_None;
  double *phi = NULL;
  npy_intp phi_Dims[1] = {-1};
  const int phi_Rank = 1;
  PyArrayObject *capi_phi_tmp = NULL;
  int capi_phi_intent = 0;
  PyObject *phi_capi = Py_None;
  double zeff = 0;
  PyObject *zeff_capi = Py_None;
  double *v = NULL;
  npy_intp v_Dims[1] = {-1};
  const int v_Rank = 1;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
  PyObject *v_capi = Py_None;
  double *q0 = NULL;
  npy_intp q0_Dims[1] = {-1};
  const int q0_Rank = 1;
  PyArrayObject *capi_q0_tmp = NULL;
  int capi_q0_intent = 0;
  PyObject *q0_capi = Py_None;
  double *xm1 = NULL;
  npy_intp xm1_Dims[1] = {-1};
  const int xm1_Rank = 1;
  PyArrayObject *capi_xm1_tmp = NULL;
  int capi_xm1_intent = 0;
  PyObject *xm1_capi = Py_None;
  double *xm2 = NULL;
  npy_intp xm2_Dims[1] = {-1};
  const int xm2_Rank = 1;
  PyArrayObject *capi_xm2_tmp = NULL;
  int capi_xm2_intent = 0;
  PyObject *xm2_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *dr = NULL;
  npy_intp dr_Dims[1] = {-1};
  const int dr_Rank = 1;
  PyArrayObject *capi_dr_tmp = NULL;
  int capi_dr_intent = 0;
  PyObject *dr_capi = Py_None;
  double *r2 = NULL;
  npy_intp r2_Dims[1] = {-1};
  const int r2_Rank = 1;
  PyArrayObject *capi_r2_tmp = NULL;
  int capi_r2_intent = 0;
  PyObject *r2_capi = Py_None;
  double dl = 0;
  PyObject *dl_capi = Py_None;
  double rel = 0;
  PyObject *rel_capi = Py_None;
  double factor = 0;
  PyObject *factor_capi = Py_None;
  static char *capi_kwlist[] = {"i","orb","rcut","njrc","e","l","xj","n","jrt","xideal","phi","zeff","v","q0","xm1","xm2","nr","r","dr","r2","dl","rel","factor",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOOOOOOOOOOOOO:libphsh.fitx0",\
    capi_kwlist,&i_capi,&orb_capi,&rcut_capi,&njrc_capi,&e_capi,&l_capi,&xj_capi,&n_capi,&jrt_capi,&xideal_capi,&phi_capi,&zeff_capi,&v_capi,&q0_capi,&xm1_capi,&xm2_capi,&nr_capi,&r_capi,&dr_capi,&r2_capi,&dl_capi,&rel_capi,&factor_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable xj */
    f2py_success = double_from_pyobj(&xj,xj_capi,"libphsh.fitx0() 7th argument (xj) can't be converted to double");
  if (f2py_success) {
  /* Processing variable rcut */
    f2py_success = double_from_pyobj(&rcut,rcut_capi,"libphsh.fitx0() 3rd argument (rcut) can't be converted to double");
  if (f2py_success) {
  /* Processing variable jrt */
    f2py_success = int_from_pyobj(&jrt,jrt_capi,"libphsh.fitx0() 9th argument (jrt) can't be converted to int");
  if (f2py_success) {
  /* Processing variable xideal */
    f2py_success = double_from_pyobj(&xideal,xideal_capi,"libphsh.fitx0() 10th argument (xideal) can't be converted to double");
  if (f2py_success) {
  /* Processing variable q0 */
  q0_Dims[0]=4000;
  capi_q0_intent |= F2PY_INTENT_IN;
  capi_q0_tmp = array_from_pyobj(NPY_DOUBLE,q0_Dims,q0_Rank,capi_q0_intent,q0_capi);
  if (capi_q0_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 14th argument `q0' of libphsh.fitx0 to C/Fortran array" );
  } else {
    q0 = (double *)(capi_q0_tmp->data);

  /* Processing variable zeff */
    f2py_success = double_from_pyobj(&zeff,zeff_capi,"libphsh.fitx0() 12nd argument (zeff) can't be converted to double");
  if (f2py_success) {
  /* Processing variable orb */
  orb_Dims[0]=4000,orb_Dims[1]=33;
  capi_orb_intent |= F2PY_INTENT_IN;
  capi_orb_tmp = array_from_pyobj(NPY_DOUBLE,orb_Dims,orb_Rank,capi_orb_intent,orb_capi);
  if (capi_orb_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `orb' of libphsh.fitx0 to C/Fortran array" );
  } else {
    orb = (double *)(capi_orb_tmp->data);

  /* Processing variable phi */
  phi_Dims[0]=4000;
  capi_phi_intent |= F2PY_INTENT_IN;
  capi_phi_tmp = array_from_pyobj(NPY_DOUBLE,phi_Dims,phi_Rank,capi_phi_intent,phi_capi);
  if (capi_phi_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 11st argument `phi' of libphsh.fitx0 to C/Fortran array" );
  } else {
    phi = (double *)(capi_phi_tmp->data);

  /* Processing variable rel */
    f2py_success = double_from_pyobj(&rel,rel_capi,"libphsh.fitx0() 22nd argument (rel) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.fitx0() 17th argument (nr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable dl */
    f2py_success = double_from_pyobj(&dl,dl_capi,"libphsh.fitx0() 21st argument (dl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable factor */
    f2py_success = double_from_pyobj(&factor,factor_capi,"libphsh.fitx0() 23rd argument (factor) can't be converted to double");
  if (f2py_success) {
  /* Processing variable njrc */
  njrc_Dims[0]=4;
  capi_njrc_intent |= F2PY_INTENT_IN;
  capi_njrc_tmp = array_from_pyobj(NPY_INT,njrc_Dims,njrc_Rank,capi_njrc_intent,njrc_capi);
  if (capi_njrc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 4th argument `njrc' of libphsh.fitx0 to C/Fortran array" );
  } else {
    njrc = (int *)(capi_njrc_tmp->data);

  /* Processing variable dr */
  dr_Dims[0]=4000;
  capi_dr_intent |= F2PY_INTENT_IN;
  capi_dr_tmp = array_from_pyobj(NPY_DOUBLE,dr_Dims,dr_Rank,capi_dr_intent,dr_capi);
  if (capi_dr_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 19th argument `dr' of libphsh.fitx0 to C/Fortran array" );
  } else {
    dr = (double *)(capi_dr_tmp->data);

  /* Processing variable e */
    f2py_success = double_from_pyobj(&e,e_capi,"libphsh.fitx0() 5th argument (e) can't be converted to double");
  if (f2py_success) {
  /* Processing variable r2 */
  r2_Dims[0]=4000;
  capi_r2_intent |= F2PY_INTENT_IN;
  capi_r2_tmp = array_from_pyobj(NPY_DOUBLE,r2_Dims,r2_Rank,capi_r2_intent,r2_capi);
  if (capi_r2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 20th argument `r2' of libphsh.fitx0 to C/Fortran array" );
  } else {
    r2 = (double *)(capi_r2_tmp->data);

  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"libphsh.fitx0() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable l */
    f2py_success = int_from_pyobj(&l,l_capi,"libphsh.fitx0() 6th argument (l) can't be converted to int");
  if (f2py_success) {
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"libphsh.fitx0() 8th argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 18th argument `r' of libphsh.fitx0 to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

  /* Processing variable v */
  v_Dims[0]=4000;
  capi_v_intent |= F2PY_INTENT_IN;
  capi_v_tmp = array_from_pyobj(NPY_DOUBLE,v_Dims,v_Rank,capi_v_intent,v_capi);
  if (capi_v_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 13rd argument `v' of libphsh.fitx0 to C/Fortran array" );
  } else {
    v = (double *)(capi_v_tmp->data);

  /* Processing variable xm1 */
  xm1_Dims[0]=4000;
  capi_xm1_intent |= F2PY_INTENT_IN;
  capi_xm1_tmp = array_from_pyobj(NPY_DOUBLE,xm1_Dims,xm1_Rank,capi_xm1_intent,xm1_capi);
  if (capi_xm1_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 15th argument `xm1' of libphsh.fitx0 to C/Fortran array" );
  } else {
    xm1 = (double *)(capi_xm1_tmp->data);

  /* Processing variable xm2 */
  xm2_Dims[0]=4000;
  capi_xm2_intent |= F2PY_INTENT_IN;
  capi_xm2_tmp = array_from_pyobj(NPY_DOUBLE,xm2_Dims,xm2_Rank,capi_xm2_intent,xm2_capi);
  if (capi_xm2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 16th argument `xm2' of libphsh.fitx0 to C/Fortran array" );
  } else {
    xm2 = (double *)(capi_xm2_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,orb,&rcut,njrc,&e,&l,&xj,&n,&jrt,&xideal,phi,&zeff,v,q0,xm1,xm2,&nr,r,dr,r2,&dl,&rel,&factor);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_xm2_tmp!=xm2_capi) {
    Py_XDECREF(capi_xm2_tmp); }
  }  /*if (capi_xm2_tmp == NULL) ... else of xm2*/
  /* End of cleaning variable xm2 */
  if((PyObject *)capi_xm1_tmp!=xm1_capi) {
    Py_XDECREF(capi_xm1_tmp); }
  }  /*if (capi_xm1_tmp == NULL) ... else of xm1*/
  /* End of cleaning variable xm1 */
  if((PyObject *)capi_v_tmp!=v_capi) {
    Py_XDECREF(capi_v_tmp); }
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
  if((PyObject *)capi_r2_tmp!=r2_capi) {
    Py_XDECREF(capi_r2_tmp); }
  }  /*if (capi_r2_tmp == NULL) ... else of r2*/
  /* End of cleaning variable r2 */
  } /*if (f2py_success) of e*/
  /* End of cleaning variable e */
  if((PyObject *)capi_dr_tmp!=dr_capi) {
    Py_XDECREF(capi_dr_tmp); }
  }  /*if (capi_dr_tmp == NULL) ... else of dr*/
  /* End of cleaning variable dr */
  if((PyObject *)capi_njrc_tmp!=njrc_capi) {
    Py_XDECREF(capi_njrc_tmp); }
  }  /*if (capi_njrc_tmp == NULL) ... else of njrc*/
  /* End of cleaning variable njrc */
  } /*if (f2py_success) of factor*/
  /* End of cleaning variable factor */
  } /*if (f2py_success) of dl*/
  /* End of cleaning variable dl */
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of rel*/
  /* End of cleaning variable rel */
  if((PyObject *)capi_phi_tmp!=phi_capi) {
    Py_XDECREF(capi_phi_tmp); }
  }  /*if (capi_phi_tmp == NULL) ... else of phi*/
  /* End of cleaning variable phi */
  if((PyObject *)capi_orb_tmp!=orb_capi) {
    Py_XDECREF(capi_orb_tmp); }
  }  /*if (capi_orb_tmp == NULL) ... else of orb*/
  /* End of cleaning variable orb */
  } /*if (f2py_success) of zeff*/
  /* End of cleaning variable zeff */
  if((PyObject *)capi_q0_tmp!=q0_capi) {
    Py_XDECREF(capi_q0_tmp); }
  }  /*if (capi_q0_tmp == NULL) ... else of q0*/
  /* End of cleaning variable q0 */
  } /*if (f2py_success) of xideal*/
  /* End of cleaning variable xideal */
  } /*if (f2py_success) of jrt*/
  /* End of cleaning variable jrt */
  } /*if (f2py_success) of rcut*/
  /* End of cleaning variable rcut */
  } /*if (f2py_success) of xj*/
  /* End of cleaning variable xj */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of fitx0 ********************************/

/********************************** pseudize **********************************/
static char doc_f2py_rout_libphsh_pseudize[] = "\
pseudize(i,orb,ev,l,xj,n,njrc,zeff,v,q0,xm1,xm2,nr,rmin,rmax,r,dr,r2,dl,rel)\n\nWrapper for ``pseudize``.\
\n\nParameters\n----------\n"
"i : input int\n"
"orb : input rank-2 array('d') with bounds (4000,33)\n"
"ev : input float\n"
"l : input int\n"
"xj : input float\n"
"n : input int\n"
"njrc : input rank-1 array('i') with bounds (4)\n"
"zeff : input float\n"
"v : input rank-1 array('d') with bounds (4000)\n"
"q0 : input rank-1 array('d') with bounds (4000)\n"
"xm1 : input rank-1 array('d') with bounds (4000)\n"
"xm2 : input rank-1 array('d') with bounds (4000)\n"
"nr : input int\n"
"rmin : input float\n"
"rmax : input float\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"dr : input rank-1 array('d') with bounds (4000)\n"
"r2 : input rank-1 array('d') with bounds (4000)\n"
"dl : input float\n"
"rel : input float";
/* extern void F_FUNC(pseudize,PSEUDIZE)(int*,double*,double*,int*,double*,int*,int*,double*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_libphsh_pseudize(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,int*,double*,int*,int*,double*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  double *orb = NULL;
  npy_intp orb_Dims[2] = {-1, -1};
  const int orb_Rank = 2;
  PyArrayObject *capi_orb_tmp = NULL;
  int capi_orb_intent = 0;
  PyObject *orb_capi = Py_None;
  double ev = 0;
  PyObject *ev_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  double xj = 0;
  PyObject *xj_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int *njrc = NULL;
  npy_intp njrc_Dims[1] = {-1};
  const int njrc_Rank = 1;
  PyArrayObject *capi_njrc_tmp = NULL;
  int capi_njrc_intent = 0;
  PyObject *njrc_capi = Py_None;
  double zeff = 0;
  PyObject *zeff_capi = Py_None;
  double *v = NULL;
  npy_intp v_Dims[1] = {-1};
  const int v_Rank = 1;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
  PyObject *v_capi = Py_None;
  double *q0 = NULL;
  npy_intp q0_Dims[1] = {-1};
  const int q0_Rank = 1;
  PyArrayObject *capi_q0_tmp = NULL;
  int capi_q0_intent = 0;
  PyObject *q0_capi = Py_None;
  double *xm1 = NULL;
  npy_intp xm1_Dims[1] = {-1};
  const int xm1_Rank = 1;
  PyArrayObject *capi_xm1_tmp = NULL;
  int capi_xm1_intent = 0;
  PyObject *xm1_capi = Py_None;
  double *xm2 = NULL;
  npy_intp xm2_Dims[1] = {-1};
  const int xm2_Rank = 1;
  PyArrayObject *capi_xm2_tmp = NULL;
  int capi_xm2_intent = 0;
  PyObject *xm2_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  double rmin = 0;
  PyObject *rmin_capi = Py_None;
  double rmax = 0;
  PyObject *rmax_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *dr = NULL;
  npy_intp dr_Dims[1] = {-1};
  const int dr_Rank = 1;
  PyArrayObject *capi_dr_tmp = NULL;
  int capi_dr_intent = 0;
  PyObject *dr_capi = Py_None;
  double *r2 = NULL;
  npy_intp r2_Dims[1] = {-1};
  const int r2_Rank = 1;
  PyArrayObject *capi_r2_tmp = NULL;
  int capi_r2_intent = 0;
  PyObject *r2_capi = Py_None;
  double dl = 0;
  PyObject *dl_capi = Py_None;
  double rel = 0;
  PyObject *rel_capi = Py_None;
  static char *capi_kwlist[] = {"i","orb","ev","l","xj","n","njrc","zeff","v","q0","xm1","xm2","nr","rmin","rmax","r","dr","r2","dl","rel",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOOOOOOOOOO:libphsh.pseudize",\
    capi_kwlist,&i_capi,&orb_capi,&ev_capi,&l_capi,&xj_capi,&n_capi,&njrc_capi,&zeff_capi,&v_capi,&q0_capi,&xm1_capi,&xm2_capi,&nr_capi,&rmin_capi,&rmax_capi,&r_capi,&dr_capi,&r2_capi,&dl_capi,&rel_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable xj */
    f2py_success = double_from_pyobj(&xj,xj_capi,"libphsh.pseudize() 5th argument (xj) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ev */
    f2py_success = double_from_pyobj(&ev,ev_capi,"libphsh.pseudize() 3rd argument (ev) can't be converted to double");
  if (f2py_success) {
  /* Processing variable q0 */
  q0_Dims[0]=4000;
  capi_q0_intent |= F2PY_INTENT_IN;
  capi_q0_tmp = array_from_pyobj(NPY_DOUBLE,q0_Dims,q0_Rank,capi_q0_intent,q0_capi);
  if (capi_q0_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 10th argument `q0' of libphsh.pseudize to C/Fortran array" );
  } else {
    q0 = (double *)(capi_q0_tmp->data);

  /* Processing variable rmin */
    f2py_success = double_from_pyobj(&rmin,rmin_capi,"libphsh.pseudize() 14th argument (rmin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable dr */
  dr_Dims[0]=4000;
  capi_dr_intent |= F2PY_INTENT_IN;
  capi_dr_tmp = array_from_pyobj(NPY_DOUBLE,dr_Dims,dr_Rank,capi_dr_intent,dr_capi);
  if (capi_dr_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 17th argument `dr' of libphsh.pseudize to C/Fortran array" );
  } else {
    dr = (double *)(capi_dr_tmp->data);

  /* Processing variable rel */
    f2py_success = double_from_pyobj(&rel,rel_capi,"libphsh.pseudize() 20th argument (rel) can't be converted to double");
  if (f2py_success) {
  /* Processing variable zeff */
    f2py_success = double_from_pyobj(&zeff,zeff_capi,"libphsh.pseudize() 8th argument (zeff) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.pseudize() 13rd argument (nr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable rmax */
    f2py_success = double_from_pyobj(&rmax,rmax_capi,"libphsh.pseudize() 15th argument (rmax) can't be converted to double");
  if (f2py_success) {
  /* Processing variable njrc */
  njrc_Dims[0]=4;
  capi_njrc_intent |= F2PY_INTENT_IN;
  capi_njrc_tmp = array_from_pyobj(NPY_INT,njrc_Dims,njrc_Rank,capi_njrc_intent,njrc_capi);
  if (capi_njrc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 7th argument `njrc' of libphsh.pseudize to C/Fortran array" );
  } else {
    njrc = (int *)(capi_njrc_tmp->data);

  /* Processing variable orb */
  orb_Dims[0]=4000,orb_Dims[1]=33;
  capi_orb_intent |= F2PY_INTENT_IN;
  capi_orb_tmp = array_from_pyobj(NPY_DOUBLE,orb_Dims,orb_Rank,capi_orb_intent,orb_capi);
  if (capi_orb_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `orb' of libphsh.pseudize to C/Fortran array" );
  } else {
    orb = (double *)(capi_orb_tmp->data);

  /* Processing variable dl */
    f2py_success = double_from_pyobj(&dl,dl_capi,"libphsh.pseudize() 19th argument (dl) can't be converted to double");
  if (f2py_success) {
  /* Processing variable r2 */
  r2_Dims[0]=4000;
  capi_r2_intent |= F2PY_INTENT_IN;
  capi_r2_tmp = array_from_pyobj(NPY_DOUBLE,r2_Dims,r2_Rank,capi_r2_intent,r2_capi);
  if (capi_r2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 18th argument `r2' of libphsh.pseudize to C/Fortran array" );
  } else {
    r2 = (double *)(capi_r2_tmp->data);

  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"libphsh.pseudize() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable l */
    f2py_success = int_from_pyobj(&l,l_capi,"libphsh.pseudize() 4th argument (l) can't be converted to int");
  if (f2py_success) {
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"libphsh.pseudize() 6th argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 16th argument `r' of libphsh.pseudize to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

  /* Processing variable v */
  v_Dims[0]=4000;
  capi_v_intent |= F2PY_INTENT_IN;
  capi_v_tmp = array_from_pyobj(NPY_DOUBLE,v_Dims,v_Rank,capi_v_intent,v_capi);
  if (capi_v_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 9th argument `v' of libphsh.pseudize to C/Fortran array" );
  } else {
    v = (double *)(capi_v_tmp->data);

  /* Processing variable xm1 */
  xm1_Dims[0]=4000;
  capi_xm1_intent |= F2PY_INTENT_IN;
  capi_xm1_tmp = array_from_pyobj(NPY_DOUBLE,xm1_Dims,xm1_Rank,capi_xm1_intent,xm1_capi);
  if (capi_xm1_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 11st argument `xm1' of libphsh.pseudize to C/Fortran array" );
  } else {
    xm1 = (double *)(capi_xm1_tmp->data);

  /* Processing variable xm2 */
  xm2_Dims[0]=4000;
  capi_xm2_intent |= F2PY_INTENT_IN;
  capi_xm2_tmp = array_from_pyobj(NPY_DOUBLE,xm2_Dims,xm2_Rank,capi_xm2_intent,xm2_capi);
  if (capi_xm2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 12nd argument `xm2' of libphsh.pseudize to C/Fortran array" );
  } else {
    xm2 = (double *)(capi_xm2_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,orb,&ev,&l,&xj,&n,njrc,&zeff,v,q0,xm1,xm2,&nr,&rmin,&rmax,r,dr,r2,&dl,&rel);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_xm2_tmp!=xm2_capi) {
    Py_XDECREF(capi_xm2_tmp); }
  }  /*if (capi_xm2_tmp == NULL) ... else of xm2*/
  /* End of cleaning variable xm2 */
  if((PyObject *)capi_xm1_tmp!=xm1_capi) {
    Py_XDECREF(capi_xm1_tmp); }
  }  /*if (capi_xm1_tmp == NULL) ... else of xm1*/
  /* End of cleaning variable xm1 */
  if((PyObject *)capi_v_tmp!=v_capi) {
    Py_XDECREF(capi_v_tmp); }
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
  if((PyObject *)capi_r2_tmp!=r2_capi) {
    Py_XDECREF(capi_r2_tmp); }
  }  /*if (capi_r2_tmp == NULL) ... else of r2*/
  /* End of cleaning variable r2 */
  } /*if (f2py_success) of dl*/
  /* End of cleaning variable dl */
  if((PyObject *)capi_orb_tmp!=orb_capi) {
    Py_XDECREF(capi_orb_tmp); }
  }  /*if (capi_orb_tmp == NULL) ... else of orb*/
  /* End of cleaning variable orb */
  if((PyObject *)capi_njrc_tmp!=njrc_capi) {
    Py_XDECREF(capi_njrc_tmp); }
  }  /*if (capi_njrc_tmp == NULL) ... else of njrc*/
  /* End of cleaning variable njrc */
  } /*if (f2py_success) of rmax*/
  /* End of cleaning variable rmax */
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of zeff*/
  /* End of cleaning variable zeff */
  } /*if (f2py_success) of rel*/
  /* End of cleaning variable rel */
  if((PyObject *)capi_dr_tmp!=dr_capi) {
    Py_XDECREF(capi_dr_tmp); }
  }  /*if (capi_dr_tmp == NULL) ... else of dr*/
  /* End of cleaning variable dr */
  } /*if (f2py_success) of rmin*/
  /* End of cleaning variable rmin */
  if((PyObject *)capi_q0_tmp!=q0_capi) {
    Py_XDECREF(capi_q0_tmp); }
  }  /*if (capi_q0_tmp == NULL) ... else of q0*/
  /* End of cleaning variable q0 */
  } /*if (f2py_success) of ev*/
  /* End of cleaning variable ev */
  } /*if (f2py_success) of xj*/
  /* End of cleaning variable xj */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of pseudize ******************************/

/********************************** fourier **********************************/
static char doc_f2py_rout_libphsh_fourier[] = "\
fourier(nr,r,dr,r2,vi)\n\nWrapper for ``fourier``.\
\n\nParameters\n----------\n"
"nr : input int\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"dr : input rank-1 array('d') with bounds (4000)\n"
"r2 : input rank-1 array('d') with bounds (4000)\n"
"vi : input rank-2 array('d') with bounds (4000,7)";
/* extern void F_FUNC(fourier,FOURIER)(int*,double*,double*,double*,double*); */
static PyObject *f2py_rout_libphsh_fourier(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nr = 0;
  PyObject *nr_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *dr = NULL;
  npy_intp dr_Dims[1] = {-1};
  const int dr_Rank = 1;
  PyArrayObject *capi_dr_tmp = NULL;
  int capi_dr_intent = 0;
  PyObject *dr_capi = Py_None;
  double *r2 = NULL;
  npy_intp r2_Dims[1] = {-1};
  const int r2_Rank = 1;
  PyArrayObject *capi_r2_tmp = NULL;
  int capi_r2_intent = 0;
  PyObject *r2_capi = Py_None;
  double *vi = NULL;
  npy_intp vi_Dims[2] = {-1, -1};
  const int vi_Rank = 2;
  PyArrayObject *capi_vi_tmp = NULL;
  int capi_vi_intent = 0;
  PyObject *vi_capi = Py_None;
  static char *capi_kwlist[] = {"nr","r","dr","r2","vi",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO:libphsh.fourier",\
    capi_kwlist,&nr_capi,&r_capi,&dr_capi,&r2_capi,&vi_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable vi */
  vi_Dims[0]=4000,vi_Dims[1]=7;
  capi_vi_intent |= F2PY_INTENT_IN;
  capi_vi_tmp = array_from_pyobj(NPY_DOUBLE,vi_Dims,vi_Rank,capi_vi_intent,vi_capi);
  if (capi_vi_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 5th argument `vi' of libphsh.fourier to C/Fortran array" );
  } else {
    vi = (double *)(capi_vi_tmp->data);

  /* Processing variable dr */
  dr_Dims[0]=4000;
  capi_dr_intent |= F2PY_INTENT_IN;
  capi_dr_tmp = array_from_pyobj(NPY_DOUBLE,dr_Dims,dr_Rank,capi_dr_intent,dr_capi);
  if (capi_dr_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 3rd argument `dr' of libphsh.fourier to C/Fortran array" );
  } else {
    dr = (double *)(capi_dr_tmp->data);

  /* Processing variable r2 */
  r2_Dims[0]=4000;
  capi_r2_intent |= F2PY_INTENT_IN;
  capi_r2_tmp = array_from_pyobj(NPY_DOUBLE,r2_Dims,r2_Rank,capi_r2_intent,r2_capi);
  if (capi_r2_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 4th argument `r2' of libphsh.fourier to C/Fortran array" );
  } else {
    r2 = (double *)(capi_r2_tmp->data);

  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `r' of libphsh.fourier to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.fourier() 1st argument (nr) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nr,r,dr,r2,vi);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  if((PyObject *)capi_r2_tmp!=r2_capi) {
    Py_XDECREF(capi_r2_tmp); }
  }  /*if (capi_r2_tmp == NULL) ... else of r2*/
  /* End of cleaning variable r2 */
  if((PyObject *)capi_dr_tmp!=dr_capi) {
    Py_XDECREF(capi_dr_tmp); }
  }  /*if (capi_dr_tmp == NULL) ... else of dr*/
  /* End of cleaning variable dr */
  if((PyObject *)capi_vi_tmp!=vi_capi) {
    Py_XDECREF(capi_vi_tmp); }
  }  /*if (capi_vi_tmp == NULL) ... else of vi*/
  /* End of cleaning variable vi */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of fourier *******************************/

/********************************** GETILLLS **********************************/
static char doc_f2py_rout_libphsh_GETILLLS[] = "\
GETILLLS(PIN)\n\nWrapper for ``GETILLLS``.\
\n\nParameters\n----------\n"
"PIN : input rank-3 array('d') with bounds (9,9,17)";
/* extern void F_FUNC(GETILLLS,GETILLLS)(double*); */
static PyObject *f2py_rout_libphsh_GETILLLS(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *PIN = NULL;
  npy_intp PIN_Dims[3] = {-1, -1, -1};
  const int PIN_Rank = 3;
  PyArrayObject *capi_PIN_tmp = NULL;
  int capi_PIN_intent = 0;
  PyObject *PIN_capi = Py_None;
  static char *capi_kwlist[] = {"PIN",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:libphsh.GETILLLS",\
    capi_kwlist,&PIN_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable PIN */
  PIN_Dims[0]=9,PIN_Dims[1]=9,PIN_Dims[2]=17;
  capi_PIN_intent |= F2PY_INTENT_IN;
  capi_PIN_tmp = array_from_pyobj(NPY_DOUBLE,PIN_Dims,PIN_Rank,capi_PIN_intent,PIN_capi);
  if (capi_PIN_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `PIN' of libphsh.GETILLLS to C/Fortran array" );
  } else {
    PIN = (double *)(capi_PIN_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(PIN);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_PIN_tmp!=PIN_capi) {
    Py_XDECREF(capi_PIN_tmp); }
  }  /*if (capi_PIN_tmp == NULL) ... else of PIN*/
  /* End of cleaning variable PIN */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of GETILLLS ******************************/

/*********************************** hfdisk ***********************************/
static char doc_f2py_rout_libphsh_hfdisk[] = "\
hfdisk(iu,ir,etot,nst,rel,nr,rmin,rmax,r,rho,zorig,xntot,ixflag,nel,no,nl,xnj,is,ev,ek,occ,njrc,vi,phe,orb)\n\nWrapper for ``hfdisk``.\
\n\nParameters\n----------\n"
"iu : input int\n"
"ir : input int\n"
"etot : input float\n"
"nst : input int\n"
"rel : input float\n"
"nr : input int\n"
"rmin : input float\n"
"rmax : input float\n"
"r : input rank-1 array('d') with bounds (4000)\n"
"rho : input rank-1 array('d') with bounds (4000)\n"
"zorig : input float\n"
"xntot : input float\n"
"ixflag : input int\n"
"nel : input int\n"
"no : input rank-1 array('i') with bounds (33)\n"
"nl : input rank-1 array('i') with bounds (33)\n"
"xnj : input rank-1 array('d') with bounds (33)\n"
"is : input rank-1 array('i') with bounds (33)\n"
"ev : input rank-1 array('d') with bounds (33)\n"
"ek : input rank-1 array('d') with bounds (33)\n"
"occ : input rank-1 array('d') with bounds (33)\n"
"njrc : input rank-1 array('i') with bounds (4)\n"
"vi : input rank-2 array('d') with bounds (4000,7)\n"
"phe : input rank-2 array('d') with bounds (4000,33)\n"
"orb : input rank-2 array('d') with bounds (4000,33)";
/* extern void F_FUNC(hfdisk,HFDISK)(int*,int*,double*,int*,double*,int*,double*,double*,double*,double*,double*,double*,int*,int*,int*,int*,double*,int*,double*,double*,double*,int*,double*,double*,double*); */
static PyObject *f2py_rout_libphsh_hfdisk(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,int*,double*,int*,double*,double*,double*,double*,double*,double*,int*,int*,int*,int*,double*,int*,double*,double*,double*,int*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int iu = 0;
  PyObject *iu_capi = Py_None;
  int ir = 0;
  PyObject *ir_capi = Py_None;
  double etot = 0;
  PyObject *etot_capi = Py_None;
  int nst = 0;
  PyObject *nst_capi = Py_None;
  double rel = 0;
  PyObject *rel_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  double rmin = 0;
  PyObject *rmin_capi = Py_None;
  double rmax = 0;
  PyObject *rmax_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *rho = NULL;
  npy_intp rho_Dims[1] = {-1};
  const int rho_Rank = 1;
  PyArrayObject *capi_rho_tmp = NULL;
  int capi_rho_intent = 0;
  PyObject *rho_capi = Py_None;
  double zorig = 0;
  PyObject *zorig_capi = Py_None;
  double xntot = 0;
  PyObject *xntot_capi = Py_None;
  int ixflag = 0;
  PyObject *ixflag_capi = Py_None;
  int nel = 0;
  PyObject *nel_capi = Py_None;
  int *no = NULL;
  npy_intp no_Dims[1] = {-1};
  const int no_Rank = 1;
  PyArrayObject *capi_no_tmp = NULL;
  int capi_no_intent = 0;
  PyObject *no_capi = Py_None;
  int *nl = NULL;
  npy_intp nl_Dims[1] = {-1};
  const int nl_Rank = 1;
  PyArrayObject *capi_nl_tmp = NULL;
  int capi_nl_intent = 0;
  PyObject *nl_capi = Py_None;
  double *xnj = NULL;
  npy_intp xnj_Dims[1] = {-1};
  const int xnj_Rank = 1;
  PyArrayObject *capi_xnj_tmp = NULL;
  int capi_xnj_intent = 0;
  PyObject *xnj_capi = Py_None;
  int *is = NULL;
  npy_intp is_Dims[1] = {-1};
  const int is_Rank = 1;
  PyArrayObject *capi_is_tmp = NULL;
  int capi_is_intent = 0;
  PyObject *is_capi = Py_None;
  double *ev = NULL;
  npy_intp ev_Dims[1] = {-1};
  const int ev_Rank = 1;
  PyArrayObject *capi_ev_tmp = NULL;
  int capi_ev_intent = 0;
  PyObject *ev_capi = Py_None;
  double *ek = NULL;
  npy_intp ek_Dims[1] = {-1};
  const int ek_Rank = 1;
  PyArrayObject *capi_ek_tmp = NULL;
  int capi_ek_intent = 0;
  PyObject *ek_capi = Py_None;
  double *occ = NULL;
  npy_intp occ_Dims[1] = {-1};
  const int occ_Rank = 1;
  PyArrayObject *capi_occ_tmp = NULL;
  int capi_occ_intent = 0;
  PyObject *occ_capi = Py_None;
  int *njrc = NULL;
  npy_intp njrc_Dims[1] = {-1};
  const int njrc_Rank = 1;
  PyArrayObject *capi_njrc_tmp = NULL;
  int capi_njrc_intent = 0;
  PyObject *njrc_capi = Py_None;
  double *vi = NULL;
  npy_intp vi_Dims[2] = {-1, -1};
  const int vi_Rank = 2;
  PyArrayObject *capi_vi_tmp = NULL;
  int capi_vi_intent = 0;
  PyObject *vi_capi = Py_None;
  double *phe = NULL;
  npy_intp phe_Dims[2] = {-1, -1};
  const int phe_Rank = 2;
  PyArrayObject *capi_phe_tmp = NULL;
  int capi_phe_intent = 0;
  PyObject *phe_capi = Py_None;
  double *orb = NULL;
  npy_intp orb_Dims[2] = {-1, -1};
  const int orb_Rank = 2;
  PyArrayObject *capi_orb_tmp = NULL;
  int capi_orb_intent = 0;
  PyObject *orb_capi = Py_None;
  static char *capi_kwlist[] = {"iu","ir","etot","nst","rel","nr","rmin","rmax","r","rho","zorig","xntot","ixflag","nel","no","nl","xnj","is","ev","ek","occ","njrc","vi","phe","orb",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOOOOOOOOOOOOOOO:libphsh.hfdisk",\
    capi_kwlist,&iu_capi,&ir_capi,&etot_capi,&nst_capi,&rel_capi,&nr_capi,&rmin_capi,&rmax_capi,&r_capi,&rho_capi,&zorig_capi,&xntot_capi,&ixflag_capi,&nel_capi,&no_capi,&nl_capi,&xnj_capi,&is_capi,&ev_capi,&ek_capi,&occ_capi,&njrc_capi,&vi_capi,&phe_capi,&orb_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable ek */
  ek_Dims[0]=33;
  capi_ek_intent |= F2PY_INTENT_IN;
  capi_ek_tmp = array_from_pyobj(NPY_DOUBLE,ek_Dims,ek_Rank,capi_ek_intent,ek_capi);
  if (capi_ek_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 20th argument `ek' of libphsh.hfdisk to C/Fortran array" );
  } else {
    ek = (double *)(capi_ek_tmp->data);

  /* Processing variable vi */
  vi_Dims[0]=4000,vi_Dims[1]=7;
  capi_vi_intent |= F2PY_INTENT_IN;
  capi_vi_tmp = array_from_pyobj(NPY_DOUBLE,vi_Dims,vi_Rank,capi_vi_intent,vi_capi);
  if (capi_vi_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 23rd argument `vi' of libphsh.hfdisk to C/Fortran array" );
  } else {
    vi = (double *)(capi_vi_tmp->data);

  /* Processing variable is */
  is_Dims[0]=33;
  capi_is_intent |= F2PY_INTENT_IN;
  capi_is_tmp = array_from_pyobj(NPY_INT,is_Dims,is_Rank,capi_is_intent,is_capi);
  if (capi_is_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 18th argument `is' of libphsh.hfdisk to C/Fortran array" );
  } else {
    is = (int *)(capi_is_tmp->data);

  /* Processing variable ir */
    f2py_success = int_from_pyobj(&ir,ir_capi,"libphsh.hfdisk() 2nd argument (ir) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iu */
    f2py_success = int_from_pyobj(&iu,iu_capi,"libphsh.hfdisk() 1st argument (iu) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ev */
  ev_Dims[0]=33;
  capi_ev_intent |= F2PY_INTENT_IN;
  capi_ev_tmp = array_from_pyobj(NPY_DOUBLE,ev_Dims,ev_Rank,capi_ev_intent,ev_capi);
  if (capi_ev_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 19th argument `ev' of libphsh.hfdisk to C/Fortran array" );
  } else {
    ev = (double *)(capi_ev_tmp->data);

  /* Processing variable nst */
    f2py_success = int_from_pyobj(&nst,nst_capi,"libphsh.hfdisk() 4th argument (nst) can't be converted to int");
  if (f2py_success) {
  /* Processing variable rmin */
    f2py_success = double_from_pyobj(&rmin,rmin_capi,"libphsh.hfdisk() 7th argument (rmin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nl */
  nl_Dims[0]=33;
  capi_nl_intent |= F2PY_INTENT_IN;
  capi_nl_tmp = array_from_pyobj(NPY_INT,nl_Dims,nl_Rank,capi_nl_intent,nl_capi);
  if (capi_nl_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 16th argument `nl' of libphsh.hfdisk to C/Fortran array" );
  } else {
    nl = (int *)(capi_nl_tmp->data);

  /* Processing variable xntot */
    f2py_success = double_from_pyobj(&xntot,xntot_capi,"libphsh.hfdisk() 12nd argument (xntot) can't be converted to double");
  if (f2py_success) {
  /* Processing variable no */
  no_Dims[0]=33;
  capi_no_intent |= F2PY_INTENT_IN;
  capi_no_tmp = array_from_pyobj(NPY_INT,no_Dims,no_Rank,capi_no_intent,no_capi);
  if (capi_no_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 15th argument `no' of libphsh.hfdisk to C/Fortran array" );
  } else {
    no = (int *)(capi_no_tmp->data);

  /* Processing variable rel */
    f2py_success = double_from_pyobj(&rel,rel_capi,"libphsh.hfdisk() 5th argument (rel) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"libphsh.hfdisk() 6th argument (nr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable etot */
    f2py_success = double_from_pyobj(&etot,etot_capi,"libphsh.hfdisk() 3rd argument (etot) can't be converted to double");
  if (f2py_success) {
  /* Processing variable rmax */
    f2py_success = double_from_pyobj(&rmax,rmax_capi,"libphsh.hfdisk() 8th argument (rmax) can't be converted to double");
  if (f2py_success) {
  /* Processing variable zorig */
    f2py_success = double_from_pyobj(&zorig,zorig_capi,"libphsh.hfdisk() 11st argument (zorig) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nel */
    f2py_success = int_from_pyobj(&nel,nel_capi,"libphsh.hfdisk() 14th argument (nel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable phe */
  phe_Dims[0]=4000,phe_Dims[1]=33;
  capi_phe_intent |= F2PY_INTENT_IN;
  capi_phe_tmp = array_from_pyobj(NPY_DOUBLE,phe_Dims,phe_Rank,capi_phe_intent,phe_capi);
  if (capi_phe_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 24th argument `phe' of libphsh.hfdisk to C/Fortran array" );
  } else {
    phe = (double *)(capi_phe_tmp->data);

  /* Processing variable njrc */
  njrc_Dims[0]=4;
  capi_njrc_intent |= F2PY_INTENT_IN;
  capi_njrc_tmp = array_from_pyobj(NPY_INT,njrc_Dims,njrc_Rank,capi_njrc_intent,njrc_capi);
  if (capi_njrc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 22nd argument `njrc' of libphsh.hfdisk to C/Fortran array" );
  } else {
    njrc = (int *)(capi_njrc_tmp->data);

  /* Processing variable rho */
  rho_Dims[0]=4000;
  capi_rho_intent |= F2PY_INTENT_IN;
  capi_rho_tmp = array_from_pyobj(NPY_DOUBLE,rho_Dims,rho_Rank,capi_rho_intent,rho_capi);
  if (capi_rho_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 10th argument `rho' of libphsh.hfdisk to C/Fortran array" );
  } else {
    rho = (double *)(capi_rho_tmp->data);

  /* Processing variable orb */
  orb_Dims[0]=4000,orb_Dims[1]=33;
  capi_orb_intent |= F2PY_INTENT_IN;
  capi_orb_tmp = array_from_pyobj(NPY_DOUBLE,orb_Dims,orb_Rank,capi_orb_intent,orb_capi);
  if (capi_orb_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 25th argument `orb' of libphsh.hfdisk to C/Fortran array" );
  } else {
    orb = (double *)(capi_orb_tmp->data);

  /* Processing variable ixflag */
    f2py_success = int_from_pyobj(&ixflag,ixflag_capi,"libphsh.hfdisk() 13rd argument (ixflag) can't be converted to int");
  if (f2py_success) {
  /* Processing variable r */
  r_Dims[0]=4000;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 9th argument `r' of libphsh.hfdisk to C/Fortran array" );
  } else {
    r = (double *)(capi_r_tmp->data);

  /* Processing variable xnj */
  xnj_Dims[0]=33;
  capi_xnj_intent |= F2PY_INTENT_IN;
  capi_xnj_tmp = array_from_pyobj(NPY_DOUBLE,xnj_Dims,xnj_Rank,capi_xnj_intent,xnj_capi);
  if (capi_xnj_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 17th argument `xnj' of libphsh.hfdisk to C/Fortran array" );
  } else {
    xnj = (double *)(capi_xnj_tmp->data);

  /* Processing variable occ */
  occ_Dims[0]=33;
  capi_occ_intent |= F2PY_INTENT_IN;
  capi_occ_tmp = array_from_pyobj(NPY_DOUBLE,occ_Dims,occ_Rank,capi_occ_intent,occ_capi);
  if (capi_occ_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 21st argument `occ' of libphsh.hfdisk to C/Fortran array" );
  } else {
    occ = (double *)(capi_occ_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iu,&ir,&etot,&nst,&rel,&nr,&rmin,&rmax,r,rho,&zorig,&xntot,&ixflag,&nel,no,nl,xnj,is,ev,ek,occ,njrc,vi,phe,orb);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_occ_tmp!=occ_capi) {
    Py_XDECREF(capi_occ_tmp); }
  }  /*if (capi_occ_tmp == NULL) ... else of occ*/
  /* End of cleaning variable occ */
  if((PyObject *)capi_xnj_tmp!=xnj_capi) {
    Py_XDECREF(capi_xnj_tmp); }
  }  /*if (capi_xnj_tmp == NULL) ... else of xnj*/
  /* End of cleaning variable xnj */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*if (f2py_success) of ixflag*/
  /* End of cleaning variable ixflag */
  if((PyObject *)capi_orb_tmp!=orb_capi) {
    Py_XDECREF(capi_orb_tmp); }
  }  /*if (capi_orb_tmp == NULL) ... else of orb*/
  /* End of cleaning variable orb */
  if((PyObject *)capi_rho_tmp!=rho_capi) {
    Py_XDECREF(capi_rho_tmp); }
  }  /*if (capi_rho_tmp == NULL) ... else of rho*/
  /* End of cleaning variable rho */
  if((PyObject *)capi_njrc_tmp!=njrc_capi) {
    Py_XDECREF(capi_njrc_tmp); }
  }  /*if (capi_njrc_tmp == NULL) ... else of njrc*/
  /* End of cleaning variable njrc */
  if((PyObject *)capi_phe_tmp!=phe_capi) {
    Py_XDECREF(capi_phe_tmp); }
  }  /*if (capi_phe_tmp == NULL) ... else of phe*/
  /* End of cleaning variable phe */
  } /*if (f2py_success) of nel*/
  /* End of cleaning variable nel */
  } /*if (f2py_success) of zorig*/
  /* End of cleaning variable zorig */
  } /*if (f2py_success) of rmax*/
  /* End of cleaning variable rmax */
  } /*if (f2py_success) of etot*/
  /* End of cleaning variable etot */
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of rel*/
  /* End of cleaning variable rel */
  if((PyObject *)capi_no_tmp!=no_capi) {
    Py_XDECREF(capi_no_tmp); }
  }  /*if (capi_no_tmp == NULL) ... else of no*/
  /* End of cleaning variable no */
  } /*if (f2py_success) of xntot*/
  /* End of cleaning variable xntot */
  if((PyObject *)capi_nl_tmp!=nl_capi) {
    Py_XDECREF(capi_nl_tmp); }
  }  /*if (capi_nl_tmp == NULL) ... else of nl*/
  /* End of cleaning variable nl */
  } /*if (f2py_success) of rmin*/
  /* End of cleaning variable rmin */
  } /*if (f2py_success) of nst*/
  /* End of cleaning variable nst */
  if((PyObject *)capi_ev_tmp!=ev_capi) {
    Py_XDECREF(capi_ev_tmp); }
  }  /*if (capi_ev_tmp == NULL) ... else of ev*/
  /* End of cleaning variable ev */
  } /*if (f2py_success) of iu*/
  /* End of cleaning variable iu */
  } /*if (f2py_success) of ir*/
  /* End of cleaning variable ir */
  if((PyObject *)capi_is_tmp!=is_capi) {
    Py_XDECREF(capi_is_tmp); }
  }  /*if (capi_is_tmp == NULL) ... else of is*/
  /* End of cleaning variable is */
  if((PyObject *)capi_vi_tmp!=vi_capi) {
    Py_XDECREF(capi_vi_tmp); }
  }  /*if (capi_vi_tmp == NULL) ... else of vi*/
  /* End of cleaning variable vi */
  if((PyObject *)capi_ek_tmp!=ek_capi) {
    Py_XDECREF(capi_ek_tmp); }
  }  /*if (capi_ek_tmp == NULL) ... else of ek*/
  /* End of cleaning variable ek */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of hfdisk *******************************/

/********************************** exchcorr **********************************/
static char doc_f2py_rout_libphsh_exchcorr[] = "\
exchcorr(nst,rel,rr,rh1,rh2,ex,ec,ux1,ux2,uc1,uc2)\n\nWrapper for ``exchcorr``.\
\n\nParameters\n----------\n"
"nst : input int\n"
"rel : input float\n"
"rr : input float\n"
"rh1 : input float\n"
"rh2 : input float\n"
"ex : input float\n"
"ec : input float\n"
"ux1 : input float\n"
"ux2 : input float\n"
"uc1 : input float\n"
"uc2 : input float";
/* extern void F_FUNC(exchcorr,EXCHCORR)(int*,double*,double*,double*,double*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_libphsh_exchcorr(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,double*,double*,double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nst = 0;
  PyObject *nst_capi = Py_None;
  double rel = 0;
  PyObject *rel_capi = Py_None;
  double rr = 0;
  PyObject *rr_capi = Py_None;
  double rh1 = 0;
  PyObject *rh1_capi = Py_None;
  double rh2 = 0;
  PyObject *rh2_capi = Py_None;
  double ex = 0;
  PyObject *ex_capi = Py_None;
  double ec = 0;
  PyObject *ec_capi = Py_None;
  double ux1 = 0;
  PyObject *ux1_capi = Py_None;
  double ux2 = 0;
  PyObject *ux2_capi = Py_None;
  double uc1 = 0;
  PyObject *uc1_capi = Py_None;
  double uc2 = 0;
  PyObject *uc2_capi = Py_None;
  static char *capi_kwlist[] = {"nst","rel","rr","rh1","rh2","ex","ec","ux1","ux2","uc1","uc2",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOO:libphsh.exchcorr",\
    capi_kwlist,&nst_capi,&rel_capi,&rr_capi,&rh1_capi,&rh2_capi,&ex_capi,&ec_capi,&ux1_capi,&ux2_capi,&uc1_capi,&uc2_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable ux2 */
    f2py_success = double_from_pyobj(&ux2,ux2_capi,"libphsh.exchcorr() 9th argument (ux2) can't be converted to double");
  if (f2py_success) {
  /* Processing variable rr */
    f2py_success = double_from_pyobj(&rr,rr_capi,"libphsh.exchcorr() 3rd argument (rr) can't be converted to double");
  if (f2py_success) {
  /* Processing variable uc1 */
    f2py_success = double_from_pyobj(&uc1,uc1_capi,"libphsh.exchcorr() 10th argument (uc1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ux1 */
    f2py_success = double_from_pyobj(&ux1,ux1_capi,"libphsh.exchcorr() 8th argument (ux1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable rh1 */
    f2py_success = double_from_pyobj(&rh1,rh1_capi,"libphsh.exchcorr() 4th argument (rh1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable rh2 */
    f2py_success = double_from_pyobj(&rh2,rh2_capi,"libphsh.exchcorr() 5th argument (rh2) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ec */
    f2py_success = double_from_pyobj(&ec,ec_capi,"libphsh.exchcorr() 7th argument (ec) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ex */
    f2py_success = double_from_pyobj(&ex,ex_capi,"libphsh.exchcorr() 6th argument (ex) can't be converted to double");
  if (f2py_success) {
  /* Processing variable rel */
    f2py_success = double_from_pyobj(&rel,rel_capi,"libphsh.exchcorr() 2nd argument (rel) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nst */
    f2py_success = int_from_pyobj(&nst,nst_capi,"libphsh.exchcorr() 1st argument (nst) can't be converted to int");
  if (f2py_success) {
  /* Processing variable uc2 */
    f2py_success = double_from_pyobj(&uc2,uc2_capi,"libphsh.exchcorr() 11st argument (uc2) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nst,&rel,&rr,&rh1,&rh2,&ex,&ec,&ux1,&ux2,&uc1,&uc2);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of uc2*/
  /* End of cleaning variable uc2 */
  } /*if (f2py_success) of nst*/
  /* End of cleaning variable nst */
  } /*if (f2py_success) of rel*/
  /* End of cleaning variable rel */
  } /*if (f2py_success) of ex*/
  /* End of cleaning variable ex */
  } /*if (f2py_success) of ec*/
  /* End of cleaning variable ec */
  } /*if (f2py_success) of rh2*/
  /* End of cleaning variable rh2 */
  } /*if (f2py_success) of rh1*/
  /* End of cleaning variable rh1 */
  } /*if (f2py_success) of ux1*/
  /* End of cleaning variable ux1 */
  } /*if (f2py_success) of uc1*/
  /* End of cleaning variable uc1 */
  } /*if (f2py_success) of rr*/
  /* End of cleaning variable rr */
  } /*if (f2py_success) of ux2*/
  /* End of cleaning variable ux2 */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of exchcorr ******************************/

/*********************************** CAVPOT ***********************************/
static char doc_f2py_rout_libphsh_CAVPOT[] = "\
CAVPOT = CAVPOT(MTZ_STRING,SLAB_FLAG,ATOMIC_FILE,CLUSTER_FILE,MUFFTIN_FILE,OUTPUT_FILE,INFO_FILE)\n\nWrapper for ``CAVPOT``.\
\n\nParameters\n----------\n"
"MTZ_STRING : input string(len=-1)\n"
"SLAB_FLAG : input int\n"
"ATOMIC_FILE : input string(len=-1)\n"
"CLUSTER_FILE : input string(len=-1)\n"
"MUFFTIN_FILE : input string(len=-1)\n"
"OUTPUT_FILE : input string(len=-1)\n"
"INFO_FILE : input string(len=-1)\n"
"\nReturns\n-------\n"
"CAVPOT : float";
/* extern void F_WRAPPEDFUNC(cavpot,CAVPOT)(float*,string,int*,string,string,string,string,string,size_t,size_t,size_t,size_t,size_t,size_t); */
static PyObject *f2py_rout_libphsh_CAVPOT(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,string,int*,string,string,string,string,string,size_t,size_t,size_t,size_t,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  float CAVPOT = 0;
  string MTZ_STRING = NULL;
  int slen(MTZ_STRING);
  PyObject *MTZ_STRING_capi = Py_None;
  int SLAB_FLAG = 0;
  PyObject *SLAB_FLAG_capi = Py_None;
  string ATOMIC_FILE = NULL;
  int slen(ATOMIC_FILE);
  PyObject *ATOMIC_FILE_capi = Py_None;
  string CLUSTER_FILE = NULL;
  int slen(CLUSTER_FILE);
  PyObject *CLUSTER_FILE_capi = Py_None;
  string MUFFTIN_FILE = NULL;
  int slen(MUFFTIN_FILE);
  PyObject *MUFFTIN_FILE_capi = Py_None;
  string OUTPUT_FILE = NULL;
  int slen(OUTPUT_FILE);
  PyObject *OUTPUT_FILE_capi = Py_None;
  string INFO_FILE = NULL;
  int slen(INFO_FILE);
  PyObject *INFO_FILE_capi = Py_None;
  static char *capi_kwlist[] = {"MTZ_STRING","SLAB_FLAG","ATOMIC_FILE","CLUSTER_FILE","MUFFTIN_FILE","OUTPUT_FILE","INFO_FILE",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOO:libphsh.CAVPOT",\
    capi_kwlist,&MTZ_STRING_capi,&SLAB_FLAG_capi,&ATOMIC_FILE_capi,&CLUSTER_FILE_capi,&MUFFTIN_FILE_capi,&OUTPUT_FILE_capi,&INFO_FILE_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable OUTPUT_FILE */
  slen(OUTPUT_FILE) = -1;
  f2py_success = string_from_pyobj(&OUTPUT_FILE,&slen(OUTPUT_FILE),"",OUTPUT_FILE_capi,"string_from_pyobj failed in converting 6th argument `OUTPUT_FILE' of libphsh.CAVPOT to C string");
  if (f2py_success) {
  /* Processing variable INFO_FILE */
  slen(INFO_FILE) = -1;
  f2py_success = string_from_pyobj(&INFO_FILE,&slen(INFO_FILE),"",INFO_FILE_capi,"string_from_pyobj failed in converting 7th argument `INFO_FILE' of libphsh.CAVPOT to C string");
  if (f2py_success) {
  /* Processing variable MUFFTIN_FILE */
  slen(MUFFTIN_FILE) = -1;
  f2py_success = string_from_pyobj(&MUFFTIN_FILE,&slen(MUFFTIN_FILE),"",MUFFTIN_FILE_capi,"string_from_pyobj failed in converting 5th argument `MUFFTIN_FILE' of libphsh.CAVPOT to C string");
  if (f2py_success) {
  /* Processing variable MTZ_STRING */
  slen(MTZ_STRING) = -1;
  f2py_success = string_from_pyobj(&MTZ_STRING,&slen(MTZ_STRING),"",MTZ_STRING_capi,"string_from_pyobj failed in converting 1st argument `MTZ_STRING' of libphsh.CAVPOT to C string");
  if (f2py_success) {
  /* Processing variable CLUSTER_FILE */
  slen(CLUSTER_FILE) = -1;
  f2py_success = string_from_pyobj(&CLUSTER_FILE,&slen(CLUSTER_FILE),"",CLUSTER_FILE_capi,"string_from_pyobj failed in converting 4th argument `CLUSTER_FILE' of libphsh.CAVPOT to C string");
  if (f2py_success) {
  /* Processing variable ATOMIC_FILE */
  slen(ATOMIC_FILE) = -1;
  f2py_success = string_from_pyobj(&ATOMIC_FILE,&slen(ATOMIC_FILE),"",ATOMIC_FILE_capi,"string_from_pyobj failed in converting 3rd argument `ATOMIC_FILE' of libphsh.CAVPOT to C string");
  if (f2py_success) {
  /* Processing variable SLAB_FLAG */
    f2py_success = int_from_pyobj(&SLAB_FLAG,SLAB_FLAG_capi,"libphsh.CAVPOT() 2nd argument (SLAB_FLAG) can't be converted to int");
  if (f2py_success) {
  /* Processing variable CAVPOT */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&CAVPOT,MTZ_STRING,&SLAB_FLAG,ATOMIC_FILE,CLUSTER_FILE,MUFFTIN_FILE,OUTPUT_FILE,INFO_FILE,slen(MTZ_STRING),slen(ATOMIC_FILE),slen(CLUSTER_FILE),slen(MUFFTIN_FILE),slen(OUTPUT_FILE),slen(INFO_FILE));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("f",CAVPOT);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable CAVPOT */
  } /*if (f2py_success) of SLAB_FLAG*/
  /* End of cleaning variable SLAB_FLAG */
    STRINGFREE(ATOMIC_FILE);
  }  /*if (f2py_success) of ATOMIC_FILE*/
  /* End of cleaning variable ATOMIC_FILE */
    STRINGFREE(CLUSTER_FILE);
  }  /*if (f2py_success) of CLUSTER_FILE*/
  /* End of cleaning variable CLUSTER_FILE */
    STRINGFREE(MTZ_STRING);
  }  /*if (f2py_success) of MTZ_STRING*/
  /* End of cleaning variable MTZ_STRING */
    STRINGFREE(MUFFTIN_FILE);
  }  /*if (f2py_success) of MUFFTIN_FILE*/
  /* End of cleaning variable MUFFTIN_FILE */
    STRINGFREE(INFO_FILE);
  }  /*if (f2py_success) of INFO_FILE*/
  /* End of cleaning variable INFO_FILE */
    STRINGFREE(OUTPUT_FILE);
  }  /*if (f2py_success) of OUTPUT_FILE*/
  /* End of cleaning variable OUTPUT_FILE */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of CAVPOT *******************************/

/*********************************** CHGRID ***********************************/
static char doc_f2py_rout_libphsh_CHGRID[] = "\
CHGRID(FX,X,FY,Y,[NX,NY])\n\nWrapper for ``CHGRID``.\
\n\nParameters\n----------\n"
"FX : input rank-1 array('d') with bounds (NX)\n"
"X : input rank-1 array('d') with bounds (NX)\n"
"FY : input rank-1 array('d') with bounds (NY)\n"
"Y : input rank-1 array('d') with bounds (NY)\n"
"\nOther Parameters\n----------------\n"
"NX : input int, optional\n    Default: len(FX)\n"
"NY : input int, optional\n    Default: len(FY)";
/* extern void F_FUNC(CHGRID,CHGRID)(double*,double*,int*,double*,double*,int*); */
static PyObject *f2py_rout_libphsh_CHGRID(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *FX = NULL;
  npy_intp FX_Dims[1] = {-1};
  const int FX_Rank = 1;
  PyArrayObject *capi_FX_tmp = NULL;
  int capi_FX_intent = 0;
  PyObject *FX_capi = Py_None;
  double *X = NULL;
  npy_intp X_Dims[1] = {-1};
  const int X_Rank = 1;
  PyArrayObject *capi_X_tmp = NULL;
  int capi_X_intent = 0;
  PyObject *X_capi = Py_None;
  int NX = 0;
  PyObject *NX_capi = Py_None;
  double *FY = NULL;
  npy_intp FY_Dims[1] = {-1};
  const int FY_Rank = 1;
  PyArrayObject *capi_FY_tmp = NULL;
  int capi_FY_intent = 0;
  PyObject *FY_capi = Py_None;
  double *Y = NULL;
  npy_intp Y_Dims[1] = {-1};
  const int Y_Rank = 1;
  PyArrayObject *capi_Y_tmp = NULL;
  int capi_Y_intent = 0;
  PyObject *Y_capi = Py_None;
  int NY = 0;
  PyObject *NY_capi = Py_None;
  static char *capi_kwlist[] = {"FX","X","FY","Y","NX","NY",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|OO:libphsh.CHGRID",\
    capi_kwlist,&FX_capi,&X_capi,&FY_capi,&Y_capi,&NX_capi,&NY_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable FX */
  ;
  capi_FX_intent |= F2PY_INTENT_IN;
  capi_FX_tmp = array_from_pyobj(NPY_DOUBLE,FX_Dims,FX_Rank,capi_FX_intent,FX_capi);
  if (capi_FX_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `FX' of libphsh.CHGRID to C/Fortran array" );
  } else {
    FX = (double *)(capi_FX_tmp->data);

  /* Processing variable FY */
  ;
  capi_FY_intent |= F2PY_INTENT_IN;
  capi_FY_tmp = array_from_pyobj(NPY_DOUBLE,FY_Dims,FY_Rank,capi_FY_intent,FY_capi);
  if (capi_FY_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 3rd argument `FY' of libphsh.CHGRID to C/Fortran array" );
  } else {
    FY = (double *)(capi_FY_tmp->data);

  /* Processing variable NX */
  if (NX_capi == Py_None) NX = len(FX); else
    f2py_success = int_from_pyobj(&NX,NX_capi,"libphsh.CHGRID() 1st keyword (NX) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(FX)>=NX,"len(FX)>=NX","1st keyword NX","CHGRID:NX=%d",NX) {
  /* Processing variable NY */
  if (NY_capi == Py_None) NY = len(FY); else
    f2py_success = int_from_pyobj(&NY,NY_capi,"libphsh.CHGRID() 2nd keyword (NY) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(FY)>=NY,"len(FY)>=NY","2nd keyword NY","CHGRID:NY=%d",NY) {
  /* Processing variable Y */
  Y_Dims[0]=NY;
  capi_Y_intent |= F2PY_INTENT_IN;
  capi_Y_tmp = array_from_pyobj(NPY_DOUBLE,Y_Dims,Y_Rank,capi_Y_intent,Y_capi);
  if (capi_Y_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 4th argument `Y' of libphsh.CHGRID to C/Fortran array" );
  } else {
    Y = (double *)(capi_Y_tmp->data);

  /* Processing variable X */
  X_Dims[0]=NX;
  capi_X_intent |= F2PY_INTENT_IN;
  capi_X_tmp = array_from_pyobj(NPY_DOUBLE,X_Dims,X_Rank,capi_X_intent,X_capi);
  if (capi_X_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `X' of libphsh.CHGRID to C/Fortran array" );
  } else {
    X = (double *)(capi_X_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(FX,X,&NX,FY,Y,&NY);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_X_tmp!=X_capi) {
    Py_XDECREF(capi_X_tmp); }
  }  /*if (capi_X_tmp == NULL) ... else of X*/
  /* End of cleaning variable X */
  if((PyObject *)capi_Y_tmp!=Y_capi) {
    Py_XDECREF(capi_Y_tmp); }
  }  /*if (capi_Y_tmp == NULL) ... else of Y*/
  /* End of cleaning variable Y */
  } /*CHECKSCALAR(len(FY)>=NY)*/
  } /*if (f2py_success) of NY*/
  /* End of cleaning variable NY */
  } /*CHECKSCALAR(len(FX)>=NX)*/
  } /*if (f2py_success) of NX*/
  /* End of cleaning variable NX */
  if((PyObject *)capi_FY_tmp!=FY_capi) {
    Py_XDECREF(capi_FY_tmp); }
  }  /*if (capi_FY_tmp == NULL) ... else of FY*/
  /* End of cleaning variable FY */
  if((PyObject *)capi_FX_tmp!=FX_capi) {
    Py_XDECREF(capi_FX_tmp); }
  }  /*if (capi_FX_tmp == NULL) ... else of FX*/
  /* End of cleaning variable FX */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of CHGRID *******************************/

/*********************************** CLEMIN ***********************************/
static char doc_f2py_rout_libphsh_CLEMIN[] = "\
CLEMIN(RHO,RX,NX,[NGRID])\n\nWrapper for ``CLEMIN``.\
\n\nParameters\n----------\n"
"RHO : input rank-1 array('d') with bounds (NGRID)\n"
"RX : input rank-1 array('d') with bounds (NGRID)\n"
"NX : input int\n"
"\nOther Parameters\n----------------\n"
"NGRID : input int, optional\n    Default: len(RHO)";
/* extern void F_FUNC(CLEMIN,CLEMIN)(double*,double*,int*,int*); */
static PyObject *f2py_rout_libphsh_CLEMIN(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *RHO = NULL;
  npy_intp RHO_Dims[1] = {-1};
  const int RHO_Rank = 1;
  PyArrayObject *capi_RHO_tmp = NULL;
  int capi_RHO_intent = 0;
  PyObject *RHO_capi = Py_None;
  double *RX = NULL;
  npy_intp RX_Dims[1] = {-1};
  const int RX_Rank = 1;
  PyArrayObject *capi_RX_tmp = NULL;
  int capi_RX_intent = 0;
  PyObject *RX_capi = Py_None;
  int NX = 0;
  PyObject *NX_capi = Py_None;
  int NGRID = 0;
  PyObject *NGRID_capi = Py_None;
  static char *capi_kwlist[] = {"RHO","RX","NX","NGRID",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|O:libphsh.CLEMIN",\
    capi_kwlist,&RHO_capi,&RX_capi,&NX_capi,&NGRID_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable NX */
    f2py_success = int_from_pyobj(&NX,NX_capi,"libphsh.CLEMIN() 3rd argument (NX) can't be converted to int");
  if (f2py_success) {
  /* Processing variable RHO */
  ;
  capi_RHO_intent |= F2PY_INTENT_IN;
  capi_RHO_tmp = array_from_pyobj(NPY_DOUBLE,RHO_Dims,RHO_Rank,capi_RHO_intent,RHO_capi);
  if (capi_RHO_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `RHO' of libphsh.CLEMIN to C/Fortran array" );
  } else {
    RHO = (double *)(capi_RHO_tmp->data);

  /* Processing variable NGRID */
  if (NGRID_capi == Py_None) NGRID = len(RHO); else
    f2py_success = int_from_pyobj(&NGRID,NGRID_capi,"libphsh.CLEMIN() 1st keyword (NGRID) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(RHO)>=NGRID,"len(RHO)>=NGRID","1st keyword NGRID","CLEMIN:NGRID=%d",NGRID) {
  /* Processing variable RX */
  RX_Dims[0]=NGRID;
  capi_RX_intent |= F2PY_INTENT_IN;
  capi_RX_tmp = array_from_pyobj(NPY_DOUBLE,RX_Dims,RX_Rank,capi_RX_intent,RX_capi);
  if (capi_RX_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `RX' of libphsh.CLEMIN to C/Fortran array" );
  } else {
    RX = (double *)(capi_RX_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(RHO,RX,&NX,&NGRID);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_RX_tmp!=RX_capi) {
    Py_XDECREF(capi_RX_tmp); }
  }  /*if (capi_RX_tmp == NULL) ... else of RX*/
  /* End of cleaning variable RX */
  } /*CHECKSCALAR(len(RHO)>=NGRID)*/
  } /*if (f2py_success) of NGRID*/
  /* End of cleaning variable NGRID */
  if((PyObject *)capi_RHO_tmp!=RHO_capi) {
    Py_XDECREF(capi_RHO_tmp); }
  }  /*if (capi_RHO_tmp == NULL) ... else of RHO*/
  /* End of cleaning variable RHO */
  } /*if (f2py_success) of NX*/
  /* End of cleaning variable NX */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of CLEMIN *******************************/

/************************************ Hsin ************************************/
static char doc_f2py_rout_libphsh_Hsin[] = "\
Hsin(RHO,RX,NX,[NGRID])\n\nWrapper for ``Hsin``.\
\n\nParameters\n----------\n"
"RHO : input rank-1 array('d') with bounds (NGRID)\n"
"RX : input rank-1 array('d') with bounds (NGRID)\n"
"NX : input int\n"
"\nOther Parameters\n----------------\n"
"NGRID : input int, optional\n    Default: len(RHO)";
/* extern void F_FUNC(Hsin,HSIN)(double*,double*,int*,int*); */
static PyObject *f2py_rout_libphsh_Hsin(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *RHO = NULL;
  npy_intp RHO_Dims[1] = {-1};
  const int RHO_Rank = 1;
  PyArrayObject *capi_RHO_tmp = NULL;
  int capi_RHO_intent = 0;
  PyObject *RHO_capi = Py_None;
  double *RX = NULL;
  npy_intp RX_Dims[1] = {-1};
  const int RX_Rank = 1;
  PyArrayObject *capi_RX_tmp = NULL;
  int capi_RX_intent = 0;
  PyObject *RX_capi = Py_None;
  int NX = 0;
  PyObject *NX_capi = Py_None;
  int NGRID = 0;
  PyObject *NGRID_capi = Py_None;
  static char *capi_kwlist[] = {"RHO","RX","NX","NGRID",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|O:libphsh.Hsin",\
    capi_kwlist,&RHO_capi,&RX_capi,&NX_capi,&NGRID_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable NX */
    f2py_success = int_from_pyobj(&NX,NX_capi,"libphsh.Hsin() 3rd argument (NX) can't be converted to int");
  if (f2py_success) {
  /* Processing variable RHO */
  ;
  capi_RHO_intent |= F2PY_INTENT_IN;
  capi_RHO_tmp = array_from_pyobj(NPY_DOUBLE,RHO_Dims,RHO_Rank,capi_RHO_intent,RHO_capi);
  if (capi_RHO_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `RHO' of libphsh.Hsin to C/Fortran array" );
  } else {
    RHO = (double *)(capi_RHO_tmp->data);

  /* Processing variable NGRID */
  if (NGRID_capi == Py_None) NGRID = len(RHO); else
    f2py_success = int_from_pyobj(&NGRID,NGRID_capi,"libphsh.Hsin() 1st keyword (NGRID) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(RHO)>=NGRID,"len(RHO)>=NGRID","1st keyword NGRID","Hsin:NGRID=%d",NGRID) {
  /* Processing variable RX */
  RX_Dims[0]=NGRID;
  capi_RX_intent |= F2PY_INTENT_IN;
  capi_RX_tmp = array_from_pyobj(NPY_DOUBLE,RX_Dims,RX_Rank,capi_RX_intent,RX_capi);
  if (capi_RX_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `RX' of libphsh.Hsin to C/Fortran array" );
  } else {
    RX = (double *)(capi_RX_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(RHO,RX,&NX,&NGRID);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_RX_tmp!=RX_capi) {
    Py_XDECREF(capi_RX_tmp); }
  }  /*if (capi_RX_tmp == NULL) ... else of RX*/
  /* End of cleaning variable RX */
  } /*CHECKSCALAR(len(RHO)>=NGRID)*/
  } /*if (f2py_success) of NGRID*/
  /* End of cleaning variable NGRID */
  if((PyObject *)capi_RHO_tmp!=RHO_capi) {
    Py_XDECREF(capi_RHO_tmp); }
  }  /*if (capi_RHO_tmp == NULL) ... else of RHO*/
  /* End of cleaning variable RHO */
  } /*if (f2py_success) of NX*/
  /* End of cleaning variable NX */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of Hsin ********************************/

/************************************ MAD ************************************/
static char doc_f2py_rout_libphsh_MAD[] = "\
MAD(VMAD,RX,RMT,NRR,NX,RC,RK,ZM,AV,[NGRID,NR,N])\n\nWrapper for ``MAD``.\
\n\nParameters\n----------\n"
"VMAD : input rank-2 array('d') with bounds (NGRID,NR)\n"
"RX : input rank-1 array('d') with bounds (NGRID)\n"
"RMT : input rank-1 array('d') with bounds (NR)\n"
"NRR : input rank-1 array('i') with bounds (NR)\n"
"NX : input rank-1 array('i') with bounds (NR)\n"
"RC : input rank-2 array('d') with bounds (3,3)\n"
"RK : input rank-2 array('d') with bounds (3,N)\n"
"ZM : input rank-1 array('d') with bounds (N)\n"
"AV : input float\n"
"\nOther Parameters\n----------------\n"
"NGRID : input int, optional\n    Default: shape(VMAD,0)\n"
"NR : input int, optional\n    Default: shape(VMAD,1)\n"
"N : input int, optional\n    Default: shape(RK,1)";
/* extern void F_FUNC(MAD,MAD)(double*,double*,int*,double*,int*,int*,int*,double*,double*,double*,int*,double*); */
static PyObject *f2py_rout_libphsh_MAD(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,double*,int*,int*,int*,double*,double*,double*,int*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *VMAD = NULL;
  npy_intp VMAD_Dims[2] = {-1, -1};
  const int VMAD_Rank = 2;
  PyArrayObject *capi_VMAD_tmp = NULL;
  int capi_VMAD_intent = 0;
  PyObject *VMAD_capi = Py_None;
  double *RX = NULL;
  npy_intp RX_Dims[1] = {-1};
  const int RX_Rank = 1;
  PyArrayObject *capi_RX_tmp = NULL;
  int capi_RX_intent = 0;
  PyObject *RX_capi = Py_None;
  int NGRID = 0;
  PyObject *NGRID_capi = Py_None;
  double *RMT = NULL;
  npy_intp RMT_Dims[1] = {-1};
  const int RMT_Rank = 1;
  PyArrayObject *capi_RMT_tmp = NULL;
  int capi_RMT_intent = 0;
  PyObject *RMT_capi = Py_None;
  int *NRR = NULL;
  npy_intp NRR_Dims[1] = {-1};
  const int NRR_Rank = 1;
  PyArrayObject *capi_NRR_tmp = NULL;
  int capi_NRR_intent = 0;
  PyObject *NRR_capi = Py_None;
  int *NX = NULL;
  npy_intp NX_Dims[1] = {-1};
  const int NX_Rank = 1;
  PyArrayObject *capi_NX_tmp = NULL;
  int capi_NX_intent = 0;
  PyObject *NX_capi = Py_None;
  int NR = 0;
  PyObject *NR_capi = Py_None;
  double *RC = NULL;
  npy_intp RC_Dims[2] = {-1, -1};
  const int RC_Rank = 2;
  PyArrayObject *capi_RC_tmp = NULL;
  int capi_RC_intent = 0;
  PyObject *RC_capi = Py_None;
  double *RK = NULL;
  npy_intp RK_Dims[2] = {-1, -1};
  const int RK_Rank = 2;
  PyArrayObject *capi_RK_tmp = NULL;
  int capi_RK_intent = 0;
  PyObject *RK_capi = Py_None;
  double *ZM = NULL;
  npy_intp ZM_Dims[1] = {-1};
  const int ZM_Rank = 1;
  PyArrayObject *capi_ZM_tmp = NULL;
  int capi_ZM_intent = 0;
  PyObject *ZM_capi = Py_None;
  int N = 0;
  PyObject *N_capi = Py_None;
  double AV = 0;
  PyObject *AV_capi = Py_None;
  static char *capi_kwlist[] = {"VMAD","RX","RMT","NRR","NX","RC","RK","ZM","AV","NGRID","NR","N",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOO|OOO:libphsh.MAD",\
    capi_kwlist,&VMAD_capi,&RX_capi,&RMT_capi,&NRR_capi,&NX_capi,&RC_capi,&RK_capi,&ZM_capi,&AV_capi,&NGRID_capi,&NR_capi,&N_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable VMAD */
  ;
  capi_VMAD_intent |= F2PY_INTENT_IN;
  capi_VMAD_tmp = array_from_pyobj(NPY_DOUBLE,VMAD_Dims,VMAD_Rank,capi_VMAD_intent,VMAD_capi);
  if (capi_VMAD_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `VMAD' of libphsh.MAD to C/Fortran array" );
  } else {
    VMAD = (double *)(capi_VMAD_tmp->data);

  /* Processing variable AV */
    f2py_success = double_from_pyobj(&AV,AV_capi,"libphsh.MAD() 9th argument (AV) can't be converted to double");
  if (f2py_success) {
  /* Processing variable RC */
  RC_Dims[0]=3,RC_Dims[1]=3;
  capi_RC_intent |= F2PY_INTENT_IN;
  capi_RC_tmp = array_from_pyobj(NPY_DOUBLE,RC_Dims,RC_Rank,capi_RC_intent,RC_capi);
  if (capi_RC_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 6th argument `RC' of libphsh.MAD to C/Fortran array" );
  } else {
    RC = (double *)(capi_RC_tmp->data);

  /* Processing variable RK */
  RK_Dims[0]=3;
  capi_RK_intent |= F2PY_INTENT_IN;
  capi_RK_tmp = array_from_pyobj(NPY_DOUBLE,RK_Dims,RK_Rank,capi_RK_intent,RK_capi);
  if (capi_RK_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 7th argument `RK' of libphsh.MAD to C/Fortran array" );
  } else {
    RK = (double *)(capi_RK_tmp->data);

  /* Processing variable N */
  if (N_capi == Py_None) N = shape(RK,1); else
    f2py_success = int_from_pyobj(&N,N_capi,"libphsh.MAD() 3rd keyword (N) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(RK,1)==N,"shape(RK,1)==N","3rd keyword N","MAD:N=%d",N) {
  /* Processing variable NGRID */
  if (NGRID_capi == Py_None) NGRID = shape(VMAD,0); else
    f2py_success = int_from_pyobj(&NGRID,NGRID_capi,"libphsh.MAD() 1st keyword (NGRID) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(VMAD,0)==NGRID,"shape(VMAD,0)==NGRID","1st keyword NGRID","MAD:NGRID=%d",NGRID) {
  /* Processing variable RX */
  RX_Dims[0]=NGRID;
  capi_RX_intent |= F2PY_INTENT_IN;
  capi_RX_tmp = array_from_pyobj(NPY_DOUBLE,RX_Dims,RX_Rank,capi_RX_intent,RX_capi);
  if (capi_RX_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `RX' of libphsh.MAD to C/Fortran array" );
  } else {
    RX = (double *)(capi_RX_tmp->data);

  /* Processing variable NR */
  if (NR_capi == Py_None) NR = shape(VMAD,1); else
    f2py_success = int_from_pyobj(&NR,NR_capi,"libphsh.MAD() 2nd keyword (NR) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(VMAD,1)==NR,"shape(VMAD,1)==NR","2nd keyword NR","MAD:NR=%d",NR) {
  /* Processing variable ZM */
  ZM_Dims[0]=N;
  capi_ZM_intent |= F2PY_INTENT_IN;
  capi_ZM_tmp = array_from_pyobj(NPY_DOUBLE,ZM_Dims,ZM_Rank,capi_ZM_intent,ZM_capi);
  if (capi_ZM_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 8th argument `ZM' of libphsh.MAD to C/Fortran array" );
  } else {
    ZM = (double *)(capi_ZM_tmp->data);

  /* Processing variable RMT */
  RMT_Dims[0]=NR;
  capi_RMT_intent |= F2PY_INTENT_IN;
  capi_RMT_tmp = array_from_pyobj(NPY_DOUBLE,RMT_Dims,RMT_Rank,capi_RMT_intent,RMT_capi);
  if (capi_RMT_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 3rd argument `RMT' of libphsh.MAD to C/Fortran array" );
  } else {
    RMT = (double *)(capi_RMT_tmp->data);

  /* Processing variable NX */
  NX_Dims[0]=NR;
  capi_NX_intent |= F2PY_INTENT_IN;
  capi_NX_tmp = array_from_pyobj(NPY_INT,NX_Dims,NX_Rank,capi_NX_intent,NX_capi);
  if (capi_NX_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 5th argument `NX' of libphsh.MAD to C/Fortran array" );
  } else {
    NX = (int *)(capi_NX_tmp->data);

  /* Processing variable NRR */
  NRR_Dims[0]=NR;
  capi_NRR_intent |= F2PY_INTENT_IN;
  capi_NRR_tmp = array_from_pyobj(NPY_INT,NRR_Dims,NRR_Rank,capi_NRR_intent,NRR_capi);
  if (capi_NRR_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 4th argument `NRR' of libphsh.MAD to C/Fortran array" );
  } else {
    NRR = (int *)(capi_NRR_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(VMAD,RX,&NGRID,RMT,NRR,NX,&NR,RC,RK,ZM,&N,&AV);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_NRR_tmp!=NRR_capi) {
    Py_XDECREF(capi_NRR_tmp); }
  }  /*if (capi_NRR_tmp == NULL) ... else of NRR*/
  /* End of cleaning variable NRR */
  if((PyObject *)capi_NX_tmp!=NX_capi) {
    Py_XDECREF(capi_NX_tmp); }
  }  /*if (capi_NX_tmp == NULL) ... else of NX*/
  /* End of cleaning variable NX */
  if((PyObject *)capi_RMT_tmp!=RMT_capi) {
    Py_XDECREF(capi_RMT_tmp); }
  }  /*if (capi_RMT_tmp == NULL) ... else of RMT*/
  /* End of cleaning variable RMT */
  if((PyObject *)capi_ZM_tmp!=ZM_capi) {
    Py_XDECREF(capi_ZM_tmp); }
  }  /*if (capi_ZM_tmp == NULL) ... else of ZM*/
  /* End of cleaning variable ZM */
  } /*CHECKSCALAR(shape(VMAD,1)==NR)*/
  } /*if (f2py_success) of NR*/
  /* End of cleaning variable NR */
  if((PyObject *)capi_RX_tmp!=RX_capi) {
    Py_XDECREF(capi_RX_tmp); }
  }  /*if (capi_RX_tmp == NULL) ... else of RX*/
  /* End of cleaning variable RX */
  } /*CHECKSCALAR(shape(VMAD,0)==NGRID)*/
  } /*if (f2py_success) of NGRID*/
  /* End of cleaning variable NGRID */
  } /*CHECKSCALAR(shape(RK,1)==N)*/
  } /*if (f2py_success) of N*/
  /* End of cleaning variable N */
  if((PyObject *)capi_RK_tmp!=RK_capi) {
    Py_XDECREF(capi_RK_tmp); }
  }  /*if (capi_RK_tmp == NULL) ... else of RK*/
  /* End of cleaning variable RK */
  if((PyObject *)capi_RC_tmp!=RC_capi) {
    Py_XDECREF(capi_RC_tmp); }
  }  /*if (capi_RC_tmp == NULL) ... else of RC*/
  /* End of cleaning variable RC */
  } /*if (f2py_success) of AV*/
  /* End of cleaning variable AV */
  if((PyObject *)capi_VMAD_tmp!=VMAD_capi) {
    Py_XDECREF(capi_VMAD_tmp); }
  }  /*if (capi_VMAD_tmp == NULL) ... else of VMAD*/
  /* End of cleaning variable VMAD */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of MAD *********************************/

/************************************ MTZ ************************************/
static char doc_f2py_rout_libphsh_MTZ[] = "\
MTZ(SIG,RHO,RX,RMT,NRR,NX,RC,RK,VHAR,VEX,ALPHA,AV,NH,[NGRID,NR,N])\n\nWrapper for ``MTZ``.\
\n\nParameters\n----------\n"
"SIG : input rank-2 array('d') with bounds (NGRID,NR)\n"
"RHO : input rank-2 array('d') with bounds (NGRID,NR)\n"
"RX : input rank-1 array('d') with bounds (NGRID)\n"
"RMT : input rank-1 array('d') with bounds (NR)\n"
"NRR : input rank-1 array('i') with bounds (NR)\n"
"NX : input rank-1 array('i') with bounds (NR)\n"
"RC : input rank-2 array('d') with bounds (3,3)\n"
"RK : input rank-2 array('d') with bounds (3,N)\n"
"VHAR : input float\n"
"VEX : input float\n"
"ALPHA : input float\n"
"AV : input float\n"
"NH : input int\n"
"\nOther Parameters\n----------------\n"
"NGRID : input int, optional\n    Default: shape(SIG,0)\n"
"NR : input int, optional\n    Default: shape(SIG,1)\n"
"N : input int, optional\n    Default: shape(RK,1)";
/* extern void F_FUNC(MTZ,MTZ)(double*,double*,double*,int*,double*,int*,int*,int*,double*,double*,int*,double*,double*,double*,double*,int*); */
static PyObject *f2py_rout_libphsh_MTZ(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,int*,double*,int*,int*,int*,double*,double*,int*,double*,double*,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *SIG = NULL;
  npy_intp SIG_Dims[2] = {-1, -1};
  const int SIG_Rank = 2;
  PyArrayObject *capi_SIG_tmp = NULL;
  int capi_SIG_intent = 0;
  PyObject *SIG_capi = Py_None;
  double *RHO = NULL;
  npy_intp RHO_Dims[2] = {-1, -1};
  const int RHO_Rank = 2;
  PyArrayObject *capi_RHO_tmp = NULL;
  int capi_RHO_intent = 0;
  PyObject *RHO_capi = Py_None;
  double *RX = NULL;
  npy_intp RX_Dims[1] = {-1};
  const int RX_Rank = 1;
  PyArrayObject *capi_RX_tmp = NULL;
  int capi_RX_intent = 0;
  PyObject *RX_capi = Py_None;
  int NGRID = 0;
  PyObject *NGRID_capi = Py_None;
  double *RMT = NULL;
  npy_intp RMT_Dims[1] = {-1};
  const int RMT_Rank = 1;
  PyArrayObject *capi_RMT_tmp = NULL;
  int capi_RMT_intent = 0;
  PyObject *RMT_capi = Py_None;
  int *NRR = NULL;
  npy_intp NRR_Dims[1] = {-1};
  const int NRR_Rank = 1;
  PyArrayObject *capi_NRR_tmp = NULL;
  int capi_NRR_intent = 0;
  PyObject *NRR_capi = Py_None;
  int *NX = NULL;
  npy_intp NX_Dims[1] = {-1};
  const int NX_Rank = 1;
  PyArrayObject *capi_NX_tmp = NULL;
  int capi_NX_intent = 0;
  PyObject *NX_capi = Py_None;
  int NR = 0;
  PyObject *NR_capi = Py_None;
  double *RC = NULL;
  npy_intp RC_Dims[2] = {-1, -1};
  const int RC_Rank = 2;
  PyArrayObject *capi_RC_tmp = NULL;
  int capi_RC_intent = 0;
  PyObject *RC_capi = Py_None;
  double *RK = NULL;
  npy_intp RK_Dims[2] = {-1, -1};
  const int RK_Rank = 2;
  PyArrayObject *capi_RK_tmp = NULL;
  int capi_RK_intent = 0;
  PyObject *RK_capi = Py_None;
  int N = 0;
  PyObject *N_capi = Py_None;
  double VHAR = 0;
  PyObject *VHAR_capi = Py_None;
  double VEX = 0;
  PyObject *VEX_capi = Py_None;
  double ALPHA = 0;
  PyObject *ALPHA_capi = Py_None;
  double AV = 0;
  PyObject *AV_capi = Py_None;
  int NH = 0;
  PyObject *NH_capi = Py_None;
  static char *capi_kwlist[] = {"SIG","RHO","RX","RMT","NRR","NX","RC","RK","VHAR","VEX","ALPHA","AV","NH","NGRID","NR","N",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOOO|OOO:libphsh.MTZ",\
    capi_kwlist,&SIG_capi,&RHO_capi,&RX_capi,&RMT_capi,&NRR_capi,&NX_capi,&RC_capi,&RK_capi,&VHAR_capi,&VEX_capi,&ALPHA_capi,&AV_capi,&NH_capi,&NGRID_capi,&NR_capi,&N_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable VHAR */
    f2py_success = double_from_pyobj(&VHAR,VHAR_capi,"libphsh.MTZ() 9th argument (VHAR) can't be converted to double");
  if (f2py_success) {
  /* Processing variable VEX */
    f2py_success = double_from_pyobj(&VEX,VEX_capi,"libphsh.MTZ() 10th argument (VEX) can't be converted to double");
  if (f2py_success) {
  /* Processing variable SIG */
  ;
  capi_SIG_intent |= F2PY_INTENT_IN;
  capi_SIG_tmp = array_from_pyobj(NPY_DOUBLE,SIG_Dims,SIG_Rank,capi_SIG_intent,SIG_capi);
  if (capi_SIG_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `SIG' of libphsh.MTZ to C/Fortran array" );
  } else {
    SIG = (double *)(capi_SIG_tmp->data);

  /* Processing variable NH */
    f2py_success = int_from_pyobj(&NH,NH_capi,"libphsh.MTZ() 13rd argument (NH) can't be converted to int");
  if (f2py_success) {
  /* Processing variable RC */
  RC_Dims[0]=3,RC_Dims[1]=3;
  capi_RC_intent |= F2PY_INTENT_IN;
  capi_RC_tmp = array_from_pyobj(NPY_DOUBLE,RC_Dims,RC_Rank,capi_RC_intent,RC_capi);
  if (capi_RC_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 7th argument `RC' of libphsh.MTZ to C/Fortran array" );
  } else {
    RC = (double *)(capi_RC_tmp->data);

  /* Processing variable ALPHA */
    f2py_success = double_from_pyobj(&ALPHA,ALPHA_capi,"libphsh.MTZ() 11st argument (ALPHA) can't be converted to double");
  if (f2py_success) {
  /* Processing variable AV */
    f2py_success = double_from_pyobj(&AV,AV_capi,"libphsh.MTZ() 12nd argument (AV) can't be converted to double");
  if (f2py_success) {
  /* Processing variable RK */
  RK_Dims[0]=3;
  capi_RK_intent |= F2PY_INTENT_IN;
  capi_RK_tmp = array_from_pyobj(NPY_DOUBLE,RK_Dims,RK_Rank,capi_RK_intent,RK_capi);
  if (capi_RK_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 8th argument `RK' of libphsh.MTZ to C/Fortran array" );
  } else {
    RK = (double *)(capi_RK_tmp->data);

  /* Processing variable N */
  if (N_capi == Py_None) N = shape(RK,1); else
    f2py_success = int_from_pyobj(&N,N_capi,"libphsh.MTZ() 3rd keyword (N) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(RK,1)==N,"shape(RK,1)==N","3rd keyword N","MTZ:N=%d",N) {
  /* Processing variable NGRID */
  if (NGRID_capi == Py_None) NGRID = shape(SIG,0); else
    f2py_success = int_from_pyobj(&NGRID,NGRID_capi,"libphsh.MTZ() 1st keyword (NGRID) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(SIG,0)==NGRID,"shape(SIG,0)==NGRID","1st keyword NGRID","MTZ:NGRID=%d",NGRID) {
  /* Processing variable RX */
  RX_Dims[0]=NGRID;
  capi_RX_intent |= F2PY_INTENT_IN;
  capi_RX_tmp = array_from_pyobj(NPY_DOUBLE,RX_Dims,RX_Rank,capi_RX_intent,RX_capi);
  if (capi_RX_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 3rd argument `RX' of libphsh.MTZ to C/Fortran array" );
  } else {
    RX = (double *)(capi_RX_tmp->data);

  /* Processing variable NR */
  if (NR_capi == Py_None) NR = shape(SIG,1); else
    f2py_success = int_from_pyobj(&NR,NR_capi,"libphsh.MTZ() 2nd keyword (NR) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(SIG,1)==NR,"shape(SIG,1)==NR","2nd keyword NR","MTZ:NR=%d",NR) {
  /* Processing variable RHO */
  RHO_Dims[0]=NGRID,RHO_Dims[1]=NR;
  capi_RHO_intent |= F2PY_INTENT_IN;
  capi_RHO_tmp = array_from_pyobj(NPY_DOUBLE,RHO_Dims,RHO_Rank,capi_RHO_intent,RHO_capi);
  if (capi_RHO_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `RHO' of libphsh.MTZ to C/Fortran array" );
  } else {
    RHO = (double *)(capi_RHO_tmp->data);

  /* Processing variable NRR */
  NRR_Dims[0]=NR;
  capi_NRR_intent |= F2PY_INTENT_IN;
  capi_NRR_tmp = array_from_pyobj(NPY_INT,NRR_Dims,NRR_Rank,capi_NRR_intent,NRR_capi);
  if (capi_NRR_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 5th argument `NRR' of libphsh.MTZ to C/Fortran array" );
  } else {
    NRR = (int *)(capi_NRR_tmp->data);

  /* Processing variable RMT */
  RMT_Dims[0]=NR;
  capi_RMT_intent |= F2PY_INTENT_IN;
  capi_RMT_tmp = array_from_pyobj(NPY_DOUBLE,RMT_Dims,RMT_Rank,capi_RMT_intent,RMT_capi);
  if (capi_RMT_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 4th argument `RMT' of libphsh.MTZ to C/Fortran array" );
  } else {
    RMT = (double *)(capi_RMT_tmp->data);

  /* Processing variable NX */
  NX_Dims[0]=NR;
  capi_NX_intent |= F2PY_INTENT_IN;
  capi_NX_tmp = array_from_pyobj(NPY_INT,NX_Dims,NX_Rank,capi_NX_intent,NX_capi);
  if (capi_NX_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 6th argument `NX' of libphsh.MTZ to C/Fortran array" );
  } else {
    NX = (int *)(capi_NX_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(SIG,RHO,RX,&NGRID,RMT,NRR,NX,&NR,RC,RK,&N,&VHAR,&VEX,&ALPHA,&AV,&NH);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_NX_tmp!=NX_capi) {
    Py_XDECREF(capi_NX_tmp); }
  }  /*if (capi_NX_tmp == NULL) ... else of NX*/
  /* End of cleaning variable NX */
  if((PyObject *)capi_RMT_tmp!=RMT_capi) {
    Py_XDECREF(capi_RMT_tmp); }
  }  /*if (capi_RMT_tmp == NULL) ... else of RMT*/
  /* End of cleaning variable RMT */
  if((PyObject *)capi_NRR_tmp!=NRR_capi) {
    Py_XDECREF(capi_NRR_tmp); }
  }  /*if (capi_NRR_tmp == NULL) ... else of NRR*/
  /* End of cleaning variable NRR */
  if((PyObject *)capi_RHO_tmp!=RHO_capi) {
    Py_XDECREF(capi_RHO_tmp); }
  }  /*if (capi_RHO_tmp == NULL) ... else of RHO*/
  /* End of cleaning variable RHO */
  } /*CHECKSCALAR(shape(SIG,1)==NR)*/
  } /*if (f2py_success) of NR*/
  /* End of cleaning variable NR */
  if((PyObject *)capi_RX_tmp!=RX_capi) {
    Py_XDECREF(capi_RX_tmp); }
  }  /*if (capi_RX_tmp == NULL) ... else of RX*/
  /* End of cleaning variable RX */
  } /*CHECKSCALAR(shape(SIG,0)==NGRID)*/
  } /*if (f2py_success) of NGRID*/
  /* End of cleaning variable NGRID */
  } /*CHECKSCALAR(shape(RK,1)==N)*/
  } /*if (f2py_success) of N*/
  /* End of cleaning variable N */
  if((PyObject *)capi_RK_tmp!=RK_capi) {
    Py_XDECREF(capi_RK_tmp); }
  }  /*if (capi_RK_tmp == NULL) ... else of RK*/
  /* End of cleaning variable RK */
  } /*if (f2py_success) of AV*/
  /* End of cleaning variable AV */
  } /*if (f2py_success) of ALPHA*/
  /* End of cleaning variable ALPHA */
  if((PyObject *)capi_RC_tmp!=RC_capi) {
    Py_XDECREF(capi_RC_tmp); }
  }  /*if (capi_RC_tmp == NULL) ... else of RC*/
  /* End of cleaning variable RC */
  } /*if (f2py_success) of NH*/
  /* End of cleaning variable NH */
  if((PyObject *)capi_SIG_tmp!=SIG_capi) {
    Py_XDECREF(capi_SIG_tmp); }
  }  /*if (capi_SIG_tmp == NULL) ... else of SIG*/
  /* End of cleaning variable SIG */
  } /*if (f2py_success) of VEX*/
  /* End of cleaning variable VEX */
  } /*if (f2py_success) of VHAR*/
  /* End of cleaning variable VHAR */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of MTZ *********************************/

/************************************ MTZM ************************************/
static char doc_f2py_rout_libphsh_MTZM[] = "\
MTZM(VH,VS,RX,RMT,RWS,JRMT,JRWS,VHAR,VEX,[NGRID])\n\nWrapper for ``MTZM``.\
\n\nParameters\n----------\n"
"VH : input rank-1 array('d') with bounds (NGRID)\n"
"VS : input rank-1 array('d') with bounds (NGRID)\n"
"RX : input rank-1 array('d') with bounds (NGRID)\n"
"RMT : input float\n"
"RWS : input float\n"
"JRMT : input int\n"
"JRWS : input int\n"
"VHAR : input float\n"
"VEX : input float\n"
"\nOther Parameters\n----------------\n"
"NGRID : input int, optional\n    Default: len(VH)";
/* extern void F_FUNC(MTZM,MTZM)(double*,double*,double*,int*,double*,double*,int*,int*,double*,double*); */
static PyObject *f2py_rout_libphsh_MTZM(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,int*,double*,double*,int*,int*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *VH = NULL;
  npy_intp VH_Dims[1] = {-1};
  const int VH_Rank = 1;
  PyArrayObject *capi_VH_tmp = NULL;
  int capi_VH_intent = 0;
  PyObject *VH_capi = Py_None;
  double *VS = NULL;
  npy_intp VS_Dims[1] = {-1};
  const int VS_Rank = 1;
  PyArrayObject *capi_VS_tmp = NULL;
  int capi_VS_intent = 0;
  PyObject *VS_capi = Py_None;
  double *RX = NULL;
  npy_intp RX_Dims[1] = {-1};
  const int RX_Rank = 1;
  PyArrayObject *capi_RX_tmp = NULL;
  int capi_RX_intent = 0;
  PyObject *RX_capi = Py_None;
  int NGRID = 0;
  PyObject *NGRID_capi = Py_None;
  double RMT = 0;
  PyObject *RMT_capi = Py_None;
  double RWS = 0;
  PyObject *RWS_capi = Py_None;
  int JRMT = 0;
  PyObject *JRMT_capi = Py_None;
  int JRWS = 0;
  PyObject *JRWS_capi = Py_None;
  double VHAR = 0;
  PyObject *VHAR_capi = Py_None;
  double VEX = 0;
  PyObject *VEX_capi = Py_None;
  static char *capi_kwlist[] = {"VH","VS","RX","RMT","RWS","JRMT","JRWS","VHAR","VEX","NGRID",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOO|O:libphsh.MTZM",\
    capi_kwlist,&VH_capi,&VS_capi,&RX_capi,&RMT_capi,&RWS_capi,&JRMT_capi,&JRWS_capi,&VHAR_capi,&VEX_capi,&NGRID_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable RMT */
    f2py_success = double_from_pyobj(&RMT,RMT_capi,"libphsh.MTZM() 4th argument (RMT) can't be converted to double");
  if (f2py_success) {
  /* Processing variable VH */
  ;
  capi_VH_intent |= F2PY_INTENT_IN;
  capi_VH_tmp = array_from_pyobj(NPY_DOUBLE,VH_Dims,VH_Rank,capi_VH_intent,VH_capi);
  if (capi_VH_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `VH' of libphsh.MTZM to C/Fortran array" );
  } else {
    VH = (double *)(capi_VH_tmp->data);

  /* Processing variable JRMT */
    f2py_success = int_from_pyobj(&JRMT,JRMT_capi,"libphsh.MTZM() 6th argument (JRMT) can't be converted to int");
  if (f2py_success) {
  /* Processing variable JRWS */
    f2py_success = int_from_pyobj(&JRWS,JRWS_capi,"libphsh.MTZM() 7th argument (JRWS) can't be converted to int");
  if (f2py_success) {
  /* Processing variable RWS */
    f2py_success = double_from_pyobj(&RWS,RWS_capi,"libphsh.MTZM() 5th argument (RWS) can't be converted to double");
  if (f2py_success) {
  /* Processing variable VEX */
    f2py_success = double_from_pyobj(&VEX,VEX_capi,"libphsh.MTZM() 9th argument (VEX) can't be converted to double");
  if (f2py_success) {
  /* Processing variable VHAR */
    f2py_success = double_from_pyobj(&VHAR,VHAR_capi,"libphsh.MTZM() 8th argument (VHAR) can't be converted to double");
  if (f2py_success) {
  /* Processing variable NGRID */
  if (NGRID_capi == Py_None) NGRID = len(VH); else
    f2py_success = int_from_pyobj(&NGRID,NGRID_capi,"libphsh.MTZM() 1st keyword (NGRID) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(VH)>=NGRID,"len(VH)>=NGRID","1st keyword NGRID","MTZM:NGRID=%d",NGRID) {
  /* Processing variable RX */
  RX_Dims[0]=NGRID;
  capi_RX_intent |= F2PY_INTENT_IN;
  capi_RX_tmp = array_from_pyobj(NPY_DOUBLE,RX_Dims,RX_Rank,capi_RX_intent,RX_capi);
  if (capi_RX_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 3rd argument `RX' of libphsh.MTZM to C/Fortran array" );
  } else {
    RX = (double *)(capi_RX_tmp->data);

  /* Processing variable VS */
  VS_Dims[0]=NGRID;
  capi_VS_intent |= F2PY_INTENT_IN;
  capi_VS_tmp = array_from_pyobj(NPY_DOUBLE,VS_Dims,VS_Rank,capi_VS_intent,VS_capi);
  if (capi_VS_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `VS' of libphsh.MTZM to C/Fortran array" );
  } else {
    VS = (double *)(capi_VS_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(VH,VS,RX,&NGRID,&RMT,&RWS,&JRMT,&JRWS,&VHAR,&VEX);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_VS_tmp!=VS_capi) {
    Py_XDECREF(capi_VS_tmp); }
  }  /*if (capi_VS_tmp == NULL) ... else of VS*/
  /* End of cleaning variable VS */
  if((PyObject *)capi_RX_tmp!=RX_capi) {
    Py_XDECREF(capi_RX_tmp); }
  }  /*if (capi_RX_tmp == NULL) ... else of RX*/
  /* End of cleaning variable RX */
  } /*CHECKSCALAR(len(VH)>=NGRID)*/
  } /*if (f2py_success) of NGRID*/
  /* End of cleaning variable NGRID */
  } /*if (f2py_success) of VHAR*/
  /* End of cleaning variable VHAR */
  } /*if (f2py_success) of VEX*/
  /* End of cleaning variable VEX */
  } /*if (f2py_success) of RWS*/
  /* End of cleaning variable RWS */
  } /*if (f2py_success) of JRWS*/
  /* End of cleaning variable JRWS */
  } /*if (f2py_success) of JRMT*/
  /* End of cleaning variable JRMT */
  if((PyObject *)capi_VH_tmp!=VH_capi) {
    Py_XDECREF(capi_VH_tmp); }
  }  /*if (capi_VH_tmp == NULL) ... else of VH*/
  /* End of cleaning variable VH */
  } /*if (f2py_success) of RMT*/
  /* End of cleaning variable RMT */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of MTZM ********************************/

/************************************ NBR ************************************/
static char doc_f2py_rout_libphsh_NBR[] = "\
NBR(IA,NA,AD,NCON,NRR,RC,RK,RMAX,[NR,N,MC])\n\nWrapper for ``NBR``.\
\n\nParameters\n----------\n"
"IA : input rank-2 array('i') with bounds (MC,NR)\n"
"NA : input rank-2 array('i') with bounds (MC,NR)\n"
"AD : input rank-2 array('d') with bounds (MC,NR)\n"
"NCON : input rank-1 array('i') with bounds (NR)\n"
"NRR : input rank-1 array('i') with bounds (NR)\n"
"RC : input rank-2 array('d') with bounds (3,3)\n"
"RK : input rank-2 array('d') with bounds (3,N)\n"
"RMAX : input float\n"
"\nOther Parameters\n----------------\n"
"NR : input int, optional\n    Default: shape(IA,1)\n"
"N : input int, optional\n    Default: shape(RK,1)\n"
"MC : input int, optional\n    Default: shape(IA,0)";
/* extern void F_FUNC(NBR,NBR)(int*,int*,double*,int*,int*,int*,double*,double*,int*,double*,int*); */
static PyObject *f2py_rout_libphsh_NBR(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,int*,int*,int*,double*,double*,int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int *IA = NULL;
  npy_intp IA_Dims[2] = {-1, -1};
  const int IA_Rank = 2;
  PyArrayObject *capi_IA_tmp = NULL;
  int capi_IA_intent = 0;
  PyObject *IA_capi = Py_None;
  int *NA = NULL;
  npy_intp NA_Dims[2] = {-1, -1};
  const int NA_Rank = 2;
  PyArrayObject *capi_NA_tmp = NULL;
  int capi_NA_intent = 0;
  PyObject *NA_capi = Py_None;
  double *AD = NULL;
  npy_intp AD_Dims[2] = {-1, -1};
  const int AD_Rank = 2;
  PyArrayObject *capi_AD_tmp = NULL;
  int capi_AD_intent = 0;
  PyObject *AD_capi = Py_None;
  int *NCON = NULL;
  npy_intp NCON_Dims[1] = {-1};
  const int NCON_Rank = 1;
  PyArrayObject *capi_NCON_tmp = NULL;
  int capi_NCON_intent = 0;
  PyObject *NCON_capi = Py_None;
  int *NRR = NULL;
  npy_intp NRR_Dims[1] = {-1};
  const int NRR_Rank = 1;
  PyArrayObject *capi_NRR_tmp = NULL;
  int capi_NRR_intent = 0;
  PyObject *NRR_capi = Py_None;
  int NR = 0;
  PyObject *NR_capi = Py_None;
  double *RC = NULL;
  npy_intp RC_Dims[2] = {-1, -1};
  const int RC_Rank = 2;
  PyArrayObject *capi_RC_tmp = NULL;
  int capi_RC_intent = 0;
  PyObject *RC_capi = Py_None;
  double *RK = NULL;
  npy_intp RK_Dims[2] = {-1, -1};
  const int RK_Rank = 2;
  PyArrayObject *capi_RK_tmp = NULL;
  int capi_RK_intent = 0;
  PyObject *RK_capi = Py_None;
  int N = 0;
  PyObject *N_capi = Py_None;
  double RMAX = 0;
  PyObject *RMAX_capi = Py_None;
  int MC = 0;
  PyObject *MC_capi = Py_None;
  static char *capi_kwlist[] = {"IA","NA","AD","NCON","NRR","RC","RK","RMAX","NR","N","MC",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOO|OOO:libphsh.NBR",\
    capi_kwlist,&IA_capi,&NA_capi,&AD_capi,&NCON_capi,&NRR_capi,&RC_capi,&RK_capi,&RMAX_capi,&NR_capi,&N_capi,&MC_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable RMAX */
    f2py_success = double_from_pyobj(&RMAX,RMAX_capi,"libphsh.NBR() 8th argument (RMAX) can't be converted to double");
  if (f2py_success) {
  /* Processing variable RC */
  RC_Dims[0]=3,RC_Dims[1]=3;
  capi_RC_intent |= F2PY_INTENT_IN;
  capi_RC_tmp = array_from_pyobj(NPY_DOUBLE,RC_Dims,RC_Rank,capi_RC_intent,RC_capi);
  if (capi_RC_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 6th argument `RC' of libphsh.NBR to C/Fortran array" );
  } else {
    RC = (double *)(capi_RC_tmp->data);

  /* Processing variable IA */
  ;
  capi_IA_intent |= F2PY_INTENT_IN;
  capi_IA_tmp = array_from_pyobj(NPY_INT,IA_Dims,IA_Rank,capi_IA_intent,IA_capi);
  if (capi_IA_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `IA' of libphsh.NBR to C/Fortran array" );
  } else {
    IA = (int *)(capi_IA_tmp->data);

  /* Processing variable RK */
  RK_Dims[0]=3;
  capi_RK_intent |= F2PY_INTENT_IN;
  capi_RK_tmp = array_from_pyobj(NPY_DOUBLE,RK_Dims,RK_Rank,capi_RK_intent,RK_capi);
  if (capi_RK_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 7th argument `RK' of libphsh.NBR to C/Fortran array" );
  } else {
    RK = (double *)(capi_RK_tmp->data);

  /* Processing variable MC */
  if (MC_capi == Py_None) MC = shape(IA,0); else
    f2py_success = int_from_pyobj(&MC,MC_capi,"libphsh.NBR() 3rd keyword (MC) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(IA,0)==MC,"shape(IA,0)==MC","3rd keyword MC","NBR:MC=%d",MC) {
  /* Processing variable N */
  if (N_capi == Py_None) N = shape(RK,1); else
    f2py_success = int_from_pyobj(&N,N_capi,"libphsh.NBR() 2nd keyword (N) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(RK,1)==N,"shape(RK,1)==N","2nd keyword N","NBR:N=%d",N) {
  /* Processing variable NR */
  if (NR_capi == Py_None) NR = shape(IA,1); else
    f2py_success = int_from_pyobj(&NR,NR_capi,"libphsh.NBR() 1st keyword (NR) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(IA,1)==NR,"shape(IA,1)==NR","1st keyword NR","NBR:NR=%d",NR) {
  /* Processing variable AD */
  AD_Dims[0]=MC,AD_Dims[1]=NR;
  capi_AD_intent |= F2PY_INTENT_IN;
  capi_AD_tmp = array_from_pyobj(NPY_DOUBLE,AD_Dims,AD_Rank,capi_AD_intent,AD_capi);
  if (capi_AD_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 3rd argument `AD' of libphsh.NBR to C/Fortran array" );
  } else {
    AD = (double *)(capi_AD_tmp->data);

  /* Processing variable NA */
  NA_Dims[0]=MC,NA_Dims[1]=NR;
  capi_NA_intent |= F2PY_INTENT_IN;
  capi_NA_tmp = array_from_pyobj(NPY_INT,NA_Dims,NA_Rank,capi_NA_intent,NA_capi);
  if (capi_NA_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `NA' of libphsh.NBR to C/Fortran array" );
  } else {
    NA = (int *)(capi_NA_tmp->data);

  /* Processing variable NCON */
  NCON_Dims[0]=NR;
  capi_NCON_intent |= F2PY_INTENT_IN;
  capi_NCON_tmp = array_from_pyobj(NPY_INT,NCON_Dims,NCON_Rank,capi_NCON_intent,NCON_capi);
  if (capi_NCON_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 4th argument `NCON' of libphsh.NBR to C/Fortran array" );
  } else {
    NCON = (int *)(capi_NCON_tmp->data);

  /* Processing variable NRR */
  NRR_Dims[0]=NR;
  capi_NRR_intent |= F2PY_INTENT_IN;
  capi_NRR_tmp = array_from_pyobj(NPY_INT,NRR_Dims,NRR_Rank,capi_NRR_intent,NRR_capi);
  if (capi_NRR_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 5th argument `NRR' of libphsh.NBR to C/Fortran array" );
  } else {
    NRR = (int *)(capi_NRR_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(IA,NA,AD,NCON,NRR,&NR,RC,RK,&N,&RMAX,&MC);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_NRR_tmp!=NRR_capi) {
    Py_XDECREF(capi_NRR_tmp); }
  }  /*if (capi_NRR_tmp == NULL) ... else of NRR*/
  /* End of cleaning variable NRR */
  if((PyObject *)capi_NCON_tmp!=NCON_capi) {
    Py_XDECREF(capi_NCON_tmp); }
  }  /*if (capi_NCON_tmp == NULL) ... else of NCON*/
  /* End of cleaning variable NCON */
  if((PyObject *)capi_NA_tmp!=NA_capi) {
    Py_XDECREF(capi_NA_tmp); }
  }  /*if (capi_NA_tmp == NULL) ... else of NA*/
  /* End of cleaning variable NA */
  if((PyObject *)capi_AD_tmp!=AD_capi) {
    Py_XDECREF(capi_AD_tmp); }
  }  /*if (capi_AD_tmp == NULL) ... else of AD*/
  /* End of cleaning variable AD */
  } /*CHECKSCALAR(shape(IA,1)==NR)*/
  } /*if (f2py_success) of NR*/
  /* End of cleaning variable NR */
  } /*CHECKSCALAR(shape(RK,1)==N)*/
  } /*if (f2py_success) of N*/
  /* End of cleaning variable N */
  } /*CHECKSCALAR(shape(IA,0)==MC)*/
  } /*if (f2py_success) of MC*/
  /* End of cleaning variable MC */
  if((PyObject *)capi_RK_tmp!=RK_capi) {
    Py_XDECREF(capi_RK_tmp); }
  }  /*if (capi_RK_tmp == NULL) ... else of RK*/
  /* End of cleaning variable RK */
  if((PyObject *)capi_IA_tmp!=IA_capi) {
    Py_XDECREF(capi_IA_tmp); }
  }  /*if (capi_IA_tmp == NULL) ... else of IA*/
  /* End of cleaning variable IA */
  if((PyObject *)capi_RC_tmp!=RC_capi) {
    Py_XDECREF(capi_RC_tmp); }
  }  /*if (capi_RC_tmp == NULL) ... else of RC*/
  /* End of cleaning variable RC */
  } /*if (f2py_success) of RMAX*/
  /* End of cleaning variable RMAX */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of NBR *********************************/

/*********************************** POISON ***********************************/
static char doc_f2py_rout_libphsh_POISON[] = "\
POISON(PSQ,Z,W,[J])\n\nWrapper for ``POISON``.\
\n\nParameters\n----------\n"
"PSQ : input rank-1 array('d') with bounds (J)\n"
"Z : input float\n"
"W : input rank-1 array('d') with bounds (J)\n"
"\nOther Parameters\n----------------\n"
"J : input int, optional\n    Default: len(PSQ)";
/* extern void F_FUNC(POISON,POISON)(double*,double*,int*,double*); */
static PyObject *f2py_rout_libphsh_POISON(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *PSQ = NULL;
  npy_intp PSQ_Dims[1] = {-1};
  const int PSQ_Rank = 1;
  PyArrayObject *capi_PSQ_tmp = NULL;
  int capi_PSQ_intent = 0;
  PyObject *PSQ_capi = Py_None;
  double Z = 0;
  PyObject *Z_capi = Py_None;
  int J = 0;
  PyObject *J_capi = Py_None;
  double *W = NULL;
  npy_intp W_Dims[1] = {-1};
  const int W_Rank = 1;
  PyArrayObject *capi_W_tmp = NULL;
  int capi_W_intent = 0;
  PyObject *W_capi = Py_None;
  static char *capi_kwlist[] = {"PSQ","Z","W","J",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|O:libphsh.POISON",\
    capi_kwlist,&PSQ_capi,&Z_capi,&W_capi,&J_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable PSQ */
  ;
  capi_PSQ_intent |= F2PY_INTENT_IN;
  capi_PSQ_tmp = array_from_pyobj(NPY_DOUBLE,PSQ_Dims,PSQ_Rank,capi_PSQ_intent,PSQ_capi);
  if (capi_PSQ_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `PSQ' of libphsh.POISON to C/Fortran array" );
  } else {
    PSQ = (double *)(capi_PSQ_tmp->data);

  /* Processing variable Z */
    f2py_success = double_from_pyobj(&Z,Z_capi,"libphsh.POISON() 2nd argument (Z) can't be converted to double");
  if (f2py_success) {
  /* Processing variable J */
  if (J_capi == Py_None) J = len(PSQ); else
    f2py_success = int_from_pyobj(&J,J_capi,"libphsh.POISON() 1st keyword (J) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(PSQ)>=J,"len(PSQ)>=J","1st keyword J","POISON:J=%d",J) {
  /* Processing variable W */
  W_Dims[0]=J;
  capi_W_intent |= F2PY_INTENT_IN;
  capi_W_tmp = array_from_pyobj(NPY_DOUBLE,W_Dims,W_Rank,capi_W_intent,W_capi);
  if (capi_W_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 3rd argument `W' of libphsh.POISON to C/Fortran array" );
  } else {
    W = (double *)(capi_W_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(PSQ,&Z,&J,W);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_W_tmp!=W_capi) {
    Py_XDECREF(capi_W_tmp); }
  }  /*if (capi_W_tmp == NULL) ... else of W*/
  /* End of cleaning variable W */
  } /*CHECKSCALAR(len(PSQ)>=J)*/
  } /*if (f2py_success) of J*/
  /* End of cleaning variable J */
  } /*if (f2py_success) of Z*/
  /* End of cleaning variable Z */
  if((PyObject *)capi_PSQ_tmp!=PSQ_capi) {
    Py_XDECREF(capi_PSQ_tmp); }
  }  /*if (capi_PSQ_tmp == NULL) ... else of PSQ*/
  /* End of cleaning variable PSQ */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of POISON *******************************/

/************************************ RELA ************************************/
static char doc_f2py_rout_libphsh_RELA[] = "\
RELA(RHO,RX,NX,[NGRID])\n\nWrapper for ``RELA``.\
\n\nParameters\n----------\n"
"RHO : input rank-1 array('d') with bounds (NGRID)\n"
"RX : input rank-1 array('d') with bounds (NGRID)\n"
"NX : input int\n"
"\nOther Parameters\n----------------\n"
"NGRID : input int, optional\n    Default: len(RHO)";
/* extern void F_FUNC(RELA,RELA)(double*,double*,int*,int*); */
static PyObject *f2py_rout_libphsh_RELA(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *RHO = NULL;
  npy_intp RHO_Dims[1] = {-1};
  const int RHO_Rank = 1;
  PyArrayObject *capi_RHO_tmp = NULL;
  int capi_RHO_intent = 0;
  PyObject *RHO_capi = Py_None;
  double *RX = NULL;
  npy_intp RX_Dims[1] = {-1};
  const int RX_Rank = 1;
  PyArrayObject *capi_RX_tmp = NULL;
  int capi_RX_intent = 0;
  PyObject *RX_capi = Py_None;
  int NX = 0;
  PyObject *NX_capi = Py_None;
  int NGRID = 0;
  PyObject *NGRID_capi = Py_None;
  static char *capi_kwlist[] = {"RHO","RX","NX","NGRID",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|O:libphsh.RELA",\
    capi_kwlist,&RHO_capi,&RX_capi,&NX_capi,&NGRID_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable NX */
    f2py_success = int_from_pyobj(&NX,NX_capi,"libphsh.RELA() 3rd argument (NX) can't be converted to int");
  if (f2py_success) {
  /* Processing variable RHO */
  ;
  capi_RHO_intent |= F2PY_INTENT_IN;
  capi_RHO_tmp = array_from_pyobj(NPY_DOUBLE,RHO_Dims,RHO_Rank,capi_RHO_intent,RHO_capi);
  if (capi_RHO_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `RHO' of libphsh.RELA to C/Fortran array" );
  } else {
    RHO = (double *)(capi_RHO_tmp->data);

  /* Processing variable NGRID */
  if (NGRID_capi == Py_None) NGRID = len(RHO); else
    f2py_success = int_from_pyobj(&NGRID,NGRID_capi,"libphsh.RELA() 1st keyword (NGRID) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(RHO)>=NGRID,"len(RHO)>=NGRID","1st keyword NGRID","RELA:NGRID=%d",NGRID) {
  /* Processing variable RX */
  RX_Dims[0]=NGRID;
  capi_RX_intent |= F2PY_INTENT_IN;
  capi_RX_tmp = array_from_pyobj(NPY_DOUBLE,RX_Dims,RX_Rank,capi_RX_intent,RX_capi);
  if (capi_RX_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `RX' of libphsh.RELA to C/Fortran array" );
  } else {
    RX = (double *)(capi_RX_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(RHO,RX,&NX,&NGRID);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_RX_tmp!=RX_capi) {
    Py_XDECREF(capi_RX_tmp); }
  }  /*if (capi_RX_tmp == NULL) ... else of RX*/
  /* End of cleaning variable RX */
  } /*CHECKSCALAR(len(RHO)>=NGRID)*/
  } /*if (f2py_success) of NGRID*/
  /* End of cleaning variable NGRID */
  if((PyObject *)capi_RHO_tmp!=RHO_capi) {
    Py_XDECREF(capi_RHO_tmp); }
  }  /*if (capi_RHO_tmp == NULL) ... else of RHO*/
  /* End of cleaning variable RHO */
  } /*if (f2py_success) of NX*/
  /* End of cleaning variable NX */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of RELA ********************************/

/*********************************** SUMAX ***********************************/
static char doc_f2py_rout_libphsh_SUMAX[] = "\
SUMAX(ACC,CHI,RX,NX,IA,NA,AD,IMAX,[NCON,NGRID,NR])\n\nWrapper for ``SUMAX``.\
\n\nParameters\n----------\n"
"ACC : input rank-1 array('d') with bounds (NGRID)\n"
"CHI : input rank-2 array('d') with bounds (NGRID,NR)\n"
"RX : input rank-1 array('d') with bounds (NGRID)\n"
"NX : input rank-1 array('i') with bounds (NR)\n"
"IA : input rank-1 array('i') with bounds (NCON)\n"
"NA : input rank-1 array('i') with bounds (NCON)\n"
"AD : input rank-1 array('d') with bounds (NCON)\n"
"IMAX : input int\n"
"\nOther Parameters\n----------------\n"
"NCON : input int, optional\n    Default: len(IA)\n"
"NGRID : input int, optional\n    Default: len(ACC)\n"
"NR : input int, optional\n    Default: shape(CHI,1)";
/* extern void F_FUNC(SUMAX,SUMAX)(double*,double*,double*,int*,int*,int*,int*,double*,int*,int*,int*); */
static PyObject *f2py_rout_libphsh_SUMAX(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,int*,int*,int*,int*,double*,int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *ACC = NULL;
  npy_intp ACC_Dims[1] = {-1};
  const int ACC_Rank = 1;
  PyArrayObject *capi_ACC_tmp = NULL;
  int capi_ACC_intent = 0;
  PyObject *ACC_capi = Py_None;
  double *CHI = NULL;
  npy_intp CHI_Dims[2] = {-1, -1};
  const int CHI_Rank = 2;
  PyArrayObject *capi_CHI_tmp = NULL;
  int capi_CHI_intent = 0;
  PyObject *CHI_capi = Py_None;
  double *RX = NULL;
  npy_intp RX_Dims[1] = {-1};
  const int RX_Rank = 1;
  PyArrayObject *capi_RX_tmp = NULL;
  int capi_RX_intent = 0;
  PyObject *RX_capi = Py_None;
  int *NX = NULL;
  npy_intp NX_Dims[1] = {-1};
  const int NX_Rank = 1;
  PyArrayObject *capi_NX_tmp = NULL;
  int capi_NX_intent = 0;
  PyObject *NX_capi = Py_None;
  int NCON = 0;
  PyObject *NCON_capi = Py_None;
  int *IA = NULL;
  npy_intp IA_Dims[1] = {-1};
  const int IA_Rank = 1;
  PyArrayObject *capi_IA_tmp = NULL;
  int capi_IA_intent = 0;
  PyObject *IA_capi = Py_None;
  int *NA = NULL;
  npy_intp NA_Dims[1] = {-1};
  const int NA_Rank = 1;
  PyArrayObject *capi_NA_tmp = NULL;
  int capi_NA_intent = 0;
  PyObject *NA_capi = Py_None;
  double *AD = NULL;
  npy_intp AD_Dims[1] = {-1};
  const int AD_Rank = 1;
  PyArrayObject *capi_AD_tmp = NULL;
  int capi_AD_intent = 0;
  PyObject *AD_capi = Py_None;
  int IMAX = 0;
  PyObject *IMAX_capi = Py_None;
  int NGRID = 0;
  PyObject *NGRID_capi = Py_None;
  int NR = 0;
  PyObject *NR_capi = Py_None;
  static char *capi_kwlist[] = {"ACC","CHI","RX","NX","IA","NA","AD","IMAX","NCON","NGRID","NR",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOO|OOO:libphsh.SUMAX",\
    capi_kwlist,&ACC_capi,&CHI_capi,&RX_capi,&NX_capi,&IA_capi,&NA_capi,&AD_capi,&IMAX_capi,&NCON_capi,&NGRID_capi,&NR_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable ACC */
  ;
  capi_ACC_intent |= F2PY_INTENT_IN;
  capi_ACC_tmp = array_from_pyobj(NPY_DOUBLE,ACC_Dims,ACC_Rank,capi_ACC_intent,ACC_capi);
  if (capi_ACC_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `ACC' of libphsh.SUMAX to C/Fortran array" );
  } else {
    ACC = (double *)(capi_ACC_tmp->data);

  /* Processing variable IMAX */
    f2py_success = int_from_pyobj(&IMAX,IMAX_capi,"libphsh.SUMAX() 8th argument (IMAX) can't be converted to int");
  if (f2py_success) {
  /* Processing variable IA */
  ;
  capi_IA_intent |= F2PY_INTENT_IN;
  capi_IA_tmp = array_from_pyobj(NPY_INT,IA_Dims,IA_Rank,capi_IA_intent,IA_capi);
  if (capi_IA_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 5th argument `IA' of libphsh.SUMAX to C/Fortran array" );
  } else {
    IA = (int *)(capi_IA_tmp->data);

  /* Processing variable NGRID */
  if (NGRID_capi == Py_None) NGRID = len(ACC); else
    f2py_success = int_from_pyobj(&NGRID,NGRID_capi,"libphsh.SUMAX() 2nd keyword (NGRID) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(ACC)>=NGRID,"len(ACC)>=NGRID","2nd keyword NGRID","SUMAX:NGRID=%d",NGRID) {
  /* Processing variable CHI */
  CHI_Dims[0]=NGRID;
  capi_CHI_intent |= F2PY_INTENT_IN;
  capi_CHI_tmp = array_from_pyobj(NPY_DOUBLE,CHI_Dims,CHI_Rank,capi_CHI_intent,CHI_capi);
  if (capi_CHI_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `CHI' of libphsh.SUMAX to C/Fortran array" );
  } else {
    CHI = (double *)(capi_CHI_tmp->data);

  /* Processing variable RX */
  RX_Dims[0]=NGRID;
  capi_RX_intent |= F2PY_INTENT_IN;
  capi_RX_tmp = array_from_pyobj(NPY_DOUBLE,RX_Dims,RX_Rank,capi_RX_intent,RX_capi);
  if (capi_RX_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 3rd argument `RX' of libphsh.SUMAX to C/Fortran array" );
  } else {
    RX = (double *)(capi_RX_tmp->data);

  /* Processing variable NCON */
  if (NCON_capi == Py_None) NCON = len(IA); else
    f2py_success = int_from_pyobj(&NCON,NCON_capi,"libphsh.SUMAX() 1st keyword (NCON) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(IA)>=NCON,"len(IA)>=NCON","1st keyword NCON","SUMAX:NCON=%d",NCON) {
  /* Processing variable NA */
  NA_Dims[0]=NCON;
  capi_NA_intent |= F2PY_INTENT_IN;
  capi_NA_tmp = array_from_pyobj(NPY_INT,NA_Dims,NA_Rank,capi_NA_intent,NA_capi);
  if (capi_NA_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 6th argument `NA' of libphsh.SUMAX to C/Fortran array" );
  } else {
    NA = (int *)(capi_NA_tmp->data);

  /* Processing variable NR */
  if (NR_capi == Py_None) NR = shape(CHI,1); else
    f2py_success = int_from_pyobj(&NR,NR_capi,"libphsh.SUMAX() 3rd keyword (NR) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(CHI,1)==NR,"shape(CHI,1)==NR","3rd keyword NR","SUMAX:NR=%d",NR) {
  /* Processing variable AD */
  AD_Dims[0]=NCON;
  capi_AD_intent |= F2PY_INTENT_IN;
  capi_AD_tmp = array_from_pyobj(NPY_DOUBLE,AD_Dims,AD_Rank,capi_AD_intent,AD_capi);
  if (capi_AD_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 7th argument `AD' of libphsh.SUMAX to C/Fortran array" );
  } else {
    AD = (double *)(capi_AD_tmp->data);

  /* Processing variable NX */
  NX_Dims[0]=NR;
  capi_NX_intent |= F2PY_INTENT_IN;
  capi_NX_tmp = array_from_pyobj(NPY_INT,NX_Dims,NX_Rank,capi_NX_intent,NX_capi);
  if (capi_NX_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 4th argument `NX' of libphsh.SUMAX to C/Fortran array" );
  } else {
    NX = (int *)(capi_NX_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(ACC,CHI,RX,NX,&NCON,IA,NA,AD,&IMAX,&NGRID,&NR);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_NX_tmp!=NX_capi) {
    Py_XDECREF(capi_NX_tmp); }
  }  /*if (capi_NX_tmp == NULL) ... else of NX*/
  /* End of cleaning variable NX */
  if((PyObject *)capi_AD_tmp!=AD_capi) {
    Py_XDECREF(capi_AD_tmp); }
  }  /*if (capi_AD_tmp == NULL) ... else of AD*/
  /* End of cleaning variable AD */
  } /*CHECKSCALAR(shape(CHI,1)==NR)*/
  } /*if (f2py_success) of NR*/
  /* End of cleaning variable NR */
  if((PyObject *)capi_NA_tmp!=NA_capi) {
    Py_XDECREF(capi_NA_tmp); }
  }  /*if (capi_NA_tmp == NULL) ... else of NA*/
  /* End of cleaning variable NA */
  } /*CHECKSCALAR(len(IA)>=NCON)*/
  } /*if (f2py_success) of NCON*/
  /* End of cleaning variable NCON */
  if((PyObject *)capi_RX_tmp!=RX_capi) {
    Py_XDECREF(capi_RX_tmp); }
  }  /*if (capi_RX_tmp == NULL) ... else of RX*/
  /* End of cleaning variable RX */
  if((PyObject *)capi_CHI_tmp!=CHI_capi) {
    Py_XDECREF(capi_CHI_tmp); }
  }  /*if (capi_CHI_tmp == NULL) ... else of CHI*/
  /* End of cleaning variable CHI */
  } /*CHECKSCALAR(len(ACC)>=NGRID)*/
  } /*if (f2py_success) of NGRID*/
  /* End of cleaning variable NGRID */
  if((PyObject *)capi_IA_tmp!=IA_capi) {
    Py_XDECREF(capi_IA_tmp); }
  }  /*if (capi_IA_tmp == NULL) ... else of IA*/
  /* End of cleaning variable IA */
  } /*if (f2py_success) of IMAX*/
  /* End of cleaning variable IMAX */
  if((PyObject *)capi_ACC_tmp!=ACC_capi) {
    Py_XDECREF(capi_ACC_tmp); }
  }  /*if (capi_ACC_tmp == NULL) ... else of ACC*/
  /* End of cleaning variable ACC */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of SUMAX ********************************/

/********************************** PHSH_CAV **********************************/
static char doc_f2py_rout_libphsh_PHSH_CAV[] = "\
PHSH_CAV(MUFFTIN_FILE,PHASOUT_FILE,DATAPH_FILE,ZPH_FILE)\n\nWrapper for ``PHSH_CAV``.\
\n\nParameters\n----------\n"
"MUFFTIN_FILE : in/output rank-0 array(string(len=-1),'c')\n"
"PHASOUT_FILE : in/output rank-0 array(string(len=-1),'c')\n"
"DATAPH_FILE : in/output rank-0 array(string(len=-1),'c')\n"
"ZPH_FILE : in/output rank-0 array(string(len=-1),'c')";
/* extern void F_FUNC_US(PHSH_CAV,PHSH_CAV)(string,string,string,string,size_t,size_t,size_t,size_t); */
static PyObject *f2py_rout_libphsh_PHSH_CAV(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,string,string,size_t,size_t,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string MUFFTIN_FILE = NULL;
  int slen(MUFFTIN_FILE);
  PyObject *MUFFTIN_FILE_capi = Py_None;
  string PHASOUT_FILE = NULL;
  int slen(PHASOUT_FILE);
  PyObject *PHASOUT_FILE_capi = Py_None;
  string DATAPH_FILE = NULL;
  int slen(DATAPH_FILE);
  PyObject *DATAPH_FILE_capi = Py_None;
  string ZPH_FILE = NULL;
  int slen(ZPH_FILE);
  PyObject *ZPH_FILE_capi = Py_None;
  static char *capi_kwlist[] = {"MUFFTIN_FILE","PHASOUT_FILE","DATAPH_FILE","ZPH_FILE",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO:libphsh.PHSH_CAV",\
    capi_kwlist,&MUFFTIN_FILE_capi,&PHASOUT_FILE_capi,&DATAPH_FILE_capi,&ZPH_FILE_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable DATAPH_FILE */
  slen(DATAPH_FILE) = -1;
  f2py_success = string_from_pyobj(&DATAPH_FILE,&slen(DATAPH_FILE),"",DATAPH_FILE_capi,"string_from_pyobj failed in converting 3rd argument `DATAPH_FILE' of libphsh.PHSH_CAV to C string");
  if (f2py_success) {
  /* Processing variable MUFFTIN_FILE */
  slen(MUFFTIN_FILE) = -1;
  f2py_success = string_from_pyobj(&MUFFTIN_FILE,&slen(MUFFTIN_FILE),"",MUFFTIN_FILE_capi,"string_from_pyobj failed in converting 1st argument `MUFFTIN_FILE' of libphsh.PHSH_CAV to C string");
  if (f2py_success) {
  /* Processing variable ZPH_FILE */
  slen(ZPH_FILE) = -1;
  f2py_success = string_from_pyobj(&ZPH_FILE,&slen(ZPH_FILE),"",ZPH_FILE_capi,"string_from_pyobj failed in converting 4th argument `ZPH_FILE' of libphsh.PHSH_CAV to C string");
  if (f2py_success) {
  /* Processing variable PHASOUT_FILE */
  slen(PHASOUT_FILE) = -1;
  f2py_success = string_from_pyobj(&PHASOUT_FILE,&slen(PHASOUT_FILE),"",PHASOUT_FILE_capi,"string_from_pyobj failed in converting 2nd argument `PHASOUT_FILE' of libphsh.PHSH_CAV to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(MUFFTIN_FILE,PHASOUT_FILE,DATAPH_FILE,ZPH_FILE,slen(MUFFTIN_FILE),slen(PHASOUT_FILE),slen(DATAPH_FILE),slen(ZPH_FILE));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
  f2py_success = try_pyarr_from_string(MUFFTIN_FILE_capi,MUFFTIN_FILE);
  if (f2py_success) {
  f2py_success = try_pyarr_from_string(PHASOUT_FILE_capi,PHASOUT_FILE);
  if (f2py_success) {
  f2py_success = try_pyarr_from_string(DATAPH_FILE_capi,DATAPH_FILE);
  if (f2py_success) {
  f2py_success = try_pyarr_from_string(ZPH_FILE_capi,ZPH_FILE);
  if (f2py_success) {
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
  } /*if (f2py_success) of ZPH_FILE pyobjfrom*/
  } /*if (f2py_success) of DATAPH_FILE pyobjfrom*/
  } /*if (f2py_success) of PHASOUT_FILE pyobjfrom*/
  } /*if (f2py_success) of MUFFTIN_FILE pyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(PHASOUT_FILE);
  }  /*if (f2py_success) of PHASOUT_FILE*/
  /* End of cleaning variable PHASOUT_FILE */
    STRINGFREE(ZPH_FILE);
  }  /*if (f2py_success) of ZPH_FILE*/
  /* End of cleaning variable ZPH_FILE */
    STRINGFREE(MUFFTIN_FILE);
  }  /*if (f2py_success) of MUFFTIN_FILE*/
  /* End of cleaning variable MUFFTIN_FILE */
    STRINGFREE(DATAPH_FILE);
  }  /*if (f2py_success) of DATAPH_FILE*/
  /* End of cleaning variable DATAPH_FILE */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of PHSH_CAV ******************************/

/************************************* PS *************************************/
static char doc_f2py_rout_libphsh_PS[] = "\
PS(V,RX,RAD,E,PHS,FILE_UNIT,[NGRID,NL])\n\nWrapper for ``PS``.\
\n\nParameters\n----------\n"
"V : input rank-1 array('d') with bounds (NGRID)\n"
"RX : input rank-1 array('d') with bounds (NGRID)\n"
"RAD : input float\n"
"E : input float\n"
"PHS : input rank-1 array('d') with bounds (NL)\n"
"FILE_UNIT : input int\n"
"\nOther Parameters\n----------------\n"
"NGRID : input int, optional\n    Default: len(V)\n"
"NL : input int, optional\n    Default: len(PHS)";
/* extern void F_FUNC(PS,PS)(double*,double*,int*,double*,double*,double*,int*,int*); */
static PyObject *f2py_rout_libphsh_PS(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,double*,double*,double*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *V = NULL;
  npy_intp V_Dims[1] = {-1};
  const int V_Rank = 1;
  PyArrayObject *capi_V_tmp = NULL;
  int capi_V_intent = 0;
  PyObject *V_capi = Py_None;
  double *RX = NULL;
  npy_intp RX_Dims[1] = {-1};
  const int RX_Rank = 1;
  PyArrayObject *capi_RX_tmp = NULL;
  int capi_RX_intent = 0;
  PyObject *RX_capi = Py_None;
  int NGRID = 0;
  PyObject *NGRID_capi = Py_None;
  double RAD = 0;
  PyObject *RAD_capi = Py_None;
  double E = 0;
  PyObject *E_capi = Py_None;
  double *PHS = NULL;
  npy_intp PHS_Dims[1] = {-1};
  const int PHS_Rank = 1;
  PyArrayObject *capi_PHS_tmp = NULL;
  int capi_PHS_intent = 0;
  PyObject *PHS_capi = Py_None;
  int NL = 0;
  PyObject *NL_capi = Py_None;
  int FILE_UNIT = 0;
  PyObject *FILE_UNIT_capi = Py_None;
  static char *capi_kwlist[] = {"V","RX","RAD","E","PHS","FILE_UNIT","NGRID","NL",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOO|OO:libphsh.PS",\
    capi_kwlist,&V_capi,&RX_capi,&RAD_capi,&E_capi,&PHS_capi,&FILE_UNIT_capi,&NGRID_capi,&NL_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable E */
    f2py_success = double_from_pyobj(&E,E_capi,"libphsh.PS() 4th argument (E) can't be converted to double");
  if (f2py_success) {
  /* Processing variable FILE_UNIT */
    f2py_success = int_from_pyobj(&FILE_UNIT,FILE_UNIT_capi,"libphsh.PS() 6th argument (FILE_UNIT) can't be converted to int");
  if (f2py_success) {
  /* Processing variable V */
  ;
  capi_V_intent |= F2PY_INTENT_IN;
  capi_V_tmp = array_from_pyobj(NPY_DOUBLE,V_Dims,V_Rank,capi_V_intent,V_capi);
  if (capi_V_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `V' of libphsh.PS to C/Fortran array" );
  } else {
    V = (double *)(capi_V_tmp->data);

  /* Processing variable RAD */
    f2py_success = double_from_pyobj(&RAD,RAD_capi,"libphsh.PS() 3rd argument (RAD) can't be converted to double");
  if (f2py_success) {
  /* Processing variable PHS */
  ;
  capi_PHS_intent |= F2PY_INTENT_IN;
  capi_PHS_tmp = array_from_pyobj(NPY_DOUBLE,PHS_Dims,PHS_Rank,capi_PHS_intent,PHS_capi);
  if (capi_PHS_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 5th argument `PHS' of libphsh.PS to C/Fortran array" );
  } else {
    PHS = (double *)(capi_PHS_tmp->data);

  /* Processing variable NGRID */
  if (NGRID_capi == Py_None) NGRID = len(V); else
    f2py_success = int_from_pyobj(&NGRID,NGRID_capi,"libphsh.PS() 1st keyword (NGRID) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(V)>=NGRID,"len(V)>=NGRID","1st keyword NGRID","PS:NGRID=%d",NGRID) {
  /* Processing variable NL */
  if (NL_capi == Py_None) NL = len(PHS); else
    f2py_success = int_from_pyobj(&NL,NL_capi,"libphsh.PS() 2nd keyword (NL) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(PHS)>=NL,"len(PHS)>=NL","2nd keyword NL","PS:NL=%d",NL) {
  /* Processing variable RX */
  RX_Dims[0]=NGRID;
  capi_RX_intent |= F2PY_INTENT_IN;
  capi_RX_tmp = array_from_pyobj(NPY_DOUBLE,RX_Dims,RX_Rank,capi_RX_intent,RX_capi);
  if (capi_RX_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `RX' of libphsh.PS to C/Fortran array" );
  } else {
    RX = (double *)(capi_RX_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(V,RX,&NGRID,&RAD,&E,PHS,&NL,&FILE_UNIT);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_RX_tmp!=RX_capi) {
    Py_XDECREF(capi_RX_tmp); }
  }  /*if (capi_RX_tmp == NULL) ... else of RX*/
  /* End of cleaning variable RX */
  } /*CHECKSCALAR(len(PHS)>=NL)*/
  } /*if (f2py_success) of NL*/
  /* End of cleaning variable NL */
  } /*CHECKSCALAR(len(V)>=NGRID)*/
  } /*if (f2py_success) of NGRID*/
  /* End of cleaning variable NGRID */
  if((PyObject *)capi_PHS_tmp!=PHS_capi) {
    Py_XDECREF(capi_PHS_tmp); }
  }  /*if (capi_PHS_tmp == NULL) ... else of PHS*/
  /* End of cleaning variable PHS */
  } /*if (f2py_success) of RAD*/
  /* End of cleaning variable RAD */
  if((PyObject *)capi_V_tmp!=V_capi) {
    Py_XDECREF(capi_V_tmp); }
  }  /*if (capi_V_tmp == NULL) ... else of V*/
  /* End of cleaning variable V */
  } /*if (f2py_success) of FILE_UNIT*/
  /* End of cleaning variable FILE_UNIT */
  } /*if (f2py_success) of E*/
  /* End of cleaning variable E */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of PS *********************************/

/*********************************** CALCBF ***********************************/
static char doc_f2py_rout_libphsh_CALCBF[] = "\
CALCBF(BJ,BN,X,FILE_UNIT,[NL])\n\nWrapper for ``CALCBF``.\
\n\nParameters\n----------\n"
"BJ : input rank-1 array('d') with bounds (NL)\n"
"BN : input rank-1 array('d') with bounds (NL)\n"
"X : input float\n"
"FILE_UNIT : input int\n"
"\nOther Parameters\n----------------\n"
"NL : input int, optional\n    Default: len(BJ)";
/* extern void F_FUNC(CALCBF,CALCBF)(double*,double*,int*,double*,int*); */
static PyObject *f2py_rout_libphsh_CALCBF(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *BJ = NULL;
  npy_intp BJ_Dims[1] = {-1};
  const int BJ_Rank = 1;
  PyArrayObject *capi_BJ_tmp = NULL;
  int capi_BJ_intent = 0;
  PyObject *BJ_capi = Py_None;
  double *BN = NULL;
  npy_intp BN_Dims[1] = {-1};
  const int BN_Rank = 1;
  PyArrayObject *capi_BN_tmp = NULL;
  int capi_BN_intent = 0;
  PyObject *BN_capi = Py_None;
  int NL = 0;
  PyObject *NL_capi = Py_None;
  double X = 0;
  PyObject *X_capi = Py_None;
  int FILE_UNIT = 0;
  PyObject *FILE_UNIT_capi = Py_None;
  static char *capi_kwlist[] = {"BJ","BN","X","FILE_UNIT","NL",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O:libphsh.CALCBF",\
    capi_kwlist,&BJ_capi,&BN_capi,&X_capi,&FILE_UNIT_capi,&NL_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable X */
    f2py_success = double_from_pyobj(&X,X_capi,"libphsh.CALCBF() 3rd argument (X) can't be converted to double");
  if (f2py_success) {
  /* Processing variable FILE_UNIT */
    f2py_success = int_from_pyobj(&FILE_UNIT,FILE_UNIT_capi,"libphsh.CALCBF() 4th argument (FILE_UNIT) can't be converted to int");
  if (f2py_success) {
  /* Processing variable BJ */
  ;
  capi_BJ_intent |= F2PY_INTENT_IN;
  capi_BJ_tmp = array_from_pyobj(NPY_DOUBLE,BJ_Dims,BJ_Rank,capi_BJ_intent,BJ_capi);
  if (capi_BJ_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `BJ' of libphsh.CALCBF to C/Fortran array" );
  } else {
    BJ = (double *)(capi_BJ_tmp->data);

  /* Processing variable NL */
  if (NL_capi == Py_None) NL = len(BJ); else
    f2py_success = int_from_pyobj(&NL,NL_capi,"libphsh.CALCBF() 1st keyword (NL) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(BJ)>=NL,"len(BJ)>=NL","1st keyword NL","CALCBF:NL=%d",NL) {
  /* Processing variable BN */
  BN_Dims[0]=NL;
  capi_BN_intent |= F2PY_INTENT_IN;
  capi_BN_tmp = array_from_pyobj(NPY_DOUBLE,BN_Dims,BN_Rank,capi_BN_intent,BN_capi);
  if (capi_BN_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `BN' of libphsh.CALCBF to C/Fortran array" );
  } else {
    BN = (double *)(capi_BN_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(BJ,BN,&NL,&X,&FILE_UNIT);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_BN_tmp!=BN_capi) {
    Py_XDECREF(capi_BN_tmp); }
  }  /*if (capi_BN_tmp == NULL) ... else of BN*/
  /* End of cleaning variable BN */
  } /*CHECKSCALAR(len(BJ)>=NL)*/
  } /*if (f2py_success) of NL*/
  /* End of cleaning variable NL */
  if((PyObject *)capi_BJ_tmp!=BJ_capi) {
    Py_XDECREF(capi_BJ_tmp); }
  }  /*if (capi_BJ_tmp == NULL) ... else of BJ*/
  /* End of cleaning variable BJ */
  } /*if (f2py_success) of FILE_UNIT*/
  /* End of cleaning variable FILE_UNIT */
  } /*if (f2py_success) of X*/
  /* End of cleaning variable X */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of CALCBF *******************************/

/********************************** PHSH_WIL **********************************/
static char doc_f2py_rout_libphsh_PHSH_WIL[] = "\
PHSH_WIL(MUFFTIN_FILE,PHASOUT_FILE,DATAPH_FILE,ZPH_FILE)\n\nWrapper for ``PHSH_WIL``.\
\n\nParameters\n----------\n"
"MUFFTIN_FILE : in/output rank-0 array(string(len=-1),'c')\n"
"PHASOUT_FILE : in/output rank-0 array(string(len=-1),'c')\n"
"DATAPH_FILE : in/output rank-0 array(string(len=-1),'c')\n"
"ZPH_FILE : in/output rank-0 array(string(len=-1),'c')";
/* extern void F_FUNC_US(PHSH_WIL,PHSH_WIL)(string,string,string,string,size_t,size_t,size_t,size_t); */
static PyObject *f2py_rout_libphsh_PHSH_WIL(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,string,string,size_t,size_t,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string MUFFTIN_FILE = NULL;
  int slen(MUFFTIN_FILE);
  PyObject *MUFFTIN_FILE_capi = Py_None;
  string PHASOUT_FILE = NULL;
  int slen(PHASOUT_FILE);
  PyObject *PHASOUT_FILE_capi = Py_None;
  string DATAPH_FILE = NULL;
  int slen(DATAPH_FILE);
  PyObject *DATAPH_FILE_capi = Py_None;
  string ZPH_FILE = NULL;
  int slen(ZPH_FILE);
  PyObject *ZPH_FILE_capi = Py_None;
  static char *capi_kwlist[] = {"MUFFTIN_FILE","PHASOUT_FILE","DATAPH_FILE","ZPH_FILE",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO:libphsh.PHSH_WIL",\
    capi_kwlist,&MUFFTIN_FILE_capi,&PHASOUT_FILE_capi,&DATAPH_FILE_capi,&ZPH_FILE_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable DATAPH_FILE */
  slen(DATAPH_FILE) = -1;
  f2py_success = string_from_pyobj(&DATAPH_FILE,&slen(DATAPH_FILE),"",DATAPH_FILE_capi,"string_from_pyobj failed in converting 3rd argument `DATAPH_FILE' of libphsh.PHSH_WIL to C string");
  if (f2py_success) {
  /* Processing variable MUFFTIN_FILE */
  slen(MUFFTIN_FILE) = -1;
  f2py_success = string_from_pyobj(&MUFFTIN_FILE,&slen(MUFFTIN_FILE),"",MUFFTIN_FILE_capi,"string_from_pyobj failed in converting 1st argument `MUFFTIN_FILE' of libphsh.PHSH_WIL to C string");
  if (f2py_success) {
  /* Processing variable ZPH_FILE */
  slen(ZPH_FILE) = -1;
  f2py_success = string_from_pyobj(&ZPH_FILE,&slen(ZPH_FILE),"",ZPH_FILE_capi,"string_from_pyobj failed in converting 4th argument `ZPH_FILE' of libphsh.PHSH_WIL to C string");
  if (f2py_success) {
  /* Processing variable PHASOUT_FILE */
  slen(PHASOUT_FILE) = -1;
  f2py_success = string_from_pyobj(&PHASOUT_FILE,&slen(PHASOUT_FILE),"",PHASOUT_FILE_capi,"string_from_pyobj failed in converting 2nd argument `PHASOUT_FILE' of libphsh.PHSH_WIL to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(MUFFTIN_FILE,PHASOUT_FILE,DATAPH_FILE,ZPH_FILE,slen(MUFFTIN_FILE),slen(PHASOUT_FILE),slen(DATAPH_FILE),slen(ZPH_FILE));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
  f2py_success = try_pyarr_from_string(MUFFTIN_FILE_capi,MUFFTIN_FILE);
  if (f2py_success) {
  f2py_success = try_pyarr_from_string(PHASOUT_FILE_capi,PHASOUT_FILE);
  if (f2py_success) {
  f2py_success = try_pyarr_from_string(DATAPH_FILE_capi,DATAPH_FILE);
  if (f2py_success) {
  f2py_success = try_pyarr_from_string(ZPH_FILE_capi,ZPH_FILE);
  if (f2py_success) {
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
  } /*if (f2py_success) of ZPH_FILE pyobjfrom*/
  } /*if (f2py_success) of DATAPH_FILE pyobjfrom*/
  } /*if (f2py_success) of PHASOUT_FILE pyobjfrom*/
  } /*if (f2py_success) of MUFFTIN_FILE pyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(PHASOUT_FILE);
  }  /*if (f2py_success) of PHASOUT_FILE*/
  /* End of cleaning variable PHASOUT_FILE */
    STRINGFREE(ZPH_FILE);
  }  /*if (f2py_success) of ZPH_FILE*/
  /* End of cleaning variable ZPH_FILE */
    STRINGFREE(MUFFTIN_FILE);
  }  /*if (f2py_success) of MUFFTIN_FILE*/
  /* End of cleaning variable MUFFTIN_FILE */
    STRINGFREE(DATAPH_FILE);
  }  /*if (f2py_success) of DATAPH_FILE*/
  /* End of cleaning variable DATAPH_FILE */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of PHSH_WIL ******************************/

/************************************ S16 ************************************/
static char doc_f2py_rout_libphsh_S16[] = "\
S16()\n\nWrapper for ``S16``.\
\n";
/* extern void F_FUNC(S16,S16)(void); */
static PyObject *f2py_rout_libphsh_S16(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":libphsh.S16",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of S16 *********************************/

/************************************ F12 ************************************/
static char doc_f2py_rout_libphsh_F12[] = "\
F12 = F12(X,Y,Z,N)\n\nWrapper for ``F12``.\
\n\nParameters\n----------\n"
"X : input rank-1 array('f') with bounds (10)\n"
"Y : input rank-1 array('f') with bounds (10)\n"
"Z : input float\n"
"N : input int\n"
"\nReturns\n-------\n"
"F12 : float";
/* extern void F_WRAPPEDFUNC(f12,F12)(double*,float*,float*,double*,int*); */
static PyObject *f2py_rout_libphsh_F12(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,float*,float*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double F12 = 0;
  float *X = NULL;
  npy_intp X_Dims[1] = {-1};
  const int X_Rank = 1;
  PyArrayObject *capi_X_tmp = NULL;
  int capi_X_intent = 0;
  PyObject *X_capi = Py_None;
  float *Y = NULL;
  npy_intp Y_Dims[1] = {-1};
  const int Y_Rank = 1;
  PyArrayObject *capi_Y_tmp = NULL;
  int capi_Y_intent = 0;
  PyObject *Y_capi = Py_None;
  double Z = 0;
  PyObject *Z_capi = Py_None;
  int N = 0;
  PyObject *N_capi = Py_None;
  static char *capi_kwlist[] = {"X","Y","Z","N",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO:libphsh.F12",\
    capi_kwlist,&X_capi,&Y_capi,&Z_capi,&N_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable N */
    f2py_success = int_from_pyobj(&N,N_capi,"libphsh.F12() 4th argument (N) can't be converted to int");
  if (f2py_success) {
  /* Processing variable F12 */
  /* Processing variable Y */
  Y_Dims[0]=10;
  capi_Y_intent |= F2PY_INTENT_IN;
  capi_Y_tmp = array_from_pyobj(NPY_FLOAT,Y_Dims,Y_Rank,capi_Y_intent,Y_capi);
  if (capi_Y_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `Y' of libphsh.F12 to C/Fortran array" );
  } else {
    Y = (float *)(capi_Y_tmp->data);

  /* Processing variable X */
  X_Dims[0]=10;
  capi_X_intent |= F2PY_INTENT_IN;
  capi_X_tmp = array_from_pyobj(NPY_FLOAT,X_Dims,X_Rank,capi_X_intent,X_capi);
  if (capi_X_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `X' of libphsh.F12 to C/Fortran array" );
  } else {
    X = (float *)(capi_X_tmp->data);

  /* Processing variable Z */
    f2py_success = double_from_pyobj(&Z,Z_capi,"libphsh.F12() 3rd argument (Z) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&F12,X,Y,&Z,&N);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",F12);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of Z*/
  /* End of cleaning variable Z */
  if((PyObject *)capi_X_tmp!=X_capi) {
    Py_XDECREF(capi_X_tmp); }
  }  /*if (capi_X_tmp == NULL) ... else of X*/
  /* End of cleaning variable X */
  if((PyObject *)capi_Y_tmp!=Y_capi) {
    Py_XDECREF(capi_Y_tmp); }
  }  /*if (capi_Y_tmp == NULL) ... else of Y*/
  /* End of cleaning variable Y */
  /* End of cleaning variable F12 */
  } /*if (f2py_success) of N*/
  /* End of cleaning variable N */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of F12 *********************************/

/************************************* S5 *************************************/
static char doc_f2py_rout_libphsh_S5[] = "\
S5(E)\n\nWrapper for ``S5``.\
\n\nParameters\n----------\n"
"E : input float";
/* extern void F_FUNC(S5,S5)(double*); */
static PyObject *f2py_rout_libphsh_S5(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double E = 0;
  PyObject *E_capi = Py_None;
  static char *capi_kwlist[] = {"E",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:libphsh.S5",\
    capi_kwlist,&E_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable E */
    f2py_success = double_from_pyobj(&E,E_capi,"libphsh.S5() 1st argument (E) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&E);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of E*/
  /* End of cleaning variable E */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of S5 *********************************/

/************************************ S10 ************************************/
static char doc_f2py_rout_libphsh_S10[] = "\
S10(E)\n\nWrapper for ``S10``.\
\n\nParameters\n----------\n"
"E : input float";
/* extern void F_FUNC(S10,S10)(double*); */
static PyObject *f2py_rout_libphsh_S10(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double E = 0;
  PyObject *E_capi = Py_None;
  static char *capi_kwlist[] = {"E",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:libphsh.S10",\
    capi_kwlist,&E_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable E */
    f2py_success = double_from_pyobj(&E,E_capi,"libphsh.S10() 1st argument (E) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&E);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of E*/
  /* End of cleaning variable E */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of S10 *********************************/

/************************************ F44 ************************************/
static char doc_f2py_rout_libphsh_F44[] = "\
F44 = F44(L,X)\n\nWrapper for ``F44``.\
\n\nParameters\n----------\n"
"L : input int\n"
"X : input float\n"
"\nReturns\n-------\n"
"F44 : float";
/* extern void F_WRAPPEDFUNC(f44,F44)(double*,int*,double*); */
static PyObject *f2py_rout_libphsh_F44(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double F44 = 0;
  int L = 0;
  PyObject *L_capi = Py_None;
  double X = 0;
  PyObject *X_capi = Py_None;
  static char *capi_kwlist[] = {"L","X",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO:libphsh.F44",\
    capi_kwlist,&L_capi,&X_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable X */
    f2py_success = double_from_pyobj(&X,X_capi,"libphsh.F44() 2nd argument (X) can't be converted to double");
  if (f2py_success) {
  /* Processing variable L */
    f2py_success = int_from_pyobj(&L,L_capi,"libphsh.F44() 1st argument (L) can't be converted to int");
  if (f2py_success) {
  /* Processing variable F44 */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&F44,&L,&X);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",F44);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable F44 */
  } /*if (f2py_success) of L*/
  /* End of cleaning variable L */
  } /*if (f2py_success) of X*/
  /* End of cleaning variable X */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of F44 *********************************/

/************************************ F45 ************************************/
static char doc_f2py_rout_libphsh_F45[] = "\
F45 = F45(L,X)\n\nWrapper for ``F45``.\
\n\nParameters\n----------\n"
"L : input int\n"
"X : input float\n"
"\nReturns\n-------\n"
"F45 : float";
/* extern void F_WRAPPEDFUNC(f45,F45)(double*,int*,double*); */
static PyObject *f2py_rout_libphsh_F45(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double F45 = 0;
  int L = 0;
  PyObject *L_capi = Py_None;
  double X = 0;
  PyObject *X_capi = Py_None;
  static char *capi_kwlist[] = {"L","X",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO:libphsh.F45",\
    capi_kwlist,&L_capi,&X_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable X */
    f2py_success = double_from_pyobj(&X,X_capi,"libphsh.F45() 2nd argument (X) can't be converted to double");
  if (f2py_success) {
  /* Processing variable F45 */
  /* Processing variable L */
    f2py_success = int_from_pyobj(&L,L_capi,"libphsh.F45() 1st argument (L) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&F45,&L,&X);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",F45);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of L*/
  /* End of cleaning variable L */
  /* End of cleaning variable F45 */
  } /*if (f2py_success) of X*/
  /* End of cleaning variable X */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of F45 *********************************/

/************************************ S41 ************************************/
static char doc_f2py_rout_libphsh_S41[] = "\
S41(X,Y,N)\n\nWrapper for ``S41``.\
\n\nParameters\n----------\n"
"X : input rank-1 array('d') with bounds (100)\n"
"Y : input rank-1 array('d') with bounds (100)\n"
"N : input int";
/* extern void F_FUNC(S41,S41)(double*,double*,int*); */
static PyObject *f2py_rout_libphsh_S41(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *X = NULL;
  npy_intp X_Dims[1] = {-1};
  const int X_Rank = 1;
  PyArrayObject *capi_X_tmp = NULL;
  int capi_X_intent = 0;
  PyObject *X_capi = Py_None;
  double *Y = NULL;
  npy_intp Y_Dims[1] = {-1};
  const int Y_Rank = 1;
  PyArrayObject *capi_Y_tmp = NULL;
  int capi_Y_intent = 0;
  PyObject *Y_capi = Py_None;
  int N = 0;
  PyObject *N_capi = Py_None;
  static char *capi_kwlist[] = {"X","Y","N",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO:libphsh.S41",\
    capi_kwlist,&X_capi,&Y_capi,&N_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable N */
    f2py_success = int_from_pyobj(&N,N_capi,"libphsh.S41() 3rd argument (N) can't be converted to int");
  if (f2py_success) {
  /* Processing variable Y */
  Y_Dims[0]=100;
  capi_Y_intent |= F2PY_INTENT_IN;
  capi_Y_tmp = array_from_pyobj(NPY_DOUBLE,Y_Dims,Y_Rank,capi_Y_intent,Y_capi);
  if (capi_Y_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 2nd argument `Y' of libphsh.S41 to C/Fortran array" );
  } else {
    Y = (double *)(capi_Y_tmp->data);

  /* Processing variable X */
  X_Dims[0]=100;
  capi_X_intent |= F2PY_INTENT_IN;
  capi_X_tmp = array_from_pyobj(NPY_DOUBLE,X_Dims,X_Rank,capi_X_intent,X_capi);
  if (capi_X_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(libphsh_error,"failed in converting 1st argument `X' of libphsh.S41 to C/Fortran array" );
  } else {
    X = (double *)(capi_X_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(X,Y,&N);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_X_tmp!=X_capi) {
    Py_XDECREF(capi_X_tmp); }
  }  /*if (capi_X_tmp == NULL) ... else of X*/
  /* End of cleaning variable X */
  if((PyObject *)capi_Y_tmp!=Y_capi) {
    Py_XDECREF(capi_Y_tmp); }
  }  /*if (capi_Y_tmp == NULL) ... else of Y*/
  /* End of cleaning variable Y */
  } /*if (f2py_success) of N*/
  /* End of cleaning variable N */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of S41 *********************************/

/********************************** PHSH_REL **********************************/
static char doc_f2py_rout_libphsh_PHSH_REL[] = "\
PHSH_REL(MUFFTIN_FILE,PHASOUT_FILE,DATAPH_FILE,INPDAT_FILE)\n\nWrapper for ``PHSH_REL``.\
\n\nParameters\n----------\n"
"MUFFTIN_FILE : in/output rank-0 array(string(len=-1),'c')\n"
"PHASOUT_FILE : in/output rank-0 array(string(len=-1),'c')\n"
"DATAPH_FILE : in/output rank-0 array(string(len=-1),'c')\n"
"INPDAT_FILE : in/output rank-0 array(string(len=-1),'c')";
/* extern void F_FUNC_US(PHSH_REL,PHSH_REL)(string,string,string,string,size_t,size_t,size_t,size_t); */
static PyObject *f2py_rout_libphsh_PHSH_REL(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,string,string,size_t,size_t,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string MUFFTIN_FILE = NULL;
  int slen(MUFFTIN_FILE);
  PyObject *MUFFTIN_FILE_capi = Py_None;
  string PHASOUT_FILE = NULL;
  int slen(PHASOUT_FILE);
  PyObject *PHASOUT_FILE_capi = Py_None;
  string DATAPH_FILE = NULL;
  int slen(DATAPH_FILE);
  PyObject *DATAPH_FILE_capi = Py_None;
  string INPDAT_FILE = NULL;
  int slen(INPDAT_FILE);
  PyObject *INPDAT_FILE_capi = Py_None;
  static char *capi_kwlist[] = {"MUFFTIN_FILE","PHASOUT_FILE","DATAPH_FILE","INPDAT_FILE",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO:libphsh.PHSH_REL",\
    capi_kwlist,&MUFFTIN_FILE_capi,&PHASOUT_FILE_capi,&DATAPH_FILE_capi,&INPDAT_FILE_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable DATAPH_FILE */
  slen(DATAPH_FILE) = -1;
  f2py_success = string_from_pyobj(&DATAPH_FILE,&slen(DATAPH_FILE),"",DATAPH_FILE_capi,"string_from_pyobj failed in converting 3rd argument `DATAPH_FILE' of libphsh.PHSH_REL to C string");
  if (f2py_success) {
  /* Processing variable INPDAT_FILE */
  slen(INPDAT_FILE) = -1;
  f2py_success = string_from_pyobj(&INPDAT_FILE,&slen(INPDAT_FILE),"",INPDAT_FILE_capi,"string_from_pyobj failed in converting 4th argument `INPDAT_FILE' of libphsh.PHSH_REL to C string");
  if (f2py_success) {
  /* Processing variable PHASOUT_FILE */
  slen(PHASOUT_FILE) = -1;
  f2py_success = string_from_pyobj(&PHASOUT_FILE,&slen(PHASOUT_FILE),"",PHASOUT_FILE_capi,"string_from_pyobj failed in converting 2nd argument `PHASOUT_FILE' of libphsh.PHSH_REL to C string");
  if (f2py_success) {
  /* Processing variable MUFFTIN_FILE */
  slen(MUFFTIN_FILE) = -1;
  f2py_success = string_from_pyobj(&MUFFTIN_FILE,&slen(MUFFTIN_FILE),"",MUFFTIN_FILE_capi,"string_from_pyobj failed in converting 1st argument `MUFFTIN_FILE' of libphsh.PHSH_REL to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(MUFFTIN_FILE,PHASOUT_FILE,DATAPH_FILE,INPDAT_FILE,slen(MUFFTIN_FILE),slen(PHASOUT_FILE),slen(DATAPH_FILE),slen(INPDAT_FILE));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
  f2py_success = try_pyarr_from_string(MUFFTIN_FILE_capi,MUFFTIN_FILE);
  if (f2py_success) {
  f2py_success = try_pyarr_from_string(PHASOUT_FILE_capi,PHASOUT_FILE);
  if (f2py_success) {
  f2py_success = try_pyarr_from_string(DATAPH_FILE_capi,DATAPH_FILE);
  if (f2py_success) {
  f2py_success = try_pyarr_from_string(INPDAT_FILE_capi,INPDAT_FILE);
  if (f2py_success) {
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
  } /*if (f2py_success) of INPDAT_FILE pyobjfrom*/
  } /*if (f2py_success) of DATAPH_FILE pyobjfrom*/
  } /*if (f2py_success) of PHASOUT_FILE pyobjfrom*/
  } /*if (f2py_success) of MUFFTIN_FILE pyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(MUFFTIN_FILE);
  }  /*if (f2py_success) of MUFFTIN_FILE*/
  /* End of cleaning variable MUFFTIN_FILE */
    STRINGFREE(PHASOUT_FILE);
  }  /*if (f2py_success) of PHASOUT_FILE*/
  /* End of cleaning variable PHASOUT_FILE */
    STRINGFREE(INPDAT_FILE);
  }  /*if (f2py_success) of INPDAT_FILE*/
  /* End of cleaning variable INPDAT_FILE */
    STRINGFREE(DATAPH_FILE);
  }  /*if (f2py_success) of DATAPH_FILE*/
  /* End of cleaning variable DATAPH_FILE */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of PHSH_REL ******************************/

/*********************************** DLGKAP ***********************************/
static char doc_f2py_rout_libphsh_DLGKAP[] = "\
DLGKAP = DLGKAP(E,KAPPA)\n\nWrapper for ``DLGKAP``.\
\n\nParameters\n----------\n"
"E : input float\n"
"KAPPA : input int\n"
"\nReturns\n-------\n"
"DLGKAP : float";
/* extern void F_WRAPPEDFUNC(dlgkap,DLGKAP)(double*,double*,int*); */
static PyObject *f2py_rout_libphsh_DLGKAP(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double DLGKAP = 0;
  double E = 0;
  PyObject *E_capi = Py_None;
  int KAPPA = 0;
  PyObject *KAPPA_capi = Py_None;
  static char *capi_kwlist[] = {"E","KAPPA",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO:libphsh.DLGKAP",\
    capi_kwlist,&E_capi,&KAPPA_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable KAPPA */
    f2py_success = int_from_pyobj(&KAPPA,KAPPA_capi,"libphsh.DLGKAP() 2nd argument (KAPPA) can't be converted to int");
  if (f2py_success) {
  /* Processing variable DLGKAP */
  /* Processing variable E */
    f2py_success = double_from_pyobj(&E,E_capi,"libphsh.DLGKAP() 1st argument (E) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&DLGKAP,&E,&KAPPA);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",DLGKAP);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of E*/
  /* End of cleaning variable E */
  /* End of cleaning variable DLGKAP */
  } /*if (f2py_success) of KAPPA*/
  /* End of cleaning variable KAPPA */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of DLGKAP *******************************/

/*********************************** SBFIT ***********************************/
static char doc_f2py_rout_libphsh_SBFIT[] = "\
SBFIT(T,E,L,R,JFS)\n\nWrapper for ``SBFIT``.\
\n\nParameters\n----------\n"
"T : input float\n"
"E : input float\n"
"L : input int\n"
"R : input float\n"
"JFS : input float";
/* extern void F_FUNC(SBFIT,SBFIT)(double*,double*,int*,double*,float*); */
static PyObject *f2py_rout_libphsh_SBFIT(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,double*,float*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double T = 0;
  PyObject *T_capi = Py_None;
  double E = 0;
  PyObject *E_capi = Py_None;
  int L = 0;
  PyObject *L_capi = Py_None;
  double R = 0;
  PyObject *R_capi = Py_None;
  float JFS = 0;
  PyObject *JFS_capi = Py_None;
  static char *capi_kwlist[] = {"T","E","L","R","JFS",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO:libphsh.SBFIT",\
    capi_kwlist,&T_capi,&E_capi,&L_capi,&R_capi,&JFS_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable R */
    f2py_success = double_from_pyobj(&R,R_capi,"libphsh.SBFIT() 4th argument (R) can't be converted to double");
  if (f2py_success) {
  /* Processing variable E */
    f2py_success = double_from_pyobj(&E,E_capi,"libphsh.SBFIT() 2nd argument (E) can't be converted to double");
  if (f2py_success) {
  /* Processing variable T */
    f2py_success = double_from_pyobj(&T,T_capi,"libphsh.SBFIT() 1st argument (T) can't be converted to double");
  if (f2py_success) {
  /* Processing variable JFS */
    f2py_success = float_from_pyobj(&JFS,JFS_capi,"libphsh.SBFIT() 5th argument (JFS) can't be converted to float");
  if (f2py_success) {
  /* Processing variable L */
    f2py_success = int_from_pyobj(&L,L_capi,"libphsh.SBFIT() 3rd argument (L) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&T,&E,&L,&R,&JFS);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of L*/
  /* End of cleaning variable L */
  } /*if (f2py_success) of JFS*/
  /* End of cleaning variable JFS */
  } /*if (f2py_success) of T*/
  /* End of cleaning variable T */
  } /*if (f2py_success) of E*/
  /* End of cleaning variable E */
  } /*if (f2py_success) of R*/
  /* End of cleaning variable R */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of SBFIT ********************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

static FortranDataDef f2py_WF_def[] = {
  {"WF2",2,{{250,14}},NPY_DOUBLE},
  {"WC",1,{{14}},NPY_DOUBLE},
  {"LC",1,{{14}},NPY_INT},
  {NULL}
};
static void f2py_setup_WF(char *WF2,char *WC,char *LC) {
  int i_f2py=0;
  f2py_WF_def[i_f2py++].data = WF2;
  f2py_WF_def[i_f2py++].data = WC;
  f2py_WF_def[i_f2py++].data = LC;
}
extern void F_FUNC(f2pyinitwf,F2PYINITWF)(void(*)(char*,char*,char*));
static void f2py_init_WF(void) {
  F_FUNC(f2pyinitwf,F2PYINITWF)(f2py_setup_WF);
}

static FortranDataDef f2py_WK_def[] = {
  {"WK1",1,{{250}},NPY_DOUBLE},
  {"WK2",1,{{250}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_WK(char *WK1,char *WK2) {
  int i_f2py=0;
  f2py_WK_def[i_f2py++].data = WK1;
  f2py_WK_def[i_f2py++].data = WK2;
}
extern void F_FUNC(f2pyinitwk,F2PYINITWK)(void(*)(char*,char*));
static void f2py_init_WK(void) {
  F_FUNC(f2pyinitwk,F2PYINITWK)(f2py_setup_WK);
}

static FortranDataDef f2py_CMRV_def[] = {
  {"R",1,{{201}},NPY_DOUBLE},
  {"V",2,{{201,15}},NPY_DOUBLE},
  {"NR",0,{{-1}},NPY_INT},
  {"NL",0,{{-1}},NPY_INT},
  {"Z",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_CMRV(char *R,char *V,char *NR,char *NL,char *Z) {
  int i_f2py=0;
  f2py_CMRV_def[i_f2py++].data = R;
  f2py_CMRV_def[i_f2py++].data = V;
  f2py_CMRV_def[i_f2py++].data = NR;
  f2py_CMRV_def[i_f2py++].data = NL;
  f2py_CMRV_def[i_f2py++].data = Z;
}
extern void F_FUNC(f2pyinitcmrv,F2PYINITCMRV)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_CMRV(void) {
  F_FUNC(f2pyinitcmrv,F2PYINITCMRV)(f2py_setup_CMRV);
}

static FortranDataDef f2py_CM5_def[] = {
  {"Y",2,{{30,4}},NPY_DOUBLE},
  {"F",2,{{30,4}},NPY_DOUBLE},
  {"ILST",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_CM5(char *Y,char *F,char *ILST) {
  int i_f2py=0;
  f2py_CM5_def[i_f2py++].data = Y;
  f2py_CM5_def[i_f2py++].data = F;
  f2py_CM5_def[i_f2py++].data = ILST;
}
extern void F_FUNC(f2pyinitcm5,F2PYINITCM5)(void(*)(char*,char*,char*));
static void f2py_init_CM5(void) {
  F_FUNC(f2pyinitcm5,F2PYINITCM5)(f2py_setup_CM5);
}

static FortranDataDef f2py_CM16_def[] = {
  {"E1",0,{{-1}},NPY_DOUBLE},
  {"E2",0,{{-1}},NPY_DOUBLE},
  {"NE",0,{{-1}},NPY_INT},
  {"IX",0,{{-1}},NPY_INT},
  {"NEUO",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_CM16(char *E1,char *E2,char *NE,char *IX,char *NEUO) {
  int i_f2py=0;
  f2py_CM16_def[i_f2py++].data = E1;
  f2py_CM16_def[i_f2py++].data = E2;
  f2py_CM16_def[i_f2py++].data = NE;
  f2py_CM16_def[i_f2py++].data = IX;
  f2py_CM16_def[i_f2py++].data = NEUO;
}
extern void F_FUNC(f2pyinitcm16,F2PYINITCM16)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_CM16(void) {
  F_FUNC(f2pyinitcm16,F2PYINITCM16)(f2py_setup_CM16);
}

static FortranDataDef f2py_Z_def[] = {
  {"RMAXI",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_Z(char *RMAXI) {
  int i_f2py=0;
  f2py_Z_def[i_f2py++].data = RMAXI;
}
extern void F_FUNC(f2pyinitz,F2PYINITZ)(void(*)(char*));
static void f2py_init_Z(void) {
  F_FUNC(f2pyinitz,F2PYINITZ)(f2py_setup_Z);
}

static FortranDataDef f2py_ZZZZ_def[] = {
  {"ZP",1,{{340}},NPY_DOUBLE},
  {"VS",0,{{-1}},NPY_DOUBLE},
  {"IPT",0,{{-1}},NPY_INT},
  {"JRI",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_ZZZZ(char *ZP,char *VS,char *IPT,char *JRI) {
  int i_f2py=0;
  f2py_ZZZZ_def[i_f2py++].data = ZP;
  f2py_ZZZZ_def[i_f2py++].data = VS;
  f2py_ZZZZ_def[i_f2py++].data = IPT;
  f2py_ZZZZ_def[i_f2py++].data = JRI;
}
extern void F_FUNC(f2pyinitzzzz,F2PYINITZZZZ)(void(*)(char*,char*,char*,char*));
static void f2py_init_ZZZZ(void) {
  F_FUNC(f2pyinitzzzz,F2PYINITZZZZ)(f2py_setup_ZZZZ);
}

static FortranDataDef f2py_RADFUN_def[] = {
  {"U",1,{{340}},NPY_DOUBLE},
  {"W",1,{{340}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_RADFUN(char *U,char *W) {
  int i_f2py=0;
  f2py_RADFUN_def[i_f2py++].data = U;
  f2py_RADFUN_def[i_f2py++].data = W;
}
extern void F_FUNC(f2pyinitradfun,F2PYINITRADFUN)(void(*)(char*,char*));
static void f2py_init_RADFUN(void) {
  F_FUNC(f2pyinitradfun,F2PYINITRADFUN)(f2py_setup_RADFUN);
}

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"hartfock",-1,{{-1}},0,(char *)F_FUNC(hartfock,HARTFOCK),(f2py_init_func)f2py_rout_libphsh_hartfock,doc_f2py_rout_libphsh_hartfock},
  {"abinitio",-1,{{-1}},0,(char *)F_FUNC(abinitio,ABINITIO),(f2py_init_func)f2py_rout_libphsh_abinitio,doc_f2py_rout_libphsh_abinitio},
  {"atsolve",-1,{{-1}},0,(char *)F_FUNC(atsolve,ATSOLVE),(f2py_init_func)f2py_rout_libphsh_atsolve,doc_f2py_rout_libphsh_atsolve},
  {"getpot",-1,{{-1}},0,(char *)F_FUNC(getpot,GETPOT),(f2py_init_func)f2py_rout_libphsh_getpot,doc_f2py_rout_libphsh_getpot},
  {"elsolve",-1,{{-1}},0,(char *)F_FUNC(elsolve,ELSOLVE),(f2py_init_func)f2py_rout_libphsh_elsolve,doc_f2py_rout_libphsh_elsolve},
  {"augment",-1,{{-1}},0,(char *)F_FUNC(augment,AUGMENT),(f2py_init_func)f2py_rout_libphsh_augment,doc_f2py_rout_libphsh_augment},
  {"setqmm",-1,{{-1}},0,(char *)F_FUNC(setqmm,SETQMM),(f2py_init_func)f2py_rout_libphsh_setqmm,doc_f2py_rout_libphsh_setqmm},
  {"initiali",-1,{{-1}},0,(char *)F_FUNC(initiali,INITIALI),(f2py_init_func)f2py_rout_libphsh_initiali,doc_f2py_rout_libphsh_initiali},
  {"setgrid",-1,{{-1}},0,(char *)F_FUNC(setgrid,SETGRID),(f2py_init_func)f2py_rout_libphsh_setgrid,doc_f2py_rout_libphsh_setgrid},
  {"integ",-1,{{-1}},0,(char *)F_FUNC(integ,INTEG),(f2py_init_func)f2py_rout_libphsh_integ,doc_f2py_rout_libphsh_integ},
  {"clebschgordan",-1,{{-1}},0,(char *)F_FUNC(clebschgordan,CLEBSCHGORDAN),(f2py_init_func)f2py_rout_libphsh_clebschgordan,doc_f2py_rout_libphsh_clebschgordan},
  {"pseudo",-1,{{-1}},0,(char *)F_FUNC(pseudo,PSEUDO),(f2py_init_func)f2py_rout_libphsh_pseudo,doc_f2py_rout_libphsh_pseudo},
  {"parabreg",-1,{{-1}},0,(char *)F_FUNC(parabreg,PARABREG),(f2py_init_func)f2py_rout_libphsh_parabreg,doc_f2py_rout_libphsh_parabreg},
  {"hb",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(hb,HB),(f2py_init_func)f2py_rout_libphsh_hb,doc_f2py_rout_libphsh_hb},
  {"fitx0",-1,{{-1}},0,(char *)F_FUNC(fitx0,FITX0),(f2py_init_func)f2py_rout_libphsh_fitx0,doc_f2py_rout_libphsh_fitx0},
  {"pseudize",-1,{{-1}},0,(char *)F_FUNC(pseudize,PSEUDIZE),(f2py_init_func)f2py_rout_libphsh_pseudize,doc_f2py_rout_libphsh_pseudize},
  {"fourier",-1,{{-1}},0,(char *)F_FUNC(fourier,FOURIER),(f2py_init_func)f2py_rout_libphsh_fourier,doc_f2py_rout_libphsh_fourier},
  {"GETILLLS",-1,{{-1}},0,(char *)F_FUNC(GETILLLS,GETILLLS),(f2py_init_func)f2py_rout_libphsh_GETILLLS,doc_f2py_rout_libphsh_GETILLLS},
  {"hfdisk",-1,{{-1}},0,(char *)F_FUNC(hfdisk,HFDISK),(f2py_init_func)f2py_rout_libphsh_hfdisk,doc_f2py_rout_libphsh_hfdisk},
  {"exchcorr",-1,{{-1}},0,(char *)F_FUNC(exchcorr,EXCHCORR),(f2py_init_func)f2py_rout_libphsh_exchcorr,doc_f2py_rout_libphsh_exchcorr},
  {"CAVPOT",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(cavpot,CAVPOT),(f2py_init_func)f2py_rout_libphsh_CAVPOT,doc_f2py_rout_libphsh_CAVPOT},
  {"CHGRID",-1,{{-1}},0,(char *)F_FUNC(CHGRID,CHGRID),(f2py_init_func)f2py_rout_libphsh_CHGRID,doc_f2py_rout_libphsh_CHGRID},
  {"CLEMIN",-1,{{-1}},0,(char *)F_FUNC(CLEMIN,CLEMIN),(f2py_init_func)f2py_rout_libphsh_CLEMIN,doc_f2py_rout_libphsh_CLEMIN},
  {"Hsin",-1,{{-1}},0,(char *)F_FUNC(Hsin,HSIN),(f2py_init_func)f2py_rout_libphsh_Hsin,doc_f2py_rout_libphsh_Hsin},
  {"MAD",-1,{{-1}},0,(char *)F_FUNC(MAD,MAD),(f2py_init_func)f2py_rout_libphsh_MAD,doc_f2py_rout_libphsh_MAD},
  {"MTZ",-1,{{-1}},0,(char *)F_FUNC(MTZ,MTZ),(f2py_init_func)f2py_rout_libphsh_MTZ,doc_f2py_rout_libphsh_MTZ},
  {"MTZM",-1,{{-1}},0,(char *)F_FUNC(MTZM,MTZM),(f2py_init_func)f2py_rout_libphsh_MTZM,doc_f2py_rout_libphsh_MTZM},
  {"NBR",-1,{{-1}},0,(char *)F_FUNC(NBR,NBR),(f2py_init_func)f2py_rout_libphsh_NBR,doc_f2py_rout_libphsh_NBR},
  {"POISON",-1,{{-1}},0,(char *)F_FUNC(POISON,POISON),(f2py_init_func)f2py_rout_libphsh_POISON,doc_f2py_rout_libphsh_POISON},
  {"RELA",-1,{{-1}},0,(char *)F_FUNC(RELA,RELA),(f2py_init_func)f2py_rout_libphsh_RELA,doc_f2py_rout_libphsh_RELA},
  {"SUMAX",-1,{{-1}},0,(char *)F_FUNC(SUMAX,SUMAX),(f2py_init_func)f2py_rout_libphsh_SUMAX,doc_f2py_rout_libphsh_SUMAX},
  {"PHSH_CAV",-1,{{-1}},0,(char *)F_FUNC_US(PHSH_CAV,PHSH_CAV),(f2py_init_func)f2py_rout_libphsh_PHSH_CAV,doc_f2py_rout_libphsh_PHSH_CAV},
  {"PS",-1,{{-1}},0,(char *)F_FUNC(PS,PS),(f2py_init_func)f2py_rout_libphsh_PS,doc_f2py_rout_libphsh_PS},
  {"CALCBF",-1,{{-1}},0,(char *)F_FUNC(CALCBF,CALCBF),(f2py_init_func)f2py_rout_libphsh_CALCBF,doc_f2py_rout_libphsh_CALCBF},
  {"PHSH_WIL",-1,{{-1}},0,(char *)F_FUNC_US(PHSH_WIL,PHSH_WIL),(f2py_init_func)f2py_rout_libphsh_PHSH_WIL,doc_f2py_rout_libphsh_PHSH_WIL},
  {"S16",-1,{{-1}},0,(char *)F_FUNC(S16,S16),(f2py_init_func)f2py_rout_libphsh_S16,doc_f2py_rout_libphsh_S16},
  {"F12",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(f12,F12),(f2py_init_func)f2py_rout_libphsh_F12,doc_f2py_rout_libphsh_F12},
  {"S5",-1,{{-1}},0,(char *)F_FUNC(S5,S5),(f2py_init_func)f2py_rout_libphsh_S5,doc_f2py_rout_libphsh_S5},
  {"S10",-1,{{-1}},0,(char *)F_FUNC(S10,S10),(f2py_init_func)f2py_rout_libphsh_S10,doc_f2py_rout_libphsh_S10},
  {"F44",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(f44,F44),(f2py_init_func)f2py_rout_libphsh_F44,doc_f2py_rout_libphsh_F44},
  {"F45",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(f45,F45),(f2py_init_func)f2py_rout_libphsh_F45,doc_f2py_rout_libphsh_F45},
  {"S41",-1,{{-1}},0,(char *)F_FUNC(S41,S41),(f2py_init_func)f2py_rout_libphsh_S41,doc_f2py_rout_libphsh_S41},
  {"PHSH_REL",-1,{{-1}},0,(char *)F_FUNC_US(PHSH_REL,PHSH_REL),(f2py_init_func)f2py_rout_libphsh_PHSH_REL,doc_f2py_rout_libphsh_PHSH_REL},
  {"DLGKAP",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(dlgkap,DLGKAP),(f2py_init_func)f2py_rout_libphsh_DLGKAP,doc_f2py_rout_libphsh_DLGKAP},
  {"SBFIT",-1,{{-1}},0,(char *)F_FUNC(SBFIT,SBFIT),(f2py_init_func)f2py_rout_libphsh_SBFIT,doc_f2py_rout_libphsh_SBFIT},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

#if PY_VERSION_HEX >= 0x03000000
static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "libphsh",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};
#endif

#if PY_VERSION_HEX >= 0x03000000
#define RETVAL m
PyMODINIT_FUNC PyInit_libphsh(void) {
#else
#define RETVAL
PyMODINIT_FUNC initlibphsh(void) {
#endif
  int i;
  PyObject *m,*d, *s;
#if PY_VERSION_HEX >= 0x03000000
  m = libphsh_module = PyModule_Create(&moduledef);
#else
  m = libphsh_module = Py_InitModule("libphsh", f2py_module_methods);
#endif
  Py_TYPE(&PyFortran_Type) = &PyType_Type;
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module libphsh (failed to import numpy)"); return RETVAL;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
#if PY_VERSION_HEX >= 0x03000000
  s = PyUnicode_FromString(
#else
  s = PyString_FromString(
#endif
    "This module 'libphsh' is auto-generated with f2py (version:2).\nFunctions:\n"
"  hartfock(input_file)\n"
"  abinitio(etot,nst,rel,alfa,nr,r,dr,r2,dl,phe,njrc,vi,zorig,xntot,nel,no,nl,xnj,ev,occ,is,ek,orb,iuflag)\n"
"  atsolve(etot,nst,rel,alfa,eerror,nfc,nr,r,dr,r2,dl,phe,njrc,vi,zorig,xntot,nel,no,nl,nm,xnj,ev,occ,is,ek,ratio,orb,rpower,xnum,etot2,iuflag)\n"
"  getpot(etot,nst,rel,alfa,dl,nr,dr,r,r2,xntot,phe,ratio,orb,occ,is,nel,nl,nm,no,xnj,rpower,xnum,etot2,iuflag)\n"
"  elsolve(i,occ,n,l,xkappa,xj,zorig,zeff,e,phi,v,q0,xm1,xm2,nr,r,dr,r2,dl,rel)\n"
"  augment(e,l,xj,phi,v,nr,r,dl)\n"
"  setqmm(i,orb,l,ns,idoflag,v,zeff,zorig,rel,nr,r,r2,dl,q0,xm1,xm2,njrc,vi)\n"
"  initiali(zorig,nr,rmin,rmax,r,dr,r2,dl,njrc,xntot,nel)\n"
"  setgrid(nr,rmin,rmax,r,dr,r2,dl)\n"
"  integ(e,l,xkappa,n,nn,istop,ief,x0,phi,z,v,q0,xm1,xm2,nr,r,dr,r2,dl,rel)\n"
"  clebschgordan(nel,nl,cg)\n"
"  pseudo(etot,nst,rel,alfa,nr,rmin,rmax,r,dr,r2,dl,phe,orb,njrc,vi,zorig,xntot,nel,no,nl,xnj,ev,occ,is,ek,iuflag,vctab)\n"
"  parabreg(f,fp,fpp,rf,vf)\n"
"  hb = hb(x,factor)\n"
"  fitx0(i,orb,rcut,njrc,e,l,xj,n,jrt,xideal,phi,zeff,v,q0,xm1,xm2,nr,r,dr,r2,dl,rel,factor)\n"
"  pseudize(i,orb,ev,l,xj,n,njrc,zeff,v,q0,xm1,xm2,nr,rmin,rmax,r,dr,r2,dl,rel)\n"
"  fourier(nr,r,dr,r2,vi)\n"
"  GETILLLS(PIN)\n"
"  hfdisk(iu,ir,etot,nst,rel,nr,rmin,rmax,r,rho,zorig,xntot,ixflag,nel,no,nl,xnj,is,ev,ek,occ,njrc,vi,phe,orb)\n"
"  exchcorr(nst,rel,rr,rh1,rh2,ex,ec,ux1,ux2,uc1,uc2)\n"
"  CAVPOT = CAVPOT(MTZ_STRING,SLAB_FLAG,ATOMIC_FILE,CLUSTER_FILE,MUFFTIN_FILE,OUTPUT_FILE,INFO_FILE)\n"
"  CHGRID(FX,X,FY,Y,NX=len(FX),NY=len(FY))\n"
"  CLEMIN(RHO,RX,NX,NGRID=len(RHO))\n"
"  Hsin(RHO,RX,NX,NGRID=len(RHO))\n"
"  MAD(VMAD,RX,RMT,NRR,NX,RC,RK,ZM,AV,NGRID=shape(VMAD,0),NR=shape(VMAD,1),N=shape(RK,1))\n"
"  MTZ(SIG,RHO,RX,RMT,NRR,NX,RC,RK,VHAR,VEX,ALPHA,AV,NH,NGRID=shape(SIG,0),NR=shape(SIG,1),N=shape(RK,1))\n"
"  MTZM(VH,VS,RX,RMT,RWS,JRMT,JRWS,VHAR,VEX,NGRID=len(VH))\n"
"  NBR(IA,NA,AD,NCON,NRR,RC,RK,RMAX,NR=shape(IA,1),N=shape(RK,1),MC=shape(IA,0))\n"
"  POISON(PSQ,Z,W,J=len(PSQ))\n"
"  RELA(RHO,RX,NX,NGRID=len(RHO))\n"
"  SUMAX(ACC,CHI,RX,NX,IA,NA,AD,IMAX,NCON=len(IA),NGRID=len(ACC),NR=shape(CHI,1))\n"
"  PHSH_CAV(MUFFTIN_FILE,PHASOUT_FILE,DATAPH_FILE,ZPH_FILE)\n"
"  PS(V,RX,RAD,E,PHS,FILE_UNIT,NGRID=len(V),NL=len(PHS))\n"
"  CALCBF(BJ,BN,X,FILE_UNIT,NL=len(BJ))\n"
"  PHSH_WIL(MUFFTIN_FILE,PHASOUT_FILE,DATAPH_FILE,ZPH_FILE)\n"
"  S16()\n"
"  F12 = F12(X,Y,Z,N)\n"
"  S5(E)\n"
"  S10(E)\n"
"  F44 = F44(L,X)\n"
"  F45 = F45(L,X)\n"
"  S41(X,Y,N)\n"
"  PHSH_REL(MUFFTIN_FILE,PHASOUT_FILE,DATAPH_FILE,INPDAT_FILE)\n"
"  DLGKAP = DLGKAP(E,KAPPA)\n"
"  SBFIT(T,E,L,R,JFS)\n"
"COMMON blocks:\n""  /WF/ WF2(250,14),WC(14),LC(14)\n""  /WK/ WK1(250),WK2(250)\n""  /CMRV/ R(201),V(201,15),NR,NL,Z\n""  /CM5/ Y(30,4),F(30,4),ILST\n""  /CM16/ E1,E2,NE,IX,NEUO\n""  /Z/ RMAXI\n""  /ZZZZ/ ZP(340),VS,IPT,JRI\n""  /RADFUN/ U(340),W(340)\n"".");
  PyDict_SetItemString(d, "__doc__", s);
  libphsh_error = PyErr_NewException ("libphsh.error", NULL, NULL);
  Py_DECREF(s);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++)
    PyDict_SetItemString(d, f2py_routine_defs[i].name,PyFortranObject_NewAsAttr(&f2py_routine_defs[i]));














    {
      extern double F_FUNC(hb,HB)(void);
      PyObject* o = PyDict_GetItemString(d,"hb");
      PyObject_SetAttrString(o,"_cpointer", F2PyCapsule_FromVoidPtr((void*)F_FUNC(hb,HB),NULL));
#if PY_VERSION_HEX >= 0x03000000
      PyObject_SetAttrString(o,"__name__", PyUnicode_FromString("hb"));
#else
      PyObject_SetAttrString(o,"__name__", PyString_FromString("hb"));
#endif
    }
    







    {
      extern float F_FUNC(cavpot,CAVPOT)(void);
      PyObject* o = PyDict_GetItemString(d,"CAVPOT");
      PyObject_SetAttrString(o,"_cpointer", F2PyCapsule_FromVoidPtr((void*)F_FUNC(cavpot,CAVPOT),NULL));
#if PY_VERSION_HEX >= 0x03000000
      PyObject_SetAttrString(o,"__name__", PyUnicode_FromString("CAVPOT"));
#else
      PyObject_SetAttrString(o,"__name__", PyString_FromString("CAVPOT"));
#endif
    }
    
















    {
      extern double F_FUNC(f12,F12)(void);
      PyObject* o = PyDict_GetItemString(d,"F12");
      PyObject_SetAttrString(o,"_cpointer", F2PyCapsule_FromVoidPtr((void*)F_FUNC(f12,F12),NULL));
#if PY_VERSION_HEX >= 0x03000000
      PyObject_SetAttrString(o,"__name__", PyUnicode_FromString("F12"));
#else
      PyObject_SetAttrString(o,"__name__", PyString_FromString("F12"));
#endif
    }
    



    {
      extern double F_FUNC(f44,F44)(void);
      PyObject* o = PyDict_GetItemString(d,"F44");
      PyObject_SetAttrString(o,"_cpointer", F2PyCapsule_FromVoidPtr((void*)F_FUNC(f44,F44),NULL));
#if PY_VERSION_HEX >= 0x03000000
      PyObject_SetAttrString(o,"__name__", PyUnicode_FromString("F44"));
#else
      PyObject_SetAttrString(o,"__name__", PyString_FromString("F44"));
#endif
    }
    

    {
      extern double F_FUNC(f45,F45)(void);
      PyObject* o = PyDict_GetItemString(d,"F45");
      PyObject_SetAttrString(o,"_cpointer", F2PyCapsule_FromVoidPtr((void*)F_FUNC(f45,F45),NULL));
#if PY_VERSION_HEX >= 0x03000000
      PyObject_SetAttrString(o,"__name__", PyUnicode_FromString("F45"));
#else
      PyObject_SetAttrString(o,"__name__", PyString_FromString("F45"));
#endif
    }
    



    {
      extern double F_FUNC(dlgkap,DLGKAP)(void);
      PyObject* o = PyDict_GetItemString(d,"DLGKAP");
      PyObject_SetAttrString(o,"_cpointer", F2PyCapsule_FromVoidPtr((void*)F_FUNC(dlgkap,DLGKAP),NULL));
#if PY_VERSION_HEX >= 0x03000000
      PyObject_SetAttrString(o,"__name__", PyUnicode_FromString("DLGKAP"));
#else
      PyObject_SetAttrString(o,"__name__", PyString_FromString("DLGKAP"));
#endif
    }
    

/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

  F2PyDict_SetItemString(d, "WF", PyFortranObject_New(f2py_WF_def,f2py_init_WF));
  F2PyDict_SetItemString(d, "WK", PyFortranObject_New(f2py_WK_def,f2py_init_WK));
  F2PyDict_SetItemString(d, "CMRV", PyFortranObject_New(f2py_CMRV_def,f2py_init_CMRV));
  F2PyDict_SetItemString(d, "CM5", PyFortranObject_New(f2py_CM5_def,f2py_init_CM5));
  F2PyDict_SetItemString(d, "CM16", PyFortranObject_New(f2py_CM16_def,f2py_init_CM16));
  F2PyDict_SetItemString(d, "Z", PyFortranObject_New(f2py_Z_def,f2py_init_Z));
  F2PyDict_SetItemString(d, "ZZZZ", PyFortranObject_New(f2py_ZZZZ_def,f2py_init_ZZZZ));
  F2PyDict_SetItemString(d, "RADFUN", PyFortranObject_New(f2py_RADFUN_def,f2py_init_RADFUN));
/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"libphsh");
#endif

  return RETVAL;
}
#ifdef __cplusplus
}
#endif
