from sqlalchemy import Column,  Integer, DATE, ForeignKey, Float
from ETRMDatabase.base import Base


class BlotterDailyLinear(Base):

    __tablename__ = 'blotter_index_linear'
    __table_args__ = {'schema': 'trade'}

    id = Column(Integer, primary_key=True)
    header_id = Column(Integer, ForeignKey('trade.trade_header.id'))
    curve_id = Column(Integer, ForeignKey('power.hub_curve.id'))
    peak_id = Column(Integer, ForeignKey('power.dim_peak.id'))
    volume_shape_id = Column(Integer, ForeignKey('trade.volume_shape.id'))
    volume = Column(Float)
    price_adder = Column(Float)
    start_date = Column(DATE)
    end_date = Column(DATE)

    def __init__(self, header_id, curve_id, peak_id, volume_id, price_adder, start_date, end_date):
        self.header_id = header_id
        self.curve_id = curve_id
        self.peak_id = peak_id
        self.volume_id = volume_id
        self.price_adder = price_adder
        self.start_date = start_date
        self.end_date = end_date

