from sqlalchemy import Column, Integer, ForeignKey, DATE
from ETRMDatabase.base import Base


class PowerHours(Base):

    __tablename__ = 'power_hours'
    __table_args__ = {'schema': 'power'}

    # id = Column('id', Integer, primary_key=True)
    region_id = Column(Integer, ForeignKey('power.dim_region.id'), primary_key=True)
    contract_month = Column(DATE, primary_key=True)
    act_days = Column(Integer)
    biz_days = Column(Integer)
    on_peak_hours = Column(Integer)
    off_peak_hours = Column(Integer)
    weekend_peak_hours = Column(Integer)
    week_off_peak_hours = Column(Integer)

    def __init__(self, region_id, contract_month, act_days, biz_days, on_peak_hours, off_peak_hours,
                 weekend_peak_hours, week_off_peak_hours):
        self.region_id = region_id,
        self.contract_month = contract_month
        self.act_days = act_days
        self.biz_days = biz_days
        self.on_peak_hours = on_peak_hours
        self.off_peak_hours = off_peak_hours
        self.weekend_peak_hours = weekend_peak_hours
        self.week_off_peak_hours = week_off_peak_hours

