from sqlalchemy import Column, String, Integer, ForeignKey
from ETRMDatabase.base import Base


class HubCurve(Base):

    __tablename__ = 'hub_curve'
    __table_args__ = {'schema': 'power'}

    id = Column(Integer, primary_key=True)
    ticker = Column(String(8))
    region_id = Column(Integer, ForeignKey('power.dim_region.id'))
    hub_id = Column(Integer, ForeignKey('power.dim_hub.id'))
    peak_id = Column(Integer, ForeignKey('power.dim_peak.id'))
    pricing_style_id = Column(Integer, ForeignKey('power.dim_pricing_style.id'))
    frequency_id = Column(Integer, ForeignKey('power.dim_frequency.id'))
    source_id = Column(Integer, ForeignKey('power.dim_source.id'))

    def __int__(self, ticker, region_id, hub_id, peak_id, pricing_style_id, frequency_id, source_id):
        self.ticker = ticker
        self.region_id = region_id
        self.hub_id = hub_id
        self.peak_id = peak_id
        self.pricing_style_id = pricing_style_id
        self.frequency_id = frequency_id
        self.source_id = source_id

