from sqlalchemy import Column, DateTime, ForeignKey, Index, Integer, String
from sqlalchemy.orm import relationship

from ETRMDatabase.AuditDatabase.auditbase import Base_audit


class Account(Base_audit):
    __tablename__ = 'Account'
    __table_args__ = (
        Index('INDEX_Account', 'Customer_ID', 'AccountNumber_ID'),
        {'schema': 'cms'}
    )

    teleios_account_number_id = Column('AccountNumber_ID', Integer, primary_key=True)
    client_account_number = Column('AccountNumber', String(250, 'SQL_Latin1_General_CP1_CI_AS'), nullable=False)
    teleios_customer_id = Column('Customer_ID', ForeignKey('cms.Customer.Customer_ID'), nullable=False)
    edc_id = Column('EDC_ID', ForeignKey('cms.EDC.EDC_ID'), nullable=False)
    pnode_id = Column('PNode_ID', ForeignKey('cms.PNodes.PNode_ID'), nullable=False)
    record_created_date = Column('CreatedDate', DateTime)
    record_created_by = Column('CreatedBy', String(50, 'SQL_Latin1_General_CP1_CI_AS'), nullable=False)

    Customer = relationship('Customer')
    EDC = relationship('EDC')
    PNode = relationship('PNode')

    def __int__(self, _teleios_account_number_id, _client_account_number, _teleios_customer_id, _edc_id,
                _pnode_id, _record_created_date, _record_created_by):
        self.teleios_account_number_id = _teleios_account_number_id
        self.client_account_number = _client_account_number
        self.teleios_customer_id = _teleios_customer_id
        self.edc_id = _edc_id
        self.pnode_id = _pnode_id
        self.record_created_date = _record_created_date
        self.record_created_by = _record_created_by


