'''
Created on 5. 1. 2017

@author: ppavlu
'''

import smartsheet

class smartSheetAccess:
    '''
    classdocs
    '''


    def __init__(self, Token):
        '''
        Constructor - initiate the Smart Sheet handle by the Security Token
        '''
        self.smSheet=smartsheet.Smartsheet(Token)
        
    def getListofSheetNames (self):
        action=self.smSheet.Sheets.list_sheets(include_all=True)
        l=[]
        for item in action.data:
            l.append(item.name)
        return l
    
    def getNamedSheetHandle(self, sheetName):
        #Returns Sheet object with a given name, or returns null if the sheet does not exists
        action=self.smSheet.Sheets.list_sheets(include_all=True)
        Result=None
        while action.data != []:
            if action.data[len(action.data)-1].name == sheetName:
                Result=action.data[len(action.data)-1]
                break
            else:
                action.data.pop()
        return Result
    
    def getListofSheetColumnNames (self, SheetId):
        action=self.smSheet.Sheets.get_columns(SheetId,include_all=True)
        l=[]
        for item in action.data:
            l.append(item.title)
        return l

    def getNamedColumnHandle(self, SheetId, columnName):
        #Returns Column object with a given name in sheet with id provided as first Parameter, or returns null if the column does not exist
        action=self.smSheet.Sheets.get_columns(SheetId,include_all=True)
        Result=None
        while action.data != []:
            if action.data[len(action.data)-1].title == columnName:
                Result=action.data[len(action.data)-1]
                break
            else:
                action.data.pop()
        return Result
    
    def getListofCellsinSheetColumn(self, sheetName,columnName):
        #Returns list of values in a named column of a named sheet (both defined by Ids). In case of any inconsistency the list is empty
        cellValueList=[]
        sheet=self.getNamedSheetHandle(sheetName)
        #print(sheet.name)
        if sheet == None:
            print("Nonexisting sheet requested")
        else:
            column=self.getNamedColumnHandle(sheet.id, columnName)
            #print(column.index)
            if column == None:
                print("Nonexisting column requested")
            else:
                sheetData=self.smSheet.Sheets.get_sheet(sheet.id)
                for row in sheetData.rows:
                    # print(row.cells[column.index].value)
                    cellValueList.append(row.cells[column.index].value)
        return cellValueList
    