/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.omake;

import com.ibm.xml.omake.RegexpParseException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Regexp
implements Serializable {
    String regexp;
    int nofparen;
    Token tokentree;
    transient NFANode nfastart = null;
    transient NFANode nfaterm = null;
    transient int[] positions;
    transient String target;

    void toNFA(Token tok) {
        if (this.nfastart == null) {
            this.nfastart = new NFANode();
            this.nfaterm = new NFANode();
            this.toNFA(tok, this.nfastart, this.nfaterm);
        }
    }

    void toNFA(Token tok, NFANode from, NFANode to) {
        switch (tok.type) {
            case 0: {
                from.addElement(new NFAArrow(0, tok.chardata, to));
                break;
            }
            case 1: {
                NFANode n = new NFANode();
                this.toNFA(tok.child, from, n);
                this.toNFA(tok.child2, n, to);
                break;
            }
            case 2: {
                Enumeration en = tok.children.elements();
                while (en.hasMoreElements()) {
                    NFANode nu = new NFANode();
                    from.addElement(new NFAArrow(1, 0, nu));
                    this.toNFA((Token)en.nextElement(), nu, to);
                }
                break;
            }
            case 3: {
                NFANode st = new NFANode();
                NFANode te = new NFANode();
                from.addElement(new NFAArrow(1, 0, st));
                this.toNFA(tok.child, st, te);
                te.addElement(new NFAArrow(1, 0, st));
                st.addElement(new NFAArrow(1, 0, to));
                break;
            }
            case 4: {
                from.addElement(new NFAArrow(2, tok.ranges, to));
                break;
            }
            case 5: {
                from.addElement(new NFAArrow(3, tok.ranges, to));
                break;
            }
            case 6: {
                NFANode p1 = new NFANode();
                NFANode p2 = new NFANode();
                from.addElement(new NFAArrow(1, tok.parennumber, p1));
                this.toNFA(tok.child, p1, p2);
                p2.addElement(new NFAArrow(1, -tok.parennumber, to));
                break;
            }
            case 7: {
                from.addElement(new NFAArrow(1, 0, to));
            }
        }
    }

    int NFAmatch(String target, int offset, int limit) {
        if (this.nfastart == null) {
            this.prepare();
        }
        return this.NFAmatch0(this.nfastart, target, offset, limit, this.positions);
    }

    int NFAmatch0(NFANode node, String target, int offset, int limit, int[] pos) {
        int ret = -1;
        if (node == this.nfaterm) {
            ret = offset;
        } else if (offset > limit) {
            ret = -1;
        } else {
            int[] resultpos = (int[])pos.clone();
            int[] childpos = new int[pos.length];
            Enumeration en = node.elements();
            while (en.hasMoreElements()) {
                NFAArrow arr = (NFAArrow)en.nextElement();
                int current = -1;
                System.arraycopy(pos, 0, childpos, 0, pos.length);
                switch (arr.type) {
                    case 0: 
                    case 2: 
                    case 3: {
                        if (offset >= limit) {
                            current = -1;
                            break;
                        }
                        if (!arr.match(target.charAt(offset))) break;
                        current = this.NFAmatch0(arr.to, target, offset + 1, limit, childpos);
                        break;
                    }
                    case 1: {
                        if (arr.regnumber > 0) {
                            childpos[arr.regnumber * 2] = offset;
                        } else if (arr.regnumber < 0) {
                            childpos[-arr.regnumber * 2 + 1] = offset;
                        }
                        current = this.NFAmatch0(arr.to, target, offset, limit, childpos);
                    }
                }
                if (current <= ret) continue;
                ret = current;
                System.arraycopy(childpos, 0, resultpos, 0, childpos.length);
            }
            if (ret >= 0) {
                System.arraycopy(resultpos, 0, pos, 0, pos.length);
            }
        }
        return ret;
    }

    void prepare() {
        this.toNFA(this.tokentree);
        this.positions = new int[this.nofparen * 2];
        for (int i = 0; i < this.nofparen * 2; ++i) {
            this.positions[i] = -1;
        }
    }

    public Regexp(String regexp) throws RegexpParseException {
        this.regexp = regexp;
        RegexpParser rp = new RegexpParser(regexp);
        this.tokentree = rp.parse();
        this.nofparen = rp.parennumber;
    }

    public String toString() {
        return this.tokentree.toString();
    }

    public int match(String target) {
        this.target = target;
        int len = target.length();
        for (int i = 0; i < len; ++i) {
            int l = this.NFAmatch(target, i, len);
            if (0 > l) continue;
            this.positions[0] = i;
            this.positions[1] = l;
            return i;
        }
        return -1;
    }

    public boolean exactMatch(String target) {
        this.target = target;
        int len = target.length();
        if (len == this.NFAmatch(target, 0, len)) {
            this.positions[0] = 0;
            this.positions[1] = len;
            return true;
        }
        return false;
    }

    public int getMatchedBeginning(int index) {
        return this.positions[index * 2];
    }

    public int getMatchedEnd(int index) {
        return this.positions[index * 2 + 1];
    }

    public String getMatchedString(int index) {
        return this.target.substring(this.positions[index * 2], this.positions[index * 2 + 1]);
    }

    public int getNumberOfGroups() {
        return this.nofparen;
    }

    public static void main(String[] argv) {
        try {
            Regexp reg = new Regexp(argv[0]);
            System.out.println("Regexp: " + reg);
            System.out.println("Match position: " + reg.match(argv[1]));
            for (int i = 0; i < reg.getNumberOfGroups(); ++i) {
                if (i == 0) {
                    System.out.print("To whole pattern: ");
                } else {
                    System.out.print("[" + i + "]: ");
                }
                if (reg.getMatchedBeginning(i) < 0) {
                    System.out.println("-1");
                    continue;
                }
                System.out.print(reg.getMatchedBeginning(i) + ", " + reg.getMatchedEnd(i) + ", ");
                System.out.println(reg.getMatchedString(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class NFANode
    extends Vector {
        NFANode() {
        }
    }

    static class NFAArrow {
        static final int CHAR = 0;
        static final int EPSILON = 1;
        static final int RANGE = 2;
        static final int NRANGE = 3;
        int type;
        int chardata;
        int regnumber;
        int[] ranges;
        NFANode to;

        NFAArrow(int type, int data, NFANode to) {
            this.type = type;
            this.to = to;
            if (type == 0) {
                this.chardata = data;
            } else {
                this.regnumber = data;
            }
        }

        NFAArrow(int type, int[] ranges, NFANode to) {
            this.type = type;
            this.ranges = ranges;
            this.to = to;
        }

        boolean match(int ch) {
            boolean ret = false;
            if (this.type == 0) {
                ret = ch == this.chardata;
            } else if (this.type == 2) {
                for (int i = 0; i < this.ranges.length; i += 2) {
                    if (this.ranges[i] > ch || ch > this.ranges[i + 1]) continue;
                    return true;
                }
            } else if (this.type == 3) {
                for (int i = 0; i < this.ranges.length; i += 2) {
                    if (this.ranges[i] > ch || ch > this.ranges[i + 1]) continue;
                    return false;
                }
                ret = true;
            } else {
                System.err.println("NFAArrow#match(): Internal error!");
            }
            return ret;
        }
    }

    static class RegexpParser {
        private static final String className = "com.ibm.xml.omake.Regexp.RegexpParser";
        int offset;
        String regexp;
        static final int T_CHAR = 0;
        static final int T_EOF = 1;
        static final int T_OR = 2;
        static final int T_STAR = 3;
        static final int T_PLUS = 4;
        static final int T_QUESTION = 5;
        static final int T_LPAREN = 6;
        static final int T_RPAREN = 7;
        static final int T_DOT = 8;
        static final int T_LBRACKET = 9;
        int chardata;
        int nexttoken;
        static final int S_NORMAL = 0;
        static final int S_NONE = 1;
        int syntax = 0;
        int parennumber = 1;

        RegexpParser(String regexp) {
            this.regexp = regexp;
            this.offset = 0;
        }

        private String left() {
            return this.regexp.substring(this.offset);
        }

        Token parse() throws RegexpParseException {
            this.next();
            Token ret = this.parseRegexp();
            if (this.offset != this.regexp.length()) {
                throw new RegexpParseException(className + "#parse(): Wrong character: " + this.left());
            }
            return ret;
        }

        private void setSyntax(int syn) {
            this.syntax = syn;
        }

        int read() {
            return this.nexttoken;
        }

        void next() {
            int ret;
            if (this.offset < this.regexp.length()) {
                char ch = this.regexp.charAt(this.offset++);
                this.chardata = ch;
                if (this.syntax == 0) {
                    switch (ch) {
                        case '|': {
                            ret = 2;
                            break;
                        }
                        case '*': {
                            ret = 3;
                            break;
                        }
                        case '+': {
                            ret = 4;
                            break;
                        }
                        case '?': {
                            ret = 5;
                            break;
                        }
                        case '(': {
                            ret = 6;
                            break;
                        }
                        case ')': {
                            ret = 7;
                            break;
                        }
                        case '.': {
                            ret = 8;
                            break;
                        }
                        case '[': {
                            ret = 9;
                            break;
                        }
                        case '\\': {
                            if (this.offset < this.regexp.length()) {
                                ret = 0;
                                this.chardata = this.regexp.charAt(this.offset++);
                            } else {
                                throw new RegexpParseException(className + "#next(): 1 character is required after \\.");
                            }
                        }
                        default: {
                            ret = 0;
                            break;
                        }
                    }
                } else {
                    ret = 0;
                }
            } else {
                ret = 1;
                this.chardata = -1;
            }
            this.nexttoken = ret;
        }

        Token parseRegexp() throws RegexpParseException {
            Token tok = this.parseTerm();
            Token parent = null;
            while (this.read() == 2) {
                this.next();
                if (parent == null) {
                    parent = new Token(2);
                    parent.addElement(tok);
                    tok = parent;
                }
                tok.addElement(this.parseTerm());
            }
            return tok;
        }

        Token parseTerm() throws RegexpParseException {
            int ch = this.read();
            if (ch == 2 || ch == 7 || ch == 1) {
                return new Token(7);
            }
            Token tok = this.parseFactor();
            while ((ch = this.read()) != 2 && ch != 7 && ch != 1) {
                tok = new Token(tok, this.parseFactor());
            }
            return tok;
        }

        Token parseFactor() throws RegexpParseException {
            Token tok = this.parseAtom();
            int ch = this.read();
            switch (ch) {
                case 3: {
                    this.next();
                    tok = new Token(3, tok);
                    break;
                }
                case 4: {
                    this.next();
                    tok = new Token(tok, new Token(3, tok));
                    break;
                }
                case 5: {
                    this.next();
                    Token par = new Token(2);
                    par.addElement(new Token(7));
                    par.addElement(tok);
                    tok = par;
                }
            }
            return tok;
        }

        Token parseAtom() throws RegexpParseException {
            int ch = this.read();
            Token tok = null;
            switch (ch) {
                case 6: {
                    this.next();
                    int p = this.parennumber++;
                    tok = new Token(6, this.parseRegexp(), p);
                    if (this.read() != 7) {
                        throw new RegexpParseException(className + "#parseAtom(): ')' is expected: " + this.left());
                    }
                    this.next();
                    break;
                }
                case 8: {
                    this.next();
                    tok = new Token(4);
                    tok.addRange(1, 65534);
                    break;
                }
                case 9: {
                    int c;
                    this.setSyntax(1);
                    this.next();
                    boolean nrange = false;
                    if (this.chardata == 94) {
                        nrange = true;
                        this.next();
                    }
                    tok = new Token(nrange ? 5 : 4);
                    boolean first = true;
                    boolean minusp = false;
                    int start = -1;
                    block9: while (this.read() != 1 && ((c = this.chardata) != 93 || first)) {
                        this.next();
                        first = false;
                        switch (c) {
                            case 45: {
                                if (start < 0) {
                                    start = 45;
                                    continue block9;
                                }
                                minusp = true;
                                continue block9;
                            }
                        }
                        if (start < 0) {
                            start = c;
                            minusp = false;
                            continue;
                        }
                        if (!minusp) {
                            tok.addRange(start, start);
                            start = c;
                            continue;
                        }
                        tok.addRange(start, c);
                        start = -1;
                        minusp = false;
                    }
                    if (start >= 0) {
                        tok.addRange(start, start);
                    }
                    if (minusp) {
                        tok.addRange(45, 45);
                    }
                    if (this.read() == 1) {
                        throw new RegexpParseException(className + "#parseAtom(): Unexpected end of expression in a range([...]).");
                    }
                    this.setSyntax(0);
                    this.next();
                    break;
                }
                case 0: {
                    tok = new Token(0, this.chardata);
                    this.next();
                    break;
                }
                default: {
                    throw new RegexpParseException(className + "#parseAtom(): Unexpected special character: code=" + ch + ", " + (char)this.chardata);
                }
            }
            return tok;
        }
    }

    static class Token
    implements Serializable {
        static final int CHAR = 0;
        static final int CONCAT = 1;
        static final int UNION = 2;
        static final int CLOSURE = 3;
        static final int RANGE = 4;
        static final int NRANGE = 5;
        static final int PAREN = 6;
        static final int EMPTY = 7;
        int type;
        int chardata;
        static final int PERIOD_START = 1;
        static final int PERIOD_END = 65534;
        int[] ranges;
        int parennumber;
        Token child;
        Token child2;
        Vector children;

        Token(int type) {
            this.type = type;
        }

        Token(int type, Token tok) {
            this.type = type;
            this.child = tok;
        }

        Token(int type, Token tok, int pnumber) {
            this.type = type;
            this.child = tok;
            this.parennumber = pnumber;
        }

        Token(Token tok1, Token tok2) {
            this.type = 1;
            this.child = tok1;
            this.child2 = tok2;
        }

        Token(int type, int ch) {
            this.type = type;
            this.chardata = ch;
        }

        void addElement(Token tok) {
            if (this.children == null) {
                this.children = new Vector();
            }
            this.children.addElement(tok);
        }

        void addRange(int start, int end) {
            int pos = 0;
            if (this.ranges == null) {
                this.ranges = new int[2];
            } else {
                pos = this.ranges.length;
                int[] temp = new int[pos + 2];
                System.arraycopy(this.ranges, 0, temp, 0, pos);
                this.ranges = temp;
            }
            if (start <= end) {
                this.ranges[pos++] = start;
                this.ranges[pos] = end;
            } else {
                this.ranges[pos++] = end;
                this.ranges[pos] = start;
            }
        }

        public String toString() {
            String ret = "";
            switch (this.type) {
                case 0: {
                    if (0 <= "|*+?().[\\".indexOf(this.chardata)) {
                        ret = "\\" + (char)this.chardata;
                        break;
                    }
                    ret = "" + (char)this.chardata;
                    break;
                }
                case 1: {
                    if (this.child2.type == 3 && this.child2.child == this.child) {
                        ret = this.child.toString() + "+";
                        break;
                    }
                    ret = this.child.toString() + this.child2.toString();
                    break;
                }
                case 2: {
                    if (this.children.size() == 2 && ((Token)this.children.elementAt((int)0)).type == 7) {
                        ret = this.children.elementAt(1).toString() + "?";
                        break;
                    }
                    Enumeration en = this.children.elements();
                    StringBuffer sb = new StringBuffer();
                    sb.append(en.nextElement().toString());
                    while (en.hasMoreElements()) {
                        sb.append('|');
                        sb.append(en.nextElement().toString());
                    }
                    ret = sb.toString();
                    break;
                }
                case 3: {
                    ret = this.child.toString() + "*";
                    break;
                }
                case 4: {
                    if (this.ranges.length == 2 && this.ranges[0] == 1 && this.ranges[1] == 65534) {
                        ret = ".";
                        break;
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append("[");
                    for (int i = 0; i < this.ranges.length; i += 2) {
                        if (this.ranges[i] == this.ranges[i + 1]) {
                            sb.append((char)this.ranges[i]);
                            continue;
                        }
                        sb.append((char)this.ranges[i]);
                        sb.append('-');
                        sb.append((char)this.ranges[i + 1]);
                    }
                    sb.append("]");
                    ret = sb.toString();
                    break;
                }
                case 5: {
                    StringBuffer sb = new StringBuffer();
                    sb.append("[^");
                    for (int i = 0; i < this.ranges.length; i += 2) {
                        if (this.ranges[i] == this.ranges[i + 1]) {
                            sb.append((char)this.ranges[i]);
                            continue;
                        }
                        sb.append((char)this.ranges[i]);
                        sb.append('-');
                        sb.append((char)this.ranges[i + 1]);
                    }
                    sb.append("]");
                    ret = sb.toString();
                    break;
                }
                case 6: {
                    ret = "(" + this.child.toString() + ")";
                    break;
                }
            }
            return ret;
        }
    }
}

