/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Constants;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class ForeignFilter
extends XMLFilterImpl {
    private Stack stack = new Stack();

    ForeignFilter() {
    }

    ForeignFilter(XMLReader parent) {
        super(parent);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        boolean foreign = (Boolean)this.stack.pop();
        boolean foreignParent = !this.stack.isEmpty() && (Boolean)this.stack.peek() != false;
        super.endElement(namespaceURI, localName, qName);
        if (!foreignParent && foreign) {
            super.endElement(Constants.XSLFO, "instream-foreign-object", "fo:instream-foreign-object");
        }
    }

    private static Attributes removeCSS(Attributes atts) {
        AttributesImpl result = new AttributesImpl();
        for (int i = 0; i < atts.getLength(); ++i) {
            if (Constants.CSS.equals(atts.getURI(i)) || Constants.SPECIF.equals(atts.getURI(i))) continue;
            result.addAttribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
        }
        return result;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        boolean foreign;
        boolean foreignParent = !this.stack.isEmpty() && (Boolean)this.stack.peek() != false;
        boolean bl = foreign = foreignParent || "foreign".equals(atts.getValue(Constants.CSS, "display"));
        if (!foreignParent && foreign) {
            super.startElement(Constants.XSLFO, "instream-foreign-object", "fo:instream-foreign-object", new AttributesImpl());
        }
        this.stack.push(new Boolean(foreign));
        super.startElement(namespaceURI, localName, qName, foreign ? ForeignFilter.removeCSS(atts) : atts);
    }
}

