
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class PropertyType(object):
	def __init__(self, apiContext: ApiContext = None, dataViewMode="Live", mozuClient = None):
		if (apiContext is not None and apiContext.dataViewMode is None):
			apiContext.dataViewMode = dataViewMode;
		else:
			apiContext = ApiContext(dataViewMode = dataViewMode);
		self.client = mozuClient or default_client();
		self.client.withApiContext(apiContext);
	
	def getPropertyTypes(self,pageSize = None, startIndex = None, responseFields = None):
		""" Retrieves a list of the content property types.
		
		Args:
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a PageSize of 25, to get the 51st through the 75th items, use startIndex=3.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| PropertyTypeCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/propertytypes/?pageSize={pageSize}&startIndex={startIndex}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getPropertyType(self,propertyTypeName, responseFields = None):
		""" Retrieves the details of the content property type.
		
		Args:
			| propertyTypeName (string) - The name of the property type.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| PropertyType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/propertytypes/{propertyTypeName}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("propertyTypeName", propertyTypeName);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def createPropertyType(self,propertyType, responseFields = None):
		""" Creates a new
		
		Args:
			| propertyType(propertyType) - Property type available for content. Property types are like templates that can be reused.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| PropertyType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/propertytypes/?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(propertyType).execute();
		return self.client.result();

	
		
	def updatePropertyType(self,propertyType, propertyTypeName, responseFields = None):
		""" Updates a
		
		Args:
			| propertyType(propertyType) - Property type available for content. Property types are like templates that can be reused.
			| propertyTypeName (string) - The name of the property type.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| PropertyType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/propertytypes/{propertyTypeName}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("propertyTypeName", propertyTypeName);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(propertyType).execute();
		return self.client.result();

	
		
	def deletePropertyType(self,propertyTypeName):
		""" Delete a specific
		
		Args:
			| propertyTypeName (string) - The name of the property type.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/propertytypes/{propertyTypeName}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("propertyTypeName", propertyTypeName);
		self.client.withResourceUrl(url).execute();

	
	
	