# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RegistryNameCheckRequest(Model):
    """The request to check whether the container registry name is available.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name: The container registry name.
    :type name: str
    :ivar type: The container registry resource type. Default value:
     "Microsoft.ContainerRegistry/registries" .
    :vartype type: str
    """ 

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.ContainerRegistry/registries"

    def __init__(self, name):
        self.name = name
