from Products.CMFCore.utils import getToolByName
from zope.app.component.hooks import getSite

from Acquisition import aq_base

_marker = []

def search_key(property_id, context = None):
    """ this function is copied from Products.Maps"""
    if context == None:
        context = getSite()
    portal_props = getToolByName(context, 'portal_properties')
    map_properties = portal_props.get('maps_properties', portal_props.get('openmember_properties', None))
    
    if map_properties is None:
        return None
    keys_list = getattr(map_properties, property_id, None)
    if keys_list is None:
        return None
    keys = {}
    for key in keys_list:
        url, key = key.split('|')
        url = url.strip()
        # remove trailing slashes
        url = url.strip('/')
        key = key.strip()
        keys[url] = key
    portal_url_tool = getToolByName(context, 'portal_url')
    portal_url = portal_url_tool()
    portal_url = portal_url.split('/')
    while len(portal_url) > 2:
        url = '/'.join(portal_url)
        if keys.has_key(url):
            return keys[url]
        portal_url = portal_url[:-1]
    return None


def shasattr(obj, attr, acquire=False):
    """Stolen from Archetypes.
        Safe has attribute method

    * It's acquisition safe by default because it's removing the acquisition
      wrapper before trying to test for the attribute.

    * It's not using hasattr which might swallow a ZODB ConflictError (actually
      the implementation of hasattr is swallowing all exceptions). Instead of
      using hasattr it's comparing the output of getattr with a special marker
      object.

    TODO the getattr() trick can be removed when Python's hasattr() is fixed to
    catch only AttributeErrors.

    Quoting Shane Hathaway:

    That said, I was surprised to discover that Python 2.3 implements hasattr
    this way (from bltinmodule.c):

            v = PyObject_GetAttr(v, name);
            if (v == NULL) {
                    PyErr_Clear();
                    Py_INCREF(Py_False);
                    return Py_False;
            }
        Py_DECREF(v);
        Py_INCREF(Py_True);
        return Py_True;

    It should not swallow all errors, especially now that descriptors make
    computed attributes quite common.  getattr() only recently started catching
    only AttributeErrors, but apparently hasattr is lagging behind.  I suggest
    the consistency between getattr and hasattr should be fixed in Python, not
    Zope.

    Shane
    """
    if not acquire:
        obj = aq_base(obj)
    return getattr(obj, attr, _marker) is not _marker
