from Products.CMFCore.utils import getToolByName

from betahaus.openmember.handlers import getValueFor, onlyWhenInstalled
from geopy import geocoders
from betahaus.maps.openmember.utils import search_key, shasattr

def lookupGeo(event, address_fields):        

    addres_values = []
    for field in address_fields:
        address_value = getValueFor(event.object, field)
        if address_value:
            addres_values.append(address_value)
    
    if addres_values:
        # get the coordinates and make sure they are set
        coords = _doGeoLooup(addres_values)
        # Setting the geo_coords here might result in setting them to (0.0,0.0) which is ok, since the 
        # geo lookup might not have found correct coordinates. Even if the previous adress did have coordinates 
        # they might be reset now.
        event.om_object['geo_coords'] = coords

        
def _address2geolocation(address):
    """private helper function to look up a geolocation given an address

    address needs to be a plain (unicode) string  

    Raises ValueError if address cannot be resolved"""
    
    g1 = geocoders.Google(search_key('map_google_api_keys'))
    g2 = geocoders.Google(resource='maps')

    try:
        place, (lat, lng) = g2.geocode(address)
    except ValueError:
        place, (lat, lng) = g1.geocode(address)
        
    return (lat, lng)
        
def _doGeoLooup(address_list):
    if not address_list:
        return (0.0,0.0)
    
    address = ', '.join(address_list)
    fallback1 = fallback2 = None
    if len(address_list) > 1:
        fallback1 = ', '.join(address_list[1:])
    if len(address_list) > 2:
        fallback2 = ', '.join(address_list[2:])
    
    try:
        return _address2geolocation(address)
    except ValueError:
        if fallback1 is not None:
            try:
                return _address2geolocation(fallback1)
            except ValueError:
                if fallback1 is not None:
                    try:
                        return _address2geolocation(fallback2)
                    except ValueError:
                        pass
    
    return (0.0,0.0)

#TODO this needs to be restricted to only run when installed.
def geo(event):
    """Adds member data when a content type that should be indexed is added. 
    """
    # get the properties needed for geo lookup.
    portal_properties = getToolByName(event.object, 'portal_properties', None)
    openmember_properties = getattr(portal_properties, 'openmember_properties', None)

    address_fields = []
    if openmember_properties and openmember_properties.hasProperty('address_fields'):
        address_fields = list(openmember_properties.getProperty('address_fields'))
    

    for field in address_fields:
        if shasattr(event.om_object, field) and getValueFor(event.object, field) != getattr(event.om_object, field):
            # This is if there is a previous entry of the field.
            # We cannot make any assumptions of what data is in the field thus the strange check 
            lookupGeo(event, address_fields)
            break
        if not shasattr(event.om_object, field):
            # This one is if this is the first time address info has been added.
            lookupGeo(event, address_fields)
            break
            
