import simplejson
from Products.CMFCore.utils import getToolByName

from betahaus.openmember.browser.baseview import OMBaseView
from betahaus.openmember.interfaces import IOpenMemberContextResults
from betahaus.maps.openmember.utils import search_key
from betahaus.maps.openmember import mapsMessageFactory as _

class MapsView(OMBaseView):
    """Base view for encoding geo information to json"""
    
    def available(self):
        """This should be available if we can aquire a datahandler"""
        handler = IOpenMemberContextResults(self.context, IOpenMemberContextResults(self.context.context, False))
        return handler and True or False
    
    def geo_json(self):
        data = {'markers':[]}

        data_handler = IOpenMemberContextResults(self.context, IOpenMemberContextResults(self.context.context))
            
        bubble_title_fields = []
        pprops = getToolByName(self.context, 'portal_properties')
        if pprops and hasattr(pprops, 'openmember_properties'):
            bubble_title_fields = getattr(pprops.openmember_properties, 'bubble_title_fields', [])

        for member in data_handler.getResults():
            coords = member.geo_coords
            if coords:
                lat, lng = coords
                html = '<div>%s</div><div><a href="resolveuid/%s">%s</a>' % (' '.join([getattr(member, field, '') for field in bubble_title_fields if getattr(member, field, None) != None]),
                                                                               member.getMappedObjectUID,
                                                                               _(u"Link"))
                data['markers'].append({'lat': lat,
                                       'lng': lng,
                                       'html':html,
                                       'label': ' '.join([getattr(member, field, '') for field in bubble_title_fields if getattr(member, field, None) != None]),
                                       })
        

        config = {}
        config['apikey'] = search_key('map_google_api_keys', self.context)
        config['selectablemaptypes'] = True
        config['defaultmaptype'] = 'normal',
        config['maxzoomlevel'] = 13,
        config['initialzoomlevel'] = 12,
        
        data['config'] = config
        return simplejson.dumps(data)
