// This Javascript is based on code provided by the
// Community Church Javascript Team
// http://www.bisphamchurch.org.uk/
// http://econym.org.uk/gmap/

// start namespace
var omGoogleMaps = function() {

	// arrays to hold copies of the markers and html used by the side_bar
	// because the function closure trick doesnt work there
	var side_bar_html = "";
	var gmarkers = [];
	var htmls = [];

	// A function to create the marker and set up the event window
	function createMarker(point, name, html) {
		var marker = new GMarker(point);
		GEvent.addListener(marker, "click", function() {
			marker.openInfoWindowHtml(html);
		});

		// add a line to the side_bar html
		// side_bar_html += '<a href="javascript:myclick(' + gmarkers.length
		// + ')">' + name
		// + '<\/a><br>';

		// save the info we need to use later for the side_bar
		gmarkers.push(marker);
		htmls.push(html);
		return marker;
	}

	// This function picks up the click and opens the corresponding info
	// window
	function myclick(i) {
		gmarkers[i].openInfoWindowHtml(htmls[i]);
	}

	// ================================================================
	// === Define the function thats going to process the JSON file ===
	process_it = function(jsonData) {
		
		// === Parse the JSON document ===
		var config = jsonData.config;

		var table = jq("#om_table");
		table.hide().after('<div id="ommap"></div>');
		jq('.listingBar').hide();
		
		map_container = jq('#ommap');
		if (map_container.height() == 0)
			map_container.height('50em');
		
		map_container.show();
		
		var map = new GMap(document.getElementById('ommap'));
		map.addControl(new GLargeMapControl());

		var map_type = G_NORMAL_MAP;

		if (config.selectablemaptypes)
			map.addControl(new GMapTypeControl());

		if (config.defaultmaptype == "satellite")
			map_type = G_SATELLITE_MAP;

		if (config.defaultmaptype == "hybrid")
			map_type = G_HYBRID_MAP;

		// === Plot the markers ===
		var bounds = new GLatLngBounds();
		for ( var i = 0; i < jsonData.markers.length; i++) {
			var point = new GLatLng(jsonData.markers[i].lat,
					jsonData.markers[i].lng);
			var marker = createMarker(point, jsonData.markers[i].label,
					jsonData.markers[i].html);
			bounds.extend(point);
		}

		// find and set the center and zoomlevel.
		center = bounds.getCenter();
		zoomlevel = map.getBoundsZoomLevel(bounds);

		map.setCenter(center, zoomlevel, map_type);

		// plot the markers
		for ( var i = 0; i < gmarkers.length; i++) {
			map.addOverlay(gmarkers[i]);
		}

		// put the assembled side_bar_html contents into the side_bar div
		// document.getElementById("side_bar").innerHTML = side_bar_html;

		// === Plot the polylines ===
		for ( var i = 0; i < jsonData.lines.length; i++) {
			var pts = [];
			for ( var j = 0; j < jsonData.lines[i].points.length; j++) {
				pts[j] = new GLatLng(jsonData.lines[i].points[j].lat,
						jsonData.lines[i].points[j].lng);
			}
			map.addOverlay(new GPolyline(pts, jsonData.lines[i].colour,
					jsonData.lines[i].width));
		}
	}


	// namespace dictionary
	return {
		init : function(confguration) {
			registerEventListener(window, 'unload', GUnload);
			
			if (GBrowserIsCompatible()) {
				process_it(confguration);
			}
		},

	};
	// end namespace
}();

jq(window).ready(function (){
	var files_needed = 0;
	var files_loaded = 0;
	
	function loadJS(source){
		// loads java scripts to a already loaded document
		var headID = document.getElementsByTagName('head')[0];
		var newscript = document.createElement('script');
		newscript.type = 'text/javascript';
		newscript.src = source;
		newscript.onload = function() {files_loaded += 1;};
		headID.appendChild(newscript);
		files_needed += 1;
	}
	
	function our_write(argument){
		// extracts the src and passes it on to loadJS
		var re = new RegExp('src="([^"]*)"');
		var matches = re.exec(argument);
		var src = matches[1];
		loadJS(src);
	}
	
	document.write = our_write;
	
	function launch_map(configuration){
		if (files_needed == files_loaded){
			omGoogleMaps.init(configuration);
		}else{
			setTimeout(launch_map,1000, configuration);
		}
	}
	
	jq('#document-action-map a').click(function (){

		if (jq('#ommap').length>0){
			jq('#ommap').toggle();
			jq("#om_table").toggle();
			jq('.listingBar').toggle();
			
		}else{
			load_url = portal_url.slice(0,portal_url.lastIndexOf('/')) + window.location.pathname + '/om_geo.json'+window.location.search;

			configuration = jq.getJSON(load_url, 
					function(data){
						loadJS("http://maps.google.com/maps?file=api&amp;v=2&amp;sensor=false&amp;key=" + data.config.apikey);
						launch_map(data);
			}
			);

		}
		return false;
	});
});


