from zope.interface import implements
from zope.component import adapts
from zope import schema

from Products.CMFPlone.interfaces import IPloneSiteRoot
from Products.CMFDefault.formlib.schema import SchemaAdapterBase
from Products.CMFCore.utils import getToolByName

from betahaus.openmember.browser.controlpanel import registerForm
from betahaus.openmember.interfaces import IOMControlPanelForm

from betahaus.maps.openmember.field import GoogleAPIKey
from betahaus.maps.openmember import mapsMessageFactory as _
from betahaus.maps.openmember import PROJECTNAME


class IOMMapsSchema(IOMControlPanelForm):
    """
    """
    address_fields = schema.List(
        title=_(u'address_fields_title',
                    default = u'Adress fields'),
        description=_(u'address_fields_description',
                        default = u"Add the fields that are part of the address."),
        missing_value = set(),
        value_type=schema.Choice(vocabulary = 'betahaus.openmember.SelectableIndexes'),
        required=False,
        )   

    googlemaps_keys = schema.Tuple(
                        title=_(u'Google Maps API Keys'),
                        description=_('help_google_maps_api_keys',
                                      default=u"Add Google Maps API keys. "
                                               "You have to use the client "
                                               "side url at which your site "
                                               "is visible."),
                        unique=True,
                        value_type=GoogleAPIKey(
                            title=_(u'Key'),
                        ),
                      )
 
    bubble_title_fields = schema.List(
        title=_(u'bubble_title_fields_title',
                    default = u'Bubble title fields'),
        description=_(u'bubble_title_fields_description',
                        default = u"Add the fields that should be part of the title."),
        missing_value = set(),
        value_type=schema.Choice(vocabulary = 'betahaus.openmember.SelectableIndexes'),
        required=False,
        )   
            
class OMMapsPanelAdapter(SchemaAdapterBase):
    """Openmember control panel extension for setting up maps."""
    implements(IOMMapsSchema)
    adapts(IPloneSiteRoot)

    def __init__(self, context):
        super(OMMapsPanelAdapter, self).__init__(context)
        properties = getToolByName(context, 'portal_properties')
        self.openmember_properties = properties.get('openmember_properties')
        # Reuse the properties from the Maps product is available
        self.map_properties = properties.get('maps_properties', self.openmember_properties)
            
    def getId(self):
        return 'maps'
    
    def getLabel(self):
        return _(u'maps_config_label',
                    default=u'Maps')

    def get_address_fields(self):
        """The address fields are stored in the properties tool, on the openmember_properties sheet lines field called address_fields
        """
        return list(getattr(self.openmember_properties, 'address_fields', []))
    
    def set_address_fields(self, value):
        """The address fields are stored in the properties tool, on the openmember_properties sheet lines field called address_fields.
        """
        self.openmember_properties._updateProperty('address_fields', tuple(value))
    
    address_fields = property(get_address_fields,
                              set_address_fields)

    def get_googlemaps_keys(self):
        return getattr(self.map_properties, 'map_google_api_keys', '')

    def set_googlemaps_keys(self, value):
        self.map_properties._updateProperty('map_google_api_keys', value)

    googlemaps_keys = property(get_googlemaps_keys,
                               set_googlemaps_keys)
    
    def get_bubble_title_fields(self):
        return list(getattr(self.openmember_properties, 'bubble_title_fields', []))

    def set_bubble_title_fields(self, value):
        self.openmember_properties._updateProperty('bubble_title_fields', tuple(value))

    bubble_title_fields = property(get_bubble_title_fields,
                                   set_bubble_title_fields)
    
registerForm(IOMMapsSchema, PROJECTNAME)
