# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Response(Model):
    """The response to a metrics query.

    :param cost: The integer value representing the cost of the query, for
     data case.
    :type cost: float
    :param timespan: The timespan for which the data was retrieved. Its value
     consists of two datatimes concatenated, separated by '/'.  This may be
     adjusted in the future and returned back from what was originally
     requested.
    :type timespan: str
    :param interval: The interval (window size) for which the metric data was
     returned in.  This may be adjusted in the future and returned back from
     what was originally requested.  This is not present if a metadata request
     was made.
    :type interval: timedelta
    :param value: the value of the collection.
    :type value: list[~azure.mgmt.monitor.models.Metric]
    """

    _validation = {
        'cost': {'minimum': 0},
        'timespan': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'cost': {'key': 'cost', 'type': 'float'},
        'timespan': {'key': 'timespan', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'duration'},
        'value': {'key': 'value', 'type': '[Metric]'},
    }

    def __init__(self, timespan, value, cost=None, interval=None):
        self.cost = cost
        self.timespan = timespan
        self.interval = interval
        self.value = value
