# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PoolUpgradeProfile(Model):
    """The list of available upgrade versions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar orchestrator_type: Orchestrator type. Default value: "Kubernetes" .
    :vartype orchestrator_type: str
    :param orchestrator_version: Orchestrator version (major, minor, patch).
    :type orchestrator_version: str
    :param name: Pool name.
    :type name: str
    :param os_type: OsType to be used to specify os type. Choose from Linux
     and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
    :type os_type: str or :class:`ContainerServiceOSTypes
     <azure.mgmt.containerservice.models.ContainerServiceOSTypes>`
    :param upgrades:
    :type upgrades: list of :class:`OrchestratorProfile
     <azure.mgmt.containerservice.models.OrchestratorProfile>`
    """

    _validation = {
        'orchestrator_type': {'required': True, 'constant': True},
        'orchestrator_version': {'required': True},
        'os_type': {'required': True},
    }

    _attribute_map = {
        'orchestrator_type': {'key': 'orchestratorType', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'upgrades': {'key': 'upgrades', 'type': '[OrchestratorProfile]'},
    }

    orchestrator_type = "Kubernetes"

    def __init__(self, orchestrator_version, os_type, name=None, upgrades=None):
        self.orchestrator_version = orchestrator_version
        self.name = name
        self.os_type = os_type
        self.upgrades = upgrades
