# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ManagedClusterUpgradeProfileProperties(Model):
    """Control plane and agent pool upgrade profiles.

    :param control_plane_profile: The list of available upgrade versions for
     the control plane.
    :type control_plane_profile: :class:`ManagedClusterPoolUpgradeProfile
     <azure.mgmt.containerservice.models.ManagedClusterPoolUpgradeProfile>`
    :param agent_pool_profiles: The list of available upgrade versions for
     agent pools.
    :type agent_pool_profiles: list of
     :class:`ManagedClusterPoolUpgradeProfile
     <azure.mgmt.containerservice.models.ManagedClusterPoolUpgradeProfile>`
    """

    _validation = {
        'control_plane_profile': {'required': True},
        'agent_pool_profiles': {'required': True},
    }

    _attribute_map = {
        'control_plane_profile': {'key': 'controlPlaneProfile', 'type': 'ManagedClusterPoolUpgradeProfile'},
        'agent_pool_profiles': {'key': 'agentPoolProfiles', 'type': '[ManagedClusterPoolUpgradeProfile]'},
    }

    def __init__(self, control_plane_profile, agent_pool_profiles):
        self.control_plane_profile = control_plane_profile
        self.agent_pool_profiles = agent_pool_profiles
