#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Dec 16 09:40:15 2014

@author: aldehoff
"""
# only needed for Python v2, harmless for Python v3
import sip
sip.setapi('QVariant', 2)

from PyQt4.QtGui import (QItemDelegate, QSpinBox, QStandardItemModel,
                         QTableView, QApplication)
from PyQt4.QtCore import Qt, QModelIndex


class FilterItemDelegate(QItemDelegate):
    def __init__(self, parent=None):
        super(FilterItemDelegate, self).__init__(parent)

    def paint(self, painter, option, index):
        QItemDelegate.paint(self, painter, option, index)
#        pass

    def sizeHint(self, option, index):
        hint = QItemDelegate.sizeHint(self, option, index)
        hint.setHeight(hint.height() * 25)
        return hint

    def createEditor(self, parent, option, index):
        if index.column() == 0:
            item = index.model().data(index, Qt.DisplayRole)
            print(item)
            return item.makeWidget()

#            btn = QPushButton()
#            print("edit mode")
#            btn.setText("I'm an editor!")
#            return btn
        else:
            return QItemDelegate.createEditor(self, parent, option, index)


class SpinBoxDelegate(QItemDelegate):
    """
    Copyright (C) 2005-2005 Trolltech AS. All rights reserved.

    This file is part of the example classes of the Qt Toolkit.

    This file may be used under the terms of the GNU General Public
    License version 2.0 as published by the Free Software Foundation
    and appearing in the file LICENSE.GPL included in the packaging of
    this file.  Please review the following information to ensure GNU
    General Public Licensing requirements will be met:
    http://www.trolltech.com/products/qt/opensource.html

    If you are unsure which license is appropriate for your use, please
    review the following information:
    http://www.trolltech.com/products/qt/licensing.html or contact the
    sales department at sales@trolltech.com.

    This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
    WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
    """
    def createEditor(self, parent, option, index):
        editor = QSpinBox(parent)
        editor.setMinimum(0)
        editor.setMaximum(100)

        return editor

    def setEditorData(self, spinBox, index):
        value = index.model().data(index, Qt.EditRole)

        spinBox.setValue(value)

    def setModelData(self, spinBox, model, index):
        spinBox.interpretText()
        value = spinBox.value()

        model.setData(index, value, Qt.EditRole)

    def updateEditorGeometry(self, editor, option, index):
        editor.setGeometry(option.rect)


if __name__ == '__main__':

    import sys

    app = QApplication(sys.argv)

    model = QStandardItemModel(4, 2)
    tableView = QTableView()
    tableView.setModel(model)

    delegate = SpinBoxDelegate()
    tableView.setItemDelegate(delegate)

    for row in range(4):
        for column in range(2):
            index = model.index(row, column, QModelIndex())
            model.setData(index, (row + 1) * (column + 1))

    tableView.setWindowTitle("Spin Box Delegate")
    tableView.show()
    sys.exit(app.exec_())
