# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RepairTask(Model):
    """Represents a repair task, which includes information about what kind of
    repair was requested, what its progress is, and what its final result was.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.
    .

    :param task_id: The ID of the repair task.
    :type task_id: str
    :param version: The version of the repair task.
     When creating a new repair task, the version must be set to zero.  When
     updating a repair task,
     the version is used for optimistic concurrency checks.  If the version is
     set to zero, the update will not check for write conflicts.  If the
     version is set to a non-zero value, then the
     update will only succeed if the actual current version of the repair task
     matches this value.
    :type version: str
    :param description: A description of the purpose of the repair task, or
     other informational details.
     May be set when the repair task is created, and is immutable once set.
    :type description: str
    :param state: The workflow state of the repair task. Valid initial states
     are Created, Claimed, and Preparing.
     - Invalid - Indicates that the repair task state is invalid. All Service
     Fabric enumerations have the invalid value.
     - Created - Indicates that the repair task has been created.
     - Claimed - Indicates that the repair task has been claimed by a repair
     executor.
     - Preparing - Indicates that the Repair Manager is preparing the system to
     handle the impact of the repair task, usually by taking resources offline
     gracefully.
     - Approved - Indicates that the repair task has been approved by the
     Repair Manager and is safe to execute.
     - Executing - Indicates that execution of the repair task is in progress.
     - Restoring - Indicates that the Repair Manager is restoring the system to
     its pre-repair state, usually by bringing resources back online.
     - Completed - Indicates that the repair task has completed, and no further
     state changes will occur.
     . Possible values include: 'Invalid', 'Created', 'Claimed', 'Preparing',
     'Approved', 'Executing', 'Restoring', 'Completed'
    :type state: str or :class:`enum <azure.servicefabric.models.enum>`
    :param flags: A bitwise-OR of the following values, which gives additional
     details about the status of the repair task.
     - 1 - Cancellation of the repair has been requested
     - 2 - Abort of the repair has been requested
     - 4 - Approval of the repair was forced via client request
    :type flags: int
    :param action: The requested repair action. Must be specified when the
     repair task is created, and is immutable once set.
    :type action: str
    :param target:
    :type target: :class:`RepairTargetDescriptionBase
     <azure.servicefabric.models.RepairTargetDescriptionBase>`
    :param executor: The name of the repair executor. Must be specified in
     Claimed and later states, and is immutable once set.
    :type executor: str
    :param executor_data: A data string that the repair executor can use to
     store its internal state.
    :type executor_data: str
    :param impact:
    :type impact: :class:`RepairImpactDescriptionBase
     <azure.servicefabric.models.RepairImpactDescriptionBase>`
    :param result_status: A value describing the overall result of the repair
     task execution.
     Must be specified in the Restoring and later states, and is immutable once
     set.
     - Invalid - Indicates that the repair task result is invalid. All Service
     Fabric enumerations have the invalid value.
     - Succeeded - Indicates that the repair task completed execution
     successfully.
     - Cancelled - Indicates that the repair task was cancelled prior to
     execution.
     - Interrupted - Indicates that execution of the repair task was
     interrupted by a cancellation request after some work had already been
     performed.
     - Failed - Indicates that there was a failure during execution of the
     repair task. Some work may have been performed.
     - Pending - Indicates that the repair task result is not yet available,
     because the repair task has not finished executing.
     . Possible values include: 'Invalid', 'Succeeded', 'Cancelled',
     'Interrupted', 'Failed', 'Pending'
    :type result_status: str or :class:`enum
     <azure.servicefabric.models.enum>`
    :param result_code: A numeric value providing additional details about the
     result of the repair task execution.
     May be specified in the Restoring and later states, and is immutable once
     set.
    :type result_code: int
    :param result_details: A string providing additional details about the
     result of the repair task execution.
     May be specified in the Restoring and later states, and is immutable once
     set.
    :type result_details: str
    :param history:
    :type history: :class:`RepairTaskHistory
     <azure.servicefabric.models.RepairTaskHistory>`
    :param preparing_health_check_state: Possible values include:
     'NotStarted', 'InProgress', 'Succeeded', 'Skipped', 'TimedOut'
    :type preparing_health_check_state: str or :class:`enum
     <azure.servicefabric.models.enum>`
    :param restoring_health_check_state: Possible values include:
     'NotStarted', 'InProgress', 'Succeeded', 'Skipped', 'TimedOut'
    :type restoring_health_check_state: str or :class:`enum
     <azure.servicefabric.models.enum>`
    :param perform_preparing_health_check: A value to determine if health
     checks will be performed when the repair task enters the Preparing state.
    :type perform_preparing_health_check: bool
    :param perform_restoring_health_check: A value to determine if health
     checks will be performed when the repair task enters the Restoring state.
    :type perform_restoring_health_check: bool
    """

    _validation = {
        'task_id': {'required': True},
        'state': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'task_id': {'key': 'TaskId', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'state': {'key': 'State', 'type': 'str'},
        'flags': {'key': 'Flags', 'type': 'int'},
        'action': {'key': 'Action', 'type': 'str'},
        'target': {'key': 'Target', 'type': 'RepairTargetDescriptionBase'},
        'executor': {'key': 'Executor', 'type': 'str'},
        'executor_data': {'key': 'ExecutorData', 'type': 'str'},
        'impact': {'key': 'Impact', 'type': 'RepairImpactDescriptionBase'},
        'result_status': {'key': 'ResultStatus', 'type': 'str'},
        'result_code': {'key': 'ResultCode', 'type': 'int'},
        'result_details': {'key': 'ResultDetails', 'type': 'str'},
        'history': {'key': 'History', 'type': 'RepairTaskHistory'},
        'preparing_health_check_state': {'key': 'PreparingHealthCheckState', 'type': 'str'},
        'restoring_health_check_state': {'key': 'RestoringHealthCheckState', 'type': 'str'},
        'perform_preparing_health_check': {'key': 'PerformPreparingHealthCheck', 'type': 'bool'},
        'perform_restoring_health_check': {'key': 'PerformRestoringHealthCheck', 'type': 'bool'},
    }

    def __init__(self, task_id, state, action, version=None, description=None, flags=None, target=None, executor=None, executor_data=None, impact=None, result_status=None, result_code=None, result_details=None, history=None, preparing_health_check_state=None, restoring_health_check_state=None, perform_preparing_health_check=None, perform_restoring_health_check=None):
        self.task_id = task_id
        self.version = version
        self.description = description
        self.state = state
        self.flags = flags
        self.action = action
        self.target = target
        self.executor = executor
        self.executor_data = executor_data
        self.impact = impact
        self.result_status = result_status
        self.result_code = result_code
        self.result_details = result_details
        self.history = history
        self.preparing_health_check_state = preparing_health_check_state
        self.restoring_health_check_state = restoring_health_check_state
        self.perform_preparing_health_check = perform_preparing_health_check
        self.perform_restoring_health_check = perform_restoring_health_check
