#!/usr/bin/python
# -*- coding: utf-8 -*-

# Hive Omni ERP
# Copyright (C) 2008-2015 Hive Solutions Lda.
#
# This file is part of Hive Omni ERP.
#
# Hive Omni ERP is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Hive Omni ERP is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Hive Omni ERP. If not, see <http://www.gnu.org/licenses/>.

__author__ = "João Magalhães <joamag@hive.pt>"
""" The author(s) of the module """

__version__ = "1.0.0"
""" The version of the module """

__revision__ = "$LastChangedRevision$"
""" The revision number of the module """

__date__ = "$LastChangedDate$"
""" The last change date of the module """

__copyright__ = "Copyright (c) 2008-2015 Hive Solutions Lda."
""" The copyright for the module """

__license__ = "GNU General Public License (GPL), Version 3"
""" The license for the module """

import base64

import appier

class EntityApi(object):

    def sequence_entity(self, object_id):
        url = self.base_url + "omni/entities/%d/sequence.json" % object_id
        contents = self.get(url)
        return contents

    def media_entity(self, object_id, dimensions = None, label = None):
        url = self.base_url + "omni/entities/%d/media.json" % object_id
        contents = self.get(url, dimensions = dimensions, label = label)
        return contents

    def public_media_entity(self, object_id, dimensions = None, label = None):
        url = self.base_url + "omni/entities/%d/media/public.json" % object_id
        contents = self.get(url, dimensions = dimensions, label = label)
        return contents

    def info_media_entity(self, object_id, dimensions = None, label = None):
        url = self.base_url + "omni/entities/%d/media/info.json" % object_id
        contents = self.get(url, dimensions = dimensions, label = label)
        return contents

    def set_media_entity(
        self,
        object_id,
        data,
        position = None,
        label = None,
        mime_type = None,
        width = None,
        height = None,
        dimensions = None,
        url = None,
        visibility = None,
        engine = None,
        thumbnails = None
    ):
        data_b64 = base64.b64encode(data)
        data_b64 = appier.legacy.str(data_b64)
        data_j = dict(
            data_b64 = data_b64,
            label = label,
            mime_type = mime_type,
            width = width,
            height = height,
            dimensions = dimensions,
            url = url,
            visibility = visibility,
        )
        if not position == None: data_j["position"] = position
        if not engine == None: data_j["engine"] = engine
        if not thumbnails == None: data_j["thumbnails"] = thumbnails
        url = self.base_url + "omni/entities/%d/media/set.json" % object_id
        contents = self.post(url, data_j = data_j)
        return contents
