# Do NOT edit this file!
# It was generated by IdlC class idl.json.python.ProxyAsnVisitor.

#
# Section generated from "/home/nb/builds/MEGA/px2-3.1.x-branch-20150209-none-release-none-pdu-raritan/fwcomponents/mkdist/tmp/px2_final/libidl_client/topofw/peripheral/idl/PeripheralDeviceSlot.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.peripheral

import raritan.rpc.sensors


# enumeration
class PortType(Enumeration):
    idlType = "peripheral.PortType:1.0.0"
    values = ["ONEWIRE_ONBOARD", "ONEWIRE_DEV_PORT", "ONEWIRE_HUB_PORT", "ONEWIRE_CHAIN_POS"]

PortType.ONEWIRE_ONBOARD = PortType(0)
PortType.ONEWIRE_DEV_PORT = PortType(1)
PortType.ONEWIRE_HUB_PORT = PortType(2)
PortType.ONEWIRE_CHAIN_POS = PortType(3)

# structure
class PosElement(Structure):
    idlType = "peripheral.PosElement:1.0.0"
    elements = ["portType", "port"]

    def __init__(self, portType, port):
        typecheck.is_enum(portType, raritan.rpc.peripheral.PortType, AssertionError)
        typecheck.is_string(port, AssertionError)

        self.portType = portType
        self.port = port

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            portType = raritan.rpc.peripheral.PortType.decode(json['portType']),
            port = json['port'],
        )
        return obj

    def encode(self):
        json = {}
        json['portType'] = raritan.rpc.peripheral.PortType.encode(self.portType)
        json['port'] = self.port
        return json

# structure
class DeviceID(Structure):
    idlType = "peripheral.DeviceID:3.0.0"
    elements = ["serial", "type", "isActuator", "channel"]

    def __init__(self, serial, type, isActuator, channel):
        typecheck.is_string(serial, AssertionError)
        typecheck.is_struct(type, raritan.rpc.sensors.Sensor.TypeSpec, AssertionError)
        typecheck.is_bool(isActuator, AssertionError)
        typecheck.is_int(channel, AssertionError)

        self.serial = serial
        self.type = type
        self.isActuator = isActuator
        self.channel = channel

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            serial = json['serial'],
            type = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['type'], agent),
            isActuator = json['isActuator'],
            channel = json['channel'],
        )
        return obj

    def encode(self):
        json = {}
        json['serial'] = self.serial
        json['type'] = raritan.rpc.sensors.Sensor.TypeSpec.encode(self.type)
        json['isActuator'] = self.isActuator
        json['channel'] = self.channel
        return json

# structure
class Address(Structure):
    idlType = "peripheral.Address:3.0.0"
    elements = ["position", "type", "isActuator", "channel"]

    def __init__(self, position, type, isActuator, channel):
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_struct(type, raritan.rpc.sensors.Sensor.TypeSpec, AssertionError)
        typecheck.is_bool(isActuator, AssertionError)
        typecheck.is_int(channel, AssertionError)

        self.position = position
        self.type = type
        self.isActuator = isActuator
        self.channel = channel

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            position = [raritan.rpc.peripheral.PosElement.decode(x0, agent) for x0 in json['position']],
            type = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['type'], agent),
            isActuator = json['isActuator'],
            channel = json['channel'],
        )
        return obj

    def encode(self):
        json = {}
        json['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in self.position]
        json['type'] = raritan.rpc.sensors.Sensor.TypeSpec.encode(self.type)
        json['isActuator'] = self.isActuator
        json['channel'] = self.channel
        return json

# value object
class Device(ValueObject):
    idlType = "peripheral.Device:3.0.0"

    def __init__(self, deviceID, position, packageClass, device):
        typecheck.is_struct(deviceID, raritan.rpc.peripheral.DeviceID, AssertionError)
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_string(packageClass, AssertionError)
        typecheck.is_interface(device, raritan.rpc.sensors.Sensor, AssertionError)

        self.deviceID = deviceID
        self.position = position
        self.packageClass = packageClass
        self.device = device

    def encode(self):
        json = {}
        json['deviceID'] = raritan.rpc.peripheral.DeviceID.encode(self.deviceID)
        json['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in self.position]
        json['packageClass'] = self.packageClass
        json['device'] = Interface.encode(self.device)
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            deviceID = raritan.rpc.peripheral.DeviceID.decode(json['deviceID'], agent),
            position = [raritan.rpc.peripheral.PosElement.decode(x0, agent) for x0 in json['position']],
            packageClass = json['packageClass'],
            device = Interface.decode(json['device'], agent),
        )
        return obj

    def listElements(self):
        elements = ["deviceID", "position", "packageClass", "device"]
        return elements

# interface
class DeviceSlot(Interface):
    idlType = "peripheral.DeviceSlot:2.0.1"

    ERR_INVALID_PARAMS = 1

    ERR_NOT_SUPPORTED = 2

    CHANNEL_INVALID = -1

    # structure
    class Location(Structure):
        idlType = "peripheral.DeviceSlot.Location:1.0.0"
        elements = ["x", "y", "z"]

        def __init__(self, x, y, z):
            typecheck.is_string(x, AssertionError)
            typecheck.is_string(y, AssertionError)
            typecheck.is_string(z, AssertionError)

            self.x = x
            self.y = y
            self.z = z

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                x = json['x'],
                y = json['y'],
                z = json['z'],
            )
            return obj

        def encode(self):
            json = {}
            json['x'] = self.x
            json['y'] = self.y
            json['z'] = self.z
            return json

    # structure
    class Settings(Structure):
        idlType = "peripheral.DeviceSlot.Settings:1.0.0"
        elements = ["name", "description", "location", "useDefaultThresholds", "properties"]

        def __init__(self, name, description, location, useDefaultThresholds, properties):
            typecheck.is_string(name, AssertionError)
            typecheck.is_string(description, AssertionError)
            typecheck.is_struct(location, raritan.rpc.peripheral.DeviceSlot.Location, AssertionError)
            typecheck.is_bool(useDefaultThresholds, AssertionError)

            self.name = name
            self.description = description
            self.location = location
            self.useDefaultThresholds = useDefaultThresholds
            self.properties = properties

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                description = json['description'],
                location = raritan.rpc.peripheral.DeviceSlot.Location.decode(json['location'], agent),
                useDefaultThresholds = json['useDefaultThresholds'],
                properties = dict([(
                    elem['key'],
                    elem['value'])
                    for elem in json['properties']]),
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['description'] = self.description
            json['location'] = raritan.rpc.peripheral.DeviceSlot.Location.encode(self.location)
            json['useDefaultThresholds'] = self.useDefaultThresholds
            json['properties'] = [dict(
                key = k,
                value = v)
                for k, v in self.properties.items()]
            return json

    # value object
    class DeviceChangedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceSlot.DeviceChangedEvent:1.0.0"

        def __init__(self, oldDevice, newDevice, source):
            super(raritan.rpc.peripheral.DeviceSlot.DeviceChangedEvent, self).__init__(source)
            typecheck.is_valobj(oldDevice, raritan.rpc.peripheral.Device, AssertionError)
            typecheck.is_valobj(newDevice, raritan.rpc.peripheral.Device, AssertionError)

            self.oldDevice = oldDevice
            self.newDevice = newDevice

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceSlot.DeviceChangedEvent, self).encode()
            json['oldDevice'] = ValueObject.encode(self.oldDevice)
            json['newDevice'] = ValueObject.encode(self.newDevice)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldDevice = ValueObject.decode(json['oldDevice'], agent),
                newDevice = ValueObject.decode(json['newDevice'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldDevice", "newDevice"]
            elements = elements + super(raritan.rpc.peripheral.DeviceSlot.DeviceChangedEvent, self).listElements()
            return elements

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "peripheral.DeviceSlot.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings, newSettings, actUserName, actIpAddr, source):
            super(raritan.rpc.peripheral.DeviceSlot.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_struct(oldSettings, raritan.rpc.peripheral.DeviceSlot.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.peripheral.DeviceSlot.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceSlot.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.peripheral.DeviceSlot.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.peripheral.DeviceSlot.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.peripheral.DeviceSlot.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.peripheral.DeviceSlot.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.peripheral.DeviceSlot.SettingsChangedEvent, self).listElements()
            return elements

    def getDevice(self):
        agent = self.agent
        args = {}
        rsp = agent.json_rpc(self.target, 'getDevice', args)
        _ret_ = ValueObject.decode(rsp['_ret_'], agent)
        typecheck.is_valobj(_ret_, raritan.rpc.peripheral.Device, DecodeException)
        return _ret_

    def assign(self, devid):
        agent = self.agent
        typecheck.is_struct(devid, raritan.rpc.peripheral.DeviceID, AssertionError)
        args = {}
        args['devid'] = raritan.rpc.peripheral.DeviceID.encode(devid)
        rsp = agent.json_rpc(self.target, 'assign', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def assignAddress(self, packageClass, address):
        agent = self.agent
        typecheck.is_string(packageClass, AssertionError)
        typecheck.is_struct(address, raritan.rpc.peripheral.Address, AssertionError)
        args = {}
        args['packageClass'] = packageClass
        args['address'] = raritan.rpc.peripheral.Address.encode(address)
        rsp = agent.json_rpc(self.target, 'assignAddress', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def unassign(self):
        agent = self.agent
        args = {}
        rsp = agent.json_rpc(self.target, 'unassign', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def getSettings(self):
        agent = self.agent
        args = {}
        rsp = agent.json_rpc(self.target, 'getSettings', args)
        _ret_ = raritan.rpc.peripheral.DeviceSlot.Settings.decode(rsp['_ret_'], agent)
        typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceSlot.Settings, DecodeException)
        return _ret_

    def setSettings(self, settings):
        agent = self.agent
        typecheck.is_struct(settings, raritan.rpc.peripheral.DeviceSlot.Settings, AssertionError)
        args = {}
        args['settings'] = raritan.rpc.peripheral.DeviceSlot.Settings.encode(settings)
        rsp = agent.json_rpc(self.target, 'setSettings', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_
# Do NOT edit this file!
# It was generated by IdlC class idl.json.python.ProxyAsnVisitor.

#
# Section generated from "/home/nb/builds/MEGA/px2-3.1.x-branch-20150209-none-release-none-pdu-raritan/fwcomponents/mkdist/tmp/px2_final/libidl_client/topofw/peripheral/idl/PeripheralDevicePackage.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.peripheral


# structure
class PackageInfo(Structure):
    idlType = "peripheral.PackageInfo:2.0.0"
    elements = ["state", "position", "hwInfo", "fwInfo"]

    def __init__(self, state, position, hwInfo, fwInfo):
        typecheck.is_enum(state, raritan.rpc.peripheral.PackageInfo.State, AssertionError)
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_struct(hwInfo, raritan.rpc.peripheral.PackageInfo.HardwareInfo, AssertionError)
        typecheck.is_struct(fwInfo, raritan.rpc.peripheral.PackageInfo.FirmwareInfo, AssertionError)

        self.state = state
        self.position = position
        self.hwInfo = hwInfo
        self.fwInfo = fwInfo

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            state = raritan.rpc.peripheral.PackageInfo.State.decode(json['state']),
            position = [raritan.rpc.peripheral.PosElement.decode(x0, agent) for x0 in json['position']],
            hwInfo = raritan.rpc.peripheral.PackageInfo.HardwareInfo.decode(json['hwInfo'], agent),
            fwInfo = raritan.rpc.peripheral.PackageInfo.FirmwareInfo.decode(json['fwInfo'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['state'] = raritan.rpc.peripheral.PackageInfo.State.encode(self.state)
        json['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in self.position]
        json['hwInfo'] = raritan.rpc.peripheral.PackageInfo.HardwareInfo.encode(self.hwInfo)
        json['fwInfo'] = raritan.rpc.peripheral.PackageInfo.FirmwareInfo.encode(self.fwInfo)
        return json

    # enumeration
    class State(Enumeration):
        idlType = "peripheral.PackageInfo.State:1.0.0"
        values = ["NORMAL", "FW_UPDATE", "INTERNAL_ERROR", "CONFIG_ERROR"]

    State.NORMAL = State(0)
    State.FW_UPDATE = State(1)
    State.INTERNAL_ERROR = State(2)
    State.CONFIG_ERROR = State(3)

    # structure
    class HardwareInfo(Structure):
        idlType = "peripheral.PackageInfo.HardwareInfo:1.0.0"
        elements = ["serial", "packageClass", "model", "minDowngradeVersion", "revision"]

        def __init__(self, serial, packageClass, model, minDowngradeVersion, revision):
            typecheck.is_string(serial, AssertionError)
            typecheck.is_string(packageClass, AssertionError)
            typecheck.is_string(model, AssertionError)
            typecheck.is_int(minDowngradeVersion, AssertionError)
            typecheck.is_string(revision, AssertionError)

            self.serial = serial
            self.packageClass = packageClass
            self.model = model
            self.minDowngradeVersion = minDowngradeVersion
            self.revision = revision

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                serial = json['serial'],
                packageClass = json['packageClass'],
                model = json['model'],
                minDowngradeVersion = json['minDowngradeVersion'],
                revision = json['revision'],
            )
            return obj

        def encode(self):
            json = {}
            json['serial'] = self.serial
            json['packageClass'] = self.packageClass
            json['model'] = self.model
            json['minDowngradeVersion'] = self.minDowngradeVersion
            json['revision'] = self.revision
            return json

    # structure
    class FirmwareInfo(Structure):
        idlType = "peripheral.PackageInfo.FirmwareInfo:1.0.0"
        elements = ["compileDate", "version", "updateDate"]

        def __init__(self, compileDate, version, updateDate):
            typecheck.is_time(compileDate, AssertionError)
            typecheck.is_struct(version, raritan.rpc.peripheral.PackageInfo.FirmwareInfo.Version, AssertionError)
            typecheck.is_time(updateDate, AssertionError)

            self.compileDate = compileDate
            self.version = version
            self.updateDate = updateDate

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                compileDate = raritan.rpc.Time.decode(json['compileDate']),
                version = raritan.rpc.peripheral.PackageInfo.FirmwareInfo.Version.decode(json['version'], agent),
                updateDate = raritan.rpc.Time.decode(json['updateDate']),
            )
            return obj

        def encode(self):
            json = {}
            json['compileDate'] = raritan.rpc.Time.encode(self.compileDate)
            json['version'] = raritan.rpc.peripheral.PackageInfo.FirmwareInfo.Version.encode(self.version)
            json['updateDate'] = raritan.rpc.Time.encode(self.updateDate)
            return json

        # structure
        class Version(Structure):
            idlType = "peripheral.PackageInfo.FirmwareInfo.Version:1.0.0"
            elements = ["majorNumber", "minorNumber"]

            def __init__(self, majorNumber, minorNumber):
                typecheck.is_int(majorNumber, AssertionError)
                typecheck.is_int(minorNumber, AssertionError)

                self.majorNumber = majorNumber
                self.minorNumber = minorNumber

            @classmethod
            def decode(cls, json, agent):
                obj = cls(
                    majorNumber = json['majorNumber'],
                    minorNumber = json['minorNumber'],
                )
                return obj

            def encode(self):
                json = {}
                json['majorNumber'] = self.majorNumber
                json['minorNumber'] = self.minorNumber
                return json
# Do NOT edit this file!
# It was generated by IdlC class idl.json.python.ProxyAsnVisitor.

#
# Section generated from "/home/nb/builds/MEGA/px2-3.1.x-branch-20150209-none-release-none-pdu-raritan/fwcomponents/mkdist/tmp/px2_final/libidl_client/topofw/peripheral/idl/PeripheralDeviceManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.peripheral

import raritan.rpc.sensors


# interface
class DeviceManager(Interface):
    idlType = "peripheral.DeviceManager:2.0.1"

    ERR_INVALID_PARAMS = 1

    # enumeration
    class ZCoordMode(Enumeration):
        idlType = "peripheral.DeviceManager.ZCoordMode:1.0.0"
        values = ["RACKUNITS", "FREEFORM"]

    ZCoordMode.RACKUNITS = ZCoordMode(0)
    ZCoordMode.FREEFORM = ZCoordMode(1)

    # structure
    class Settings(Structure):
        idlType = "peripheral.DeviceManager.Settings:1.0.0"
        elements = ["zCoordMode", "autoManageNewDevices", "deviceAltitude", "presenceDetectionTimeout", "defaultThresholdsMap"]

        def __init__(self, zCoordMode, autoManageNewDevices, deviceAltitude, presenceDetectionTimeout, defaultThresholdsMap):
            typecheck.is_enum(zCoordMode, raritan.rpc.peripheral.DeviceManager.ZCoordMode, AssertionError)
            typecheck.is_bool(autoManageNewDevices, AssertionError)
            typecheck.is_float(deviceAltitude, AssertionError)
            typecheck.is_int(presenceDetectionTimeout, AssertionError)

            self.zCoordMode = zCoordMode
            self.autoManageNewDevices = autoManageNewDevices
            self.deviceAltitude = deviceAltitude
            self.presenceDetectionTimeout = presenceDetectionTimeout
            self.defaultThresholdsMap = defaultThresholdsMap

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                zCoordMode = raritan.rpc.peripheral.DeviceManager.ZCoordMode.decode(json['zCoordMode']),
                autoManageNewDevices = json['autoManageNewDevices'],
                deviceAltitude = json['deviceAltitude'],
                presenceDetectionTimeout = json['presenceDetectionTimeout'],
                defaultThresholdsMap = dict([(
                    elem['key'],
                    raritan.rpc.sensors.NumericSensor.Thresholds.decode(elem['value'], agent))
                    for elem in json['defaultThresholdsMap']]),
            )
            return obj

        def encode(self):
            json = {}
            json['zCoordMode'] = raritan.rpc.peripheral.DeviceManager.ZCoordMode.encode(self.zCoordMode)
            json['autoManageNewDevices'] = self.autoManageNewDevices
            json['deviceAltitude'] = self.deviceAltitude
            json['presenceDetectionTimeout'] = self.presenceDetectionTimeout
            json['defaultThresholdsMap'] = [dict(
                key = k,
                value = raritan.rpc.sensors.NumericSensor.Thresholds.encode(v))
                for k, v in self.defaultThresholdsMap.items()]
            return json

    # structure
    class MetaData(Structure):
        idlType = "peripheral.DeviceManager.MetaData:1.0.0"
        elements = ["oneWirePortCount", "onboardDeviceCount"]

        def __init__(self, oneWirePortCount, onboardDeviceCount):
            typecheck.is_int(oneWirePortCount, AssertionError)
            typecheck.is_int(onboardDeviceCount, AssertionError)

            self.oneWirePortCount = oneWirePortCount
            self.onboardDeviceCount = onboardDeviceCount

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oneWirePortCount = json['oneWirePortCount'],
                onboardDeviceCount = json['onboardDeviceCount'],
            )
            return obj

        def encode(self):
            json = {}
            json['oneWirePortCount'] = self.oneWirePortCount
            json['onboardDeviceCount'] = self.onboardDeviceCount
            return json

    # structure
    class DeviceTypeInfo(Structure):
        idlType = "peripheral.DeviceManager.DeviceTypeInfo:1.0.0"
        elements = ["type", "isActuator", "identifier", "name", "defaultRange", "defaultDecDigits"]

        def __init__(self, type, isActuator, identifier, name, defaultRange, defaultDecDigits):
            typecheck.is_struct(type, raritan.rpc.sensors.Sensor.TypeSpec, AssertionError)
            typecheck.is_bool(isActuator, AssertionError)
            typecheck.is_string(identifier, AssertionError)
            typecheck.is_string(name, AssertionError)
            typecheck.is_struct(defaultRange, raritan.rpc.sensors.NumericSensor.Range, AssertionError)
            typecheck.is_int(defaultDecDigits, AssertionError)

            self.type = type
            self.isActuator = isActuator
            self.identifier = identifier
            self.name = name
            self.defaultRange = defaultRange
            self.defaultDecDigits = defaultDecDigits

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                type = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['type'], agent),
                isActuator = json['isActuator'],
                identifier = json['identifier'],
                name = json['name'],
                defaultRange = raritan.rpc.sensors.NumericSensor.Range.decode(json['defaultRange'], agent),
                defaultDecDigits = json['defaultDecDigits'],
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = raritan.rpc.sensors.Sensor.TypeSpec.encode(self.type)
            json['isActuator'] = self.isActuator
            json['identifier'] = self.identifier
            json['name'] = self.name
            json['defaultRange'] = raritan.rpc.sensors.NumericSensor.Range.encode(self.defaultRange)
            json['defaultDecDigits'] = self.defaultDecDigits
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "peripheral.DeviceManager.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings, newSettings, actUserName, actIpAddr, source):
            super(raritan.rpc.peripheral.DeviceManager.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_struct(oldSettings, raritan.rpc.peripheral.DeviceManager.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.peripheral.DeviceManager.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.peripheral.DeviceManager.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.peripheral.DeviceManager.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.peripheral.DeviceManager.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.peripheral.DeviceManager.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.SettingsChangedEvent, self).listElements()
            return elements

    # value object
    class DeviceEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager.DeviceEvent:1.0.0"

        def __init__(self, device, allDevices, source):
            super(raritan.rpc.peripheral.DeviceManager.DeviceEvent, self).__init__(source)
            typecheck.is_valobj(device, raritan.rpc.peripheral.Device, AssertionError)
            for x0 in allDevices:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.Device, AssertionError)

            self.device = device
            self.allDevices = allDevices

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.DeviceEvent, self).encode()
            json['device'] = ValueObject.encode(self.device)
            json['allDevices'] = [ValueObject.encode(x0) for x0 in self.allDevices]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                device = ValueObject.decode(json['device'], agent),
                allDevices = [ValueObject.decode(x0, agent) for x0 in json['allDevices']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["device", "allDevices"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.DeviceEvent, self).listElements()
            return elements

    # value object
    class DeviceAddedEvent(DeviceEvent):
        idlType = "peripheral.DeviceManager.DeviceAddedEvent:1.0.0"

        def __init__(self, device, allDevices, source):
            super(raritan.rpc.peripheral.DeviceManager.DeviceAddedEvent, self).__init__(device, allDevices, source)

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.DeviceAddedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.DeviceManager_2_0_1.DeviceEvent
                device = ValueObject.decode(json['device'], agent),
                allDevices = [ValueObject.decode(x0, agent) for x0 in json['allDevices']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.DeviceAddedEvent, self).listElements()
            return elements

    # value object
    class DeviceRemovedEvent(DeviceEvent):
        idlType = "peripheral.DeviceManager.DeviceRemovedEvent:1.0.0"

        def __init__(self, device, allDevices, source):
            super(raritan.rpc.peripheral.DeviceManager.DeviceRemovedEvent, self).__init__(device, allDevices, source)

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.DeviceRemovedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.DeviceManager_2_0_1.DeviceEvent
                device = ValueObject.decode(json['device'], agent),
                allDevices = [ValueObject.decode(x0, agent) for x0 in json['allDevices']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.DeviceRemovedEvent, self).listElements()
            return elements

    # value object
    class UnknownDeviceAttachedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager.UnknownDeviceAttachedEvent:1.0.0"

        def __init__(self, romCode, position, source):
            super(raritan.rpc.peripheral.DeviceManager.UnknownDeviceAttachedEvent, self).__init__(source)
            typecheck.is_string(romCode, AssertionError)
            for x0 in position:
                typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)

            self.romCode = romCode
            self.position = position

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.UnknownDeviceAttachedEvent, self).encode()
            json['romCode'] = self.romCode
            json['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in self.position]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                romCode = json['romCode'],
                position = [raritan.rpc.peripheral.PosElement.decode(x0, agent) for x0 in json['position']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["romCode", "position"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.UnknownDeviceAttachedEvent, self).listElements()
            return elements

    # enumeration
    class DeviceFirmwareUpdateState(Enumeration):
        idlType = "peripheral.DeviceManager.DeviceFirmwareUpdateState:1.0.0"
        values = ["UPDATE_STARTED", "UPDATE_SUCCESSFUL", "UPDATE_FAILED"]

    DeviceFirmwareUpdateState.UPDATE_STARTED = DeviceFirmwareUpdateState(0)
    DeviceFirmwareUpdateState.UPDATE_SUCCESSFUL = DeviceFirmwareUpdateState(1)
    DeviceFirmwareUpdateState.UPDATE_FAILED = DeviceFirmwareUpdateState(2)

    # value object
    class DeviceFirmwareUpdateStateChangedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager.DeviceFirmwareUpdateStateChangedEvent:1.0.0"

        def __init__(self, oldVersion, newVersion, serial, state, source):
            super(raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateStateChangedEvent, self).__init__(source)
            typecheck.is_string(oldVersion, AssertionError)
            typecheck.is_string(newVersion, AssertionError)
            typecheck.is_string(serial, AssertionError)
            typecheck.is_enum(state, raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateState, AssertionError)

            self.oldVersion = oldVersion
            self.newVersion = newVersion
            self.serial = serial
            self.state = state

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateStateChangedEvent, self).encode()
            json['oldVersion'] = self.oldVersion
            json['newVersion'] = self.newVersion
            json['serial'] = self.serial
            json['state'] = raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateState.encode(self.state)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldVersion = json['oldVersion'],
                newVersion = json['newVersion'],
                serial = json['serial'],
                state = raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateState.decode(json['state']),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldVersion", "newVersion", "serial", "state"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateStateChangedEvent, self).listElements()
            return elements

    # value object
    class PackageEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager.PackageEvent:1.0.0"

        def __init__(self, packageInfo, allPackages, source):
            super(raritan.rpc.peripheral.DeviceManager.PackageEvent, self).__init__(source)
            typecheck.is_struct(packageInfo, raritan.rpc.peripheral.PackageInfo, AssertionError)
            for x0 in allPackages:
                typecheck.is_struct(x0, raritan.rpc.peripheral.PackageInfo, AssertionError)

            self.packageInfo = packageInfo
            self.allPackages = allPackages

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.PackageEvent, self).encode()
            json['packageInfo'] = raritan.rpc.peripheral.PackageInfo.encode(self.packageInfo)
            json['allPackages'] = [raritan.rpc.peripheral.PackageInfo.encode(x0) for x0 in self.allPackages]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                packageInfo = raritan.rpc.peripheral.PackageInfo.decode(json['packageInfo'], agent),
                allPackages = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['allPackages']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["packageInfo", "allPackages"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.PackageEvent, self).listElements()
            return elements

    # value object
    class PackageAddedEvent(PackageEvent):
        idlType = "peripheral.DeviceManager.PackageAddedEvent:1.0.0"

        def __init__(self, packageInfo, allPackages, source):
            super(raritan.rpc.peripheral.DeviceManager.PackageAddedEvent, self).__init__(packageInfo, allPackages, source)

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.PackageAddedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.DeviceManager_2_0_1.PackageEvent
                packageInfo = raritan.rpc.peripheral.PackageInfo.decode(json['packageInfo'], agent),
                allPackages = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['allPackages']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.PackageAddedEvent, self).listElements()
            return elements

    # value object
    class PackageRemovedEvent(PackageEvent):
        idlType = "peripheral.DeviceManager.PackageRemovedEvent:1.0.0"

        def __init__(self, packageInfo, allPackages, source):
            super(raritan.rpc.peripheral.DeviceManager.PackageRemovedEvent, self).__init__(packageInfo, allPackages, source)

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.PackageRemovedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.DeviceManager_2_0_1.PackageEvent
                packageInfo = raritan.rpc.peripheral.PackageInfo.decode(json['packageInfo'], agent),
                allPackages = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['allPackages']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.PackageRemovedEvent, self).listElements()
            return elements

    # structure
    class Statistics(Structure):
        idlType = "peripheral.DeviceManager.Statistics:1.0.0"
        elements = ["cSumErrCnt"]

        def __init__(self, cSumErrCnt):
            typecheck.is_int(cSumErrCnt, AssertionError)

            self.cSumErrCnt = cSumErrCnt

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                cSumErrCnt = json['cSumErrCnt'],
            )
            return obj

        def encode(self):
            json = {}
            json['cSumErrCnt'] = self.cSumErrCnt
            return json

    def getDeviceSlots(self):
        agent = self.agent
        args = {}
        rsp = agent.json_rpc(self.target, 'getDeviceSlots', args)
        _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
        for x0 in _ret_:
            typecheck.is_interface(x0, raritan.rpc.peripheral.DeviceSlot, DecodeException)
        return _ret_

    def getDeviceSlot(self, idx):
        agent = self.agent
        typecheck.is_int(idx, AssertionError)
        args = {}
        args['idx'] = idx
        rsp = agent.json_rpc(self.target, 'getDeviceSlot', args)
        _ret_ = Interface.decode(rsp['_ret_'], agent)
        typecheck.is_interface(_ret_, raritan.rpc.peripheral.DeviceSlot, DecodeException)
        return _ret_

    def getDiscoveredDevices(self):
        agent = self.agent
        args = {}
        rsp = agent.json_rpc(self.target, 'getDiscoveredDevices', args)
        _ret_ = [ValueObject.decode(x0, agent) for x0 in rsp['_ret_']]
        for x0 in _ret_:
            typecheck.is_valobj(x0, raritan.rpc.peripheral.Device, DecodeException)
        return _ret_

    def getDiscoveredPackageInfos(self):
        agent = self.agent
        args = {}
        rsp = agent.json_rpc(self.target, 'getDiscoveredPackageInfos', args)
        _ret_ = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in rsp['_ret_']]
        for x0 in _ret_:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PackageInfo, DecodeException)
        return _ret_

    def getSettings(self):
        agent = self.agent
        args = {}
        rsp = agent.json_rpc(self.target, 'getSettings', args)
        _ret_ = raritan.rpc.peripheral.DeviceManager.Settings.decode(rsp['_ret_'], agent)
        typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceManager.Settings, DecodeException)
        return _ret_

    def setSettings(self, settings):
        agent = self.agent
        typecheck.is_struct(settings, raritan.rpc.peripheral.DeviceManager.Settings, AssertionError)
        args = {}
        args['settings'] = raritan.rpc.peripheral.DeviceManager.Settings.encode(settings)
        rsp = agent.json_rpc(self.target, 'setSettings', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def getMetaData(self):
        agent = self.agent
        args = {}
        rsp = agent.json_rpc(self.target, 'getMetaData', args)
        _ret_ = raritan.rpc.peripheral.DeviceManager.MetaData.decode(rsp['_ret_'], agent)
        typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceManager.MetaData, DecodeException)
        return _ret_

    def getDeviceTypeInfos(self):
        agent = self.agent
        args = {}
        rsp = agent.json_rpc(self.target, 'getDeviceTypeInfos', args)
        _ret_ = [raritan.rpc.peripheral.DeviceManager.DeviceTypeInfo.decode(x0, agent) for x0 in rsp['_ret_']]
        for x0 in _ret_:
            typecheck.is_struct(x0, raritan.rpc.peripheral.DeviceManager.DeviceTypeInfo, DecodeException)
        return _ret_

    def getStatistics(self):
        agent = self.agent
        args = {}
        rsp = agent.json_rpc(self.target, 'getStatistics', args)
        _ret_ = raritan.rpc.peripheral.DeviceManager.Statistics.decode(rsp['_ret_'], agent)
        typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceManager.Statistics, DecodeException)
        return _ret_
# Do NOT edit this file!
# It was generated by IdlC class idl.json.python.ProxyAsnVisitor.

#
# Section generated from "/home/nb/builds/MEGA/px2-3.1.x-branch-20150209-none-release-none-pdu-raritan/fwcomponents/mkdist/tmp/px2_final/libidl_client/topofw/peripheral/idl/PeripheralG2Production.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.peripheral


# interface
class G2Production(Interface):
    idlType = "peripheral.G2Production:2.0.0"

    ERR_INVALID_PARAMS = 1

    ERR_NO_CONFIG_MODE = 2

    ERR_NO_DEVICE = 3

    ERR_NO_FIRMWARE_FILE = 4

    ERR_FIRMWARE_INVALID = 5

    ERR_PROTECTED = 6

    ERR_UPDATE_IN_PROGRESS = 7

    # structure
    class FirmwareInfo(Structure):
        idlType = "peripheral.G2Production.FirmwareInfo:1.0.0"
        elements = ["crc", "compiler", "compilerVersion", "compileDate", "version", "subVersion", "configurationId", "updateDate"]

        def __init__(self, crc, compiler, compilerVersion, compileDate, version, subVersion, configurationId, updateDate):
            typecheck.is_int(crc, AssertionError)
            typecheck.is_string(compiler, AssertionError)
            typecheck.is_int(compilerVersion, AssertionError)
            typecheck.is_string(compileDate, AssertionError)
            typecheck.is_int(version, AssertionError)
            typecheck.is_int(subVersion, AssertionError)
            typecheck.is_int(configurationId, AssertionError)
            typecheck.is_string(updateDate, AssertionError)

            self.crc = crc
            self.compiler = compiler
            self.compilerVersion = compilerVersion
            self.compileDate = compileDate
            self.version = version
            self.subVersion = subVersion
            self.configurationId = configurationId
            self.updateDate = updateDate

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                crc = json['crc'],
                compiler = json['compiler'],
                compilerVersion = json['compilerVersion'],
                compileDate = json['compileDate'],
                version = json['version'],
                subVersion = json['subVersion'],
                configurationId = json['configurationId'],
                updateDate = json['updateDate'],
            )
            return obj

        def encode(self):
            json = {}
            json['crc'] = self.crc
            json['compiler'] = self.compiler
            json['compilerVersion'] = self.compilerVersion
            json['compileDate'] = self.compileDate
            json['version'] = self.version
            json['subVersion'] = self.subVersion
            json['configurationId'] = self.configurationId
            json['updateDate'] = self.updateDate
            return json

    def updateFirmware(self, romcode):
        agent = self.agent
        typecheck.is_string(romcode, AssertionError)
        args = {}
        args['romcode'] = romcode
        rsp = agent.json_rpc(self.target, 'updateFirmware', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def updateFirmwarePos(self, position):
        agent = self.agent
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        args = {}
        args['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in position]
        rsp = agent.json_rpc(self.target, 'updateFirmwarePos', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def getFirmwareInfo(self, romcode):
        agent = self.agent
        typecheck.is_string(romcode, AssertionError)
        args = {}
        args['romcode'] = romcode
        rsp = agent.json_rpc(self.target, 'getFirmwareInfo', args)
        _ret_ = rsp['_ret_']
        info = raritan.rpc.peripheral.G2Production.FirmwareInfo.decode(rsp['info'], agent)
        typecheck.is_int(_ret_, DecodeException)
        typecheck.is_struct(info, raritan.rpc.peripheral.G2Production.FirmwareInfo, DecodeException)
        return (_ret_, info)

    def getFirmwareInfoPos(self, position):
        agent = self.agent
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        args = {}
        args['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in position]
        rsp = agent.json_rpc(self.target, 'getFirmwareInfoPos', args)
        _ret_ = rsp['_ret_']
        info = raritan.rpc.peripheral.G2Production.FirmwareInfo.decode(rsp['info'], agent)
        typecheck.is_int(_ret_, DecodeException)
        typecheck.is_struct(info, raritan.rpc.peripheral.G2Production.FirmwareInfo, DecodeException)
        return (_ret_, info)

    # enumeration
    class ConfigurationSpace(Enumeration):
        idlType = "peripheral.G2Production.ConfigurationSpace:1.0.0"
        values = ["HARDWARE", "FUNCTION", "FIRMWARE", "RESERVED"]

    ConfigurationSpace.HARDWARE = ConfigurationSpace(0)
    ConfigurationSpace.FUNCTION = ConfigurationSpace(1)
    ConfigurationSpace.FIRMWARE = ConfigurationSpace(2)
    ConfigurationSpace.RESERVED = ConfigurationSpace(3)

    def readConfigurationSpace(self, romcode, cs):
        agent = self.agent
        typecheck.is_string(romcode, AssertionError)
        typecheck.is_enum(cs, raritan.rpc.peripheral.G2Production.ConfigurationSpace, AssertionError)
        args = {}
        args['romcode'] = romcode
        args['cs'] = raritan.rpc.peripheral.G2Production.ConfigurationSpace.encode(cs)
        rsp = agent.json_rpc(self.target, 'readConfigurationSpace', args)
        _ret_ = rsp['_ret_']
        cfg = [x0 for x0 in rsp['cfg']]
        typecheck.is_int(_ret_, DecodeException)
        for x0 in cfg:
            typecheck.is_byte(x0, DecodeException)
        return (_ret_, cfg)

    def readConfigurationSpacePos(self, position, cs):
        agent = self.agent
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_enum(cs, raritan.rpc.peripheral.G2Production.ConfigurationSpace, AssertionError)
        args = {}
        args['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in position]
        args['cs'] = raritan.rpc.peripheral.G2Production.ConfigurationSpace.encode(cs)
        rsp = agent.json_rpc(self.target, 'readConfigurationSpacePos', args)
        _ret_ = rsp['_ret_']
        cfg = [x0 for x0 in rsp['cfg']]
        typecheck.is_int(_ret_, DecodeException)
        for x0 in cfg:
            typecheck.is_byte(x0, DecodeException)
        return (_ret_, cfg)

    def eraseConfigurationSpace(self, romcode, cs):
        agent = self.agent
        typecheck.is_string(romcode, AssertionError)
        typecheck.is_enum(cs, raritan.rpc.peripheral.G2Production.ConfigurationSpace, AssertionError)
        args = {}
        args['romcode'] = romcode
        args['cs'] = raritan.rpc.peripheral.G2Production.ConfigurationSpace.encode(cs)
        rsp = agent.json_rpc(self.target, 'eraseConfigurationSpace', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def eraseConfigurationSpacePos(self, position, cs):
        agent = self.agent
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_enum(cs, raritan.rpc.peripheral.G2Production.ConfigurationSpace, AssertionError)
        args = {}
        args['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in position]
        args['cs'] = raritan.rpc.peripheral.G2Production.ConfigurationSpace.encode(cs)
        rsp = agent.json_rpc(self.target, 'eraseConfigurationSpacePos', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def writeConfigurationSpace(self, romcode, cs, cfg):
        agent = self.agent
        typecheck.is_string(romcode, AssertionError)
        typecheck.is_enum(cs, raritan.rpc.peripheral.G2Production.ConfigurationSpace, AssertionError)
        for x0 in cfg:
            typecheck.is_byte(x0, AssertionError)
        args = {}
        args['romcode'] = romcode
        args['cs'] = raritan.rpc.peripheral.G2Production.ConfigurationSpace.encode(cs)
        args['cfg'] = [x0 for x0 in cfg]
        rsp = agent.json_rpc(self.target, 'writeConfigurationSpace', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def writeConfigurationSpacePos(self, position, cs, cfg):
        agent = self.agent
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_enum(cs, raritan.rpc.peripheral.G2Production.ConfigurationSpace, AssertionError)
        for x0 in cfg:
            typecheck.is_byte(x0, AssertionError)
        args = {}
        args['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in position]
        args['cs'] = raritan.rpc.peripheral.G2Production.ConfigurationSpace.encode(cs)
        args['cfg'] = [x0 for x0 in cfg]
        rsp = agent.json_rpc(self.target, 'writeConfigurationSpacePos', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def readRegisters(self, romcode, address, count):
        agent = self.agent
        typecheck.is_string(romcode, AssertionError)
        typecheck.is_int(address, AssertionError)
        typecheck.is_int(count, AssertionError)
        args = {}
        args['romcode'] = romcode
        args['address'] = address
        args['count'] = count
        rsp = agent.json_rpc(self.target, 'readRegisters', args)
        _ret_ = rsp['_ret_']
        data = [x0 for x0 in rsp['data']]
        typecheck.is_int(_ret_, DecodeException)
        for x0 in data:
            typecheck.is_byte(x0, DecodeException)
        return (_ret_, data)

    def readRegistersPos(self, position, address, count):
        agent = self.agent
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_int(address, AssertionError)
        typecheck.is_int(count, AssertionError)
        args = {}
        args['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in position]
        args['address'] = address
        args['count'] = count
        rsp = agent.json_rpc(self.target, 'readRegistersPos', args)
        _ret_ = rsp['_ret_']
        data = [x0 for x0 in rsp['data']]
        typecheck.is_int(_ret_, DecodeException)
        for x0 in data:
            typecheck.is_byte(x0, DecodeException)
        return (_ret_, data)

    def writeRegisters(self, romcode, address, data):
        agent = self.agent
        typecheck.is_string(romcode, AssertionError)
        typecheck.is_int(address, AssertionError)
        for x0 in data:
            typecheck.is_byte(x0, AssertionError)
        args = {}
        args['romcode'] = romcode
        args['address'] = address
        args['data'] = [x0 for x0 in data]
        rsp = agent.json_rpc(self.target, 'writeRegisters', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def writeRegistersPos(self, position, address, data):
        agent = self.agent
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_int(address, AssertionError)
        for x0 in data:
            typecheck.is_byte(x0, AssertionError)
        args = {}
        args['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in position]
        args['address'] = address
        args['data'] = [x0 for x0 in data]
        rsp = agent.json_rpc(self.target, 'writeRegistersPos', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def writeRegisterBits(self, romcode, address, mask, bits):
        agent = self.agent
        typecheck.is_string(romcode, AssertionError)
        typecheck.is_int(address, AssertionError)
        typecheck.is_byte(mask, AssertionError)
        typecheck.is_byte(bits, AssertionError)
        args = {}
        args['romcode'] = romcode
        args['address'] = address
        args['mask'] = mask
        args['bits'] = bits
        rsp = agent.json_rpc(self.target, 'writeRegisterBits', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def writeRegisterBitsPos(self, position, address, mask, bits):
        agent = self.agent
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_int(address, AssertionError)
        typecheck.is_byte(mask, AssertionError)
        typecheck.is_byte(bits, AssertionError)
        args = {}
        args['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in position]
        args['address'] = address
        args['mask'] = mask
        args['bits'] = bits
        rsp = agent.json_rpc(self.target, 'writeRegisterBitsPos', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    # enumeration
    class ResetMethod(Enumeration):
        idlType = "peripheral.G2Production.ResetMethod:1.0.0"
        values = ["BROWNOUT", "WATCHDOG"]

    ResetMethod.BROWNOUT = ResetMethod(0)
    ResetMethod.WATCHDOG = ResetMethod(1)

    def reset(self, romcode, method):
        agent = self.agent
        typecheck.is_string(romcode, AssertionError)
        typecheck.is_enum(method, raritan.rpc.peripheral.G2Production.ResetMethod, AssertionError)
        args = {}
        args['romcode'] = romcode
        args['method'] = raritan.rpc.peripheral.G2Production.ResetMethod.encode(method)
        rsp = agent.json_rpc(self.target, 'reset', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def resetPos(self, position, method):
        agent = self.agent
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_enum(method, raritan.rpc.peripheral.G2Production.ResetMethod, AssertionError)
        args = {}
        args['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in position]
        args['method'] = raritan.rpc.peripheral.G2Production.ResetMethod.encode(method)
        rsp = agent.json_rpc(self.target, 'resetPos', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_
