# Do NOT edit this file!
# It was generated by IdlC class idl.json.python.ProxyAsnVisitor.

#
# Section generated from "/home/nb/builds/MEGA/px2-3.1.x-branch-20150209-none-release-none-pdu-raritan/fwcomponents/mkdist/tmp/px2_final/libisys/src/idl/ServerSSLCert.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.cert


# interface
class ServerSSLCert(Interface):
    idlType = "cert.ServerSSLCert:1.0.0"

    # structure
    class CommonAttributes(Structure):
        idlType = "cert.ServerSSLCert.CommonAttributes:1.0.0"
        elements = ["country", "stateOrProvince", "locality", "organization", "organizationalUnit", "commonName", "emailAddress"]

        def __init__(self, country, stateOrProvince, locality, organization, organizationalUnit, commonName, emailAddress):
            typecheck.is_string(country, AssertionError)
            typecheck.is_string(stateOrProvince, AssertionError)
            typecheck.is_string(locality, AssertionError)
            typecheck.is_string(organization, AssertionError)
            typecheck.is_string(organizationalUnit, AssertionError)
            typecheck.is_string(commonName, AssertionError)
            typecheck.is_string(emailAddress, AssertionError)

            self.country = country
            self.stateOrProvince = stateOrProvince
            self.locality = locality
            self.organization = organization
            self.organizationalUnit = organizationalUnit
            self.commonName = commonName
            self.emailAddress = emailAddress

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                country = json['country'],
                stateOrProvince = json['stateOrProvince'],
                locality = json['locality'],
                organization = json['organization'],
                organizationalUnit = json['organizationalUnit'],
                commonName = json['commonName'],
                emailAddress = json['emailAddress'],
            )
            return obj

        def encode(self):
            json = {}
            json['country'] = self.country
            json['stateOrProvince'] = self.stateOrProvince
            json['locality'] = self.locality
            json['organization'] = self.organization
            json['organizationalUnit'] = self.organizationalUnit
            json['commonName'] = self.commonName
            json['emailAddress'] = self.emailAddress
            return json

    # structure
    class ReqInfo(Structure):
        idlType = "cert.ServerSSLCert.ReqInfo:1.0.0"
        elements = ["subject", "keyLength"]

        def __init__(self, subject, keyLength):
            typecheck.is_struct(subject, raritan.rpc.cert.ServerSSLCert.CommonAttributes, AssertionError)
            typecheck.is_int(keyLength, AssertionError)

            self.subject = subject
            self.keyLength = keyLength

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                subject = raritan.rpc.cert.ServerSSLCert.CommonAttributes.decode(json['subject'], agent),
                keyLength = json['keyLength'],
            )
            return obj

        def encode(self):
            json = {}
            json['subject'] = raritan.rpc.cert.ServerSSLCert.CommonAttributes.encode(self.subject)
            json['keyLength'] = self.keyLength
            return json

    # structure
    class CertInfo(Structure):
        idlType = "cert.ServerSSLCert.CertInfo:1.0.0"
        elements = ["subject", "issuer", "invalidBefore", "invalidAfter", "serialNumber", "keyLength"]

        def __init__(self, subject, issuer, invalidBefore, invalidAfter, serialNumber, keyLength):
            typecheck.is_struct(subject, raritan.rpc.cert.ServerSSLCert.CommonAttributes, AssertionError)
            typecheck.is_struct(issuer, raritan.rpc.cert.ServerSSLCert.CommonAttributes, AssertionError)
            typecheck.is_string(invalidBefore, AssertionError)
            typecheck.is_string(invalidAfter, AssertionError)
            typecheck.is_string(serialNumber, AssertionError)
            typecheck.is_int(keyLength, AssertionError)

            self.subject = subject
            self.issuer = issuer
            self.invalidBefore = invalidBefore
            self.invalidAfter = invalidAfter
            self.serialNumber = serialNumber
            self.keyLength = keyLength

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                subject = raritan.rpc.cert.ServerSSLCert.CommonAttributes.decode(json['subject'], agent),
                issuer = raritan.rpc.cert.ServerSSLCert.CommonAttributes.decode(json['issuer'], agent),
                invalidBefore = json['invalidBefore'],
                invalidAfter = json['invalidAfter'],
                serialNumber = json['serialNumber'],
                keyLength = json['keyLength'],
            )
            return obj

        def encode(self):
            json = {}
            json['subject'] = raritan.rpc.cert.ServerSSLCert.CommonAttributes.encode(self.subject)
            json['issuer'] = raritan.rpc.cert.ServerSSLCert.CommonAttributes.encode(self.issuer)
            json['invalidBefore'] = self.invalidBefore
            json['invalidAfter'] = self.invalidAfter
            json['serialNumber'] = self.serialNumber
            json['keyLength'] = self.keyLength
            return json

    # structure
    class Info(Structure):
        idlType = "cert.ServerSSLCert.Info:1.0.0"
        elements = ["havePendingReq", "havePendingCert", "pendingReqInfo", "pendingCertInfo", "activeCertInfo", "maxSignDays"]

        def __init__(self, havePendingReq, havePendingCert, pendingReqInfo, pendingCertInfo, activeCertInfo, maxSignDays):
            typecheck.is_bool(havePendingReq, AssertionError)
            typecheck.is_bool(havePendingCert, AssertionError)
            typecheck.is_struct(pendingReqInfo, raritan.rpc.cert.ServerSSLCert.ReqInfo, AssertionError)
            typecheck.is_struct(pendingCertInfo, raritan.rpc.cert.ServerSSLCert.CertInfo, AssertionError)
            typecheck.is_struct(activeCertInfo, raritan.rpc.cert.ServerSSLCert.CertInfo, AssertionError)
            typecheck.is_int(maxSignDays, AssertionError)

            self.havePendingReq = havePendingReq
            self.havePendingCert = havePendingCert
            self.pendingReqInfo = pendingReqInfo
            self.pendingCertInfo = pendingCertInfo
            self.activeCertInfo = activeCertInfo
            self.maxSignDays = maxSignDays

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                havePendingReq = json['havePendingReq'],
                havePendingCert = json['havePendingCert'],
                pendingReqInfo = raritan.rpc.cert.ServerSSLCert.ReqInfo.decode(json['pendingReqInfo'], agent),
                pendingCertInfo = raritan.rpc.cert.ServerSSLCert.CertInfo.decode(json['pendingCertInfo'], agent),
                activeCertInfo = raritan.rpc.cert.ServerSSLCert.CertInfo.decode(json['activeCertInfo'], agent),
                maxSignDays = json['maxSignDays'],
            )
            return obj

        def encode(self):
            json = {}
            json['havePendingReq'] = self.havePendingReq
            json['havePendingCert'] = self.havePendingCert
            json['pendingReqInfo'] = raritan.rpc.cert.ServerSSLCert.ReqInfo.encode(self.pendingReqInfo)
            json['pendingCertInfo'] = raritan.rpc.cert.ServerSSLCert.CertInfo.encode(self.pendingCertInfo)
            json['activeCertInfo'] = raritan.rpc.cert.ServerSSLCert.CertInfo.encode(self.activeCertInfo)
            json['maxSignDays'] = self.maxSignDays
            return json

    def generateUnsignedKeyPair(self, reqInfo, challenge):
        agent = self.agent
        typecheck.is_struct(reqInfo, raritan.rpc.cert.ServerSSLCert.ReqInfo, AssertionError)
        typecheck.is_string(challenge, AssertionError)
        args = {}
        args['reqInfo'] = raritan.rpc.cert.ServerSSLCert.ReqInfo.encode(reqInfo)
        args['challenge'] = challenge
        rsp = agent.json_rpc(self.target, 'generateUnsignedKeyPair', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def generateSelfSignedKeyPair(self, reqInfo, days):
        agent = self.agent
        typecheck.is_struct(reqInfo, raritan.rpc.cert.ServerSSLCert.ReqInfo, AssertionError)
        typecheck.is_int(days, AssertionError)
        args = {}
        args['reqInfo'] = raritan.rpc.cert.ServerSSLCert.ReqInfo.encode(reqInfo)
        args['days'] = days
        rsp = agent.json_rpc(self.target, 'generateSelfSignedKeyPair', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_

    def deletePending(self):
        agent = self.agent
        args = {}
        rsp = agent.json_rpc(self.target, 'deletePending', args)

    def getInfo(self):
        agent = self.agent
        args = {}
        rsp = agent.json_rpc(self.target, 'getInfo', args)
        info = raritan.rpc.cert.ServerSSLCert.Info.decode(rsp['info'], agent)
        typecheck.is_struct(info, raritan.rpc.cert.ServerSSLCert.Info, DecodeException)
        return info

    def installPendingKeyPair(self):
        agent = self.agent
        args = {}
        rsp = agent.json_rpc(self.target, 'installPendingKeyPair', args)
        _ret_ = rsp['_ret_']
        typecheck.is_int(_ret_, DecodeException)
        return _ret_
