##############################################################################
#
# Copyright (c) 2007 Zope Foundation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""Setup

$Id:$
"""
import os
from setuptools import setup, find_packages

def read(*rnames):
    return open(os.path.join(os.path.dirname(__file__), *rnames)).read()

setup (
    name='z3c.indexer',
    version='0.5.0',
    author = "Roger Ineichen and the Zope Community",
    author_email = "zope3-dev@zope.org",
    description = "A new way to index objects for Zope3",
    long_description=(
        read('README.txt')
        + '\n\n' +
        read('CHANGES.txt')
        ),
    license = "ZPL 2.1",
    keywords = "zope3 z3c catalog indexer index indexing",
    classifiers = [
        'Development Status :: 4 - Beta',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: Zope Public License',
        'Programming Language :: Python',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Topic :: Internet :: WWW/HTTP',
        'Framework :: Zope3'],
    url = 'http://cheeseshop.python.org/pypi/z3c.indexer',
    packages = find_packages('src'),
    include_package_data = True,
    package_dir = {'':'src'},
    namespace_packages = ['z3c',],
    extras_require = dict(
        test = [
            'z3c.coverage',
            'z3c.testing',
            'zope.testing',
            'zope.app.keyreference',
            ],
        performance = [
            'zope.app.component',
            'zope.app.pagetemplate',
            'zope.app.publisher',
            'zope.app.publication',
            'zope.app.container',
            'zope.app.testing',
            'zope.app.zapi',
            'zope.app.pagetemplate',
            'zope.contentprovider',
            'zope.i18n',
            'zope.i18nmessageid',
            'zope.event',
            'zope.i18n',
            'zope.i18nmessageid',
            'zope.lifecycleevent',
            'zope.interface',
            'zope.schema',
            'zope.security',
            'zope.testing',
            'zope.traversing',
            'zope.viewlet',
            ],
        ),
    install_requires = [
        'setuptools',
        'zc.catalog',
        'zope.app.container',
        'zope.app.intid',
        'zope.app.keyreference',
        'zope.component',
        'zope.configuration',
        'zope.index',
        'zope.interface',
        'zope.location',
        'zope.schema',
        ],
    zip_safe = False,
)
