import re
import time

from bs4 import BeautifulSoup
from lxml import etree
from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.support.wait import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
import pandas as pd
from zhulong.util.etl import est_meta, est_html

_name_ = "hezhou"


def f1(driver, num):
    driver.set_page_load_timeout(60)
    locator = (By.XPATH, "//input[@type='submit']")
    WebDriverWait(driver, 20).until(EC.visibility_of_all_elements_located(locator))
    val = driver.find_element_by_xpath('//*[@id="Main_unitList_lstMain_lnk_fEntityName_0"]').text
    cnum = driver.find_element_by_xpath(
        "//input[@class='pager-content-selected' and @style='width:20px;cursor:hand;']").get_attribute("value")
    if int(cnum) > int(num):
        driver.get(driver.current_url)
        cnum = 1
    if int(cnum) != int(num):  # 翻页
        if num <= 10 and int(cnum) <= 10:
            locator = (By.ID, "Main_unitList_unitPager_lstMain_btnPage_%s" % (int(num) - 1))
            WebDriverWait(driver, 30).until(EC.visibility_of_element_located(locator))
            driver.find_element_by_id("Main_unitList_unitPager_lstMain_btnPage_%s" % (int(num) - 1)).click()
            locator = (By.XPATH, '//*[@id="Main_unitList_lstMain_lnk_fEntityName_0"][not(contains(string(),"%s"))]' % val)
            WebDriverWait(driver, 30).until(EC.visibility_of_all_elements_located(locator))
        else:
            d = int(num) - int(cnum)
            # print('num',num,'cnum',cnum,'d',d)
            time = d // 10
            if time:
                for i in range(time):
                    if i == 0:
                        if int(cnum) < 11:
                            WebDriverWait(driver, 30).until(EC.visibility_of_element_located((By.ID, "Main_unitList_unitPager_lstMain_btnPage_10"))).click()
                        else:
                            WebDriverWait(driver, 30).until(EC.visibility_of_element_located((By.ID, "Main_unitList_unitPager_lstMain_btnPage_11"))).click()
                    else:
                        locator = (By.ID, "Main_unitList_unitPager_lstMain_btnPage_11")
                        WebDriverWait(driver, 30).until(EC.visibility_of_element_located(locator))
                        driver.find_element_by_id("Main_unitList_unitPager_lstMain_btnPage_11").click()
                    locator = (By.XPATH, '//*[@id="Main_unitList_lstMain_lnk_fEntityName_0"][not(contains(string(),"%s"))]' % val)
                    WebDriverWait(driver, 30).until(EC.visibility_of_all_elements_located(locator))

            # 10 ,20 ,30为起始页，目标页少10
            if int(cnum) % 10 == 0 and num-int(cnum) > 1:
                if int(cnum) <= 11:
                    WebDriverWait(driver, 30).until(EC.visibility_of_element_located((By.ID, "Main_unitList_unitPager_lstMain_btnPage_10"))).click()
                else:
                    WebDriverWait(driver, 30).until(EC.visibility_of_element_located((By.ID, "Main_unitList_unitPager_lstMain_btnPage_11"))).click()
                locator = (By.XPATH,'//*[@id="Main_unitList_lstMain_lnk_fEntityName_0"][not(contains(string(),"%s"))]' % val)
                WebDriverWait(driver, 30).until(EC.visibility_of_all_elements_located(locator))

            d = d - 10 * time
            j_len = int(str(cnum)[-1:]) + d
            locator = (By.XPATH, "//input[@type='submit']")
            WebDriverWait(driver, 30).until(EC.visibility_of_all_elements_located(locator))
            btns = driver.find_elements_by_xpath("//input[@type='submit']")
            if int(cnum) <= 10:
                if j_len == 1 and len(btns) > 13:
                    WebDriverWait(driver, 30).until(EC.visibility_of_element_located((By.ID, "Main_unitList_unitPager_lstMain_btnPage_10"))).click()
            else:
                if j_len == 1 and len(btns) > 13:
                    WebDriverWait(driver, 30).until(EC.visibility_of_element_located((By.ID, "Main_unitList_unitPager_lstMain_btnPage_11"))).click()

            t = j_len // 10
            for i in range(t):
                cnum_2 = driver.find_element_by_xpath(
                    "//input[@class='pager-content-selected' and @style='width:20px;cursor:hand;']").get_attribute(
                    "value")
                val = driver.find_element_by_xpath('//*[@id="Main_unitList_lstMain_lnk_fEntityName_0"]').text

                if int(cnum_2) <= 10:
                    WebDriverWait(driver, 30).until(EC.visibility_of_element_located((By.ID, "Main_unitList_unitPager_lstMain_btnPage_10"))).click()
                else:
                    WebDriverWait(driver, 30).until(EC.visibility_of_element_located((By.ID, "Main_unitList_unitPager_lstMain_btnPage_11"))).click()
                j_len -= 10
                locator = (By.XPATH,'//*[@id="Main_unitList_lstMain_lnk_fEntityName_0"][not(contains(string(),"%s"))]' % val)
                WebDriverWait(driver, 30).until(EC.visibility_of_all_elements_located(locator))

            locator = (By.ID, "Main_unitList_unitPager_lstMain_btnPage_%s" % j_len)
            WebDriverWait(driver, 30).until(EC.visibility_of_element_located(locator))
            driver.find_element_by_id("Main_unitList_unitPager_lstMain_btnPage_%s" % j_len).click()

    page = driver.page_source
    body = etree.HTML(page)
    data = []

    content_list = body.xpath("//tr[@class='grid-item' or @class='grid-item-alternate']")
    for content in content_list:
        name = content.xpath("./td/a/text()")[0].strip()
        if name == "":
            name = content.xpath("./td[2]/a")[0].xpath("string(.)").strip()
        ggstart_time = content.xpath("./td[@class='grid-item-sorted']/span/text()")[0][:-1].strip().replace("月", '-')
        url = "http://www.hzzfcg.com" + re.findall('\"(.+)\"', content.xpath("./td/a/@onclick")[0])[0][2:]
        temp = [name, ggstart_time, url]
        data.append(temp)
        # print(temp)
    df = pd.DataFrame(data=data)
    df["info"] = None
    return df


def f2(driver):
    locator = (By.ID, "Main_unitList_unitPager_lstMain_btnLast")
    WebDriverWait(driver, 20).until(EC.visibility_of_element_located(locator))
    total_page = driver.find_element_by_xpath("//input[@id='Main_unitList_unitPager_lstMain_btnLast']").get_attribute(
        "value")
    driver.quit()
    return int(total_page)


def f3(driver, url):
    driver.get(url)
    locator = (By.CLASS_NAME, "info_main")
    WebDriverWait(driver, 10).until(EC.presence_of_all_elements_located(locator))
    before = len(driver.page_source)
    time.sleep(0.1)
    after = len(driver.page_source)
    i = 0
    while before != after:
        before = len(driver.page_source)
        time.sleep(0.1)
        after = len(driver.page_source)
        i += 1
        if i > 5: break
    page = driver.page_source
    soup = BeautifulSoup(page, 'html.parser')
    table = soup.find('table', class_='info_main')
    table2 = table.find("table")
    table3 = table2.find("table")
    table4 = table3.find("table")
    return table4


data = [

    ["gcjs_zhaobiao_gg",
     "http://www.hzzfcg.com/page__gp_portal/list_article.aspx?id=9ba20408-67c2-4f11-bc77-13d0dd4c8748",
     ["name", "ggstart_time", "href", "info"], f1, f2],
    ["gcjs_biangeng_gg",
     "http://www.hzzfcg.com/page__gp_portal/list_article.aspx?id=a99892ee-ed5c-4c0f-aa5d-94fd46fb72c4",
     ["name", "ggstart_time", "href", "info"], f1, f2],
    ["gcjs_yucai_gg",
     "http://www.hzzfcg.com/page__gp_portal/list_article.aspx?id=f220428e-dad6-4c31-bc38-f7fefc163cbb",
     ["name", "ggstart_time", "href", "info"], f1, f2],
    ["gcjs_zhongbiaohx_gg",
     "http://www.hzzfcg.com/page__gp_portal/list_article.aspx?id=083422fb-432a-426d-bd0d-58625a9ce035",
     ["name", "ggstart_time", "href", "info"], f1, f2],

]


def work(conp, **arg):
    est_meta(conp, data=data, diqu="广西省贺州市", **arg)
    est_html(conp, f=f3, **arg)


if __name__ == "__main__":

    conp = ["postgres", "since2015", "192.168.3.171", "guangxi", "hezhou"]
    work(conp,num=4)
    # url = "http://www.hzzfcg.com/page__gp_portal/list_article.aspx?id=9ba20408-67c2-4f11-bc77-13d0dd4c8748"
    # url = "http://www.hzzfcg.com/page__gp_portal/list_article.aspx?id=a99892ee-ed5c-4c0f-aa5d-94fd46fb72c4"
    # driver = webdriver.Chrome()
    # driver.get(url)
    # f1(driver,1)
    # print(f1(driver, 32))
    # driver.quit()
    data = {'__EVENTTARGET': '',
            '__EVENTARGUMENT': '',
            '__LASTFOCUS': '',
            '__VIEWSTATEGENERATOR': '8CB3B3E0',
            '__VIEWSTATEENCRYPTED': '',
            'ctl00$Main$unitList$ctl00$ddl_fField': 'fEntityName',
            'ctl00$Main$unitList$ctl00$ddl_fType': '_3_Equal',
            'ctl00$Main$unitList$ctl00$tb_fLower': '',
            'ctl00$Main$unitList$unitPager$lstMain$ctl04$btnPage': '1293',
            'ctl00$Main$noB$noB_NoBotExtender_ClientState': '-180',
            '__VIEWSTATE': "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"}




