/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import org.sikuli.basics.Debug;
import org.sikuli.script.Button;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Mouse;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.RunTime;
import org.sikuli.script.Runner;
import org.sikuli.script.Screen;

public class Commands {
    private static int lvl = 2;
    int i = 0;
    private static Region scr = new Screen();
    private static Region scrSaved = null;
    private static RunTime runTime = RunTime.get();

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, "Commands: " + message, args);
    }

    private static void logCmd(String cmd, Object ... args) {
        String msg = cmd + ": ";
        if (args.length == 0) {
            Commands.log(lvl, msg + "no-args", new Object[0]);
        } else {
            for (int i = 0; i < args.length; ++i) {
                msg = msg + "%s ";
            }
            Commands.log(lvl, msg, args);
        }
    }

    public static boolean isNashorn() {
        return runTime.isJava8();
    }

    public static Object call(String function, Object ... args) {
        Object aObj;
        Method m = null;
        Object retVal = null;
        int count = 0;
        Object[] arr$ = args;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (aObj = arr$[i$]) == null || aObj.getClass().getName().endsWith("Undefined") || aObj instanceof String && ((String)aObj).contains("undefined")); ++i$) {
            ++count;
        }
        Object[] newArgs = new Object[count];
        for (int n = 0; n < count; ++n) {
            newArgs[n] = args[n];
        }
        try {
            m = Commands.class.getMethod(function, Object[].class);
            retVal = m.invoke(null, new Object[]{newArgs});
        }
        catch (Exception ex) {
            m = null;
        }
        return retVal;
    }

    public static Object run(Object ... args) {
        String script = args[0].toString();
        String[] scriptArgs = new String[args.length - 1];
        if (scriptArgs.length > 0) {
            for (int i = 1; i < args.length; ++i) {
                scriptArgs[i - 1] = args[i].toString();
            }
        }
        return Runner.run(script, scriptArgs);
    }

    public static Object circle(Object args) {
        return 0;
    }

    private static boolean isNumber(Object aObj) {
        return aObj instanceof Integer || aObj instanceof Long || aObj instanceof Float || aObj instanceof Double;
    }

    private static int getInteger(Object aObj, int deflt) {
        Integer val = deflt;
        if (aObj instanceof Integer || aObj instanceof Long) {
            val = (Integer)aObj;
        }
        if (aObj instanceof Float) {
            val = Math.round(((Float)aObj).floatValue());
        }
        if (aObj instanceof Double) {
            val = (int)Math.round((Double)aObj);
        }
        return val;
    }

    private static int getInteger(Object aObj) {
        return Commands.getInteger(aObj, 0);
    }

    private static double getNumber(Object aObj, Double deflt) {
        Double val = deflt;
        if (aObj instanceof Integer) {
            val = 0.0 + (double)((Integer)aObj).intValue();
        } else if (aObj instanceof Long) {
            val = 0.0 + (double)((Long)aObj).longValue();
        } else if (aObj instanceof Float) {
            val = 0.0 + (double)((Float)aObj).floatValue();
        } else if (aObj instanceof Double) {
            val = (Double)aObj;
        }
        return val;
    }

    private static double getNumber(Object aObj) {
        return Commands.getNumber(aObj, 0.0);
    }

    public static Region use(Object ... args) {
        Commands.logCmd("use", args);
        scrSaved = null;
        return Commands.usex(args);
    }

    public static Region use1(Object ... args) {
        Commands.logCmd("use1", args);
        scrSaved = scr;
        return Commands.usex(args);
    }

    public static void restoreUsed() {
        if (scrSaved != null) {
            scr = scrSaved;
            scrSaved = null;
            Commands.log(lvl, "restored: %s", scr);
        }
    }

    private static Region usex(Object ... args) {
        int len = args.length;
        int nScreen = -1;
        if (len == 0 || len > 1) {
            scr = new Screen();
            return scr;
        }
        nScreen = Commands.getInteger(args[0], -1);
        if (nScreen > -1) {
            scr = new Screen(nScreen);
        } else {
            Object oReg = args[0];
            if (oReg instanceof Region) {
                scr = (Region)oReg;
            }
        }
        return scr;
    }

    public static Match wait(Object ... args) throws FindFailed {
        Commands.logCmd("wait", args);
        Object[] realArgs = Commands.waitArgs(args);
        return Commands.waitx((String)realArgs[0], (Pattern)realArgs[1], (Double)realArgs[2], ((Float)realArgs[3]).floatValue());
    }

    private static Match waitx(String image, Pattern pimage, double timeout, float score) throws FindFailed {
        Object aPattern = null;
        if (image != null) {
            aPattern = score > 0.0f ? new Pattern(image).similar(score) : image;
        } else if (pimage != null) {
            aPattern = pimage;
        }
        if (aPattern != null) {
            if (timeout > -1.0) {
                return scr.wait(aPattern, timeout);
            }
            return scr.wait(aPattern);
        }
        return null;
    }

    private static Object[] waitArgs(Object ... args) {
        int len = args.length;
        String image = "";
        float score = 0.0f;
        double timeout = -1.0;
        boolean argsOK = true;
        Object[] realArgs = new Object[]{null, null, -1.0, Float.valueOf(0.0f)};
        if (len == 0 || len > 3) {
            argsOK = false;
        } else {
            Object aObj = args[0];
            if (aObj == null) {
                return realArgs;
            }
            if (Commands.isJSON(aObj)) {
                aObj = Commands.fromJSON(aObj);
            }
            if (aObj instanceof String) {
                realArgs[0] = aObj;
            } else if (aObj instanceof Pattern) {
                realArgs[1] = aObj;
                if (len > 1 && Commands.isNumber(args[1])) {
                    realArgs[2] = Commands.getNumber(args[1]);
                }
            } else {
                if (Commands.isNumber(aObj)) {
                    scr.wait(Commands.getNumber(aObj));
                    return null;
                }
                argsOK = false;
            }
        }
        if (argsOK && len > 1 && realArgs[1] == null) {
            if (len > 2 && Commands.isNumber(args[2])) {
                score = (float)Commands.getNumber(args[2]) / 100.0f;
                if ((double)score < 0.7) {
                    score = 0.7f;
                } else if ((double)score > 0.99) {
                    score = 0.99f;
                }
            }
            if (score > 0.0f) {
                realArgs[3] = Float.valueOf(score);
            }
            if (len > 1 && Commands.isNumber(args[1])) {
                realArgs[2] = Commands.getNumber(args[1]);
            }
        }
        if (!argsOK) {
            throw new UnsupportedOperationException("Commands.wait: parameters: String/Pattern:image, float:timeout, int:score");
        }
        return realArgs;
    }

    public static boolean waitVanish(Object ... args) {
        Commands.logCmd("waitVanish", args);
        Object[] realArgs = Commands.waitArgs(args);
        String image = (String)realArgs[0];
        Pattern pimage = (Pattern)realArgs[1];
        double timeout = (Double)realArgs[2];
        float score = ((Float)realArgs[3]).floatValue();
        Object aPattern = image != null ? (score > 0.0f ? new Pattern(image).similar(score) : image) : pimage;
        if (timeout > -1.0) {
            return scr.waitVanish(aPattern, timeout);
        }
        return scr.waitVanish(aPattern);
    }

    public static Match exists(Object ... args) {
        Commands.logCmd("exists", args);
        Match match = null;
        Object[] realArgs = Commands.waitArgs(args);
        if ((Double)realArgs[2] < 0.0) {
            realArgs[2] = 0.0;
        }
        try {
            match = Commands.waitx((String)realArgs[0], (Pattern)realArgs[1], (Double)realArgs[2], ((Float)realArgs[3]).floatValue());
        }
        catch (Exception ex) {
            return null;
        }
        return match;
    }

    public static Location hover(Object ... args) {
        Commands.logCmd("hover", args);
        return Commands.hoverx(args);
    }

    private static Location hoverx(Object ... args) {
        int len = args.length;
        if (len == 0 || args[0] == null) {
            Mouse.move(scr.checkMatch());
            return Mouse.at();
        }
        if (len < 4) {
            Object aObj = args[0];
            Location loc = null;
            if (Commands.isJSON(aObj)) {
                aObj = Commands.fromJSON(aObj);
            }
            if (aObj instanceof String || aObj instanceof Pattern) {
                try {
                    Match aMatch = Commands.wait(args);
                    Mouse.move(aMatch.getTarget());
                }
                catch (Exception ex) {
                    Mouse.move(scr.checkMatch());
                }
                return Mouse.at();
            }
            if (aObj instanceof Region) {
                loc = ((Region)aObj).getTarget();
            } else if (aObj instanceof Location) {
                loc = (Location)aObj;
            }
            if (len > 1) {
                if (Commands.isNumber(aObj) && Commands.isNumber(args[1])) {
                    Mouse.move(scr.checkMatch().offset(Commands.getInteger(aObj), Commands.getInteger(args[1])));
                    return Mouse.at();
                }
                if (len == 3 && loc != null && Commands.isNumber(args[1]) && Commands.isNumber(args[2])) {
                    Mouse.move(loc.offset(Commands.getInteger(args[1], 0), Commands.getInteger(args[2], 0)));
                    return Mouse.at();
                }
            }
            if (loc != null) {
                Mouse.move(loc);
                return Mouse.at();
            }
        }
        Mouse.move(scr.checkMatch());
        return Mouse.at();
    }

    public static Location click(Object ... args) {
        Commands.logCmd("click", args);
        Location loc = Commands.hoverx(args);
        Mouse.click(null, Button.LEFT, (Integer)0, false, null);
        return Mouse.at();
    }

    public static Location doubleClick(Object ... args) {
        Commands.logCmd("doubleClick", args);
        Location loc = Commands.hoverx(args);
        Mouse.click(null, Button.LEFT, (Integer)0, true, null);
        return Mouse.at();
    }

    public static Location rightClick(Object ... args) {
        Commands.logCmd("rightClick", args);
        Location loc = Commands.hoverx(args);
        Mouse.click(null, Button.RIGHT, (Integer)0, false, null);
        return Mouse.at();
    }

    public static boolean paste(Object ... args) {
        Commands.logCmd("paste", args);
        Object[] realArgs = Commands.typeArgs(args);
        return 0 < scr.paste((String)realArgs[0]);
    }

    public static boolean write(Object ... args) {
        Commands.logCmd("write", args);
        Object[] realArgs = Commands.typeArgs(args);
        return 0 < scr.write((String)realArgs[0]);
    }

    private static Object[] typeArgs(Object ... args) {
        Object[] realArgs = new Object[]{null};
        if (!(args[0] instanceof String)) {
            throw new UnsupportedOperationException("Commands.type/paste/write: parameters: String:text");
        }
        realArgs[0] = args[0];
        return realArgs;
    }

    public static boolean isJSON(Object aObj) {
        if (aObj instanceof String) {
            return ((String)aObj).startsWith("[\"");
        }
        return false;
    }

    public static Object fromJSON(Object aObj) {
        if (!Commands.isJSON(aObj)) {
            return aObj;
        }
        Object newObj = null;
        String[] json = ((String)aObj).split(",");
        String last = json[json.length - 1];
        if (!last.endsWith("]")) {
            return aObj;
        }
        json[json.length - 1] = last.substring(0, last.length() - 1);
        String oType = json[0].substring(2, 3);
        if (!"SRML".contains(oType)) {
            return aObj;
        }
        if ("S".equals(oType)) {
            aObj = new Screen(Commands.intFromJSON(json, 5));
            ((Screen)aObj).setRect(Commands.rectFromJSON(json));
        } else if ("R".equals(oType)) {
            newObj = new Region(Commands.rectFromJSON(json));
        } else if ("M".equals(oType)) {
            double score = Commands.dblFromJSON(json, 5) / 100.0;
            newObj = new Match(new Region(Commands.rectFromJSON(json)), score);
            ((Match)newObj).setTarget(Commands.intFromJSON(json, 6), Commands.intFromJSON(json, 7));
        } else if ("L".equals(oType)) {
            newObj = new Location(Commands.locFromJSON(json));
        } else if ("P".equals(oType)) {
            newObj = new Pattern(json[1]);
            ((Pattern)newObj).similar(Commands.fltFromJSON(json, 2));
            ((Pattern)newObj).targetOffset(Commands.intFromJSON(json, 3), Commands.intFromJSON(json, 4));
        }
        return newObj;
    }

    private static Rectangle rectFromJSON(String[] json) {
        int[] vals = new int[4];
        for (int n = 1; n < 5; ++n) {
            try {
                vals[n - 1] = Integer.parseInt(json[n].trim());
                continue;
            }
            catch (Exception ex) {
                vals[n - 1] = 0;
            }
        }
        return new Rectangle(vals[0], vals[1], vals[2], vals[3]);
    }

    private static Point locFromJSON(String[] json) {
        int[] vals = new int[2];
        for (int n = 1; n < 3; ++n) {
            try {
                vals[n - 1] = Integer.parseInt(json[n].trim());
                continue;
            }
            catch (Exception ex) {
                vals[n - 1] = 0;
            }
        }
        return new Point(vals[0], vals[1]);
    }

    private static int intFromJSON(String[] json, int pos) {
        try {
            return Integer.parseInt(json[pos].trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private static float fltFromJSON(String[] json, int pos) {
        try {
            return Float.parseFloat(json[pos].trim());
        }
        catch (Exception ex) {
            return 0.0f;
        }
    }

    private static double dblFromJSON(String[] json, int pos) {
        try {
            return Double.parseDouble(json[pos].trim());
        }
        catch (Exception ex) {
            return 0.0;
        }
    }
}

