import csv
import json
import datetime


"""
Criação de módulo que calcula as compensações de continuidade à consumidores.
"""


class CompensationContinuityConsumer:
    __code_consumer = ""
    __year = 0
    __type_tension = "BT"
    __type_area = "URB"
    __type_system = "INT"
    __code_conjunt = 0
    __dic_monthly_h = [0.0] * 12
    __dic_quartely_h = [0.0] * 4
    __proportion_dic_quartely = [0.0] * 4
    __paid_monthly_dic_quartely_rs = [0.0] * 4
    __dic_yearly_h = [0.0] * 1
    __proportion_dic_yearly = [0.0] * 1
    __paid_monthly_dic_yearly_rs = [0.0] * 1
    __fic_monthly = [0.0] * 12
    __fic_quartely = [0.0] * 4
    __proportion_fic_quartely = [0.0] * 4
    __paid_monthly_fic_quartely_rs = [0.0] * 4
    __fic_yearly = [0.0] * 1
    __proportion_fic_yearly = [0.0] * 1
    __paid_monthly_fic_yearly_rs = [0.0] * 1
    __dmic_monthly_h = [0.0] * 12
    __eusd_monthly_rs = [0.0] * 12
    __eusd_quartely_rs = [0.0] * 4
    __eusd_yearly_rs = [0.0] * 1
    __kei = 0
    __limit_dec_yearly_h = 0
    __limit_fec_yearly = 0
    __limit_dic_monthly_h = 0
    __limit_fic_monthly = 0
    __limit_dmic_monthly_h = 0
    __limit_dic_quartely_h = 0
    __limit_fic_quartely = 0
    __limit_dic_yearly_h = 0
    __limit_fic_yearly = 0
    __monthly_value_compensation = [0.0] * 12
    __monthly_indicator_compensation = ["NA"] * 12
    __quartely_value_compensation = [0.0] * 4
    __quartely_indicator_compensation = ["NA"] * 4
    __yearly_value_compensation = [0.0] * 1
    __yearly_indicator_compensation = ["NA"] * 1

    def set_features(self, code_consumer, year, type_tension, type_area, type_system, code_conjunt, dic_h, fic, dmic_h,
                     eusd_rs):
        self.__code_consumer = code_consumer
        self.__year = year
        self.__type_tension = type_tension
        self.__type_area = type_area
        self.__type_system = type_system
        self.__code_conjunt = code_conjunt
        self.__dic_monthly_h = dic_h
        self.__fic_monthly = fic
        self.__dmic_monthly_h = dmic_h
        self.__eusd_monthly_rs = eusd_rs
        self.calculate_compensation()

    @classmethod
    def get_kei(cls, type_tension):
        if type_tension == "BT":
            return 15
        elif type_tension == "MT":
            return 20
        elif type_tension == "AT":
            return 27

    def __set_kei(self):
        self.__kei = CompensationContinuityConsumer.get_kei(self.__type_tension)

    @classmethod
    def get_dec_fec_limits(cls, code_conjunt, year):
        dec_fec_limits = [0.0] * 2
        # Each register must follow the pattern
        # [year1, codeConjunt1, yearlyDech, yearlyFec]
        limits_table_dech_fec = [
            [1996, 6000, 30, 45],
            [1996, 6001, 30, 45],
            [1996, 6003, 30, 45],
            [1996, 6004, 30, 45],
            [1996, 6005, 30, 45],
            [1996, 6006, 30, 45],
            [1996, 6007, 30, 45],
            [1996, 6008, 30, 45],
            [1996, 6009, 30, 45],
            [1996, 6010, 30, 45],
            [1996, 6011, 30, 45],
            [1996, 6012, 30, 45],
            [1996, 6013, 30, 45],
            [1996, 6014, 30, 45],
            [1996, 6015, 30, 45],
            [1996, 6016, 30, 45],
            [1996, 6018, 30, 45],
            [1996, 6019, 30, 45],
            [1996, 6020, 30, 45],
            [1996, 6021, 30, 45],
            [1996, 6022, 30, 45],
            [1996, 6023, 30, 45],
            [1996, 6024, 30, 45],
            [1996, 6025, 30, 45],
            [1996, 6026, 30, 45],
            [1996, 6027, 30, 45],
            [1996, 6028, 30, 45],
            [1996, 6031, 30, 45],
            [1996, 6032, 30, 45],
            [1996, 6034, 30, 45],
            [1996, 6035, 30, 45],
            [1996, 6036, 30, 45],
            [1996, 6037, 30, 45],
            [1996, 6038, 30, 45],
            [1996, 6039, 30, 45],
            [1996, 6040, 30, 45],
            [1996, 6041, 30, 45],
            [1996, 6042, 30, 45],
            [1997, 1, 50, 60],
            [1997, 2, 120, 90],
            [1997, 3, 70, 70],
            [1997, 4, 120, 90],
            [1997, 5, 120, 90],
            [1997, 6, 120, 90],
            [1997, 7, 120, 90],
            [1997, 8, 70, 70],
            [1997, 13, 120, 90],
            [1997, 14, 120, 90],
            [1997, 15, 70, 70],
            [1997, 16, 70, 70],
            [1997, 17, 120, 90],
            [1997, 18, 70, 70],
            [1997, 19, 70, 70],
            [1997, 20, 120, 90],
            [1997, 21, 70, 70],
            [1997, 22, 120, 90],
            [1997, 23, 120, 90],
            [1997, 24, 120, 90],
            [1997, 25, 13.55, 9.36],
            [1997, 26, 70, 70],
            [1997, 27, 120, 90],
            [1997, 28, 50, 60],
            [1997, 29, 120, 90],
            [1997, 30, 31.41, 21.15],
            [1997, 32, 120, 90],
            [1997, 33, 70, 70],
            [1997, 34, 120, 90],
            [1997, 35, 120, 90],
            [1997, 37, 120, 90],
            [1997, 38, 120, 90],
            [1997, 39, 30, 45],
            [1997, 40, 70, 70],
            [1997, 41, 120, 90],
            [1997, 42, 70, 70],
            [1997, 43, 120, 90],
            [1997, 44, 120, 90],
            [1997, 45, 70, 70],
            [1997, 46, 120, 90],
            [1997, 47, 70, 70],
            [1997, 48, 70, 70],
            [1997, 49, 50, 60],
            [1997, 50, 120, 90],
            [1997, 51, 120, 90],
            [1997, 53, 40, 50],
            [1997, 54, 120, 90],
            [1997, 55, 50, 60],
            [1997, 56, 120, 90],
            [1997, 57, 120, 90],
            [1997, 59, 70, 70],
            [1997, 60, 120, 90],
            [1997, 61, 70, 70],
            [1997, 62, 120, 90],
            [1997, 63, 70, 70],
            [1997, 64, 30, 45],
            [1997, 65, 50, 60],
            [1997, 66, 20, 25],
            [1997, 68, 70, 70],
            [1997, 69, 70, 70],
            [1997, 70, 50, 60],
            [1997, 71, 50, 60],
            [1997, 72, 120, 90],
            [1997, 73, 120, 90],
            [1997, 75, 50, 60],
            [1997, 76, 120, 90],
            [1997, 77, 35.02, 25.49],
            [1997, 78, 120, 90],
            [1997, 81, 70, 70],
            [1997, 82, 70, 70],
            [1997, 83, 40, 50],
            [1997, 84, 120, 90],
            [1997, 87, 120, 90],
            [1997, 88, 15.28, 7.56],
            [1997, 89, 32.24, 21.39],
            [1997, 90, 120, 90],
            [1997, 91, 40, 50],
            [1997, 94, 120, 90],
            [1997, 95, 120, 90],
            [1997, 96, 70, 70],
            [1997, 97, 120, 90],
            [1997, 98, 120, 90],
            [1997, 99, 70, 70],
            [1997, 101, 70, 70],
            [1997, 103, 120, 90],
            [1997, 104, 50, 60],
            [1997, 105, 40, 50],
            [1997, 106, 70, 70],
            [1997, 107, 50, 60],
            [1997, 108, 50, 60],
            [1997, 109, 40, 50],
            [1997, 110, 120, 90],
            [1997, 111, 70, 70],
            [1997, 113, 70, 70],
            [1997, 115, 120, 90],
            [1997, 116, 70, 70],
            [1997, 117, 70, 70],
            [1997, 119, 70, 70],
            [1997, 120, 120, 90],
            [1997, 121, 17.05, 9.84],
            [1997, 122, 120, 90],
            [1997, 123, 120, 90],
            [1997, 124, 70, 70],
            [1997, 125, 120, 90],
            [1997, 128, 70, 70],
            [1997, 129, 120, 90],
            [1997, 130, 30, 45],
            [1997, 131, 120, 90],
            [1997, 133, 35.02, 25.49],
            [1997, 134, 120, 90],
            [1997, 135, 120, 90],
            [1997, 136, 120, 90],
            [1997, 137, 120, 90],
            [1997, 138, 120, 90],
            [1997, 139, 120, 90],
            [1997, 140, 50, 60],
            [1997, 141, 70, 70],
            [1997, 142, 70, 70],
            [1997, 143, 120, 90],
            [1997, 144, 50, 60],
            [1997, 146, 35.02, 25.49],
            [1997, 147, 32.24, 21.39],
            [1997, 149, 50, 60],
            [1997, 150, 50, 60],
            [1997, 152, 120, 90],
            [1997, 153, 30, 45],
            [1997, 154, 120, 90],
            [1997, 155, 120, 90],
            [1997, 156, 120, 90],
            [1997, 157, 120, 90],
            [1997, 158, 35.02, 25.49],
            [1997, 160, 120, 90],
            [1997, 161, 50, 60],
            [1997, 162, 17.62, 13.77],
            [1997, 163, 70, 70],
            [1997, 164, 120, 90],
            [1997, 165, 120, 90],
            [1997, 166, 120, 90],
            [1997, 167, 120, 90],
            [1997, 168, 50, 60],
            [1997, 169, 70, 70],
            [1997, 170, 120, 90],
            [1997, 171, 70, 70],
            [1997, 173, 30, 45],
            [1997, 174, 70, 70],
            [1997, 175, 120, 90],
            [1997, 176, 70, 70],
            [1997, 177, 70, 70],
            [1997, 178, 120, 90],
            [1997, 181, 120, 90],
            [1997, 182, 120, 90],
            [1997, 183, 70, 70],
            [1997, 184, 120, 90],
            [1997, 185, 120, 90],
            [1997, 186, 120, 90],
            [1997, 187, 50, 60],
            [1997, 189, 120, 90],
            [1997, 190, 70, 70],
            [1997, 191, 120, 90],
            [1997, 192, 70, 70],
            [1997, 193, 50, 60],
            [1997, 194, 120, 90],
            [1997, 195, 70, 70],
            [1997, 197, 120, 90],
            [1997, 198, 120, 90],
            [1997, 199, 120, 90],
            [1997, 200, 50, 60],
            [1997, 201, 120, 90],
            [1997, 203, 70, 70],
            [1997, 204, 70, 70],
            [1997, 205, 50, 60],
            [1997, 206, 120, 90],
            [1997, 207, 120, 90],
            [1997, 208, 120, 90],
            [1997, 209, 120, 90],
            [1997, 210, 120, 90],
            [1997, 211, 120, 90],
            [1997, 212, 70, 70],
            [1997, 213, 120, 90],
            [1997, 214, 120, 90],
            [1997, 215, 50, 60],
            [1997, 216, 120, 90],
            [1997, 217, 120, 90],
            [1997, 218, 70, 70],
            [1997, 219, 50, 60],
            [1997, 220, 70, 70],
            [1997, 221, 70, 70],
            [1997, 225, 50, 60],
            [1997, 226, 70, 70],
            [1997, 227, 120, 90],
            [1997, 228, 50, 60],
            [1997, 229, 70, 70],
            [1997, 230, 40, 50],
            [1997, 231, 70, 70],
            [1997, 232, 70, 70],
            [1997, 233, 70, 70],
            [1997, 234, 50, 60],
            [1997, 235, 70, 70],
            [1997, 236, 70, 70],
            [1997, 237, 10.83, 7.57],
            [1997, 239, 120, 90],
            [1997, 240, 120, 90],
            [1997, 241, 70, 70],
            [1997, 242, 120, 90],
            [1997, 243, 120, 90],
            [1997, 244, 120, 90],
            [1997, 245, 120, 90],
            [1997, 246, 120, 90],
            [1997, 247, 120, 90],
            [1997, 248, 120, 90],
            [1997, 249, 120, 90],
            [1997, 250, 50, 60],
            [1997, 252, 120, 90],
            [1997, 253, 120, 90],
            [1997, 254, 120, 90],
            [1997, 256, 50, 60],
            [1997, 257, 120, 90],
            [1997, 258, 120, 90],
            [1997, 259, 70, 70],
            [1997, 260, 70, 70],
            [1997, 261, 15, 25],
            [1997, 262, 70, 70],
            [1997, 264, 70, 70],
            [1997, 265, 120, 90],
            [1997, 267, 120, 90],
            [1997, 268, 35.02, 25.49],
            [1997, 269, 120, 90],
            [1997, 270, 120, 90],
            [1997, 271, 120, 90],
            [1997, 272, 120, 90],
            [1997, 273, 30, 45],
            [1997, 274, 120, 90],
            [1997, 275, 40, 50],
            [1997, 277, 70, 70],
            [1997, 278, 120, 90],
            [1997, 279, 120, 90],
            [1997, 280, 50, 60],
            [1997, 282, 70, 70],
            [1997, 283, 35.02, 25.49],
            [1997, 284, 70, 70],
            [1997, 285, 120, 90],
            [1997, 286, 120, 90],
            [1997, 287, 40, 50],
            [1997, 288, 120, 90],
            [1997, 289, 120, 90],
            [1997, 291, 70, 70],
            [1997, 292, 50, 60],
            [1997, 293, 120, 90],
            [1997, 295, 120, 90],
            [1997, 296, 70, 70],
            [1997, 297, 35.02, 25.49],
            [1997, 298, 50, 60],
            [1997, 299, 120, 90],
            [1997, 300, 120, 90],
            [1997, 302, 120, 90],
            [1997, 305, 120, 90],
            [1997, 306, 120, 90],
            [1997, 307, 120, 90],
            [1997, 308, 50, 60],
            [1997, 309, 35.02, 25.49],
            [1997, 310, 70, 70],
            [1997, 311, 70, 70],
            [1997, 312, 120, 90],
            [1997, 313, 120, 90],
            [1997, 314, 70, 70],
            [1997, 315, 120, 90],
            [1997, 316, 120, 90],
            [1997, 317, 120, 90],
            [1997, 318, 120, 90],
            [1997, 319, 40, 50],
            [1997, 320, 120, 90],
            [1997, 321, 120, 90],
            [1997, 322, 120, 90],
            [1997, 323, 120, 90],
            [1997, 324, 40, 50],
            [1997, 325, 120, 90],
            [1997, 326, 50, 60],
            [1997, 327, 120, 90],
            [1997, 328, 120, 90],
            [1997, 329, 70, 70],
            [1997, 330, 120, 90],
            [1997, 331, 70, 70],
            [1997, 332, 120, 90],
            [1997, 333, 120, 90],
            [1997, 334, 120, 90],
            [1997, 335, 120, 90],
            [1997, 336, 120, 90],
            [1997, 337, 120, 90],
            [1997, 339, 120, 90],
            [1997, 340, 120, 90],
            [1997, 342, 70, 70],
            [1997, 343, 120, 90],
            [1997, 344, 120, 90],
            [1997, 345, 120, 90],
            [1997, 346, 120, 90],
            [1997, 347, 120, 90],
            [1997, 348, 120, 90],
            [1997, 350, 70, 70],
            [1997, 351, 120, 90],
            [1997, 352, 120, 90],
            [1997, 353, 20.67, 13.88],
            [1997, 354, 50, 60],
            [1997, 355, 70, 70],
            [1997, 356, 120, 90],
            [1997, 357, 120, 90],
            [1997, 358, 32.24, 21.39],
            [1997, 360, 120, 90],
            [1997, 361, 70, 70],
            [1997, 362, 50, 60],
            [1997, 363, 70, 70],
            [1997, 364, 120, 90],
            [1997, 365, 120, 90],
            [1997, 366, 70, 70],
            [1997, 367, 50, 60],
            [1997, 368, 120, 90],
            [1997, 369, 6.34, 5.27],
            [1997, 370, 70, 70],
            [1997, 371, 120, 90],
            [1997, 373, 40, 50],
            [1997, 374, 50, 60],
            [1997, 375, 120, 90],
            [1997, 377, 40, 50],
            [1997, 378, 120, 90],
            [1997, 379, 70, 70],
            [1997, 380, 70, 70],
            [1997, 381, 120, 90],
            [1997, 382, 120, 90],
            [1997, 383, 70, 70],
            [1997, 384, 120, 90],
            [1997, 385, 120, 90],
            [1997, 386, 50, 60],
            [1997, 387, 70, 70],
            [1997, 389, 50, 60],
            [1997, 390, 120, 90],
            [1997, 391, 70, 70],
            [1997, 392, 120, 90],
            [1997, 393, 50, 60],
            [1997, 394, 50, 60],
            [1997, 395, 120, 90],
            [1997, 396, 120, 90],
            [1997, 397, 120, 90],
            [1997, 398, 70, 70],
            [1997, 399, 70, 70],
            [1997, 400, 120, 90],
            [1997, 401, 120, 90],
            [1997, 402, 120, 90],
            [1997, 403, 120, 90],
            [1997, 404, 40, 50],
            [1997, 405, 70, 70],
            [1997, 406, 120, 90],
            [1997, 407, 120, 90],
            [1997, 409, 50, 60],
            [1997, 410, 70, 70],
            [1997, 411, 120, 90],
            [1997, 412, 120, 90],
            [1997, 413, 30, 45],
            [1997, 415, 120, 90],
            [1997, 416, 50, 60],
            [1997, 417, 120, 90],
            [1997, 418, 120, 90],
            [1997, 419, 120, 90],
            [1997, 421, 70, 70],
            [1997, 422, 35.02, 25.49],
            [1997, 424, 120, 90],
            [1997, 425, 70, 70],
            [1997, 426, 35.02, 25.49],
            [1997, 427, 40, 50],
            [1997, 428, 70, 70],
            [1997, 429, 70, 70],
            [1997, 430, 70, 70],
            [1997, 432, 70, 70],
            [1997, 433, 120, 90],
            [1997, 434, 70, 70],
            [1997, 436, 70, 70],
            [1997, 437, 50, 60],
            [1997, 438, 70, 70],
            [1997, 439, 70, 70],
            [1997, 440, 120, 90],
            [1997, 441, 70, 70],
            [1997, 442, 50, 60],
            [1997, 443, 120, 90],
            [1997, 444, 20.67, 13.88],
            [1997, 445, 120, 90],
            [1997, 446, 120, 90],
            [1997, 447, 70, 70],
            [1997, 448, 120, 90],
            [1997, 449, 70, 70],
            [1997, 450, 120, 90],
            [1997, 451, 120, 90],
            [1997, 452, 120, 90],
            [1997, 453, 70, 70],
            [1997, 454, 120, 90],
            [1997, 455, 120, 90],
            [1997, 456, 120, 90],
            [1997, 457, 50, 60],
            [1997, 458, 70, 70],
            [1997, 459, 120, 90],
            [1997, 460, 70, 70],
            [1997, 461, 50, 60],
            [1997, 462, 120, 90],
            [1997, 465, 120, 90],
            [1997, 466, 120, 90],
            [1997, 467, 35.02, 25.49],
            [1997, 468, 120, 90],
            [1997, 469, 120, 90],
            [1997, 470, 35.02, 25.49],
            [1997, 471, 70, 70],
            [1997, 472, 120, 90],
            [1997, 473, 120, 90],
            [1997, 474, 70, 70],
            [1997, 475, 120, 90],
            [1997, 476, 120, 90],
            [1997, 477, 120, 90],
            [1997, 478, 120, 90],
            [1997, 479, 70, 70],
            [1997, 480, 70, 70],
            [1997, 481, 70, 70],
            [1997, 482, 70, 70],
            [1997, 483, 120, 90],
            [1997, 484, 70, 70],
            [1997, 485, 120, 90],
            [1997, 486, 50, 60],
            [1997, 487, 30, 45],
            [1997, 488, 120, 90],
            [1997, 490, 120, 90],
            [1997, 491, 70, 70],
            [1997, 493, 120, 90],
            [1997, 494, 120, 90],
            [1997, 495, 120, 90],
            [1997, 496, 70, 70],
            [1997, 497, 70, 70],
            [1997, 498, 70, 70],
            [1997, 499, 120, 90],
            [1997, 500, 120, 90],
            [1997, 501, 70, 70],
            [1997, 502, 120, 90],
            [1997, 503, 70, 70],
            [1997, 504, 40, 50],
            [1997, 505, 50, 60],
            [1997, 507, 120, 90],
            [1997, 508, 70, 70],
            [1997, 509, 5.13, 4.64],
            [1997, 510, 50, 60],
            [1997, 512, 40, 50],
            [1997, 513, 70, 70],
            [1997, 514, 120, 90],
            [1997, 515, 120, 90],
            [1997, 516, 120, 90],
            [1997, 517, 120, 90],
            [1997, 518, 120, 90],
            [1997, 519, 70, 70],
            [1997, 520, 120, 90],
            [1997, 521, 120, 90],
            [1997, 522, 70, 70],
            [1997, 523, 120, 90],
            [1997, 524, 70, 70],
            [1997, 525, 120, 90],
            [1997, 526, 70, 70],
            [1997, 527, 70, 70],
            [1997, 528, 50, 60],
            [1997, 529, 70, 70],
            [1997, 530, 70, 70],
            [1997, 531, 10.37, 9.91],
            [1997, 532, 50, 60],
            [1997, 533, 70, 70],
            [1997, 534, 50, 60],
            [1997, 535, 120, 90],
            [1997, 536, 40, 50],
            [1997, 537, 70, 70],
            [1997, 538, 120, 90],
            [1997, 539, 70, 70],
            [1997, 540, 70, 70],
            [1997, 541, 70, 70],
            [1997, 542, 120, 90],
            [1997, 543, 120, 90],
            [1997, 545, 120, 90],
            [1997, 546, 120, 90],
            [1997, 547, 15, 25],
            [1997, 548, 120, 90],
            [1997, 549, 120, 90],
            [1997, 550, 70, 70],
            [1997, 551, 120, 90],
            [1997, 552, 120, 90],
            [1997, 553, 120, 90],
            [1997, 554, 15, 25],
            [1997, 555, 120, 90],
            [1997, 556, 120, 90],
            [1997, 557, 40, 50],
            [1997, 558, 120, 90],
            [1997, 559, 70, 70],
            [1997, 561, 120, 90],
            [1997, 562, 120, 90],
            [1997, 563, 70, 70],
            [1997, 564, 12.02, 6.99],
            [1997, 565, 30, 45],
            [1997, 566, 120, 90],
            [1997, 567, 70, 70],
            [1997, 568, 70, 70],
            [1997, 569, 70, 70],
            [1997, 570, 120, 90],
            [1997, 571, 70, 70],
            [1997, 572, 40, 50],
            [1997, 573, 120, 90],
            [1997, 574, 70, 70],
            [1997, 575, 120, 90],
            [1997, 576, 120, 90],
            [1997, 577, 120, 90],
            [1997, 578, 120, 90],
            [1997, 579, 40, 50],
            [1997, 580, 120, 90],
            [1997, 581, 30, 45],
            [1997, 582, 70, 70],
            [1997, 583, 70, 70],
            [1997, 584, 21.39, 10.39],
            [1997, 585, 70, 70],
            [1997, 586, 50, 60],
            [1997, 587, 120, 90],
            [1997, 588, 70, 70],
            [1997, 589, 120, 90],
            [1997, 590, 70, 70],
            [1997, 591, 120, 90],
            [1997, 592, 120, 90],
            [1997, 593, 70, 70],
            [1997, 594, 32.24, 21.39],
            [1997, 595, 50, 60],
            [1997, 596, 50, 60],
            [1997, 597, 70, 70],
            [1997, 599, 120, 90],
            [1997, 600, 120, 90],
            [1997, 601, 120, 90],
            [1997, 602, 70, 70],
            [1997, 603, 120, 90],
            [1997, 604, 120, 90],
            [1997, 605, 70, 70],
            [1997, 606, 120, 90],
            [1997, 607, 50, 60],
            [1997, 608, 70, 70],
            [1997, 609, 40, 50],
            [1997, 610, 50, 60],
            [1997, 611, 120, 90],
            [1997, 612, 70, 70],
            [1997, 614, 70, 70],
            [1997, 615, 120, 90],
            [1997, 616, 120, 90],
            [1997, 618, 40, 50],
            [1997, 619, 120, 90],
            [1997, 621, 120, 90],
            [1997, 623, 8.39, 6.11],
            [1997, 625, 120, 90],
            [1997, 626, 40, 50],
            [1997, 627, 50, 60],
            [1997, 628, 70, 70],
            [1997, 629, 120, 90],
            [1997, 630, 120, 90],
            [1997, 631, 120, 90],
            [1997, 632, 30, 45],
            [1997, 633, 120, 90],
            [1997, 635, 70, 70],
            [1997, 636, 70, 70],
            [1997, 637, 7.01, 5.35],
            [1997, 638, 120, 90],
            [1997, 639, 70, 70],
            [1997, 640, 70, 70],
            [1997, 641, 120, 90],
            [1997, 642, 120, 90],
            [1997, 643, 120, 90],
            [1997, 644, 120, 90],
            [1997, 645, 50, 60],
            [1997, 646, 120, 90],
            [1997, 647, 70, 70],
            [1997, 648, 70, 70],
            [1997, 649, 70, 70],
            [1997, 650, 120, 90],
            [1997, 651, 120, 90],
            [1997, 652, 70, 70],
            [1997, 653, 70, 70],
            [1997, 654, 120, 90],
            [1997, 656, 120, 90],
            [1997, 657, 120, 90],
            [1997, 658, 120, 90],
            [1997, 660, 50, 60],
            [1997, 661, 70, 70],
            [1997, 662, 120, 90],
            [1997, 663, 120, 90],
            [1997, 664, 70, 70],
            [1997, 665, 120, 90],
            [1997, 666, 120, 90],
            [1997, 667, 120, 90],
            [1997, 668, 120, 90],
            [1997, 669, 50, 60],
            [1997, 670, 70, 70],
            [1997, 672, 70, 70],
            [1997, 673, 120, 90],
            [1997, 674, 70, 70],
            [1997, 675, 70, 70],
            [1997, 676, 120, 90],
            [1997, 677, 120, 90],
            [1997, 678, 70, 70],
            [1997, 679, 120, 90],
            [1997, 681, 32.24, 21.39],
            [1997, 682, 8.1, 6.18],
            [1997, 685, 70, 70],
            [1997, 686, 50, 60],
            [1997, 687, 120, 90],
            [1997, 688, 120, 90],
            [1997, 689, 120, 90],
            [1997, 690, 50, 60],
            [1997, 691, 120, 90],
            [1997, 692, 32.24, 21.39],
            [1997, 693, 70, 70],
            [1997, 694, 50, 60],
            [1997, 695, 120, 90],
            [1997, 697, 120, 90],
            [1997, 698, 70, 70],
            [1997, 699, 30, 45],
            [1997, 700, 70, 70],
            [1997, 701, 120, 90],
            [1997, 702, 70, 70],
            [1997, 703, 70, 70],
            [1997, 704, 120, 90],
            [1997, 705, 40, 50],
            [1997, 706, 70, 70],
            [1997, 707, 120, 90],
            [1997, 708, 70, 70],
            [1997, 709, 120, 90],
            [1997, 710, 120, 90],
            [1997, 711, 50, 60],
            [1997, 712, 120, 90],
            [1997, 713, 120, 90],
            [1997, 714, 50, 60],
            [1997, 715, 120, 90],
            [1997, 716, 70, 70],
            [1997, 717, 70, 70],
            [1997, 718, 50, 60],
            [1997, 719, 120, 90],
            [1997, 720, 120, 90],
            [1997, 721, 50, 60],
            [1997, 722, 120, 90],
            [1997, 723, 120, 90],
            [1997, 724, 120, 90],
            [1997, 726, 120, 90],
            [1997, 727, 50, 60],
            [1997, 730, 35.02, 25.49],
            [1997, 731, 50, 60],
            [1997, 732, 120, 90],
            [1997, 733, 120, 90],
            [1997, 734, 30, 45],
            [1997, 735, 120, 90],
            [1997, 736, 70, 70],
            [1997, 737, 70, 70],
            [1997, 738, 120, 90],
            [1997, 739, 70, 70],
            [1997, 740, 120, 90],
            [1997, 741, 120, 90],
            [1997, 742, 40, 50],
            [1997, 744, 120, 90],
            [1997, 745, 120, 90],
            [1997, 746, 40, 50],
            [1997, 747, 50, 60],
            [1997, 748, 70, 70],
            [1997, 749, 50, 60],
            [1997, 750, 120, 90],
            [1997, 751, 50, 60],
            [1997, 752, 120, 90],
            [1997, 753, 50, 60],
            [1997, 754, 70, 70],
            [1997, 755, 120, 90],
            [1997, 756, 70, 70],
            [1997, 757, 120, 90],
            [1997, 758, 70, 70],
            [1997, 759, 70, 70],
            [1997, 761, 120, 90],
            [1997, 762, 70, 70],
            [1997, 763, 70, 70],
            [1997, 765, 120, 90],
            [1997, 766, 120, 90],
            [1997, 767, 70, 70],
            [1997, 768, 120, 90],
            [1997, 769, 120, 90],
            [1997, 771, 120, 90],
            [1997, 772, 70, 70],
            [1997, 773, 120, 90],
            [1997, 774, 120, 90],
            [1997, 775, 70, 70],
            [1997, 776, 120, 90],
            [1997, 777, 70, 70],
            [1997, 778, 120, 90],
            [1997, 779, 50, 60],
            [1997, 781, 120, 90],
            [1997, 782, 120, 90],
            [1997, 783, 50, 60],
            [1997, 784, 50, 60],
            [1997, 785, 120, 90],
            [1997, 786, 120, 90],
            [1997, 787, 70, 70],
            [1997, 788, 50, 60],
            [1997, 789, 120, 90],
            [1997, 790, 120, 90],
            [1997, 791, 120, 90],
            [1997, 792, 40, 50],
            [1997, 793, 120, 90],
            [1997, 794, 120, 90],
            [1997, 795, 120, 90],
            [1997, 796, 70, 70],
            [1997, 797, 120, 90],
            [1997, 799, 50, 60],
            [1997, 801, 70, 70],
            [1997, 802, 120, 90],
            [1997, 803, 120, 90],
            [1997, 804, 120, 90],
            [1997, 805, 70, 70],
            [1997, 806, 120, 90],
            [1997, 807, 30, 45],
            [1997, 809, 120, 90],
            [1997, 810, 120, 90],
            [1997, 811, 120, 90],
            [1997, 812, 50, 60],
            [1997, 814, 120, 90],
            [1997, 815, 120, 90],
            [1997, 817, 70, 70],
            [1997, 818, 120, 90],
            [1997, 819, 120, 90],
            [1997, 820, 120, 90],
            [1997, 821, 120, 90],
            [1997, 822, 40, 50],
            [1997, 823, 120, 90],
            [1997, 824, 120, 90],
            [1997, 825, 70, 70],
            [1997, 826, 120, 90],
            [1997, 827, 70, 70],
            [1997, 830, 120, 90],
            [1997, 831, 120, 90],
            [1997, 832, 120, 90],
            [1997, 833, 120, 90],
            [1997, 834, 70, 70],
            [1997, 835, 70, 70],
            [1997, 836, 120, 90],
            [1997, 837, 70, 70],
            [1997, 838, 120, 90],
            [1997, 839, 70, 70],
            [1997, 840, 70, 70],
            [1997, 841, 120, 90],
            [1997, 842, 50, 60],
            [1997, 843, 120, 90],
            [1997, 844, 120, 90],
            [1997, 845, 70, 70],
            [1997, 846, 120, 90],
            [1997, 847, 32.24, 21.39],
            [1997, 848, 120, 90],
            [1997, 850, 40, 50],
            [1997, 852, 70, 70],
            [1997, 853, 120, 90],
            [1997, 854, 120, 90],
            [1997, 855, 9.81, 9.88],
            [1997, 856, 120, 90],
            [1997, 857, 120, 90],
            [1997, 858, 120, 90],
            [1997, 859, 120, 90],
            [1997, 860, 70, 70],
            [1997, 861, 120, 90],
            [1997, 863, 40, 50],
            [1997, 865, 70, 70],
            [1997, 867, 120, 90],
            [1997, 868, 70, 70],
            [1997, 869, 70, 70],
            [1997, 870, 120, 90],
            [1997, 871, 120, 90],
            [1997, 872, 70, 70],
            [1997, 873, 70, 70],
            [1997, 874, 50, 60],
            [1997, 875, 120, 90],
            [1997, 876, 120, 90],
            [1997, 877, 120, 90],
            [1997, 878, 5.59, 4.6],
            [1997, 879, 120, 90],
            [1997, 880, 120, 90],
            [1997, 881, 35.02, 25.49],
            [1997, 882, 50, 60],
            [1997, 883, 120, 90],
            [1997, 884, 50, 60],
            [1997, 885, 70, 70],
            [1997, 886, 120, 90],
            [1997, 887, 50, 60],
            [1997, 888, 120, 90],
            [1997, 890, 120, 90],
            [1997, 891, 120, 90],
            [1997, 892, 120, 90],
            [1997, 894, 120, 90],
            [1997, 895, 120, 90],
            [1997, 896, 120, 90],
            [1997, 897, 30, 45],
            [1997, 898, 120, 90],
            [1997, 899, 120, 90],
            [1997, 900, 6.81, 4.72],
            [1997, 901, 120, 90],
            [1997, 902, 70, 70],
            [1997, 903, 70, 70],
            [1997, 904, 120, 90],
            [1997, 905, 120, 90],
            [1997, 906, 70, 70],
            [1997, 907, 120, 90],
            [1997, 908, 50, 60],
            [1997, 910, 17.59, 7.29],
            [1997, 911, 50, 60],
            [1997, 912, 40, 50],
            [1997, 913, 40, 50],
            [1997, 914, 120, 90],
            [1997, 915, 120, 90],
            [1997, 916, 50, 60],
            [1997, 917, 30, 45],
            [1997, 918, 120, 90],
            [1997, 919, 120, 90],
            [1997, 920, 40, 50],
            [1997, 921, 120, 90],
            [1997, 922, 40, 50],
            [1997, 924, 11.58, 10.56],
            [1997, 926, 120, 90],
            [1997, 927, 70, 70],
            [1997, 928, 120, 90],
            [1997, 929, 120, 90],
            [1997, 930, 120, 90],
            [1997, 931, 120, 90],
            [1997, 932, 70, 70],
            [1997, 933, 70, 70],
            [1997, 934, 50, 60],
            [1997, 935, 120, 90],
            [1997, 936, 50, 60],
            [1997, 937, 120, 90],
            [1997, 938, 70, 70],
            [1997, 939, 70, 70],
            [1997, 940, 70, 70],
            [1997, 941, 70, 70],
            [1997, 942, 120, 90],
            [1997, 943, 120, 90],
            [1997, 944, 120, 90],
            [1997, 945, 50, 60],
            [1997, 946, 50, 60],
            [1997, 947, 120, 90],
            [1997, 948, 70, 70],
            [1997, 949, 120, 90],
            [1997, 950, 70, 70],
            [1997, 951, 120, 90],
            [1997, 953, 70, 70],
            [1997, 954, 120, 90],
            [1997, 955, 120, 90],
            [1997, 957, 120, 90],
            [1997, 958, 50, 60],
            [1997, 960, 50, 60],
            [1997, 961, 120, 90],
            [1997, 963, 32.24, 21.39],
            [1997, 964, 50, 60],
            [1997, 965, 50, 60],
            [1997, 967, 120, 90],
            [1997, 968, 120, 90],
            [1997, 969, 70, 70],
            [1997, 970, 20.67, 13.88],
            [1997, 971, 50, 60],
            [1997, 972, 120, 90],
            [1997, 973, 70, 70],
            [1997, 974, 30, 45],
            [1997, 975, 70, 70],
            [1997, 978, 70, 70],
            [1997, 979, 70, 70],
            [1997, 980, 70, 70],
            [1997, 981, 120, 90],
            [1997, 982, 120, 90],
            [1997, 984, 120, 90],
            [1997, 985, 70, 70],
            [1997, 987, 35.02, 25.49],
            [1997, 988, 6.14, 5.32],
            [1997, 989, 120, 90],
            [1997, 990, 120, 90],
            [1997, 991, 120, 90],
            [1997, 992, 120, 90],
            [1997, 993, 120, 90],
            [1997, 994, 120, 90],
            [1997, 995, 120, 90],
            [1997, 996, 120, 90],
            [1997, 997, 120, 90],
            [1997, 998, 70, 70],
            [1997, 999, 120, 90],
            [1997, 1000, 120, 90],
            [1997, 1001, 120, 90],
            [1997, 1003, 8.24, 5.82],
            [1997, 1004, 70, 70],
            [1997, 1005, 17.62, 13.77],
            [1997, 1006, 120, 90],
            [1997, 1007, 40, 50],
            [1997, 1008, 50, 60],
            [1997, 1009, 120, 90],
            [1997, 1010, 50, 60],
            [1997, 1011, 120, 90],
            [1997, 1012, 120, 90],
            [1997, 1013, 120, 90],
            [1997, 1014, 70, 70],
            [1997, 1015, 120, 90],
            [1997, 1016, 50, 60],
            [1997, 1017, 70, 70],
            [1997, 1018, 120, 90],
            [1997, 1019, 70, 70],
            [1997, 1020, 32.24, 21.39],
            [1997, 1021, 70, 70],
            [1997, 1022, 120, 90],
            [1997, 1023, 50, 60],
            [1997, 1025, 120, 90],
            [1997, 1026, 30, 45],
            [1997, 1027, 120, 90],
            [1997, 1029, 32.24, 21.39],
            [1997, 1030, 40, 50],
            [1997, 1031, 120, 90],
            [1997, 1033, 120, 90],
            [1997, 1034, 120, 90],
            [1997, 1035, 30, 45],
            [1997, 1036, 70, 70],
            [1997, 1037, 120, 90],
            [1997, 1038, 70, 70],
            [1997, 1039, 120, 90],
            [1997, 1040, 15, 20],
            [1997, 1041, 120, 90],
            [1997, 1043, 120, 90],
            [1997, 1044, 120, 90],
            [1997, 1045, 120, 90],
            [1997, 1046, 50, 60],
            [1997, 1047, 70, 70],
            [1997, 1048, 70, 70],
            [1997, 1050, 70, 70],
            [1997, 1051, 120, 90],
            [1997, 1052, 50, 60],
            [1997, 1053, 70, 70],
            [1997, 1054, 120, 90],
            [1997, 1055, 120, 90],
            [1997, 1056, 70, 70],
            [1997, 1057, 50, 60],
            [1997, 1058, 70, 70],
            [1997, 1059, 70, 70],
            [1997, 1061, 70, 70],
            [1997, 1062, 70, 70],
            [1997, 1063, 120, 90],
            [1997, 1064, 20.67, 13.88],
            [1997, 1065, 120, 90],
            [1997, 1066, 50, 60],
            [1997, 1067, 120, 90],
            [1997, 1069, 50, 60],
            [1997, 1070, 50, 60],
            [1997, 1071, 70, 70],
            [1997, 1073, 120, 90],
            [1997, 1074, 120, 90],
            [1997, 1076, 70, 70],
            [1997, 1077, 120, 90],
            [1997, 1078, 120, 90],
            [1997, 1079, 120, 90],
            [1997, 1080, 120, 90],
            [1997, 1081, 70, 70],
            [1997, 1082, 120, 90],
            [1997, 1083, 40, 50],
            [1997, 1084, 120, 90],
            [1997, 1085, 120, 90],
            [1997, 1086, 120, 90],
            [1997, 1087, 70, 70],
            [1997, 1088, 120, 90],
            [1997, 1089, 50, 60],
            [1997, 1090, 120, 90],
            [1997, 1091, 120, 90],
            [1997, 1092, 15, 25],
            [1997, 1093, 50, 60],
            [1997, 1094, 120, 90],
            [1997, 1095, 120, 90],
            [1997, 1096, 120, 90],
            [1997, 1097, 70, 70],
            [1997, 1098, 120, 90],
            [1997, 1100, 120, 90],
            [1997, 1102, 120, 90],
            [1997, 1104, 70, 70],
            [1997, 1105, 120, 90],
            [1997, 1106, 120, 90],
            [1997, 1108, 120, 90],
            [1997, 1109, 120, 90],
            [1997, 1110, 120, 90],
            [1997, 1111, 120, 90],
            [1997, 1112, 120, 90],
            [1997, 1113, 120, 90],
            [1997, 1114, 120, 90],
            [1997, 1115, 120, 90],
            [1997, 1116, 120, 90],
            [1997, 1117, 70, 70],
            [1997, 1118, 50, 60],
            [1997, 1119, 50, 60],
            [1997, 1120, 120, 90],
            [1997, 1121, 120, 90],
            [1997, 1122, 35.02, 25.49],
            [1997, 1123, 70, 70],
            [1997, 1124, 70, 70],
            [1997, 1125, 120, 90],
            [1997, 1126, 70, 70],
            [1997, 1127, 35.02, 25.49],
            [1997, 1128, 70, 70],
            [1997, 1129, 20.67, 13.88],
            [1997, 1130, 120, 90],
            [1997, 1131, 40, 50],
            [1997, 1132, 50, 60],
            [1997, 1133, 70, 70],
            [1997, 1134, 120, 90],
            [1997, 1135, 50, 60],
            [1997, 1136, 70, 70],
            [1997, 1137, 120, 90],
            [1997, 1138, 120, 90],
            [1997, 1139, 70, 70],
            [1997, 1140, 50, 60],
            [1997, 1141, 120, 90],
            [1997, 1142, 70, 70],
            [1997, 1143, 70, 70],
            [1997, 1144, 120, 90],
            [1997, 1145, 120, 90],
            [1997, 1148, 120, 90],
            [1997, 1149, 50, 60],
            [1997, 1150, 70, 70],
            [1997, 1151, 70, 70],
            [1997, 1153, 120, 90],
            [1997, 1154, 120, 90],
            [1997, 1155, 120, 90],
            [1997, 1156, 50, 60],
            [1997, 1157, 120, 90],
            [1997, 1158, 50, 60],
            [1997, 1159, 70, 70],
            [1997, 1160, 120, 90],
            [1997, 1161, 120, 90],
            [1997, 1162, 120, 90],
            [1997, 1163, 70, 70],
            [1997, 1164, 120, 90],
            [1997, 1165, 120, 90],
            [1997, 1166, 120, 90],
            [1997, 1167, 70, 70],
            [1997, 1168, 120, 90],
            [1997, 1169, 120, 90],
            [1997, 1170, 120, 90],
            [1997, 1171, 70, 70],
            [1997, 1172, 70, 70],
            [1997, 1173, 50, 60],
            [1997, 1174, 70, 70],
            [1997, 1175, 120, 90],
            [1997, 1176, 120, 90],
            [1997, 1177, 70, 70],
            [1997, 1179, 120, 90],
            [1997, 1181, 120, 90],
            [1997, 1183, 70, 70],
            [1997, 1185, 120, 90],
            [1997, 1186, 70, 70],
            [1997, 1187, 120, 90],
            [1997, 1188, 40, 50],
            [1997, 1189, 120, 90],
            [1997, 1190, 50, 60],
            [1997, 1191, 50, 60],
            [1997, 1192, 70, 70],
            [1997, 1193, 120, 90],
            [1997, 1194, 120, 90],
            [1997, 1195, 120, 90],
            [1997, 1196, 120, 90],
            [1997, 1197, 120, 90],
            [1997, 1198, 120, 90],
            [1997, 1199, 40, 50],
            [1997, 1200, 120, 90],
            [1997, 1201, 70, 70],
            [1997, 1202, 30, 45],
            [1997, 1203, 15, 25],
            [1997, 1204, 70, 70],
            [1997, 1205, 120, 90],
            [1997, 1206, 120, 90],
            [1997, 1207, 30, 45],
            [1997, 1208, 120, 90],
            [1997, 1209, 40, 50],
            [1997, 1210, 40, 50],
            [1997, 1211, 50, 60],
            [1997, 1212, 120, 90],
            [1997, 1213, 40, 50],
            [1997, 1214, 50, 60],
            [1997, 1215, 120, 90],
            [1997, 1216, 50, 60],
            [1997, 1217, 120, 90],
            [1997, 1219, 120, 90],
            [1997, 1220, 120, 90],
            [1997, 1221, 50, 60],
            [1997, 1223, 70, 70],
            [1997, 1224, 120, 90],
            [1997, 1225, 70, 70],
            [1997, 1226, 70, 70],
            [1997, 1227, 120, 90],
            [1997, 1228, 120, 90],
            [1997, 1230, 50, 60],
            [1997, 1232, 30, 45],
            [1997, 1233, 50, 60],
            [1997, 1234, 70, 70],
            [1997, 1235, 50, 60],
            [1997, 1236, 70, 70],
            [1997, 1237, 50, 60],
            [1997, 1238, 70, 70],
            [1997, 1239, 120, 90],
            [1997, 1240, 120, 90],
            [1997, 1241, 70, 70],
            [1997, 1242, 120, 90],
            [1997, 1243, 120, 90],
            [1997, 1244, 70, 70],
            [1997, 1245, 120, 90],
            [1997, 1246, 70, 70],
            [1997, 1247, 70, 70],
            [1997, 1248, 70, 70],
            [1997, 1249, 70, 70],
            [1997, 1250, 40, 50],
            [1997, 1251, 70, 70],
            [1997, 1252, 120, 90],
            [1997, 1253, 50, 60],
            [1997, 1254, 70, 70],
            [1997, 1255, 120, 90],
            [1997, 1257, 50, 60],
            [1997, 1258, 70, 70],
            [1997, 1260, 120, 90],
            [1997, 1261, 50, 60],
            [1997, 1262, 120, 90],
            [1997, 1263, 120, 90],
            [1997, 1264, 120, 90],
            [1997, 1266, 35.02, 25.49],
            [1997, 1267, 120, 90],
            [1997, 1268, 70, 70],
            [1997, 1269, 50, 60],
            [1997, 1270, 120, 90],
            [1997, 1271, 70, 70],
            [1997, 1272, 70, 70],
            [1997, 1273, 120, 90],
            [1997, 1274, 120, 90],
            [1997, 1275, 50, 60],
            [1997, 1276, 32.24, 21.39],
            [1997, 1278, 70, 70],
            [1997, 1280, 14.3, 8.12],
            [1997, 1281, 50, 60],
            [1997, 1282, 50, 60],
            [1997, 1283, 120, 90],
            [1997, 1286, 120, 90],
            [1997, 1287, 70, 70],
            [1997, 1288, 70, 70],
            [1997, 1289, 70, 70],
            [1997, 1290, 120, 90],
            [1997, 1291, 70, 70],
            [1997, 1292, 70, 70],
            [1997, 1293, 20, 25],
            [1997, 1294, 120, 90],
            [1997, 1295, 70, 70],
            [1997, 1296, 50, 60],
            [1997, 1297, 70, 70],
            [1997, 1298, 120, 90],
            [1997, 1299, 120, 90],
            [1997, 1300, 50, 60],
            [1997, 1301, 70, 70],
            [1997, 1302, 30, 45],
            [1997, 1303, 70, 70],
            [1997, 1304, 70, 70],
            [1997, 1305, 120, 90],
            [1997, 1306, 50, 60],
            [1997, 1307, 120, 90],
            [1997, 1308, 120, 90],
            [1997, 1309, 70, 70],
            [1997, 1311, 30, 45],
            [1997, 1312, 26.57, 15.77],
            [1997, 1313, 120, 90],
            [1997, 1314, 50, 60],
            [1997, 1315, 120, 90],
            [1997, 1317, 120, 90],
            [1997, 1318, 120, 90],
            [1997, 1319, 120, 90],
            [1997, 1320, 120, 90],
            [1997, 1322, 50, 60],
            [1997, 1323, 120, 90],
            [1997, 1324, 120, 90],
            [1997, 1325, 120, 90],
            [1997, 1326, 70, 70],
            [1997, 1327, 120, 90],
            [1997, 1328, 70, 70],
            [1997, 1329, 70, 70],
            [1997, 1330, 120, 90],
            [1997, 1331, 120, 90],
            [1997, 1333, 120, 90],
            [1997, 1334, 120, 90],
            [1997, 1335, 70, 70],
            [1997, 1336, 120, 90],
            [1997, 1337, 5.66, 6.03],
            [1997, 1338, 120, 90],
            [1997, 1339, 11.12, 9.1],
            [1997, 1340, 50, 60],
            [1997, 1341, 35.02, 25.49],
            [1997, 1342, 120, 90],
            [1997, 1343, 70, 70],
            [1997, 1344, 120, 90],
            [1997, 1345, 120, 90],
            [1997, 1346, 20.67, 13.88],
            [1997, 1347, 120, 90],
            [1997, 1348, 40, 50],
            [1997, 1349, 70, 70],
            [1997, 1350, 70, 70],
            [1997, 1351, 70, 70],
            [1997, 1352, 35.02, 25.49],
            [1997, 1353, 50, 60],
            [1997, 1355, 120, 90],
            [1997, 1357, 70, 70],
            [1997, 1358, 120, 90],
            [1997, 1359, 120, 90],
            [1997, 1360, 120, 90],
            [1997, 1361, 120, 90],
            [1997, 1362, 70, 70],
            [1997, 1363, 70, 70],
            [1997, 1364, 120, 90],
            [1997, 1365, 40, 50],
            [1997, 1367, 120, 90],
            [1997, 1369, 70, 70],
            [1997, 1370, 120, 90],
            [1997, 1371, 70, 70],
            [1997, 1372, 120, 90],
            [1997, 1373, 70, 70],
            [1997, 1374, 120, 90],
            [1997, 1375, 120, 90],
            [1997, 1376, 40, 50],
            [1997, 1377, 120, 90],
            [1997, 1378, 50, 60],
            [1997, 1379, 120, 90],
            [1997, 1380, 70, 70],
            [1997, 1381, 120, 90],
            [1997, 1382, 50, 60],
            [1997, 1384, 120, 90],
            [1997, 1385, 32.24, 21.39],
            [1997, 1387, 50, 60],
            [1997, 1388, 120, 90],
            [1997, 1390, 120, 90],
            [1997, 1391, 120, 90],
            [1997, 1392, 35.02, 25.49],
            [1997, 1393, 120, 90],
            [1997, 1394, 120, 90],
            [1997, 1395, 70, 70],
            [1997, 1396, 70, 70],
            [1997, 1398, 50, 60],
            [1997, 1400, 120, 90],
            [1997, 1401, 70, 70],
            [1997, 1402, 70, 70],
            [1997, 1403, 120, 90],
            [1997, 1404, 40, 50],
            [1997, 1405, 120, 90],
            [1997, 1409, 120, 90],
            [1997, 1410, 70, 70],
            [1997, 1411, 20.67, 13.88],
            [1997, 1412, 70, 70],
            [1997, 1414, 70, 70],
            [1997, 1415, 70, 70],
            [1997, 1416, 70, 70],
            [1997, 1417, 120, 90],
            [1997, 1418, 70, 70],
            [1997, 1419, 120, 90],
            [1997, 1420, 50, 60],
            [1997, 1421, 120, 90],
            [1997, 1422, 120, 90],
            [1997, 1423, 120, 90],
            [1997, 1424, 50, 60],
            [1997, 1425, 120, 90],
            [1997, 1426, 8.57, 6.77],
            [1997, 1427, 30, 45],
            [1997, 1428, 10.79, 6.72],
            [1997, 1430, 70, 70],
            [1997, 1431, 120, 90],
            [1997, 1432, 6.73, 7.01],
            [1997, 1433, 70, 70],
            [1997, 1434, 70, 70],
            [1997, 1435, 120, 90],
            [1997, 1436, 70, 70],
            [1997, 1437, 120, 90],
            [1997, 1438, 120, 90],
            [1997, 1439, 120, 90],
            [1997, 1440, 120, 90],
            [1997, 1441, 120, 90],
            [1997, 1442, 120, 90],
            [1997, 1443, 50, 60],
            [1997, 1444, 120, 90],
            [1997, 1445, 120, 90],
            [1997, 1447, 120, 90],
            [1997, 1448, 70, 70],
            [1997, 1449, 120, 90],
            [1997, 1450, 120, 90],
            [1997, 1451, 35.02, 25.49],
            [1997, 1452, 70, 70],
            [1997, 1453, 120, 90],
            [1997, 1454, 120, 90],
            [1997, 1455, 120, 90],
            [1997, 1456, 70, 70],
            [1997, 1457, 120, 90],
            [1997, 1458, 40, 50],
            [1997, 1459, 120, 90],
            [1997, 1460, 120, 90],
            [1997, 1461, 6.14, 6.98],
            [1997, 1463, 70, 70],
            [1997, 1464, 50, 60],
            [1997, 1465, 70, 70],
            [1997, 1466, 50, 60],
            [1997, 1467, 70, 70],
            [1997, 1468, 120, 90],
            [1997, 1469, 120, 90],
            [1997, 1470, 30, 45],
            [1997, 1471, 120, 90],
            [1997, 1472, 120, 90],
            [1997, 1473, 50, 60],
            [1997, 1474, 70, 70],
            [1997, 1475, 70, 70],
            [1997, 1476, 70, 70],
            [1997, 1477, 120, 90],
            [1997, 1478, 17.41, 11.68],
            [1997, 1479, 120, 90],
            [1997, 1481, 50, 60],
            [1997, 1482, 70, 70],
            [1997, 1483, 70, 70],
            [1997, 1484, 70, 70],
            [1997, 1485, 120, 90],
            [1997, 1486, 120, 90],
            [1997, 1487, 120, 90],
            [1997, 1488, 120, 90],
            [1997, 1489, 120, 90],
            [1997, 1490, 120, 90],
            [1997, 1491, 13.55, 10.7],
            [1997, 1492, 70, 70],
            [1997, 1493, 120, 90],
            [1997, 1495, 120, 90],
            [1997, 1496, 50, 60],
            [1997, 1497, 120, 90],
            [1997, 1498, 30, 45],
            [1997, 1499, 30, 45],
            [1997, 1500, 120, 90],
            [1997, 1502, 120, 90],
            [1997, 1503, 120, 90],
            [1997, 1505, 120, 90],
            [1997, 1506, 120, 90],
            [1997, 1507, 70, 70],
            [1997, 1508, 120, 90],
            [1997, 1509, 120, 90],
            [1997, 1510, 120, 90],
            [1997, 1511, 50, 60],
            [1997, 1512, 50, 60],
            [1997, 1513, 32.24, 21.39],
            [1997, 1514, 70, 70],
            [1997, 1515, 30, 45],
            [1997, 1516, 70, 70],
            [1997, 1517, 120, 90],
            [1997, 1518, 120, 90],
            [1997, 1519, 120, 90],
            [1997, 1520, 70, 70],
            [1997, 1521, 120, 90],
            [1997, 1522, 120, 90],
            [1997, 1523, 120, 90],
            [1997, 1524, 120, 90],
            [1997, 1525, 40, 50],
            [1997, 1526, 50, 60],
            [1997, 1527, 120, 90],
            [1997, 1528, 70, 70],
            [1997, 1529, 40, 50],
            [1997, 1530, 120, 90],
            [1997, 1531, 120, 90],
            [1997, 1533, 120, 90],
            [1997, 1535, 70, 70],
            [1997, 1536, 70, 70],
            [1997, 1537, 70, 70],
            [1997, 1538, 120, 90],
            [1997, 1539, 40, 50],
            [1997, 1540, 50, 60],
            [1997, 1541, 70, 70],
            [1997, 1542, 50, 60],
            [1997, 1543, 70, 70],
            [1997, 1544, 120, 90],
            [1997, 1545, 120, 90],
            [1997, 1546, 70, 70],
            [1997, 1547, 70, 70],
            [1997, 1548, 120, 90],
            [1997, 1549, 70, 70],
            [1997, 1550, 120, 90],
            [1997, 1551, 120, 90],
            [1997, 1552, 40, 50],
            [1997, 1553, 120, 90],
            [1997, 1554, 70, 70],
            [1997, 1555, 40, 50],
            [1997, 1556, 70, 70],
            [1997, 1557, 120, 90],
            [1997, 1558, 50, 60],
            [1997, 1559, 50, 60],
            [1997, 1560, 70, 70],
            [1997, 1561, 120, 90],
            [1997, 1562, 120, 90],
            [1997, 1563, 30, 45],
            [1997, 1565, 120, 90],
            [1997, 1567, 120, 90],
            [1997, 1568, 70, 70],
            [1997, 1569, 120, 90],
            [1997, 1571, 120, 90],
            [1997, 1572, 120, 90],
            [1997, 1573, 70, 70],
            [1997, 1574, 50, 60],
            [1997, 1575, 120, 90],
            [1997, 1576, 50, 60],
            [1997, 1577, 50, 60],
            [1997, 1578, 120, 90],
            [1997, 1579, 120, 90],
            [1997, 1580, 50, 60],
            [1997, 1581, 19.75, 12.12],
            [1997, 1582, 70, 70],
            [1997, 1583, 120, 90],
            [1997, 1584, 120, 90],
            [1997, 1585, 70, 70],
            [1997, 1586, 120, 90],
            [1997, 1587, 70, 70],
            [1997, 1588, 40, 50],
            [1997, 1589, 70, 70],
            [1997, 1590, 70, 70],
            [1997, 1591, 70, 70],
            [1997, 1592, 32.24, 21.39],
            [1997, 1593, 30, 45],
            [1997, 1595, 70, 70],
            [1997, 1596, 120, 90],
            [1997, 1597, 70, 70],
            [1997, 1599, 120, 90],
            [1997, 1600, 120, 90],
            [1997, 1601, 70, 70],
            [1997, 1602, 120, 90],
            [1997, 1603, 40, 50],
            [1997, 1605, 120, 90],
            [1997, 1606, 120, 90],
            [1997, 1607, 70, 70],
            [1997, 1608, 120, 90],
            [1997, 1609, 120, 90],
            [1997, 1610, 70, 70],
            [1997, 1611, 120, 90],
            [1997, 1612, 120, 90],
            [1997, 1613, 120, 90],
            [1997, 1614, 70, 70],
            [1997, 1615, 120, 90],
            [1997, 1616, 120, 90],
            [1997, 1617, 120, 90],
            [1997, 1619, 120, 90],
            [1997, 1620, 120, 90],
            [1997, 1621, 120, 90],
            [1997, 1622, 70, 70],
            [1997, 1623, 50, 60],
            [1997, 1624, 35.02, 25.49],
            [1997, 1625, 70, 70],
            [1997, 1626, 70, 70],
            [1997, 1627, 70, 70],
            [1997, 1628, 50, 60],
            [1997, 1629, 40, 50],
            [1997, 1630, 70, 70],
            [1997, 1631, 70, 70],
            [1997, 1633, 120, 90],
            [1997, 1634, 70, 70],
            [1997, 1635, 70, 70],
            [1997, 1636, 120, 90],
            [1997, 1637, 120, 90],
            [1997, 1638, 70, 70],
            [1997, 1639, 70, 70],
            [1997, 1640, 70, 70],
            [1997, 1641, 70, 70],
            [1997, 1642, 120, 90],
            [1997, 1644, 50, 60],
            [1997, 1645, 70, 70],
            [1997, 1647, 70, 70],
            [1997, 1648, 120, 90],
            [1997, 1649, 120, 90],
            [1997, 1650, 70, 70],
            [1997, 1651, 120, 90],
            [1997, 1652, 70, 70],
            [1997, 1653, 120, 90],
            [1997, 1654, 70, 70],
            [1997, 1655, 120, 90],
            [1997, 1657, 70, 70],
            [1997, 1658, 120, 90],
            [1997, 1659, 70, 70],
            [1997, 1660, 120, 90],
            [1997, 1661, 32.24, 21.39],
            [1997, 1662, 70, 70],
            [1997, 1663, 70, 70],
            [1997, 1664, 70, 70],
            [1997, 1665, 50, 60],
            [1997, 1666, 6.17, 5.14],
            [1997, 1667, 120, 90],
            [1997, 1668, 70, 70],
            [1997, 1669, 120, 90],
            [1997, 1670, 120, 90],
            [1997, 1671, 120, 90],
            [1997, 1672, 120, 90],
            [1997, 1673, 70, 70],
            [1997, 1674, 70, 70],
            [1997, 1675, 11.86, 16.02],
            [1997, 1676, 70, 70],
            [1997, 1677, 70, 70],
            [1997, 1678, 120, 90],
            [1997, 1679, 40, 50],
            [1997, 1680, 120, 90],
            [1997, 1681, 120, 90],
            [1997, 1682, 120, 90],
            [1997, 1683, 120, 90],
            [1997, 1684, 120, 90],
            [1997, 1685, 50, 60],
            [1997, 1687, 120, 90],
            [1997, 1688, 30, 45],
            [1997, 1689, 120, 90],
            [1997, 1690, 120, 90],
            [1997, 1691, 120, 90],
            [1997, 1692, 120, 90],
            [1997, 1693, 120, 90],
            [1997, 1694, 120, 90],
            [1997, 1695, 120, 90],
            [1997, 1696, 120, 90],
            [1997, 1697, 70, 70],
            [1997, 1698, 120, 90],
            [1997, 1699, 70, 70],
            [1997, 1700, 120, 90],
            [1997, 1701, 120, 90],
            [1997, 1702, 70, 70],
            [1997, 1704, 50, 60],
            [1997, 1705, 70, 70],
            [1997, 1706, 120, 90],
            [1997, 1707, 120, 90],
            [1997, 1708, 120, 90],
            [1997, 1709, 30, 45],
            [1997, 1710, 50, 60],
            [1997, 1711, 70, 70],
            [1997, 1712, 120, 90],
            [1997, 1713, 50, 60],
            [1997, 1714, 120, 90],
            [1997, 1715, 120, 90],
            [1997, 1716, 70, 70],
            [1997, 1717, 70, 70],
            [1997, 1719, 70, 70],
            [1997, 1720, 4.58, 3.57],
            [1997, 1721, 120, 90],
            [1997, 1722, 120, 90],
            [1997, 1723, 70, 70],
            [1997, 1724, 120, 90],
            [1997, 1725, 70, 70],
            [1997, 1726, 120, 90],
            [1997, 1727, 120, 90],
            [1997, 1728, 120, 90],
            [1997, 1730, 70, 70],
            [1997, 1732, 120, 90],
            [1997, 1735, 120, 90],
            [1997, 1736, 120, 90],
            [1997, 1737, 70, 70],
            [1997, 1738, 120, 90],
            [1997, 1739, 32.24, 21.39],
            [1997, 1740, 50, 60],
            [1997, 1741, 70, 70],
            [1997, 1742, 120, 90],
            [1997, 1743, 120, 90],
            [1997, 1744, 120, 90],
            [1997, 1746, 70, 70],
            [1997, 1748, 70, 70],
            [1997, 1749, 50, 60],
            [1997, 1750, 70, 70],
            [1997, 1752, 120, 90],
            [1997, 1754, 120, 90],
            [1997, 1755, 50, 60],
            [1997, 1756, 120, 90],
            [1997, 1757, 120, 90],
            [1997, 1758, 32.24, 21.39],
            [1997, 1759, 120, 90],
            [1997, 1760, 70, 70],
            [1997, 1762, 120, 90],
            [1997, 1763, 120, 90],
            [1997, 1764, 70, 70],
            [1997, 1765, 120, 90],
            [1997, 1766, 120, 90],
            [1997, 1767, 120, 90],
            [1997, 1769, 70, 70],
            [1997, 1770, 70, 70],
            [1997, 1771, 120, 90],
            [1997, 1772, 40, 50],
            [1997, 1773, 50, 60],
            [1997, 1774, 70, 70],
            [1997, 1775, 70, 70],
            [1997, 1776, 120, 90],
            [1997, 1777, 120, 90],
            [1997, 1778, 120, 90],
            [1997, 1779, 70, 70],
            [1997, 1780, 70, 70],
            [1997, 1781, 120, 90],
            [1997, 1782, 120, 90],
            [1997, 1783, 120, 90],
            [1997, 1784, 70, 70],
            [1997, 1785, 120, 90],
            [1997, 1786, 120, 90],
            [1997, 1787, 120, 90],
            [1997, 1788, 120, 90],
            [1997, 1789, 120, 90],
            [1997, 1790, 120, 90],
            [1997, 1791, 120, 90],
            [1997, 1792, 120, 90],
            [1997, 1793, 70, 70],
            [1997, 1794, 70, 70],
            [1997, 1795, 9.04, 6.4],
            [1997, 1796, 50, 60],
            [1997, 1797, 70, 70],
            [1997, 1798, 70, 70],
            [1997, 1801, 70, 70],
            [1997, 1802, 120, 90],
            [1997, 1803, 120, 90],
            [1997, 1804, 120, 90],
            [1997, 1805, 50, 60],
            [1997, 1806, 120, 90],
            [1997, 1807, 70, 70],
            [1997, 1808, 70, 70],
            [1997, 1809, 120, 90],
            [1997, 1810, 120, 90],
            [1997, 1811, 120, 90],
            [1997, 1812, 120, 90],
            [1997, 1813, 70, 70],
            [1997, 1814, 40, 50],
            [1997, 1815, 17.45, 9.13],
            [1997, 1816, 120, 90],
            [1997, 1817, 70, 70],
            [1997, 1818, 120, 90],
            [1997, 1819, 120, 90],
            [1997, 1820, 120, 90],
            [1997, 1821, 40, 50],
            [1997, 1822, 70, 70],
            [1997, 1823, 120, 90],
            [1997, 1824, 70, 70],
            [1997, 1825, 70, 70],
            [1997, 1826, 120, 90],
            [1997, 1827, 70, 70],
            [1997, 1829, 120, 90],
            [1997, 1830, 50, 60],
            [1997, 1831, 50, 60],
            [1997, 1832, 70, 70],
            [1997, 1833, 120, 90],
            [1997, 1834, 120, 90],
            [1997, 1837, 120, 90],
            [1997, 1839, 120, 90],
            [1997, 1840, 120, 90],
            [1997, 1841, 70, 70],
            [1997, 1842, 120, 90],
            [1997, 1844, 30, 45],
            [1997, 1845, 40, 50],
            [1997, 1846, 120, 90],
            [1997, 1847, 50, 60],
            [1997, 1848, 70, 70],
            [1997, 1849, 120, 90],
            [1997, 1850, 8.32, 6.64],
            [1997, 1851, 120, 90],
            [1997, 1852, 70, 70],
            [1997, 1853, 120, 90],
            [1997, 1854, 120, 90],
            [1997, 1855, 120, 90],
            [1997, 1856, 30, 45],
            [1997, 1857, 70, 70],
            [1997, 1859, 120, 90],
            [1997, 1860, 120, 90],
            [1997, 1861, 120, 90],
            [1997, 1863, 18.35, 13.66],
            [1997, 1864, 120, 90],
            [1997, 1865, 120, 90],
            [1997, 1866, 70, 70],
            [1997, 1868, 35.02, 25.49],
            [1997, 1869, 40, 50],
            [1997, 1870, 32.24, 21.39],
            [1997, 1871, 120, 90],
            [1997, 1872, 50, 60],
            [1997, 1873, 70, 70],
            [1997, 1874, 70, 70],
            [1997, 1875, 120, 90],
            [1997, 1876, 70, 70],
            [1997, 1877, 120, 90],
            [1997, 1878, 120, 90],
            [1997, 1879, 120, 90],
            [1997, 1881, 50, 60],
            [1997, 1882, 70, 70],
            [1997, 1883, 120, 90],
            [1997, 1884, 50, 60],
            [1997, 1885, 70, 70],
            [1997, 1886, 120, 90],
            [1997, 1887, 70, 70],
            [1997, 1888, 120, 90],
            [1997, 1889, 120, 90],
            [1997, 1890, 120, 90],
            [1997, 1891, 50, 60],
            [1997, 1892, 70, 70],
            [1997, 1893, 120, 90],
            [1997, 1894, 50, 60],
            [1997, 1895, 70, 70],
            [1997, 1896, 120, 90],
            [1997, 1898, 12.47, 7.24],
            [1997, 1899, 70, 70],
            [1997, 1900, 30, 45],
            [1997, 1901, 120, 90],
            [1997, 1902, 120, 90],
            [1997, 1903, 70, 70],
            [1997, 1904, 120, 90],
            [1997, 1905, 120, 90],
            [1997, 1906, 20.9, 12.43],
            [1997, 1907, 70, 70],
            [1997, 1909, 120, 90],
            [1997, 1910, 120, 90],
            [1997, 1911, 70, 70],
            [1997, 1912, 70, 70],
            [1997, 1913, 120, 90],
            [1997, 1914, 120, 90],
            [1997, 1915, 120, 90],
            [1997, 1916, 120, 90],
            [1997, 1917, 120, 90],
            [1997, 1918, 120, 90],
            [1997, 1919, 120, 90],
            [1997, 1920, 70, 70],
            [1997, 1921, 30, 45],
            [1997, 1922, 120, 90],
            [1997, 1923, 40, 50],
            [1997, 1924, 120, 90],
            [1997, 1925, 120, 90],
            [1997, 1926, 120, 90],
            [1997, 1928, 120, 90],
            [1997, 1929, 6.5, 4.93],
            [1997, 1930, 10.76, 8.15],
            [1997, 1933, 70, 70],
            [1997, 1934, 120, 90],
            [1997, 1935, 120, 90],
            [1997, 1936, 70, 70],
            [1997, 1937, 70, 70],
            [1997, 1938, 120, 90],
            [1997, 1939, 120, 90],
            [1997, 1940, 120, 90],
            [1997, 1941, 120, 90],
            [1997, 1942, 120, 90],
            [1997, 1944, 120, 90],
            [1997, 1945, 120, 90],
            [1997, 1946, 70, 70],
            [1997, 1947, 120, 90],
            [1997, 1948, 120, 90],
            [1997, 1949, 120, 90],
            [1997, 1950, 120, 90],
            [1997, 1951, 50, 60],
            [1997, 1952, 120, 90],
            [1997, 1953, 120, 90],
            [1997, 1954, 120, 90],
            [1997, 1955, 70, 70],
            [1997, 1956, 40, 50],
            [1997, 1957, 70, 70],
            [1997, 1959, 120, 90],
            [1997, 1961, 120, 90],
            [1997, 1962, 40, 50],
            [1997, 1963, 7.89, 5.56],
            [1997, 1964, 50, 60],
            [1997, 1965, 50, 60],
            [1997, 1966, 120, 90],
            [1997, 1967, 32.24, 21.39],
            [1997, 1969, 70, 70],
            [1997, 1971, 120, 90],
            [1997, 1972, 11.39, 7.39],
            [1997, 1973, 70, 70],
            [1997, 1974, 70, 70],
            [1997, 1975, 120, 90],
            [1997, 1976, 14.59, 10.01],
            [1997, 1977, 70, 70],
            [1997, 1978, 120, 90],
            [1997, 1979, 50, 60],
            [1997, 1980, 120, 90],
            [1997, 1981, 70, 70],
            [1997, 1982, 70, 70],
            [1997, 1983, 120, 90],
            [1997, 1984, 120, 90],
            [1997, 1985, 70, 70],
            [1997, 1986, 120, 90],
            [1997, 1987, 120, 90],
            [1997, 1988, 70, 70],
            [1997, 1989, 50, 60],
            [1997, 1990, 70, 70],
            [1997, 1992, 50, 60],
            [1997, 1994, 120, 90],
            [1997, 1995, 70, 70],
            [1997, 1996, 120, 90],
            [1997, 1997, 70, 70],
            [1997, 1998, 8.45, 8.42],
            [1997, 1999, 120, 90],
            [1997, 2000, 70, 70],
            [1997, 2001, 120, 90],
            [1997, 2002, 50, 60],
            [1997, 2003, 120, 90],
            [1997, 2005, 50, 60],
            [1997, 2006, 70, 70],
            [1997, 2007, 120, 90],
            [1997, 2008, 70, 70],
            [1997, 2009, 120, 90],
            [1997, 2010, 120, 90],
            [1997, 2011, 120, 90],
            [1997, 2012, 70, 70],
            [1997, 2014, 120, 90],
            [1997, 2015, 50, 60],
            [1997, 2016, 70, 70],
            [1997, 2017, 40, 50],
            [1997, 2018, 120, 90],
            [1997, 2019, 120, 90],
            [1997, 2020, 32.24, 21.39],
            [1997, 2021, 120, 90],
            [1997, 2022, 120, 90],
            [1997, 2023, 50, 60],
            [1997, 2024, 50, 60],
            [1997, 2025, 120, 90],
            [1997, 2026, 120, 90],
            [1997, 2027, 120, 90],
            [1997, 2028, 120, 90],
            [1997, 2029, 50, 60],
            [1997, 2030, 50, 60],
            [1997, 2031, 6.44, 5.98],
            [1997, 2032, 120, 90],
            [1997, 2033, 70, 70],
            [1997, 2034, 120, 90],
            [1997, 2035, 70, 70],
            [1997, 2036, 70, 70],
            [1997, 2037, 120, 90],
            [1997, 2038, 120, 90],
            [1997, 2040, 120, 90],
            [1997, 2041, 120, 90],
            [1997, 2042, 120, 90],
            [1997, 2043, 70, 70],
            [1997, 2044, 120, 90],
            [1997, 2045, 120, 90],
            [1997, 2046, 50, 60],
            [1997, 2048, 70, 70],
            [1997, 2049, 70, 70],
            [1997, 2050, 70, 70],
            [1997, 2051, 120, 90],
            [1997, 2052, 120, 90],
            [1997, 2053, 70, 70],
            [1997, 2054, 40, 50],
            [1997, 2055, 70, 70],
            [1997, 2056, 50, 60],
            [1997, 2057, 120, 90],
            [1997, 2059, 14.88, 8.19],
            [1997, 2060, 70, 70],
            [1997, 2061, 70, 70],
            [1997, 2062, 120, 90],
            [1997, 2063, 70, 70],
            [1997, 2064, 70, 70],
            [1997, 2066, 120, 90],
            [1997, 2067, 70, 70],
            [1997, 2068, 70, 70],
            [1997, 2069, 120, 90],
            [1997, 2071, 120, 90],
            [1997, 2072, 120, 90],
            [1997, 2073, 120, 90],
            [1997, 2074, 70, 70],
            [1997, 2075, 70, 70],
            [1997, 2076, 70, 70],
            [1997, 2077, 120, 90],
            [1997, 2078, 50, 60],
            [1997, 2079, 120, 90],
            [1997, 2080, 120, 90],
            [1997, 2081, 120, 90],
            [1997, 2082, 120, 90],
            [1997, 2083, 120, 90],
            [1997, 2084, 120, 90],
            [1997, 2086, 40, 50],
            [1997, 2087, 120, 90],
            [1997, 2089, 0, 0],
            [1997, 2090, 120, 90],
            [1997, 2091, 120, 90],
            [1997, 2092, 120, 90],
            [1997, 2095, 120, 90],
            [1997, 2096, 120, 90],
            [1997, 2097, 50, 60],
            [1997, 2098, 40, 50],
            [1997, 2099, 120, 90],
            [1997, 2100, 70, 70],
            [1997, 2101, 70, 70],
            [1997, 2102, 120, 90],
            [1997, 2103, 12.45, 12.74],
            [1997, 2104, 120, 90],
            [1997, 2105, 120, 90],
            [1997, 2106, 50, 60],
            [1997, 2107, 70, 70],
            [1997, 2108, 120, 90],
            [1997, 2109, 120, 90],
            [1997, 2110, 40, 50],
            [1997, 2111, 70, 70],
            [1997, 2112, 70, 70],
            [1997, 2113, 120, 90],
            [1997, 2114, 120, 90],
            [1997, 2115, 70, 70],
            [1997, 2116, 70, 70],
            [1997, 2118, 120, 90],
            [1997, 2119, 16.05, 9.74],
            [1997, 2121, 120, 90],
            [1997, 2122, 120, 90],
            [1997, 2123, 70, 70],
            [1997, 2124, 70, 70],
            [1997, 2125, 120, 90],
            [1997, 2126, 50, 60],
            [1997, 2127, 50, 60],
            [1997, 2128, 70, 70],
            [1997, 2129, 120, 90],
            [1997, 2130, 120, 90],
            [1997, 2131, 120, 90],
            [1997, 2133, 70, 70],
            [1997, 2134, 120, 90],
            [1997, 2135, 50, 60],
            [1997, 2136, 120, 90],
            [1997, 2137, 70, 70],
            [1997, 2138, 70, 70],
            [1997, 2139, 120, 90],
            [1997, 2140, 120, 90],
            [1997, 2141, 120, 90],
            [1997, 2142, 70, 70],
            [1997, 2143, 120, 90],
            [1997, 2144, 120, 90],
            [1997, 2146, 70, 70],
            [1997, 2147, 120, 90],
            [1997, 2148, 70, 70],
            [1997, 2149, 120, 90],
            [1997, 2150, 120, 90],
            [1997, 2152, 120, 90],
            [1997, 2154, 120, 90],
            [1997, 2155, 120, 90],
            [1997, 2156, 70, 70],
            [1997, 2157, 120, 90],
            [1997, 2158, 50, 60],
            [1997, 2159, 120, 90],
            [1997, 2160, 120, 90],
            [1997, 2161, 70, 70],
            [1997, 2162, 120, 90],
            [1997, 2163, 120, 90],
            [1997, 2164, 50, 60],
            [1997, 2165, 50, 60],
            [1997, 2166, 35.02, 25.49],
            [1997, 2169, 120, 90],
            [1997, 2170, 120, 90],
            [1997, 2171, 120, 90],
            [1997, 2172, 120, 90],
            [1997, 2174, 70, 70],
            [1997, 2175, 120, 90],
            [1997, 2178, 70, 70],
            [1997, 2179, 50, 60],
            [1997, 2180, 70, 70],
            [1997, 2181, 70, 70],
            [1997, 2182, 120, 90],
            [1997, 2183, 40, 50],
            [1997, 2184, 40, 50],
            [1997, 2185, 70, 70],
            [1997, 2186, 120, 90],
            [1997, 2187, 120, 90],
            [1997, 2188, 120, 90],
            [1997, 2189, 70, 70],
            [1997, 2190, 70, 70],
            [1997, 2191, 120, 90],
            [1997, 2192, 120, 90],
            [1997, 2193, 70, 70],
            [1997, 2194, 120, 90],
            [1997, 2195, 50, 60],
            [1997, 2196, 70, 70],
            [1997, 2197, 120, 90],
            [1997, 2198, 40, 50],
            [1997, 2199, 120, 90],
            [1997, 2200, 70, 70],
            [1997, 2201, 120, 90],
            [1997, 2202, 120, 90],
            [1997, 2203, 12.12, 8.84],
            [1997, 2204, 14.98, 8.4],
            [1997, 2205, 120, 90],
            [1997, 2206, 50, 60],
            [1997, 2207, 70, 70],
            [1997, 2208, 120, 90],
            [1997, 2210, 120, 90],
            [1997, 2211, 50, 60],
            [1997, 2212, 70, 70],
            [1997, 2213, 50, 60],
            [1997, 2214, 20, 25],
            [1997, 2215, 70, 70],
            [1997, 2216, 120, 90],
            [1997, 2217, 120, 90],
            [1997, 2219, 120, 90],
            [1997, 2220, 120, 90],
            [1997, 2221, 120, 90],
            [1997, 2223, 40, 50],
            [1997, 2224, 70, 70],
            [1997, 2225, 40, 50],
            [1997, 2226, 120, 90],
            [1997, 2227, 50, 60],
            [1997, 2228, 50, 60],
            [1997, 2229, 120, 90],
            [1997, 2230, 120, 90],
            [1997, 2231, 120, 90],
            [1997, 2232, 50, 60],
            [1997, 2234, 70, 70],
            [1997, 2235, 50, 60],
            [1997, 2236, 120, 90],
            [1997, 2237, 120, 90],
            [1997, 2238, 70, 70],
            [1997, 2239, 120, 90],
            [1997, 2240, 120, 90],
            [1997, 2241, 14.63, 9.52],
            [1997, 2242, 70, 70],
            [1997, 2243, 120, 90],
            [1997, 2244, 120, 90],
            [1997, 2245, 70, 70],
            [1997, 2246, 50, 60],
            [1997, 2247, 120, 90],
            [1997, 2248, 40, 50],
            [1997, 2249, 120, 90],
            [1997, 2250, 50, 60],
            [1997, 2251, 120, 90],
            [1997, 2252, 70, 70],
            [1997, 2253, 14.51, 10.23],
            [1997, 2254, 70, 70],
            [1997, 2255, 70, 70],
            [1997, 2256, 120, 90],
            [1997, 2258, 50, 60],
            [1997, 2259, 15, 20],
            [1997, 2260, 70, 70],
            [1997, 2262, 120, 90],
            [1997, 2263, 70, 70],
            [1997, 2264, 120, 90],
            [1997, 2265, 120, 90],
            [1997, 2267, 10.9, 7.43],
            [1997, 2268, 120, 90],
            [1997, 2269, 70, 70],
            [1997, 2270, 120, 90],
            [1997, 2271, 9.23, 6.76],
            [1997, 2272, 50, 60],
            [1997, 2273, 70, 70],
            [1997, 2274, 70, 70],
            [1997, 2275, 120, 90],
            [1997, 2276, 120, 90],
            [1997, 2277, 50, 60],
            [1997, 2278, 40, 50],
            [1997, 2279, 120, 90],
            [1997, 2280, 8.57, 5.83],
            [1997, 2281, 120, 90],
            [1997, 2282, 70, 70],
            [1997, 2283, 120, 90],
            [1997, 2284, 70, 70],
            [1997, 2285, 40, 50],
            [1997, 2286, 70, 70],
            [1997, 2288, 70, 70],
            [1997, 2289, 120, 90],
            [1997, 2290, 120, 90],
            [1997, 2291, 120, 90],
            [1997, 2292, 120, 90],
            [1997, 2293, 120, 90],
            [1997, 2294, 50, 60],
            [1997, 2295, 120, 90],
            [1997, 2296, 70, 70],
            [1997, 2297, 120, 90],
            [1997, 2298, 120, 90],
            [1997, 2300, 50, 60],
            [1997, 2301, 70, 70],
            [1997, 2302, 120, 90],
            [1997, 2303, 120, 90],
            [1997, 2304, 70, 70],
            [1997, 2305, 120, 90],
            [1997, 2306, 120, 90],
            [1997, 2307, 70, 70],
            [1997, 2311, 70, 70],
            [1997, 2312, 120, 90],
            [1997, 2313, 40, 50],
            [1997, 2314, 120, 90],
            [1997, 2316, 120, 90],
            [1997, 2317, 120, 90],
            [1997, 2319, 50, 60],
            [1997, 2321, 120, 90],
            [1997, 2323, 70, 70],
            [1997, 2324, 120, 90],
            [1997, 2325, 120, 90],
            [1997, 2326, 120, 90],
            [1997, 2327, 120, 90],
            [1997, 2328, 120, 90],
            [1997, 2329, 70, 70],
            [1997, 2330, 120, 90],
            [1997, 2331, 40, 50],
            [1997, 2332, 120, 90],
            [1997, 2333, 70, 70],
            [1997, 2335, 120, 90],
            [1997, 2336, 120, 90],
            [1997, 2337, 120, 90],
            [1997, 2338, 32.24, 21.39],
            [1997, 2339, 120, 90],
            [1997, 2340, 120, 90],
            [1997, 2341, 70, 70],
            [1997, 2342, 70, 70],
            [1997, 2343, 70, 70],
            [1997, 2344, 120, 90],
            [1997, 2345, 40, 50],
            [1997, 2346, 70, 70],
            [1997, 2347, 120, 90],
            [1997, 2348, 70, 70],
            [1997, 2349, 70, 70],
            [1997, 2350, 120, 90],
            [1997, 2352, 50, 60],
            [1997, 2353, 120, 90],
            [1997, 2354, 40, 50],
            [1997, 2355, 120, 90],
            [1997, 2356, 120, 90],
            [1997, 2357, 120, 90],
            [1997, 2358, 50, 60],
            [1997, 2359, 50, 60],
            [1997, 2360, 120, 90],
            [1997, 2361, 50, 60],
            [1997, 2362, 70, 70],
            [1997, 2363, 70, 70],
            [1997, 2364, 32.24, 21.39],
            [1997, 2365, 120, 90],
            [1997, 2366, 50, 60],
            [1997, 2367, 120, 90],
            [1997, 2368, 70, 70],
            [1997, 2369, 70, 70],
            [1997, 2371, 70, 70],
            [1997, 2372, 30, 45],
            [1997, 2373, 120, 90],
            [1997, 2374, 14.36, 11.08],
            [1997, 2375, 120, 90],
            [1997, 2376, 120, 90],
            [1997, 2379, 120, 90],
            [1997, 2380, 30, 45],
            [1997, 2381, 40, 50],
            [1997, 2382, 120, 90],
            [1997, 2383, 120, 90],
            [1997, 2384, 40, 50],
            [1997, 2385, 70, 70],
            [1997, 2387, 40, 50],
            [1997, 2388, 120, 90],
            [1997, 2389, 70, 70],
            [1997, 2390, 120, 90],
            [1997, 2391, 70, 70],
            [1997, 2393, 70, 70],
            [1997, 2394, 120, 90],
            [1997, 2395, 120, 90],
            [1997, 2396, 120, 90],
            [1997, 2397, 120, 90],
            [1997, 2398, 120, 90],
            [1997, 2399, 120, 90],
            [1997, 2400, 120, 90],
            [1997, 2401, 9.42, 9.69],
            [1997, 2402, 70, 70],
            [1997, 2403, 120, 90],
            [1997, 2404, 120, 90],
            [1997, 2405, 70, 70],
            [1997, 2406, 120, 90],
            [1997, 2407, 120, 90],
            [1997, 2408, 50, 60],
            [1997, 2409, 50, 60],
            [1997, 2410, 70, 70],
            [1997, 2411, 9.59, 8.49],
            [1997, 2412, 6.63, 7.08],
            [1997, 2413, 120, 90],
            [1997, 2414, 8.64, 7.09],
            [1997, 2416, 120, 90],
            [1997, 2417, 120, 90],
            [1997, 2418, 120, 90],
            [1997, 2420, 120, 90],
            [1997, 2421, 120, 90],
            [1997, 2422, 120, 90],
            [1997, 2423, 70, 70],
            [1997, 2424, 120, 90],
            [1997, 2425, 70, 70],
            [1997, 2426, 120, 90],
            [1997, 2428, 120, 90],
            [1997, 2429, 70, 70],
            [1997, 2430, 120, 90],
            [1997, 2431, 30, 45],
            [1997, 2432, 120, 90],
            [1997, 2433, 70, 70],
            [1997, 2434, 120, 90],
            [1997, 2435, 40, 50],
            [1997, 2436, 70, 70],
            [1997, 2437, 16.17, 13.35],
            [1997, 2438, 120, 90],
            [1997, 2439, 70, 70],
            [1997, 2440, 5.64, 5.78],
            [1997, 2441, 120, 90],
            [1997, 2442, 120, 90],
            [1997, 2443, 70, 70],
            [1997, 2444, 120, 90],
            [1997, 2445, 120, 90],
            [1997, 2447, 120, 90],
            [1997, 2448, 120, 90],
            [1997, 2449, 35.02, 25.49],
            [1997, 2450, 120, 90],
            [1997, 2452, 120, 90],
            [1997, 2454, 120, 90],
            [1997, 2455, 70, 70],
            [1997, 2456, 70, 70],
            [1997, 2458, 50, 60],
            [1997, 2459, 70, 70],
            [1997, 2460, 70, 70],
            [1997, 2461, 120, 90],
            [1997, 2462, 120, 90],
            [1997, 2463, 120, 90],
            [1997, 2464, 120, 90],
            [1997, 2465, 120, 90],
            [1997, 2466, 120, 90],
            [1997, 2467, 70, 70],
            [1997, 2468, 40, 50],
            [1997, 2469, 30, 45],
            [1997, 2470, 120, 90],
            [1997, 2471, 120, 90],
            [1997, 2472, 120, 90],
            [1997, 2473, 120, 90],
            [1997, 2474, 120, 90],
            [1997, 2475, 70, 70],
            [1997, 2476, 120, 90],
            [1997, 2477, 70, 70],
            [1997, 2478, 120, 90],
            [1997, 2479, 120, 90],
            [1997, 2481, 50, 60],
            [1997, 2482, 120, 90],
            [1997, 2483, 120, 90],
            [1997, 2484, 120, 90],
            [1997, 2485, 50, 60],
            [1997, 2486, 70, 70],
            [1997, 2487, 70, 70],
            [1997, 2488, 70, 70],
            [1997, 2489, 30, 45],
            [1997, 2490, 70, 70],
            [1997, 2491, 120, 90],
            [1997, 2492, 50, 60],
            [1997, 2493, 120, 90],
            [1997, 2494, 70, 70],
            [1997, 2495, 40, 50],
            [1997, 2496, 120, 90],
            [1997, 2497, 120, 90],
            [1997, 2498, 120, 90],
            [1997, 2499, 17.64, 11.45],
            [1997, 2500, 40, 50],
            [1997, 2501, 70, 70],
            [1997, 2502, 50, 60],
            [1997, 2504, 120, 90],
            [1997, 2505, 70, 70],
            [1997, 2506, 120, 90],
            [1997, 2507, 120, 90],
            [1997, 2508, 70, 70],
            [1997, 2509, 70, 70],
            [1997, 2510, 70, 70],
            [1997, 2511, 35.02, 25.49],
            [1997, 2512, 120, 90],
            [1997, 2513, 120, 90],
            [1997, 2515, 50, 60],
            [1997, 2516, 120, 90],
            [1997, 2517, 120, 90],
            [1997, 2518, 120, 90],
            [1997, 2519, 35.02, 25.49],
            [1997, 2520, 70, 70],
            [1997, 2521, 50, 60],
            [1997, 2522, 120, 90],
            [1997, 2523, 120, 90],
            [1997, 2524, 50, 60],
            [1997, 2525, 70, 70],
            [1997, 2526, 120, 90],
            [1997, 2527, 120, 90],
            [1997, 2528, 120, 90],
            [1997, 2529, 70, 70],
            [1997, 2530, 70, 70],
            [1997, 2531, 70, 70],
            [1997, 2532, 70, 70],
            [1997, 2533, 70, 70],
            [1997, 2534, 120, 90],
            [1997, 2535, 5.8, 6.5],
            [1997, 2537, 120, 90],
            [1997, 2538, 120, 90],
            [1997, 2539, 70, 70],
            [1997, 2540, 120, 90],
            [1997, 2541, 70, 70],
            [1997, 2543, 40, 50],
            [1997, 2544, 120, 90],
            [1997, 2545, 120, 90],
            [1997, 2546, 120, 90],
            [1997, 2547, 70, 70],
            [1997, 2548, 70, 70],
            [1997, 2549, 70, 70],
            [1997, 2550, 120, 90],
            [1997, 2551, 120, 90],
            [1997, 2552, 120, 90],
            [1997, 2553, 70, 70],
            [1997, 2554, 70, 70],
            [1997, 2555, 70, 70],
            [1997, 2556, 120, 90],
            [1997, 2558, 40, 50],
            [1997, 2560, 120, 90],
            [1997, 2561, 120, 90],
            [1997, 2562, 120, 90],
            [1997, 2563, 70, 70],
            [1997, 2564, 120, 90],
            [1997, 2565, 40, 50],
            [1997, 2567, 120, 90],
            [1997, 2568, 50, 60],
            [1997, 2569, 50, 60],
            [1997, 2570, 120, 90],
            [1997, 2571, 50, 60],
            [1997, 2572, 120, 90],
            [1997, 2573, 120, 90],
            [1997, 2574, 120, 90],
            [1997, 2575, 70, 70],
            [1997, 2576, 70, 70],
            [1997, 2578, 70, 70],
            [1997, 2579, 120, 90],
            [1997, 2580, 120, 90],
            [1997, 2581, 120, 90],
            [1997, 2582, 70, 70],
            [1997, 2584, 120, 90],
            [1997, 2585, 70, 70],
            [1997, 2586, 120, 90],
            [1997, 2587, 120, 90],
            [1997, 2588, 70, 70],
            [1997, 2589, 70, 70],
            [1997, 2590, 120, 90],
            [1997, 2591, 120, 90],
            [1997, 2592, 120, 90],
            [1997, 2593, 120, 90],
            [1997, 2594, 40, 50],
            [1997, 2595, 70, 70],
            [1997, 2596, 120, 90],
            [1997, 2597, 40, 50],
            [1997, 2598, 70, 70],
            [1997, 2599, 40, 50],
            [1997, 2600, 50, 60],
            [1997, 2601, 70, 70],
            [1997, 2602, 120, 90],
            [1997, 2603, 120, 90],
            [1997, 2604, 70, 70],
            [1997, 2606, 70, 70],
            [1997, 2607, 120, 90],
            [1997, 2608, 70, 70],
            [1997, 2609, 120, 90],
            [1997, 2610, 70, 70],
            [1997, 2612, 30, 45],
            [1997, 2613, 35.02, 25.49],
            [1997, 2614, 120, 90],
            [1997, 2615, 120, 90],
            [1997, 2616, 120, 90],
            [1997, 2617, 120, 90],
            [1997, 2618, 120, 90],
            [1997, 2619, 120, 90],
            [1997, 2620, 50, 60],
            [1997, 2621, 120, 90],
            [1997, 2622, 120, 90],
            [1997, 2623, 70, 70],
            [1997, 2624, 35.02, 25.49],
            [1997, 2625, 120, 90],
            [1997, 2626, 30, 45],
            [1997, 2627, 70, 70],
            [1997, 2628, 120, 90],
            [1997, 2629, 120, 90],
            [1997, 2630, 70, 70],
            [1997, 2631, 70, 70],
            [1997, 2632, 120, 90],
            [1997, 2633, 120, 90],
            [1997, 2634, 120, 90],
            [1997, 2635, 70, 70],
            [1997, 2636, 70, 70],
            [1997, 2637, 120, 90],
            [1997, 2638, 70, 70],
            [1997, 2642, 120, 90],
            [1997, 2644, 120, 90],
            [1997, 2645, 120, 90],
            [1997, 2646, 30, 45],
            [1997, 2647, 120, 90],
            [1997, 2649, 50, 60],
            [1997, 2650, 120, 90],
            [1997, 2651, 40, 50],
            [1997, 2652, 50, 60],
            [1997, 2653, 70, 70],
            [1997, 2654, 70, 70],
            [1997, 2655, 120, 90],
            [1997, 2656, 120, 90],
            [1997, 2657, 120, 90],
            [1997, 2658, 70, 70],
            [1997, 2659, 70, 70],
            [1997, 2660, 40, 50],
            [1997, 2661, 70, 70],
            [1997, 2662, 120, 90],
            [1997, 2663, 50, 60],
            [1997, 2664, 120, 90],
            [1997, 2665, 70, 70],
            [1997, 2666, 120, 90],
            [1997, 2667, 120, 90],
            [1997, 2668, 120, 90],
            [1997, 2669, 120, 90],
            [1997, 2670, 70, 70],
            [1997, 2671, 50, 60],
            [1997, 2672, 70, 70],
            [1997, 2673, 120, 90],
            [1997, 2675, 120, 90],
            [1997, 2676, 70, 70],
            [1997, 2677, 70, 70],
            [1997, 2678, 70, 70],
            [1997, 2679, 120, 90],
            [1997, 2680, 120, 90],
            [1997, 2681, 70, 70],
            [1997, 2682, 120, 90],
            [1997, 2683, 11.9, 7.65],
            [1997, 2684, 70, 70],
            [1997, 2685, 120, 90],
            [1997, 2687, 120, 90],
            [1997, 2688, 70, 70],
            [1997, 2690, 120, 90],
            [1997, 2691, 70, 70],
            [1997, 2692, 70, 70],
            [1997, 2693, 120, 90],
            [1997, 2694, 35.02, 25.49],
            [1997, 2695, 70, 70],
            [1997, 2696, 32.24, 21.39],
            [1997, 2697, 120, 90],
            [1997, 2698, 70, 70],
            [1997, 2699, 40, 50],
            [1997, 2702, 120, 90],
            [1997, 2703, 70, 70],
            [1997, 2706, 120, 90],
            [1997, 2707, 70, 70],
            [1997, 2709, 120, 90],
            [1997, 2711, 50, 60],
            [1997, 2712, 70, 70],
            [1997, 2713, 70, 70],
            [1997, 2714, 50, 60],
            [1997, 2715, 120, 90],
            [1997, 2716, 70, 70],
            [1997, 2717, 120, 90],
            [1997, 2718, 120, 90],
            [1997, 2719, 70, 70],
            [1997, 2720, 120, 90],
            [1997, 2721, 70, 70],
            [1997, 2722, 120, 90],
            [1997, 2723, 70, 70],
            [1997, 2724, 70, 70],
            [1997, 2725, 120, 90],
            [1997, 2726, 70, 70],
            [1997, 2727, 120, 90],
            [1997, 2728, 35.02, 25.49],
            [1997, 2730, 50, 60],
            [1997, 2731, 120, 90],
            [1997, 2732, 70, 70],
            [1997, 2733, 120, 90],
            [1997, 2734, 50, 60],
            [1997, 2736, 30, 45],
            [1997, 2737, 40, 50],
            [1997, 2738, 40, 50],
            [1997, 2739, 50, 60],
            [1997, 2740, 120, 90],
            [1997, 2741, 120, 90],
            [1997, 2742, 70, 70],
            [1997, 2743, 70, 70],
            [1997, 2745, 70, 70],
            [1997, 2746, 32.24, 21.39],
            [1997, 2747, 120, 90],
            [1997, 2748, 120, 90],
            [1997, 2749, 120, 90],
            [1997, 2750, 30, 45],
            [1997, 2751, 120, 90],
            [1997, 2752, 70, 70],
            [1997, 2753, 50, 60],
            [1997, 2754, 70, 70],
            [1997, 2755, 120, 90],
            [1997, 2756, 70, 70],
            [1997, 2757, 120, 90],
            [1997, 2758, 70, 70],
            [1997, 2759, 120, 90],
            [1997, 2760, 120, 90],
            [1997, 2761, 120, 90],
            [1997, 2762, 120, 90],
            [1997, 2763, 120, 90],
            [1997, 2764, 120, 90],
            [1997, 2765, 120, 90],
            [1997, 2766, 5.69, 6.72],
            [1997, 2767, 120, 90],
            [1997, 2768, 120, 90],
            [1997, 2769, 120, 90],
            [1997, 2770, 120, 90],
            [1997, 2772, 70, 70],
            [1997, 2773, 50, 60],
            [1997, 2774, 120, 90],
            [1997, 2775, 70, 70],
            [1997, 2776, 120, 90],
            [1997, 2777, 120, 90],
            [1997, 2778, 70, 70],
            [1997, 2779, 120, 90],
            [1997, 2780, 70, 70],
            [1997, 2782, 50, 60],
            [1997, 2783, 70, 70],
            [1997, 2784, 70, 70],
            [1997, 2785, 40, 50],
            [1997, 2786, 70, 70],
            [1997, 2787, 120, 90],
            [1997, 2788, 120, 90],
            [1997, 2789, 30, 45],
            [1997, 2790, 70, 70],
            [1997, 2791, 40, 50],
            [1997, 2792, 120, 90],
            [1997, 2793, 40, 50],
            [1997, 2794, 70, 70],
            [1997, 2795, 32.24, 21.39],
            [1997, 2796, 70, 70],
            [1997, 2797, 120, 90],
            [1997, 2798, 70, 70],
            [1997, 2799, 50, 60],
            [1997, 2800, 70, 70],
            [1997, 2801, 120, 90],
            [1997, 2802, 70, 70],
            [1997, 2803, 120, 90],
            [1997, 2804, 20.57, 14.3],
            [1997, 2805, 120, 90],
            [1997, 2806, 70, 70],
            [1997, 2808, 50, 60],
            [1997, 2809, 120, 90],
            [1997, 2810, 50, 60],
            [1997, 2811, 50, 60],
            [1997, 2812, 120, 90],
            [1997, 2813, 70, 70],
            [1997, 2814, 120, 90],
            [1997, 2818, 30, 45],
            [1997, 2819, 11.84, 8.58],
            [1997, 2820, 120, 90],
            [1997, 2821, 70, 70],
            [1997, 2822, 50, 60],
            [1997, 2823, 70, 70],
            [1997, 2824, 120, 90],
            [1997, 2825, 120, 90],
            [1997, 2826, 40, 50],
            [1997, 2827, 50, 60],
            [1997, 2829, 40, 50],
            [1997, 2830, 70, 70],
            [1997, 2831, 120, 90],
            [1997, 2832, 70, 70],
            [1997, 2833, 120, 90],
            [1997, 2834, 50, 60],
            [1997, 2835, 50, 60],
            [1997, 2836, 70, 70],
            [1997, 2837, 120, 90],
            [1997, 2838, 120, 90],
            [1997, 2839, 120, 90],
            [1997, 2840, 70, 70],
            [1997, 2841, 120, 90],
            [1997, 2842, 120, 90],
            [1997, 2843, 120, 90],
            [1997, 2844, 70, 70],
            [1997, 2845, 120, 90],
            [1997, 2846, 120, 90],
            [1997, 2847, 30, 45],
            [1997, 2850, 20.67, 13.88],
            [1997, 2851, 120, 90],
            [1997, 2852, 50, 60],
            [1997, 2853, 70, 70],
            [1997, 2854, 120, 90],
            [1997, 2855, 50, 60],
            [1997, 2856, 70, 70],
            [1997, 2857, 35.02, 25.49],
            [1997, 2858, 120, 90],
            [1997, 2860, 120, 90],
            [1997, 2861, 70, 70],
            [1997, 2862, 70, 70],
            [1997, 2863, 70, 70],
            [1997, 2864, 120, 90],
            [1997, 2865, 120, 90],
            [1997, 2866, 50, 60],
            [1997, 2868, 70, 70],
            [1997, 2869, 5.93, 4.86],
            [1997, 2871, 120, 90],
            [1997, 2872, 70, 70],
            [1997, 2873, 120, 90],
            [1997, 2874, 120, 90],
            [1997, 2875, 120, 90],
            [1997, 2876, 120, 90],
            [1997, 2877, 120, 90],
            [1997, 2878, 120, 90],
            [1997, 2879, 50, 60],
            [1997, 2880, 70, 70],
            [1997, 2881, 70, 70],
            [1997, 2882, 120, 90],
            [1997, 2883, 70, 70],
            [1997, 2884, 120, 90],
            [1997, 2885, 70, 70],
            [1997, 2886, 70, 70],
            [1997, 2887, 120, 90],
            [1997, 2888, 120, 90],
            [1997, 2889, 120, 90],
            [1997, 2890, 70, 70],
            [1997, 2891, 120, 90],
            [1997, 2892, 120, 90],
            [1997, 2893, 120, 90],
            [1997, 2894, 120, 90],
            [1997, 2896, 30, 45],
            [1997, 2897, 120, 90],
            [1997, 2898, 70, 70],
            [1997, 2899, 70, 70],
            [1997, 2900, 20.67, 13.88],
            [1997, 2901, 120, 90],
            [1997, 2902, 120, 90],
            [1997, 2903, 120, 90],
            [1997, 2904, 120, 90],
            [1997, 2905, 50, 60],
            [1997, 2906, 70, 70],
            [1997, 2907, 16.83, 17.5],
            [1997, 2908, 50, 60],
            [1997, 2909, 70, 70],
            [1997, 2910, 120, 90],
            [1997, 2911, 120, 90],
            [1997, 2912, 50, 60],
            [1997, 2913, 70, 70],
            [1997, 2914, 120, 90],
            [1997, 2916, 120, 90],
            [1997, 2917, 20.67, 13.88],
            [1997, 2918, 120, 90],
            [1997, 2919, 70, 70],
            [1997, 2920, 120, 90],
            [1997, 2921, 120, 90],
            [1997, 2922, 50, 60],
            [1997, 2923, 70, 70],
            [1997, 2924, 120, 90],
            [1997, 2925, 120, 90],
            [1997, 2926, 120, 90],
            [1997, 2927, 120, 90],
            [1997, 2928, 120, 90],
            [1997, 2929, 70, 70],
            [1997, 2930, 120, 90],
            [1997, 2931, 120, 90],
            [1997, 2932, 120, 90],
            [1997, 2933, 70, 70],
            [1997, 2934, 70, 70],
            [1997, 2935, 120, 90],
            [1997, 2936, 120, 90],
            [1997, 2937, 120, 90],
            [1997, 2939, 50, 60],
            [1997, 2940, 120, 90],
            [1997, 2942, 70, 70],
            [1997, 2943, 120, 90],
            [1997, 2944, 70, 70],
            [1997, 2945, 70, 70],
            [1997, 2946, 120, 90],
            [1997, 2947, 70, 70],
            [1997, 2948, 50, 60],
            [1997, 2949, 50, 60],
            [1997, 2950, 70, 70],
            [1997, 2951, 120, 90],
            [1997, 2952, 120, 90],
            [1997, 2953, 120, 90],
            [1997, 2954, 70, 70],
            [1997, 2955, 120, 90],
            [1997, 2956, 70, 70],
            [1997, 2957, 70, 70],
            [1997, 2958, 70, 70],
            [1997, 2959, 70, 70],
            [1997, 2960, 50, 60],
            [1997, 2961, 70, 70],
            [1997, 2962, 40, 50],
            [1997, 2963, 120, 90],
            [1997, 2964, 50, 60],
            [1997, 2965, 120, 90],
            [1997, 2967, 40, 50],
            [1997, 2968, 120, 90],
            [1997, 2969, 120, 90],
            [1997, 2970, 120, 90],
            [1997, 2971, 70, 70],
            [1997, 2972, 120, 90],
            [1997, 2973, 120, 90],
            [1997, 2974, 120, 90],
            [1997, 2975, 70, 70],
            [1997, 2976, 120, 90],
            [1997, 2978, 120, 90],
            [1997, 2979, 70, 70],
            [1997, 2980, 120, 90],
            [1997, 2981, 120, 90],
            [1997, 2982, 120, 90],
            [1997, 2984, 15.43, 13.81],
            [1997, 2985, 50, 60],
            [1997, 2986, 35.02, 25.49],
            [1997, 2987, 120, 90],
            [1997, 2988, 120, 90],
            [1997, 2989, 50, 60],
            [1997, 2990, 50, 60],
            [1997, 2991, 50, 60],
            [1997, 2992, 120, 90],
            [1997, 2993, 120, 90],
            [1997, 2994, 120, 90],
            [1997, 2995, 120, 90],
            [1997, 2996, 120, 90],
            [1997, 2998, 70, 70],
            [1997, 3000, 50, 60],
            [1997, 3001, 70, 70],
            [1997, 3002, 120, 90],
            [1997, 3003, 120, 90],
            [1997, 3004, 120, 90],
            [1997, 3005, 50, 60],
            [1997, 3006, 120, 90],
            [1997, 3007, 120, 90],
            [1997, 3008, 70, 70],
            [1997, 3009, 50, 60],
            [1997, 3010, 40, 50],
            [1997, 3011, 70, 70],
            [1997, 3012, 120, 90],
            [1997, 3013, 40, 50],
            [1997, 3014, 120, 90],
            [1997, 3015, 40, 50],
            [1997, 3016, 50, 60],
            [1997, 3017, 120, 90],
            [1997, 3018, 70, 70],
            [1997, 3019, 50, 60],
            [1997, 3021, 120, 90],
            [1997, 3022, 120, 90],
            [1997, 3023, 120, 90],
            [1997, 3024, 70, 70],
            [1997, 3025, 120, 90],
            [1997, 3027, 120, 90],
            [1997, 3028, 50, 60],
            [1997, 3029, 70, 70],
            [1997, 3030, 120, 90],
            [1997, 3031, 20.67, 13.88],
            [1997, 3032, 120, 90],
            [1997, 3033, 120, 90],
            [1997, 3034, 120, 90],
            [1997, 3035, 70, 70],
            [1997, 3036, 120, 90],
            [1997, 3037, 70, 70],
            [1997, 3039, 120, 90],
            [1997, 3040, 120, 90],
            [1997, 3041, 70, 70],
            [1997, 3042, 10.27, 8.48],
            [1997, 3043, 70, 70],
            [1997, 3044, 120, 90],
            [1997, 3045, 120, 90],
            [1997, 3046, 120, 90],
            [1997, 3047, 120, 90],
            [1997, 3048, 120, 90],
            [1997, 3049, 120, 90],
            [1997, 3050, 120, 90],
            [1997, 3051, 120, 90],
            [1997, 3052, 70, 70],
            [1997, 3053, 70, 70],
            [1997, 3054, 120, 90],
            [1997, 3055, 120, 90],
            [1997, 3057, 70, 70],
            [1997, 3058, 70, 70],
            [1997, 3059, 120, 90],
            [1997, 3060, 70, 70],
            [1997, 3061, 120, 90],
            [1997, 3062, 120, 90],
            [1997, 3063, 70, 70],
            [1997, 3064, 70, 70],
            [1997, 3065, 120, 90],
            [1997, 3066, 50, 60],
            [1997, 3069, 35.02, 25.49],
            [1997, 3070, 120, 90],
            [1997, 3071, 70, 70],
            [1997, 3072, 120, 90],
            [1997, 3073, 120, 90],
            [1997, 3074, 120, 90],
            [1997, 3076, 120, 90],
            [1997, 3077, 120, 90],
            [1997, 3078, 120, 90],
            [1997, 3079, 70, 70],
            [1997, 3081, 120, 90],
            [1997, 3083, 70, 70],
            [1997, 3084, 70, 70],
            [1997, 3085, 70, 70],
            [1997, 3086, 70, 70],
            [1997, 3087, 70, 70],
            [1997, 3088, 70, 70],
            [1997, 3090, 50, 60],
            [1997, 3091, 40, 50],
            [1997, 3092, 70, 70],
            [1997, 3094, 120, 90],
            [1997, 3095, 120, 90],
            [1997, 3096, 70, 70],
            [1997, 3097, 120, 90],
            [1997, 3098, 120, 90],
            [1997, 3100, 120, 90],
            [1997, 3101, 120, 90],
            [1997, 3102, 120, 90],
            [1997, 3103, 70, 70],
            [1997, 3104, 7.73, 6.59],
            [1997, 3105, 120, 90],
            [1997, 3106, 70, 70],
            [1997, 3107, 120, 90],
            [1997, 3108, 120, 90],
            [1997, 3109, 120, 90],
            [1997, 3110, 120, 90],
            [1997, 3111, 70, 70],
            [1997, 3112, 70, 70],
            [1997, 3113, 120, 90],
            [1997, 3115, 120, 90],
            [1997, 3116, 120, 90],
            [1997, 3117, 70, 70],
            [1997, 3118, 120, 90],
            [1997, 3119, 40, 50],
            [1997, 3120, 70, 70],
            [1997, 3121, 120, 90],
            [1997, 3122, 120, 90],
            [1997, 3124, 120, 90],
            [1997, 3125, 120, 90],
            [1997, 3126, 70, 70],
            [1997, 3127, 9.37, 9.65],
            [1997, 3128, 120, 90],
            [1997, 3129, 120, 90],
            [1997, 3130, 40, 50],
            [1997, 3131, 8.89, 9.07],
            [1997, 3132, 120, 90],
            [1997, 3133, 120, 90],
            [1997, 3134, 50, 60],
            [1997, 3135, 120, 90],
            [1997, 3136, 40, 50],
            [1997, 3137, 70, 70],
            [1997, 3138, 120, 90],
            [1997, 3139, 10.29, 7.91],
            [1997, 3140, 120, 90],
            [1997, 3141, 120, 90],
            [1997, 3142, 40, 50],
            [1997, 3143, 70, 70],
            [1997, 3144, 120, 90],
            [1997, 3145, 120, 90],
            [1997, 3148, 120, 90],
            [1997, 3149, 120, 90],
            [1997, 3150, 70, 70],
            [1997, 3151, 120, 90],
            [1997, 3152, 120, 90],
            [1997, 3153, 70, 70],
            [1997, 3154, 120, 90],
            [1997, 3155, 120, 90],
            [1997, 3156, 120, 90],
            [1997, 3157, 120, 90],
            [1997, 3158, 120, 90],
            [1997, 3159, 120, 90],
            [1997, 3160, 120, 90],
            [1997, 3161, 70, 70],
            [1997, 3162, 120, 90],
            [1997, 3163, 120, 90],
            [1997, 3164, 70, 70],
            [1997, 3166, 15, 20],
            [1997, 3167, 70, 70],
            [1997, 3168, 120, 90],
            [1997, 3169, 70, 70],
            [1997, 3170, 120, 90],
            [1997, 3171, 50, 60],
            [1997, 3172, 120, 90],
            [1997, 3175, 120, 90],
            [1997, 3176, 120, 90],
            [1997, 3177, 50, 60],
            [1997, 3178, 120, 90],
            [1997, 3179, 120, 90],
            [1997, 3182, 50, 60],
            [1997, 3183, 40, 50],
            [1997, 3184, 70, 70],
            [1997, 3186, 40, 50],
            [1997, 3187, 120, 90],
            [1997, 3188, 120, 90],
            [1997, 3189, 70, 70],
            [1997, 3190, 40, 50],
            [1997, 3191, 70, 70],
            [1997, 3192, 120, 90],
            [1997, 3193, 50, 60],
            [1997, 3194, 70, 70],
            [1997, 3195, 120, 90],
            [1997, 3196, 70, 70],
            [1997, 3197, 70, 70],
            [1997, 3198, 50, 60],
            [1997, 3199, 70, 70],
            [1997, 3200, 40, 50],
            [1997, 3201, 120, 90],
            [1997, 3202, 50, 60],
            [1997, 3203, 12.22, 11.28],
            [1997, 3206, 70, 70],
            [1997, 3207, 70, 70],
            [1997, 3208, 120, 90],
            [1997, 3210, 30, 45],
            [1997, 3211, 50, 60],
            [1997, 3212, 120, 90],
            [1997, 3213, 70, 70],
            [1997, 3214, 120, 90],
            [1997, 3215, 70, 70],
            [1997, 3216, 120, 90],
            [1997, 3217, 120, 90],
            [1997, 3218, 50, 60],
            [1997, 3219, 10.87, 12.56],
            [1997, 3220, 120, 90],
            [1997, 3221, 70, 70],
            [1997, 3222, 70, 70],
            [1997, 3224, 120, 90],
            [1997, 3225, 8.05, 7.89],
            [1997, 3226, 50, 60],
            [1997, 3227, 70, 70],
            [1997, 3228, 40, 50],
            [1997, 3229, 35.02, 25.49],
            [1997, 3230, 50, 60],
            [1997, 3231, 120, 90],
            [1997, 3232, 70, 70],
            [1997, 3234, 70, 70],
            [1997, 3235, 120, 90],
            [1997, 3237, 120, 90],
            [1997, 3238, 120, 90],
            [1997, 3239, 120, 90],
            [1997, 3240, 120, 90],
            [1997, 3241, 40, 50],
            [1997, 3242, 120, 90],
            [1997, 3243, 12.14, 9.5],
            [1997, 3244, 120, 90],
            [1997, 3245, 120, 90],
            [1997, 3246, 120, 90],
            [1997, 3247, 120, 90],
            [1997, 3248, 50, 60],
            [1997, 3249, 120, 90],
            [1997, 3250, 70, 70],
            [1997, 3251, 40, 50],
            [1997, 3252, 50, 60],
            [1997, 3253, 70, 70],
            [1997, 3254, 50, 60],
            [1997, 3255, 70, 70],
            [1997, 3256, 120, 90],
            [1997, 3257, 50, 60],
            [1997, 3258, 70, 70],
            [1997, 3259, 50, 60],
            [1997, 3260, 20, 25],
            [1997, 3261, 120, 90],
            [1997, 3262, 70, 70],
            [1997, 3263, 120, 90],
            [1997, 3264, 40, 50],
            [1997, 3265, 120, 90],
            [1997, 3266, 70, 70],
            [1997, 3267, 50, 60],
            [1997, 3268, 120, 90],
            [1997, 3269, 120, 90],
            [1997, 3271, 35.02, 25.49],
            [1997, 3272, 120, 90],
            [1997, 3273, 120, 90],
            [1997, 3274, 50, 60],
            [1997, 3275, 120, 90],
            [1997, 3276, 35.02, 25.49],
            [1997, 3277, 120, 90],
            [1997, 3278, 70, 70],
            [1997, 3279, 32.24, 21.39],
            [1997, 3280, 120, 90],
            [1997, 3281, 120, 90],
            [1997, 3282, 120, 90],
            [1997, 3284, 120, 90],
            [1997, 3285, 120, 90],
            [1997, 3286, 15.7, 9.65],
            [1997, 3287, 50, 60],
            [1997, 3288, 50, 60],
            [1997, 3289, 120, 90],
            [1997, 3290, 70, 70],
            [1997, 3291, 120, 90],
            [1997, 3292, 120, 90],
            [1997, 3293, 70, 70],
            [1997, 3294, 20.67, 13.88],
            [1997, 3295, 120, 90],
            [1997, 3296, 30, 45],
            [1997, 3297, 120, 90],
            [1997, 3299, 40, 50],
            [1997, 3300, 70, 70],
            [1997, 3301, 70, 70],
            [1997, 3302, 70, 70],
            [1997, 3303, 120, 90],
            [1997, 3305, 120, 90],
            [1997, 3306, 70, 70],
            [1997, 3308, 70, 70],
            [1997, 3309, 50, 60],
            [1997, 3310, 50, 60],
            [1997, 3311, 70, 70],
            [1997, 3312, 70, 70],
            [1997, 3313, 120, 90],
            [1997, 3314, 50, 60],
            [1997, 3315, 120, 90],
            [1997, 3316, 120, 90],
            [1997, 3317, 120, 90],
            [1997, 3318, 70, 70],
            [1997, 3319, 70, 70],
            [1997, 3320, 120, 90],
            [1997, 3321, 50, 60],
            [1997, 3322, 120, 90],
            [1997, 3323, 120, 90],
            [1997, 3324, 70, 70],
            [1997, 3325, 40, 50],
            [1997, 3326, 120, 90],
            [1997, 3327, 120, 90],
            [1997, 3328, 120, 90],
            [1997, 3329, 8.87, 8.14],
            [1997, 3330, 120, 90],
            [1997, 3331, 120, 90],
            [1997, 3332, 120, 90],
            [1997, 3333, 120, 90],
            [1997, 3335, 70, 70],
            [1997, 3336, 120, 90],
            [1997, 3337, 120, 90],
            [1997, 3338, 70, 70],
            [1997, 3339, 70, 70],
            [1997, 3340, 70, 70],
            [1997, 3341, 24.19, 14.72],
            [1997, 3342, 32.24, 21.39],
            [1997, 3343, 120, 90],
            [1997, 3344, 120, 90],
            [1997, 3345, 70, 70],
            [1997, 3346, 120, 90],
            [1997, 3347, 120, 90],
            [1997, 3348, 70, 70],
            [1997, 3350, 35.02, 25.49],
            [1997, 3351, 35.02, 25.49],
            [1997, 3352, 120, 90],
            [1997, 3353, 120, 90],
            [1997, 3354, 50, 60],
            [1997, 3356, 120, 90],
            [1997, 3357, 120, 90],
            [1997, 3358, 120, 90],
            [1997, 3359, 120, 90],
            [1997, 3360, 50, 60],
            [1997, 3361, 120, 90],
            [1997, 3362, 120, 90],
            [1997, 3363, 120, 90],
            [1997, 3364, 70, 70],
            [1997, 3365, 70, 70],
            [1997, 3366, 120, 90],
            [1997, 3367, 50, 60],
            [1997, 3368, 120, 90],
            [1997, 3369, 120, 90],
            [1997, 3370, 70, 70],
            [1997, 3371, 70, 70],
            [1997, 3372, 70, 70],
            [1997, 3373, 30, 45],
            [1997, 3375, 120, 90],
            [1997, 3376, 35.02, 25.49],
            [1997, 3377, 70, 70],
            [1997, 3378, 9.02, 8.54],
            [1997, 3379, 120, 90],
            [1997, 3380, 120, 90],
            [1997, 3381, 120, 90],
            [1997, 3382, 70, 70],
            [1997, 3384, 120, 90],
            [1997, 3385, 70, 70],
            [1997, 3386, 120, 90],
            [1997, 3387, 70, 70],
            [1997, 3388, 120, 90],
            [1997, 3389, 70, 70],
            [1997, 3390, 120, 90],
            [1997, 3391, 120, 90],
            [1997, 3392, 120, 90],
            [1997, 3393, 120, 90],
            [1997, 3394, 120, 90],
            [1997, 3397, 70, 70],
            [1997, 3398, 120, 90],
            [1997, 3399, 70, 70],
            [1997, 3400, 40, 50],
            [1997, 3401, 30, 45],
            [1997, 3402, 120, 90],
            [1997, 3404, 120, 90],
            [1997, 3407, 120, 90],
            [1997, 3408, 35.02, 25.49],
            [1997, 3409, 120, 90],
            [1997, 3410, 50, 60],
            [1997, 3411, 70, 70],
            [1997, 3412, 50, 60],
            [1997, 3414, 50, 60],
            [1997, 3415, 40, 50],
            [1997, 3416, 40, 50],
            [1997, 3417, 70, 70],
            [1997, 3418, 120, 90],
            [1997, 3419, 70, 70],
            [1997, 3420, 70, 70],
            [1997, 3422, 120, 90],
            [1997, 3423, 120, 90],
            [1997, 3424, 50, 60],
            [1997, 3425, 70, 70],
            [1997, 3426, 120, 90],
            [1997, 3427, 70, 70],
            [1997, 3428, 70, 70],
            [1997, 3429, 120, 90],
            [1997, 3430, 120, 90],
            [1997, 3431, 120, 90],
            [1997, 3432, 120, 90],
            [1997, 3433, 70, 70],
            [1997, 3434, 6.86, 5.46],
            [1997, 3435, 120, 90],
            [1997, 3436, 120, 90],
            [1997, 3437, 70, 70],
            [1997, 3439, 70, 70],
            [1997, 3440, 120, 90],
            [1997, 3441, 120, 90],
            [1997, 3442, 120, 90],
            [1997, 3444, 30, 45],
            [1997, 3445, 70, 70],
            [1997, 3446, 70, 70],
            [1997, 3447, 120, 90],
            [1997, 3448, 5.56, 6.38],
            [1997, 3449, 70, 70],
            [1997, 3450, 120, 90],
            [1997, 3451, 120, 90],
            [1997, 3452, 120, 90],
            [1997, 3453, 120, 90],
            [1997, 3454, 40, 50],
            [1997, 3456, 120, 90],
            [1997, 3458, 120, 90],
            [1997, 3459, 120, 90],
            [1997, 3460, 120, 90],
            [1997, 3461, 70, 70],
            [1997, 3462, 70, 24.96],
            [1997, 3463, 120, 90],
            [1997, 3464, 120, 90],
            [1997, 3466, 120, 90],
            [1997, 3467, 70, 70],
            [1997, 3468, 120, 90],
            [1997, 3469, 120, 90],
            [1997, 3470, 120, 90],
            [1997, 3471, 70, 70],
            [1997, 3472, 120, 90],
            [1997, 3473, 22.49, 13.06],
            [1997, 3474, 70, 70],
            [1997, 3475, 50, 60],
            [1997, 3476, 40, 50],
            [1997, 3477, 120, 90],
            [1997, 3478, 120, 90],
            [1997, 3480, 120, 90],
            [1997, 3481, 70, 70],
            [1997, 3482, 32.24, 21.39],
            [1997, 3483, 70, 70],
            [1997, 3484, 120, 90],
            [1997, 3485, 50, 60],
            [1997, 3486, 70, 70],
            [1997, 3487, 20.67, 13.88],
            [1997, 3488, 50, 60],
            [1997, 3489, 50, 60],
            [1997, 3490, 120, 90],
            [1997, 3491, 120, 90],
            [1997, 3492, 120, 90],
            [1997, 3493, 70, 70],
            [1997, 3494, 40, 50],
            [1997, 3495, 120, 90],
            [1997, 3496, 120, 90],
            [1997, 3497, 120, 90],
            [1997, 3498, 40, 50],
            [1997, 3499, 120, 90],
            [1997, 3500, 120, 90],
            [1997, 3501, 120, 90],
            [1997, 3503, 120, 90],
            [1997, 3504, 70, 70],
            [1997, 3505, 120, 90],
            [1997, 3506, 120, 90],
            [1997, 3508, 120, 90],
            [1997, 3509, 50, 60],
            [1997, 3510, 120, 90],
            [1997, 3511, 70, 70],
            [1997, 3514, 50, 60],
            [1997, 3515, 70, 70],
            [1997, 3516, 120, 90],
            [1997, 3517, 70, 70],
            [1997, 3518, 120, 90],
            [1997, 3519, 50, 60],
            [1997, 3520, 120, 90],
            [1997, 3521, 120, 90],
            [1997, 3522, 70, 70],
            [1997, 3523, 35.02, 25.49],
            [1997, 3524, 70, 70],
            [1997, 3525, 120, 90],
            [1997, 3527, 120, 90],
            [1997, 3528, 70, 70],
            [1997, 3529, 70, 70],
            [1997, 3530, 70, 70],
            [1997, 3531, 120, 90],
            [1997, 3533, 70, 70],
            [1997, 3534, 50, 60],
            [1997, 3535, 30, 45],
            [1997, 3536, 70, 70],
            [1997, 3537, 120, 90],
            [1997, 3538, 70, 70],
            [1997, 3539, 120, 90],
            [1997, 3540, 120, 90],
            [1997, 3541, 120, 90],
            [1997, 3542, 70, 70],
            [1997, 3543, 120, 90],
            [1997, 3544, 120, 90],
            [1997, 3545, 120, 90],
            [1997, 3546, 35.02, 25.49],
            [1997, 3547, 120, 90],
            [1997, 3548, 120, 90],
            [1997, 3549, 30, 45],
            [1997, 3550, 50, 60],
            [1997, 3551, 120, 90],
            [1997, 3552, 40, 50],
            [1997, 3553, 70, 70],
            [1997, 3554, 50, 60],
            [1997, 3555, 40, 50],
            [1997, 3557, 50, 60],
            [1997, 3558, 70, 70],
            [1997, 3559, 50, 60],
            [1997, 3560, 120, 90],
            [1997, 3561, 120, 90],
            [1997, 3562, 120, 90],
            [1997, 3563, 120, 90],
            [1997, 3564, 120, 90],
            [1997, 3566, 120, 90],
            [1997, 3568, 12.22, 9.98],
            [1997, 3569, 50, 60],
            [1997, 3570, 70, 70],
            [1997, 3571, 70, 70],
            [1997, 3572, 120, 90],
            [1997, 3573, 120, 90],
            [1997, 3575, 120, 90],
            [1997, 3576, 120, 90],
            [1997, 3577, 120, 90],
            [1997, 3578, 70, 70],
            [1997, 3579, 40, 50],
            [1997, 3580, 70, 70],
            [1997, 3581, 120, 90],
            [1997, 3583, 120, 90],
            [1997, 3584, 70, 70],
            [1997, 3585, 70, 70],
            [1997, 3586, 70, 70],
            [1997, 3587, 70, 70],
            [1997, 3588, 120, 90],
            [1997, 3589, 70, 70],
            [1997, 3590, 40, 50],
            [1997, 3592, 70, 70],
            [1997, 3593, 70, 70],
            [1997, 3594, 120, 90],
            [1997, 3595, 120, 90],
            [1997, 3596, 35.02, 25.49],
            [1997, 3597, 70, 70],
            [1997, 3598, 120, 90],
            [1997, 3599, 120, 90],
            [1997, 3600, 70, 70],
            [1997, 3601, 40, 50],
            [1997, 3602, 120, 90],
            [1997, 3603, 30, 45],
            [1997, 3604, 120, 90],
            [1997, 3606, 40, 50],
            [1997, 3607, 70, 70],
            [1997, 3608, 120, 90],
            [1997, 3609, 120, 90],
            [1997, 3610, 50, 60],
            [1997, 3611, 70, 70],
            [1997, 3612, 70, 70],
            [1997, 3613, 40, 50],
            [1997, 3615, 70, 70],
            [1997, 3616, 70, 70],
            [1997, 3617, 120, 90],
            [1997, 3619, 70, 70],
            [1997, 3620, 50, 60],
            [1997, 3621, 50, 60],
            [1997, 3622, 120, 90],
            [1997, 3623, 120, 90],
            [1997, 3625, 120, 90],
            [1997, 3626, 120, 90],
            [1997, 3627, 120, 90],
            [1997, 3628, 30, 45],
            [1997, 3629, 32.24, 21.39],
            [1997, 3630, 50, 60],
            [1997, 3631, 70, 70],
            [1997, 3632, 120, 90],
            [1997, 3633, 70, 70],
            [1997, 3635, 50, 60],
            [1997, 3636, 70, 70],
            [1997, 3637, 40, 50],
            [1997, 3638, 120, 90],
            [1997, 3639, 120, 90],
            [1997, 3640, 120, 90],
            [1997, 3641, 40, 50],
            [1997, 3642, 70, 70],
            [1997, 3643, 70, 70],
            [1997, 3644, 70, 70],
            [1997, 3646, 70, 70],
            [1997, 3647, 120, 90],
            [1997, 3648, 70, 70],
            [1997, 3649, 120, 90],
            [1997, 3650, 120, 90],
            [1997, 3651, 40, 50],
            [1997, 3652, 40, 50],
            [1997, 3653, 120, 90],
            [1997, 3654, 120, 90],
            [1997, 3655, 120, 90],
            [1997, 3656, 70, 70],
            [1997, 3657, 120, 90],
            [1997, 3658, 120, 90],
            [1997, 3659, 120, 90],
            [1997, 3660, 120, 90],
            [1997, 3661, 120, 90],
            [1997, 3662, 30, 45],
            [1997, 3663, 120, 90],
            [1997, 3664, 120, 90],
            [1997, 3665, 120, 90],
            [1997, 3666, 35.02, 25.49],
            [1997, 3667, 120, 90],
            [1997, 3668, 120, 90],
            [1997, 3669, 50, 60],
            [1997, 3670, 70, 70],
            [1997, 3671, 120, 90],
            [1997, 3672, 40, 50],
            [1997, 3673, 120, 90],
            [1997, 3674, 70, 70],
            [1997, 3675, 120, 90],
            [1997, 3676, 120, 90],
            [1997, 3677, 50, 60],
            [1997, 3678, 6.48, 4.68],
            [1997, 3679, 50, 60],
            [1997, 3680, 120, 90],
            [1997, 3681, 70, 70],
            [1997, 3682, 120, 90],
            [1997, 3683, 70, 70],
            [1997, 3684, 120, 90],
            [1997, 3685, 120, 90],
            [1997, 3686, 35.02, 25.49],
            [1997, 3687, 70, 70],
            [1997, 3688, 120, 90],
            [1997, 3689, 120, 90],
            [1997, 3690, 120, 90],
            [1997, 3691, 14.78, 14.29],
            [1997, 3692, 50, 60],
            [1997, 3693, 120, 90],
            [1997, 3694, 70, 70],
            [1997, 3695, 35.02, 25.49],
            [1997, 3696, 70, 70],
            [1997, 3697, 50, 60],
            [1997, 3698, 120, 90],
            [1997, 3699, 120, 90],
            [1997, 3700, 50, 60],
            [1997, 3701, 40, 50],
            [1997, 3702, 18.29, 11.85],
            [1997, 3703, 120, 90],
            [1997, 3704, 70, 70],
            [1997, 3705, 14.08, 13.22],
            [1997, 3706, 120, 90],
            [1997, 3707, 70, 70],
            [1997, 3708, 70, 70],
            [1997, 3710, 50, 60],
            [1997, 3712, 120, 90],
            [1997, 3713, 70, 70],
            [1997, 3714, 120, 90],
            [1997, 3715, 120, 90],
            [1997, 3716, 120, 90],
            [1997, 3718, 70, 70],
            [1997, 3719, 35.02, 25.49],
            [1997, 3720, 50, 60],
            [1997, 3721, 120, 90],
            [1997, 3722, 40, 50],
            [1997, 3723, 40, 50],
            [1997, 3725, 70, 70],
            [1997, 3726, 70, 70],
            [1997, 3727, 50, 60],
            [1997, 3728, 120, 90],
            [1997, 3729, 120, 90],
            [1997, 3730, 30, 45],
            [1997, 3731, 120, 90],
            [1997, 3733, 120, 90],
            [1997, 3736, 120, 90],
            [1997, 3737, 70, 70],
            [1997, 3738, 30, 45],
            [1997, 3739, 70, 70],
            [1997, 3741, 120, 90],
            [1997, 3742, 120, 90],
            [1997, 3743, 30, 45],
            [1997, 3744, 120, 90],
            [1997, 3745, 120, 90],
            [1997, 3746, 120, 90],
            [1997, 3747, 120, 90],
            [1997, 3748, 120, 90],
            [1997, 3749, 35.02, 25.49],
            [1997, 3750, 120, 90],
            [1997, 3751, 120, 90],
            [1997, 3752, 120, 90],
            [1997, 3753, 50, 60],
            [1997, 3754, 120, 90],
            [1997, 3755, 50, 60],
            [1997, 3756, 120, 90],
            [1997, 3757, 70, 70],
            [1997, 3758, 50, 60],
            [1997, 3759, 70, 70],
            [1997, 3760, 40, 50],
            [1997, 3761, 120, 90],
            [1997, 3762, 50, 60],
            [1997, 3763, 70, 70],
            [1997, 3764, 50, 60],
            [1997, 3765, 70, 70],
            [1997, 3766, 50, 60],
            [1997, 3767, 50, 60],
            [1997, 3768, 70, 70],
            [1997, 3769, 120, 90],
            [1997, 3770, 30, 45],
            [1997, 3772, 120, 90],
            [1997, 3773, 70, 70],
            [1997, 3775, 50, 60],
            [1997, 3776, 120, 90],
            [1997, 3777, 120, 90],
            [1997, 3778, 30, 45],
            [1997, 3779, 120, 90],
            [1997, 3780, 70, 70],
            [1997, 3781, 120, 90],
            [1997, 3782, 120, 90],
            [1997, 3783, 70, 70],
            [1997, 3785, 35.02, 25.49],
            [1997, 3786, 50, 60],
            [1997, 3787, 70, 70],
            [1997, 3789, 70, 70],
            [1997, 3791, 120, 90],
            [1997, 3793, 70, 70],
            [1997, 3794, 30, 45],
            [1997, 3795, 120, 90],
            [1997, 3796, 120, 90],
            [1997, 3797, 70, 70],
            [1997, 3798, 120, 90],
            [1997, 3799, 50, 60],
            [1997, 3800, 70, 70],
            [1997, 3801, 120, 90],
            [1997, 3802, 40, 50],
            [1997, 3804, 70, 70],
            [1997, 3806, 120, 90],
            [1997, 3807, 120, 90],
            [1997, 3809, 120, 90],
            [1997, 3810, 30, 45],
            [1997, 3811, 120, 90],
            [1997, 3812, 120, 90],
            [1997, 3813, 120, 90],
            [1997, 3814, 70, 70],
            [1997, 3816, 120, 90],
            [1997, 3817, 70, 70],
            [1997, 3818, 40, 50],
            [1997, 3819, 120, 90],
            [1997, 3820, 50, 60],
            [1997, 3821, 120, 90],
            [1997, 3822, 120, 90],
            [1997, 3824, 120, 90],
            [1997, 3825, 120, 90],
            [1997, 3826, 70, 70],
            [1997, 3827, 120, 90],
            [1997, 3828, 120, 90],
            [1997, 3829, 70, 70],
            [1997, 3831, 120, 90],
            [1997, 3832, 120, 90],
            [1997, 3833, 30, 45],
            [1997, 3834, 120, 90],
            [1997, 3835, 70, 70],
            [1997, 3836, 50, 60],
            [1997, 3837, 70, 70],
            [1997, 3838, 120, 90],
            [1997, 3839, 120, 90],
            [1997, 3840, 120, 90],
            [1997, 3841, 120, 90],
            [1997, 3842, 50, 60],
            [1997, 3843, 120, 90],
            [1997, 3844, 120, 90],
            [1997, 3845, 40, 50],
            [1997, 3846, 70, 70],
            [1997, 3847, 50, 60],
            [1997, 3849, 32.24, 21.39],
            [1997, 3850, 120, 90],
            [1997, 3851, 120, 90],
            [1997, 3852, 120, 90],
            [1997, 3853, 35.02, 25.49],
            [1997, 3854, 120, 90],
            [1997, 3855, 120, 90],
            [1997, 3856, 120, 90],
            [1997, 3857, 70, 70],
            [1997, 3858, 120, 90],
            [1997, 3859, 70, 70],
            [1997, 3862, 70, 70],
            [1997, 3863, 50, 60],
            [1997, 3864, 70, 70],
            [1997, 3865, 120, 90],
            [1997, 3867, 35.02, 25.49],
            [1997, 3868, 120, 90],
            [1997, 3869, 40, 50],
            [1997, 3870, 120, 90],
            [1997, 3871, 70, 70],
            [1997, 3872, 120, 90],
            [1997, 3873, 120, 90],
            [1997, 3874, 120, 90],
            [1997, 3875, 70, 70],
            [1997, 3877, 70, 70],
            [1997, 3878, 70, 70],
            [1997, 3879, 70, 70],
            [1997, 3881, 120, 90],
            [1997, 3882, 120, 90],
            [1997, 3883, 120, 90],
            [1997, 3884, 70, 70],
            [1997, 3885, 70, 70],
            [1997, 3886, 120, 90],
            [1997, 3887, 120, 90],
            [1997, 3888, 120, 90],
            [1997, 3889, 70, 70],
            [1997, 3891, 70, 70],
            [1997, 3892, 120, 90],
            [1997, 3893, 70, 70],
            [1997, 3894, 120, 90],
            [1997, 3895, 120, 90],
            [1997, 3896, 70, 70],
            [1997, 3897, 120, 90],
            [1997, 3898, 120, 90],
            [1997, 3899, 120, 90],
            [1997, 3900, 120, 90],
            [1997, 3901, 120, 90],
            [1997, 3902, 120, 90],
            [1997, 3903, 70, 70],
            [1997, 3905, 120, 90],
            [1997, 3906, 70, 70],
            [1997, 3907, 120, 90],
            [1997, 3908, 120, 90],
            [1997, 3909, 120, 90],
            [1997, 3910, 32.24, 21.39],
            [1997, 3912, 70, 70],
            [1997, 3913, 120, 90],
            [1997, 3914, 70, 70],
            [1997, 3915, 30, 45],
            [1997, 3916, 120, 90],
            [1997, 3917, 70, 70],
            [1997, 3918, 8.88, 7.78],
            [1997, 3919, 120, 90],
            [1997, 3920, 70, 70],
            [1997, 3921, 120, 90],
            [1997, 3922, 120, 90],
            [1997, 3923, 70, 70],
            [1997, 3925, 120, 90],
            [1997, 3926, 120, 90],
            [1997, 3927, 70, 70],
            [1997, 3929, 120, 90],
            [1997, 3930, 70, 70],
            [1997, 3931, 120, 90],
            [1997, 3932, 70, 70],
            [1997, 3933, 120, 90],
            [1997, 3934, 120, 90],
            [1997, 3935, 120, 90],
            [1997, 3936, 120, 90],
            [1997, 3937, 70, 70],
            [1997, 3938, 40, 50],
            [1997, 3939, 120, 90],
            [1997, 3940, 50, 60],
            [1997, 3941, 120, 90],
            [1997, 3942, 120, 90],
            [1997, 3943, 70, 70],
            [1997, 3944, 35.02, 25.49],
            [1997, 3945, 120, 90],
            [1997, 3946, 13.42, 11.21],
            [1997, 3947, 120, 90],
            [1997, 3948, 30, 45],
            [1997, 3949, 120, 90],
            [1997, 3950, 120, 90],
            [1997, 3951, 120, 90],
            [1997, 3952, 120, 90],
            [1997, 3953, 120, 90],
            [1997, 3954, 120, 90],
            [1997, 3955, 120, 90],
            [1997, 3956, 50, 60],
            [1997, 3958, 13.07, 12.08],
            [1997, 3959, 120, 90],
            [1997, 3960, 50, 60],
            [1997, 3961, 10.48, 9.83],
            [1997, 3962, 120, 90],
            [1997, 3963, 50, 60],
            [1997, 3964, 120, 90],
            [1997, 3965, 70, 70],
            [1997, 3966, 70, 70],
            [1997, 3968, 40, 50],
            [1997, 3969, 70, 70],
            [1997, 3970, 120, 90],
            [1997, 3971, 120, 90],
            [1997, 3972, 120, 90],
            [1997, 3973, 120, 90],
            [1997, 3974, 120, 90],
            [1997, 3975, 120, 90],
            [1997, 3976, 70, 70],
            [1997, 3978, 70, 70],
            [1997, 3979, 70, 70],
            [1997, 3980, 120, 90],
            [1997, 3981, 70, 70],
            [1997, 3982, 120, 90],
            [1997, 3983, 30, 45],
            [1997, 3984, 120, 90],
            [1997, 3985, 70, 70],
            [1997, 3986, 120, 90],
            [1997, 3988, 120, 90],
            [1997, 3990, 70, 70],
            [1997, 3991, 120, 90],
            [1997, 3992, 70, 70],
            [1997, 3993, 70, 70],
            [1997, 3994, 120, 90],
            [1997, 3995, 120, 90],
            [1997, 3996, 70, 70],
            [1997, 3997, 120, 90],
            [1997, 3998, 120, 90],
            [1997, 3999, 70, 70],
            [1997, 4001, 120, 90],
            [1997, 4002, 120, 90],
            [1997, 4003, 70, 70],
            [1997, 4004, 70, 70],
            [1997, 4005, 40, 50],
            [1997, 4006, 120, 90],
            [1997, 4007, 120, 90],
            [1997, 4008, 70, 70],
            [1997, 4009, 120, 90],
            [1997, 4010, 30, 45],
            [1997, 4011, 120, 90],
            [1997, 4012, 120, 90],
            [1997, 4013, 120, 90],
            [1997, 4014, 120, 90],
            [1997, 4015, 120, 90],
            [1997, 4016, 30, 45],
            [1997, 4017, 70, 70],
            [1997, 4018, 70, 70],
            [1997, 4019, 120, 90],
            [1997, 4020, 70, 70],
            [1997, 4021, 70, 70],
            [1997, 4022, 70, 70],
            [1997, 4023, 50, 60],
            [1997, 4024, 120, 90],
            [1997, 4025, 70, 70],
            [1997, 4026, 70, 70],
            [1997, 4027, 120, 90],
            [1997, 4028, 70, 70],
            [1997, 4029, 120, 90],
            [1997, 4031, 50, 60],
            [1997, 4032, 120, 90],
            [1997, 4033, 70, 70],
            [1997, 4035, 120, 90],
            [1997, 4036, 120, 90],
            [1997, 4037, 70, 70],
            [1997, 4038, 120, 90],
            [1997, 4039, 120, 90],
            [1997, 4040, 120, 90],
            [1997, 4041, 120, 90],
            [1997, 4042, 120, 90],
            [1997, 4043, 70, 70],
            [1997, 4044, 120, 90],
            [1997, 4045, 10.74, 9.07],
            [1997, 4046, 120, 90],
            [1997, 4047, 120, 90],
            [1997, 4048, 50, 60],
            [1997, 4049, 70, 70],
            [1997, 4050, 120, 90],
            [1997, 4051, 120, 90],
            [1997, 4053, 70, 70],
            [1997, 4056, 70, 70],
            [1997, 4057, 50, 60],
            [1997, 4059, 70, 70],
            [1997, 4060, 120, 90],
            [1997, 4062, 70, 70],
            [1997, 4063, 50, 60],
            [1997, 4064, 30, 45],
            [1997, 4065, 70, 70],
            [1997, 4066, 70, 70],
            [1997, 4067, 70, 70],
            [1997, 4068, 120, 90],
            [1997, 4069, 50, 60],
            [1997, 4070, 120, 90],
            [1997, 4071, 70, 70],
            [1997, 4072, 120, 90],
            [1997, 4073, 30, 45],
            [1997, 4074, 70, 70],
            [1997, 4075, 120, 90],
            [1997, 4076, 120, 90],
            [1997, 4077, 120, 90],
            [1997, 4078, 120, 90],
            [1997, 4079, 120, 90],
            [1997, 4080, 120, 90],
            [1997, 4081, 120, 90],
            [1997, 4082, 120, 90],
            [1997, 4083, 120, 90],
            [1997, 4084, 120, 90],
            [1997, 4085, 70, 70],
            [1997, 4086, 120, 90],
            [1997, 4087, 120, 90],
            [1997, 4088, 120, 90],
            [1997, 4089, 120, 90],
            [1997, 4090, 120, 90],
            [1997, 4091, 70, 70],
            [1997, 4092, 70, 70],
            [1997, 4093, 120, 90],
            [1997, 4094, 32.24, 21.39],
            [1997, 4095, 70, 70],
            [1997, 4096, 70, 70],
            [1997, 4097, 120, 90],
            [1997, 4098, 50, 60],
            [1997, 4100, 50, 60],
            [1997, 4101, 120, 90],
            [1997, 4102, 70, 70],
            [1997, 4103, 70, 70],
            [1997, 4104, 70, 70],
            [1997, 4105, 120, 90],
            [1997, 4106, 70, 70],
            [1997, 4107, 120, 90],
            [1997, 4108, 120, 90],
            [1997, 4109, 120, 90],
            [1997, 4110, 70, 70],
            [1997, 4111, 70, 70],
            [1997, 4112, 40, 50],
            [1997, 4113, 120, 90],
            [1997, 4115, 120, 90],
            [1997, 4116, 120, 90],
            [1997, 4117, 50, 60],
            [1997, 4118, 120, 90],
            [1997, 4119, 35.02, 25.49],
            [1997, 4120, 70, 70],
            [1997, 4121, 70, 70],
            [1997, 4122, 120, 90],
            [1997, 4123, 70, 70],
            [1997, 4124, 30, 45],
            [1997, 4125, 70, 70],
            [1997, 4126, 120, 90],
            [1997, 4127, 120, 90],
            [1997, 4128, 70, 70],
            [1997, 4131, 16.41, 11.51],
            [1997, 4132, 120, 90],
            [1997, 4133, 70, 70],
            [1997, 4134, 120, 90],
            [1997, 4135, 120, 90],
            [1997, 4136, 50, 60],
            [1997, 4137, 120, 90],
            [1997, 4138, 11.77, 6.96],
            [1997, 4139, 30, 45],
            [1997, 4140, 70, 70],
            [1997, 4141, 120, 90],
            [1997, 4142, 120, 90],
            [1997, 4143, 50, 60],
            [1997, 4144, 120, 90],
            [1997, 4145, 120, 90],
            [1997, 4147, 120, 90],
            [1997, 4148, 120, 90],
            [1997, 4149, 120, 90],
            [1997, 4150, 70, 70],
            [1997, 4151, 120, 90],
            [1997, 4152, 120, 90],
            [1997, 4153, 120, 90],
            [1997, 4154, 120, 90],
            [1997, 4155, 70, 70],
            [1997, 4156, 120, 90],
            [1997, 4157, 70, 70],
            [1997, 4158, 120, 90],
            [1997, 4159, 6.8, 6.9],
            [1997, 4160, 120, 90],
            [1997, 4161, 120, 90],
            [1997, 4162, 120, 90],
            [1997, 4163, 120, 90],
            [1997, 4164, 120, 90],
            [1997, 4165, 120, 90],
            [1997, 4166, 30, 45],
            [1997, 4167, 120, 90],
            [1997, 4168, 50, 60],
            [1997, 4169, 70, 70],
            [1997, 4170, 70, 70],
            [1997, 4171, 120, 90],
            [1997, 4172, 120, 90],
            [1997, 4173, 70, 70],
            [1997, 4174, 70, 70],
            [1997, 4175, 40, 50],
            [1997, 4176, 50, 60],
            [1997, 4177, 120, 90],
            [1997, 4178, 120, 90],
            [1997, 4181, 70, 70],
            [1997, 4182, 120, 90],
            [1997, 4184, 120, 90],
            [1997, 4185, 70, 70],
            [1997, 4186, 120, 90],
            [1997, 4187, 120, 90],
            [1997, 4188, 120, 90],
            [1997, 4189, 50, 60],
            [1997, 4190, 120, 90],
            [1997, 4192, 50, 60],
            [1997, 4193, 120, 90],
            [1997, 4194, 120, 90],
            [1997, 4195, 120, 90],
            [1997, 4196, 120, 90],
            [1997, 4197, 120, 90],
            [1997, 4198, 120, 90],
            [1997, 4199, 70, 70],
            [1997, 4200, 13.33, 9.28],
            [1997, 4201, 70, 70],
            [1997, 4202, 70, 70],
            [1997, 4203, 120, 90],
            [1997, 4204, 50, 60],
            [1997, 4205, 120, 90],
            [1997, 4206, 40, 50],
            [1997, 4207, 50, 60],
            [1997, 4208, 120, 90],
            [1997, 4209, 120, 90],
            [1997, 4210, 40, 50],
            [1997, 4211, 120, 90],
            [1997, 4212, 30, 45],
            [1997, 4213, 70, 70],
            [1997, 4214, 120, 90],
            [1997, 4215, 35.02, 25.49],
            [1997, 4216, 120, 90],
            [1997, 4218, 70, 70],
            [1997, 4219, 30, 45],
            [1997, 4220, 120, 90],
            [1997, 4221, 32.24, 21.39],
            [1997, 4222, 120, 90],
            [1997, 4224, 70, 70],
            [1997, 4225, 120, 90],
            [1997, 4226, 70, 70],
            [1997, 4228, 120, 90],
            [1997, 4229, 120, 90],
            [1997, 4230, 70, 70],
            [1997, 4231, 70, 70],
            [1997, 4232, 50, 60],
            [1997, 4233, 40, 50],
            [1997, 4234, 50, 60],
            [1997, 4235, 13.03, 13.29],
            [1997, 4236, 70, 70],
            [1997, 4237, 120, 90],
            [1997, 4238, 120, 90],
            [1997, 4239, 120, 90],
            [1997, 4240, 15, 25],
            [1997, 4241, 120, 90],
            [1997, 4242, 120, 90],
            [1997, 4244, 30, 45],
            [1997, 4245, 50, 60],
            [1997, 4246, 50, 60],
            [1997, 4247, 120, 90],
            [1997, 4248, 120, 90],
            [1997, 4249, 120, 90],
            [1997, 4250, 120, 90],
            [1997, 4251, 120, 90],
            [1997, 4252, 11.19, 9.3],
            [1997, 4253, 120, 90],
            [1997, 4255, 120, 90],
            [1997, 4256, 50, 60],
            [1997, 4257, 40, 50],
            [1997, 4258, 50, 60],
            [1997, 4260, 120, 90],
            [1997, 4261, 50, 60],
            [1997, 4262, 70, 70],
            [1997, 4263, 120, 90],
            [1997, 4264, 13.05, 10.17],
            [1997, 4265, 70, 70],
            [1997, 4266, 120, 90],
            [1997, 4267, 120, 90],
            [1997, 4268, 120, 90],
            [1997, 4269, 120, 90],
            [1997, 4270, 120, 90],
            [1997, 4271, 70, 70],
            [1997, 4272, 120, 90],
            [1997, 4273, 120, 90],
            [1997, 4274, 120, 90],
            [1997, 4275, 70, 70],
            [1997, 4276, 120, 90],
            [1997, 4277, 120, 90],
            [1997, 4278, 120, 90],
            [1997, 4279, 120, 90],
            [1997, 4280, 120, 90],
            [1997, 4281, 70, 70],
            [1997, 4282, 50, 60],
            [1997, 4283, 120, 90],
            [1997, 4284, 120, 90],
            [1997, 4285, 50, 60],
            [1997, 4286, 120, 90],
            [1997, 4287, 25.96, 16.87],
            [1997, 4288, 120, 90],
            [1997, 4290, 50, 60],
            [1997, 4291, 120, 90],
            [1997, 4292, 120, 90],
            [1997, 4293, 9.17, 7.22],
            [1997, 4294, 120, 90],
            [1997, 4295, 120, 90],
            [1997, 4296, 120, 90],
            [1997, 4297, 70, 70],
            [1997, 4298, 120, 90],
            [1997, 4299, 70, 70],
            [1997, 4300, 50, 60],
            [1997, 4301, 70, 70],
            [1997, 4302, 120, 90],
            [1997, 4304, 120, 90],
            [1997, 4305, 70, 70],
            [1997, 4306, 70, 70],
            [1997, 4307, 120, 90],
            [1997, 4308, 120, 90],
            [1997, 4309, 50, 60],
            [1997, 4310, 50, 60],
            [1997, 4311, 120, 90],
            [1997, 4312, 70, 70],
            [1997, 4313, 120, 90],
            [1997, 4314, 70, 70],
            [1997, 4315, 120, 90],
            [1997, 4316, 30, 45],
            [1997, 4317, 50, 60],
            [1997, 4318, 120, 90],
            [1997, 4319, 120, 90],
            [1997, 4320, 70, 70],
            [1997, 4321, 120, 90],
            [1997, 4322, 70, 70],
            [1997, 4323, 30, 45],
            [1997, 4325, 70, 70],
            [1997, 4326, 40, 50],
            [1997, 4328, 70, 70],
            [1997, 4329, 120, 90],
            [1997, 4330, 120, 90],
            [1997, 4333, 120, 90],
            [1997, 4334, 120, 90],
            [1997, 4335, 70, 70],
            [1997, 4336, 50, 60],
            [1997, 4337, 40, 50],
            [1997, 4338, 70, 70],
            [1997, 4339, 30, 45],
            [1997, 4340, 120, 90],
            [1997, 4341, 120, 90],
            [1997, 4342, 120, 90],
            [1997, 4343, 120, 90],
            [1997, 4345, 120, 90],
            [1997, 4346, 50, 60],
            [1997, 4347, 120, 90],
            [1997, 4348, 70, 70],
            [1997, 4349, 120, 90],
            [1997, 4350, 120, 90],
            [1997, 4352, 120, 90],
            [1997, 4353, 70, 70],
            [1997, 4355, 120, 90],
            [1997, 4356, 40, 50],
            [1997, 4357, 120, 90],
            [1997, 4358, 70, 70],
            [1997, 4360, 70, 70],
            [1997, 4362, 70, 70],
            [1997, 4363, 120, 90],
            [1997, 4364, 120, 90],
            [1997, 4365, 120, 90],
            [1997, 4366, 120, 90],
            [1997, 4367, 120, 90],
            [1997, 4368, 120, 90],
            [1997, 4370, 70, 70],
            [1997, 4371, 120, 90],
            [1997, 4372, 70, 70],
            [1997, 4373, 30, 45],
            [1997, 4374, 40, 50],
            [1997, 4375, 120, 90],
            [1997, 4376, 120, 90],
            [1997, 4377, 70, 70],
            [1997, 4378, 70, 70],
            [1997, 4379, 120, 90],
            [1997, 4380, 70, 70],
            [1997, 4381, 120, 90],
            [1997, 4382, 70, 70],
            [1997, 4383, 70, 70],
            [1997, 4384, 120, 90],
            [1997, 4385, 120, 90],
            [1997, 4386, 70, 70],
            [1997, 4387, 120, 90],
            [1997, 4389, 120, 90],
            [1997, 4390, 35.02, 25.49],
            [1997, 4391, 120, 90],
            [1997, 4392, 120, 90],
            [1997, 4393, 120, 90],
            [1997, 4394, 70, 70],
            [1997, 4395, 120, 90],
            [1997, 4396, 120, 90],
            [1997, 4398, 70, 70],
            [1997, 4399, 70, 70],
            [1997, 4400, 120, 90],
            [1997, 4401, 70, 70],
            [1997, 4404, 120, 90],
            [1997, 4405, 6.35, 4.6],
            [1997, 4406, 120, 90],
            [1997, 4407, 70, 70],
            [1997, 4408, 120, 90],
            [1997, 4409, 120, 90],
            [1997, 4410, 70, 70],
            [1997, 4411, 120, 90],
            [1997, 4412, 120, 90],
            [1997, 4413, 50, 60],
            [1997, 4414, 70, 70],
            [1997, 4415, 120, 90],
            [1997, 4416, 120, 90],
            [1997, 4417, 50, 60],
            [1997, 4418, 70, 70],
            [1997, 4419, 120, 90],
            [1997, 4420, 7.46, 6.7],
            [1997, 4421, 120, 90],
            [1997, 4422, 120, 90],
            [1997, 4423, 120, 90],
            [1997, 4426, 70, 70],
            [1997, 4427, 40, 50],
            [1997, 4428, 32.24, 21.39],
            [1997, 4430, 50, 60],
            [1997, 4431, 70, 70],
            [1997, 4432, 32.24, 21.39],
            [1997, 4433, 120, 90],
            [1997, 4435, 120, 90],
            [1997, 4436, 40, 50],
            [1997, 4437, 120, 90],
            [1997, 4438, 50, 60],
            [1997, 4439, 40, 50],
            [1997, 4440, 70, 70],
            [1997, 4441, 120, 90],
            [1997, 4442, 70, 70],
            [1997, 4443, 70, 70],
            [1997, 4444, 120, 90],
            [1997, 4445, 120, 90],
            [1997, 4446, 120, 90],
            [1997, 4447, 120, 90],
            [1997, 4448, 70, 70],
            [1997, 4450, 120, 90],
            [1997, 4451, 40, 50],
            [1997, 4453, 70, 70],
            [1997, 4454, 70, 70],
            [1997, 4455, 70, 70],
            [1997, 4456, 70, 70],
            [1997, 4457, 40, 50],
            [1997, 4459, 120, 90],
            [1997, 4460, 120, 90],
            [1997, 4461, 70, 70],
            [1997, 4463, 50, 60],
            [1997, 4464, 70, 70],
            [1997, 4465, 70, 70],
            [1997, 4466, 120, 90],
            [1997, 4467, 120, 90],
            [1997, 4468, 70, 70],
            [1997, 4470, 50, 60],
            [1997, 4471, 120, 90],
            [1997, 4472, 70, 70],
            [1997, 4473, 32.24, 21.39],
            [1997, 4474, 120, 90],
            [1997, 4475, 120, 90],
            [1997, 4476, 120, 90],
            [1997, 4477, 50, 60],
            [1997, 4478, 120, 90],
            [1997, 4479, 120, 90],
            [1997, 4481, 120, 90],
            [1997, 4482, 120, 90],
            [1997, 4483, 120, 90],
            [1997, 4484, 120, 90],
            [1997, 4485, 120, 90],
            [1997, 4486, 120, 90],
            [1997, 4487, 50, 60],
            [1997, 4488, 70, 70],
            [1997, 4489, 11.71, 6.08],
            [1997, 4490, 120, 90],
            [1997, 4491, 70, 70],
            [1997, 4492, 120, 90],
            [1997, 4493, 70, 70],
            [1997, 4494, 120, 90],
            [1997, 4495, 120, 90],
            [1997, 4496, 70, 70],
            [1997, 4497, 120, 90],
            [1997, 4498, 120, 90],
            [1997, 4500, 120, 90],
            [1997, 4501, 120, 90],
            [1997, 4502, 120, 90],
            [1997, 4504, 70, 70],
            [1997, 4505, 70, 70],
            [1997, 4506, 70, 70],
            [1997, 4508, 120, 90],
            [1997, 4509, 120, 90],
            [1997, 4510, 120, 90],
            [1997, 4511, 70, 70],
            [1997, 4512, 12.38, 7.83],
            [1997, 4513, 120, 90],
            [1997, 4514, 120, 90],
            [1997, 4515, 70, 70],
            [1997, 4516, 120, 90],
            [1997, 4517, 50, 60],
            [1997, 4518, 70, 70],
            [1997, 4519, 70, 70],
            [1997, 4520, 50, 60],
            [1997, 4521, 120, 90],
            [1997, 4523, 50, 60],
            [1997, 4524, 70, 70],
            [1997, 4525, 70, 70],
            [1997, 4526, 9.64, 9.7],
            [1997, 4527, 120, 90],
            [1997, 4528, 120, 90],
            [1997, 4529, 120, 90],
            [1997, 4531, 120, 90],
            [1997, 4532, 70, 70],
            [1997, 4533, 70, 70],
            [1997, 4534, 70, 70],
            [1997, 4535, 120, 90],
            [1997, 4536, 70, 70],
            [1997, 4537, 120, 90],
            [1997, 4538, 70, 70],
            [1997, 4539, 50, 60],
            [1997, 4541, 120, 90],
            [1997, 4542, 70, 70],
            [1997, 4543, 50, 60],
            [1997, 4544, 70, 70],
            [1997, 4545, 70, 70],
            [1997, 4546, 120, 90],
            [1997, 4547, 50, 60],
            [1997, 4548, 20.54, 15.72],
            [1997, 4549, 40, 50],
            [1997, 4550, 120, 90],
            [1997, 4551, 120, 90],
            [1997, 4552, 120, 90],
            [1997, 4553, 120, 90],
            [1997, 4554, 70, 70],
            [1997, 4555, 70, 70],
            [1997, 4556, 120, 90],
            [1997, 4557, 120, 90],
            [1997, 4558, 120, 90],
            [1997, 4559, 120, 90],
            [1997, 4560, 120, 90],
            [1997, 4561, 70, 70],
            [1997, 4562, 70, 70],
            [1997, 4563, 120, 90],
            [1997, 4565, 70, 70],
            [1997, 4566, 70, 70],
            [1997, 4568, 70, 70],
            [1997, 4569, 120, 90],
            [1997, 4571, 70, 70],
            [1997, 4572, 120, 90],
            [1997, 4574, 50, 60],
            [1997, 4575, 70, 70],
            [1997, 4576, 120, 90],
            [1997, 4578, 70, 70],
            [1997, 4579, 9.23, 6.62],
            [1997, 4580, 50, 60],
            [1997, 4581, 120, 90],
            [1997, 4582, 70, 70],
            [1997, 4584, 40, 50],
            [1997, 4585, 70, 70],
            [1997, 4587, 120, 90],
            [1997, 4588, 120, 90],
            [1997, 4590, 70, 70],
            [1997, 4591, 120, 90],
            [1997, 4592, 70, 70],
            [1997, 4595, 120, 90],
            [1997, 4596, 70, 70],
            [1997, 4597, 120, 90],
            [1997, 4598, 120, 90],
            [1997, 4599, 35.02, 25.49],
            [1997, 4600, 120, 90],
            [1997, 4601, 120, 90],
            [1997, 4602, 120, 90],
            [1997, 4603, 120, 90],
            [1997, 4604, 120, 90],
            [1997, 4605, 50, 60],
            [1997, 4606, 120, 90],
            [1997, 4607, 120, 90],
            [1997, 4608, 50, 60],
            [1997, 4610, 70, 70],
            [1997, 4611, 120, 90],
            [1997, 4612, 120, 90],
            [1997, 4613, 120, 90],
            [1997, 4614, 70, 70],
            [1997, 4615, 120, 90],
            [1997, 4616, 120, 90],
            [1997, 4617, 70, 70],
            [1997, 4618, 70, 70],
            [1997, 4619, 70, 70],
            [1997, 4620, 70, 70],
            [1997, 4621, 120, 90],
            [1997, 4622, 120, 90],
            [1997, 4623, 70, 70],
            [1997, 4624, 120, 90],
            [1997, 4625, 120, 90],
            [1997, 4626, 40, 50],
            [1997, 4627, 120, 90],
            [1997, 4628, 120, 90],
            [1997, 4629, 70, 70],
            [1997, 4630, 120, 90],
            [1997, 4631, 40, 50],
            [1997, 4633, 120, 90],
            [1997, 4634, 70, 70],
            [1997, 4635, 40, 50],
            [1997, 4636, 120, 90],
            [1997, 4637, 70, 70],
            [1997, 4638, 70, 70],
            [1997, 4640, 120, 90],
            [1997, 4641, 15.54, 8.85],
            [1997, 4643, 120, 90],
            [1997, 4644, 70, 70],
            [1997, 4645, 32.24, 21.39],
            [1997, 4646, 70, 70],
            [1997, 4647, 50, 60],
            [1997, 4648, 70, 70],
            [1997, 4649, 50, 60],
            [1997, 4651, 70, 70],
            [1997, 4652, 70, 70],
            [1997, 4653, 120, 90],
            [1997, 4654, 70, 70],
            [1997, 4655, 120, 90],
            [1997, 4657, 120, 90],
            [1997, 4658, 70, 70],
            [1997, 4659, 70, 70],
            [1997, 4660, 70, 70],
            [1997, 4661, 32.24, 21.39],
            [1997, 4662, 70, 70],
            [1997, 4663, 30, 45],
            [1997, 4664, 10.86, 8.78],
            [1997, 4665, 120, 90],
            [1997, 4666, 120, 90],
            [1997, 4667, 120, 90],
            [1997, 4668, 70, 70],
            [1997, 4669, 120, 90],
            [1997, 4670, 70, 70],
            [1997, 4671, 120, 90],
            [1997, 4673, 50, 60],
            [1997, 4674, 15, 20],
            [1997, 4675, 50, 60],
            [1997, 4676, 70, 70],
            [1997, 4677, 70, 70],
            [1997, 4679, 120, 90],
            [1997, 4680, 120, 90],
            [1997, 4682, 120, 90],
            [1997, 4683, 50, 60],
            [1997, 4684, 120, 90],
            [1997, 4686, 70, 70],
            [1997, 4687, 120, 90],
            [1997, 4689, 50, 60],
            [1997, 4690, 32.24, 21.39],
            [1997, 4691, 40, 50],
            [1997, 4692, 70, 70],
            [1997, 4693, 120, 90],
            [1997, 4694, 120, 90],
            [1997, 4695, 70, 70],
            [1997, 4696, 120, 90],
            [1997, 4697, 120, 90],
            [1997, 4698, 70, 70],
            [1997, 4699, 120, 90],
            [1997, 4701, 120, 90],
            [1997, 4702, 120, 90],
            [1997, 4703, 50, 60],
            [1997, 4704, 120, 90],
            [1997, 4705, 120, 90],
            [1997, 4706, 120, 90],
            [1997, 4707, 70, 70],
            [1997, 4708, 70, 70],
            [1997, 4709, 120, 90],
            [1997, 4711, 120, 90],
            [1997, 4712, 120, 90],
            [1997, 4713, 70, 70],
            [1997, 4714, 70, 70],
            [1997, 4715, 40, 50],
            [1997, 4716, 35.02, 25.49],
            [1997, 4717, 70, 70],
            [1997, 4718, 120, 90],
            [1997, 4720, 50, 60],
            [1997, 4722, 120, 90],
            [1997, 4723, 70, 70],
            [1997, 4724, 50, 60],
            [1997, 4725, 8.65, 7.78],
            [1997, 4726, 120, 90],
            [1997, 4728, 120, 90],
            [1997, 4729, 120, 90],
            [1997, 4730, 70, 70],
            [1997, 4731, 4.74, 5.56],
            [1997, 4732, 50, 60],
            [1997, 4733, 70, 70],
            [1997, 4734, 40, 50],
            [1997, 4735, 120, 90],
            [1997, 4736, 32.24, 21.39],
            [1997, 4737, 120, 90],
            [1997, 4738, 120, 90],
            [1997, 4739, 120, 90],
            [1997, 4740, 70, 70],
            [1997, 4741, 70, 70],
            [1997, 4742, 120, 90],
            [1997, 4743, 32.24, 21.39],
            [1997, 4744, 40, 50],
            [1997, 4745, 40, 50],
            [1997, 4747, 120, 90],
            [1997, 4749, 70, 70],
            [1997, 4750, 9.46, 11.76],
            [1997, 4751, 50, 60],
            [1997, 4752, 120, 90],
            [1997, 4753, 120, 90],
            [1997, 4754, 120, 90],
            [1997, 4756, 40, 50],
            [1997, 4757, 120, 90],
            [1997, 4758, 120, 90],
            [1997, 4760, 120, 90],
            [1997, 4761, 22.44, 14.33],
            [1997, 4762, 70, 70],
            [1997, 4763, 120, 90],
            [1997, 4764, 120, 90],
            [1997, 4765, 50, 60],
            [1997, 4766, 120, 90],
            [1997, 4767, 120, 90],
            [1997, 4770, 120, 90],
            [1997, 4771, 120, 90],
            [1997, 4772, 70, 70],
            [1997, 4773, 70, 70],
            [1997, 4774, 120, 90],
            [1997, 4775, 32.24, 21.39],
            [1997, 4776, 50, 60],
            [1997, 4777, 70, 70],
            [1997, 4778, 50, 60],
            [1997, 4779, 70, 70],
            [1997, 4780, 120, 90],
            [1997, 4781, 40, 50],
            [1997, 4782, 70, 70],
            [1997, 4783, 70, 70],
            [1997, 4784, 120, 90],
            [1997, 4785, 120, 90],
            [1997, 4786, 120, 90],
            [1997, 4788, 50, 60],
            [1997, 4789, 70, 70],
            [1997, 4790, 120, 90],
            [1997, 4791, 70, 70],
            [1997, 4792, 70, 70],
            [1997, 4793, 120, 90],
            [1997, 4794, 70, 70],
            [1997, 4795, 70, 70],
            [1997, 4796, 120, 90],
            [1997, 4797, 50, 60],
            [1997, 4798, 70, 70],
            [1997, 4799, 70, 70],
            [1997, 4800, 120, 90],
            [1997, 4801, 70, 70],
            [1997, 4802, 120, 90],
            [1997, 4803, 70, 70],
            [1997, 4804, 120, 90],
            [1997, 4805, 70, 70],
            [1997, 4806, 120, 90],
            [1997, 4807, 50, 60],
            [1997, 4808, 120, 90],
            [1997, 4809, 120, 90],
            [1997, 4810, 120, 90],
            [1997, 4811, 50, 60],
            [1997, 4812, 120, 90],
            [1997, 4814, 120, 90],
            [1997, 4815, 70, 70],
            [1997, 4816, 120, 90],
            [1997, 4817, 120, 90],
            [1997, 4818, 120, 90],
            [1997, 4819, 120, 90],
            [1997, 4820, 70, 70],
            [1997, 4821, 120, 90],
            [1997, 4823, 70, 70],
            [1997, 4825, 120, 90],
            [1997, 4826, 120, 90],
            [1997, 4827, 120, 90],
            [1997, 4828, 70, 70],
            [1997, 4829, 120, 90],
            [1997, 4830, 120, 90],
            [1997, 4831, 9.72, 8.44],
            [1997, 4832, 70, 70],
            [1997, 4833, 70, 70],
            [1997, 4834, 120, 90],
            [1997, 4835, 120, 90],
            [1997, 4836, 30, 45],
            [1997, 4837, 120, 90],
            [1997, 4838, 40, 50],
            [1997, 4839, 120, 90],
            [1997, 4840, 70, 70],
            [1997, 4841, 120, 90],
            [1997, 4842, 120, 90],
            [1997, 4843, 120, 90],
            [1997, 4844, 120, 90],
            [1997, 4845, 120, 90],
            [1997, 4846, 120, 90],
            [1997, 4847, 120, 90],
            [1997, 4848, 120, 90],
            [1997, 4849, 40, 50],
            [1997, 4850, 30, 45],
            [1997, 4851, 120, 90],
            [1997, 4852, 120, 90],
            [1997, 4853, 70, 70],
            [1997, 4854, 120, 90],
            [1997, 4855, 120, 90],
            [1997, 4856, 120, 90],
            [1997, 4857, 120, 90],
            [1997, 4858, 120, 90],
            [1997, 4860, 120, 90],
            [1997, 4862, 40, 50],
            [1997, 4863, 70, 70],
            [1997, 4864, 120, 90],
            [1997, 4865, 40, 50],
            [1997, 4866, 15, 25],
            [1997, 4867, 120, 90],
            [1997, 4868, 70, 70],
            [1997, 4869, 120, 90],
            [1997, 4871, 50, 60],
            [1997, 4872, 40, 50],
            [1997, 4874, 120, 90],
            [1997, 4875, 70, 70],
            [1997, 4876, 40, 50],
            [1997, 4877, 120, 90],
            [1997, 4878, 50, 60],
            [1997, 4879, 120, 90],
            [1997, 4880, 70, 70],
            [1997, 4881, 70, 70],
            [1997, 4882, 120, 90],
            [1997, 4883, 120, 90],
            [1997, 4885, 120, 90],
            [1997, 4886, 30, 45],
            [1997, 4887, 120, 90],
            [1997, 4888, 70, 70],
            [1997, 4890, 70, 70],
            [1997, 4891, 120, 90],
            [1997, 4892, 120, 90],
            [1997, 4893, 50, 60],
            [1997, 4894, 70, 70],
            [1997, 4895, 120, 90],
            [1997, 4896, 70, 70],
            [1997, 4897, 50, 60],
            [1997, 4898, 120, 90],
            [1997, 4899, 120, 90],
            [1997, 4900, 70, 70],
            [1997, 4901, 70, 70],
            [1997, 4902, 70, 70],
            [1997, 4903, 120, 90],
            [1997, 4904, 120, 90],
            [1997, 4905, 40, 50],
            [1997, 4906, 120, 90],
            [1997, 4907, 70, 70],
            [1997, 4908, 50, 60],
            [1997, 4909, 40, 50],
            [1997, 4910, 70, 70],
            [1997, 4911, 11.82, 7.07],
            [1997, 4912, 50, 60],
            [1997, 4914, 70, 70],
            [1997, 4915, 120, 90],
            [1997, 4916, 70, 70],
            [1997, 4917, 70, 70],
            [1997, 4918, 50, 60],
            [1997, 4919, 120, 90],
            [1997, 4920, 120, 90],
            [1997, 4922, 120, 90],
            [1997, 4923, 120, 90],
            [1997, 4924, 120, 90],
            [1997, 4925, 120, 90],
            [1997, 4926, 120, 90],
            [1997, 4927, 120, 90],
            [1997, 4928, 70, 70],
            [1997, 4929, 70, 70],
            [1997, 4930, 70, 70],
            [1997, 4931, 70, 70],
            [1997, 4932, 120, 90],
            [1997, 4934, 70, 70],
            [1997, 4935, 30, 45],
            [1997, 4936, 120, 90],
            [1997, 4937, 70, 70],
            [1997, 4938, 120, 90],
            [1997, 4939, 70, 70],
            [1997, 4940, 120, 90],
            [1997, 4941, 120, 90],
            [1997, 4942, 50, 60],
            [1997, 4944, 70, 70],
            [1997, 4945, 120, 90],
            [1997, 4946, 120, 90],
            [1997, 4947, 70, 70],
            [1997, 4948, 70, 70],
            [1997, 4949, 120, 90],
            [1997, 4950, 70, 70],
            [1997, 4951, 70, 70],
            [1997, 4952, 50, 60],
            [1997, 4953, 35.02, 25.49],
            [1997, 4954, 70, 70],
            [1997, 4955, 70, 70],
            [1997, 4956, 32.24, 21.39],
            [1997, 4957, 120, 90],
            [1997, 4958, 120, 90],
            [1997, 4959, 120, 90],
            [1997, 4960, 120, 90],
            [1997, 4961, 70, 70],
            [1997, 4962, 70, 70],
            [1997, 4963, 70, 70],
            [1997, 4964, 7.37, 6.44],
            [1997, 4965, 50, 60],
            [1997, 4966, 70, 70],
            [1997, 4968, 120, 90],
            [1997, 4969, 120, 90],
            [1997, 4970, 70, 70],
            [1997, 4971, 32.24, 21.39],
            [1997, 4972, 35.02, 25.49],
            [1997, 4973, 70, 70],
            [1997, 4974, 70, 70],
            [1997, 4975, 120, 90],
            [1997, 4976, 40, 50],
            [1997, 4977, 120, 90],
            [1997, 4978, 120, 90],
            [1997, 4979, 120, 90],
            [1997, 4980, 70, 70],
            [1997, 4981, 50, 60],
            [1997, 4982, 70, 70],
            [1997, 4983, 50, 60],
            [1997, 4984, 40, 50],
            [1997, 4987, 120, 90],
            [1997, 4988, 70, 70],
            [1997, 4989, 120, 90],
            [1997, 4990, 120, 90],
            [1997, 4992, 70, 70],
            [1997, 4993, 120, 90],
            [1997, 4994, 120, 90],
            [1997, 4995, 120, 90],
            [1997, 4996, 120, 90],
            [1997, 4997, 120, 90],
            [1997, 4998, 70, 70],
            [1997, 5000, 13.36, 12.29],
            [1997, 5001, 70, 70],
            [1997, 5002, 120, 90],
            [1997, 5003, 120, 90],
            [1997, 5004, 120, 90],
            [1997, 5005, 70, 70],
            [1997, 5006, 120, 90],
            [1997, 5007, 120, 90],
            [1997, 5008, 70, 70],
            [1997, 5009, 120, 90],
            [1997, 5010, 8.39, 5.61],
            [1997, 5011, 50, 60],
            [1997, 5012, 120, 90],
            [1997, 5013, 70, 70],
            [1997, 5014, 70, 70],
            [1997, 5015, 50, 60],
            [1997, 5017, 70, 70],
            [1997, 5018, 30, 45],
            [1997, 5019, 70, 70],
            [1997, 5020, 40, 50],
            [1997, 5021, 120, 90],
            [1997, 5022, 120, 90],
            [1997, 5023, 70, 70],
            [1997, 5024, 120, 90],
            [1997, 5025, 120, 90],
            [1997, 5026, 120, 90],
            [1997, 5027, 120, 90],
            [1997, 5028, 120, 90],
            [1997, 5029, 120, 90],
            [1997, 5030, 120, 90],
            [1997, 5031, 40, 50],
            [1997, 5032, 120, 90],
            [1997, 5033, 120, 90],
            [1997, 5034, 120, 90],
            [1997, 5035, 50, 60],
            [1997, 5036, 120, 90],
            [1997, 5037, 120, 90],
            [1997, 5038, 70, 70],
            [1997, 5039, 70, 70],
            [1997, 5040, 120, 90],
            [1997, 5041, 120, 90],
            [1997, 5042, 120, 90],
            [1997, 5043, 50, 60],
            [1997, 5044, 70, 70],
            [1997, 5045, 120, 90],
            [1997, 5046, 50, 60],
            [1997, 5047, 30, 45],
            [1997, 5048, 70, 70],
            [1997, 5049, 120, 90],
            [1997, 5050, 50, 60],
            [1997, 5051, 70, 70],
            [1997, 5052, 120, 90],
            [1997, 5053, 120, 90],
            [1997, 5054, 120, 90],
            [1997, 5056, 120, 90],
            [1997, 5057, 120, 90],
            [1997, 5058, 120, 90],
            [1997, 5059, 120, 90],
            [1997, 5060, 120, 90],
            [1997, 5061, 120, 90],
            [1997, 5062, 70, 70],
            [1997, 5063, 40, 50],
            [1997, 5064, 120, 90],
            [1997, 5065, 120, 90],
            [1997, 5066, 120, 90],
            [1997, 5068, 120, 90],
            [1997, 5069, 120, 90],
            [1997, 5070, 120, 90],
            [1997, 5071, 50, 60],
            [1997, 5072, 120, 90],
            [1997, 5073, 50, 60],
            [1997, 5075, 120, 90],
            [1997, 5076, 30, 45],
            [1997, 5077, 40, 50],
            [1997, 5078, 120, 90],
            [1997, 5079, 70, 70],
            [1997, 5080, 70, 70],
            [1997, 5081, 120, 90],
            [1997, 5082, 12.57, 13.41],
            [1997, 5084, 50, 60],
            [1997, 5085, 50, 60],
            [1997, 5086, 70, 70],
            [1997, 5087, 120, 90],
            [1997, 5088, 120, 90],
            [1997, 5089, 120, 90],
            [1997, 5091, 120, 90],
            [1997, 5092, 50, 60],
            [1997, 5093, 120, 90],
            [1997, 5094, 40, 50],
            [1997, 5095, 50, 60],
            [1997, 5097, 120, 90],
            [1997, 5098, 120, 90],
            [1997, 5099, 70, 70],
            [1997, 5100, 120, 90],
            [1997, 5101, 5.93, 6.65],
            [1997, 5102, 120, 90],
            [1997, 5103, 120, 90],
            [1997, 5104, 120, 90],
            [1997, 5105, 120, 90],
            [1997, 5106, 50, 60],
            [1997, 5107, 120, 90],
            [1997, 5108, 70, 70],
            [1997, 5109, 120, 90],
            [1997, 5110, 120, 90],
            [1997, 5111, 35.02, 25.49],
            [1997, 5114, 4.87, 4],
            [1997, 5115, 120, 90],
            [1997, 5116, 70, 70],
            [1997, 5117, 40, 50],
            [1997, 5118, 70, 70],
            [1997, 5119, 120, 90],
            [1997, 5120, 50, 60],
            [1997, 5121, 120, 90],
            [1997, 5122, 120, 90],
            [1997, 5124, 70, 70],
            [1997, 5125, 50, 60],
            [1997, 5126, 120, 90],
            [1997, 5127, 70, 70],
            [1997, 5128, 32.24, 21.39],
            [1997, 5129, 70, 70],
            [1997, 5130, 70, 70],
            [1997, 5131, 120, 90],
            [1997, 5132, 120, 90],
            [1997, 5135, 50, 60],
            [1997, 5137, 120, 90],
            [1997, 5138, 120, 90],
            [1997, 5139, 70, 70],
            [1997, 5140, 70, 70],
            [1997, 5141, 50, 60],
            [1997, 5142, 120, 90],
            [1997, 5143, 70, 70],
            [1997, 5144, 70, 70],
            [1997, 5145, 35.02, 25.49],
            [1997, 5148, 120, 90],
            [1997, 5149, 120, 90],
            [1997, 5150, 120, 90],
            [1997, 5151, 70, 70],
            [1997, 5152, 120, 90],
            [1997, 5153, 120, 90],
            [1997, 5154, 120, 90],
            [1997, 5155, 70, 70],
            [1997, 5156, 120, 90],
            [1997, 5157, 50, 60],
            [1997, 5158, 40, 50],
            [1997, 5159, 70, 70],
            [1997, 5160, 120, 90],
            [1997, 5161, 50, 60],
            [1997, 5162, 120, 90],
            [1997, 5163, 120, 90],
            [1997, 5164, 120, 90],
            [1997, 5165, 70, 70],
            [1997, 5166, 50, 60],
            [1997, 5167, 120, 90],
            [1997, 5168, 70, 70],
            [1997, 5169, 120, 90],
            [1997, 5170, 120, 90],
            [1997, 5171, 70, 70],
            [1997, 5172, 70, 70],
            [1997, 5173, 120, 90],
            [1997, 5174, 70, 70],
            [1997, 5175, 120, 90],
            [1997, 5177, 120, 90],
            [1997, 5178, 120, 90],
            [1997, 5179, 120, 90],
            [1997, 5180, 120, 90],
            [1997, 5181, 120, 90],
            [1997, 5182, 120, 90],
            [1997, 5183, 120, 90],
            [1997, 5189, 40, 50],
            [1997, 5271, 70, 70],
            [1997, 5627, 70, 70],
            [1997, 5632, 120, 90],
            [1997, 5999, 50, 60],
            [1997, 6000, 30, 45],
            [1997, 6001, 30, 45],
            [1997, 6002, 30, 45],
            [1997, 6003, 30, 45],
            [1997, 6004, 30, 45],
            [1997, 6005, 30, 45],
            [1997, 6006, 30, 45],
            [1997, 6007, 30, 45],
            [1997, 6008, 30, 45],
            [1997, 6011, 30, 45],
            [1997, 6012, 30, 45],
            [1997, 6013, 30, 45],
            [1997, 6014, 30, 45],
            [1997, 6015, 30, 45],
            [1997, 6016, 30, 45],
            [1997, 6020, 30, 45],
            [1997, 6021, 30, 45],
            [1997, 6022, 30, 45],
            [1997, 6023, 30, 45],
            [1997, 6024, 30, 45],
            [1997, 6028, 30, 45],
            [1997, 6031, 30, 45],
            [1997, 6032, 30, 45],
            [1997, 6034, 30, 45],
            [1997, 6035, 30, 45],
            [1997, 6036, 30, 45],
            [1997, 6037, 30, 45],
            [1997, 6038, 30, 45],
            [1997, 6040, 30, 45],
            [1997, 6041, 30, 45],
            [1997, 6042, 30, 45],
            [1997, 6043, 30, 45],
            [1997, 6044, 30, 45],
            [1997, 6045, 30, 45],
            [1997, 6046, 30, 45],
            [1997, 6047, 30, 45],
            [1997, 6048, 30, 45],
            [1997, 6050, 70, 70],
            [1997, 6051, 70, 70],
            [1997, 6052, 120, 90],
            [1997, 6053, 120, 90],
            [1997, 6248, 30, 45],
            [1997, 6252, 50, 60],
            [1997, 6253, 120, 90],
            [1997, 6255, 70, 70],
            [1997, 6256, 50, 60],
            [1997, 6258, 50, 60],
            [1997, 6259, 120, 90],
            [1997, 6260, 120, 90],
            [1997, 6261, 70, 70],
            [1997, 6262, 70, 70],
            [1997, 6263, 120, 90],
            [1997, 6264, 70, 70],
            [1997, 6265, 70, 70],
            [1997, 6266, 50, 60],
            [1997, 6267, 50, 60],
            [1997, 6268, 70, 70],
            [1997, 6269, 50, 60],
            [1997, 6270, 50, 60],
            [1997, 6271, 70, 70],
            [1997, 6272, 40, 50],
            [1997, 6274, 70, 70],
            [1997, 6275, 70, 70],
            [1997, 6276, 50, 60],
            [1997, 6277, 120, 90],
            [1997, 6279, 70, 70],
            [1997, 6280, 70, 70],
            [1997, 6281, 70, 70],
            [1997, 6282, 50, 60],
            [1997, 6283, 70, 70],
            [1997, 6284, 50, 60],
            [1997, 6286, 70, 70],
            [1997, 6287, 50, 60],
            [1997, 6288, 70, 70],
            [1997, 6289, 50, 60],
            [1997, 6290, 120, 90],
            [1997, 6292, 70, 70],
            [1997, 6293, 70, 70],
            [1997, 6294, 120, 90],
            [1997, 6295, 120, 90],
            [1997, 6296, 70, 70],
            [1997, 6297, 120, 90],
            [1997, 6299, 70, 70],
            [1997, 6300, 70, 70],
            [1997, 6301, 70, 70],
            [1997, 6302, 70, 70],
            [1997, 6303, 70, 70],
            [1997, 6305, 120, 90],
            [1997, 6306, 70, 70],
            [1997, 6307, 120, 90],
            [1997, 6308, 120, 90],
            [1997, 6309, 70, 70],
            [1997, 6310, 50, 60],
            [1997, 6312, 120, 90],
            [1997, 6313, 70, 70],
            [1997, 6314, 120, 90],
            [1997, 6315, 70, 70],
            [1997, 6316, 70, 70],
            [1997, 6317, 70, 70],
            [1997, 6319, 50, 60],
            [1997, 6320, 70, 70],
            [1997, 6321, 70, 70],
            [1997, 6326, 70, 70],
            [1997, 6328, 120, 90],
            [1997, 6330, 120, 90],
            [1998, 1, 50, 60],
            [1998, 2, 120, 90],
            [1998, 3, 70, 70],
            [1998, 7, 35.26, 21.02],
            [1998, 9, 120, 90],
            [1998, 13, 120, 90],
            [1998, 14, 70, 70],
            [1998, 15, 70, 70],
            [1998, 16, 70, 70],
            [1998, 17, 120, 90],
            [1998, 18, 70, 70],
            [1998, 19, 70, 70],
            [1998, 20, 120, 90],
            [1998, 21, 70, 70],
            [1998, 22, 120, 90],
            [1998, 23, 120, 90],
            [1998, 25, 13.55, 9.36],
            [1998, 26, 70, 70],
            [1998, 27, 120, 90],
            [1998, 28, 50, 60],
            [1998, 29, 120, 90],
            [1998, 30, 31.41, 21.15],
            [1998, 31, 11.48, 9.38],
            [1998, 32, 120, 90],
            [1998, 33, 70, 70],
            [1998, 35, 120, 90],
            [1998, 37, 120, 90],
            [1998, 38, 120, 90],
            [1998, 40, 70, 70],
            [1998, 42, 70, 70],
            [1998, 43, 120, 90],
            [1998, 44, 120, 90],
            [1998, 46, 120, 90],
            [1998, 47, 70, 70],
            [1998, 48, 70, 70],
            [1998, 49, 37.5, 45],
            [1998, 50, 120, 90],
            [1998, 51, 15.57, 18.15],
            [1998, 53, 40, 50],
            [1998, 56, 120, 90],
            [1998, 57, 120, 90],
            [1998, 58, 61.93, 51.53],
            [1998, 61, 70, 70],
            [1998, 62, 120, 90],
            [1998, 63, 70, 70],
            [1998, 64, 30, 45],
            [1998, 65, 50, 60],
            [1998, 66, 20, 25],
            [1998, 68, 70, 70],
            [1998, 69, 70, 70],
            [1998, 70, 50, 60],
            [1998, 71, 120, 90],
            [1998, 72, 120, 90],
            [1998, 73, 120, 90],
            [1998, 75, 50, 60],
            [1998, 77, 35.02, 25.49],
            [1998, 78, 59.13, 56.03],
            [1998, 81, 70, 70],
            [1998, 82, 70, 70],
            [1998, 83, 40, 37.5],
            [1998, 84, 120, 90],
            [1998, 87, 140.68, 39.98],
            [1998, 88, 15.28, 7.56],
            [1998, 89, 32.24, 21.39],
            [1998, 91, 40, 50],
            [1998, 93, 10.29, 11.63],
            [1998, 94, 120, 90],
            [1998, 96, 120, 90],
            [1998, 98, 120, 90],
            [1998, 99, 15.91, 13.12],
            [1998, 100, 13.94, 11.33],
            [1998, 101, 70, 70],
            [1998, 103, 120, 90],
            [1998, 105, 40, 50],
            [1998, 106, 70, 70],
            [1998, 109, 40, 50],
            [1998, 110, 120, 90],
            [1998, 113, 50, 60],
            [1998, 119, 70, 70],
            [1998, 121, 17.05, 9.84],
            [1998, 122, 42.72, 53.2],
            [1998, 123, 120, 90],
            [1998, 125, 24.22, 37.94],
            [1998, 128, 70, 70],
            [1998, 133, 35.02, 25.49],
            [1998, 135, 24.22, 25.06],
            [1998, 136, 120, 90],
            [1998, 138, 83.99, 31.46],
            [1998, 140, 50, 60],
            [1998, 141, 70, 70],
            [1998, 142, 70, 70],
            [1998, 144, 50, 60],
            [1998, 145, 10.42, 10.42],
            [1998, 146, 35.02, 25.49],
            [1998, 147, 32.24, 21.39],
            [1998, 149, 70, 70],
            [1998, 150, 50, 60],
            [1998, 151, 47.1, 33.3],
            [1998, 153, 12, 18],
            [1998, 156, 120, 90],
            [1998, 157, 120, 90],
            [1998, 158, 35.02, 25.49],
            [1998, 160, 120, 90],
            [1998, 161, 50, 60],
            [1998, 162, 17.62, 13.77],
            [1998, 163, 70, 70],
            [1998, 164, 120, 90],
            [1998, 165, 70, 70],
            [1998, 166, 31.35, 44.44],
            [1998, 169, 97.7, 41.85],
            [1998, 170, 120, 90],
            [1998, 171, 70, 70],
            [1998, 175, 70, 70],
            [1998, 177, 70, 70],
            [1998, 181, 120, 90],
            [1998, 182, 120, 90],
            [1998, 183, 70, 70],
            [1998, 184, 120, 90],
            [1998, 186, 42.55, 28.63],
            [1998, 187, 50, 60],
            [1998, 188, 50.99, 26.41],
            [1998, 189, 120, 90],
            [1998, 190, 41.9, 24.53],
            [1998, 192, 70, 70],
            [1998, 193, 50, 60],
            [1998, 194, 120, 90],
            [1998, 195, 70, 70],
            [1998, 196, 9.99, 9.76],
            [1998, 197, 120, 90],
            [1998, 198, 120, 90],
            [1998, 199, 120, 90],
            [1998, 200, 50, 60],
            [1998, 203, 70, 70],
            [1998, 204, 70, 70],
            [1998, 206, 120, 90],
            [1998, 207, 50, 60],
            [1998, 210, 120, 90],
            [1998, 211, 120, 90],
            [1998, 212, 70, 70],
            [1998, 213, 70, 70],
            [1998, 214, 120, 90],
            [1998, 215, 39.31, 26.34],
            [1998, 216, 72.31, 55.31],
            [1998, 217, 120, 90],
            [1998, 218, 53.89, 34.22],
            [1998, 219, 50, 60],
            [1998, 220, 23.35, 19.12],
            [1998, 222, 13.4, 9.72],
            [1998, 225, 37.5, 45],
            [1998, 226, 13.66, 15.31],
            [1998, 227, 120, 90],
            [1998, 228, 50, 60],
            [1998, 230, 30, 37.5],
            [1998, 231, 70, 70],
            [1998, 232, 70, 70],
            [1998, 233, 70, 70],
            [1998, 234, 50, 60],
            [1998, 235, 70, 70],
            [1998, 236, 70, 70],
            [1998, 237, 10.83, 7.57],
            [1998, 239, 57.35, 74.71],
            [1998, 240, 120, 90],
            [1998, 241, 70, 70],
            [1998, 242, 164.4, 59.03],
            [1998, 243, 118.04, 58],
            [1998, 244, 120, 90],
            [1998, 245, 120, 90],
            [1998, 246, 60.21, 33.65],
            [1998, 247, 120, 90],
            [1998, 248, 60.9, 49.22],
            [1998, 249, 70, 70],
            [1998, 250, 50, 60],
            [1998, 253, 120, 90],
            [1998, 256, 50, 60],
            [1998, 257, 120, 90],
            [1998, 260, 70, 70],
            [1998, 264, 50, 60],
            [1998, 265, 120, 90],
            [1998, 267, 120, 90],
            [1998, 268, 35.02, 25.49],
            [1998, 269, 120, 90],
            [1998, 270, 102.9, 57.89],
            [1998, 272, 120, 90],
            [1998, 273, 30, 45],
            [1998, 275, 40, 50],
            [1998, 282, 70, 70],
            [1998, 283, 35.02, 25.49],
            [1998, 284, 70, 70],
            [1998, 285, 62.31, 50.39],
            [1998, 286, 33.37, 83.43],
            [1998, 287, 40, 37.5],
            [1998, 289, 120, 90],
            [1998, 291, 70, 70],
            [1998, 292, 50, 60],
            [1998, 294, 118.68, 38.52],
            [1998, 295, 120, 90],
            [1998, 296, 70, 70],
            [1998, 297, 35.02, 25.49],
            [1998, 298, 70, 70],
            [1998, 299, 56.16, 71.39],
            [1998, 302, 120, 90],
            [1998, 303, 60.81, 38.31],
            [1998, 305, 21.98, 26],
            [1998, 306, 53.16, 39.53],
            [1998, 307, 120, 90],
            [1998, 308, 22.69, 32.81],
            [1998, 309, 35.02, 25.49],
            [1998, 310, 20.76, 23.58],
            [1998, 311, 70, 70],
            [1998, 312, 98.14, 57.65],
            [1998, 313, 50, 60],
            [1998, 314, 28.98, 30.23],
            [1998, 315, 120, 90],
            [1998, 317, 34.9, 28.91],
            [1998, 320, 120, 90],
            [1998, 321, 120, 90],
            [1998, 322, 120, 90],
            [1998, 324, 37.5, 45],
            [1998, 325, 120, 90],
            [1998, 326, 28.63, 19.82],
            [1998, 327, 120, 90],
            [1998, 328, 70, 70],
            [1998, 329, 70, 70],
            [1998, 330, 24.63, 27.62],
            [1998, 332, 101.6, 71.83],
            [1998, 333, 120, 90],
            [1998, 334, 14.71, 16.26],
            [1998, 337, 19.61, 30.02],
            [1998, 339, 74, 62.86],
            [1998, 340, 120, 90],
            [1998, 342, 70, 70],
            [1998, 343, 120, 90],
            [1998, 344, 89.38, 44.91],
            [1998, 346, 120, 90],
            [1998, 347, 120, 90],
            [1998, 348, 120, 90],
            [1998, 350, 70, 70],
            [1998, 351, 70, 70],
            [1998, 353, 20.67, 13.88],
            [1998, 354, 37.5, 45],
            [1998, 355, 70, 70],
            [1998, 356, 120, 90],
            [1998, 358, 32.24, 21.39],
            [1998, 361, 41.38, 37.74],
            [1998, 362, 50, 60],
            [1998, 365, 120, 90],
            [1998, 367, 50, 60],
            [1998, 368, 50, 60],
            [1998, 369, 6.34, 5.27],
            [1998, 370, 70, 70],
            [1998, 371, 120, 90],
            [1998, 372, 25.28, 18],
            [1998, 374, 50, 60],
            [1998, 376, 22.12, 15.98],
            [1998, 377, 40, 50],
            [1998, 378, 31.66, 30.53],
            [1998, 379, 11.67, 16.73],
            [1998, 382, 120, 90],
            [1998, 383, 70, 70],
            [1998, 385, 120, 90],
            [1998, 386, 50, 60],
            [1998, 387, 50, 60],
            [1998, 389, 37.5, 45],
            [1998, 390, 70, 70],
            [1998, 391, 70, 70],
            [1998, 392, 72.06, 47.49],
            [1998, 394, 50, 60],
            [1998, 396, 120, 90],
            [1998, 398, 70, 70],
            [1998, 399, 70, 70],
            [1998, 400, 50, 60],
            [1998, 401, 70, 70],
            [1998, 402, 120, 90],
            [1998, 403, 25.72, 27.84],
            [1998, 405, 70, 70],
            [1998, 406, 120, 90],
            [1998, 407, 50, 60],
            [1998, 409, 50, 60],
            [1998, 411, 120, 90],
            [1998, 412, 120, 90],
            [1998, 413, 30, 45],
            [1998, 415, 120, 90],
            [1998, 416, 50, 60],
            [1998, 418, 37.33, 36.38],
            [1998, 419, 120, 90],
            [1998, 422, 35.02, 25.49],
            [1998, 424, 32.02, 28.67],
            [1998, 425, 12.16, 14.12],
            [1998, 426, 35.02, 25.49],
            [1998, 427, 16, 20],
            [1998, 428, 13.52, 12.14],
            [1998, 429, 70, 70],
            [1998, 430, 50, 60],
            [1998, 432, 60.55, 31.38],
            [1998, 434, 70, 70],
            [1998, 436, 70, 70],
            [1998, 437, 16, 20],
            [1998, 439, 70, 70],
            [1998, 443, 120, 90],
            [1998, 444, 20.67, 13.88],
            [1998, 445, 120, 90],
            [1998, 446, 70, 70],
            [1998, 450, 120, 90],
            [1998, 451, 50, 60],
            [1998, 452, 120, 90],
            [1998, 453, 70, 70],
            [1998, 454, 120, 90],
            [1998, 455, 71.93, 65.93],
            [1998, 457, 50, 60],
            [1998, 458, 70, 70],
            [1998, 459, 120, 90],
            [1998, 460, 50, 60],
            [1998, 461, 50, 60],
            [1998, 463, 14.85, 9.88],
            [1998, 464, 21.08, 14.31],
            [1998, 465, 50, 60],
            [1998, 466, 120, 90],
            [1998, 467, 35.02, 25.49],
            [1998, 468, 120, 90],
            [1998, 469, 120, 90],
            [1998, 470, 35.02, 25.49],
            [1998, 471, 29.42, 44.44],
            [1998, 473, 120, 90],
            [1998, 474, 70, 70],
            [1998, 476, 120, 90],
            [1998, 477, 120, 90],
            [1998, 478, 120, 90],
            [1998, 479, 70, 70],
            [1998, 480, 70, 70],
            [1998, 481, 70, 70],
            [1998, 482, 70, 70],
            [1998, 484, 70, 70],
            [1998, 485, 120, 90],
            [1998, 486, 50, 60],
            [1998, 487, 22.74, 35.74],
            [1998, 488, 70, 70],
            [1998, 490, 70, 70],
            [1998, 493, 120, 90],
            [1998, 494, 120, 90],
            [1998, 495, 120, 90],
            [1998, 496, 70, 70],
            [1998, 497, 20.34, 27.7],
            [1998, 498, 50, 60],
            [1998, 500, 70, 70],
            [1998, 501, 70, 70],
            [1998, 503, 70, 70],
            [1998, 504, 14.4, 17.19],
            [1998, 505, 24.91, 27.22],
            [1998, 507, 120, 90],
            [1998, 508, 70, 70],
            [1998, 509, 5.13, 4.64],
            [1998, 510, 50, 60],
            [1998, 512, 40, 50],
            [1998, 513, 70, 70],
            [1998, 515, 120, 90],
            [1998, 518, 120, 90],
            [1998, 519, 26.44, 21.57],
            [1998, 520, 120, 90],
            [1998, 521, 120, 90],
            [1998, 522, 70, 70],
            [1998, 523, 120, 90],
            [1998, 524, 70, 70],
            [1998, 525, 120, 90],
            [1998, 526, 50, 60],
            [1998, 527, 70, 70],
            [1998, 528, 50, 60],
            [1998, 531, 10.37, 9.91],
            [1998, 532, 50, 60],
            [1998, 534, 50, 60],
            [1998, 535, 40, 50],
            [1998, 536, 18.74, 29.58],
            [1998, 537, 70, 70],
            [1998, 540, 70, 70],
            [1998, 541, 61.04, 50.11],
            [1998, 543, 120, 90],
            [1998, 545, 35.62, 43.31],
            [1998, 547, 15, 25],
            [1998, 548, 120, 90],
            [1998, 549, 120, 90],
            [1998, 550, 70, 70],
            [1998, 551, 120, 90],
            [1998, 553, 120, 90],
            [1998, 554, 15, 25],
            [1998, 555, 120, 90],
            [1998, 556, 120, 90],
            [1998, 557, 40, 50],
            [1998, 558, 120, 90],
            [1998, 559, 70, 70],
            [1998, 561, 120, 90],
            [1998, 563, 70, 70],
            [1998, 564, 12.02, 6.99],
            [1998, 565, 30, 45],
            [1998, 568, 44.41, 35.25],
            [1998, 569, 106.46, 58.13],
            [1998, 570, 77.63, 49.89],
            [1998, 571, 70, 70],
            [1998, 572, 30, 45],
            [1998, 573, 34.75, 26.58],
            [1998, 574, 70, 70],
            [1998, 577, 32.7, 38.7],
            [1998, 579, 40, 50],
            [1998, 581, 30, 45],
            [1998, 582, 120, 90],
            [1998, 583, 70, 70],
            [1998, 584, 21.39, 10.39],
            [1998, 585, 70, 70],
            [1998, 586, 50, 60],
            [1998, 588, 70, 70],
            [1998, 589, 120, 90],
            [1998, 590, 70, 70],
            [1998, 591, 120, 90],
            [1998, 593, 70, 70],
            [1998, 594, 32.24, 21.39],
            [1998, 595, 62.54, 30.08],
            [1998, 596, 50, 60],
            [1998, 597, 70, 70],
            [1998, 599, 37.1, 32.34],
            [1998, 600, 120, 90],
            [1998, 601, 70, 70],
            [1998, 604, 120, 90],
            [1998, 606, 120, 90],
            [1998, 607, 50, 60],
            [1998, 608, 54.37, 25.93],
            [1998, 610, 50, 60],
            [1998, 611, 50, 60],
            [1998, 612, 70, 70],
            [1998, 614, 28.93, 29.68],
            [1998, 615, 120, 90],
            [1998, 616, 120, 90],
            [1998, 618, 30, 37.5],
            [1998, 619, 120, 90],
            [1998, 621, 120, 90],
            [1998, 623, 8.39, 6.11],
            [1998, 625, 51.68, 25.98],
            [1998, 626, 40, 50],
            [1998, 627, 50, 60],
            [1998, 628, 20.36, 23.58],
            [1998, 629, 120, 90],
            [1998, 630, 70, 70],
            [1998, 631, 43.54, 34.8],
            [1998, 633, 120, 90],
            [1998, 635, 120, 90],
            [1998, 636, 70, 70],
            [1998, 637, 7.01, 5.35],
            [1998, 639, 70, 70],
            [1998, 641, 120, 90],
            [1998, 645, 50, 60],
            [1998, 647, 70, 70],
            [1998, 648, 70, 70],
            [1998, 649, 70, 70],
            [1998, 650, 120, 90],
            [1998, 651, 120, 90],
            [1998, 652, 70, 70],
            [1998, 653, 70, 70],
            [1998, 654, 120, 90],
            [1998, 656, 120, 90],
            [1998, 657, 120, 90],
            [1998, 659, 9.95, 8.02],
            [1998, 660, 24.24, 22.96],
            [1998, 662, 120, 90],
            [1998, 663, 120, 90],
            [1998, 664, 70, 70],
            [1998, 665, 120, 90],
            [1998, 666, 120, 90],
            [1998, 669, 50, 60],
            [1998, 670, 70, 70],
            [1998, 672, 70, 70],
            [1998, 673, 120, 90],
            [1998, 675, 70, 70],
            [1998, 678, 47.55, 39.99],
            [1998, 679, 120, 90],
            [1998, 680, 11.71, 8.44],
            [1998, 681, 32.24, 21.39],
            [1998, 682, 8.1, 6.18],
            [1998, 683, 16.28, 9.76],
            [1998, 686, 50, 60],
            [1998, 687, 120, 90],
            [1998, 688, 120, 90],
            [1998, 690, 50, 60],
            [1998, 691, 18.17, 15.1],
            [1998, 692, 32.24, 21.39],
            [1998, 693, 70, 70],
            [1998, 694, 50, 60],
            [1998, 695, 74.53, 49.3],
            [1998, 697, 120, 90],
            [1998, 698, 70, 70],
            [1998, 700, 70, 70],
            [1998, 701, 120, 90],
            [1998, 702, 70, 70],
            [1998, 703, 70, 70],
            [1998, 704, 55.7, 36.5],
            [1998, 705, 40, 50],
            [1998, 706, 70, 70],
            [1998, 708, 70, 70],
            [1998, 709, 32.88, 46.39],
            [1998, 710, 120, 90],
            [1998, 711, 50, 60],
            [1998, 712, 120, 90],
            [1998, 714, 50, 60],
            [1998, 715, 120, 90],
            [1998, 716, 70, 70],
            [1998, 717, 36.27, 32.74],
            [1998, 718, 70, 70],
            [1998, 719, 120, 90],
            [1998, 720, 87.15, 35.16],
            [1998, 721, 50, 60],
            [1998, 722, 120, 90],
            [1998, 723, 50, 60],
            [1998, 724, 29.85, 64.97],
            [1998, 727, 50, 45],
            [1998, 730, 35.02, 25.49],
            [1998, 731, 50, 60],
            [1998, 732, 120, 90],
            [1998, 734, 30, 45],
            [1998, 736, 70, 70],
            [1998, 737, 70, 70],
            [1998, 738, 120, 90],
            [1998, 740, 120, 90],
            [1998, 741, 120, 90],
            [1998, 742, 40, 50],
            [1998, 745, 120, 90],
            [1998, 746, 40, 50],
            [1998, 747, 50, 60],
            [1998, 748, 70, 70],
            [1998, 749, 50, 60],
            [1998, 750, 133.42, 46.75],
            [1998, 751, 50, 60],
            [1998, 753, 50, 60],
            [1998, 754, 36.5, 31.71],
            [1998, 756, 70, 70],
            [1998, 759, 70, 70],
            [1998, 762, 70, 70],
            [1998, 763, 70, 70],
            [1998, 766, 120, 90],
            [1998, 767, 70, 70],
            [1998, 769, 120, 90],
            [1998, 771, 120, 90],
            [1998, 772, 70, 70],
            [1998, 773, 64.93, 30.4],
            [1998, 774, 120, 90],
            [1998, 775, 70, 70],
            [1998, 776, 120, 90],
            [1998, 778, 120, 90],
            [1998, 779, 50, 60],
            [1998, 781, 71.84, 33.52],
            [1998, 782, 120, 90],
            [1998, 783, 50, 45],
            [1998, 784, 50, 60],
            [1998, 785, 120, 90],
            [1998, 787, 70, 70],
            [1998, 789, 70, 70],
            [1998, 790, 120, 90],
            [1998, 795, 120, 90],
            [1998, 796, 70, 70],
            [1998, 799, 50, 60],
            [1998, 801, 35.37, 49.96],
            [1998, 802, 120, 90],
            [1998, 803, 70, 70],
            [1998, 804, 120, 90],
            [1998, 805, 13.65, 18.71],
            [1998, 806, 120, 90],
            [1998, 807, 30, 45],
            [1998, 811, 120, 90],
            [1998, 812, 50, 60],
            [1998, 813, 15.18, 11.6],
            [1998, 814, 120, 90],
            [1998, 815, 120, 90],
            [1998, 818, 70, 70],
            [1998, 819, 120, 90],
            [1998, 820, 120, 90],
            [1998, 821, 24.1, 26.31],
            [1998, 822, 40, 50],
            [1998, 823, 120, 90],
            [1998, 824, 120, 90],
            [1998, 825, 70, 70],
            [1998, 826, 17.52, 8.25],
            [1998, 827, 70, 70],
            [1998, 829, 11.79, 8.2],
            [1998, 830, 120, 90],
            [1998, 831, 120, 90],
            [1998, 833, 120, 90],
            [1998, 834, 70, 70],
            [1998, 835, 69.3, 61.77],
            [1998, 836, 120, 90],
            [1998, 837, 70, 70],
            [1998, 840, 70, 70],
            [1998, 842, 50, 60],
            [1998, 843, 50.2, 42.1],
            [1998, 844, 117.83, 54.95],
            [1998, 845, 79.17, 68.36],
            [1998, 846, 120, 90],
            [1998, 847, 32.24, 21.39],
            [1998, 848, 9.12, 11.53],
            [1998, 850, 40, 50],
            [1998, 851, 18.96, 12.46],
            [1998, 852, 70, 70],
            [1998, 855, 9.81, 9.88],
            [1998, 857, 120, 90],
            [1998, 860, 70, 70],
            [1998, 863, 40, 50],
            [1998, 865, 70, 70],
            [1998, 867, 120, 90],
            [1998, 869, 70, 70],
            [1998, 871, 16.44, 22.77],
            [1998, 872, 70, 70],
            [1998, 873, 70, 70],
            [1998, 875, 120, 90],
            [1998, 876, 120, 90],
            [1998, 877, 120, 90],
            [1998, 878, 5.59, 4.6],
            [1998, 881, 35.02, 25.49],
            [1998, 882, 50, 60],
            [1998, 883, 120, 90],
            [1998, 884, 70, 70],
            [1998, 885, 70, 70],
            [1998, 886, 120, 90],
            [1998, 889, 11.95, 11.69],
            [1998, 890, 62.93, 34.45],
            [1998, 891, 120, 90],
            [1998, 892, 120, 90],
            [1998, 894, 23.13, 17.71],
            [1998, 895, 120, 90],
            [1998, 896, 70, 70],
            [1998, 897, 13.97, 22.37],
            [1998, 899, 120, 90],
            [1998, 900, 6.81, 4.72],
            [1998, 901, 120, 90],
            [1998, 905, 120, 90],
            [1998, 909, 120, 90],
            [1998, 910, 17.59, 7.29],
            [1998, 913, 40, 50],
            [1998, 914, 120, 90],
            [1998, 915, 38.46, 49.72],
            [1998, 916, 40, 50],
            [1998, 917, 30, 45],
            [1998, 918, 120, 90],
            [1998, 919, 120, 90],
            [1998, 922, 16, 20],
            [1998, 924, 11.58, 10.56],
            [1998, 926, 40.84, 38.58],
            [1998, 927, 70, 70],
            [1998, 928, 120, 90],
            [1998, 929, 120, 90],
            [1998, 930, 50, 60],
            [1998, 931, 70, 70],
            [1998, 934, 37.5, 45],
            [1998, 935, 120, 90],
            [1998, 936, 50, 60],
            [1998, 937, 120, 90],
            [1998, 938, 70, 70],
            [1998, 940, 70, 70],
            [1998, 941, 70, 70],
            [1998, 942, 70, 70],
            [1998, 944, 96.61, 70.21],
            [1998, 945, 50, 60],
            [1998, 946, 50, 60],
            [1998, 948, 70, 70],
            [1998, 949, 79.45, 48.51],
            [1998, 950, 13.52, 21.99],
            [1998, 952, 16.43, 13.85],
            [1998, 953, 50, 60],
            [1998, 954, 120, 90],
            [1998, 955, 120, 90],
            [1998, 957, 120, 90],
            [1998, 958, 50, 60],
            [1998, 960, 50, 60],
            [1998, 961, 120, 90],
            [1998, 963, 32.24, 21.39],
            [1998, 964, 50, 60],
            [1998, 965, 50, 60],
            [1998, 966, 7.47, 7.71],
            [1998, 969, 70, 70],
            [1998, 970, 20.67, 13.88],
            [1998, 971, 35.72, 14.91],
            [1998, 972, 35.77, 19.67],
            [1998, 974, 30, 45],
            [1998, 976, 8.35, 13.66],
            [1998, 977, 17.03, 11.19],
            [1998, 978, 70, 70],
            [1998, 979, 36.64, 34.46],
            [1998, 980, 70, 70],
            [1998, 981, 120, 90],
            [1998, 982, 120, 90],
            [1998, 983, 71.83, 43.14],
            [1998, 985, 194.37, 75.01],
            [1998, 986, 12.4, 12.01],
            [1998, 987, 35.02, 25.49],
            [1998, 988, 6.14, 5.32],
            [1998, 990, 71.86, 39.63],
            [1998, 991, 120, 90],
            [1998, 993, 120, 90],
            [1998, 994, 40, 50],
            [1998, 997, 120, 90],
            [1998, 998, 70, 70],
            [1998, 999, 120, 90],
            [1998, 1000, 50, 60],
            [1998, 1003, 8.24, 5.82],
            [1998, 1004, 70, 70],
            [1998, 1005, 17.62, 13.77],
            [1998, 1006, 120, 90],
            [1998, 1007, 40, 50],
            [1998, 1008, 37.5, 45],
            [1998, 1009, 120, 90],
            [1998, 1013, 120, 90],
            [1998, 1015, 70, 70],
            [1998, 1016, 14.94, 23.74],
            [1998, 1017, 50, 60],
            [1998, 1018, 120, 90],
            [1998, 1020, 32.24, 21.39],
            [1998, 1021, 70, 70],
            [1998, 1022, 120, 90],
            [1998, 1023, 50, 60],
            [1998, 1025, 120, 90],
            [1998, 1027, 120, 90],
            [1998, 1028, 50, 60],
            [1998, 1029, 32.24, 21.39],
            [1998, 1030, 40, 50],
            [1998, 1032, 35.33, 27.71],
            [1998, 1033, 27.47, 30.75],
            [1998, 1034, 70, 70],
            [1998, 1036, 70, 70],
            [1998, 1038, 70, 70],
            [1998, 1039, 120, 90],
            [1998, 1042, 120, 90],
            [1998, 1043, 120, 90],
            [1998, 1044, 120, 90],
            [1998, 1045, 120, 90],
            [1998, 1046, 50, 60],
            [1998, 1047, 70, 70],
            [1998, 1048, 70, 70],
            [1998, 1050, 70, 70],
            [1998, 1051, 92.72, 35.97],
            [1998, 1052, 50, 60],
            [1998, 1053, 50, 60],
            [1998, 1054, 70, 70],
            [1998, 1056, 70, 70],
            [1998, 1057, 50, 60],
            [1998, 1058, 70, 70],
            [1998, 1059, 70, 70],
            [1998, 1061, 70, 70],
            [1998, 1062, 70, 70],
            [1998, 1063, 120, 90],
            [1998, 1064, 20.67, 13.88],
            [1998, 1065, 120, 90],
            [1998, 1067, 120, 90],
            [1998, 1069, 50, 60],
            [1998, 1070, 50, 60],
            [1998, 1071, 125.97, 49.26],
            [1998, 1073, 84.92, 72.24],
            [1998, 1075, 9.34, 8.91],
            [1998, 1077, 120, 90],
            [1998, 1078, 120, 90],
            [1998, 1080, 120, 90],
            [1998, 1081, 70, 70],
            [1998, 1082, 120, 90],
            [1998, 1084, 160.19, 70.76],
            [1998, 1087, 70, 70],
            [1998, 1090, 120, 90],
            [1998, 1091, 40, 50],
            [1998, 1092, 15, 25],
            [1998, 1093, 50, 60],
            [1998, 1094, 23.66, 23.15],
            [1998, 1095, 34.76, 26.62],
            [1998, 1096, 120, 90],
            [1998, 1097, 8.07, 10.33],
            [1998, 1099, 20.2, 20.63],
            [1998, 1100, 55.33, 47.25],
            [1998, 1102, 120, 90],
            [1998, 1104, 70, 70],
            [1998, 1106, 120, 90],
            [1998, 1108, 120, 90],
            [1998, 1109, 71.26, 34.85],
            [1998, 1110, 120, 90],
            [1998, 1111, 120, 90],
            [1998, 1113, 120, 90],
            [1998, 1114, 120, 90],
            [1998, 1117, 50, 60],
            [1998, 1118, 50, 60],
            [1998, 1119, 50, 60],
            [1998, 1120, 120, 90],
            [1998, 1121, 120, 90],
            [1998, 1122, 35.02, 25.49],
            [1998, 1124, 33.6, 22.42],
            [1998, 1125, 120, 90],
            [1998, 1126, 70, 70],
            [1998, 1127, 35.02, 25.49],
            [1998, 1128, 70, 70],
            [1998, 1129, 20.67, 13.88],
            [1998, 1130, 120, 90],
            [1998, 1131, 19.62, 27.9],
            [1998, 1132, 50, 60],
            [1998, 1136, 70, 70],
            [1998, 1137, 120, 90],
            [1998, 1138, 120, 90],
            [1998, 1139, 120, 90],
            [1998, 1140, 50, 45],
            [1998, 1141, 151.96, 55.04],
            [1998, 1142, 87.4, 44.91],
            [1998, 1144, 70.4, 75.66],
            [1998, 1145, 120, 90],
            [1998, 1147, 22.6, 14.7],
            [1998, 1149, 50, 60],
            [1998, 1150, 50, 60],
            [1998, 1152, 70, 70],
            [1998, 1153, 120, 90],
            [1998, 1154, 120, 90],
            [1998, 1155, 12.52, 12.5],
            [1998, 1156, 50, 60],
            [1998, 1157, 120, 90],
            [1998, 1158, 50, 60],
            [1998, 1159, 70, 70],
            [1998, 1161, 120, 90],
            [1998, 1163, 70, 70],
            [1998, 1164, 120, 90],
            [1998, 1165, 120, 90],
            [1998, 1167, 85.7, 63.16],
            [1998, 1168, 120, 90],
            [1998, 1169, 34.55, 69.22],
            [1998, 1170, 70, 70],
            [1998, 1171, 120, 90],
            [1998, 1172, 70, 70],
            [1998, 1173, 50, 60],
            [1998, 1174, 70, 70],
            [1998, 1175, 28.04, 39.32],
            [1998, 1176, 120, 90],
            [1998, 1177, 70, 70],
            [1998, 1178, 9.93, 8.3],
            [1998, 1180, 20.27, 16.1],
            [1998, 1181, 120, 90],
            [1998, 1186, 70, 70],
            [1998, 1187, 120, 90],
            [1998, 1188, 40, 50],
            [1998, 1189, 120, 90],
            [1998, 1190, 70, 70],
            [1998, 1191, 70, 70],
            [1998, 1194, 82.38, 42.91],
            [1998, 1195, 120, 90],
            [1998, 1198, 120, 90],
            [1998, 1199, 40, 50],
            [1998, 1200, 27.2, 13.54],
            [1998, 1202, 30, 45],
            [1998, 1203, 120, 90],
            [1998, 1204, 70, 70],
            [1998, 1205, 85.87, 50.11],
            [1998, 1206, 120, 90],
            [1998, 1207, 30, 45],
            [1998, 1209, 40, 50],
            [1998, 1210, 40, 37.5],
            [1998, 1211, 53.75, 32.19],
            [1998, 1212, 120, 90],
            [1998, 1213, 40, 50],
            [1998, 1214, 70, 70],
            [1998, 1216, 50, 60],
            [1998, 1217, 90.55, 46.37],
            [1998, 1219, 116.48, 55.12],
            [1998, 1221, 22.66, 24.86],
            [1998, 1223, 70, 70],
            [1998, 1224, 49.77, 79.26],
            [1998, 1225, 70, 70],
            [1998, 1226, 70, 70],
            [1998, 1227, 120, 90],
            [1998, 1228, 57.49, 37.38],
            [1998, 1230, 50, 60],
            [1998, 1233, 50, 60],
            [1998, 1234, 70, 70],
            [1998, 1235, 50, 60],
            [1998, 1236, 70, 70],
            [1998, 1237, 37.5, 45],
            [1998, 1238, 70, 70],
            [1998, 1239, 120, 90],
            [1998, 1240, 120, 90],
            [1998, 1244, 70, 70],
            [1998, 1245, 120, 90],
            [1998, 1246, 70, 70],
            [1998, 1247, 70, 70],
            [1998, 1250, 70, 70],
            [1998, 1251, 70, 70],
            [1998, 1253, 50, 60],
            [1998, 1254, 70, 70],
            [1998, 1255, 120, 90],
            [1998, 1257, 50, 60],
            [1998, 1259, 105.06, 30.34],
            [1998, 1260, 50, 60],
            [1998, 1262, 110.05, 49.65],
            [1998, 1263, 120, 90],
            [1998, 1264, 120, 90],
            [1998, 1265, 13.84, 11.71],
            [1998, 1266, 35.02, 25.49],
            [1998, 1268, 30.72, 32.5],
            [1998, 1269, 50, 60],
            [1998, 1271, 85.26, 44.5],
            [1998, 1272, 70, 70],
            [1998, 1275, 50, 60],
            [1998, 1276, 32.24, 21.39],
            [1998, 1278, 70, 70],
            [1998, 1280, 14.3, 8.12],
            [1998, 1281, 21.65, 27],
            [1998, 1282, 50, 60],
            [1998, 1286, 120, 90],
            [1998, 1287, 70, 70],
            [1998, 1288, 70, 70],
            [1998, 1290, 120, 90],
            [1998, 1291, 70, 70],
            [1998, 1292, 70, 70],
            [1998, 1293, 20, 25],
            [1998, 1295, 70, 70],
            [1998, 1298, 50, 60],
            [1998, 1299, 70, 70],
            [1998, 1300, 50, 60],
            [1998, 1301, 70, 70],
            [1998, 1302, 30, 45],
            [1998, 1303, 70, 70],
            [1998, 1305, 17.46, 22.11],
            [1998, 1306, 50, 60],
            [1998, 1308, 120, 90],
            [1998, 1312, 26.57, 15.77],
            [1998, 1313, 120, 90],
            [1998, 1314, 40, 50],
            [1998, 1315, 120, 90],
            [1998, 1317, 70, 70],
            [1998, 1318, 120, 90],
            [1998, 1319, 46.62, 28.16],
            [1998, 1320, 120, 90],
            [1998, 1321, 48.13, 28.8],
            [1998, 1323, 75.54, 72.3],
            [1998, 1324, 120, 90],
            [1998, 1325, 120, 90],
            [1998, 1326, 70, 70],
            [1998, 1327, 120, 90],
            [1998, 1328, 70, 70],
            [1998, 1329, 70, 70],
            [1998, 1331, 120, 90],
            [1998, 1332, 10.21, 7.08],
            [1998, 1333, 120, 90],
            [1998, 1334, 87.72, 70.36],
            [1998, 1335, 70, 70],
            [1998, 1337, 5.66, 6.03],
            [1998, 1338, 120, 90],
            [1998, 1339, 11.12, 9.1],
            [1998, 1340, 50, 60],
            [1998, 1341, 35.02, 25.49],
            [1998, 1342, 70, 70],
            [1998, 1345, 40, 50],
            [1998, 1346, 20.67, 13.88],
            [1998, 1349, 70, 70],
            [1998, 1350, 70, 70],
            [1998, 1351, 70, 70],
            [1998, 1352, 35.02, 25.49],
            [1998, 1353, 120, 90],
            [1998, 1355, 120, 90],
            [1998, 1357, 70, 70],
            [1998, 1358, 120, 90],
            [1998, 1359, 67.94, 52.51],
            [1998, 1360, 120, 90],
            [1998, 1361, 77.94, 60.66],
            [1998, 1363, 83.47, 31.82],
            [1998, 1367, 53.29, 36.48],
            [1998, 1370, 17.21, 28.49],
            [1998, 1371, 70, 70],
            [1998, 1372, 120, 90],
            [1998, 1375, 22.3, 23.87],
            [1998, 1376, 30, 37.5],
            [1998, 1378, 70, 70],
            [1998, 1379, 120, 90],
            [1998, 1380, 70, 70],
            [1998, 1381, 120, 90],
            [1998, 1382, 50, 60],
            [1998, 1383, 8.95, 7.72],
            [1998, 1385, 32.24, 21.39],
            [1998, 1387, 50, 60],
            [1998, 1388, 120, 90],
            [1998, 1391, 120, 90],
            [1998, 1392, 35.02, 25.49],
            [1998, 1393, 120, 90],
            [1998, 1395, 70, 70],
            [1998, 1396, 70, 70],
            [1998, 1398, 50, 60],
            [1998, 1399, 9.27, 9.03],
            [1998, 1402, 70, 70],
            [1998, 1404, 40, 50],
            [1998, 1405, 120, 90],
            [1998, 1406, 6.5, 5.37],
            [1998, 1410, 70, 70],
            [1998, 1411, 20.67, 13.88],
            [1998, 1415, 70, 70],
            [1998, 1417, 120, 90],
            [1998, 1420, 20, 24],
            [1998, 1421, 120, 90],
            [1998, 1422, 120, 90],
            [1998, 1424, 50, 60],
            [1998, 1425, 70, 70],
            [1998, 1426, 8.57, 6.77],
            [1998, 1427, 30, 45],
            [1998, 1428, 10.79, 6.72],
            [1998, 1431, 120, 90],
            [1998, 1432, 6.73, 7.01],
            [1998, 1434, 70, 70],
            [1998, 1436, 70, 70],
            [1998, 1438, 70, 70],
            [1998, 1439, 120, 90],
            [1998, 1440, 70, 70],
            [1998, 1441, 120, 90],
            [1998, 1442, 70, 70],
            [1998, 1443, 50, 60],
            [1998, 1444, 120, 90],
            [1998, 1445, 120, 90],
            [1998, 1448, 70, 70],
            [1998, 1449, 40, 50],
            [1998, 1450, 120, 90],
            [1998, 1451, 35.02, 25.49],
            [1998, 1453, 70, 70],
            [1998, 1454, 20.61, 20.28],
            [1998, 1456, 70, 70],
            [1998, 1459, 120, 90],
            [1998, 1460, 120, 90],
            [1998, 1461, 6.14, 6.98],
            [1998, 1464, 50, 60],
            [1998, 1465, 70, 70],
            [1998, 1466, 50, 60],
            [1998, 1467, 70, 70],
            [1998, 1469, 70, 70],
            [1998, 1470, 30, 45],
            [1998, 1471, 58.78, 40.42],
            [1998, 1472, 120, 90],
            [1998, 1473, 11.99, 10.02],
            [1998, 1474, 70, 70],
            [1998, 1475, 93.38, 40.44],
            [1998, 1476, 39.76, 77.7],
            [1998, 1477, 104.5, 55.33],
            [1998, 1478, 17.41, 11.68],
            [1998, 1479, 40, 50],
            [1998, 1481, 70, 70],
            [1998, 1482, 70, 70],
            [1998, 1483, 70, 70],
            [1998, 1484, 24.92, 66.54],
            [1998, 1485, 120, 90],
            [1998, 1486, 73.81, 56.6],
            [1998, 1487, 120, 90],
            [1998, 1488, 120, 90],
            [1998, 1490, 35.69, 22.38],
            [1998, 1491, 13.55, 10.7],
            [1998, 1493, 40.01, 20.74],
            [1998, 1503, 120, 90],
            [1998, 1505, 120, 90],
            [1998, 1506, 120, 90],
            [1998, 1507, 70, 70],
            [1998, 1508, 21.47, 18.5],
            [1998, 1509, 120, 90],
            [1998, 1510, 31.13, 26.62],
            [1998, 1511, 21.14, 10.89],
            [1998, 1512, 20, 24],
            [1998, 1513, 32.24, 21.39],
            [1998, 1514, 70, 70],
            [1998, 1515, 30, 45],
            [1998, 1516, 70, 70],
            [1998, 1517, 120, 90],
            [1998, 1518, 120, 90],
            [1998, 1519, 120, 90],
            [1998, 1520, 70, 70],
            [1998, 1521, 120, 90],
            [1998, 1522, 35.03, 33.83],
            [1998, 1523, 120, 90],
            [1998, 1524, 120, 90],
            [1998, 1525, 30, 37.5],
            [1998, 1526, 70, 70],
            [1998, 1527, 17.34, 33.26],
            [1998, 1530, 70, 70],
            [1998, 1533, 70, 70],
            [1998, 1534, 10.96, 7.99],
            [1998, 1536, 30.57, 20.35],
            [1998, 1537, 35.55, 43.28],
            [1998, 1538, 120, 90],
            [1998, 1539, 40, 50],
            [1998, 1540, 40, 50],
            [1998, 1541, 70, 70],
            [1998, 1542, 50, 60],
            [1998, 1544, 120, 90],
            [1998, 1546, 70, 70],
            [1998, 1547, 70, 70],
            [1998, 1548, 120, 90],
            [1998, 1549, 70, 70],
            [1998, 1550, 120, 90],
            [1998, 1552, 30, 45],
            [1998, 1553, 70.57, 50.89],
            [1998, 1555, 30, 37.5],
            [1998, 1556, 27.63, 11.76],
            [1998, 1557, 70, 70],
            [1998, 1559, 50, 60],
            [1998, 1560, 70, 70],
            [1998, 1561, 30.82, 30.34],
            [1998, 1562, 97.79, 51.18],
            [1998, 1565, 120, 90],
            [1998, 1567, 120, 90],
            [1998, 1568, 17.56, 11.49],
            [1998, 1571, 70, 70],
            [1998, 1572, 120, 90],
            [1998, 1574, 50, 60],
            [1998, 1575, 124.82, 81.48],
            [1998, 1576, 50, 60],
            [1998, 1577, 50, 60],
            [1998, 1578, 120, 90],
            [1998, 1580, 50, 60],
            [1998, 1581, 19.75, 12.12],
            [1998, 1582, 22.41, 22.97],
            [1998, 1583, 120, 90],
            [1998, 1585, 70, 70],
            [1998, 1587, 70, 70],
            [1998, 1589, 70, 70],
            [1998, 1590, 70, 70],
            [1998, 1591, 70, 70],
            [1998, 1592, 32.24, 21.39],
            [1998, 1593, 25.91, 24.87],
            [1998, 1595, 70, 70],
            [1998, 1596, 120, 90],
            [1998, 1597, 50, 60],
            [1998, 1598, 19.88, 13.26],
            [1998, 1600, 120, 90],
            [1998, 1601, 70, 70],
            [1998, 1602, 120, 90],
            [1998, 1603, 50, 60],
            [1998, 1605, 50, 60],
            [1998, 1606, 120, 90],
            [1998, 1607, 70, 70],
            [1998, 1609, 120, 90],
            [1998, 1610, 18.25, 11.14],
            [1998, 1612, 40, 50],
            [1998, 1614, 70, 70],
            [1998, 1615, 120, 90],
            [1998, 1617, 120, 90],
            [1998, 1619, 120, 90],
            [1998, 1620, 50, 60],
            [1998, 1621, 70, 70],
            [1998, 1623, 50, 60],
            [1998, 1624, 35.02, 25.49],
            [1998, 1625, 70, 70],
            [1998, 1626, 70, 70],
            [1998, 1627, 70, 70],
            [1998, 1628, 50, 60],
            [1998, 1629, 16, 20],
            [1998, 1630, 70, 70],
            [1998, 1632, 13.48, 10.49],
            [1998, 1634, 70, 70],
            [1998, 1635, 16.96, 17.21],
            [1998, 1637, 120, 90],
            [1998, 1638, 70, 70],
            [1998, 1639, 70, 70],
            [1998, 1640, 70, 70],
            [1998, 1641, 70, 70],
            [1998, 1643, 18.14, 22.93],
            [1998, 1644, 48.21, 38.33],
            [1998, 1645, 70, 70],
            [1998, 1647, 70, 70],
            [1998, 1648, 120, 90],
            [1998, 1649, 120, 90],
            [1998, 1650, 70, 70],
            [1998, 1651, 120, 90],
            [1998, 1652, 70, 70],
            [1998, 1653, 120, 90],
            [1998, 1654, 70, 70],
            [1998, 1656, 8.81, 6.01],
            [1998, 1657, 70, 70],
            [1998, 1658, 120, 90],
            [1998, 1659, 38.85, 38.2],
            [1998, 1660, 134.83, 48.67],
            [1998, 1661, 32.24, 21.39],
            [1998, 1662, 70, 70],
            [1998, 1663, 28.45, 30.94],
            [1998, 1664, 70, 70],
            [1998, 1665, 50, 60],
            [1998, 1666, 6.17, 5.14],
            [1998, 1667, 120, 90],
            [1998, 1668, 50, 60],
            [1998, 1669, 120, 90],
            [1998, 1671, 120, 90],
            [1998, 1672, 20.29, 61.88],
            [1998, 1673, 40.58, 28.22],
            [1998, 1674, 70, 70],
            [1998, 1675, 11.86, 16.02],
            [1998, 1679, 40, 50],
            [1998, 1680, 55.76, 53.89],
            [1998, 1681, 120, 90],
            [1998, 1684, 120, 90],
            [1998, 1685, 37.5, 45],
            [1998, 1686, 120, 90],
            [1998, 1688, 25.71, 34.65],
            [1998, 1689, 120, 90],
            [1998, 1690, 120, 90],
            [1998, 1692, 120, 90],
            [1998, 1694, 120, 90],
            [1998, 1695, 120, 90],
            [1998, 1697, 70, 70],
            [1998, 1701, 70, 70],
            [1998, 1702, 70, 70],
            [1998, 1704, 50, 60],
            [1998, 1705, 70, 70],
            [1998, 1706, 50, 60],
            [1998, 1707, 120, 90],
            [1998, 1709, 30, 45],
            [1998, 1711, 70, 70],
            [1998, 1713, 50, 60],
            [1998, 1715, 120, 90],
            [1998, 1717, 70, 70],
            [1998, 1720, 4.58, 3.57],
            [1998, 1722, 120, 90],
            [1998, 1724, 31.04, 29.1],
            [1998, 1726, 120, 90],
            [1998, 1728, 120, 90],
            [1998, 1729, 36.89, 30.28],
            [1998, 1730, 70, 70],
            [1998, 1734, 22.97, 21.82],
            [1998, 1737, 70, 70],
            [1998, 1739, 32.24, 21.39],
            [1998, 1740, 50, 60],
            [1998, 1741, 70, 70],
            [1998, 1742, 120, 90],
            [1998, 1743, 70, 70],
            [1998, 1744, 48.44, 41.98],
            [1998, 1745, 55.29, 18.61],
            [1998, 1746, 70, 70],
            [1998, 1748, 109.42, 45.47],
            [1998, 1749, 50, 60],
            [1998, 1750, 70, 70],
            [1998, 1752, 120, 90],
            [1998, 1753, 25.17, 15.07],
            [1998, 1754, 120, 90],
            [1998, 1756, 47.81, 29.86],
            [1998, 1757, 70, 70],
            [1998, 1758, 32.24, 21.39],
            [1998, 1760, 70, 70],
            [1998, 1763, 43.44, 47.84],
            [1998, 1764, 70, 70],
            [1998, 1765, 50, 60],
            [1998, 1766, 120, 90],
            [1998, 1767, 120, 90],
            [1998, 1769, 70, 70],
            [1998, 1770, 70, 70],
            [1998, 1771, 19.39, 23.78],
            [1998, 1772, 25.48, 41.18],
            [1998, 1773, 50, 60],
            [1998, 1774, 17.87, 21.37],
            [1998, 1775, 70, 70],
            [1998, 1776, 35.63, 37.22],
            [1998, 1778, 120, 90],
            [1998, 1779, 70, 70],
            [1998, 1780, 37.79, 33.06],
            [1998, 1781, 113.83, 52.58],
            [1998, 1783, 120, 90],
            [1998, 1784, 70, 70],
            [1998, 1785, 120, 90],
            [1998, 1786, 120, 90],
            [1998, 1787, 120, 90],
            [1998, 1788, 120, 90],
            [1998, 1789, 120, 90],
            [1998, 1790, 48.09, 38.27],
            [1998, 1792, 25.36, 24.69],
            [1998, 1793, 70, 70],
            [1998, 1794, 70, 70],
            [1998, 1795, 9.04, 6.4],
            [1998, 1796, 50, 60],
            [1998, 1797, 70, 70],
            [1998, 1798, 70, 70],
            [1998, 1799, 4.8, 5.01],
            [1998, 1800, 15.42, 8.83],
            [1998, 1801, 70, 70],
            [1998, 1802, 120, 90],
            [1998, 1803, 120, 90],
            [1998, 1804, 105.47, 52.76],
            [1998, 1805, 50, 60],
            [1998, 1806, 120, 90],
            [1998, 1808, 70, 70],
            [1998, 1809, 120, 90],
            [1998, 1810, 50, 60],
            [1998, 1811, 120, 90],
            [1998, 1812, 43.07, 42.87],
            [1998, 1814, 40, 50],
            [1998, 1815, 17.45, 9.13],
            [1998, 1816, 83.79, 61.8],
            [1998, 1817, 70, 70],
            [1998, 1818, 27.25, 18.05],
            [1998, 1819, 70, 70],
            [1998, 1822, 70, 70],
            [1998, 1824, 70, 70],
            [1998, 1825, 50.4, 52.17],
            [1998, 1827, 70, 70],
            [1998, 1829, 120, 90],
            [1998, 1832, 70, 70],
            [1998, 1833, 120, 90],
            [1998, 1834, 120, 90],
            [1998, 1837, 120, 90],
            [1998, 1839, 70, 70],
            [1998, 1841, 70, 70],
            [1998, 1843, 14.6, 13.38],
            [1998, 1844, 30, 45],
            [1998, 1845, 20.52, 19.97],
            [1998, 1846, 120, 90],
            [1998, 1847, 50, 60],
            [1998, 1848, 66.18, 60.25],
            [1998, 1849, 120, 90],
            [1998, 1850, 8.32, 6.64],
            [1998, 1851, 120, 90],
            [1998, 1852, 70, 70],
            [1998, 1853, 120, 90],
            [1998, 1855, 120, 90],
            [1998, 1856, 30, 45],
            [1998, 1857, 70, 70],
            [1998, 1859, 120, 90],
            [1998, 1860, 120, 90],
            [1998, 1863, 18.35, 13.66],
            [1998, 1864, 120, 90],
            [1998, 1866, 70, 70],
            [1998, 1868, 35.02, 25.49],
            [1998, 1869, 40, 37.5],
            [1998, 1870, 32.24, 21.39],
            [1998, 1873, 70, 70],
            [1998, 1875, 50, 60],
            [1998, 1876, 35.35, 35.59],
            [1998, 1877, 120, 90],
            [1998, 1879, 43.02, 40.39],
            [1998, 1881, 50, 60],
            [1998, 1882, 104.15, 43.17],
            [1998, 1883, 120, 90],
            [1998, 1884, 50, 60],
            [1998, 1885, 70, 70],
            [1998, 1886, 50, 60],
            [1998, 1887, 70, 70],
            [1998, 1888, 120, 90],
            [1998, 1889, 70, 70],
            [1998, 1890, 120, 90],
            [1998, 1891, 50, 60],
            [1998, 1892, 70, 70],
            [1998, 1894, 50, 60],
            [1998, 1895, 50, 60],
            [1998, 1896, 120, 90],
            [1998, 1897, 18.91, 17.19],
            [1998, 1898, 12.47, 7.24],
            [1998, 1899, 70, 70],
            [1998, 1900, 20, 25],
            [1998, 1901, 27.52, 29.78],
            [1998, 1903, 70, 70],
            [1998, 1904, 120, 90],
            [1998, 1906, 20.9, 12.43],
            [1998, 1909, 120, 90],
            [1998, 1910, 120, 90],
            [1998, 1912, 70, 70],
            [1998, 1914, 120, 90],
            [1998, 1915, 120, 90],
            [1998, 1916, 120, 90],
            [1998, 1917, 120, 90],
            [1998, 1919, 120, 90],
            [1998, 1920, 70, 70],
            [1998, 1921, 30, 45],
            [1998, 1924, 120, 90],
            [1998, 1925, 59.83, 43.65],
            [1998, 1928, 120, 90],
            [1998, 1929, 6.5, 4.93],
            [1998, 1930, 10.76, 8.15],
            [1998, 1933, 12.42, 12.39],
            [1998, 1937, 70, 70],
            [1998, 1938, 120, 90],
            [1998, 1940, 120, 90],
            [1998, 1941, 120, 90],
            [1998, 1945, 45.16, 27.63],
            [1998, 1946, 70, 70],
            [1998, 1948, 120, 90],
            [1998, 1949, 120, 90],
            [1998, 1950, 120, 90],
            [1998, 1952, 92.32, 71.14],
            [1998, 1955, 70, 70],
            [1998, 1956, 40, 50],
            [1998, 1957, 70, 70],
            [1998, 1959, 120, 90],
            [1998, 1961, 120, 90],
            [1998, 1962, 40, 50],
            [1998, 1963, 7.89, 5.56],
            [1998, 1964, 50, 60],
            [1998, 1965, 50, 60],
            [1998, 1967, 32.24, 21.39],
            [1998, 1969, 70, 70],
            [1998, 1972, 11.39, 7.39],
            [1998, 1974, 70, 70],
            [1998, 1976, 14.59, 10.01],
            [1998, 1978, 120, 90],
            [1998, 1979, 50, 60],
            [1998, 1980, 120, 90],
            [1998, 1981, 70, 70],
            [1998, 1982, 70, 70],
            [1998, 1984, 70, 70],
            [1998, 1986, 120, 90],
            [1998, 1989, 50, 60],
            [1998, 1991, 18.88, 13.68],
            [1998, 1992, 50, 60],
            [1998, 1995, 39.6, 34.17],
            [1998, 1996, 120, 90],
            [1998, 1997, 120, 90],
            [1998, 1998, 8.45, 8.42],
            [1998, 2000, 32.3, 7.9],
            [1998, 2001, 120, 90],
            [1998, 2002, 50, 60],
            [1998, 2004, 8.73, 6.08],
            [1998, 2005, 50, 60],
            [1998, 2006, 34.13, 29.15],
            [1998, 2007, 70, 70],
            [1998, 2008, 70, 70],
            [1998, 2009, 120, 90],
            [1998, 2011, 120, 90],
            [1998, 2012, 70, 70],
            [1998, 2013, 70, 70],
            [1998, 2015, 50, 60],
            [1998, 2016, 50, 60],
            [1998, 2017, 40, 37.5],
            [1998, 2018, 70, 70],
            [1998, 2020, 32.24, 21.39],
            [1998, 2021, 91.08, 54.55],
            [1998, 2022, 120, 90],
            [1998, 2023, 12.93, 13.98],
            [1998, 2025, 47.08, 35.03],
            [1998, 2026, 122.65, 67.48],
            [1998, 2027, 120, 90],
            [1998, 2028, 120, 90],
            [1998, 2029, 30.65, 35.97],
            [1998, 2030, 50, 60],
            [1998, 2031, 6.44, 5.98],
            [1998, 2032, 120, 90],
            [1998, 2034, 120, 90],
            [1998, 2035, 70, 70],
            [1998, 2038, 120, 90],
            [1998, 2040, 120, 90],
            [1998, 2041, 120, 90],
            [1998, 2042, 25.88, 9.57],
            [1998, 2043, 70, 70],
            [1998, 2044, 120, 90],
            [1998, 2046, 50, 60],
            [1998, 2048, 70, 70],
            [1998, 2049, 70, 70],
            [1998, 2050, 70, 70],
            [1998, 2051, 120, 90],
            [1998, 2052, 120, 90],
            [1998, 2053, 70, 70],
            [1998, 2054, 40, 50],
            [1998, 2055, 70, 70],
            [1998, 2056, 50, 60],
            [1998, 2057, 120, 90],
            [1998, 2058, 9.96, 8.92],
            [1998, 2059, 14.88, 8.19],
            [1998, 2060, 70, 70],
            [1998, 2061, 70, 70],
            [1998, 2062, 120, 90],
            [1998, 2063, 50, 60],
            [1998, 2064, 61.23, 37.87],
            [1998, 2066, 120, 90],
            [1998, 2068, 70, 70],
            [1998, 2070, 21.34, 9.3],
            [1998, 2071, 120, 90],
            [1998, 2072, 120, 90],
            [1998, 2073, 120, 90],
            [1998, 2074, 70, 70],
            [1998, 2075, 70, 70],
            [1998, 2076, 70, 70],
            [1998, 2077, 120, 90],
            [1998, 2081, 57.1, 44.75],
            [1998, 2083, 120, 90],
            [1998, 2084, 23.59, 36.63],
            [1998, 2085, 9.03, 8.79],
            [1998, 2086, 40, 50],
            [1998, 2087, 70, 70],
            [1998, 2089, 0, 0],
            [1998, 2090, 120, 90],
            [1998, 2091, 120, 90],
            [1998, 2095, 70, 70],
            [1998, 2096, 120, 90],
            [1998, 2097, 50, 60],
            [1998, 2098, 40, 50],
            [1998, 2099, 89.29, 46.57],
            [1998, 2100, 70, 70],
            [1998, 2101, 70, 70],
            [1998, 2103, 12.45, 12.74],
            [1998, 2104, 111.3, 45.15],
            [1998, 2105, 120, 90],
            [1998, 2106, 50, 60],
            [1998, 2107, 120, 90],
            [1998, 2109, 120, 90],
            [1998, 2110, 40, 50],
            [1998, 2112, 70, 70],
            [1998, 2115, 70, 70],
            [1998, 2116, 50, 60],
            [1998, 2118, 120, 90],
            [1998, 2119, 16.05, 9.74],
            [1998, 2121, 120, 90],
            [1998, 2122, 70, 70],
            [1998, 2125, 120, 90],
            [1998, 2126, 50, 60],
            [1998, 2127, 44.84, 32.36],
            [1998, 2128, 29.14, 12.62],
            [1998, 2130, 120, 90],
            [1998, 2131, 120, 90],
            [1998, 2132, 19.44, 13.59],
            [1998, 2134, 70, 70],
            [1998, 2135, 50, 60],
            [1998, 2136, 70, 70],
            [1998, 2137, 70, 70],
            [1998, 2138, 38.63, 26.61],
            [1998, 2139, 70, 70],
            [1998, 2140, 50, 60],
            [1998, 2142, 70, 70],
            [1998, 2144, 120, 90],
            [1998, 2146, 70, 70],
            [1998, 2147, 120, 90],
            [1998, 2148, 70, 70],
            [1998, 2149, 120, 90],
            [1998, 2150, 120, 90],
            [1998, 2151, 62.81, 37.98],
            [1998, 2152, 120, 90],
            [1998, 2154, 120, 90],
            [1998, 2155, 120, 90],
            [1998, 2156, 70, 70],
            [1998, 2159, 120, 90],
            [1998, 2161, 50, 60],
            [1998, 2162, 34.02, 34.24],
            [1998, 2163, 120, 90],
            [1998, 2164, 50, 60],
            [1998, 2165, 50, 60],
            [1998, 2166, 35.02, 25.49],
            [1998, 2167, 10.33, 10.88],
            [1998, 2169, 70, 70],
            [1998, 2170, 50.17, 28.05],
            [1998, 2171, 120, 90],
            [1998, 2174, 40.28, 40.83],
            [1998, 2177, 8.15, 8.97],
            [1998, 2178, 70, 70],
            [1998, 2179, 70, 70],
            [1998, 2180, 14.38, 10.62],
            [1998, 2181, 58.9, 76.35],
            [1998, 2182, 120, 90],
            [1998, 2184, 40, 50],
            [1998, 2186, 50, 60],
            [1998, 2187, 120, 90],
            [1998, 2190, 70, 70],
            [1998, 2191, 120, 90],
            [1998, 2197, 120, 90],
            [1998, 2198, 40, 50],
            [1998, 2199, 120, 90],
            [1998, 2200, 70, 70],
            [1998, 2201, 23.77, 27.53],
            [1998, 2203, 12.12, 8.84],
            [1998, 2204, 14.98, 8.4],
            [1998, 2205, 120, 90],
            [1998, 2208, 81.25, 48.76],
            [1998, 2212, 70, 70],
            [1998, 2213, 50, 60],
            [1998, 2214, 20, 25],
            [1998, 2216, 34.36, 17.02],
            [1998, 2217, 120, 90],
            [1998, 2219, 120, 90],
            [1998, 2220, 37.11, 22.57],
            [1998, 2223, 40, 50],
            [1998, 2224, 29.41, 34.07],
            [1998, 2225, 50, 60],
            [1998, 2226, 120, 90],
            [1998, 2227, 39.22, 33.66],
            [1998, 2228, 50, 60],
            [1998, 2230, 120, 90],
            [1998, 2231, 120, 90],
            [1998, 2232, 17.94, 39.15],
            [1998, 2233, 34.95, 29.11],
            [1998, 2235, 50, 60],
            [1998, 2236, 26.79, 29.04],
            [1998, 2237, 120, 90],
            [1998, 2238, 26.85, 29.25],
            [1998, 2239, 21.85, 11.47],
            [1998, 2240, 120, 90],
            [1998, 2241, 14.63, 9.52],
            [1998, 2242, 70, 70],
            [1998, 2243, 120, 90],
            [1998, 2244, 70, 70],
            [1998, 2245, 70, 70],
            [1998, 2247, 50, 60],
            [1998, 2248, 16, 20],
            [1998, 2249, 120, 90],
            [1998, 2250, 50, 60],
            [1998, 2252, 70, 70],
            [1998, 2253, 14.51, 10.23],
            [1998, 2254, 70, 70],
            [1998, 2255, 22.3, 61.32],
            [1998, 2256, 70, 70],
            [1998, 2258, 42.22, 34.38],
            [1998, 2259, 2, 2],
            [1998, 2260, 70, 70],
            [1998, 2262, 70, 70],
            [1998, 2265, 120, 90],
            [1998, 2267, 10.9, 7.43],
            [1998, 2268, 120, 90],
            [1998, 2269, 70, 70],
            [1998, 2270, 120, 90],
            [1998, 2271, 9.23, 6.76],
            [1998, 2273, 70, 70],
            [1998, 2274, 70, 70],
            [1998, 2277, 50, 60],
            [1998, 2280, 8.57, 5.83],
            [1998, 2281, 120, 90],
            [1998, 2282, 70, 70],
            [1998, 2283, 120, 90],
            [1998, 2284, 70, 70],
            [1998, 2285, 40, 50],
            [1998, 2286, 70, 70],
            [1998, 2289, 120, 90],
            [1998, 2290, 120, 90],
            [1998, 2292, 120, 90],
            [1998, 2293, 109.99, 52.3],
            [1998, 2294, 50, 60],
            [1998, 2295, 120, 90],
            [1998, 2297, 153.15, 64.3],
            [1998, 2300, 50, 60],
            [1998, 2301, 70, 70],
            [1998, 2302, 120, 90],
            [1998, 2303, 56.37, 41.39],
            [1998, 2304, 70, 70],
            [1998, 2305, 120, 90],
            [1998, 2306, 50, 60],
            [1998, 2307, 70, 70],
            [1998, 2311, 70, 70],
            [1998, 2312, 33.27, 33.84],
            [1998, 2314, 120, 90],
            [1998, 2316, 70, 70],
            [1998, 2317, 120, 90],
            [1998, 2319, 50, 60],
            [1998, 2320, 8.59, 9.12],
            [1998, 2321, 120, 90],
            [1998, 2323, 70, 70],
            [1998, 2325, 120, 90],
            [1998, 2326, 120, 90],
            [1998, 2327, 120, 90],
            [1998, 2328, 70, 70],
            [1998, 2332, 120, 90],
            [1998, 2335, 85.28, 79.59],
            [1998, 2336, 120, 90],
            [1998, 2337, 120, 90],
            [1998, 2338, 32.24, 21.39],
            [1998, 2339, 120, 90],
            [1998, 2340, 120, 90],
            [1998, 2341, 70, 70],
            [1998, 2342, 70, 70],
            [1998, 2343, 70, 70],
            [1998, 2345, 40, 50],
            [1998, 2346, 70, 70],
            [1998, 2347, 120, 90],
            [1998, 2348, 70, 70],
            [1998, 2349, 70, 70],
            [1998, 2352, 50, 60],
            [1998, 2356, 226.56, 56.42],
            [1998, 2359, 50, 60],
            [1998, 2363, 50, 60],
            [1998, 2364, 32.24, 21.39],
            [1998, 2366, 50, 60],
            [1998, 2367, 59.45, 50.23],
            [1998, 2368, 70, 70],
            [1998, 2371, 70, 70],
            [1998, 2372, 30, 45],
            [1998, 2373, 70, 70],
            [1998, 2374, 14.36, 11.08],
            [1998, 2375, 120, 90],
            [1998, 2378, 47.63, 26.72],
            [1998, 2382, 70, 70],
            [1998, 2383, 96.19, 48.48],
            [1998, 2384, 30, 45],
            [1998, 2385, 70, 70],
            [1998, 2387, 40, 50],
            [1998, 2388, 70, 70],
            [1998, 2390, 120, 90],
            [1998, 2391, 70, 70],
            [1998, 2392, 8.47, 8.48],
            [1998, 2394, 50, 60],
            [1998, 2396, 120, 90],
            [1998, 2397, 120, 90],
            [1998, 2398, 120, 90],
            [1998, 2399, 120, 90],
            [1998, 2401, 9.42, 9.69],
            [1998, 2402, 70, 70],
            [1998, 2404, 120, 90],
            [1998, 2405, 22.61, 36.11],
            [1998, 2406, 120, 90],
            [1998, 2407, 120, 90],
            [1998, 2408, 50, 60],
            [1998, 2409, 50, 60],
            [1998, 2410, 70, 70],
            [1998, 2411, 9.59, 8.49],
            [1998, 2412, 6.63, 7.08],
            [1998, 2413, 120, 90],
            [1998, 2414, 8.64, 7.09],
            [1998, 2416, 120, 90],
            [1998, 2420, 120, 90],
            [1998, 2423, 70, 70],
            [1998, 2424, 120, 90],
            [1998, 2425, 70, 70],
            [1998, 2428, 10.11, 12.8],
            [1998, 2429, 70, 70],
            [1998, 2430, 70, 70],
            [1998, 2433, 70, 70],
            [1998, 2434, 120, 90],
            [1998, 2435, 40, 50],
            [1998, 2436, 70, 70],
            [1998, 2437, 16.17, 13.35],
            [1998, 2438, 120, 90],
            [1998, 2439, 70, 70],
            [1998, 2440, 5.64, 5.78],
            [1998, 2441, 120, 90],
            [1998, 2442, 120, 90],
            [1998, 2443, 70, 70],
            [1998, 2444, 120, 90],
            [1998, 2447, 25.21, 17.4],
            [1998, 2448, 120, 90],
            [1998, 2449, 35.02, 25.49],
            [1998, 2452, 70, 70],
            [1998, 2454, 120, 90],
            [1998, 2456, 70, 70],
            [1998, 2458, 50, 60],
            [1998, 2459, 32.63, 40.69],
            [1998, 2460, 70, 70],
            [1998, 2462, 120, 90],
            [1998, 2463, 40, 50],
            [1998, 2465, 120, 90],
            [1998, 2466, 120, 90],
            [1998, 2467, 70, 70],
            [1998, 2468, 40, 50],
            [1998, 2470, 120, 90],
            [1998, 2471, 120, 90],
            [1998, 2472, 78.4, 34.97],
            [1998, 2473, 120, 90],
            [1998, 2474, 120, 90],
            [1998, 2475, 70, 70],
            [1998, 2476, 120, 90],
            [1998, 2477, 70, 70],
            [1998, 2478, 120, 90],
            [1998, 2479, 50, 60],
            [1998, 2480, 33.47, 21.67],
            [1998, 2481, 50, 60],
            [1998, 2482, 120, 90],
            [1998, 2483, 120, 90],
            [1998, 2484, 120, 90],
            [1998, 2485, 50, 60],
            [1998, 2486, 70, 70],
            [1998, 2487, 70, 70],
            [1998, 2488, 53.21, 52.23],
            [1998, 2490, 70, 70],
            [1998, 2493, 104.76, 45.88],
            [1998, 2494, 57.1, 29.4],
            [1998, 2495, 40, 50],
            [1998, 2496, 120, 90],
            [1998, 2497, 40.2, 11.31],
            [1998, 2499, 17.64, 11.45],
            [1998, 2500, 14.55, 14.52],
            [1998, 2501, 70, 70],
            [1998, 2502, 50, 60],
            [1998, 2503, 50, 60],
            [1998, 2504, 120, 90],
            [1998, 2505, 70, 70],
            [1998, 2507, 120, 90],
            [1998, 2508, 70, 70],
            [1998, 2509, 70, 70],
            [1998, 2510, 70, 70],
            [1998, 2511, 35.02, 25.49],
            [1998, 2512, 120, 90],
            [1998, 2513, 120, 90],
            [1998, 2514, 120, 90],
            [1998, 2515, 50, 60],
            [1998, 2516, 40.7, 39.93],
            [1998, 2518, 74.82, 43.44],
            [1998, 2519, 35.02, 25.49],
            [1998, 2520, 70, 70],
            [1998, 2521, 50, 60],
            [1998, 2524, 50, 60],
            [1998, 2525, 70, 70],
            [1998, 2526, 70, 70],
            [1998, 2527, 49.14, 44.47],
            [1998, 2528, 120, 90],
            [1998, 2529, 70, 70],
            [1998, 2530, 70, 70],
            [1998, 2532, 70, 70],
            [1998, 2533, 23.69, 46.33],
            [1998, 2534, 120, 90],
            [1998, 2535, 5.8, 6.5],
            [1998, 2536, 6.37, 5.06],
            [1998, 2537, 120, 90],
            [1998, 2539, 70, 70],
            [1998, 2540, 40.04, 38.42],
            [1998, 2542, 34.79, 22.79],
            [1998, 2543, 40, 50],
            [1998, 2545, 40, 50],
            [1998, 2546, 70, 70],
            [1998, 2547, 70, 70],
            [1998, 2548, 70, 70],
            [1998, 2549, 70, 70],
            [1998, 2551, 71.76, 36.27],
            [1998, 2553, 70, 70],
            [1998, 2554, 70, 70],
            [1998, 2555, 52.5, 52.5],
            [1998, 2558, 40, 50],
            [1998, 2562, 111.85, 42.43],
            [1998, 2563, 70, 70],
            [1998, 2564, 40.56, 78.59],
            [1998, 2565, 40, 50],
            [1998, 2566, 10.44, 11.25],
            [1998, 2568, 50, 60],
            [1998, 2569, 50, 60],
            [1998, 2571, 50, 60],
            [1998, 2572, 120, 90],
            [1998, 2574, 107.79, 57.67],
            [1998, 2575, 70, 70],
            [1998, 2576, 70, 70],
            [1998, 2577, 30.15, 21.64],
            [1998, 2578, 70, 70],
            [1998, 2580, 120, 90],
            [1998, 2582, 70, 70],
            [1998, 2584, 120, 90],
            [1998, 2585, 70, 70],
            [1998, 2587, 66.78, 50.99],
            [1998, 2589, 70, 70],
            [1998, 2590, 120, 90],
            [1998, 2591, 120, 90],
            [1998, 2592, 120, 90],
            [1998, 2593, 109.49, 44.64],
            [1998, 2595, 70, 70],
            [1998, 2596, 120, 90],
            [1998, 2597, 40, 50],
            [1998, 2598, 70, 70],
            [1998, 2600, 50, 60],
            [1998, 2601, 70, 70],
            [1998, 2603, 120, 90],
            [1998, 2604, 14.91, 16.67],
            [1998, 2606, 18.48, 15.38],
            [1998, 2607, 14.85, 16.55],
            [1998, 2608, 70, 70],
            [1998, 2610, 70, 70],
            [1998, 2612, 19.02, 24.51],
            [1998, 2613, 35.02, 25.49],
            [1998, 2615, 80.55, 54.14],
            [1998, 2617, 17.59, 35.03],
            [1998, 2619, 57.48, 50.98],
            [1998, 2620, 50, 60],
            [1998, 2621, 120, 90],
            [1998, 2622, 22.29, 20.66],
            [1998, 2623, 36.98, 28.35],
            [1998, 2624, 35.02, 25.49],
            [1998, 2627, 70, 70],
            [1998, 2628, 47.2, 82.28],
            [1998, 2630, 120, 90],
            [1998, 2631, 70, 70],
            [1998, 2632, 22.83, 26.19],
            [1998, 2633, 36.95, 67.11],
            [1998, 2634, 120, 90],
            [1998, 2635, 70, 70],
            [1998, 2636, 70, 70],
            [1998, 2638, 70, 70],
            [1998, 2639, 10.59, 10.5],
            [1998, 2642, 120, 90],
            [1998, 2644, 71.93, 71.93],
            [1998, 2646, 30, 45],
            [1998, 2647, 51.91, 54.1],
            [1998, 2649, 50, 60],
            [1998, 2650, 120, 90],
            [1998, 2651, 40, 50],
            [1998, 2652, 37.5, 45],
            [1998, 2653, 70, 70],
            [1998, 2655, 40, 50],
            [1998, 2656, 69.06, 43.42],
            [1998, 2658, 40.97, 26.68],
            [1998, 2660, 40, 50],
            [1998, 2661, 70, 70],
            [1998, 2663, 50, 60],
            [1998, 2664, 120, 90],
            [1998, 2665, 70, 70],
            [1998, 2667, 63.81, 52.19],
            [1998, 2668, 39.53, 31.14],
            [1998, 2669, 120, 90],
            [1998, 2670, 70, 70],
            [1998, 2671, 50, 45],
            [1998, 2672, 70, 70],
            [1998, 2677, 70, 70],
            [1998, 2681, 70, 70],
            [1998, 2682, 120, 90],
            [1998, 2683, 11.9, 7.65],
            [1998, 2684, 70.83, 69.48],
            [1998, 2685, 50, 60],
            [1998, 2686, 9.12, 8.59],
            [1998, 2687, 94.14, 34.56],
            [1998, 2691, 50, 60],
            [1998, 2692, 70, 70],
            [1998, 2694, 35.02, 25.49],
            [1998, 2695, 70, 70],
            [1998, 2696, 32.24, 21.39],
            [1998, 2697, 120, 90],
            [1998, 2698, 70, 70],
            [1998, 2703, 50, 60],
            [1998, 2704, 15.95, 11.19],
            [1998, 2706, 120, 90],
            [1998, 2707, 70, 70],
            [1998, 2708, 120, 90],
            [1998, 2710, 22.67, 16.2],
            [1998, 2711, 50, 60],
            [1998, 2712, 70, 70],
            [1998, 2713, 70, 70],
            [1998, 2714, 50, 60],
            [1998, 2716, 70, 70],
            [1998, 2719, 70, 70],
            [1998, 2720, 120, 90],
            [1998, 2722, 120, 90],
            [1998, 2723, 70, 70],
            [1998, 2725, 70, 70],
            [1998, 2726, 70, 70],
            [1998, 2728, 35.02, 25.49],
            [1998, 2730, 50, 60],
            [1998, 2731, 120, 90],
            [1998, 2734, 50, 60],
            [1998, 2735, 8.55, 9.81],
            [1998, 2736, 30, 45],
            [1998, 2737, 40, 50],
            [1998, 2738, 40, 37.5],
            [1998, 2739, 50, 60],
            [1998, 2740, 120, 90],
            [1998, 2741, 120, 90],
            [1998, 2742, 70, 70],
            [1998, 2743, 30.71, 32.21],
            [1998, 2746, 32.24, 21.39],
            [1998, 2747, 63.12, 31.83],
            [1998, 2748, 123.58, 59.04],
            [1998, 2750, 30, 45],
            [1998, 2752, 70, 70],
            [1998, 2753, 50, 60],
            [1998, 2755, 120, 90],
            [1998, 2756, 70, 70],
            [1998, 2757, 120, 90],
            [1998, 2758, 36.94, 36.69],
            [1998, 2759, 120, 90],
            [1998, 2760, 120, 90],
            [1998, 2762, 120, 90],
            [1998, 2763, 120, 90],
            [1998, 2764, 70, 70],
            [1998, 2765, 120, 90],
            [1998, 2766, 5.69, 6.72],
            [1998, 2767, 120, 90],
            [1998, 2768, 120, 90],
            [1998, 2770, 120, 90],
            [1998, 2772, 70, 70],
            [1998, 2773, 50, 60],
            [1998, 2774, 120, 90],
            [1998, 2775, 70, 70],
            [1998, 2778, 70, 70],
            [1998, 2781, 9.91, 6.13],
            [1998, 2782, 50, 60],
            [1998, 2783, 70, 70],
            [1998, 2784, 70, 70],
            [1998, 2785, 5.56, 14],
            [1998, 2786, 70, 70],
            [1998, 2787, 64.37, 35.05],
            [1998, 2788, 96.68, 56.26],
            [1998, 2791, 30, 37.5],
            [1998, 2792, 120, 90],
            [1998, 2793, 16, 20],
            [1998, 2795, 32.24, 21.39],
            [1998, 2796, 70, 70],
            [1998, 2797, 120, 90],
            [1998, 2798, 70, 70],
            [1998, 2800, 70, 70],
            [1998, 2801, 120, 90],
            [1998, 2804, 20.57, 14.3],
            [1998, 2806, 70, 70],
            [1998, 2807, 36.77, 11.92],
            [1998, 2808, 50, 60],
            [1998, 2809, 120, 90],
            [1998, 2811, 50, 60],
            [1998, 2813, 34.06, 29.31],
            [1998, 2814, 120, 90],
            [1998, 2818, 30, 45],
            [1998, 2819, 11.84, 8.58],
            [1998, 2820, 120, 90],
            [1998, 2821, 70, 70],
            [1998, 2822, 40, 50],
            [1998, 2823, 59.27, 44.08],
            [1998, 2826, 40, 50],
            [1998, 2827, 21.89, 30.71],
            [1998, 2831, 120, 90],
            [1998, 2832, 70, 70],
            [1998, 2833, 120, 90],
            [1998, 2834, 50, 60],
            [1998, 2835, 37.5, 45],
            [1998, 2836, 36.81, 31.39],
            [1998, 2837, 120, 90],
            [1998, 2838, 120, 90],
            [1998, 2839, 120, 90],
            [1998, 2841, 120, 90],
            [1998, 2844, 70, 70],
            [1998, 2845, 120, 90],
            [1998, 2846, 120, 90],
            [1998, 2847, 30, 45],
            [1998, 2850, 20.67, 13.88],
            [1998, 2851, 75.14, 53.01],
            [1998, 2852, 37.5, 45],
            [1998, 2853, 70, 70],
            [1998, 2854, 25.17, 19.72],
            [1998, 2856, 124.74, 77.59],
            [1998, 2857, 35.02, 25.49],
            [1998, 2861, 70, 70],
            [1998, 2862, 70, 70],
            [1998, 2863, 70, 70],
            [1998, 2864, 120, 90],
            [1998, 2865, 120, 90],
            [1998, 2866, 50, 60],
            [1998, 2867, 120, 90],
            [1998, 2869, 5.93, 4.86],
            [1998, 2871, 120, 90],
            [1998, 2872, 31.07, 14.75],
            [1998, 2876, 101.18, 75.84],
            [1998, 2877, 120, 90],
            [1998, 2878, 120, 90],
            [1998, 2879, 50, 60],
            [1998, 2880, 39, 52.5],
            [1998, 2882, 120, 90],
            [1998, 2883, 70, 70],
            [1998, 2884, 70.14, 48.85],
            [1998, 2885, 70, 70],
            [1998, 2886, 70, 70],
            [1998, 2887, 70, 70],
            [1998, 2889, 70, 70],
            [1998, 2890, 120, 90],
            [1998, 2891, 120, 90],
            [1998, 2893, 120, 90],
            [1998, 2894, 120, 90],
            [1998, 2897, 120, 90],
            [1998, 2899, 70, 70],
            [1998, 2900, 20.67, 13.88],
            [1998, 2901, 120, 90],
            [1998, 2902, 120, 90],
            [1998, 2903, 120, 90],
            [1998, 2904, 120, 90],
            [1998, 2905, 50, 60],
            [1998, 2906, 120, 90],
            [1998, 2907, 16.83, 17.5],
            [1998, 2908, 50, 60],
            [1998, 2910, 49.02, 40.47],
            [1998, 2911, 120, 90],
            [1998, 2914, 70, 70],
            [1998, 2916, 70, 70],
            [1998, 2917, 20.67, 13.88],
            [1998, 2918, 17.8, 10.33],
            [1998, 2919, 120, 90],
            [1998, 2921, 120, 90],
            [1998, 2922, 50, 60],
            [1998, 2923, 26.73, 30.82],
            [1998, 2924, 120, 90],
            [1998, 2925, 120, 90],
            [1998, 2928, 70, 70],
            [1998, 2929, 50.7, 47.79],
            [1998, 2930, 120, 90],
            [1998, 2931, 70, 70],
            [1998, 2932, 120, 90],
            [1998, 2933, 70, 70],
            [1998, 2934, 85.78, 39.36],
            [1998, 2935, 120, 90],
            [1998, 2936, 90.08, 68.66],
            [1998, 2937, 120, 90],
            [1998, 2940, 120, 90],
            [1998, 2942, 70, 70],
            [1998, 2943, 120, 90],
            [1998, 2944, 50, 60],
            [1998, 2946, 117.5, 74.87],
            [1998, 2948, 50, 60],
            [1998, 2950, 110.01, 49.26],
            [1998, 2951, 120, 90],
            [1998, 2952, 120, 90],
            [1998, 2955, 70, 70],
            [1998, 2956, 70, 70],
            [1998, 2957, 120, 90],
            [1998, 2958, 50, 60],
            [1998, 2960, 50, 60],
            [1998, 2961, 50, 60],
            [1998, 2962, 40, 50],
            [1998, 2963, 120, 90],
            [1998, 2964, 50, 60],
            [1998, 2965, 120, 90],
            [1998, 2969, 15.24, 25.59],
            [1998, 2971, 70, 70],
            [1998, 2972, 120, 90],
            [1998, 2973, 120, 90],
            [1998, 2974, 22.89, 34.75],
            [1998, 2975, 70, 70],
            [1998, 2976, 120, 90],
            [1998, 2978, 24.61, 18.48],
            [1998, 2979, 70, 70],
            [1998, 2980, 120, 90],
            [1998, 2982, 40, 50],
            [1998, 2984, 15.43, 13.81],
            [1998, 2985, 50, 60],
            [1998, 2986, 35.02, 25.49],
            [1998, 2988, 120, 90],
            [1998, 2989, 50, 60],
            [1998, 2991, 50, 60],
            [1998, 2995, 36.26, 41.54],
            [1998, 2997, 12.34, 10.34],
            [1998, 2998, 70, 70],
            [1998, 2999, 7.91, 8.83],
            [1998, 3000, 50, 60],
            [1998, 3001, 70, 70],
            [1998, 3002, 120, 90],
            [1998, 3003, 120, 90],
            [1998, 3004, 120, 90],
            [1998, 3006, 70, 70],
            [1998, 3008, 70, 70],
            [1998, 3009, 50, 60],
            [1998, 3011, 13.6, 28.86],
            [1998, 3012, 70, 70],
            [1998, 3014, 120, 90],
            [1998, 3015, 30, 37.5],
            [1998, 3016, 22.14, 18.78],
            [1998, 3017, 120, 90],
            [1998, 3019, 50, 60],
            [1998, 3022, 120, 90],
            [1998, 3024, 70, 70],
            [1998, 3025, 70, 70],
            [1998, 3026, 21.48, 22.87],
            [1998, 3027, 22, 43.41],
            [1998, 3031, 20.67, 13.88],
            [1998, 3033, 120, 90],
            [1998, 3035, 29.76, 27.35],
            [1998, 3037, 50, 60],
            [1998, 3041, 52.5, 52.5],
            [1998, 3042, 10.27, 8.48],
            [1998, 3043, 70, 70],
            [1998, 3044, 70, 70],
            [1998, 3045, 120, 90],
            [1998, 3046, 120, 90],
            [1998, 3047, 50, 60],
            [1998, 3048, 101.09, 97.17],
            [1998, 3049, 120, 90],
            [1998, 3050, 27.97, 29.63],
            [1998, 3051, 120, 90],
            [1998, 3052, 70, 70],
            [1998, 3053, 70, 70],
            [1998, 3054, 50, 60],
            [1998, 3055, 120, 90],
            [1998, 3056, 15.98, 17.91],
            [1998, 3057, 70, 70],
            [1998, 3058, 70, 70],
            [1998, 3059, 120, 90],
            [1998, 3060, 70, 70],
            [1998, 3061, 128.24, 46.52],
            [1998, 3063, 70, 70],
            [1998, 3064, 70, 70],
            [1998, 3066, 50, 60],
            [1998, 3069, 35.02, 25.49],
            [1998, 3070, 56.43, 49.17],
            [1998, 3073, 120, 90],
            [1998, 3076, 120, 90],
            [1998, 3077, 39.42, 34.65],
            [1998, 3078, 70, 70],
            [1998, 3079, 70, 70],
            [1998, 3083, 70, 70],
            [1998, 3084, 70, 70],
            [1998, 3085, 50, 60],
            [1998, 3086, 97.92, 38.7],
            [1998, 3087, 70, 70],
            [1998, 3089, 43.11, 25.75],
            [1998, 3090, 50, 60],
            [1998, 3091, 19.67, 20.1],
            [1998, 3092, 70, 70],
            [1998, 3095, 120, 90],
            [1998, 3098, 20.76, 58.98],
            [1998, 3100, 120, 90],
            [1998, 3101, 120, 90],
            [1998, 3102, 120, 90],
            [1998, 3104, 7.73, 6.59],
            [1998, 3105, 70, 70],
            [1998, 3106, 70, 70],
            [1998, 3107, 120, 90],
            [1998, 3109, 50, 60],
            [1998, 3112, 79.98, 40.43],
            [1998, 3113, 70, 70],
            [1998, 3114, 120, 90],
            [1998, 3115, 120, 90],
            [1998, 3117, 50, 60],
            [1998, 3118, 120, 90],
            [1998, 3119, 40, 50],
            [1998, 3121, 69.55, 32.33],
            [1998, 3122, 63.25, 33.78],
            [1998, 3123, 120, 90],
            [1998, 3125, 120, 90],
            [1998, 3126, 70, 70],
            [1998, 3127, 9.37, 9.65],
            [1998, 3128, 120, 90],
            [1998, 3129, 37.84, 31.71],
            [1998, 3130, 40, 50],
            [1998, 3131, 8.89, 9.07],
            [1998, 3132, 120, 90],
            [1998, 3133, 72.02, 36.75],
            [1998, 3134, 50, 45],
            [1998, 3135, 120, 90],
            [1998, 3136, 40, 50],
            [1998, 3137, 12.56, 13.35],
            [1998, 3138, 120, 90],
            [1998, 3139, 10.29, 7.91],
            [1998, 3140, 70, 70],
            [1998, 3141, 50, 60],
            [1998, 3142, 40, 50],
            [1998, 3143, 70, 70],
            [1998, 3144, 120, 90],
            [1998, 3148, 33.08, 29.22],
            [1998, 3149, 120, 90],
            [1998, 3151, 120, 90],
            [1998, 3152, 50, 60],
            [1998, 3153, 70, 70],
            [1998, 3154, 87.45, 60.56],
            [1998, 3155, 98.27, 51.32],
            [1998, 3158, 120, 90],
            [1998, 3160, 37.27, 60.05],
            [1998, 3161, 20.3, 19.5],
            [1998, 3163, 70, 70],
            [1998, 3164, 70, 70],
            [1998, 3165, 70, 54.11],
            [1998, 3166, 15, 20],
            [1998, 3167, 69.49, 38],
            [1998, 3168, 120, 90],
            [1998, 3171, 50, 60],
            [1998, 3172, 120, 90],
            [1998, 3175, 73.26, 36.41],
            [1998, 3177, 37.5, 45],
            [1998, 3181, 8.14, 6.4],
            [1998, 3182, 22.27, 15.36],
            [1998, 3183, 40, 50],
            [1998, 3184, 70, 70],
            [1998, 3186, 40, 50],
            [1998, 3187, 120, 90],
            [1998, 3188, 14.43, 16.56],
            [1998, 3189, 192.54, 70.66],
            [1998, 3190, 40, 50],
            [1998, 3191, 70, 70],
            [1998, 3192, 120, 90],
            [1998, 3195, 22.52, 19.08],
            [1998, 3196, 70, 70],
            [1998, 3197, 99.63, 37.69],
            [1998, 3198, 50, 60],
            [1998, 3199, 70, 70],
            [1998, 3200, 40, 50],
            [1998, 3203, 12.22, 11.28],
            [1998, 3206, 36.81, 46.42],
            [1998, 3207, 50, 60],
            [1998, 3208, 120, 90],
            [1998, 3211, 50, 60],
            [1998, 3212, 120, 90],
            [1998, 3214, 70, 70],
            [1998, 3216, 120, 90],
            [1998, 3217, 34.82, 34.71],
            [1998, 3219, 10.87, 12.56],
            [1998, 3220, 120, 90],
            [1998, 3221, 70, 70],
            [1998, 3225, 8.05, 7.89],
            [1998, 3227, 70, 70],
            [1998, 3228, 34.26, 35.61],
            [1998, 3229, 35.02, 25.49],
            [1998, 3231, 26.42, 28.94],
            [1998, 3234, 37.45, 21.3],
            [1998, 3239, 120, 90],
            [1998, 3240, 120, 90],
            [1998, 3241, 50, 60],
            [1998, 3242, 70, 70],
            [1998, 3243, 12.14, 9.5],
            [1998, 3244, 120, 90],
            [1998, 3246, 65.38, 60.87],
            [1998, 3247, 120, 90],
            [1998, 3248, 50, 60],
            [1998, 3249, 120, 90],
            [1998, 3251, 40, 50],
            [1998, 3252, 50, 60],
            [1998, 3253, 70, 70],
            [1998, 3254, 50, 60],
            [1998, 3255, 70, 70],
            [1998, 3256, 30.27, 22.34],
            [1998, 3257, 50, 60],
            [1998, 3258, 70, 70],
            [1998, 3259, 50, 60],
            [1998, 3260, 20, 25],
            [1998, 3262, 70, 70],
            [1998, 3263, 120, 90],
            [1998, 3264, 13.13, 23.21],
            [1998, 3265, 120, 90],
            [1998, 3266, 70, 70],
            [1998, 3267, 50, 60],
            [1998, 3268, 59.2, 40.69],
            [1998, 3270, 21.48, 22.87],
            [1998, 3271, 35.02, 25.49],
            [1998, 3272, 106.83, 78.93],
            [1998, 3273, 120, 90],
            [1998, 3274, 50, 60],
            [1998, 3275, 120, 90],
            [1998, 3276, 35.02, 25.49],
            [1998, 3277, 91.74, 42.99],
            [1998, 3278, 70, 70],
            [1998, 3279, 32.24, 21.39],
            [1998, 3280, 59.87, 41.55],
            [1998, 3283, 12.69, 12.13],
            [1998, 3284, 42.57, 30.98],
            [1998, 3286, 15.7, 9.65],
            [1998, 3287, 50, 60],
            [1998, 3288, 50, 60],
            [1998, 3289, 120, 90],
            [1998, 3290, 70, 70],
            [1998, 3292, 120, 90],
            [1998, 3293, 70, 70],
            [1998, 3294, 20.67, 13.88],
            [1998, 3295, 120, 90],
            [1998, 3296, 30, 45],
            [1998, 3300, 70, 70],
            [1998, 3301, 70, 70],
            [1998, 3302, 70, 70],
            [1998, 3303, 70, 70],
            [1998, 3305, 120, 90],
            [1998, 3306, 32.44, 29.79],
            [1998, 3308, 70, 70],
            [1998, 3309, 50, 45],
            [1998, 3312, 70, 70],
            [1998, 3313, 120, 90],
            [1998, 3314, 50, 60],
            [1998, 3315, 120, 90],
            [1998, 3316, 120, 90],
            [1998, 3318, 70, 70],
            [1998, 3319, 70, 70],
            [1998, 3320, 120, 90],
            [1998, 3321, 50, 60],
            [1998, 3322, 120, 90],
            [1998, 3323, 40, 50],
            [1998, 3324, 70, 70],
            [1998, 3325, 40, 50],
            [1998, 3326, 51.15, 39.66],
            [1998, 3327, 120, 90],
            [1998, 3328, 120, 90],
            [1998, 3329, 8.87, 8.14],
            [1998, 3331, 108.09, 47.79],
            [1998, 3332, 120, 90],
            [1998, 3333, 120, 90],
            [1998, 3334, 14.53, 16.63],
            [1998, 3335, 70, 70],
            [1998, 3336, 46.22, 26.88],
            [1998, 3338, 70, 70],
            [1998, 3340, 50, 60],
            [1998, 3341, 24.19, 14.72],
            [1998, 3342, 32.24, 21.39],
            [1998, 3343, 120, 90],
            [1998, 3344, 99.81, 58.02],
            [1998, 3346, 62.21, 43.82],
            [1998, 3347, 120, 90],
            [1998, 3348, 70, 70],
            [1998, 3350, 35.02, 25.49],
            [1998, 3351, 35.02, 25.49],
            [1998, 3353, 120, 90],
            [1998, 3354, 50, 60],
            [1998, 3357, 12.58, 12.94],
            [1998, 3358, 19.2, 17.45],
            [1998, 3359, 120, 90],
            [1998, 3361, 120, 90],
            [1998, 3363, 14.08, 11.88],
            [1998, 3364, 70, 70],
            [1998, 3366, 120, 90],
            [1998, 3367, 50, 60],
            [1998, 3369, 120, 90],
            [1998, 3370, 70, 70],
            [1998, 3371, 70, 70],
            [1998, 3372, 70, 70],
            [1998, 3376, 35.02, 25.49],
            [1998, 3378, 9.02, 8.54],
            [1998, 3380, 120, 90],
            [1998, 3381, 120, 90],
            [1998, 3382, 23.2, 25.03],
            [1998, 3384, 120, 90],
            [1998, 3386, 120, 90],
            [1998, 3387, 70, 70],
            [1998, 3388, 120, 90],
            [1998, 3389, 70, 70],
            [1998, 3390, 120, 90],
            [1998, 3391, 120, 90],
            [1998, 3392, 120, 90],
            [1998, 3393, 120, 90],
            [1998, 3394, 120, 90],
            [1998, 3396, 31.22, 33.2],
            [1998, 3399, 70, 70],
            [1998, 3400, 40, 50],
            [1998, 3402, 120, 90],
            [1998, 3403, 16.87, 10.26],
            [1998, 3404, 41.37, 52.15],
            [1998, 3407, 59.05, 33.48],
            [1998, 3408, 35.02, 25.49],
            [1998, 3411, 70, 70],
            [1998, 3414, 50, 60],
            [1998, 3415, 40, 50],
            [1998, 3416, 40, 50],
            [1998, 3417, 70, 70],
            [1998, 3418, 120, 90],
            [1998, 3419, 70, 70],
            [1998, 3420, 70, 70],
            [1998, 3422, 50.99, 25.75],
            [1998, 3423, 120, 90],
            [1998, 3424, 37.5, 45],
            [1998, 3426, 120, 90],
            [1998, 3428, 70, 70],
            [1998, 3429, 46.45, 44.76],
            [1998, 3431, 120, 90],
            [1998, 3432, 70, 70],
            [1998, 3433, 70, 70],
            [1998, 3434, 6.86, 5.46],
            [1998, 3436, 50, 60],
            [1998, 3437, 70, 70],
            [1998, 3438, 70, 70],
            [1998, 3439, 60.72, 58.05],
            [1998, 3440, 50, 60],
            [1998, 3441, 59.78, 46.81],
            [1998, 3442, 42.15, 37.9],
            [1998, 3444, 30, 45],
            [1998, 3445, 70, 70],
            [1998, 3448, 5.56, 6.38],
            [1998, 3449, 70, 70],
            [1998, 3450, 70, 70],
            [1998, 3451, 120, 90],
            [1998, 3452, 120, 90],
            [1998, 3453, 15.33, 23.54],
            [1998, 3454, 18.63, 15.82],
            [1998, 3456, 120, 90],
            [1998, 3457, 120, 90],
            [1998, 3459, 120, 90],
            [1998, 3461, 70, 70],
            [1998, 3462, 70, 24.96],
            [1998, 3463, 120, 90],
            [1998, 3464, 120, 90],
            [1998, 3468, 73.94, 42.49],
            [1998, 3469, 34.89, 19.21],
            [1998, 3471, 70, 70],
            [1998, 3473, 22.49, 13.06],
            [1998, 3474, 70, 70],
            [1998, 3476, 40, 50],
            [1998, 3480, 120, 90],
            [1998, 3481, 70, 70],
            [1998, 3482, 32.24, 21.39],
            [1998, 3483, 70, 70],
            [1998, 3484, 120, 90],
            [1998, 3485, 50, 60],
            [1998, 3487, 20.67, 13.88],
            [1998, 3488, 50, 60],
            [1998, 3489, 40, 50],
            [1998, 3492, 120, 90],
            [1998, 3493, 70, 70],
            [1998, 3494, 40, 50],
            [1998, 3496, 120, 90],
            [1998, 3497, 120, 90],
            [1998, 3498, 40, 50],
            [1998, 3499, 120, 90],
            [1998, 3501, 120, 90],
            [1998, 3503, 120, 90],
            [1998, 3504, 70, 70],
            [1998, 3505, 120, 90],
            [1998, 3508, 120, 90],
            [1998, 3509, 50, 60],
            [1998, 3510, 120, 90],
            [1998, 3511, 70, 70],
            [1998, 3514, 50, 60],
            [1998, 3515, 70, 70],
            [1998, 3516, 120, 90],
            [1998, 3517, 70, 70],
            [1998, 3518, 120, 90],
            [1998, 3519, 50, 60],
            [1998, 3520, 120, 90],
            [1998, 3521, 120, 90],
            [1998, 3523, 35.02, 25.49],
            [1998, 3525, 120, 90],
            [1998, 3527, 120, 90],
            [1998, 3530, 70, 70],
            [1998, 3531, 70.97, 39.98],
            [1998, 3534, 70, 70],
            [1998, 3535, 30, 45],
            [1998, 3537, 120, 90],
            [1998, 3539, 120, 90],
            [1998, 3541, 42.81, 43.65],
            [1998, 3543, 120, 90],
            [1998, 3545, 120, 90],
            [1998, 3546, 35.02, 25.49],
            [1998, 3549, 22.69, 14.46],
            [1998, 3551, 120, 90],
            [1998, 3553, 70, 70],
            [1998, 3554, 50, 60],
            [1998, 3555, 40, 50],
            [1998, 3557, 16.81, 25.35],
            [1998, 3558, 70, 70],
            [1998, 3559, 50, 60],
            [1998, 3560, 120, 90],
            [1998, 3561, 120, 90],
            [1998, 3564, 120, 90],
            [1998, 3566, 17.61, 17.41],
            [1998, 3568, 12.22, 9.98],
            [1998, 3569, 50, 60],
            [1998, 3570, 70, 70],
            [1998, 3571, 70, 70],
            [1998, 3572, 120, 90],
            [1998, 3573, 120, 90],
            [1998, 3575, 120, 90],
            [1998, 3576, 120, 90],
            [1998, 3577, 120, 90],
            [1998, 3579, 40, 50],
            [1998, 3580, 70, 70],
            [1998, 3581, 120, 90],
            [1998, 3582, 4.45, 5.68],
            [1998, 3583, 120, 90],
            [1998, 3585, 70, 70],
            [1998, 3586, 70, 70],
            [1998, 3587, 70, 70],
            [1998, 3588, 120, 90],
            [1998, 3589, 70, 70],
            [1998, 3590, 40, 50],
            [1998, 3592, 70, 70],
            [1998, 3593, 70, 70],
            [1998, 3594, 120, 90],
            [1998, 3595, 120, 90],
            [1998, 3596, 35.02, 25.49],
            [1998, 3597, 70, 70],
            [1998, 3598, 22.96, 24.32],
            [1998, 3599, 120, 90],
            [1998, 3600, 70, 70],
            [1998, 3601, 40, 50],
            [1998, 3602, 51.79, 46.05],
            [1998, 3606, 40, 50],
            [1998, 3607, 70, 70],
            [1998, 3608, 33.57, 26.7],
            [1998, 3609, 120, 90],
            [1998, 3610, 50, 60],
            [1998, 3611, 70, 70],
            [1998, 3612, 70, 70],
            [1998, 3613, 40, 50],
            [1998, 3614, 9.76, 9.91],
            [1998, 3615, 70, 70],
            [1998, 3617, 70, 70],
            [1998, 3619, 70, 70],
            [1998, 3620, 50, 60],
            [1998, 3621, 50, 60],
            [1998, 3622, 120, 90],
            [1998, 3623, 120, 90],
            [1998, 3624, 18.29, 11.74],
            [1998, 3626, 120, 90],
            [1998, 3627, 120, 90],
            [1998, 3628, 30, 45],
            [1998, 3629, 32.24, 21.39],
            [1998, 3631, 70, 70],
            [1998, 3632, 47.16, 37.74],
            [1998, 3633, 70, 70],
            [1998, 3634, 24.1, 17.24],
            [1998, 3635, 50, 60],
            [1998, 3636, 70, 70],
            [1998, 3637, 40, 50],
            [1998, 3639, 120, 90],
            [1998, 3641, 40, 50],
            [1998, 3642, 58.18, 27.21],
            [1998, 3643, 70, 70],
            [1998, 3644, 36.34, 36.78],
            [1998, 3647, 120, 90],
            [1998, 3648, 70, 70],
            [1998, 3649, 120, 90],
            [1998, 3650, 93.96, 49.61],
            [1998, 3651, 40, 50],
            [1998, 3652, 40, 50],
            [1998, 3653, 52.81, 42.1],
            [1998, 3656, 16.63, 13.83],
            [1998, 3657, 40, 50],
            [1998, 3659, 120, 90],
            [1998, 3661, 49.38, 28.07],
            [1998, 3662, 30, 45],
            [1998, 3663, 120, 90],
            [1998, 3665, 120, 90],
            [1998, 3666, 35.02, 25.49],
            [1998, 3667, 30.55, 36.38],
            [1998, 3668, 120, 90],
            [1998, 3669, 50, 60],
            [1998, 3670, 91.39, 52.48],
            [1998, 3671, 120, 90],
            [1998, 3674, 70, 70],
            [1998, 3675, 120, 90],
            [1998, 3676, 120, 90],
            [1998, 3677, 50, 60],
            [1998, 3678, 6.48, 4.68],
            [1998, 3679, 29.5, 43.67],
            [1998, 3681, 70, 70],
            [1998, 3683, 70, 70],
            [1998, 3685, 120, 90],
            [1998, 3686, 35.02, 25.49],
            [1998, 3687, 70, 70],
            [1998, 3688, 120, 90],
            [1998, 3690, 120, 90],
            [1998, 3691, 14.78, 14.29],
            [1998, 3692, 50, 60],
            [1998, 3694, 70, 70],
            [1998, 3695, 35.02, 25.49],
            [1998, 3696, 70, 70],
            [1998, 3697, 20, 24],
            [1998, 3698, 120, 90],
            [1998, 3700, 25.38, 59.21],
            [1998, 3701, 40, 50],
            [1998, 3702, 18.29, 11.85],
            [1998, 3703, 175.88, 66.13],
            [1998, 3705, 14.08, 13.22],
            [1998, 3707, 70, 70],
            [1998, 3708, 70, 70],
            [1998, 3710, 50, 60],
            [1998, 3711, 15.93, 11.6],
            [1998, 3713, 70, 70],
            [1998, 3714, 120, 90],
            [1998, 3716, 120, 90],
            [1998, 3718, 70, 70],
            [1998, 3719, 35.02, 25.49],
            [1998, 3720, 50, 60],
            [1998, 3722, 40, 50],
            [1998, 3723, 30, 45],
            [1998, 3724, 12.29, 14.45],
            [1998, 3726, 70, 70],
            [1998, 3728, 120, 90],
            [1998, 3729, 120, 90],
            [1998, 3731, 120, 90],
            [1998, 3733, 120, 90],
            [1998, 3738, 30, 45],
            [1998, 3741, 120, 90],
            [1998, 3744, 120, 90],
            [1998, 3745, 120, 90],
            [1998, 3747, 33.24, 30.21],
            [1998, 3748, 120, 90],
            [1998, 3749, 35.02, 25.49],
            [1998, 3751, 27.22, 22.15],
            [1998, 3752, 120, 90],
            [1998, 3753, 50, 60],
            [1998, 3754, 120, 90],
            [1998, 3755, 31.04, 34.22],
            [1998, 3756, 120, 90],
            [1998, 3757, 70, 70],
            [1998, 3758, 120, 90],
            [1998, 3759, 120, 90],
            [1998, 3761, 36.17, 17.01],
            [1998, 3762, 50, 60],
            [1998, 3763, 70, 70],
            [1998, 3764, 50, 60],
            [1998, 3765, 36.87, 29.24],
            [1998, 3766, 50, 60],
            [1998, 3768, 70, 70],
            [1998, 3769, 120, 90],
            [1998, 3775, 50, 60],
            [1998, 3776, 120, 90],
            [1998, 3777, 64.75, 33.71],
            [1998, 3780, 70, 70],
            [1998, 3781, 120, 90],
            [1998, 3782, 33.84, 17.76],
            [1998, 3783, 70, 70],
            [1998, 3785, 35.02, 25.49],
            [1998, 3786, 50, 60],
            [1998, 3791, 120, 90],
            [1998, 3792, 120, 90],
            [1998, 3793, 70, 70],
            [1998, 3795, 28.93, 71.01],
            [1998, 3796, 34.35, 19.61],
            [1998, 3797, 120, 90],
            [1998, 3799, 50, 60],
            [1998, 3800, 70, 70],
            [1998, 3801, 120, 90],
            [1998, 3802, 50, 60],
            [1998, 3804, 70, 70],
            [1998, 3807, 23.88, 19.39],
            [1998, 3811, 50, 60],
            [1998, 3812, 120, 90],
            [1998, 3814, 70, 70],
            [1998, 3815, 11.6, 10.05],
            [1998, 3816, 120, 90],
            [1998, 3818, 40, 50],
            [1998, 3820, 50, 60],
            [1998, 3821, 120, 90],
            [1998, 3822, 120, 90],
            [1998, 3824, 70, 70],
            [1998, 3826, 70, 70],
            [1998, 3827, 104.49, 49.9],
            [1998, 3828, 48.71, 27.21],
            [1998, 3830, 8.66, 6.14],
            [1998, 3832, 58.73, 69.61],
            [1998, 3833, 30, 45],
            [1998, 3834, 82.66, 53.29],
            [1998, 3837, 70, 70],
            [1998, 3839, 120, 90],
            [1998, 3840, 120, 90],
            [1998, 3841, 115.85, 58.55],
            [1998, 3842, 50, 60],
            [1998, 3843, 120, 90],
            [1998, 3845, 16.28, 21.19],
            [1998, 3846, 70, 70],
            [1998, 3849, 32.24, 21.39],
            [1998, 3850, 120, 90],
            [1998, 3851, 120, 90],
            [1998, 3853, 35.02, 25.49],
            [1998, 3854, 20.59, 23],
            [1998, 3855, 120, 90],
            [1998, 3856, 120, 90],
            [1998, 3858, 120, 90],
            [1998, 3859, 70, 70],
            [1998, 3862, 70, 70],
            [1998, 3863, 50, 60],
            [1998, 3865, 120, 90],
            [1998, 3866, 15.15, 16.66],
            [1998, 3867, 35.02, 25.49],
            [1998, 3868, 120, 90],
            [1998, 3869, 16, 20],
            [1998, 3870, 113.75, 53.42],
            [1998, 3871, 46.79, 28.4],
            [1998, 3873, 120, 90],
            [1998, 3874, 41.13, 34.16],
            [1998, 3877, 40, 50],
            [1998, 3879, 120, 90],
            [1998, 3880, 19.75, 22.98],
            [1998, 3881, 50, 60],
            [1998, 3882, 120, 90],
            [1998, 3883, 57.22, 73.4],
            [1998, 3884, 70, 70],
            [1998, 3886, 70, 70],
            [1998, 3887, 120, 90],
            [1998, 3889, 70, 70],
            [1998, 3890, 10.56, 9.77],
            [1998, 3891, 70, 70],
            [1998, 3892, 70, 70],
            [1998, 3896, 70, 70],
            [1998, 3897, 46.88, 27.21],
            [1998, 3898, 120, 90],
            [1998, 3899, 120, 90],
            [1998, 3900, 50.61, 29.08],
            [1998, 3901, 70, 70],
            [1998, 3903, 50, 60],
            [1998, 3905, 90.98, 55.27],
            [1998, 3906, 70, 70],
            [1998, 3909, 120, 90],
            [1998, 3910, 32.24, 21.39],
            [1998, 3915, 30, 45],
            [1998, 3916, 120, 90],
            [1998, 3918, 8.88, 7.78],
            [1998, 3919, 120, 90],
            [1998, 3921, 34.37, 32.04],
            [1998, 3922, 120, 90],
            [1998, 3923, 70, 70],
            [1998, 3924, 14.82, 9.49],
            [1998, 3925, 120, 90],
            [1998, 3927, 70, 70],
            [1998, 3928, 19.06, 19.47],
            [1998, 3929, 120, 90],
            [1998, 3930, 70, 70],
            [1998, 3931, 70, 70],
            [1998, 3932, 32.72, 42.52],
            [1998, 3933, 120, 90],
            [1998, 3935, 120, 90],
            [1998, 3936, 120, 90],
            [1998, 3937, 70, 70],
            [1998, 3938, 50, 60],
            [1998, 3939, 50, 60],
            [1998, 3940, 50, 60],
            [1998, 3941, 120, 90],
            [1998, 3942, 32.24, 20.58],
            [1998, 3943, 16.04, 19.53],
            [1998, 3944, 35.02, 25.49],
            [1998, 3946, 13.42, 11.21],
            [1998, 3947, 120, 90],
            [1998, 3950, 120, 90],
            [1998, 3951, 120, 90],
            [1998, 3952, 120, 90],
            [1998, 3953, 130.15, 56.8],
            [1998, 3954, 120, 90],
            [1998, 3956, 50, 60],
            [1998, 3958, 13.07, 12.08],
            [1998, 3959, 107.55, 47.75],
            [1998, 3960, 26.79, 20.82],
            [1998, 3961, 10.48, 9.83],
            [1998, 3963, 24.93, 29.76],
            [1998, 3964, 70, 70],
            [1998, 3966, 70, 70],
            [1998, 3968, 40, 50],
            [1998, 3969, 73.5, 49.04],
            [1998, 3970, 22.45, 62.54],
            [1998, 3971, 120, 90],
            [1998, 3972, 120, 90],
            [1998, 3976, 70, 70],
            [1998, 3978, 70, 70],
            [1998, 3979, 70, 70],
            [1998, 3980, 50, 60],
            [1998, 3981, 70, 70],
            [1998, 3982, 120, 90],
            [1998, 3983, 30, 45],
            [1998, 3985, 70, 70],
            [1998, 3988, 120, 90],
            [1998, 3990, 70, 70],
            [1998, 3991, 120, 90],
            [1998, 3992, 53.73, 58.98],
            [1998, 3993, 70, 70],
            [1998, 3994, 120, 90],
            [1998, 3996, 70, 70],
            [1998, 3997, 120, 90],
            [1998, 3998, 120, 90],
            [1998, 3999, 29.09, 38.47],
            [1998, 4001, 120, 90],
            [1998, 4002, 120, 90],
            [1998, 4003, 70, 70],
            [1998, 4004, 70, 70],
            [1998, 4005, 40, 50],
            [1998, 4007, 120, 90],
            [1998, 4008, 70, 70],
            [1998, 4009, 40, 50],
            [1998, 4010, 50, 60],
            [1998, 4012, 120, 90],
            [1998, 4013, 120, 90],
            [1998, 4014, 120, 90],
            [1998, 4015, 120, 90],
            [1998, 4016, 21, 33],
            [1998, 4017, 70, 70],
            [1998, 4018, 70, 70],
            [1998, 4019, 40, 50],
            [1998, 4021, 70, 70],
            [1998, 4022, 70, 70],
            [1998, 4023, 27.39, 27.85],
            [1998, 4024, 120, 90],
            [1998, 4025, 70, 70],
            [1998, 4026, 70, 70],
            [1998, 4027, 120, 90],
            [1998, 4028, 70, 70],
            [1998, 4031, 28.52, 48.27],
            [1998, 4033, 70, 70],
            [1998, 4034, 120, 90],
            [1998, 4035, 17.68, 13.86],
            [1998, 4038, 120, 90],
            [1998, 4040, 85.79, 70.07],
            [1998, 4041, 120, 90],
            [1998, 4043, 70, 70],
            [1998, 4045, 10.74, 9.07],
            [1998, 4047, 44.52, 35.91],
            [1998, 4048, 50, 60],
            [1998, 4049, 70, 70],
            [1998, 4051, 120, 90],
            [1998, 4053, 70, 70],
            [1998, 4057, 50, 60],
            [1998, 4059, 70, 70],
            [1998, 4062, 70, 70],
            [1998, 4063, 50, 60],
            [1998, 4065, 50, 60],
            [1998, 4066, 70, 70],
            [1998, 4067, 70, 70],
            [1998, 4068, 120, 90],
            [1998, 4069, 50, 60],
            [1998, 4070, 70, 70],
            [1998, 4071, 70, 70],
            [1998, 4072, 120, 90],
            [1998, 4073, 30, 45],
            [1998, 4074, 70, 70],
            [1998, 4076, 120, 90],
            [1998, 4080, 120, 90],
            [1998, 4081, 120, 90],
            [1998, 4082, 120, 90],
            [1998, 4083, 120, 90],
            [1998, 4084, 14, 13.72],
            [1998, 4085, 70, 70],
            [1998, 4087, 120, 90],
            [1998, 4088, 120, 90],
            [1998, 4089, 120, 90],
            [1998, 4090, 120, 90],
            [1998, 4091, 70, 70],
            [1998, 4092, 70, 70],
            [1998, 4093, 120, 90],
            [1998, 4094, 32.24, 21.39],
            [1998, 4095, 37.45, 42.54],
            [1998, 4096, 37.85, 49.46],
            [1998, 4097, 120, 90],
            [1998, 4100, 50, 60],
            [1998, 4101, 120, 90],
            [1998, 4102, 70, 70],
            [1998, 4103, 70, 70],
            [1998, 4104, 70, 70],
            [1998, 4105, 120, 90],
            [1998, 4106, 12.41, 18.24],
            [1998, 4107, 120, 90],
            [1998, 4108, 120, 90],
            [1998, 4109, 11.09, 23.39],
            [1998, 4110, 70, 70],
            [1998, 4111, 53.38, 47.38],
            [1998, 4112, 40, 50],
            [1998, 4115, 120, 90],
            [1998, 4116, 31.55, 32.55],
            [1998, 4117, 50, 60],
            [1998, 4118, 41.47, 35.71],
            [1998, 4119, 35.02, 25.49],
            [1998, 4120, 27.58, 30.03],
            [1998, 4121, 70, 70],
            [1998, 4122, 120, 90],
            [1998, 4124, 46.81, 38.06],
            [1998, 4125, 70, 70],
            [1998, 4128, 70, 70],
            [1998, 4129, 14.49, 12.39],
            [1998, 4131, 16.41, 11.51],
            [1998, 4133, 70, 70],
            [1998, 4134, 79.03, 44.3],
            [1998, 4136, 50, 60],
            [1998, 4137, 120, 90],
            [1998, 4138, 11.77, 6.96],
            [1998, 4139, 30, 45],
            [1998, 4140, 70, 70],
            [1998, 4142, 70, 70],
            [1998, 4143, 50, 60],
            [1998, 4145, 120, 90],
            [1998, 4146, 6.49, 5.75],
            [1998, 4147, 120, 90],
            [1998, 4149, 50, 60],
            [1998, 4150, 70, 70],
            [1998, 4152, 106.07, 54.99],
            [1998, 4154, 120, 90],
            [1998, 4155, 70, 70],
            [1998, 4156, 76.31, 53.54],
            [1998, 4157, 70, 70],
            [1998, 4158, 120, 90],
            [1998, 4159, 6.8, 6.9],
            [1998, 4162, 120, 90],
            [1998, 4164, 20.48, 22.01],
            [1998, 4165, 120, 90],
            [1998, 4166, 30, 45],
            [1998, 4167, 70, 70],
            [1998, 4168, 37.5, 45],
            [1998, 4169, 35.25, 45.76],
            [1998, 4173, 50, 60],
            [1998, 4175, 40, 50],
            [1998, 4176, 50, 60],
            [1998, 4177, 40.07, 56.69],
            [1998, 4178, 120, 90],
            [1998, 4179, 23.41, 16.69],
            [1998, 4180, 14.1, 9.29],
            [1998, 4181, 70, 70],
            [1998, 4182, 76.84, 36.41],
            [1998, 4185, 27.78, 27.06],
            [1998, 4186, 50, 60],
            [1998, 4188, 120, 90],
            [1998, 4189, 50, 60],
            [1998, 4190, 120, 90],
            [1998, 4192, 50, 60],
            [1998, 4193, 120, 90],
            [1998, 4194, 120, 90],
            [1998, 4197, 50, 60],
            [1998, 4199, 78.4, 74.93],
            [1998, 4200, 13.33, 9.28],
            [1998, 4203, 62.98, 58.18],
            [1998, 4204, 50, 60],
            [1998, 4205, 120, 90],
            [1998, 4206, 40, 50],
            [1998, 4207, 50, 60],
            [1998, 4208, 120, 90],
            [1998, 4209, 120, 90],
            [1998, 4210, 40, 50],
            [1998, 4211, 120, 90],
            [1998, 4213, 70, 70],
            [1998, 4215, 35.02, 25.49],
            [1998, 4216, 120, 90],
            [1998, 4219, 30, 45],
            [1998, 4220, 120, 90],
            [1998, 4221, 32.24, 21.39],
            [1998, 4222, 120, 90],
            [1998, 4223, 9.96, 8.54],
            [1998, 4224, 70, 70],
            [1998, 4225, 120, 90],
            [1998, 4226, 73.7, 42.65],
            [1998, 4229, 36.01, 22.9],
            [1998, 4230, 70, 70],
            [1998, 4231, 70, 70],
            [1998, 4232, 40, 50],
            [1998, 4233, 40, 50],
            [1998, 4234, 50, 60],
            [1998, 4235, 13.03, 13.29],
            [1998, 4236, 70, 70],
            [1998, 4237, 120, 90],
            [1998, 4238, 120, 90],
            [1998, 4239, 120, 90],
            [1998, 4241, 120, 90],
            [1998, 4242, 46.74, 74.49],
            [1998, 4244, 11.58, 16.71],
            [1998, 4245, 50, 60],
            [1998, 4246, 23.77, 36.35],
            [1998, 4248, 70, 70],
            [1998, 4249, 120, 90],
            [1998, 4250, 120, 90],
            [1998, 4251, 120, 90],
            [1998, 4252, 11.19, 9.3],
            [1998, 4256, 50, 60],
            [1998, 4257, 40, 50],
            [1998, 4258, 50, 60],
            [1998, 4259, 12.25, 12.29],
            [1998, 4260, 120, 90],
            [1998, 4261, 20, 24],
            [1998, 4264, 13.05, 10.17],
            [1998, 4265, 70, 70],
            [1998, 4266, 120, 90],
            [1998, 4269, 120, 90],
            [1998, 4270, 120, 90],
            [1998, 4272, 98.28, 54.81],
            [1998, 4273, 120, 90],
            [1998, 4274, 120, 90],
            [1998, 4275, 70, 70],
            [1998, 4279, 25.11, 25.86],
            [1998, 4281, 70, 70],
            [1998, 4282, 50, 60],
            [1998, 4283, 19.15, 24.03],
            [1998, 4284, 120, 90],
            [1998, 4285, 50, 60],
            [1998, 4286, 120, 90],
            [1998, 4287, 25.96, 16.87],
            [1998, 4288, 120, 90],
            [1998, 4289, 64.74, 40.71],
            [1998, 4290, 50, 60],
            [1998, 4291, 50, 60],
            [1998, 4293, 9.17, 7.22],
            [1998, 4294, 120, 90],
            [1998, 4295, 120, 90],
            [1998, 4296, 120, 90],
            [1998, 4297, 70, 70],
            [1998, 4298, 120, 90],
            [1998, 4299, 70, 70],
            [1998, 4301, 70, 70],
            [1998, 4302, 26.64, 23.08],
            [1998, 4305, 70, 70],
            [1998, 4307, 120, 90],
            [1998, 4308, 120, 90],
            [1998, 4309, 50, 60],
            [1998, 4310, 50, 60],
            [1998, 4312, 70, 70],
            [1998, 4313, 120, 90],
            [1998, 4317, 50, 60],
            [1998, 4318, 44.5, 31.24],
            [1998, 4320, 70, 70],
            [1998, 4323, 30, 45],
            [1998, 4325, 29.6, 19.97],
            [1998, 4326, 40, 50],
            [1998, 4328, 70, 70],
            [1998, 4329, 24.49, 21.37],
            [1998, 4330, 70, 70],
            [1998, 4333, 17.64, 32.54],
            [1998, 4334, 120, 90],
            [1998, 4337, 40, 50],
            [1998, 4338, 19.83, 26.04],
            [1998, 4339, 30, 45],
            [1998, 4340, 120, 90],
            [1998, 4341, 120, 90],
            [1998, 4343, 120, 90],
            [1998, 4345, 64.97, 47.25],
            [1998, 4346, 70, 70],
            [1998, 4347, 120, 90],
            [1998, 4349, 19.92, 20.51],
            [1998, 4350, 45.83, 36.77],
            [1998, 4352, 27.75, 35.04],
            [1998, 4353, 40.7, 33.52],
            [1998, 4355, 120, 90],
            [1998, 4356, 40, 50],
            [1998, 4358, 23.24, 26.31],
            [1998, 4360, 70, 70],
            [1998, 4362, 57.64, 39.46],
            [1998, 4363, 70, 70],
            [1998, 4364, 60.02, 38.25],
            [1998, 4365, 120, 90],
            [1998, 4366, 70, 70],
            [1998, 4367, 120, 90],
            [1998, 4372, 70, 70],
            [1998, 4374, 40, 50],
            [1998, 4375, 70, 70],
            [1998, 4376, 120, 90],
            [1998, 4377, 70, 70],
            [1998, 4378, 70, 70],
            [1998, 4380, 70, 70],
            [1998, 4382, 70, 70],
            [1998, 4383, 70, 70],
            [1998, 4384, 41.7, 25.8],
            [1998, 4386, 70, 70],
            [1998, 4387, 120, 90],
            [1998, 4389, 70, 70],
            [1998, 4390, 35.02, 25.49],
            [1998, 4391, 21.62, 31.72],
            [1998, 4392, 70, 70],
            [1998, 4394, 70, 70],
            [1998, 4395, 70, 70],
            [1998, 4396, 70, 70],
            [1998, 4397, 10.73, 9.29],
            [1998, 4398, 70, 70],
            [1998, 4399, 50, 60],
            [1998, 4400, 120, 90],
            [1998, 4402, 40, 50],
            [1998, 4404, 120, 90],
            [1998, 4405, 6.35, 4.6],
            [1998, 4406, 63.31, 68.07],
            [1998, 4407, 70, 70],
            [1998, 4408, 120, 90],
            [1998, 4409, 120, 90],
            [1998, 4410, 70, 70],
            [1998, 4411, 120, 90],
            [1998, 4412, 120, 90],
            [1998, 4413, 50, 60],
            [1998, 4414, 70, 70],
            [1998, 4415, 126.64, 97.53],
            [1998, 4416, 70, 70],
            [1998, 4417, 50, 60],
            [1998, 4418, 70, 70],
            [1998, 4419, 70, 70],
            [1998, 4420, 7.46, 6.7],
            [1998, 4421, 76.43, 44.44],
            [1998, 4426, 70, 70],
            [1998, 4427, 40, 50],
            [1998, 4428, 32.24, 21.39],
            [1998, 4432, 32.24, 21.39],
            [1998, 4433, 120, 90],
            [1998, 4436, 40, 50],
            [1998, 4438, 50, 60],
            [1998, 4439, 40, 50],
            [1998, 4440, 70, 70],
            [1998, 4441, 120, 90],
            [1998, 4442, 70, 70],
            [1998, 4443, 70, 70],
            [1998, 4444, 120, 90],
            [1998, 4445, 70, 70],
            [1998, 4446, 34.09, 21.45],
            [1998, 4448, 70, 70],
            [1998, 4450, 120, 90],
            [1998, 4453, 70, 70],
            [1998, 4454, 25.13, 30.27],
            [1998, 4455, 70, 70],
            [1998, 4456, 70, 70],
            [1998, 4457, 40, 50],
            [1998, 4460, 120, 90],
            [1998, 4461, 25.09, 25.72],
            [1998, 4463, 50, 60],
            [1998, 4464, 44.69, 25.78],
            [1998, 4465, 70, 70],
            [1998, 4466, 70, 70],
            [1998, 4467, 120, 90],
            [1998, 4468, 70, 70],
            [1998, 4470, 50, 60],
            [1998, 4471, 135.92, 55.65],
            [1998, 4473, 32.24, 21.39],
            [1998, 4477, 37.5, 45],
            [1998, 4479, 120, 90],
            [1998, 4481, 120, 90],
            [1998, 4482, 120, 90],
            [1998, 4483, 120, 90],
            [1998, 4484, 120, 90],
            [1998, 4486, 120, 90],
            [1998, 4487, 50, 60],
            [1998, 4488, 70, 70],
            [1998, 4489, 11.71, 6.08],
            [1998, 4490, 120, 90],
            [1998, 4491, 70, 70],
            [1998, 4493, 70, 70],
            [1998, 4494, 120, 90],
            [1998, 4495, 82.86, 52.5],
            [1998, 4497, 50, 60],
            [1998, 4498, 70, 70],
            [1998, 4500, 17.11, 23.93],
            [1998, 4501, 120, 90],
            [1998, 4502, 50, 60],
            [1998, 4504, 29.9, 16.62],
            [1998, 4505, 70, 70],
            [1998, 4506, 32.1, 29.68],
            [1998, 4508, 120, 90],
            [1998, 4509, 120, 90],
            [1998, 4510, 33.56, 26.64],
            [1998, 4511, 70, 70],
            [1998, 4512, 12.38, 7.83],
            [1998, 4513, 120, 90],
            [1998, 4514, 120, 90],
            [1998, 4515, 33.39, 72.42],
            [1998, 4517, 50, 60],
            [1998, 4518, 72.62, 43.09],
            [1998, 4520, 50, 60],
            [1998, 4521, 115.81, 56],
            [1998, 4523, 50, 60],
            [1998, 4524, 25.93, 22.72],
            [1998, 4525, 50, 60],
            [1998, 4526, 9.64, 9.7],
            [1998, 4527, 120, 90],
            [1998, 4530, 13.96, 9.89],
            [1998, 4531, 120, 90],
            [1998, 4532, 66.87, 50.91],
            [1998, 4533, 70, 70],
            [1998, 4534, 70, 70],
            [1998, 4535, 120, 90],
            [1998, 4536, 70, 70],
            [1998, 4538, 70, 70],
            [1998, 4539, 40, 50],
            [1998, 4540, 10.59, 6.68],
            [1998, 4541, 120, 90],
            [1998, 4542, 70, 70],
            [1998, 4543, 37.5, 45],
            [1998, 4545, 70, 70],
            [1998, 4546, 120, 90],
            [1998, 4548, 20.54, 15.72],
            [1998, 4549, 40, 50],
            [1998, 4550, 65.66, 48.34],
            [1998, 4551, 120, 90],
            [1998, 4552, 55.6, 45.56],
            [1998, 4553, 120, 90],
            [1998, 4555, 120, 90],
            [1998, 4556, 120, 90],
            [1998, 4558, 120, 90],
            [1998, 4560, 120, 90],
            [1998, 4563, 53.86, 28.78],
            [1998, 4565, 70, 70],
            [1998, 4566, 70, 70],
            [1998, 4568, 70, 70],
            [1998, 4569, 70, 70],
            [1998, 4571, 70, 70],
            [1998, 4572, 105.72, 48.73],
            [1998, 4576, 120, 90],
            [1998, 4577, 16.43, 13.85],
            [1998, 4578, 70, 70],
            [1998, 4579, 9.23, 6.62],
            [1998, 4580, 50, 60],
            [1998, 4582, 70, 70],
            [1998, 4584, 40, 50],
            [1998, 4585, 70, 70],
            [1998, 4587, 120, 90],
            [1998, 4590, 70, 70],
            [1998, 4591, 38.76, 40.37],
            [1998, 4593, 7.89, 6.27],
            [1998, 4597, 120, 90],
            [1998, 4598, 120, 90],
            [1998, 4599, 35.02, 25.49],
            [1998, 4600, 50, 60],
            [1998, 4601, 33.72, 42.28],
            [1998, 4602, 36.28, 36.4],
            [1998, 4603, 120, 90],
            [1998, 4604, 120, 90],
            [1998, 4605, 50, 60],
            [1998, 4606, 35.1, 31.57],
            [1998, 4607, 120, 90],
            [1998, 4608, 50, 60],
            [1998, 4610, 70, 70],
            [1998, 4611, 62.95, 50.94],
            [1998, 4612, 120, 90],
            [1998, 4613, 70, 70],
            [1998, 4614, 70, 70],
            [1998, 4615, 120, 90],
            [1998, 4616, 27.98, 41.56],
            [1998, 4617, 95.75, 69.39],
            [1998, 4618, 70, 70],
            [1998, 4619, 70, 70],
            [1998, 4620, 70, 70],
            [1998, 4621, 50, 60],
            [1998, 4622, 120, 90],
            [1998, 4623, 70, 70],
            [1998, 4626, 40, 50],
            [1998, 4627, 70, 70],
            [1998, 4628, 120, 90],
            [1998, 4629, 70, 70],
            [1998, 4630, 120, 90],
            [1998, 4631, 20.43, 22.07],
            [1998, 4633, 28.23, 35.68],
            [1998, 4634, 70, 70],
            [1998, 4635, 16.11, 11.7],
            [1998, 4636, 120, 90],
            [1998, 4637, 70, 70],
            [1998, 4638, 54.7, 34.62],
            [1998, 4641, 15.54, 8.85],
            [1998, 4643, 120, 90],
            [1998, 4644, 70, 70],
            [1998, 4645, 32.24, 21.39],
            [1998, 4648, 50, 60],
            [1998, 4649, 50, 60],
            [1998, 4651, 70, 70],
            [1998, 4652, 50, 60],
            [1998, 4653, 120, 90],
            [1998, 4655, 120, 90],
            [1998, 4657, 120, 90],
            [1998, 4658, 70, 70],
            [1998, 4660, 70, 70],
            [1998, 4661, 32.24, 21.39],
            [1998, 4662, 70, 70],
            [1998, 4664, 10.86, 8.78],
            [1998, 4665, 120, 90],
            [1998, 4666, 120, 90],
            [1998, 4667, 70, 70],
            [1998, 4668, 62.61, 42.44],
            [1998, 4670, 70, 70],
            [1998, 4671, 120, 90],
            [1998, 4674, 15, 20],
            [1998, 4675, 50, 60],
            [1998, 4676, 13.79, 18.19],
            [1998, 4677, 70, 70],
            [1998, 4679, 120, 90],
            [1998, 4680, 120, 90],
            [1998, 4682, 120, 90],
            [1998, 4684, 39.81, 23.32],
            [1998, 4685, 61.3, 38.03],
            [1998, 4687, 120, 90],
            [1998, 4688, 17.49, 12.85],
            [1998, 4689, 70, 70],
            [1998, 4690, 32.24, 21.39],
            [1998, 4691, 40, 50],
            [1998, 4692, 70, 70],
            [1998, 4693, 119.12, 52.9],
            [1998, 4694, 58.28, 38.29],
            [1998, 4695, 70, 70],
            [1998, 4696, 120, 90],
            [1998, 4697, 120, 90],
            [1998, 4698, 70, 70],
            [1998, 4699, 120, 90],
            [1998, 4701, 70, 70],
            [1998, 4702, 120, 90],
            [1998, 4703, 23.69, 36.87],
            [1998, 4704, 120, 90],
            [1998, 4705, 120, 90],
            [1998, 4708, 70, 70],
            [1998, 4709, 120, 90],
            [1998, 4710, 10.6, 9.61],
            [1998, 4711, 120, 90],
            [1998, 4712, 50.55, 38.31],
            [1998, 4713, 50, 60],
            [1998, 4716, 35.02, 25.49],
            [1998, 4717, 29.78, 34.18],
            [1998, 4718, 120, 90],
            [1998, 4720, 50, 60],
            [1998, 4722, 120, 90],
            [1998, 4724, 50, 60],
            [1998, 4725, 8.65, 7.78],
            [1998, 4726, 120, 90],
            [1998, 4728, 25.36, 23.41],
            [1998, 4729, 68.67, 36.75],
            [1998, 4731, 4.74, 5.56],
            [1998, 4732, 50, 60],
            [1998, 4733, 70, 70],
            [1998, 4734, 40, 50],
            [1998, 4736, 32.24, 21.39],
            [1998, 4737, 120, 90],
            [1998, 4738, 120, 90],
            [1998, 4740, 70, 70],
            [1998, 4741, 70, 70],
            [1998, 4742, 120, 90],
            [1998, 4743, 32.24, 21.39],
            [1998, 4744, 40, 50],
            [1998, 4745, 40, 50],
            [1998, 4747, 55.87, 35.31],
            [1998, 4749, 70, 70],
            [1998, 4750, 9.46, 11.76],
            [1998, 4751, 50, 60],
            [1998, 4752, 70, 70],
            [1998, 4753, 88.11, 37.86],
            [1998, 4754, 120, 90],
            [1998, 4755, 14.14, 10.28],
            [1998, 4756, 40, 50],
            [1998, 4757, 120, 90],
            [1998, 4760, 120, 90],
            [1998, 4761, 22.44, 14.33],
            [1998, 4762, 52.5, 52.5],
            [1998, 4764, 120, 90],
            [1998, 4765, 50, 60],
            [1998, 4771, 70, 70],
            [1998, 4772, 70, 70],
            [1998, 4775, 32.24, 21.39],
            [1998, 4776, 37.5, 45],
            [1998, 4777, 24.04, 33.32],
            [1998, 4778, 50, 60],
            [1998, 4779, 70, 70],
            [1998, 4780, 110.99, 50.6],
            [1998, 4781, 30, 37.5],
            [1998, 4782, 70, 70],
            [1998, 4784, 120, 90],
            [1998, 4785, 120, 90],
            [1998, 4786, 120, 90],
            [1998, 4788, 50, 60],
            [1998, 4789, 70, 70],
            [1998, 4790, 70, 70],
            [1998, 4791, 48.77, 79.01],
            [1998, 4792, 70, 70],
            [1998, 4793, 120, 90],
            [1998, 4794, 70, 70],
            [1998, 4797, 50, 60],
            [1998, 4799, 70, 70],
            [1998, 4800, 17.87, 23.42],
            [1998, 4801, 70, 70],
            [1998, 4802, 128.4, 56.12],
            [1998, 4803, 70, 70],
            [1998, 4805, 70, 70],
            [1998, 4806, 70, 70],
            [1998, 4807, 50, 60],
            [1998, 4809, 120, 90],
            [1998, 4810, 120, 90],
            [1998, 4811, 50, 60],
            [1998, 4812, 120, 90],
            [1998, 4813, 50, 60],
            [1998, 4814, 120, 90],
            [1998, 4815, 39.69, 32.93],
            [1998, 4816, 70, 70],
            [1998, 4818, 120, 90],
            [1998, 4819, 57.44, 40.47],
            [1998, 4820, 70, 70],
            [1998, 4821, 120, 90],
            [1998, 4825, 120, 90],
            [1998, 4826, 28.39, 26.06],
            [1998, 4828, 70, 70],
            [1998, 4829, 45.03, 39.57],
            [1998, 4831, 9.72, 8.44],
            [1998, 4832, 70, 70],
            [1998, 4834, 120, 90],
            [1998, 4835, 51.6, 40.69],
            [1998, 4838, 40, 50],
            [1998, 4839, 37.82, 38.91],
            [1998, 4840, 70, 70],
            [1998, 4841, 120, 90],
            [1998, 4842, 120, 90],
            [1998, 4844, 49.21, 40.22],
            [1998, 4846, 120, 90],
            [1998, 4848, 120, 90],
            [1998, 4849, 40, 50],
            [1998, 4851, 120, 90],
            [1998, 4852, 70, 70],
            [1998, 4853, 70, 70],
            [1998, 4854, 120, 90],
            [1998, 4856, 120, 90],
            [1998, 4863, 70, 70],
            [1998, 4864, 8.85, 15.97],
            [1998, 4865, 40, 50],
            [1998, 4866, 15, 25],
            [1998, 4867, 120, 90],
            [1998, 4869, 120, 90],
            [1998, 4871, 21.01, 27.1],
            [1998, 4872, 26.5, 30.18],
            [1998, 4875, 70, 70],
            [1998, 4876, 40, 50],
            [1998, 4877, 18.65, 29.18],
            [1998, 4878, 50, 60],
            [1998, 4879, 120, 90],
            [1998, 4880, 70, 70],
            [1998, 4881, 32.11, 49.85],
            [1998, 4882, 120, 90],
            [1998, 4885, 120, 90],
            [1998, 4887, 120, 90],
            [1998, 4888, 70, 70],
            [1998, 4893, 50, 60],
            [1998, 4894, 50, 60],
            [1998, 4895, 120, 90],
            [1998, 4896, 70, 70],
            [1998, 4897, 22.65, 32.49],
            [1998, 4902, 70, 70],
            [1998, 4905, 40, 50],
            [1998, 4906, 40, 50],
            [1998, 4907, 70, 70],
            [1998, 4909, 40, 50],
            [1998, 4910, 16.17, 15.54],
            [1998, 4911, 11.82, 7.07],
            [1998, 4912, 12.39, 15.28],
            [1998, 4914, 120, 90],
            [1998, 4915, 12.81, 25.88],
            [1998, 4916, 70, 70],
            [1998, 4918, 29.8, 29.23],
            [1998, 4920, 50, 60],
            [1998, 4922, 68.28, 37.1],
            [1998, 4923, 120, 90],
            [1998, 4926, 120, 90],
            [1998, 4927, 28.01, 18.8],
            [1998, 4928, 70, 70],
            [1998, 4929, 70, 70],
            [1998, 4930, 70, 70],
            [1998, 4931, 34.13, 33.6],
            [1998, 4934, 70, 70],
            [1998, 4936, 120, 90],
            [1998, 4939, 28.05, 30.31],
            [1998, 4940, 95.48, 82.93],
            [1998, 4942, 50, 60],
            [1998, 4944, 70, 70],
            [1998, 4945, 120, 90],
            [1998, 4946, 120, 90],
            [1998, 4949, 50, 60],
            [1998, 4950, 70.53, 51.44],
            [1998, 4951, 70, 70],
            [1998, 4953, 35.02, 25.49],
            [1998, 4954, 70, 70],
            [1998, 4955, 25.46, 23.67],
            [1998, 4956, 32.24, 21.39],
            [1998, 4957, 64.8, 59.23],
            [1998, 4958, 120, 90],
            [1998, 4960, 101.39, 50.61],
            [1998, 4962, 70, 70],
            [1998, 4963, 70, 70],
            [1998, 4964, 7.37, 6.44],
            [1998, 4965, 50, 60],
            [1998, 4966, 70, 70],
            [1998, 4968, 120, 90],
            [1998, 4971, 32.24, 21.39],
            [1998, 4972, 35.02, 25.49],
            [1998, 4973, 70, 70],
            [1998, 4974, 50, 60],
            [1998, 4975, 49.84, 42.61],
            [1998, 4976, 40, 50],
            [1998, 4977, 120, 90],
            [1998, 4978, 120, 90],
            [1998, 4979, 56.77, 40.85],
            [1998, 4981, 50, 60],
            [1998, 4983, 29.76, 20.92],
            [1998, 4984, 40, 50],
            [1998, 4985, 6.45, 5.95],
            [1998, 4987, 55.01, 32.18],
            [1998, 4988, 70, 70],
            [1998, 4989, 120, 90],
            [1998, 4990, 106.41, 53.31],
            [1998, 4992, 45.11, 33.84],
            [1998, 4994, 120, 90],
            [1998, 4995, 23.94, 28.78],
            [1998, 4996, 16.69, 30.91],
            [1998, 4997, 78.17, 40.51],
            [1998, 4998, 49.03, 43.06],
            [1998, 5000, 13.36, 12.29],
            [1998, 5001, 70, 70],
            [1998, 5002, 120, 90],
            [1998, 5003, 120, 90],
            [1998, 5005, 18.06, 19.95],
            [1998, 5006, 120, 90],
            [1998, 5007, 120, 90],
            [1998, 5008, 126.38, 53.28],
            [1998, 5009, 18.59, 27.74],
            [1998, 5010, 8.39, 5.61],
            [1998, 5011, 15.78, 16.19],
            [1998, 5012, 39.94, 45.98],
            [1998, 5013, 46.69, 34.25],
            [1998, 5014, 70, 70],
            [1998, 5017, 9.26, 20.62],
            [1998, 5019, 70, 70],
            [1998, 5020, 40, 50],
            [1998, 5022, 137.19, 88.29],
            [1998, 5023, 70, 70],
            [1998, 5025, 120, 90],
            [1998, 5026, 120, 90],
            [1998, 5027, 32.18, 30.47],
            [1998, 5031, 40, 50],
            [1998, 5032, 26.02, 40.08],
            [1998, 5033, 73.53, 35.42],
            [1998, 5034, 120, 90],
            [1998, 5035, 32.19, 33.94],
            [1998, 5036, 120, 90],
            [1998, 5037, 91.49, 46.75],
            [1998, 5038, 70, 70],
            [1998, 5041, 120, 90],
            [1998, 5043, 50, 60],
            [1998, 5044, 70, 70],
            [1998, 5046, 29.35, 32.47],
            [1998, 5048, 70, 70],
            [1998, 5049, 120, 90],
            [1998, 5050, 50, 60],
            [1998, 5051, 50, 60],
            [1998, 5053, 77.54, 45.07],
            [1998, 5054, 120, 90],
            [1998, 5056, 120, 90],
            [1998, 5057, 120, 90],
            [1998, 5058, 48.62, 42.89],
            [1998, 5060, 120, 90],
            [1998, 5061, 120, 90],
            [1998, 5062, 70, 70],
            [1998, 5063, 40, 50],
            [1998, 5064, 20.75, 20.03],
            [1998, 5065, 100.18, 69.74],
            [1998, 5066, 120, 90],
            [1998, 5068, 164.36, 62.76],
            [1998, 5069, 149.63, 54.69],
            [1998, 5070, 15.65, 30],
            [1998, 5071, 33.7, 31.78],
            [1998, 5072, 120, 90],
            [1998, 5073, 50, 60],
            [1998, 5075, 21.04, 24.86],
            [1998, 5077, 40, 50],
            [1998, 5079, 61.44, 42.57],
            [1998, 5081, 120, 90],
            [1998, 5082, 12.57, 13.41],
            [1998, 5083, 6.36, 5.53],
            [1998, 5084, 50, 60],
            [1998, 5085, 50, 60],
            [1998, 5087, 120, 90],
            [1998, 5088, 120, 90],
            [1998, 5091, 120, 90],
            [1998, 5092, 50, 60],
            [1998, 5093, 50, 60],
            [1998, 5094, 40, 50],
            [1998, 5095, 50, 60],
            [1998, 5097, 120, 90],
            [1998, 5098, 47.1, 29.63],
            [1998, 5099, 70, 70],
            [1998, 5100, 120, 90],
            [1998, 5101, 5.93, 6.65],
            [1998, 5102, 120, 90],
            [1998, 5103, 89.21, 43],
            [1998, 5104, 120, 90],
            [1998, 5107, 120, 90],
            [1998, 5108, 70, 70],
            [1998, 5109, 93.01, 45.96],
            [1998, 5111, 35.02, 25.49],
            [1998, 5114, 4.87, 4],
            [1998, 5115, 120, 90],
            [1998, 5116, 22.23, 21.49],
            [1998, 5117, 40, 50],
            [1998, 5119, 120, 90],
            [1998, 5121, 30.65, 46.26],
            [1998, 5122, 21.51, 31.21],
            [1998, 5123, 15.99, 15.06],
            [1998, 5124, 70, 70],
            [1998, 5126, 26.81, 24.11],
            [1998, 5127, 32.57, 20.36],
            [1998, 5128, 32.24, 21.39],
            [1998, 5130, 50, 60],
            [1998, 5132, 120, 90],
            [1998, 5135, 50, 60],
            [1998, 5136, 11.5, 8.4],
            [1998, 5137, 120, 90],
            [1998, 5138, 120, 90],
            [1998, 5141, 50, 60],
            [1998, 5143, 70, 70],
            [1998, 5145, 35.02, 25.49],
            [1998, 5149, 120, 90],
            [1998, 5150, 52.83, 33.37],
            [1998, 5153, 179.52, 59.91],
            [1998, 5154, 120, 90],
            [1998, 5155, 70, 70],
            [1998, 5156, 40, 50],
            [1998, 5157, 50, 60],
            [1998, 5159, 52.86, 48.43],
            [1998, 5160, 120, 90],
            [1998, 5161, 50, 60],
            [1998, 5162, 65.6, 46.34],
            [1998, 5163, 120, 90],
            [1998, 5164, 120, 90],
            [1998, 5165, 70, 70],
            [1998, 5166, 50, 60],
            [1998, 5167, 120, 90],
            [1998, 5169, 120, 90],
            [1998, 5171, 120, 90],
            [1998, 5172, 70, 70],
            [1998, 5173, 46.38, 41.15],
            [1998, 5174, 70, 70],
            [1998, 5178, 120, 90],
            [1998, 5180, 86.39, 54.81],
            [1998, 5181, 120, 90],
            [1998, 5182, 16.01, 20.04],
            [1998, 5183, 30.09, 35.52],
            [1998, 5184, 120, 90],
            [1998, 5185, 70, 70],
            [1998, 5186, 70, 70],
            [1998, 5187, 70, 70],
            [1998, 5188, 70, 70],
            [1998, 5189, 40, 50],
            [1998, 5191, 70, 70],
            [1998, 5192, 15, 25],
            [1998, 5193, 15, 25],
            [1998, 5194, 15, 25],
            [1998, 5195, 15, 25],
            [1998, 5196, 15, 25],
            [1998, 5197, 15, 25],
            [1998, 5198, 15, 25],
            [1998, 5199, 15, 25],
            [1998, 5200, 15, 25],
            [1998, 5201, 15, 25],
            [1998, 5202, 15, 25],
            [1998, 5203, 15, 25],
            [1998, 5204, 40, 50],
            [1998, 5205, 15, 25],
            [1998, 5206, 15, 25],
            [1998, 5207, 15, 25],
            [1998, 5208, 15, 25],
            [1998, 5209, 15, 25],
            [1998, 5210, 15, 25],
            [1998, 5211, 15, 25],
            [1998, 5212, 15, 25],
            [1998, 5213, 15, 25],
            [1998, 5214, 15, 25],
            [1998, 5215, 15, 25],
            [1998, 5216, 15, 25],
            [1998, 5217, 70, 70],
            [1998, 5219, 70, 70],
            [1998, 5220, 70, 70],
            [1998, 5221, 40, 50],
            [1998, 5222, 120, 90],
            [1998, 5223, 70, 70],
            [1998, 5224, 120, 90],
            [1998, 5225, 70, 70],
            [1998, 5226, 70, 70],
            [1998, 5227, 70, 70],
            [1998, 5228, 120, 90],
            [1998, 5229, 70, 70],
            [1998, 5230, 70, 70],
            [1998, 5231, 50, 60],
            [1998, 5232, 70, 70],
            [1998, 5233, 120, 90],
            [1998, 5234, 40, 50],
            [1998, 5235, 70, 70],
            [1998, 5236, 50, 60],
            [1998, 5237, 70, 70],
            [1998, 5238, 50, 60],
            [1998, 5239, 70, 70],
            [1998, 5240, 120, 90],
            [1998, 5241, 70, 70],
            [1998, 5242, 50, 60],
            [1998, 5243, 70, 70],
            [1998, 5244, 120, 90],
            [1998, 5245, 70, 70],
            [1998, 5249, 19.35, 11.59],
            [1998, 5250, 20.93, 10.99],
            [1998, 5251, 14.65, 13.08],
            [1998, 5252, 30, 16.56],
            [1998, 5253, 17.35, 10.66],
            [1998, 5254, 25.65, 16.32],
            [1998, 5255, 24.23, 14.71],
            [1998, 5256, 24.56, 17.38],
            [1998, 5257, 15.4, 13.96],
            [1998, 5258, 23.85, 19.14],
            [1998, 5259, 10.2, 9.75],
            [1998, 5260, 14.55, 9.36],
            [1998, 5261, 26.17, 17.95],
            [1998, 5263, 19.45, 15.67],
            [1998, 5264, 70, 50.86],
            [1998, 5265, 9.6, 16.73],
            [1998, 5266, 29.56, 17.86],
            [1998, 5267, 21.83, 15.71],
            [1998, 5268, 15.77, 15],
            [1998, 5269, 14.5, 9.26],
            [1998, 5270, 18.93, 17.93],
            [1998, 5271, 70, 70],
            [1998, 5272, 49.88, 21.16],
            [1998, 5273, 70, 70],
            [1998, 5274, 70, 70],
            [1998, 5275, 70, 70],
            [1998, 5276, 70, 70],
            [1998, 5277, 50, 60],
            [1998, 5278, 70, 70],
            [1998, 5279, 70, 70],
            [1998, 5280, 70, 70],
            [1998, 5281, 50, 60],
            [1998, 5282, 70, 70],
            [1998, 5283, 70, 70],
            [1998, 5284, 70, 70],
            [1998, 5285, 50, 60],
            [1998, 5286, 70, 70],
            [1998, 5287, 40, 50],
            [1998, 5288, 40, 50],
            [1998, 5289, 50, 60],
            [1998, 5290, 70, 70],
            [1998, 5291, 40, 50],
            [1998, 5292, 120, 90],
            [1998, 5293, 50, 60],
            [1998, 5294, 50, 60],
            [1998, 5295, 50, 60],
            [1998, 5296, 120, 90],
            [1998, 5297, 70, 70],
            [1998, 5298, 50, 60],
            [1998, 5299, 50, 60],
            [1998, 5300, 70, 70],
            [1998, 5301, 70, 70],
            [1998, 5302, 70, 70],
            [1998, 5303, 70, 70],
            [1998, 5304, 70, 70],
            [1998, 5305, 70, 70],
            [1998, 5306, 70, 70],
            [1998, 5307, 70, 70],
            [1998, 5308, 120, 90],
            [1998, 5309, 70, 70],
            [1998, 5310, 70, 70],
            [1998, 5311, 120, 90],
            [1998, 5312, 50, 60],
            [1998, 5313, 50, 60],
            [1998, 5314, 70, 70],
            [1998, 5315, 70, 70],
            [1998, 5316, 70, 70],
            [1998, 5317, 70, 70],
            [1998, 5318, 70, 70],
            [1998, 5319, 40, 50],
            [1998, 5320, 70, 70],
            [1998, 5321, 70, 70],
            [1998, 5322, 50, 60],
            [1998, 5323, 70, 70],
            [1998, 5324, 50, 60],
            [1998, 5325, 70, 70],
            [1998, 5326, 70, 70],
            [1998, 5327, 30, 45],
            [1998, 5328, 40, 50],
            [1998, 5329, 70, 70],
            [1998, 5330, 70, 70],
            [1998, 5331, 70, 70],
            [1998, 5332, 50, 60],
            [1998, 5333, 40, 50],
            [1998, 5334, 70, 70],
            [1998, 5335, 50, 60],
            [1998, 5336, 50, 60],
            [1998, 5337, 50, 60],
            [1998, 5338, 70, 70],
            [1998, 5339, 120, 90],
            [1998, 5340, 70, 70],
            [1998, 5341, 70, 70],
            [1998, 5342, 120, 90],
            [1998, 5343, 50, 60],
            [1998, 5344, 70, 70],
            [1998, 5345, 50, 60],
            [1998, 5346, 30, 45],
            [1998, 5347, 70, 70],
            [1998, 5348, 50, 60],
            [1998, 5349, 70, 70],
            [1998, 5350, 70, 70],
            [1998, 5351, 70, 70],
            [1998, 5352, 70, 70],
            [1998, 5353, 50, 60],
            [1998, 5354, 120, 90],
            [1998, 5355, 50, 60],
            [1998, 5356, 70, 70],
            [1998, 5357, 50, 60],
            [1998, 5358, 70, 70],
            [1998, 5359, 70, 70],
            [1998, 5360, 70, 70],
            [1998, 5361, 120, 90],
            [1998, 5362, 70, 70],
            [1998, 5363, 30, 45],
            [1998, 5364, 70, 70],
            [1998, 5365, 40, 50],
            [1998, 5366, 70, 70],
            [1998, 5367, 50, 60],
            [1998, 5368, 70, 70],
            [1998, 5369, 50, 60],
            [1998, 5370, 70, 70],
            [1998, 5371, 70, 70],
            [1998, 5372, 70, 70],
            [1998, 5373, 70, 70],
            [1998, 5374, 120, 90],
            [1998, 5375, 50, 60],
            [1998, 5376, 120, 90],
            [1998, 5377, 50, 60],
            [1998, 5378, 70, 70],
            [1998, 5379, 40, 50],
            [1998, 5380, 70, 70],
            [1998, 5381, 70, 70],
            [1998, 5382, 70, 70],
            [1998, 5383, 50, 60],
            [1998, 5384, 70, 70],
            [1998, 5385, 70, 70],
            [1998, 5386, 70, 70],
            [1998, 5387, 40, 50],
            [1998, 5388, 70, 70],
            [1998, 5389, 70, 70],
            [1998, 5390, 70, 70],
            [1998, 5391, 70, 70],
            [1998, 5392, 70, 70],
            [1998, 5393, 70, 70],
            [1998, 5394, 120, 90],
            [1998, 5395, 120, 90],
            [1998, 5396, 40, 50],
            [1998, 5397, 70, 70],
            [1998, 5398, 70, 70],
            [1998, 5399, 50, 60],
            [1998, 5400, 50, 60],
            [1998, 5401, 70, 70],
            [1998, 5402, 70, 70],
            [1998, 5403, 70, 70],
            [1998, 5404, 70, 70],
            [1998, 5405, 50, 60],
            [1998, 5406, 120, 90],
            [1998, 5407, 70, 70],
            [1998, 5408, 70, 70],
            [1998, 5409, 70, 70],
            [1998, 5410, 70, 70],
            [1998, 5411, 50, 60],
            [1998, 5412, 50, 60],
            [1998, 5413, 70, 70],
            [1998, 5414, 50, 60],
            [1998, 5415, 70, 70],
            [1998, 5416, 30, 45],
            [1998, 5417, 70, 70],
            [1998, 5418, 70, 70],
            [1998, 5419, 50, 60],
            [1998, 5420, 50, 60],
            [1998, 5421, 50, 60],
            [1998, 5422, 70, 70],
            [1998, 5423, 70, 70],
            [1998, 5424, 50, 60],
            [1998, 5425, 70, 70],
            [1998, 5426, 50, 60],
            [1998, 5427, 70, 70],
            [1998, 5428, 70, 70],
            [1998, 5429, 30, 45],
            [1998, 5430, 120, 90],
            [1998, 5431, 70, 70],
            [1998, 5432, 70, 70],
            [1998, 5433, 70, 70],
            [1998, 5434, 40, 50],
            [1998, 5435, 70, 70],
            [1998, 5436, 40, 50],
            [1998, 5437, 70, 70],
            [1998, 5438, 70, 70],
            [1998, 5439, 70, 70],
            [1998, 5440, 70, 70],
            [1998, 5441, 70, 70],
            [1998, 5442, 70, 70],
            [1998, 5443, 70, 70],
            [1998, 5444, 70, 70],
            [1998, 5445, 50, 60],
            [1998, 5446, 70, 70],
            [1998, 5447, 50, 60],
            [1998, 5448, 70, 70],
            [1998, 5449, 70, 70],
            [1998, 5450, 70, 70],
            [1998, 5451, 70, 70],
            [1998, 5452, 70, 70],
            [1998, 5453, 70, 70],
            [1998, 5454, 50, 60],
            [1998, 5455, 50, 60],
            [1998, 5456, 70, 70],
            [1998, 5457, 50, 60],
            [1998, 5458, 70, 70],
            [1998, 5459, 70, 70],
            [1998, 5460, 40, 50],
            [1998, 5461, 40, 50],
            [1998, 5462, 70, 70],
            [1998, 5463, 40, 50],
            [1998, 5464, 70, 70],
            [1998, 5465, 70, 70],
            [1998, 5466, 70, 70],
            [1998, 5467, 70, 70],
            [1998, 5468, 70, 70],
            [1998, 5469, 70, 70],
            [1998, 5470, 70, 70],
            [1998, 5471, 50, 60],
            [1998, 5472, 50, 60],
            [1998, 5473, 50, 60],
            [1998, 5474, 120, 90],
            [1998, 5475, 70, 70],
            [1998, 5476, 70, 70],
            [1998, 5477, 30, 45],
            [1998, 5478, 70, 70],
            [1998, 5479, 70, 70],
            [1998, 5480, 70, 70],
            [1998, 5481, 50, 60],
            [1998, 5482, 70, 70],
            [1998, 5483, 50, 60],
            [1998, 5484, 70, 70],
            [1998, 5485, 50, 60],
            [1998, 5486, 70, 70],
            [1998, 5487, 50, 60],
            [1998, 5488, 70, 70],
            [1998, 5489, 70, 70],
            [1998, 5490, 70, 70],
            [1998, 5491, 50, 60],
            [1998, 5492, 70, 70],
            [1998, 5493, 50, 60],
            [1998, 5494, 70, 70],
            [1998, 5495, 50, 60],
            [1998, 5496, 70, 70],
            [1998, 5497, 50, 60],
            [1998, 5498, 70, 70],
            [1998, 5499, 70, 70],
            [1998, 5500, 70, 70],
            [1998, 5501, 70, 70],
            [1998, 5502, 70, 70],
            [1998, 5503, 70, 70],
            [1998, 5504, 70, 70],
            [1998, 5505, 70, 70],
            [1998, 5506, 70, 70],
            [1998, 5507, 70, 70],
            [1998, 5508, 70, 70],
            [1998, 5509, 70, 70],
            [1998, 5510, 70, 70],
            [1998, 5511, 50, 60],
            [1998, 5512, 50, 60],
            [1998, 5513, 70, 70],
            [1998, 5514, 70, 70],
            [1998, 5515, 70, 70],
            [1998, 5516, 70, 70],
            [1998, 5517, 70, 70],
            [1998, 5518, 50, 60],
            [1998, 5519, 70, 70],
            [1998, 5520, 70, 70],
            [1998, 5521, 70, 70],
            [1998, 5522, 40, 50],
            [1998, 5523, 50, 60],
            [1998, 5524, 50, 60],
            [1998, 5525, 70, 70],
            [1998, 5526, 70, 70],
            [1998, 5527, 70, 70],
            [1998, 5528, 40, 50],
            [1998, 5529, 120, 90],
            [1998, 5530, 70, 70],
            [1998, 5531, 70, 70],
            [1998, 5532, 70, 70],
            [1998, 5533, 70, 70],
            [1998, 5534, 50, 60],
            [1998, 5535, 70, 70],
            [1998, 5536, 15, 20],
            [1998, 5537, 120, 90],
            [1998, 5538, 70, 70],
            [1998, 5539, 70, 70],
            [1998, 5540, 70, 70],
            [1998, 5541, 70, 70],
            [1998, 5542, 40, 50],
            [1998, 5543, 40, 50],
            [1998, 5544, 70, 70],
            [1998, 5545, 70, 70],
            [1998, 5546, 70, 70],
            [1998, 5547, 70, 70],
            [1998, 5548, 70, 70],
            [1998, 5549, 40, 50],
            [1998, 5550, 70, 70],
            [1998, 5551, 70, 70],
            [1998, 5552, 70, 70],
            [1998, 5553, 70, 70],
            [1998, 5554, 70, 70],
            [1998, 5555, 70, 70],
            [1998, 5556, 50, 60],
            [1998, 5557, 40, 50],
            [1998, 5558, 40, 50],
            [1998, 5559, 70, 70],
            [1998, 5560, 120, 90],
            [1998, 5561, 120, 90],
            [1998, 5562, 120, 90],
            [1998, 5563, 70, 70],
            [1998, 5564, 70, 70],
            [1998, 5565, 70, 70],
            [1998, 5566, 70, 70],
            [1998, 5567, 70, 70],
            [1998, 5568, 120, 90],
            [1998, 5569, 70, 70],
            [1998, 5570, 120, 90],
            [1998, 5571, 50, 60],
            [1998, 5572, 70, 70],
            [1998, 5573, 0, 0],
            [1998, 5590, 70, 70],
            [1998, 5600, 120, 90],
            [1998, 5618, 120, 90],
            [1998, 5621, 120, 90],
            [1998, 5624, 120, 90],
            [1998, 5625, 120, 90],
            [1998, 5627, 70, 70],
            [1998, 5632, 120, 90],
            [1998, 5636, 120, 90],
            [1998, 5638, 50, 60],
            [1998, 5646, 120, 90],
            [1998, 5648, 120, 90],
            [1998, 5649, 70, 70],
            [1998, 5659, 7.31, 6.79],
            [1998, 5660, 9.41, 9.76],
            [1998, 5661, 70, 70],
            [1998, 5663, 120, 90],
            [1998, 5666, 120, 90],
            [1998, 5672, 70, 70],
            [1998, 5675, 50, 60],
            [1998, 5677, 120, 90],
            [1998, 5681, 70, 70],
            [1998, 5683, 120, 90],
            [1998, 5689, 120, 90],
            [1998, 5706, 120, 90],
            [1998, 5715, 70, 70],
            [1998, 5717, 120, 90],
            [1998, 5720, 70, 70],
            [1998, 5726, 120, 90],
            [1998, 5728, 120, 90],
            [1998, 5737, 120, 90],
            [1998, 5738, 120, 90],
            [1998, 5745, 70, 70],
            [1998, 5747, 120, 90],
            [1998, 5757, 40, 50],
            [1998, 5758, 70, 70],
            [1998, 5764, 50, 60],
            [1998, 5768, 70, 70],
            [1998, 5777, 120, 90],
            [1998, 5789, 40, 50],
            [1998, 5796, 120, 90],
            [1998, 5805, 120, 90],
            [1998, 5808, 70, 70],
            [1998, 5811, 120, 90],
            [1998, 5819, 120, 90],
            [1998, 5824, 70, 70],
            [1998, 5830, 70, 70],
            [1998, 5833, 120, 90],
            [1998, 5840, 120, 90],
            [1998, 5841, 120, 90],
            [1998, 5846, 120, 90],
            [1998, 5848, 120, 90],
            [1998, 5851, 120, 90],
            [1998, 5855, 50, 60],
            [1998, 5856, 40, 50],
            [1998, 5861, 120, 90],
            [1998, 5868, 120, 90],
            [1998, 5869, 120, 90],
            [1998, 5876, 120, 90],
            [1998, 5877, 120, 90],
            [1998, 5880, 50, 60],
            [1998, 5881, 70, 70],
            [1998, 5882, 70, 70],
            [1998, 5884, 120, 90],
            [1998, 5887, 70, 70],
            [1998, 5889, 70, 70],
            [1998, 5898, 120, 90],
            [1998, 5903, 70, 70],
            [1998, 5911, 120, 90],
            [1998, 5917, 120, 90],
            [1998, 5918, 120, 90],
            [1998, 5919, 70, 70],
            [1998, 5931, 70, 70],
            [1998, 5933, 40, 50],
            [1998, 5936, 70, 70],
            [1998, 5939, 120, 90],
            [1998, 5940, 120, 90],
            [1998, 5941, 120, 90],
            [1998, 5942, 120, 90],
            [1998, 5943, 120, 90],
            [1998, 5944, 40, 50],
            [1998, 5945, 40, 50],
            [1998, 5946, 40, 50],
            [1998, 5947, 120, 90],
            [1998, 5948, 40, 50],
            [1998, 5949, 120, 90],
            [1998, 5950, 120, 90],
            [1998, 5951, 120, 90],
            [1998, 5953, 40, 50],
            [1998, 5954, 120, 90],
            [1998, 5955, 120, 90],
            [1998, 5956, 120, 90],
            [1998, 5957, 120, 90],
            [1998, 5958, 50, 60],
            [1998, 5959, 50, 60],
            [1998, 5960, 120, 90],
            [1998, 5961, 40, 50],
            [1998, 5964, 120, 90],
            [1998, 5965, 120, 90],
            [1998, 5966, 50, 60],
            [1998, 5967, 70, 70],
            [1998, 5968, 120, 90],
            [1998, 5969, 70, 70],
            [1998, 5970, 70, 70],
            [1998, 5985, 15, 25],
            [1998, 5986, 50, 60],
            [1998, 5987, 15, 25],
            [1998, 5988, 21, 33],
            [1998, 5994, 50, 60],
            [1998, 5995, 70, 70],
            [1998, 5996, 70, 70],
            [1998, 5997, 70, 70],
            [1998, 5998, 120, 90],
            [1998, 5999, 50, 60],
            [1998, 6049, 120, 90],
            [1998, 6050, 70, 70],
            [1998, 6051, 70, 70],
            [1998, 6052, 120, 90],
            [1998, 6053, 120, 90],
            [1998, 6054, 120, 90],
            [1998, 6068, 120, 90],
            [1998, 6069, 70, 70],
            [1998, 6070, 70, 70],
            [1998, 6071, 70, 70],
            [1998, 6072, 40, 50],
            [1998, 6073, 70, 70],
            [1998, 6074, 70, 70],
            [1998, 6075, 70, 70],
            [1998, 6076, 50, 60],
            [1998, 6077, 70, 70],
            [1998, 6078, 50, 60],
            [1998, 6079, 70, 70],
            [1998, 6080, 70, 70],
            [1998, 6081, 50, 60],
            [1998, 6082, 70, 70],
            [1998, 6083, 120, 90],
            [1998, 6084, 120, 90],
            [1998, 6085, 120, 90],
            [1998, 6086, 70, 70],
            [1998, 6087, 70, 70],
            [1998, 6088, 70, 70],
            [1998, 6089, 70, 70],
            [1998, 6090, 120, 90],
            [1998, 6091, 70, 70],
            [1998, 6092, 70, 70],
            [1998, 6093, 120, 90],
            [1998, 6094, 70, 70],
            [1998, 6095, 50, 60],
            [1998, 6096, 120, 90],
            [1998, 6097, 120, 90],
            [1998, 6098, 120, 90],
            [1998, 6099, 120, 90],
            [1998, 6100, 70, 70],
            [1998, 6101, 70, 70],
            [1998, 6102, 70, 70],
            [1998, 6103, 70, 70],
            [1998, 6104, 120, 90],
            [1998, 6105, 120, 90],
            [1998, 6106, 70, 70],
            [1998, 6107, 70, 70],
            [1998, 6108, 70, 70],
            [1998, 6109, 50, 60],
            [1998, 6110, 70, 70],
            [1998, 6111, 30, 45],
            [1998, 6112, 70, 70],
            [1998, 6113, 70, 70],
            [1998, 6114, 50, 60],
            [1998, 6115, 50, 60],
            [1998, 6116, 70, 70],
            [1998, 6117, 70, 70],
            [1998, 6118, 70, 70],
            [1998, 6119, 70, 70],
            [1998, 6120, 40, 50],
            [1998, 6121, 70, 70],
            [1998, 6122, 70, 70],
            [1998, 6123, 70, 70],
            [1998, 6124, 70, 70],
            [1998, 6125, 70, 70],
            [1998, 6126, 70, 70],
            [1998, 6127, 70, 70],
            [1998, 6128, 70, 70],
            [1998, 6129, 40, 50],
            [1998, 6130, 70, 70],
            [1998, 6131, 70, 70],
            [1998, 6132, 70, 70],
            [1998, 6133, 70, 70],
            [1998, 6134, 70, 70],
            [1998, 6135, 70, 70],
            [1998, 6136, 70, 70],
            [1998, 6137, 40, 50],
            [1998, 6138, 50, 60],
            [1998, 6139, 70, 70],
            [1998, 6140, 40, 50],
            [1998, 6141, 50, 60],
            [1998, 6142, 50, 60],
            [1998, 6143, 70, 70],
            [1998, 6144, 70, 70],
            [1998, 6145, 70, 70],
            [1998, 6146, 30, 45],
            [1998, 6147, 40, 50],
            [1998, 6148, 40, 50],
            [1998, 6149, 70, 70],
            [1998, 6150, 50, 60],
            [1998, 6151, 70, 70],
            [1998, 6152, 40, 50],
            [1998, 6153, 50, 60],
            [1998, 6154, 70, 70],
            [1998, 6155, 40, 50],
            [1998, 6156, 50, 60],
            [1998, 6157, 50, 60],
            [1998, 6158, 50, 60],
            [1998, 6159, 70, 70],
            [1998, 6160, 70, 70],
            [1998, 6161, 40, 50],
            [1998, 6162, 50, 60],
            [1998, 6163, 50, 60],
            [1998, 6164, 70, 70],
            [1998, 6165, 70, 70],
            [1998, 6166, 70, 70],
            [1998, 6167, 70, 70],
            [1998, 6168, 30, 45],
            [1998, 6169, 30, 45],
            [1998, 6170, 30, 45],
            [1998, 6248, 30, 45],
            [1998, 6252, 50, 60],
            [1998, 6253, 120, 90],
            [1998, 6255, 70, 70],
            [1998, 6256, 50, 60],
            [1998, 6258, 50, 60],
            [1998, 6259, 120, 90],
            [1998, 6260, 120, 90],
            [1998, 6261, 70, 70],
            [1998, 6262, 70, 70],
            [1998, 6263, 120, 90],
            [1998, 6264, 70, 70],
            [1998, 6265, 70, 70],
            [1998, 6266, 50, 60],
            [1998, 6267, 50, 60],
            [1998, 6268, 70, 70],
            [1998, 6269, 50, 60],
            [1998, 6270, 50, 60],
            [1998, 6271, 70, 70],
            [1998, 6272, 40, 50],
            [1998, 6274, 70, 70],
            [1998, 6275, 70, 70],
            [1998, 6276, 50, 60],
            [1998, 6277, 120, 90],
            [1998, 6278, 70, 70],
            [1998, 6279, 70, 70],
            [1998, 6280, 70, 70],
            [1998, 6281, 70, 70],
            [1998, 6282, 50, 60],
            [1998, 6283, 70, 70],
            [1998, 6284, 50, 60],
            [1998, 6286, 70, 70],
            [1998, 6287, 50, 60],
            [1998, 6288, 70, 70],
            [1998, 6289, 50, 60],
            [1998, 6290, 120, 90],
            [1998, 6292, 70, 70],
            [1998, 6293, 70, 70],
            [1998, 6294, 120, 90],
            [1998, 6295, 120, 90],
            [1998, 6296, 70, 70],
            [1998, 6297, 120, 90],
            [1998, 6299, 70, 70],
            [1998, 6300, 70, 70],
            [1998, 6301, 70, 70],
            [1998, 6302, 70, 70],
            [1998, 6303, 70, 70],
            [1998, 6305, 120, 90],
            [1998, 6306, 70, 70],
            [1998, 6307, 120, 90],
            [1998, 6308, 120, 90],
            [1998, 6309, 70, 70],
            [1998, 6310, 50, 60],
            [1998, 6312, 120, 90],
            [1998, 6313, 70, 70],
            [1998, 6314, 120, 90],
            [1998, 6315, 70, 70],
            [1998, 6316, 70, 70],
            [1998, 6317, 70, 70],
            [1998, 6319, 50, 60],
            [1998, 6320, 70, 70],
            [1998, 6321, 70, 70],
            [1998, 6323, 50, 60],
            [1998, 6324, 50, 60],
            [1998, 6325, 120, 90],
            [1998, 6326, 70, 70],
            [1998, 6327, 50, 60],
            [1998, 6328, 120, 90],
            [1998, 6330, 120, 90],
            [1998, 6331, 50, 60],
            [1998, 6333, 120, 90],
            [1998, 6334, 27.92, 22.8],
            [1998, 6335, 36.36, 27.35],
            [1998, 6336, 50, 35.7],
            [1998, 6337, 28.8, 13.04],
            [1998, 6338, 50, 33.77],
            [1998, 6339, 20.96, 16.45],
            [1998, 6340, 50, 36.94],
            [1998, 6341, 40, 23.08],
            [1998, 6342, 23.49, 10.98],
            [1998, 6343, 22.07, 18.41],
            [1998, 6344, 19.93, 9.57],
            [1998, 6345, 50, 21.26],
            [1998, 6346, 40, 25.58],
            [1998, 6347, 30.77, 13.81],
            [1998, 6348, 40, 23.23],
            [1998, 6349, 26.83, 18.14],
            [1998, 6350, 30.1, 29.64],
            [1998, 6351, 37.29, 18.38],
            [1999, 1, 50, 60],
            [1999, 2, 120, 90],
            [1999, 3, 70, 70],
            [1999, 7, 35.26, 21.02],
            [1999, 13, 120, 90],
            [1999, 14, 120, 90],
            [1999, 15, 70, 70],
            [1999, 16, 70, 70],
            [1999, 17, 120, 90],
            [1999, 18, 70, 70],
            [1999, 19, 70, 70],
            [1999, 20, 120, 90],
            [1999, 21, 70, 70],
            [1999, 22, 3.02, 9.75],
            [1999, 23, 120, 90],
            [1999, 25, 13.55, 9.36],
            [1999, 26, 70, 70],
            [1999, 27, 120, 90],
            [1999, 28, 50, 60],
            [1999, 29, 120, 90],
            [1999, 30, 26.05, 16.78],
            [1999, 31, 11.48, 9.38],
            [1999, 32, 120, 90],
            [1999, 33, 60.79, 35],
            [1999, 35, 120, 90],
            [1999, 37, 70, 70],
            [1999, 38, 120, 90],
            [1999, 40, 70, 133],
            [1999, 42, 49.3, 31.8],
            [1999, 43, 120, 90],
            [1999, 44, 120, 90],
            [1999, 47, 50, 60],
            [1999, 48, 70, 70],
            [1999, 49, 37.5, 45],
            [1999, 50, 120, 90],
            [1999, 51, 15.57, 18.15],
            [1999, 53, 40, 50],
            [1999, 56, 120, 90],
            [1999, 57, 120, 90],
            [1999, 58, 61.93, 49.09],
            [1999, 61, 70, 70],
            [1999, 62, 27.9, 27.4],
            [1999, 63, 70, 70],
            [1999, 64, 29.97, 42.64],
            [1999, 65, 50, 42.55],
            [1999, 66, 20, 25],
            [1999, 68, 70, 70],
            [1999, 69, 70, 70],
            [1999, 70, 50, 60],
            [1999, 71, 120, 90],
            [1999, 72, 120, 90],
            [1999, 73, 120, 90],
            [1999, 75, 50, 60],
            [1999, 77, 120, 90],
            [1999, 78, 59.13, 56.03],
            [1999, 81, 70, 70],
            [1999, 82, 12, 28.91],
            [1999, 83, 40, 37.5],
            [1999, 84, 120, 90],
            [1999, 87, 140.68, 39.98],
            [1999, 88, 10.85, 7.56],
            [1999, 89, 70, 70],
            [1999, 91, 40, 50],
            [1999, 93, 8.27, 9.25],
            [1999, 94, 120, 90],
            [1999, 96, 17.85, 27],
            [1999, 99, 15.91, 13.12],
            [1999, 100, 8.29, 8.86],
            [1999, 101, 70, 70],
            [1999, 103, 120, 90],
            [1999, 105, 40, 50],
            [1999, 106, 70, 70],
            [1999, 109, 40, 50],
            [1999, 110, 120, 90],
            [1999, 113, 86.12, 35.5],
            [1999, 119, 70, 70],
            [1999, 121, 13.82, 8.38],
            [1999, 122, 42.72, 53.2],
            [1999, 123, 120, 90],
            [1999, 125, 24.22, 37.94],
            [1999, 128, 70, 70],
            [1999, 133, 120, 90],
            [1999, 135, 24.22, 25.06],
            [1999, 136, 120, 90],
            [1999, 138, 83.99, 31.46],
            [1999, 140, 50, 60],
            [1999, 141, 5, 5.95],
            [1999, 142, 114, 273],
            [1999, 144, 50, 60],
            [1999, 145, 10.42, 7.09],
            [1999, 146, 120, 90],
            [1999, 147, 70, 70],
            [1999, 149, 50, 33.8],
            [1999, 150, 50, 60],
            [1999, 151, 47.04, 30.27],
            [1999, 153, 30, 45],
            [1999, 156, 120, 90],
            [1999, 157, 120, 90],
            [1999, 158, 120, 90],
            [1999, 160, 120, 90],
            [1999, 161, 47.65, 26.01],
            [1999, 162, 40, 50],
            [1999, 163, 32.08, 38.15],
            [1999, 164, 120, 90],
            [1999, 165, 70, 70],
            [1999, 166, 31.35, 44.44],
            [1999, 169, 97.7, 41.85],
            [1999, 170, 120, 90],
            [1999, 171, 35.55, 35],
            [1999, 175, 70, 70],
            [1999, 177, 70, 70],
            [1999, 181, 120, 90],
            [1999, 182, 120, 90],
            [1999, 183, 70, 70],
            [1999, 184, 120, 90],
            [1999, 186, 42.55, 28.63],
            [1999, 187, 50, 60],
            [1999, 188, 34.84, 17.18],
            [1999, 189, 120, 90],
            [1999, 190, 41.9, 24.53],
            [1999, 192, 12, 18],
            [1999, 194, 36.1, 33],
            [1999, 195, 25.2, 22.5],
            [1999, 196, 8.64, 9.03],
            [1999, 197, 120, 90],
            [1999, 199, 120, 90],
            [1999, 200, 50, 60],
            [1999, 203, 70, 70],
            [1999, 204, 16.64, 27],
            [1999, 206, 120, 90],
            [1999, 207, 50, 60],
            [1999, 210, 120, 90],
            [1999, 211, 42.5, 64.2],
            [1999, 212, 70, 70],
            [1999, 213, 70, 70],
            [1999, 214, 120, 90],
            [1999, 215, 39.31, 26.34],
            [1999, 216, 72.31, 55.31],
            [1999, 217, 120, 90],
            [1999, 218, 53.89, 34.22],
            [1999, 220, 23.35, 19.12],
            [1999, 222, 9.57, 9.57],
            [1999, 225, 37.5, 45],
            [1999, 226, 13.66, 15.31],
            [1999, 227, 120, 90],
            [1999, 228, 18.5, 27.7],
            [1999, 230, 30, 37.5],
            [1999, 231, 70, 70],
            [1999, 233, 22.4, 15.4],
            [1999, 234, 12, 19.36],
            [1999, 235, 34.93, 21.66],
            [1999, 236, 70, 70],
            [1999, 237, 10.83, 7.57],
            [1999, 239, 57.35, 74.71],
            [1999, 240, 35.9, 29.8],
            [1999, 241, 46.4, 41.28],
            [1999, 242, 164.4, 59.03],
            [1999, 243, 118.04, 58],
            [1999, 244, 120, 90],
            [1999, 245, 120, 90],
            [1999, 246, 60.21, 33.65],
            [1999, 247, 120, 90],
            [1999, 248, 60.9, 49.22],
            [1999, 249, 70, 70],
            [1999, 250, 50, 60],
            [1999, 253, 120, 90],
            [1999, 256, 50, 60],
            [1999, 257, 120, 90],
            [1999, 260, 70, 70],
            [1999, 264, 50, 60],
            [1999, 265, 120, 90],
            [1999, 267, 120, 90],
            [1999, 268, 120, 90],
            [1999, 269, 120, 90],
            [1999, 270, 102.9, 57.89],
            [1999, 272, 120, 90],
            [1999, 273, 25.7, 35.52],
            [1999, 282, 70, 70],
            [1999, 283, 120, 90],
            [1999, 284, 70, 70],
            [1999, 285, 62.31, 50.39],
            [1999, 286, 33.37, 83.43],
            [1999, 287, 40, 37.5],
            [1999, 289, 120, 90],
            [1999, 291, 70, 70],
            [1999, 292, 50, 60],
            [1999, 294, 96.24, 38.52],
            [1999, 295, 120, 90],
            [1999, 296, 36.57, 16.84],
            [1999, 297, 120, 90],
            [1999, 298, 70, 70],
            [1999, 299, 56.16, 71.39],
            [1999, 302, 120, 90],
            [1999, 303, 60.81, 32.84],
            [1999, 305, 21.98, 26],
            [1999, 306, 53.16, 39.53],
            [1999, 307, 70, 70],
            [1999, 308, 22.69, 32.81],
            [1999, 309, 120, 90],
            [1999, 310, 20.76, 23.58],
            [1999, 311, 70, 70],
            [1999, 312, 98.14, 57.65],
            [1999, 313, 50, 60],
            [1999, 314, 28.98, 30.23],
            [1999, 315, 120, 90],
            [1999, 317, 34.9, 28.91],
            [1999, 320, 40.8, 42.3],
            [1999, 321, 120, 90],
            [1999, 322, 120, 90],
            [1999, 324, 37.5, 45],
            [1999, 325, 120, 90],
            [1999, 326, 28.63, 19.82],
            [1999, 327, 52.96, 62.65],
            [1999, 328, 70, 70],
            [1999, 329, 70, 70],
            [1999, 330, 24.63, 27.62],
            [1999, 332, 101.6, 71.83],
            [1999, 333, 120, 90],
            [1999, 334, 14.71, 16.26],
            [1999, 337, 19.61, 30.02],
            [1999, 339, 74, 62.86],
            [1999, 340, 120, 90],
            [1999, 342, 70, 70],
            [1999, 343, 120, 90],
            [1999, 344, 89.38, 44.91],
            [1999, 346, 56.18, 44.76],
            [1999, 347, 70, 70],
            [1999, 348, 120, 90],
            [1999, 350, 70, 70],
            [1999, 351, 70, 70],
            [1999, 353, 50, 60],
            [1999, 354, 37.5, 45],
            [1999, 355, 70, 70],
            [1999, 356, 120, 90],
            [1999, 358, 70, 70],
            [1999, 361, 41.38, 37.74],
            [1999, 362, 50, 60],
            [1999, 365, 120, 90],
            [1999, 367, 60, 167],
            [1999, 368, 50, 60],
            [1999, 369, 5.88, 5.27],
            [1999, 370, 70, 70],
            [1999, 371, 72.52, 67.5],
            [1999, 372, 16.36, 13.13],
            [1999, 374, 50, 60],
            [1999, 376, 22.12, 15.96],
            [1999, 377, 25.09, 17.45],
            [1999, 378, 31.66, 30.53],
            [1999, 379, 11.67, 16.73],
            [1999, 382, 70, 70],
            [1999, 383, 25.5, 21.6],
            [1999, 385, 120, 90],
            [1999, 386, 50, 60],
            [1999, 387, 70, 70],
            [1999, 389, 37.5, 45],
            [1999, 390, 70, 70],
            [1999, 391, 70, 70],
            [1999, 392, 72.06, 47.49],
            [1999, 394, 50, 60],
            [1999, 396, 120, 90],
            [1999, 398, 70, 70],
            [1999, 399, 70, 70],
            [1999, 400, 50, 60],
            [1999, 401, 70, 70],
            [1999, 402, 120, 90],
            [1999, 403, 25.72, 27.84],
            [1999, 405, 70, 70],
            [1999, 406, 120, 90],
            [1999, 409, 50, 60],
            [1999, 411, 120, 90],
            [1999, 412, 120, 90],
            [1999, 413, 30, 45],
            [1999, 415, 120, 90],
            [1999, 416, 50, 60],
            [1999, 418, 37.33, 36.38],
            [1999, 419, 120, 90],
            [1999, 422, 120, 90],
            [1999, 424, 32.02, 28.67],
            [1999, 425, 12.16, 14.12],
            [1999, 426, 120, 90],
            [1999, 427, 40, 50],
            [1999, 428, 13.52, 12.14],
            [1999, 429, 70, 70],
            [1999, 430, 27, 24],
            [1999, 432, 60.55, 31.38],
            [1999, 434, 70, 70],
            [1999, 436, 20.72, 16.74],
            [1999, 437, 40, 50],
            [1999, 439, 70, 70],
            [1999, 443, 120, 90],
            [1999, 444, 50, 60],
            [1999, 445, 120, 90],
            [1999, 446, 70, 70],
            [1999, 450, 120, 90],
            [1999, 451, 50, 60],
            [1999, 452, 120, 90],
            [1999, 453, 70, 70],
            [1999, 454, 120, 90],
            [1999, 455, 71.93, 65.93],
            [1999, 457, 40, 50],
            [1999, 458, 70, 70],
            [1999, 459, 120, 90],
            [1999, 460, 70, 70],
            [1999, 461, 50, 60],
            [1999, 463, 10.14, 8.58],
            [1999, 464, 21.08, 14.31],
            [1999, 465, 50, 60],
            [1999, 466, 120, 90],
            [1999, 467, 120, 90],
            [1999, 468, 120, 90],
            [1999, 469, 120, 90],
            [1999, 470, 120, 90],
            [1999, 471, 29.42, 44.44],
            [1999, 473, 120, 90],
            [1999, 474, 70, 70],
            [1999, 476, 120, 90],
            [1999, 477, 120, 90],
            [1999, 478, 120, 90],
            [1999, 479, 70, 70],
            [1999, 480, 70, 70],
            [1999, 481, 70, 70],
            [1999, 482, 70, 70],
            [1999, 484, 70, 70],
            [1999, 485, 120, 90],
            [1999, 486, 50, 60],
            [1999, 487, 22.74, 35.74],
            [1999, 488, 70, 70],
            [1999, 490, 70, 70],
            [1999, 493, 120, 90],
            [1999, 494, 16.23, 19.49],
            [1999, 495, 120, 90],
            [1999, 496, 77, 84],
            [1999, 497, 20.34, 27.7],
            [1999, 498, 50, 60],
            [1999, 500, 70, 70],
            [1999, 501, 70, 70],
            [1999, 503, 70, 24.56],
            [1999, 504, 14.4, 17.19],
            [1999, 505, 24.91, 27.22],
            [1999, 507, 120, 90],
            [1999, 508, 70, 70],
            [1999, 509, 5.13, 4.64],
            [1999, 510, 40, 50],
            [1999, 512, 30, 40],
            [1999, 513, 70, 70],
            [1999, 515, 75, 45],
            [1999, 518, 120, 90],
            [1999, 519, 26.44, 21.57],
            [1999, 520, 120, 90],
            [1999, 521, 120, 90],
            [1999, 522, 70, 70],
            [1999, 523, 120, 90],
            [1999, 524, 70, 70],
            [1999, 525, 31.78, 60.44],
            [1999, 526, 70.03, 60],
            [1999, 527, 82, 95],
            [1999, 528, 50, 60],
            [1999, 531, 10.37, 9.91],
            [1999, 532, 85.36, 50.72],
            [1999, 534, 41.02, 29.31],
            [1999, 535, 40, 50],
            [1999, 536, 18.74, 29.58],
            [1999, 540, 70, 70],
            [1999, 541, 61.04, 50.11],
            [1999, 543, 120, 90],
            [1999, 545, 35.62, 43.31],
            [1999, 547, 12, 18],
            [1999, 548, 120, 90],
            [1999, 549, 45, 24.58],
            [1999, 550, 70, 70],
            [1999, 551, 120, 90],
            [1999, 553, 120, 90],
            [1999, 554, 15, 25],
            [1999, 555, 120, 90],
            [1999, 556, 120, 90],
            [1999, 557, 40, 50],
            [1999, 558, 120, 90],
            [1999, 559, 70, 70],
            [1999, 561, 120, 90],
            [1999, 563, 70, 70],
            [1999, 564, 12.02, 6.99],
            [1999, 565, 24.89, 19.74],
            [1999, 568, 44.41, 35.25],
            [1999, 569, 106.46, 58.13],
            [1999, 570, 77.63, 49.89],
            [1999, 571, 70, 70],
            [1999, 572, 30, 45],
            [1999, 573, 34.75, 26.58],
            [1999, 574, 70, 70],
            [1999, 577, 32.7, 38.7],
            [1999, 579, 40, 50],
            [1999, 581, 30, 45],
            [1999, 582, 120, 90],
            [1999, 583, 70, 70],
            [1999, 584, 21.39, 10.39],
            [1999, 585, 70, 70],
            [1999, 586, 50, 60],
            [1999, 588, 12, 22.5],
            [1999, 589, 120, 90],
            [1999, 590, 53.52, 61.02],
            [1999, 591, 120, 90],
            [1999, 593, 65, 51.92],
            [1999, 594, 70, 70],
            [1999, 595, 62.54, 30.08],
            [1999, 596, 8.9, 17.2],
            [1999, 597, 40.93, 18.93],
            [1999, 599, 37.1, 32.34],
            [1999, 600, 120, 90],
            [1999, 601, 70, 70],
            [1999, 604, 77.66, 49.79],
            [1999, 606, 70, 70],
            [1999, 607, 50, 60],
            [1999, 608, 54.37, 25.93],
            [1999, 610, 50, 60],
            [1999, 611, 50, 60],
            [1999, 612, 45.76, 60.33],
            [1999, 614, 28.93, 29.68],
            [1999, 615, 120, 90],
            [1999, 616, 120, 90],
            [1999, 618, 30, 37.5],
            [1999, 619, 120, 90],
            [1999, 621, 120, 90],
            [1999, 623, 8.39, 6.11],
            [1999, 625, 51.68, 25.98],
            [1999, 626, 40, 50],
            [1999, 627, 50, 60],
            [1999, 628, 20.36, 23.58],
            [1999, 629, 18.8, 33.4],
            [1999, 630, 70, 70],
            [1999, 631, 43.54, 34.8],
            [1999, 633, 120, 90],
            [1999, 635, 70, 70],
            [1999, 636, 21.1, 50.2],
            [1999, 637, 7.79, 7.02],
            [1999, 639, 70, 70],
            [1999, 641, 120, 90],
            [1999, 645, 97.67, 37.44],
            [1999, 647, 70, 70],
            [1999, 648, 70, 70],
            [1999, 649, 70, 70],
            [1999, 650, 120, 90],
            [1999, 651, 120, 90],
            [1999, 653, 70, 70],
            [1999, 654, 12.52, 17.79],
            [1999, 656, 120, 90],
            [1999, 657, 120, 90],
            [1999, 659, 7.56, 7.64],
            [1999, 660, 24.24, 22.96],
            [1999, 662, 120, 90],
            [1999, 663, 69.14, 36.97],
            [1999, 664, 70, 70],
            [1999, 665, 120, 90],
            [1999, 666, 120, 90],
            [1999, 669, 50, 30.85],
            [1999, 670, 70, 70],
            [1999, 672, 70, 70],
            [1999, 673, 120, 90],
            [1999, 675, 70, 70],
            [1999, 678, 47.55, 39.99],
            [1999, 679, 120, 90],
            [1999, 680, 10.1, 8.13],
            [1999, 681, 70, 70],
            [1999, 682, 8.1, 6.18],
            [1999, 683, 9.08, 9.76],
            [1999, 686, 16.9, 21.27],
            [1999, 687, 120, 90],
            [1999, 688, 120, 90],
            [1999, 690, 40, 50],
            [1999, 691, 18.17, 15.1],
            [1999, 692, 70, 70],
            [1999, 693, 70, 70],
            [1999, 694, 50, 42.14],
            [1999, 695, 74.53, 49.3],
            [1999, 697, 120, 90],
            [1999, 698, 70, 70],
            [1999, 700, 70, 70],
            [1999, 701, 120, 90],
            [1999, 702, 70, 70],
            [1999, 703, 12, 18],
            [1999, 704, 55.7, 36.5],
            [1999, 705, 30, 45],
            [1999, 706, 70, 70],
            [1999, 708, 70, 70],
            [1999, 709, 32.88, 46.39],
            [1999, 710, 120, 90],
            [1999, 711, 50, 60],
            [1999, 714, 50, 60],
            [1999, 715, 120, 90],
            [1999, 716, 70, 70],
            [1999, 717, 36.27, 32.74],
            [1999, 718, 50, 60],
            [1999, 719, 120, 90],
            [1999, 720, 87.15, 35.16],
            [1999, 721, 50, 60],
            [1999, 722, 120, 90],
            [1999, 723, 50, 60],
            [1999, 724, 29.85, 64.97],
            [1999, 727, 50, 45],
            [1999, 730, 120, 90],
            [1999, 731, 41.75, 21.4],
            [1999, 734, 18.45, 34.92],
            [1999, 737, 10.58, 13.69],
            [1999, 738, 120, 90],
            [1999, 740, 18, 27],
            [1999, 741, 120, 90],
            [1999, 742, 25, 15.29],
            [1999, 745, 120, 90],
            [1999, 746, 40, 50],
            [1999, 747, 85.74, 47.21],
            [1999, 748, 70, 70],
            [1999, 749, 50, 60],
            [1999, 750, 133.42, 46.75],
            [1999, 751, 70, 70],
            [1999, 753, 50, 60],
            [1999, 754, 36.5, 31.71],
            [1999, 756, 83, 140],
            [1999, 759, 70, 70],
            [1999, 762, 70, 70],
            [1999, 763, 70, 70],
            [1999, 766, 100.6, 37.63],
            [1999, 767, 70, 70],
            [1999, 769, 37.94, 60],
            [1999, 771, 120, 90],
            [1999, 772, 70, 70],
            [1999, 773, 64.93, 30.4],
            [1999, 775, 70, 70],
            [1999, 776, 120, 90],
            [1999, 778, 120, 90],
            [1999, 779, 50, 60],
            [1999, 781, 71.84, 33.52],
            [1999, 782, 120, 90],
            [1999, 783, 50, 45],
            [1999, 784, 33.43, 46.1],
            [1999, 785, 120, 90],
            [1999, 787, 18, 23.03],
            [1999, 789, 70, 70],
            [1999, 790, 60.28, 19.43],
            [1999, 795, 120, 90],
            [1999, 796, 70, 70],
            [1999, 799, 50, 60],
            [1999, 801, 35.37, 49.96],
            [1999, 802, 120, 90],
            [1999, 803, 42.57, 40],
            [1999, 804, 120, 90],
            [1999, 805, 13.65, 18.71],
            [1999, 806, 120, 90],
            [1999, 807, 9.12, 12.1],
            [1999, 811, 120, 90],
            [1999, 812, 50, 60],
            [1999, 813, 8.07, 6.92],
            [1999, 814, 120, 90],
            [1999, 815, 30.9, 14.34],
            [1999, 818, 70, 70],
            [1999, 819, 120, 90],
            [1999, 820, 50, 65],
            [1999, 821, 24.1, 26.31],
            [1999, 822, 18.48, 22.65],
            [1999, 823, 120, 90],
            [1999, 824, 120, 90],
            [1999, 825, 70, 70],
            [1999, 826, 17.52, 8.25],
            [1999, 827, 12, 18],
            [1999, 829, 8.45, 6.52],
            [1999, 830, 120, 90],
            [1999, 831, 120, 90],
            [1999, 833, 120, 90],
            [1999, 835, 69.3, 61.77],
            [1999, 836, 120, 90],
            [1999, 837, 70, 70],
            [1999, 840, 120, 90],
            [1999, 842, 50, 60],
            [1999, 843, 50.2, 42.1],
            [1999, 844, 117.83, 54.95],
            [1999, 845, 79.17, 68.36],
            [1999, 846, 120, 90],
            [1999, 847, 70, 70],
            [1999, 848, 9.12, 11.53],
            [1999, 850, 40, 50],
            [1999, 851, 18.96, 12.46],
            [1999, 852, 70, 70],
            [1999, 855, 6.73, 7.13],
            [1999, 857, 120, 90],
            [1999, 860, 70, 70],
            [1999, 863, 13.7, 17.4],
            [1999, 865, 70, 42.13],
            [1999, 867, 120, 90],
            [1999, 869, 70, 70],
            [1999, 871, 16.44, 22.77],
            [1999, 872, 70, 70],
            [1999, 873, 51, 70],
            [1999, 875, 120, 90],
            [1999, 876, 120, 90],
            [1999, 877, 120, 90],
            [1999, 878, 5.59, 4.6],
            [1999, 881, 120, 90],
            [1999, 882, 50, 60],
            [1999, 883, 120, 90],
            [1999, 884, 70, 70],
            [1999, 885, 70, 70],
            [1999, 886, 120, 90],
            [1999, 889, 11.95, 11.28],
            [1999, 890, 62.93, 34.45],
            [1999, 891, 120, 90],
            [1999, 892, 120, 90],
            [1999, 894, 23.13, 17.71],
            [1999, 895, 120, 90],
            [1999, 896, 70, 70],
            [1999, 897, 13.97, 22.37],
            [1999, 899, 120, 90],
            [1999, 900, 6.81, 4.72],
            [1999, 901, 120, 90],
            [1999, 905, 120, 90],
            [1999, 909, 120, 90],
            [1999, 910, 11.75, 7.29],
            [1999, 913, 21.73, 18.25],
            [1999, 914, 120, 90],
            [1999, 915, 38.46, 49.72],
            [1999, 916, 40, 50],
            [1999, 917, 30, 45],
            [1999, 918, 62, 50],
            [1999, 919, 120, 90],
            [1999, 922, 50, 60],
            [1999, 924, 8.93, 9.74],
            [1999, 926, 40.84, 38.58],
            [1999, 927, 70, 70],
            [1999, 928, 120, 90],
            [1999, 929, 120, 90],
            [1999, 930, 50, 60],
            [1999, 931, 70, 70],
            [1999, 934, 37.5, 45],
            [1999, 935, 120, 90],
            [1999, 936, 50, 60],
            [1999, 937, 120, 90],
            [1999, 938, 12, 18],
            [1999, 940, 12, 18],
            [1999, 941, 70, 70],
            [1999, 942, 70, 70],
            [1999, 944, 96.61, 70.21],
            [1999, 945, 50, 60],
            [1999, 946, 50, 60],
            [1999, 948, 31.14, 15],
            [1999, 949, 79.45, 48.51],
            [1999, 950, 13.52, 21.99],
            [1999, 952, 12.6, 9.35],
            [1999, 953, 70, 70],
            [1999, 954, 120, 90],
            [1999, 955, 120, 90],
            [1999, 957, 120, 90],
            [1999, 958, 59.87, 32.44],
            [1999, 960, 50, 60],
            [1999, 961, 120, 90],
            [1999, 963, 70, 70],
            [1999, 964, 12, 15],
            [1999, 965, 50.79, 35],
            [1999, 966, 4.52, 4.32],
            [1999, 969, 52.88, 45.27],
            [1999, 970, 50, 60],
            [1999, 971, 35.72, 14.91],
            [1999, 972, 35.77, 19.67],
            [1999, 974, 30, 45],
            [1999, 976, 8.35, 13.15],
            [1999, 977, 12.22, 8.58],
            [1999, 978, 70, 48.36],
            [1999, 979, 36.64, 34.46],
            [1999, 980, 70, 70],
            [1999, 982, 120, 90],
            [1999, 983, 71.83, 30.1],
            [1999, 985, 194.37, 75.01],
            [1999, 986, 7.84, 7.68],
            [1999, 987, 120, 90],
            [1999, 988, 6.14, 5.32],
            [1999, 990, 71.86, 39.63],
            [1999, 991, 120, 90],
            [1999, 993, 89.04, 64.77],
            [1999, 994, 40, 50],
            [1999, 997, 120, 90],
            [1999, 998, 70, 70],
            [1999, 999, 120, 90],
            [1999, 1000, 40, 50],
            [1999, 1003, 7.76, 5.82],
            [1999, 1004, 70, 70],
            [1999, 1005, 40, 50],
            [1999, 1006, 120, 90],
            [1999, 1007, 28.86, 20.82],
            [1999, 1008, 37.5, 45],
            [1999, 1009, 120, 90],
            [1999, 1013, 70, 70],
            [1999, 1015, 70, 70],
            [1999, 1016, 14.94, 23.74],
            [1999, 1017, 50, 60],
            [1999, 1018, 120, 90],
            [1999, 1020, 70, 70],
            [1999, 1021, 70, 70],
            [1999, 1022, 120, 90],
            [1999, 1023, 13.9, 28.3],
            [1999, 1025, 120, 90],
            [1999, 1027, 120, 90],
            [1999, 1028, 50, 60],
            [1999, 1029, 70, 70],
            [1999, 1030, 7, 9.5],
            [1999, 1032, 23, 23.89],
            [1999, 1033, 27.47, 30.75],
            [1999, 1034, 70, 70],
            [1999, 1036, 6.74, 8.62],
            [1999, 1038, 70, 70],
            [1999, 1039, 120, 90],
            [1999, 1042, 120, 90],
            [1999, 1043, 12.3, 25.3],
            [1999, 1044, 120, 90],
            [1999, 1045, 120, 90],
            [1999, 1046, 50, 60],
            [1999, 1047, 70, 70],
            [1999, 1048, 70, 70],
            [1999, 1050, 70, 70],
            [1999, 1051, 92.72, 35.97],
            [1999, 1052, 50, 60],
            [1999, 1053, 50, 60],
            [1999, 1054, 70, 70],
            [1999, 1056, 22.3, 25.8],
            [1999, 1057, 50, 60],
            [1999, 1058, 70, 70],
            [1999, 1059, 65.53, 68.84],
            [1999, 1061, 70, 70],
            [1999, 1062, 7.92, 8.74],
            [1999, 1063, 120, 90],
            [1999, 1064, 50, 60],
            [1999, 1065, 120, 90],
            [1999, 1066, 50, 60],
            [1999, 1067, 120, 90],
            [1999, 1069, 50, 60],
            [1999, 1070, 20.5, 19],
            [1999, 1071, 125.97, 49.26],
            [1999, 1073, 84.92, 72.24],
            [1999, 1075, 6.43, 6.35],
            [1999, 1077, 120, 90],
            [1999, 1078, 120, 90],
            [1999, 1080, 120, 90],
            [1999, 1081, 53.54, 36.15],
            [1999, 1082, 75, 64.64],
            [1999, 1084, 160.19, 70.76],
            [1999, 1087, 130.51, 58.25],
            [1999, 1090, 120, 90],
            [1999, 1091, 40, 50],
            [1999, 1092, 12, 18],
            [1999, 1093, 50, 60],
            [1999, 1094, 23.66, 23.15],
            [1999, 1095, 34.76, 26.62],
            [1999, 1096, 120, 90],
            [1999, 1097, 8.07, 10.33],
            [1999, 1099, 13.78, 13.14],
            [1999, 1100, 55.33, 47.25],
            [1999, 1102, 20.14, 33.65],
            [1999, 1104, 70, 70],
            [1999, 1106, 70, 70],
            [1999, 1108, 120, 90],
            [1999, 1109, 71.26, 34.85],
            [1999, 1110, 120, 90],
            [1999, 1111, 68.1, 60.82],
            [1999, 1113, 120, 90],
            [1999, 1114, 120, 90],
            [1999, 1117, 50, 60],
            [1999, 1118, 50, 60],
            [1999, 1119, 50, 60],
            [1999, 1120, 120, 90],
            [1999, 1121, 120, 90],
            [1999, 1122, 120, 90],
            [1999, 1124, 33.6, 22.42],
            [1999, 1125, 120, 90],
            [1999, 1126, 70, 70],
            [1999, 1127, 120, 90],
            [1999, 1128, 70, 70],
            [1999, 1129, 50, 60],
            [1999, 1130, 120, 90],
            [1999, 1131, 19.62, 27.9],
            [1999, 1132, 12, 18],
            [1999, 1136, 64.79, 64.92],
            [1999, 1137, 120, 90],
            [1999, 1138, 166, 148],
            [1999, 1139, 70, 70],
            [1999, 1140, 50, 45],
            [1999, 1141, 151.96, 55.04],
            [1999, 1142, 87.4, 44.91],
            [1999, 1144, 70.4, 75.66],
            [1999, 1145, 120, 90],
            [1999, 1147, 12.27, 6.99],
            [1999, 1149, 53.28, 35.03],
            [1999, 1150, 50, 60],
            [1999, 1152, 36.81, 97.97],
            [1999, 1153, 120, 90],
            [1999, 1154, 120, 90],
            [1999, 1155, 12.52, 12.5],
            [1999, 1156, 50, 60],
            [1999, 1157, 40.32, 25.17],
            [1999, 1158, 50, 60],
            [1999, 1159, 70, 60],
            [1999, 1161, 120, 90],
            [1999, 1163, 19.1, 28.7],
            [1999, 1164, 120, 90],
            [1999, 1165, 120, 90],
            [1999, 1167, 85.7, 63.16],
            [1999, 1168, 120, 90],
            [1999, 1169, 34.55, 69.22],
            [1999, 1170, 70, 70],
            [1999, 1171, 70, 70],
            [1999, 1172, 70, 70],
            [1999, 1173, 50, 60],
            [1999, 1174, 37.2, 58.3],
            [1999, 1175, 28.04, 39.32],
            [1999, 1176, 120, 90],
            [1999, 1177, 70, 70],
            [1999, 1178, 8.86, 7.64],
            [1999, 1180, 15.85, 14.23],
            [1999, 1181, 120, 90],
            [1999, 1186, 15.33, 18],
            [1999, 1187, 120, 90],
            [1999, 1188, 40, 50],
            [1999, 1189, 120, 90],
            [1999, 1190, 70, 70],
            [1999, 1191, 67.28, 35],
            [1999, 1194, 82.38, 42.91],
            [1999, 1195, 120, 90],
            [1999, 1198, 120, 90],
            [1999, 1199, 40, 50],
            [1999, 1200, 27.2, 13.54],
            [1999, 1202, 30, 45],
            [1999, 1203, 15, 25],
            [1999, 1204, 70, 70],
            [1999, 1205, 85.87, 50.11],
            [1999, 1206, 120, 90],
            [1999, 1207, 30, 45],
            [1999, 1209, 40, 50],
            [1999, 1210, 40, 37.5],
            [1999, 1211, 53.75, 32.19],
            [1999, 1212, 70, 70],
            [1999, 1213, 40, 50],
            [1999, 1214, 70, 70],
            [1999, 1216, 50, 60],
            [1999, 1217, 90.55, 46.37],
            [1999, 1219, 116.48, 55.12],
            [1999, 1221, 22.66, 24.86],
            [1999, 1223, 70, 70],
            [1999, 1224, 49.77, 79.26],
            [1999, 1225, 50, 60],
            [1999, 1226, 25.67, 16.67],
            [1999, 1227, 120, 90],
            [1999, 1228, 57.49, 37.38],
            [1999, 1230, 50, 60],
            [1999, 1233, 50, 60],
            [1999, 1234, 12, 18],
            [1999, 1235, 50, 60],
            [1999, 1236, 70, 70],
            [1999, 1237, 37.5, 45],
            [1999, 1238, 14.2, 20.8],
            [1999, 1239, 120, 90],
            [1999, 1240, 120, 90],
            [1999, 1244, 70, 70],
            [1999, 1245, 120, 90],
            [1999, 1246, 70, 70],
            [1999, 1247, 70, 70],
            [1999, 1250, 70, 70],
            [1999, 1251, 70, 70],
            [1999, 1253, 50, 60],
            [1999, 1254, 70, 70],
            [1999, 1255, 120, 90],
            [1999, 1257, 40, 50],
            [1999, 1259, 105.06, 30.34],
            [1999, 1260, 50, 60],
            [1999, 1262, 110.05, 49.65],
            [1999, 1263, 120, 90],
            [1999, 1264, 120, 90],
            [1999, 1265, 13.11, 9.3],
            [1999, 1266, 120, 90],
            [1999, 1268, 30.72, 32.5],
            [1999, 1269, 50, 60],
            [1999, 1271, 85.26, 44.5],
            [1999, 1272, 70, 70],
            [1999, 1275, 36.46, 15.29],
            [1999, 1276, 70, 70],
            [1999, 1278, 18.5, 14.7],
            [1999, 1280, 11.06, 6.23],
            [1999, 1281, 21.65, 27],
            [1999, 1282, 50, 60],
            [1999, 1286, 120, 90],
            [1999, 1287, 70, 70],
            [1999, 1288, 70, 70],
            [1999, 1290, 120, 90],
            [1999, 1292, 70, 70],
            [1999, 1293, 4.01, 4.97],
            [1999, 1295, 70, 70],
            [1999, 1298, 50, 60],
            [1999, 1299, 70, 70],
            [1999, 1301, 70, 70],
            [1999, 1302, 30, 45],
            [1999, 1303, 70, 70],
            [1999, 1305, 17.46, 22.11],
            [1999, 1306, 12.9, 26.6],
            [1999, 1312, 26.57, 15.77],
            [1999, 1313, 120, 90],
            [1999, 1314, 23.54, 16.63],
            [1999, 1315, 120, 90],
            [1999, 1317, 70, 70],
            [1999, 1318, 120, 90],
            [1999, 1319, 46.62, 28.16],
            [1999, 1320, 120, 90],
            [1999, 1321, 48.13, 28.8],
            [1999, 1323, 75.54, 72.3],
            [1999, 1324, 120, 90],
            [1999, 1325, 120, 90],
            [1999, 1326, 70, 70],
            [1999, 1327, 70, 70],
            [1999, 1328, 69.9, 51.49],
            [1999, 1331, 120, 90],
            [1999, 1332, 5.42, 3.32],
            [1999, 1333, 120, 90],
            [1999, 1334, 87.72, 70.36],
            [1999, 1335, 22.9, 24.9],
            [1999, 1337, 5.66, 6.03],
            [1999, 1338, 120, 90],
            [1999, 1339, 11.12, 8.5],
            [1999, 1340, 53.22, 39.25],
            [1999, 1341, 120, 90],
            [1999, 1342, 70, 70],
            [1999, 1345, 40, 50],
            [1999, 1346, 50, 60],
            [1999, 1349, 97, 131],
            [1999, 1350, 70, 70],
            [1999, 1351, 70, 70],
            [1999, 1352, 120, 90],
            [1999, 1353, 70, 70],
            [1999, 1355, 120, 90],
            [1999, 1357, 70, 70],
            [1999, 1358, 120, 90],
            [1999, 1359, 67.94, 52.51],
            [1999, 1360, 18, 27],
            [1999, 1361, 77.94, 60.66],
            [1999, 1363, 83.47, 31.82],
            [1999, 1367, 53.29, 36.48],
            [1999, 1370, 17.21, 28.49],
            [1999, 1371, 70, 70],
            [1999, 1372, 120, 90],
            [1999, 1375, 22.3, 23.87],
            [1999, 1376, 30, 37.5],
            [1999, 1378, 70, 70],
            [1999, 1379, 120, 90],
            [1999, 1380, 70, 70],
            [1999, 1381, 120, 90],
            [1999, 1382, 26.47, 36.84],
            [1999, 1383, 8.45, 7.72],
            [1999, 1385, 70, 70],
            [1999, 1387, 40, 50],
            [1999, 1388, 120, 90],
            [1999, 1391, 120, 90],
            [1999, 1392, 120, 90],
            [1999, 1393, 70, 70],
            [1999, 1395, 70, 70],
            [1999, 1396, 12, 24.84],
            [1999, 1398, 40, 50],
            [1999, 1399, 7.42, 6.96],
            [1999, 1402, 70, 70],
            [1999, 1404, 40, 50],
            [1999, 1405, 120, 90],
            [1999, 1406, 4.67, 5.31],
            [1999, 1410, 70, 70],
            [1999, 1411, 50, 60],
            [1999, 1415, 70, 70],
            [1999, 1417, 120, 90],
            [1999, 1420, 50, 60],
            [1999, 1421, 120, 90],
            [1999, 1422, 120, 90],
            [1999, 1424, 50, 60],
            [1999, 1426, 12.76, 9.29],
            [1999, 1427, 23.02, 15.67],
            [1999, 1428, 8.98, 6.72],
            [1999, 1431, 120, 90],
            [1999, 1432, 6.73, 6.53],
            [1999, 1434, 53.67, 36.6],
            [1999, 1436, 70, 70],
            [1999, 1438, 70, 70],
            [1999, 1439, 120, 90],
            [1999, 1440, 70, 70],
            [1999, 1441, 120, 90],
            [1999, 1442, 70, 70],
            [1999, 1443, 57.46, 26.71],
            [1999, 1444, 120, 90],
            [1999, 1445, 85.92, 19.7],
            [1999, 1448, 70, 70],
            [1999, 1449, 120, 90],
            [1999, 1450, 120, 90],
            [1999, 1451, 120, 90],
            [1999, 1453, 70, 70],
            [1999, 1454, 20.61, 20.28],
            [1999, 1456, 70, 70],
            [1999, 1459, 120, 90],
            [1999, 1460, 78, 74],
            [1999, 1461, 6.14, 6.98],
            [1999, 1464, 50, 60],
            [1999, 1465, 30.3, 26.6],
            [1999, 1466, 50, 60],
            [1999, 1467, 70, 70],
            [1999, 1469, 70, 70],
            [1999, 1470, 35, 45],
            [1999, 1471, 58.78, 40.42],
            [1999, 1472, 120, 90],
            [1999, 1473, 11.99, 10.02],
            [1999, 1474, 18, 27],
            [1999, 1475, 93.38, 40.44],
            [1999, 1476, 39.76, 77.7],
            [1999, 1477, 104.5, 55.33],
            [1999, 1478, 14.96, 11.47],
            [1999, 1479, 40, 50],
            [1999, 1481, 70, 70],
            [1999, 1482, 12.31, 14.89],
            [1999, 1483, 70, 70],
            [1999, 1484, 24.92, 66.54],
            [1999, 1485, 120, 90],
            [1999, 1486, 73.81, 56.6],
            [1999, 1487, 120, 90],
            [1999, 1488, 120, 90],
            [1999, 1490, 35.69, 22.38],
            [1999, 1491, 11.32, 8.34],
            [1999, 1493, 40.01, 20.74],
            [1999, 1503, 120, 90],
            [1999, 1505, 120, 90],
            [1999, 1506, 120, 90],
            [1999, 1507, 70, 70],
            [1999, 1508, 21.47, 18.5],
            [1999, 1509, 120, 90],
            [1999, 1510, 31.13, 26.62],
            [1999, 1511, 21.14, 10.89],
            [1999, 1512, 50, 60],
            [1999, 1513, 70, 70],
            [1999, 1514, 75, 105],
            [1999, 1515, 30, 45],
            [1999, 1516, 70, 70],
            [1999, 1518, 120, 90],
            [1999, 1519, 120, 90],
            [1999, 1520, 70, 70],
            [1999, 1521, 120, 90],
            [1999, 1522, 35.03, 33.83],
            [1999, 1523, 120, 90],
            [1999, 1524, 120, 90],
            [1999, 1525, 30, 37.5],
            [1999, 1526, 19.7, 33.1],
            [1999, 1527, 17.34, 33.26],
            [1999, 1530, 97.88, 79.23],
            [1999, 1533, 70, 70],
            [1999, 1534, 10.96, 7.99],
            [1999, 1536, 30.57, 20.35],
            [1999, 1537, 35.55, 43.28],
            [1999, 1538, 120, 90],
            [1999, 1539, 20, 15],
            [1999, 1540, 40, 50],
            [1999, 1541, 70, 70],
            [1999, 1542, 50, 60],
            [1999, 1544, 120, 90],
            [1999, 1546, 70, 70],
            [1999, 1547, 70, 70],
            [1999, 1548, 120, 90],
            [1999, 1549, 233, 267],
            [1999, 1550, 120, 90],
            [1999, 1552, 30, 45],
            [1999, 1553, 70.57, 50.89],
            [1999, 1555, 30, 37.5],
            [1999, 1556, 27.63, 11.76],
            [1999, 1557, 59.6, 36.82],
            [1999, 1559, 50, 60],
            [1999, 1561, 30.82, 30.34],
            [1999, 1562, 97.79, 51.18],
            [1999, 1565, 120, 90],
            [1999, 1568, 17.56, 11.49],
            [1999, 1571, 70, 70],
            [1999, 1572, 120, 90],
            [1999, 1574, 50, 60],
            [1999, 1575, 124.82, 81.48],
            [1999, 1576, 50, 60],
            [1999, 1577, 50, 60],
            [1999, 1578, 120, 90],
            [1999, 1580, 50, 60],
            [1999, 1581, 17.87, 10.61],
            [1999, 1582, 22.41, 22.97],
            [1999, 1585, 70, 70],
            [1999, 1587, 18, 27],
            [1999, 1589, 70, 70],
            [1999, 1590, 70, 70],
            [1999, 1591, 12.9, 21.1],
            [1999, 1592, 70, 70],
            [1999, 1593, 25.91, 24.87],
            [1999, 1595, 70, 70],
            [1999, 1596, 120, 90],
            [1999, 1597, 70, 70],
            [1999, 1598, 15.38, 8.13],
            [1999, 1600, 120, 90],
            [1999, 1601, 70, 70],
            [1999, 1602, 120, 90],
            [1999, 1603, 50, 60],
            [1999, 1605, 50, 60],
            [1999, 1607, 70, 70],
            [1999, 1609, 120, 90],
            [1999, 1610, 18.25, 11.14],
            [1999, 1612, 120, 90],
            [1999, 1615, 120, 90],
            [1999, 1617, 120, 90],
            [1999, 1619, 8.99, 11.56],
            [1999, 1620, 40, 50],
            [1999, 1621, 70, 70],
            [1999, 1623, 50, 114],
            [1999, 1624, 120, 90],
            [1999, 1625, 70, 70],
            [1999, 1626, 70, 70],
            [1999, 1627, 70, 70],
            [1999, 1628, 50, 60],
            [1999, 1629, 40, 50],
            [1999, 1630, 70.01, 36.62],
            [1999, 1632, 8.5, 7.41],
            [1999, 1634, 70, 70],
            [1999, 1635, 16.96, 17.21],
            [1999, 1637, 120, 90],
            [1999, 1638, 52.95, 70],
            [1999, 1639, 70, 70],
            [1999, 1640, 70, 70],
            [1999, 1641, 50.33, 45.33],
            [1999, 1643, 18.14, 18.53],
            [1999, 1644, 48.21, 38.33],
            [1999, 1645, 70, 70],
            [1999, 1647, 70, 70],
            [1999, 1648, 120, 90],
            [1999, 1649, 120, 90],
            [1999, 1650, 70, 70],
            [1999, 1651, 120, 90],
            [1999, 1652, 57.04, 46.09],
            [1999, 1653, 35, 26.28],
            [1999, 1654, 50, 60],
            [1999, 1656, 8.28, 5.7],
            [1999, 1657, 70, 70],
            [1999, 1658, 120, 90],
            [1999, 1659, 38.85, 38.2],
            [1999, 1660, 134.83, 48.67],
            [1999, 1661, 70, 70],
            [1999, 1662, 20.69, 28.99],
            [1999, 1663, 28.45, 30.94],
            [1999, 1664, 22.26, 19.82],
            [1999, 1665, 28.19, 19.28],
            [1999, 1666, 6.17, 5.14],
            [1999, 1667, 120, 90],
            [1999, 1668, 70, 70],
            [1999, 1669, 120, 90],
            [1999, 1671, 120, 90],
            [1999, 1672, 20.29, 61.88],
            [1999, 1673, 40.58, 28.22],
            [1999, 1674, 70, 70],
            [1999, 1675, 9.08, 16.02],
            [1999, 1679, 33.66, 20.7],
            [1999, 1680, 55.76, 53.89],
            [1999, 1681, 120, 90],
            [1999, 1684, 120, 90],
            [1999, 1685, 37.5, 45],
            [1999, 1686, 120, 90],
            [1999, 1688, 25.71, 34.65],
            [1999, 1689, 120, 90],
            [1999, 1690, 120, 90],
            [1999, 1692, 120, 90],
            [1999, 1694, 120, 90],
            [1999, 1695, 120, 90],
            [1999, 1697, 70, 70],
            [1999, 1701, 70, 70],
            [1999, 1702, 70, 70],
            [1999, 1704, 32.73, 29.33],
            [1999, 1705, 70, 70],
            [1999, 1706, 40, 50],
            [1999, 1707, 30, 17.24],
            [1999, 1709, 16, 15.44],
            [1999, 1711, 70, 70],
            [1999, 1713, 50, 60],
            [1999, 1715, 120, 90],
            [1999, 1717, 70, 70],
            [1999, 1720, 4.58, 3.57],
            [1999, 1722, 120, 90],
            [1999, 1724, 31.04, 29.1],
            [1999, 1726, 120, 90],
            [1999, 1728, 120, 90],
            [1999, 1729, 36.89, 30.28],
            [1999, 1730, 12, 18],
            [1999, 1734, 17.03, 13.98],
            [1999, 1737, 70, 70],
            [1999, 1739, 70, 70],
            [1999, 1740, 50, 60],
            [1999, 1741, 70, 70],
            [1999, 1742, 120, 90],
            [1999, 1743, 70, 70],
            [1999, 1744, 48.44, 41.98],
            [1999, 1745, 34.11, 14.96],
            [1999, 1746, 70, 70],
            [1999, 1748, 109.42, 45.47],
            [1999, 1749, 50, 60],
            [1999, 1750, 70, 70],
            [1999, 1752, 120, 90],
            [1999, 1753, 25.17, 15.07],
            [1999, 1754, 120, 90],
            [1999, 1756, 47.81, 29.86],
            [1999, 1757, 70, 70],
            [1999, 1758, 70, 70],
            [1999, 1760, 12.98, 21.4],
            [1999, 1763, 43.44, 47.84],
            [1999, 1764, 131, 250],
            [1999, 1765, 50, 60],
            [1999, 1766, 120, 90],
            [1999, 1767, 120, 88.81],
            [1999, 1769, 70, 60.5],
            [1999, 1770, 80, 70],
            [1999, 1771, 19.39, 23.78],
            [1999, 1772, 25.48, 41.18],
            [1999, 1773, 50, 60],
            [1999, 1774, 17.87, 21.37],
            [1999, 1775, 70, 70],
            [1999, 1776, 35.63, 37.22],
            [1999, 1778, 120, 90],
            [1999, 1779, 38.19, 95.28],
            [1999, 1780, 37.79, 33.06],
            [1999, 1781, 113.83, 52.58],
            [1999, 1783, 12.6, 22.4],
            [1999, 1784, 70, 70],
            [1999, 1785, 120, 90],
            [1999, 1786, 40.8, 58.18],
            [1999, 1787, 120, 90],
            [1999, 1788, 120, 90],
            [1999, 1789, 120, 90],
            [1999, 1790, 48.09, 38.27],
            [1999, 1792, 25.36, 24.69],
            [1999, 1793, 70, 70],
            [1999, 1794, 42.48, 37.47],
            [1999, 1795, 13.2, 9.9],
            [1999, 1796, 50, 60],
            [1999, 1797, 70, 70],
            [1999, 1798, 70, 70],
            [1999, 1799, 4.8, 5.01],
            [1999, 1800, 9.59, 5.61],
            [1999, 1801, 70, 70],
            [1999, 1802, 120, 90],
            [1999, 1803, 120, 90],
            [1999, 1804, 105.47, 52.76],
            [1999, 1806, 120, 90],
            [1999, 1809, 120, 90],
            [1999, 1811, 120, 90],
            [1999, 1812, 43.07, 42.87],
            [1999, 1814, 40, 50],
            [1999, 1815, 15.67, 9.13],
            [1999, 1816, 83.79, 61.8],
            [1999, 1817, 90.35, 31.74],
            [1999, 1818, 27.25, 18.05],
            [1999, 1819, 70, 70],
            [1999, 1822, 70, 70],
            [1999, 1824, 50, 65],
            [1999, 1825, 50.4, 52.17],
            [1999, 1827, 70, 70],
            [1999, 1829, 23.1, 41.1],
            [1999, 1832, 70, 70],
            [1999, 1833, 120, 90],
            [1999, 1834, 120, 90],
            [1999, 1837, 120, 90],
            [1999, 1839, 70, 70],
            [1999, 1841, 70, 70],
            [1999, 1843, 14.6, 12.44],
            [1999, 1844, 30, 45],
            [1999, 1845, 20.52, 19.97],
            [1999, 1846, 120, 90],
            [1999, 1847, 50, 60],
            [1999, 1848, 66.18, 60.25],
            [1999, 1849, 120, 90],
            [1999, 1850, 7.35, 6.92],
            [1999, 1851, 7.82, 10.41],
            [1999, 1852, 40.34, 32.16],
            [1999, 1853, 120, 90],
            [1999, 1855, 120, 90],
            [1999, 1856, 30, 45],
            [1999, 1857, 70, 70],
            [1999, 1859, 120, 90],
            [1999, 1860, 120, 90],
            [1999, 1863, 16.62, 11.53],
            [1999, 1864, 94.1, 90],
            [1999, 1866, 70, 70],
            [1999, 1868, 120, 90],
            [1999, 1869, 40, 37.5],
            [1999, 1870, 70, 70],
            [1999, 1873, 70, 70],
            [1999, 1875, 40, 50],
            [1999, 1876, 35.35, 35.59],
            [1999, 1877, 120, 90],
            [1999, 1879, 43.02, 40.39],
            [1999, 1881, 55.94, 67.39],
            [1999, 1882, 104.15, 43.17],
            [1999, 1883, 120, 90],
            [1999, 1884, 50, 60],
            [1999, 1885, 70, 70],
            [1999, 1886, 50, 60],
            [1999, 1887, 70, 70],
            [1999, 1888, 120, 90],
            [1999, 1889, 70, 70],
            [1999, 1890, 120, 90],
            [1999, 1891, 33.58, 60],
            [1999, 1892, 70, 70],
            [1999, 1894, 50, 60],
            [1999, 1895, 79.91, 49.67],
            [1999, 1896, 120, 90],
            [1999, 1897, 13.67, 11.12],
            [1999, 1898, 8.67, 4.23],
            [1999, 1899, 70, 70],
            [1999, 1900, 30, 45],
            [1999, 1901, 27.52, 29.78],
            [1999, 1903, 70, 70],
            [1999, 1904, 120, 90],
            [1999, 1906, 19.49, 10.43],
            [1999, 1909, 120, 90],
            [1999, 1910, 120, 90],
            [1999, 1912, 70, 70],
            [1999, 1914, 120, 90],
            [1999, 1915, 57.34, 41.55],
            [1999, 1916, 120, 90],
            [1999, 1917, 120, 90],
            [1999, 1919, 120, 90],
            [1999, 1920, 70, 70],
            [1999, 1921, 28.17, 26.56],
            [1999, 1924, 120, 90],
            [1999, 1925, 59.83, 43.65],
            [1999, 1928, 120, 90],
            [1999, 1929, 6.5, 4.93],
            [1999, 1930, 10.76, 8.15],
            [1999, 1933, 12.42, 12.39],
            [1999, 1937, 70, 70],
            [1999, 1938, 120, 90],
            [1999, 1940, 151, 263],
            [1999, 1941, 120, 90],
            [1999, 1945, 45.16, 27.63],
            [1999, 1946, 70, 70],
            [1999, 1948, 26.6, 21.6],
            [1999, 1949, 120, 90],
            [1999, 1950, 42.96, 58.04],
            [1999, 1952, 92.32, 71.14],
            [1999, 1955, 50, 60],
            [1999, 1956, 40, 50],
            [1999, 1957, 70, 70],
            [1999, 1959, 120, 90],
            [1999, 1961, 120, 90],
            [1999, 1962, 15.89, 20.58],
            [1999, 1963, 7.89, 5.56],
            [1999, 1964, 79.54, 41.58],
            [1999, 1965, 50, 59.43],
            [1999, 1967, 70, 70],
            [1999, 1969, 70, 70],
            [1999, 1972, 8.68, 7.21],
            [1999, 1974, 70, 70],
            [1999, 1976, 9.37, 9.9],
            [1999, 1978, 70, 70],
            [1999, 1979, 50, 60],
            [1999, 1980, 120, 90],
            [1999, 1981, 70, 70],
            [1999, 1982, 70, 70],
            [1999, 1984, 70, 70],
            [1999, 1986, 120, 90],
            [1999, 1989, 63, 120],
            [1999, 1991, 11.55, 8.24],
            [1999, 1992, 50.97, 29.55],
            [1999, 1995, 39.6, 34.17],
            [1999, 1996, 120, 90],
            [1999, 1997, 120, 90],
            [1999, 1998, 7.33, 8.42],
            [1999, 2000, 32.3, 7.9],
            [1999, 2001, 63.05, 65.31],
            [1999, 2002, 50, 60],
            [1999, 2004, 8.73, 6.08],
            [1999, 2005, 117.44, 37.08],
            [1999, 2006, 34.13, 29.15],
            [1999, 2007, 70, 70],
            [1999, 2008, 70, 70],
            [1999, 2009, 67, 176],
            [1999, 2011, 12, 18],
            [1999, 2012, 70, 70],
            [1999, 2013, 38.69, 111.03],
            [1999, 2015, 20.41, 16.91],
            [1999, 2016, 50, 60],
            [1999, 2017, 40, 37.5],
            [1999, 2018, 12, 18],
            [1999, 2020, 70, 70],
            [1999, 2021, 91.08, 54.55],
            [1999, 2022, 120, 90],
            [1999, 2023, 12.93, 13.98],
            [1999, 2025, 47.08, 35.03],
            [1999, 2026, 122.65, 67.48],
            [1999, 2027, 120, 90],
            [1999, 2028, 120, 90],
            [1999, 2029, 30.65, 35.97],
            [1999, 2030, 50, 60],
            [1999, 2031, 6.44, 5.6],
            [1999, 2032, 29.96, 39.24],
            [1999, 2034, 120, 90],
            [1999, 2035, 70, 70],
            [1999, 2038, 120, 90],
            [1999, 2040, 120, 90],
            [1999, 2041, 120, 90],
            [1999, 2042, 25.88, 9.57],
            [1999, 2043, 16.14, 25.13],
            [1999, 2044, 120, 90],
            [1999, 2046, 50, 60],
            [1999, 2048, 13.1, 28.8],
            [1999, 2049, 70, 70],
            [1999, 2050, 11, 25],
            [1999, 2051, 120, 90],
            [1999, 2052, 120, 90],
            [1999, 2053, 70, 70],
            [1999, 2054, 21.44, 20.37],
            [1999, 2055, 70, 70],
            [1999, 2056, 50, 60],
            [1999, 2057, 120, 90],
            [1999, 2058, 7.15, 5.43],
            [1999, 2059, 11.86, 8.19],
            [1999, 2060, 70, 70],
            [1999, 2061, 70, 70],
            [1999, 2062, 120, 90],
            [1999, 2063, 70, 70],
            [1999, 2064, 61.23, 37.87],
            [1999, 2066, 120, 90],
            [1999, 2068, 70, 70],
            [1999, 2070, 19.34, 6.55],
            [1999, 2071, 120, 90],
            [1999, 2072, 120, 90],
            [1999, 2073, 120, 90],
            [1999, 2074, 70, 70],
            [1999, 2075, 45, 70],
            [1999, 2076, 70, 70],
            [1999, 2077, 120, 90],
            [1999, 2081, 57.1, 44.75],
            [1999, 2083, 120, 90],
            [1999, 2084, 23.59, 36.63],
            [1999, 2085, 9.03, 8.79],
            [1999, 2087, 70, 70],
            [1999, 2089, 50, 60],
            [1999, 2090, 120, 90],
            [1999, 2091, 120, 90],
            [1999, 2095, 70, 70],
            [1999, 2096, 120, 90],
            [1999, 2097, 50, 60],
            [1999, 2098, 40, 50],
            [1999, 2099, 89.29, 46.57],
            [1999, 2100, 71.04, 24.35],
            [1999, 2101, 30.58, 16.13],
            [1999, 2103, 11.08, 12.74],
            [1999, 2104, 111.3, 45.15],
            [1999, 2105, 120, 90],
            [1999, 2106, 40.17, 51.44],
            [1999, 2107, 120, 90],
            [1999, 2110, 40, 50],
            [1999, 2112, 70, 70],
            [1999, 2115, 70, 70],
            [1999, 2116, 50, 60],
            [1999, 2119, 7.29, 9.02],
            [1999, 2121, 28, 32.4],
            [1999, 2122, 70, 70],
            [1999, 2125, 120, 90],
            [1999, 2126, 50, 60],
            [1999, 2127, 44.84, 32.36],
            [1999, 2128, 29.14, 12.62],
            [1999, 2130, 120, 90],
            [1999, 2131, 65.5, 56.7],
            [1999, 2132, 19.44, 12.24],
            [1999, 2134, 70, 70],
            [1999, 2135, 22.3, 28.8],
            [1999, 2136, 70, 70],
            [1999, 2137, 70, 70],
            [1999, 2138, 38.63, 26.61],
            [1999, 2139, 70, 70],
            [1999, 2140, 40, 50],
            [1999, 2142, 5.59, 1.96],
            [1999, 2144, 37.3, 75.7],
            [1999, 2146, 70, 70],
            [1999, 2147, 120, 90],
            [1999, 2148, 70, 70],
            [1999, 2149, 120, 90],
            [1999, 2150, 120, 90],
            [1999, 2151, 40.63, 26.2],
            [1999, 2152, 120, 90],
            [1999, 2154, 120, 90],
            [1999, 2155, 120, 90],
            [1999, 2156, 43.59, 31.42],
            [1999, 2159, 120, 90],
            [1999, 2161, 50, 60],
            [1999, 2162, 34.02, 34.24],
            [1999, 2163, 120, 90],
            [1999, 2164, 22, 26.1],
            [1999, 2166, 120, 90],
            [1999, 2167, 10.33, 10.88],
            [1999, 2169, 70, 70],
            [1999, 2170, 50.17, 28.05],
            [1999, 2171, 120, 90],
            [1999, 2174, 40.28, 40.83],
            [1999, 2177, 8.15, 8.97],
            [1999, 2178, 16.1, 27],
            [1999, 2179, 26, 37.8],
            [1999, 2180, 14.38, 10.62],
            [1999, 2181, 58.9, 76.35],
            [1999, 2182, 120, 90],
            [1999, 2184, 40, 50],
            [1999, 2186, 50, 60],
            [1999, 2187, 120, 90],
            [1999, 2190, 70, 70],
            [1999, 2191, 120, 90],
            [1999, 2197, 120, 90],
            [1999, 2198, 40, 50],
            [1999, 2199, 120, 90],
            [1999, 2200, 70, 70],
            [1999, 2201, 23.77, 27.53],
            [1999, 2203, 11.11, 8.84],
            [1999, 2204, 14.98, 8.4],
            [1999, 2205, 120, 90],
            [1999, 2208, 81.25, 48.76],
            [1999, 2212, 70, 70],
            [1999, 2213, 50, 60],
            [1999, 2214, 1.27, 0.88],
            [1999, 2216, 34.36, 17.02],
            [1999, 2217, 120, 90],
            [1999, 2219, 120, 90],
            [1999, 2220, 37.11, 22.57],
            [1999, 2223, 40, 50],
            [1999, 2224, 29.41, 34.07],
            [1999, 2225, 50, 60],
            [1999, 2226, 120, 90],
            [1999, 2227, 39.22, 33.66],
            [1999, 2228, 50, 101],
            [1999, 2230, 120, 90],
            [1999, 2231, 120, 90],
            [1999, 2232, 17.94, 39.15],
            [1999, 2233, 22.35, 13.45],
            [1999, 2235, 50, 60],
            [1999, 2236, 26.79, 29.04],
            [1999, 2237, 120, 90],
            [1999, 2238, 26.85, 29.25],
            [1999, 2239, 21.85, 11.47],
            [1999, 2240, 120, 90],
            [1999, 2241, 14.63, 9.52],
            [1999, 2242, 70, 70],
            [1999, 2243, 120, 90],
            [1999, 2244, 38, 31.98],
            [1999, 2245, 70, 70],
            [1999, 2247, 50, 60],
            [1999, 2248, 40, 50],
            [1999, 2249, 120, 90],
            [1999, 2250, 50, 60],
            [1999, 2252, 50, 60],
            [1999, 2253, 14.51, 10.23],
            [1999, 2254, 70, 70],
            [1999, 2255, 22.3, 61.32],
            [1999, 2256, 70, 70],
            [1999, 2258, 42.22, 34.38],
            [1999, 2259, 2, 1],
            [1999, 2260, 70, 70],
            [1999, 2262, 70, 70],
            [1999, 2265, 120, 90],
            [1999, 2267, 7.26, 3.97],
            [1999, 2268, 120, 90],
            [1999, 2269, 70, 70],
            [1999, 2270, 120, 90],
            [1999, 2271, 6.34, 5.21],
            [1999, 2273, 70, 70],
            [1999, 2274, 70, 70],
            [1999, 2277, 50, 33.82],
            [1999, 2280, 8.57, 5.83],
            [1999, 2281, 120, 90],
            [1999, 2282, 34.6, 40.1],
            [1999, 2283, 120, 90],
            [1999, 2284, 70, 70],
            [1999, 2285, 40, 50],
            [1999, 2286, 70, 70],
            [1999, 2289, 120, 90],
            [1999, 2290, 120, 90],
            [1999, 2292, 120, 90],
            [1999, 2293, 109.99, 52.3],
            [1999, 2294, 50, 60],
            [1999, 2295, 120, 90],
            [1999, 2297, 153.15, 64.3],
            [1999, 2300, 50, 60],
            [1999, 2301, 70, 70],
            [1999, 2302, 120, 90],
            [1999, 2303, 56.37, 41.39],
            [1999, 2304, 70, 70],
            [1999, 2305, 120, 90],
            [1999, 2306, 50, 60],
            [1999, 2311, 45, 45],
            [1999, 2312, 33.27, 33.84],
            [1999, 2314, 120, 90],
            [1999, 2316, 70, 70],
            [1999, 2317, 120, 90],
            [1999, 2319, 50, 60],
            [1999, 2320, 8.59, 8.74],
            [1999, 2321, 120, 90],
            [1999, 2323, 70, 70],
            [1999, 2325, 120, 90],
            [1999, 2326, 120, 90],
            [1999, 2327, 120, 90],
            [1999, 2328, 70, 70],
            [1999, 2332, 30.96, 25.63],
            [1999, 2335, 85.28, 79.59],
            [1999, 2336, 120, 90],
            [1999, 2337, 120, 90],
            [1999, 2338, 70, 70],
            [1999, 2339, 120, 90],
            [1999, 2340, 120, 90],
            [1999, 2341, 73, 177],
            [1999, 2342, 70, 70],
            [1999, 2343, 57.74, 26.83],
            [1999, 2346, 70, 70],
            [1999, 2347, 120, 90],
            [1999, 2349, 70, 70],
            [1999, 2352, 50, 60],
            [1999, 2356, 226.56, 56.42],
            [1999, 2359, 50, 60],
            [1999, 2363, 30.54, 20.65],
            [1999, 2364, 70, 70],
            [1999, 2366, 16.78, 17.31],
            [1999, 2367, 59.45, 50.23],
            [1999, 2368, 70, 70],
            [1999, 2371, 70, 70],
            [1999, 2372, 30, 45],
            [1999, 2373, 70, 70],
            [1999, 2374, 12.45, 9.91],
            [1999, 2375, 120, 90],
            [1999, 2378, 20.26, 18.12],
            [1999, 2382, 70, 70],
            [1999, 2383, 96.19, 48.48],
            [1999, 2384, 30, 45],
            [1999, 2385, 70, 70],
            [1999, 2387, 40, 50],
            [1999, 2388, 70, 70],
            [1999, 2390, 121, 178],
            [1999, 2391, 70, 70],
            [1999, 2392, 7.85, 7.64],
            [1999, 2394, 50, 60],
            [1999, 2396, 120, 90],
            [1999, 2397, 120, 90],
            [1999, 2398, 120, 90],
            [1999, 2399, 120, 90],
            [1999, 2401, 9.42, 9.69],
            [1999, 2402, 70, 70],
            [1999, 2404, 120, 90],
            [1999, 2405, 22.61, 36.11],
            [1999, 2406, 120, 90],
            [1999, 2407, 120, 90],
            [1999, 2408, 50, 60],
            [1999, 2409, 9.5, 15.2],
            [1999, 2410, 70, 70],
            [1999, 2411, 9.59, 8.49],
            [1999, 2412, 6.63, 7.08],
            [1999, 2413, 120, 90],
            [1999, 2414, 8.64, 7.09],
            [1999, 2416, 120, 90],
            [1999, 2420, 120, 90],
            [1999, 2423, 70, 70],
            [1999, 2424, 120, 90],
            [1999, 2425, 52.54, 35],
            [1999, 2428, 10.11, 12.8],
            [1999, 2429, 12, 18],
            [1999, 2430, 70, 70],
            [1999, 2433, 70, 70],
            [1999, 2434, 134, 205],
            [1999, 2435, 22.35, 18.73],
            [1999, 2436, 17.93, 15],
            [1999, 2437, 9.73, 8.67],
            [1999, 2438, 120, 90],
            [1999, 2439, 70, 70],
            [1999, 2440, 5.64, 5.78],
            [1999, 2441, 120, 90],
            [1999, 2442, 12, 18],
            [1999, 2443, 70, 70],
            [1999, 2444, 120, 90],
            [1999, 2447, 25.21, 17.4],
            [1999, 2448, 120, 90],
            [1999, 2449, 120, 90],
            [1999, 2452, 70, 70],
            [1999, 2454, 120, 90],
            [1999, 2456, 70, 70],
            [1999, 2458, 42.99, 19.09],
            [1999, 2459, 32.63, 40.69],
            [1999, 2462, 120, 90],
            [1999, 2465, 120, 90],
            [1999, 2466, 120, 90],
            [1999, 2467, 12, 21.72],
            [1999, 2468, 40, 50],
            [1999, 2470, 120, 90],
            [1999, 2471, 120, 90],
            [1999, 2472, 78.4, 34.97],
            [1999, 2473, 120, 90],
            [1999, 2474, 120, 90],
            [1999, 2475, 70, 70],
            [1999, 2476, 120, 90],
            [1999, 2477, 70, 70],
            [1999, 2478, 120, 90],
            [1999, 2479, 50, 60],
            [1999, 2480, 25.72, 16.26],
            [1999, 2481, 50, 60],
            [1999, 2482, 120, 90],
            [1999, 2483, 120, 90],
            [1999, 2484, 120, 90],
            [1999, 2485, 26.73, 30.59],
            [1999, 2486, 70, 70],
            [1999, 2487, 70, 70],
            [1999, 2488, 53.21, 52.23],
            [1999, 2490, 70, 70],
            [1999, 2493, 104.76, 45.88],
            [1999, 2494, 57.1, 29.4],
            [1999, 2495, 40, 50],
            [1999, 2496, 120, 90],
            [1999, 2497, 40.2, 11.31],
            [1999, 2499, 13.19, 8.58],
            [1999, 2500, 14.55, 14.52],
            [1999, 2501, 70, 70],
            [1999, 2504, 120, 90],
            [1999, 2505, 70, 70],
            [1999, 2507, 120, 90],
            [1999, 2508, 70, 70],
            [1999, 2509, 21.55, 18.6],
            [1999, 2510, 70, 70],
            [1999, 2511, 120, 90],
            [1999, 2512, 120, 90],
            [1999, 2513, 7, 18.7],
            [1999, 2514, 120, 90],
            [1999, 2515, 50, 60],
            [1999, 2516, 40.7, 39.93],
            [1999, 2518, 74.82, 43.44],
            [1999, 2519, 120, 90],
            [1999, 2520, 104, 174],
            [1999, 2521, 50, 60],
            [1999, 2524, 10.39, 13.16],
            [1999, 2525, 70, 70],
            [1999, 2526, 70, 70],
            [1999, 2527, 49.14, 44.47],
            [1999, 2528, 120, 90],
            [1999, 2529, 43.73, 38.98],
            [1999, 2530, 70, 70],
            [1999, 2532, 70, 70],
            [1999, 2533, 23.69, 46.33],
            [1999, 2534, 120, 90],
            [1999, 2535, 5.38, 6.5],
            [1999, 2536, 5.45, 5.06],
            [1999, 2537, 120, 90],
            [1999, 2539, 70, 30.72],
            [1999, 2540, 40.04, 38.42],
            [1999, 2542, 34.79, 22.79],
            [1999, 2543, 27.67, 25],
            [1999, 2545, 40, 50],
            [1999, 2546, 70, 70],
            [1999, 2547, 17.63, 16.94],
            [1999, 2548, 70, 70],
            [1999, 2549, 70, 70],
            [1999, 2551, 71.76, 36.27],
            [1999, 2553, 70, 70],
            [1999, 2554, 16.72, 26.29],
            [1999, 2555, 52.5, 52.5],
            [1999, 2558, 40, 50],
            [1999, 2562, 111.85, 42.43],
            [1999, 2563, 61.13, 37.95],
            [1999, 2564, 40.56, 78.59],
            [1999, 2565, 40, 50],
            [1999, 2566, 10.13, 8.41],
            [1999, 2568, 70, 70],
            [1999, 2569, 34.08, 20.39],
            [1999, 2571, 50, 60],
            [1999, 2572, 120, 90],
            [1999, 2574, 107.79, 57.67],
            [1999, 2575, 70, 70],
            [1999, 2576, 70, 70],
            [1999, 2577, 16.06, 11.33],
            [1999, 2578, 70, 70],
            [1999, 2580, 120, 90],
            [1999, 2582, 70, 70],
            [1999, 2584, 120, 90],
            [1999, 2585, 70, 58.43],
            [1999, 2587, 66.78, 50.99],
            [1999, 2589, 70, 70],
            [1999, 2590, 120, 90],
            [1999, 2591, 120, 90],
            [1999, 2592, 120, 105],
            [1999, 2593, 109.49, 44.64],
            [1999, 2595, 70, 70],
            [1999, 2596, 120, 90],
            [1999, 2597, 40, 50],
            [1999, 2598, 70, 70],
            [1999, 2600, 50, 60],
            [1999, 2601, 70, 70],
            [1999, 2603, 120, 90],
            [1999, 2604, 14.91, 16.67],
            [1999, 2606, 18.48, 15.38],
            [1999, 2607, 14.85, 16.55],
            [1999, 2608, 70, 70],
            [1999, 2610, 70, 70],
            [1999, 2612, 19.02, 24.51],
            [1999, 2613, 120, 90],
            [1999, 2615, 80.55, 54.14],
            [1999, 2617, 17.59, 35.03],
            [1999, 2619, 57.48, 50.98],
            [1999, 2620, 60, 60],
            [1999, 2621, 120, 90],
            [1999, 2622, 22.29, 20.66],
            [1999, 2623, 36.98, 28.35],
            [1999, 2624, 120, 90],
            [1999, 2627, 70, 70],
            [1999, 2628, 47.2, 82.28],
            [1999, 2630, 120, 90],
            [1999, 2631, 70, 70],
            [1999, 2632, 22.83, 26.19],
            [1999, 2633, 36.95, 67.11],
            [1999, 2634, 120, 90],
            [1999, 2635, 12, 22.39],
            [1999, 2636, 70, 70],
            [1999, 2638, 70, 70],
            [1999, 2639, 9.66, 9.9],
            [1999, 2642, 120, 90],
            [1999, 2644, 71.93, 71.93],
            [1999, 2646, 30, 45],
            [1999, 2647, 51.91, 54.1],
            [1999, 2649, 50, 60],
            [1999, 2650, 120, 90],
            [1999, 2651, 32.4, 19.95],
            [1999, 2652, 37.5, 45],
            [1999, 2653, 70, 70],
            [1999, 2655, 40, 50],
            [1999, 2656, 69.06, 43.42],
            [1999, 2658, 40.97, 26.68],
            [1999, 2660, 40, 50],
            [1999, 2661, 70, 70],
            [1999, 2663, 50, 60],
            [1999, 2664, 11, 16.7],
            [1999, 2665, 70, 70],
            [1999, 2667, 63.81, 52.19],
            [1999, 2668, 39.53, 31.14],
            [1999, 2669, 75, 64.66],
            [1999, 2670, 70, 70],
            [1999, 2671, 50, 45],
            [1999, 2672, 13.43, 14.62],
            [1999, 2677, 70, 70],
            [1999, 2681, 70, 70],
            [1999, 2682, 178, 216],
            [1999, 2683, 9.17, 6.35],
            [1999, 2684, 70.83, 69.48],
            [1999, 2685, 50, 60],
            [1999, 2686, 9.12, 8.12],
            [1999, 2687, 94.14, 34.56],
            [1999, 2691, 50, 60],
            [1999, 2692, 70, 70],
            [1999, 2694, 120, 90],
            [1999, 2695, 12, 18],
            [1999, 2696, 70, 70],
            [1999, 2697, 120, 90],
            [1999, 2703, 50, 60],
            [1999, 2704, 10.96, 9.94],
            [1999, 2706, 120, 90],
            [1999, 2707, 70, 70],
            [1999, 2710, 18.57, 12.32],
            [1999, 2711, 50, 60],
            [1999, 2712, 70, 70],
            [1999, 2714, 50, 60],
            [1999, 2716, 70, 70],
            [1999, 2719, 70, 70],
            [1999, 2720, 46, 38.9],
            [1999, 2722, 120, 90],
            [1999, 2723, 70, 70],
            [1999, 2725, 70, 70],
            [1999, 2726, 120.52, 25.63],
            [1999, 2728, 120, 90],
            [1999, 2730, 50, 60],
            [1999, 2731, 120, 90],
            [1999, 2734, 50, 60],
            [1999, 2735, 6.21, 6.8],
            [1999, 2736, 30, 45],
            [1999, 2737, 40, 50],
            [1999, 2738, 40, 37.5],
            [1999, 2739, 50, 60],
            [1999, 2740, 120, 90],
            [1999, 2741, 88, 114],
            [1999, 2743, 30.71, 32.21],
            [1999, 2746, 70, 70],
            [1999, 2747, 63.12, 31.83],
            [1999, 2748, 123.58, 59.04],
            [1999, 2750, 30, 45],
            [1999, 2752, 70, 70],
            [1999, 2753, 50, 60],
            [1999, 2755, 120, 90],
            [1999, 2756, 77, 96],
            [1999, 2757, 120, 90],
            [1999, 2758, 36.94, 36.69],
            [1999, 2759, 120, 90],
            [1999, 2760, 120, 90],
            [1999, 2762, 120, 90],
            [1999, 2763, 120, 90],
            [1999, 2764, 70, 70],
            [1999, 2765, 120, 90],
            [1999, 2766, 8.32, 6.64],
            [1999, 2767, 120, 90],
            [1999, 2768, 120, 90],
            [1999, 2770, 120, 90],
            [1999, 2772, 70, 70],
            [1999, 2773, 50, 60],
            [1999, 2774, 120, 90],
            [1999, 2775, 70, 70],
            [1999, 2778, 70, 70],
            [1999, 2781, 9.91, 6.13],
            [1999, 2782, 50, 60],
            [1999, 2783, 70, 70],
            [1999, 2784, 70, 70],
            [1999, 2785, 5.56, 14],
            [1999, 2786, 70, 70],
            [1999, 2787, 64.37, 35.05],
            [1999, 2788, 96.68, 56.26],
            [1999, 2791, 30, 37.5],
            [1999, 2792, 120, 90],
            [1999, 2793, 40, 50],
            [1999, 2795, 70, 70],
            [1999, 2796, 70, 70],
            [1999, 2797, 38.38, 16.45],
            [1999, 2798, 12, 21.53],
            [1999, 2800, 70, 70],
            [1999, 2801, 120, 90],
            [1999, 2804, 16.93, 11.94],
            [1999, 2806, 70, 70],
            [1999, 2807, 36.77, 11.92],
            [1999, 2808, 50, 60],
            [1999, 2809, 120, 90],
            [1999, 2811, 34.31, 28.04],
            [1999, 2813, 34.06, 29.31],
            [1999, 2814, 120, 90],
            [1999, 2818, 9.74, 14.61],
            [1999, 2819, 11.84, 8.58],
            [1999, 2820, 70, 70],
            [1999, 2821, 70, 70],
            [1999, 2822, 40, 50],
            [1999, 2823, 59.27, 44.08],
            [1999, 2826, 40, 50],
            [1999, 2827, 21.89, 30.71],
            [1999, 2831, 120, 90],
            [1999, 2832, 23.2, 22.2],
            [1999, 2833, 65.79, 46.49],
            [1999, 2834, 50, 60],
            [1999, 2835, 37.5, 45],
            [1999, 2836, 36.81, 31.39],
            [1999, 2837, 120, 90],
            [1999, 2838, 120, 90],
            [1999, 2839, 120, 90],
            [1999, 2841, 120, 90],
            [1999, 2844, 70, 70],
            [1999, 2845, 120, 90],
            [1999, 2846, 40, 23.06],
            [1999, 2847, 30, 45],
            [1999, 2850, 50, 60],
            [1999, 2851, 75.14, 53.01],
            [1999, 2852, 37.5, 45],
            [1999, 2853, 70, 70],
            [1999, 2854, 25.17, 19.72],
            [1999, 2856, 124.74, 77.59],
            [1999, 2857, 120, 90],
            [1999, 2861, 50, 60],
            [1999, 2862, 70, 70],
            [1999, 2863, 25.3, 31],
            [1999, 2864, 120, 90],
            [1999, 2865, 120, 90],
            [1999, 2866, 50, 60],
            [1999, 2867, 120, 90],
            [1999, 2869, 5.93, 4.86],
            [1999, 2871, 120, 90],
            [1999, 2872, 31.07, 14.75],
            [1999, 2876, 101.18, 75.84],
            [1999, 2877, 120, 90],
            [1999, 2878, 120, 90],
            [1999, 2879, 50, 60],
            [1999, 2880, 39, 52.5],
            [1999, 2882, 120, 90],
            [1999, 2883, 48.97, 31.48],
            [1999, 2884, 70.14, 48.85],
            [1999, 2885, 70, 70],
            [1999, 2886, 70, 70],
            [1999, 2887, 70, 70],
            [1999, 2889, 70, 70],
            [1999, 2890, 70, 70],
            [1999, 2891, 120, 90],
            [1999, 2893, 120, 90],
            [1999, 2894, 120, 90],
            [1999, 2897, 120, 90],
            [1999, 2899, 70, 70],
            [1999, 2900, 50, 60],
            [1999, 2901, 107.65, 88.66],
            [1999, 2902, 120, 90],
            [1999, 2903, 120, 90],
            [1999, 2904, 65, 40.54],
            [1999, 2905, 50, 60],
            [1999, 2906, 120, 90],
            [1999, 2907, 11.65, 11.52],
            [1999, 2908, 70, 70],
            [1999, 2910, 49.02, 40.47],
            [1999, 2911, 120, 90],
            [1999, 2914, 70, 70],
            [1999, 2916, 70, 70],
            [1999, 2917, 50, 60],
            [1999, 2918, 17.8, 10.33],
            [1999, 2919, 120, 90],
            [1999, 2921, 120, 90],
            [1999, 2922, 16, 18],
            [1999, 2923, 26.73, 30.82],
            [1999, 2924, 120, 90],
            [1999, 2925, 120, 90],
            [1999, 2928, 70, 70],
            [1999, 2929, 50.7, 47.79],
            [1999, 2930, 155, 210],
            [1999, 2931, 70, 70],
            [1999, 2932, 30, 24.3],
            [1999, 2933, 70, 70],
            [1999, 2934, 85.78, 39.36],
            [1999, 2935, 120, 90],
            [1999, 2936, 90.08, 68.66],
            [1999, 2937, 120, 90],
            [1999, 2940, 120, 90],
            [1999, 2942, 70, 70],
            [1999, 2943, 120, 90],
            [1999, 2944, 50, 60],
            [1999, 2946, 117.5, 74.87],
            [1999, 2948, 50, 60],
            [1999, 2950, 110.01, 49.26],
            [1999, 2951, 120, 90],
            [1999, 2952, 70, 70],
            [1999, 2955, 70, 70],
            [1999, 2956, 30.2, 34.9],
            [1999, 2957, 120, 90],
            [1999, 2958, 70, 70],
            [1999, 2960, 50, 60],
            [1999, 2961, 70, 70],
            [1999, 2962, 40, 50],
            [1999, 2963, 120, 90],
            [1999, 2964, 50, 60],
            [1999, 2965, 120, 90],
            [1999, 2969, 15.24, 25.59],
            [1999, 2971, 70, 70],
            [1999, 2972, 120, 90],
            [1999, 2973, 70, 65],
            [1999, 2974, 22.89, 34.75],
            [1999, 2975, 70, 70],
            [1999, 2976, 120, 90],
            [1999, 2978, 24.61, 18.48],
            [1999, 2979, 27.1, 18.5],
            [1999, 2980, 21.22, 18.94],
            [1999, 2982, 40, 50],
            [1999, 2984, 13.6, 13.23],
            [1999, 2985, 50, 60],
            [1999, 2986, 120, 90],
            [1999, 2988, 120, 90],
            [1999, 2989, 50, 60],
            [1999, 2991, 50, 60],
            [1999, 2995, 36.26, 41.54],
            [1999, 2997, 11.88, 8.2],
            [1999, 2999, 6.02, 5.8],
            [1999, 3000, 50, 60],
            [1999, 3001, 56.14, 45.79],
            [1999, 3002, 70, 70],
            [1999, 3003, 120, 90],
            [1999, 3004, 48.58, 95.54],
            [1999, 3006, 70, 70],
            [1999, 3008, 28.3, 32.4],
            [1999, 3009, 50, 60],
            [1999, 3011, 13.6, 28.86],
            [1999, 3012, 70, 70],
            [1999, 3014, 120, 90],
            [1999, 3015, 30, 37.5],
            [1999, 3016, 22.14, 18.78],
            [1999, 3017, 120, 90],
            [1999, 3019, 50, 60],
            [1999, 3022, 120, 90],
            [1999, 3024, 70, 70],
            [1999, 3025, 70, 70],
            [1999, 3026, 12.16, 8.01],
            [1999, 3027, 22, 43.41],
            [1999, 3031, 50, 60],
            [1999, 3033, 120, 90],
            [1999, 3035, 29.76, 27.35],
            [1999, 3037, 50, 60],
            [1999, 3041, 52.5, 52.5],
            [1999, 3042, 5.83, 5.64],
            [1999, 3043, 70, 70],
            [1999, 3044, 70, 70],
            [1999, 3045, 120, 90],
            [1999, 3046, 50.66, 21.51],
            [1999, 3047, 50, 60],
            [1999, 3048, 101.09, 97.17],
            [1999, 3049, 120, 90],
            [1999, 3050, 27.97, 29.63],
            [1999, 3051, 120, 90],
            [1999, 3052, 50, 60],
            [1999, 3053, 70, 70],
            [1999, 3054, 50, 60],
            [1999, 3055, 120, 90],
            [1999, 3056, 15.98, 16.7],
            [1999, 3057, 70, 70],
            [1999, 3058, 70, 70],
            [1999, 3059, 120, 90],
            [1999, 3060, 70, 70],
            [1999, 3061, 128.24, 46.52],
            [1999, 3063, 70, 70],
            [1999, 3064, 121, 253],
            [1999, 3066, 70, 70],
            [1999, 3069, 120, 90],
            [1999, 3070, 56.43, 49.17],
            [1999, 3073, 120, 90],
            [1999, 3076, 120, 90],
            [1999, 3077, 39.42, 34.65],
            [1999, 3078, 70, 70],
            [1999, 3079, 70, 70],
            [1999, 3084, 70, 70],
            [1999, 3085, 50, 60],
            [1999, 3086, 97.92, 38.7],
            [1999, 3087, 70, 70],
            [1999, 3089, 38.17, 24],
            [1999, 3090, 50, 60],
            [1999, 3091, 19.67, 20.1],
            [1999, 3092, 70, 70],
            [1999, 3095, 120, 90],
            [1999, 3098, 20.76, 58.98],
            [1999, 3100, 120, 90],
            [1999, 3101, 120, 90],
            [1999, 3104, 7.73, 6.59],
            [1999, 3105, 70, 70],
            [1999, 3106, 34.5, 25.1],
            [1999, 3107, 120, 90],
            [1999, 3109, 50, 60],
            [1999, 3112, 79.98, 40.43],
            [1999, 3113, 50, 60],
            [1999, 3114, 120, 90],
            [1999, 3115, 120, 90],
            [1999, 3117, 50, 60],
            [1999, 3118, 120, 90],
            [1999, 3119, 12.2, 16.8],
            [1999, 3121, 69.55, 32.33],
            [1999, 3122, 63.25, 33.78],
            [1999, 3123, 120, 90],
            [1999, 3126, 70, 70],
            [1999, 3127, 9.37, 9.65],
            [1999, 3128, 62, 50],
            [1999, 3129, 37.84, 31.71],
            [1999, 3130, 12, 10],
            [1999, 3131, 8.27, 8.03],
            [1999, 3132, 120, 90],
            [1999, 3133, 72.02, 36.75],
            [1999, 3134, 50, 45],
            [1999, 3135, 120, 90],
            [1999, 3136, 40, 50],
            [1999, 3137, 12.56, 13.35],
            [1999, 3138, 120, 90],
            [1999, 3139, 5.88, 5.48],
            [1999, 3140, 70, 70],
            [1999, 3141, 50, 60],
            [1999, 3142, 40, 50],
            [1999, 3143, 70, 70],
            [1999, 3144, 120, 90],
            [1999, 3148, 33.08, 29.22],
            [1999, 3149, 120, 90],
            [1999, 3151, 120, 90],
            [1999, 3152, 50, 60],
            [1999, 3154, 87.45, 60.56],
            [1999, 3155, 98.27, 51.32],
            [1999, 3158, 18, 18],
            [1999, 3160, 37.27, 60.05],
            [1999, 3161, 20.3, 19.5],
            [1999, 3163, 70, 70],
            [1999, 3164, 70, 70],
            [1999, 3165, 70, 45.26],
            [1999, 3166, 0.17, 0.59],
            [1999, 3167, 69.49, 38],
            [1999, 3168, 120, 90],
            [1999, 3171, 40, 50],
            [1999, 3172, 120, 90],
            [1999, 3175, 73.26, 36.41],
            [1999, 3177, 37.5, 45],
            [1999, 3181, 8.14, 6.4],
            [1999, 3182, 22.27, 15.36],
            [1999, 3183, 51.17, 40.2],
            [1999, 3184, 70, 70],
            [1999, 3187, 24.7, 20.1],
            [1999, 3188, 14.43, 16.56],
            [1999, 3189, 192.54, 70.66],
            [1999, 3190, 26.99, 20.03],
            [1999, 3191, 70, 70],
            [1999, 3192, 120, 90],
            [1999, 3195, 22.52, 19.08],
            [1999, 3196, 70, 70],
            [1999, 3197, 99.63, 37.69],
            [1999, 3198, 9.06, 10.25],
            [1999, 3199, 70, 70],
            [1999, 3200, 40, 50],
            [1999, 3203, 12.22, 10.64],
            [1999, 3206, 36.81, 46.42],
            [1999, 3207, 50, 60],
            [1999, 3208, 120, 90],
            [1999, 3211, 70, 70],
            [1999, 3212, 120, 90],
            [1999, 3214, 70, 70],
            [1999, 3216, 120, 90],
            [1999, 3217, 34.82, 34.71],
            [1999, 3219, 10.36, 9.85],
            [1999, 3220, 120, 90],
            [1999, 3221, 70, 70],
            [1999, 3225, 6.02, 7.89],
            [1999, 3227, 25, 20],
            [1999, 3228, 34.26, 35.61],
            [1999, 3229, 120, 90],
            [1999, 3231, 26.42, 28.94],
            [1999, 3234, 37.45, 21.3],
            [1999, 3239, 120, 90],
            [1999, 3240, 120, 90],
            [1999, 3241, 50, 60],
            [1999, 3242, 70, 70],
            [1999, 3243, 12.14, 9.5],
            [1999, 3244, 120, 90],
            [1999, 3246, 65.38, 60.87],
            [1999, 3247, 120, 90],
            [1999, 3248, 40, 17.83],
            [1999, 3249, 120, 90],
            [1999, 3251, 40, 50],
            [1999, 3252, 50, 60],
            [1999, 3253, 70, 70],
            [1999, 3254, 40.73, 38.06],
            [1999, 3255, 70, 70],
            [1999, 3256, 30.27, 22.34],
            [1999, 3257, 50, 60],
            [1999, 3258, 70, 70],
            [1999, 3259, 50, 60],
            [1999, 3260, 10, 13.06],
            [1999, 3262, 70, 70],
            [1999, 3263, 120, 90],
            [1999, 3264, 13.13, 23.21],
            [1999, 3265, 120, 90],
            [1999, 3266, 70, 70],
            [1999, 3267, 50, 60],
            [1999, 3268, 59.2, 40.69],
            [1999, 3270, 17.3, 14.21],
            [1999, 3271, 120, 90],
            [1999, 3272, 106.83, 78.93],
            [1999, 3273, 120, 90],
            [1999, 3274, 45, 32.77],
            [1999, 3275, 120, 90],
            [1999, 3276, 120, 90],
            [1999, 3277, 91.74, 42.99],
            [1999, 3278, 63.11, 20.86],
            [1999, 3279, 70, 70],
            [1999, 3280, 59.87, 41.55],
            [1999, 3283, 12.69, 12.13],
            [1999, 3284, 42.57, 30.98],
            [1999, 3286, 15.7, 9.65],
            [1999, 3287, 50, 60],
            [1999, 3288, 30.42, 23.34],
            [1999, 3289, 85, 70],
            [1999, 3290, 21.59, 14.57],
            [1999, 3292, 120, 90],
            [1999, 3293, 70, 70],
            [1999, 3294, 50, 60],
            [1999, 3295, 120, 90],
            [1999, 3296, 30, 45],
            [1999, 3300, 70, 70],
            [1999, 3301, 70, 70],
            [1999, 3302, 40, 50],
            [1999, 3303, 70, 70],
            [1999, 3305, 120, 90],
            [1999, 3306, 32.44, 29.79],
            [1999, 3308, 70, 70],
            [1999, 3309, 50, 45],
            [1999, 3312, 70, 70],
            [1999, 3313, 120, 90],
            [1999, 3314, 50, 60],
            [1999, 3315, 120, 90],
            [1999, 3316, 120, 90],
            [1999, 3318, 70, 70],
            [1999, 3319, 70, 70],
            [1999, 3320, 120, 90],
            [1999, 3321, 50, 60],
            [1999, 3322, 120, 90],
            [1999, 3324, 9.8, 13.83],
            [1999, 3325, 38.61, 28.27],
            [1999, 3326, 51.15, 39.66],
            [1999, 3327, 98.77, 87.26],
            [1999, 3328, 120, 90],
            [1999, 3329, 8.87, 8.14],
            [1999, 3331, 108.09, 47.79],
            [1999, 3332, 120, 90],
            [1999, 3333, 120, 90],
            [1999, 3334, 8.78, 7.44],
            [1999, 3335, 70, 70],
            [1999, 3336, 46.22, 26.88],
            [1999, 3338, 70, 70],
            [1999, 3340, 50, 60],
            [1999, 3341, 24.19, 12.04],
            [1999, 3342, 70, 70],
            [1999, 3343, 120, 90],
            [1999, 3344, 99.81, 58.02],
            [1999, 3346, 62.21, 43.82],
            [1999, 3347, 120, 90],
            [1999, 3348, 70, 70],
            [1999, 3350, 120, 90],
            [1999, 3351, 120, 90],
            [1999, 3353, 120, 90],
            [1999, 3357, 12.58, 12.94],
            [1999, 3358, 19.2, 17.45],
            [1999, 3359, 120, 90],
            [1999, 3361, 120, 90],
            [1999, 3363, 14.08, 11.88],
            [1999, 3364, 12, 21.69],
            [1999, 3366, 120, 90],
            [1999, 3367, 50, 60],
            [1999, 3369, 120, 90],
            [1999, 3370, 47.38, 71.88],
            [1999, 3371, 70, 60],
            [1999, 3372, 70, 70],
            [1999, 3376, 120, 90],
            [1999, 3378, 9.02, 8.54],
            [1999, 3380, 120, 90],
            [1999, 3381, 120, 90],
            [1999, 3382, 23.2, 25.03],
            [1999, 3384, 70, 70],
            [1999, 3386, 120, 90],
            [1999, 3387, 70, 70],
            [1999, 3388, 120, 90],
            [1999, 3389, 31.29, 20.21],
            [1999, 3390, 120, 90],
            [1999, 3391, 120, 90],
            [1999, 3392, 120, 90],
            [1999, 3393, 120, 90],
            [1999, 3394, 120, 90],
            [1999, 3396, 21.88, 28.51],
            [1999, 3399, 70, 70],
            [1999, 3400, 50, 60],
            [1999, 3402, 120, 90],
            [1999, 3403, 16.87, 10.26],
            [1999, 3404, 41.37, 52.15],
            [1999, 3407, 59.05, 33.48],
            [1999, 3408, 120, 90],
            [1999, 3411, 70, 70],
            [1999, 3414, 50, 60],
            [1999, 3415, 40, 50],
            [1999, 3416, 40, 50],
            [1999, 3417, 70, 70],
            [1999, 3418, 120, 90],
            [1999, 3419, 70, 70],
            [1999, 3420, 70, 70],
            [1999, 3422, 50.99, 25.75],
            [1999, 3423, 120, 90],
            [1999, 3424, 37.5, 45],
            [1999, 3426, 120, 90],
            [1999, 3428, 70, 70],
            [1999, 3429, 46.45, 44.76],
            [1999, 3431, 120, 90],
            [1999, 3432, 70, 70],
            [1999, 3433, 19.6, 20.1],
            [1999, 3434, 6.86, 5.46],
            [1999, 3436, 50, 60],
            [1999, 3437, 70, 70],
            [1999, 3438, 70, 70],
            [1999, 3439, 60.72, 58.05],
            [1999, 3440, 50, 60],
            [1999, 3441, 59.78, 46.81],
            [1999, 3442, 42.15, 37.9],
            [1999, 3444, 17.9, 15.29],
            [1999, 3445, 70, 70],
            [1999, 3448, 5.56, 6.38],
            [1999, 3449, 70, 70],
            [1999, 3450, 70, 70],
            [1999, 3451, 71.38, 68.39],
            [1999, 3452, 120, 90],
            [1999, 3453, 15.33, 23.54],
            [1999, 3454, 18.63, 15.82],
            [1999, 3456, 120, 90],
            [1999, 3457, 120, 90],
            [1999, 3459, 72.5, 55.8],
            [1999, 3461, 68.26, 26.15],
            [1999, 3462, 55.41, 24.77],
            [1999, 3463, 120, 90],
            [1999, 3464, 120, 90],
            [1999, 3468, 73.94, 42.49],
            [1999, 3469, 34.89, 19.21],
            [1999, 3471, 70, 70],
            [1999, 3472, 120, 90],
            [1999, 3473, 12.27, 10.63],
            [1999, 3474, 70, 70],
            [1999, 3476, 40, 50],
            [1999, 3480, 120, 90],
            [1999, 3481, 120, 206],
            [1999, 3482, 70, 70],
            [1999, 3483, 70, 70],
            [1999, 3484, 120, 90],
            [1999, 3485, 52.28, 52.85],
            [1999, 3487, 50, 60],
            [1999, 3488, 23, 23],
            [1999, 3489, 40, 50],
            [1999, 3492, 120, 90],
            [1999, 3493, 70, 70],
            [1999, 3494, 12, 18],
            [1999, 3496, 120, 90],
            [1999, 3497, 120, 90],
            [1999, 3498, 38.68, 34.83],
            [1999, 3499, 120, 90],
            [1999, 3501, 120, 90],
            [1999, 3503, 120, 90],
            [1999, 3504, 70, 70],
            [1999, 3505, 120, 90],
            [1999, 3508, 120, 90],
            [1999, 3509, 40, 60],
            [1999, 3510, 120, 90],
            [1999, 3511, 70, 70],
            [1999, 3514, 18.7, 27],
            [1999, 3515, 70, 70],
            [1999, 3516, 120, 90],
            [1999, 3517, 70, 70],
            [1999, 3518, 120, 90],
            [1999, 3519, 50, 60],
            [1999, 3520, 120, 90],
            [1999, 3521, 120, 90],
            [1999, 3523, 120, 90],
            [1999, 3525, 120, 90],
            [1999, 3527, 120, 90],
            [1999, 3530, 52.8, 38.6],
            [1999, 3531, 70.97, 39.98],
            [1999, 3534, 70, 70],
            [1999, 3535, 30, 45],
            [1999, 3537, 120, 90],
            [1999, 3539, 120, 90],
            [1999, 3541, 42.81, 43.65],
            [1999, 3543, 120, 90],
            [1999, 3545, 120, 90],
            [1999, 3546, 120, 90],
            [1999, 3549, 22.69, 14.17],
            [1999, 3551, 120, 90],
            [1999, 3553, 70, 70],
            [1999, 3554, 50, 60],
            [1999, 3555, 40, 50],
            [1999, 3557, 16.81, 25.35],
            [1999, 3558, 70, 70],
            [1999, 3559, 50, 60],
            [1999, 3560, 120, 90],
            [1999, 3561, 120, 90],
            [1999, 3564, 120, 90],
            [1999, 3566, 17.61, 17.41],
            [1999, 3568, 12.22, 9.98],
            [1999, 3569, 50, 60],
            [1999, 3570, 70, 70],
            [1999, 3571, 70, 70],
            [1999, 3572, 120, 90],
            [1999, 3573, 120, 90],
            [1999, 3575, 120, 90],
            [1999, 3576, 120, 90],
            [1999, 3577, 70, 70],
            [1999, 3579, 22.92, 33.97],
            [1999, 3580, 70, 70],
            [1999, 3581, 120, 90],
            [1999, 3582, 4.45, 5.68],
            [1999, 3585, 70, 70],
            [1999, 3586, 70, 70],
            [1999, 3587, 70, 70],
            [1999, 3588, 120, 90],
            [1999, 3589, 12, 18],
            [1999, 3590, 40, 43.95],
            [1999, 3592, 70, 70],
            [1999, 3593, 35.78, 25.31],
            [1999, 3594, 120, 90],
            [1999, 3595, 120, 90],
            [1999, 3596, 120, 90],
            [1999, 3597, 70, 70],
            [1999, 3598, 22.96, 24.32],
            [1999, 3599, 120, 90],
            [1999, 3600, 49.66, 38.48],
            [1999, 3601, 40, 50],
            [1999, 3602, 51.79, 46.05],
            [1999, 3606, 40, 50],
            [1999, 3607, 12.7, 15.8],
            [1999, 3608, 33.57, 26.7],
            [1999, 3609, 120, 90],
            [1999, 3610, 50, 71],
            [1999, 3611, 156, 211],
            [1999, 3612, 70, 70],
            [1999, 3613, 40, 50],
            [1999, 3614, 9.76, 7.31],
            [1999, 3615, 70, 70],
            [1999, 3617, 70, 70],
            [1999, 3619, 70, 70],
            [1999, 3620, 50, 60],
            [1999, 3621, 50, 60],
            [1999, 3622, 120, 90],
            [1999, 3623, 120, 90],
            [1999, 3624, 16.21, 10.44],
            [1999, 3626, 120, 90],
            [1999, 3627, 120, 90],
            [1999, 3628, 30, 45],
            [1999, 3629, 70, 70],
            [1999, 3631, 70, 70],
            [1999, 3632, 47.16, 37.74],
            [1999, 3633, 70, 70],
            [1999, 3634, 24.1, 17.22],
            [1999, 3635, 50, 60],
            [1999, 3636, 70, 70],
            [1999, 3637, 40, 50],
            [1999, 3639, 120, 90],
            [1999, 3641, 40, 50],
            [1999, 3642, 58.18, 27.21],
            [1999, 3643, 70, 70],
            [1999, 3644, 36.34, 36.78],
            [1999, 3647, 70, 70],
            [1999, 3648, 70, 70],
            [1999, 3649, 120, 90],
            [1999, 3650, 93.96, 49.61],
            [1999, 3651, 40, 50],
            [1999, 3652, 40, 50],
            [1999, 3653, 52.81, 42.1],
            [1999, 3656, 16.63, 13.83],
            [1999, 3657, 40, 50],
            [1999, 3659, 45.77, 17.29],
            [1999, 3661, 49.38, 28.07],
            [1999, 3662, 30, 45],
            [1999, 3663, 120, 90],
            [1999, 3665, 120, 90],
            [1999, 3666, 120, 90],
            [1999, 3667, 30.55, 36.38],
            [1999, 3668, 120, 90],
            [1999, 3669, 12, 25.38],
            [1999, 3670, 91.39, 52.48],
            [1999, 3671, 120, 90],
            [1999, 3675, 120, 90],
            [1999, 3676, 120, 90],
            [1999, 3677, 50, 60],
            [1999, 3678, 11.23, 7.28],
            [1999, 3679, 29.5, 43.67],
            [1999, 3681, 70, 70],
            [1999, 3683, 7.87, 11.07],
            [1999, 3685, 120, 90],
            [1999, 3686, 120, 90],
            [1999, 3687, 70, 70],
            [1999, 3688, 120, 90],
            [1999, 3690, 120, 90],
            [1999, 3691, 13.11, 11.71],
            [1999, 3692, 50, 60],
            [1999, 3694, 70, 70],
            [1999, 3695, 120, 90],
            [1999, 3696, 70, 70],
            [1999, 3698, 120, 90],
            [1999, 3700, 25.38, 59.21],
            [1999, 3701, 29.01, 18.72],
            [1999, 3702, 16.7, 11.85],
            [1999, 3703, 175.88, 66.13],
            [1999, 3705, 30, 45],
            [1999, 3707, 70, 70],
            [1999, 3708, 70, 70],
            [1999, 3710, 50, 60],
            [1999, 3711, 9.31, 9.41],
            [1999, 3713, 70, 70],
            [1999, 3714, 120, 90],
            [1999, 3716, 120, 90],
            [1999, 3718, 70, 70],
            [1999, 3719, 120, 90],
            [1999, 3720, 95.89, 30.16],
            [1999, 3722, 40, 50],
            [1999, 3723, 30, 45],
            [1999, 3724, 12.29, 10.32],
            [1999, 3726, 12, 18],
            [1999, 3728, 120, 90],
            [1999, 3729, 120, 90],
            [1999, 3731, 40, 25.08],
            [1999, 3733, 120, 90],
            [1999, 3738, 30, 45],
            [1999, 3741, 120, 90],
            [1999, 3745, 120, 90],
            [1999, 3747, 33.24, 30.21],
            [1999, 3748, 120, 90],
            [1999, 3749, 120, 90],
            [1999, 3751, 27.22, 22.15],
            [1999, 3752, 120, 90],
            [1999, 3753, 50, 60],
            [1999, 3755, 31.04, 34.22],
            [1999, 3756, 120, 90],
            [1999, 3758, 50, 60],
            [1999, 3759, 70, 70],
            [1999, 3761, 36.17, 17.01],
            [1999, 3762, 49.07, 30.08],
            [1999, 3763, 70, 70],
            [1999, 3764, 56.14, 29.13],
            [1999, 3765, 36.87, 29.24],
            [1999, 3766, 50, 60],
            [1999, 3768, 70, 70],
            [1999, 3769, 120, 90],
            [1999, 3775, 16.7, 21.1],
            [1999, 3776, 120, 90],
            [1999, 3777, 64.75, 33.71],
            [1999, 3780, 70, 70],
            [1999, 3781, 120, 90],
            [1999, 3782, 33.84, 17.76],
            [1999, 3783, 70, 70],
            [1999, 3785, 120, 90],
            [1999, 3786, 10.14, 9.72],
            [1999, 3791, 120, 90],
            [1999, 3793, 70, 70],
            [1999, 3795, 28.93, 71.01],
            [1999, 3796, 34.35, 19.61],
            [1999, 3797, 50, 60],
            [1999, 3799, 50, 60],
            [1999, 3800, 70, 70],
            [1999, 3801, 120, 90],
            [1999, 3802, 50, 60],
            [1999, 3804, 70, 70],
            [1999, 3807, 23.88, 19.39],
            [1999, 3811, 50, 60],
            [1999, 3812, 120, 90],
            [1999, 3814, 121, 70],
            [1999, 3815, 8.38, 6.36],
            [1999, 3816, 120, 90],
            [1999, 3820, 50, 60],
            [1999, 3821, 18.9, 24.5],
            [1999, 3822, 120, 90],
            [1999, 3824, 70, 70],
            [1999, 3826, 70, 70],
            [1999, 3827, 104.49, 49.9],
            [1999, 3828, 48.71, 27.21],
            [1999, 3830, 6.73, 6.06],
            [1999, 3832, 58.73, 69.61],
            [1999, 3833, 30, 45],
            [1999, 3834, 82.66, 53.29],
            [1999, 3837, 70, 70],
            [1999, 3839, 120, 90],
            [1999, 3840, 120, 90],
            [1999, 3841, 115.85, 58.55],
            [1999, 3842, 70, 70],
            [1999, 3843, 4.12, 8.93],
            [1999, 3845, 16.28, 21.19],
            [1999, 3846, 70, 70],
            [1999, 3849, 70, 70],
            [1999, 3850, 28.31, 33.02],
            [1999, 3851, 120, 90],
            [1999, 3853, 120, 90],
            [1999, 3854, 20.59, 23],
            [1999, 3855, 120, 90],
            [1999, 3856, 16.7, 22.9],
            [1999, 3858, 120, 90],
            [1999, 3859, 12, 23.21],
            [1999, 3862, 70, 70],
            [1999, 3863, 50, 60],
            [1999, 3865, 120, 90],
            [1999, 3866, 14.49, 13.27],
            [1999, 3867, 120, 90],
            [1999, 3868, 120, 90],
            [1999, 3869, 50, 60],
            [1999, 3870, 113.75, 53.42],
            [1999, 3871, 46.79, 28.4],
            [1999, 3873, 120, 90],
            [1999, 3874, 41.13, 34.16],
            [1999, 3877, 70, 70],
            [1999, 3879, 120, 90],
            [1999, 3880, 15.73, 17.34],
            [1999, 3881, 50, 60],
            [1999, 3882, 120, 90],
            [1999, 3883, 57.22, 73.4],
            [1999, 3884, 50, 60],
            [1999, 3886, 70, 70],
            [1999, 3887, 120, 90],
            [1999, 3889, 70, 70],
            [1999, 3890, 10.56, 9.46],
            [1999, 3891, 17.06, 21.5],
            [1999, 3892, 70, 70],
            [1999, 3896, 70, 70],
            [1999, 3897, 46.88, 27.21],
            [1999, 3898, 120, 90],
            [1999, 3899, 120, 90],
            [1999, 3900, 50.61, 29.08],
            [1999, 3901, 70, 70],
            [1999, 3903, 50, 60],
            [1999, 3905, 90.98, 55.27],
            [1999, 3906, 70, 70],
            [1999, 3909, 120, 90],
            [1999, 3910, 70, 70],
            [1999, 3915, 30, 45],
            [1999, 3916, 120, 90],
            [1999, 3918, 8.88, 7.78],
            [1999, 3919, 120, 90],
            [1999, 3921, 34.37, 32.04],
            [1999, 3922, 120, 90],
            [1999, 3923, 70, 70],
            [1999, 3924, 11.01, 5.63],
            [1999, 3925, 87.13, 64.34],
            [1999, 3927, 70, 70],
            [1999, 3928, 15.78, 11.76],
            [1999, 3929, 120, 90],
            [1999, 3930, 70, 70],
            [1999, 3931, 70, 70],
            [1999, 3932, 32.72, 42.52],
            [1999, 3933, 70, 70],
            [1999, 3935, 120, 90],
            [1999, 3936, 70, 70],
            [1999, 3937, 50, 60],
            [1999, 3938, 50, 60],
            [1999, 3939, 40, 50],
            [1999, 3940, 53.79, 32.63],
            [1999, 3941, 120, 90],
            [1999, 3942, 32.24, 20.58],
            [1999, 3943, 16.04, 19.53],
            [1999, 3944, 120, 90],
            [1999, 3946, 9.98, 9.98],
            [1999, 3947, 120, 90],
            [1999, 3950, 120, 90],
            [1999, 3951, 120, 90],
            [1999, 3952, 120, 90],
            [1999, 3953, 130.15, 56.8],
            [1999, 3954, 120, 90],
            [1999, 3956, 56.24, 62.52],
            [1999, 3958, 13.07, 12.08],
            [1999, 3959, 107.55, 47.75],
            [1999, 3960, 26.79, 20.82],
            [1999, 3961, 8.09, 5.91],
            [1999, 3963, 24.93, 29.76],
            [1999, 3964, 70, 70],
            [1999, 3966, 70, 70],
            [1999, 3968, 26.82, 32.61],
            [1999, 3969, 73.5, 49.04],
            [1999, 3970, 22.45, 62.54],
            [1999, 3971, 120, 90],
            [1999, 3972, 120, 86],
            [1999, 3976, 12, 24.6],
            [1999, 3978, 70, 70],
            [1999, 3979, 70, 70],
            [1999, 3980, 50, 60],
            [1999, 3981, 70, 70],
            [1999, 3982, 120, 90],
            [1999, 3983, 30, 45],
            [1999, 3985, 36, 28],
            [1999, 3988, 33.8, 45.99],
            [1999, 3990, 70, 70],
            [1999, 3991, 120, 90],
            [1999, 3992, 53.73, 58.98],
            [1999, 3993, 12, 18],
            [1999, 3994, 120, 90],
            [1999, 3996, 70, 95],
            [1999, 3997, 120, 90],
            [1999, 3998, 120, 90],
            [1999, 3999, 29.09, 38.47],
            [1999, 4001, 120, 90],
            [1999, 4002, 120, 90],
            [1999, 4003, 70, 70],
            [1999, 4004, 70, 70],
            [1999, 4005, 51.86, 17.81],
            [1999, 4007, 120, 90],
            [1999, 4008, 70, 70],
            [1999, 4010, 8.6, 12.5],
            [1999, 4012, 120, 90],
            [1999, 4013, 120, 90],
            [1999, 4014, 120, 90],
            [1999, 4015, 120, 90],
            [1999, 4016, 21, 33],
            [1999, 4017, 84.3, 28.73],
            [1999, 4018, 50, 60],
            [1999, 4019, 40, 50],
            [1999, 4021, 70, 70],
            [1999, 4022, 70, 70],
            [1999, 4023, 27.39, 27.85],
            [1999, 4024, 120, 90],
            [1999, 4026, 36.65, 22.13],
            [1999, 4027, 120, 90],
            [1999, 4028, 70, 70],
            [1999, 4031, 28.52, 48.27],
            [1999, 4034, 120, 90],
            [1999, 4035, 17.68, 13.86],
            [1999, 4038, 120, 90],
            [1999, 4040, 85.79, 70.07],
            [1999, 4041, 120, 90],
            [1999, 4043, 20, 20],
            [1999, 4045, 10.39, 9.07],
            [1999, 4047, 44.52, 35.91],
            [1999, 4048, 14.6, 19.7],
            [1999, 4049, 70, 70],
            [1999, 4051, 120, 90],
            [1999, 4053, 64.92, 33.42],
            [1999, 4057, 50, 60],
            [1999, 4059, 70, 70],
            [1999, 4062, 70, 70],
            [1999, 4063, 50, 60],
            [1999, 4065, 70, 70],
            [1999, 4066, 70, 70],
            [1999, 4067, 102.05, 42.28],
            [1999, 4068, 169, 150],
            [1999, 4069, 58.37, 31.62],
            [1999, 4070, 70, 70],
            [1999, 4071, 70, 70],
            [1999, 4072, 120, 90],
            [1999, 4073, 30, 45],
            [1999, 4074, 70, 70],
            [1999, 4076, 120, 90],
            [1999, 4080, 120, 90],
            [1999, 4081, 120, 90],
            [1999, 4082, 120, 90],
            [1999, 4083, 120, 90],
            [1999, 4084, 14, 13.72],
            [1999, 4085, 70, 70],
            [1999, 4087, 120, 90],
            [1999, 4088, 120, 90],
            [1999, 4089, 39.55, 33.1],
            [1999, 4090, 120, 90],
            [1999, 4091, 70, 70],
            [1999, 4092, 70, 70],
            [1999, 4093, 120, 90],
            [1999, 4094, 50, 60],
            [1999, 4095, 37.45, 42.54],
            [1999, 4096, 37.85, 49.46],
            [1999, 4097, 120, 90],
            [1999, 4100, 50, 60],
            [1999, 4102, 70, 70],
            [1999, 4103, 70, 70],
            [1999, 4104, 70, 70],
            [1999, 4105, 120, 90],
            [1999, 4106, 12.41, 18.24],
            [1999, 4107, 120, 90],
            [1999, 4109, 11.09, 23.39],
            [1999, 4110, 70, 70],
            [1999, 4111, 53.38, 47.38],
            [1999, 4112, 40, 50],
            [1999, 4115, 120, 90],
            [1999, 4116, 31.55, 32.55],
            [1999, 4117, 50, 60],
            [1999, 4118, 41.47, 35.71],
            [1999, 4119, 120, 90],
            [1999, 4120, 27.58, 30.03],
            [1999, 4121, 70, 70],
            [1999, 4122, 103.31, 86.3],
            [1999, 4124, 46.81, 38.06],
            [1999, 4125, 12, 18],
            [1999, 4128, 28, 24.17],
            [1999, 4129, 14.06, 10.13],
            [1999, 4131, 16.41, 11.2],
            [1999, 4133, 70, 70],
            [1999, 4134, 79.03, 44.3],
            [1999, 4136, 50, 60],
            [1999, 4137, 120, 90],
            [1999, 4138, 11.77, 6.96],
            [1999, 4139, 30, 45],
            [1999, 4140, 49.79, 34.67],
            [1999, 4142, 70, 70],
            [1999, 4143, 50, 60],
            [1999, 4145, 120, 90],
            [1999, 4146, 6.49, 5.75],
            [1999, 4147, 120, 90],
            [1999, 4149, 50, 60],
            [1999, 4150, 70, 70],
            [1999, 4152, 106.07, 54.99],
            [1999, 4154, 120, 90],
            [1999, 4155, 70, 70],
            [1999, 4156, 76.31, 53.54],
            [1999, 4157, 70, 70],
            [1999, 4158, 120, 90],
            [1999, 4159, 6.8, 6.65],
            [1999, 4162, 120, 90],
            [1999, 4164, 20.48, 22.01],
            [1999, 4165, 120, 90],
            [1999, 4166, 30, 45],
            [1999, 4167, 70, 70],
            [1999, 4168, 37.5, 45],
            [1999, 4169, 35.25, 45.76],
            [1999, 4173, 12, 24.28],
            [1999, 4175, 51.01, 25.06],
            [1999, 4176, 12, 18],
            [1999, 4177, 40.07, 56.69],
            [1999, 4178, 120, 90],
            [1999, 4179, 23.41, 16.69],
            [1999, 4180, 14.1, 8.76],
            [1999, 4181, 70, 70],
            [1999, 4182, 76.84, 36.41],
            [1999, 4185, 27.78, 27.06],
            [1999, 4186, 50, 60],
            [1999, 4188, 120, 90],
            [1999, 4189, 24.6, 36],
            [1999, 4190, 120, 90],
            [1999, 4192, 50, 60],
            [1999, 4193, 120, 90],
            [1999, 4194, 120, 90],
            [1999, 4197, 50, 60],
            [1999, 4199, 78.4, 74.93],
            [1999, 4200, 12.14, 9.28],
            [1999, 4203, 62.98, 58.18],
            [1999, 4205, 120, 90],
            [1999, 4206, 12.5, 12],
            [1999, 4207, 60.24, 34.36],
            [1999, 4208, 120, 90],
            [1999, 4209, 22.23, 20.17],
            [1999, 4210, 56.87, 36.84],
            [1999, 4211, 120, 90],
            [1999, 4213, 40.9, 35.4],
            [1999, 4215, 120, 90],
            [1999, 4216, 120, 90],
            [1999, 4219, 30, 45],
            [1999, 4220, 101, 196],
            [1999, 4221, 70, 70],
            [1999, 4222, 120, 90],
            [1999, 4223, 5.37, 4.59],
            [1999, 4224, 42.19, 39.65],
            [1999, 4225, 120, 90],
            [1999, 4226, 73.7, 42.65],
            [1999, 4229, 36.01, 22.9],
            [1999, 4230, 70, 70],
            [1999, 4231, 70, 70],
            [1999, 4232, 40, 50],
            [1999, 4233, 40, 50],
            [1999, 4234, 70, 70],
            [1999, 4235, 6.53, 5.13],
            [1999, 4236, 139, 137],
            [1999, 4237, 120, 90],
            [1999, 4238, 120, 90],
            [1999, 4239, 120, 90],
            [1999, 4241, 120, 90],
            [1999, 4242, 46.74, 74.49],
            [1999, 4244, 11.58, 16.71],
            [1999, 4245, 64, 70],
            [1999, 4246, 23.77, 36.35],
            [1999, 4248, 70, 70],
            [1999, 4249, 120, 90],
            [1999, 4250, 120, 90],
            [1999, 4251, 120, 90],
            [1999, 4252, 7.87, 9.28],
            [1999, 4256, 50, 60],
            [1999, 4257, 40, 50],
            [1999, 4258, 17, 38.5],
            [1999, 4259, 12.25, 12.29],
            [1999, 4260, 120, 90],
            [1999, 4261, 50, 60],
            [1999, 4264, 8.46, 8.46],
            [1999, 4265, 70, 70],
            [1999, 4266, 120, 90],
            [1999, 4269, 120, 90],
            [1999, 4270, 120, 90],
            [1999, 4272, 98.28, 54.81],
            [1999, 4273, 120, 90],
            [1999, 4274, 120, 90],
            [1999, 4275, 70, 70],
            [1999, 4279, 25.11, 25.86],
            [1999, 4281, 70, 70],
            [1999, 4282, 50, 60],
            [1999, 4283, 19.15, 24.03],
            [1999, 4284, 120, 90],
            [1999, 4285, 36.64, 28.69],
            [1999, 4286, 120, 90],
            [1999, 4287, 14.84, 10.96],
            [1999, 4288, 120, 90],
            [1999, 4289, 43.54, 28.73],
            [1999, 4291, 50, 60],
            [1999, 4293, 7.15, 6.68],
            [1999, 4294, 79.07, 70],
            [1999, 4295, 70, 70],
            [1999, 4296, 120, 90],
            [1999, 4297, 70, 70],
            [1999, 4298, 120, 85],
            [1999, 4299, 70, 48.52],
            [1999, 4301, 60.86, 37.6],
            [1999, 4302, 26.64, 23.08],
            [1999, 4305, 70, 70],
            [1999, 4307, 120, 90],
            [1999, 4308, 120, 90],
            [1999, 4309, 11.7, 18],
            [1999, 4310, 50, 60],
            [1999, 4312, 70, 70],
            [1999, 4313, 120, 90],
            [1999, 4317, 50, 60],
            [1999, 4318, 44.5, 31.24],
            [1999, 4320, 46.9, 37],
            [1999, 4323, 24.53, 33.29],
            [1999, 4325, 29.6, 19.97],
            [1999, 4326, 11.3, 11.2],
            [1999, 4328, 70, 70],
            [1999, 4329, 24.49, 21.37],
            [1999, 4330, 70, 70],
            [1999, 4333, 17.64, 32.54],
            [1999, 4334, 120, 90],
            [1999, 4337, 30.93, 37.77],
            [1999, 4338, 19.83, 26.04],
            [1999, 4339, 21.74, 15.6],
            [1999, 4340, 13.6, 21.8],
            [1999, 4341, 120, 90],
            [1999, 4343, 120, 90],
            [1999, 4345, 64.97, 47.25],
            [1999, 4346, 50, 60],
            [1999, 4347, 120, 90],
            [1999, 4349, 19.92, 20.51],
            [1999, 4350, 45.83, 36.77],
            [1999, 4352, 27.75, 35.04],
            [1999, 4353, 40.7, 33.52],
            [1999, 4355, 120, 90],
            [1999, 4356, 12.68, 15.44],
            [1999, 4358, 23.24, 26.31],
            [1999, 4360, 70, 70],
            [1999, 4362, 57.64, 39.46],
            [1999, 4363, 70, 70],
            [1999, 4364, 60.02, 38.25],
            [1999, 4365, 120, 90],
            [1999, 4366, 70, 70],
            [1999, 4367, 120, 90],
            [1999, 4372, 70, 70],
            [1999, 4374, 52, 51],
            [1999, 4375, 70, 70],
            [1999, 4376, 120, 90],
            [1999, 4377, 70, 70],
            [1999, 4378, 70, 70],
            [1999, 4380, 66.47, 40.12],
            [1999, 4382, 70, 65],
            [1999, 4383, 70, 70],
            [1999, 4384, 41.7, 25.8],
            [1999, 4386, 16.95, 21.6],
            [1999, 4387, 120, 90],
            [1999, 4389, 70, 70],
            [1999, 4390, 120, 90],
            [1999, 4391, 21.62, 31.72],
            [1999, 4392, 70, 70],
            [1999, 4394, 70, 70],
            [1999, 4395, 70, 70],
            [1999, 4396, 70, 70],
            [1999, 4397, 7.76, 8.86],
            [1999, 4398, 70, 70],
            [1999, 4399, 50, 60],
            [1999, 4400, 120, 90],
            [1999, 4402, 40, 50],
            [1999, 4404, 120, 90],
            [1999, 4405, 6.29, 4.6],
            [1999, 4406, 63.31, 68.07],
            [1999, 4407, 70, 70],
            [1999, 4408, 18, 27],
            [1999, 4409, 120, 90],
            [1999, 4410, 70, 70],
            [1999, 4411, 120, 90],
            [1999, 4412, 120, 90],
            [1999, 4413, 26.66, 14.26],
            [1999, 4414, 18.02, 27],
            [1999, 4415, 126.64, 97.53],
            [1999, 4416, 70, 70],
            [1999, 4417, 50, 60],
            [1999, 4418, 70, 70],
            [1999, 4419, 70, 70],
            [1999, 4420, 5.73, 6.7],
            [1999, 4421, 76.43, 44.44],
            [1999, 4426, 12, 18],
            [1999, 4427, 40, 50],
            [1999, 4428, 70, 70],
            [1999, 4432, 70, 70],
            [1999, 4433, 120, 90],
            [1999, 4436, 40, 50],
            [1999, 4438, 50, 50],
            [1999, 4439, 40, 50],
            [1999, 4440, 70, 70],
            [1999, 4441, 16.95, 12.33],
            [1999, 4442, 18, 27],
            [1999, 4443, 41.1, 27.5],
            [1999, 4444, 70, 70],
            [1999, 4445, 70, 70],
            [1999, 4446, 34.09, 21.45],
            [1999, 4448, 70, 70],
            [1999, 4450, 120, 90],
            [1999, 4453, 50, 60],
            [1999, 4454, 25.13, 30.27],
            [1999, 4455, 70, 70],
            [1999, 4456, 15.9, 14.4],
            [1999, 4457, 40, 50],
            [1999, 4460, 70, 70],
            [1999, 4461, 25.09, 25.72],
            [1999, 4463, 38.22, 20.51],
            [1999, 4464, 44.69, 25.78],
            [1999, 4465, 70, 70],
            [1999, 4466, 70, 70],
            [1999, 4467, 120, 90],
            [1999, 4468, 70, 70],
            [1999, 4470, 50, 60],
            [1999, 4471, 135.92, 55.65],
            [1999, 4473, 70, 70],
            [1999, 4477, 37.5, 45],
            [1999, 4479, 120, 90],
            [1999, 4481, 120, 90],
            [1999, 4482, 120, 90],
            [1999, 4484, 120, 90],
            [1999, 4486, 120, 90],
            [1999, 4487, 44.33, 51.92],
            [1999, 4488, 70, 70],
            [1999, 4489, 11.71, 6.08],
            [1999, 4490, 120, 90],
            [1999, 4491, 70, 70],
            [1999, 4493, 35.69, 81.75],
            [1999, 4494, 19.4, 18.2],
            [1999, 4495, 82.86, 52.5],
            [1999, 4498, 70, 70],
            [1999, 4500, 17.11, 23.93],
            [1999, 4501, 120, 90],
            [1999, 4502, 50, 60],
            [1999, 4504, 29.9, 16.62],
            [1999, 4505, 70, 70],
            [1999, 4506, 32.1, 29.68],
            [1999, 4508, 43.63, 35.85],
            [1999, 4509, 120, 90],
            [1999, 4510, 33.56, 26.64],
            [1999, 4511, 70, 70],
            [1999, 4512, 12.38, 7.83],
            [1999, 4513, 40, 50],
            [1999, 4514, 120, 90],
            [1999, 4515, 33.39, 72.42],
            [1999, 4517, 29.39, 25.61],
            [1999, 4518, 72.62, 43.09],
            [1999, 4520, 22.49, 21.03],
            [1999, 4521, 115.81, 56],
            [1999, 4523, 50, 60],
            [1999, 4524, 25.93, 22.72],
            [1999, 4525, 50, 60],
            [1999, 4526, 7.23, 8.94],
            [1999, 4527, 120, 90],
            [1999, 4530, 13.96, 9.89],
            [1999, 4531, 120, 90],
            [1999, 4532, 66.87, 50.91],
            [1999, 4533, 70, 70],
            [1999, 4534, 70, 70],
            [1999, 4535, 70, 70],
            [1999, 4536, 7.2, 20.3],
            [1999, 4538, 18, 18],
            [1999, 4539, 78.64, 44.85],
            [1999, 4540, 10.59, 6.68],
            [1999, 4541, 120, 90],
            [1999, 4542, 65, 35],
            [1999, 4543, 37.5, 45],
            [1999, 4545, 70, 70],
            [1999, 4546, 16.6, 24.9],
            [1999, 4548, 20.54, 15.72],
            [1999, 4549, 23.8, 26.7],
            [1999, 4550, 65.66, 48.34],
            [1999, 4551, 70, 70],
            [1999, 4552, 55.6, 45.56],
            [1999, 4553, 120, 90],
            [1999, 4555, 11.6, 15.4],
            [1999, 4556, 120, 90],
            [1999, 4558, 90.79, 78.09],
            [1999, 4560, 120, 90],
            [1999, 4563, 53.86, 28.78],
            [1999, 4566, 70, 70],
            [1999, 4568, 50, 60],
            [1999, 4569, 70, 70],
            [1999, 4571, 70, 70],
            [1999, 4572, 105.72, 48.73],
            [1999, 4576, 28.7, 23.7],
            [1999, 4577, 13.21, 11.61],
            [1999, 4578, 70, 70],
            [1999, 4579, 8.36, 6.62],
            [1999, 4580, 50, 60],
            [1999, 4582, 70, 70],
            [1999, 4584, 40, 50],
            [1999, 4585, 70, 70],
            [1999, 4587, 120, 90],
            [1999, 4590, 70, 70],
            [1999, 4591, 38.76, 40.37],
            [1999, 4593, 6.78, 5.29],
            [1999, 4597, 120, 90],
            [1999, 4598, 120, 90],
            [1999, 4599, 120, 90],
            [1999, 4600, 50, 60],
            [1999, 4601, 33.72, 42.28],
            [1999, 4602, 36.28, 36.4],
            [1999, 4603, 120, 90],
            [1999, 4604, 120, 90],
            [1999, 4605, 9.5, 15.6],
            [1999, 4606, 35.1, 31.57],
            [1999, 4607, 120, 90],
            [1999, 4608, 38.4, 32.2],
            [1999, 4610, 70, 70],
            [1999, 4611, 62.95, 50.94],
            [1999, 4612, 105, 166],
            [1999, 4613, 120, 77.8],
            [1999, 4614, 70, 70],
            [1999, 4615, 120, 90],
            [1999, 4616, 27.98, 41.56],
            [1999, 4617, 95.75, 69.39],
            [1999, 4618, 70, 70],
            [1999, 4619, 70, 70],
            [1999, 4620, 70, 70],
            [1999, 4621, 40, 50],
            [1999, 4622, 120, 90],
            [1999, 4623, 18, 27],
            [1999, 4626, 40, 50],
            [1999, 4627, 70, 70],
            [1999, 4628, 120, 90],
            [1999, 4629, 70, 70],
            [1999, 4630, 120, 90],
            [1999, 4631, 20.43, 22.07],
            [1999, 4633, 28.23, 35.68],
            [1999, 4634, 34.71, 35.52],
            [1999, 4635, 16.11, 11.7],
            [1999, 4636, 120, 90],
            [1999, 4637, 70, 70],
            [1999, 4638, 54.7, 34.62],
            [1999, 4641, 15.53, 8.78],
            [1999, 4643, 120, 90],
            [1999, 4644, 15.8, 15.4],
            [1999, 4645, 50, 60],
            [1999, 4648, 50, 60],
            [1999, 4649, 50, 60],
            [1999, 4651, 70, 70],
            [1999, 4652, 50, 60],
            [1999, 4653, 120, 90],
            [1999, 4655, 120, 90],
            [1999, 4657, 120, 90],
            [1999, 4658, 70, 70],
            [1999, 4660, 70, 70],
            [1999, 4661, 70, 70],
            [1999, 4662, 70, 70],
            [1999, 4664, 10.86, 8.78],
            [1999, 4665, 120, 90],
            [1999, 4666, 120, 90],
            [1999, 4667, 70, 70],
            [1999, 4668, 62.61, 42.44],
            [1999, 4670, 70, 70],
            [1999, 4671, 120, 90],
            [1999, 4674, 15, 20],
            [1999, 4675, 19.2, 19.5],
            [1999, 4676, 13.79, 18.19],
            [1999, 4677, 70, 70],
            [1999, 4679, 120, 90],
            [1999, 4682, 120, 90],
            [1999, 4684, 39.81, 23.32],
            [1999, 4685, 60.96, 34.44],
            [1999, 4687, 14.2, 21.3],
            [1999, 4688, 17.49, 12.85],
            [1999, 4689, 50, 60],
            [1999, 4690, 70, 70],
            [1999, 4691, 27.06, 17.14],
            [1999, 4692, 3.57, 3.82],
            [1999, 4693, 119.12, 52.9],
            [1999, 4694, 58.28, 38.29],
            [1999, 4695, 70, 70],
            [1999, 4696, 120, 90],
            [1999, 4697, 120, 90],
            [1999, 4698, 70, 70],
            [1999, 4699, 120, 90],
            [1999, 4701, 70, 70],
            [1999, 4702, 120, 90],
            [1999, 4703, 23.69, 36.87],
            [1999, 4704, 120, 90],
            [1999, 4705, 120, 90],
            [1999, 4708, 70, 70],
            [1999, 4709, 120, 90],
            [1999, 4710, 8.73, 6.69],
            [1999, 4711, 34.53, 20.2],
            [1999, 4712, 50.55, 38.31],
            [1999, 4713, 50, 60],
            [1999, 4716, 120, 90],
            [1999, 4717, 29.78, 34.18],
            [1999, 4718, 120, 90],
            [1999, 4720, 49.72, 35.65],
            [1999, 4722, 120, 90],
            [1999, 4724, 47.15, 28.88],
            [1999, 4725, 8.6, 7.78],
            [1999, 4726, 120, 90],
            [1999, 4728, 25.36, 23.41],
            [1999, 4729, 68.67, 36.75],
            [1999, 4731, 4.74, 5.39],
            [1999, 4732, 50, 60],
            [1999, 4733, 70, 70],
            [1999, 4734, 20, 20],
            [1999, 4736, 70, 70],
            [1999, 4737, 120, 90],
            [1999, 4738, 50.45, 38.8],
            [1999, 4740, 70, 70],
            [1999, 4741, 50, 60],
            [1999, 4742, 120, 90],
            [1999, 4743, 70, 70],
            [1999, 4744, 40, 50],
            [1999, 4745, 40, 50],
            [1999, 4747, 55.87, 35.31],
            [1999, 4749, 70, 70],
            [1999, 4750, 9.46, 10.97],
            [1999, 4751, 50, 60],
            [1999, 4752, 70, 70],
            [1999, 4753, 88.11, 37.86],
            [1999, 4754, 120, 90],
            [1999, 4755, 13.77, 7.34],
            [1999, 4756, 40, 50],
            [1999, 4757, 120, 90],
            [1999, 4760, 120, 90],
            [1999, 4761, 15.75, 12.37],
            [1999, 4762, 52.5, 52.5],
            [1999, 4764, 46.9, 75],
            [1999, 4765, 50, 60],
            [1999, 4771, 70, 70],
            [1999, 4772, 70, 70],
            [1999, 4775, 70, 70],
            [1999, 4776, 37.5, 45],
            [1999, 4777, 24.04, 33.32],
            [1999, 4778, 50, 60],
            [1999, 4779, 50, 60],
            [1999, 4780, 110.99, 50.6],
            [1999, 4781, 30, 37.5],
            [1999, 4782, 70, 70],
            [1999, 4784, 120, 90],
            [1999, 4785, 120, 90],
            [1999, 4786, 120, 90],
            [1999, 4788, 6.3, 12.1],
            [1999, 4789, 70, 70],
            [1999, 4790, 70, 70],
            [1999, 4791, 48.77, 79.01],
            [1999, 4792, 70, 70],
            [1999, 4793, 120, 90],
            [1999, 4794, 41.99, 22.03],
            [1999, 4797, 20.25, 21.58],
            [1999, 4799, 70, 70],
            [1999, 4800, 17.87, 23.42],
            [1999, 4801, 21, 27],
            [1999, 4802, 128.4, 56.12],
            [1999, 4803, 70, 70],
            [1999, 4805, 16.75, 18],
            [1999, 4806, 70, 70],
            [1999, 4807, 50, 60],
            [1999, 4809, 120, 90],
            [1999, 4810, 120, 90],
            [1999, 4811, 50, 60],
            [1999, 4812, 120, 90],
            [1999, 4814, 120, 90],
            [1999, 4815, 39.69, 32.93],
            [1999, 4816, 70, 70],
            [1999, 4818, 120, 90],
            [1999, 4819, 57.44, 40.47],
            [1999, 4820, 70, 70],
            [1999, 4821, 120, 90],
            [1999, 4825, 120, 90],
            [1999, 4826, 28.39, 26.06],
            [1999, 4828, 47.32, 22.66],
            [1999, 4829, 45.03, 39.57],
            [1999, 4831, 7.24, 8.44],
            [1999, 4832, 12, 18],
            [1999, 4834, 120, 90],
            [1999, 4835, 51.6, 40.69],
            [1999, 4838, 39.63, 29.51],
            [1999, 4839, 37.82, 38.91],
            [1999, 4840, 70, 70],
            [1999, 4841, 120, 90],
            [1999, 4842, 120, 90],
            [1999, 4844, 49.21, 40.22],
            [1999, 4846, 12.98, 17.47],
            [1999, 4848, 120, 90],
            [1999, 4849, 14.83, 14.22],
            [1999, 4851, 120, 90],
            [1999, 4852, 70, 70],
            [1999, 4853, 10.34, 10.99],
            [1999, 4854, 120, 90],
            [1999, 4856, 12, 18],
            [1999, 4863, 70, 70],
            [1999, 4864, 8.85, 15.97],
            [1999, 4865, 40, 50],
            [1999, 4866, 12, 18],
            [1999, 4867, 38.67, 22.56],
            [1999, 4869, 120, 90],
            [1999, 4871, 21.01, 27.1],
            [1999, 4872, 26.5, 30.18],
            [1999, 4875, 11.1, 18.8],
            [1999, 4876, 40, 50],
            [1999, 4877, 18.65, 29.18],
            [1999, 4878, 50, 60],
            [1999, 4879, 120, 90],
            [1999, 4880, 23.1, 15.3],
            [1999, 4881, 32.11, 49.85],
            [1999, 4882, 120, 90],
            [1999, 4885, 18, 23.69],
            [1999, 4887, 120, 90],
            [1999, 4888, 70, 70],
            [1999, 4893, 53.46, 31.32],
            [1999, 4894, 50, 60],
            [1999, 4895, 120, 90],
            [1999, 4896, 18.2, 35.8],
            [1999, 4897, 22.65, 32.49],
            [1999, 4902, 70, 70],
            [1999, 4905, 44, 67],
            [1999, 4906, 40, 50],
            [1999, 4907, 70, 70],
            [1999, 4909, 17.42, 19.96],
            [1999, 4910, 16.17, 15.54],
            [1999, 4911, 11.82, 7.07],
            [1999, 4912, 12.39, 15.28],
            [1999, 4914, 120, 90],
            [1999, 4915, 12.81, 25.88],
            [1999, 4916, 70, 70],
            [1999, 4918, 29.8, 29.23],
            [1999, 4920, 40, 50],
            [1999, 4922, 68.28, 37.1],
            [1999, 4923, 120, 90],
            [1999, 4926, 55.14, 28.19],
            [1999, 4927, 28.01, 18.8],
            [1999, 4928, 70, 70],
            [1999, 4929, 70, 70],
            [1999, 4930, 70, 70],
            [1999, 4931, 34.13, 33.6],
            [1999, 4934, 51.99, 38.18],
            [1999, 4936, 120, 90],
            [1999, 4939, 28.05, 30.31],
            [1999, 4940, 95.48, 82.93],
            [1999, 4942, 50, 60],
            [1999, 4944, 18, 18],
            [1999, 4946, 120, 90],
            [1999, 4949, 50, 60],
            [1999, 4950, 70.53, 51.44],
            [1999, 4951, 66.71, 36.01],
            [1999, 4953, 120, 90],
            [1999, 4954, 104, 179],
            [1999, 4955, 25.46, 23.67],
            [1999, 4956, 70, 70],
            [1999, 4957, 64.8, 59.23],
            [1999, 4958, 120, 90],
            [1999, 4960, 101.39, 50.61],
            [1999, 4962, 70, 70],
            [1999, 4963, 50, 66],
            [1999, 4964, 7.37, 6.44],
            [1999, 4965, 42.65, 79.28],
            [1999, 4966, 70, 70],
            [1999, 4968, 120, 90],
            [1999, 4971, 70, 70],
            [1999, 4972, 120, 90],
            [1999, 4973, 34.33, 57.8],
            [1999, 4974, 50, 60],
            [1999, 4975, 49.84, 42.61],
            [1999, 4976, 12, 22.97],
            [1999, 4977, 120, 90],
            [1999, 4978, 120, 90],
            [1999, 4979, 56.77, 40.85],
            [1999, 4981, 50, 60],
            [1999, 4983, 29.76, 20.92],
            [1999, 4984, 20, 13.27],
            [1999, 4985, 6.45, 5.95],
            [1999, 4987, 55.01, 32.18],
            [1999, 4988, 84, 107],
            [1999, 4989, 120, 90],
            [1999, 4990, 106.41, 53.31],
            [1999, 4992, 45.11, 33.84],
            [1999, 4994, 120, 90],
            [1999, 4995, 23.94, 28.78],
            [1999, 4996, 16.69, 30.91],
            [1999, 4997, 78.17, 40.51],
            [1999, 4998, 49.03, 43.06],
            [1999, 5000, 13.36, 12.29],
            [1999, 5001, 70, 70],
            [1999, 5002, 120, 90],
            [1999, 5003, 120, 90],
            [1999, 5005, 18.06, 19.95],
            [1999, 5006, 112, 90],
            [1999, 5007, 120, 90],
            [1999, 5008, 126.38, 53.28],
            [1999, 5009, 18.59, 27.74],
            [1999, 5010, 8.39, 5.61],
            [1999, 5011, 15.78, 16.19],
            [1999, 5012, 39.94, 45.98],
            [1999, 5013, 46.69, 34.25],
            [1999, 5014, 61.9, 35.6],
            [1999, 5017, 9.26, 20.62],
            [1999, 5019, 70, 45.82],
            [1999, 5020, 32.11, 40.08],
            [1999, 5022, 137.19, 88.29],
            [1999, 5023, 70, 70],
            [1999, 5025, 120, 90],
            [1999, 5026, 120, 90],
            [1999, 5027, 32.18, 30.47],
            [1999, 5031, 12, 18],
            [1999, 5032, 26.02, 40.08],
            [1999, 5033, 73.53, 35.42],
            [1999, 5035, 32.19, 33.94],
            [1999, 5037, 91.49, 46.75],
            [1999, 5038, 18, 27],
            [1999, 5041, 70, 70],
            [1999, 5043, 50, 60],
            [1999, 5044, 70, 70],
            [1999, 5046, 29.35, 32.47],
            [1999, 5048, 17.82, 19.75],
            [1999, 5049, 120, 90],
            [1999, 5050, 20.33, 12.35],
            [1999, 5051, 12, 18],
            [1999, 5053, 77.54, 45.07],
            [1999, 5054, 45.4, 28.5],
            [1999, 5056, 120, 90],
            [1999, 5057, 120, 90],
            [1999, 5058, 48.62, 42.89],
            [1999, 5060, 120, 90],
            [1999, 5061, 120, 90],
            [1999, 5062, 67.65, 70],
            [1999, 5063, 20.35, 50],
            [1999, 5064, 20.75, 20.03],
            [1999, 5065, 100.18, 69.74],
            [1999, 5066, 120, 90],
            [1999, 5068, 164.36, 62.76],
            [1999, 5069, 149.63, 54.69],
            [1999, 5070, 15.65, 30],
            [1999, 5071, 33.7, 31.78],
            [1999, 5072, 120, 90],
            [1999, 5073, 50, 60],
            [1999, 5075, 21.04, 24.86],
            [1999, 5077, 40, 50],
            [1999, 5079, 61.44, 42.57],
            [1999, 5081, 120, 90],
            [1999, 5082, 9.69, 9.33],
            [1999, 5083, 5.36, 5.53],
            [1999, 5084, 50, 60],
            [1999, 5085, 41.13, 26.96],
            [1999, 5091, 40.5, 33.65],
            [1999, 5092, 12, 18],
            [1999, 5093, 50, 60],
            [1999, 5094, 36.74, 43],
            [1999, 5095, 13.3, 17.3],
            [1999, 5097, 120, 90],
            [1999, 5098, 47.1, 29.63],
            [1999, 5099, 58.83, 35.89],
            [1999, 5100, 120, 90],
            [1999, 5101, 5.93, 6.13],
            [1999, 5102, 35.03, 31.53],
            [1999, 5103, 89.21, 43],
            [1999, 5104, 120, 90],
            [1999, 5107, 70, 65],
            [1999, 5108, 25, 40],
            [1999, 5109, 93.01, 45.96],
            [1999, 5111, 120, 90],
            [1999, 5114, 4.87, 4],
            [1999, 5115, 12.26, 31.18],
            [1999, 5116, 22.23, 21.49],
            [1999, 5117, 40, 50],
            [1999, 5119, 120, 90],
            [1999, 5121, 30.65, 46.26],
            [1999, 5122, 21.51, 31.21],
            [1999, 5123, 11.8, 11.02],
            [1999, 5124, 56.09, 43.95],
            [1999, 5126, 26.81, 24.11],
            [1999, 5127, 32.57, 20.36],
            [1999, 5128, 70, 70],
            [1999, 5130, 50, 60],
            [1999, 5132, 120, 90],
            [1999, 5135, 68.8, 41.77],
            [1999, 5136, 10.18, 8.06],
            [1999, 5137, 120, 90],
            [1999, 5138, 15.14, 13.83],
            [1999, 5141, 24.58, 21.45],
            [1999, 5143, 70, 70],
            [1999, 5145, 120, 90],
            [1999, 5149, 120, 90],
            [1999, 5150, 52.83, 33.37],
            [1999, 5153, 179.52, 59.91],
            [1999, 5154, 96, 141],
            [1999, 5155, 70, 70],
            [1999, 5156, 40, 50],
            [1999, 5157, 50, 60],
            [1999, 5159, 52.86, 48.43],
            [1999, 5160, 120, 90],
            [1999, 5161, 17.42, 15.54],
            [1999, 5162, 65.6, 46.34],
            [1999, 5163, 120, 90],
            [1999, 5164, 120, 90],
            [1999, 5165, 3.38, 5.47],
            [1999, 5166, 33.73, 21.58],
            [1999, 5167, 179, 220],
            [1999, 5169, 56.5, 44.9],
            [1999, 5171, 249.75, 64.69],
            [1999, 5172, 70, 70],
            [1999, 5173, 46.38, 41.15],
            [1999, 5174, 143.07, 72.47],
            [1999, 5178, 120, 90],
            [1999, 5180, 86.39, 54.81],
            [1999, 5181, 120, 90],
            [1999, 5182, 16.01, 20.04],
            [1999, 5183, 30.09, 35.52],
            [1999, 5184, 120, 90],
            [1999, 5185, 70, 70],
            [1999, 5186, 12, 18],
            [1999, 5187, 12, 18],
            [1999, 5188, 12, 18],
            [1999, 5189, 32, 40],
            [1999, 5191, 50, 25],
            [1999, 5192, 15, 25],
            [1999, 5193, 15, 25],
            [1999, 5194, 15, 25],
            [1999, 5195, 15, 25],
            [1999, 5196, 15, 25],
            [1999, 5197, 15, 25],
            [1999, 5198, 15, 25],
            [1999, 5199, 15, 25],
            [1999, 5200, 15, 25],
            [1999, 5201, 15, 25],
            [1999, 5202, 15, 25],
            [1999, 5203, 15, 25],
            [1999, 5204, 40, 50],
            [1999, 5205, 15, 25],
            [1999, 5206, 15, 25],
            [1999, 5207, 15, 25],
            [1999, 5208, 15, 25],
            [1999, 5209, 15, 25],
            [1999, 5210, 15, 25],
            [1999, 5211, 15, 25],
            [1999, 5212, 15, 25],
            [1999, 5213, 15, 25],
            [1999, 5214, 15, 25],
            [1999, 5215, 15, 25],
            [1999, 5216, 15, 25],
            [1999, 5217, 70, 70],
            [1999, 5218, 50, 60],
            [1999, 5219, 20.7, 31.7],
            [1999, 5220, 12.6, 25.3],
            [1999, 5221, 14.8, 27.6],
            [1999, 5222, 23, 18.2],
            [1999, 5223, 10.5, 15.3],
            [1999, 5224, 16.8, 30.5],
            [1999, 5225, 21.5, 24.2],
            [1999, 5226, 8.5, 20.2],
            [1999, 5227, 55.9, 46.8],
            [1999, 5228, 18.7, 32.7],
            [1999, 5229, 7, 15.8],
            [1999, 5230, 15.5, 13.1],
            [1999, 5231, 15.2, 18.9],
            [1999, 5232, 26.7, 34.4],
            [1999, 5233, 22.9, 36.3],
            [1999, 5234, 10.9, 17.5],
            [1999, 5235, 43.7, 39.9],
            [1999, 5236, 15.6, 18.9],
            [1999, 5237, 27.3, 31.4],
            [1999, 5238, 23.1, 25.3],
            [1999, 5239, 23.3, 28.2],
            [1999, 5240, 17, 31.3],
            [1999, 5241, 26.1, 21.4],
            [1999, 5242, 25.2, 23.2],
            [1999, 5243, 28.2, 26.9],
            [1999, 5244, 20.5, 30],
            [1999, 5245, 21.3, 30],
            [1999, 5247, 80, 60],
            [1999, 5248, 80, 60],
            [1999, 5249, 18.79, 11.59],
            [1999, 5250, 20.93, 10.99],
            [1999, 5251, 9.51, 7.03],
            [1999, 5252, 30, 16.56],
            [1999, 5253, 10.32, 10.66],
            [1999, 5254, 24.49, 16.32],
            [1999, 5255, 22.02, 14.56],
            [1999, 5256, 24.56, 17.38],
            [1999, 5257, 15.4, 13.96],
            [1999, 5258, 22.79, 18.26],
            [1999, 5259, 10.2, 9.75],
            [1999, 5260, 14.4, 8.76],
            [1999, 5261, 24.99, 12.73],
            [1999, 5263, 19.45, 15.67],
            [1999, 5264, 70, 38.11],
            [1999, 5265, 7.43, 6.83],
            [1999, 5266, 23.79, 12.6],
            [1999, 5267, 21.83, 11.15],
            [1999, 5268, 15.77, 12.82],
            [1999, 5269, 14.5, 9.26],
            [1999, 5270, 13.02, 16.2],
            [1999, 5271, 70, 70],
            [1999, 5272, 49.88, 21.16],
            [1999, 5273, 27.17, 19.34],
            [1999, 5274, 21.56, 23.35],
            [1999, 5275, 21.89, 20.99],
            [1999, 5276, 33.57, 69.59],
            [1999, 5277, 33.53, 44.16],
            [1999, 5278, 17.61, 19.46],
            [1999, 5279, 22.19, 26.31],
            [1999, 5280, 54.9, 42.95],
            [1999, 5281, 23.97, 21.11],
            [1999, 5282, 18.86, 21.15],
            [1999, 5283, 14.72, 24.85],
            [1999, 5284, 19.82, 21.97],
            [1999, 5285, 12.98, 10.05],
            [1999, 5286, 21.47, 25.37],
            [1999, 5287, 12.95, 13.1],
            [1999, 5288, 15.79, 13.5],
            [1999, 5289, 14.72, 18.53],
            [1999, 5290, 23.09, 21.92],
            [1999, 5291, 13.74, 15.42],
            [1999, 5292, 27.71, 17.72],
            [1999, 5293, 31.42, 28.8],
            [1999, 5294, 27.26, 35.13],
            [1999, 5295, 17.19, 14.3],
            [1999, 5296, 37.77, 51.52],
            [1999, 5297, 36.44, 42.37],
            [1999, 5298, 13.26, 13.27],
            [1999, 5299, 18.16, 20.87],
            [1999, 5300, 19.04, 16.88],
            [1999, 5301, 42.73, 37.25],
            [1999, 5302, 9.07, 5.65],
            [1999, 5303, 36.15, 21.1],
            [1999, 5304, 19.35, 28.15],
            [1999, 5305, 28.21, 24.21],
            [1999, 5306, 30.08, 35.59],
            [1999, 5307, 28.82, 42.89],
            [1999, 5308, 30.68, 46.96],
            [1999, 5309, 22.98, 21.99],
            [1999, 5310, 18.38, 19.26],
            [1999, 5311, 14.95, 17.32],
            [1999, 5312, 24.78, 19.47],
            [1999, 5313, 14.05, 18.92],
            [1999, 5314, 22.31, 24.96],
            [1999, 5315, 19.95, 27.16],
            [1999, 5316, 34.5, 42.49],
            [1999, 5317, 47.68, 75.34],
            [1999, 5318, 30.3, 21.67],
            [1999, 5319, 13.84, 14.27],
            [1999, 5320, 53.44, 55.56],
            [1999, 5321, 21.43, 22.1],
            [1999, 5322, 21.86, 31.16],
            [1999, 5323, 13.54, 22.48],
            [1999, 5324, 28.56, 35.07],
            [1999, 5325, 16.07, 19.54],
            [1999, 5326, 34.56, 41.14],
            [1999, 5327, 16.58, 21.05],
            [1999, 5328, 21.03, 21.33],
            [1999, 5329, 17.44, 17.44],
            [1999, 5330, 28.89, 22.93],
            [1999, 5331, 20.27, 21.28],
            [1999, 5332, 24.04, 29.18],
            [1999, 5333, 13.04, 16.32],
            [1999, 5334, 14.81, 13.78],
            [1999, 5335, 19.89, 15.44],
            [1999, 5336, 16.38, 19.14],
            [1999, 5337, 17.09, 17.7],
            [1999, 5338, 33.77, 26.64],
            [1999, 5339, 21.48, 24.94],
            [1999, 5340, 31.28, 38.93],
            [1999, 5341, 21.6, 30.78],
            [1999, 5342, 67.33, 44.59],
            [1999, 5343, 16.6, 14.81],
            [1999, 5344, 47.23, 50.54],
            [1999, 5345, 17.36, 20.76],
            [1999, 5346, 12.53, 15.06],
            [1999, 5347, 20.45, 23.78],
            [1999, 5348, 18.99, 19.54],
            [1999, 5349, 23.6, 27.71],
            [1999, 5350, 17.87, 30.23],
            [1999, 5351, 25.6, 34.49],
            [1999, 5352, 12.65, 19.75],
            [1999, 5353, 20.64, 26.6],
            [1999, 5354, 15.47, 9.25],
            [1999, 5355, 24.3, 42.86],
            [1999, 5356, 15.64, 19.61],
            [1999, 5357, 30.99, 21.01],
            [1999, 5358, 18.44, 20.69],
            [1999, 5359, 17.32, 25.16],
            [1999, 5360, 14.69, 9.66],
            [1999, 5361, 25.44, 28.51],
            [1999, 5362, 22.78, 37.54],
            [1999, 5363, 17.15, 20.75],
            [1999, 5364, 27.13, 35.08],
            [1999, 5365, 14.15, 16.33],
            [1999, 5366, 31.71, 24.96],
            [1999, 5367, 18.39, 19.03],
            [1999, 5368, 25.49, 33.82],
            [1999, 5369, 17.87, 17.73],
            [1999, 5370, 26.37, 19.9],
            [1999, 5371, 34.48, 40.39],
            [1999, 5372, 23.31, 23.21],
            [1999, 5373, 39.81, 52.34],
            [1999, 5374, 38.4, 30.66],
            [1999, 5375, 20.13, 18.67],
            [1999, 5376, 39.93, 36.29],
            [1999, 5377, 17.78, 19.64],
            [1999, 5378, 44.16, 54.79],
            [1999, 5379, 17.59, 16],
            [1999, 5380, 19.5, 24.07],
            [1999, 5381, 24.54, 27.3],
            [1999, 5382, 27.26, 39.02],
            [1999, 5383, 24.98, 28.96],
            [1999, 5384, 32.06, 28.26],
            [1999, 5385, 35.75, 25.11],
            [1999, 5386, 12.39, 14.93],
            [1999, 5387, 16.52, 16.08],
            [1999, 5388, 28.27, 31.03],
            [1999, 5389, 21.28, 32.3],
            [1999, 5390, 27.81, 21.8],
            [1999, 5391, 15.92, 17.92],
            [1999, 5392, 18.92, 29.5],
            [1999, 5393, 21.42, 30.33],
            [1999, 5394, 25.56, 27.95],
            [1999, 5395, 15.36, 21.7],
            [1999, 5396, 24.37, 24.45],
            [1999, 5397, 37.72, 55.15],
            [1999, 5398, 22.54, 21.56],
            [1999, 5399, 30.96, 24.28],
            [1999, 5400, 13.97, 12.67],
            [1999, 5401, 27.87, 36.25],
            [1999, 5402, 25.63, 36.95],
            [1999, 5403, 24.28, 25.06],
            [1999, 5404, 24.46, 24.68],
            [1999, 5405, 17.96, 16.23],
            [1999, 5406, 26.71, 28.04],
            [1999, 5407, 20.69, 24.62],
            [1999, 5408, 18.11, 22.5],
            [1999, 5409, 31.73, 36.57],
            [1999, 5410, 58.51, 46.49],
            [1999, 5411, 27.68, 21.48],
            [1999, 5412, 23.04, 18.15],
            [1999, 5413, 23.32, 18.19],
            [1999, 5414, 9.91, 15.09],
            [1999, 5415, 51.57, 56.26],
            [1999, 5416, 12.77, 13.87],
            [1999, 5417, 23.61, 19.35],
            [1999, 5418, 28.79, 36.91],
            [1999, 5419, 27.19, 25.1],
            [1999, 5420, 16.27, 16.14],
            [1999, 5421, 18.76, 15.11],
            [1999, 5422, 25.14, 34.37],
            [1999, 5423, 35.81, 32.77],
            [1999, 5424, 17.07, 19.91],
            [1999, 5425, 16.63, 19.74],
            [1999, 5426, 22.35, 32.83],
            [1999, 5427, 30.13, 36.75],
            [1999, 5428, 18.88, 25.12],
            [1999, 5429, 14.33, 16.18],
            [1999, 5430, 35.21, 32.17],
            [1999, 5431, 21.98, 23.51],
            [1999, 5432, 22.49, 30.65],
            [1999, 5433, 22.03, 25.8],
            [1999, 5434, 15.65, 16.63],
            [1999, 5435, 28.65, 36.45],
            [1999, 5436, 22.2, 26.91],
            [1999, 5437, 28.46, 24.42],
            [1999, 5438, 26.15, 45.07],
            [1999, 5439, 23.1, 32.12],
            [1999, 5440, 42.61, 31.07],
            [1999, 5441, 31.6, 43.27],
            [1999, 5442, 27.28, 31.24],
            [1999, 5443, 27.08, 44.53],
            [1999, 5444, 21.92, 35.18],
            [1999, 5445, 16.8, 20.91],
            [1999, 5446, 28.06, 29.76],
            [1999, 5447, 20.25, 23.23],
            [1999, 5448, 18.61, 19.97],
            [1999, 5449, 26.78, 33.16],
            [1999, 5450, 28.76, 31.21],
            [1999, 5451, 36.55, 47.48],
            [1999, 5452, 22.51, 34.53],
            [1999, 5453, 28.94, 32.53],
            [1999, 5454, 12.32, 16.18],
            [1999, 5455, 28.32, 21.25],
            [1999, 5456, 21.35, 24.85],
            [1999, 5457, 16.87, 25.48],
            [1999, 5458, 18.67, 22.48],
            [1999, 5459, 25.03, 25.93],
            [1999, 5460, 15.43, 17.97],
            [1999, 5461, 18.92, 17.99],
            [1999, 5462, 22.52, 26.38],
            [1999, 5463, 14.28, 17.95],
            [1999, 5464, 18.6, 18.27],
            [1999, 5465, 23.82, 23.85],
            [1999, 5466, 18.5, 23.11],
            [1999, 5467, 21.73, 26.16],
            [1999, 5468, 48, 73.78],
            [1999, 5469, 28.95, 22.5],
            [1999, 5470, 18.2, 26.19],
            [1999, 5471, 21.88, 24.32],
            [1999, 5472, 24.34, 29.62],
            [1999, 5473, 18.21, 24.01],
            [1999, 5474, 15.15, 14.65],
            [1999, 5475, 19.39, 18.75],
            [1999, 5476, 15.52, 20.64],
            [1999, 5477, 11.66, 13.63],
            [1999, 5478, 18.69, 21.99],
            [1999, 5479, 20.66, 18.21],
            [1999, 5480, 38.45, 32.17],
            [1999, 5481, 15.98, 18.15],
            [1999, 5482, 17.06, 18.76],
            [1999, 5483, 25.35, 27.15],
            [1999, 5484, 22.09, 21.1],
            [1999, 5485, 22.02, 23.57],
            [1999, 5486, 22.14, 21.65],
            [1999, 5487, 17.97, 21.38],
            [1999, 5488, 24.02, 25.06],
            [1999, 5489, 34.19, 66.05],
            [1999, 5490, 28.94, 32.56],
            [1999, 5491, 15.88, 20.08],
            [1999, 5492, 22.58, 38.47],
            [1999, 5493, 27.68, 21.75],
            [1999, 5494, 25.82, 30.23],
            [1999, 5495, 33.94, 27.03],
            [1999, 5496, 74.87, 78.15],
            [1999, 5497, 18.35, 22.55],
            [1999, 5498, 27.02, 39.89],
            [1999, 5499, 33.57, 24.3],
            [1999, 5500, 22.47, 23.4],
            [1999, 5501, 27.13, 46.22],
            [1999, 5502, 29.4, 31.24],
            [1999, 5503, 25.48, 24.22],
            [1999, 5504, 29.82, 41.45],
            [1999, 5505, 19.44, 30.38],
            [1999, 5506, 19.55, 18.02],
            [1999, 5507, 8.92, 15.03],
            [1999, 5508, 25.07, 35.23],
            [1999, 5509, 25.6, 36.32],
            [1999, 5510, 23.88, 39.9],
            [1999, 5511, 27.52, 24.5],
            [1999, 5512, 11.13, 11.46],
            [1999, 5513, 20.91, 23.63],
            [1999, 5514, 17.98, 18.09],
            [1999, 5515, 38.99, 31.52],
            [1999, 5516, 24.35, 34.55],
            [1999, 5517, 22.32, 28.37],
            [1999, 5518, 19.91, 18.99],
            [1999, 5519, 31.61, 40.04],
            [1999, 5520, 22.33, 22.91],
            [1999, 5521, 33.45, 39.31],
            [1999, 5522, 20.71, 22.53],
            [1999, 5523, 26.18, 29.99],
            [1999, 5524, 21.48, 50.1],
            [1999, 5525, 22.24, 21.41],
            [1999, 5526, 32.51, 26.74],
            [1999, 5527, 30.84, 34.66],
            [1999, 5528, 20.96, 19.72],
            [1999, 5529, 59.13, 37.8],
            [1999, 5530, 19.55, 21.33],
            [1999, 5531, 24.12, 22.95],
            [1999, 5532, 25.42, 24.65],
            [1999, 5533, 14.52, 14.84],
            [1999, 5534, 17.4, 14.87],
            [1999, 5535, 15.5, 12.89],
            [1999, 5536, 2, 2],
            [1999, 5537, 12.2, 8.94],
            [1999, 5538, 37.26, 35.28],
            [1999, 5539, 14.86, 20],
            [1999, 5540, 23.95, 34.62],
            [1999, 5541, 26.12, 21.77],
            [1999, 5542, 12.8, 16.15],
            [1999, 5543, 12.26, 16.58],
            [1999, 5544, 22.77, 32.88],
            [1999, 5545, 16.25, 22.22],
            [1999, 5546, 34.03, 40.31],
            [1999, 5547, 26.1, 25.13],
            [1999, 5548, 38.2, 46.39],
            [1999, 5549, 16.23, 22.79],
            [1999, 5550, 16.66, 17.46],
            [1999, 5551, 47.85, 75.99],
            [1999, 5552, 28.07, 25.33],
            [1999, 5553, 31.7, 29.24],
            [1999, 5554, 26.98, 30.18],
            [1999, 5555, 32.21, 32.76],
            [1999, 5556, 17.16, 17.29],
            [1999, 5557, 15.34, 14.19],
            [1999, 5558, 14.56, 19.66],
            [1999, 5559, 30.04, 31.58],
            [1999, 5560, 74.52, 28.37],
            [1999, 5561, 38.69, 49.15],
            [1999, 5562, 40.29, 56.03],
            [1999, 5563, 33.52, 34.96],
            [1999, 5564, 88.05, 56.53],
            [1999, 5565, 19.45, 18.12],
            [1999, 5566, 24.67, 27.3],
            [1999, 5567, 28.59, 35.72],
            [1999, 5568, 26.89, 35.03],
            [1999, 5569, 51.02, 38.85],
            [1999, 5570, 37.26, 27.17],
            [1999, 5571, 28.9, 21.65],
            [1999, 5572, 20.43, 17.7],
            [1999, 5573, 42.96, 28.46],
            [1999, 5600, 70, 129],
            [1999, 5627, 55, 125],
            [1999, 5632, 50, 70],
            [1999, 5636, 52, 60],
            [1999, 5638, 163, 120],
            [1999, 5646, 120, 104],
            [1999, 5648, 65, 172],
            [1999, 5649, 102, 108],
            [1999, 5659, 5.35, 4.7],
            [1999, 5660, 7.67, 7.45],
            [1999, 5661, 70, 70],
            [1999, 5663, 120, 90],
            [1999, 5666, 120, 90],
            [1999, 5672, 70, 70],
            [1999, 5675, 40, 50],
            [1999, 5677, 120, 90],
            [1999, 5681, 70, 70],
            [1999, 5683, 120, 90],
            [1999, 5689, 120, 90],
            [1999, 5706, 120, 90],
            [1999, 5715, 70, 70],
            [1999, 5717, 120, 90],
            [1999, 5720, 70, 70],
            [1999, 5726, 120, 90],
            [1999, 5728, 120, 90],
            [1999, 5737, 120, 90],
            [1999, 5738, 120, 90],
            [1999, 5745, 70, 70],
            [1999, 5747, 120, 90],
            [1999, 5757, 40, 50],
            [1999, 5758, 70, 70],
            [1999, 5764, 50, 60],
            [1999, 5768, 70, 70],
            [1999, 5777, 120, 90],
            [1999, 5789, 40, 50],
            [1999, 5805, 120, 90],
            [1999, 5808, 70, 70],
            [1999, 5811, 120, 90],
            [1999, 5819, 120, 90],
            [1999, 5824, 70, 70],
            [1999, 5830, 70, 70],
            [1999, 5833, 120, 90],
            [1999, 5840, 120, 90],
            [1999, 5841, 120, 90],
            [1999, 5846, 120, 90],
            [1999, 5848, 120, 90],
            [1999, 5851, 120, 90],
            [1999, 5855, 50, 60],
            [1999, 5856, 40, 50],
            [1999, 5861, 120, 90],
            [1999, 5869, 120, 90],
            [1999, 5876, 120, 90],
            [1999, 5877, 120, 90],
            [1999, 5880, 50, 60],
            [1999, 5881, 40, 50],
            [1999, 5882, 50, 60],
            [1999, 5884, 120, 90],
            [1999, 5889, 70, 70],
            [1999, 5898, 120, 90],
            [1999, 5903, 70, 70],
            [1999, 5911, 120, 90],
            [1999, 5917, 120, 90],
            [1999, 5918, 120, 90],
            [1999, 5919, 70, 70],
            [1999, 5931, 70, 70],
            [1999, 5933, 40, 50],
            [1999, 5936, 70, 70],
            [1999, 5939, 120, 90],
            [1999, 5941, 120, 90],
            [1999, 5942, 120, 90],
            [1999, 5943, 120, 90],
            [1999, 5944, 40, 50],
            [1999, 5945, 40, 50],
            [1999, 5946, 40, 50],
            [1999, 5947, 120, 90],
            [1999, 5948, 120, 90],
            [1999, 5949, 120, 90],
            [1999, 5950, 120, 90],
            [1999, 5951, 120, 90],
            [1999, 5953, 120, 90],
            [1999, 5954, 120, 90],
            [1999, 5955, 120, 90],
            [1999, 5956, 120, 90],
            [1999, 5957, 120, 90],
            [1999, 5958, 40, 50],
            [1999, 5959, 40, 50],
            [1999, 5961, 40, 50],
            [1999, 5962, 50, 60],
            [1999, 5970, 163, 136],
            [1999, 5985, 15, 25],
            [1999, 5986, 50, 60],
            [1999, 5987, 15, 25],
            [1999, 5988, 21, 33],
            [1999, 5989, 50, 60],
            [1999, 5990, 50, 60],
            [1999, 5991, 50, 60],
            [1999, 5992, 50, 60],
            [1999, 5993, 50, 60],
            [1999, 5994, 40, 50],
            [1999, 5995, 70, 70],
            [1999, 5996, 70, 70],
            [1999, 5997, 70, 70],
            [1999, 5998, 120, 90],
            [1999, 5999, 50, 60],
            [1999, 6049, 70, 70],
            [1999, 6050, 70, 70],
            [1999, 6051, 70, 70],
            [1999, 6052, 120, 90],
            [1999, 6053, 120, 90],
            [1999, 6054, 120, 90],
            [1999, 6055, 52.5, 52.5],
            [1999, 6066, 37.5, 45],
            [1999, 6067, 15, 25],
            [1999, 6068, 120, 90],
            [1999, 6069, 70, 70],
            [1999, 6070, 70, 70],
            [1999, 6071, 70, 70],
            [1999, 6072, 40, 50],
            [1999, 6073, 70, 70],
            [1999, 6074, 70, 70],
            [1999, 6075, 70, 70],
            [1999, 6076, 50, 60],
            [1999, 6077, 70, 70],
            [1999, 6078, 50, 60],
            [1999, 6079, 70, 70],
            [1999, 6080, 50, 60],
            [1999, 6081, 50, 60],
            [1999, 6082, 70, 70],
            [1999, 6083, 70, 70],
            [1999, 6084, 120, 90],
            [1999, 6085, 120, 90],
            [1999, 6086, 50, 60],
            [1999, 6087, 70, 70],
            [1999, 6088, 70, 70],
            [1999, 6089, 70, 70],
            [1999, 6090, 120, 90],
            [1999, 6091, 70, 70],
            [1999, 6092, 70, 70],
            [1999, 6093, 70, 70],
            [1999, 6094, 70, 70],
            [1999, 6095, 50, 60],
            [1999, 6096, 70, 70],
            [1999, 6097, 70, 70],
            [1999, 6098, 70, 70],
            [1999, 6099, 120, 90],
            [1999, 6100, 70, 70],
            [1999, 6101, 70, 70],
            [1999, 6102, 50, 60],
            [1999, 6103, 70, 70],
            [1999, 6104, 120, 90],
            [1999, 6105, 120, 90],
            [1999, 6106, 70, 70],
            [1999, 6107, 70, 70],
            [1999, 6108, 70, 70],
            [1999, 6109, 50, 60],
            [1999, 6110, 70, 70],
            [1999, 6111, 30, 45],
            [1999, 6112, 70, 70],
            [1999, 6113, 70, 70],
            [1999, 6114, 50, 60],
            [1999, 6115, 50, 60],
            [1999, 6116, 70, 70],
            [1999, 6117, 70, 70],
            [1999, 6118, 70, 70],
            [1999, 6119, 70, 70],
            [1999, 6120, 40, 50],
            [1999, 6121, 70, 70],
            [1999, 6122, 70, 70],
            [1999, 6123, 70, 70],
            [1999, 6124, 70, 70],
            [1999, 6125, 70, 70],
            [1999, 6126, 70, 70],
            [1999, 6127, 70, 70],
            [1999, 6128, 70, 70],
            [1999, 6129, 40, 50],
            [1999, 6130, 70, 70],
            [1999, 6131, 70, 70],
            [1999, 6132, 70, 70],
            [1999, 6133, 70, 70],
            [1999, 6134, 70, 70],
            [1999, 6135, 70, 70],
            [1999, 6136, 70, 70],
            [1999, 6137, 40, 50],
            [1999, 6138, 50, 60],
            [1999, 6139, 70, 70],
            [1999, 6140, 40, 50],
            [1999, 6141, 50, 60],
            [1999, 6142, 50, 60],
            [1999, 6143, 70, 70],
            [1999, 6144, 70, 70],
            [1999, 6145, 70, 70],
            [1999, 6146, 30, 45],
            [1999, 6147, 40, 50],
            [1999, 6148, 40, 50],
            [1999, 6149, 70, 70],
            [1999, 6150, 40, 50],
            [1999, 6151, 70, 70],
            [1999, 6152, 40, 50],
            [1999, 6153, 40, 50],
            [1999, 6154, 70, 70],
            [1999, 6155, 40, 50],
            [1999, 6156, 50, 60],
            [1999, 6157, 50, 60],
            [1999, 6158, 50, 60],
            [1999, 6159, 70, 70],
            [1999, 6160, 70, 70],
            [1999, 6161, 40, 50],
            [1999, 6162, 50, 60],
            [1999, 6163, 50, 60],
            [1999, 6164, 70, 70],
            [1999, 6165, 50, 60],
            [1999, 6166, 50, 60],
            [1999, 6167, 70, 70],
            [1999, 6168, 30, 45],
            [1999, 6169, 30, 45],
            [1999, 6170, 30, 45],
            [1999, 6227, 120, 90],
            [1999, 6228, 15, 25],
            [1999, 6229, 15, 25],
            [1999, 6230, 50, 60],
            [1999, 6231, 50, 60],
            [1999, 6232, 50, 60],
            [1999, 6233, 70, 70],
            [1999, 6234, 50, 60],
            [1999, 6235, 50, 60],
            [1999, 6236, 50, 60],
            [1999, 6238, 70, 70],
            [1999, 6239, 50, 60],
            [1999, 6240, 50, 60],
            [1999, 6241, 50, 60],
            [1999, 6242, 50, 60],
            [1999, 6243, 70, 70],
            [1999, 6244, 70, 70],
            [1999, 6245, 50, 60],
            [1999, 6246, 70, 70],
            [1999, 6247, 50, 60],
            [1999, 6248, 30, 45],
            [1999, 6252, 50, 60],
            [1999, 6253, 120, 90],
            [1999, 6255, 70, 70],
            [1999, 6256, 50, 60],
            [1999, 6258, 50, 60],
            [1999, 6259, 120, 90],
            [1999, 6260, 120, 90],
            [1999, 6261, 70, 70],
            [1999, 6262, 70, 70],
            [1999, 6263, 120, 90],
            [1999, 6264, 70, 70],
            [1999, 6265, 70, 70],
            [1999, 6266, 50, 60],
            [1999, 6267, 50, 60],
            [1999, 6268, 70, 70],
            [1999, 6269, 50, 60],
            [1999, 6270, 50, 60],
            [1999, 6271, 70, 70],
            [1999, 6272, 40, 50],
            [1999, 6274, 70, 70],
            [1999, 6275, 70, 70],
            [1999, 6276, 50, 60],
            [1999, 6277, 120, 90],
            [1999, 6278, 70, 70],
            [1999, 6279, 70, 70],
            [1999, 6280, 70, 70],
            [1999, 6281, 70, 70],
            [1999, 6282, 50, 60],
            [1999, 6283, 70, 70],
            [1999, 6284, 50, 60],
            [1999, 6286, 70, 70],
            [1999, 6287, 50, 60],
            [1999, 6288, 70, 70],
            [1999, 6289, 50, 60],
            [1999, 6290, 120, 90],
            [1999, 6292, 70, 70],
            [1999, 6293, 70, 70],
            [1999, 6294, 120, 90],
            [1999, 6295, 120, 90],
            [1999, 6296, 70, 70],
            [1999, 6297, 120, 90],
            [1999, 6299, 70, 70],
            [1999, 6300, 70, 70],
            [1999, 6301, 70, 70],
            [1999, 6302, 70, 70],
            [1999, 6303, 70, 70],
            [1999, 6305, 120, 90],
            [1999, 6306, 70, 70],
            [1999, 6307, 120, 90],
            [1999, 6308, 120, 90],
            [1999, 6309, 70, 70],
            [1999, 6310, 50, 60],
            [1999, 6312, 120, 90],
            [1999, 6313, 70, 70],
            [1999, 6314, 120, 90],
            [1999, 6315, 70, 70],
            [1999, 6316, 70, 70],
            [1999, 6317, 70, 70],
            [1999, 6319, 50, 60],
            [1999, 6320, 70, 70],
            [1999, 6321, 70, 70],
            [1999, 6323, 50, 60],
            [1999, 6324, 50, 60],
            [1999, 6325, 120, 90],
            [1999, 6326, 70, 70],
            [1999, 6327, 50, 60],
            [1999, 6328, 120, 90],
            [1999, 6330, 120, 90],
            [1999, 6334, 27.92, 22.8],
            [1999, 6335, 36.36, 27.35],
            [1999, 6336, 50, 35.7],
            [1999, 6337, 28.8, 13.04],
            [1999, 6338, 50, 33.77],
            [1999, 6339, 20.96, 16.45],
            [1999, 6340, 50, 36.94],
            [1999, 6341, 40, 23.08],
            [1999, 6342, 23.49, 10.98],
            [1999, 6343, 22.07, 18.41],
            [1999, 6344, 19.93, 9.57],
            [1999, 6345, 50, 21.26],
            [1999, 6346, 40, 25.58],
            [1999, 6347, 30.77, 13.81],
            [1999, 6348, 28.74, 14.96],
            [1999, 6349, 26.83, 18.14],
            [1999, 6350, 30.1, 29.64],
            [1999, 6351, 37.29, 18.38],
            [1999, 6353, 40, 50],
            [1999, 6354, 40, 50],
            [1999, 6355, 30, 45],
            [1999, 6356, 40, 50],
            [1999, 6357, 40, 50],
            [1999, 6358, 40, 50],
            [1999, 6359, 28.08, 27.32],
            [1999, 6360, 120, 109.36],
            [1999, 6361, 120, 90],
            [1999, 6362, 115.35, 155.44],
            [1999, 6363, 63.74, 113.55],
            [1999, 6364, 120, 108.36],
            [1999, 6365, 120, 90],
            [1999, 6366, 152, 95.28],
            [1999, 6367, 70, 70],
            [1999, 6368, 120, 119.04],
            [1999, 6369, 68.6, 48.47],
            [1999, 6370, 120, 90],
            [1999, 6371, 120, 130.57],
            [1999, 6372, 120, 90],
            [1999, 6373, 120, 90],
            [1999, 6374, 120, 64.08],
            [1999, 6375, 120, 90],
            [1999, 6376, 70, 70],
            [1999, 6377, 120, 90],
            [1999, 6378, 70, 70],
            [1999, 6379, 120, 78.19],
            [1999, 6380, 70, 91.63],
            [1999, 6381, 70, 70],
            [1999, 6382, 120, 108.36],
            [1999, 6383, 70, 70],
            [1999, 6384, 120, 108.36],
            [1999, 6385, 120, 65.11],
            [1999, 6386, 120, 90],
            [1999, 6387, 120, 90],
            [1999, 6388, 120, 90],
            [1999, 6389, 120, 90],
            [1999, 6390, 120, 90],
            [1999, 6391, 78.33, 99.36],
            [1999, 6392, 120, 90],
            [1999, 6393, 120, 90],
            [1999, 6394, 120, 90],
            [1999, 6395, 120, 90],
            [1999, 6396, 120, 117.19],
            [1999, 6397, 120, 90],
            [1999, 6398, 120, 90],
            [1999, 6399, 120, 90],
            [1999, 6400, 120, 109.36],
            [1999, 6401, 70, 70],
            [1999, 6402, 120, 130.57],
            [1999, 6403, 120, 90],
            [1999, 6404, 120, 90],
            [1999, 6405, 120, 90],
            [1999, 6406, 120, 109.36],
            [1999, 6407, 120, 109.36],
            [1999, 6408, 120, 90],
            [1999, 6409, 120, 90],
            [1999, 6410, 120, 90],
            [1999, 6411, 120, 90],
            [1999, 6412, 120, 90],
            [1999, 6413, 120, 90],
            [1999, 6414, 120, 109.36],
            [1999, 6415, 120, 119.04],
            [1999, 6416, 120, 90],
            [1999, 6417, 120, 90],
            [1999, 6418, 120, 90],
            [1999, 6419, 120, 90],
            [1999, 6420, 120, 90],
            [1999, 6421, 120, 117.19],
            [1999, 6422, 120, 109.36],
            [1999, 6423, 42.81, 43.17],
            [1999, 6424, 115.49, 81.33],
            [1999, 6425, 70, 98.36],
            [1999, 6426, 120, 117.19],
            [1999, 6427, 120, 90],
            [1999, 6428, 120, 90],
            [1999, 6429, 120, 90],
            [1999, 6430, 70, 86.89],
            [1999, 6431, 120, 90],
            [1999, 6432, 120, 90],
            [1999, 6433, 63.74, 113.55],
            [1999, 6434, 120, 90],
            [1999, 6435, 78.33, 99.36],
            [1999, 6436, 120, 90],
            [1999, 6437, 120, 90],
            [1999, 6438, 120, 90],
            [1999, 6439, 120, 125.74],
            [1999, 6440, 120, 90],
            [1999, 6441, 120, 109.36],
            [1999, 6442, 70, 70],
            [1999, 6443, 120, 90],
            [1999, 6444, 120, 90],
            [1999, 6445, 120, 90],
            [1999, 6446, 120, 90],
            [1999, 6447, 48.53, 70],
            [1999, 6448, 120, 90],
            [1999, 6449, 120, 90],
            [1999, 6450, 120, 90],
            [1999, 6451, 120, 90],
            [1999, 6452, 120, 90],
            [1999, 6453, 120, 90],
            [1999, 6454, 120, 90],
            [1999, 6455, 120, 90],
            [1999, 6456, 120, 90],
            [1999, 6457, 56.58, 70],
            [1999, 6458, 40, 55.85],
            [1999, 6459, 120, 125.74],
            [1999, 6460, 163.78, 95.28],
            [1999, 6461, 120, 90],
            [1999, 6462, 152, 95.28],
            [1999, 6463, 120, 90],
            [1999, 6464, 120, 90],
            [1999, 6465, 120, 90],
            [1999, 6466, 120, 90],
            [1999, 6467, 120, 90],
            [1999, 6468, 120, 90],
            [1999, 6469, 120, 101.08],
            [1999, 6470, 120, 90],
            [1999, 6471, 120, 109.36],
            [1999, 6472, 120, 108.36],
            [1999, 6473, 120, 90],
            [1999, 6474, 120, 90],
            [1999, 6475, 120, 90],
            [1999, 6476, 120, 108.36],
            [1999, 6477, 120, 90],
            [1999, 6478, 120, 90],
            [1999, 6479, 120, 90],
            [1999, 6480, 120, 90],
            [1999, 6481, 120, 90],
            [1999, 6482, 152, 95.28],
            [1999, 6483, 120, 109.36],
            [1999, 6484, 70, 56.48],
            [1999, 6485, 120, 90],
            [1999, 6486, 120, 90],
            [1999, 6487, 120, 90],
            [1999, 6488, 120, 90],
            [1999, 6489, 120, 90],
            [1999, 6490, 120, 108.36],
            [1999, 6491, 120, 90],
            [1999, 6492, 60.88, 72.65],
            [1999, 6493, 120, 90],
            [1999, 6494, 60.88, 72.65],
            [1999, 6495, 120, 125.74],
            [1999, 6496, 120, 109.36],
            [1999, 6497, 120, 90],
            [1999, 6498, 120, 125.74],
            [1999, 6499, 120, 90],
            [1999, 6500, 80.71, 115.49],
            [1999, 6501, 120, 90],
            [1999, 6502, 120, 78.19],
            [1999, 6503, 120, 109.36],
            [1999, 6504, 120, 130.57],
            [1999, 6505, 120, 91.63],
            [1999, 6506, 120, 90],
            [1999, 6507, 120, 90],
            [1999, 6508, 120, 90],
            [1999, 6509, 120, 119.04],
            [1999, 6510, 120, 90],
            [1999, 6511, 120, 90],
            [1999, 6512, 120, 109.36],
            [1999, 6513, 31.53, 53.27],
            [1999, 6514, 120, 90],
            [1999, 6515, 120, 90],
            [1999, 6516, 73.07, 58.95],
            [1999, 6517, 68.95, 86.89],
            [1999, 6518, 120, 117.19],
            [1999, 6519, 120, 90],
            [1999, 6520, 120, 90],
            [1999, 6521, 56.58, 56.58],
            [1999, 6522, 120, 90],
            [1999, 6523, 120, 90],
            [1999, 6524, 120, 90],
            [1999, 6525, 120, 90],
            [1999, 6526, 120, 90],
            [1999, 6527, 120, 125.74],
            [1999, 6528, 120, 125.74],
            [1999, 6529, 120, 90],
            [1999, 6530, 120, 109.36],
            [1999, 6531, 120, 90],
            [1999, 6532, 120, 125.74],
            [1999, 6533, 120, 91.63],
            [1999, 6534, 120, 119.04],
            [1999, 6535, 120, 90],
            [1999, 6536, 70.23, 106.94],
            [1999, 6537, 120, 90],
            [1999, 6538, 120, 90],
            [1999, 6539, 120, 90],
            [1999, 6540, 120, 90],
            [1999, 6541, 120, 90],
            [1999, 6542, 120, 108.36],
            [1999, 6543, 120, 90],
            [1999, 6544, 120, 90],
            [1999, 6546, 120, 90],
            [1999, 6547, 120, 90],
            [1999, 6548, 120, 90],
            [1999, 6549, 120, 90],
            [1999, 6550, 120, 90],
            [1999, 6551, 120, 90],
            [1999, 6552, 120, 108.36],
            [1999, 6553, 120, 90],
            [1999, 6554, 120, 90],
            [1999, 6555, 120, 90],
            [1999, 6556, 120, 90],
            [1999, 6557, 120, 90],
            [1999, 6558, 120, 90],
            [1999, 6559, 120, 90],
            [1999, 6560, 120, 90],
            [1999, 6561, 120, 90],
            [1999, 6562, 120, 90],
            [1999, 6563, 120, 90],
            [1999, 6564, 120, 90],
            [1999, 6565, 120, 90],
            [1999, 6566, 120, 78.64],
            [1999, 6567, 120, 90],
            [1999, 6568, 120, 109.36],
            [1999, 6569, 120, 90],
            [1999, 6570, 120, 90],
            [1999, 6572, 120, 90],
            [1999, 6573, 120, 90],
            [1999, 6574, 120, 90],
            [1999, 6575, 120, 119.04],
            [1999, 6576, 120, 90],
            [1999, 6577, 120, 90],
            [1999, 6578, 120, 109.36],
            [1999, 6579, 120, 90],
            [1999, 6580, 120, 90],
            [1999, 6581, 120, 90],
            [1999, 6582, 120, 90],
            [1999, 6583, 120, 90],
            [1999, 6584, 120, 90],
            [1999, 6585, 120, 109.36],
            [1999, 6586, 120, 130.57],
            [1999, 6587, 120, 90],
            [1999, 6588, 120, 109.36],
            [1999, 6589, 120, 90],
            [1999, 6590, 120, 90],
            [1999, 6591, 120, 90],
            [1999, 6592, 120, 90],
            [1999, 6593, 120, 90],
            [1999, 6594, 120, 90],
            [1999, 6595, 120, 90],
            [1999, 6596, 120, 90],
            [1999, 6597, 120, 90],
            [1999, 6598, 120, 90],
            [1999, 6599, 120, 90],
            [1999, 6600, 120, 90],
            [1999, 6601, 120, 90],
            [1999, 6602, 120, 125.74],
            [1999, 6603, 70, 70],
            [1999, 6604, 120, 119.04],
            [1999, 6605, 120, 108.36],
            [1999, 6606, 120, 90],
            [1999, 6607, 120, 125.74],
            [1999, 6608, 120, 109.36],
            [1999, 6609, 120, 90],
            [1999, 6610, 120, 90],
            [1999, 6611, 70, 91.63],
            [1999, 6612, 120, 119.04],
            [1999, 6613, 120, 90],
            [1999, 6614, 50, 101.08],
            [1999, 6615, 120, 130.57],
            [1999, 6616, 120, 90],
            [1999, 6617, 39.9, 34.9],
            [1999, 6618, 120, 90],
            [1999, 6619, 120, 90],
            [1999, 6620, 120, 90],
            [1999, 6621, 120, 90],
            [1999, 6622, 120, 90],
            [1999, 6623, 152, 95.28],
            [1999, 6624, 120, 108.36],
            [1999, 6625, 120, 90],
            [1999, 6626, 120, 90],
            [1999, 6627, 120, 90],
            [1999, 6628, 120, 90],
            [1999, 6629, 70, 70],
            [1999, 6630, 70, 70],
            [1999, 6631, 50, 60],
            [1999, 6632, 40, 50],
            [1999, 6633, 50, 60],
            [1999, 6634, 70, 70],
            [1999, 6635, 120, 90],
            [1999, 6636, 70, 70],
            [1999, 6637, 120, 90],
            [1999, 6638, 70, 70],
            [1999, 6639, 120, 90],
            [1999, 6640, 50, 60],
            [1999, 6641, 70, 70],
            [1999, 6642, 40, 50],
            [1999, 6643, 30, 40],
            [1999, 6648, 120, 90],
            [1999, 6649, 120, 90],
            [1999, 6650, 120, 90],
            [1999, 6651, 120, 90],
            [1999, 6652, 120, 90],
            [1999, 6653, 70, 70],
            [1999, 6654, 70, 70],
            [1999, 6655, 70, 70],
            [1999, 6656, 70, 70],
            [1999, 6657, 70, 70],
            [1999, 6660, 70, 70],
            [1999, 6661, 70, 70],
            [1999, 6662, 70, 70],
            [1999, 6663, 70, 70],
            [1999, 6664, 70, 70],
            [1999, 6665, 70, 70],
            [1999, 6666, 70, 70],
            [1999, 6667, 70, 70],
            [1999, 6668, 70, 70],
            [1999, 6669, 70, 70],
            [1999, 6670, 70, 70],
            [1999, 6671, 70, 70],
            [1999, 6672, 70, 70],
            [1999, 6673, 70, 70],
            [1999, 6674, 70, 70],
            [1999, 6675, 70, 70],
            [1999, 6676, 70, 70],
            [1999, 6677, 70, 70],
            [1999, 6678, 70, 70],
            [1999, 6679, 70, 70],
            [1999, 6680, 70, 70],
            [1999, 6682, 70, 70],
            [1999, 6683, 70, 70],
            [1999, 6684, 70, 70],
            [1999, 6685, 50, 60],
            [1999, 6686, 50, 60],
            [1999, 6687, 50, 60],
            [1999, 6688, 50, 60],
            [1999, 6689, 50, 60],
            [1999, 6690, 50, 60],
            [1999, 6691, 120, 90],
            [1999, 6692, 120, 90],
            [1999, 6697, 40, 50],
            [1999, 6698, 70, 70],
            [1999, 6699, 70, 70],
            [1999, 6700, 120, 90],
            [1999, 6701, 70, 70],
            [1999, 6702, 70, 70],
            [1999, 6703, 30, 40],
            [1999, 6704, 70, 70],
            [1999, 6705, 70, 70],
            [1999, 6706, 70, 70],
            [1999, 6707, 120, 90],
            [1999, 6708, 70, 70],
            [1999, 6709, 30, 40],
            [1999, 6710, 50, 60],
            [1999, 6711, 70, 70],
            [1999, 6712, 50, 60],
            [1999, 6713, 70, 70],
            [1999, 6714, 50, 60],
            [1999, 6715, 120, 90],
            [1999, 6716, 70, 70],
            [1999, 6717, 70, 70],
            [1999, 6718, 70, 70],
            [1999, 6719, 70, 70],
            [1999, 6720, 70, 70],
            [1999, 6721, 50, 60],
            [1999, 6722, 30, 40],
            [1999, 6723, 70, 70],
            [1999, 6724, 70, 70],
            [1999, 6725, 70, 70],
            [1999, 6726, 70, 70],
            [1999, 6727, 70, 70],
            [1999, 6728, 70, 70],
            [1999, 6729, 70, 70],
            [1999, 6730, 120, 90],
            [1999, 6731, 70, 70],
            [1999, 6732, 70, 70],
            [1999, 6733, 70, 70],
            [1999, 6734, 70, 70],
            [1999, 6735, 70, 70],
            [1999, 6736, 50, 60],
            [1999, 6737, 70, 70],
            [1999, 6738, 70, 70],
            [1999, 6739, 50, 60],
            [1999, 6740, 18, 27],
            [1999, 6741, 18, 27],
            [1999, 6742, 18, 27],
            [1999, 6743, 18, 27],
            [1999, 6746, 50, 60],
            [1999, 6748, 70, 70],
            [1999, 6749, 70, 70],
            [1999, 6750, 50, 60],
            [1999, 6752, 50, 60],
            [1999, 6753, 120, 90],
            [1999, 6754, 70, 70],
            [1999, 6755, 70, 70],
            [1999, 6756, 70, 70],
            [1999, 6757, 70, 70],
            [1999, 6758, 70, 70],
            [1999, 6759, 50, 60],
            [1999, 6760, 70, 70],
            [1999, 6761, 70, 70],
            [1999, 6762, 70, 70],
            [1999, 6763, 50, 60],
            [1999, 6764, 70, 70],
            [1999, 6766, 120, 90],
            [1999, 6767, 70, 70],
            [1999, 6768, 70, 70],
            [1999, 6769, 120, 90],
            [1999, 6770, 70, 70],
            [1999, 6771, 70, 70],
            [1999, 6772, 50, 60],
            [1999, 6773, 120, 90],
            [1999, 6777, 70, 70],
            [1999, 6778, 40, 50],
            [1999, 6779, 50, 60],
            [1999, 6780, 70, 70],
            [1999, 6781, 70, 70],
            [1999, 6782, 120, 90],
            [1999, 6783, 70, 70],
            [1999, 6784, 70, 70],
            [1999, 6785, 70, 70],
            [1999, 6786, 70, 70],
            [1999, 6787, 70, 70],
            [1999, 6789, 50, 60],
            [1999, 6824, 120, 90],
            [1999, 6825, 120, 90],
            [1999, 6826, 50, 60],
            [1999, 6827, 50, 60],
            [1999, 6828, 50, 60],
            [1999, 6829, 70, 70],
            [1999, 6830, 70, 70],
            [1999, 6831, 120, 90],
            [1999, 6832, 70, 70],
            [2000, 1, 50, 60],
            [2000, 2, 120, 90],
            [2000, 3, 70, 70],
            [2000, 7, 35.26, 21.02],
            [2000, 9, 70, 70],
            [2000, 13, 120, 90],
            [2000, 14, 120, 90],
            [2000, 15, 70, 70],
            [2000, 16, 70, 70],
            [2000, 17, 120, 90],
            [2000, 18, 70, 70],
            [2000, 19, 70, 70],
            [2000, 20, 120, 90],
            [2000, 21, 70, 70],
            [2000, 22, 3.02, 9.75],
            [2000, 23, 120, 90],
            [2000, 25, 13.55, 9.36],
            [2000, 26, 98.66, 77.21],
            [2000, 27, 120, 90],
            [2000, 28, 50, 60],
            [2000, 29, 120, 90],
            [2000, 30, 26.05, 16.78],
            [2000, 31, 11.48, 9.38],
            [2000, 32, 120, 90],
            [2000, 33, 60.79, 35],
            [2000, 35, 120, 90],
            [2000, 37, 120, 90],
            [2000, 38, 120, 90],
            [2000, 40, 70, 70],
            [2000, 42, 49.3, 31.8],
            [2000, 43, 120, 90],
            [2000, 44, 120, 90],
            [2000, 47, 50, 60],
            [2000, 48, 70, 70],
            [2000, 49, 37.5, 45],
            [2000, 50, 120, 90],
            [2000, 51, 15.57, 18.15],
            [2000, 53, 40, 50],
            [2000, 56, 120, 90],
            [2000, 57, 120, 90],
            [2000, 58, 61.93, 49.09],
            [2000, 61, 70, 70],
            [2000, 62, 27.9, 27.4],
            [2000, 63, 70, 70],
            [2000, 64, 29.97, 42.64],
            [2000, 65, 50, 42.55],
            [2000, 66, 20, 25],
            [2000, 68, 98.54, 77.15],
            [2000, 69, 70, 70],
            [2000, 70, 50, 60],
            [2000, 71, 120, 90],
            [2000, 72, 120, 90],
            [2000, 73, 120, 90],
            [2000, 75, 50, 60],
            [2000, 77, 120, 90],
            [2000, 78, 59.13, 56.03],
            [2000, 81, 70, 70],
            [2000, 82, 12, 28.91],
            [2000, 83, 40, 37.5],
            [2000, 84, 120, 90],
            [2000, 87, 140.68, 39.98],
            [2000, 88, 10.85, 7.56],
            [2000, 89, 70, 70],
            [2000, 91, 40, 50],
            [2000, 93, 8.27, 9.25],
            [2000, 94, 120, 90],
            [2000, 96, 17.85, 27],
            [2000, 99, 31.13, 26.62],
            [2000, 100, 8.29, 8.86],
            [2000, 101, 70, 70],
            [2000, 103, 120, 90],
            [2000, 105, 40, 50],
            [2000, 106, 70, 70],
            [2000, 109, 40, 50],
            [2000, 110, 120, 90],
            [2000, 113, 86.12, 35.5],
            [2000, 119, 70, 70],
            [2000, 121, 13.82, 8.38],
            [2000, 122, 42.72, 53.2],
            [2000, 123, 120, 90],
            [2000, 125, 24.22, 37.94],
            [2000, 128, 74.95, 70],
            [2000, 133, 120, 90],
            [2000, 135, 24.22, 25.06],
            [2000, 136, 120, 90],
            [2000, 138, 89.29, 46.57],
            [2000, 140, 50, 60],
            [2000, 141, 5, 5.95],
            [2000, 142, 70, 70],
            [2000, 144, 50, 60],
            [2000, 145, 10.42, 7.09],
            [2000, 146, 120, 90],
            [2000, 147, 70, 70],
            [2000, 149, 50, 33.8],
            [2000, 150, 80.09, 63.64],
            [2000, 151, 47.04, 30.27],
            [2000, 153, 30, 45],
            [2000, 156, 120, 90],
            [2000, 157, 120, 90],
            [2000, 158, 120, 90],
            [2000, 160, 120, 90],
            [2000, 161, 47.65, 26.01],
            [2000, 162, 40, 50],
            [2000, 163, 32.08, 38.15],
            [2000, 164, 120, 90],
            [2000, 165, 70, 70],
            [2000, 166, 31.35, 44.44],
            [2000, 169, 97.7, 41.85],
            [2000, 170, 120, 90],
            [2000, 171, 35.55, 35],
            [2000, 175, 70, 70],
            [2000, 177, 71.36, 70],
            [2000, 181, 120, 90],
            [2000, 182, 120, 90],
            [2000, 183, 70, 70],
            [2000, 184, 120, 90],
            [2000, 186, 16.63, 13.83],
            [2000, 187, 50, 60],
            [2000, 188, 34.84, 17.18],
            [2000, 189, 120, 90],
            [2000, 190, 41.9, 24.53],
            [2000, 192, 12, 18],
            [2000, 194, 36.1, 33],
            [2000, 195, 25.2, 22.5],
            [2000, 196, 8.64, 9.03],
            [2000, 197, 120, 90],
            [2000, 199, 120, 90],
            [2000, 200, 50, 60],
            [2000, 203, 70, 70],
            [2000, 204, 16.64, 27],
            [2000, 206, 120, 90],
            [2000, 207, 50, 60],
            [2000, 210, 120, 90],
            [2000, 211, 42.5, 64.2],
            [2000, 212, 70, 70],
            [2000, 213, 70, 70],
            [2000, 214, 120, 90],
            [2000, 215, 44.5, 31.24],
            [2000, 216, 98.28, 54.81],
            [2000, 217, 120, 90],
            [2000, 218, 53.89, 34.22],
            [2000, 220, 23.35, 19.12],
            [2000, 222, 9.57, 9.57],
            [2000, 225, 37.5, 45],
            [2000, 226, 13.66, 15.31],
            [2000, 227, 120, 90],
            [2000, 228, 18.5, 27.7],
            [2000, 230, 30, 37.5],
            [2000, 231, 70, 70],
            [2000, 233, 22.4, 15.4],
            [2000, 234, 10, 19.36],
            [2000, 235, 34.93, 21.66],
            [2000, 236, 70, 70],
            [2000, 237, 10.83, 7.57],
            [2000, 239, 58.9, 76.35],
            [2000, 240, 35.9, 29.8],
            [2000, 241, 46.4, 41.28],
            [2000, 242, 164.4, 59.03],
            [2000, 243, 118.04, 58],
            [2000, 244, 120, 90],
            [2000, 245, 120, 90],
            [2000, 246, 60.21, 33.65],
            [2000, 247, 120, 90],
            [2000, 248, 60.9, 49.22],
            [2000, 249, 70, 70],
            [2000, 250, 50, 60],
            [2000, 253, 120, 90],
            [2000, 256, 50, 60],
            [2000, 257, 120, 90],
            [2000, 260, 70, 70],
            [2000, 264, 50, 60],
            [2000, 265, 120, 90],
            [2000, 267, 120, 90],
            [2000, 268, 120, 90],
            [2000, 269, 120, 90],
            [2000, 270, 70.14, 48.85],
            [2000, 272, 120, 90],
            [2000, 273, 25.7, 35.52],
            [2000, 282, 70, 70],
            [2000, 283, 120, 90],
            [2000, 284, 70, 70],
            [2000, 285, 62.31, 50.39],
            [2000, 286, 33.37, 83.43],
            [2000, 287, 40, 37.5],
            [2000, 289, 120, 90],
            [2000, 291, 70, 70],
            [2000, 292, 53.52, 70],
            [2000, 294, 96.24, 38.52],
            [2000, 295, 120, 90],
            [2000, 296, 36.57, 16.84],
            [2000, 297, 120, 90],
            [2000, 298, 70, 70],
            [2000, 299, 26.73, 30.82],
            [2000, 302, 120, 90],
            [2000, 303, 60.81, 32.84],
            [2000, 305, 15.78, 16.19],
            [2000, 306, 53.16, 39.53],
            [2000, 307, 70, 70],
            [2000, 308, 22.69, 32.81],
            [2000, 309, 120, 90],
            [2000, 310, 20.52, 19.97],
            [2000, 311, 70, 70],
            [2000, 312, 98.14, 57.65],
            [2000, 313, 50, 60],
            [2000, 314, 28.98, 30.23],
            [2000, 315, 120, 90],
            [2000, 317, 31.04, 29.1],
            [2000, 320, 40.8, 42.3],
            [2000, 321, 120, 90],
            [2000, 322, 120, 90],
            [2000, 324, 37.5, 45],
            [2000, 325, 120, 90],
            [2000, 326, 28.63, 19.82],
            [2000, 327, 52.96, 62.65],
            [2000, 328, 70, 70],
            [2000, 329, 70, 70],
            [2000, 330, 26.79, 29.04],
            [2000, 332, 101.6, 71.83],
            [2000, 333, 120, 90],
            [2000, 334, 14.71, 16.26],
            [2000, 337, 19.61, 30.02],
            [2000, 339, 74, 62.86],
            [2000, 340, 120, 90],
            [2000, 342, 86.2, 70],
            [2000, 343, 120, 90],
            [2000, 344, 79.03, 44.3],
            [2000, 346, 56.18, 44.76],
            [2000, 347, 70, 70],
            [2000, 348, 120, 90],
            [2000, 350, 70, 70],
            [2000, 351, 70, 70],
            [2000, 353, 50, 60],
            [2000, 354, 37.5, 45],
            [2000, 355, 70, 70],
            [2000, 356, 120, 90],
            [2000, 358, 70, 70],
            [2000, 361, 49.02, 40.47],
            [2000, 362, 50, 60],
            [2000, 365, 120, 90],
            [2000, 367, 40, 50],
            [2000, 368, 50, 60],
            [2000, 369, 5.88, 5.27],
            [2000, 370, 70, 70],
            [2000, 371, 72.52, 67.5],
            [2000, 372, 16.36, 13.13],
            [2000, 374, 50, 60],
            [2000, 376, 22.12, 15.96],
            [2000, 377, 25.09, 17.45],
            [2000, 378, 31.04, 34.22],
            [2000, 379, 11.67, 16.73],
            [2000, 382, 70, 70],
            [2000, 383, 25.5, 21.6],
            [2000, 385, 120, 90],
            [2000, 386, 50, 60],
            [2000, 387, 70, 70],
            [2000, 389, 37.5, 45],
            [2000, 390, 70, 70],
            [2000, 391, 70, 70],
            [2000, 392, 34.26, 35.61],
            [2000, 394, 50, 60],
            [2000, 396, 120, 90],
            [2000, 398, 70, 70],
            [2000, 399, 70, 70],
            [2000, 400, 50, 60],
            [2000, 401, 70, 70],
            [2000, 402, 120, 90],
            [2000, 403, 27.52, 29.78],
            [2000, 405, 70, 70],
            [2000, 406, 120, 90],
            [2000, 409, 50, 60],
            [2000, 411, 120, 90],
            [2000, 412, 120, 90],
            [2000, 413, 30, 45],
            [2000, 415, 120, 90],
            [2000, 416, 50, 60],
            [2000, 418, 36.34, 36.78],
            [2000, 419, 120, 90],
            [2000, 422, 120, 90],
            [2000, 424, 36.5, 31.71],
            [2000, 425, 12.16, 14.12],
            [2000, 426, 120, 90],
            [2000, 427, 40, 50],
            [2000, 428, 8.07, 10.33],
            [2000, 429, 70, 70],
            [2000, 430, 27, 24],
            [2000, 432, 72.02, 36.75],
            [2000, 434, 70, 70],
            [2000, 436, 20.72, 16.74],
            [2000, 437, 40, 50],
            [2000, 439, 70, 70],
            [2000, 443, 120, 90],
            [2000, 444, 50, 60],
            [2000, 445, 120, 90],
            [2000, 446, 70, 70],
            [2000, 450, 120, 90],
            [2000, 451, 50, 60],
            [2000, 452, 120, 90],
            [2000, 453, 70, 70],
            [2000, 454, 120, 90],
            [2000, 455, 71.93, 65.93],
            [2000, 457, 40, 50],
            [2000, 458, 92.61, 76.03],
            [2000, 459, 120, 90],
            [2000, 460, 70, 70],
            [2000, 461, 50, 60],
            [2000, 463, 10.14, 8.58],
            [2000, 464, 21.08, 14.31],
            [2000, 465, 50, 60],
            [2000, 466, 120, 90],
            [2000, 467, 120, 90],
            [2000, 468, 120, 90],
            [2000, 469, 120, 90],
            [2000, 470, 120, 90],
            [2000, 471, 29.42, 44.44],
            [2000, 473, 120, 90],
            [2000, 474, 70, 70],
            [2000, 476, 120, 90],
            [2000, 477, 120, 90],
            [2000, 478, 120, 90],
            [2000, 479, 70, 70],
            [2000, 480, 70, 70],
            [2000, 481, 70, 70],
            [2000, 482, 70, 70],
            [2000, 484, 70, 70],
            [2000, 485, 120, 90],
            [2000, 486, 50, 60],
            [2000, 487, 29.5, 43.67],
            [2000, 488, 70, 70],
            [2000, 490, 70, 70],
            [2000, 493, 120, 90],
            [2000, 494, 16.23, 19.49],
            [2000, 495, 120, 90],
            [2000, 496, 70, 70],
            [2000, 497, 20.34, 27.7],
            [2000, 498, 50, 60],
            [2000, 500, 70, 70],
            [2000, 501, 70, 70],
            [2000, 503, 70, 24.56],
            [2000, 504, 14.4, 17.19],
            [2000, 505, 32.44, 29.79],
            [2000, 507, 120, 90],
            [2000, 508, 70, 70],
            [2000, 509, 5.13, 4.64],
            [2000, 510, 40, 50],
            [2000, 512, 30, 35],
            [2000, 513, 70, 70],
            [2000, 515, 75, 45],
            [2000, 518, 120, 90],
            [2000, 519, 22.23, 21.49],
            [2000, 520, 120, 90],
            [2000, 521, 120, 90],
            [2000, 522, 70, 70],
            [2000, 523, 120, 90],
            [2000, 524, 122.06, 81.71],
            [2000, 525, 31.78, 60.44],
            [2000, 526, 70.03, 60],
            [2000, 527, 70, 70],
            [2000, 528, 50, 50],
            [2000, 531, 10.37, 9.91],
            [2000, 532, 85.36, 50.72],
            [2000, 534, 41.02, 29.31],
            [2000, 535, 40, 50],
            [2000, 536, 17.11, 23.93],
            [2000, 540, 70, 70],
            [2000, 541, 61.04, 50.11],
            [2000, 543, 120, 90],
            [2000, 545, 50.7, 47.79],
            [2000, 547, 12, 18],
            [2000, 548, 120, 90],
            [2000, 549, 45, 24.58],
            [2000, 550, 70, 70],
            [2000, 551, 120, 90],
            [2000, 553, 120, 90],
            [2000, 554, 15, 25],
            [2000, 555, 120, 90],
            [2000, 556, 120, 90],
            [2000, 557, 40, 50],
            [2000, 558, 120, 90],
            [2000, 559, 70, 70],
            [2000, 561, 120, 90],
            [2000, 563, 78.2, 70],
            [2000, 564, 12.02, 6.99],
            [2000, 565, 24.89, 19.74],
            [2000, 568, 22.14, 18.78],
            [2000, 569, 106.46, 58.13],
            [2000, 570, 77.63, 49.89],
            [2000, 571, 70, 70],
            [2000, 572, 30, 45],
            [2000, 573, 34.75, 26.58],
            [2000, 574, 70, 70],
            [2000, 577, 32.7, 38.7],
            [2000, 579, 40, 50],
            [2000, 581, 30, 45],
            [2000, 582, 120, 90],
            [2000, 583, 70, 70],
            [2000, 584, 21.39, 10.39],
            [2000, 585, 70, 70],
            [2000, 586, 50, 60],
            [2000, 588, 12, 22.5],
            [2000, 589, 120, 90],
            [2000, 590, 53.52, 61.02],
            [2000, 591, 120, 90],
            [2000, 593, 65, 51.92],
            [2000, 594, 70, 70],
            [2000, 595, 104.15, 43.17],
            [2000, 596, 8.9, 17.2],
            [2000, 597, 40.93, 18.93],
            [2000, 599, 37.1, 32.34],
            [2000, 600, 120, 90],
            [2000, 601, 70, 70],
            [2000, 604, 77.66, 49.79],
            [2000, 606, 70, 70],
            [2000, 607, 50, 60],
            [2000, 608, 54.37, 25.93],
            [2000, 610, 50, 60],
            [2000, 611, 50, 60],
            [2000, 612, 45.76, 60.33],
            [2000, 614, 20.59, 23],
            [2000, 615, 120, 90],
            [2000, 616, 120, 90],
            [2000, 618, 30, 37.5],
            [2000, 619, 120, 90],
            [2000, 621, 120, 90],
            [2000, 623, 8.39, 6.11],
            [2000, 625, 51.68, 25.98],
            [2000, 626, 40, 50],
            [2000, 627, 50, 60],
            [2000, 628, 34.13, 29.15],
            [2000, 629, 18.8, 33.4],
            [2000, 630, 70, 70],
            [2000, 631, 39.6, 34.17],
            [2000, 633, 120, 90],
            [2000, 635, 70, 70],
            [2000, 636, 21.1, 50.2],
            [2000, 637, 7.79, 7.02],
            [2000, 639, 70, 70],
            [2000, 641, 120, 90],
            [2000, 645, 97.67, 37.44],
            [2000, 647, 108.04, 87.9],
            [2000, 648, 70, 70],
            [2000, 649, 70, 70],
            [2000, 650, 120, 90],
            [2000, 651, 120, 90],
            [2000, 653, 70, 70],
            [2000, 654, 12.52, 17.79],
            [2000, 656, 120, 90],
            [2000, 657, 120, 90],
            [2000, 659, 7.56, 7.64],
            [2000, 660, 38.63, 26.61],
            [2000, 662, 120, 90],
            [2000, 663, 69.14, 36.97],
            [2000, 664, 70, 70],
            [2000, 665, 120, 90],
            [2000, 666, 120, 90],
            [2000, 669, 50, 30.85],
            [2000, 670, 70, 70],
            [2000, 672, 70, 70],
            [2000, 673, 120, 90],
            [2000, 675, 70, 70],
            [2000, 678, 32.19, 33.94],
            [2000, 679, 120, 90],
            [2000, 680, 10.1, 8.13],
            [2000, 681, 70, 70],
            [2000, 682, 8.1, 6.18],
            [2000, 683, 9.08, 9.76],
            [2000, 686, 16.9, 21.27],
            [2000, 687, 120, 90],
            [2000, 688, 120, 90],
            [2000, 690, 40, 50],
            [2000, 691, 18.17, 15.1],
            [2000, 692, 70, 70],
            [2000, 693, 70, 70],
            [2000, 694, 50, 42.14],
            [2000, 695, 82.86, 52.5],
            [2000, 697, 120, 90],
            [2000, 698, 70, 70],
            [2000, 700, 70, 70],
            [2000, 701, 120, 90],
            [2000, 702, 70, 70],
            [2000, 703, 12, 18],
            [2000, 704, 93.01, 45.96],
            [2000, 705, 30, 45],
            [2000, 706, 70, 70],
            [2000, 708, 70, 70],
            [2000, 709, 32.88, 46.39],
            [2000, 710, 120, 90],
            [2000, 711, 50, 60],
            [2000, 714, 50, 60],
            [2000, 715, 120, 90],
            [2000, 716, 70, 70],
            [2000, 717, 36.27, 32.74],
            [2000, 718, 79.28, 72.56],
            [2000, 719, 120, 90],
            [2000, 720, 83.47, 31.82],
            [2000, 721, 50, 60],
            [2000, 722, 120, 90],
            [2000, 723, 50, 60],
            [2000, 724, 20.76, 58.98],
            [2000, 727, 50, 45],
            [2000, 730, 120, 90],
            [2000, 731, 41.75, 21.4],
            [2000, 732, 151, 158],
            [2000, 734, 18.45, 34.92],
            [2000, 737, 10.58, 13.69],
            [2000, 738, 120, 90],
            [2000, 740, 18, 27],
            [2000, 741, 120, 90],
            [2000, 742, 25, 15.29],
            [2000, 745, 120, 90],
            [2000, 746, 40, 50],
            [2000, 747, 85.74, 47.21],
            [2000, 748, 120, 90],
            [2000, 749, 50, 60],
            [2000, 750, 133.42, 46.75],
            [2000, 751, 70, 70],
            [2000, 753, 50, 60],
            [2000, 754, 32.02, 28.67],
            [2000, 756, 70, 70],
            [2000, 759, 70, 70],
            [2000, 762, 70, 70],
            [2000, 763, 70, 70],
            [2000, 766, 100.6, 37.63],
            [2000, 767, 70, 70],
            [2000, 769, 37.94, 60],
            [2000, 771, 120, 90],
            [2000, 772, 70, 70],
            [2000, 773, 69.55, 32.33],
            [2000, 775, 70, 70],
            [2000, 776, 120, 90],
            [2000, 778, 120, 90],
            [2000, 779, 50, 60],
            [2000, 781, 71.26, 34.85],
            [2000, 782, 120, 90],
            [2000, 783, 50, 45],
            [2000, 784, 33.43, 46.1],
            [2000, 785, 120, 90],
            [2000, 787, 18, 23.03],
            [2000, 789, 70, 70],
            [2000, 790, 60.28, 19.43],
            [2000, 795, 120, 90],
            [2000, 796, 70, 70],
            [2000, 799, 50, 60],
            [2000, 801, 32.11, 49.85],
            [2000, 802, 120, 90],
            [2000, 803, 42.57, 40],
            [2000, 804, 120, 90],
            [2000, 805, 13.65, 18.71],
            [2000, 806, 120, 90],
            [2000, 807, 9.12, 12.1],
            [2000, 811, 120, 90],
            [2000, 812, 50, 60],
            [2000, 813, 8.07, 6.92],
            [2000, 814, 120, 90],
            [2000, 815, 30.9, 14.34],
            [2000, 818, 70, 70],
            [2000, 819, 120, 90],
            [2000, 820, 50, 65],
            [2000, 821, 32.18, 30.47],
            [2000, 822, 18.48, 22.65],
            [2000, 823, 120, 90],
            [2000, 824, 120, 90],
            [2000, 825, 70, 70],
            [2000, 826, 32.3, 7.9],
            [2000, 827, 12, 18],
            [2000, 829, 8.45, 6.52],
            [2000, 830, 120, 90],
            [2000, 831, 120, 90],
            [2000, 833, 120, 90],
            [2000, 835, 69.3, 61.77],
            [2000, 836, 120, 90],
            [2000, 837, 70, 70],
            [2000, 840, 120, 90],
            [2000, 842, 50, 50],
            [2000, 843, 69.06, 43.42],
            [2000, 844, 117.83, 54.95],
            [2000, 845, 79.17, 68.36],
            [2000, 846, 120, 90],
            [2000, 847, 70, 70],
            [2000, 848, 9.12, 11.53],
            [2000, 850, 26.43, 37.47],
            [2000, 851, 18.96, 12.46],
            [2000, 852, 70, 70],
            [2000, 855, 6.73, 7.13],
            [2000, 857, 120, 90],
            [2000, 860, 70, 70],
            [2000, 863, 13.7, 17.4],
            [2000, 865, 70, 42.13],
            [2000, 867, 120, 90],
            [2000, 869, 70, 70],
            [2000, 871, 16.44, 22.77],
            [2000, 872, 70, 70],
            [2000, 873, 48, 70],
            [2000, 875, 120, 90],
            [2000, 876, 120, 90],
            [2000, 877, 120, 90],
            [2000, 878, 5.59, 4.6],
            [2000, 881, 120, 90],
            [2000, 882, 50, 60],
            [2000, 883, 120, 90],
            [2000, 884, 70, 70],
            [2000, 885, 70, 70],
            [2000, 886, 120, 90],
            [2000, 889, 11.95, 11.28],
            [2000, 890, 63.25, 33.78],
            [2000, 891, 120, 90],
            [2000, 892, 120, 90],
            [2000, 894, 23.13, 17.71],
            [2000, 895, 120, 90],
            [2000, 896, 70, 70],
            [2000, 897, 13.97, 22.37],
            [2000, 899, 120, 90],
            [2000, 900, 6.81, 4.72],
            [2000, 901, 120, 90],
            [2000, 905, 120, 90],
            [2000, 909, 120, 90],
            [2000, 910, 11.75, 7.29],
            [2000, 913, 21.73, 18.25],
            [2000, 914, 120, 90],
            [2000, 915, 38.46, 49.72],
            [2000, 916, 40, 50],
            [2000, 917, 30, 45],
            [2000, 918, 47, 50],
            [2000, 919, 120, 90],
            [2000, 922, 50, 60],
            [2000, 924, 8.93, 9.74],
            [2000, 926, 40.84, 38.58],
            [2000, 927, 70, 70],
            [2000, 928, 120, 90],
            [2000, 929, 120, 90],
            [2000, 930, 50, 60],
            [2000, 931, 70, 70],
            [2000, 934, 37.5, 45],
            [2000, 935, 120, 90],
            [2000, 936, 50, 60],
            [2000, 937, 120, 90],
            [2000, 938, 12, 18],
            [2000, 940, 12, 18],
            [2000, 941, 70, 70],
            [2000, 942, 70, 70],
            [2000, 944, 96.61, 70.21],
            [2000, 945, 50, 60],
            [2000, 946, 50, 60],
            [2000, 948, 31.14, 15],
            [2000, 949, 79.45, 48.51],
            [2000, 950, 9.26, 20.62],
            [2000, 952, 12.6, 9.35],
            [2000, 953, 70, 70],
            [2000, 954, 120, 90],
            [2000, 955, 120, 90],
            [2000, 957, 120, 90],
            [2000, 958, 59.87, 32.44],
            [2000, 960, 50, 60],
            [2000, 961, 120, 90],
            [2000, 963, 70, 70],
            [2000, 964, 12, 15],
            [2000, 965, 50.79, 35],
            [2000, 966, 4.52, 4.32],
            [2000, 969, 52.88, 45.27],
            [2000, 970, 50, 60],
            [2000, 971, 35.72, 14.91],
            [2000, 972, 35.77, 19.67],
            [2000, 974, 30, 45],
            [2000, 976, 8.35, 13.15],
            [2000, 977, 12.22, 8.58],
            [2000, 978, 70, 48.36],
            [2000, 979, 25.93, 22.72],
            [2000, 980, 70, 70],
            [2000, 982, 120, 90],
            [2000, 983, 71.83, 30.1],
            [2000, 985, 194.37, 75.01],
            [2000, 986, 7.84, 7.68],
            [2000, 987, 120, 90],
            [2000, 988, 6.14, 5.32],
            [2000, 990, 71.86, 39.63],
            [2000, 991, 120, 90],
            [2000, 993, 89.04, 64.77],
            [2000, 994, 40, 50],
            [2000, 997, 120, 90],
            [2000, 998, 70, 70],
            [2000, 999, 120, 90],
            [2000, 1000, 40, 50],
            [2000, 1003, 7.76, 5.82],
            [2000, 1004, 70, 70],
            [2000, 1005, 40, 50],
            [2000, 1006, 120, 90],
            [2000, 1007, 28.86, 20.82],
            [2000, 1008, 37.5, 45],
            [2000, 1009, 120, 90],
            [2000, 1013, 120, 90],
            [2000, 1015, 70, 70],
            [2000, 1016, 14.94, 23.74],
            [2000, 1017, 50, 60],
            [2000, 1018, 120, 90],
            [2000, 1020, 70, 70],
            [2000, 1021, 70, 70],
            [2000, 1022, 120, 90],
            [2000, 1023, 13.9, 28.3],
            [2000, 1025, 120, 90],
            [2000, 1027, 120, 90],
            [2000, 1028, 50, 60],
            [2000, 1029, 70, 70],
            [2000, 1030, 7, 9.5],
            [2000, 1032, 23, 23.89],
            [2000, 1033, 30.71, 32.21],
            [2000, 1034, 70, 70],
            [2000, 1036, 6.74, 8.62],
            [2000, 1038, 70, 70],
            [2000, 1039, 120, 90],
            [2000, 1042, 120, 90],
            [2000, 1043, 12.3, 25.3],
            [2000, 1044, 120, 90],
            [2000, 1045, 120, 90],
            [2000, 1046, 50, 60],
            [2000, 1047, 70, 70],
            [2000, 1048, 70, 70],
            [2000, 1050, 70, 70],
            [2000, 1051, 92.72, 35.97],
            [2000, 1052, 50, 60],
            [2000, 1053, 50, 60],
            [2000, 1054, 70, 70],
            [2000, 1056, 22.3, 25.8],
            [2000, 1057, 50, 60],
            [2000, 1058, 70, 70],
            [2000, 1059, 65.53, 68.84],
            [2000, 1061, 70, 70],
            [2000, 1062, 7.92, 8.74],
            [2000, 1063, 115.77, 70],
            [2000, 1064, 50, 60],
            [2000, 1065, 120, 90],
            [2000, 1066, 50, 60],
            [2000, 1067, 120, 90],
            [2000, 1069, 50, 60],
            [2000, 1070, 20.5, 19],
            [2000, 1071, 125.97, 49.26],
            [2000, 1073, 84.92, 72.24],
            [2000, 1075, 6.43, 6.35],
            [2000, 1077, 120, 90],
            [2000, 1078, 120, 90],
            [2000, 1080, 120, 90],
            [2000, 1081, 53.54, 36.15],
            [2000, 1082, 75, 64.64],
            [2000, 1084, 160.19, 70.76],
            [2000, 1087, 130.51, 58.25],
            [2000, 1090, 120, 70],
            [2000, 1091, 40, 50],
            [2000, 1092, 12, 18],
            [2000, 1093, 50, 60],
            [2000, 1094, 20.61, 20.28],
            [2000, 1095, 27.39, 27.85],
            [2000, 1096, 120, 90],
            [2000, 1097, 13.52, 12.14],
            [2000, 1099, 13.78, 13.14],
            [2000, 1100, 55.33, 47.25],
            [2000, 1102, 20.14, 33.65],
            [2000, 1104, 70, 70],
            [2000, 1106, 70, 70],
            [2000, 1108, 120, 90],
            [2000, 1109, 71.84, 33.52],
            [2000, 1110, 120, 90],
            [2000, 1111, 68.1, 60.82],
            [2000, 1113, 120, 90],
            [2000, 1114, 120, 90],
            [2000, 1117, 50, 60],
            [2000, 1118, 21.27, 36.09],
            [2000, 1119, 50, 60],
            [2000, 1120, 120, 90],
            [2000, 1121, 120, 90],
            [2000, 1122, 120, 90],
            [2000, 1124, 33.6, 22.42],
            [2000, 1125, 120, 90],
            [2000, 1126, 72.51, 70],
            [2000, 1127, 120, 90],
            [2000, 1128, 70, 70],
            [2000, 1129, 50, 60],
            [2000, 1130, 120, 90],
            [2000, 1131, 40.04, 38.42],
            [2000, 1132, 12, 18],
            [2000, 1136, 64.79, 64.92],
            [2000, 1137, 120, 90],
            [2000, 1138, 120, 90],
            [2000, 1139, 89.3, 90],
            [2000, 1140, 50, 45],
            [2000, 1141, 151.96, 55.04],
            [2000, 1142, 79.98, 40.43],
            [2000, 1144, 70.4, 75.66],
            [2000, 1145, 120, 90],
            [2000, 1147, 12.27, 6.99],
            [2000, 1149, 53.28, 35.03],
            [2000, 1150, 50, 60],
            [2000, 1152, 38.19, 95.28],
            [2000, 1153, 120, 90],
            [2000, 1154, 120, 90],
            [2000, 1155, 12.52, 12.5],
            [2000, 1156, 50, 60],
            [2000, 1157, 40.32, 25.17],
            [2000, 1158, 50, 60],
            [2000, 1159, 70, 60],
            [2000, 1161, 120, 90],
            [2000, 1163, 19.1, 28.7],
            [2000, 1164, 120, 90],
            [2000, 1165, 120, 90],
            [2000, 1167, 66.18, 60.25],
            [2000, 1168, 120, 90],
            [2000, 1169, 24.92, 66.54],
            [2000, 1170, 70, 70],
            [2000, 1171, 89.52, 90],
            [2000, 1172, 70, 70],
            [2000, 1173, 50, 60],
            [2000, 1174, 37.2, 58.3],
            [2000, 1175, 29.09, 38.47],
            [2000, 1176, 120, 90],
            [2000, 1177, 70, 70],
            [2000, 1178, 8.86, 7.64],
            [2000, 1180, 15.85, 14.23],
            [2000, 1181, 120, 90],
            [2000, 1186, 15.33, 18],
            [2000, 1187, 120, 90],
            [2000, 1188, 40, 50],
            [2000, 1189, 120, 90],
            [2000, 1190, 70, 70],
            [2000, 1191, 67.28, 35],
            [2000, 1194, 82.38, 42.91],
            [2000, 1195, 120, 90],
            [2000, 1198, 120, 90],
            [2000, 1199, 40, 50],
            [2000, 1200, 27.2, 13.54],
            [2000, 1202, 30, 45],
            [2000, 1203, 15, 25],
            [2000, 1204, 108.29, 90],
            [2000, 1205, 37.85, 49.46],
            [2000, 1206, 120, 90],
            [2000, 1207, 30, 45],
            [2000, 1209, 40, 50],
            [2000, 1210, 40, 37.5],
            [2000, 1211, 53.75, 32.19],
            [2000, 1212, 70, 70],
            [2000, 1213, 40, 50],
            [2000, 1214, 70, 70],
            [2000, 1216, 50, 60],
            [2000, 1217, 90.55, 46.37],
            [2000, 1219, 110.01, 49.26],
            [2000, 1221, 22.66, 24.86],
            [2000, 1223, 70, 70],
            [2000, 1224, 47.2, 82.28],
            [2000, 1225, 50, 60],
            [2000, 1226, 25.67, 16.67],
            [2000, 1227, 120, 90],
            [2000, 1228, 57.49, 37.38],
            [2000, 1230, 50, 60],
            [2000, 1233, 50, 60],
            [2000, 1234, 12, 18],
            [2000, 1235, 50, 60],
            [2000, 1236, 85.05, 70.88],
            [2000, 1237, 37.5, 45],
            [2000, 1238, 14.2, 20.8],
            [2000, 1239, 120, 90],
            [2000, 1240, 120, 90],
            [2000, 1244, 70, 70],
            [2000, 1245, 120, 90],
            [2000, 1246, 70, 70],
            [2000, 1247, 70, 70],
            [2000, 1250, 70, 70],
            [2000, 1251, 70, 70],
            [2000, 1253, 50, 60],
            [2000, 1254, 70, 70],
            [2000, 1255, 120, 90],
            [2000, 1257, 40, 50],
            [2000, 1259, 105.06, 30.34],
            [2000, 1260, 50, 60],
            [2000, 1262, 110.05, 49.65],
            [2000, 1263, 120, 90],
            [2000, 1264, 120, 90],
            [2000, 1265, 13.11, 9.3],
            [2000, 1266, 120, 90],
            [2000, 1268, 30.72, 32.5],
            [2000, 1269, 50, 60],
            [2000, 1271, 85.26, 44.5],
            [2000, 1272, 70, 70],
            [2000, 1275, 36.46, 15.29],
            [2000, 1276, 70, 70],
            [2000, 1278, 18.5, 14.7],
            [2000, 1280, 11.06, 6.23],
            [2000, 1281, 21.65, 27],
            [2000, 1282, 50, 60],
            [2000, 1286, 120, 90],
            [2000, 1287, 70, 70],
            [2000, 1288, 70, 70],
            [2000, 1290, 120, 90],
            [2000, 1292, 70, 70],
            [2000, 1293, 4.01, 4.97],
            [2000, 1295, 70, 70],
            [2000, 1298, 50, 60],
            [2000, 1299, 70, 70],
            [2000, 1301, 70, 70],
            [2000, 1302, 30, 45],
            [2000, 1303, 70, 70],
            [2000, 1305, 18.06, 19.95],
            [2000, 1306, 12.9, 26.6],
            [2000, 1312, 26.57, 15.77],
            [2000, 1313, 120, 90],
            [2000, 1314, 23.54, 16.63],
            [2000, 1315, 120, 90],
            [2000, 1317, 70, 70],
            [2000, 1318, 120, 90],
            [2000, 1319, 46.62, 28.16],
            [2000, 1320, 120, 90],
            [2000, 1321, 48.13, 28.8],
            [2000, 1323, 75.54, 72.3],
            [2000, 1324, 120, 90],
            [2000, 1325, 120, 90],
            [2000, 1326, 70, 70],
            [2000, 1327, 70, 70],
            [2000, 1328, 69.9, 51.49],
            [2000, 1331, 120, 90],
            [2000, 1332, 5.42, 3.32],
            [2000, 1333, 120, 90],
            [2000, 1334, 55.76, 53.89],
            [2000, 1335, 22.9, 24.9],
            [2000, 1337, 5.66, 6.03],
            [2000, 1338, 120, 90],
            [2000, 1339, 11.12, 8.5],
            [2000, 1340, 53.22, 39.25],
            [2000, 1341, 120, 90],
            [2000, 1342, 70, 70],
            [2000, 1345, 40, 50],
            [2000, 1346, 50, 60],
            [2000, 1349, 70, 70],
            [2000, 1350, 70, 70],
            [2000, 1351, 97.23, 70],
            [2000, 1352, 120, 90],
            [2000, 1353, 70, 70],
            [2000, 1355, 120, 90],
            [2000, 1357, 70, 70],
            [2000, 1358, 120, 90],
            [2000, 1359, 67.94, 52.51],
            [2000, 1360, 18, 27],
            [2000, 1361, 77.94, 60.66],
            [2000, 1363, 87.15, 35.16],
            [2000, 1367, 37.84, 31.71],
            [2000, 1370, 17.21, 28.49],
            [2000, 1371, 118.59, 70],
            [2000, 1372, 120, 90],
            [2000, 1375, 17.87, 23.42],
            [2000, 1376, 30, 37.5],
            [2000, 1378, 70, 70],
            [2000, 1379, 120, 90],
            [2000, 1380, 70, 70],
            [2000, 1381, 120, 90],
            [2000, 1382, 26.47, 36.84],
            [2000, 1383, 8.45, 7.72],
            [2000, 1385, 70, 70],
            [2000, 1387, 40, 50],
            [2000, 1388, 120, 90],
            [2000, 1391, 120, 90],
            [2000, 1392, 120, 90],
            [2000, 1393, 70, 70],
            [2000, 1395, 70, 70],
            [2000, 1396, 12, 24.84],
            [2000, 1398, 40, 50],
            [2000, 1399, 7.42, 6.96],
            [2000, 1402, 70, 70],
            [2000, 1404, 40, 50],
            [2000, 1405, 120, 90],
            [2000, 1406, 4.67, 5.31],
            [2000, 1410, 70, 70],
            [2000, 1411, 50, 60],
            [2000, 1415, 70, 70],
            [2000, 1417, 120, 90],
            [2000, 1420, 50, 60],
            [2000, 1421, 120, 90],
            [2000, 1422, 120, 90],
            [2000, 1424, 50, 60],
            [2000, 1426, 12.76, 9.29],
            [2000, 1427, 23.02, 15.67],
            [2000, 1428, 8.98, 6.72],
            [2000, 1431, 120, 90],
            [2000, 1432, 6.73, 6.53],
            [2000, 1434, 53.67, 36.6],
            [2000, 1436, 70, 70],
            [2000, 1438, 70, 70],
            [2000, 1439, 120, 90],
            [2000, 1440, 70, 70],
            [2000, 1441, 120, 90],
            [2000, 1442, 70, 70],
            [2000, 1443, 57.46, 26.71],
            [2000, 1444, 120, 90],
            [2000, 1445, 85.92, 19.7],
            [2000, 1448, 70, 70],
            [2000, 1449, 120, 90],
            [2000, 1450, 120, 90],
            [2000, 1451, 120, 90],
            [2000, 1453, 70, 70],
            [2000, 1454, 23.66, 23.15],
            [2000, 1456, 70, 70],
            [2000, 1459, 120, 90],
            [2000, 1460, 49, 58],
            [2000, 1461, 6.14, 6.98],
            [2000, 1464, 50, 60],
            [2000, 1465, 30.3, 26.6],
            [2000, 1466, 50, 60],
            [2000, 1467, 70, 70],
            [2000, 1469, 70, 70],
            [2000, 1470, 30, 45],
            [2000, 1471, 58.28, 38.29],
            [2000, 1472, 120, 90],
            [2000, 1473, 11.99, 10.02],
            [2000, 1474, 18, 27],
            [2000, 1475, 93.38, 40.44],
            [2000, 1476, 48.77, 79.01],
            [2000, 1477, 104.49, 49.9],
            [2000, 1478, 14.96, 11.47],
            [2000, 1479, 40, 50],
            [2000, 1481, 70, 70],
            [2000, 1482, 12.31, 14.89],
            [2000, 1483, 70, 70],
            [2000, 1484, 34.55, 69.22],
            [2000, 1485, 120, 90],
            [2000, 1486, 73.81, 56.6],
            [2000, 1487, 120, 90],
            [2000, 1488, 120, 90],
            [2000, 1490, 35.69, 22.38],
            [2000, 1491, 11.32, 8.34],
            [2000, 1493, 40.01, 20.74],
            [2000, 1503, 120, 90],
            [2000, 1505, 120, 90],
            [2000, 1506, 120, 90],
            [2000, 1507, 70, 70],
            [2000, 1508, 23.88, 19.39],
            [2000, 1509, 120, 90],
            [2000, 1510, 15.91, 13.12],
            [2000, 1511, 27.25, 18.05],
            [2000, 1512, 50, 60],
            [2000, 1513, 70, 70],
            [2000, 1514, 70, 70],
            [2000, 1515, 30, 45],
            [2000, 1516, 70, 70],
            [2000, 1518, 120, 90],
            [2000, 1519, 120, 90],
            [2000, 1520, 70, 70],
            [2000, 1521, 120, 90],
            [2000, 1522, 12.41, 18.24],
            [2000, 1523, 120, 90],
            [2000, 1524, 120, 90],
            [2000, 1525, 30, 37.5],
            [2000, 1526, 19.7, 33.1],
            [2000, 1527, 17.34, 33.26],
            [2000, 1530, 97.88, 79.23],
            [2000, 1533, 70, 70],
            [2000, 1534, 10.96, 7.99],
            [2000, 1536, 30.57, 20.35],
            [2000, 1537, 39.94, 45.98],
            [2000, 1538, 120, 90],
            [2000, 1539, 20, 15],
            [2000, 1540, 40, 50],
            [2000, 1541, 70, 70],
            [2000, 1542, 50, 60],
            [2000, 1544, 120, 90],
            [2000, 1546, 70, 70],
            [2000, 1547, 70, 70],
            [2000, 1548, 120, 90],
            [2000, 1549, 50, 60],
            [2000, 1550, 120, 90],
            [2000, 1552, 30, 45],
            [2000, 1553, 70.57, 50.89],
            [2000, 1555, 30, 37.5],
            [2000, 1556, 27.63, 11.76],
            [2000, 1557, 59.6, 36.82],
            [2000, 1559, 50, 60],
            [2000, 1561, 37.45, 42.54],
            [2000, 1562, 97.79, 51.18],
            [2000, 1565, 120, 90],
            [2000, 1567, 120, 90],
            [2000, 1568, 17.56, 11.49],
            [2000, 1571, 70, 70],
            [2000, 1572, 120, 90],
            [2000, 1574, 50, 60],
            [2000, 1575, 124.82, 81.48],
            [2000, 1576, 50, 60],
            [2000, 1577, 50, 60],
            [2000, 1578, 120, 90],
            [2000, 1580, 50, 60],
            [2000, 1581, 17.87, 10.61],
            [2000, 1582, 22.41, 22.97],
            [2000, 1585, 70, 70],
            [2000, 1587, 18, 27],
            [2000, 1589, 70, 70],
            [2000, 1590, 70, 70],
            [2000, 1591, 12.9, 21.1],
            [2000, 1592, 70, 70],
            [2000, 1593, 25.91, 24.87],
            [2000, 1595, 152.2, 70],
            [2000, 1596, 120, 90],
            [2000, 1597, 70, 70],
            [2000, 1598, 15.38, 8.13],
            [2000, 1600, 120, 90],
            [2000, 1601, 70, 70],
            [2000, 1602, 120, 90],
            [2000, 1603, 50, 60],
            [2000, 1605, 50, 60],
            [2000, 1607, 70, 70],
            [2000, 1609, 120, 90],
            [2000, 1610, 32.57, 20.36],
            [2000, 1612, 120, 90],
            [2000, 1615, 120, 90],
            [2000, 1617, 120, 90],
            [2000, 1619, 8.99, 11.56],
            [2000, 1620, 40, 50],
            [2000, 1621, 70, 70],
            [2000, 1623, 50, 60],
            [2000, 1624, 120, 90],
            [2000, 1625, 70, 70],
            [2000, 1626, 70, 70],
            [2000, 1627, 70, 70],
            [2000, 1628, 50, 60],
            [2000, 1629, 40, 50],
            [2000, 1630, 70.01, 36.62],
            [2000, 1632, 8.5, 7.41],
            [2000, 1634, 70, 70],
            [2000, 1635, 16.96, 17.21],
            [2000, 1637, 120, 90],
            [2000, 1638, 52.95, 70],
            [2000, 1639, 74.31, 70],
            [2000, 1640, 70, 70],
            [2000, 1641, 50.33, 45.33],
            [2000, 1643, 18.14, 18.53],
            [2000, 1644, 135.92, 55.65],
            [2000, 1645, 70, 70],
            [2000, 1647, 70, 70],
            [2000, 1648, 120, 90],
            [2000, 1649, 120, 90],
            [2000, 1650, 70, 70],
            [2000, 1651, 120, 90],
            [2000, 1652, 57.04, 46.09],
            [2000, 1653, 35, 26.28],
            [2000, 1654, 50, 60],
            [2000, 1656, 8.28, 5.7],
            [2000, 1657, 70, 70],
            [2000, 1658, 120, 90],
            [2000, 1659, 38.85, 38.2],
            [2000, 1660, 134.83, 48.67],
            [2000, 1661, 70, 70],
            [2000, 1662, 20.69, 28.99],
            [2000, 1663, 35.1, 31.57],
            [2000, 1664, 22.26, 19.82],
            [2000, 1665, 28.19, 19.28],
            [2000, 1666, 6.17, 5.14],
            [2000, 1667, 120, 90],
            [2000, 1668, 84.95, 70],
            [2000, 1669, 120, 90],
            [2000, 1671, 120, 90],
            [2000, 1672, 20.29, 61.88],
            [2000, 1673, 40.58, 28.22],
            [2000, 1674, 70, 70],
            [2000, 1675, 9.08, 16.02],
            [2000, 1679, 33.66, 20.7],
            [2000, 1680, 87.72, 70.36],
            [2000, 1681, 120, 90],
            [2000, 1684, 120, 90],
            [2000, 1685, 37.5, 45],
            [2000, 1686, 120, 90],
            [2000, 1688, 25.71, 34.65],
            [2000, 1689, 120, 90],
            [2000, 1690, 120, 90],
            [2000, 1692, 120, 90],
            [2000, 1694, 120, 90],
            [2000, 1695, 120, 90],
            [2000, 1697, 70, 70],
            [2000, 1701, 70, 70],
            [2000, 1702, 70, 70],
            [2000, 1704, 32.73, 29.33],
            [2000, 1705, 70, 70],
            [2000, 1706, 40, 50],
            [2000, 1707, 30, 17.24],
            [2000, 1709, 16, 15.44],
            [2000, 1711, 70, 70],
            [2000, 1713, 50, 60],
            [2000, 1715, 120, 90],
            [2000, 1717, 70, 70],
            [2000, 1720, 4.58, 3.57],
            [2000, 1722, 120, 90],
            [2000, 1724, 34.9, 28.91],
            [2000, 1726, 120, 90],
            [2000, 1728, 120, 90],
            [2000, 1729, 36.89, 30.28],
            [2000, 1730, 12, 18],
            [2000, 1734, 17.03, 13.98],
            [2000, 1737, 70, 70],
            [2000, 1739, 70, 70],
            [2000, 1740, 50, 60],
            [2000, 1741, 70, 70],
            [2000, 1742, 120, 90],
            [2000, 1743, 70, 70],
            [2000, 1744, 64.97, 47.25],
            [2000, 1745, 34.11, 14.96],
            [2000, 1746, 90.45, 70],
            [2000, 1748, 104.76, 45.88],
            [2000, 1749, 50, 60],
            [2000, 1750, 70, 70],
            [2000, 1752, 120, 90],
            [2000, 1753, 25.17, 15.07],
            [2000, 1754, 120, 90],
            [2000, 1756, 47.1, 29.63],
            [2000, 1757, 70, 70],
            [2000, 1758, 70, 70],
            [2000, 1760, 12.98, 21.4],
            [2000, 1763, 43.44, 47.84],
            [2000, 1764, 70, 70],
            [2000, 1765, 50, 60],
            [2000, 1766, 120, 90],
            [2000, 1767, 120, 88.81],
            [2000, 1769, 70, 60.5],
            [2000, 1770, 48, 62],
            [2000, 1771, 19.39, 23.78],
            [2000, 1772, 25.48, 41.18],
            [2000, 1773, 50, 60],
            [2000, 1774, 17.87, 21.37],
            [2000, 1775, 70, 70],
            [2000, 1776, 35.63, 37.22],
            [2000, 1778, 120, 90],
            [2000, 1779, 35.69, 81.75],
            [2000, 1780, 35.35, 35.59],
            [2000, 1781, 113.83, 52.58],
            [2000, 1783, 12.6, 22.4],
            [2000, 1784, 70, 70],
            [2000, 1785, 120, 90],
            [2000, 1786, 40.8, 58.18],
            [2000, 1787, 120, 90],
            [2000, 1788, 120, 90],
            [2000, 1789, 120, 90],
            [2000, 1790, 47.16, 37.74],
            [2000, 1792, 25.36, 24.69],
            [2000, 1793, 99.43, 70],
            [2000, 1794, 42.48, 37.47],
            [2000, 1795, 13.2, 9.9],
            [2000, 1796, 50, 60],
            [2000, 1797, 70, 70],
            [2000, 1798, 70, 70],
            [2000, 1799, 4.8, 5.01],
            [2000, 1800, 9.59, 5.61],
            [2000, 1801, 70, 70],
            [2000, 1802, 120, 90],
            [2000, 1803, 120, 90],
            [2000, 1804, 105.47, 52.76],
            [2000, 1806, 120, 90],
            [2000, 1809, 120, 90],
            [2000, 1811, 120, 90],
            [2000, 1812, 43.07, 42.87],
            [2000, 1814, 40, 50],
            [2000, 1815, 15.67, 9.13],
            [2000, 1816, 83.79, 61.8],
            [2000, 1817, 90.35, 31.74],
            [2000, 1818, 21.14, 10.89],
            [2000, 1819, 70, 70],
            [2000, 1822, 70, 70],
            [2000, 1824, 50, 65],
            [2000, 1825, 50.4, 52.17],
            [2000, 1827, 70, 70],
            [2000, 1829, 23.1, 41.1],
            [2000, 1832, 70, 70],
            [2000, 1833, 120, 90],
            [2000, 1834, 120, 90],
            [2000, 1837, 120, 90],
            [2000, 1839, 70, 70],
            [2000, 1841, 70, 70],
            [2000, 1843, 14.6, 12.44],
            [2000, 1844, 30, 45],
            [2000, 1845, 20.76, 23.58],
            [2000, 1846, 120, 90],
            [2000, 1847, 50, 60],
            [2000, 1848, 85.7, 63.16],
            [2000, 1849, 120, 90],
            [2000, 1850, 7.35, 6.92],
            [2000, 1851, 7.82, 10.41],
            [2000, 1852, 40.34, 32.16],
            [2000, 1853, 120, 90],
            [2000, 1855, 120, 90],
            [2000, 1856, 30, 45],
            [2000, 1857, 70, 70],
            [2000, 1859, 120, 90],
            [2000, 1860, 120, 90],
            [2000, 1863, 16.62, 11.53],
            [2000, 1864, 94.1, 90],
            [2000, 1866, 70, 70],
            [2000, 1868, 120, 90],
            [2000, 1869, 40, 37.5],
            [2000, 1870, 70, 70],
            [2000, 1873, 70, 70],
            [2000, 1875, 40, 50],
            [2000, 1876, 37.79, 33.06],
            [2000, 1877, 120, 90],
            [2000, 1879, 43.02, 40.39],
            [2000, 1881, 50, 60],
            [2000, 1882, 62.54, 30.08],
            [2000, 1883, 120, 90],
            [2000, 1884, 50, 60],
            [2000, 1885, 70, 70],
            [2000, 1886, 50, 60],
            [2000, 1887, 70, 70],
            [2000, 1888, 120, 90],
            [2000, 1889, 70, 70],
            [2000, 1890, 120, 90],
            [2000, 1891, 33.58, 60],
            [2000, 1892, 70, 70],
            [2000, 1894, 50, 60],
            [2000, 1895, 79.91, 49.67],
            [2000, 1896, 120, 90],
            [2000, 1897, 13.67, 11.12],
            [2000, 1898, 8.67, 4.23],
            [2000, 1899, 70, 70],
            [2000, 1900, 34.8, 47.81],
            [2000, 1901, 25.72, 27.84],
            [2000, 1903, 70, 70],
            [2000, 1904, 120, 90],
            [2000, 1906, 19.49, 10.43],
            [2000, 1909, 120, 90],
            [2000, 1910, 120, 90],
            [2000, 1912, 70, 70],
            [2000, 1914, 120, 90],
            [2000, 1915, 57.34, 41.55],
            [2000, 1916, 120, 90],
            [2000, 1917, 120, 90],
            [2000, 1919, 120, 90],
            [2000, 1920, 70, 70],
            [2000, 1921, 28.17, 26.56],
            [2000, 1924, 120, 90],
            [2000, 1925, 49.21, 40.22],
            [2000, 1928, 120, 90],
            [2000, 1929, 6.5, 4.93],
            [2000, 1930, 10.76, 8.15],
            [2000, 1933, 12.42, 12.39],
            [2000, 1937, 70, 70],
            [2000, 1938, 120, 90],
            [2000, 1940, 120, 90],
            [2000, 1941, 120, 90],
            [2000, 1945, 41.7, 25.8],
            [2000, 1946, 70, 70],
            [2000, 1948, 26.6, 21.6],
            [2000, 1949, 120, 90],
            [2000, 1950, 42.96, 58.04],
            [2000, 1952, 92.32, 71.14],
            [2000, 1955, 50, 60],
            [2000, 1956, 40, 50],
            [2000, 1957, 70, 70],
            [2000, 1959, 120, 90],
            [2000, 1961, 120, 90],
            [2000, 1962, 15.89, 20.58],
            [2000, 1963, 7.89, 5.56],
            [2000, 1964, 79.54, 41.58],
            [2000, 1965, 50, 59.43],
            [2000, 1967, 70, 70],
            [2000, 1969, 70, 70],
            [2000, 1972, 8.68, 7.21],
            [2000, 1974, 70, 70],
            [2000, 1976, 9.37, 9.9],
            [2000, 1978, 70, 70],
            [2000, 1979, 50, 60],
            [2000, 1980, 120, 90],
            [2000, 1981, 70.08, 70],
            [2000, 1982, 70, 70],
            [2000, 1984, 70, 70],
            [2000, 1986, 120, 90],
            [2000, 1989, 50, 60],
            [2000, 1991, 11.55, 8.24],
            [2000, 1992, 50.97, 29.55],
            [2000, 1995, 43.54, 34.8],
            [2000, 1996, 120, 90],
            [2000, 1997, 120, 90],
            [2000, 1998, 7.33, 8.42],
            [2000, 2000, 17.52, 8.25],
            [2000, 2001, 63.05, 65.31],
            [2000, 2002, 50, 60],
            [2000, 2004, 8.73, 6.08],
            [2000, 2005, 117.44, 37.08],
            [2000, 2006, 20.36, 23.58],
            [2000, 2007, 70, 70],
            [2000, 2008, 70, 70],
            [2000, 2009, 58, 70],
            [2000, 2011, 12, 18],
            [2000, 2012, 70, 70],
            [2000, 2013, 38.69, 111.03],
            [2000, 2015, 20.41, 16.91],
            [2000, 2016, 50, 60],
            [2000, 2017, 40, 37.5],
            [2000, 2018, 12, 18],
            [2000, 2020, 70, 70],
            [2000, 2021, 91.08, 54.55],
            [2000, 2022, 120, 90],
            [2000, 2023, 12.93, 13.98],
            [2000, 2025, 47.08, 35.03],
            [2000, 2026, 122.65, 67.48],
            [2000, 2027, 120, 90],
            [2000, 2028, 120, 90],
            [2000, 2029, 61.44, 42.57],
            [2000, 2030, 50, 60],
            [2000, 2031, 6.44, 5.6],
            [2000, 2032, 29.96, 39.24],
            [2000, 2034, 120, 90],
            [2000, 2035, 70, 70],
            [2000, 2038, 120, 90],
            [2000, 2040, 120, 90],
            [2000, 2041, 120, 90],
            [2000, 2042, 27.63, 11.76],
            [2000, 2044, 120, 90],
            [2000, 2046, 50, 60],
            [2000, 2048, 13.1, 28.8],
            [2000, 2049, 70, 70],
            [2000, 2050, 11, 25],
            [2000, 2051, 120, 90],
            [2000, 2052, 120, 90],
            [2000, 2053, 70, 70],
            [2000, 2054, 21.44, 20.37],
            [2000, 2055, 70, 70],
            [2000, 2056, 50, 60],
            [2000, 2057, 120, 90],
            [2000, 2058, 7.15, 5.43],
            [2000, 2059, 11.86, 8.19],
            [2000, 2060, 70, 70],
            [2000, 2061, 70, 70],
            [2000, 2062, 120, 90],
            [2000, 2063, 84.41, 70],
            [2000, 2064, 61.23, 37.87],
            [2000, 2066, 120, 90],
            [2000, 2068, 70, 70],
            [2000, 2070, 19.34, 6.55],
            [2000, 2071, 120, 90],
            [2000, 2072, 120, 90],
            [2000, 2073, 120, 90],
            [2000, 2074, 70, 70],
            [2000, 2075, 45, 70],
            [2000, 2076, 70, 70],
            [2000, 2077, 120, 90],
            [2000, 2081, 41.13, 34.16],
            [2000, 2083, 120, 90],
            [2000, 2084, 23.59, 36.63],
            [2000, 2085, 9.03, 8.79],
            [2000, 2087, 70, 70],
            [2000, 2089, 50, 60],
            [2000, 2090, 120, 90],
            [2000, 2091, 120, 90],
            [2000, 2095, 70, 70],
            [2000, 2096, 120, 90],
            [2000, 2097, 50, 60],
            [2000, 2098, 40, 50],
            [2000, 2099, 83.99, 31.46],
            [2000, 2100, 71.04, 24.35],
            [2000, 2101, 30.58, 16.13],
            [2000, 2103, 11.08, 12.74],
            [2000, 2104, 111.3, 45.15],
            [2000, 2105, 120, 90],
            [2000, 2106, 40.17, 51.44],
            [2000, 2107, 120, 90],
            [2000, 2110, 40, 50],
            [2000, 2112, 70, 70],
            [2000, 2115, 70, 70],
            [2000, 2116, 50, 60],
            [2000, 2119, 7.29, 9.02],
            [2000, 2121, 28, 32.4],
            [2000, 2122, 70, 70],
            [2000, 2125, 120, 90],
            [2000, 2126, 50, 60],
            [2000, 2127, 19.02, 24.51],
            [2000, 2128, 32.1, 29.68],
            [2000, 2130, 120, 90],
            [2000, 2131, 65.5, 56.7],
            [2000, 2132, 19.44, 12.24],
            [2000, 2134, 70, 70],
            [2000, 2135, 22.3, 28.8],
            [2000, 2136, 70, 70],
            [2000, 2137, 70, 70],
            [2000, 2138, 24.24, 22.96],
            [2000, 2139, 70, 70],
            [2000, 2140, 40, 50],
            [2000, 2142, 5.59, 1.96],
            [2000, 2144, 37.3, 75.7],
            [2000, 2146, 70, 70],
            [2000, 2147, 120, 90],
            [2000, 2148, 95.28, 70],
            [2000, 2149, 120, 90],
            [2000, 2150, 120, 90],
            [2000, 2151, 40.63, 26.2],
            [2000, 2152, 120, 90],
            [2000, 2154, 120, 90],
            [2000, 2155, 120, 90],
            [2000, 2156, 43.59, 31.42],
            [2000, 2159, 120, 90],
            [2000, 2161, 50, 60],
            [2000, 2162, 27.58, 30.03],
            [2000, 2163, 120, 90],
            [2000, 2164, 22, 26.1],
            [2000, 2166, 120, 90],
            [2000, 2167, 10.33, 10.88],
            [2000, 2169, 70, 70],
            [2000, 2170, 50.17, 28.05],
            [2000, 2171, 120, 90],
            [2000, 2174, 40.28, 40.83],
            [2000, 2177, 8.15, 8.97],
            [2000, 2178, 16.1, 27],
            [2000, 2179, 26, 37.8],
            [2000, 2180, 31.07, 14.75],
            [2000, 2181, 57.35, 74.71],
            [2000, 2182, 120, 90],
            [2000, 2184, 40, 50],
            [2000, 2186, 50, 60],
            [2000, 2187, 120, 90],
            [2000, 2190, 70, 70],
            [2000, 2191, 120, 90],
            [2000, 2197, 120, 90],
            [2000, 2198, 40, 50],
            [2000, 2199, 120, 90],
            [2000, 2200, 85.49, 90],
            [2000, 2201, 23.77, 27.53],
            [2000, 2203, 11.11, 8.84],
            [2000, 2204, 14.98, 8.4],
            [2000, 2205, 120, 90],
            [2000, 2208, 81.25, 48.76],
            [2000, 2212, 70, 70],
            [2000, 2213, 50, 60],
            [2000, 2214, 1.27, 0.88],
            [2000, 2216, 25.21, 17.4],
            [2000, 2217, 120, 90],
            [2000, 2219, 120, 90],
            [2000, 2220, 34.09, 21.45],
            [2000, 2223, 40, 50],
            [2000, 2224, 36.28, 36.4],
            [2000, 2225, 50, 60],
            [2000, 2226, 120, 90],
            [2000, 2227, 39.22, 33.66],
            [2000, 2228, 50, 60],
            [2000, 2230, 120, 90],
            [2000, 2231, 120, 90],
            [2000, 2232, 28.52, 48.27],
            [2000, 2233, 22.35, 13.45],
            [2000, 2235, 50, 60],
            [2000, 2236, 24.63, 27.62],
            [2000, 2237, 120, 90],
            [2000, 2238, 45.83, 36.77],
            [2000, 2239, 21.85, 11.47],
            [2000, 2240, 120, 90],
            [2000, 2241, 14.63, 9.52],
            [2000, 2242, 91.6, 70],
            [2000, 2243, 120, 90],
            [2000, 2244, 38, 31.98],
            [2000, 2245, 70, 70],
            [2000, 2247, 50, 60],
            [2000, 2248, 40, 50],
            [2000, 2249, 120, 90],
            [2000, 2250, 50, 60],
            [2000, 2252, 70, 70],
            [2000, 2253, 14.51, 10.23],
            [2000, 2254, 70, 70],
            [2000, 2255, 37.27, 60.05],
            [2000, 2256, 70, 70],
            [2000, 2258, 70.97, 39.98],
            [2000, 2259, 2, 1],
            [2000, 2260, 70, 70],
            [2000, 2262, 70, 70],
            [2000, 2265, 120, 90],
            [2000, 2267, 7.26, 3.97],
            [2000, 2268, 120, 90],
            [2000, 2269, 70, 70],
            [2000, 2270, 120, 90],
            [2000, 2271, 6.34, 5.21],
            [2000, 2273, 92.69, 76.05],
            [2000, 2274, 70, 70],
            [2000, 2277, 50, 33.82],
            [2000, 2280, 8.57, 5.83],
            [2000, 2281, 120, 90],
            [2000, 2282, 34.6, 40.1],
            [2000, 2283, 120, 90],
            [2000, 2284, 70, 70],
            [2000, 2285, 40, 50],
            [2000, 2286, 70, 70],
            [2000, 2289, 120, 90],
            [2000, 2290, 120, 90],
            [2000, 2292, 120, 90],
            [2000, 2293, 109.99, 52.3],
            [2000, 2294, 50, 60],
            [2000, 2295, 120, 90],
            [2000, 2297, 153.15, 64.3],
            [2000, 2300, 50, 60],
            [2000, 2301, 92.47, 70],
            [2000, 2302, 120, 90],
            [2000, 2303, 56.37, 41.39],
            [2000, 2304, 70, 70],
            [2000, 2305, 120, 90],
            [2000, 2306, 50, 60],
            [2000, 2311, 45, 45],
            [2000, 2312, 40.7, 39.93],
            [2000, 2314, 120, 90],
            [2000, 2316, 70, 70],
            [2000, 2317, 120, 90],
            [2000, 2319, 50, 60],
            [2000, 2320, 8.59, 8.74],
            [2000, 2321, 120, 90],
            [2000, 2323, 70, 70],
            [2000, 2325, 120, 90],
            [2000, 2326, 120, 90],
            [2000, 2327, 120, 90],
            [2000, 2328, 70, 70],
            [2000, 2332, 30.96, 25.63],
            [2000, 2335, 57.22, 73.4],
            [2000, 2336, 120, 90],
            [2000, 2337, 120, 90],
            [2000, 2338, 70, 70],
            [2000, 2339, 120, 90],
            [2000, 2340, 120, 90],
            [2000, 2341, 70, 70],
            [2000, 2342, 70, 70],
            [2000, 2343, 57.74, 26.83],
            [2000, 2346, 70, 70],
            [2000, 2347, 120, 90],
            [2000, 2348, 37, 70],
            [2000, 2349, 92.7, 76.05],
            [2000, 2352, 50, 60],
            [2000, 2356, 226.56, 56.42],
            [2000, 2359, 50, 60],
            [2000, 2363, 30.54, 20.65],
            [2000, 2364, 70, 70],
            [2000, 2366, 16.78, 17.31],
            [2000, 2367, 59.45, 50.23],
            [2000, 2368, 70, 70],
            [2000, 2371, 70, 70],
            [2000, 2372, 30, 45],
            [2000, 2373, 70, 70],
            [2000, 2374, 12.45, 9.91],
            [2000, 2375, 120, 90],
            [2000, 2378, 20.26, 18.12],
            [2000, 2382, 70, 70],
            [2000, 2383, 91.39, 52.48],
            [2000, 2384, 30, 45],
            [2000, 2385, 70, 70],
            [2000, 2387, 40, 50],
            [2000, 2388, 70, 70],
            [2000, 2390, 120, 90],
            [2000, 2391, 70, 70],
            [2000, 2392, 7.85, 7.64],
            [2000, 2394, 50, 60],
            [2000, 2396, 120, 90],
            [2000, 2397, 120, 90],
            [2000, 2398, 120, 90],
            [2000, 2399, 120, 90],
            [2000, 2401, 9.42, 9.69],
            [2000, 2402, 70, 70],
            [2000, 2404, 120, 90],
            [2000, 2405, 22.61, 36.11],
            [2000, 2406, 120, 90],
            [2000, 2407, 120, 90],
            [2000, 2408, 50, 60],
            [2000, 2409, 9.5, 15.2],
            [2000, 2410, 55.09, 24],
            [2000, 2411, 9.59, 8.49],
            [2000, 2412, 6.63, 7.08],
            [2000, 2413, 120, 90],
            [2000, 2414, 8.64, 7.09],
            [2000, 2416, 120, 90],
            [2000, 2420, 120, 90],
            [2000, 2423, 70, 70],
            [2000, 2424, 70, 90],
            [2000, 2425, 52.54, 35],
            [2000, 2428, 10.11, 12.8],
            [2000, 2429, 12, 18],
            [2000, 2430, 70, 70],
            [2000, 2433, 70, 70],
            [2000, 2434, 70, 70],
            [2000, 2435, 22.35, 18.73],
            [2000, 2436, 17.93, 15],
            [2000, 2437, 9.73, 8.67],
            [2000, 2438, 120, 90],
            [2000, 2439, 70, 70],
            [2000, 2440, 5.64, 5.78],
            [2000, 2441, 120, 90],
            [2000, 2442, 12, 18],
            [2000, 2443, 70, 70],
            [2000, 2444, 120, 90],
            [2000, 2447, 34.36, 17.02],
            [2000, 2448, 120, 90],
            [2000, 2449, 120, 90],
            [2000, 2452, 70, 70],
            [2000, 2454, 120, 90],
            [2000, 2456, 70, 70],
            [2000, 2458, 42.99, 19.09],
            [2000, 2459, 32.63, 40.69],
            [2000, 2462, 120, 90],
            [2000, 2465, 120, 90],
            [2000, 2466, 120, 90],
            [2000, 2467, 12, 21.72],
            [2000, 2468, 22.08, 35.99],
            [2000, 2470, 120, 90],
            [2000, 2471, 120, 90],
            [2000, 2472, 78.4, 34.97],
            [2000, 2473, 120, 90],
            [2000, 2474, 120, 90],
            [2000, 2475, 123.12, 70],
            [2000, 2476, 120, 90],
            [2000, 2477, 70, 70],
            [2000, 2478, 120, 90],
            [2000, 2479, 50, 60],
            [2000, 2480, 25.72, 16.26],
            [2000, 2481, 50, 60],
            [2000, 2482, 120, 90],
            [2000, 2483, 120, 90],
            [2000, 2484, 120, 90],
            [2000, 2485, 26.73, 30.59],
            [2000, 2486, 70, 70],
            [2000, 2487, 70, 70],
            [2000, 2488, 53.21, 52.23],
            [2000, 2490, 70.38, 70],
            [2000, 2493, 109.42, 45.47],
            [2000, 2494, 85.78, 39.36],
            [2000, 2495, 40, 50],
            [2000, 2496, 120, 90],
            [2000, 2497, 40.2, 11.31],
            [2000, 2499, 13.19, 8.58],
            [2000, 2500, 14.55, 14.52],
            [2000, 2501, 70, 70],
            [2000, 2503, 40, 60],
            [2000, 2504, 120, 90],
            [2000, 2505, 70, 70],
            [2000, 2507, 120, 90],
            [2000, 2508, 70, 70],
            [2000, 2509, 21.55, 18.6],
            [2000, 2510, 70, 70],
            [2000, 2511, 120, 90],
            [2000, 2512, 120, 90],
            [2000, 2513, 7, 18.7],
            [2000, 2514, 120, 90],
            [2000, 2515, 50, 60],
            [2000, 2516, 33.27, 33.84],
            [2000, 2518, 74.82, 43.44],
            [2000, 2519, 120, 90],
            [2000, 2520, 70, 70],
            [2000, 2521, 50, 60],
            [2000, 2524, 10.39, 13.16],
            [2000, 2525, 70, 70],
            [2000, 2526, 70, 70],
            [2000, 2527, 46.45, 44.76],
            [2000, 2528, 120, 90],
            [2000, 2529, 43.73, 38.98],
            [2000, 2530, 70, 70],
            [2000, 2532, 70, 70],
            [2000, 2533, 23.69, 46.33],
            [2000, 2534, 120, 90],
            [2000, 2535, 5.38, 6.5],
            [2000, 2536, 5.45, 5.06],
            [2000, 2537, 120, 90],
            [2000, 2539, 70, 30.72],
            [2000, 2540, 19.62, 27.9],
            [2000, 2542, 34.79, 22.79],
            [2000, 2543, 27.67, 25],
            [2000, 2545, 40, 50],
            [2000, 2546, 70, 70],
            [2000, 2547, 17.63, 16.94],
            [2000, 2548, 70, 70],
            [2000, 2549, 70, 70],
            [2000, 2551, 71.76, 36.27],
            [2000, 2553, 70, 70],
            [2000, 2554, 16.72, 26.29],
            [2000, 2555, 52.5, 52.5],
            [2000, 2558, 40, 50],
            [2000, 2562, 111.85, 42.43],
            [2000, 2563, 61.13, 37.95],
            [2000, 2564, 33.39, 72.42],
            [2000, 2565, 40, 50],
            [2000, 2566, 10.13, 8.41],
            [2000, 2568, 70, 70],
            [2000, 2569, 34.08, 20.39],
            [2000, 2571, 50, 60],
            [2000, 2572, 120, 90],
            [2000, 2574, 107.79, 57.67],
            [2000, 2575, 70, 70],
            [2000, 2576, 70, 70],
            [2000, 2577, 16.06, 11.33],
            [2000, 2578, 28.35, 12.83],
            [2000, 2580, 120, 90],
            [2000, 2582, 70, 70],
            [2000, 2584, 120, 90],
            [2000, 2585, 70, 58.43],
            [2000, 2587, 66.78, 50.99],
            [2000, 2589, 70, 70],
            [2000, 2590, 120, 90],
            [2000, 2591, 120, 90],
            [2000, 2592, 120, 90],
            [2000, 2593, 109.49, 44.64],
            [2000, 2595, 70, 70],
            [2000, 2596, 120, 90],
            [2000, 2597, 40, 50],
            [2000, 2598, 70, 70],
            [2000, 2600, 50, 60],
            [2000, 2601, 70, 70],
            [2000, 2603, 120, 90],
            [2000, 2604, 27.78, 27.06],
            [2000, 2606, 18.48, 15.38],
            [2000, 2607, 14.85, 16.55],
            [2000, 2608, 70, 70],
            [2000, 2610, 70, 70],
            [2000, 2612, 44.84, 32.36],
            [2000, 2613, 120, 90],
            [2000, 2615, 80.55, 54.14],
            [2000, 2617, 17.59, 35.03],
            [2000, 2619, 57.48, 50.98],
            [2000, 2620, 50, 60],
            [2000, 2621, 120, 90],
            [2000, 2622, 22.29, 20.66],
            [2000, 2623, 36.98, 28.35],
            [2000, 2624, 120, 90],
            [2000, 2627, 70, 70],
            [2000, 2628, 49.77, 79.26],
            [2000, 2630, 120, 90],
            [2000, 2631, 70, 70],
            [2000, 2632, 22.83, 26.19],
            [2000, 2633, 30.65, 46.26],
            [2000, 2634, 130.51, 90],
            [2000, 2635, 12, 22.39],
            [2000, 2636, 105.09, 70],
            [2000, 2638, 70, 70],
            [2000, 2639, 9.66, 9.9],
            [2000, 2642, 120, 90],
            [2000, 2644, 71.93, 71.93],
            [2000, 2646, 30, 45],
            [2000, 2647, 51.91, 54.1],
            [2000, 2649, 50, 60],
            [2000, 2650, 120, 90],
            [2000, 2651, 32.4, 19.95],
            [2000, 2652, 37.5, 45],
            [2000, 2653, 70, 70],
            [2000, 2655, 40, 50],
            [2000, 2656, 50.2, 42.1],
            [2000, 2658, 73.53, 35.42],
            [2000, 2660, 40, 50],
            [2000, 2661, 70, 70],
            [2000, 2663, 50, 60],
            [2000, 2664, 11, 16.7],
            [2000, 2665, 70, 70],
            [2000, 2667, 63.81, 52.19],
            [2000, 2668, 50.55, 38.31],
            [2000, 2669, 75, 64.66],
            [2000, 2670, 70, 70],
            [2000, 2671, 50, 45],
            [2000, 2672, 13.43, 14.62],
            [2000, 2677, 70, 70],
            [2000, 2681, 70, 70],
            [2000, 2682, 120, 90],
            [2000, 2683, 9.17, 6.35],
            [2000, 2684, 70.83, 69.48],
            [2000, 2685, 50, 60],
            [2000, 2686, 9.12, 8.12],
            [2000, 2687, 94.14, 34.56],
            [2000, 2691, 50, 60],
            [2000, 2692, 70, 70],
            [2000, 2694, 120, 90],
            [2000, 2695, 12, 18],
            [2000, 2696, 70, 70],
            [2000, 2697, 120, 90],
            [2000, 2703, 50, 60],
            [2000, 2704, 10.96, 9.94],
            [2000, 2706, 120, 90],
            [2000, 2707, 70, 70],
            [2000, 2710, 18.57, 12.32],
            [2000, 2711, 50, 60],
            [2000, 2712, 87.13, 70],
            [2000, 2713, 80, 145],
            [2000, 2714, 50, 60],
            [2000, 2716, 70, 70],
            [2000, 2719, 70, 70],
            [2000, 2720, 46, 38.9],
            [2000, 2722, 120, 90],
            [2000, 2723, 70, 70],
            [2000, 2725, 70, 70],
            [2000, 2726, 120.52, 25.63],
            [2000, 2728, 120, 90],
            [2000, 2730, 76.1, 66.81],
            [2000, 2731, 120, 90],
            [2000, 2734, 50, 50],
            [2000, 2735, 6.21, 6.8],
            [2000, 2736, 30, 45],
            [2000, 2737, 40, 50],
            [2000, 2738, 40, 37.5],
            [2000, 2739, 50, 60],
            [2000, 2740, 120, 90],
            [2000, 2741, 70, 70],
            [2000, 2743, 27.47, 30.75],
            [2000, 2746, 70, 70],
            [2000, 2747, 59.05, 33.48],
            [2000, 2748, 123.58, 59.04],
            [2000, 2750, 30, 45],
            [2000, 2752, 70, 70],
            [2000, 2753, 50, 60],
            [2000, 2755, 120, 90],
            [2000, 2756, 67, 70],
            [2000, 2757, 120, 90],
            [2000, 2758, 36.94, 36.69],
            [2000, 2759, 120, 90],
            [2000, 2760, 120, 90],
            [2000, 2762, 120, 90],
            [2000, 2763, 120, 90],
            [2000, 2764, 70, 70],
            [2000, 2765, 120, 90],
            [2000, 2766, 8.32, 6.64],
            [2000, 2767, 120, 90],
            [2000, 2768, 120, 90],
            [2000, 2770, 120, 90],
            [2000, 2772, 70, 70],
            [2000, 2773, 50, 60],
            [2000, 2774, 120, 90],
            [2000, 2775, 70, 70],
            [2000, 2778, 70, 70],
            [2000, 2781, 9.91, 6.13],
            [2000, 2782, 64.72, 61.32],
            [2000, 2783, 70, 70],
            [2000, 2784, 103.9, 81.72],
            [2000, 2785, 5.56, 14],
            [2000, 2786, 70, 70],
            [2000, 2787, 64.37, 35.05],
            [2000, 2788, 99.81, 58.02],
            [2000, 2791, 30, 37.5],
            [2000, 2792, 120, 90],
            [2000, 2793, 40, 50],
            [2000, 2795, 70, 70],
            [2000, 2796, 70, 70],
            [2000, 2797, 38.38, 16.45],
            [2000, 2798, 12, 21.53],
            [2000, 2800, 85.82, 80.02],
            [2000, 2801, 120, 90],
            [2000, 2804, 16.93, 11.94],
            [2000, 2806, 70, 70],
            [2000, 2807, 36.77, 11.92],
            [2000, 2808, 50, 60],
            [2000, 2809, 120, 90],
            [2000, 2811, 34.31, 28.04],
            [2000, 2813, 34.06, 29.31],
            [2000, 2814, 120, 90],
            [2000, 2818, 9.74, 14.61],
            [2000, 2819, 11.84, 8.58],
            [2000, 2820, 70, 70],
            [2000, 2821, 70, 70],
            [2000, 2822, 40, 50],
            [2000, 2823, 29.35, 32.47],
            [2000, 2826, 40, 50],
            [2000, 2827, 13.13, 23.21],
            [2000, 2831, 120, 90],
            [2000, 2832, 23.2, 22.2],
            [2000, 2833, 65.79, 46.49],
            [2000, 2834, 50, 60],
            [2000, 2835, 37.5, 45],
            [2000, 2836, 36.81, 31.39],
            [2000, 2837, 120, 90],
            [2000, 2838, 120, 90],
            [2000, 2839, 120, 90],
            [2000, 2841, 120, 90],
            [2000, 2844, 70, 70],
            [2000, 2845, 120, 90],
            [2000, 2846, 40, 23.06],
            [2000, 2847, 30, 45],
            [2000, 2850, 50, 60],
            [2000, 2851, 75.14, 53.01],
            [2000, 2852, 37.5, 45],
            [2000, 2853, 79.31, 70],
            [2000, 2854, 14.43, 16.56],
            [2000, 2856, 124.74, 77.59],
            [2000, 2857, 120, 90],
            [2000, 2861, 50, 60],
            [2000, 2862, 70, 70],
            [2000, 2863, 25.3, 31],
            [2000, 2864, 120, 90],
            [2000, 2865, 120, 90],
            [2000, 2866, 50, 60],
            [2000, 2867, 120, 90],
            [2000, 2869, 5.93, 4.86],
            [2000, 2871, 120, 90],
            [2000, 2872, 14.38, 10.62],
            [2000, 2876, 106.83, 78.93],
            [2000, 2877, 120, 90],
            [2000, 2878, 120, 90],
            [2000, 2879, 50, 60],
            [2000, 2880, 39, 52.5],
            [2000, 2882, 120, 90],
            [2000, 2883, 48.97, 31.48],
            [2000, 2884, 102.9, 57.89],
            [2000, 2885, 164.05, 83.42],
            [2000, 2886, 70, 70],
            [2000, 2887, 70, 70],
            [2000, 2889, 70, 70],
            [2000, 2890, 120, 90],
            [2000, 2891, 120, 90],
            [2000, 2893, 120, 90],
            [2000, 2894, 120, 90],
            [2000, 2897, 120, 90],
            [2000, 2899, 98.66, 70],
            [2000, 2900, 50, 60],
            [2000, 2901, 107.65, 88.66],
            [2000, 2902, 120, 90],
            [2000, 2903, 120, 90],
            [2000, 2904, 65, 40.54],
            [2000, 2905, 50, 60],
            [2000, 2906, 120, 90],
            [2000, 2907, 11.65, 11.52],
            [2000, 2908, 70, 70],
            [2000, 2910, 41.38, 37.74],
            [2000, 2911, 120, 90],
            [2000, 2914, 70, 70],
            [2000, 2916, 70, 70],
            [2000, 2917, 50, 60],
            [2000, 2918, 17.8, 10.33],
            [2000, 2919, 120, 90],
            [2000, 2921, 120, 90],
            [2000, 2922, 16, 18],
            [2000, 2923, 56.16, 71.39],
            [2000, 2924, 120, 90],
            [2000, 2925, 120, 90],
            [2000, 2928, 70, 70],
            [2000, 2929, 35.62, 43.31],
            [2000, 2930, 70, 70],
            [2000, 2931, 70, 70],
            [2000, 2932, 30, 24.3],
            [2000, 2933, 70, 70],
            [2000, 2934, 57.1, 29.4],
            [2000, 2935, 120, 90],
            [2000, 2936, 90.08, 68.66],
            [2000, 2937, 120, 90],
            [2000, 2940, 120, 90],
            [2000, 2942, 70, 70],
            [2000, 2943, 120, 90],
            [2000, 2944, 50, 60],
            [2000, 2946, 117.5, 74.87],
            [2000, 2948, 61.55, 60],
            [2000, 2950, 116.48, 55.12],
            [2000, 2951, 120, 90],
            [2000, 2952, 70, 70],
            [2000, 2955, 70, 70],
            [2000, 2956, 30.2, 34.9],
            [2000, 2957, 120, 90],
            [2000, 2958, 70, 70],
            [2000, 2960, 50, 60],
            [2000, 2961, 50, 60],
            [2000, 2962, 40, 50],
            [2000, 2963, 120, 90],
            [2000, 2964, 50, 60],
            [2000, 2965, 120, 90],
            [2000, 2969, 15.24, 25.59],
            [2000, 2971, 70, 70],
            [2000, 2972, 120, 90],
            [2000, 2973, 70, 65],
            [2000, 2974, 22.89, 34.75],
            [2000, 2975, 70, 70],
            [2000, 2976, 120, 90],
            [2000, 2978, 24.61, 18.48],
            [2000, 2979, 27.1, 18.5],
            [2000, 2980, 21.22, 18.94],
            [2000, 2982, 40, 50],
            [2000, 2984, 13.6, 13.23],
            [2000, 2985, 50, 60],
            [2000, 2986, 120, 90],
            [2000, 2988, 120, 90],
            [2000, 2989, 50, 60],
            [2000, 2991, 50, 60],
            [2000, 2995, 26.5, 30.18],
            [2000, 2997, 11.88, 8.2],
            [2000, 2999, 6.02, 5.8],
            [2000, 3000, 53.82, 60],
            [2000, 3001, 56.14, 45.79],
            [2000, 3002, 126.06, 90],
            [2000, 3003, 120, 90],
            [2000, 3004, 36.81, 97.97],
            [2000, 3006, 70, 70],
            [2000, 3008, 28.3, 32.4],
            [2000, 3009, 50, 60],
            [2000, 3011, 15.65, 30],
            [2000, 3012, 70, 70],
            [2000, 3014, 120, 90],
            [2000, 3015, 30, 37.5],
            [2000, 3016, 44.41, 35.25],
            [2000, 3017, 120, 90],
            [2000, 3019, 50, 60],
            [2000, 3022, 120, 90],
            [2000, 3024, 70, 70],
            [2000, 3025, 70, 70],
            [2000, 3026, 12.16, 8.01],
            [2000, 3027, 22, 43.41],
            [2000, 3031, 50, 60],
            [2000, 3033, 120, 90],
            [2000, 3035, 25.46, 23.67],
            [2000, 3037, 50, 60],
            [2000, 3041, 52.5, 52.5],
            [2000, 3042, 5.83, 5.64],
            [2000, 3043, 74.42, 70],
            [2000, 3044, 70, 70],
            [2000, 3045, 120, 90],
            [2000, 3046, 50.66, 21.51],
            [2000, 3047, 50, 60],
            [2000, 3048, 101.09, 97.17],
            [2000, 3049, 120, 90],
            [2000, 3050, 27.97, 29.63],
            [2000, 3051, 120, 90],
            [2000, 3052, 50, 60],
            [2000, 3053, 70, 70],
            [2000, 3054, 50, 60],
            [2000, 3055, 120, 90],
            [2000, 3056, 15.98, 16.7],
            [2000, 3057, 70, 70],
            [2000, 3058, 71.08, 70],
            [2000, 3059, 120, 90],
            [2000, 3060, 70, 70],
            [2000, 3061, 128.24, 46.52],
            [2000, 3063, 70, 70],
            [2000, 3064, 50, 60],
            [2000, 3066, 70, 70],
            [2000, 3069, 120, 90],
            [2000, 3070, 56.43, 49.17],
            [2000, 3073, 120, 90],
            [2000, 3076, 120, 90],
            [2000, 3077, 39.42, 34.65],
            [2000, 3078, 70, 70],
            [2000, 3079, 70, 70],
            [2000, 3084, 70, 70],
            [2000, 3085, 50, 50],
            [2000, 3086, 97.92, 38.7],
            [2000, 3087, 70, 70],
            [2000, 3089, 38.17, 24],
            [2000, 3090, 50, 60],
            [2000, 3091, 19.67, 20.1],
            [2000, 3092, 70, 70],
            [2000, 3095, 120, 90],
            [2000, 3098, 29.85, 64.97],
            [2000, 3100, 120, 90],
            [2000, 3101, 120, 90],
            [2000, 3104, 7.73, 6.59],
            [2000, 3105, 70, 70],
            [2000, 3106, 34.5, 25.1],
            [2000, 3107, 120, 90],
            [2000, 3109, 50, 60],
            [2000, 3112, 87.4, 44.91],
            [2000, 3113, 50, 60],
            [2000, 3114, 120, 90],
            [2000, 3115, 120, 90],
            [2000, 3117, 50, 60],
            [2000, 3118, 120, 90],
            [2000, 3119, 12.2, 16.8],
            [2000, 3121, 64.93, 30.4],
            [2000, 3122, 62.93, 34.45],
            [2000, 3123, 120, 90],
            [2000, 3126, 70, 70],
            [2000, 3127, 9.37, 9.65],
            [2000, 3128, 47, 50],
            [2000, 3129, 53.29, 36.48],
            [2000, 3130, 12, 10],
            [2000, 3131, 8.27, 8.03],
            [2000, 3132, 120, 90],
            [2000, 3133, 60.55, 31.38],
            [2000, 3134, 50, 45],
            [2000, 3135, 120, 90],
            [2000, 3136, 40, 50],
            [2000, 3137, 20.3, 19.5],
            [2000, 3138, 120, 90],
            [2000, 3139, 5.88, 5.48],
            [2000, 3140, 70, 70],
            [2000, 3141, 50, 60],
            [2000, 3142, 40, 50],
            [2000, 3143, 70, 70],
            [2000, 3144, 120, 90],
            [2000, 3148, 33.08, 29.22],
            [2000, 3149, 120, 90],
            [2000, 3151, 120, 90],
            [2000, 3152, 50, 60],
            [2000, 3154, 87.45, 60.56],
            [2000, 3155, 98.27, 51.32],
            [2000, 3158, 18, 18],
            [2000, 3160, 22.3, 61.32],
            [2000, 3161, 12.56, 13.35],
            [2000, 3163, 70, 70],
            [2000, 3164, 70, 70],
            [2000, 3165, 70, 45.26],
            [2000, 3166, 0.17, 0.59],
            [2000, 3167, 29.9, 16.62],
            [2000, 3168, 120, 90],
            [2000, 3171, 40, 50],
            [2000, 3172, 120, 90],
            [2000, 3175, 73.26, 36.41],
            [2000, 3177, 37.5, 45],
            [2000, 3181, 8.14, 6.4],
            [2000, 3182, 22.27, 15.36],
            [2000, 3183, 51.17, 40.2],
            [2000, 3184, 70, 70],
            [2000, 3187, 24.7, 20.1],
            [2000, 3188, 25.17, 19.72],
            [2000, 3189, 192.54, 70.66],
            [2000, 3190, 26.99, 20.03],
            [2000, 3191, 70, 70],
            [2000, 3192, 120, 90],
            [2000, 3195, 24.49, 21.37],
            [2000, 3196, 70, 70],
            [2000, 3197, 99.63, 37.69],
            [2000, 3198, 9.06, 10.25],
            [2000, 3199, 70, 70],
            [2000, 3200, 40, 50],
            [2000, 3203, 12.22, 10.64],
            [2000, 3206, 60.72, 58.05],
            [2000, 3207, 50, 60],
            [2000, 3208, 120, 90],
            [2000, 3211, 70, 70],
            [2000, 3212, 120, 90],
            [2000, 3214, 70, 70],
            [2000, 3216, 120, 90],
            [2000, 3217, 42.15, 37.9],
            [2000, 3219, 10.36, 9.85],
            [2000, 3220, 120, 90],
            [2000, 3221, 70, 70],
            [2000, 3225, 6.02, 7.89],
            [2000, 3227, 25, 20],
            [2000, 3228, 72.06, 47.49],
            [2000, 3229, 120, 90],
            [2000, 3231, 19.83, 26.04],
            [2000, 3234, 37.45, 21.3],
            [2000, 3239, 120, 90],
            [2000, 3240, 120, 90],
            [2000, 3241, 50, 60],
            [2000, 3242, 70, 70],
            [2000, 3243, 12.14, 9.5],
            [2000, 3244, 120, 90],
            [2000, 3246, 65.38, 60.87],
            [2000, 3247, 120, 90],
            [2000, 3248, 40, 17.83],
            [2000, 3249, 120, 90],
            [2000, 3251, 40, 50],
            [2000, 3252, 50, 60],
            [2000, 3253, 70, 70],
            [2000, 3254, 40.73, 38.06],
            [2000, 3255, 70, 70],
            [2000, 3256, 30.27, 22.34],
            [2000, 3257, 50, 60],
            [2000, 3258, 70, 70],
            [2000, 3259, 50, 60],
            [2000, 3260, 10, 13.06],
            [2000, 3262, 70, 70],
            [2000, 3263, 120, 90],
            [2000, 3264, 21.89, 30.71],
            [2000, 3265, 120, 90],
            [2000, 3266, 86.9, 70],
            [2000, 3267, 50, 60],
            [2000, 3268, 60.02, 38.25],
            [2000, 3270, 17.3, 14.21],
            [2000, 3271, 120, 90],
            [2000, 3272, 101.18, 75.84],
            [2000, 3273, 120, 90],
            [2000, 3274, 45, 32.77],
            [2000, 3275, 120, 90],
            [2000, 3276, 120, 90],
            [2000, 3277, 91.74, 42.99],
            [2000, 3278, 63.11, 20.86],
            [2000, 3279, 70, 70],
            [2000, 3280, 59.87, 41.55],
            [2000, 3283, 12.69, 12.13],
            [2000, 3284, 42.57, 30.98],
            [2000, 3286, 15.7, 9.65],
            [2000, 3287, 50, 60],
            [2000, 3288, 30.42, 23.34],
            [2000, 3289, 85, 70],
            [2000, 3290, 21.59, 14.57],
            [2000, 3292, 120, 90],
            [2000, 3293, 70, 70],
            [2000, 3294, 50, 60],
            [2000, 3295, 120, 90],
            [2000, 3296, 30, 45],
            [2000, 3300, 70, 70],
            [2000, 3301, 70, 70],
            [2000, 3302, 40, 50],
            [2000, 3303, 70, 70],
            [2000, 3305, 120, 90],
            [2000, 3306, 24.91, 27.22],
            [2000, 3308, 70, 70],
            [2000, 3309, 50, 45],
            [2000, 3312, 70, 70],
            [2000, 3313, 120, 90],
            [2000, 3314, 50, 60],
            [2000, 3315, 120, 90],
            [2000, 3316, 120, 90],
            [2000, 3318, 70, 70],
            [2000, 3319, 70, 70],
            [2000, 3320, 120, 90],
            [2000, 3321, 50, 60],
            [2000, 3322, 120, 90],
            [2000, 3324, 9.8, 13.83],
            [2000, 3325, 38.61, 28.27],
            [2000, 3326, 51.15, 39.66],
            [2000, 3327, 98.77, 87.26],
            [2000, 3328, 120, 90],
            [2000, 3329, 8.87, 8.14],
            [2000, 3331, 108.09, 47.79],
            [2000, 3332, 120, 90],
            [2000, 3333, 120, 90],
            [2000, 3334, 8.78, 7.44],
            [2000, 3335, 70, 70],
            [2000, 3336, 46.22, 26.88],
            [2000, 3338, 70, 70],
            [2000, 3340, 50, 60],
            [2000, 3341, 24.19, 12.04],
            [2000, 3342, 70, 70],
            [2000, 3343, 120, 90],
            [2000, 3344, 96.68, 56.26],
            [2000, 3346, 90.98, 55.27],
            [2000, 3347, 120, 90],
            [2000, 3348, 70, 70],
            [2000, 3350, 120, 90],
            [2000, 3351, 120, 90],
            [2000, 3353, 120, 90],
            [2000, 3357, 12.58, 12.94],
            [2000, 3358, 19.2, 17.45],
            [2000, 3359, 120, 90],
            [2000, 3361, 120, 90],
            [2000, 3363, 14.08, 11.88],
            [2000, 3364, 12, 21.69],
            [2000, 3366, 120, 90],
            [2000, 3367, 50, 60],
            [2000, 3369, 120, 90],
            [2000, 3370, 48.58, 95.54],
            [2000, 3371, 70, 60],
            [2000, 3372, 70, 70],
            [2000, 3376, 120, 90],
            [2000, 3378, 9.02, 8.54],
            [2000, 3380, 120, 90],
            [2000, 3381, 120, 90],
            [2000, 3382, 23.2, 25.03],
            [2000, 3384, 70, 70],
            [2000, 3386, 120, 90],
            [2000, 3387, 70, 70],
            [2000, 3388, 120, 90],
            [2000, 3389, 31.29, 20.21],
            [2000, 3390, 59.69, 14.2],
            [2000, 3391, 120, 90],
            [2000, 3392, 120, 90],
            [2000, 3393, 120, 90],
            [2000, 3394, 120, 90],
            [2000, 3396, 21.88, 28.51],
            [2000, 3399, 89.86, 75.76],
            [2000, 3400, 50, 60],
            [2000, 3402, 120, 90],
            [2000, 3403, 16.87, 10.26],
            [2000, 3404, 41.37, 52.15],
            [2000, 3407, 63.12, 31.83],
            [2000, 3408, 120, 90],
            [2000, 3411, 70.12, 70],
            [2000, 3414, 50, 60],
            [2000, 3415, 40, 50],
            [2000, 3416, 40, 50],
            [2000, 3417, 120, 70],
            [2000, 3418, 120, 90],
            [2000, 3419, 70, 70],
            [2000, 3420, 70, 70],
            [2000, 3422, 50.99, 25.75],
            [2000, 3423, 120, 90],
            [2000, 3424, 37.5, 45],
            [2000, 3426, 120, 90],
            [2000, 3428, 70, 70],
            [2000, 3429, 49.14, 44.47],
            [2000, 3431, 120, 90],
            [2000, 3432, 70, 70],
            [2000, 3433, 19.6, 20.1],
            [2000, 3434, 6.86, 5.46],
            [2000, 3436, 50, 60],
            [2000, 3437, 70.24, 70],
            [2000, 3438, 70, 70],
            [2000, 3439, 36.81, 46.42],
            [2000, 3440, 50, 60],
            [2000, 3441, 59.78, 46.81],
            [2000, 3442, 34.82, 34.71],
            [2000, 3444, 17.9, 15.29],
            [2000, 3445, 70, 70],
            [2000, 3448, 5.56, 6.38],
            [2000, 3449, 70, 70],
            [2000, 3450, 70, 70],
            [2000, 3451, 71.38, 68.39],
            [2000, 3452, 120, 90],
            [2000, 3453, 15.33, 23.54],
            [2000, 3454, 18.63, 15.82],
            [2000, 3456, 70, 90],
            [2000, 3457, 120, 90],
            [2000, 3459, 72.5, 55.8],
            [2000, 3461, 68.26, 26.15],
            [2000, 3462, 55.41, 24.77],
            [2000, 3463, 120, 90],
            [2000, 3464, 120, 90],
            [2000, 3468, 76.43, 44.44],
            [2000, 3469, 34.89, 19.21],
            [2000, 3471, 70, 70],
            [2000, 3472, 120, 90],
            [2000, 3473, 12.27, 10.63],
            [2000, 3474, 70, 70],
            [2000, 3476, 40, 50],
            [2000, 3480, 120, 90],
            [2000, 3481, 70, 70],
            [2000, 3482, 70, 70],
            [2000, 3483, 70, 70],
            [2000, 3484, 120, 90],
            [2000, 3485, 52.28, 52.85],
            [2000, 3487, 50, 60],
            [2000, 3488, 23, 23],
            [2000, 3489, 40, 50],
            [2000, 3492, 120, 90],
            [2000, 3493, 70, 70],
            [2000, 3494, 12, 18],
            [2000, 3496, 120, 90],
            [2000, 3497, 120, 90],
            [2000, 3498, 38.68, 34.83],
            [2000, 3499, 120, 90],
            [2000, 3501, 120, 90],
            [2000, 3503, 120, 90],
            [2000, 3504, 70, 70],
            [2000, 3505, 120, 90],
            [2000, 3508, 120, 90],
            [2000, 3509, 40, 60],
            [2000, 3510, 120, 90],
            [2000, 3511, 70, 70],
            [2000, 3514, 18.7, 27],
            [2000, 3515, 70, 70],
            [2000, 3516, 120, 90],
            [2000, 3517, 70, 70],
            [2000, 3518, 120, 90],
            [2000, 3519, 50, 60],
            [2000, 3520, 120, 90],
            [2000, 3521, 120, 90],
            [2000, 3523, 120, 90],
            [2000, 3525, 120, 90],
            [2000, 3527, 120, 90],
            [2000, 3530, 52.8, 38.6],
            [2000, 3531, 42.22, 34.38],
            [2000, 3534, 70, 70],
            [2000, 3535, 30, 45],
            [2000, 3537, 120, 90],
            [2000, 3539, 120, 90],
            [2000, 3541, 42.81, 43.65],
            [2000, 3543, 120, 90],
            [2000, 3545, 120, 90],
            [2000, 3546, 120, 90],
            [2000, 3549, 22.69, 14.17],
            [2000, 3551, 120, 90],
            [2000, 3553, 70, 70],
            [2000, 3554, 50, 60],
            [2000, 3555, 40, 50],
            [2000, 3557, 16.81, 25.35],
            [2000, 3558, 70, 70],
            [2000, 3559, 50, 60],
            [2000, 3560, 120, 90],
            [2000, 3561, 120, 90],
            [2000, 3564, 120, 90],
            [2000, 3566, 17.61, 17.41],
            [2000, 3568, 12.22, 9.98],
            [2000, 3569, 50, 60],
            [2000, 3570, 70, 70],
            [2000, 3571, 70, 70],
            [2000, 3572, 120, 90],
            [2000, 3573, 120, 90],
            [2000, 3575, 120, 90],
            [2000, 3576, 120, 90],
            [2000, 3577, 70, 70],
            [2000, 3579, 22.92, 33.97],
            [2000, 3580, 70, 70],
            [2000, 3581, 120, 90],
            [2000, 3582, 4.45, 5.68],
            [2000, 3585, 70, 70],
            [2000, 3586, 70, 70],
            [2000, 3587, 70, 70],
            [2000, 3588, 120, 90],
            [2000, 3589, 12, 18],
            [2000, 3590, 40, 43.95],
            [2000, 3592, 70, 70],
            [2000, 3593, 35.78, 25.31],
            [2000, 3594, 120, 90],
            [2000, 3595, 70, 90],
            [2000, 3596, 120, 90],
            [2000, 3597, 70, 70],
            [2000, 3598, 22.96, 24.32],
            [2000, 3599, 120, 90],
            [2000, 3600, 49.66, 38.48],
            [2000, 3601, 75.67, 62.54],
            [2000, 3602, 51.79, 46.05],
            [2000, 3606, 40, 50],
            [2000, 3607, 12.7, 15.8],
            [2000, 3608, 33.57, 26.7],
            [2000, 3609, 151.97, 90],
            [2000, 3610, 50, 60],
            [2000, 3611, 70, 70],
            [2000, 3612, 70, 70],
            [2000, 3613, 40, 50],
            [2000, 3614, 9.76, 7.31],
            [2000, 3615, 70, 70],
            [2000, 3617, 70, 70],
            [2000, 3619, 70, 70],
            [2000, 3620, 48, 60],
            [2000, 3621, 50, 60],
            [2000, 3622, 120, 90],
            [2000, 3623, 120, 90],
            [2000, 3624, 16.21, 10.44],
            [2000, 3626, 120, 90],
            [2000, 3627, 120, 90],
            [2000, 3628, 30, 45],
            [2000, 3629, 70, 70],
            [2000, 3631, 70, 70],
            [2000, 3632, 48.09, 38.27],
            [2000, 3633, 71.55, 70],
            [2000, 3634, 24.1, 17.22],
            [2000, 3635, 50, 60],
            [2000, 3636, 70, 70],
            [2000, 3637, 40, 50],
            [2000, 3639, 120, 90],
            [2000, 3641, 40, 50],
            [2000, 3642, 58.18, 27.21],
            [2000, 3643, 70, 70],
            [2000, 3644, 37.33, 36.38],
            [2000, 3647, 70, 70],
            [2000, 3648, 70, 70],
            [2000, 3649, 120, 90],
            [2000, 3650, 93.96, 49.61],
            [2000, 3651, 40, 50],
            [2000, 3652, 40, 50],
            [2000, 3653, 49.84, 42.61],
            [2000, 3656, 42.55, 28.63],
            [2000, 3657, 40, 50],
            [2000, 3659, 45.77, 17.29],
            [2000, 3661, 49.38, 28.07],
            [2000, 3662, 30, 45],
            [2000, 3663, 120, 90],
            [2000, 3665, 120, 90],
            [2000, 3666, 120, 90],
            [2000, 3667, 30.09, 35.52],
            [2000, 3668, 120, 90],
            [2000, 3669, 12, 25.38],
            [2000, 3670, 96.19, 48.48],
            [2000, 3671, 120, 90],
            [2000, 3675, 120, 90],
            [2000, 3676, 120, 90],
            [2000, 3677, 50, 60],
            [2000, 3678, 11.23, 7.28],
            [2000, 3679, 22.74, 35.74],
            [2000, 3681, 70, 70],
            [2000, 3683, 7.87, 11.07],
            [2000, 3685, 120, 90],
            [2000, 3686, 120, 90],
            [2000, 3687, 92.77, 76.03],
            [2000, 3688, 120, 90],
            [2000, 3690, 120, 90],
            [2000, 3691, 13.11, 11.71],
            [2000, 3692, 24.91, 11.38],
            [2000, 3694, 70, 70],
            [2000, 3695, 120, 90],
            [2000, 3696, 70, 70],
            [2000, 3698, 120, 90],
            [2000, 3700, 25.38, 59.21],
            [2000, 3701, 29.01, 18.72],
            [2000, 3702, 16.7, 11.85],
            [2000, 3703, 175.88, 66.13],
            [2000, 3705, 30, 45],
            [2000, 3707, 70, 70],
            [2000, 3708, 70, 70],
            [2000, 3710, 50, 60],
            [2000, 3711, 9.31, 9.41],
            [2000, 3713, 71.95, 70],
            [2000, 3714, 120, 90],
            [2000, 3716, 120, 90],
            [2000, 3718, 70, 70],
            [2000, 3719, 120, 90],
            [2000, 3720, 95.89, 30.16],
            [2000, 3722, 40, 50],
            [2000, 3723, 30, 45],
            [2000, 3724, 12.29, 10.32],
            [2000, 3726, 12, 18],
            [2000, 3728, 120, 90],
            [2000, 3729, 120, 90],
            [2000, 3731, 40, 25.08],
            [2000, 3733, 120, 90],
            [2000, 3738, 30, 45],
            [2000, 3741, 120, 90],
            [2000, 3745, 120, 90],
            [2000, 3747, 33.24, 30.21],
            [2000, 3748, 120, 90],
            [2000, 3749, 120, 90],
            [2000, 3751, 27.22, 22.15],
            [2000, 3752, 38.07, 10.83],
            [2000, 3753, 50, 60],
            [2000, 3755, 31.66, 30.53],
            [2000, 3756, 120, 90],
            [2000, 3758, 50, 60],
            [2000, 3759, 70, 70],
            [2000, 3761, 36.17, 17.01],
            [2000, 3762, 49.07, 30.08],
            [2000, 3763, 70, 70],
            [2000, 3764, 56.14, 29.13],
            [2000, 3765, 36.87, 29.24],
            [2000, 3766, 50, 60],
            [2000, 3768, 72.89, 70],
            [2000, 3769, 120, 90],
            [2000, 3775, 16.7, 21.1],
            [2000, 3776, 120, 90],
            [2000, 3777, 64.75, 33.71],
            [2000, 3780, 70, 70],
            [2000, 3781, 120, 90],
            [2000, 3782, 33.84, 17.76],
            [2000, 3783, 70, 70],
            [2000, 3785, 120, 90],
            [2000, 3786, 10.14, 9.72],
            [2000, 3791, 120, 90],
            [2000, 3793, 70, 70],
            [2000, 3795, 28.93, 71.01],
            [2000, 3796, 34.35, 19.61],
            [2000, 3797, 50, 60],
            [2000, 3799, 50, 60],
            [2000, 3800, 70, 70],
            [2000, 3801, 120, 90],
            [2000, 3802, 50, 60],
            [2000, 3804, 70, 70],
            [2000, 3807, 21.47, 18.5],
            [2000, 3811, 50, 60],
            [2000, 3812, 120, 90],
            [2000, 3814, 70, 70],
            [2000, 3815, 8.38, 6.36],
            [2000, 3816, 120, 90],
            [2000, 3820, 50, 60],
            [2000, 3821, 18.9, 24.5],
            [2000, 3822, 120, 90],
            [2000, 3824, 70, 70],
            [2000, 3826, 114.89, 70],
            [2000, 3827, 104.5, 55.33],
            [2000, 3828, 48.71, 27.21],
            [2000, 3830, 6.73, 6.06],
            [2000, 3832, 40.07, 56.69],
            [2000, 3833, 30, 45],
            [2000, 3834, 82.66, 53.29],
            [2000, 3837, 70, 70],
            [2000, 3839, 120, 90],
            [2000, 3841, 115.85, 58.55],
            [2000, 3842, 70, 70],
            [2000, 3843, 4.12, 8.93],
            [2000, 3845, 29.78, 34.18],
            [2000, 3846, 70, 70],
            [2000, 3849, 70, 70],
            [2000, 3850, 28.31, 33.02],
            [2000, 3851, 120, 90],
            [2000, 3853, 120, 90],
            [2000, 3854, 28.93, 29.68],
            [2000, 3855, 120, 90],
            [2000, 3856, 16.7, 22.9],
            [2000, 3858, 120, 90],
            [2000, 3859, 12, 23.21],
            [2000, 3862, 70, 70],
            [2000, 3863, 50, 60],
            [2000, 3865, 120, 90],
            [2000, 3866, 14.49, 13.27],
            [2000, 3867, 120, 90],
            [2000, 3868, 120, 90],
            [2000, 3869, 50, 60],
            [2000, 3870, 113.75, 53.42],
            [2000, 3871, 46.79, 28.4],
            [2000, 3873, 120, 90],
            [2000, 3874, 57.1, 44.75],
            [2000, 3877, 120, 70],
            [2000, 3879, 120, 90],
            [2000, 3880, 15.73, 17.34],
            [2000, 3881, 50, 60],
            [2000, 3882, 120, 90],
            [2000, 3883, 85.28, 79.59],
            [2000, 3884, 50, 60],
            [2000, 3886, 70, 70],
            [2000, 3887, 120, 90],
            [2000, 3889, 70, 70],
            [2000, 3890, 10.56, 9.46],
            [2000, 3891, 17.06, 21.5],
            [2000, 3892, 70, 70],
            [2000, 3896, 70, 70],
            [2000, 3897, 46.88, 27.21],
            [2000, 3898, 120, 90],
            [2000, 3899, 120, 90],
            [2000, 3900, 50.61, 29.08],
            [2000, 3901, 70, 70],
            [2000, 3903, 50, 60],
            [2000, 3905, 62.21, 43.82],
            [2000, 3906, 70, 70],
            [2000, 3909, 120, 90],
            [2000, 3910, 70, 70],
            [2000, 3915, 30, 45],
            [2000, 3916, 120, 90],
            [2000, 3918, 8.88, 7.78],
            [2000, 3919, 120, 90],
            [2000, 3921, 34.37, 32.04],
            [2000, 3922, 120, 90],
            [2000, 3923, 120, 90],
            [2000, 3924, 11.01, 5.63],
            [2000, 3925, 87.13, 64.34],
            [2000, 3927, 70, 70],
            [2000, 3928, 15.78, 11.76],
            [2000, 3929, 120, 90],
            [2000, 3930, 76.26, 70],
            [2000, 3931, 70, 70],
            [2000, 3932, 32.72, 42.52],
            [2000, 3933, 70, 70],
            [2000, 3935, 120, 90],
            [2000, 3936, 120, 90],
            [2000, 3937, 70, 70],
            [2000, 3938, 40, 50],
            [2000, 3939, 40, 50],
            [2000, 3940, 53.79, 32.63],
            [2000, 3941, 120, 90],
            [2000, 3942, 32.24, 20.58],
            [2000, 3943, 16.04, 19.53],
            [2000, 3944, 120, 90],
            [2000, 3946, 9.98, 9.98],
            [2000, 3947, 120, 90],
            [2000, 3950, 120, 90],
            [2000, 3951, 120, 90],
            [2000, 3952, 120, 90],
            [2000, 3953, 130.15, 56.8],
            [2000, 3954, 120, 90],
            [2000, 3956, 50, 60],
            [2000, 3958, 13.07, 12.08],
            [2000, 3959, 107.55, 47.75],
            [2000, 3960, 78.17, 40.51],
            [2000, 3961, 8.09, 5.91],
            [2000, 3963, 24.93, 29.76],
            [2000, 3964, 70, 70],
            [2000, 3966, 70, 70],
            [2000, 3968, 26.82, 32.61],
            [2000, 3969, 73.5, 49.04],
            [2000, 3970, 46.74, 74.49],
            [2000, 3971, 120, 90],
            [2000, 3972, 120, 86],
            [2000, 3976, 12, 24.6],
            [2000, 3978, 70, 70],
            [2000, 3979, 151.53, 70.45],
            [2000, 3980, 50, 60],
            [2000, 3981, 70, 70],
            [2000, 3982, 120, 90],
            [2000, 3983, 30, 45],
            [2000, 3985, 36, 28],
            [2000, 3988, 33.8, 45.99],
            [2000, 3990, 70, 70],
            [2000, 3991, 120, 90],
            [2000, 3992, 53.73, 58.98],
            [2000, 3993, 12, 18],
            [2000, 3994, 120, 90],
            [2000, 3996, 70, 70],
            [2000, 3997, 120, 90],
            [2000, 3998, 120, 90],
            [2000, 3999, 28.04, 39.32],
            [2000, 4001, 120, 90],
            [2000, 4002, 120, 90],
            [2000, 4003, 86.47, 73.85],
            [2000, 4004, 70, 70],
            [2000, 4005, 51.86, 17.81],
            [2000, 4007, 120, 90],
            [2000, 4008, 70, 70],
            [2000, 4010, 8.6, 12.5],
            [2000, 4012, 120, 90],
            [2000, 4013, 120, 90],
            [2000, 4014, 120, 90],
            [2000, 4015, 120, 90],
            [2000, 4016, 21, 33],
            [2000, 4017, 84.3, 28.73],
            [2000, 4018, 80.65, 70],
            [2000, 4019, 40, 50],
            [2000, 4021, 70, 70],
            [2000, 4022, 70, 70],
            [2000, 4023, 34.76, 26.62],
            [2000, 4024, 120, 90],
            [2000, 4026, 36.65, 22.13],
            [2000, 4027, 120, 90],
            [2000, 4028, 70, 70],
            [2000, 4031, 17.94, 39.15],
            [2000, 4034, 120, 90],
            [2000, 4035, 17.68, 13.86],
            [2000, 4038, 120, 90],
            [2000, 4040, 85.79, 70.07],
            [2000, 4041, 120, 90],
            [2000, 4043, 20, 20],
            [2000, 4045, 10.39, 9.07],
            [2000, 4047, 44.52, 35.91],
            [2000, 4048, 14.6, 19.7],
            [2000, 4049, 70, 70],
            [2000, 4051, 120, 90],
            [2000, 4053, 64.92, 33.42],
            [2000, 4057, 50, 60],
            [2000, 4059, 113.78, 76.04],
            [2000, 4062, 70.39, 70],
            [2000, 4063, 50, 60],
            [2000, 4065, 70.03, 70],
            [2000, 4066, 70, 70],
            [2000, 4068, 120, 90],
            [2000, 4069, 58.37, 31.62],
            [2000, 4070, 70, 70],
            [2000, 4071, 70, 70],
            [2000, 4072, 120, 90],
            [2000, 4073, 30, 45],
            [2000, 4074, 70, 70],
            [2000, 4076, 120, 90],
            [2000, 4080, 120, 90],
            [2000, 4081, 120, 90],
            [2000, 4082, 120, 90],
            [2000, 4083, 120, 90],
            [2000, 4084, 14, 13.72],
            [2000, 4085, 70, 70],
            [2000, 4087, 120, 90],
            [2000, 4088, 120, 90],
            [2000, 4090, 120, 90],
            [2000, 4091, 70, 70],
            [2000, 4092, 98.89, 70],
            [2000, 4093, 120, 90],
            [2000, 4094, 50, 60],
            [2000, 4095, 30.82, 30.34],
            [2000, 4096, 85.87, 50.11],
            [2000, 4097, 120, 90],
            [2000, 4100, 50, 60],
            [2000, 4102, 70.01, 70],
            [2000, 4103, 70, 70],
            [2000, 4104, 70, 70],
            [2000, 4105, 120, 90],
            [2000, 4106, 35.03, 33.83],
            [2000, 4107, 120, 90],
            [2000, 4108, 47, 127],
            [2000, 4109, 11.09, 23.39],
            [2000, 4110, 70, 70],
            [2000, 4111, 46.81, 38.06],
            [2000, 4112, 40, 50],
            [2000, 4115, 120, 90],
            [2000, 4116, 31.55, 32.55],
            [2000, 4117, 53.51, 60],
            [2000, 4118, 27.75, 35.04],
            [2000, 4119, 120, 90],
            [2000, 4120, 34.02, 34.24],
            [2000, 4121, 70, 70],
            [2000, 4122, 103.31, 86.3],
            [2000, 4124, 53.38, 47.38],
            [2000, 4125, 12, 18],
            [2000, 4128, 28, 24.17],
            [2000, 4129, 14.06, 10.13],
            [2000, 4131, 16.41, 11.2],
            [2000, 4133, 70, 70],
            [2000, 4134, 89.38, 44.91],
            [2000, 4136, 50, 60],
            [2000, 4137, 120, 90],
            [2000, 4138, 11.77, 6.96],
            [2000, 4139, 30, 45],
            [2000, 4140, 49.79, 34.67],
            [2000, 4142, 70, 70],
            [2000, 4143, 50, 60],
            [2000, 4145, 120, 90],
            [2000, 4146, 6.49, 5.75],
            [2000, 4147, 120, 90],
            [2000, 4149, 50, 60],
            [2000, 4150, 70, 70],
            [2000, 4152, 101.39, 50.61],
            [2000, 4154, 120, 90],
            [2000, 4155, 70, 70],
            [2000, 4156, 78.4, 74.93],
            [2000, 4157, 30.51, 11.96],
            [2000, 4158, 120, 90],
            [2000, 4159, 6.8, 6.65],
            [2000, 4162, 120, 90],
            [2000, 4164, 16.17, 15.54],
            [2000, 4165, 120, 90],
            [2000, 4166, 30, 45],
            [2000, 4167, 70, 70],
            [2000, 4168, 37.5, 45],
            [2000, 4169, 35.25, 45.76],
            [2000, 4173, 12, 24.28],
            [2000, 4175, 51.01, 25.06],
            [2000, 4176, 10, 16],
            [2000, 4177, 58.73, 69.61],
            [2000, 4178, 120, 90],
            [2000, 4179, 23.41, 16.69],
            [2000, 4180, 14.1, 8.76],
            [2000, 4181, 120, 90],
            [2000, 4182, 76.84, 36.41],
            [2000, 4185, 14.91, 16.67],
            [2000, 4186, 50, 60],
            [2000, 4188, 120, 90],
            [2000, 4189, 24.6, 36],
            [2000, 4190, 120, 90],
            [2000, 4192, 50, 60],
            [2000, 4193, 120, 90],
            [2000, 4194, 120, 90],
            [2000, 4197, 50, 60],
            [2000, 4199, 76.31, 53.54],
            [2000, 4200, 12.14, 9.28],
            [2000, 4203, 62.98, 58.18],
            [2000, 4205, 120, 90],
            [2000, 4206, 12.5, 12],
            [2000, 4207, 60.24, 34.36],
            [2000, 4208, 120, 90],
            [2000, 4209, 22.23, 20.17],
            [2000, 4210, 56.87, 36.84],
            [2000, 4211, 120, 90],
            [2000, 4213, 40.9, 35.4],
            [2000, 4215, 120, 90],
            [2000, 4216, 120, 90],
            [2000, 4219, 30, 45],
            [2000, 4220, 70, 70],
            [2000, 4221, 70, 70],
            [2000, 4222, 120, 90],
            [2000, 4223, 5.37, 4.59],
            [2000, 4224, 42.19, 39.65],
            [2000, 4225, 120, 90],
            [2000, 4226, 73.7, 42.65],
            [2000, 4229, 36.01, 22.9],
            [2000, 4230, 70, 70],
            [2000, 4231, 70, 70],
            [2000, 4232, 40, 50],
            [2000, 4233, 30.06, 42.45],
            [2000, 4234, 70, 70],
            [2000, 4235, 6.53, 5.13],
            [2000, 4236, 70, 70],
            [2000, 4237, 120, 90],
            [2000, 4238, 120, 90],
            [2000, 4239, 120, 90],
            [2000, 4241, 120, 90],
            [2000, 4242, 22.45, 62.54],
            [2000, 4244, 11.58, 16.71],
            [2000, 4245, 50, 60],
            [2000, 4246, 23.77, 36.35],
            [2000, 4248, 70, 70],
            [2000, 4249, 120, 90],
            [2000, 4250, 120, 90],
            [2000, 4251, 120, 90],
            [2000, 4252, 7.87, 9.28],
            [2000, 4256, 50, 60],
            [2000, 4257, 40, 50],
            [2000, 4258, 17, 38.5],
            [2000, 4259, 12.25, 12.29],
            [2000, 4260, 120, 90],
            [2000, 4261, 50, 60],
            [2000, 4264, 8.46, 8.46],
            [2000, 4265, 70, 70],
            [2000, 4266, 120, 90],
            [2000, 4269, 120, 90],
            [2000, 4270, 120, 90],
            [2000, 4272, 72.31, 55.31],
            [2000, 4273, 120, 90],
            [2000, 4274, 120, 90],
            [2000, 4275, 70, 70],
            [2000, 4279, 25.11, 25.86],
            [2000, 4281, 70, 70],
            [2000, 4282, 50, 60],
            [2000, 4283, 19.15, 24.03],
            [2000, 4284, 120, 90],
            [2000, 4285, 36.64, 28.69],
            [2000, 4286, 120, 90],
            [2000, 4287, 14.84, 10.96],
            [2000, 4288, 120, 90],
            [2000, 4289, 43.54, 28.73],
            [2000, 4291, 50, 60],
            [2000, 4293, 7.15, 6.68],
            [2000, 4294, 79.07, 70],
            [2000, 4295, 70, 70],
            [2000, 4296, 42.82, 14.61],
            [2000, 4297, 70, 70],
            [2000, 4298, 120, 80],
            [2000, 4299, 70, 48.52],
            [2000, 4301, 60.86, 37.6],
            [2000, 4302, 26.64, 23.08],
            [2000, 4305, 70, 70],
            [2000, 4307, 120, 90],
            [2000, 4308, 120, 90],
            [2000, 4309, 11.7, 18],
            [2000, 4310, 50, 60],
            [2000, 4312, 70, 70],
            [2000, 4313, 120, 90],
            [2000, 4317, 50, 60],
            [2000, 4318, 39.31, 26.34],
            [2000, 4320, 46.9, 37],
            [2000, 4323, 24.53, 33.29],
            [2000, 4325, 29.6, 19.97],
            [2000, 4326, 11.3, 11.2],
            [2000, 4328, 70, 70],
            [2000, 4329, 22.52, 19.08],
            [2000, 4330, 70, 70],
            [2000, 4333, 17.64, 32.54],
            [2000, 4334, 120, 90],
            [2000, 4337, 30.93, 37.77],
            [2000, 4338, 26.42, 28.94],
            [2000, 4339, 21.74, 15.6],
            [2000, 4340, 13.6, 21.8],
            [2000, 4341, 120, 90],
            [2000, 4343, 120, 90],
            [2000, 4345, 48.44, 41.98],
            [2000, 4346, 50, 60],
            [2000, 4347, 120, 90],
            [2000, 4349, 21.62, 31.72],
            [2000, 4350, 26.85, 29.25],
            [2000, 4352, 41.47, 35.71],
            [2000, 4353, 40.7, 33.52],
            [2000, 4355, 120, 90],
            [2000, 4356, 12.68, 15.44],
            [2000, 4358, 23.24, 26.31],
            [2000, 4360, 84.9, 70],
            [2000, 4362, 57.64, 39.46],
            [2000, 4363, 70, 70],
            [2000, 4364, 59.2, 40.69],
            [2000, 4365, 120, 90],
            [2000, 4366, 70, 70],
            [2000, 4367, 120, 90],
            [2000, 4372, 70, 70],
            [2000, 4374, 30, 45],
            [2000, 4375, 70, 70],
            [2000, 4376, 120, 90],
            [2000, 4377, 70, 70],
            [2000, 4378, 70, 70],
            [2000, 4380, 66.47, 40.12],
            [2000, 4382, 70, 65],
            [2000, 4383, 70, 70],
            [2000, 4384, 45.16, 27.63],
            [2000, 4386, 16.95, 21.6],
            [2000, 4387, 120, 90],
            [2000, 4389, 70, 70],
            [2000, 4390, 120, 90],
            [2000, 4391, 19.92, 20.51],
            [2000, 4392, 70, 70],
            [2000, 4394, 70, 70],
            [2000, 4395, 70, 70],
            [2000, 4396, 70, 70],
            [2000, 4397, 7.76, 8.86],
            [2000, 4398, 70, 70],
            [2000, 4399, 50, 60],
            [2000, 4400, 120, 90],
            [2000, 4402, 40, 50],
            [2000, 4404, 120, 90],
            [2000, 4405, 6.29, 4.6],
            [2000, 4406, 63.31, 68.07],
            [2000, 4407, 70, 70],
            [2000, 4408, 18, 27],
            [2000, 4409, 120, 90],
            [2000, 4410, 70, 70],
            [2000, 4411, 120, 90],
            [2000, 4412, 120, 90],
            [2000, 4413, 26.66, 14.26],
            [2000, 4414, 18.02, 27],
            [2000, 4415, 126.64, 97.53],
            [2000, 4416, 70, 70],
            [2000, 4417, 50, 60],
            [2000, 4418, 131.53, 70.86],
            [2000, 4419, 70, 70],
            [2000, 4420, 5.73, 6.7],
            [2000, 4421, 73.94, 42.49],
            [2000, 4426, 12, 18],
            [2000, 4427, 40, 50],
            [2000, 4428, 70, 70],
            [2000, 4432, 70, 70],
            [2000, 4433, 120, 90],
            [2000, 4436, 40, 50],
            [2000, 4438, 50, 50],
            [2000, 4439, 40, 50],
            [2000, 4440, 70, 70],
            [2000, 4441, 16.95, 12.33],
            [2000, 4442, 18, 27],
            [2000, 4443, 41.1, 27.5],
            [2000, 4444, 70, 90],
            [2000, 4445, 70, 90],
            [2000, 4446, 37.11, 22.57],
            [2000, 4448, 70, 70],
            [2000, 4450, 120, 90],
            [2000, 4453, 50, 60],
            [2000, 4454, 25.13, 30.27],
            [2000, 4455, 70, 70],
            [2000, 4456, 15.9, 14.4],
            [2000, 4457, 40, 50],
            [2000, 4460, 70, 70],
            [2000, 4461, 25.09, 25.72],
            [2000, 4463, 38.22, 20.51],
            [2000, 4464, 44.69, 25.78],
            [2000, 4465, 70, 70],
            [2000, 4466, 70, 70],
            [2000, 4467, 120, 90],
            [2000, 4468, 70, 70],
            [2000, 4470, 50, 60],
            [2000, 4471, 48.21, 38.33],
            [2000, 4473, 70, 70],
            [2000, 4477, 37.5, 45],
            [2000, 4479, 120, 90],
            [2000, 4481, 120, 90],
            [2000, 4482, 120, 90],
            [2000, 4484, 120, 90],
            [2000, 4486, 120, 90],
            [2000, 4487, 44.33, 51.92],
            [2000, 4488, 70, 70],
            [2000, 4489, 11.71, 6.08],
            [2000, 4490, 120, 90],
            [2000, 4491, 70, 70],
            [2000, 4493, 47.38, 71.88],
            [2000, 4494, 19.4, 18.2],
            [2000, 4495, 74.53, 49.3],
            [2000, 4498, 70, 70],
            [2000, 4500, 18.74, 29.58],
            [2000, 4501, 120, 90],
            [2000, 4502, 50, 60],
            [2000, 4504, 69.49, 38],
            [2000, 4505, 70, 70],
            [2000, 4506, 29.14, 12.62],
            [2000, 4508, 43.63, 35.85],
            [2000, 4509, 120, 90],
            [2000, 4510, 33.56, 26.64],
            [2000, 4511, 70, 70],
            [2000, 4512, 12.38, 7.83],
            [2000, 4513, 40, 50],
            [2000, 4514, 120, 90],
            [2000, 4515, 40.56, 78.59],
            [2000, 4517, 29.39, 25.61],
            [2000, 4518, 72.62, 43.09],
            [2000, 4520, 22.49, 21.03],
            [2000, 4521, 115.81, 56],
            [2000, 4523, 50, 60],
            [2000, 4524, 36.64, 34.46],
            [2000, 4525, 50, 60],
            [2000, 4526, 7.23, 8.94],
            [2000, 4527, 120, 90],
            [2000, 4530, 13.96, 9.89],
            [2000, 4531, 120, 90],
            [2000, 4532, 66.87, 50.91],
            [2000, 4533, 70, 70],
            [2000, 4534, 70, 70],
            [2000, 4535, 70, 70],
            [2000, 4536, 7.2, 20.3],
            [2000, 4538, 18, 18],
            [2000, 4539, 78.64, 44.85],
            [2000, 4540, 10.59, 6.68],
            [2000, 4541, 120, 90],
            [2000, 4542, 65, 35],
            [2000, 4543, 37.5, 45],
            [2000, 4545, 70, 70],
            [2000, 4546, 16.6, 24.9],
            [2000, 4548, 20.54, 15.72],
            [2000, 4549, 23.8, 26.7],
            [2000, 4550, 65.66, 48.34],
            [2000, 4551, 70, 70],
            [2000, 4552, 55.6, 45.56],
            [2000, 4553, 120, 90],
            [2000, 4555, 11.6, 15.4],
            [2000, 4556, 120, 90],
            [2000, 4558, 90.79, 78.09],
            [2000, 4560, 120, 90],
            [2000, 4563, 53.86, 28.78],
            [2000, 4566, 83.86, 83.48],
            [2000, 4568, 50, 60],
            [2000, 4569, 70, 70],
            [2000, 4571, 70, 70],
            [2000, 4572, 105.72, 48.73],
            [2000, 4576, 28.7, 23.7],
            [2000, 4577, 13.21, 11.61],
            [2000, 4578, 90.9, 70],
            [2000, 4579, 8.36, 6.62],
            [2000, 4580, 50, 60],
            [2000, 4582, 70, 70],
            [2000, 4584, 40, 50],
            [2000, 4585, 92.75, 76.06],
            [2000, 4587, 120, 90],
            [2000, 4590, 70, 70],
            [2000, 4591, 38.76, 40.37],
            [2000, 4593, 6.78, 5.29],
            [2000, 4597, 120, 90],
            [2000, 4598, 120, 90],
            [2000, 4599, 120, 90],
            [2000, 4600, 50, 60],
            [2000, 4601, 33.72, 42.28],
            [2000, 4602, 29.41, 34.07],
            [2000, 4603, 120, 90],
            [2000, 4604, 120, 90],
            [2000, 4605, 9.5, 15.6],
            [2000, 4606, 28.45, 30.94],
            [2000, 4607, 120, 90],
            [2000, 4608, 38.4, 32.2],
            [2000, 4610, 70, 70],
            [2000, 4611, 62.95, 50.94],
            [2000, 4612, 70, 70],
            [2000, 4613, 120, 77.8],
            [2000, 4614, 70, 70],
            [2000, 4615, 120, 90],
            [2000, 4616, 27.98, 41.56],
            [2000, 4617, 95.75, 69.39],
            [2000, 4618, 70, 70],
            [2000, 4619, 70, 70],
            [2000, 4620, 70, 70],
            [2000, 4621, 40, 50],
            [2000, 4622, 120, 90],
            [2000, 4623, 18, 27],
            [2000, 4626, 40, 50],
            [2000, 4627, 70, 70],
            [2000, 4628, 120, 90],
            [2000, 4629, 70, 70],
            [2000, 4630, 120, 90],
            [2000, 4631, 20.43, 22.07],
            [2000, 4633, 23.94, 28.78],
            [2000, 4634, 34.71, 35.52],
            [2000, 4635, 16.11, 11.7],
            [2000, 4636, 120, 90],
            [2000, 4637, 70.44, 90],
            [2000, 4638, 54.7, 34.62],
            [2000, 4641, 15.53, 8.78],
            [2000, 4643, 120, 90],
            [2000, 4644, 15.8, 15.4],
            [2000, 4645, 50, 60],
            [2000, 4648, 50, 60],
            [2000, 4649, 50, 60],
            [2000, 4651, 70, 70],
            [2000, 4652, 50, 50],
            [2000, 4653, 120, 90],
            [2000, 4655, 120, 90],
            [2000, 4657, 120, 90],
            [2000, 4658, 70, 70],
            [2000, 4660, 70, 70],
            [2000, 4661, 70, 70],
            [2000, 4662, 70, 70],
            [2000, 4664, 10.86, 8.78],
            [2000, 4665, 120, 90],
            [2000, 4666, 120, 90],
            [2000, 4667, 70, 70],
            [2000, 4668, 62.61, 42.44],
            [2000, 4670, 70, 70],
            [2000, 4671, 120, 90],
            [2000, 4674, 15, 20],
            [2000, 4675, 19.2, 19.5],
            [2000, 4676, 13.79, 18.19],
            [2000, 4677, 70, 70],
            [2000, 4679, 120, 90],
            [2000, 4682, 120, 90],
            [2000, 4684, 39.81, 23.32],
            [2000, 4685, 60.96, 34.44],
            [2000, 4687, 14.2, 21.3],
            [2000, 4688, 17.49, 12.85],
            [2000, 4689, 50, 60],
            [2000, 4690, 70, 70],
            [2000, 4691, 27.06, 17.14],
            [2000, 4692, 3.57, 3.82],
            [2000, 4693, 119.12, 52.9],
            [2000, 4694, 58.78, 40.42],
            [2000, 4695, 70, 70],
            [2000, 4696, 120, 90],
            [2000, 4697, 120, 90],
            [2000, 4698, 70, 70],
            [2000, 4699, 120, 90],
            [2000, 4701, 70, 70],
            [2000, 4702, 120, 90],
            [2000, 4703, 23.69, 36.87],
            [2000, 4704, 120, 90],
            [2000, 4705, 120, 90],
            [2000, 4708, 70, 70],
            [2000, 4709, 120, 90],
            [2000, 4710, 8.73, 6.69],
            [2000, 4711, 34.53, 20.2],
            [2000, 4712, 39.53, 31.14],
            [2000, 4713, 50, 60],
            [2000, 4716, 120, 90],
            [2000, 4717, 16.28, 21.19],
            [2000, 4718, 120, 90],
            [2000, 4720, 49.72, 35.65],
            [2000, 4722, 120, 90],
            [2000, 4724, 47.15, 28.88],
            [2000, 4725, 8.6, 7.78],
            [2000, 4726, 120, 90],
            [2000, 4728, 25.36, 23.41],
            [2000, 4729, 68.67, 36.75],
            [2000, 4731, 4.74, 5.39],
            [2000, 4732, 50, 60],
            [2000, 4733, 86.8, 70],
            [2000, 4734, 20, 20],
            [2000, 4736, 70, 70],
            [2000, 4737, 120, 90],
            [2000, 4738, 50.45, 38.8],
            [2000, 4740, 70, 70],
            [2000, 4741, 50, 60],
            [2000, 4742, 120, 90],
            [2000, 4743, 70, 70],
            [2000, 4744, 40, 50],
            [2000, 4745, 40, 50],
            [2000, 4747, 55.87, 35.31],
            [2000, 4749, 70, 70],
            [2000, 4750, 9.46, 10.97],
            [2000, 4751, 19.36, 32.46],
            [2000, 4752, 70, 70],
            [2000, 4753, 88.11, 37.86],
            [2000, 4754, 120, 90],
            [2000, 4755, 13.77, 7.34],
            [2000, 4756, 129.21, 50],
            [2000, 4757, 120, 90],
            [2000, 4760, 120, 90],
            [2000, 4761, 15.75, 12.37],
            [2000, 4762, 52.5, 52.5],
            [2000, 4764, 46.9, 75],
            [2000, 4765, 50, 60],
            [2000, 4771, 70, 70],
            [2000, 4772, 70, 70],
            [2000, 4775, 70, 70],
            [2000, 4776, 37.5, 45],
            [2000, 4777, 24.04, 33.32],
            [2000, 4778, 50, 60],
            [2000, 4779, 50, 60],
            [2000, 4780, 110.99, 50.6],
            [2000, 4781, 30, 37.5],
            [2000, 4782, 87.14, 72.26],
            [2000, 4784, 120, 90],
            [2000, 4785, 120, 90],
            [2000, 4786, 120, 90],
            [2000, 4788, 6.3, 12.1],
            [2000, 4789, 70, 70],
            [2000, 4790, 70, 70],
            [2000, 4791, 39.76, 77.7],
            [2000, 4792, 92.77, 76.03],
            [2000, 4793, 120, 90],
            [2000, 4794, 41.99, 22.03],
            [2000, 4797, 20.25, 21.58],
            [2000, 4799, 70, 70],
            [2000, 4800, 22.3, 23.87],
            [2000, 4801, 21, 27],
            [2000, 4802, 128.4, 56.12],
            [2000, 4803, 79.74, 17.5],
            [2000, 4805, 16.75, 18],
            [2000, 4806, 70, 70],
            [2000, 4807, 50, 60],
            [2000, 4809, 120, 90],
            [2000, 4810, 120, 90],
            [2000, 4811, 50, 60],
            [2000, 4812, 120, 90],
            [2000, 4813, 60, 131],
            [2000, 4814, 120, 90],
            [2000, 4815, 55.01, 32.18],
            [2000, 4816, 70, 70],
            [2000, 4818, 120, 90],
            [2000, 4819, 57.44, 40.47],
            [2000, 4820, 70, 70],
            [2000, 4821, 120, 90],
            [2000, 4825, 120, 90],
            [2000, 4826, 28.39, 26.06],
            [2000, 4828, 47.32, 22.66],
            [2000, 4829, 45.03, 39.57],
            [2000, 4831, 7.24, 8.44],
            [2000, 4832, 12, 18],
            [2000, 4834, 120, 90],
            [2000, 4835, 51.6, 40.69],
            [2000, 4838, 39.63, 29.51],
            [2000, 4839, 37.82, 38.91],
            [2000, 4840, 70, 70],
            [2000, 4841, 120, 90],
            [2000, 4842, 120, 90],
            [2000, 4844, 59.83, 43.65],
            [2000, 4846, 12.98, 17.47],
            [2000, 4848, 120, 90],
            [2000, 4849, 14.83, 14.22],
            [2000, 4851, 120, 90],
            [2000, 4852, 70, 70],
            [2000, 4853, 10.34, 10.99],
            [2000, 4854, 120, 90],
            [2000, 4856, 12, 18],
            [2000, 4863, 70, 70],
            [2000, 4864, 8.85, 15.97],
            [2000, 4865, 40, 50],
            [2000, 4866, 12, 18],
            [2000, 4867, 38.67, 22.56],
            [2000, 4869, 120, 90],
            [2000, 4871, 21.01, 27.1],
            [2000, 4872, 36.26, 41.54],
            [2000, 4875, 11.1, 18.8],
            [2000, 4876, 40, 50],
            [2000, 4877, 18.65, 29.18],
            [2000, 4878, 50, 60],
            [2000, 4879, 120, 90],
            [2000, 4880, 23.1, 15.3],
            [2000, 4881, 35.37, 49.96],
            [2000, 4882, 120, 90],
            [2000, 4885, 18, 23.69],
            [2000, 4887, 120, 90],
            [2000, 4888, 70, 70],
            [2000, 4893, 53.46, 31.32],
            [2000, 4894, 50, 60],
            [2000, 4895, 120, 90],
            [2000, 4896, 18.2, 35.8],
            [2000, 4897, 22.65, 32.49],
            [2000, 4902, 70, 70],
            [2000, 4905, 40, 50],
            [2000, 4906, 40, 50],
            [2000, 4907, 70, 70],
            [2000, 4909, 17.42, 19.96],
            [2000, 4910, 20.48, 22.01],
            [2000, 4911, 11.82, 7.07],
            [2000, 4912, 12.39, 15.28],
            [2000, 4914, 120, 90],
            [2000, 4915, 12.81, 25.88],
            [2000, 4916, 21.19, 34.67],
            [2000, 4918, 29.8, 29.23],
            [2000, 4920, 40, 50],
            [2000, 4922, 68.28, 37.1],
            [2000, 4923, 120, 90],
            [2000, 4926, 55.14, 28.19],
            [2000, 4927, 28.01, 18.8],
            [2000, 4928, 70, 70],
            [2000, 4929, 70, 70],
            [2000, 4930, 70, 70],
            [2000, 4931, 33.7, 31.78],
            [2000, 4934, 51.99, 38.18],
            [2000, 4936, 120, 90],
            [2000, 4939, 28.05, 30.31],
            [2000, 4940, 95.48, 82.93],
            [2000, 4942, 50, 60],
            [2000, 4944, 18, 18],
            [2000, 4946, 120, 90],
            [2000, 4949, 50, 60],
            [2000, 4950, 70.53, 51.44],
            [2000, 4951, 66.71, 36.01],
            [2000, 4953, 120, 90],
            [2000, 4954, 70, 70],
            [2000, 4955, 29.76, 27.35],
            [2000, 4956, 70, 70],
            [2000, 4957, 64.8, 59.23],
            [2000, 4958, 120, 90],
            [2000, 4960, 106.07, 54.99],
            [2000, 4962, 70, 70],
            [2000, 4963, 31, 51],
            [2000, 4964, 7.37, 6.44],
            [2000, 4965, 42.65, 79.28],
            [2000, 4966, 70, 70],
            [2000, 4968, 120, 90],
            [2000, 4971, 70, 70],
            [2000, 4972, 120, 90],
            [2000, 4973, 34.33, 57.8],
            [2000, 4974, 50, 60],
            [2000, 4975, 52.81, 42.1],
            [2000, 4976, 12, 22.97],
            [2000, 4977, 120, 90],
            [2000, 4978, 120, 90],
            [2000, 4979, 56.77, 40.85],
            [2000, 4981, 50, 50],
            [2000, 4983, 29.76, 20.92],
            [2000, 4984, 20, 13.27],
            [2000, 4985, 6.45, 5.95],
            [2000, 4987, 39.69, 32.93],
            [2000, 4988, 70, 70],
            [2000, 4989, 120, 90],
            [2000, 4990, 106.41, 53.31],
            [2000, 4992, 45.11, 33.84],
            [2000, 4994, 120, 90],
            [2000, 4995, 28.23, 35.68],
            [2000, 4996, 16.69, 30.91],
            [2000, 4997, 26.79, 20.82],
            [2000, 4998, 49.03, 43.06],
            [2000, 5000, 13.36, 12.29],
            [2000, 5001, 70, 70],
            [2000, 5002, 120, 90],
            [2000, 5003, 120, 90],
            [2000, 5005, 17.46, 22.11],
            [2000, 5006, 112, 90],
            [2000, 5007, 120, 90],
            [2000, 5008, 126.38, 53.28],
            [2000, 5009, 18.59, 27.74],
            [2000, 5010, 8.39, 5.61],
            [2000, 5011, 21.98, 26],
            [2000, 5012, 35.55, 43.28],
            [2000, 5013, 46.69, 34.25],
            [2000, 5014, 61.9, 35.6],
            [2000, 5017, 13.52, 21.99],
            [2000, 5019, 70, 45.82],
            [2000, 5020, 32.11, 40.08],
            [2000, 5022, 137.19, 88.29],
            [2000, 5023, 70, 70],
            [2000, 5025, 120, 90],
            [2000, 5026, 120, 90],
            [2000, 5027, 24.1, 26.31],
            [2000, 5031, 10, 16],
            [2000, 5032, 26.02, 40.08],
            [2000, 5033, 40.97, 26.68],
            [2000, 5035, 47.55, 39.99],
            [2000, 5037, 91.49, 46.75],
            [2000, 5038, 18, 27],
            [2000, 5041, 120, 90],
            [2000, 5043, 50, 60],
            [2000, 5044, 70, 70],
            [2000, 5046, 59.27, 44.08],
            [2000, 5048, 17.82, 19.75],
            [2000, 5049, 120, 90],
            [2000, 5050, 20.33, 12.35],
            [2000, 5051, 12, 18],
            [2000, 5053, 77.54, 45.07],
            [2000, 5054, 45.4, 28.5],
            [2000, 5056, 120, 90],
            [2000, 5057, 120, 90],
            [2000, 5058, 48.62, 42.89],
            [2000, 5060, 120, 90],
            [2000, 5061, 120, 90],
            [2000, 5062, 67.65, 70],
            [2000, 5063, 20.35, 50],
            [2000, 5064, 20.75, 20.03],
            [2000, 5065, 100.18, 69.74],
            [2000, 5066, 120, 90],
            [2000, 5068, 164.36, 62.76],
            [2000, 5069, 149.63, 54.69],
            [2000, 5070, 13.6, 28.86],
            [2000, 5071, 34.13, 33.6],
            [2000, 5072, 120, 90],
            [2000, 5073, 50, 60],
            [2000, 5075, 21.04, 24.86],
            [2000, 5077, 40, 50],
            [2000, 5079, 30.65, 35.97],
            [2000, 5081, 120, 90],
            [2000, 5082, 9.69, 9.33],
            [2000, 5083, 5.36, 5.53],
            [2000, 5084, 50, 60],
            [2000, 5085, 41.13, 26.96],
            [2000, 5091, 40.5, 33.65],
            [2000, 5092, 10, 16],
            [2000, 5093, 50, 60],
            [2000, 5094, 36.74, 43],
            [2000, 5095, 13.3, 17.3],
            [2000, 5097, 120, 90],
            [2000, 5098, 47.81, 29.86],
            [2000, 5099, 58.83, 35.89],
            [2000, 5100, 120, 90],
            [2000, 5101, 5.93, 6.13],
            [2000, 5102, 35.03, 31.53],
            [2000, 5103, 89.21, 43],
            [2000, 5104, 120, 90],
            [2000, 5107, 70, 65],
            [2000, 5108, 25, 40],
            [2000, 5109, 55.7, 36.5],
            [2000, 5111, 120, 90],
            [2000, 5114, 4.87, 4],
            [2000, 5115, 12.26, 31.18],
            [2000, 5116, 26.44, 21.57],
            [2000, 5117, 40, 50],
            [2000, 5119, 120, 90],
            [2000, 5121, 36.95, 67.11],
            [2000, 5122, 21.51, 31.21],
            [2000, 5123, 11.8, 11.02],
            [2000, 5124, 56.09, 43.95],
            [2000, 5126, 26.81, 24.11],
            [2000, 5127, 18.25, 11.14],
            [2000, 5128, 70, 70],
            [2000, 5130, 50, 60],
            [2000, 5132, 120, 90],
            [2000, 5135, 68.8, 41.77],
            [2000, 5136, 10.18, 8.06],
            [2000, 5137, 120, 90],
            [2000, 5138, 15.14, 13.83],
            [2000, 5141, 24.58, 21.45],
            [2000, 5143, 70, 70],
            [2000, 5145, 120, 90],
            [2000, 5149, 120, 90],
            [2000, 5150, 52.83, 33.37],
            [2000, 5153, 179.52, 59.91],
            [2000, 5154, 70, 90],
            [2000, 5155, 70, 70],
            [2000, 5156, 40, 50],
            [2000, 5157, 50, 60],
            [2000, 5159, 52.86, 48.43],
            [2000, 5160, 120, 90],
            [2000, 5161, 17.42, 15.54],
            [2000, 5162, 65.6, 46.34],
            [2000, 5163, 120, 90],
            [2000, 5164, 120, 90],
            [2000, 5165, 3.38, 5.47],
            [2000, 5166, 33.73, 21.58],
            [2000, 5167, 120, 90],
            [2000, 5169, 56.5, 44.9],
            [2000, 5171, 249.75, 64.69],
            [2000, 5172, 70, 70],
            [2000, 5173, 46.38, 41.15],
            [2000, 5174, 143.07, 72.47],
            [2000, 5178, 120, 90],
            [2000, 5180, 86.39, 54.81],
            [2000, 5181, 120, 90],
            [2000, 5182, 16.01, 20.04],
            [2000, 5183, 30.55, 36.38],
            [2000, 5184, 25, 30.44],
            [2000, 5185, 22.64, 29.76],
            [2000, 5186, 12, 18],
            [2000, 5187, 12, 18],
            [2000, 5188, 12, 18],
            [2000, 5189, 32, 40],
            [2000, 5191, 50, 25],
            [2000, 5192, 15, 25],
            [2000, 5193, 15, 25],
            [2000, 5194, 15, 25],
            [2000, 5197, 15, 25],
            [2000, 5198, 15, 25],
            [2000, 5202, 15, 25],
            [2000, 5203, 15, 25],
            [2000, 5204, 40, 50],
            [2000, 5205, 15, 25],
            [2000, 5206, 15, 25],
            [2000, 5207, 15, 25],
            [2000, 5209, 15, 25],
            [2000, 5212, 15, 25],
            [2000, 5213, 15, 25],
            [2000, 5214, 15, 25],
            [2000, 5215, 15, 25],
            [2000, 5216, 15, 25],
            [2000, 5217, 70, 70],
            [2000, 5218, 50, 60],
            [2000, 5219, 20.7, 31.7],
            [2000, 5220, 12.6, 25.3],
            [2000, 5221, 14.8, 27.6],
            [2000, 5222, 23, 18.2],
            [2000, 5223, 10.5, 15.3],
            [2000, 5224, 16.8, 30.5],
            [2000, 5225, 21.5, 24.2],
            [2000, 5226, 8.5, 20.2],
            [2000, 5227, 55.9, 46.8],
            [2000, 5228, 18.7, 32.7],
            [2000, 5229, 7, 15.8],
            [2000, 5230, 15.5, 13.1],
            [2000, 5231, 15.2, 18.9],
            [2000, 5232, 26.7, 34.4],
            [2000, 5233, 22.9, 36.3],
            [2000, 5234, 10.9, 17.5],
            [2000, 5235, 43.7, 39.9],
            [2000, 5236, 15.6, 18.9],
            [2000, 5237, 27.3, 31.4],
            [2000, 5238, 23.1, 25.3],
            [2000, 5239, 23.3, 28.2],
            [2000, 5240, 17, 31.3],
            [2000, 5241, 26.1, 21.4],
            [2000, 5242, 25.2, 23.2],
            [2000, 5243, 28.2, 26.9],
            [2000, 5244, 20.5, 30],
            [2000, 5245, 21.3, 30],
            [2000, 5247, 80, 60],
            [2000, 5248, 80, 60],
            [2000, 5249, 19.35, 11.59],
            [2000, 5250, 20.93, 10.99],
            [2000, 5251, 10.39, 7.22],
            [2000, 5252, 30, 16.38],
            [2000, 5253, 11.8, 10.66],
            [2000, 5254, 25.42, 16.32],
            [2000, 5255, 23.04, 14.71],
            [2000, 5256, 24.56, 17.38],
            [2000, 5257, 15.4, 13.96],
            [2000, 5258, 23.85, 19.14],
            [2000, 5259, 10.2, 9.75],
            [2000, 5260, 14.55, 9.36],
            [2000, 5261, 24.59, 17.95],
            [2000, 5262, 13.46, 12.24],
            [2000, 5263, 19.45, 15.67],
            [2000, 5264, 70, 50.86],
            [2000, 5265, 7.91, 11.54],
            [2000, 5266, 24.83, 17.86],
            [2000, 5267, 21.83, 15.71],
            [2000, 5268, 15.77, 15],
            [2000, 5269, 14.5, 9.26],
            [2000, 5270, 13.36, 17.93],
            [2000, 5271, 70, 70],
            [2000, 5272, 49.88, 21.16],
            [2000, 5273, 27.17, 19.34],
            [2000, 5274, 21.56, 23.35],
            [2000, 5275, 21.89, 20.99],
            [2000, 5276, 33.57, 69.59],
            [2000, 5277, 33.53, 44.16],
            [2000, 5278, 17.61, 19.46],
            [2000, 5279, 22.19, 26.31],
            [2000, 5280, 54.9, 42.95],
            [2000, 5281, 23.97, 21.11],
            [2000, 5282, 18.86, 21.15],
            [2000, 5283, 14.72, 24.85],
            [2000, 5284, 19.82, 21.97],
            [2000, 5285, 12.98, 10.05],
            [2000, 5286, 21.47, 25.37],
            [2000, 5287, 12.95, 13.1],
            [2000, 5288, 15.79, 13.5],
            [2000, 5289, 14.72, 18.53],
            [2000, 5290, 23.09, 21.92],
            [2000, 5291, 13.74, 15.42],
            [2000, 5292, 27.71, 17.72],
            [2000, 5293, 31.42, 28.8],
            [2000, 5294, 27.26, 35.13],
            [2000, 5295, 17.19, 14.3],
            [2000, 5296, 37.77, 51.52],
            [2000, 5297, 36.44, 42.37],
            [2000, 5298, 13.26, 13.27],
            [2000, 5299, 18.16, 20.87],
            [2000, 5300, 19.04, 16.88],
            [2000, 5301, 42.73, 37.25],
            [2000, 5302, 9.07, 5.65],
            [2000, 5303, 36.15, 21.1],
            [2000, 5304, 19.35, 28.15],
            [2000, 5305, 28.21, 24.21],
            [2000, 5306, 30.08, 35.59],
            [2000, 5307, 28.82, 42.89],
            [2000, 5308, 30.68, 46.96],
            [2000, 5309, 22.98, 21.99],
            [2000, 5310, 18.38, 19.26],
            [2000, 5311, 14.95, 17.32],
            [2000, 5312, 24.78, 19.47],
            [2000, 5313, 14.05, 18.92],
            [2000, 5314, 22.31, 24.96],
            [2000, 5315, 19.95, 27.16],
            [2000, 5316, 34.5, 42.49],
            [2000, 5317, 47.68, 75.34],
            [2000, 5318, 30.3, 21.67],
            [2000, 5319, 13.84, 14.27],
            [2000, 5320, 53.44, 55.56],
            [2000, 5321, 21.43, 22.1],
            [2000, 5322, 21.86, 31.16],
            [2000, 5323, 13.54, 22.48],
            [2000, 5324, 28.56, 35.07],
            [2000, 5325, 16.07, 19.54],
            [2000, 5326, 34.56, 41.14],
            [2000, 5327, 16.58, 21.05],
            [2000, 5328, 21.03, 21.33],
            [2000, 5329, 17.44, 17.44],
            [2000, 5330, 28.89, 22.93],
            [2000, 5331, 20.27, 21.28],
            [2000, 5332, 24.04, 29.18],
            [2000, 5333, 13.04, 16.32],
            [2000, 5334, 14.81, 13.78],
            [2000, 5335, 19.89, 15.44],
            [2000, 5336, 16.38, 19.14],
            [2000, 5337, 17.09, 17.7],
            [2000, 5338, 33.77, 26.64],
            [2000, 5339, 21.48, 24.94],
            [2000, 5340, 31.28, 38.93],
            [2000, 5341, 21.6, 30.78],
            [2000, 5342, 67.33, 44.59],
            [2000, 5343, 16.6, 14.81],
            [2000, 5344, 47.23, 50.54],
            [2000, 5345, 17.36, 20.76],
            [2000, 5346, 12.53, 15.06],
            [2000, 5347, 20.45, 23.78],
            [2000, 5348, 18.99, 19.54],
            [2000, 5349, 23.6, 27.71],
            [2000, 5350, 17.87, 30.23],
            [2000, 5351, 25.6, 34.49],
            [2000, 5352, 12.65, 19.75],
            [2000, 5353, 20.64, 26.6],
            [2000, 5354, 15.47, 9.25],
            [2000, 5355, 24.3, 42.86],
            [2000, 5356, 15.64, 19.61],
            [2000, 5357, 30.99, 21.01],
            [2000, 5358, 18.44, 20.69],
            [2000, 5359, 17.32, 25.16],
            [2000, 5360, 14.69, 9.66],
            [2000, 5361, 25.44, 28.51],
            [2000, 5362, 22.78, 37.54],
            [2000, 5363, 17.15, 20.75],
            [2000, 5364, 27.13, 35.08],
            [2000, 5365, 14.15, 16.33],
            [2000, 5366, 31.71, 24.96],
            [2000, 5367, 18.39, 19.03],
            [2000, 5368, 25.49, 33.82],
            [2000, 5369, 17.87, 17.73],
            [2000, 5370, 26.37, 19.9],
            [2000, 5371, 34.48, 40.39],
            [2000, 5372, 23.31, 23.21],
            [2000, 5373, 39.81, 52.34],
            [2000, 5374, 38.4, 30.66],
            [2000, 5375, 20.13, 18.67],
            [2000, 5376, 39.93, 36.29],
            [2000, 5377, 17.78, 19.64],
            [2000, 5378, 44.16, 54.79],
            [2000, 5379, 17.59, 16],
            [2000, 5380, 19.5, 24.07],
            [2000, 5381, 24.54, 27.3],
            [2000, 5382, 27.26, 39.02],
            [2000, 5383, 24.98, 28.96],
            [2000, 5384, 32.06, 28.26],
            [2000, 5385, 35.75, 25.11],
            [2000, 5386, 12.39, 14.93],
            [2000, 5387, 16.52, 16.08],
            [2000, 5388, 28.27, 31.03],
            [2000, 5389, 21.28, 32.3],
            [2000, 5390, 27.81, 21.8],
            [2000, 5391, 15.92, 17.92],
            [2000, 5392, 18.92, 29.5],
            [2000, 5393, 21.42, 30.33],
            [2000, 5394, 25.56, 27.95],
            [2000, 5395, 15.36, 21.7],
            [2000, 5396, 24.37, 24.45],
            [2000, 5397, 37.72, 55.15],
            [2000, 5398, 22.54, 21.56],
            [2000, 5399, 30.96, 24.28],
            [2000, 5400, 13.97, 12.67],
            [2000, 5401, 27.87, 36.25],
            [2000, 5402, 25.63, 36.95],
            [2000, 5403, 24.28, 25.06],
            [2000, 5404, 24.46, 24.68],
            [2000, 5405, 17.96, 16.23],
            [2000, 5406, 26.71, 28.04],
            [2000, 5407, 20.69, 24.62],
            [2000, 5408, 18.11, 22.5],
            [2000, 5409, 31.73, 36.57],
            [2000, 5410, 58.51, 46.49],
            [2000, 5411, 27.68, 21.48],
            [2000, 5412, 23.04, 18.15],
            [2000, 5413, 23.32, 18.19],
            [2000, 5414, 9.91, 15.09],
            [2000, 5415, 51.57, 56.26],
            [2000, 5416, 12.77, 13.87],
            [2000, 5417, 23.61, 19.35],
            [2000, 5418, 28.79, 36.91],
            [2000, 5419, 27.19, 25.1],
            [2000, 5420, 16.27, 16.14],
            [2000, 5421, 18.76, 15.11],
            [2000, 5422, 25.14, 34.37],
            [2000, 5423, 35.81, 32.77],
            [2000, 5424, 17.07, 19.91],
            [2000, 5425, 16.63, 19.74],
            [2000, 5426, 22.35, 32.83],
            [2000, 5427, 30.13, 36.75],
            [2000, 5428, 18.88, 25.12],
            [2000, 5429, 14.33, 16.18],
            [2000, 5430, 35.21, 32.17],
            [2000, 5431, 21.98, 23.51],
            [2000, 5432, 22.49, 30.65],
            [2000, 5433, 22.03, 25.8],
            [2000, 5434, 15.65, 16.63],
            [2000, 5435, 28.65, 36.45],
            [2000, 5436, 22.2, 26.91],
            [2000, 5437, 28.46, 24.42],
            [2000, 5438, 26.15, 45.07],
            [2000, 5439, 23.1, 32.12],
            [2000, 5440, 42.61, 31.07],
            [2000, 5441, 31.6, 43.27],
            [2000, 5442, 27.28, 31.24],
            [2000, 5443, 27.08, 44.53],
            [2000, 5444, 21.92, 35.18],
            [2000, 5445, 16.8, 20.91],
            [2000, 5446, 28.06, 29.76],
            [2000, 5447, 20.25, 23.23],
            [2000, 5448, 18.61, 19.97],
            [2000, 5449, 26.78, 33.16],
            [2000, 5450, 28.76, 31.21],
            [2000, 5451, 36.55, 47.48],
            [2000, 5452, 22.51, 34.53],
            [2000, 5453, 28.94, 32.53],
            [2000, 5454, 12.32, 16.18],
            [2000, 5455, 28.32, 21.25],
            [2000, 5456, 21.35, 24.85],
            [2000, 5457, 16.87, 25.48],
            [2000, 5458, 18.67, 22.48],
            [2000, 5459, 25.03, 25.93],
            [2000, 5460, 15.43, 17.97],
            [2000, 5461, 18.92, 17.99],
            [2000, 5462, 22.52, 26.38],
            [2000, 5463, 14.28, 17.95],
            [2000, 5464, 18.6, 18.27],
            [2000, 5465, 23.82, 23.85],
            [2000, 5466, 18.5, 23.11],
            [2000, 5467, 21.73, 26.16],
            [2000, 5468, 48, 70],
            [2000, 5469, 28.95, 22.5],
            [2000, 5470, 18.2, 26.19],
            [2000, 5471, 21.88, 24.32],
            [2000, 5472, 24.34, 29.62],
            [2000, 5473, 18.21, 24.01],
            [2000, 5474, 15.15, 14.65],
            [2000, 5475, 19.39, 18.75],
            [2000, 5476, 15.52, 20.64],
            [2000, 5477, 11.66, 13.63],
            [2000, 5478, 18.69, 21.99],
            [2000, 5479, 20.66, 18.21],
            [2000, 5480, 38.45, 32.17],
            [2000, 5481, 15.98, 18.15],
            [2000, 5482, 17.06, 18.76],
            [2000, 5483, 25.35, 27.15],
            [2000, 5484, 22.09, 21.1],
            [2000, 5485, 22.02, 23.57],
            [2000, 5486, 22.14, 21.65],
            [2000, 5487, 17.97, 21.38],
            [2000, 5488, 24.02, 25.06],
            [2000, 5489, 34.19, 66.05],
            [2000, 5490, 28.94, 32.56],
            [2000, 5491, 15.88, 20.08],
            [2000, 5492, 22.58, 38.47],
            [2000, 5493, 27.68, 21.75],
            [2000, 5494, 25.82, 30.23],
            [2000, 5495, 33.94, 27.03],
            [2000, 5496, 70, 70],
            [2000, 5497, 18.35, 22.55],
            [2000, 5498, 27.02, 39.89],
            [2000, 5499, 33.57, 24.3],
            [2000, 5500, 22.47, 23.4],
            [2000, 5501, 27.13, 46.22],
            [2000, 5502, 29.4, 31.24],
            [2000, 5503, 25.48, 24.22],
            [2000, 5504, 29.82, 41.45],
            [2000, 5505, 19.44, 30.38],
            [2000, 5506, 19.55, 18.02],
            [2000, 5507, 8.92, 15.03],
            [2000, 5508, 25.07, 35.23],
            [2000, 5509, 25.6, 36.32],
            [2000, 5510, 23.88, 39.9],
            [2000, 5511, 27.52, 24.5],
            [2000, 5512, 11.13, 11.46],
            [2000, 5513, 20.91, 23.63],
            [2000, 5514, 17.98, 18.09],
            [2000, 5515, 38.99, 31.52],
            [2000, 5516, 24.35, 34.55],
            [2000, 5517, 22.32, 28.37],
            [2000, 5518, 19.91, 18.99],
            [2000, 5519, 31.61, 40.04],
            [2000, 5520, 22.33, 22.91],
            [2000, 5521, 33.45, 39.31],
            [2000, 5522, 20.71, 22.53],
            [2000, 5523, 26.18, 29.99],
            [2000, 5524, 21.48, 50.1],
            [2000, 5525, 22.24, 21.41],
            [2000, 5526, 32.51, 26.74],
            [2000, 5527, 30.84, 34.66],
            [2000, 5528, 20.96, 19.72],
            [2000, 5529, 59.13, 37.8],
            [2000, 5530, 19.55, 21.33],
            [2000, 5531, 24.12, 22.95],
            [2000, 5532, 25.42, 24.65],
            [2000, 5533, 14.52, 14.84],
            [2000, 5534, 17.4, 14.87],
            [2000, 5535, 15.5, 12.89],
            [2000, 5536, 2, 2],
            [2000, 5537, 12.2, 8.94],
            [2000, 5538, 37.26, 35.28],
            [2000, 5539, 14.86, 20],
            [2000, 5540, 23.95, 34.62],
            [2000, 5541, 26.12, 21.77],
            [2000, 5542, 12.8, 16.15],
            [2000, 5543, 12.26, 16.58],
            [2000, 5544, 22.77, 32.88],
            [2000, 5545, 16.25, 22.22],
            [2000, 5546, 34.03, 40.31],
            [2000, 5547, 26.1, 25.13],
            [2000, 5548, 38.2, 46.39],
            [2000, 5549, 16.23, 22.79],
            [2000, 5550, 16.66, 17.46],
            [2000, 5551, 47.85, 70],
            [2000, 5552, 28.07, 25.33],
            [2000, 5553, 31.7, 29.24],
            [2000, 5554, 26.98, 30.18],
            [2000, 5555, 32.21, 32.76],
            [2000, 5556, 17.16, 17.29],
            [2000, 5557, 15.34, 14.19],
            [2000, 5558, 14.56, 19.66],
            [2000, 5559, 30.04, 31.58],
            [2000, 5560, 74.52, 28.37],
            [2000, 5561, 38.69, 49.15],
            [2000, 5562, 40.29, 56.03],
            [2000, 5563, 33.52, 34.96],
            [2000, 5564, 70, 56.53],
            [2000, 5565, 19.45, 18.12],
            [2000, 5566, 24.67, 27.3],
            [2000, 5567, 28.59, 35.72],
            [2000, 5568, 26.89, 35.03],
            [2000, 5569, 51.02, 38.85],
            [2000, 5570, 37.26, 27.17],
            [2000, 5571, 28.9, 21.65],
            [2000, 5572, 20.43, 17.7],
            [2000, 5573, 42.96, 28.46],
            [2000, 5590, 70, 70],
            [2000, 5600, 70, 70],
            [2000, 5618, 60, 132],
            [2000, 5621, 59, 48],
            [2000, 5624, 79, 140],
            [2000, 5625, 46, 70],
            [2000, 5627, 45, 70],
            [2000, 5632, 50, 70],
            [2000, 5636, 50, 60],
            [2000, 5638, 40, 50],
            [2000, 5646, 120, 90],
            [2000, 5648, 58, 90],
            [2000, 5649, 50, 60],
            [2000, 5659, 5.35, 4.7],
            [2000, 5660, 7.67, 7.45],
            [2000, 5661, 70, 70],
            [2000, 5663, 120, 90],
            [2000, 5666, 120, 90],
            [2000, 5672, 70, 70],
            [2000, 5675, 40, 50],
            [2000, 5677, 120, 90],
            [2000, 5681, 70, 70],
            [2000, 5683, 120, 90],
            [2000, 5689, 120, 90],
            [2000, 5706, 120, 90],
            [2000, 5715, 70, 70],
            [2000, 5717, 120, 90],
            [2000, 5720, 70, 70],
            [2000, 5726, 120, 90],
            [2000, 5728, 120, 90],
            [2000, 5737, 120, 90],
            [2000, 5738, 120, 90],
            [2000, 5745, 70, 70],
            [2000, 5747, 120, 90],
            [2000, 5757, 40, 50],
            [2000, 5758, 70, 70],
            [2000, 5764, 50, 60],
            [2000, 5768, 70, 70],
            [2000, 5777, 120, 90],
            [2000, 5789, 40, 50],
            [2000, 5805, 120, 90],
            [2000, 5808, 70, 70],
            [2000, 5811, 120, 90],
            [2000, 5819, 120, 90],
            [2000, 5824, 70, 70],
            [2000, 5830, 70, 70],
            [2000, 5833, 120, 90],
            [2000, 5840, 120, 90],
            [2000, 5841, 120, 90],
            [2000, 5846, 120, 90],
            [2000, 5848, 120, 90],
            [2000, 5851, 120, 90],
            [2000, 5855, 50, 50],
            [2000, 5856, 40, 50],
            [2000, 5861, 120, 90],
            [2000, 5869, 120, 90],
            [2000, 5876, 120, 90],
            [2000, 5877, 120, 90],
            [2000, 5880, 50, 60],
            [2000, 5881, 70, 70],
            [2000, 5882, 70, 70],
            [2000, 5884, 120, 90],
            [2000, 5889, 70, 70],
            [2000, 5898, 120, 90],
            [2000, 5903, 70, 70],
            [2000, 5911, 120, 90],
            [2000, 5917, 120, 90],
            [2000, 5918, 120, 90],
            [2000, 5919, 70, 70],
            [2000, 5931, 70, 70],
            [2000, 5933, 40, 50],
            [2000, 5936, 70, 70],
            [2000, 5939, 120, 90],
            [2000, 5941, 120, 90],
            [2000, 5942, 120, 90],
            [2000, 5943, 120, 90],
            [2000, 5944, 40, 50],
            [2000, 5945, 40, 50],
            [2000, 5946, 40, 50],
            [2000, 5947, 120, 90],
            [2000, 5948, 120, 90],
            [2000, 5949, 120, 90],
            [2000, 5950, 120, 90],
            [2000, 5951, 120, 90],
            [2000, 5953, 120, 90],
            [2000, 5954, 120, 90],
            [2000, 5955, 120, 90],
            [2000, 5956, 120, 90],
            [2000, 5957, 120, 90],
            [2000, 5958, 40, 50],
            [2000, 5959, 40, 50],
            [2000, 5961, 40, 50],
            [2000, 5962, 50, 60],
            [2000, 5964, 120, 90],
            [2000, 5965, 28, 90],
            [2000, 5966, 68, 80],
            [2000, 5967, 41, 60],
            [2000, 5968, 120, 117],
            [2000, 5969, 56, 70],
            [2000, 5970, 70, 70],
            [2000, 5985, 15, 25],
            [2000, 5986, 50, 60],
            [2000, 5987, 15, 25],
            [2000, 5988, 21, 33],
            [2000, 5989, 50, 60],
            [2000, 5990, 50, 60],
            [2000, 5991, 50, 60],
            [2000, 5992, 50, 60],
            [2000, 5993, 50, 60],
            [2000, 5994, 60.08, 60],
            [2000, 5995, 70, 70],
            [2000, 5996, 70, 70],
            [2000, 5997, 70, 70],
            [2000, 5998, 120, 90],
            [2000, 5999, 50, 60],
            [2000, 6049, 70, 70],
            [2000, 6050, 70, 70],
            [2000, 6051, 70, 70],
            [2000, 6052, 120, 90],
            [2000, 6053, 120, 90],
            [2000, 6054, 120, 90],
            [2000, 6055, 52.5, 52.5],
            [2000, 6066, 37.5, 45],
            [2000, 6067, 15, 25],
            [2000, 6068, 120, 90],
            [2000, 6069, 70, 70],
            [2000, 6070, 70, 70],
            [2000, 6071, 49, 49],
            [2000, 6072, 40, 50],
            [2000, 6073, 49, 49],
            [2000, 6074, 49, 49],
            [2000, 6075, 70, 70],
            [2000, 6076, 50, 60],
            [2000, 6077, 49, 49],
            [2000, 6078, 50, 60],
            [2000, 6079, 49, 49],
            [2000, 6080, 70, 70],
            [2000, 6081, 38, 45],
            [2000, 6082, 49, 49],
            [2000, 6083, 49, 49],
            [2000, 6084, 84, 63],
            [2000, 6085, 84, 63],
            [2000, 6086, 35, 42],
            [2000, 6087, 49, 49],
            [2000, 6088, 49, 49],
            [2000, 6089, 49, 49],
            [2000, 6090, 84, 63],
            [2000, 6091, 49, 49],
            [2000, 6092, 49, 49],
            [2000, 6093, 49, 49],
            [2000, 6094, 49, 49],
            [2000, 6095, 35, 42],
            [2000, 6096, 49, 49],
            [2000, 6097, 49, 49],
            [2000, 6098, 49, 49],
            [2000, 6099, 84, 63],
            [2000, 6100, 49, 49],
            [2000, 6101, 49, 49],
            [2000, 6102, 35, 42],
            [2000, 6103, 49, 49],
            [2000, 6104, 84, 63],
            [2000, 6105, 84, 63],
            [2000, 6106, 49, 49],
            [2000, 6107, 49, 49],
            [2000, 6108, 49, 49],
            [2000, 6109, 35, 42],
            [2000, 6110, 49, 49],
            [2000, 6111, 24, 36],
            [2000, 6112, 49, 49],
            [2000, 6113, 42, 42],
            [2000, 6114, 35, 42],
            [2000, 6115, 35, 42],
            [2000, 6116, 49, 49],
            [2000, 6117, 49, 49],
            [2000, 6118, 49, 49],
            [2000, 6119, 49, 49],
            [2000, 6120, 28, 35],
            [2000, 6121, 49, 49],
            [2000, 6122, 49, 49],
            [2000, 6123, 49, 49],
            [2000, 6124, 49, 49],
            [2000, 6125, 49, 49],
            [2000, 6126, 49, 49],
            [2000, 6127, 49, 49],
            [2000, 6128, 49, 49],
            [2000, 6129, 28, 35],
            [2000, 6130, 49, 49],
            [2000, 6131, 49, 49],
            [2000, 6132, 49, 49],
            [2000, 6133, 49, 49],
            [2000, 6134, 49, 49],
            [2000, 6135, 49, 49],
            [2000, 6136, 70, 70],
            [2000, 6137, 28, 35],
            [2000, 6138, 35, 42],
            [2000, 6139, 49, 49],
            [2000, 6140, 28, 35],
            [2000, 6141, 49, 49],
            [2000, 6142, 35, 42],
            [2000, 6143, 49, 49],
            [2000, 6144, 42, 42],
            [2000, 6145, 49, 49],
            [2000, 6146, 24, 36],
            [2000, 6147, 40, 50],
            [2000, 6148, 32, 40],
            [2000, 6149, 49, 49],
            [2000, 6150, 28, 35],
            [2000, 6151, 49, 49],
            [2000, 6152, 28, 35],
            [2000, 6153, 28, 35],
            [2000, 6154, 49, 49],
            [2000, 6155, 30, 38],
            [2000, 6156, 35, 42],
            [2000, 6157, 49, 49],
            [2000, 6158, 35, 42],
            [2000, 6159, 49, 49],
            [2000, 6160, 35, 42],
            [2000, 6161, 28, 35],
            [2000, 6162, 35, 42],
            [2000, 6163, 50, 60],
            [2000, 6164, 49, 49],
            [2000, 6165, 35, 42],
            [2000, 6166, 70, 70],
            [2000, 6167, 70, 70],
            [2000, 6168, 24, 36],
            [2000, 6169, 24, 36],
            [2000, 6170, 24, 36],
            [2000, 6227, 120, 90],
            [2000, 6228, 15, 25],
            [2000, 6229, 15, 25],
            [2000, 6230, 50, 60],
            [2000, 6231, 50, 60],
            [2000, 6232, 50, 60],
            [2000, 6233, 70, 70],
            [2000, 6234, 50, 60],
            [2000, 6235, 50, 60],
            [2000, 6236, 50, 60],
            [2000, 6238, 70, 70],
            [2000, 6239, 50, 60],
            [2000, 6240, 50, 60],
            [2000, 6241, 50, 60],
            [2000, 6242, 50, 60],
            [2000, 6243, 70, 70],
            [2000, 6244, 70, 70],
            [2000, 6245, 50, 60],
            [2000, 6246, 70, 70],
            [2000, 6247, 50, 60],
            [2000, 6248, 30, 45],
            [2000, 6252, 50, 60],
            [2000, 6253, 120, 90],
            [2000, 6255, 70, 70],
            [2000, 6256, 50, 60],
            [2000, 6258, 50, 60],
            [2000, 6259, 120, 90],
            [2000, 6260, 120, 90],
            [2000, 6261, 70, 70],
            [2000, 6262, 70, 70],
            [2000, 6263, 120, 90],
            [2000, 6264, 70, 70],
            [2000, 6265, 70, 70],
            [2000, 6266, 50, 60],
            [2000, 6267, 50, 60],
            [2000, 6268, 70, 70],
            [2000, 6269, 50, 60],
            [2000, 6270, 50, 60],
            [2000, 6271, 70, 70],
            [2000, 6272, 40, 50],
            [2000, 6274, 70, 70],
            [2000, 6275, 70, 70],
            [2000, 6276, 50, 60],
            [2000, 6277, 120, 90],
            [2000, 6278, 70, 70],
            [2000, 6279, 70, 70],
            [2000, 6280, 70, 70],
            [2000, 6281, 70, 70],
            [2000, 6282, 50, 60],
            [2000, 6283, 70, 70],
            [2000, 6284, 50, 60],
            [2000, 6286, 70, 70],
            [2000, 6287, 50, 60],
            [2000, 6288, 70, 70],
            [2000, 6289, 50, 60],
            [2000, 6290, 120, 90],
            [2000, 6292, 70, 70],
            [2000, 6293, 70, 70],
            [2000, 6294, 120, 90],
            [2000, 6295, 120, 90],
            [2000, 6296, 70, 70],
            [2000, 6297, 120, 90],
            [2000, 6299, 70, 70],
            [2000, 6300, 70, 70],
            [2000, 6301, 70, 70],
            [2000, 6302, 70, 70],
            [2000, 6303, 70, 70],
            [2000, 6305, 120, 90],
            [2000, 6306, 70, 70],
            [2000, 6307, 120, 90],
            [2000, 6308, 120, 90],
            [2000, 6309, 70, 70],
            [2000, 6310, 50, 60],
            [2000, 6312, 120, 90],
            [2000, 6313, 70, 70],
            [2000, 6314, 120, 90],
            [2000, 6315, 70, 70],
            [2000, 6316, 70, 70],
            [2000, 6317, 70, 70],
            [2000, 6319, 50, 60],
            [2000, 6320, 70, 70],
            [2000, 6321, 70, 70],
            [2000, 6323, 50, 60],
            [2000, 6324, 50, 60],
            [2000, 6325, 120, 90],
            [2000, 6326, 70, 70],
            [2000, 6327, 50, 60],
            [2000, 6328, 120, 90],
            [2000, 6330, 120, 90],
            [2000, 6334, 17.01, 16],
            [2000, 6335, 22.88, 20.17],
            [2000, 6336, 34, 36.4],
            [2000, 6337, 22.28, 16.2],
            [2000, 6338, 35, 27.18],
            [2000, 6339, 20.53, 16.19],
            [2000, 6340, 34, 36.69],
            [2000, 6341, 28.74, 25],
            [2000, 6342, 22.3, 20],
            [2000, 6343, 28.6, 33.48],
            [2000, 6344, 22.3, 21.5],
            [2000, 6345, 31.99, 26.94],
            [2000, 6346, 30, 21.24],
            [2000, 6347, 22.82, 20],
            [2000, 6348, 40.24, 30],
            [2000, 6349, 20.84, 24.13],
            [2000, 6350, 22.32, 30],
            [2000, 6351, 29.17, 16.2],
            [2000, 6353, 40, 50],
            [2000, 6354, 40, 50],
            [2000, 6355, 30, 45],
            [2000, 6356, 50, 60],
            [2000, 6357, 70, 70],
            [2000, 6358, 40, 50],
            [2000, 6359, 28.08, 27.32],
            [2000, 6360, 120, 109.36],
            [2000, 6361, 120, 90],
            [2000, 6362, 115.35, 155.44],
            [2000, 6363, 63.74, 113.55],
            [2000, 6364, 120, 108.36],
            [2000, 6365, 120, 90],
            [2000, 6366, 152, 95.28],
            [2000, 6367, 70, 70],
            [2000, 6368, 120, 119.04],
            [2000, 6369, 68.6, 48.47],
            [2000, 6370, 120, 90],
            [2000, 6371, 120, 130.57],
            [2000, 6372, 120, 90],
            [2000, 6373, 120, 90],
            [2000, 6374, 120, 64.08],
            [2000, 6375, 120, 90],
            [2000, 6376, 70, 70],
            [2000, 6377, 120, 90],
            [2000, 6378, 70, 70],
            [2000, 6379, 120, 78.19],
            [2000, 6380, 70, 91.63],
            [2000, 6381, 70, 70],
            [2000, 6382, 120, 108.36],
            [2000, 6383, 70, 70],
            [2000, 6384, 120, 108.36],
            [2000, 6385, 120, 65.11],
            [2000, 6386, 120, 90],
            [2000, 6387, 120, 90],
            [2000, 6388, 120, 90],
            [2000, 6389, 120, 90],
            [2000, 6390, 120, 90],
            [2000, 6391, 78.33, 99.36],
            [2000, 6392, 120, 90],
            [2000, 6393, 120, 90],
            [2000, 6394, 120, 90],
            [2000, 6395, 120, 90],
            [2000, 6396, 120, 117.19],
            [2000, 6397, 120, 90],
            [2000, 6398, 120, 90],
            [2000, 6399, 120, 90],
            [2000, 6400, 120, 109.36],
            [2000, 6401, 70, 70],
            [2000, 6402, 120, 130.57],
            [2000, 6403, 120, 90],
            [2000, 6404, 120, 90],
            [2000, 6405, 120, 90],
            [2000, 6406, 120, 109.36],
            [2000, 6407, 120, 109.36],
            [2000, 6408, 120, 90],
            [2000, 6409, 120, 90],
            [2000, 6410, 120, 90],
            [2000, 6411, 120, 90],
            [2000, 6412, 120, 90],
            [2000, 6413, 120, 90],
            [2000, 6414, 120, 109.36],
            [2000, 6415, 120, 119.04],
            [2000, 6416, 120, 90],
            [2000, 6417, 120, 90],
            [2000, 6418, 120, 90],
            [2000, 6419, 120, 90],
            [2000, 6420, 120, 90],
            [2000, 6421, 120, 117.19],
            [2000, 6422, 120, 109.36],
            [2000, 6423, 42.81, 43.17],
            [2000, 6424, 115.49, 81.33],
            [2000, 6425, 70, 98.36],
            [2000, 6426, 120, 117.19],
            [2000, 6427, 120, 90],
            [2000, 6428, 120, 90],
            [2000, 6429, 120, 90],
            [2000, 6430, 70, 86.89],
            [2000, 6431, 120, 90],
            [2000, 6432, 120, 90],
            [2000, 6433, 63.74, 113.55],
            [2000, 6434, 120, 90],
            [2000, 6435, 78.33, 99.36],
            [2000, 6436, 120, 90],
            [2000, 6437, 120, 90],
            [2000, 6438, 120, 90],
            [2000, 6439, 120, 125.74],
            [2000, 6440, 120, 90],
            [2000, 6441, 120, 109.36],
            [2000, 6442, 70, 70],
            [2000, 6443, 120, 90],
            [2000, 6444, 120, 90],
            [2000, 6445, 120, 90],
            [2000, 6446, 120, 90],
            [2000, 6447, 48.53, 70],
            [2000, 6448, 120, 90],
            [2000, 6449, 120, 90],
            [2000, 6450, 120, 90],
            [2000, 6451, 120, 90],
            [2000, 6452, 120, 90],
            [2000, 6453, 120, 90],
            [2000, 6454, 120, 90],
            [2000, 6455, 120, 90],
            [2000, 6456, 120, 90],
            [2000, 6457, 56.58, 70],
            [2000, 6458, 40, 55.85],
            [2000, 6459, 120, 125.74],
            [2000, 6460, 163.78, 95.28],
            [2000, 6461, 120, 90],
            [2000, 6462, 152, 95.28],
            [2000, 6463, 120, 90],
            [2000, 6464, 120, 90],
            [2000, 6465, 120, 90],
            [2000, 6466, 120, 90],
            [2000, 6467, 120, 90],
            [2000, 6468, 120, 90],
            [2000, 6469, 120, 101.08],
            [2000, 6470, 120, 90],
            [2000, 6471, 120, 109.36],
            [2000, 6472, 120, 108.36],
            [2000, 6473, 120, 90],
            [2000, 6474, 120, 90],
            [2000, 6475, 120, 90],
            [2000, 6476, 120, 108.36],
            [2000, 6477, 120, 90],
            [2000, 6478, 120, 90],
            [2000, 6479, 120, 90],
            [2000, 6480, 120, 90],
            [2000, 6481, 120, 90],
            [2000, 6482, 152, 95.28],
            [2000, 6483, 120, 109.36],
            [2000, 6484, 70, 56.48],
            [2000, 6485, 120, 90],
            [2000, 6486, 120, 90],
            [2000, 6487, 120, 90],
            [2000, 6488, 120, 90],
            [2000, 6489, 120, 90],
            [2000, 6490, 120, 108.36],
            [2000, 6491, 120, 90],
            [2000, 6492, 60.88, 72.65],
            [2000, 6493, 120, 90],
            [2000, 6494, 60.88, 72.65],
            [2000, 6495, 120, 125.74],
            [2000, 6496, 120, 109.36],
            [2000, 6497, 120, 90],
            [2000, 6498, 120, 125.74],
            [2000, 6499, 120, 90],
            [2000, 6500, 80.71, 115.49],
            [2000, 6501, 120, 90],
            [2000, 6502, 120, 78.19],
            [2000, 6503, 120, 109.36],
            [2000, 6504, 120, 130.57],
            [2000, 6505, 120, 91.63],
            [2000, 6506, 120, 90],
            [2000, 6507, 120, 90],
            [2000, 6508, 120, 90],
            [2000, 6509, 120, 119.04],
            [2000, 6510, 120, 90],
            [2000, 6511, 120, 90],
            [2000, 6512, 120, 109.36],
            [2000, 6513, 31.53, 53.27],
            [2000, 6514, 120, 90],
            [2000, 6515, 120, 90],
            [2000, 6516, 73.07, 58.95],
            [2000, 6517, 68.95, 86.89],
            [2000, 6518, 120, 117.19],
            [2000, 6519, 120, 90],
            [2000, 6520, 120, 90],
            [2000, 6521, 56.58, 56.58],
            [2000, 6522, 120, 90],
            [2000, 6523, 120, 90],
            [2000, 6524, 120, 90],
            [2000, 6525, 120, 90],
            [2000, 6526, 120, 90],
            [2000, 6527, 120, 125.74],
            [2000, 6528, 120, 125.74],
            [2000, 6529, 120, 90],
            [2000, 6530, 120, 109.36],
            [2000, 6531, 120, 90],
            [2000, 6532, 120, 125.74],
            [2000, 6533, 120, 91.63],
            [2000, 6534, 120, 119.04],
            [2000, 6535, 120, 90],
            [2000, 6536, 70.23, 106.94],
            [2000, 6537, 120, 90],
            [2000, 6538, 120, 90],
            [2000, 6539, 120, 90],
            [2000, 6540, 120, 90],
            [2000, 6541, 120, 90],
            [2000, 6542, 120, 108.36],
            [2000, 6543, 120, 90],
            [2000, 6544, 120, 90],
            [2000, 6546, 120, 90],
            [2000, 6547, 120, 90],
            [2000, 6548, 120, 90],
            [2000, 6549, 120, 90],
            [2000, 6550, 120, 90],
            [2000, 6551, 120, 90],
            [2000, 6552, 120, 108.36],
            [2000, 6553, 120, 90],
            [2000, 6554, 120, 90],
            [2000, 6555, 120, 90],
            [2000, 6556, 120, 90],
            [2000, 6557, 120, 90],
            [2000, 6558, 120, 90],
            [2000, 6559, 120, 90],
            [2000, 6560, 120, 90],
            [2000, 6561, 120, 90],
            [2000, 6562, 120, 90],
            [2000, 6563, 120, 90],
            [2000, 6564, 120, 90],
            [2000, 6565, 120, 90],
            [2000, 6566, 120, 78.64],
            [2000, 6567, 120, 90],
            [2000, 6568, 120, 109.36],
            [2000, 6569, 120, 90],
            [2000, 6570, 120, 90],
            [2000, 6572, 120, 90],
            [2000, 6573, 120, 90],
            [2000, 6574, 120, 90],
            [2000, 6575, 120, 119.04],
            [2000, 6576, 120, 90],
            [2000, 6577, 120, 90],
            [2000, 6578, 120, 109.36],
            [2000, 6579, 120, 90],
            [2000, 6580, 120, 90],
            [2000, 6581, 120, 90],
            [2000, 6582, 120, 90],
            [2000, 6583, 120, 90],
            [2000, 6584, 120, 90],
            [2000, 6585, 120, 109.36],
            [2000, 6586, 120, 130.57],
            [2000, 6587, 120, 90],
            [2000, 6588, 120, 109.36],
            [2000, 6589, 120, 90],
            [2000, 6590, 120, 90],
            [2000, 6591, 120, 90],
            [2000, 6592, 120, 90],
            [2000, 6593, 120, 90],
            [2000, 6594, 120, 90],
            [2000, 6595, 120, 90],
            [2000, 6596, 120, 90],
            [2000, 6597, 120, 90],
            [2000, 6598, 120, 90],
            [2000, 6599, 120, 90],
            [2000, 6600, 120, 90],
            [2000, 6601, 120, 90],
            [2000, 6602, 120, 125.74],
            [2000, 6603, 70, 70],
            [2000, 6604, 120, 119.04],
            [2000, 6605, 120, 108.36],
            [2000, 6606, 120, 90],
            [2000, 6607, 120, 125.74],
            [2000, 6608, 120, 109.36],
            [2000, 6609, 120, 90],
            [2000, 6610, 120, 90],
            [2000, 6611, 70, 91.63],
            [2000, 6612, 120, 119.04],
            [2000, 6613, 120, 90],
            [2000, 6614, 50, 101.08],
            [2000, 6615, 120, 130.57],
            [2000, 6616, 120, 90],
            [2000, 6617, 39.9, 34.9],
            [2000, 6618, 120, 90],
            [2000, 6619, 120, 90],
            [2000, 6620, 120, 90],
            [2000, 6621, 120, 90],
            [2000, 6622, 120, 90],
            [2000, 6623, 152, 95.28],
            [2000, 6624, 120, 108.36],
            [2000, 6625, 120, 90],
            [2000, 6626, 120, 90],
            [2000, 6627, 120, 90],
            [2000, 6628, 120, 90],
            [2000, 6629, 70, 70],
            [2000, 6630, 70, 70],
            [2000, 6631, 50, 60],
            [2000, 6632, 28, 35],
            [2000, 6633, 50, 60],
            [2000, 6634, 49, 49],
            [2000, 6635, 70, 70],
            [2000, 6636, 70, 70],
            [2000, 6637, 84, 63],
            [2000, 6638, 70, 70],
            [2000, 6639, 84, 63],
            [2000, 6640, 50, 60],
            [2000, 6641, 70, 70],
            [2000, 6642, 40, 50],
            [2000, 6643, 30, 40],
            [2000, 6648, 120, 90],
            [2000, 6649, 84, 63],
            [2000, 6650, 84, 63],
            [2000, 6651, 84, 63],
            [2000, 6652, 84, 63],
            [2000, 6653, 70, 70],
            [2000, 6654, 49, 49],
            [2000, 6655, 49, 49],
            [2000, 6656, 49, 49],
            [2000, 6657, 70, 70],
            [2000, 6660, 49, 49],
            [2000, 6661, 49, 49],
            [2000, 6662, 49, 49],
            [2000, 6663, 49, 49],
            [2000, 6664, 49, 49],
            [2000, 6665, 49, 49],
            [2000, 6666, 49, 49],
            [2000, 6667, 49, 49],
            [2000, 6668, 49, 49],
            [2000, 6669, 49, 49],
            [2000, 6670, 49, 49],
            [2000, 6671, 49, 49],
            [2000, 6672, 49, 49],
            [2000, 6673, 49, 49],
            [2000, 6674, 49, 49],
            [2000, 6675, 49, 49],
            [2000, 6676, 49, 49],
            [2000, 6677, 49, 49],
            [2000, 6678, 49, 49],
            [2000, 6679, 70, 70],
            [2000, 6680, 49, 49],
            [2000, 6682, 49, 49],
            [2000, 6683, 70, 70],
            [2000, 6684, 49, 49],
            [2000, 6685, 35, 42],
            [2000, 6686, 35, 42],
            [2000, 6687, 35, 42],
            [2000, 6688, 35, 42],
            [2000, 6689, 35, 42],
            [2000, 6690, 35, 42],
            [2000, 6691, 10.46, 2.78],
            [2000, 6692, 12.66, 2.21],
            [2000, 6697, 40, 50],
            [2000, 6698, 70, 70],
            [2000, 6699, 70, 70],
            [2000, 6700, 120, 90],
            [2000, 6701, 70, 70],
            [2000, 6702, 70, 70],
            [2000, 6703, 30, 40],
            [2000, 6704, 70, 70],
            [2000, 6705, 70, 70],
            [2000, 6706, 70, 70],
            [2000, 6707, 120, 90],
            [2000, 6708, 70, 70],
            [2000, 6709, 30, 40],
            [2000, 6710, 50, 60],
            [2000, 6711, 70, 70],
            [2000, 6712, 50, 60],
            [2000, 6713, 70, 70],
            [2000, 6714, 50, 60],
            [2000, 6715, 120, 90],
            [2000, 6716, 70, 70],
            [2000, 6717, 70, 70],
            [2000, 6718, 70, 70],
            [2000, 6719, 70, 70],
            [2000, 6720, 70, 70],
            [2000, 6721, 50, 60],
            [2000, 6722, 30, 40],
            [2000, 6723, 70, 70],
            [2000, 6724, 70, 70],
            [2000, 6725, 70, 70],
            [2000, 6726, 70, 70],
            [2000, 6727, 70, 70],
            [2000, 6728, 70, 70],
            [2000, 6729, 70, 70],
            [2000, 6730, 120, 90],
            [2000, 6731, 70, 70],
            [2000, 6732, 70, 70],
            [2000, 6733, 70, 70],
            [2000, 6734, 70, 70],
            [2000, 6735, 70, 70],
            [2000, 6736, 50, 60],
            [2000, 6737, 70, 70],
            [2000, 6738, 70, 70],
            [2000, 6739, 50, 60],
            [2000, 6740, 18, 27],
            [2000, 6741, 18, 27],
            [2000, 6742, 18, 27],
            [2000, 6743, 18, 27],
            [2000, 6746, 50, 60],
            [2000, 6748, 70, 70],
            [2000, 6749, 70, 70],
            [2000, 6750, 70, 70],
            [2000, 6752, 35, 42],
            [2000, 6753, 120, 90],
            [2000, 6754, 70, 70],
            [2000, 6755, 70, 70],
            [2000, 6756, 70, 70],
            [2000, 6757, 70, 70],
            [2000, 6758, 70, 70],
            [2000, 6759, 50, 60],
            [2000, 6760, 70, 70],
            [2000, 6761, 70, 70],
            [2000, 6762, 70, 70],
            [2000, 6763, 35, 42],
            [2000, 6764, 70, 70],
            [2000, 6766, 120, 90],
            [2000, 6767, 49, 49],
            [2000, 6768, 49, 49],
            [2000, 6769, 120, 90],
            [2000, 6770, 70, 70],
            [2000, 6771, 70, 70],
            [2000, 6772, 50, 60],
            [2000, 6773, 120, 90],
            [2000, 6777, 70, 70],
            [2000, 6778, 70, 70],
            [2000, 6779, 50, 60],
            [2000, 6780, 70, 70],
            [2000, 6781, 70, 70],
            [2000, 6782, 120, 90],
            [2000, 6783, 70, 70],
            [2000, 6784, 70, 70],
            [2000, 6785, 70, 70],
            [2000, 6786, 70, 70],
            [2000, 6787, 70, 70],
            [2000, 6789, 70, 70],
            [2000, 6790, 70, 70],
            [2000, 6791, 30, 40],
            [2000, 6792, 70, 70],
            [2000, 6793, 30, 40],
            [2000, 6794, 70, 70],
            [2000, 6795, 70, 70],
            [2000, 6796, 70, 70],
            [2000, 6797, 70, 70],
            [2000, 6798, 30, 40],
            [2000, 6799, 30, 40],
            [2000, 6800, 70, 70],
            [2000, 6801, 70, 70],
            [2000, 6802, 70, 70],
            [2000, 6803, 70, 70],
            [2000, 6804, 70, 70],
            [2000, 6805, 70, 70],
            [2000, 6806, 70, 70],
            [2000, 6807, 70, 70],
            [2000, 6808, 120, 90],
            [2000, 6809, 70, 70],
            [2000, 6810, 70, 70],
            [2000, 6811, 30, 40],
            [2000, 6812, 30, 40],
            [2000, 6813, 70, 70],
            [2000, 6814, 30, 40],
            [2000, 6815, 70, 70],
            [2000, 6816, 120, 90],
            [2000, 6817, 50, 60],
            [2000, 6818, 21.25, 24.78],
            [2000, 6819, 40, 48],
            [2000, 6820, 40, 48],
            [2000, 6821, 56, 56],
            [2000, 6822, 56, 56],
            [2000, 6823, 56, 56],
            [2000, 6824, 120, 90],
            [2000, 6825, 120, 90],
            [2000, 6826, 50, 60],
            [2000, 6827, 50, 60],
            [2000, 6828, 50, 60],
            [2000, 6829, 70, 70],
            [2000, 6830, 70, 70],
            [2000, 6831, 120, 90],
            [2000, 6832, 70, 70],
            [2000, 6833, 30, 40],
            [2000, 6834, 30, 40],
            [2000, 6835, 30, 40],
            [2000, 6836, 70, 70],
            [2000, 6837, 120, 90],
            [2000, 6838, 30, 40],
            [2000, 6841, 49, 49],
            [2000, 6842, 70, 70],
            [2000, 6843, 70, 70],
            [2000, 6844, 50, 60],
            [2000, 6845, 120, 90],
            [2000, 6846, 120, 90],
            [2000, 6847, 70, 70],
            [2000, 6848, 50, 60],
            [2000, 6849, 70, 70],
            [2000, 6850, 50, 60],
            [2000, 6851, 50, 60],
            [2000, 6852, 50, 60],
            [2000, 6853, 50, 60],
            [2000, 6854, 120, 90],
            [2000, 6855, 50, 60],
            [2000, 6856, 70, 70],
            [2000, 6857, 70, 70],
            [2000, 6858, 50, 60],
            [2000, 6859, 30, 40],
            [2000, 6860, 70, 70],
            [2000, 6861, 50, 60],
            [2000, 6862, 50, 60],
            [2000, 6864, 40, 50],
            [2000, 6865, 30, 45],
            [2000, 6866, 19.37, 24.9],
            [2001, 2, 51, 44],
            [2001, 7, 33, 33],
            [2001, 25, 14, 10],
            [2001, 42, 21, 22],
            [2001, 48, 95, 70],
            [2001, 49, 38, 26],
            [2001, 51, 32, 33],
            [2001, 62, 22, 32],
            [2001, 65, 27, 23],
            [2001, 78, 21, 21],
            [2001, 82, 12, 21],
            [2001, 83, 43, 50],
            [2001, 87, 39, 33],
            [2001, 99, 33, 33],
            [2001, 101, 70, 57],
            [2001, 119, 45, 33],
            [2001, 122, 37, 22],
            [2001, 125, 35, 37],
            [2001, 135, 21, 21],
            [2001, 138, 35, 33],
            [2001, 163, 31, 28],
            [2001, 166, 43, 43],
            [2001, 169, 28, 22],
            [2001, 186, 17, 22],
            [2001, 190, 33, 32],
            [2001, 194, 27, 27],
            [2001, 200, 45, 34],
            [2001, 204, 12, 21],
            [2001, 211, 22, 54],
            [2001, 215, 31, 33],
            [2001, 216, 26, 22],
            [2001, 218, 69, 28],
            [2001, 220, 20, 21],
            [2001, 226, 18, 20],
            [2001, 230, 54, 50],
            [2001, 231, 60, 53],
            [2001, 233, 18, 19],
            [2001, 234, 12, 18],
            [2001, 239, 22, 22],
            [2001, 240, 21, 19],
            [2001, 242, 37, 21],
            [2001, 243, 32, 33],
            [2001, 246, 64, 38],
            [2001, 248, 22, 21],
            [2001, 270, 32, 32],
            [2001, 272, 62, 19],
            [2001, 282, 48, 24],
            [2001, 285, 21, 22],
            [2001, 286, 22, 13],
            [2001, 299, 21, 22],
            [2001, 305, 22, 22],
            [2001, 306, 33, 33],
            [2001, 308, 13, 53],
            [2001, 310, 23, 22],
            [2001, 312, 22, 22],
            [2001, 314, 20, 30],
            [2001, 317, 32, 33],
            [2001, 320, 26, 30],
            [2001, 324, 54, 45],
            [2001, 327, 51, 46],
            [2001, 329, 44, 36],
            [2001, 330, 32, 33],
            [2001, 332, 33, 33],
            [2001, 334, 39, 34],
            [2001, 337, 27, 19],
            [2001, 339, 25, 22],
            [2001, 344, 35, 21],
            [2001, 346, 47, 40],
            [2001, 355, 55, 37],
            [2001, 361, 33, 33],
            [2001, 365, 50, 36],
            [2001, 378, 22, 27],
            [2001, 379, 16, 14],
            [2001, 389, 18, 26],
            [2001, 392, 21, 22],
            [2001, 399, 85, 41],
            [2001, 402, 38, 32],
            [2001, 403, 33, 34],
            [2001, 418, 24, 22],
            [2001, 424, 22, 22],
            [2001, 425, 19, 30],
            [2001, 428, 31, 22],
            [2001, 430, 22, 29],
            [2001, 432, 40, 34],
            [2001, 436, 29, 24],
            [2001, 455, 30, 27],
            [2001, 471, 21, 22],
            [2001, 479, 39, 38],
            [2001, 480, 70, 29],
            [2001, 487, 36, 33],
            [2001, 493, 32, 33],
            [2001, 494, 17, 19],
            [2001, 497, 11, 16],
            [2001, 503, 72, 24],
            [2001, 504, 16, 14],
            [2001, 505, 31, 34],
            [2001, 519, 20, 30],
            [2001, 525, 20, 34],
            [2001, 536, 21, 21],
            [2001, 541, 87, 45],
            [2001, 545, 23, 28],
            [2001, 568, 22, 22],
            [2001, 569, 59, 33],
            [2001, 570, 28, 22],
            [2001, 573, 33, 34],
            [2001, 577, 32, 26],
            [2001, 579, 56, 50],
            [2001, 585, 70, 62],
            [2001, 590, 44, 49],
            [2001, 593, 49, 45],
            [2001, 595, 33, 33],
            [2001, 597, 26, 10],
            [2001, 599, 17, 25],
            [2001, 604, 60, 36],
            [2001, 608, 32, 22],
            [2001, 612, 53, 50],
            [2001, 618, 29, 23],
            [2001, 625, 26, 19],
            [2001, 627, 38, 35],
            [2001, 628, 33, 33],
            [2001, 631, 21, 22],
            [2001, 654, 15, 12],
            [2001, 660, 35, 36],
            [2001, 662, 82, 55],
            [2001, 663, 60, 37],
            [2001, 669, 38, 26],
            [2001, 678, 21, 29],
            [2001, 686, 17, 27],
            [2001, 691, 25, 22],
            [2001, 694, 45, 37],
            [2001, 695, 85, 63],
            [2001, 700, 65, 47],
            [2001, 703, 12, 19],
            [2001, 704, 29, 34],
            [2001, 709, 55, 38],
            [2001, 716, 70, 64],
            [2001, 717, 42, 33],
            [2001, 719, 34, 31],
            [2001, 720, 25, 22],
            [2001, 724, 32, 33],
            [2001, 727, 58, 57],
            [2001, 734, 22, 32],
            [2001, 737, 14, 12],
            [2001, 750, 22, 22],
            [2001, 751, 35, 19],
            [2001, 754, 32, 33],
            [2001, 766, 79, 34],
            [2001, 769, 41, 51],
            [2001, 773, 32, 34],
            [2001, 781, 30, 24],
            [2001, 783, 22, 28],
            [2001, 785, 66, 66],
            [2001, 790, 51, 35],
            [2001, 801, 21, 22],
            [2001, 803, 39, 37],
            [2001, 805, 44, 31],
            [2001, 811, 30, 26],
            [2001, 815, 16, 16],
            [2001, 820, 45, 52],
            [2001, 821, 21, 22],
            [2001, 822, 19, 23],
            [2001, 826, 21, 22],
            [2001, 827, 11, 15],
            [2001, 835, 32, 33],
            [2001, 843, 33, 33],
            [2001, 844, 32, 26],
            [2001, 845, 70, 34],
            [2001, 848, 27, 22],
            [2001, 865, 57, 36],
            [2001, 871, 47, 26],
            [2001, 878, 7, 6],
            [2001, 882, 50, 39],
            [2001, 890, 21, 22],
            [2001, 894, 30, 12],
            [2001, 909, 79, 46],
            [2001, 913, 21, 18],
            [2001, 915, 66, 43],
            [2001, 922, 59, 41],
            [2001, 926, 76, 24],
            [2001, 938, 12, 14],
            [2001, 940, 12, 15],
            [2001, 941, 44, 42],
            [2001, 944, 26, 22],
            [2001, 949, 78, 38],
            [2001, 950, 17, 22],
            [2001, 964, 13, 17],
            [2001, 969, 47, 44],
            [2001, 971, 23, 19],
            [2001, 972, 43, 28],
            [2001, 978, 57, 43],
            [2001, 979, 22, 22],
            [2001, 985, 92, 46],
            [2001, 990, 26, 22],
            [2001, 993, 70, 45],
            [2001, 998, 40, 23],
            [2001, 1003, 8, 6],
            [2001, 1006, 13, 20],
            [2001, 1008, 24, 26],
            [2001, 1016, 11, 16],
            [2001, 1030, 9, 15],
            [2001, 1033, 21, 22],
            [2001, 1042, 120, 55],
            [2001, 1048, 46, 45],
            [2001, 1051, 29, 22],
            [2001, 1056, 23, 46],
            [2001, 1059, 51, 55],
            [2001, 1071, 109, 33],
            [2001, 1073, 58, 38],
            [2001, 1082, 61, 52],
            [2001, 1084, 91, 39],
            [2001, 1094, 21, 22],
            [2001, 1095, 22, 22],
            [2001, 1097, 37, 20],
            [2001, 1100, 24, 25],
            [2001, 1102, 16, 18],
            [2001, 1106, 108, 38],
            [2001, 1109, 30, 33],
            [2001, 1111, 43, 58],
            [2001, 1124, 71, 42],
            [2001, 1131, 35, 33],
            [2001, 1132, 12, 15],
            [2001, 1136, 51, 57],
            [2001, 1140, 33, 28],
            [2001, 1141, 33, 33],
            [2001, 1142, 29, 29],
            [2001, 1144, 35, 25],
            [2001, 1145, 32, 25],
            [2001, 1150, 40, 30],
            [2001, 1155, 33, 33],
            [2001, 1156, 30, 20],
            [2001, 1157, 41, 28],
            [2001, 1159, 57, 49],
            [2001, 1167, 21, 21],
            [2001, 1169, 22, 22],
            [2001, 1174, 32, 48],
            [2001, 1175, 23, 22],
            [2001, 1177, 43, 34],
            [2001, 1186, 15, 22],
            [2001, 1194, 120, 52],
            [2001, 1200, 21, 22],
            [2001, 1203, 11, 19],
            [2001, 1205, 22, 22],
            [2001, 1213, 23, 23],
            [2001, 1217, 33, 34],
            [2001, 1219, 22, 22],
            [2001, 1221, 23, 22],
            [2001, 1224, 33, 33],
            [2001, 1226, 24, 16],
            [2001, 1228, 20, 21],
            [2001, 1234, 12, 16],
            [2001, 1235, 28, 25],
            [2001, 1238, 14, 29],
            [2001, 1247, 65, 38],
            [2001, 1254, 60, 31],
            [2001, 1262, 33, 33],
            [2001, 1268, 51, 36],
            [2001, 1275, 25, 15],
            [2001, 1281, 17, 24],
            [2001, 1295, 50, 60],
            [2001, 1302, 60, 73],
            [2001, 1303, 95, 46],
            [2001, 1305, 19, 22],
            [2001, 1319, 59, 28],
            [2001, 1320, 48, 46],
            [2001, 1323, 25, 22],
            [2001, 1334, 21, 21],
            [2001, 1358, 60, 32],
            [2001, 1359, 32, 33],
            [2001, 1361, 33, 33],
            [2001, 1363, 35, 34],
            [2001, 1367, 43, 49],
            [2001, 1370, 15, 25],
            [2001, 1375, 21, 22],
            [2001, 1376, 30, 27],
            [2001, 1396, 11, 20],
            [2001, 1420, 59, 54],
            [2001, 1445, 75, 19],
            [2001, 1454, 26, 33],
            [2001, 1456, 33, 33],
            [2001, 1465, 18, 21],
            [2001, 1466, 40, 27],
            [2001, 1471, 34, 33],
            [2001, 1473, 17, 25],
            [2001, 1475, 35, 33],
            [2001, 1476, 33, 34],
            [2001, 1477, 22, 22],
            [2001, 1481, 50, 33],
            [2001, 1482, 13, 17],
            [2001, 1484, 34, 34],
            [2001, 1486, 14, 14],
            [2001, 1490, 24, 22],
            [2001, 1491, 12, 9],
            [2001, 1493, 30, 22],
            [2001, 1507, 40, 27],
            [2001, 1508, 32, 33],
            [2001, 1510, 17, 22],
            [2001, 1511, 32, 33],
            [2001, 1515, 25, 20],
            [2001, 1522, 15, 22],
            [2001, 1525, 53, 51],
            [2001, 1527, 31, 33],
            [2001, 1530, 63, 59],
            [2001, 1536, 19, 20],
            [2001, 1537, 34, 31],
            [2001, 1548, 31, 34],
            [2001, 1553, 32, 33],
            [2001, 1555, 60, 50],
            [2001, 1556, 33, 33],
            [2001, 1557, 37, 34],
            [2001, 1561, 21, 22],
            [2001, 1562, 32, 33],
            [2001, 1568, 34, 33],
            [2001, 1575, 103, 69],
            [2001, 1577, 30, 23],
            [2001, 1580, 50, 41],
            [2001, 1582, 30, 30],
            [2001, 1587, 17, 21],
            [2001, 1589, 49, 22],
            [2001, 1593, 13, 14],
            [2001, 1598, 16, 9],
            [2001, 1610, 33, 34],
            [2001, 1628, 40, 24],
            [2001, 1635, 19, 18],
            [2001, 1638, 34, 54],
            [2001, 1644, 38, 33],
            [2001, 1645, 50, 33],
            [2001, 1659, 28, 25],
            [2001, 1660, 32, 34],
            [2001, 1662, 15, 12],
            [2001, 1663, 33, 34],
            [2001, 1664, 18, 16],
            [2001, 1672, 21, 22],
            [2001, 1673, 72, 48],
            [2001, 1680, 31, 33],
            [2001, 1685, 50, 45],
            [2001, 1704, 19, 23],
            [2001, 1717, 65, 32],
            [2001, 1724, 22, 22],
            [2001, 1730, 17, 13],
            [2001, 1744, 33, 33],
            [2001, 1748, 32, 33],
            [2001, 1756, 33, 33],
            [2001, 1760, 13, 17],
            [2001, 1763, 26, 26],
            [2001, 1769, 63, 54],
            [2001, 1771, 21, 22],
            [2001, 1772, 11, 16],
            [2001, 1774, 31, 33],
            [2001, 1776, 32, 20],
            [2001, 1780, 20, 22],
            [2001, 1781, 22, 21],
            [2001, 1786, 20, 27],
            [2001, 1790, 21, 21],
            [2001, 1792, 34, 34],
            [2001, 1794, 38, 41],
            [2001, 1795, 14, 10],
            [2001, 1797, 70, 50],
            [2001, 1798, 45, 60],
            [2001, 1804, 21, 22],
            [2001, 1812, 15, 19],
            [2001, 1816, 114, 27],
            [2001, 1818, 22, 22],
            [2001, 1824, 43, 50],
            [2001, 1825, 22, 32],
            [2001, 1829, 20, 30],
            [2001, 1841, 53, 53],
            [2001, 1845, 33, 33],
            [2001, 1848, 33, 33],
            [2001, 1853, 71, 29],
            [2001, 1864, 81, 75],
            [2001, 1866, 70, 39],
            [2001, 1869, 40, 47],
            [2001, 1876, 32, 33],
            [2001, 1879, 26, 22],
            [2001, 1882, 19, 22],
            [2001, 1891, 33, 50],
            [2001, 1894, 40, 16],
            [2001, 1901, 21, 22],
            [2001, 1903, 108, 40],
            [2001, 1915, 52, 42],
            [2001, 1916, 21, 19],
            [2001, 1917, 32, 33],
            [2001, 1921, 24, 22],
            [2001, 1925, 33, 33],
            [2001, 1930, 11, 9],
            [2001, 1933, 12, 16],
            [2001, 1945, 31, 33],
            [2001, 1948, 27, 36],
            [2001, 1950, 22, 40],
            [2001, 1952, 120, 79],
            [2001, 1962, 14, 18],
            [2001, 1965, 68, 53],
            [2001, 1995, 33, 33],
            [2001, 2000, 34, 33],
            [2001, 2001, 40, 30],
            [2001, 2006, 26, 24],
            [2001, 2011, 12, 18],
            [2001, 2017, 49, 50],
            [2001, 2021, 33, 33],
            [2001, 2023, 12, 12],
            [2001, 2025, 33, 34],
            [2001, 2026, 53, 36],
            [2001, 2028, 51, 27],
            [2001, 2029, 31, 33],
            [2001, 2032, 17, 20],
            [2001, 2035, 70, 39],
            [2001, 2042, 21, 22],
            [2001, 2048, 14, 32],
            [2001, 2056, 42, 49],
            [2001, 2057, 117, 48],
            [2001, 2064, 60, 39],
            [2001, 2081, 21, 22],
            [2001, 2084, 65, 35],
            [2001, 2098, 16, 19],
            [2001, 2099, 27, 22],
            [2001, 2101, 10, 14],
            [2001, 2104, 35, 33],
            [2001, 2121, 19, 18],
            [2001, 2127, 20, 13],
            [2001, 2128, 33, 33],
            [2001, 2131, 31, 42],
            [2001, 2138, 30, 29],
            [2001, 2142, 10, 11],
            [2001, 2144, 24, 76],
            [2001, 2162, 21, 43],
            [2001, 2163, 42, 20],
            [2001, 2170, 29, 22],
            [2001, 2171, 32, 30],
            [2001, 2174, 30, 23],
            [2001, 2178, 13, 21],
            [2001, 2180, 33, 34],
            [2001, 2181, 34, 33],
            [2001, 2182, 32, 34],
            [2001, 2190, 30, 25],
            [2001, 2198, 26, 19],
            [2001, 2201, 33, 33],
            [2001, 2208, 55, 39],
            [2001, 2213, 50, 41],
            [2001, 2216, 26, 34],
            [2001, 2220, 21, 22],
            [2001, 2224, 32, 36],
            [2001, 2227, 20, 21],
            [2001, 2232, 33, 33],
            [2001, 2236, 20, 22],
            [2001, 2238, 33, 33],
            [2001, 2239, 24, 22],
            [2001, 2244, 27, 29],
            [2001, 2250, 50, 34],
            [2001, 2255, 32, 32],
            [2001, 2258, 33, 34],
            [2001, 2277, 35, 30],
            [2001, 2280, 9, 7],
            [2001, 2282, 22, 65],
            [2001, 2293, 33, 33],
            [2001, 2297, 111, 40],
            [2001, 2300, 51, 60],
            [2001, 2303, 21, 22],
            [2001, 2311, 42, 41],
            [2001, 2312, 21, 22],
            [2001, 2316, 63, 39],
            [2001, 2332, 16, 17],
            [2001, 2335, 33, 33],
            [2001, 2343, 29, 19],
            [2001, 2352, 49, 41],
            [2001, 2356, 120, 57],
            [2001, 2366, 17, 18],
            [2001, 2367, 36, 33],
            [2001, 2371, 64, 36],
            [2001, 2383, 37, 22],
            [2001, 2384, 30, 43],
            [2001, 2404, 32, 33],
            [2001, 2405, 31, 35],
            [2001, 2428, 38, 22],
            [2001, 2429, 12, 12],
            [2001, 2433, 63, 25],
            [2001, 2435, 20, 17],
            [2001, 2443, 65, 39],
            [2001, 2447, 20, 21],
            [2001, 2458, 17, 15],
            [2001, 2459, 14, 19],
            [2001, 2467, 12, 17],
            [2001, 2472, 36, 24],
            [2001, 2483, 73, 52],
            [2001, 2485, 14, 14],
            [2001, 2488, 27, 28],
            [2001, 2493, 26, 22],
            [2001, 2494, 31, 33],
            [2001, 2497, 21, 22],
            [2001, 2500, 31, 21],
            [2001, 2501, 69, 30],
            [2001, 2505, 50, 35],
            [2001, 2509, 16, 19],
            [2001, 2514, 36, 33],
            [2001, 2516, 33, 33],
            [2001, 2518, 32, 33],
            [2001, 2524, 11, 12],
            [2001, 2527, 27, 21],
            [2001, 2533, 11, 19],
            [2001, 2539, 62, 29],
            [2001, 2540, 23, 25],
            [2001, 2543, 24, 24],
            [2001, 2547, 17, 16],
            [2001, 2551, 43, 33],
            [2001, 2554, 12, 12],
            [2001, 2555, 40, 25],
            [2001, 2562, 38, 34],
            [2001, 2564, 20, 22],
            [2001, 2574, 31, 33],
            [2001, 2576, 63, 32],
            [2001, 2585, 62, 51],
            [2001, 2587, 32, 33],
            [2001, 2593, 30, 33],
            [2001, 2595, 45, 42],
            [2001, 2603, 98, 45],
            [2001, 2604, 33, 33],
            [2001, 2606, 22, 16],
            [2001, 2607, 11, 10],
            [2001, 2612, 31, 32],
            [2001, 2615, 37, 33],
            [2001, 2617, 50, 27],
            [2001, 2619, 12, 13],
            [2001, 2622, 31, 22],
            [2001, 2627, 70, 40],
            [2001, 2628, 22, 22],
            [2001, 2632, 32, 20],
            [2001, 2633, 32, 33],
            [2001, 2635, 13, 22],
            [2001, 2644, 29, 22],
            [2001, 2647, 36, 31],
            [2001, 2650, 25, 22],
            [2001, 2656, 22, 21],
            [2001, 2658, 32, 33],
            [2001, 2667, 32, 34],
            [2001, 2668, 32, 33],
            [2001, 2669, 58, 51],
            [2001, 2670, 50, 34],
            [2001, 2671, 52, 60],
            [2001, 2684, 36, 19],
            [2001, 2687, 28, 19],
            [2001, 2692, 65, 29],
            [2001, 2695, 12, 13],
            [2001, 2720, 38, 42],
            [2001, 2723, 45, 70],
            [2001, 2743, 33, 33],
            [2001, 2747, 32, 32],
            [2001, 2748, 33, 33],
            [2001, 2758, 37, 33],
            [2001, 2762, 97, 52],
            [2001, 2775, 65, 39],
            [2001, 2785, 14, 16],
            [2001, 2787, 37, 28],
            [2001, 2788, 33, 33],
            [2001, 2791, 44, 28],
            [2001, 2797, 15, 16],
            [2001, 2798, 12, 21],
            [2001, 2813, 31, 33],
            [2001, 2822, 30, 25],
            [2001, 2823, 22, 22],
            [2001, 2827, 14, 20],
            [2001, 2832, 16, 16],
            [2001, 2833, 57, 37],
            [2001, 2835, 38, 35],
            [2001, 2836, 35, 18],
            [2001, 2838, 50, 41],
            [2001, 2846, 28, 29],
            [2001, 2851, 22, 18],
            [2001, 2854, 38, 40],
            [2001, 2856, 38, 33],
            [2001, 2867, 22, 22],
            [2001, 2872, 19, 22],
            [2001, 2876, 32, 34],
            [2001, 2879, 25, 26],
            [2001, 2880, 39, 31],
            [2001, 2883, 36, 34],
            [2001, 2884, 26, 45],
            [2001, 2897, 120, 63],
            [2001, 2901, 80, 66],
            [2001, 2904, 53, 36],
            [2001, 2910, 21, 22],
            [2001, 2914, 50, 34],
            [2001, 2918, 58, 41],
            [2001, 2922, 17, 17],
            [2001, 2923, 33, 33],
            [2001, 2929, 34, 33],
            [2001, 2932, 36, 36],
            [2001, 2934, 24, 22],
            [2001, 2935, 80, 36],
            [2001, 2936, 25, 22],
            [2001, 2946, 34, 22],
            [2001, 2950, 33, 33],
            [2001, 2969, 23, 19],
            [2001, 2973, 41, 54],
            [2001, 2974, 48, 24],
            [2001, 2978, 32, 33],
            [2001, 2979, 28, 17],
            [2001, 2991, 45, 48],
            [2001, 2995, 22, 22],
            [2001, 3009, 42, 47],
            [2001, 3011, 33, 33],
            [2001, 3016, 34, 34],
            [2001, 3019, 48, 24],
            [2001, 3027, 20, 22],
            [2001, 3033, 95, 54],
            [2001, 3035, 21, 21],
            [2001, 3041, 36, 27],
            [2001, 3046, 32, 14],
            [2001, 3048, 49, 25],
            [2001, 3050, 36, 23],
            [2001, 3053, 80, 70],
            [2001, 3061, 33, 34],
            [2001, 3066, 63, 33],
            [2001, 3070, 35, 38],
            [2001, 3077, 40, 22],
            [2001, 3086, 81, 27],
            [2001, 3091, 10, 16],
            [2001, 3092, 50, 27],
            [2001, 3098, 21, 21],
            [2001, 3106, 20, 22],
            [2001, 3112, 62, 33],
            [2001, 3114, 33, 31],
            [2001, 3119, 12, 28],
            [2001, 3121, 21, 22],
            [2001, 3122, 33, 33],
            [2001, 3123, 120, 43],
            [2001, 3126, 50, 23],
            [2001, 3129, 39, 49],
            [2001, 3133, 29, 22],
            [2001, 3134, 54, 45],
            [2001, 3137, 33, 33],
            [2001, 3142, 41, 50],
            [2001, 3148, 37, 34],
            [2001, 3154, 35, 33],
            [2001, 3155, 29, 23],
            [2001, 3158, 16, 19],
            [2001, 3160, 21, 22],
            [2001, 3161, 22, 22],
            [2001, 3164, 60, 40],
            [2001, 3167, 23, 33],
            [2001, 3171, 40, 22],
            [2001, 3175, 41, 29],
            [2001, 3182, 22, 26],
            [2001, 3188, 44, 42],
            [2001, 3189, 40, 33],
            [2001, 3195, 21, 22],
            [2001, 3206, 33, 33],
            [2001, 3217, 32, 33],
            [2001, 3221, 50, 24],
            [2001, 3228, 32, 33],
            [2001, 3231, 22, 22],
            [2001, 3234, 62, 28],
            [2001, 3246, 64, 37],
            [2001, 3248, 21, 24],
            [2001, 3251, 40, 49],
            [2001, 3252, 44, 29],
            [2001, 3254, 26, 19],
            [2001, 3256, 23, 25],
            [2001, 3264, 34, 34],
            [2001, 3268, 33, 33],
            [2001, 3272, 27, 24],
            [2001, 3273, 90, 20],
            [2001, 3274, 34, 28],
            [2001, 3277, 36, 25],
            [2001, 3280, 32, 33],
            [2001, 3283, 27, 22],
            [2001, 3284, 21, 22],
            [2001, 3289, 71, 59],
            [2001, 3301, 46, 45],
            [2001, 3306, 24, 30],
            [2001, 3308, 70, 41],
            [2001, 3309, 50, 45],
            [2001, 3320, 62, 68],
            [2001, 3321, 50, 28],
            [2001, 3326, 21, 22],
            [2001, 3327, 57, 60],
            [2001, 3331, 21, 21],
            [2001, 3336, 27, 22],
            [2001, 3344, 21, 21],
            [2001, 3346, 21, 37],
            [2001, 3348, 65, 34],
            [2001, 3357, 12, 19],
            [2001, 3358, 16, 19],
            [2001, 3363, 82, 34],
            [2001, 3364, 11, 19],
            [2001, 3372, 60, 36],
            [2001, 3382, 44, 27],
            [2001, 3404, 43, 34],
            [2001, 3407, 21, 22],
            [2001, 3418, 88, 42],
            [2001, 3422, 26, 20],
            [2001, 3429, 32, 33],
            [2001, 3434, 7, 6],
            [2001, 3438, 60, 33],
            [2001, 3439, 22, 22],
            [2001, 3441, 31, 32],
            [2001, 3442, 21, 22],
            [2001, 3451, 53, 57],
            [2001, 3453, 21, 22],
            [2001, 3454, 13, 10],
            [2001, 3457, 33, 34],
            [2001, 3459, 28, 24],
            [2001, 3462, 56, 25],
            [2001, 3468, 23, 22],
            [2001, 3469, 34, 20],
            [2001, 3476, 34, 44],
            [2001, 3494, 12, 15],
            [2001, 3498, 22, 30],
            [2001, 3503, 97, 62],
            [2001, 3511, 20, 36],
            [2001, 3515, 17, 77],
            [2001, 3517, 63, 24],
            [2001, 3531, 31, 22],
            [2001, 3541, 24, 30],
            [2001, 3557, 10, 16],
            [2001, 3559, 50, 44],
            [2001, 3566, 14, 12],
            [2001, 3569, 76, 77],
            [2001, 3572, 32, 32],
            [2001, 3579, 22, 33],
            [2001, 3590, 35, 38],
            [2001, 3593, 57, 23],
            [2001, 3598, 18, 14],
            [2001, 3602, 22, 22],
            [2001, 3608, 30, 32],
            [2001, 3632, 33, 33],
            [2001, 3639, 22, 22],
            [2001, 3642, 36, 31],
            [2001, 3644, 33, 33],
            [2001, 3650, 44, 32],
            [2001, 3653, 22, 22],
            [2001, 3656, 32, 33],
            [2001, 3659, 21, 17],
            [2001, 3661, 34, 34],
            [2001, 3667, 21, 22],
            [2001, 3669, 11, 22],
            [2001, 3670, 44, 33],
            [2001, 3679, 21, 22],
            [2001, 3700, 27, 32],
            [2001, 3703, 34, 35],
            [2001, 3718, 60, 31],
            [2001, 3726, 12, 13],
            [2001, 3729, 120, 32],
            [2001, 3731, 30, 25],
            [2001, 3747, 31, 25],
            [2001, 3751, 26, 22],
            [2001, 3755, 33, 34],
            [2001, 3761, 23, 24],
            [2001, 3765, 29, 19],
            [2001, 3777, 33, 24],
            [2001, 3782, 82, 35],
            [2001, 3786, 14, 12],
            [2001, 3795, 31, 33],
            [2001, 3796, 33, 34],
            [2001, 3802, 56, 60],
            [2001, 3807, 21, 21],
            [2001, 3827, 33, 33],
            [2001, 3828, 22, 25],
            [2001, 3832, 33, 33],
            [2001, 3833, 27, 14],
            [2001, 3834, 33, 40],
            [2001, 3841, 30, 33],
            [2001, 3845, 34, 34],
            [2001, 3854, 21, 22],
            [2001, 3855, 21, 21],
            [2001, 3859, 12, 16],
            [2001, 3870, 36, 34],
            [2001, 3871, 23, 26],
            [2001, 3874, 32, 33],
            [2001, 3883, 21, 22],
            [2001, 3884, 65, 39],
            [2001, 3889, 90, 33],
            [2001, 3897, 30, 33],
            [2001, 3900, 29, 28],
            [2001, 3905, 34, 34],
            [2001, 3915, 32, 33],
            [2001, 3921, 33, 34],
            [2001, 3925, 76, 56],
            [2001, 3932, 28, 36],
            [2001, 3942, 20, 34],
            [2001, 3943, 18, 30],
            [2001, 3947, 59, 46],
            [2001, 3953, 33, 33],
            [2001, 3956, 48, 57],
            [2001, 3959, 21, 21],
            [2001, 3960, 43, 33],
            [2001, 3963, 30, 16],
            [2001, 3969, 105, 53],
            [2001, 3970, 33, 33],
            [2001, 3972, 99, 73],
            [2001, 3976, 17, 16],
            [2001, 3985, 34, 26],
            [2001, 3988, 25, 34],
            [2001, 3992, 33, 34],
            [2001, 3993, 11, 14],
            [2001, 3999, 31, 33],
            [2001, 4015, 65, 35],
            [2001, 4022, 50, 33],
            [2001, 4023, 32, 33],
            [2001, 4026, 42, 21],
            [2001, 4027, 100, 43],
            [2001, 4028, 38, 49],
            [2001, 4031, 18, 15],
            [2001, 4034, 106, 56],
            [2001, 4035, 22, 22],
            [2001, 4038, 120, 47],
            [2001, 4040, 33, 34],
            [2001, 4043, 19, 19],
            [2001, 4047, 34, 40],
            [2001, 4074, 25, 38],
            [2001, 4082, 102, 45],
            [2001, 4084, 12, 19],
            [2001, 4091, 44, 17],
            [2001, 4095, 33, 33],
            [2001, 4096, 31, 33],
            [2001, 4106, 31, 33],
            [2001, 4107, 80, 34],
            [2001, 4109, 19, 20],
            [2001, 4111, 21, 14],
            [2001, 4116, 32, 33],
            [2001, 4118, 33, 34],
            [2001, 4120, 32, 33],
            [2001, 4122, 73, 68],
            [2001, 4124, 31, 32],
            [2001, 4125, 13, 18],
            [2001, 4134, 39, 33],
            [2001, 4152, 134, 59],
            [2001, 4156, 22, 23],
            [2001, 4164, 22, 22],
            [2001, 4165, 47, 46],
            [2001, 4169, 30, 23],
            [2001, 4173, 12, 19],
            [2001, 4176, 11, 16],
            [2001, 4177, 58, 40],
            [2001, 4182, 32, 33],
            [2001, 4185, 21, 22],
            [2001, 4188, 113, 29],
            [2001, 4189, 22, 34],
            [2001, 4199, 50, 33],
            [2001, 4203, 33, 34],
            [2001, 4206, 17, 19],
            [2001, 4209, 22, 20],
            [2001, 4229, 29, 23],
            [2001, 4242, 21, 21],
            [2001, 4246, 12, 16],
            [2001, 4250, 79, 27],
            [2001, 4272, 33, 34],
            [2001, 4279, 28, 34],
            [2001, 4283, 20, 20],
            [2001, 4285, 38, 34],
            [2001, 4298, 50, 62],
            [2001, 4299, 23, 41],
            [2001, 4301, 67, 34],
            [2001, 4302, 18, 19],
            [2001, 4310, 36, 29],
            [2001, 4312, 63, 36],
            [2001, 4318, 21, 22],
            [2001, 4320, 34, 33],
            [2001, 4325, 66, 34],
            [2001, 4326, 11, 14],
            [2001, 4329, 23, 34],
            [2001, 4333, 18, 23],
            [2001, 4338, 34, 33],
            [2001, 4345, 20, 23],
            [2001, 4349, 32, 33],
            [2001, 4350, 20, 22],
            [2001, 4352, 22, 22],
            [2001, 4353, 30, 28],
            [2001, 4358, 13, 17],
            [2001, 4362, 54, 34],
            [2001, 4364, 21, 22],
            [2001, 4380, 19, 14],
            [2001, 4382, 63, 53],
            [2001, 4384, 37, 22],
            [2001, 4386, 15, 19],
            [2001, 4391, 21, 21],
            [2001, 4406, 51, 35],
            [2001, 4413, 13, 13],
            [2001, 4414, 15, 26],
            [2001, 4415, 105, 31],
            [2001, 4421, 33, 33],
            [2001, 4426, 11, 15],
            [2001, 4438, 63, 30],
            [2001, 4440, 50, 38],
            [2001, 4441, 17, 13],
            [2001, 4442, 15, 22],
            [2001, 4446, 33, 34],
            [2001, 4454, 25, 23],
            [2001, 4461, 41, 30],
            [2001, 4464, 64, 31],
            [2001, 4470, 35, 40],
            [2001, 4471, 22, 22],
            [2001, 4477, 34, 39],
            [2001, 4487, 37, 50],
            [2001, 4491, 55, 40],
            [2001, 4494, 20, 20],
            [2001, 4495, 30, 23],
            [2001, 4500, 30, 22],
            [2001, 4504, 68, 43],
            [2001, 4506, 21, 22],
            [2001, 4508, 37, 32],
            [2001, 4510, 30, 25],
            [2001, 4515, 33, 33],
            [2001, 4518, 44, 33],
            [2001, 4521, 31, 33],
            [2001, 4524, 32, 33],
            [2001, 4532, 24, 22],
            [2001, 4536, 23, 21],
            [2001, 4542, 50, 31],
            [2001, 4545, 56, 43],
            [2001, 4550, 32, 33],
            [2001, 4552, 16, 19],
            [2001, 4558, 30, 29],
            [2001, 4563, 32, 34],
            [2001, 4572, 33, 21],
            [2001, 4587, 36, 28],
            [2001, 4591, 24, 22],
            [2001, 4601, 61, 33],
            [2001, 4602, 26, 33],
            [2001, 4606, 21, 22],
            [2001, 4608, 23, 25],
            [2001, 4610, 64, 31],
            [2001, 4611, 21, 22],
            [2001, 4613, 52, 43],
            [2001, 4616, 24, 19],
            [2001, 4617, 100, 43],
            [2001, 4618, 29, 28],
            [2001, 4623, 15, 20],
            [2001, 4626, 38, 25],
            [2001, 4631, 16, 16],
            [2001, 4633, 21, 22],
            [2001, 4634, 33, 32],
            [2001, 4635, 90, 15],
            [2001, 4638, 80, 46],
            [2001, 4643, 24, 19],
            [2001, 4644, 14, 19],
            [2001, 4648, 32, 11],
            [2001, 4660, 70, 33],
            [2001, 4668, 33, 33],
            [2001, 4670, 70, 26],
            [2001, 4676, 14, 23],
            [2001, 4684, 25, 22],
            [2001, 4689, 50, 36],
            [2001, 4693, 34, 32],
            [2001, 4694, 24, 24],
            [2001, 4703, 11, 16],
            [2001, 4710, 9, 7],
            [2001, 4711, 17, 16],
            [2001, 4712, 27, 20],
            [2001, 4717, 22, 22],
            [2001, 4724, 38, 23],
            [2001, 4728, 27, 24],
            [2001, 4729, 42, 33],
            [2001, 4732, 96, 113],
            [2001, 4734, 19, 19],
            [2001, 4738, 46, 57],
            [2001, 4745, 20, 25],
            [2001, 4747, 74, 39],
            [2001, 4749, 50, 38],
            [2001, 4753, 28, 23],
            [2001, 4762, 69, 66],
            [2001, 4764, 58, 51],
            [2001, 4777, 23, 24],
            [2001, 4780, 21, 21],
            [2001, 4781, 30, 35],
            [2001, 4789, 45, 28],
            [2001, 4791, 21, 22],
            [2001, 4794, 29, 21],
            [2001, 4800, 32, 33],
            [2001, 4801, 11, 23],
            [2001, 4802, 32, 22],
            [2001, 4805, 15, 22],
            [2001, 4815, 32, 33],
            [2001, 4819, 20, 22],
            [2001, 4820, 60, 55],
            [2001, 4826, 22, 22],
            [2001, 4828, 44, 22],
            [2001, 4829, 22, 30],
            [2001, 4832, 12, 17],
            [2001, 4835, 30, 28],
            [2001, 4839, 44, 24],
            [2001, 4840, 65, 45],
            [2001, 4844, 23, 22],
            [2001, 4849, 23, 21],
            [2001, 4863, 50, 31],
            [2001, 4864, 21, 24],
            [2001, 4865, 35, 25],
            [2001, 4871, 18, 24],
            [2001, 4872, 32, 33],
            [2001, 4877, 27, 21],
            [2001, 4880, 17, 21],
            [2001, 4881, 32, 33],
            [2001, 4888, 62, 60],
            [2001, 4897, 18, 27],
            [2001, 4910, 32, 34],
            [2001, 4912, 11, 23],
            [2001, 4914, 37, 20],
            [2001, 4915, 23, 19],
            [2001, 4918, 25, 35],
            [2001, 4922, 44, 22],
            [2001, 4926, 28, 24],
            [2001, 4927, 21, 21],
            [2001, 4931, 21, 22],
            [2001, 4939, 26, 25],
            [2001, 4940, 50, 23],
            [2001, 4944, 15, 19],
            [2001, 4950, 32, 33],
            [2001, 4951, 55, 33],
            [2001, 4955, 33, 33],
            [2001, 4957, 21, 23],
            [2001, 4960, 129, 57],
            [2001, 4973, 35, 40],
            [2001, 4975, 34, 34],
            [2001, 4976, 12, 19],
            [2001, 4978, 83, 64],
            [2001, 4979, 108, 40],
            [2001, 4983, 25, 22],
            [2001, 4987, 20, 21],
            [2001, 4990, 22, 22],
            [2001, 4992, 27, 26],
            [2001, 4995, 32, 35],
            [2001, 4996, 32, 33],
            [2001, 4997, 31, 22],
            [2001, 4998, 32, 33],
            [2001, 5005, 19, 33],
            [2001, 5006, 55, 29],
            [2001, 5008, 32, 33],
            [2001, 5009, 19, 21],
            [2001, 5011, 33, 33],
            [2001, 5012, 27, 30],
            [2001, 5013, 12, 19],
            [2001, 5017, 34, 34],
            [2001, 5019, 58, 36],
            [2001, 5022, 99, 55],
            [2001, 5027, 34, 34],
            [2001, 5031, 11, 16],
            [2001, 5032, 24, 35],
            [2001, 5033, 21, 22],
            [2001, 5035, 32, 33],
            [2001, 5037, 34, 21],
            [2001, 5038, 12, 21],
            [2001, 5046, 32, 33],
            [2001, 5048, 24, 21],
            [2001, 5050, 13, 15],
            [2001, 5051, 12, 13],
            [2001, 5053, 32, 24],
            [2001, 5058, 32, 33],
            [2001, 5062, 39, 56],
            [2001, 5063, 27, 38],
            [2001, 5064, 32, 34],
            [2001, 5065, 31, 33],
            [2001, 5068, 35, 26],
            [2001, 5069, 33, 33],
            [2001, 5070, 22, 22],
            [2001, 5071, 33, 34],
            [2001, 5073, 68, 49],
            [2001, 5075, 22, 33],
            [2001, 5079, 21, 22],
            [2001, 5081, 41, 19],
            [2001, 5091, 60, 52],
            [2001, 5092, 12, 19],
            [2001, 5095, 14, 17],
            [2001, 5098, 21, 22],
            [2001, 5102, 20, 12],
            [2001, 5103, 33, 33],
            [2001, 5104, 67, 45],
            [2001, 5107, 61, 52],
            [2001, 5108, 24, 37],
            [2001, 5109, 24, 22],
            [2001, 5116, 29, 34],
            [2001, 5121, 21, 21],
            [2001, 5122, 33, 24],
            [2001, 5126, 21, 22],
            [2001, 5127, 22, 22],
            [2001, 5130, 62, 73],
            [2001, 5138, 16, 15],
            [2001, 5149, 26, 24],
            [2001, 5150, 76, 47],
            [2001, 5153, 40, 33],
            [2001, 5159, 47, 28],
            [2001, 5162, 24, 24],
            [2001, 5173, 51, 28],
            [2001, 5180, 23, 37],
            [2001, 5181, 20, 22],
            [2001, 5182, 23, 26],
            [2001, 5183, 33, 33],
            [2001, 5184, 40, 24],
            [2001, 5185, 36, 20],
            [2001, 5186, 13, 19],
            [2001, 5187, 12, 13],
            [2001, 5188, 12, 15],
            [2001, 5189, 20, 11],
            [2001, 5217, 65, 44],
            [2001, 5219, 17, 60],
            [2001, 5220, 14, 62],
            [2001, 5221, 13, 48],
            [2001, 5222, 16, 24],
            [2001, 5223, 11, 31],
            [2001, 5224, 16, 45],
            [2001, 5225, 17, 62],
            [2001, 5226, 12, 60],
            [2001, 5227, 31, 69],
            [2001, 5228, 20, 62],
            [2001, 5229, 11, 44],
            [2001, 5230, 16, 38],
            [2001, 5231, 15, 37],
            [2001, 5232, 20, 69],
            [2001, 5233, 24, 82],
            [2001, 5234, 11, 28],
            [2001, 5235, 43, 43],
            [2001, 5236, 16, 44],
            [2001, 5237, 33, 67],
            [2001, 5238, 20, 52],
            [2001, 5239, 25, 69],
            [2001, 5240, 19, 69],
            [2001, 5241, 29, 63],
            [2001, 5242, 23, 50],
            [2001, 5243, 28, 69],
            [2001, 5244, 20, 87],
            [2001, 5245, 26, 69],
            [2001, 5247, 40, 15],
            [2001, 5248, 41, 21],
            [2001, 5273, 27, 18],
            [2001, 5276, 34, 67],
            [2001, 5279, 23, 27],
            [2001, 5287, 13, 14],
            [2001, 5290, 24, 22],
            [2001, 5298, 14, 14],
            [2001, 5299, 19, 21],
            [2001, 5303, 35, 22],
            [2001, 5305, 29, 25],
            [2001, 5314, 23, 25],
            [2001, 5315, 20, 28],
            [2001, 5317, 48, 72],
            [2001, 5321, 22, 23],
            [2001, 5323, 14, 23],
            [2001, 5328, 22, 22],
            [2001, 5332, 25, 30],
            [2001, 5333, 14, 17],
            [2001, 5336, 17, 20],
            [2001, 5337, 18, 18],
            [2001, 5338, 34, 27],
            [2001, 5339, 22, 25],
            [2001, 5340, 32, 37],
            [2001, 5343, 17, 15],
            [2001, 5344, 45, 49],
            [2001, 5347, 21, 24],
            [2001, 5349, 24, 28],
            [2001, 5350, 22, 31],
            [2001, 5353, 21, 27],
            [2001, 5355, 25, 41],
            [2001, 5357, 30, 22],
            [2001, 5359, 18, 26],
            [2001, 5366, 32, 25],
            [2001, 5371, 35, 39],
            [2001, 5372, 24, 25],
            [2001, 5375, 21, 19],
            [2001, 5377, 18, 20],
            [2001, 5383, 30, 29],
            [2001, 5385, 34, 26],
            [2001, 5387, 17, 17],
            [2001, 5400, 14, 13],
            [2001, 5403, 25, 26],
            [2001, 5404, 25, 25],
            [2001, 5407, 21, 25],
            [2001, 5408, 19, 23],
            [2001, 5411, 27, 22],
            [2001, 5412, 24, 19],
            [2001, 5414, 13, 16],
            [2001, 5415, 49, 54],
            [2001, 5418, 29, 37],
            [2001, 5420, 17, 17],
            [2001, 5421, 19, 16],
            [2001, 5422, 26, 35],
            [2001, 5425, 17, 20],
            [2001, 5426, 23, 32],
            [2001, 5428, 19, 26],
            [2001, 5431, 22, 24],
            [2001, 5432, 23, 31],
            [2001, 5434, 16, 17],
            [2001, 5436, 23, 26],
            [2001, 5437, 29, 25],
            [2001, 5440, 41, 32],
            [2001, 5441, 32, 42],
            [2001, 5444, 22, 36],
            [2001, 5447, 21, 24],
            [2001, 5449, 27, 34],
            [2001, 5450, 29, 32],
            [2001, 5452, 23, 35],
            [2001, 5453, 35, 33],
            [2001, 5454, 15, 17],
            [2001, 5455, 29, 22],
            [2001, 5457, 17, 26],
            [2001, 5459, 26, 26],
            [2001, 5462, 23, 27],
            [2001, 5463, 15, 18],
            [2001, 5464, 19, 19],
            [2001, 5465, 24, 24],
            [2001, 5472, 25, 30],
            [2001, 5473, 19, 25],
            [2001, 5476, 16, 21],
            [2001, 5479, 21, 19],
            [2001, 5480, 37, 33],
            [2001, 5482, 18, 19],
            [2001, 5486, 23, 22],
            [2001, 5489, 35, 63],
            [2001, 5492, 23, 39],
            [2001, 5494, 26, 31],
            [2001, 5495, 33, 28],
            [2001, 5498, 37, 39],
            [2001, 5499, 34, 25],
            [2001, 5501, 28, 44],
            [2001, 5505, 20, 31],
            [2001, 5508, 26, 36],
            [2001, 5528, 21, 20],
            [2001, 5532, 26, 25],
            [2001, 5534, 18, 15],
            [2001, 5539, 17, 20],
            [2001, 5541, 27, 22],
            [2001, 5544, 23, 33],
            [2001, 5545, 17, 23],
            [2001, 5547, 27, 26],
            [2001, 5550, 17, 18],
            [2001, 5571, 28, 22],
            [2001, 5659, 9, 7],
            [2001, 5944, 7, 8],
            [2001, 5945, 11, 9],
            [2001, 5946, 6, 5],
            [2001, 5962, 77, 101],
            [2001, 5986, 65, 42],
            [2001, 5989, 50, 60],
            [2001, 5990, 50, 60],
            [2001, 5991, 50, 60],
            [2001, 5992, 50, 60],
            [2001, 5993, 50, 60],
            [2001, 5996, 63, 36],
            [2001, 6055, 70, 41],
            [2001, 6066, 38, 36],
            [2001, 6068, 66, 57],
            [2001, 6069, 71, 71],
            [2001, 6070, 71, 71],
            [2001, 6071, 36, 36],
            [2001, 6072, 26, 51],
            [2001, 6073, 41, 46],
            [2001, 6074, 46, 46],
            [2001, 6075, 71, 71],
            [2001, 6076, 51, 49],
            [2001, 6077, 41, 41],
            [2001, 6078, 51, 61],
            [2001, 6079, 50, 49],
            [2001, 6080, 51, 57],
            [2001, 6081, 31, 37],
            [2001, 6082, 46, 46],
            [2001, 6083, 41, 41],
            [2001, 6084, 61, 46],
            [2001, 6085, 51, 51],
            [2001, 6086, 31, 28],
            [2001, 6087, 121, 41],
            [2001, 6088, 50, 50],
            [2001, 6089, 41, 40],
            [2001, 6090, 71, 54],
            [2001, 6091, 36, 41],
            [2001, 6092, 41, 49],
            [2001, 6093, 46, 46],
            [2001, 6094, 46, 46],
            [2001, 6095, 31, 31],
            [2001, 6096, 41, 36],
            [2001, 6097, 50, 42],
            [2001, 6098, 41, 41],
            [2001, 6099, 61, 46],
            [2001, 6100, 46, 46],
            [2001, 6101, 46, 36],
            [2001, 6102, 31, 33],
            [2001, 6103, 41, 41],
            [2001, 6104, 51, 38],
            [2001, 6105, 61, 46],
            [2001, 6106, 36, 36],
            [2001, 6107, 36, 36],
            [2001, 6108, 46, 43],
            [2001, 6109, 26, 35],
            [2001, 6110, 41, 46],
            [2001, 6111, 20, 31],
            [2001, 6112, 41, 41],
            [2001, 6113, 31, 31],
            [2001, 6114, 31, 31],
            [2001, 6115, 31, 37],
            [2001, 6116, 46, 41],
            [2001, 6117, 36, 36],
            [2001, 6118, 46, 45],
            [2001, 6119, 41, 41],
            [2001, 6120, 26, 30],
            [2001, 6121, 41, 41],
            [2001, 6122, 41, 36],
            [2001, 6123, 30, 31],
            [2001, 6124, 46, 36],
            [2001, 6125, 36, 36],
            [2001, 6126, 41, 41],
            [2001, 6127, 41, 41],
            [2001, 6128, 35, 47],
            [2001, 6129, 21, 31],
            [2001, 6130, 41, 41],
            [2001, 6131, 41, 41],
            [2001, 6132, 46, 46],
            [2001, 6133, 41, 41],
            [2001, 6134, 41, 41],
            [2001, 6135, 121, 121],
            [2001, 6136, 101, 101],
            [2001, 6137, 21, 26],
            [2001, 6138, 36, 43],
            [2001, 6139, 41, 43],
            [2001, 6140, 26, 36],
            [2001, 6141, 41, 50],
            [2001, 6142, 35, 43],
            [2001, 6143, 36, 36],
            [2001, 6144, 31, 31],
            [2001, 6145, 46, 46],
            [2001, 6146, 20, 31],
            [2001, 6147, 31, 47],
            [2001, 6148, 31, 39],
            [2001, 6149, 41, 41],
            [2001, 6150, 21, 31],
            [2001, 6151, 31, 31],
            [2001, 6152, 26, 32],
            [2001, 6153, 29, 36],
            [2001, 6154, 41, 41],
            [2001, 6155, 26, 33],
            [2001, 6156, 31, 37],
            [2001, 6157, 50, 46],
            [2001, 6158, 31, 35],
            [2001, 6159, 46, 46],
            [2001, 6160, 26, 31],
            [2001, 6161, 19, 27],
            [2001, 6162, 25, 31],
            [2001, 6163, 71, 60],
            [2001, 6164, 41, 46],
            [2001, 6165, 36, 35],
            [2001, 6166, 61, 43],
            [2001, 6167, 71, 58],
            [2001, 6244, 67, 50],
            [2001, 6353, 25, 16],
            [2001, 6357, 35, 29],
            [2001, 6358, 27, 36],
            [2001, 6359, 26, 26],
            [2001, 6360, 107, 80],
            [2001, 6361, 107, 90],
            [2001, 6362, 65, 64],
            [2001, 6363, 65, 70],
            [2001, 6364, 107, 80],
            [2001, 6365, 111, 83],
            [2001, 6366, 111, 83],
            [2001, 6367, 63, 64],
            [2001, 6368, 107, 80],
            [2001, 6369, 70, 70],
            [2001, 6370, 106, 80],
            [2001, 6371, 107, 90],
            [2001, 6372, 111, 83],
            [2001, 6373, 111, 90],
            [2001, 6374, 107, 80],
            [2001, 6375, 120, 80],
            [2001, 6376, 71, 64],
            [2001, 6377, 120, 89],
            [2001, 6378, 65, 64],
            [2001, 6379, 71, 70],
            [2001, 6380, 70, 63],
            [2001, 6381, 71, 64],
            [2001, 6382, 107, 80],
            [2001, 6383, 71, 64],
            [2001, 6384, 107, 80],
            [2001, 6385, 107, 66],
            [2001, 6386, 107, 80],
            [2001, 6387, 106, 89],
            [2001, 6388, 107, 79],
            [2001, 6389, 111, 83],
            [2001, 6390, 107, 80],
            [2001, 6391, 64, 63],
            [2001, 6392, 107, 80],
            [2001, 6393, 120, 90],
            [2001, 6394, 111, 83],
            [2001, 6395, 107, 80],
            [2001, 6396, 111, 83],
            [2001, 6397, 107, 80],
            [2001, 6398, 120, 90],
            [2001, 6399, 111, 83],
            [2001, 6400, 105, 79],
            [2001, 6401, 70, 70],
            [2001, 6402, 111, 83],
            [2001, 6403, 120, 90],
            [2001, 6404, 111, 83],
            [2001, 6405, 111, 83],
            [2001, 6406, 107, 80],
            [2001, 6407, 107, 80],
            [2001, 6408, 107, 80],
            [2001, 6409, 107, 80],
            [2001, 6410, 107, 80],
            [2001, 6411, 104, 78],
            [2001, 6412, 107, 80],
            [2001, 6413, 120, 90],
            [2001, 6414, 120, 80],
            [2001, 6415, 107, 80],
            [2001, 6416, 111, 83],
            [2001, 6417, 111, 83],
            [2001, 6418, 120, 90],
            [2001, 6419, 111, 90],
            [2001, 6420, 120, 90],
            [2001, 6421, 107, 80],
            [2001, 6422, 107, 80],
            [2001, 6423, 33, 32],
            [2001, 6424, 71, 70],
            [2001, 6425, 71, 64],
            [2001, 6426, 107, 90],
            [2001, 6427, 120, 90],
            [2001, 6428, 120, 90],
            [2001, 6429, 120, 89],
            [2001, 6430, 65, 70],
            [2001, 6431, 107, 80],
            [2001, 6432, 107, 90],
            [2001, 6433, 58, 63],
            [2001, 6434, 107, 80],
            [2001, 6435, 70, 62],
            [2001, 6436, 120, 80],
            [2001, 6437, 111, 83],
            [2001, 6438, 107, 80],
            [2001, 6439, 107, 80],
            [2001, 6440, 120, 90],
            [2001, 6441, 105, 78],
            [2001, 6442, 64, 63],
            [2001, 6443, 107, 80],
            [2001, 6444, 82, 90],
            [2001, 6445, 107, 80],
            [2001, 6446, 111, 83],
            [2001, 6447, 64, 48],
            [2001, 6448, 107, 80],
            [2001, 6449, 111, 90],
            [2001, 6450, 120, 90],
            [2001, 6451, 111, 90],
            [2001, 6452, 120, 80],
            [2001, 6453, 107, 80],
            [2001, 6454, 107, 80],
            [2001, 6455, 107, 80],
            [2001, 6456, 107, 80],
            [2001, 6457, 36, 41],
            [2001, 6458, 28, 32],
            [2001, 6459, 120, 83],
            [2001, 6460, 120, 90],
            [2001, 6461, 107, 80],
            [2001, 6462, 106, 90],
            [2001, 6463, 107, 90],
            [2001, 6464, 120, 90],
            [2001, 6465, 111, 90],
            [2001, 6466, 106, 80],
            [2001, 6467, 120, 90],
            [2001, 6468, 111, 83],
            [2001, 6469, 107, 80],
            [2001, 6470, 107, 80],
            [2001, 6471, 107, 80],
            [2001, 6472, 111, 83],
            [2001, 6473, 111, 83],
            [2001, 6474, 107, 80],
            [2001, 6475, 107, 80],
            [2001, 6476, 107, 80],
            [2001, 6477, 115, 87],
            [2001, 6478, 107, 80],
            [2001, 6479, 107, 80],
            [2001, 6480, 107, 80],
            [2001, 6481, 111, 83],
            [2001, 6482, 111, 90],
            [2001, 6483, 107, 80],
            [2001, 6484, 71, 52],
            [2001, 6485, 105, 80],
            [2001, 6486, 111, 83],
            [2001, 6487, 107, 80],
            [2001, 6488, 107, 80],
            [2001, 6489, 107, 80],
            [2001, 6490, 107, 80],
            [2001, 6491, 107, 80],
            [2001, 6492, 29, 32],
            [2001, 6493, 107, 80],
            [2001, 6494, 29, 32],
            [2001, 6495, 105, 79],
            [2001, 6496, 107, 80],
            [2001, 6497, 120, 90],
            [2001, 6498, 120, 90],
            [2001, 6499, 120, 90],
            [2001, 6500, 71, 64],
            [2001, 6501, 107, 80],
            [2001, 6502, 63, 64],
            [2001, 6503, 107, 80],
            [2001, 6504, 107, 90],
            [2001, 6505, 107, 80],
            [2001, 6506, 107, 90],
            [2001, 6507, 111, 83],
            [2001, 6508, 111, 83],
            [2001, 6509, 107, 80],
            [2001, 6510, 120, 90],
            [2001, 6511, 107, 80],
            [2001, 6512, 107, 80],
            [2001, 6513, 26, 24],
            [2001, 6514, 106, 79],
            [2001, 6515, 107, 90],
            [2001, 6516, 71, 59],
            [2001, 6517, 34, 32],
            [2001, 6518, 107, 90],
            [2001, 6519, 120, 90],
            [2001, 6520, 120, 90],
            [2001, 6521, 53, 52],
            [2001, 6522, 107, 80],
            [2001, 6523, 120, 90],
            [2001, 6524, 120, 91],
            [2001, 6525, 107, 80],
            [2001, 6526, 111, 83],
            [2001, 6527, 107, 80],
            [2001, 6528, 107, 80],
            [2001, 6529, 120, 90],
            [2001, 6530, 105, 79],
            [2001, 6531, 111, 90],
            [2001, 6532, 107, 80],
            [2001, 6533, 107, 80],
            [2001, 6534, 107, 90],
            [2001, 6535, 111, 83],
            [2001, 6536, 34, 37],
            [2001, 6537, 111, 83],
            [2001, 6538, 111, 90],
            [2001, 6539, 107, 80],
            [2001, 6540, 111, 90],
            [2001, 6541, 111, 83],
            [2001, 6542, 111, 83],
            [2001, 6543, 111, 83],
            [2001, 6544, 111, 83],
            [2001, 6546, 111, 83],
            [2001, 6547, 120, 90],
            [2001, 6548, 111, 83],
            [2001, 6549, 111, 90],
            [2001, 6550, 111, 83],
            [2001, 6551, 111, 83],
            [2001, 6552, 111, 90],
            [2001, 6553, 111, 83],
            [2001, 6554, 111, 83],
            [2001, 6555, 111, 83],
            [2001, 6556, 111, 83],
            [2001, 6557, 111, 83],
            [2001, 6558, 107, 80],
            [2001, 6559, 111, 83],
            [2001, 6560, 107, 80],
            [2001, 6561, 111, 90],
            [2001, 6562, 111, 83],
            [2001, 6563, 111, 83],
            [2001, 6564, 111, 83],
            [2001, 6565, 120, 90],
            [2001, 6566, 107, 70],
            [2001, 6567, 111, 83],
            [2001, 6568, 107, 80],
            [2001, 6569, 107, 80],
            [2001, 6570, 111, 83],
            [2001, 6572, 111, 83],
            [2001, 6573, 107, 80],
            [2001, 6574, 107, 80],
            [2001, 6575, 106, 79],
            [2001, 6576, 107, 80],
            [2001, 6577, 107, 80],
            [2001, 6578, 107, 80],
            [2001, 6579, 111, 83],
            [2001, 6580, 107, 80],
            [2001, 6581, 120, 90],
            [2001, 6582, 107, 80],
            [2001, 6583, 120, 90],
            [2001, 6584, 115, 87],
            [2001, 6585, 107, 80],
            [2001, 6586, 107, 80],
            [2001, 6587, 107, 80],
            [2001, 6588, 107, 80],
            [2001, 6589, 107, 80],
            [2001, 6590, 115, 87],
            [2001, 6591, 111, 83],
            [2001, 6592, 111, 83],
            [2001, 6593, 111, 83],
            [2001, 6594, 111, 83],
            [2001, 6595, 107, 80],
            [2001, 6596, 107, 80],
            [2001, 6597, 111, 83],
            [2001, 6598, 111, 83],
            [2001, 6599, 120, 90],
            [2001, 6600, 107, 80],
            [2001, 6601, 111, 83],
            [2001, 6602, 107, 80],
            [2001, 6603, 65, 64],
            [2001, 6604, 111, 90],
            [2001, 6605, 107, 80],
            [2001, 6606, 107, 80],
            [2001, 6607, 120, 80],
            [2001, 6608, 107, 80],
            [2001, 6609, 107, 80],
            [2001, 6610, 107, 80],
            [2001, 6611, 65, 64],
            [2001, 6612, 107, 90],
            [2001, 6613, 107, 80],
            [2001, 6614, 34, 37],
            [2001, 6615, 107, 80],
            [2001, 6616, 107, 80],
            [2001, 6617, 38, 33],
            [2001, 6618, 107, 80],
            [2001, 6619, 111, 83],
            [2001, 6620, 111, 83],
            [2001, 6621, 107, 80],
            [2001, 6622, 107, 80],
            [2001, 6623, 120, 90],
            [2001, 6624, 120, 83],
            [2001, 6625, 111, 83],
            [2001, 6626, 120, 90],
            [2001, 6627, 107, 80],
            [2001, 6628, 111, 90],
            [2001, 6629, 65, 70],
            [2001, 6630, 70, 70],
            [2001, 6631, 61, 73],
            [2001, 6632, 26, 31],
            [2001, 6633, 36, 43],
            [2001, 6634, 46, 46],
            [2001, 6635, 51, 51],
            [2001, 6636, 81, 81],
            [2001, 6637, 61, 46],
            [2001, 6638, 71, 58],
            [2001, 6639, 51, 64],
            [2001, 6640, 72, 80],
            [2001, 6643, 51, 48],
            [2001, 6649, 61, 48],
            [2001, 6650, 61, 46],
            [2001, 6651, 41, 31],
            [2001, 6652, 61, 46],
            [2001, 6653, 56, 56],
            [2001, 6654, 41, 41],
            [2001, 6655, 36, 36],
            [2001, 6656, 46, 41],
            [2001, 6657, 51, 51],
            [2001, 6660, 46, 33],
            [2001, 6661, 36, 36],
            [2001, 6662, 53, 46],
            [2001, 6663, 41, 41],
            [2001, 6664, 50, 50],
            [2001, 6665, 41, 41],
            [2001, 6666, 41, 36],
            [2001, 6667, 41, 41],
            [2001, 6668, 41, 30],
            [2001, 6669, 50, 50],
            [2001, 6670, 41, 41],
            [2001, 6671, 61, 41],
            [2001, 6672, 46, 36],
            [2001, 6673, 46, 41],
            [2001, 6674, 46, 46],
            [2001, 6675, 41, 41],
            [2001, 6676, 61, 61],
            [2001, 6677, 41, 41],
            [2001, 6678, 41, 41],
            [2001, 6679, 101, 101],
            [2001, 6680, 36, 36],
            [2001, 6682, 36, 36],
            [2001, 6683, 41, 41],
            [2001, 6684, 36, 50],
            [2001, 6685, 30, 35],
            [2001, 6686, 31, 37],
            [2001, 6687, 31, 37],
            [2001, 6688, 31, 37],
            [2001, 6689, 30, 37],
            [2001, 6690, 31, 37],
            [2001, 6697, 40, 31],
            [2001, 6699, 73, 61],
            [2001, 6700, 88, 80],
            [2001, 6701, 73, 93],
            [2001, 6702, 74, 49],
            [2001, 6704, 59, 50],
            [2001, 6706, 49, 47],
            [2001, 6708, 69, 69],
            [2001, 6715, 72, 60],
            [2001, 6716, 92, 60],
            [2001, 6718, 101, 76],
            [2001, 6722, 78, 62],
            [2001, 6723, 70, 53],
            [2001, 6725, 53, 54],
            [2001, 6726, 103, 69],
            [2001, 6728, 63, 62],
            [2001, 6730, 53, 54],
            [2001, 6734, 69, 52],
            [2001, 6737, 74, 62],
            [2001, 6738, 60, 60],
            [2001, 6741, 17, 20],
            [2001, 6748, 36, 36],
            [2001, 6749, 41, 41],
            [2001, 6750, 61, 61],
            [2001, 6752, 31, 37],
            [2001, 6753, 51, 46],
            [2001, 6754, 46, 46],
            [2001, 6755, 61, 61],
            [2001, 6756, 51, 51],
            [2001, 6757, 46, 46],
            [2001, 6758, 51, 65],
            [2001, 6759, 31, 37],
            [2001, 6760, 61, 61],
            [2001, 6761, 61, 61],
            [2001, 6762, 51, 51],
            [2001, 6763, 31, 31],
            [2001, 6764, 46, 51],
            [2001, 6766, 71, 74],
            [2001, 6767, 41, 45],
            [2001, 6768, 46, 46],
            [2001, 6769, 61, 78],
            [2001, 6770, 51, 61],
            [2001, 6771, 51, 56],
            [2001, 6772, 41, 52],
            [2001, 6773, 71, 65],
            [2001, 6777, 71, 70],
            [2001, 6778, 41, 41],
            [2001, 6779, 51, 61],
            [2001, 6780, 51, 57],
            [2001, 6781, 61, 61],
            [2001, 6782, 101, 91],
            [2001, 6783, 71, 71],
            [2001, 6784, 51, 51],
            [2001, 6785, 51, 51],
            [2001, 6786, 51, 61],
            [2001, 6787, 46, 58],
            [2001, 6789, 61, 61],
            [2001, 6790, 103, 78],
            [2001, 6791, 96, 65],
            [2001, 6794, 102, 77],
            [2001, 6795, 75, 66],
            [2001, 6798, 98, 67],
            [2001, 6803, 80, 69],
            [2001, 6804, 80, 69],
            [2001, 6805, 105, 79],
            [2001, 6806, 75, 69],
            [2001, 6807, 101, 69],
            [2001, 6808, 104, 79],
            [2001, 6812, 117, 103],
            [2001, 6813, 101, 76],
            [2001, 6814, 96, 89],
            [2001, 6816, 98, 82],
            [2001, 6818, 21, 24],
            [2001, 6819, 39, 47],
            [2001, 6820, 38, 44],
            [2001, 6821, 51, 52],
            [2001, 6822, 54, 53],
            [2001, 6823, 50, 52],
            [2001, 6833, 93, 72],
            [2001, 6834, 104, 87],
            [2001, 6835, 113, 87],
            [2001, 6836, 103, 80],
            [2001, 6837, 104, 78],
            [2001, 6838, 116, 89],
            [2001, 6841, 41, 30],
            [2001, 6845, 103, 78],
            [2001, 6846, 115, 99],
            [2001, 6847, 102, 77],
            [2001, 6848, 105, 79],
            [2001, 6849, 68, 67],
            [2001, 6850, 103, 78],
            [2001, 6851, 102, 77],
            [2001, 6852, 106, 80],
            [2001, 6853, 106, 80],
            [2001, 6854, 101, 84],
            [2001, 6855, 104, 79],
            [2001, 6856, 103, 78],
            [2001, 6857, 104, 87],
            [2001, 6858, 109, 82],
            [2001, 6859, 93, 71],
            [2001, 6860, 103, 78],
            [2001, 6861, 106, 88],
            [2001, 6862, 106, 80],
            [2001, 6867, 12, 20],
            [2001, 6868, 12, 17],
            [2001, 6869, 15, 18],
            [2001, 6870, 15, 21],
            [2001, 6871, 16, 19],
            [2001, 6872, 12, 18],
            [2001, 6873, 21, 21],
            [2001, 6874, 17, 21],
            [2001, 6875, 16, 20],
            [2001, 6876, 15, 22],
            [2001, 6877, 18, 21],
            [2001, 6878, 15, 19],
            [2001, 6879, 15, 22],
            [2001, 6880, 21, 27],
            [2001, 6881, 15, 15],
            [2001, 6882, 16, 21],
            [2001, 6883, 15, 23],
            [2001, 6884, 7, 8],
            [2001, 6885, 26, 16],
            [2001, 6886, 12, 17],
            [2001, 6887, 120, 40],
            [2001, 6888, 11, 12],
            [2001, 6889, 22, 14],
            [2001, 6890, 8, 10],
            [2001, 6891, 18, 17],
            [2001, 6892, 9, 10],
            [2001, 6893, 23, 15],
            [2001, 6894, 7, 9],
            [2001, 6895, 29, 16],
            [2001, 6896, 9, 12],
            [2001, 6897, 16, 16],
            [2001, 6898, 6, 8],
            [2001, 6899, 30, 14],
            [2001, 6900, 6, 7],
            [2001, 6901, 25, 16],
            [2001, 6902, 11, 16],
            [2001, 6903, 36, 25],
            [2001, 6904, 12, 12],
            [2001, 6905, 45, 26],
            [2001, 6906, 8, 10],
            [2001, 6907, 26, 17],
            [2001, 6908, 8, 8],
            [2001, 6909, 25, 19],
            [2001, 6910, 36, 31],
            [2001, 6911, 65, 44],
            [2001, 6912, 40, 25],
            [2001, 6913, 71, 43],
            [2001, 6914, 13, 12],
            [2001, 6915, 42, 41],
            [2001, 6916, 11, 12],
            [2001, 6917, 31, 37],
            [2001, 6918, 31, 25],
            [2001, 6919, 31, 31],
            [2001, 6920, 31, 25],
            [2001, 6921, 54, 40],
            [2001, 6922, 15, 13],
            [2001, 6923, 59, 43],
            [2001, 6924, 11, 12],
            [2001, 6925, 45, 45],
            [2001, 6926, 75, 31],
            [2001, 6927, 75, 41],
            [2001, 6928, 21, 20],
            [2001, 6929, 60, 45],
            [2001, 6930, 22, 15],
            [2001, 6931, 42, 45],
            [2001, 6932, 21, 14],
            [2001, 6933, 31, 29],
            [2001, 6934, 21, 15],
            [2001, 6935, 50, 55],
            [2001, 6936, 25, 23],
            [2001, 6937, 53, 45],
            [2001, 6938, 23, 15],
            [2001, 6939, 55, 42],
            [2001, 6940, 13, 11],
            [2001, 6941, 33, 26],
            [2001, 6942, 35, 30],
            [2001, 6943, 65, 44],
            [2001, 6944, 12, 12],
            [2001, 6945, 84, 65],
            [2001, 6946, 71, 37],
            [2001, 6947, 75, 55],
            [2001, 6948, 15, 13],
            [2001, 6949, 54, 41],
            [2001, 6950, 18, 15],
            [2001, 6951, 60, 45],
            [2001, 6952, 69, 28],
            [2001, 6953, 72, 41],
            [2001, 6954, 31, 18],
            [2001, 6955, 54, 41],
            [2001, 6956, 20, 16],
            [2001, 6957, 84, 73],
            [2001, 6958, 16, 12],
            [2001, 6959, 55, 45],
            [2001, 6960, 12, 11],
            [2001, 6961, 31, 28],
            [2001, 6962, 14, 12],
            [2001, 6963, 12, 11],
            [2001, 6964, 28, 18],
            [2001, 6965, 9, 10],
            [2001, 6966, 34, 77],
            [2001, 6967, 25, 74],
            [2001, 6968, 44, 97],
            [2001, 6969, 26, 66],
            [2001, 6970, 36, 80],
            [2001, 6971, 38, 29],
            [2001, 6972, 77, 35],
            [2001, 6973, 24, 12],
            [2001, 6974, 6, 7],
            [2001, 6975, 9, 10],
            [2001, 6976, 22, 18],
            [2001, 6977, 7, 9],
            [2001, 6978, 53, 21],
            [2001, 6979, 7, 9],
            [2001, 6980, 20, 15],
            [2001, 6981, 9, 9],
            [2001, 6982, 29, 17],
            [2001, 6983, 12, 14],
            [2001, 6984, 34, 26],
            [2001, 6985, 60, 34],
            [2001, 6986, 120, 49],
            [2001, 6987, 9, 9],
            [2001, 6988, 27, 12],
            [2001, 6989, 15, 16],
            [2001, 6990, 32, 23],
            [2001, 6991, 7, 5],
            [2001, 6992, 24, 13],
            [2001, 6993, 8, 8],
            [2001, 6994, 61, 26],
            [2001, 6995, 11, 11],
            [2001, 6996, 22, 16],
            [2001, 6997, 7, 6],
            [2001, 6998, 15, 8],
            [2001, 6999, 7, 7],
            [2001, 7000, 21, 15],
            [2001, 7001, 7, 7],
            [2001, 7002, 18, 14],
            [2001, 7003, 8, 8],
            [2001, 7004, 18, 14],
            [2001, 7005, 15, 15],
            [2001, 7006, 31, 25],
            [2001, 7007, 43, 33],
            [2001, 7008, 43, 33],
            [2001, 7009, 21, 15],
            [2001, 7010, 21, 15],
            [2001, 7011, 10, 10],
            [2001, 7012, 24, 23],
            [2001, 7013, 32, 21],
            [2001, 7014, 13, 11],
            [2001, 7015, 12, 9],
            [2001, 7019, 11, 10],
            [2001, 7020, 43, 45],
            [2001, 7021, 13, 12],
            [2001, 7022, 23, 23],
            [2001, 7023, 19, 19],
            [2001, 7024, 31, 31],
            [2001, 7025, 15, 13],
            [2001, 7026, 31, 25],
            [2001, 7027, 22, 21],
            [2001, 7028, 43, 45],
            [2001, 7029, 45, 31],
            [2001, 7030, 62, 45],
            [2001, 7031, 15, 13],
            [2001, 7032, 31, 25],
            [2001, 7033, 25, 25],
            [2001, 7034, 40, 33],
            [2001, 7035, 11, 12],
            [2001, 7036, 31, 31],
            [2001, 7037, 31, 33],
            [2001, 7038, 41, 45],
            [2001, 7039, 25, 14],
            [2001, 7040, 33, 31],
            [2001, 7041, 15, 13],
            [2001, 7042, 62, 58],
            [2001, 7043, 21, 31],
            [2001, 7044, 31, 31],
            [2001, 7045, 40, 25],
            [2001, 7046, 58, 41],
            [2001, 7047, 20, 15],
            [2001, 7048, 31, 25],
            [2001, 7049, 55, 41],
            [2001, 7050, 23, 17],
            [2001, 7051, 61, 45],
            [2001, 7052, 17, 15],
            [2001, 7053, 55, 45],
            [2001, 7054, 18, 15],
            [2001, 7055, 45, 32],
            [2001, 7056, 15, 15],
            [2001, 7057, 66, 45],
            [2001, 7058, 31, 19],
            [2001, 7059, 61, 45],
            [2001, 7060, 32, 21],
            [2001, 7061, 55, 45],
            [2001, 7062, 20, 14],
            [2001, 7063, 55, 25],
            [2001, 7064, 32, 15],
            [2001, 7065, 45, 45],
            [2001, 7066, 13, 13],
            [2001, 7067, 56, 46],
            [2001, 7068, 45, 35],
            [2001, 7069, 75, 65],
            [2001, 7070, 31, 21],
            [2001, 7071, 61, 45],
            [2001, 7072, 11, 12],
            [2001, 7073, 31, 31],
            [2001, 7074, 26, 21],
            [2001, 7075, 56, 60],
            [2001, 7076, 31, 25],
            [2001, 7077, 44, 31],
            [2001, 7078, 11, 12],
            [2001, 7079, 31, 25],
            [2001, 7080, 47, 41],
            [2001, 7081, 82, 64],
            [2001, 7082, 31, 25],
            [2001, 7083, 45, 45],
            [2001, 7084, 70, 24],
            [2001, 7085, 71, 45],
            [2001, 7086, 13, 12],
            [2001, 7087, 46, 41],
            [2001, 7088, 31, 28],
            [2001, 7089, 61, 45],
            [2001, 7090, 22, 12],
            [2001, 7091, 60, 45],
            [2001, 7092, 63, 27],
            [2001, 7093, 82, 70],
            [2001, 7094, 42, 31],
            [2001, 7095, 64, 45],
            [2001, 7096, 31, 25],
            [2001, 7097, 45, 31],
            [2001, 7098, 31, 31],
            [2001, 7099, 58, 46],
            [2001, 7100, 15, 13],
            [2001, 7101, 21, 20],
            [2001, 7102, 15, 11],
            [2001, 7103, 37, 18],
            [2001, 7104, 10, 7],
            [2001, 7105, 22, 13],
            [2001, 7106, 5, 7],
            [2001, 7107, 22, 12],
            [2001, 7108, 12, 10],
            [2001, 7109, 30, 16],
            [2001, 7110, 9, 11],
            [2001, 7111, 28, 14],
            [2001, 7112, 5, 5],
            [2001, 7113, 34, 14],
            [2001, 7114, 29, 21],
            [2001, 7115, 49, 27],
            [2001, 7116, 11, 12],
            [2001, 7117, 34, 22],
            [2001, 7118, 8, 16],
            [2001, 7119, 17, 16],
            [2001, 7120, 12, 14],
            [2001, 7121, 43, 38],
            [2001, 7122, 10, 8],
            [2001, 7123, 30, 17],
            [2001, 7124, 7, 10],
            [2001, 7125, 16, 16],
            [2001, 7126, 8, 7],
            [2001, 7127, 21, 16],
            [2001, 7128, 9, 8],
            [2001, 7129, 21, 14],
            [2001, 7130, 8, 9],
            [2001, 7131, 24, 14],
            [2001, 7132, 9, 8],
            [2001, 7133, 35, 21],
            [2001, 7134, 18, 11],
            [2001, 7135, 26, 11],
            [2001, 7136, 19, 14],
            [2001, 7137, 35, 20],
            [2001, 7138, 10, 9],
            [2001, 7139, 26, 19],
            [2001, 7140, 6, 7],
            [2001, 7141, 14, 12],
            [2001, 7142, 9, 11],
            [2001, 7143, 26, 15],
            [2001, 7144, 9, 9],
            [2001, 7145, 18, 14],
            [2001, 7146, 11, 12],
            [2001, 7147, 29, 22],
            [2001, 7148, 9, 11],
            [2001, 7149, 37, 21],
            [2001, 7150, 5, 9],
            [2001, 7151, 18, 14],
            [2001, 7152, 8, 8],
            [2001, 7153, 29, 21],
            [2001, 7154, 18, 21],
            [2001, 7155, 26, 24],
            [2001, 7156, 20, 19],
            [2001, 7157, 10, 8],
            [2001, 7158, 46, 23],
            [2001, 7159, 21, 15],
            [2001, 7160, 49, 32],
            [2001, 7161, 9, 11],
            [2001, 7162, 27, 22],
            [2001, 7163, 8, 7],
            [2001, 7164, 22, 13],
            [2001, 7165, 13, 11],
            [2001, 7166, 58, 32],
            [2001, 7167, 7, 8],
            [2001, 7168, 28, 18],
            [2001, 7169, 5, 5],
            [2001, 7170, 38, 23],
            [2001, 7171, 6, 7],
            [2001, 7172, 44, 27],
            [2001, 7173, 14, 14],
            [2001, 7174, 70, 42],
            [2001, 7175, 6, 5],
            [2001, 7176, 17, 13],
            [2001, 7177, 16, 10],
            [2001, 7178, 23, 13],
            [2001, 7179, 16, 14],
            [2001, 7180, 50, 31],
            [2001, 7181, 10, 10],
            [2001, 7182, 43, 20],
            [2001, 7183, 20, 12],
            [2001, 7184, 92, 62],
            [2001, 7185, 19, 15],
            [2001, 7186, 53, 28],
            [2001, 7187, 14, 11],
            [2001, 7188, 49, 27],
            [2001, 7189, 18, 16],
            [2001, 7190, 46, 27],
            [2001, 7191, 18, 13],
            [2001, 7192, 27, 16],
            [2001, 7193, 14, 13],
            [2001, 7194, 21, 12],
            [2001, 7195, 15, 13],
            [2001, 7196, 42, 24],
            [2001, 7197, 8, 6],
            [2001, 7198, 22, 11],
            [2001, 7199, 16, 11],
            [2001, 7200, 35, 18],
            [2001, 7201, 6, 5],
            [2001, 7202, 14, 9],
            [2001, 7203, 10, 7],
            [2001, 7204, 18, 16],
            [2001, 7205, 20, 17],
            [2001, 7206, 56, 31],
            [2001, 7207, 15, 15],
            [2001, 7208, 42, 27],
            [2001, 7209, 17, 10],
            [2001, 7210, 50, 41],
            [2001, 7211, 10, 10],
            [2001, 7212, 28, 16],
            [2001, 7213, 8, 9],
            [2001, 7214, 70, 35],
            [2001, 7215, 8, 6],
            [2001, 7216, 56, 28],
            [2001, 7217, 13, 10],
            [2001, 7218, 32, 21],
            [2001, 7219, 18, 18],
            [2001, 7220, 38, 25],
            [2001, 7221, 15, 12],
            [2001, 7222, 34, 24],
            [2001, 7223, 12, 11],
            [2001, 7224, 43, 22],
            [2001, 7225, 7, 8],
            [2001, 7226, 29, 17],
            [2001, 7227, 11, 11],
            [2001, 7228, 32, 23],
            [2001, 7229, 14, 9],
            [2001, 7230, 62, 30],
            [2001, 7231, 11, 9],
            [2001, 7232, 32, 20],
            [2001, 7233, 8, 6],
            [2001, 7234, 27, 16],
            [2001, 7235, 12, 10],
            [2001, 7236, 21, 16],
            [2001, 7237, 7, 7],
            [2001, 7238, 21, 14],
            [2001, 7239, 8, 8],
            [2001, 7240, 19, 13],
            [2001, 7241, 21, 22],
            [2001, 7242, 28, 15],
            [2001, 7243, 5, 6],
            [2001, 7244, 18, 12],
            [2001, 7245, 5, 7],
            [2001, 7246, 27, 15],
            [2001, 7247, 7, 9],
            [2001, 7248, 26, 18],
            [2001, 7249, 7, 8],
            [2001, 7250, 25, 16],
            [2001, 7251, 18, 20],
            [2001, 7252, 30, 24],
            [2001, 7253, 16, 10],
            [2001, 7254, 59, 18],
            [2001, 7255, 48, 25],
            [2001, 7256, 26, 17],
            [2001, 7257, 120, 90],
            [2001, 7258, 120, 90],
            [2001, 7259, 103, 65],
            [2001, 7260, 124, 95],
            [2001, 7261, 103, 91],
            [2001, 7262, 118, 138],
            [2001, 7263, 107, 95],
            [2001, 7264, 124, 145],
            [2001, 7265, 104, 92],
            [2001, 7266, 126, 96],
            [2001, 7267, 103, 91],
            [2001, 7268, 125, 96],
            [2001, 7269, 125, 96],
            [2001, 7270, 102, 65],
            [2001, 7271, 69, 68],
            [2001, 7272, 124, 95],
            [2001, 7273, 124, 145],
            [2001, 7274, 124, 94],
            [2001, 7275, 105, 94],
            [2001, 7276, 67, 64],
            [2001, 7277, 104, 92],
            [2001, 7278, 118, 139],
            [2001, 7279, 120, 90],
            [2001, 7280, 126, 96],
            [2001, 7281, 103, 91],
            [2001, 7282, 117, 137],
            [2001, 7283, 15, 25],
            [2001, 7284, 11, 10],
            [2001, 7285, 12, 11],
            [2001, 7286, 20, 31],
            [2001, 7287, 17, 35],
            [2001, 7288, 37, 40],
            [2001, 7289, 43, 31],
            [2001, 7290, 69, 45],
            [2001, 7291, 52, 43],
            [2001, 7292, 49, 52],
            [2001, 7293, 33, 31],
            [2001, 7294, 32, 31],
            [2001, 7295, 15, 14],
            [2001, 7296, 27, 23],
            [2001, 7297, 29, 25],
            [2001, 7298, 16, 20],
            [2001, 7299, 17, 22],
            [2001, 7300, 21, 34],
            [2001, 7301, 13, 30],
            [2001, 7302, 55, 64],
            [2001, 7303, 84, 81],
            [2001, 7304, 43, 48],
            [2001, 7305, 58, 60],
            [2001, 7306, 39, 47],
            [2001, 7307, 57, 64],
            [2001, 7308, 46, 53],
            [2001, 7309, 43, 51],
            [2001, 7310, 89, 77],
            [2001, 7311, 72, 71],
            [2001, 7312, 56, 61],
            [2001, 7313, 115, 85],
            [2001, 7314, 109, 82],
            [2001, 7315, 107, 81],
            [2001, 7316, 109, 82],
            [2001, 7317, 110, 82],
            [2001, 7318, 109, 82],
            [2001, 7319, 116, 86],
            [2001, 7320, 108, 81],
            [2001, 7321, 140, 105],
            [2001, 7322, 109, 82],
            [2001, 7323, 138, 103],
            [2001, 7324, 115, 85],
            [2001, 7325, 110, 82],
            [2001, 7326, 109, 82],
            [2001, 7327, 138, 104],
            [2001, 7328, 42, 50],
            [2001, 7329, 77, 75],
            [2001, 7330, 57, 56],
            [2001, 7331, 57, 56],
            [2001, 7332, 42, 49],
            [2001, 7333, 78, 99],
            [2001, 7337, 16, 16],
            [2001, 7342, 14, 9],
            [2001, 7343, 14, 9],
            [2001, 7344, 12, 9],
            [2001, 7348, 12, 8],
            [2001, 7352, 11, 9],
            [2001, 7354, 14, 14],
            [2001, 7356, 11, 8],
            [2001, 7357, 22, 11],
            [2001, 7358, 16, 11],
            [2001, 7359, 27, 12],
            [2001, 7360, 13, 10],
            [2001, 7362, 11, 9],
            [2001, 7363, 13, 12],
            [2001, 7364, 12, 12],
            [2001, 7367, 13, 8],
            [2001, 7370, 12, 11],
            [2001, 7371, 17, 12],
            [2001, 7372, 19, 10],
            [2001, 7373, 15, 11],
            [2001, 7374, 11, 8],
            [2001, 7375, 12, 8],
            [2001, 7376, 9, 8],
            [2001, 7377, 11, 8],
            [2001, 7378, 21, 20],
            [2001, 7379, 37, 28],
            [2001, 7396, 56, 56],
            [2001, 7397, 94, 72],
            [2001, 7398, 56, 56],
            [2001, 7399, 41, 49],
            [2001, 7400, 63, 62],
            [2001, 7401, 41, 49],
            [2001, 7402, 79, 101],
            [2001, 7403, 34, 41],
            [2001, 7404, 100, 75],
            [2001, 7405, 55, 56],
            [2001, 7406, 75, 94],
            [2001, 7407, 56, 56],
            [2001, 7408, 63, 78],
            [2001, 7409, 25, 31],
            [2001, 7410, 26, 32],
            [2001, 7411, 26, 32],
            [2001, 7412, 60, 65],
            [2001, 7413, 24, 31],
            [2001, 7414, 25, 31],
            [2001, 7415, 23, 36],
            [2001, 7416, 33, 42],
            [2001, 7417, 26, 33],
            [2001, 7418, 29, 32],
            [2001, 7419, 65, 72],
            [2001, 7420, 24, 32],
            [2001, 7421, 49, 57],
            [2001, 7422, 25, 31],
            [2001, 7423, 40, 43],
            [2001, 7424, 65, 60],
            [2001, 7425, 48, 41],
            [2001, 7426, 81, 70],
            [2001, 7427, 60, 57],
            [2001, 7428, 60, 60],
            [2001, 7429, 36, 40],
            [2001, 7430, 56, 43],
            [2001, 7431, 40, 43],
            [2001, 7432, 97, 74],
            [2001, 7433, 60, 56],
            [2001, 7434, 101, 64],
            [2001, 7435, 66, 61],
            [2001, 7436, 78, 70],
            [2001, 7437, 34, 45],
            [2001, 7438, 61, 60],
            [2001, 7439, 55, 50],
            [2001, 7440, 84, 75],
            [2001, 7441, 50, 46],
            [2001, 7442, 75, 65],
            [2001, 7443, 75, 67],
            [2001, 7444, 92, 75],
            [2001, 7445, 75, 63],
            [2001, 7446, 105, 80],
            [2001, 7447, 46, 47],
            [2001, 7448, 78, 77],
            [2001, 7449, 28, 27],
            [2001, 7450, 28, 32],
            [2001, 7451, 17, 20],
            [2001, 7452, 32, 21],
            [2001, 7453, 81, 39],
            [2001, 7454, 24, 25],
            [2001, 7455, 33, 30],
            [2001, 7456, 101, 76],
            [2001, 7457, 71, 71],
            [2001, 7458, 51, 51],
            [2001, 7459, 71, 71],
            [2001, 7460, 71, 81],
            [2001, 7461, 51, 50],
            [2001, 7462, 61, 61],
            [2001, 7463, 71, 71],
            [2001, 7464, 81, 61],
            [2001, 7465, 81, 61],
            [2001, 7466, 71, 53],
            [2001, 7467, 71, 71],
            [2001, 7468, 61, 61],
            [2001, 7469, 86, 65],
            [2001, 7470, 91, 68],
            [2001, 7471, 116, 87],
            [2001, 7472, 41, 91],
            [2001, 7473, 51, 61],
            [2001, 7474, 71, 71],
            [2001, 7475, 71, 71],
            [2001, 7476, 66, 66],
            [2001, 7477, 56, 56],
            [2001, 7478, 61, 61],
            [2001, 7479, 61, 61],
            [2001, 7480, 71, 60],
            [2001, 7481, 51, 61],
            [2001, 7482, 71, 53],
            [2001, 7483, 71, 71],
            [2001, 7484, 51, 61],
            [2001, 7485, 121, 91],
            [2001, 7486, 101, 76],
            [2001, 7487, 66, 66],
            [2001, 7488, 81, 61],
            [2001, 7489, 86, 55],
            [2001, 7490, 61, 61],
            [2001, 7491, 81, 61],
            [2001, 7492, 101, 76],
            [2001, 7493, 71, 71],
            [2001, 7494, 71, 71],
            [2001, 7495, 71, 71],
            [2001, 7496, 121, 91],
            [2001, 7497, 81, 61],
            [2001, 7498, 51, 61],
            [2001, 7499, 60, 51],
            [2001, 7500, 61, 61],
            [2001, 7501, 81, 61],
            [2001, 7502, 80, 61],
            [2001, 7503, 91, 68],
            [2001, 7504, 86, 64],
            [2001, 7505, 71, 71],
            [2001, 7506, 81, 61],
            [2001, 7507, 66, 66],
            [2001, 7508, 81, 61],
            [2001, 7509, 71, 71],
            [2001, 7510, 71, 71],
            [2001, 7511, 81, 61],
            [2001, 7512, 71, 71],
            [2001, 7513, 80, 61],
            [2001, 7514, 120, 91],
            [2001, 7515, 91, 68],
            [2001, 7516, 71, 71],
            [2001, 7517, 121, 91],
            [2001, 7518, 81, 61],
            [2001, 7519, 71, 71],
            [2001, 7520, 71, 71],
            [2001, 7521, 51, 61],
            [2001, 7522, 91, 68],
            [2001, 7523, 71, 71],
            [2001, 7524, 121, 121],
            [2001, 7525, 71, 71],
            [2001, 7526, 86, 64],
            [2001, 7527, 51, 61],
            [2001, 7528, 101, 76],
            [2001, 7529, 121, 121],
            [2001, 7530, 91, 68],
            [2001, 7531, 51, 61],
            [2001, 7532, 71, 71],
            [2001, 7533, 101, 76],
            [2001, 7534, 121, 121],
            [2001, 7535, 71, 71],
            [2001, 7536, 91, 68],
            [2001, 7537, 96, 72],
            [2001, 7538, 101, 76],
            [2001, 7539, 71, 71],
            [2001, 7540, 101, 76],
            [2001, 7541, 91, 68],
            [2001, 7542, 101, 76],
            [2001, 7543, 91, 68],
            [2001, 7544, 96, 72],
            [2001, 7545, 66, 66],
            [2001, 7546, 81, 61],
            [2001, 7547, 80, 61],
            [2001, 7548, 61, 61],
            [2001, 7549, 71, 71],
            [2001, 7550, 61, 61],
            [2001, 7551, 61, 61],
            [2001, 7552, 61, 61],
            [2001, 7553, 71, 71],
            [2001, 7554, 111, 101],
            [2001, 7555, 101, 81],
            [2001, 7556, 71, 71],
            [2001, 7557, 121, 91],
            [2001, 7558, 51, 51],
            [2001, 7559, 80, 61],
            [2001, 7560, 61, 61],
            [2001, 7561, 121, 91],
            [2001, 7562, 121, 91],
            [2001, 7563, 91, 68],
            [2001, 7564, 91, 68],
            [2001, 7565, 71, 71],
            [2001, 7566, 71, 71],
            [2001, 7567, 71, 71],
            [2001, 7568, 71, 71],
            [2001, 7569, 71, 71],
            [2001, 7570, 71, 71],
            [2001, 7571, 71, 71],
            [2001, 7572, 121, 91],
            [2001, 7573, 71, 61],
            [2001, 7574, 71, 71],
            [2001, 7575, 81, 61],
            [2001, 7576, 81, 61],
            [2001, 7577, 91, 68],
            [2001, 7578, 71, 71],
            [2001, 7579, 91, 68],
            [2001, 7580, 91, 68],
            [2001, 7581, 91, 68],
            [2001, 7582, 91, 80],
            [2001, 7583, 71, 71],
            [2001, 7584, 66, 66],
            [2001, 7585, 66, 65],
            [2001, 7586, 121, 91],
            [2001, 7587, 61, 61],
            [2001, 7588, 71, 71],
            [2001, 7589, 121, 91],
            [2001, 7590, 71, 71],
            [2001, 7591, 81, 61],
            [2001, 7592, 91, 68],
            [2001, 7593, 96, 72],
            [2001, 7594, 71, 71],
            [2001, 7595, 71, 71],
            [2001, 7596, 61, 61],
            [2001, 7597, 71, 71],
            [2001, 7598, 81, 61],
            [2001, 7599, 71, 71],
            [2001, 7600, 71, 71],
            [2001, 7601, 61, 61],
            [2001, 7602, 56, 56],
            [2001, 7603, 71, 71],
            [2001, 7604, 71, 71],
            [2001, 7605, 71, 71],
            [2001, 7606, 71, 61],
            [2001, 7607, 91, 68],
            [2001, 7608, 61, 61],
            [2001, 7609, 71, 71],
            [2001, 7610, 61, 61],
            [2001, 7611, 46, 71],
            [2001, 7612, 71, 68],
            [2001, 7613, 71, 71],
            [2001, 7614, 81, 71],
            [2001, 7615, 91, 68],
            [2001, 7616, 91, 68],
            [2001, 7617, 81, 61],
            [2001, 7618, 91, 68],
            [2001, 7619, 71, 71],
            [2001, 7620, 61, 61],
            [2001, 7621, 71, 71],
            [2001, 7622, 91, 68],
            [2001, 7623, 71, 71],
            [2001, 7624, 101, 76],
            [2001, 7625, 61, 61],
            [2001, 7626, 91, 68],
            [2001, 7627, 66, 66],
            [2001, 7628, 91, 68],
            [2001, 7629, 61, 61],
            [2001, 7630, 66, 66],
            [2001, 7631, 66, 66],
            [2001, 7632, 91, 68],
            [2001, 7633, 61, 61],
            [2001, 7634, 19, 34],
            [2001, 7635, 19, 28],
            [2001, 7636, 21, 31],
            [2001, 7637, 43, 42],
            [2001, 7638, 27, 23],
            [2001, 7639, 13, 17],
            [2001, 7640, 12, 14],
            [2001, 7641, 15, 19],
            [2001, 7642, 37, 46],
            [2001, 7643, 19, 20],
            [2001, 7644, 36, 52],
            [2001, 7645, 18, 25],
            [2001, 7646, 36, 34],
            [2001, 7647, 50, 31],
            [2001, 7648, 13, 14],
            [2001, 7649, 13, 14],
            [2001, 7650, 20, 22],
            [2001, 7651, 17, 14],
            [2001, 7652, 19, 15],
            [2001, 7653, 53, 41],
            [2001, 7654, 15, 17],
            [2001, 7655, 19, 18],
            [2001, 7656, 16, 15],
            [2001, 7657, 34, 35],
            [2001, 7658, 23, 33],
            [2001, 7659, 14, 21],
            [2001, 7661, 10, 10],
            [2001, 7662, 15, 13],
            [2001, 7663, 18, 20],
            [2001, 7664, 29, 44],
            [2001, 7665, 46, 67],
            [2001, 7666, 18, 23],
            [2001, 7667, 18, 21],
            [2001, 7668, 18, 14],
            [2001, 7669, 12, 8],
            [2001, 7670, 33, 26],
            [2001, 7671, 45, 39],
            [2001, 7672, 10, 9],
            [2001, 7673, 8, 7],
            [2001, 7674, 22, 19],
            [2001, 7675, 9, 10],
            [2001, 7676, 6, 7],
            [2001, 7677, 6, 6],
            [2001, 7678, 10, 8],
            [2001, 7679, 14, 11],
            [2001, 7680, 20, 22],
            [2001, 7681, 5, 3],
            [2001, 7682, 16, 13],
            [2001, 7683, 5, 3],
            [2001, 7684, 16, 15],
            [2001, 7685, 12, 11],
            [2001, 7686, 22, 20],
            [2001, 7687, 5, 3],
            [2001, 7688, 18, 17],
            [2001, 7689, 12, 13],
            [2001, 7690, 7, 8],
            [2001, 7691, 21, 26],
            [2001, 7692, 11, 10],
            [2001, 7693, 9, 9],
            [2001, 7694, 10, 9],
            [2001, 7695, 31, 21],
            [2001, 7696, 5, 3],
            [2001, 7697, 16, 12],
            [2001, 7698, 10, 8],
            [2001, 7699, 14, 16],
            [2001, 7700, 11, 10],
            [2001, 7701, 9, 8],
            [2001, 7702, 17, 13],
            [2001, 7703, 15, 15],
            [2001, 7704, 18, 19],
            [2001, 7705, 22, 14],
            [2001, 7706, 11, 10],
            [2001, 7707, 10, 10],
            [2001, 7708, 9, 7],
            [2001, 7709, 12, 15],
            [2001, 7710, 6, 6],
            [2001, 7711, 16, 12],
            [2001, 7712, 13, 10],
            [2001, 7713, 21, 12],
            [2001, 7714, 11, 9],
            [2001, 7715, 44, 52],
            [2001, 7716, 55, 56],
            [2001, 7717, 78, 99],
            [2001, 7718, 57, 56],
            [2001, 7719, 42, 49],
            [2001, 7720, 80, 102],
            [2001, 7721, 57, 57],
            [2001, 7722, 71, 57],
            [2001, 7723, 41, 48],
            [2001, 7724, 76, 96],
            [2001, 7725, 24, 33],
            [2001, 7726, 43, 51],
            [2001, 7727, 58, 58],
            [2001, 7728, 71, 69],
            [2001, 7729, 57, 57],
            [2001, 7730, 41, 48],
            [2001, 7731, 77, 98],
            [2001, 7732, 43, 51],
            [2001, 7733, 63, 78],
            [2001, 7734, 92, 71],
            [2001, 7735, 102, 100],
            [2001, 7736, 41, 49],
            [2001, 7737, 62, 61],
            [2001, 7738, 41, 49],
            [2001, 7739, 46, 61],
            [2001, 7740, 42, 49],
            [2001, 7741, 62, 76],
            [2001, 7742, 69, 75],
            [2001, 7743, 56, 56],
            [2001, 7744, 77, 97],
            [2001, 7745, 78, 61],
            [2001, 7746, 57, 57],
            [2001, 7747, 72, 92],
            [2001, 7748, 64, 63],
            [2001, 7749, 57, 58],
            [2001, 7750, 70, 89],
            [2001, 7751, 92, 71],
            [2001, 7752, 101, 99],
            [2001, 7753, 63, 62],
            [2001, 7754, 57, 58],
            [2001, 7755, 42, 49],
            [2001, 7756, 95, 62],
            [2001, 7757, 73, 61],
            [2001, 7758, 106, 80],
            [2001, 7759, 36, 42],
            [2001, 7760, 72, 74],
            [2001, 7761, 43, 55],
            [2001, 7762, 93, 85],
            [2001, 7763, 19, 28],
            [2001, 7764, 19, 27],
            [2001, 7765, 20, 31],
            [2001, 7766, 11, 21],
            [2001, 7767, 29, 36],
            [2001, 7768, 12, 23],
            [2001, 7769, 42, 39],
            [2001, 7770, 62, 45],
            [2001, 7771, 17, 18],
            [2001, 7772, 16, 20],
            [2001, 7773, 26, 28],
            [2001, 7774, 15, 26],
            [2001, 7775, 45, 42],
            [2001, 7776, 18, 37],
            [2001, 7777, 24, 39],
            [2001, 7778, 9, 13],
            [2001, 7779, 15, 20],
            [2001, 7780, 23, 23],
            [2001, 7781, 30, 33],
            [2001, 7782, 36, 29],
            [2001, 7783, 37, 28],
            [2001, 7784, 15, 36],
            [2001, 7785, 26, 46],
            [2001, 7786, 16, 18],
            [2001, 7787, 26, 33],
            [2001, 7788, 23, 27],
            [2001, 7789, 24, 30],
            [2001, 7790, 24, 31],
            [2001, 7791, 47, 43],
            [2001, 7792, 20, 26],
            [2001, 7793, 38, 38],
            [2001, 7795, 61, 58],
            [2001, 7796, 96, 74],
            [2001, 7797, 61, 59],
            [2001, 7798, 61, 58],
            [2001, 7799, 61, 59],
            [2001, 7800, 60, 60],
            [2001, 7801, 63, 59],
            [2001, 7802, 61, 57],
            [2001, 7803, 63, 62],
            [2001, 7804, 98, 74],
            [2001, 7805, 62, 59],
            [2001, 7806, 63, 59],
            [2001, 7807, 61, 57],
            [2001, 7808, 100, 75],
            [2001, 7809, 100, 74],
            [2001, 7810, 60, 56],
            [2001, 7811, 61, 58],
            [2001, 7812, 61, 57],
            [2001, 7813, 62, 58],
            [2001, 7815, 62, 59],
            [2001, 7816, 61, 57],
            [2001, 7817, 99, 74],
            [2001, 7818, 62, 59],
            [2001, 7819, 62, 58],
            [2001, 7820, 63, 75],
            [2001, 7821, 61, 58],
            [2001, 7822, 99, 76],
            [2001, 7823, 95, 73],
            [2001, 7824, 103, 77],
            [2001, 7825, 62, 58],
            [2001, 7826, 99, 74],
            [2001, 7827, 45, 50],
            [2001, 7828, 61, 58],
            [2001, 7829, 60, 60],
            [2001, 7830, 62, 58],
            [2001, 7831, 62, 60],
            [2001, 7832, 62, 58],
            [2001, 7833, 61, 57],
            [2001, 7834, 45, 50],
            [2001, 7835, 62, 58],
            [2001, 7836, 102, 76],
            [2001, 7837, 62, 58],
            [2001, 7838, 99, 74],
            [2001, 7839, 62, 58],
            [2001, 7840, 99, 74],
            [2001, 7841, 61, 57],
            [2001, 7842, 61, 59],
            [2001, 7843, 61, 58],
            [2001, 7844, 61, 56],
            [2001, 7845, 23, 14],
            [2001, 7846, 62, 58],
            [2001, 7847, 100, 75],
            [2001, 7848, 100, 75],
            [2001, 7849, 104, 78],
            [2001, 7850, 45, 50],
            [2001, 7851, 61, 57],
            [2001, 7852, 38, 44],
            [2001, 7853, 46, 51],
            [2001, 7854, 45, 49],
            [2001, 7855, 45, 50],
            [2001, 7856, 43, 50],
            [2001, 7857, 61, 57],
            [2001, 7858, 61, 58],
            [2001, 7859, 60, 59],
            [2001, 7860, 62, 57],
            [2001, 7861, 59, 55],
            [2001, 7862, 106, 79],
            [2001, 7863, 107, 80],
            [2001, 7864, 61, 59],
            [2001, 7865, 63, 60],
            [2001, 7866, 99, 74],
            [2001, 7867, 62, 58],
            [2001, 7868, 62, 58],
            [2001, 7869, 98, 73],
            [2001, 7870, 62, 58],
            [2001, 7871, 61, 59],
            [2001, 7872, 99, 74],
            [2001, 7873, 61, 57],
            [2001, 7874, 62, 58],
            [2001, 7875, 45, 50],
            [2001, 7876, 61, 57],
            [2001, 7877, 101, 75],
            [2001, 7878, 63, 61],
            [2001, 7879, 61, 59],
            [2001, 7880, 61, 59],
            [2001, 7881, 61, 59],
            [2001, 7882, 45, 39],
            [2001, 7883, 45, 50],
            [2001, 7884, 61, 58],
            [2001, 7885, 61, 59],
            [2001, 7886, 61, 59],
            [2001, 7887, 62, 58],
            [2001, 7888, 62, 58],
            [2001, 7889, 99, 74],
            [2001, 7890, 61, 59],
            [2001, 7891, 45, 50],
            [2001, 7892, 62, 58],
            [2001, 7893, 62, 57],
            [2001, 7894, 63, 59],
            [2001, 7895, 62, 60],
            [2001, 7896, 99, 74],
            [2001, 7897, 101, 75],
            [2001, 7898, 62, 57],
            [2001, 7899, 62, 60],
            [2001, 7900, 99, 74],
            [2001, 7901, 61, 56],
            [2001, 7902, 61, 60],
            [2001, 7903, 99, 74],
            [2001, 7904, 62, 57],
            [2001, 7905, 61, 57],
            [2001, 7906, 62, 58],
            [2001, 7907, 100, 74],
            [2001, 7908, 95, 74],
            [2001, 7909, 62, 59],
            [2001, 7910, 62, 58],
            [2001, 7911, 61, 56],
            [2001, 7912, 62, 58],
            [2001, 7913, 61, 59],
            [2001, 7914, 61, 59],
            [2001, 7915, 99, 74],
            [2001, 7916, 97, 74],
            [2001, 7917, 101, 75],
            [2001, 7918, 61, 57],
            [2001, 7919, 62, 58],
            [2001, 7920, 100, 75],
            [2001, 7921, 62, 57],
            [2001, 7922, 63, 59],
            [2001, 7923, 61, 57],
            [2001, 7924, 62, 57],
            [2001, 7925, 62, 57],
            [2001, 7926, 97, 75],
            [2001, 7927, 62, 58],
            [2001, 7928, 43, 50],
            [2001, 7929, 101, 75],
            [2001, 7930, 61, 57],
            [2001, 7931, 62, 58],
            [2001, 7932, 62, 58],
            [2001, 7933, 45, 51],
            [2001, 7934, 43, 51],
            [2001, 7935, 63, 59],
            [2001, 7936, 62, 58],
            [2001, 7937, 62, 57],
            [2001, 7938, 61, 58],
            [2001, 7939, 99, 76],
            [2001, 7940, 98, 73],
            [2001, 7941, 99, 74],
            [2001, 7942, 61, 59],
            [2001, 7943, 62, 58],
            [2001, 7944, 43, 50],
            [2001, 7945, 99, 74],
            [2001, 7946, 62, 58],
            [2001, 7947, 99, 74],
            [2001, 7948, 45, 51],
            [2001, 7949, 100, 74],
            [2001, 7950, 104, 77],
            [2001, 7951, 61, 57],
            [2001, 7952, 51, 44],
            [2001, 7953, 45, 51],
            [2001, 7954, 62, 58],
            [2001, 7955, 62, 58],
            [2001, 7956, 63, 59],
            [2001, 7957, 96, 74],
            [2001, 7958, 101, 75],
            [2001, 7959, 62, 58],
            [2001, 7960, 58, 58],
            [2001, 7961, 62, 59],
            [2001, 7962, 63, 59],
            [2001, 7963, 45, 50],
            [2001, 7964, 100, 74],
            [2001, 7965, 62, 61],
            [2001, 7966, 60, 58],
            [2001, 7967, 61, 57],
            [2001, 7968, 107, 80],
            [2001, 7969, 99, 74],
            [2001, 7970, 62, 58],
            [2001, 7971, 45, 50],
            [2001, 7972, 61, 57],
            [2001, 7974, 45, 51],
            [2001, 7975, 62, 58],
            [2001, 7976, 100, 75],
            [2001, 7977, 61, 58],
            [2001, 7978, 99, 74],
            [2001, 7979, 100, 75],
            [2001, 7980, 61, 57],
            [2001, 7981, 100, 74],
            [2001, 7982, 62, 58],
            [2001, 7983, 61, 57],
            [2001, 7984, 100, 75],
            [2001, 7985, 61, 59],
            [2001, 7986, 61, 57],
            [2001, 7987, 61, 59],
            [2001, 7988, 98, 73],
            [2001, 7989, 47, 54],
            [2001, 7990, 62, 50],
            [2001, 7992, 63, 59],
            [2001, 7993, 99, 76],
            [2001, 7994, 60, 57],
            [2001, 7995, 61, 58],
            [2001, 7996, 61, 59],
            [2001, 7997, 62, 58],
            [2001, 7998, 62, 58],
            [2001, 7999, 61, 58],
            [2001, 8000, 45, 50],
            [2001, 8001, 61, 59],
            [2001, 8002, 45, 50],
            [2001, 8003, 43, 50],
            [2001, 8004, 45, 50],
            [2001, 8005, 27, 34],
            [2001, 8006, 17, 24],
            [2001, 8007, 28, 37],
            [2001, 8008, 23, 31],
            [2001, 8009, 20, 21],
            [2001, 8010, 16, 20],
            [2001, 8011, 19, 22],
            [2001, 8012, 14, 18],
            [2001, 8013, 8, 8],
            [2001, 8014, 9, 10],
            [2001, 8015, 12, 13],
            [2001, 8016, 6, 6],
            [2001, 8017, 14, 14],
            [2001, 8018, 8, 9],
            [2001, 8019, 18, 20],
            [2001, 8020, 15, 17],
            [2001, 8021, 7, 8],
            [2001, 8022, 32, 42],
            [2001, 8023, 18, 20],
            [2001, 8024, 24, 22],
            [2001, 8025, 18, 25],
            [2001, 8026, 20, 22],
            [2001, 8027, 13, 11],
            [2001, 8028, 16, 16],
            [2001, 8029, 32, 29],
            [2001, 8030, 20, 17],
            [2001, 8031, 12, 11],
            [2001, 8032, 20, 29],
            [2001, 8033, 31, 34],
            [2001, 8034, 29, 41],
            [2001, 8035, 23, 22],
            [2001, 8036, 19, 25],
            [2001, 8037, 28, 34],
            [2001, 8038, 56, 56],
            [2001, 8039, 39, 70],
            [2001, 8040, 23, 70],
            [2001, 8041, 8, 18],
            [2001, 8042, 7, 10],
            [2001, 8043, 12, 18],
            [2001, 8044, 12, 17],
            [2001, 8045, 5, 3],
            [2001, 8046, 5, 3],
            [2001, 8047, 5, 6],
            [2001, 8048, 17, 23],
            [2001, 8049, 13, 17],
            [2001, 8050, 10, 11],
            [2001, 8051, 23, 27],
            [2001, 8052, 42, 49],
            [2001, 8053, 28, 39],
            [2001, 8054, 24, 34],
            [2001, 8055, 35, 50],
            [2001, 8056, 46, 54],
            [2001, 8057, 29, 36],
            [2001, 8058, 24, 29],
            [2001, 8059, 27, 34],
            [2001, 8060, 32, 37],
            [2001, 8061, 60, 67],
            [2001, 8062, 62, 80],
            [2001, 8063, 13, 10],
            [2001, 8064, 14, 17],
            [2001, 8065, 20, 15],
            [2001, 8066, 91, 56],
            [2001, 8067, 45, 34],
            [2001, 8068, 14, 12],
            [2001, 8069, 13, 30],
            [2001, 8070, 19, 20],
            [2001, 8071, 57, 24],
            [2001, 8072, 48, 27],
            [2001, 8073, 70, 34],
            [2001, 8074, 15, 18],
            [2001, 8075, 16, 19],
            [2001, 8076, 70, 50],
            [2001, 8077, 102, 43],
            [2001, 8078, 31, 45],
            [2001, 8079, 76, 61],
            [2001, 8080, 97, 27],
            [2001, 8081, 117, 60],
            [2001, 8082, 79, 46],
            [2001, 8083, 127, 51],
            [2001, 8084, 74, 64],
            [2001, 8085, 55, 38],
            [2001, 8086, 18, 52],
            [2001, 8087, 15, 36],
            [2001, 8088, 20, 42],
            [2001, 8089, 24, 56],
            [2001, 8090, 26, 40],
            [2001, 8091, 26, 70],
            [2001, 8092, 25, 54],
            [2001, 8093, 28, 70],
            [2001, 8094, 14, 70],
            [2001, 8095, 23, 29],
            [2001, 8096, 27, 43],
            [2001, 8097, 21, 37],
            [2001, 8098, 9, 30],
            [2001, 8099, 56, 56],
            [2001, 8100, 56, 56],
            [2001, 8101, 57, 56],
            [2001, 8102, 42, 49],
            [2001, 8103, 57, 56],
            [2001, 8104, 56, 56],
            [2001, 8105, 93, 72],
            [2001, 8106, 58, 58],
            [2001, 8107, 42, 49],
            [2001, 8108, 62, 61],
            [2001, 8109, 57, 57],
            [2001, 8110, 41, 49],
            [2001, 8111, 61, 60],
            [2001, 8112, 56, 56],
            [2001, 8113, 93, 72],
            [2001, 8114, 42, 49],
            [2001, 8115, 80, 102],
            [2001, 8116, 58, 58],
            [2001, 8117, 62, 99],
            [2001, 8118, 42, 50],
            [2001, 8119, 57, 57],
            [2001, 8120, 61, 60],
            [2001, 8121, 42, 49],
            [2001, 8122, 56, 56],
            [2001, 8123, 94, 72],
            [2001, 8124, 57, 57],
            [2001, 8125, 94, 72],
            [2001, 8126, 54, 54],
            [2001, 8127, 57, 58],
            [2001, 8128, 104, 102],
            [2001, 8129, 56, 56],
            [2001, 8130, 94, 72],
            [2001, 8131, 41, 49],
            [2001, 8132, 62, 61],
            [2001, 8133, 42, 50],
            [2001, 8134, 63, 61],
            [2001, 8135, 94, 72],
            [2001, 8136, 33, 41],
            [2001, 8137, 56, 57],
            [2001, 8138, 58, 58],
            [2001, 8139, 72, 86],
            [2001, 8140, 70, 90],
            [2001, 8141, 56, 56],
            [2001, 8142, 56, 56],
            [2001, 8143, 79, 101],
            [2001, 8144, 36, 43],
            [2001, 8145, 41, 48],
            [2001, 8146, 61, 75],
            [2001, 8147, 56, 56],
            [2001, 8148, 57, 57],
            [2001, 8149, 42, 50],
            [2001, 8150, 81, 104],
            [2001, 8151, 41, 49],
            [2001, 8152, 70, 89],
            [2001, 8153, 56, 57],
            [2001, 8154, 56, 56],
            [2001, 8155, 90, 69],
            [2001, 8156, 89, 119],
            [2001, 8157, 58, 58],
            [2001, 8158, 57, 56],
            [2001, 8159, 54, 55],
            [2001, 8160, 56, 56],
            [2001, 8161, 94, 72],
            [2001, 8162, 95, 73],
            [2001, 8163, 63, 59],
            [2001, 8164, 56, 56],
            [2001, 8165, 57, 57],
            [2001, 8166, 102, 77],
            [2001, 8167, 94, 72],
            [2001, 8168, 56, 57],
            [2001, 8169, 62, 59],
            [2001, 8170, 57, 57],
            [2001, 8171, 57, 57],
            [2001, 8172, 102, 76],
            [2001, 8173, 56, 56],
            [2001, 8174, 57, 57],
            [2001, 8175, 42, 49],
            [2001, 8176, 42, 49],
            [2001, 8177, 42, 50],
            [2001, 8178, 58, 58],
            [2001, 8179, 61, 60],
            [2001, 8180, 56, 56],
            [2001, 8181, 101, 76],
            [2001, 8182, 94, 72],
            [2001, 8183, 58, 58],
            [2001, 8184, 56, 56],
            [2001, 8185, 56, 56],
            [2001, 8186, 57, 57],
            [2001, 8187, 42, 50],
            [2001, 8188, 33, 41],
            [2001, 8189, 62, 60],
            [2001, 8190, 41, 48],
            [2001, 8191, 93, 92],
            [2001, 8192, 58, 57],
            [2001, 8193, 101, 75],
            [2001, 8194, 56, 55],
            [2001, 8195, 57, 56],
            [2001, 8196, 42, 50],
            [2001, 8197, 58, 58],
            [2001, 8198, 42, 50],
            [2001, 8199, 77, 98],
            [2001, 8200, 42, 49],
            [2001, 8201, 102, 77],
            [2001, 8202, 73, 72],
            [2001, 8203, 99, 72],
            [2001, 8204, 93, 72],
            [2001, 8205, 40, 47],
            [2001, 8206, 64, 63],
            [2001, 8207, 56, 56],
            [2001, 8208, 41, 49],
            [2001, 8209, 102, 77],
            [2001, 8210, 57, 57],
            [2001, 8211, 79, 101],
            [2001, 8212, 42, 49],
            [2001, 8213, 57, 57],
            [2001, 8214, 78, 99],
            [2001, 8215, 57, 57],
            [2001, 8216, 57, 56],
            [2001, 8217, 58, 57],
            [2001, 8218, 23, 35],
            [2001, 8219, 64, 63],
            [2001, 8220, 41, 49],
            [2001, 8221, 62, 60],
            [2001, 8222, 34, 42],
            [2001, 8223, 41, 49],
            [2001, 8224, 61, 74],
            [2001, 8225, 45, 53],
            [2001, 8226, 79, 101],
            [2001, 8227, 57, 56],
            [2001, 8228, 40, 47],
            [2001, 8229, 56, 55],
            [2001, 8230, 57, 57],
            [2001, 8231, 33, 41],
            [2001, 8232, 70, 71],
            [2001, 8233, 56, 56],
            [2001, 8234, 40, 48],
            [2001, 8235, 78, 99],
            [2001, 8236, 42, 49],
            [2001, 8237, 70, 69],
            [2001, 8238, 56, 56],
            [2001, 8239, 118, 90],
            [2001, 8240, 57, 56],
            [2001, 8241, 42, 50],
            [2001, 8242, 63, 62],
            [2001, 8245, 57, 57],
            [2001, 8246, 58, 58],
            [2001, 8247, 93, 72],
            [2001, 8248, 34, 41],
            [2001, 8249, 62, 61],
            [2001, 8250, 56, 56],
            [2001, 8251, 57, 56],
            [2001, 8252, 61, 60],
            [2001, 8253, 92, 71],
            [2001, 8254, 42, 53],
            [2001, 8255, 56, 56],
            [2001, 8256, 42, 49],
            [2001, 8257, 78, 99],
            [2001, 8258, 56, 56],
            [2001, 8259, 56, 56],
            [2001, 8260, 57, 58],
            [2001, 8261, 77, 98],
            [2001, 8262, 63, 64],
            [2001, 8263, 98, 74],
            [2001, 8264, 43, 51],
            [2001, 8265, 63, 102],
            [2001, 8267, 93, 71],
            [2001, 8268, 57, 57],
            [2001, 8269, 57, 56],
            [2001, 8270, 32, 41],
            [2001, 8271, 42, 50],
            [2001, 8272, 61, 60],
            [2001, 8273, 57, 56],
            [2001, 8274, 56, 56],
            [2001, 8275, 43, 50],
            [2001, 8276, 56, 56],
            [2001, 8277, 50, 35],
            [2001, 8278, 94, 72],
            [2001, 8279, 56, 56],
            [2001, 8280, 58, 58],
            [2001, 8281, 56, 56],
            [2001, 8282, 58, 58],
            [2001, 8283, 57, 57],
            [2001, 8284, 57, 56],
            [2001, 8285, 58, 58],
            [2001, 8286, 58, 58],
            [2001, 8287, 57, 57],
            [2001, 8288, 42, 50],
            [2001, 8289, 62, 61],
            [2001, 8290, 58, 58],
            [2001, 8291, 58, 58],
            [2001, 8292, 57, 57],
            [2001, 8293, 56, 56],
            [2001, 8294, 56, 56],
            [2001, 8295, 93, 72],
            [2001, 8296, 93, 57],
            [2001, 8297, 57, 57],
            [2001, 8298, 29, 57],
            [2001, 8299, 34, 41],
            [2001, 8300, 102, 77],
            [2001, 8301, 58, 57],
            [2001, 8302, 56, 56],
            [2001, 8303, 94, 72],
            [2001, 8304, 56, 56],
            [2001, 8305, 92, 71],
            [2001, 8306, 42, 50],
            [2001, 8307, 33, 41],
            [2001, 8308, 56, 56],
            [2001, 8309, 22, 30],
            [2001, 8310, 62, 60],
            [2001, 8311, 22, 28],
            [2001, 8312, 20, 24],
            [2001, 8313, 20, 24],
            [2001, 8314, 23, 30],
            [2001, 8315, 20, 24],
            [2001, 8316, 20, 24],
            [2001, 8317, 59, 59],
            [2001, 8318, 97, 73],
            [2001, 8319, 33, 39],
            [2001, 8320, 94, 72],
            [2001, 8321, 58, 43],
            [2001, 8322, 57, 57],
            [2001, 8323, 42, 50],
            [2001, 8324, 99, 74],
            [2001, 8325, 96, 74],
            [2001, 8326, 93, 72],
            [2001, 8327, 92, 71],
            [2001, 8328, 95, 73],
            [2001, 8329, 56, 56],
            [2001, 8330, 95, 73],
            [2001, 8331, 92, 71],
            [2001, 8332, 93, 72],
            [2001, 8333, 25, 34],
            [2001, 8334, 22, 32],
            [2001, 8335, 18, 29],
            [2001, 8336, 25, 20],
            [2001, 8337, 15, 19],
            [2001, 8338, 14, 15],
            [2001, 8339, 51, 53],
            [2001, 8340, 17, 20],
            [2001, 8341, 35, 42],
            [2001, 8342, 18, 18],
            [2001, 8343, 21, 22],
            [2001, 8344, 15, 14],
            [2001, 8345, 20, 16],
            [2001, 8346, 22, 31],
            [2001, 8347, 18, 21],
            [2001, 8348, 26, 35],
            [2001, 8349, 16, 20],
            [2001, 8350, 19, 21],
            [2001, 8351, 15, 11],
            [2001, 8352, 23, 36],
            [2001, 8353, 17, 21],
            [2001, 8354, 28, 36],
            [2001, 8355, 19, 20],
            [2001, 8356, 26, 34],
            [2001, 8357, 18, 18],
            [2001, 8358, 27, 20],
            [2001, 8359, 38, 50],
            [2001, 8360, 42, 53],
            [2001, 8361, 18, 16],
            [2001, 8362, 20, 30],
            [2001, 8363, 28, 40],
            [2001, 8364, 33, 29],
            [2001, 8365, 13, 15],
            [2001, 8366, 28, 25],
            [2001, 8367, 16, 18],
            [2001, 8368, 19, 30],
            [2001, 8369, 22, 31],
            [2001, 8370, 24, 25],
            [2001, 8371, 23, 22],
            [2001, 8372, 30, 25],
            [2001, 8373, 28, 37],
            [2001, 8374, 26, 37],
            [2001, 8375, 18, 17],
            [2001, 8376, 32, 35],
            [2001, 8377, 24, 19],
            [2001, 8378, 24, 20],
            [2001, 8379, 28, 26],
            [2001, 8380, 35, 33],
            [2001, 8381, 31, 41],
            [2001, 8382, 23, 26],
            [2001, 8383, 29, 35],
            [2001, 8384, 27, 43],
            [2001, 8385, 24, 33],
            [2001, 8386, 17, 21],
            [2001, 8387, 29, 30],
            [2001, 8388, 19, 20],
            [2001, 8389, 19, 23],
            [2001, 8390, 16, 18],
            [2001, 8391, 19, 24],
            [2001, 8392, 22, 27],
            [2001, 8393, 46, 67],
            [2001, 8394, 29, 23],
            [2001, 8395, 22, 25],
            [2001, 8396, 62, 60],
            [2001, 8397, 99, 74],
            [2001, 8398, 67, 53],
            [2001, 8399, 92, 58],
            [2001, 8400, 82, 74],
            [2001, 8401, 96, 58],
            [2001, 8402, 72, 60],
            [2001, 8403, 84, 57],
            [2001, 8404, 61, 59],
            [2001, 8405, 85, 57],
            [2001, 8406, 71, 59],
            [2001, 8407, 62, 60],
            [2001, 8408, 60, 73],
            [2001, 8409, 42, 37],
            [2001, 8410, 84, 63],
            [2001, 8411, 93, 65],
            [2001, 8412, 62, 61],
            [2001, 8413, 80, 64],
            [2001, 8414, 119, 57],
            [2001, 8415, 132, 84],
            [2001, 8416, 41, 44],
            [2001, 8417, 88, 59],
            [2001, 8418, 29, 35],
            [2001, 8419, 70, 52],
            [2001, 8420, 93, 71],
            [2001, 8421, 98, 74],
            [2001, 8422, 38, 42],
            [2001, 8423, 65, 63],
            [2001, 8424, 92, 103],
            [2001, 8425, 47, 63],
            [2001, 8426, 59, 57],
            [2001, 8427, 61, 52],
            [2001, 8428, 71, 58],
            [2001, 8429, 38, 38],
            [2001, 8430, 65, 63],
            [2001, 8431, 97, 73],
            [2001, 8432, 66, 63],
            [2001, 8433, 64, 62],
            [2001, 8434, 91, 60],
            [2001, 8435, 152, 71],
            [2001, 8436, 99, 74],
            [2001, 8438, 43, 38],
            [2001, 8439, 49, 46],
            [2001, 8440, 120, 70],
            [2001, 8441, 96, 60],
            [2001, 8442, 60, 59],
            [2001, 8443, 80, 73],
            [2001, 8444, 65, 63],
            [2001, 8445, 37, 35],
            [2001, 8446, 49, 44],
            [2001, 8447, 78, 64],
            [2001, 8448, 62, 58],
            [2001, 8449, 140, 56],
            [2001, 8450, 103, 69],
            [2001, 8451, 22, 33],
            [2001, 8452, 31, 47],
            [2001, 8453, 20, 29],
            [2001, 8454, 35, 46],
            [2001, 8455, 25, 33],
            [2001, 8456, 24, 33],
            [2001, 8457, 65, 63],
            [2001, 8458, 54, 44],
            [2001, 8459, 81, 58],
            [2001, 8460, 61, 59],
            [2001, 8461, 106, 58],
            [2001, 8462, 88, 59],
            [2001, 8463, 87, 70],
            [2001, 8464, 99, 74],
            [2001, 8465, 42, 33],
            [2001, 8466, 48, 60],
            [2001, 8467, 54, 51],
            [2001, 8468, 76, 64],
            [2001, 8469, 64, 58],
            [2001, 8470, 99, 75],
            [2001, 8471, 41, 50],
            [2001, 8472, 115, 57],
            [2001, 8473, 80, 74],
            [2001, 8474, 60, 59],
            [2001, 8475, 96, 72],
            [2001, 8476, 96, 73],
            [2001, 8477, 96, 73],
            [2001, 8478, 35, 39],
            [2001, 8479, 61, 59],
            [2001, 8480, 99, 75],
            [2001, 8481, 62, 52],
            [2001, 8482, 65, 55],
            [2001, 8483, 67, 58],
            [2001, 8484, 82, 64],
            [2001, 8485, 90, 74],
            [2001, 8486, 40, 35],
            [2001, 8487, 78, 58],
            [2001, 8488, 60, 57],
            [2001, 8489, 38, 66],
            [2001, 8490, 82, 64],
            [2001, 8491, 70, 72],
            [2001, 8492, 72, 57],
            [2001, 8493, 95, 58],
            [2001, 8494, 38, 33],
            [2001, 8495, 106, 109],
            [2001, 8496, 43, 58],
            [2001, 8497, 70, 75],
            [2001, 8498, 47, 58],
            [2001, 8499, 61, 58],
            [2001, 8500, 97, 59],
            [2001, 8501, 65, 80],
            [2001, 8502, 100, 59],
            [2001, 8503, 97, 73],
            [2001, 8504, 61, 60],
            [2001, 8505, 98, 74],
            [2001, 8506, 99, 74],
            [2001, 8507, 99, 75],
            [2001, 8508, 48, 52],
            [2001, 8509, 60, 58],
            [2001, 8510, 105, 73],
            [2001, 8511, 95, 72],
            [2001, 8512, 65, 63],
            [2001, 8513, 72, 70],
            [2001, 8514, 74, 72],
            [2001, 8515, 61, 60],
            [2001, 8516, 170, 92],
            [2001, 8517, 80, 32],
            [2001, 8518, 99, 95],
            [2001, 8519, 44, 43],
            [2001, 8520, 68, 58],
            [2001, 8521, 60, 58],
            [2001, 8522, 63, 59],
            [2001, 8523, 61, 58],
            [2001, 8524, 60, 57],
            [2001, 8525, 80, 58],
            [2001, 8526, 96, 73],
            [2001, 8527, 84, 86],
            [2001, 8528, 101, 83],
            [2001, 8529, 105, 82],
            [2001, 8530, 42, 41],
            [2001, 8531, 96, 93],
            [2001, 8532, 81, 86],
            [2001, 8533, 98, 93],
            [2001, 8534, 67, 68],
            [2001, 8535, 93, 96],
            [2001, 8536, 25, 55],
            [2001, 8537, 65, 42],
            [2001, 8538, 65, 42],
            [2001, 8539, 55, 47],
            [2001, 8540, 45, 80],
            [2001, 8541, 56, 88],
            [2001, 8542, 52, 85],
            [2001, 8543, 30, 81],
            [2001, 8544, 35, 88],
            [2001, 8546, 42, 80],
            [2001, 8547, 42, 86],
            [2001, 8548, 16, 22],
            [2001, 8549, 26, 35],
            [2001, 8550, 21, 33],
            [2001, 8551, 40, 33],
            [2001, 8552, 35, 44],
            [2001, 8553, 53, 74],
            [2001, 8554, 24, 21],
            [2001, 8555, 43, 41],
            [2001, 8556, 49, 72],
            [2001, 8557, 71, 70],
            [2001, 8558, 33, 37],
            [2001, 8559, 44, 44],
            [2001, 8560, 34, 41],
            [2001, 8561, 25, 33],
            [2001, 8562, 41, 42],
            [2001, 8563, 53, 59],
            [2001, 8564, 108, 86],
            [2001, 8565, 10, 13],
            [2001, 8566, 16, 15],
            [2001, 8567, 24, 23],
            [2001, 8568, 18, 17],
            [2001, 8569, 18, 16],
            [2001, 8570, 10, 10],
            [2001, 8571, 14, 11],
            [2001, 8572, 15, 11],
            [2001, 8573, 13, 11],
            [2001, 8574, 15, 13],
            [2001, 8575, 10, 10],
            [2001, 8576, 23, 17],
            [2001, 8577, 19, 17],
            [2001, 8578, 25, 25],
            [2001, 8579, 20, 22],
            [2001, 8580, 18, 18],
            [2001, 8581, 12, 10],
            [2001, 8582, 19, 18],
            [2001, 8583, 20, 19],
            [2001, 8584, 15, 15],
            [2001, 8585, 13, 13],
            [2001, 8586, 25, 20],
            [2001, 8587, 11, 9],
            [2001, 8588, 25, 15],
            [2001, 8589, 14, 13],
            [2001, 8590, 25, 16],
            [2001, 8591, 21, 17],
            [2001, 8592, 35, 36],
            [2001, 8593, 29, 29],
            [2001, 8594, 30, 29],
            [2001, 8595, 14, 13],
            [2001, 8596, 15, 16],
            [2001, 8597, 22, 13],
            [2001, 8598, 18, 12],
            [2001, 8599, 15, 13],
            [2001, 8600, 25, 16],
            [2001, 8601, 34, 25],
            [2001, 8602, 34, 23],
            [2001, 8603, 20, 17],
            [2001, 8604, 23, 20],
            [2001, 8605, 20, 19],
            [2001, 8606, 26, 18],
            [2001, 8607, 20, 18],
            [2001, 8608, 25, 22],
            [2001, 8609, 30, 22],
            [2001, 8610, 27, 20],
            [2001, 8611, 21, 15],
            [2001, 8612, 25, 17],
            [2001, 8613, 15, 12],
            [2001, 8614, 20, 15],
            [2001, 8615, 13, 13],
            [2001, 8616, 25, 18],
            [2001, 8617, 36, 16],
            [2001, 8618, 21, 13],
            [2001, 8619, 26, 15],
            [2001, 8622, 50, 35],
            [2001, 8623, 54, 36],
            [2001, 8624, 19, 14],
            [2001, 8625, 39, 34],
            [2001, 8626, 28, 19],
            [2001, 8627, 30, 24],
            [2001, 8628, 39, 31],
            [2001, 8629, 40, 31],
            [2001, 8630, 27, 19],
            [2001, 8631, 34, 23],
            [2001, 8632, 25, 18],
            [2001, 8633, 28, 21],
            [2001, 8634, 15, 11],
            [2001, 8635, 18, 12],
            [2001, 8636, 12, 10],
            [2001, 8637, 18, 15],
            [2001, 8638, 18, 13],
            [2001, 8639, 21, 13],
            [2001, 8640, 28, 21],
            [2001, 8641, 49, 22],
            [2001, 8642, 31, 27],
            [2001, 8643, 35, 34],
            [2001, 8644, 36, 29],
            [2001, 8645, 26, 23],
            [2001, 8646, 33, 24],
            [2001, 8647, 21, 16],
            [2001, 8648, 20, 15],
            [2001, 8649, 28, 24],
            [2001, 8650, 41, 19],
            [2001, 8651, 39, 27],
            [2001, 8652, 54, 36],
            [2001, 8653, 34, 31],
            [2001, 8654, 45, 37],
            [2001, 8655, 25, 26],
            [2001, 8656, 25, 21],
            [2001, 8657, 10, 8],
            [2001, 8658, 16, 13],
            [2001, 8659, 37, 19],
            [2001, 8660, 16, 13],
            [2001, 8661, 19, 13],
            [2001, 8662, 23, 14],
            [2001, 8663, 25, 15],
            [2001, 8664, 32, 23],
            [2001, 8665, 53, 37],
            [2001, 8666, 23, 23],
            [2001, 8667, 26, 23],
            [2001, 8668, 24, 32],
            [2001, 8669, 48, 45],
            [2001, 8670, 21, 24],
            [2001, 8671, 30, 33],
            [2001, 8672, 16, 21],
            [2001, 8673, 29, 28],
            [2001, 8674, 29, 21],
            [2001, 8675, 39, 23],
            [2001, 8676, 51, 35],
            [2001, 8677, 59, 35],
            [2001, 8678, 48, 25],
            [2001, 8679, 55, 23],
            [2001, 8680, 28, 22],
            [2001, 8681, 44, 28],
            [2001, 8682, 49, 25],
            [2001, 8683, 48, 15],
            [2001, 8684, 33, 25],
            [2001, 8685, 24, 21],
            [2001, 8686, 24, 21],
            [2001, 8687, 35, 22],
            [2001, 8688, 47, 29],
            [2001, 8689, 40, 27],
            [2001, 8690, 54, 27],
            [2001, 8691, 27, 30],
            [2001, 8692, 57, 32],
            [2001, 8693, 45, 15],
            [2001, 8694, 52, 27],
            [2001, 8695, 16, 17],
            [2001, 8696, 21, 22],
            [2001, 8697, 21, 17],
            [2001, 8698, 23, 19],
            [2001, 8699, 29, 19],
            [2001, 8700, 30, 18],
            [2001, 8701, 35, 18],
            [2001, 8702, 34, 21],
            [2001, 8703, 29, 26],
            [2001, 8704, 39, 30],
            [2001, 8705, 33, 21],
            [2001, 8706, 42, 22],
            [2001, 8707, 25, 26],
            [2001, 8708, 38, 29],
            [2001, 8709, 45, 23],
            [2001, 8710, 43, 23],
            [2001, 8711, 14, 13],
            [2001, 8712, 26, 24],
            [2001, 8713, 40, 24],
            [2001, 8714, 8, 8],
            [2001, 8715, 10, 8],
            [2001, 8716, 12, 9],
            [2001, 8717, 14, 13],
            [2001, 8718, 14, 11],
            [2001, 8719, 23, 25],
            [2001, 8720, 30, 33],
            [2001, 8721, 30, 33],
            [2001, 8722, 28, 26],
            [2001, 8723, 30, 29],
            [2001, 8724, 29, 28],
            [2001, 8725, 25, 22],
            [2001, 8726, 28, 24],
            [2001, 8727, 25, 25],
            [2001, 8728, 22, 23],
            [2001, 8729, 27, 23],
            [2001, 8730, 21, 18],
            [2001, 8731, 22, 21],
            [2001, 8732, 28, 22],
            [2001, 8733, 29, 22],
            [2001, 8734, 25, 20],
            [2001, 8735, 22, 19],
            [2001, 8736, 22, 22],
            [2001, 8737, 22, 19],
            [2001, 8738, 24, 20],
            [2001, 8739, 24, 21],
            [2001, 8740, 24, 20],
            [2001, 8741, 28, 22],
            [2001, 8742, 25, 23],
            [2001, 8743, 25, 21],
            [2001, 8744, 25, 22],
            [2001, 8745, 29, 21],
            [2001, 8746, 31, 24],
            [2001, 8747, 32, 25],
            [2001, 8748, 33, 26],
            [2001, 8749, 27, 22],
            [2001, 8750, 25, 27],
            [2001, 8751, 25, 28],
            [2001, 8752, 20, 18],
            [2001, 8753, 21, 19],
            [2001, 8754, 21, 23],
            [2001, 8755, 22, 21],
            [2001, 8756, 34, 25],
            [2001, 8757, 21, 19],
            [2001, 8758, 21, 21],
            [2001, 8759, 25, 24],
            [2001, 8760, 34, 36],
            [2001, 8761, 26, 21],
            [2001, 8762, 33, 22],
            [2001, 8763, 19, 18],
            [2001, 8764, 35, 28],
            [2001, 8765, 29, 21],
            [2001, 8766, 29, 23],
            [2001, 8767, 35, 27],
            [2001, 8768, 34, 26],
            [2001, 8769, 22, 22],
            [2001, 8770, 35, 27],
            [2001, 8771, 37, 29],
            [2001, 8772, 35, 28],
            [2001, 8773, 20, 18],
            [2001, 8774, 21, 21],
            [2001, 8775, 22, 19],
            [2001, 8776, 21, 21],
            [2001, 8777, 26, 21],
            [2001, 8778, 37, 28],
            [2001, 8779, 10, 15],
            [2001, 8780, 14, 11],
            [2001, 8781, 16, 11],
            [2001, 8782, 17, 12],
            [2001, 8783, 11, 8],
            [2001, 8784, 14, 10],
            [2001, 8785, 8, 7],
            [2001, 8786, 10, 11],
            [2001, 8787, 12, 12],
            [2001, 8788, 14, 11],
            [2001, 8790, 8, 7],
            [2001, 8791, 7, 6],
            [2001, 8792, 13, 12],
            [2001, 8793, 8, 8],
            [2001, 8794, 8, 7],
            [2001, 8795, 9, 8],
            [2001, 8796, 15, 11],
            [2001, 8797, 17, 11],
            [2001, 8798, 9, 9],
            [2001, 8799, 12, 10],
            [2001, 8800, 11, 8],
            [2001, 8801, 13, 11],
            [2001, 8802, 8, 7],
            [2001, 8803, 9, 9],
            [2001, 8804, 7, 11],
            [2001, 8805, 10, 9],
            [2001, 8806, 10, 11],
            [2001, 8807, 15, 15],
            [2001, 8808, 8, 8],
            [2001, 8809, 6, 7],
            [2001, 8810, 12, 12],
            [2001, 8811, 8, 9],
            [2001, 8812, 13, 11],
            [2001, 8814, 7, 7],
            [2001, 8815, 9, 9],
            [2001, 8816, 13, 8],
            [2001, 8817, 19, 11],
            [2001, 8818, 56, 46],
            [2001, 8819, 41, 25],
            [2001, 8820, 63, 53],
            [2001, 8821, 53, 35],
            [2001, 8822, 64, 54],
            [2001, 8823, 34, 29],
            [2001, 8824, 24, 20],
            [2001, 8825, 38, 33],
            [2001, 8826, 24, 24],
            [2001, 8827, 43, 33],
            [2001, 8828, 46, 37],
            [2001, 8829, 47, 37],
            [2001, 8830, 31, 35],
            [2001, 8831, 38, 33],
            [2001, 8832, 20, 11],
            [2001, 8833, 37, 32],
            [2001, 8834, 42, 36],
            [2001, 8835, 37, 21],
            [2001, 8836, 55, 45],
            [2001, 8837, 36, 21],
            [2001, 8838, 47, 41],
            [2001, 8839, 29, 14],
            [2001, 8840, 42, 28],
            [2001, 8841, 29, 14],
            [2001, 8842, 17, 23],
            [2001, 8843, 21, 12],
            [2001, 8844, 29, 24],
            [2001, 8845, 15, 19],
            [2001, 8846, 38, 33],
            [2001, 8847, 20, 23],
            [2001, 8848, 55, 45],
            [2001, 8849, 34, 27],
            [2001, 8850, 42, 37],
            [2001, 8851, 26, 28],
            [2001, 8852, 38, 29],
            [2001, 8853, 14, 19],
            [2001, 8854, 38, 33],
            [2001, 8855, 21, 11],
            [2001, 8856, 34, 28],
            [2001, 8857, 26, 13],
            [2001, 8858, 34, 15],
            [2001, 8859, 51, 46],
            [2001, 8860, 36, 12],
            [2001, 8861, 38, 33],
            [2001, 8862, 28, 24],
            [2001, 8863, 43, 37],
            [2001, 8864, 22, 23],
            [2001, 8865, 34, 29],
            [2001, 8866, 22, 23],
            [2001, 8867, 60, 54],
            [2001, 8868, 42, 37],
            [2001, 8869, 56, 51],
            [2001, 8870, 51, 42],
            [2001, 8871, 41, 36],
            [2001, 8872, 30, 27],
            [2001, 8873, 45, 40],
            [2001, 8874, 38, 32],
            [2001, 8875, 38, 33],
            [2001, 8876, 21, 18],
            [2001, 8877, 47, 42],
            [2001, 8878, 19, 11],
            [2001, 8879, 33, 28],
            [2001, 8880, 34, 28],
            [2001, 8881, 62, 52],
            [2001, 8882, 36, 31],
            [2001, 8883, 56, 50],
            [2001, 8884, 20, 18],
            [2001, 8885, 69, 44],
            [2001, 8886, 38, 33],
            [2001, 8887, 22, 12],
            [2001, 8888, 35, 25],
            [2001, 8889, 51, 42],
            [2001, 8890, 14, 19],
            [2001, 8891, 38, 33],
            [2001, 8892, 14, 11],
            [2001, 8893, 38, 33],
            [2001, 8894, 20, 19],
            [2001, 8895, 15, 11],
            [2001, 8896, 29, 24],
            [2001, 8897, 15, 11],
            [2001, 8898, 22, 21],
            [2001, 8899, 58, 52],
            [2001, 8900, 43, 37],
            [2001, 8901, 55, 34],
            [2001, 8902, 38, 33],
            [2001, 8903, 28, 17],
            [2001, 8904, 38, 33],
            [2001, 8905, 27, 17],
            [2001, 8906, 33, 28],
            [2001, 8907, 24, 22],
            [2001, 8908, 34, 29],
            [2001, 8909, 25, 22],
            [2001, 8910, 26, 13],
            [2001, 8911, 26, 13],
            [2001, 8912, 47, 42],
            [2001, 8913, 31, 27],
            [2001, 8914, 46, 41],
            [2001, 8915, 31, 27],
            [2001, 8916, 55, 45],
            [2001, 8917, 43, 27],
            [2001, 8918, 51, 46],
            [2001, 8919, 39, 37],
            [2001, 8920, 40, 38],
            [2001, 8921, 40, 38],
            [2001, 8922, 33, 28],
            [2001, 8923, 26, 21],
            [2001, 8924, 16, 16],
            [2001, 8925, 12, 12],
            [2001, 8926, 16, 14],
            [2001, 8927, 19, 17],
            [2001, 8928, 15, 14],
            [2001, 8929, 11, 10],
            [2001, 8930, 9, 11],
            [2001, 8931, 15, 17],
            [2001, 8932, 21, 22],
            [2001, 8933, 30, 28],
            [2001, 8934, 30, 30],
            [2001, 8935, 55, 46],
            [2001, 8936, 29, 21],
            [2001, 8937, 38, 33],
            [2001, 8938, 29, 21],
            [2001, 8939, 34, 29],
            [2001, 8940, 20, 18],
            [2001, 8941, 33, 28],
            [2001, 8942, 20, 18],
            [2001, 8943, 31, 22],
            [2001, 8944, 34, 29],
            [2001, 8945, 25, 14],
            [2001, 8946, 34, 29],
            [2001, 8947, 25, 14],
            [2001, 8948, 34, 29],
            [2001, 8949, 25, 14],
            [2001, 8950, 25, 21],
            [2001, 8951, 34, 29],
            [2001, 8952, 25, 21],
            [2001, 8953, 56, 50],
            [2001, 8954, 31, 21],
            [2001, 8955, 47, 42],
            [2001, 8956, 33, 28],
            [2001, 8957, 31, 21],
            [2001, 8958, 56, 47],
            [2001, 8959, 32, 22],
            [2001, 8960, 56, 46],
            [2001, 8961, 31, 22],
            [2001, 8962, 51, 46],
            [2001, 8963, 34, 33],
            [2001, 8964, 21, 12],
            [2001, 8965, 51, 45],
            [2001, 8966, 43, 34],
            [2001, 8967, 47, 37],
            [2001, 8968, 33, 28],
            [2001, 8969, 22, 14],
            [2001, 8970, 47, 41],
            [2001, 8971, 47, 37],
            [2001, 8972, 21, 14],
            [2001, 8973, 47, 38],
            [2001, 8974, 14, 20],
            [2001, 8975, 55, 45],
            [2001, 8976, 59, 54],
            [2001, 8977, 29, 24],
            [2001, 8978, 14, 11],
            [2001, 8979, 43, 37],
            [2001, 8980, 34, 28],
            [2001, 8981, 33, 28],
            [2001, 8983, 38, 33],
            [2001, 8984, 27, 22],
            [2001, 8985, 38, 33],
            [2001, 8986, 27, 22],
            [2001, 8987, 29, 29],
            [2001, 8988, 19, 13],
            [2001, 8989, 38, 33],
            [2001, 8990, 20, 13],
            [2001, 8991, 38, 32],
            [2001, 8992, 19, 13],
            [2001, 8993, 42, 31],
            [2001, 8994, 45, 31],
            [2001, 8995, 44, 32],
            [2001, 8996, 55, 46],
            [2001, 8997, 25, 14],
            [2001, 8998, 29, 24],
            [2001, 8999, 21, 11],
            [2001, 9000, 63, 53],
            [2001, 9001, 54, 34],
            [2001, 9002, 46, 37],
            [2001, 9003, 26, 24],
            [2001, 9004, 56, 46],
            [2001, 9005, 25, 21],
            [2001, 9006, 38, 33],
            [2001, 9007, 31, 22],
            [2001, 9008, 45, 28],
            [2001, 9009, 37, 28],
            [2001, 9010, 29, 24],
            [2001, 9011, 21, 11],
            [2001, 9012, 29, 28],
            [2001, 9013, 14, 14],
            [2001, 9014, 46, 37],
            [2001, 9015, 23, 16],
            [2001, 9016, 22, 16],
            [2001, 9017, 47, 37],
            [2001, 9018, 31, 34],
            [2001, 9019, 37, 36],
            [2001, 9020, 20, 25],
            [2001, 9021, 38, 33],
            [2001, 9022, 26, 28],
            [2001, 9023, 39, 31],
            [2001, 9024, 46, 37],
            [2001, 9025, 34, 29],
            [2001, 9026, 38, 20],
            [2001, 9027, 34, 19],
            [2001, 9028, 46, 37],
            [2001, 9030, 50, 37],
            [2001, 9031, 42, 31],
            [2001, 9032, 50, 37],
            [2001, 9033, 34, 33],
            [2001, 9034, 55, 45],
            [2001, 9035, 46, 41],
            [2001, 9036, 42, 37],
            [2001, 9037, 19, 15],
            [2001, 9038, 29, 29],
            [2001, 9039, 15, 22],
            [2001, 9040, 42, 37],
            [2001, 9041, 28, 23],
            [2001, 9042, 46, 37],
            [2001, 9043, 38, 33],
            [2001, 9044, 29, 14],
            [2001, 9045, 38, 28],
            [2001, 9046, 32, 23],
            [2001, 9047, 42, 32],
            [2001, 9048, 36, 25],
            [2001, 9049, 68, 42],
            [2001, 9050, 34, 23],
            [2001, 9051, 47, 38],
            [2001, 9052, 22, 20],
            [2001, 9053, 31, 22],
            [2001, 9054, 34, 24],
            [2001, 9055, 26, 14],
            [2001, 9056, 38, 25],
            [2001, 9057, 51, 33],
            [2001, 9058, 31, 22],
            [2001, 9059, 56, 37],
            [2001, 9060, 50, 34],
            [2001, 9061, 25, 20],
            [2001, 9062, 14, 15],
            [2001, 9063, 38, 29],
            [2001, 9064, 14, 20],
            [2001, 9065, 25, 24],
            [2001, 9066, 18, 20],
            [2001, 9067, 34, 24],
            [2001, 9068, 31, 20],
            [2001, 9069, 38, 45],
            [2001, 9070, 14, 14],
            [2001, 9071, 29, 37],
            [2001, 9072, 14, 18],
            [2001, 9073, 14, 18],
            [2001, 9074, 33, 32],
            [2001, 9075, 25, 29],
            [2001, 9076, 25, 28],
            [2001, 9077, 38, 24],
            [2001, 9078, 31, 18],
            [2001, 9079, 51, 42],
            [2001, 9080, 23, 20],
            [2001, 9081, 35, 27],
            [2001, 9082, 56, 37],
            [2001, 9083, 26, 22],
            [2001, 9084, 33, 24],
            [2001, 9085, 21, 23],
            [2001, 9086, 42, 33],
            [2001, 9087, 47, 33],
            [2001, 9088, 35, 19],
            [2001, 9089, 18, 15],
            [2001, 9090, 25, 20],
            [2001, 9091, 26, 17],
            [2001, 9092, 51, 33],
            [2001, 9093, 24, 22],
            [2001, 9094, 55, 53],
            [2001, 9095, 14, 12],
            [2001, 9096, 29, 36],
            [2001, 9097, 38, 25],
            [2001, 9098, 42, 27],
            [2001, 9099, 21, 11],
            [2001, 9100, 45, 28],
            [2001, 9101, 14, 14],
            [2001, 9102, 45, 36],
            [2001, 9103, 33, 33],
            [2001, 9104, 42, 33],
            [2001, 9105, 19, 13],
            [2001, 9106, 25, 13],
            [2001, 9107, 38, 28],
            [2001, 9108, 38, 29],
            [2001, 9109, 43, 31],
            [2001, 9110, 51, 33],
            [2001, 9111, 29, 14],
            [2001, 9112, 56, 46],
            [2001, 9113, 27, 22],
            [2001, 9114, 34, 29],
            [2001, 9115, 14, 11],
            [2001, 9116, 20, 15],
            [2001, 9117, 35, 13],
            [2001, 9118, 54, 36],
            [2001, 9119, 19, 13],
            [2001, 9120, 29, 24],
            [2001, 9121, 37, 32],
            [2001, 9122, 46, 41],
            [2001, 9123, 34, 21],
            [2001, 9124, 43, 33],
            [2001, 9125, 19, 28],
            [2001, 9126, 50, 44],
            [2001, 9127, 33, 24],
            [2001, 9128, 38, 29],
            [2001, 9129, 53, 41],
            [2001, 9130, 60, 47],
            [2001, 9131, 31, 32],
            [2001, 9132, 55, 50],
            [2001, 9133, 31, 21],
            [2001, 9134, 38, 29],
            [2001, 9135, 57, 40],
            [2001, 9136, 50, 35],
            [2001, 9137, 20, 15],
            [2001, 9138, 17, 11],
            [2001, 9139, 36, 32],
            [2001, 9140, 47, 42],
            [2001, 9141, 31, 27],
            [2001, 9142, 56, 47],
            [2001, 9143, 21, 23],
            [2001, 9144, 25, 29],
            [2001, 9145, 42, 36],
            [2001, 9146, 50, 40],
            [2001, 9149, 21, 18],
            [2001, 9150, 25, 28],
            [2001, 9151, 20, 19],
            [2001, 9152, 31, 32],
            [2001, 9153, 15, 20],
            [2001, 9154, 18, 18],
            [2001, 9155, 27, 31],
            [2001, 9156, 32, 30],
            [2001, 9157, 35, 39],
            [2001, 9158, 13, 17],
            [2001, 9159, 24, 35],
            [2001, 9160, 15, 15],
            [2001, 9161, 20, 22],
            [2001, 9162, 31, 35],
            [2001, 9163, 33, 27],
            [2001, 9164, 23, 22],
            [2001, 9165, 22, 48],
            [2001, 9166, 27, 30],
            [2001, 9167, 20, 23],
            [2001, 9168, 34, 38],
            [2001, 9169, 23, 23],
            [2001, 9170, 32, 41],
            [2001, 9171, 20, 19],
            [2001, 9172, 23, 29],
            [2001, 9173, 25, 35],
            [2001, 9174, 18, 19],
            [2001, 9175, 21, 24],
            [2001, 9176, 12, 12],
            [2001, 9177, 28, 25],
            [2001, 9178, 24, 40],
            [2001, 9179, 26, 37],
            [2001, 9180, 12, 16],
            [2001, 9181, 20, 19],
            [2001, 9182, 30, 40],
            [2001, 9183, 26, 25],
            [2001, 9184, 30, 32],
            [2001, 9185, 23, 24],
            [2001, 9186, 19, 23],
            [2001, 9187, 27, 26],
            [2001, 9188, 29, 33],
            [2001, 9189, 25, 26],
            [2001, 9190, 18, 22],
            [2001, 9191, 23, 22],
            [2001, 9192, 25, 28],
            [2001, 9193, 20, 19],
            [2001, 9194, 34, 21],
            [2001, 9195, 40, 49],
            [2001, 9196, 31, 32],
            [2001, 9197, 43, 28],
            [2001, 9198, 39, 29],
            [2001, 9199, 70, 45],
            [2001, 9200, 49, 58],
            [2001, 9201, 65, 38],
            [2001, 9202, 50, 48],
            [2001, 9203, 13, 22],
            [2001, 9204, 12, 16],
            [2001, 9205, 32, 31],
            [2001, 9206, 20, 25],
            [2001, 9207, 34, 38],
            [2001, 9208, 49, 49],
            [2001, 9209, 34, 30],
            [2001, 9210, 60, 50],
            [2001, 9211, 30, 37],
            [2001, 9212, 53, 52],
            [2001, 9213, 80, 70],
            [2001, 9214, 51, 47],
            [2001, 9215, 20, 28],
            [2001, 9216, 75, 76],
            [2001, 9217, 67, 50],
            [2001, 9218, 29, 27],
            [2001, 9219, 53, 60],
            [2001, 9220, 39, 36],
            [2001, 9221, 32, 37],
            [2001, 9222, 50, 59],
            [2001, 9223, 46, 59],
            [2001, 9224, 63, 48],
            [2001, 9225, 50, 41],
            [2001, 9226, 74, 48],
            [2001, 9227, 76, 60],
            [2001, 9228, 79, 81],
            [2001, 9229, 57, 60],
            [2001, 9230, 43, 42],
            [2001, 9231, 83, 67],
            [2001, 9232, 54, 46],
            [2001, 9233, 46, 44],
            [2001, 9234, 30, 38],
            [2001, 9235, 45, 50],
            [2001, 9236, 26, 21],
            [2001, 9237, 44, 25],
            [2001, 9238, 45, 60],
            [2001, 9239, 66, 79],
            [2001, 9240, 45, 51],
            [2001, 9241, 34, 49],
            [2001, 9242, 51, 43],
            [2001, 9243, 64, 60],
            [2001, 9244, 50, 47],
            [2001, 9245, 25, 32],
            [2001, 9246, 37, 30],
            [2001, 9247, 57, 44],
            [2001, 9248, 47, 35],
            [2001, 9249, 31, 23],
            [2001, 9250, 35, 23],
            [2001, 9251, 38, 33],
            [2001, 9252, 21, 29],
            [2001, 9253, 96, 70],
            [2001, 9254, 110, 127],
            [2001, 9255, 55, 38],
            [2001, 9257, 93, 86],
            [2001, 9258, 49, 73],
            [2001, 9259, 77, 77],
            [2001, 9260, 62, 46],
            [2001, 9261, 102, 132],
            [2001, 9263, 66, 74],
            [2001, 9264, 64, 70],
            [2001, 9265, 67, 74],
            [2001, 9266, 105, 132],
            [2001, 9267, 77, 80],
            [2001, 9268, 69, 77],
            [2001, 9269, 107, 121],
            [2001, 9270, 105, 132],
            [2001, 9271, 106, 134],
            [2001, 9272, 108, 137],
            [2001, 9273, 114, 145],
            [2001, 9274, 94, 92],
            [2001, 9275, 80, 76],
            [2001, 9276, 97, 92],
            [2001, 9277, 103, 85],
            [2001, 9278, 92, 93],
            [2001, 9279, 92, 89],
            [2001, 9280, 78, 77],
            [2001, 9281, 93, 88],
            [2001, 9282, 110, 100],
            [2001, 9283, 106, 122],
            [2001, 9284, 115, 144],
            [2001, 9285, 92, 119],
            [2001, 9286, 112, 142],
            [2001, 9287, 113, 141],
            [2001, 9288, 63, 48],
            [2001, 9289, 117, 140],
            [2001, 9290, 99, 119],
            [2001, 9291, 110, 135],
            [2001, 9292, 109, 135],
            [2001, 9293, 72, 52],
            [2001, 9294, 78, 78],
            [2001, 9295, 91, 89],
            [2001, 9296, 70, 51],
            [2001, 9297, 82, 58],
            [2001, 9298, 91, 120],
            [2001, 9299, 102, 134],
            [2001, 9300, 111, 138],
            [2001, 9301, 97, 124],
            [2001, 9302, 114, 141],
            [2001, 9303, 113, 145],
            [2001, 9304, 60, 86],
            [2001, 9305, 99, 127],
            [2001, 9306, 114, 146],
            [2001, 9307, 52, 76],
            [2001, 9308, 59, 86],
            [2001, 9309, 63, 80],
            [2001, 9310, 72, 88],
            [2001, 9311, 66, 82],
            [2001, 9312, 72, 88],
            [2001, 9313, 66, 81],
            [2001, 9314, 76, 94],
            [2001, 9315, 47, 47],
            [2001, 9316, 30, 30],
            [2001, 9317, 13, 15],
            [2001, 9318, 15, 19],
            [2001, 9319, 45, 52],
            [2001, 9320, 70, 70],
            [2001, 9327, 14, 19],
            [2001, 9328, 29, 35],
            [2001, 9329, 40, 50],
            [2001, 9330, 54, 62],
            [2001, 9331, 38, 38],
            [2001, 9332, 34, 40],
            [2001, 9333, 14, 17],
            [2001, 9334, 12, 15],
            [2001, 9335, 39, 39],
            [2001, 9336, 32, 39],
            [2001, 9337, 22, 27],
            [2001, 9338, 14, 16],
            [2001, 9339, 19, 24],
            [2001, 9340, 55, 64],
            [2001, 9341, 29, 34],
            [2001, 9342, 38, 38],
            [2001, 9343, 9, 11],
            [2001, 9344, 22, 26],
            [2001, 9345, 22, 27],
            [2001, 9346, 16, 19],
            [2001, 9347, 12, 16],
            [2001, 9348, 23, 26],
            [2001, 9349, 19, 23],
            [2001, 9350, 56, 66],
            [2001, 9351, 40, 39],
            [2001, 9352, 44, 44],
            [2001, 9353, 22, 26],
            [2001, 9354, 31, 31],
            [2001, 9355, 20, 20],
            [2001, 9356, 38, 45],
            [2001, 9357, 22, 25],
            [2001, 9358, 29, 28],
            [2001, 9359, 23, 23],
            [2001, 9360, 34, 41],
            [2001, 9361, 31, 37],
            [2001, 9362, 40, 39],
            [2001, 9363, 35, 41],
            [2001, 9364, 46, 35],
            [2001, 9365, 21, 26],
            [2001, 9366, 36, 42],
            [2001, 9367, 23, 22],
            [2001, 9368, 35, 35],
            [2001, 9369, 37, 37],
            [2001, 9370, 19, 22],
            [2001, 9371, 35, 35],
            [2001, 9372, 30, 29],
            [2001, 9373, 25, 25],
            [2001, 9374, 45, 45],
            [2001, 9375, 26, 31],
            [2001, 9376, 50, 50],
            [2001, 9377, 15, 21],
            [2001, 9378, 21, 25],
            [2001, 9379, 38, 47],
            [2001, 9380, 35, 42],
            [2001, 9381, 70, 84],
            [2001, 9382, 41, 48],
            [2001, 9383, 44, 44],
            [2001, 9384, 22, 26],
            [2001, 9385, 27, 32],
            [2001, 9386, 25, 29],
            [2001, 9387, 20, 23],
            [2001, 9388, 20, 27],
            [2001, 9389, 22, 26],
            [2001, 9390, 23, 28],
            [2001, 9391, 26, 31],
            [2001, 9392, 25, 29],
            [2001, 9393, 27, 27],
            [2001, 9394, 20, 24],
            [2001, 9395, 28, 33],
            [2001, 9396, 29, 36],
            [2001, 9397, 56, 66],
            [2001, 9398, 51, 61],
            [2001, 9399, 75, 87],
            [2001, 9400, 32, 39],
            [2001, 9401, 48, 47],
            [2001, 9402, 49, 38],
            [2001, 9403, 116, 87],
            [2001, 9404, 116, 86],
            [2001, 9405, 117, 87],
            [2001, 9406, 111, 87],
            [2001, 9407, 70, 68],
            [2001, 9408, 117, 87],
            [2001, 9409, 115, 86],
            [2001, 9410, 117, 87],
            [2001, 9411, 115, 85],
            [2001, 9412, 115, 86],
            [2001, 9413, 117, 87],
            [2001, 9414, 116, 86],
            [2001, 9415, 117, 87],
            [2001, 9416, 111, 84],
            [2001, 9417, 117, 87],
            [2001, 9418, 114, 83],
            [2001, 9419, 115, 87],
            [2001, 9420, 116, 86],
            [2001, 9421, 114, 83],
            [2001, 9422, 115, 87],
            [2001, 9423, 111, 83],
            [2001, 9424, 116, 86],
            [2001, 9425, 117, 87],
            [2001, 9426, 115, 87],
            [2001, 9427, 117, 87],
            [2001, 9428, 115, 85],
            [2001, 9429, 115, 86],
            [2001, 9430, 117, 87],
            [2001, 9431, 115, 86],
            [2001, 9432, 67, 65],
            [2001, 9433, 111, 83],
            [2001, 9434, 115, 86],
            [2001, 9435, 117, 87],
            [2001, 9436, 115, 86],
            [2001, 9437, 116, 86],
            [2001, 9438, 117, 87],
            [2001, 9439, 115, 85],
            [2001, 9440, 117, 87],
            [2001, 9441, 115, 87],
            [2001, 9442, 117, 87],
            [2001, 9443, 116, 86],
            [2001, 9444, 115, 85],
            [2001, 9445, 115, 86],
            [2001, 9446, 117, 87],
            [2001, 9447, 115, 86],
            [2001, 9448, 117, 87],
            [2001, 9449, 93, 72],
            [2001, 9450, 111, 83],
            [2001, 9451, 111, 87],
            [2001, 9452, 115, 86],
            [2001, 9453, 115, 86],
            [2001, 9454, 115, 86],
            [2001, 9455, 117, 87],
            [2001, 9456, 116, 86],
            [2001, 9457, 111, 87],
            [2001, 9458, 116, 86],
            [2001, 9459, 115, 86],
            [2001, 9460, 117, 87],
            [2001, 9461, 115, 86],
            [2001, 9462, 117, 87],
            [2001, 9463, 85, 83],
            [2001, 9464, 85, 83],
            [2001, 9465, 67, 65],
            [2001, 9466, 115, 86],
            [2001, 9467, 116, 86],
            [2001, 9468, 116, 68],
            [2001, 9469, 117, 87],
            [2001, 9470, 115, 85],
            [2001, 9471, 159, 95],
            [2001, 9472, 190, 180],
            [2001, 9473, 52, 91],
            [2001, 9474, 85, 139],
            [2001, 9475, 120, 106],
            [2001, 9476, 120, 200],
            [2001, 9477, 38, 54],
            [2001, 9478, 60, 83],
            [2001, 9479, 84, 93],
            [2001, 9480, 125, 139],
            [2001, 9481, 27, 79],
            [2001, 9482, 42, 123],
            [2001, 9483, 120, 90],
            [2001, 9484, 168, 83],
            [2001, 9485, 76, 50],
            [2001, 9486, 100, 80],
            [2001, 9487, 27, 55],
            [2001, 9488, 47, 82],
            [2001, 9489, 111, 83],
            [2001, 9490, 110, 107],
            [2001, 9491, 47, 80],
            [2001, 9492, 77, 91],
            [2001, 9493, 120, 100],
            [2001, 9494, 127, 138],
            [2001, 9495, 47, 46],
            [2001, 9496, 85, 57],
            [2001, 9497, 44, 31],
            [2001, 9498, 74, 50],
            [2001, 9499, 67, 83],
            [2001, 9500, 111, 123],
            [2001, 9501, 70, 119],
            [2001, 9502, 120, 200],
            [2001, 9503, 67, 57],
            [2001, 9504, 84, 68],
            [2001, 9505, 67, 108],
            [2001, 9506, 111, 174],
            [2001, 9507, 78, 83],
            [2001, 9508, 110, 158],
            [2001, 9509, 111, 77],
            [2001, 9510, 111, 113],
            [2001, 9511, 67, 66],
            [2001, 9512, 67, 110],
            [2001, 9513, 80, 84],
            [2001, 9514, 111, 126],
            [2001, 9515, 70, 70],
            [2001, 9516, 120, 104],
            [2001, 9517, 111, 91],
            [2001, 9518, 145, 142],
            [2001, 9519, 34, 39],
            [2001, 9520, 56, 64],
            [2001, 9521, 67, 170],
            [2001, 9522, 104, 200],
            [2001, 9523, 111, 91],
            [2001, 9524, 138, 149],
            [2001, 9525, 32, 42],
            [2001, 9526, 49, 63],
            [2001, 9527, 85, 86],
            [2001, 9528, 110, 117],
            [2001, 9529, 46, 55],
            [2001, 9530, 73, 83],
            [2001, 9531, 46, 63],
            [2001, 9532, 55, 99],
            [2001, 9533, 111, 116],
            [2001, 9534, 161, 157],
            [2001, 9535, 38, 94],
            [2001, 9536, 65, 164],
            [2001, 9537, 130, 90],
            [2001, 9538, 180, 145],
            [2001, 9539, 64, 63],
            [2001, 9540, 85, 98],
            [2001, 9541, 46, 45],
            [2001, 9542, 71, 69],
            [2001, 9543, 38, 49],
            [2001, 9544, 60, 76],
            [2001, 9545, 67, 65],
            [2001, 9546, 76, 91],
            [2001, 9547, 41, 52],
            [2001, 9548, 68, 85],
            [2001, 9549, 35, 36],
            [2001, 9550, 54, 65],
            [2001, 9551, 38, 59],
            [2001, 9552, 58, 97],
            [2001, 9553, 47, 55],
            [2001, 9554, 67, 83],
            [2001, 9555, 64, 144],
            [2001, 9556, 101, 173],
            [2001, 9557, 38, 63],
            [2001, 9558, 67, 99],
            [2001, 9559, 44, 46],
            [2001, 9560, 59, 70],
            [2001, 9561, 46, 72],
            [2001, 9562, 72, 112],
            [2001, 9563, 63, 141],
            [2001, 9564, 103, 174],
            [2001, 9565, 67, 65],
            [2001, 9566, 74, 106],
            [2001, 9567, 61, 80],
            [2001, 9568, 79, 129],
            [2001, 9569, 111, 108],
            [2001, 9570, 143, 149],
            [2001, 9571, 95, 180],
            [2001, 9572, 145, 200],
            [2001, 9573, 85, 83],
            [2001, 9574, 111, 135],
            [2001, 9575, 74, 82],
            [2001, 9576, 124, 137],
            [2001, 9577, 120, 81],
            [2001, 9578, 155, 140],
            [2001, 9579, 45, 108],
            [2001, 9580, 66, 141],
            [2001, 9581, 49, 65],
            [2001, 9582, 59, 86],
            [2001, 9583, 111, 146],
            [2001, 9584, 170, 174],
            [2001, 9585, 111, 74],
            [2001, 9586, 119, 87],
            [2001, 9587, 64, 63],
            [2001, 9588, 66, 84],
            [2001, 9589, 35, 80],
            [2001, 9590, 54, 123],
            [2001, 9591, 67, 57],
            [2001, 9592, 73, 65],
            [2001, 9593, 38, 58],
            [2001, 9594, 60, 103],
            [2001, 9595, 43, 59],
            [2001, 9596, 72, 90],
            [2001, 9597, 29, 29],
            [2001, 9598, 39, 56],
            [2001, 9599, 111, 74],
            [2001, 9600, 111, 83],
            [2001, 9601, 49, 83],
            [2001, 9602, 99, 155],
            [2001, 9603, 64, 83],
            [2001, 9604, 97, 108],
            [2001, 9605, 64, 46],
            [2001, 9606, 67, 55],
            [2001, 9607, 57, 71],
            [2001, 9608, 90, 83],
            [2001, 9609, 42, 47],
            [2001, 9610, 54, 65],
            [2001, 9611, 47, 55],
            [2001, 9612, 67, 74],
            [2001, 9613, 70, 142],
            [2001, 9614, 107, 174],
            [2001, 9615, 55, 48],
            [2001, 9616, 89, 78],
            [2001, 9617, 23, 31],
            [2001, 9618, 67, 65],
            [2001, 9619, 36, 48],
            [2001, 9620, 36, 48],
            [2001, 9621, 40, 74],
            [2001, 9622, 54, 82],
            [2001, 9623, 67, 57],
            [2001, 9624, 67, 65],
            [2001, 9625, 111, 83],
            [2001, 9626, 110, 114],
            [2001, 9627, 67, 48],
            [2001, 9628, 85, 65],
            [2001, 9629, 47, 57],
            [2001, 9630, 85, 78],
            [2001, 9631, 47, 48],
            [2001, 9632, 60, 77],
            [2001, 9633, 63, 79],
            [2001, 9634, 107, 150],
            [2001, 9635, 152, 141],
            [2001, 9636, 178, 174],
            [2001, 9637, 79, 85],
            [2001, 9638, 118, 127],
            [2001, 9639, 23, 32],
            [2001, 9640, 38, 65],
            [2001, 9641, 64, 50],
            [2001, 9642, 76, 82],
            [2001, 9643, 29, 54],
            [2001, 9644, 46, 86],
            [2001, 9645, 67, 130],
            [2001, 9646, 77, 174],
            [2001, 9647, 111, 83],
            [2001, 9648, 127, 157],
            [2001, 9651, 71, 70],
            [2001, 9652, 93, 92],
            [2001, 9653, 60, 55],
            [2001, 9654, 99, 76],
            [2001, 9655, 49, 49],
            [2001, 9656, 82, 81],
            [2001, 9657, 62, 61],
            [2001, 9658, 76, 67],
            [2001, 9659, 53, 45],
            [2001, 9660, 78, 77],
            [2001, 9661, 43, 43],
            [2001, 9662, 76, 74],
            [2001, 9663, 47, 43],
            [2001, 9664, 78, 72],
            [2001, 9665, 67, 66],
            [2001, 9666, 82, 81],
            [2001, 9667, 56, 50],
            [2001, 9668, 82, 71],
            [2001, 9669, 50, 50],
            [2001, 9670, 70, 70],
            [2001, 9671, 49, 50],
            [2001, 9672, 93, 81],
            [2001, 9673, 53, 53],
            [2001, 9674, 70, 70],
            [2001, 9675, 60, 61],
            [2001, 9676, 110, 83],
            [2001, 9677, 52, 50],
            [2001, 9678, 77, 73],
            [2001, 9679, 50, 52],
            [2001, 9680, 77, 76],
            [2001, 9681, 67, 55],
            [2001, 9682, 88, 81],
            [2001, 9683, 64, 59],
            [2001, 9684, 84, 81],
            [2001, 9685, 61, 60],
            [2001, 9686, 85, 82],
            [2001, 9687, 57, 50],
            [2001, 9688, 85, 82],
            [2001, 9689, 88, 89],
            [2001, 9690, 86, 83],
            [2001, 9691, 55, 49],
            [2001, 9692, 82, 73],
            [2001, 9693, 70, 54],
            [2001, 9694, 110, 73],
            [2001, 9695, 43, 43],
            [2001, 9696, 77, 73],
            [2001, 9697, 48, 44],
            [2001, 9698, 100, 67],
            [2001, 9699, 43, 49],
            [2001, 9700, 80, 81],
            [2001, 9701, 46, 46],
            [2001, 9702, 61, 59],
            [2001, 9703, 40, 41],
            [2001, 9704, 82, 79],
            [2001, 9705, 41, 41],
            [2001, 9706, 89, 85],
            [2001, 9707, 60, 49],
            [2001, 9708, 76, 59],
            [2001, 9709, 50, 50],
            [2001, 9710, 60, 58],
            [2001, 9711, 108, 81],
            [2001, 9712, 107, 84],
            [2001, 9713, 108, 81],
            [2001, 9714, 105, 79],
            [2001, 9715, 103, 78],
            [2001, 9716, 55, 45],
            [2001, 9717, 70, 60],
            [2001, 9718, 49, 46],
            [2001, 9719, 76, 73],
            [2001, 9720, 101, 75],
            [2001, 9721, 94, 83],
            [2001, 9722, 43, 43],
            [2001, 9723, 90, 87],
            [2001, 9724, 75, 72],
            [2001, 9725, 95, 87],
            [2001, 9726, 29, 37],
            [2001, 9727, 69, 67],
            [2001, 9728, 60, 58],
            [2001, 9729, 69, 66],
            [2001, 9730, 35, 35],
            [2001, 9731, 100, 75],
            [2001, 9735, 71, 61],
            [2001, 9736, 58, 58],
            [2001, 9737, 58, 52],
            [2001, 9738, 121, 84],
            [2001, 9739, 74, 72],
            [2001, 9740, 80, 78],
            [2001, 9741, 81, 73],
            [2001, 9742, 78, 70],
            [2001, 9743, 59, 50],
            [2001, 9744, 110, 80],
            [2001, 9745, 68, 67],
            [2001, 9746, 71, 71],
            [2001, 9747, 68, 66],
            [2001, 9748, 56, 59],
            [2001, 9751, 49, 43],
            [2001, 9752, 60, 55],
            [2001, 9753, 46, 46],
            [2001, 9754, 78, 78],
            [2001, 9755, 49, 49],
            [2001, 9756, 87, 84],
            [2001, 9757, 48, 48],
            [2001, 9758, 70, 68],
            [2001, 9759, 25, 15],
            [2001, 9760, 55, 33],
            [2001, 9761, 57, 35],
            [2001, 9762, 51, 22],
            [2001, 9763, 27, 18],
            [2001, 9764, 34, 15],
            [2001, 9765, 59, 35],
            [2001, 9766, 52, 26],
            [2001, 9767, 51, 60],
            [2001, 9768, 46, 30],
            [2001, 9769, 29, 21],
            [2001, 9770, 58, 51],
            [2001, 9771, 69, 27],
            [2001, 9772, 38, 17],
            [2001, 9773, 55, 41],
            [2001, 9774, 29, 23],
            [2001, 9775, 29, 21],
            [2001, 9776, 38, 16],
            [2001, 9777, 59, 35],
            [2001, 9778, 57, 38],
            [2001, 9779, 51, 36],
            [2001, 9780, 54, 42],
            [2001, 9781, 38, 19],
            [2001, 9782, 57, 39],
            [2001, 9783, 46, 26],
            [2001, 9784, 46, 38],
            [2001, 9785, 35, 29],
            [2001, 9786, 28, 20],
            [2001, 9787, 54, 35],
            [2001, 9788, 27, 21],
            [2001, 9789, 59, 26],
            [2001, 9790, 54, 32],
            [2001, 9791, 69, 41],
            [2001, 9792, 57, 50],
            [2001, 9793, 21, 15],
            [2001, 9794, 17, 16],
            [2001, 9795, 17, 15],
            [2001, 9796, 26, 20],
            [2001, 9797, 21, 15],
            [2001, 9798, 17, 16],
            [2001, 9799, 66, 54],
            [2001, 9800, 32, 27],
            [2001, 9801, 26, 20],
            [2001, 9802, 26, 20],
            [2001, 9803, 12, 10],
            [2001, 9804, 24, 18],
            [2001, 9805, 50, 35],
            [2001, 9806, 32, 23],
            [2001, 9807, 41, 24],
            [2001, 9808, 120, 70],
            [2001, 9809, 60, 20],
            [2001, 9811, 64, 33],
            [2001, 9812, 120, 65],
            [2001, 9813, 90, 35],
            [2001, 9814, 32, 17],
            [2001, 9815, 65, 33],
            [2001, 9816, 47, 18],
            [2001, 9817, 40, 16],
            [2001, 9818, 90, 24],
            [2001, 9819, 81, 54],
            [2001, 9820, 99, 57],
            [2001, 9821, 70, 37],
            [2001, 9822, 29, 24],
            [2001, 9823, 40, 25],
            [2001, 9824, 42, 33],
            [2001, 9825, 29, 22],
            [2001, 9826, 81, 53],
            [2001, 9827, 73, 38],
            [2001, 9828, 81, 52],
            [2001, 9829, 63, 37],
            [2001, 9830, 48, 35],
            [2001, 9831, 61, 34],
            [2001, 9832, 47, 29],
            [2001, 9833, 50, 33],
            [2001, 9834, 88, 54],
            [2001, 9835, 48, 42],
            [2001, 9836, 73, 50],
            [2001, 9837, 44, 27],
            [2001, 9838, 81, 59],
            [2001, 9839, 22, 19],
            [2001, 9840, 66, 47],
            [2001, 9841, 130, 71],
            [2001, 9842, 45, 25],
            [2001, 9843, 40, 28],
            [2001, 9844, 53, 32],
            [2001, 9845, 43, 36],
            [2001, 9846, 40, 23],
            [2001, 9847, 19, 16],
            [2001, 9848, 35, 22],
            [2001, 9849, 35, 20],
            [2001, 9850, 35, 15],
            [2001, 9851, 31, 15],
            [2001, 9852, 29, 15],
            [2001, 9853, 32, 21],
            [2001, 9854, 18, 15],
            [2001, 9855, 43, 35],
            [2001, 9856, 21, 22],
            [2001, 9857, 21, 16],
            [2001, 9858, 65, 39],
            [2001, 9859, 82, 48],
            [2001, 9860, 69, 50],
            [2001, 9861, 81, 70],
            [2001, 9862, 41, 45],
            [2001, 9863, 66, 45],
            [2001, 9864, 81, 30],
            [2001, 9865, 52, 30],
            [2001, 9866, 81, 30],
            [2001, 9867, 31, 21],
            [2001, 9868, 69, 42],
            [2001, 9869, 63, 35],
            [2001, 9870, 53, 65],
            [2001, 9871, 69, 39],
            [2001, 9872, 35, 30],
            [2001, 9873, 50, 47],
            [2001, 9874, 64, 28],
            [2001, 9875, 49, 32],
            [2001, 9876, 35, 30],
            [2001, 9877, 51, 39],
            [2001, 9878, 62, 35],
            [2001, 9879, 54, 30],
            [2001, 9880, 59, 45],
            [2001, 9881, 80, 41],
            [2001, 9882, 59, 45],
            [2001, 9883, 52, 28],
            [2001, 9884, 50, 25],
            [2001, 9885, 65, 30],
            [2001, 9886, 62, 29],
            [2001, 9887, 53, 35],
            [2001, 9888, 69, 50],
            [2001, 9889, 69, 40],
            [2001, 9890, 61, 40],
            [2001, 9891, 51, 31],
            [2001, 9892, 42, 31],
            [2001, 9893, 32, 23],
            [2001, 9894, 68, 44],
            [2001, 9895, 30, 18],
            [2001, 9896, 13, 16],
            [2001, 9897, 51, 31],
            [2001, 9898, 53, 40],
            [2001, 9899, 36, 27],
            [2001, 9900, 90, 79],
            [2001, 9901, 82, 50],
            [2001, 9902, 131, 95],
            [2001, 9903, 110, 65],
            [2001, 9904, 96, 67],
            [2001, 9905, 61, 45],
            [2001, 9906, 62, 34],
            [2001, 9907, 43, 39],
            [2001, 9908, 95, 60],
            [2001, 9909, 21, 18],
            [2001, 9910, 88, 72],
            [2001, 9911, 129, 67],
            [2001, 9912, 79, 45],
            [2001, 9913, 32, 26],
            [2001, 9914, 45, 33],
            [2001, 9915, 45, 37],
            [2001, 9916, 45, 40],
            [2001, 9917, 42, 37],
            [2001, 9918, 124, 40],
            [2001, 9919, 111, 91],
            [2001, 9920, 133, 92],
            [2001, 9921, 35, 27],
            [2001, 9922, 40, 21],
            [2001, 9923, 44, 27],
            [2001, 9924, 70, 34],
            [2001, 9925, 80, 76],
            [2001, 9926, 60, 76],
            [2001, 9927, 45, 29],
            [2001, 9928, 86, 42],
            [2001, 9929, 70, 60],
            [2001, 9930, 60, 37],
            [2001, 9931, 81, 46],
            [2001, 9932, 80, 37],
            [2001, 9933, 75, 57],
            [2001, 9934, 76, 40],
            [2001, 9935, 59, 30],
            [2001, 9936, 64, 40],
            [2001, 9937, 40, 37],
            [2001, 9938, 23, 20],
            [2001, 9939, 66, 30],
            [2001, 9940, 52, 45],
            [2001, 9941, 55, 28],
            [2001, 9942, 29, 22],
            [2001, 9943, 173, 93],
            [2001, 9944, 76, 36],
            [2001, 9945, 108, 43],
            [2001, 9946, 51, 24],
            [2001, 9947, 76, 36],
            [2001, 9948, 142, 65],
            [2001, 9949, 128, 73],
            [2001, 9950, 101, 70],
            [2001, 9951, 47, 29],
            [2001, 9952, 76, 35],
            [2001, 9953, 39, 29],
            [2001, 9954, 100, 65],
            [2001, 9955, 37, 30],
            [2001, 9956, 87, 35],
            [2001, 9957, 137, 62],
            [2001, 9958, 41, 31],
            [2001, 9959, 119, 57],
            [2001, 9960, 82, 36],
            [2001, 9961, 38, 37],
            [2001, 9962, 49, 31],
            [2001, 9963, 90, 54],
            [2001, 9964, 46, 43],
            [2001, 9965, 43, 20],
            [2001, 9966, 88, 42],
            [2001, 9967, 105, 47],
            [2001, 9968, 59, 52],
            [2001, 9969, 57, 31],
            [2001, 9970, 76, 35],
            [2001, 9971, 51, 36],
            [2001, 9972, 155, 61],
            [2001, 9973, 65, 50],
            [2001, 9974, 42, 18],
            [2001, 9975, 121, 48],
            [2001, 9976, 155, 61],
            [2001, 9977, 55, 25],
            [2001, 9978, 60, 26],
            [2001, 9979, 137, 57],
            [2001, 9980, 69, 29],
            [2001, 9981, 41, 23],
            [2001, 9982, 23, 16],
            [2001, 9983, 120, 45],
            [2001, 9984, 62, 34],
            [2001, 9985, 62, 33],
            [2001, 9986, 67, 36],
            [2001, 9987, 69, 57],
            [2001, 9988, 63, 37],
            [2001, 9989, 51, 39],
            [2001, 9990, 38, 22],
            [2001, 9991, 64, 44],
            [2001, 9992, 63, 47],
            [2001, 9993, 45, 51],
            [2001, 9994, 42, 36],
            [2001, 9995, 59, 47],
            [2001, 9996, 50, 42],
            [2001, 9997, 22, 30],
            [2001, 9998, 25, 20],
            [2001, 9999, 40, 45],
            [2001, 10000, 32, 20],
            [2001, 10001, 26, 19],
            [2001, 10002, 23, 18],
            [2001, 10003, 68, 36],
            [2001, 10004, 25, 21],
            [2001, 10005, 25, 20],
            [2001, 10006, 19, 15],
            [2001, 10007, 47, 54],
            [2001, 10008, 63, 63],
            [2001, 10009, 65, 46],
            [2001, 10010, 77, 42],
            [2001, 10011, 58, 40],
            [2001, 10012, 84, 36],
            [2001, 10013, 41, 39],
            [2001, 10014, 53, 61],
            [2001, 10015, 41, 39],
            [2001, 10016, 45, 52],
            [2001, 10017, 53, 46],
            [2001, 10018, 57, 52],
            [2001, 10019, 56, 49],
            [2001, 10020, 71, 60],
            [2001, 10021, 92, 60],
            [2001, 10022, 73, 60],
            [2001, 10023, 84, 61],
            [2001, 10024, 106, 74],
            [2001, 10025, 89, 74],
            [2001, 10026, 87, 63],
            [2001, 10027, 84, 67],
            [2001, 10030, 77, 63],
            [2001, 10031, 92, 82],
            [2001, 10032, 102, 77],
            [2001, 10033, 58, 44],
            [2001, 10034, 64, 43],
            [2001, 10035, 116, 60],
            [2001, 10036, 106, 48],
            [2001, 10037, 126, 63],
            [2001, 10038, 37, 24],
            [2001, 10039, 21, 25],
            [2001, 10040, 37, 25],
            [2001, 10041, 34, 21],
            [2001, 10042, 58, 39],
            [2001, 10043, 62, 30],
            [2001, 10044, 71, 30],
            [2001, 10045, 46, 26],
            [2001, 10046, 70, 45],
            [2001, 10047, 66, 36],
            [2001, 10048, 62, 36],
            [2001, 10049, 42, 33],
            [2001, 10050, 58, 40],
            [2001, 10051, 65, 44],
            [2001, 10052, 84, 74],
            [2001, 10053, 95, 79],
            [2001, 10054, 82, 79],
            [2001, 10055, 91, 81],
            [2001, 10056, 76, 77],
            [2001, 10057, 86, 81],
            [2001, 10058, 46, 52],
            [2001, 10059, 99, 57],
            [2001, 10060, 70, 51],
            [2001, 10061, 85, 82],
            [2001, 10063, 24, 28],
            [2001, 10064, 46, 38],
            [2001, 10065, 41, 53],
            [2001, 10066, 56, 51],
            [2001, 10067, 83, 66],
            [2001, 10068, 88, 68],
            [2001, 10069, 84, 67],
            [2001, 10070, 51, 29],
            [2001, 10071, 83, 60],
            [2001, 10072, 80, 29],
            [2001, 10073, 84, 35],
            [2001, 10074, 83, 36],
            [2001, 10075, 98, 51],
            [2001, 10076, 83, 51],
            [2001, 10077, 84, 51],
            [2001, 10078, 102, 63],
            [2001, 10079, 64, 47],
            [2001, 10080, 53, 47],
            [2001, 10081, 100, 63],
            [2001, 10082, 68, 74],
            [2001, 10083, 52, 51],
            [2001, 10084, 58, 40],
            [2001, 10085, 55, 26],
            [2001, 10086, 61, 36],
            [2001, 10087, 55, 25],
            [2001, 10088, 85, 54],
            [2001, 10089, 85, 56],
            [2001, 10090, 67, 54],
            [2001, 10091, 81, 39],
            [2001, 10092, 95, 40],
            [2001, 10093, 63, 54],
            [2001, 10094, 106, 65],
            [2001, 10095, 97, 64],
            [2001, 10096, 83, 50],
            [2001, 10097, 65, 50],
            [2001, 10098, 75, 56],
            [2001, 10099, 88, 62],
            [2001, 10101, 97, 79],
            [2001, 10102, 84, 72],
            [2001, 10103, 85, 82],
            [2001, 10104, 20, 21],
            [2001, 10105, 37, 25],
            [2001, 10106, 37, 36],
            [2001, 10107, 78, 75],
            [2001, 10108, 96, 89],
            [2001, 10109, 143, 90],
            [2001, 10110, 76, 68],
            [2001, 10111, 109, 83],
            [2001, 10112, 115, 93],
            [2001, 10113, 123, 103],
            [2001, 10114, 98, 60],
            [2001, 10115, 56, 41],
            [2001, 10116, 65, 55],
            [2001, 10117, 61, 67],
            [2001, 10118, 66, 75],
            [2001, 10119, 28, 19],
            [2001, 10120, 37, 24],
            [2001, 10121, 93, 83],
            [2001, 10122, 93, 82],
            [2001, 10123, 103, 88],
            [2001, 10124, 89, 87],
            [2001, 10125, 100, 62],
            [2001, 10126, 85, 50],
            [2001, 10127, 84, 54],
            [2001, 10128, 85, 60],
            [2001, 10129, 101, 65],
            [2001, 10130, 93, 63],
            [2001, 10131, 63, 51],
            [2001, 10132, 63, 51],
            [2001, 10133, 85, 50],
            [2001, 10134, 105, 73],
            [2001, 10135, 101, 82],
            [2001, 10136, 69, 34],
            [2001, 10137, 80, 54],
            [2001, 10138, 76, 40],
            [2001, 10139, 73, 47],
            [2001, 10141, 66, 40],
            [2001, 10142, 72, 43],
            [2001, 10144, 94, 47],
            [2001, 10145, 54, 57],
            [2001, 10146, 66, 64],
            [2001, 10148, 69, 36],
            [2001, 10149, 71, 78],
            [2001, 10150, 32, 44],
            [2001, 10151, 55, 53],
            [2001, 10152, 79, 62],
            [2001, 10153, 87, 69],
            [2001, 10154, 35, 35],
            [2001, 10155, 65, 67],
            [2001, 10156, 45, 47],
            [2001, 10157, 86, 64],
            [2001, 10158, 45, 49],
            [2001, 10159, 65, 52],
            [2001, 10160, 69, 44],
            [2001, 10161, 101, 57],
            [2001, 10162, 74, 38],
            [2001, 10163, 98, 46],
            [2001, 10164, 77, 39],
            [2001, 10165, 82, 41],
            [2001, 10166, 61, 36],
            [2001, 10167, 76, 59],
            [2001, 10168, 75, 59],
            [2001, 10169, 85, 61],
            [2001, 10170, 36, 47],
            [2001, 10171, 66, 56],
            [2001, 10172, 50, 45],
            [2001, 10173, 65, 56],
            [2001, 10174, 62, 43],
            [2001, 10175, 84, 57],
            [2001, 10176, 24, 26],
            [2001, 10177, 21, 24],
            [2001, 10178, 28, 27],
            [2001, 10179, 22, 24],
            [2001, 10180, 46, 37],
            [2001, 10181, 28, 20],
            [2001, 10182, 46, 52],
            [2001, 10183, 61, 34],
            [2001, 10184, 61, 21],
            [2001, 10185, 19, 15],
            [2001, 10186, 16, 14],
            [2001, 10187, 25, 19],
            [2001, 10188, 26, 18],
            [2001, 10189, 84, 43],
            [2001, 10190, 27, 17],
            [2001, 10191, 64, 33],
            [2001, 10192, 44, 26],
            [2001, 10193, 25, 23],
            [2001, 10194, 18, 13],
            [2001, 10195, 18, 15],
            [2001, 10196, 48, 34],
            [2001, 10197, 45, 32],
            [2001, 10198, 32, 36],
            [2001, 10199, 31, 36],
            [2001, 10200, 30, 36],
            [2001, 10201, 29, 33],
            [2001, 10202, 73, 64],
            [2001, 10203, 60, 42],
            [2001, 10204, 61, 42],
            [2001, 10205, 52, 38],
            [2001, 10206, 48, 33],
            [2001, 10207, 44, 31],
            [2001, 10208, 48, 35],
            [2001, 10209, 45, 32],
            [2001, 10210, 53, 43],
            [2001, 10211, 51, 40],
            [2001, 10212, 58, 36],
            [2001, 10213, 55, 34],
            [2001, 10214, 48, 43],
            [2001, 10215, 45, 40],
            [2001, 10216, 50, 35],
            [2001, 10217, 53, 38],
            [2001, 10218, 51, 42],
            [2001, 10219, 49, 42],
            [2001, 10220, 47, 39],
            [2001, 10221, 51, 35],
            [2001, 10222, 48, 37],
            [2001, 10223, 62, 51],
            [2001, 10224, 68, 57],
            [2001, 10225, 65, 62],
            [2001, 10226, 34, 34],
            [2001, 10227, 36, 34],
            [2001, 10228, 33, 31],
            [2001, 10234, 66, 52],
            [2001, 10235, 46, 41],
            [2001, 10236, 46, 44],
            [2001, 10237, 43, 42],
            [2001, 10238, 51, 51],
            [2001, 10239, 68, 54],
            [2001, 10240, 44, 46],
            [2001, 10241, 37, 50],
            [2001, 10242, 50, 39],
            [2001, 10243, 51, 43],
            [2001, 10244, 46, 52],
            [2001, 10245, 23, 35],
            [2001, 10246, 40, 37],
            [2001, 10247, 30, 35],
            [2001, 10248, 46, 39],
            [2001, 10249, 30, 39],
            [2001, 10250, 46, 44],
            [2001, 10251, 51, 43],
            [2001, 10252, 46, 44],
            [2001, 10253, 46, 48],
            [2001, 10255, 51, 47],
            [2001, 10256, 54, 52],
            [2001, 10257, 50, 43],
            [2001, 10258, 52, 51],
            [2001, 10259, 23, 38],
            [2001, 10260, 46, 44],
            [2001, 10261, 52, 43],
            [2001, 10263, 30, 38],
            [2001, 10264, 46, 44],
            [2001, 10267, 37, 35],
            [2001, 10268, 52, 39],
            [2001, 10269, 37, 38],
            [2001, 10270, 39, 44],
            [2001, 10271, 46, 36],
            [2001, 10272, 38, 39],
            [2001, 10276, 44, 43],
            [2001, 10277, 53, 48],
            [2001, 10278, 31, 39],
            [2001, 10279, 51, 50],
            [2001, 10280, 30, 46],
            [2001, 10281, 46, 52],
            [2001, 10283, 30, 35],
            [2001, 10284, 44, 43],
            [2001, 10285, 33, 34],
            [2001, 10286, 38, 36],
            [2001, 10287, 38, 35],
            [2001, 10288, 50, 35],
            [2001, 10289, 51, 40],
            [2001, 10290, 50, 39],
            [2001, 10291, 50, 43],
            [2001, 10292, 36, 42],
            [2001, 10293, 50, 50],
            [2001, 10294, 23, 35],
            [2001, 10295, 30, 39],
            [2001, 10296, 45, 44],
            [2001, 10297, 31, 35],
            [2001, 10298, 39, 40],
            [2001, 10299, 30, 35],
            [2001, 10300, 39, 40],
            [2001, 10301, 39, 44],
            [2001, 10302, 30, 39],
            [2001, 10303, 46, 45],
            [2001, 10304, 31, 39],
            [2001, 10305, 39, 44],
            [2001, 10306, 37, 47],
            [2001, 10307, 43, 49],
            [2001, 10309, 44, 39],
            [2001, 10310, 31, 39],
            [2001, 10311, 40, 44],
            [2001, 10312, 43, 42],
            [2001, 10313, 53, 46],
            [2001, 10314, 47, 40],
            [2001, 10315, 45, 35],
            [2001, 10317, 37, 38],
            [2001, 10318, 54, 44],
            [2001, 10319, 37, 46],
            [2001, 10320, 84, 51],
            [2001, 10321, 37, 35],
            [2001, 10322, 51, 52],
            [2001, 10323, 36, 49],
            [2001, 10326, 66, 52],
            [2001, 10327, 37, 42],
            [2001, 10329, 38, 35],
            [2001, 10330, 43, 50],
            [2001, 10332, 30, 35],
            [2001, 10333, 50, 50],
            [2001, 10334, 56, 50],
            [2001, 10335, 45, 51],
            [2001, 10337, 36, 38],
            [2001, 10338, 52, 44],
            [2001, 10339, 37, 39],
            [2001, 10340, 53, 44],
            [2001, 10341, 30, 34],
            [2001, 10342, 39, 36],
            [2001, 10343, 43, 39],
            [2001, 10344, 38, 43],
            [2001, 10347, 30, 46],
            [2001, 10354, 30, 38],
            [2001, 10355, 51, 44],
            [2001, 10356, 37, 42],
            [2001, 10357, 51, 51],
            [2001, 10358, 45, 43],
            [2001, 10360, 30, 35],
            [2001, 10361, 46, 40],
            [2001, 10362, 50, 50],
            [2001, 10363, 82, 51],
            [2001, 10364, 86, 48],
            [2001, 10366, 52, 51],
            [2001, 10367, 81, 50],
            [2001, 10368, 85, 52],
            [2001, 10369, 81, 50],
            [2001, 10370, 86, 53],
            [2001, 10371, 39, 52],
            [2001, 10372, 30, 38],
            [2001, 10374, 30, 39],
            [2001, 10376, 30, 34],
            [2001, 10377, 32, 36],
            [2001, 10378, 49, 49],
            [2001, 10380, 43, 45],
            [2001, 10381, 66, 52],
            [2001, 10382, 43, 46],
            [2001, 10383, 85, 51],
            [2001, 10384, 50, 50],
            [2001, 10385, 86, 52],
            [2001, 10388, 23, 39],
            [2001, 10390, 31, 36],
            [2001, 10391, 44, 35],
            [2001, 10392, 44, 43],
            [2001, 10394, 30, 34],
            [2001, 10395, 39, 40],
            [2001, 10396, 31, 35],
            [2001, 10398, 31, 39],
            [2001, 10399, 45, 44],
            [2001, 10400, 31, 36],
            [2001, 10402, 30, 46],
            [2001, 10403, 47, 52],
            [2001, 10404, 32, 40],
            [2001, 10408, 30, 46],
            [2001, 10409, 45, 52],
            [2001, 10410, 34, 46],
            [2001, 10411, 52, 51],
            [2001, 10412, 62, 34],
            [2001, 10413, 88, 50],
            [2001, 10417, 46, 52],
            [2001, 10418, 30, 35],
            [2001, 10419, 50, 50],
            [2001, 10420, 51, 52],
            [2001, 10422, 44, 50],
            [2001, 10424, 47, 47],
            [2001, 10425, 30, 42],
            [2001, 10426, 45, 51],
            [2001, 10427, 38, 35],
            [2001, 10428, 38, 44],
            [2001, 10431, 31, 39],
            [2001, 10432, 46, 44],
            [2001, 10433, 30, 38],
            [2001, 10434, 46, 44],
            [2001, 10435, 51, 40],
            [2001, 10436, 37, 35],
            [2001, 10437, 50, 35],
            [2001, 10438, 31, 35],
            [2001, 10439, 45, 51],
            [2001, 10440, 30, 42],
            [2001, 10441, 50, 43],
            [2001, 10442, 38, 39],
            [2001, 10443, 30, 34],
            [2001, 10444, 51, 36],
            [2001, 10445, 53, 44],
            [2001, 10447, 30, 34],
            [2001, 10448, 40, 37],
            [2001, 10450, 30, 38],
            [2001, 10453, 83, 43],
            [2001, 10454, 80, 42],
            [2001, 10455, 83, 50],
            [2001, 10456, 30, 38],
            [2001, 10458, 30, 35],
            [2001, 10459, 38, 35],
            [2001, 10461, 30, 39],
            [2001, 10463, 23, 31],
            [2001, 10464, 32, 36],
            [2001, 10467, 30, 43],
            [2001, 10469, 37, 38],
            [2001, 10471, 36, 34],
            [2001, 10474, 21, 21],
            [2001, 10475, 21, 21],
            [2001, 10476, 22, 23],
            [2001, 10477, 23, 23],
            [2001, 10478, 31, 50],
            [2001, 10479, 46, 35],
            [2001, 10480, 30, 34],
            [2001, 10482, 30, 39],
            [2001, 10483, 35, 44],
            [2001, 10484, 30, 38],
            [2001, 10485, 35, 44],
            [2001, 10486, 30, 38],
            [2001, 10487, 35, 44],
            [2001, 10490, 17, 30],
            [2001, 10491, 10, 23],
            [2001, 10492, 8, 14],
            [2001, 10493, 36, 41],
            [2001, 10494, 11, 40],
            [2001, 10495, 13, 33],
            [2001, 10496, 10, 22],
            [2001, 10497, 29, 61],
            [2001, 10498, 10, 29],
            [2001, 10499, 10, 57],
            [2001, 10500, 13, 59],
            [2001, 10501, 13, 59],
            [2001, 10502, 34, 89],
            [2001, 10503, 13, 60],
            [2001, 10504, 15, 81],
            [2001, 10505, 35, 70],
            [2001, 10506, 17, 47],
            [2001, 10507, 10, 26],
            [2001, 10508, 27, 68],
            [2001, 10509, 29, 46],
            [2001, 10510, 16, 42],
            [2001, 10511, 8, 22],
            [2001, 10512, 30, 34],
            [2001, 10513, 39, 40],
            [2001, 10514, 19, 29],
            [2001, 10515, 21, 37],
            [2001, 10516, 19, 31],
            [2001, 10517, 30, 42],
            [2001, 10518, 24, 29],
            [2001, 10519, 28, 33],
            [2001, 10520, 13, 18],
            [2001, 10521, 23, 30],
            [2001, 10522, 22, 29],
            [2001, 10523, 22, 29],
            [2001, 10524, 22, 29],
            [2001, 10525, 22, 29],
            [2001, 10526, 22, 29],
            [2001, 10527, 21, 27],
            [2001, 10528, 30, 30],
            [2001, 10529, 22, 29],
            [2001, 10530, 22, 29],
            [2001, 10531, 22, 29],
            [2001, 10532, 24, 24],
            [2001, 10533, 38, 32],
            [2001, 10534, 17, 15],
            [2001, 10535, 34, 29],
            [2001, 10536, 18, 24],
            [2001, 10537, 26, 23],
            [2001, 10538, 33, 28],
            [2001, 10539, 19, 20],
            [2001, 10540, 37, 30],
            [2001, 10541, 46, 40],
            [2001, 10542, 56, 36],
            [2001, 10543, 7, 7],
            [2001, 10544, 13, 11],
            [2001, 10545, 7, 7],
            [2001, 10546, 8, 8],
            [2001, 10547, 8, 9],
            [2001, 10548, 13, 13],
            [2001, 10549, 9, 9],
            [2001, 10550, 16, 11],
            [2001, 10551, 9, 10],
            [2001, 10552, 8, 8],
            [2001, 10553, 22, 16],
            [2001, 10554, 23, 15],
            [2001, 10555, 14, 10],
            [2001, 10556, 24, 16],
            [2001, 10557, 19, 12],
            [2001, 10558, 36, 20],
            [2001, 10559, 22, 14],
            [2001, 10560, 22, 15],
            [2001, 10561, 12, 11],
            [2001, 10562, 9, 8],
            [2001, 10563, 7, 8],
            [2001, 10564, 5, 5],
            [2001, 10565, 9, 10],
            [2001, 10566, 16, 13],
            [2001, 10567, 16, 13],
            [2001, 10568, 11, 11],
            [2001, 10569, 16, 14],
            [2001, 10570, 23, 17],
            [2001, 10571, 30, 19],
            [2001, 10572, 13, 11],
            [2001, 10573, 12, 8],
            [2001, 10574, 17, 13],
            [2001, 10575, 16, 15],
            [2001, 10576, 15, 12],
            [2001, 10577, 21, 13],
            [2001, 10578, 51, 61],
            [2001, 10579, 73, 62],
            [2001, 10580, 92, 75],
            [2001, 10581, 120, 102],
            [2001, 10582, 88, 75],
            [2001, 10583, 78, 72],
            [2001, 10584, 105, 85],
            [2001, 10585, 77, 81],
            [2001, 10586, 114, 99],
            [2001, 10587, 100, 80],
            [2001, 10588, 52, 52],
            [2001, 10589, 94, 85],
            [2001, 10590, 116, 90],
            [2001, 10591, 103, 98],
            [2001, 10592, 92, 51],
            [2001, 10593, 67, 57],
            [2001, 10594, 96, 94],
            [2001, 10595, 47, 55],
            [2001, 10596, 61, 60],
            [2001, 10597, 78, 64],
            [2001, 10598, 76, 61],
            [2001, 10600, 18, 22],
            [2001, 10601, 18, 18],
            [2001, 10602, 36, 44],
            [2001, 10603, 50, 51],
            [2001, 10604, 62, 39],
            [2001, 10605, 22, 11],
            [2001, 10606, 18, 11],
            [2001, 10607, 28, 15],
            [2001, 10608, 15, 11],
            [2001, 10609, 15, 11],
            [2001, 10610, 25, 11],
            [2001, 10611, 25, 16],
            [2001, 10612, 23, 17],
            [2001, 10613, 63, 18],
            [2001, 10614, 50, 32],
            [2001, 10615, 59, 32],
            [2001, 10616, 50, 43],
            [2001, 10617, 69, 38],
            [2001, 10618, 70, 38],
            [2001, 10619, 50, 29],
            [2001, 10620, 35, 24],
            [2001, 10621, 50, 20],
            [2001, 10622, 45, 23],
            [2001, 10623, 50, 23],
            [2001, 10624, 50, 23],
            [2001, 10625, 41, 28],
            [2001, 10626, 70, 38],
            [2001, 10627, 60, 28],
            [2001, 10628, 66, 45],
            [2001, 10629, 66, 45],
            [2001, 10630, 38, 23],
            [2001, 10631, 60, 23],
            [2001, 10632, 45, 23],
            [2001, 10633, 67, 33],
            [2001, 10634, 67, 23],
            [2001, 10635, 67, 23],
            [2001, 10636, 50, 33],
            [2001, 10637, 50, 29],
            [2001, 10638, 28, 20],
            [2001, 10639, 70, 39],
            [2001, 10640, 63, 39],
            [2001, 10641, 63, 39],
            [2001, 10642, 63, 39],
            [2001, 10643, 50, 35],
            [2001, 10644, 63, 39],
            [2001, 10645, 45, 37],
            [2001, 10646, 63, 37],
            [2001, 10647, 63, 37],
            [2001, 10648, 50, 46],
            [2001, 10649, 55, 33],
            [2001, 10650, 63, 30],
            [2001, 10651, 63, 32],
            [2001, 10652, 50, 31],
            [2001, 10653, 69, 31],
            [2001, 10654, 47, 37],
            [2001, 10655, 65, 37],
            [2001, 10656, 63, 37],
            [2001, 10657, 50, 28],
            [2001, 10658, 60, 26],
            [2001, 10659, 25, 20],
            [2001, 10660, 70, 32],
            [2001, 10661, 108, 39],
            [2001, 10662, 65, 42],
            [2001, 10663, 55, 22],
            [2001, 10664, 70, 32],
            [2001, 10665, 65, 32],
            [2001, 10666, 70, 28],
            [2001, 10667, 65, 28],
            [2001, 10668, 60, 29],
            [2001, 10669, 25, 20],
            [2001, 10670, 63, 28],
            [2001, 10671, 62, 40],
            [2001, 10672, 70, 39],
            [2001, 10673, 45, 19],
            [2001, 10674, 50, 25],
            [2001, 10675, 50, 48],
            [2001, 10676, 50, 48],
            [2001, 10677, 45, 24],
            [2001, 10678, 55, 37],
            [2001, 10679, 85, 37],
            [2001, 10680, 30, 26],
            [2001, 10681, 60, 32],
            [2001, 10682, 50, 32],
            [2001, 10683, 49, 32],
            [2001, 10684, 33, 35],
            [2001, 10685, 120, 50],
            [2001, 10686, 60, 50],
            [2001, 10687, 50, 53],
            [2001, 10688, 85, 53],
            [2001, 10689, 85, 53],
            [2001, 10690, 85, 53],
            [2001, 10691, 85, 53],
            [2001, 10692, 95, 36],
            [2001, 10693, 120, 36],
            [2001, 10694, 90, 36],
            [2001, 10695, 70, 36],
            [2001, 10696, 70, 35],
            [2001, 10697, 45, 35],
            [2001, 10698, 50, 45],
            [2001, 10699, 60, 45],
            [2001, 10700, 25, 27],
            [2001, 10701, 108, 34],
            [2001, 10702, 108, 34],
            [2001, 10703, 108, 34],
            [2001, 10704, 68, 34],
            [2001, 10705, 80, 32],
            [2001, 10706, 70, 32],
            [2001, 10707, 55, 59],
            [2001, 10708, 63, 59],
            [2001, 10709, 63, 59],
            [2001, 10710, 108, 26],
            [2001, 10711, 65, 26],
            [2001, 10712, 70, 49],
            [2001, 10713, 70, 49],
            [2001, 10714, 60, 41],
            [2001, 10715, 108, 31],
            [2001, 10716, 68, 59],
            [2001, 10717, 70, 59],
            [2001, 10718, 60, 59],
            [2001, 10719, 85, 54],
            [2001, 10720, 95, 54],
            [2001, 10721, 35, 30],
            [2001, 10722, 90, 52],
            [2001, 10723, 70, 52],
            [2001, 10724, 70, 52],
            [2001, 10725, 60, 52],
            [2001, 10726, 48, 38],
            [2001, 10727, 65, 38],
            [2001, 10728, 65, 39],
            [2001, 10729, 65, 39],
            [2001, 10730, 70, 39],
            [2001, 10731, 50, 32],
            [2001, 10732, 70, 32],
            [2001, 10733, 70, 32],
            [2001, 10734, 70, 32],
            [2001, 10735, 70, 25],
            [2001, 10736, 70, 25],
            [2001, 10737, 120, 25],
            [2001, 10738, 70, 40],
            [2001, 10739, 35, 20],
            [2001, 10740, 63, 28],
            [2001, 10741, 50, 28],
            [2001, 10742, 62, 47],
            [2001, 10743, 55, 44],
            [2001, 10744, 50, 33],
            [2001, 10745, 63, 36],
            [2001, 10746, 63, 34],
            [2001, 10747, 36, 26],
            [2001, 10748, 60, 23],
            [2001, 10749, 63, 33],
            [2001, 10750, 63, 12],
            [2001, 10751, 63, 29],
            [2001, 10752, 63, 29],
            [2001, 10753, 70, 38],
            [2001, 10754, 60, 28],
            [2001, 10755, 23, 16],
            [2001, 10756, 120, 90],
            [2001, 10757, 24, 15],
            [2001, 10758, 35, 13],
            [2001, 10759, 80, 34],
            [2001, 10760, 80, 44],
            [2001, 10761, 63, 45],
            [2001, 10762, 63, 34],
            [2001, 10763, 50, 34],
            [2001, 10764, 35, 34],
            [2001, 10765, 45, 33],
            [2001, 10766, 65, 33],
            [2001, 10767, 70, 24],
            [2001, 10768, 60, 24],
            [2001, 10769, 63, 24],
            [2001, 10770, 70, 50],
            [2001, 10771, 70, 50],
            [2001, 10772, 45, 60],
            [2001, 10773, 63, 70],
            [2001, 10774, 50, 33],
            [2001, 10775, 63, 33],
            [2001, 10776, 50, 23],
            [2001, 10777, 40, 26],
            [2001, 10778, 120, 26],
            [2001, 10779, 50, 39],
            [2001, 10780, 60, 26],
            [2001, 10781, 55, 26],
            [2001, 10782, 50, 23],
            [2001, 10783, 75, 45],
            [2001, 10784, 70, 33],
            [2001, 10785, 70, 33],
            [2001, 10786, 49, 26],
            [2001, 10787, 60, 26],
            [2001, 10788, 67, 59],
            [2001, 10789, 55, 34],
            [2001, 10790, 70, 34],
            [2001, 10791, 70, 34],
            [2001, 10792, 35, 23],
            [2001, 10793, 64, 23],
            [2001, 10794, 69, 24],
            [2001, 10795, 69, 24],
            [2001, 10796, 70, 24],
            [2001, 10797, 63, 24],
            [2001, 10798, 40, 24],
            [2001, 10799, 28, 21],
            [2001, 10800, 63, 46],
            [2001, 10801, 63, 33],
            [2001, 10802, 50, 33],
            [2001, 10803, 45, 26],
            [2001, 10804, 86, 28],
            [2001, 10805, 85, 30],
            [2001, 10806, 50, 29],
            [2001, 10807, 63, 29],
            [2001, 10808, 40, 20],
            [2001, 10809, 36, 25],
            [2001, 10810, 50, 25],
            [2001, 10811, 50, 22],
            [2001, 10812, 100, 74],
            [2001, 10813, 62, 59],
            [2001, 10814, 50, 29],
            [2001, 10815, 63, 29],
            [2001, 10816, 70, 28],
            [2001, 10817, 63, 28],
            [2001, 10818, 70, 46],
            [2001, 10819, 70, 46],
            [2001, 10820, 70, 36],
            [2001, 10821, 63, 23],
            [2001, 10822, 63, 23],
            [2001, 10823, 55, 23],
            [2001, 10824, 50, 33],
            [2001, 10825, 50, 33],
            [2001, 10826, 56, 34],
            [2001, 10827, 50, 34],
            [2001, 10828, 40, 25],
            [2001, 10829, 65, 39],
            [2001, 10830, 63, 39],
            [2001, 10831, 67, 38],
            [2001, 10832, 64, 38],
            [2001, 10833, 63, 38],
            [2001, 10834, 63, 38],
            [2001, 10835, 64, 38],
            [2001, 10836, 60, 38],
            [2001, 10837, 70, 38],
            [2001, 10838, 63, 38],
            [2001, 10839, 50, 38],
            [2001, 10840, 35, 30],
            [2001, 10841, 110, 24],
            [2001, 10842, 45, 23],
            [2001, 10843, 63, 33],
            [2001, 10844, 45, 40],
            [2001, 10845, 40, 36],
            [2001, 10846, 50, 36],
            [2001, 10847, 45, 24],
            [2001, 10848, 63, 24],
            [2001, 10849, 63, 24],
            [2001, 10850, 55, 38],
            [2001, 10851, 45, 33],
            [2001, 10852, 50, 33],
            [2001, 10853, 70, 47],
            [2001, 10854, 65, 34],
            [2001, 10855, 70, 34],
            [2001, 10856, 70, 41],
            [2001, 10857, 70, 41],
            [2001, 10858, 60, 39],
            [2001, 10859, 70, 39],
            [2001, 10860, 95, 40],
            [2001, 10861, 85, 40],
            [2001, 10862, 60, 40],
            [2001, 10863, 33, 30],
            [2001, 10864, 90, 40],
            [2001, 10865, 63, 25],
            [2001, 10866, 45, 29],
            [2001, 10867, 65, 39],
            [2001, 10868, 65, 39],
            [2001, 10869, 70, 24],
            [2001, 10870, 70, 33],
            [2001, 10871, 70, 34],
            [2001, 10872, 70, 24],
            [2001, 10873, 84, 24],
            [2001, 10874, 70, 24],
            [2001, 10875, 70, 32],
            [2001, 10876, 84, 32],
            [2001, 10877, 100, 42],
            [2001, 10878, 70, 32],
            [2001, 10879, 70, 32],
            [2001, 10880, 70, 32],
            [2001, 10881, 50, 22],
            [2001, 10882, 90, 33],
            [2001, 10883, 108, 33],
            [2001, 10884, 120, 33],
            [2001, 10885, 50, 46],
            [2001, 10886, 70, 34],
            [2001, 10887, 50, 33],
            [2001, 10888, 95, 43],
            [2001, 10889, 65, 36],
            [2001, 10890, 50, 26],
            [2001, 10891, 35, 26],
            [2001, 10892, 45, 32],
            [2001, 10893, 70, 56],
            [2001, 10894, 70, 56],
            [2001, 10895, 108, 48],
            [2001, 10896, 70, 48],
            [2001, 10897, 70, 48],
            [2001, 10898, 70, 48],
            [2001, 10899, 60, 31],
            [2001, 10900, 50, 25],
            [2001, 10901, 60, 22],
            [2001, 10902, 60, 23],
            [2001, 10903, 63, 31],
            [2001, 10904, 63, 31],
            [2001, 10905, 50, 31],
            [2001, 10906, 69, 45],
            [2001, 10907, 69, 45],
            [2001, 10908, 63, 27],
            [2001, 10909, 108, 27],
            [2001, 10910, 63, 27],
            [2001, 10911, 90, 70],
            [2001, 10912, 90, 70],
            [2001, 10913, 55, 49],
            [2001, 10914, 120, 49],
            [2001, 10915, 70, 54],
            [2001, 10916, 85, 54],
            [2001, 10917, 90, 54],
            [2001, 10918, 45, 45],
            [2001, 10978, 63, 23],
            [2001, 10979, 63, 43],
            [2001, 10980, 60, 33],
            [2001, 11091, 10, 6],
            [2001, 11092, 15, 11],
            [2001, 11093, 13, 8],
            [2001, 11094, 22, 11],
            [2001, 11095, 10, 7],
            [2001, 11096, 25, 19],
            [2001, 11097, 13, 8],
            [2001, 11098, 11, 7],
            [2001, 11099, 50, 40],
            [2001, 11100, 10, 7],
            [2001, 11101, 14, 9],
            [2001, 11102, 13, 8],
            [2001, 11103, 20, 11],
            [2001, 11104, 70, 40],
            [2001, 11105, 40, 39],
            [2001, 11106, 34, 20],
            [2001, 11107, 25, 14],
            [2001, 11108, 11, 6],
            [2001, 11109, 25, 20],
            [2001, 11110, 25, 12],
            [2001, 11111, 8, 8],
            [2001, 11112, 37, 21],
            [2001, 11113, 32, 18],
            [2001, 11114, 50, 33],
            [2001, 11115, 9, 6],
            [2001, 11116, 10, 5],
            [2001, 11117, 11, 8],
            [2001, 11118, 21, 14],
            [2001, 11119, 50, 27],
            [2001, 11120, 37, 25],
            [2001, 11121, 12, 10],
            [2001, 11122, 14, 8],
            [2001, 11123, 19, 10],
            [2001, 11124, 11, 9],
            [2001, 11125, 37, 17],
            [2001, 11126, 18, 11],
            [2001, 11127, 8, 8],
            [2001, 11128, 16, 8],
            [2001, 11129, 8, 6],
            [2001, 11130, 17, 10],
            [2001, 11131, 9, 6],
            [2001, 11132, 22, 13],
            [2001, 11133, 14, 9],
            [2001, 11134, 8, 4],
            [2001, 11135, 70, 34],
            [2001, 11136, 13, 9],
            [2001, 11137, 8, 6],
            [2001, 11138, 22, 15],
            [2001, 11139, 15, 10],
            [2001, 11140, 14, 12],
            [2001, 11141, 12, 8],
            [2001, 11142, 12, 8],
            [2001, 11143, 10, 6],
            [2001, 11144, 11, 9],
            [2001, 11145, 30, 24],
            [2001, 11146, 8, 7],
            [2001, 11147, 5, 3],
            [2001, 11148, 40, 35],
            [2001, 11149, 15, 11],
            [2001, 11150, 26, 18],
            [2001, 11151, 16, 13],
            [2001, 11152, 15, 12],
            [2001, 11153, 15, 10],
            [2001, 11154, 30, 18],
            [2001, 11155, 18, 10],
            [2001, 11156, 12, 11],
            [2001, 11157, 12, 10],
            [2001, 11158, 14, 11],
            [2001, 11159, 13, 12],
            [2001, 11160, 14, 10],
            [2001, 11161, 14, 11],
            [2001, 11162, 13, 12],
            [2001, 11163, 14, 14],
            [2001, 11164, 19, 18],
            [2001, 11165, 14, 10],
            [2001, 11166, 60, 39],
            [2001, 11167, 104, 55],
            [2001, 11168, 26, 19],
            [2001, 11169, 12, 11],
            [2001, 11170, 16, 13],
            [2001, 11171, 16, 13],
            [2001, 11172, 11, 11],
            [2001, 11173, 16, 14],
            [2001, 11174, 9, 8],
            [2001, 11175, 7, 8],
            [2001, 11176, 5, 5],
            [2001, 11177, 23, 17],
            [2001, 11178, 9, 10],
            [2001, 11179, 13, 11],
            [2001, 11180, 12, 8],
            [2001, 11181, 17, 13],
            [2001, 11182, 16, 15],
            [2001, 11183, 15, 12],
            [2002, 2, 46, 39],
            [2002, 7, 30, 30],
            [2002, 25, 13, 10],
            [2002, 42, 20, 21],
            [2002, 48, 79, 61],
            [2002, 49, 35, 24],
            [2002, 51, 30, 30],
            [2002, 62, 21, 30],
            [2002, 65, 24, 21],
            [2002, 78, 20, 20],
            [2002, 82, 12, 20],
            [2002, 83, 38, 43],
            [2002, 87, 35, 30],
            [2002, 99, 30, 29],
            [2002, 101, 61, 51],
            [2002, 119, 40, 29],
            [2002, 122, 32, 20],
            [2002, 125, 31, 32],
            [2002, 135, 20, 20],
            [2002, 138, 31, 30],
            [2002, 163, 27, 25],
            [2002, 166, 36, 35],
            [2002, 169, 25, 20],
            [2002, 186, 16, 20],
            [2002, 190, 30, 29],
            [2002, 194, 23, 24],
            [2002, 200, 40, 30],
            [2002, 204, 12, 21],
            [2002, 211, 21, 48],
            [2002, 215, 29, 30],
            [2002, 216, 23, 20],
            [2002, 218, 57, 25],
            [2002, 220, 18, 19],
            [2002, 226, 16, 17],
            [2002, 230, 45, 42],
            [2002, 231, 54, 48],
            [2002, 233, 18, 19],
            [2002, 234, 12, 16],
            [2002, 239, 20, 20],
            [2002, 240, 20, 18],
            [2002, 242, 32, 19],
            [2002, 243, 30, 30],
            [2002, 246, 51, 32],
            [2002, 248, 21, 20],
            [2002, 270, 30, 29],
            [2002, 272, 49, 17],
            [2002, 282, 43, 22],
            [2002, 285, 20, 20],
            [2002, 286, 20, 12],
            [2002, 299, 19, 20],
            [2002, 305, 20, 20],
            [2002, 306, 30, 30],
            [2002, 308, 12, 43],
            [2002, 310, 20, 20],
            [2002, 312, 20, 20],
            [2002, 314, 18, 27],
            [2002, 317, 30, 30],
            [2002, 320, 23, 27],
            [2002, 324, 46, 39],
            [2002, 327, 45, 40],
            [2002, 329, 39, 31],
            [2002, 330, 30, 30],
            [2002, 332, 30, 30],
            [2002, 334, 34, 30],
            [2002, 337, 25, 18],
            [2002, 339, 22, 20],
            [2002, 344, 30, 20],
            [2002, 346, 43, 36],
            [2002, 355, 49, 32],
            [2002, 361, 30, 30],
            [2002, 365, 44, 32],
            [2002, 378, 20, 24],
            [2002, 379, 15, 13],
            [2002, 389, 18, 24],
            [2002, 392, 19, 20],
            [2002, 399, 75, 38],
            [2002, 402, 34, 30],
            [2002, 403, 29, 30],
            [2002, 418, 22, 20],
            [2002, 424, 20, 20],
            [2002, 425, 16, 25],
            [2002, 428, 28, 20],
            [2002, 430, 21, 27],
            [2002, 432, 35, 30],
            [2002, 436, 27, 22],
            [2002, 455, 26, 24],
            [2002, 471, 19, 20],
            [2002, 479, 33, 33],
            [2002, 480, 61, 26],
            [2002, 487, 32, 29],
            [2002, 493, 30, 30],
            [2002, 494, 16, 18],
            [2002, 497, 10, 15],
            [2002, 503, 64, 23],
            [2002, 504, 14, 12],
            [2002, 505, 28, 30],
            [2002, 519, 18, 27],
            [2002, 525, 20, 31],
            [2002, 536, 20, 20],
            [2002, 541, 76, 41],
            [2002, 545, 21, 25],
            [2002, 568, 20, 20],
            [2002, 569, 52, 30],
            [2002, 570, 26, 21],
            [2002, 573, 30, 30],
            [2002, 577, 29, 24],
            [2002, 579, 47, 43],
            [2002, 585, 59, 55],
            [2002, 590, 35, 39],
            [2002, 593, 43, 39],
            [2002, 595, 31, 30],
            [2002, 597, 23, 10],
            [2002, 599, 16, 22],
            [2002, 604, 53, 32],
            [2002, 608, 28, 20],
            [2002, 612, 43, 42],
            [2002, 618, 26, 21],
            [2002, 625, 24, 18],
            [2002, 627, 33, 31],
            [2002, 628, 30, 30],
            [2002, 631, 20, 20],
            [2002, 654, 15, 12],
            [2002, 660, 32, 32],
            [2002, 662, 69, 47],
            [2002, 663, 51, 34],
            [2002, 669, 31, 23],
            [2002, 678, 20, 26],
            [2002, 686, 15, 23],
            [2002, 691, 23, 20],
            [2002, 694, 40, 33],
            [2002, 695, 72, 53],
            [2002, 700, 58, 43],
            [2002, 703, 12, 17],
            [2002, 704, 26, 30],
            [2002, 716, 61, 58],
            [2002, 717, 37, 30],
            [2002, 719, 31, 28],
            [2002, 720, 24, 20],
            [2002, 724, 29, 29],
            [2002, 727, 48, 48],
            [2002, 734, 21, 32],
            [2002, 737, 14, 12],
            [2002, 750, 20, 20],
            [2002, 751, 32, 18],
            [2002, 754, 30, 30],
            [2002, 766, 66, 30],
            [2002, 769, 37, 44],
            [2002, 773, 29, 30],
            [2002, 781, 27, 22],
            [2002, 783, 21, 26],
            [2002, 785, 55, 54],
            [2002, 790, 43, 30],
            [2002, 801, 20, 20],
            [2002, 803, 36, 33],
            [2002, 805, 37, 27],
            [2002, 811, 27, 23],
            [2002, 815, 16, 16],
            [2002, 820, 40, 44],
            [2002, 821, 20, 20],
            [2002, 822, 17, 21],
            [2002, 826, 20, 20],
            [2002, 827, 10, 14],
            [2002, 835, 30, 30],
            [2002, 843, 30, 30],
            [2002, 844, 28, 23],
            [2002, 845, 58, 30],
            [2002, 848, 25, 20],
            [2002, 865, 50, 33],
            [2002, 871, 41, 23],
            [2002, 878, 7, 6],
            [2002, 882, 45, 34],
            [2002, 890, 20, 20],
            [2002, 894, 28, 12],
            [2002, 909, 64, 40],
            [2002, 913, 20, 18],
            [2002, 915, 56, 37],
            [2002, 922, 47, 34],
            [2002, 926, 62, 22],
            [2002, 938, 12, 13],
            [2002, 940, 12, 14],
            [2002, 941, 39, 35],
            [2002, 944, 23, 20],
            [2002, 949, 67, 34],
            [2002, 950, 16, 20],
            [2002, 964, 12, 16],
            [2002, 969, 41, 38],
            [2002, 971, 21, 17],
            [2002, 972, 38, 25],
            [2002, 978, 49, 38],
            [2002, 979, 20, 20],
            [2002, 985, 77, 41],
            [2002, 990, 23, 20],
            [2002, 993, 60, 39],
            [2002, 998, 37, 21],
            [2002, 1003, 8, 6],
            [2002, 1008, 23, 24],
            [2002, 1016, 11, 15],
            [2002, 1030, 9, 14],
            [2002, 1033, 20, 20],
            [2002, 1042, 96, 47],
            [2002, 1048, 40, 38],
            [2002, 1051, 25, 20],
            [2002, 1056, 21, 43],
            [2002, 1059, 45, 47],
            [2002, 1073, 50, 33],
            [2002, 1082, 53, 45],
            [2002, 1094, 20, 20],
            [2002, 1095, 20, 20],
            [2002, 1097, 33, 19],
            [2002, 1100, 22, 22],
            [2002, 1102, 15, 17],
            [2002, 1106, 90, 33],
            [2002, 1109, 28, 30],
            [2002, 1111, 38, 48],
            [2002, 1131, 33, 30],
            [2002, 1132, 12, 15],
            [2002, 1136, 44, 47],
            [2002, 1140, 29, 25],
            [2002, 1141, 29, 30],
            [2002, 1142, 25, 25],
            [2002, 1144, 30, 22],
            [2002, 1145, 30, 24],
            [2002, 1150, 36, 27],
            [2002, 1155, 30, 30],
            [2002, 1156, 28, 19],
            [2002, 1157, 37, 25],
            [2002, 1159, 50, 43],
            [2002, 1167, 20, 20],
            [2002, 1169, 20, 20],
            [2002, 1174, 30, 44],
            [2002, 1175, 20, 20],
            [2002, 1177, 36, 30],
            [2002, 1186, 15, 20],
            [2002, 1194, 98, 45],
            [2002, 1200, 20, 20],
            [2002, 1203, 11, 18],
            [2002, 1205, 20, 20],
            [2002, 1213, 23, 21],
            [2002, 1217, 30, 30],
            [2002, 1219, 20, 20],
            [2002, 1221, 21, 19],
            [2002, 1224, 30, 30],
            [2002, 1226, 21, 15],
            [2002, 1228, 19, 20],
            [2002, 1234, 12, 15],
            [2002, 1235, 27, 23],
            [2002, 1238, 14, 27],
            [2002, 1247, 57, 33],
            [2002, 1254, 54, 28],
            [2002, 1262, 29, 30],
            [2002, 1268, 43, 31],
            [2002, 1275, 22, 14],
            [2002, 1281, 15, 21],
            [2002, 1295, 45, 53],
            [2002, 1302, 54, 63],
            [2002, 1303, 83, 41],
            [2002, 1305, 18, 20],
            [2002, 1319, 51, 26],
            [2002, 1320, 43, 40],
            [2002, 1323, 22, 20],
            [2002, 1334, 20, 20],
            [2002, 1358, 51, 28],
            [2002, 1359, 29, 30],
            [2002, 1361, 30, 30],
            [2002, 1363, 31, 30],
            [2002, 1367, 37, 41],
            [2002, 1370, 14, 22],
            [2002, 1375, 20, 20],
            [2002, 1376, 26, 24],
            [2002, 1396, 11, 20],
            [2002, 1420, 52, 48],
            [2002, 1445, 65, 18],
            [2002, 1454, 24, 29],
            [2002, 1456, 29, 29],
            [2002, 1465, 17, 20],
            [2002, 1466, 36, 24],
            [2002, 1471, 30, 30],
            [2002, 1473, 15, 22],
            [2002, 1475, 32, 30],
            [2002, 1476, 29, 30],
            [2002, 1477, 20, 20],
            [2002, 1481, 45, 29],
            [2002, 1482, 13, 17],
            [2002, 1484, 30, 30],
            [2002, 1486, 14, 13],
            [2002, 1490, 22, 20],
            [2002, 1491, 11, 9],
            [2002, 1493, 28, 21],
            [2002, 1507, 37, 25],
            [2002, 1508, 30, 30],
            [2002, 1510, 16, 20],
            [2002, 1511, 30, 30],
            [2002, 1515, 24, 19],
            [2002, 1522, 14, 20],
            [2002, 1525, 44, 43],
            [2002, 1527, 28, 30],
            [2002, 1530, 57, 52],
            [2002, 1536, 17, 18],
            [2002, 1537, 31, 28],
            [2002, 1548, 29, 31],
            [2002, 1553, 29, 30],
            [2002, 1555, 49, 41],
            [2002, 1556, 30, 30],
            [2002, 1557, 34, 30],
            [2002, 1561, 19, 20],
            [2002, 1562, 29, 30],
            [2002, 1568, 32, 30],
            [2002, 1575, 87, 60],
            [2002, 1577, 28, 21],
            [2002, 1580, 45, 38],
            [2002, 1582, 26, 26],
            [2002, 1587, 17, 19],
            [2002, 1589, 44, 20],
            [2002, 1598, 15, 9],
            [2002, 1610, 30, 30],
            [2002, 1628, 36, 22],
            [2002, 1635, 18, 17],
            [2002, 1638, 29, 44],
            [2002, 1644, 36, 30],
            [2002, 1645, 45, 29],
            [2002, 1659, 26, 23],
            [2002, 1660, 29, 30],
            [2002, 1662, 15, 12],
            [2002, 1663, 29, 30],
            [2002, 1664, 17, 16],
            [2002, 1672, 20, 20],
            [2002, 1673, 62, 42],
            [2002, 1680, 30, 30],
            [2002, 1685, 44, 40],
            [2002, 1704, 17, 21],
            [2002, 1717, 57, 28],
            [2002, 1724, 20, 20],
            [2002, 1730, 17, 12],
            [2002, 1744, 30, 29],
            [2002, 1748, 29, 30],
            [2002, 1756, 29, 30],
            [2002, 1760, 13, 16],
            [2002, 1763, 24, 23],
            [2002, 1769, 57, 48],
            [2002, 1771, 20, 20],
            [2002, 1772, 11, 15],
            [2002, 1774, 26, 28],
            [2002, 1780, 19, 20],
            [2002, 1781, 20, 20],
            [2002, 1786, 20, 26],
            [2002, 1790, 20, 20],
            [2002, 1792, 30, 30],
            [2002, 1794, 34, 37],
            [2002, 1795, 13, 10],
            [2002, 1797, 61, 42],
            [2002, 1798, 41, 53],
            [2002, 1804, 19, 20],
            [2002, 1812, 14, 18],
            [2002, 1816, 97, 26],
            [2002, 1818, 20, 20],
            [2002, 1824, 36, 42],
            [2002, 1825, 20, 28],
            [2002, 1829, 19, 27],
            [2002, 1841, 45, 44],
            [2002, 1845, 30, 30],
            [2002, 1848, 30, 30],
            [2002, 1853, 60, 26],
            [2002, 1864, 69, 63],
            [2002, 1866, 62, 34],
            [2002, 1869, 34, 40],
            [2002, 1876, 29, 30],
            [2002, 1879, 23, 20],
            [2002, 1882, 18, 20],
            [2002, 1891, 28, 41],
            [2002, 1894, 36, 16],
            [2002, 1901, 20, 20],
            [2002, 1903, 89, 35],
            [2002, 1915, 46, 37],
            [2002, 1916, 20, 18],
            [2002, 1917, 29, 30],
            [2002, 1921, 20, 18],
            [2002, 1925, 30, 30],
            [2002, 1930, 11, 9],
            [2002, 1933, 11, 15],
            [2002, 1945, 28, 29],
            [2002, 1948, 24, 33],
            [2002, 1950, 21, 35],
            [2002, 1952, 106, 70],
            [2002, 1962, 13, 17],
            [2002, 1965, 60, 47],
            [2002, 1995, 30, 30],
            [2002, 2000, 30, 30],
            [2002, 2001, 37, 27],
            [2002, 2006, 23, 21],
            [2002, 2011, 12, 17],
            [2002, 2017, 41, 41],
            [2002, 2021, 30, 29],
            [2002, 2023, 12, 12],
            [2002, 2025, 30, 30],
            [2002, 2026, 43, 31],
            [2002, 2028, 42, 24],
            [2002, 2029, 29, 30],
            [2002, 2032, 17, 19],
            [2002, 2035, 62, 34],
            [2002, 2042, 19, 20],
            [2002, 2048, 14, 31],
            [2002, 2056, 34, 40],
            [2002, 2057, 89, 40],
            [2002, 2064, 53, 35],
            [2002, 2081, 19, 20],
            [2002, 2084, 56, 31],
            [2002, 2098, 14, 17],
            [2002, 2099, 24, 20],
            [2002, 2101, 10, 13],
            [2002, 2104, 31, 30],
            [2002, 2121, 18, 17],
            [2002, 2127, 17, 12],
            [2002, 2128, 30, 30],
            [2002, 2131, 28, 39],
            [2002, 2138, 27, 26],
            [2002, 2142, 10, 11],
            [2002, 2144, 22, 65],
            [2002, 2162, 20, 37],
            [2002, 2163, 36, 18],
            [2002, 2170, 25, 20],
            [2002, 2171, 28, 26],
            [2002, 2174, 28, 21],
            [2002, 2178, 13, 19],
            [2002, 2180, 29, 30],
            [2002, 2181, 30, 29],
            [2002, 2182, 29, 30],
            [2002, 2190, 28, 23],
            [2002, 2198, 24, 18],
            [2002, 2201, 30, 30],
            [2002, 2208, 48, 34],
            [2002, 2213, 45, 38],
            [2002, 2216, 24, 30],
            [2002, 2220, 19, 20],
            [2002, 2224, 30, 32],
            [2002, 2227, 18, 18],
            [2002, 2232, 30, 30],
            [2002, 2236, 19, 20],
            [2002, 2238, 30, 30],
            [2002, 2239, 22, 20],
            [2002, 2244, 25, 27],
            [2002, 2250, 45, 30],
            [2002, 2255, 29, 29],
            [2002, 2258, 29, 30],
            [2002, 2277, 29, 26],
            [2002, 2280, 9, 7],
            [2002, 2282, 20, 60],
            [2002, 2293, 30, 30],
            [2002, 2300, 43, 49],
            [2002, 2303, 20, 20],
            [2002, 2311, 39, 38],
            [2002, 2312, 20, 20],
            [2002, 2316, 55, 33],
            [2002, 2332, 15, 16],
            [2002, 2335, 30, 30],
            [2002, 2343, 27, 18],
            [2002, 2352, 44, 38],
            [2002, 2366, 16, 17],
            [2002, 2367, 33, 30],
            [2002, 2371, 57, 32],
            [2002, 2383, 33, 20],
            [2002, 2384, 27, 37],
            [2002, 2404, 29, 29],
            [2002, 2405, 30, 32],
            [2002, 2428, 33, 20],
            [2002, 2429, 12, 12],
            [2002, 2433, 55, 23],
            [2002, 2435, 18, 14],
            [2002, 2443, 57, 34],
            [2002, 2447, 19, 20],
            [2002, 2458, 16, 14],
            [2002, 2459, 13, 17],
            [2002, 2467, 12, 16],
            [2002, 2472, 32, 22],
            [2002, 2483, 61, 44],
            [2002, 2485, 14, 13],
            [2002, 2488, 25, 25],
            [2002, 2493, 23, 20],
            [2002, 2494, 28, 30],
            [2002, 2497, 20, 20],
            [2002, 2500, 26, 18],
            [2002, 2501, 62, 27],
            [2002, 2505, 45, 30],
            [2002, 2509, 15, 18],
            [2002, 2514, 30, 30],
            [2002, 2516, 30, 30],
            [2002, 2518, 30, 30],
            [2002, 2524, 11, 11],
            [2002, 2527, 24, 20],
            [2002, 2533, 11, 18],
            [2002, 2539, 55, 27],
            [2002, 2540, 20, 22],
            [2002, 2543, 21, 21],
            [2002, 2547, 16, 15],
            [2002, 2551, 38, 30],
            [2002, 2554, 12, 12],
            [2002, 2555, 35, 23],
            [2002, 2562, 34, 30],
            [2002, 2564, 20, 20],
            [2002, 2574, 29, 30],
            [2002, 2576, 56, 29],
            [2002, 2585, 54, 44],
            [2002, 2587, 29, 29],
            [2002, 2593, 28, 30],
            [2002, 2595, 42, 36],
            [2002, 2603, 77, 39],
            [2002, 2604, 30, 30],
            [2002, 2606, 20, 15],
            [2002, 2607, 11, 10],
            [2002, 2612, 30, 30],
            [2002, 2615, 33, 30],
            [2002, 2617, 41, 24],
            [2002, 2619, 12, 13],
            [2002, 2622, 27, 20],
            [2002, 2627, 60, 34],
            [2002, 2628, 20, 20],
            [2002, 2632, 30, 18],
            [2002, 2633, 30, 30],
            [2002, 2635, 13, 20],
            [2002, 2644, 26, 20],
            [2002, 2647, 32, 27],
            [2002, 2650, 22, 20],
            [2002, 2656, 20, 20],
            [2002, 2658, 29, 30],
            [2002, 2667, 29, 30],
            [2002, 2668, 30, 30],
            [2002, 2669, 48, 43],
            [2002, 2670, 45, 30],
            [2002, 2671, 48, 54],
            [2002, 2687, 24, 17],
            [2002, 2692, 58, 26],
            [2002, 2695, 12, 13],
            [2002, 2720, 35, 38],
            [2002, 2723, 41, 63],
            [2002, 2743, 30, 30],
            [2002, 2747, 29, 30],
            [2002, 2748, 30, 30],
            [2002, 2758, 33, 29],
            [2002, 2762, 76, 44],
            [2002, 2775, 57, 34],
            [2002, 2785, 13, 15],
            [2002, 2788, 30, 30],
            [2002, 2791, 39, 26],
            [2002, 2797, 14, 15],
            [2002, 2798, 12, 20],
            [2002, 2813, 29, 30],
            [2002, 2822, 28, 23],
            [2002, 2823, 20, 20],
            [2002, 2827, 13, 18],
            [2002, 2832, 16, 16],
            [2002, 2833, 49, 32],
            [2002, 2835, 33, 31],
            [2002, 2836, 30, 17],
            [2002, 2838, 41, 34],
            [2002, 2846, 25, 26],
            [2002, 2851, 20, 17],
            [2002, 2854, 34, 34],
            [2002, 2856, 34, 30],
            [2002, 2867, 20, 20],
            [2002, 2872, 18, 20],
            [2002, 2876, 30, 30],
            [2002, 2879, 24, 24],
            [2002, 2880, 35, 28],
            [2002, 2883, 32, 30],
            [2002, 2884, 23, 38],
            [2002, 2897, 90, 51],
            [2002, 2901, 66, 54],
            [2002, 2904, 47, 32],
            [2002, 2910, 20, 20],
            [2002, 2914, 45, 30],
            [2002, 2918, 50, 36],
            [2002, 2922, 15, 16],
            [2002, 2923, 29, 29],
            [2002, 2929, 30, 30],
            [2002, 2932, 32, 32],
            [2002, 2934, 21, 20],
            [2002, 2935, 66, 31],
            [2002, 2936, 23, 20],
            [2002, 2946, 29, 20],
            [2002, 2950, 30, 30],
            [2002, 2969, 21, 18],
            [2002, 2973, 38, 48],
            [2002, 2974, 40, 22],
            [2002, 2978, 29, 30],
            [2002, 2979, 24, 16],
            [2002, 2991, 40, 43],
            [2002, 2995, 20, 20],
            [2002, 3009, 37, 41],
            [2002, 3011, 30, 30],
            [2002, 3016, 30, 30],
            [2002, 3019, 42, 22],
            [2002, 3027, 19, 20],
            [2002, 3033, 75, 45],
            [2002, 3035, 20, 20],
            [2002, 3041, 34, 26],
            [2002, 3046, 30, 14],
            [2002, 3048, 44, 23],
            [2002, 3050, 31, 21],
            [2002, 3053, 68, 61],
            [2002, 3061, 30, 30],
            [2002, 3066, 57, 30],
            [2002, 3070, 33, 35],
            [2002, 3077, 34, 20],
            [2002, 3086, 67, 25],
            [2002, 3091, 10, 15],
            [2002, 3092, 45, 24],
            [2002, 3098, 20, 20],
            [2002, 3106, 19, 21],
            [2002, 3112, 56, 30],
            [2002, 3114, 33, 30],
            [2002, 3119, 11, 27],
            [2002, 3121, 20, 20],
            [2002, 3122, 30, 30],
            [2002, 3126, 45, 21],
            [2002, 3129, 35, 43],
            [2002, 3133, 25, 20],
            [2002, 3134, 46, 39],
            [2002, 3137, 30, 30],
            [2002, 3142, 34, 41],
            [2002, 3148, 33, 29],
            [2002, 3154, 31, 30],
            [2002, 3155, 26, 21],
            [2002, 3158, 16, 18],
            [2002, 3160, 19, 20],
            [2002, 3161, 20, 20],
            [2002, 3164, 54, 35],
            [2002, 3167, 21, 29],
            [2002, 3171, 37, 20],
            [2002, 3175, 35, 26],
            [2002, 3182, 19, 22],
            [2002, 3188, 39, 36],
            [2002, 3189, 35, 30],
            [2002, 3195, 20, 20],
            [2002, 3206, 30, 30],
            [2002, 3217, 30, 30],
            [2002, 3221, 45, 22],
            [2002, 3228, 29, 30],
            [2002, 3231, 20, 20],
            [2002, 3234, 53, 25],
            [2002, 3246, 57, 33],
            [2002, 3248, 19, 22],
            [2002, 3251, 36, 43],
            [2002, 3252, 40, 26],
            [2002, 3254, 25, 18],
            [2002, 3256, 21, 22],
            [2002, 3264, 29, 30],
            [2002, 3268, 30, 30],
            [2002, 3272, 24, 21],
            [2002, 3273, 77, 19],
            [2002, 3274, 28, 24],
            [2002, 3277, 31, 22],
            [2002, 3280, 29, 30],
            [2002, 3283, 25, 21],
            [2002, 3284, 20, 20],
            [2002, 3289, 61, 50],
            [2002, 3301, 42, 40],
            [2002, 3306, 22, 26],
            [2002, 3308, 62, 38],
            [2002, 3309, 42, 38],
            [2002, 3320, 54, 58],
            [2002, 3321, 45, 25],
            [2002, 3326, 20, 20],
            [2002, 3327, 50, 51],
            [2002, 3331, 20, 20],
            [2002, 3336, 24, 20],
            [2002, 3344, 20, 19],
            [2002, 3346, 20, 32],
            [2002, 3348, 57, 30],
            [2002, 3357, 12, 18],
            [2002, 3358, 15, 18],
            [2002, 3363, 65, 30],
            [2002, 3364, 11, 17],
            [2002, 3372, 53, 31],
            [2002, 3382, 37, 24],
            [2002, 3404, 38, 30],
            [2002, 3407, 19, 20],
            [2002, 3418, 74, 37],
            [2002, 3422, 24, 18],
            [2002, 3429, 29, 29],
            [2002, 3434, 7, 6],
            [2002, 3438, 54, 29],
            [2002, 3439, 20, 20],
            [2002, 3441, 29, 30],
            [2002, 3442, 20, 20],
            [2002, 3451, 47, 49],
            [2002, 3453, 20, 20],
            [2002, 3454, 12, 10],
            [2002, 3457, 30, 30],
            [2002, 3459, 26, 22],
            [2002, 3462, 53, 24],
            [2002, 3468, 21, 20],
            [2002, 3469, 30, 18],
            [2002, 3476, 30, 38],
            [2002, 3494, 12, 15],
            [2002, 3498, 20, 26],
            [2002, 3503, 78, 51],
            [2002, 3511, 19, 32],
            [2002, 3515, 15, 58],
            [2002, 3517, 55, 22],
            [2002, 3531, 27, 20],
            [2002, 3541, 22, 27],
            [2002, 3557, 10, 15],
            [2002, 3559, 45, 40],
            [2002, 3566, 14, 12],
            [2002, 3569, 65, 65],
            [2002, 3572, 28, 28],
            [2002, 3579, 20, 31],
            [2002, 3590, 29, 32],
            [2002, 3593, 46, 20],
            [2002, 3598, 17, 13],
            [2002, 3602, 20, 20],
            [2002, 3608, 27, 29],
            [2002, 3632, 30, 30],
            [2002, 3639, 20, 20],
            [2002, 3642, 33, 29],
            [2002, 3644, 29, 29],
            [2002, 3650, 39, 30],
            [2002, 3653, 20, 20],
            [2002, 3656, 29, 30],
            [2002, 3659, 20, 16],
            [2002, 3661, 30, 30],
            [2002, 3667, 19, 20],
            [2002, 3669, 11, 20],
            [2002, 3670, 39, 30],
            [2002, 3679, 19, 20],
            [2002, 3700, 23, 26],
            [2002, 3703, 28, 30],
            [2002, 3718, 53, 28],
            [2002, 3726, 11, 13],
            [2002, 3729, 100, 30],
            [2002, 3731, 28, 23],
            [2002, 3747, 28, 23],
            [2002, 3751, 23, 20],
            [2002, 3755, 29, 30],
            [2002, 3761, 21, 21],
            [2002, 3765, 25, 18],
            [2002, 3777, 29, 22],
            [2002, 3782, 69, 31],
            [2002, 3786, 13, 12],
            [2002, 3795, 29, 30],
            [2002, 3796, 30, 30],
            [2002, 3802, 47, 50],
            [2002, 3807, 20, 20],
            [2002, 3827, 30, 30],
            [2002, 3828, 20, 22],
            [2002, 3832, 28, 28],
            [2002, 3833, 25, 13],
            [2002, 3834, 29, 35],
            [2002, 3841, 27, 30],
            [2002, 3845, 30, 30],
            [2002, 3854, 19, 20],
            [2002, 3855, 20, 20],
            [2002, 3859, 12, 16],
            [2002, 3870, 32, 30],
            [2002, 3874, 29, 30],
            [2002, 3883, 20, 20],
            [2002, 3884, 58, 34],
            [2002, 3889, 79, 30],
            [2002, 3897, 28, 29],
            [2002, 3905, 29, 29],
            [2002, 3915, 29, 30],
            [2002, 3921, 30, 30],
            [2002, 3925, 65, 48],
            [2002, 3932, 25, 31],
            [2002, 3942, 19, 30],
            [2002, 3943, 17, 27],
            [2002, 3947, 48, 39],
            [2002, 3953, 30, 30],
            [2002, 3956, 44, 53],
            [2002, 3959, 20, 20],
            [2002, 3960, 39, 30],
            [2002, 3963, 25, 15],
            [2002, 3969, 85, 45],
            [2002, 3970, 30, 30],
            [2002, 3972, 82, 62],
            [2002, 3976, 17, 15],
            [2002, 3985, 30, 24],
            [2002, 3988, 24, 30],
            [2002, 3992, 30, 30],
            [2002, 3993, 11, 13],
            [2002, 3999, 29, 30],
            [2002, 4015, 58, 31],
            [2002, 4022, 44, 28],
            [2002, 4023, 29, 30],
            [2002, 4026, 36, 19],
            [2002, 4027, 83, 38],
            [2002, 4028, 32, 40],
            [2002, 4031, 17, 15],
            [2002, 4034, 83, 47],
            [2002, 4035, 20, 20],
            [2002, 4038, 95, 40],
            [2002, 4040, 29, 30],
            [2002, 4043, 18, 18],
            [2002, 4047, 29, 34],
            [2002, 4074, 22, 32],
            [2002, 4082, 83, 39],
            [2002, 4084, 12, 18],
            [2002, 4091, 39, 16],
            [2002, 4095, 30, 30],
            [2002, 4096, 30, 30],
            [2002, 4106, 28, 30],
            [2002, 4107, 72, 31],
            [2002, 4109, 18, 19],
            [2002, 4111, 20, 14],
            [2002, 4116, 28, 30],
            [2002, 4118, 30, 30],
            [2002, 4120, 30, 30],
            [2002, 4122, 63, 57],
            [2002, 4124, 30, 30],
            [2002, 4125, 13, 17],
            [2002, 4134, 34, 30],
            [2002, 4152, 108, 50],
            [2002, 4156, 20, 21],
            [2002, 4164, 20, 20],
            [2002, 4165, 40, 39],
            [2002, 4169, 28, 22],
            [2002, 4173, 12, 18],
            [2002, 4176, 11, 15],
            [2002, 4177, 51, 35],
            [2002, 4182, 28, 30],
            [2002, 4185, 19, 20],
            [2002, 4188, 91, 26],
            [2002, 4189, 19, 30],
            [2002, 4199, 46, 30],
            [2002, 4203, 29, 30],
            [2002, 4206, 15, 19],
            [2002, 4209, 21, 19],
            [2002, 4229, 27, 21],
            [2002, 4242, 20, 20],
            [2002, 4246, 11, 14],
            [2002, 4250, 71, 26],
            [2002, 4272, 30, 30],
            [2002, 4279, 25, 30],
            [2002, 4283, 19, 18],
            [2002, 4285, 32, 29],
            [2002, 4298, 44, 52],
            [2002, 4299, 20, 35],
            [2002, 4301, 59, 32],
            [2002, 4310, 33, 26],
            [2002, 4312, 54, 32],
            [2002, 4318, 19, 20],
            [2002, 4320, 31, 31],
            [2002, 4325, 54, 30],
            [2002, 4326, 10, 14],
            [2002, 4329, 21, 30],
            [2002, 4333, 17, 21],
            [2002, 4338, 30, 30],
            [2002, 4345, 19, 21],
            [2002, 4349, 30, 29],
            [2002, 4350, 20, 20],
            [2002, 4352, 20, 20],
            [2002, 4353, 27, 26],
            [2002, 4358, 12, 16],
            [2002, 4362, 48, 31],
            [2002, 4364, 20, 20],
            [2002, 4380, 17, 13],
            [2002, 4382, 55, 47],
            [2002, 4384, 32, 20],
            [2002, 4386, 15, 17],
            [2002, 4391, 20, 20],
            [2002, 4406, 42, 30],
            [2002, 4413, 12, 12],
            [2002, 4414, 15, 24],
            [2002, 4415, 88, 28],
            [2002, 4421, 30, 30],
            [2002, 4426, 11, 15],
            [2002, 4438, 55, 27],
            [2002, 4440, 45, 33],
            [2002, 4441, 17, 13],
            [2002, 4442, 15, 20],
            [2002, 4446, 29, 30],
            [2002, 4454, 22, 20],
            [2002, 4461, 38, 28],
            [2002, 4464, 56, 28],
            [2002, 4470, 31, 34],
            [2002, 4471, 20, 20],
            [2002, 4477, 31, 35],
            [2002, 4487, 30, 39],
            [2002, 4491, 49, 34],
            [2002, 4494, 19, 20],
            [2002, 4495, 27, 21],
            [2002, 4500, 27, 20],
            [2002, 4504, 61, 38],
            [2002, 4506, 19, 20],
            [2002, 4508, 33, 28],
            [2002, 4510, 26, 22],
            [2002, 4515, 30, 29],
            [2002, 4518, 36, 28],
            [2002, 4521, 29, 30],
            [2002, 4524, 30, 30],
            [2002, 4532, 23, 20],
            [2002, 4536, 22, 20],
            [2002, 4542, 41, 26],
            [2002, 4545, 50, 37],
            [2002, 4550, 29, 30],
            [2002, 4552, 15, 18],
            [2002, 4558, 29, 27],
            [2002, 4563, 29, 30],
            [2002, 4572, 29, 20],
            [2002, 4587, 32, 25],
            [2002, 4591, 21, 20],
            [2002, 4602, 23, 29],
            [2002, 4606, 19, 20],
            [2002, 4608, 21, 23],
            [2002, 4610, 57, 28],
            [2002, 4611, 20, 20],
            [2002, 4613, 45, 38],
            [2002, 4616, 22, 18],
            [2002, 4617, 86, 39],
            [2002, 4618, 26, 25],
            [2002, 4623, 15, 19],
            [2002, 4626, 35, 23],
            [2002, 4633, 20, 20],
            [2002, 4634, 31, 30],
            [2002, 4635, 72, 13],
            [2002, 4638, 67, 39],
            [2002, 4643, 22, 18],
            [2002, 4644, 14, 18],
            [2002, 4648, 31, 11],
            [2002, 4660, 61, 29],
            [2002, 4668, 29, 29],
            [2002, 4670, 61, 25],
            [2002, 4676, 13, 20],
            [2002, 4684, 22, 20],
            [2002, 4689, 45, 32],
            [2002, 4693, 31, 30],
            [2002, 4694, 22, 22],
            [2002, 4703, 10, 15],
            [2002, 4710, 9, 7],
            [2002, 4711, 17, 15],
            [2002, 4712, 24, 18],
            [2002, 4717, 20, 20],
            [2002, 4724, 31, 20],
            [2002, 4728, 25, 22],
            [2002, 4729, 37, 30],
            [2002, 4732, 77, 88],
            [2002, 4734, 18, 18],
            [2002, 4738, 42, 51],
            [2002, 4745, 19, 22],
            [2002, 4747, 60, 33],
            [2002, 4749, 45, 33],
            [2002, 4753, 25, 21],
            [2002, 4762, 57, 55],
            [2002, 4764, 49, 43],
            [2002, 4777, 21, 22],
            [2002, 4780, 20, 20],
            [2002, 4781, 27, 31],
            [2002, 4789, 41, 25],
            [2002, 4791, 19, 20],
            [2002, 4794, 26, 20],
            [2002, 4800, 30, 30],
            [2002, 4801, 11, 20],
            [2002, 4802, 28, 20],
            [2002, 4805, 15, 21],
            [2002, 4815, 29, 30],
            [2002, 4819, 19, 20],
            [2002, 4820, 53, 49],
            [2002, 4826, 20, 20],
            [2002, 4828, 40, 21],
            [2002, 4829, 20, 27],
            [2002, 4832, 12, 16],
            [2002, 4835, 26, 24],
            [2002, 4839, 37, 22],
            [2002, 4840, 56, 38],
            [2002, 4844, 21, 20],
            [2002, 4849, 20, 19],
            [2002, 4863, 45, 28],
            [2002, 4864, 19, 22],
            [2002, 4865, 32, 23],
            [2002, 4871, 16, 21],
            [2002, 4872, 30, 30],
            [2002, 4877, 25, 20],
            [2002, 4880, 17, 21],
            [2002, 4881, 30, 30],
            [2002, 4888, 54, 52],
            [2002, 4897, 17, 24],
            [2002, 4910, 29, 30],
            [2002, 4912, 11, 20],
            [2002, 4914, 32, 18],
            [2002, 4915, 21, 18],
            [2002, 4918, 22, 30],
            [2002, 4922, 37, 20],
            [2002, 4926, 26, 22],
            [2002, 4927, 20, 20],
            [2002, 4931, 19, 20],
            [2002, 4939, 24, 23],
            [2002, 4940, 44, 22],
            [2002, 4944, 14, 17],
            [2002, 4950, 30, 30],
            [2002, 4951, 45, 29],
            [2002, 4955, 30, 30],
            [2002, 4957, 20, 20],
            [2002, 4960, 107, 50],
            [2002, 4973, 31, 34],
            [2002, 4975, 30, 30],
            [2002, 4976, 12, 18],
            [2002, 4978, 68, 53],
            [2002, 4979, 89, 36],
            [2002, 4983, 22, 19],
            [2002, 4987, 20, 20],
            [2002, 4990, 20, 20],
            [2002, 4992, 25, 23],
            [2002, 4995, 28, 30],
            [2002, 4996, 30, 30],
            [2002, 4997, 28, 20],
            [2002, 4998, 30, 30],
            [2002, 5005, 18, 30],
            [2002, 5006, 48, 26],
            [2002, 5008, 29, 30],
            [2002, 5009, 19, 20],
            [2002, 5011, 30, 30],
            [2002, 5012, 27, 29],
            [2002, 5013, 11, 18],
            [2002, 5017, 29, 30],
            [2002, 5019, 52, 33],
            [2002, 5022, 81, 47],
            [2002, 5027, 29, 30],
            [2002, 5031, 10, 15],
            [2002, 5032, 22, 30],
            [2002, 5033, 20, 20],
            [2002, 5035, 30, 30],
            [2002, 5037, 30, 20],
            [2002, 5038, 12, 19],
            [2002, 5046, 30, 30],
            [2002, 5048, 21, 19],
            [2002, 5050, 12, 14],
            [2002, 5051, 12, 13],
            [2002, 5053, 30, 22],
            [2002, 5058, 30, 30],
            [2002, 5062, 34, 47],
            [2002, 5063, 24, 33],
            [2002, 5064, 28, 30],
            [2002, 5065, 28, 30],
            [2002, 5068, 30, 23],
            [2002, 5069, 29, 30],
            [2002, 5070, 20, 20],
            [2002, 5071, 29, 30],
            [2002, 5073, 61, 44],
            [2002, 5075, 21, 30],
            [2002, 5079, 20, 20],
            [2002, 5081, 36, 17],
            [2002, 5091, 52, 45],
            [2002, 5092, 12, 17],
            [2002, 5095, 14, 17],
            [2002, 5098, 20, 20],
            [2002, 5102, 20, 12],
            [2002, 5103, 30, 30],
            [2002, 5104, 57, 39],
            [2002, 5107, 53, 45],
            [2002, 5108, 23, 33],
            [2002, 5109, 22, 20],
            [2002, 5116, 27, 31],
            [2002, 5121, 20, 20],
            [2002, 5122, 30, 22],
            [2002, 5126, 19, 20],
            [2002, 5127, 20, 20],
            [2002, 5130, 51, 59],
            [2002, 5138, 15, 15],
            [2002, 5149, 24, 21],
            [2002, 5150, 64, 40],
            [2002, 5153, 35, 30],
            [2002, 5159, 40, 25],
            [2002, 5162, 23, 22],
            [2002, 5173, 43, 25],
            [2002, 5180, 21, 32],
            [2002, 5181, 19, 20],
            [2002, 5182, 21, 23],
            [2002, 5183, 30, 30],
            [2002, 5184, 37, 22],
            [2002, 5185, 32, 18],
            [2002, 5186, 13, 18],
            [2002, 5187, 12, 13],
            [2002, 5188, 12, 15],
            [2002, 5189, 18, 11],
            [2002, 5217, 57, 39],
            [2002, 5219, 17, 54],
            [2002, 5220, 14, 57],
            [2002, 5221, 12, 43],
            [2002, 5222, 16, 23],
            [2002, 5223, 11, 30],
            [2002, 5224, 15, 43],
            [2002, 5225, 16, 56],
            [2002, 5226, 12, 56],
            [2002, 5227, 30, 65],
            [2002, 5228, 20, 60],
            [2002, 5229, 11, 43],
            [2002, 5230, 16, 37],
            [2002, 5231, 14, 34],
            [2002, 5232, 19, 62],
            [2002, 5233, 24, 78],
            [2002, 5234, 11, 26],
            [2002, 5235, 40, 41],
            [2002, 5236, 15, 42],
            [2002, 5237, 29, 59],
            [2002, 5238, 18, 46],
            [2002, 5239, 24, 65],
            [2002, 5240, 19, 66],
            [2002, 5241, 28, 62],
            [2002, 5242, 21, 46],
            [2002, 5243, 27, 67],
            [2002, 5244, 20, 79],
            [2002, 5245, 25, 67],
            [2002, 5247, 36, 14],
            [2002, 5248, 37, 20],
            [2002, 5273, 26, 17],
            [2002, 5276, 31, 54],
            [2002, 5279, 21, 24],
            [2002, 5287, 13, 13],
            [2002, 5290, 22, 21],
            [2002, 5298, 13, 13],
            [2002, 5299, 18, 20],
            [2002, 5303, 32, 21],
            [2002, 5305, 26, 23],
            [2002, 5314, 21, 23],
            [2002, 5315, 19, 25],
            [2002, 5317, 41, 59],
            [2002, 5321, 21, 21],
            [2002, 5323, 14, 21],
            [2002, 5328, 19, 20],
            [2002, 5332, 22, 26],
            [2002, 5333, 13, 15],
            [2002, 5336, 15, 18],
            [2002, 5337, 17, 17],
            [2002, 5338, 30, 24],
            [2002, 5339, 21, 23],
            [2002, 5340, 28, 32],
            [2002, 5343, 16, 14],
            [2002, 5344, 41, 42],
            [2002, 5347, 20, 22],
            [2002, 5349, 22, 25],
            [2002, 5350, 20, 27],
            [2002, 5353, 19, 24],
            [2002, 5355, 22, 35],
            [2002, 5357, 26, 20],
            [2002, 5359, 17, 23],
            [2002, 5366, 29, 23],
            [2002, 5371, 32, 34],
            [2002, 5372, 22, 23],
            [2002, 5375, 19, 18],
            [2002, 5377, 17, 18],
            [2002, 5383, 26, 26],
            [2002, 5385, 31, 23],
            [2002, 5387, 16, 15],
            [2002, 5400, 14, 13],
            [2002, 5403, 23, 23],
            [2002, 5404, 23, 23],
            [2002, 5407, 20, 23],
            [2002, 5408, 18, 21],
            [2002, 5411, 24, 20],
            [2002, 5412, 21, 17],
            [2002, 5414, 12, 15],
            [2002, 5415, 42, 45],
            [2002, 5418, 27, 33],
            [2002, 5420, 16, 16],
            [2002, 5421, 17, 14],
            [2002, 5422, 24, 31],
            [2002, 5425, 17, 19],
            [2002, 5426, 20, 27],
            [2002, 5428, 18, 23],
            [2002, 5431, 22, 23],
            [2002, 5432, 22, 28],
            [2002, 5434, 15, 16],
            [2002, 5436, 20, 23],
            [2002, 5437, 27, 23],
            [2002, 5440, 35, 28],
            [2002, 5441, 28, 35],
            [2002, 5444, 22, 32],
            [2002, 5447, 19, 22],
            [2002, 5449, 25, 29],
            [2002, 5450, 26, 28],
            [2002, 5452, 22, 30],
            [2002, 5453, 30, 29],
            [2002, 5454, 14, 15],
            [2002, 5455, 25, 20],
            [2002, 5457, 16, 23],
            [2002, 5459, 23, 24],
            [2002, 5462, 21, 24],
            [2002, 5463, 14, 17],
            [2002, 5464, 18, 18],
            [2002, 5465, 22, 22],
            [2002, 5472, 22, 26],
            [2002, 5473, 17, 22],
            [2002, 5476, 15, 20],
            [2002, 5479, 20, 18],
            [2002, 5480, 33, 29],
            [2002, 5482, 17, 18],
            [2002, 5486, 21, 21],
            [2002, 5489, 30, 51],
            [2002, 5492, 22, 35],
            [2002, 5494, 24, 27],
            [2002, 5495, 28, 24],
            [2002, 5498, 34, 35],
            [2002, 5499, 30, 23],
            [2002, 5501, 25, 38],
            [2002, 5505, 18, 27],
            [2002, 5508, 23, 31],
            [2002, 5528, 20, 18],
            [2002, 5532, 23, 23],
            [2002, 5534, 16, 14],
            [2002, 5539, 16, 19],
            [2002, 5541, 25, 21],
            [2002, 5544, 21, 29],
            [2002, 5545, 16, 21],
            [2002, 5547, 26, 24],
            [2002, 5550, 17, 17],
            [2002, 5571, 25, 20],
            [2002, 5659, 9, 7],
            [2002, 5944, 7, 8],
            [2002, 5945, 11, 9],
            [2002, 5946, 6, 5],
            [2002, 5962, 74, 91],
            [2002, 5986, 55, 37],
            [2002, 5996, 55, 31],
            [2002, 6055, 61, 37],
            [2002, 6066, 34, 33],
            [2002, 6068, 58, 48],
            [2002, 6069, 62, 58],
            [2002, 6070, 62, 58],
            [2002, 6071, 33, 31],
            [2002, 6072, 23, 43],
            [2002, 6073, 37, 39],
            [2002, 6074, 42, 39],
            [2002, 6075, 62, 58],
            [2002, 6076, 45, 42],
            [2002, 6077, 37, 36],
            [2002, 6078, 45, 51],
            [2002, 6079, 45, 42],
            [2002, 6080, 45, 48],
            [2002, 6081, 29, 32],
            [2002, 6082, 42, 39],
            [2002, 6083, 38, 35],
            [2002, 6084, 54, 39],
            [2002, 6085, 46, 43],
            [2002, 6086, 29, 25],
            [2002, 6087, 107, 36],
            [2002, 6088, 44, 42],
            [2002, 6089, 37, 35],
            [2002, 6090, 62, 45],
            [2002, 6091, 33, 35],
            [2002, 6092, 38, 42],
            [2002, 6093, 42, 39],
            [2002, 6094, 42, 39],
            [2002, 6095, 29, 27],
            [2002, 6096, 38, 31],
            [2002, 6097, 45, 36],
            [2002, 6098, 38, 35],
            [2002, 6099, 54, 39],
            [2002, 6100, 42, 39],
            [2002, 6101, 42, 31],
            [2002, 6102, 29, 29],
            [2002, 6103, 38, 35],
            [2002, 6104, 46, 33],
            [2002, 6105, 54, 39],
            [2002, 6106, 33, 31],
            [2002, 6107, 33, 31],
            [2002, 6108, 42, 37],
            [2002, 6109, 24, 31],
            [2002, 6110, 38, 39],
            [2002, 6111, 19, 27],
            [2002, 6112, 36, 36],
            [2002, 6113, 28, 28],
            [2002, 6114, 28, 28],
            [2002, 6115, 28, 33],
            [2002, 6116, 40, 36],
            [2002, 6117, 32, 32],
            [2002, 6118, 40, 39],
            [2002, 6119, 36, 36],
            [2002, 6120, 24, 27],
            [2002, 6121, 36, 36],
            [2002, 6122, 36, 32],
            [2002, 6123, 28, 28],
            [2002, 6124, 40, 32],
            [2002, 6125, 32, 32],
            [2002, 6126, 36, 36],
            [2002, 6127, 36, 36],
            [2002, 6128, 31, 40],
            [2002, 6129, 20, 27],
            [2002, 6130, 36, 36],
            [2002, 6131, 38, 35],
            [2002, 6132, 42, 39],
            [2002, 6133, 38, 35],
            [2002, 6134, 38, 35],
            [2002, 6135, 101, 94],
            [2002, 6136, 85, 80],
            [2002, 6137, 20, 24],
            [2002, 6138, 32, 37],
            [2002, 6139, 37, 37],
            [2002, 6140, 25, 32],
            [2002, 6141, 37, 42],
            [2002, 6142, 31, 37],
            [2002, 6143, 32, 32],
            [2002, 6144, 27, 28],
            [2002, 6145, 40, 40],
            [2002, 6146, 19, 27],
            [2002, 6147, 27, 40],
            [2002, 6148, 27, 34],
            [2002, 6149, 36, 36],
            [2002, 6150, 19, 27],
            [2002, 6151, 27, 28],
            [2002, 6152, 23, 28],
            [2002, 6153, 25, 31],
            [2002, 6154, 36, 36],
            [2002, 6155, 25, 30],
            [2002, 6156, 28, 32],
            [2002, 6157, 43, 40],
            [2002, 6158, 29, 31],
            [2002, 6159, 41, 39],
            [2002, 6160, 24, 28],
            [2002, 6161, 18, 25],
            [2002, 6162, 23, 27],
            [2002, 6163, 60, 51],
            [2002, 6164, 37, 39],
            [2002, 6165, 32, 31],
            [2002, 6166, 53, 37],
            [2002, 6167, 60, 49],
            [2002, 6244, 58, 43],
            [2002, 6353, 23, 15],
            [2002, 6357, 33, 26],
            [2002, 6358, 24, 31],
            [2002, 6359, 24, 24],
            [2002, 6360, 94, 70],
            [2002, 6361, 94, 80],
            [2002, 6362, 59, 57],
            [2002, 6363, 59, 62],
            [2002, 6364, 94, 71],
            [2002, 6365, 102, 75],
            [2002, 6366, 102, 75],
            [2002, 6367, 57, 57],
            [2002, 6368, 94, 71],
            [2002, 6369, 63, 62],
            [2002, 6370, 94, 70],
            [2002, 6371, 95, 79],
            [2002, 6372, 102, 75],
            [2002, 6373, 102, 82],
            [2002, 6374, 95, 70],
            [2002, 6375, 105, 70],
            [2002, 6376, 64, 57],
            [2002, 6377, 105, 78],
            [2002, 6378, 59, 57],
            [2002, 6379, 64, 62],
            [2002, 6380, 64, 57],
            [2002, 6381, 64, 57],
            [2002, 6382, 95, 70],
            [2002, 6383, 64, 57],
            [2002, 6384, 94, 71],
            [2002, 6385, 95, 59],
            [2002, 6386, 95, 70],
            [2002, 6387, 94, 78],
            [2002, 6388, 95, 70],
            [2002, 6389, 102, 75],
            [2002, 6390, 94, 71],
            [2002, 6391, 58, 55],
            [2002, 6392, 95, 70],
            [2002, 6393, 105, 78],
            [2002, 6394, 102, 75],
            [2002, 6395, 94, 71],
            [2002, 6396, 102, 75],
            [2002, 6397, 95, 70],
            [2002, 6398, 110, 82],
            [2002, 6399, 102, 75],
            [2002, 6400, 92, 68],
            [2002, 6401, 63, 63],
            [2002, 6402, 102, 75],
            [2002, 6403, 110, 82],
            [2002, 6404, 102, 75],
            [2002, 6405, 102, 75],
            [2002, 6406, 95, 70],
            [2002, 6407, 94, 71],
            [2002, 6408, 94, 71],
            [2002, 6409, 95, 70],
            [2002, 6410, 94, 71],
            [2002, 6411, 91, 68],
            [2002, 6412, 95, 70],
            [2002, 6413, 110, 82],
            [2002, 6414, 105, 70],
            [2002, 6415, 94, 70],
            [2002, 6416, 102, 75],
            [2002, 6417, 102, 75],
            [2002, 6418, 110, 82],
            [2002, 6419, 102, 82],
            [2002, 6420, 110, 82],
            [2002, 6421, 95, 70],
            [2002, 6422, 94, 71],
            [2002, 6423, 31, 30],
            [2002, 6424, 64, 63],
            [2002, 6425, 64, 57],
            [2002, 6426, 95, 79],
            [2002, 6427, 110, 82],
            [2002, 6428, 105, 79],
            [2002, 6429, 110, 81],
            [2002, 6430, 59, 63],
            [2002, 6431, 94, 71],
            [2002, 6432, 95, 79],
            [2002, 6433, 53, 56],
            [2002, 6434, 94, 70],
            [2002, 6435, 63, 55],
            [2002, 6436, 105, 70],
            [2002, 6437, 102, 75],
            [2002, 6438, 95, 70],
            [2002, 6439, 95, 70],
            [2002, 6440, 105, 79],
            [2002, 6441, 91, 68],
            [2002, 6442, 58, 56],
            [2002, 6443, 95, 70],
            [2002, 6444, 73, 80],
            [2002, 6445, 95, 70],
            [2002, 6446, 102, 75],
            [2002, 6447, 58, 43],
            [2002, 6448, 95, 70],
            [2002, 6449, 102, 82],
            [2002, 6450, 105, 79],
            [2002, 6451, 102, 82],
            [2002, 6452, 105, 70],
            [2002, 6453, 95, 70],
            [2002, 6454, 95, 70],
            [2002, 6455, 95, 70],
            [2002, 6456, 95, 70],
            [2002, 6457, 34, 37],
            [2002, 6458, 26, 30],
            [2002, 6459, 110, 75],
            [2002, 6460, 105, 79],
            [2002, 6461, 95, 70],
            [2002, 6462, 94, 78],
            [2002, 6463, 94, 78],
            [2002, 6464, 110, 82],
            [2002, 6465, 102, 82],
            [2002, 6466, 94, 70],
            [2002, 6467, 105, 79],
            [2002, 6468, 102, 75],
            [2002, 6469, 95, 70],
            [2002, 6470, 94, 71],
            [2002, 6471, 95, 70],
            [2002, 6472, 102, 75],
            [2002, 6473, 102, 75],
            [2002, 6474, 95, 70],
            [2002, 6475, 95, 70],
            [2002, 6476, 95, 70],
            [2002, 6477, 111, 83],
            [2002, 6478, 95, 70],
            [2002, 6479, 95, 70],
            [2002, 6480, 95, 70],
            [2002, 6481, 102, 75],
            [2002, 6482, 102, 82],
            [2002, 6483, 95, 70],
            [2002, 6484, 64, 47],
            [2002, 6485, 91, 71],
            [2002, 6486, 102, 75],
            [2002, 6487, 94, 71],
            [2002, 6488, 94, 71],
            [2002, 6489, 94, 70],
            [2002, 6490, 95, 70],
            [2002, 6491, 95, 70],
            [2002, 6492, 28, 30],
            [2002, 6493, 94, 71],
            [2002, 6494, 28, 29],
            [2002, 6495, 91, 68],
            [2002, 6496, 94, 71],
            [2002, 6497, 110, 82],
            [2002, 6498, 110, 82],
            [2002, 6499, 105, 78],
            [2002, 6500, 64, 57],
            [2002, 6501, 94, 71],
            [2002, 6502, 57, 57],
            [2002, 6503, 95, 70],
            [2002, 6504, 94, 80],
            [2002, 6505, 95, 70],
            [2002, 6506, 95, 79],
            [2002, 6507, 102, 75],
            [2002, 6508, 102, 75],
            [2002, 6509, 94, 71],
            [2002, 6510, 110, 82],
            [2002, 6511, 94, 71],
            [2002, 6512, 94, 71],
            [2002, 6513, 24, 22],
            [2002, 6514, 93, 69],
            [2002, 6515, 95, 78],
            [2002, 6516, 64, 53],
            [2002, 6517, 32, 29],
            [2002, 6518, 95, 79],
            [2002, 6519, 105, 79],
            [2002, 6520, 110, 82],
            [2002, 6521, 49, 48],
            [2002, 6522, 95, 70],
            [2002, 6523, 110, 82],
            [2002, 6524, 105, 79],
            [2002, 6525, 94, 71],
            [2002, 6526, 102, 75],
            [2002, 6527, 94, 71],
            [2002, 6528, 95, 70],
            [2002, 6529, 105, 80],
            [2002, 6530, 92, 68],
            [2002, 6531, 102, 82],
            [2002, 6532, 95, 70],
            [2002, 6533, 95, 70],
            [2002, 6534, 95, 79],
            [2002, 6535, 102, 75],
            [2002, 6536, 32, 33],
            [2002, 6537, 102, 75],
            [2002, 6538, 102, 82],
            [2002, 6539, 95, 70],
            [2002, 6540, 102, 82],
            [2002, 6541, 102, 75],
            [2002, 6542, 102, 75],
            [2002, 6543, 102, 75],
            [2002, 6544, 102, 75],
            [2002, 6546, 102, 75],
            [2002, 6547, 110, 82],
            [2002, 6548, 102, 75],
            [2002, 6549, 102, 82],
            [2002, 6550, 102, 75],
            [2002, 6551, 102, 75],
            [2002, 6552, 102, 82],
            [2002, 6553, 102, 75],
            [2002, 6554, 102, 75],
            [2002, 6555, 102, 75],
            [2002, 6556, 102, 75],
            [2002, 6557, 102, 75],
            [2002, 6558, 95, 70],
            [2002, 6559, 102, 75],
            [2002, 6560, 95, 70],
            [2002, 6561, 102, 82],
            [2002, 6562, 102, 75],
            [2002, 6563, 102, 75],
            [2002, 6564, 102, 75],
            [2002, 6565, 105, 80],
            [2002, 6566, 95, 63],
            [2002, 6567, 102, 75],
            [2002, 6568, 94, 71],
            [2002, 6569, 94, 71],
            [2002, 6570, 102, 75],
            [2002, 6572, 102, 75],
            [2002, 6573, 94, 71],
            [2002, 6574, 95, 70],
            [2002, 6575, 94, 70],
            [2002, 6576, 95, 70],
            [2002, 6577, 94, 71],
            [2002, 6578, 95, 70],
            [2002, 6579, 102, 75],
            [2002, 6580, 94, 71],
            [2002, 6581, 105, 79],
            [2002, 6582, 95, 70],
            [2002, 6583, 105, 78],
            [2002, 6584, 111, 83],
            [2002, 6585, 94, 71],
            [2002, 6586, 94, 71],
            [2002, 6587, 94, 71],
            [2002, 6588, 94, 70],
            [2002, 6589, 94, 70],
            [2002, 6590, 111, 83],
            [2002, 6591, 102, 75],
            [2002, 6592, 102, 75],
            [2002, 6593, 102, 75],
            [2002, 6594, 102, 75],
            [2002, 6595, 95, 70],
            [2002, 6596, 95, 70],
            [2002, 6597, 102, 75],
            [2002, 6598, 102, 75],
            [2002, 6599, 105, 79],
            [2002, 6600, 95, 70],
            [2002, 6601, 102, 75],
            [2002, 6602, 95, 70],
            [2002, 6603, 59, 57],
            [2002, 6604, 102, 82],
            [2002, 6605, 95, 70],
            [2002, 6606, 94, 71],
            [2002, 6607, 105, 70],
            [2002, 6608, 95, 70],
            [2002, 6609, 95, 70],
            [2002, 6610, 95, 70],
            [2002, 6611, 59, 57],
            [2002, 6612, 95, 79],
            [2002, 6613, 95, 70],
            [2002, 6614, 32, 33],
            [2002, 6615, 94, 71],
            [2002, 6616, 95, 70],
            [2002, 6617, 35, 31],
            [2002, 6618, 94, 71],
            [2002, 6619, 102, 75],
            [2002, 6620, 102, 75],
            [2002, 6621, 95, 70],
            [2002, 6622, 94, 71],
            [2002, 6623, 105, 79],
            [2002, 6624, 110, 75],
            [2002, 6625, 102, 75],
            [2002, 6626, 110, 82],
            [2002, 6627, 95, 70],
            [2002, 6628, 102, 82],
            [2002, 6629, 59, 63],
            [2002, 6630, 63, 63],
            [2002, 6631, 53, 60],
            [2002, 6632, 24, 28],
            [2002, 6633, 33, 37],
            [2002, 6634, 41, 39],
            [2002, 6635, 46, 43],
            [2002, 6636, 70, 65],
            [2002, 6637, 54, 39],
            [2002, 6638, 62, 48],
            [2002, 6639, 46, 53],
            [2002, 6640, 61, 67],
            [2002, 6643, 40, 38],
            [2002, 6649, 54, 41],
            [2002, 6650, 54, 39],
            [2002, 6651, 37, 27],
            [2002, 6652, 52, 40],
            [2002, 6653, 50, 46],
            [2002, 6654, 36, 36],
            [2002, 6655, 33, 31],
            [2002, 6656, 40, 36],
            [2002, 6657, 46, 43],
            [2002, 6660, 41, 29],
            [2002, 6661, 32, 32],
            [2002, 6662, 46, 40],
            [2002, 6663, 36, 36],
            [2002, 6664, 44, 42],
            [2002, 6665, 36, 36],
            [2002, 6666, 36, 32],
            [2002, 6667, 36, 36],
            [2002, 6668, 36, 27],
            [2002, 6669, 45, 42],
            [2002, 6670, 37, 36],
            [2002, 6671, 52, 36],
            [2002, 6672, 41, 31],
            [2002, 6673, 42, 35],
            [2002, 6674, 40, 40],
            [2002, 6675, 37, 36],
            [2002, 6676, 53, 51],
            [2002, 6677, 36, 36],
            [2002, 6678, 37, 36],
            [2002, 6679, 85, 80],
            [2002, 6680, 33, 31],
            [2002, 6682, 32, 32],
            [2002, 6683, 36, 36],
            [2002, 6684, 33, 42],
            [2002, 6685, 28, 32],
            [2002, 6686, 27, 32],
            [2002, 6687, 28, 33],
            [2002, 6688, 27, 32],
            [2002, 6689, 28, 33],
            [2002, 6690, 27, 32],
            [2002, 6697, 38, 29],
            [2002, 6699, 62, 53],
            [2002, 6700, 73, 66],
            [2002, 6701, 64, 78],
            [2002, 6702, 65, 43],
            [2002, 6704, 50, 42],
            [2002, 6706, 43, 41],
            [2002, 6708, 58, 56],
            [2002, 6715, 62, 51],
            [2002, 6716, 79, 52],
            [2002, 6718, 85, 64],
            [2002, 6722, 64, 52],
            [2002, 6723, 61, 46],
            [2002, 6725, 45, 45],
            [2002, 6726, 89, 60],
            [2002, 6728, 52, 50],
            [2002, 6730, 45, 45],
            [2002, 6734, 60, 45],
            [2002, 6737, 64, 54],
            [2002, 6738, 50, 49],
            [2002, 6741, 17, 19],
            [2002, 6748, 32, 32],
            [2002, 6749, 35, 35],
            [2002, 6750, 52, 51],
            [2002, 6752, 27, 32],
            [2002, 6753, 44, 40],
            [2002, 6754, 41, 39],
            [2002, 6755, 52, 52],
            [2002, 6756, 44, 44],
            [2002, 6757, 39, 39],
            [2002, 6758, 44, 55],
            [2002, 6759, 27, 32],
            [2002, 6760, 52, 52],
            [2002, 6761, 52, 51],
            [2002, 6762, 44, 44],
            [2002, 6763, 29, 27],
            [2002, 6764, 40, 44],
            [2002, 6766, 62, 60],
            [2002, 6767, 38, 38],
            [2002, 6768, 40, 40],
            [2002, 6769, 52, 65],
            [2002, 6770, 45, 51],
            [2002, 6771, 45, 47],
            [2002, 6772, 35, 44],
            [2002, 6773, 60, 55],
            [2002, 6777, 60, 58],
            [2002, 6778, 36, 36],
            [2002, 6779, 45, 51],
            [2002, 6780, 45, 48],
            [2002, 6781, 53, 51],
            [2002, 6782, 85, 72],
            [2002, 6783, 61, 59],
            [2002, 6784, 44, 44],
            [2002, 6785, 45, 44],
            [2002, 6786, 45, 51],
            [2002, 6787, 40, 49],
            [2002, 6789, 52, 51],
            [2002, 6790, 89, 67],
            [2002, 6791, 76, 53],
            [2002, 6794, 87, 66],
            [2002, 6795, 66, 58],
            [2002, 6798, 79, 56],
            [2002, 6803, 68, 59],
            [2002, 6804, 66, 58],
            [2002, 6805, 92, 70],
            [2002, 6806, 66, 59],
            [2002, 6807, 85, 59],
            [2002, 6808, 91, 69],
            [2002, 6812, 97, 84],
            [2002, 6813, 85, 65],
            [2002, 6814, 77, 71],
            [2002, 6816, 80, 66],
            [2002, 6818, 20, 22],
            [2002, 6819, 38, 46],
            [2002, 6820, 36, 40],
            [2002, 6821, 45, 48],
            [2002, 6822, 51, 51],
            [2002, 6823, 44, 46],
            [2002, 6833, 72, 58],
            [2002, 6834, 90, 75],
            [2002, 6835, 98, 75],
            [2002, 6836, 88, 69],
            [2002, 6837, 89, 68],
            [2002, 6838, 102, 78],
            [2002, 6841, 36, 27],
            [2002, 6845, 89, 67],
            [2002, 6846, 102, 88],
            [2002, 6847, 87, 66],
            [2002, 6848, 91, 70],
            [2002, 6849, 62, 59],
            [2002, 6850, 89, 67],
            [2002, 6851, 87, 66],
            [2002, 6852, 92, 70],
            [2002, 6853, 94, 71],
            [2002, 6854, 85, 70],
            [2002, 6855, 89, 68],
            [2002, 6856, 88, 67],
            [2002, 6857, 90, 75],
            [2002, 6858, 98, 74],
            [2002, 6859, 71, 56],
            [2002, 6860, 88, 67],
            [2002, 6861, 94, 78],
            [2002, 6862, 92, 70],
            [2002, 6867, 12, 20],
            [2002, 6868, 12, 16],
            [2002, 6869, 15, 17],
            [2002, 6870, 15, 20],
            [2002, 6871, 15, 18],
            [2002, 6872, 12, 18],
            [2002, 6873, 20, 20],
            [2002, 6874, 16, 20],
            [2002, 6875, 16, 19],
            [2002, 6876, 15, 20],
            [2002, 6877, 18, 20],
            [2002, 6878, 15, 18],
            [2002, 6879, 15, 20],
            [2002, 6880, 20, 25],
            [2002, 6881, 15, 15],
            [2002, 6882, 16, 20],
            [2002, 6883, 15, 21],
            [2002, 6884, 7, 8],
            [2002, 6885, 25, 16],
            [2002, 6886, 11, 16],
            [2002, 6887, 116, 39],
            [2002, 6888, 11, 12],
            [2002, 6889, 21, 14],
            [2002, 6890, 8, 10],
            [2002, 6891, 18, 17],
            [2002, 6892, 9, 10],
            [2002, 6893, 22, 15],
            [2002, 6894, 7, 9],
            [2002, 6895, 28, 16],
            [2002, 6896, 9, 11],
            [2002, 6897, 16, 15],
            [2002, 6898, 6, 8],
            [2002, 6899, 28, 14],
            [2002, 6900, 6, 7],
            [2002, 6901, 24, 16],
            [2002, 6902, 10, 15],
            [2002, 6903, 34, 23],
            [2002, 6904, 11, 11],
            [2002, 6905, 42, 25],
            [2002, 6906, 8, 9],
            [2002, 6907, 25, 16],
            [2002, 6908, 8, 8],
            [2002, 6909, 24, 18],
            [2002, 6910, 34, 30],
            [2002, 6911, 63, 43],
            [2002, 6912, 38, 24],
            [2002, 6913, 66, 41],
            [2002, 6914, 13, 12],
            [2002, 6915, 42, 39],
            [2002, 6916, 11, 12],
            [2002, 6917, 30, 34],
            [2002, 6918, 30, 23],
            [2002, 6919, 30, 29],
            [2002, 6920, 29, 23],
            [2002, 6921, 52, 38],
            [2002, 6922, 14, 13],
            [2002, 6923, 57, 41],
            [2002, 6924, 11, 12],
            [2002, 6925, 44, 42],
            [2002, 6926, 67, 29],
            [2002, 6927, 71, 39],
            [2002, 6928, 21, 20],
            [2002, 6929, 58, 42],
            [2002, 6930, 22, 15],
            [2002, 6931, 42, 42],
            [2002, 6932, 21, 14],
            [2002, 6933, 30, 28],
            [2002, 6934, 20, 15],
            [2002, 6935, 49, 51],
            [2002, 6936, 24, 22],
            [2002, 6937, 52, 42],
            [2002, 6938, 21, 15],
            [2002, 6939, 53, 40],
            [2002, 6940, 13, 11],
            [2002, 6941, 31, 24],
            [2002, 6942, 33, 29],
            [2002, 6943, 62, 41],
            [2002, 6944, 12, 12],
            [2002, 6945, 74, 57],
            [2002, 6946, 63, 35],
            [2002, 6947, 70, 51],
            [2002, 6948, 15, 13],
            [2002, 6949, 52, 39],
            [2002, 6950, 17, 15],
            [2002, 6951, 57, 42],
            [2002, 6952, 62, 27],
            [2002, 6953, 67, 39],
            [2002, 6954, 30, 17],
            [2002, 6955, 52, 39],
            [2002, 6956, 19, 16],
            [2002, 6957, 77, 65],
            [2002, 6958, 15, 12],
            [2002, 6959, 52, 42],
            [2002, 6960, 12, 11],
            [2002, 6961, 30, 27],
            [2002, 6962, 13, 12],
            [2002, 6963, 12, 10],
            [2002, 6964, 27, 17],
            [2002, 6965, 9, 10],
            [2002, 6966, 29, 60],
            [2002, 6967, 23, 60],
            [2002, 6968, 41, 85],
            [2002, 6969, 23, 53],
            [2002, 6970, 31, 63],
            [2002, 6971, 36, 28],
            [2002, 6972, 73, 34],
            [2002, 6973, 23, 12],
            [2002, 6974, 6, 7],
            [2002, 6975, 9, 10],
            [2002, 6976, 21, 17],
            [2002, 6977, 7, 8],
            [2002, 6978, 51, 21],
            [2002, 6979, 7, 9],
            [2002, 6980, 19, 15],
            [2002, 6981, 9, 9],
            [2002, 6982, 28, 16],
            [2002, 6983, 12, 13],
            [2002, 6984, 33, 24],
            [2002, 6985, 56, 31],
            [2002, 6986, 112, 47],
            [2002, 6987, 9, 9],
            [2002, 6988, 26, 12],
            [2002, 6989, 14, 14],
            [2002, 6990, 30, 22],
            [2002, 6991, 7, 5],
            [2002, 6992, 23, 13],
            [2002, 6993, 8, 8],
            [2002, 6994, 58, 26],
            [2002, 6995, 11, 10],
            [2002, 6996, 21, 16],
            [2002, 6997, 7, 6],
            [2002, 6998, 15, 8],
            [2002, 6999, 7, 7],
            [2002, 7000, 21, 15],
            [2002, 7001, 7, 7],
            [2002, 7002, 18, 13],
            [2002, 7003, 8, 8],
            [2002, 7004, 18, 14],
            [2002, 7005, 14, 15],
            [2002, 7006, 29, 24],
            [2002, 7007, 40, 31],
            [2002, 7008, 40, 30],
            [2002, 7009, 21, 15],
            [2002, 7010, 20, 15],
            [2002, 7011, 10, 10],
            [2002, 7012, 23, 22],
            [2002, 7013, 29, 20],
            [2002, 7014, 13, 10],
            [2002, 7015, 12, 9],
            [2002, 7019, 11, 10],
            [2002, 7020, 42, 42],
            [2002, 7021, 13, 12],
            [2002, 7022, 23, 22],
            [2002, 7023, 18, 18],
            [2002, 7024, 29, 28],
            [2002, 7025, 15, 13],
            [2002, 7026, 29, 23],
            [2002, 7027, 20, 20],
            [2002, 7028, 42, 42],
            [2002, 7029, 42, 30],
            [2002, 7030, 58, 42],
            [2002, 7031, 15, 13],
            [2002, 7032, 31, 23],
            [2002, 7033, 24, 23],
            [2002, 7034, 37, 31],
            [2002, 7035, 11, 12],
            [2002, 7036, 31, 31],
            [2002, 7037, 29, 30],
            [2002, 7038, 38, 40],
            [2002, 7039, 24, 14],
            [2002, 7040, 31, 29],
            [2002, 7041, 15, 13],
            [2002, 7042, 58, 55],
            [2002, 7043, 21, 29],
            [2002, 7044, 29, 28],
            [2002, 7045, 38, 24],
            [2002, 7046, 56, 40],
            [2002, 7047, 19, 15],
            [2002, 7048, 29, 24],
            [2002, 7049, 54, 40],
            [2002, 7050, 21, 16],
            [2002, 7051, 59, 43],
            [2002, 7052, 16, 15],
            [2002, 7053, 54, 43],
            [2002, 7054, 18, 15],
            [2002, 7055, 41, 29],
            [2002, 7056, 14, 15],
            [2002, 7057, 64, 43],
            [2002, 7058, 30, 19],
            [2002, 7059, 59, 43],
            [2002, 7060, 30, 20],
            [2002, 7061, 54, 43],
            [2002, 7062, 19, 14],
            [2002, 7063, 50, 24],
            [2002, 7064, 30, 15],
            [2002, 7065, 44, 43],
            [2002, 7066, 13, 13],
            [2002, 7067, 55, 43],
            [2002, 7068, 42, 33],
            [2002, 7069, 72, 59],
            [2002, 7070, 30, 21],
            [2002, 7071, 59, 42],
            [2002, 7072, 11, 12],
            [2002, 7073, 30, 30],
            [2002, 7074, 26, 21],
            [2002, 7075, 56, 59],
            [2002, 7076, 30, 24],
            [2002, 7077, 41, 28],
            [2002, 7078, 11, 12],
            [2002, 7079, 30, 24],
            [2002, 7080, 44, 38],
            [2002, 7081, 74, 58],
            [2002, 7082, 29, 24],
            [2002, 7083, 44, 42],
            [2002, 7084, 61, 23],
            [2002, 7085, 66, 42],
            [2002, 7086, 13, 12],
            [2002, 7087, 45, 39],
            [2002, 7088, 29, 26],
            [2002, 7089, 58, 42],
            [2002, 7090, 20, 12],
            [2002, 7091, 57, 42],
            [2002, 7092, 56, 25],
            [2002, 7093, 74, 63],
            [2002, 7094, 40, 29],
            [2002, 7095, 60, 42],
            [2002, 7096, 30, 24],
            [2002, 7097, 42, 29],
            [2002, 7098, 29, 28],
            [2002, 7099, 55, 43],
            [2002, 7100, 15, 13],
            [2002, 7101, 21, 19],
            [2002, 7102, 14, 11],
            [2002, 7103, 34, 18],
            [2002, 7104, 10, 7],
            [2002, 7105, 22, 13],
            [2002, 7106, 5, 7],
            [2002, 7107, 22, 12],
            [2002, 7108, 11, 9],
            [2002, 7109, 28, 15],
            [2002, 7110, 9, 11],
            [2002, 7111, 27, 14],
            [2002, 7112, 5, 5],
            [2002, 7113, 32, 14],
            [2002, 7114, 27, 20],
            [2002, 7115, 48, 26],
            [2002, 7116, 10, 11],
            [2002, 7117, 34, 22],
            [2002, 7118, 8, 15],
            [2002, 7119, 17, 15],
            [2002, 7120, 11, 13],
            [2002, 7121, 39, 35],
            [2002, 7122, 9, 8],
            [2002, 7123, 28, 16],
            [2002, 7124, 7, 10],
            [2002, 7125, 16, 16],
            [2002, 7126, 8, 7],
            [2002, 7127, 20, 16],
            [2002, 7128, 9, 8],
            [2002, 7129, 21, 14],
            [2002, 7130, 8, 9],
            [2002, 7131, 23, 14],
            [2002, 7132, 8, 8],
            [2002, 7133, 33, 20],
            [2002, 7134, 17, 11],
            [2002, 7135, 25, 11],
            [2002, 7136, 17, 13],
            [2002, 7137, 33, 19],
            [2002, 7138, 9, 9],
            [2002, 7139, 24, 18],
            [2002, 7140, 6, 7],
            [2002, 7141, 14, 12],
            [2002, 7142, 9, 10],
            [2002, 7143, 25, 14],
            [2002, 7144, 9, 9],
            [2002, 7145, 18, 14],
            [2002, 7146, 10, 11],
            [2002, 7147, 27, 20],
            [2002, 7148, 8, 11],
            [2002, 7149, 35, 21],
            [2002, 7150, 5, 8],
            [2002, 7151, 18, 14],
            [2002, 7152, 8, 8],
            [2002, 7153, 27, 21],
            [2002, 7154, 17, 19],
            [2002, 7155, 25, 24],
            [2002, 7156, 19, 19],
            [2002, 7157, 9, 8],
            [2002, 7158, 42, 23],
            [2002, 7159, 19, 14],
            [2002, 7160, 48, 31],
            [2002, 7161, 9, 11],
            [2002, 7162, 26, 21],
            [2002, 7163, 8, 7],
            [2002, 7164, 21, 13],
            [2002, 7165, 12, 11],
            [2002, 7166, 56, 31],
            [2002, 7167, 7, 7],
            [2002, 7168, 27, 18],
            [2002, 7169, 5, 5],
            [2002, 7170, 36, 22],
            [2002, 7171, 6, 7],
            [2002, 7172, 40, 25],
            [2002, 7173, 14, 13],
            [2002, 7174, 67, 41],
            [2002, 7175, 6, 5],
            [2002, 7176, 17, 13],
            [2002, 7177, 15, 9],
            [2002, 7178, 23, 13],
            [2002, 7179, 15, 14],
            [2002, 7180, 49, 30],
            [2002, 7181, 10, 10],
            [2002, 7182, 40, 19],
            [2002, 7183, 18, 11],
            [2002, 7184, 88, 59],
            [2002, 7185, 17, 14],
            [2002, 7186, 50, 26],
            [2002, 7187, 13, 10],
            [2002, 7188, 47, 25],
            [2002, 7189, 16, 15],
            [2002, 7190, 44, 26],
            [2002, 7191, 16, 13],
            [2002, 7192, 26, 16],
            [2002, 7193, 14, 13],
            [2002, 7194, 21, 12],
            [2002, 7195, 14, 12],
            [2002, 7196, 40, 23],
            [2002, 7197, 8, 6],
            [2002, 7198, 21, 11],
            [2002, 7199, 14, 11],
            [2002, 7200, 32, 17],
            [2002, 7201, 6, 5],
            [2002, 7202, 14, 9],
            [2002, 7203, 10, 7],
            [2002, 7204, 18, 16],
            [2002, 7205, 18, 16],
            [2002, 7206, 54, 31],
            [2002, 7207, 14, 14],
            [2002, 7208, 40, 25],
            [2002, 7209, 16, 10],
            [2002, 7210, 49, 39],
            [2002, 7211, 9, 10],
            [2002, 7212, 27, 16],
            [2002, 7213, 8, 8],
            [2002, 7214, 66, 34],
            [2002, 7215, 8, 6],
            [2002, 7216, 54, 27],
            [2002, 7217, 12, 10],
            [2002, 7218, 30, 20],
            [2002, 7219, 16, 16],
            [2002, 7220, 35, 23],
            [2002, 7221, 14, 11],
            [2002, 7222, 32, 23],
            [2002, 7223, 12, 11],
            [2002, 7224, 40, 21],
            [2002, 7225, 7, 8],
            [2002, 7226, 27, 17],
            [2002, 7227, 10, 11],
            [2002, 7228, 30, 22],
            [2002, 7229, 13, 9],
            [2002, 7230, 59, 29],
            [2002, 7231, 10, 9],
            [2002, 7232, 30, 19],
            [2002, 7233, 8, 6],
            [2002, 7234, 26, 16],
            [2002, 7235, 12, 10],
            [2002, 7236, 21, 16],
            [2002, 7237, 7, 7],
            [2002, 7238, 21, 14],
            [2002, 7239, 8, 8],
            [2002, 7240, 19, 13],
            [2002, 7241, 20, 20],
            [2002, 7242, 27, 15],
            [2002, 7243, 5, 6],
            [2002, 7244, 18, 12],
            [2002, 7245, 5, 7],
            [2002, 7246, 26, 15],
            [2002, 7247, 7, 8],
            [2002, 7248, 25, 17],
            [2002, 7249, 7, 8],
            [2002, 7250, 24, 15],
            [2002, 7251, 17, 19],
            [2002, 7252, 29, 23],
            [2002, 7253, 14, 10],
            [2002, 7254, 57, 17],
            [2002, 7255, 47, 24],
            [2002, 7256, 24, 16],
            [2002, 7257, 111, 83],
            [2002, 7258, 111, 83],
            [2002, 7259, 96, 60],
            [2002, 7260, 118, 91],
            [2002, 7261, 96, 82],
            [2002, 7262, 99, 112],
            [2002, 7263, 103, 89],
            [2002, 7264, 109, 123],
            [2002, 7265, 98, 85],
            [2002, 7266, 121, 91],
            [2002, 7267, 97, 83],
            [2002, 7268, 121, 91],
            [2002, 7269, 121, 91],
            [2002, 7270, 94, 59],
            [2002, 7271, 68, 66],
            [2002, 7272, 118, 89],
            [2002, 7273, 110, 124],
            [2002, 7274, 117, 88],
            [2002, 7275, 101, 88],
            [2002, 7276, 65, 59],
            [2002, 7277, 97, 83],
            [2002, 7278, 100, 113],
            [2002, 7279, 110, 81],
            [2002, 7280, 121, 92],
            [2002, 7281, 96, 82],
            [2002, 7282, 98, 111],
            [2002, 7283, 14, 23],
            [2002, 7284, 11, 10],
            [2002, 7285, 12, 11],
            [2002, 7286, 18, 27],
            [2002, 7287, 16, 31],
            [2002, 7288, 34, 36],
            [2002, 7289, 36, 27],
            [2002, 7290, 60, 39],
            [2002, 7291, 45, 37],
            [2002, 7292, 43, 45],
            [2002, 7293, 29, 27],
            [2002, 7294, 28, 27],
            [2002, 7295, 14, 13],
            [2002, 7296, 25, 22],
            [2002, 7297, 27, 23],
            [2002, 7298, 16, 19],
            [2002, 7299, 16, 21],
            [2002, 7300, 20, 32],
            [2002, 7301, 13, 28],
            [2002, 7302, 49, 56],
            [2002, 7303, 81, 78],
            [2002, 7304, 38, 42],
            [2002, 7305, 51, 52],
            [2002, 7306, 35, 41],
            [2002, 7307, 53, 59],
            [2002, 7308, 43, 49],
            [2002, 7309, 38, 44],
            [2002, 7310, 85, 73],
            [2002, 7311, 70, 69],
            [2002, 7312, 49, 52],
            [2002, 7313, 109, 80],
            [2002, 7314, 98, 74],
            [2002, 7315, 95, 72],
            [2002, 7316, 99, 74],
            [2002, 7317, 100, 75],
            [2002, 7318, 98, 75],
            [2002, 7319, 112, 83],
            [2002, 7320, 97, 73],
            [2002, 7321, 126, 94],
            [2002, 7322, 98, 73],
            [2002, 7323, 121, 91],
            [2002, 7324, 109, 80],
            [2002, 7325, 100, 75],
            [2002, 7326, 99, 74],
            [2002, 7327, 122, 91],
            [2002, 7328, 36, 42],
            [2002, 7329, 66, 63],
            [2002, 7330, 45, 45],
            [2002, 7331, 45, 45],
            [2002, 7332, 35, 40],
            [2002, 7333, 67, 82],
            [2002, 7337, 15, 15],
            [2002, 7342, 13, 8],
            [2002, 7343, 13, 9],
            [2002, 7344, 12, 9],
            [2002, 7348, 12, 8],
            [2002, 7352, 11, 9],
            [2002, 7354, 14, 13],
            [2002, 7356, 11, 8],
            [2002, 7357, 21, 11],
            [2002, 7358, 15, 11],
            [2002, 7359, 25, 12],
            [2002, 7360, 13, 10],
            [2002, 7362, 11, 9],
            [2002, 7363, 12, 12],
            [2002, 7364, 12, 12],
            [2002, 7367, 13, 8],
            [2002, 7370, 12, 11],
            [2002, 7371, 16, 12],
            [2002, 7372, 18, 10],
            [2002, 7373, 15, 11],
            [2002, 7374, 11, 8],
            [2002, 7375, 12, 8],
            [2002, 7376, 9, 8],
            [2002, 7377, 11, 8],
            [2002, 7378, 20, 19],
            [2002, 7379, 34, 26],
            [2002, 7396, 44, 44],
            [2002, 7397, 73, 58],
            [2002, 7398, 44, 45],
            [2002, 7399, 34, 39],
            [2002, 7400, 56, 54],
            [2002, 7401, 34, 40],
            [2002, 7402, 69, 85],
            [2002, 7403, 28, 34],
            [2002, 7404, 82, 63],
            [2002, 7405, 43, 44],
            [2002, 7406, 62, 74],
            [2002, 7407, 45, 44],
            [2002, 7408, 56, 67],
            [2002, 7409, 22, 27],
            [2002, 7410, 24, 29],
            [2002, 7411, 24, 29],
            [2002, 7412, 48, 51],
            [2002, 7413, 22, 28],
            [2002, 7414, 22, 27],
            [2002, 7415, 21, 31],
            [2002, 7416, 28, 35],
            [2002, 7417, 23, 29],
            [2002, 7418, 26, 28],
            [2002, 7419, 54, 58],
            [2002, 7420, 22, 29],
            [2002, 7421, 40, 47],
            [2002, 7422, 22, 27],
            [2002, 7423, 33, 35],
            [2002, 7424, 56, 50],
            [2002, 7425, 38, 34],
            [2002, 7426, 63, 56],
            [2002, 7427, 49, 46],
            [2002, 7428, 52, 51],
            [2002, 7429, 30, 33],
            [2002, 7430, 48, 37],
            [2002, 7431, 34, 36],
            [2002, 7432, 79, 60],
            [2002, 7433, 50, 48],
            [2002, 7434, 84, 54],
            [2002, 7435, 58, 53],
            [2002, 7436, 67, 61],
            [2002, 7437, 29, 37],
            [2002, 7438, 52, 50],
            [2002, 7439, 44, 41],
            [2002, 7440, 71, 62],
            [2002, 7441, 41, 38],
            [2002, 7442, 62, 53],
            [2002, 7443, 67, 59],
            [2002, 7444, 77, 63],
            [2002, 7445, 66, 56],
            [2002, 7446, 92, 70],
            [2002, 7447, 39, 39],
            [2002, 7448, 68, 65],
            [2002, 7449, 25, 24],
            [2002, 7450, 25, 28],
            [2002, 7451, 16, 18],
            [2002, 7452, 29, 20],
            [2002, 7453, 70, 35],
            [2002, 7454, 21, 22],
            [2002, 7455, 30, 27],
            [2002, 7456, 91, 68],
            [2002, 7457, 66, 64],
            [2002, 7458, 46, 45],
            [2002, 7459, 66, 64],
            [2002, 7460, 66, 72],
            [2002, 7461, 46, 44],
            [2002, 7462, 55, 53],
            [2002, 7463, 62, 61],
            [2002, 7464, 74, 56],
            [2002, 7465, 70, 53],
            [2002, 7466, 62, 46],
            [2002, 7467, 66, 64],
            [2002, 7468, 54, 53],
            [2002, 7469, 74, 56],
            [2002, 7470, 83, 61],
            [2002, 7471, 103, 76],
            [2002, 7472, 37, 79],
            [2002, 7473, 46, 53],
            [2002, 7474, 66, 64],
            [2002, 7475, 66, 64],
            [2002, 7476, 58, 56],
            [2002, 7477, 51, 49],
            [2002, 7478, 54, 53],
            [2002, 7479, 54, 53],
            [2002, 7480, 66, 55],
            [2002, 7481, 46, 53],
            [2002, 7482, 62, 46],
            [2002, 7483, 66, 64],
            [2002, 7484, 49, 56],
            [2002, 7485, 107, 79],
            [2002, 7486, 86, 64],
            [2002, 7487, 58, 56],
            [2002, 7488, 70, 53],
            [2002, 7489, 78, 51],
            [2002, 7490, 55, 53],
            [2002, 7491, 70, 53],
            [2002, 7492, 86, 64],
            [2002, 7493, 62, 60],
            [2002, 7494, 62, 60],
            [2002, 7495, 66, 64],
            [2002, 7496, 107, 79],
            [2002, 7497, 71, 53],
            [2002, 7498, 46, 53],
            [2002, 7499, 54, 45],
            [2002, 7500, 57, 56],
            [2002, 7501, 74, 56],
            [2002, 7502, 70, 53],
            [2002, 7503, 78, 59],
            [2002, 7504, 74, 55],
            [2002, 7505, 62, 60],
            [2002, 7506, 74, 56],
            [2002, 7507, 59, 56],
            [2002, 7508, 70, 53],
            [2002, 7509, 66, 64],
            [2002, 7510, 66, 64],
            [2002, 7511, 74, 56],
            [2002, 7512, 66, 64],
            [2002, 7513, 70, 53],
            [2002, 7514, 113, 85],
            [2002, 7515, 78, 58],
            [2002, 7516, 66, 64],
            [2002, 7517, 107, 79],
            [2002, 7518, 74, 56],
            [2002, 7519, 62, 60],
            [2002, 7520, 62, 61],
            [2002, 7521, 46, 53],
            [2002, 7522, 83, 61],
            [2002, 7523, 62, 61],
            [2002, 7524, 101, 98],
            [2002, 7525, 66, 64],
            [2002, 7526, 74, 55],
            [2002, 7527, 46, 53],
            [2002, 7528, 91, 68],
            [2002, 7529, 107, 103],
            [2002, 7530, 83, 61],
            [2002, 7531, 49, 56],
            [2002, 7532, 66, 64],
            [2002, 7533, 91, 68],
            [2002, 7534, 107, 103],
            [2002, 7535, 62, 61],
            [2002, 7536, 83, 61],
            [2002, 7537, 82, 61],
            [2002, 7538, 91, 68],
            [2002, 7539, 62, 61],
            [2002, 7540, 91, 68],
            [2002, 7541, 78, 58],
            [2002, 7542, 91, 68],
            [2002, 7543, 78, 58],
            [2002, 7544, 82, 61],
            [2002, 7545, 58, 56],
            [2002, 7546, 71, 53],
            [2002, 7547, 70, 53],
            [2002, 7548, 57, 56],
            [2002, 7549, 66, 64],
            [2002, 7550, 54, 53],
            [2002, 7551, 55, 53],
            [2002, 7552, 55, 53],
            [2002, 7553, 62, 61],
            [2002, 7554, 99, 88],
            [2002, 7555, 91, 72],
            [2002, 7556, 66, 64],
            [2002, 7557, 107, 79],
            [2002, 7558, 46, 45],
            [2002, 7559, 70, 53],
            [2002, 7560, 55, 53],
            [2002, 7561, 107, 79],
            [2002, 7562, 107, 79],
            [2002, 7563, 83, 61],
            [2002, 7564, 78, 58],
            [2002, 7565, 62, 61],
            [2002, 7566, 62, 60],
            [2002, 7567, 66, 64],
            [2002, 7568, 62, 61],
            [2002, 7569, 62, 61],
            [2002, 7570, 62, 60],
            [2002, 7571, 62, 60],
            [2002, 7572, 107, 79],
            [2002, 7573, 66, 56],
            [2002, 7574, 62, 60],
            [2002, 7575, 74, 56],
            [2002, 7576, 74, 56],
            [2002, 7577, 83, 61],
            [2002, 7578, 62, 61],
            [2002, 7579, 83, 61],
            [2002, 7580, 83, 61],
            [2002, 7581, 78, 59],
            [2002, 7582, 78, 68],
            [2002, 7583, 66, 64],
            [2002, 7584, 58, 56],
            [2002, 7585, 58, 57],
            [2002, 7586, 107, 79],
            [2002, 7587, 57, 56],
            [2002, 7588, 62, 61],
            [2002, 7589, 107, 79],
            [2002, 7590, 66, 64],
            [2002, 7591, 70, 53],
            [2002, 7592, 83, 61],
            [2002, 7593, 82, 61],
            [2002, 7594, 62, 60],
            [2002, 7595, 62, 61],
            [2002, 7596, 54, 53],
            [2002, 7597, 62, 61],
            [2002, 7598, 74, 56],
            [2002, 7599, 66, 64],
            [2002, 7600, 66, 64],
            [2002, 7601, 55, 53],
            [2002, 7602, 51, 49],
            [2002, 7603, 66, 64],
            [2002, 7604, 66, 64],
            [2002, 7605, 66, 64],
            [2002, 7606, 66, 56],
            [2002, 7607, 83, 61],
            [2002, 7608, 55, 53],
            [2002, 7609, 66, 64],
            [2002, 7610, 54, 54],
            [2002, 7611, 44, 64],
            [2002, 7612, 66, 61],
            [2002, 7613, 62, 61],
            [2002, 7614, 70, 60],
            [2002, 7615, 83, 61],
            [2002, 7616, 78, 58],
            [2002, 7617, 70, 54],
            [2002, 7618, 78, 58],
            [2002, 7619, 66, 64],
            [2002, 7620, 57, 56],
            [2002, 7621, 66, 64],
            [2002, 7622, 83, 61],
            [2002, 7623, 62, 60],
            [2002, 7624, 91, 68],
            [2002, 7625, 54, 53],
            [2002, 7626, 78, 58],
            [2002, 7627, 59, 56],
            [2002, 7628, 83, 61],
            [2002, 7629, 54, 53],
            [2002, 7630, 58, 56],
            [2002, 7631, 62, 60],
            [2002, 7632, 78, 58],
            [2002, 7633, 54, 53],
            [2002, 7634, 17, 29],
            [2002, 7635, 17, 25],
            [2002, 7636, 20, 28],
            [2002, 7637, 37, 36],
            [2002, 7638, 26, 22],
            [2002, 7639, 13, 15],
            [2002, 7640, 11, 13],
            [2002, 7641, 15, 18],
            [2002, 7642, 35, 41],
            [2002, 7643, 18, 19],
            [2002, 7644, 34, 45],
            [2002, 7645, 18, 24],
            [2002, 7646, 32, 30],
            [2002, 7647, 43, 28],
            [2002, 7648, 12, 13],
            [2002, 7649, 13, 13],
            [2002, 7650, 19, 21],
            [2002, 7651, 15, 13],
            [2002, 7652, 17, 14],
            [2002, 7653, 49, 38],
            [2002, 7654, 14, 16],
            [2002, 7655, 17, 17],
            [2002, 7656, 15, 14],
            [2002, 7657, 30, 31],
            [2002, 7658, 22, 30],
            [2002, 7659, 13, 19],
            [2002, 7661, 10, 10],
            [2002, 7662, 15, 13],
            [2002, 7663, 18, 19],
            [2002, 7664, 26, 37],
            [2002, 7665, 39, 55],
            [2002, 7666, 16, 19],
            [2002, 7667, 16, 19],
            [2002, 7668, 17, 13],
            [2002, 7669, 11, 8],
            [2002, 7670, 31, 25],
            [2002, 7671, 42, 36],
            [2002, 7672, 10, 9],
            [2002, 7673, 8, 7],
            [2002, 7674, 21, 18],
            [2002, 7675, 9, 10],
            [2002, 7676, 6, 7],
            [2002, 7677, 6, 6],
            [2002, 7678, 10, 8],
            [2002, 7679, 13, 10],
            [2002, 7680, 20, 21],
            [2002, 7681, 5, 3],
            [2002, 7682, 16, 13],
            [2002, 7683, 5, 3],
            [2002, 7684, 15, 15],
            [2002, 7685, 12, 11],
            [2002, 7686, 22, 19],
            [2002, 7687, 5, 3],
            [2002, 7688, 16, 15],
            [2002, 7689, 12, 12],
            [2002, 7690, 7, 8],
            [2002, 7691, 21, 25],
            [2002, 7692, 11, 10],
            [2002, 7693, 9, 9],
            [2002, 7694, 10, 9],
            [2002, 7695, 30, 20],
            [2002, 7696, 5, 3],
            [2002, 7697, 16, 12],
            [2002, 7698, 10, 8],
            [2002, 7699, 13, 15],
            [2002, 7700, 11, 10],
            [2002, 7701, 9, 8],
            [2002, 7702, 17, 13],
            [2002, 7703, 13, 14],
            [2002, 7704, 18, 18],
            [2002, 7705, 22, 14],
            [2002, 7706, 11, 10],
            [2002, 7707, 10, 10],
            [2002, 7708, 9, 7],
            [2002, 7709, 12, 15],
            [2002, 7710, 6, 6],
            [2002, 7711, 16, 12],
            [2002, 7712, 13, 10],
            [2002, 7713, 20, 12],
            [2002, 7714, 11, 9],
            [2002, 7715, 38, 45],
            [2002, 7716, 44, 44],
            [2002, 7717, 67, 81],
            [2002, 7718, 45, 45],
            [2002, 7719, 34, 40],
            [2002, 7720, 70, 86],
            [2002, 7721, 46, 45],
            [2002, 7722, 56, 46],
            [2002, 7723, 33, 39],
            [2002, 7724, 64, 77],
            [2002, 7725, 21, 28],
            [2002, 7726, 37, 43],
            [2002, 7727, 48, 47],
            [2002, 7728, 62, 60],
            [2002, 7729, 46, 46],
            [2002, 7730, 33, 38],
            [2002, 7731, 66, 79],
            [2002, 7732, 36, 42],
            [2002, 7733, 57, 67],
            [2002, 7734, 70, 55],
            [2002, 7735, 86, 83],
            [2002, 7736, 34, 40],
            [2002, 7737, 54, 52],
            [2002, 7738, 34, 39],
            [2002, 7739, 42, 53],
            [2002, 7740, 34, 40],
            [2002, 7741, 55, 64],
            [2002, 7742, 59, 62],
            [2002, 7743, 45, 44],
            [2002, 7744, 65, 78],
            [2002, 7745, 67, 52],
            [2002, 7746, 46, 46],
            [2002, 7747, 57, 71],
            [2002, 7748, 58, 56],
            [2002, 7749, 47, 47],
            [2002, 7750, 62, 75],
            [2002, 7751, 71, 56],
            [2002, 7752, 85, 81],
            [2002, 7753, 56, 54],
            [2002, 7754, 47, 47],
            [2002, 7755, 35, 40],
            [2002, 7756, 82, 54],
            [2002, 7757, 63, 54],
            [2002, 7758, 93, 71],
            [2002, 7759, 33, 37],
            [2002, 7760, 61, 61],
            [2002, 7761, 37, 46],
            [2002, 7762, 71, 66],
            [2002, 7763, 17, 25],
            [2002, 7764, 17, 22],
            [2002, 7765, 19, 27],
            [2002, 7766, 11, 20],
            [2002, 7767, 27, 34],
            [2002, 7768, 11, 22],
            [2002, 7769, 39, 37],
            [2002, 7770, 56, 42],
            [2002, 7771, 16, 18],
            [2002, 7772, 15, 19],
            [2002, 7773, 24, 27],
            [2002, 7774, 14, 24],
            [2002, 7775, 41, 40],
            [2002, 7776, 17, 34],
            [2002, 7777, 23, 37],
            [2002, 7778, 9, 13],
            [2002, 7779, 15, 20],
            [2002, 7780, 21, 21],
            [2002, 7781, 27, 31],
            [2002, 7782, 33, 27],
            [2002, 7783, 34, 26],
            [2002, 7784, 14, 32],
            [2002, 7785, 24, 42],
            [2002, 7786, 15, 17],
            [2002, 7787, 25, 31],
            [2002, 7788, 21, 24],
            [2002, 7789, 23, 29],
            [2002, 7790, 22, 29],
            [2002, 7791, 43, 41],
            [2002, 7792, 19, 24],
            [2002, 7793, 36, 36],
            [2002, 7795, 53, 47],
            [2002, 7796, 76, 60],
            [2002, 7797, 53, 49],
            [2002, 7798, 53, 47],
            [2002, 7799, 53, 50],
            [2002, 7800, 52, 51],
            [2002, 7801, 56, 50],
            [2002, 7802, 53, 45],
            [2002, 7803, 57, 54],
            [2002, 7804, 80, 60],
            [2002, 7805, 54, 49],
            [2002, 7806, 56, 49],
            [2002, 7807, 53, 45],
            [2002, 7808, 83, 62],
            [2002, 7809, 82, 61],
            [2002, 7810, 52, 45],
            [2002, 7811, 54, 48],
            [2002, 7812, 53, 47],
            [2002, 7813, 55, 48],
            [2002, 7815, 55, 49],
            [2002, 7816, 54, 46],
            [2002, 7817, 82, 61],
            [2002, 7818, 55, 49],
            [2002, 7819, 55, 48],
            [2002, 7820, 56, 62],
            [2002, 7821, 53, 47],
            [2002, 7822, 82, 64],
            [2002, 7823, 75, 59],
            [2002, 7824, 88, 66],
            [2002, 7825, 54, 47],
            [2002, 7826, 82, 61],
            [2002, 7827, 40, 41],
            [2002, 7828, 54, 48],
            [2002, 7829, 51, 51],
            [2002, 7830, 54, 47],
            [2002, 7831, 54, 51],
            [2002, 7832, 55, 48],
            [2002, 7833, 52, 46],
            [2002, 7834, 41, 42],
            [2002, 7835, 55, 48],
            [2002, 7836, 87, 65],
            [2002, 7837, 54, 47],
            [2002, 7838, 81, 60],
            [2002, 7839, 55, 48],
            [2002, 7840, 82, 61],
            [2002, 7841, 53, 46],
            [2002, 7842, 53, 49],
            [2002, 7843, 53, 47],
            [2002, 7844, 52, 45],
            [2002, 7845, 21, 13],
            [2002, 7846, 55, 48],
            [2002, 7847, 83, 62],
            [2002, 7848, 83, 62],
            [2002, 7849, 89, 66],
            [2002, 7850, 40, 41],
            [2002, 7851, 53, 45],
            [2002, 7852, 35, 38],
            [2002, 7853, 41, 43],
            [2002, 7854, 40, 40],
            [2002, 7855, 40, 41],
            [2002, 7856, 37, 42],
            [2002, 7857, 54, 46],
            [2002, 7858, 53, 48],
            [2002, 7859, 51, 50],
            [2002, 7860, 54, 47],
            [2002, 7861, 50, 43],
            [2002, 7862, 93, 68],
            [2002, 7863, 95, 71],
            [2002, 7864, 53, 49],
            [2002, 7865, 57, 51],
            [2002, 7866, 82, 61],
            [2002, 7867, 55, 48],
            [2002, 7868, 54, 47],
            [2002, 7869, 80, 59],
            [2002, 7870, 54, 47],
            [2002, 7871, 53, 50],
            [2002, 7872, 81, 60],
            [2002, 7873, 53, 46],
            [2002, 7874, 54, 47],
            [2002, 7875, 40, 41],
            [2002, 7876, 53, 46],
            [2002, 7877, 85, 63],
            [2002, 7878, 56, 53],
            [2002, 7879, 53, 49],
            [2002, 7880, 53, 50],
            [2002, 7881, 53, 49],
            [2002, 7882, 39, 34],
            [2002, 7883, 41, 42],
            [2002, 7884, 53, 47],
            [2002, 7885, 52, 49],
            [2002, 7886, 53, 49],
            [2002, 7887, 54, 47],
            [2002, 7888, 54, 47],
            [2002, 7889, 81, 60],
            [2002, 7890, 53, 49],
            [2002, 7891, 40, 41],
            [2002, 7892, 55, 48],
            [2002, 7893, 54, 47],
            [2002, 7894, 56, 49],
            [2002, 7895, 54, 51],
            [2002, 7896, 81, 60],
            [2002, 7897, 84, 63],
            [2002, 7898, 54, 47],
            [2002, 7899, 55, 52],
            [2002, 7900, 81, 60],
            [2002, 7901, 52, 45],
            [2002, 7902, 52, 52],
            [2002, 7903, 81, 60],
            [2002, 7904, 54, 47],
            [2002, 7905, 53, 45],
            [2002, 7906, 54, 48],
            [2002, 7907, 82, 61],
            [2002, 7908, 76, 60],
            [2002, 7909, 54, 49],
            [2002, 7910, 55, 48],
            [2002, 7911, 53, 45],
            [2002, 7912, 55, 48],
            [2002, 7913, 53, 49],
            [2002, 7914, 53, 49],
            [2002, 7915, 81, 60],
            [2002, 7916, 78, 61],
            [2002, 7917, 84, 63],
            [2002, 7918, 53, 46],
            [2002, 7919, 54, 47],
            [2002, 7920, 83, 62],
            [2002, 7921, 54, 47],
            [2002, 7922, 56, 50],
            [2002, 7923, 52, 46],
            [2002, 7924, 54, 47],
            [2002, 7925, 54, 47],
            [2002, 7926, 79, 62],
            [2002, 7927, 55, 48],
            [2002, 7928, 36, 42],
            [2002, 7929, 85, 63],
            [2002, 7930, 53, 46],
            [2002, 7931, 54, 47],
            [2002, 7932, 54, 47],
            [2002, 7933, 40, 43],
            [2002, 7934, 37, 42],
            [2002, 7935, 56, 49],
            [2002, 7936, 55, 48],
            [2002, 7937, 54, 46],
            [2002, 7938, 53, 47],
            [2002, 7939, 81, 63],
            [2002, 7940, 80, 59],
            [2002, 7941, 81, 61],
            [2002, 7942, 53, 50],
            [2002, 7943, 55, 48],
            [2002, 7944, 36, 41],
            [2002, 7945, 81, 60],
            [2002, 7946, 54, 48],
            [2002, 7947, 81, 60],
            [2002, 7948, 41, 42],
            [2002, 7949, 82, 61],
            [2002, 7950, 89, 66],
            [2002, 7951, 52, 46],
            [2002, 7952, 44, 38],
            [2002, 7953, 41, 42],
            [2002, 7954, 55, 48],
            [2002, 7955, 55, 48],
            [2002, 7956, 56, 49],
            [2002, 7957, 77, 61],
            [2002, 7958, 85, 63],
            [2002, 7959, 55, 48],
            [2002, 7960, 48, 48],
            [2002, 7961, 55, 50],
            [2002, 7962, 56, 50],
            [2002, 7963, 40, 41],
            [2002, 7964, 82, 61],
            [2002, 7965, 55, 52],
            [2002, 7966, 52, 48],
            [2002, 7967, 54, 46],
            [2002, 7968, 95, 70],
            [2002, 7969, 81, 61],
            [2002, 7970, 55, 48],
            [2002, 7971, 40, 42],
            [2002, 7972, 53, 46],
            [2002, 7974, 41, 43],
            [2002, 7975, 55, 48],
            [2002, 7976, 84, 62],
            [2002, 7977, 54, 48],
            [2002, 7978, 81, 60],
            [2002, 7979, 83, 62],
            [2002, 7980, 54, 46],
            [2002, 7981, 82, 61],
            [2002, 7982, 55, 48],
            [2002, 7983, 53, 47],
            [2002, 7984, 83, 62],
            [2002, 7985, 53, 50],
            [2002, 7986, 54, 46],
            [2002, 7987, 53, 50],
            [2002, 7988, 80, 60],
            [2002, 7989, 44, 49],
            [2002, 7990, 54, 41],
            [2002, 7992, 56, 50],
            [2002, 7993, 81, 63],
            [2002, 7994, 52, 46],
            [2002, 7995, 53, 48],
            [2002, 7996, 53, 49],
            [2002, 7997, 55, 48],
            [2002, 7998, 55, 48],
            [2002, 7999, 53, 47],
            [2002, 8000, 40, 42],
            [2002, 8001, 52, 49],
            [2002, 8002, 40, 41],
            [2002, 8003, 37, 42],
            [2002, 8004, 40, 41],
            [2002, 8005, 23, 29],
            [2002, 8006, 16, 21],
            [2002, 8007, 27, 34],
            [2002, 8008, 22, 28],
            [2002, 8009, 18, 19],
            [2002, 8010, 15, 18],
            [2002, 8011, 18, 20],
            [2002, 8012, 13, 16],
            [2002, 8013, 8, 8],
            [2002, 8014, 9, 10],
            [2002, 8015, 11, 11],
            [2002, 8016, 6, 5],
            [2002, 8017, 13, 14],
            [2002, 8018, 7, 8],
            [2002, 8019, 17, 18],
            [2002, 8020, 14, 15],
            [2002, 8021, 7, 7],
            [2002, 8022, 28, 36],
            [2002, 8023, 17, 19],
            [2002, 8024, 23, 20],
            [2002, 8025, 17, 23],
            [2002, 8026, 19, 21],
            [2002, 8027, 13, 11],
            [2002, 8028, 15, 15],
            [2002, 8029, 28, 26],
            [2002, 8030, 18, 17],
            [2002, 8031, 12, 11],
            [2002, 8032, 19, 26],
            [2002, 8033, 27, 30],
            [2002, 8034, 26, 36],
            [2002, 8035, 22, 21],
            [2002, 8036, 18, 23],
            [2002, 8037, 24, 29],
            [2002, 8038, 45, 44],
            [2002, 8039, 36, 66],
            [2002, 8040, 22, 66],
            [2002, 8041, 7, 16],
            [2002, 8042, 7, 10],
            [2002, 8043, 11, 17],
            [2002, 8044, 12, 16],
            [2002, 8045, 5, 3],
            [2002, 8046, 5, 3],
            [2002, 8047, 5, 6],
            [2002, 8048, 16, 21],
            [2002, 8049, 12, 16],
            [2002, 8050, 9, 11],
            [2002, 8051, 21, 24],
            [2002, 8052, 38, 47],
            [2002, 8053, 26, 36],
            [2002, 8054, 22, 32],
            [2002, 8055, 32, 48],
            [2002, 8056, 43, 51],
            [2002, 8057, 25, 34],
            [2002, 8058, 21, 27],
            [2002, 8059, 26, 32],
            [2002, 8060, 29, 35],
            [2002, 8061, 56, 64],
            [2002, 8062, 58, 76],
            [2002, 8063, 12, 9],
            [2002, 8064, 13, 15],
            [2002, 8065, 17, 13],
            [2002, 8066, 79, 50],
            [2002, 8067, 42, 32],
            [2002, 8068, 12, 10],
            [2002, 8069, 13, 28],
            [2002, 8070, 17, 18],
            [2002, 8071, 49, 22],
            [2002, 8072, 40, 24],
            [2002, 8073, 60, 31],
            [2002, 8074, 13, 15],
            [2002, 8075, 14, 18],
            [2002, 8076, 60, 43],
            [2002, 8079, 64, 51],
            [2002, 8080, 83, 25],
            [2002, 8081, 99, 53],
            [2002, 8082, 69, 41],
            [2002, 8083, 106, 45],
            [2002, 8084, 61, 52],
            [2002, 8085, 47, 33],
            [2002, 8086, 17, 48],
            [2002, 8087, 15, 33],
            [2002, 8088, 19, 39],
            [2002, 8089, 23, 51],
            [2002, 8090, 24, 36],
            [2002, 8091, 24, 66],
            [2002, 8092, 22, 50],
            [2002, 8093, 25, 66],
            [2002, 8094, 14, 66],
            [2002, 8095, 22, 28],
            [2002, 8096, 25, 40],
            [2002, 8097, 21, 35],
            [2002, 8098, 9, 27],
            [2002, 8099, 45, 45],
            [2002, 8100, 44, 44],
            [2002, 8101, 45, 45],
            [2002, 8102, 34, 39],
            [2002, 8103, 46, 45],
            [2002, 8104, 45, 44],
            [2002, 8105, 72, 57],
            [2002, 8106, 47, 47],
            [2002, 8107, 34, 40],
            [2002, 8108, 54, 52],
            [2002, 8109, 46, 46],
            [2002, 8110, 34, 40],
            [2002, 8111, 53, 50],
            [2002, 8112, 45, 44],
            [2002, 8113, 72, 57],
            [2002, 8114, 34, 39],
            [2002, 8115, 70, 87],
            [2002, 8116, 47, 47],
            [2002, 8117, 55, 81],
            [2002, 8118, 35, 41],
            [2002, 8119, 46, 46],
            [2002, 8120, 53, 51],
            [2002, 8121, 35, 40],
            [2002, 8122, 45, 45],
            [2002, 8123, 73, 58],
            [2002, 8124, 46, 47],
            [2002, 8125, 73, 58],
            [2002, 8126, 41, 42],
            [2002, 8127, 47, 47],
            [2002, 8128, 90, 87],
            [2002, 8129, 45, 45],
            [2002, 8130, 73, 57],
            [2002, 8131, 33, 39],
            [2002, 8132, 55, 52],
            [2002, 8133, 35, 41],
            [2002, 8134, 56, 53],
            [2002, 8135, 73, 57],
            [2002, 8136, 27, 33],
            [2002, 8137, 45, 46],
            [2002, 8138, 47, 48],
            [2002, 8139, 64, 74],
            [2002, 8140, 54, 67],
            [2002, 8141, 44, 44],
            [2002, 8142, 45, 45],
            [2002, 8143, 69, 85],
            [2002, 8144, 31, 37],
            [2002, 8145, 34, 39],
            [2002, 8146, 53, 62],
            [2002, 8147, 44, 44],
            [2002, 8148, 46, 46],
            [2002, 8149, 35, 41],
            [2002, 8150, 73, 90],
            [2002, 8151, 33, 39],
            [2002, 8152, 62, 77],
            [2002, 8153, 45, 46],
            [2002, 8154, 44, 44],
            [2002, 8155, 67, 53],
            [2002, 8156, 79, 101],
            [2002, 8157, 47, 47],
            [2002, 8158, 45, 45],
            [2002, 8159, 42, 42],
            [2002, 8160, 45, 45],
            [2002, 8161, 73, 58],
            [2002, 8162, 75, 59],
            [2002, 8163, 56, 49],
            [2002, 8164, 44, 44],
            [2002, 8165, 47, 46],
            [2002, 8166, 86, 65],
            [2002, 8167, 73, 58],
            [2002, 8168, 45, 46],
            [2002, 8169, 55, 50],
            [2002, 8170, 46, 46],
            [2002, 8171, 45, 46],
            [2002, 8172, 86, 64],
            [2002, 8173, 45, 45],
            [2002, 8174, 46, 45],
            [2002, 8175, 35, 40],
            [2002, 8176, 34, 39],
            [2002, 8177, 36, 42],
            [2002, 8178, 47, 47],
            [2002, 8179, 53, 51],
            [2002, 8180, 45, 44],
            [2002, 8181, 85, 64],
            [2002, 8182, 73, 57],
            [2002, 8183, 48, 47],
            [2002, 8184, 44, 44],
            [2002, 8185, 44, 45],
            [2002, 8186, 47, 46],
            [2002, 8187, 36, 41],
            [2002, 8188, 27, 33],
            [2002, 8189, 54, 51],
            [2002, 8190, 34, 39],
            [2002, 8191, 71, 71],
            [2002, 8192, 47, 47],
            [2002, 8193, 84, 63],
            [2002, 8194, 44, 44],
            [2002, 8195, 46, 45],
            [2002, 8196, 36, 41],
            [2002, 8197, 48, 47],
            [2002, 8198, 36, 41],
            [2002, 8199, 66, 80],
            [2002, 8200, 34, 40],
            [2002, 8201, 87, 66],
            [2002, 8202, 58, 58],
            [2002, 8203, 81, 57],
            [2002, 8204, 72, 57],
            [2002, 8205, 32, 37],
            [2002, 8206, 58, 57],
            [2002, 8207, 45, 45],
            [2002, 8208, 34, 39],
            [2002, 8209, 87, 66],
            [2002, 8210, 47, 47],
            [2002, 8211, 69, 85],
            [2002, 8212, 34, 39],
            [2002, 8213, 46, 46],
            [2002, 8214, 67, 82],
            [2002, 8215, 46, 45],
            [2002, 8216, 45, 45],
            [2002, 8217, 47, 47],
            [2002, 8218, 21, 29],
            [2002, 8219, 58, 56],
            [2002, 8220, 33, 39],
            [2002, 8221, 54, 51],
            [2002, 8222, 29, 34],
            [2002, 8223, 34, 39],
            [2002, 8224, 52, 61],
            [2002, 8225, 39, 46],
            [2002, 8226, 69, 84],
            [2002, 8227, 45, 45],
            [2002, 8228, 32, 37],
            [2002, 8229, 44, 44],
            [2002, 8230, 46, 46],
            [2002, 8231, 28, 33],
            [2002, 8232, 63, 62],
            [2002, 8233, 45, 45],
            [2002, 8234, 32, 37],
            [2002, 8235, 67, 81],
            [2002, 8236, 34, 40],
            [2002, 8237, 62, 59],
            [2002, 8238, 45, 44],
            [2002, 8239, 99, 75],
            [2002, 8240, 46, 45],
            [2002, 8241, 35, 41],
            [2002, 8242, 56, 54],
            [2002, 8245, 46, 46],
            [2002, 8246, 48, 47],
            [2002, 8247, 72, 57],
            [2002, 8248, 28, 34],
            [2002, 8249, 55, 52],
            [2002, 8250, 44, 44],
            [2002, 8251, 46, 45],
            [2002, 8252, 53, 51],
            [2002, 8253, 71, 56],
            [2002, 8254, 39, 47],
            [2002, 8255, 45, 44],
            [2002, 8256, 35, 40],
            [2002, 8257, 67, 81],
            [2002, 8258, 45, 45],
            [2002, 8259, 45, 44],
            [2002, 8260, 47, 47],
            [2002, 8261, 66, 79],
            [2002, 8262, 57, 57],
            [2002, 8263, 80, 61],
            [2002, 8264, 37, 44],
            [2002, 8265, 57, 86],
            [2002, 8267, 71, 56],
            [2002, 8268, 46, 45],
            [2002, 8269, 45, 45],
            [2002, 8270, 27, 33],
            [2002, 8271, 35, 41],
            [2002, 8272, 54, 51],
            [2002, 8273, 45, 45],
            [2002, 8274, 45, 44],
            [2002, 8275, 36, 42],
            [2002, 8276, 45, 44],
            [2002, 8277, 42, 30],
            [2002, 8278, 73, 57],
            [2002, 8279, 45, 45],
            [2002, 8280, 48, 47],
            [2002, 8281, 45, 45],
            [2002, 8282, 48, 47],
            [2002, 8283, 47, 46],
            [2002, 8284, 46, 45],
            [2002, 8285, 48, 47],
            [2002, 8286, 48, 47],
            [2002, 8287, 47, 47],
            [2002, 8288, 35, 41],
            [2002, 8289, 55, 52],
            [2002, 8290, 47, 47],
            [2002, 8291, 48, 47],
            [2002, 8292, 46, 46],
            [2002, 8293, 45, 44],
            [2002, 8294, 45, 45],
            [2002, 8295, 72, 57],
            [2002, 8296, 72, 47],
            [2002, 8297, 46, 46],
            [2002, 8298, 29, 53],
            [2002, 8299, 28, 34],
            [2002, 8300, 86, 65],
            [2002, 8301, 47, 47],
            [2002, 8302, 45, 44],
            [2002, 8303, 73, 58],
            [2002, 8304, 45, 44],
            [2002, 8305, 71, 56],
            [2002, 8306, 36, 41],
            [2002, 8307, 27, 33],
            [2002, 8308, 45, 44],
            [2002, 8309, 20, 26],
            [2002, 8310, 54, 52],
            [2002, 8311, 18, 22],
            [2002, 8312, 17, 19],
            [2002, 8313, 16, 19],
            [2002, 8314, 19, 22],
            [2002, 8315, 17, 19],
            [2002, 8316, 16, 18],
            [2002, 8317, 50, 50],
            [2002, 8318, 78, 59],
            [2002, 8319, 27, 30],
            [2002, 8320, 73, 58],
            [2002, 8321, 47, 36],
            [2002, 8322, 47, 46],
            [2002, 8323, 35, 41],
            [2002, 8324, 82, 61],
            [2002, 8325, 77, 60],
            [2002, 8326, 72, 57],
            [2002, 8327, 70, 56],
            [2002, 8328, 74, 59],
            [2002, 8329, 45, 45],
            [2002, 8330, 74, 59],
            [2002, 8331, 71, 56],
            [2002, 8332, 72, 57],
            [2002, 8333, 24, 31],
            [2002, 8334, 20, 27],
            [2002, 8335, 16, 26],
            [2002, 8336, 23, 19],
            [2002, 8337, 14, 18],
            [2002, 8338, 13, 14],
            [2002, 8339, 44, 45],
            [2002, 8340, 16, 19],
            [2002, 8341, 31, 35],
            [2002, 8342, 17, 17],
            [2002, 8343, 19, 20],
            [2002, 8344, 15, 14],
            [2002, 8345, 20, 16],
            [2002, 8346, 20, 28],
            [2002, 8347, 17, 20],
            [2002, 8348, 24, 31],
            [2002, 8349, 16, 19],
            [2002, 8350, 18, 20],
            [2002, 8351, 15, 11],
            [2002, 8352, 21, 31],
            [2002, 8353, 16, 19],
            [2002, 8354, 25, 31],
            [2002, 8355, 17, 18],
            [2002, 8356, 25, 31],
            [2002, 8357, 17, 17],
            [2002, 8358, 25, 19],
            [2002, 8359, 35, 44],
            [2002, 8360, 37, 44],
            [2002, 8361, 17, 15],
            [2002, 8362, 19, 27],
            [2002, 8363, 25, 34],
            [2002, 8364, 30, 26],
            [2002, 8365, 13, 15],
            [2002, 8366, 25, 22],
            [2002, 8367, 16, 17],
            [2002, 8368, 19, 27],
            [2002, 8369, 20, 27],
            [2002, 8370, 21, 23],
            [2002, 8371, 21, 21],
            [2002, 8372, 26, 22],
            [2002, 8373, 26, 32],
            [2002, 8374, 24, 33],
            [2002, 8375, 17, 15],
            [2002, 8376, 29, 31],
            [2002, 8377, 22, 18],
            [2002, 8378, 23, 19],
            [2002, 8379, 27, 24],
            [2002, 8380, 31, 31],
            [2002, 8381, 28, 36],
            [2002, 8382, 21, 24],
            [2002, 8383, 26, 31],
            [2002, 8384, 24, 37],
            [2002, 8385, 22, 28],
            [2002, 8386, 16, 19],
            [2002, 8387, 26, 27],
            [2002, 8388, 18, 19],
            [2002, 8389, 18, 21],
            [2002, 8390, 15, 17],
            [2002, 8391, 18, 22],
            [2002, 8392, 21, 24],
            [2002, 8393, 40, 55],
            [2002, 8394, 27, 21],
            [2002, 8395, 21, 23],
            [2002, 8396, 56, 52],
            [2002, 8397, 82, 61],
            [2002, 8398, 56, 43],
            [2002, 8399, 76, 48],
            [2002, 8400, 66, 60],
            [2002, 8401, 77, 47],
            [2002, 8402, 59, 48],
            [2002, 8403, 68, 46],
            [2002, 8404, 52, 49],
            [2002, 8405, 69, 46],
            [2002, 8406, 58, 48],
            [2002, 8407, 56, 54],
            [2002, 8408, 52, 59],
            [2002, 8409, 39, 34],
            [2002, 8410, 66, 51],
            [2002, 8411, 86, 61],
            [2002, 8412, 54, 52],
            [2002, 8413, 68, 54],
            [2002, 8414, 93, 46],
            [2002, 8415, 102, 66],
            [2002, 8416, 37, 38],
            [2002, 8417, 73, 49],
            [2002, 8418, 28, 32],
            [2002, 8419, 63, 46],
            [2002, 8420, 72, 55],
            [2002, 8421, 80, 60],
            [2002, 8422, 36, 39],
            [2002, 8423, 59, 57],
            [2002, 8424, 76, 81],
            [2002, 8425, 44, 57],
            [2002, 8426, 50, 46],
            [2002, 8427, 52, 44],
            [2002, 8428, 59, 48],
            [2002, 8429, 36, 35],
            [2002, 8430, 59, 57],
            [2002, 8431, 78, 59],
            [2002, 8432, 61, 57],
            [2002, 8433, 58, 55],
            [2002, 8434, 76, 50],
            [2002, 8435, 117, 58],
            [2002, 8436, 82, 61],
            [2002, 8438, 40, 35],
            [2002, 8439, 45, 42],
            [2002, 8440, 94, 57],
            [2002, 8441, 79, 50],
            [2002, 8442, 51, 49],
            [2002, 8443, 67, 60],
            [2002, 8444, 59, 57],
            [2002, 8445, 33, 31],
            [2002, 8446, 44, 38],
            [2002, 8447, 65, 53],
            [2002, 8448, 53, 48],
            [2002, 8449, 103, 44],
            [2002, 8450, 82, 56],
            [2002, 8451, 22, 31],
            [2002, 8452, 30, 43],
            [2002, 8453, 20, 27],
            [2002, 8454, 30, 39],
            [2002, 8455, 24, 31],
            [2002, 8456, 24, 31],
            [2002, 8457, 59, 57],
            [2002, 8458, 48, 39],
            [2002, 8459, 68, 48],
            [2002, 8460, 54, 50],
            [2002, 8461, 84, 48],
            [2002, 8462, 73, 50],
            [2002, 8463, 72, 59],
            [2002, 8464, 81, 60],
            [2002, 8465, 39, 30],
            [2002, 8466, 42, 51],
            [2002, 8467, 47, 43],
            [2002, 8468, 63, 53],
            [2002, 8469, 54, 48],
            [2002, 8470, 81, 62],
            [2002, 8471, 39, 46],
            [2002, 8472, 89, 45],
            [2002, 8473, 66, 60],
            [2002, 8474, 52, 49],
            [2002, 8475, 76, 58],
            [2002, 8476, 77, 59],
            [2002, 8477, 77, 58],
            [2002, 8478, 33, 36],
            [2002, 8479, 52, 49],
            [2002, 8480, 81, 61],
            [2002, 8481, 56, 47],
            [2002, 8482, 56, 47],
            [2002, 8483, 57, 48],
            [2002, 8484, 68, 52],
            [2002, 8485, 74, 61],
            [2002, 8486, 37, 32],
            [2002, 8487, 65, 48],
            [2002, 8488, 51, 46],
            [2002, 8489, 36, 59],
            [2002, 8490, 68, 53],
            [2002, 8491, 58, 58],
            [2002, 8492, 60, 47],
            [2002, 8493, 75, 47],
            [2002, 8494, 36, 31],
            [2002, 8495, 83, 85],
            [2002, 8496, 36, 48],
            [2002, 8497, 60, 63],
            [2002, 8498, 42, 48],
            [2002, 8499, 53, 47],
            [2002, 8500, 78, 50],
            [2002, 8501, 59, 70],
            [2002, 8502, 81, 49],
            [2002, 8503, 78, 59],
            [2002, 8504, 53, 51],
            [2002, 8505, 79, 60],
            [2002, 8506, 81, 61],
            [2002, 8507, 81, 61],
            [2002, 8508, 43, 44],
            [2002, 8509, 52, 48],
            [2002, 8510, 84, 59],
            [2002, 8511, 74, 57],
            [2002, 8512, 59, 57],
            [2002, 8513, 61, 58],
            [2002, 8514, 67, 66],
            [2002, 8515, 54, 52],
            [2002, 8516, 138, 77],
            [2002, 8517, 70, 29],
            [2002, 8518, 83, 77],
            [2002, 8519, 42, 39],
            [2002, 8520, 57, 47],
            [2002, 8521, 51, 47],
            [2002, 8522, 54, 50],
            [2002, 8523, 52, 48],
            [2002, 8524, 51, 46],
            [2002, 8525, 67, 48],
            [2002, 8526, 77, 58],
            [2002, 8527, 69, 69],
            [2002, 8528, 79, 65],
            [2002, 8529, 86, 65],
            [2002, 8530, 40, 38],
            [2002, 8531, 81, 76],
            [2002, 8532, 68, 69],
            [2002, 8533, 81, 75],
            [2002, 8534, 57, 56],
            [2002, 8535, 77, 78],
            [2002, 8536, 22, 45],
            [2002, 8537, 55, 36],
            [2002, 8538, 54, 36],
            [2002, 8539, 47, 40],
            [2002, 8540, 38, 61],
            [2002, 8541, 48, 70],
            [2002, 8542, 43, 65],
            [2002, 8543, 26, 62],
            [2002, 8544, 32, 73],
            [2002, 8546, 35, 62],
            [2002, 8547, 38, 72],
            [2002, 8548, 15, 21],
            [2002, 8549, 25, 33],
            [2002, 8550, 20, 31],
            [2002, 8551, 37, 31],
            [2002, 8552, 33, 41],
            [2002, 8553, 48, 65],
            [2002, 8554, 23, 21],
            [2002, 8555, 40, 38],
            [2002, 8556, 45, 64],
            [2002, 8557, 63, 62],
            [2002, 8558, 31, 34],
            [2002, 8559, 40, 39],
            [2002, 8560, 32, 38],
            [2002, 8561, 25, 31],
            [2002, 8562, 38, 38],
            [2002, 8563, 47, 52],
            [2002, 8564, 92, 74],
            [2002, 8565, 10, 12],
            [2002, 8566, 16, 14],
            [2002, 8567, 23, 22],
            [2002, 8568, 17, 16],
            [2002, 8569, 18, 16],
            [2002, 8570, 10, 10],
            [2002, 8571, 14, 11],
            [2002, 8572, 14, 11],
            [2002, 8573, 12, 11],
            [2002, 8574, 15, 13],
            [2002, 8575, 10, 10],
            [2002, 8576, 22, 16],
            [2002, 8577, 18, 17],
            [2002, 8578, 24, 24],
            [2002, 8579, 19, 21],
            [2002, 8580, 17, 17],
            [2002, 8581, 12, 10],
            [2002, 8582, 18, 17],
            [2002, 8583, 19, 19],
            [2002, 8584, 15, 14],
            [2002, 8585, 12, 12],
            [2002, 8586, 33, 19],
            [2002, 8587, 10, 9],
            [2002, 8588, 39, 17],
            [2002, 8589, 14, 13],
            [2002, 8590, 23, 16],
            [2002, 8591, 20, 16],
            [2002, 8592, 32, 32],
            [2002, 8593, 27, 26],
            [2002, 8594, 41, 27],
            [2002, 8595, 14, 14],
            [2002, 8596, 18, 15],
            [2002, 8597, 21, 21],
            [2002, 8598, 28, 21],
            [2002, 8599, 15, 12],
            [2002, 8600, 23, 16],
            [2002, 8601, 31, 23],
            [2002, 8602, 31, 21],
            [2002, 8603, 25, 16],
            [2002, 8604, 42, 22],
            [2002, 8605, 25, 24],
            [2002, 8606, 42, 25],
            [2002, 8607, 19, 25],
            [2002, 8608, 30, 28],
            [2002, 8609, 28, 21],
            [2002, 8610, 25, 25],
            [2002, 8611, 27, 19],
            [2002, 8612, 38, 23],
            [2002, 8613, 15, 12],
            [2002, 8614, 28, 19],
            [2002, 8615, 12, 12],
            [2002, 8616, 32, 22],
            [2002, 8617, 33, 16],
            [2002, 8618, 20, 13],
            [2002, 8619, 36, 25],
            [2002, 8622, 60, 31],
            [2002, 8623, 61, 32],
            [2002, 8624, 19, 20],
            [2002, 8625, 49, 30],
            [2002, 8626, 25, 18],
            [2002, 8627, 39, 22],
            [2002, 8628, 35, 26],
            [2002, 8629, 34, 28],
            [2002, 8630, 23, 17],
            [2002, 8631, 30, 22],
            [2002, 8632, 23, 17],
            [2002, 8633, 26, 20],
            [2002, 8634, 15, 14],
            [2002, 8635, 27, 15],
            [2002, 8636, 12, 9],
            [2002, 8637, 22, 15],
            [2002, 8638, 16, 13],
            [2002, 8639, 20, 13],
            [2002, 8640, 25, 19],
            [2002, 8641, 45, 21],
            [2002, 8642, 28, 23],
            [2002, 8643, 31, 27],
            [2002, 8644, 48, 28],
            [2002, 8645, 24, 21],
            [2002, 8646, 28, 22],
            [2002, 8647, 20, 15],
            [2002, 8648, 20, 15],
            [2002, 8649, 25, 22],
            [2002, 8650, 35, 18],
            [2002, 8651, 34, 23],
            [2002, 8652, 47, 33],
            [2002, 8653, 30, 27],
            [2002, 8654, 65, 32],
            [2002, 8655, 23, 23],
            [2002, 8656, 24, 20],
            [2002, 8657, 9, 12],
            [2002, 8658, 22, 18],
            [2002, 8659, 34, 23],
            [2002, 8660, 15, 12],
            [2002, 8661, 18, 13],
            [2002, 8662, 22, 14],
            [2002, 8663, 24, 15],
            [2002, 8664, 30, 21],
            [2002, 8665, 46, 33],
            [2002, 8666, 20, 19],
            [2002, 8667, 23, 21],
            [2002, 8668, 20, 26],
            [2002, 8669, 41, 37],
            [2002, 8670, 19, 22],
            [2002, 8671, 29, 30],
            [2002, 8672, 16, 20],
            [2002, 8673, 27, 26],
            [2002, 8674, 27, 18],
            [2002, 8675, 55, 24],
            [2002, 8676, 44, 30],
            [2002, 8677, 51, 31],
            [2002, 8678, 40, 22],
            [2002, 8679, 47, 21],
            [2002, 8680, 26, 20],
            [2002, 8681, 38, 25],
            [2002, 8682, 42, 23],
            [2002, 8683, 38, 14],
            [2002, 8684, 30, 23],
            [2002, 8685, 22, 20],
            [2002, 8686, 31, 19],
            [2002, 8687, 28, 19],
            [2002, 8688, 42, 26],
            [2002, 8689, 35, 24],
            [2002, 8690, 45, 25],
            [2002, 8691, 25, 27],
            [2002, 8692, 47, 29],
            [2002, 8693, 38, 14],
            [2002, 8694, 44, 24],
            [2002, 8695, 15, 16],
            [2002, 8696, 22, 20],
            [2002, 8697, 20, 16],
            [2002, 8698, 37, 18],
            [2002, 8699, 32, 18],
            [2002, 8700, 34, 18],
            [2002, 8701, 29, 16],
            [2002, 8702, 30, 19],
            [2002, 8703, 26, 23],
            [2002, 8704, 34, 27],
            [2002, 8705, 30, 19],
            [2002, 8706, 38, 21],
            [2002, 8707, 23, 23],
            [2002, 8708, 33, 26],
            [2002, 8709, 40, 21],
            [2002, 8710, 35, 22],
            [2002, 8711, 18, 12],
            [2002, 8712, 24, 22],
            [2002, 8713, 36, 23],
            [2002, 8714, 7, 6],
            [2002, 8715, 8, 7],
            [2002, 8716, 8, 8],
            [2002, 8717, 13, 12],
            [2002, 8718, 9, 8],
            [2002, 8719, 22, 24],
            [2002, 8720, 28, 31],
            [2002, 8721, 28, 31],
            [2002, 8722, 27, 24],
            [2002, 8723, 29, 27],
            [2002, 8724, 27, 26],
            [2002, 8725, 24, 20],
            [2002, 8726, 27, 22],
            [2002, 8727, 23, 24],
            [2002, 8728, 21, 22],
            [2002, 8729, 26, 21],
            [2002, 8730, 20, 17],
            [2002, 8731, 21, 20],
            [2002, 8732, 27, 20],
            [2002, 8733, 28, 21],
            [2002, 8734, 23, 19],
            [2002, 8735, 21, 17],
            [2002, 8736, 21, 21],
            [2002, 8737, 21, 18],
            [2002, 8738, 22, 19],
            [2002, 8739, 22, 20],
            [2002, 8740, 22, 19],
            [2002, 8741, 27, 20],
            [2002, 8742, 24, 21],
            [2002, 8743, 24, 20],
            [2002, 8744, 25, 21],
            [2002, 8745, 28, 19],
            [2002, 8746, 30, 23],
            [2002, 8747, 30, 23],
            [2002, 8748, 31, 25],
            [2002, 8749, 25, 20],
            [2002, 8750, 23, 26],
            [2002, 8751, 24, 26],
            [2002, 8752, 19, 17],
            [2002, 8753, 20, 18],
            [2002, 8754, 20, 22],
            [2002, 8755, 21, 19],
            [2002, 8756, 32, 24],
            [2002, 8757, 20, 18],
            [2002, 8758, 20, 20],
            [2002, 8759, 24, 23],
            [2002, 8760, 32, 34],
            [2002, 8761, 24, 20],
            [2002, 8762, 31, 21],
            [2002, 8763, 18, 17],
            [2002, 8764, 33, 26],
            [2002, 8765, 28, 19],
            [2002, 8766, 27, 21],
            [2002, 8767, 33, 25],
            [2002, 8768, 32, 25],
            [2002, 8769, 21, 21],
            [2002, 8770, 33, 26],
            [2002, 8771, 32, 27],
            [2002, 8772, 33, 26],
            [2002, 8773, 19, 17],
            [2002, 8774, 20, 20],
            [2002, 8775, 21, 18],
            [2002, 8776, 20, 19],
            [2002, 8777, 25, 20],
            [2002, 8778, 34, 26],
            [2002, 8779, 9, 14],
            [2002, 8780, 14, 11],
            [2002, 8781, 15, 11],
            [2002, 8782, 17, 11],
            [2002, 8783, 10, 8],
            [2002, 8784, 14, 10],
            [2002, 8785, 8, 7],
            [2002, 8786, 9, 11],
            [2002, 8787, 12, 12],
            [2002, 8788, 14, 10],
            [2002, 8790, 8, 7],
            [2002, 8791, 6, 6],
            [2002, 8792, 13, 11],
            [2002, 8793, 8, 8],
            [2002, 8794, 8, 7],
            [2002, 8795, 9, 8],
            [2002, 8796, 14, 10],
            [2002, 8797, 16, 11],
            [2002, 8798, 9, 9],
            [2002, 8799, 11, 9],
            [2002, 8800, 10, 8],
            [2002, 8801, 12, 10],
            [2002, 8802, 7, 7],
            [2002, 8803, 8, 9],
            [2002, 8804, 7, 10],
            [2002, 8805, 9, 9],
            [2002, 8806, 10, 11],
            [2002, 8807, 15, 14],
            [2002, 8808, 8, 7],
            [2002, 8809, 6, 7],
            [2002, 8810, 12, 11],
            [2002, 8811, 7, 9],
            [2002, 8812, 12, 10],
            [2002, 8814, 6, 6],
            [2002, 8815, 9, 8],
            [2002, 8816, 12, 8],
            [2002, 8817, 18, 10],
            [2002, 8818, 51, 42],
            [2002, 8819, 37, 23],
            [2002, 8820, 56, 47],
            [2002, 8821, 45, 31],
            [2002, 8822, 58, 48],
            [2002, 8823, 32, 27],
            [2002, 8824, 23, 19],
            [2002, 8825, 36, 31],
            [2002, 8826, 23, 22],
            [2002, 8827, 40, 31],
            [2002, 8828, 41, 34],
            [2002, 8829, 44, 35],
            [2002, 8830, 29, 31],
            [2002, 8831, 35, 30],
            [2002, 8832, 19, 11],
            [2002, 8833, 34, 29],
            [2002, 8834, 38, 33],
            [2002, 8835, 34, 20],
            [2002, 8836, 49, 40],
            [2002, 8837, 33, 20],
            [2002, 8838, 43, 38],
            [2002, 8839, 27, 13],
            [2002, 8840, 39, 26],
            [2002, 8841, 27, 13],
            [2002, 8842, 16, 21],
            [2002, 8843, 20, 12],
            [2002, 8844, 28, 23],
            [2002, 8845, 15, 18],
            [2002, 8846, 35, 30],
            [2002, 8847, 19, 21],
            [2002, 8848, 50, 41],
            [2002, 8849, 30, 24],
            [2002, 8850, 39, 34],
            [2002, 8851, 24, 25],
            [2002, 8852, 36, 27],
            [2002, 8853, 14, 18],
            [2002, 8854, 36, 31],
            [2002, 8855, 21, 11],
            [2002, 8856, 32, 27],
            [2002, 8857, 24, 13],
            [2002, 8858, 30, 14],
            [2002, 8859, 47, 41],
            [2002, 8860, 32, 12],
            [2002, 8861, 36, 30],
            [2002, 8862, 27, 22],
            [2002, 8863, 40, 35],
            [2002, 8864, 21, 22],
            [2002, 8865, 32, 27],
            [2002, 8866, 21, 22],
            [2002, 8867, 54, 48],
            [2002, 8868, 40, 34],
            [2002, 8869, 52, 47],
            [2002, 8870, 48, 38],
            [2002, 8871, 38, 32],
            [2002, 8872, 28, 25],
            [2002, 8873, 41, 35],
            [2002, 8874, 35, 29],
            [2002, 8875, 36, 30],
            [2002, 8876, 20, 17],
            [2002, 8877, 44, 38],
            [2002, 8878, 18, 11],
            [2002, 8879, 31, 26],
            [2002, 8880, 32, 27],
            [2002, 8881, 54, 45],
            [2002, 8882, 31, 27],
            [2002, 8883, 51, 46],
            [2002, 8884, 19, 17],
            [2002, 8885, 63, 41],
            [2002, 8886, 35, 30],
            [2002, 8887, 20, 12],
            [2002, 8888, 32, 23],
            [2002, 8889, 48, 38],
            [2002, 8890, 14, 17],
            [2002, 8891, 36, 30],
            [2002, 8892, 14, 11],
            [2002, 8893, 36, 32],
            [2002, 8894, 19, 19],
            [2002, 8895, 15, 11],
            [2002, 8896, 28, 22],
            [2002, 8897, 15, 11],
            [2002, 8898, 21, 19],
            [2002, 8899, 51, 45],
            [2002, 8900, 38, 32],
            [2002, 8901, 50, 31],
            [2002, 8902, 36, 31],
            [2002, 8903, 26, 17],
            [2002, 8904, 36, 30],
            [2002, 8905, 25, 16],
            [2002, 8906, 32, 26],
            [2002, 8907, 22, 20],
            [2002, 8908, 32, 27],
            [2002, 8909, 23, 20],
            [2002, 8910, 24, 13],
            [2002, 8911, 24, 13],
            [2002, 8912, 44, 39],
            [2002, 8913, 29, 25],
            [2002, 8914, 42, 37],
            [2002, 8915, 29, 25],
            [2002, 8916, 50, 41],
            [2002, 8917, 37, 24],
            [2002, 8918, 47, 41],
            [2002, 8919, 34, 32],
            [2002, 8920, 36, 33],
            [2002, 8921, 36, 34],
            [2002, 8922, 32, 26],
            [2002, 8923, 25, 20],
            [2002, 8924, 15, 14],
            [2002, 8925, 11, 11],
            [2002, 8926, 15, 13],
            [2002, 8927, 17, 16],
            [2002, 8928, 14, 13],
            [2002, 8929, 11, 10],
            [2002, 8930, 9, 11],
            [2002, 8931, 14, 15],
            [2002, 8932, 19, 20],
            [2002, 8933, 26, 25],
            [2002, 8934, 28, 27],
            [2002, 8935, 51, 41],
            [2002, 8936, 27, 20],
            [2002, 8937, 35, 30],
            [2002, 8938, 27, 20],
            [2002, 8939, 32, 27],
            [2002, 8940, 19, 17],
            [2002, 8941, 31, 26],
            [2002, 8942, 19, 17],
            [2002, 8943, 29, 20],
            [2002, 8944, 32, 27],
            [2002, 8945, 24, 14],
            [2002, 8946, 32, 27],
            [2002, 8947, 23, 14],
            [2002, 8948, 32, 27],
            [2002, 8949, 23, 14],
            [2002, 8950, 24, 20],
            [2002, 8951, 32, 27],
            [2002, 8952, 24, 20],
            [2002, 8953, 51, 46],
            [2002, 8954, 28, 20],
            [2002, 8955, 44, 39],
            [2002, 8956, 30, 26],
            [2002, 8957, 28, 20],
            [2002, 8958, 52, 43],
            [2002, 8959, 29, 21],
            [2002, 8960, 51, 42],
            [2002, 8961, 29, 20],
            [2002, 8962, 47, 42],
            [2002, 8963, 32, 30],
            [2002, 8964, 20, 12],
            [2002, 8965, 46, 41],
            [2002, 8966, 39, 31],
            [2002, 8967, 43, 34],
            [2002, 8968, 32, 26],
            [2002, 8969, 20, 13],
            [2002, 8970, 43, 37],
            [2002, 8971, 44, 35],
            [2002, 8972, 19, 13],
            [2002, 8973, 44, 35],
            [2002, 8974, 14, 20],
            [2002, 8975, 49, 40],
            [2002, 8976, 53, 47],
            [2002, 8977, 28, 22],
            [2002, 8978, 14, 11],
            [2002, 8979, 40, 35],
            [2002, 8980, 32, 27],
            [2002, 8981, 31, 26],
            [2002, 8983, 36, 30],
            [2002, 8984, 25, 21],
            [2002, 8985, 36, 31],
            [2002, 8986, 25, 21],
            [2002, 8987, 28, 27],
            [2002, 8988, 19, 12],
            [2002, 8989, 36, 31],
            [2002, 8990, 19, 12],
            [2002, 8991, 35, 30],
            [2002, 8992, 19, 12],
            [2002, 8993, 37, 27],
            [2002, 8994, 40, 28],
            [2002, 8995, 40, 29],
            [2002, 8996, 50, 41],
            [2002, 8997, 23, 14],
            [2002, 8998, 28, 23],
            [2002, 8999, 20, 11],
            [2002, 9000, 56, 46],
            [2002, 9001, 48, 31],
            [2002, 9002, 42, 33],
            [2002, 9003, 25, 22],
            [2002, 9004, 51, 42],
            [2002, 9005, 23, 19],
            [2002, 9006, 36, 31],
            [2002, 9007, 29, 20],
            [2002, 9008, 40, 26],
            [2002, 9009, 34, 26],
            [2002, 9010, 28, 23],
            [2002, 9011, 20, 11],
            [2002, 9012, 28, 27],
            [2002, 9013, 14, 14],
            [2002, 9014, 42, 33],
            [2002, 9015, 21, 16],
            [2002, 9016, 20, 15],
            [2002, 9017, 44, 35],
            [2002, 9018, 28, 30],
            [2002, 9019, 33, 32],
            [2002, 9020, 19, 23],
            [2002, 9021, 36, 31],
            [2002, 9022, 25, 26],
            [2002, 9023, 35, 28],
            [2002, 9024, 42, 33],
            [2002, 9025, 32, 27],
            [2002, 9026, 36, 19],
            [2002, 9027, 30, 18],
            [2002, 9028, 42, 33],
            [2002, 9030, 46, 33],
            [2002, 9031, 38, 29],
            [2002, 9032, 46, 33],
            [2002, 9033, 32, 30],
            [2002, 9034, 50, 41],
            [2002, 9035, 42, 37],
            [2002, 9036, 39, 34],
            [2002, 9037, 17, 14],
            [2002, 9038, 28, 28],
            [2002, 9039, 15, 21],
            [2002, 9040, 39, 33],
            [2002, 9041, 26, 22],
            [2002, 9042, 43, 34],
            [2002, 9043, 35, 30],
            [2002, 9044, 28, 14],
            [2002, 9045, 36, 27],
            [2002, 9046, 30, 22],
            [2002, 9047, 38, 29],
            [2002, 9048, 33, 23],
            [2002, 9049, 62, 38],
            [2002, 9050, 31, 22],
            [2002, 9051, 44, 35],
            [2002, 9052, 21, 18],
            [2002, 9053, 29, 21],
            [2002, 9054, 32, 23],
            [2002, 9055, 25, 13],
            [2002, 9056, 36, 24],
            [2002, 9057, 47, 31],
            [2002, 9058, 29, 20],
            [2002, 9059, 51, 35],
            [2002, 9060, 45, 31],
            [2002, 9061, 24, 19],
            [2002, 9062, 14, 14],
            [2002, 9063, 36, 27],
            [2002, 9064, 14, 19],
            [2002, 9065, 24, 23],
            [2002, 9066, 18, 19],
            [2002, 9067, 32, 23],
            [2002, 9068, 28, 19],
            [2002, 9069, 36, 41],
            [2002, 9070, 14, 14],
            [2002, 9071, 28, 34],
            [2002, 9072, 14, 17],
            [2002, 9073, 14, 17],
            [2002, 9074, 31, 29],
            [2002, 9075, 22, 25],
            [2002, 9076, 24, 27],
            [2002, 9077, 36, 23],
            [2002, 9078, 28, 17],
            [2002, 9079, 47, 38],
            [2002, 9080, 22, 19],
            [2002, 9081, 31, 25],
            [2002, 9082, 51, 35],
            [2002, 9083, 24, 20],
            [2002, 9084, 31, 22],
            [2002, 9085, 20, 21],
            [2002, 9086, 39, 30],
            [2002, 9087, 44, 31],
            [2002, 9088, 32, 18],
            [2002, 9089, 18, 15],
            [2002, 9090, 24, 19],
            [2002, 9091, 24, 16],
            [2002, 9092, 46, 30],
            [2002, 9093, 23, 20],
            [2002, 9094, 50, 47],
            [2002, 9095, 14, 12],
            [2002, 9096, 27, 33],
            [2002, 9097, 33, 22],
            [2002, 9098, 39, 25],
            [2002, 9099, 20, 11],
            [2002, 9100, 40, 25],
            [2002, 9101, 14, 14],
            [2002, 9102, 41, 32],
            [2002, 9103, 29, 30],
            [2002, 9104, 39, 30],
            [2002, 9105, 19, 12],
            [2002, 9106, 24, 13],
            [2002, 9107, 36, 27],
            [2002, 9108, 36, 27],
            [2002, 9109, 39, 28],
            [2002, 9110, 48, 31],
            [2002, 9111, 27, 13],
            [2002, 9112, 51, 42],
            [2002, 9113, 26, 21],
            [2002, 9114, 32, 27],
            [2002, 9115, 14, 11],
            [2002, 9116, 20, 15],
            [2002, 9117, 32, 12],
            [2002, 9118, 48, 32],
            [2002, 9119, 19, 12],
            [2002, 9120, 28, 23],
            [2002, 9121, 34, 30],
            [2002, 9122, 42, 37],
            [2002, 9123, 31, 20],
            [2002, 9124, 40, 32],
            [2002, 9125, 17, 25],
            [2002, 9126, 44, 39],
            [2002, 9127, 30, 22],
            [2002, 9128, 36, 27],
            [2002, 9129, 48, 38],
            [2002, 9130, 55, 43],
            [2002, 9131, 29, 30],
            [2002, 9132, 49, 44],
            [2002, 9133, 28, 20],
            [2002, 9134, 36, 28],
            [2002, 9135, 50, 35],
            [2002, 9136, 45, 31],
            [2002, 9137, 20, 15],
            [2002, 9138, 16, 11],
            [2002, 9139, 32, 28],
            [2002, 9140, 44, 39],
            [2002, 9141, 29, 25],
            [2002, 9142, 52, 43],
            [2002, 9143, 21, 21],
            [2002, 9144, 24, 28],
            [2002, 9145, 37, 31],
            [2002, 9146, 45, 36],
            [2002, 9149, 20, 17],
            [2002, 9150, 23, 25],
            [2002, 9151, 19, 18],
            [2002, 9152, 27, 28],
            [2002, 9153, 14, 18],
            [2002, 9154, 16, 16],
            [2002, 9155, 25, 27],
            [2002, 9156, 29, 27],
            [2002, 9157, 30, 33],
            [2002, 9158, 12, 16],
            [2002, 9159, 22, 31],
            [2002, 9160, 15, 15],
            [2002, 9161, 19, 20],
            [2002, 9162, 28, 30],
            [2002, 9163, 30, 25],
            [2002, 9164, 21, 20],
            [2002, 9165, 20, 40],
            [2002, 9166, 24, 27],
            [2002, 9167, 19, 21],
            [2002, 9168, 30, 33],
            [2002, 9169, 22, 22],
            [2002, 9170, 29, 35],
            [2002, 9171, 19, 18],
            [2002, 9172, 21, 26],
            [2002, 9173, 23, 31],
            [2002, 9174, 18, 18],
            [2002, 9175, 20, 22],
            [2002, 9176, 11, 11],
            [2002, 9177, 24, 22],
            [2002, 9178, 22, 35],
            [2002, 9179, 24, 32],
            [2002, 9180, 12, 15],
            [2002, 9181, 19, 17],
            [2002, 9182, 27, 34],
            [2002, 9183, 23, 22],
            [2002, 9184, 27, 28],
            [2002, 9185, 22, 22],
            [2002, 9186, 17, 20],
            [2002, 9187, 24, 23],
            [2002, 9188, 27, 29],
            [2002, 9189, 24, 24],
            [2002, 9190, 17, 20],
            [2002, 9191, 21, 20],
            [2002, 9192, 22, 24],
            [2002, 9193, 19, 18],
            [2002, 9194, 31, 20],
            [2002, 9195, 36, 43],
            [2002, 9196, 29, 29],
            [2002, 9197, 38, 26],
            [2002, 9198, 35, 27],
            [2002, 9199, 60, 40],
            [2002, 9200, 46, 53],
            [2002, 9201, 56, 34],
            [2002, 9202, 44, 42],
            [2002, 9203, 12, 18],
            [2002, 9204, 11, 14],
            [2002, 9205, 27, 25],
            [2002, 9206, 18, 21],
            [2002, 9207, 31, 34],
            [2002, 9208, 43, 42],
            [2002, 9209, 31, 28],
            [2002, 9210, 51, 43],
            [2002, 9211, 29, 33],
            [2002, 9212, 46, 45],
            [2002, 9213, 67, 59],
            [2002, 9214, 43, 40],
            [2002, 9215, 19, 25],
            [2002, 9216, 62, 63],
            [2002, 9217, 55, 43],
            [2002, 9218, 28, 25],
            [2002, 9219, 46, 51],
            [2002, 9220, 34, 31],
            [2002, 9221, 29, 33],
            [2002, 9222, 44, 51],
            [2002, 9223, 39, 48],
            [2002, 9224, 54, 42],
            [2002, 9225, 44, 36],
            [2002, 9226, 64, 43],
            [2002, 9227, 62, 51],
            [2002, 9228, 66, 67],
            [2002, 9229, 49, 51],
            [2002, 9230, 40, 37],
            [2002, 9231, 68, 56],
            [2002, 9232, 47, 41],
            [2002, 9233, 40, 39],
            [2002, 9234, 28, 34],
            [2002, 9235, 40, 44],
            [2002, 9236, 24, 20],
            [2002, 9237, 39, 23],
            [2002, 9238, 38, 50],
            [2002, 9239, 56, 66],
            [2002, 9240, 40, 44],
            [2002, 9241, 31, 42],
            [2002, 9242, 45, 38],
            [2002, 9243, 55, 51],
            [2002, 9244, 43, 41],
            [2002, 9245, 25, 31],
            [2002, 9246, 34, 28],
            [2002, 9247, 48, 38],
            [2002, 9248, 42, 32],
            [2002, 9249, 29, 22],
            [2002, 9250, 32, 22],
            [2002, 9251, 34, 30],
            [2002, 9252, 20, 27],
            [2002, 9253, 78, 58],
            [2002, 9254, 102, 111],
            [2002, 9255, 50, 36],
            [2002, 9257, 80, 72],
            [2002, 9258, 44, 62],
            [2002, 9259, 65, 66],
            [2002, 9260, 54, 41],
            [2002, 9261, 87, 109],
            [2002, 9263, 58, 63],
            [2002, 9264, 53, 57],
            [2002, 9265, 57, 63],
            [2002, 9266, 91, 108],
            [2002, 9267, 70, 72],
            [2002, 9268, 63, 67],
            [2002, 9269, 96, 104],
            [2002, 9270, 91, 108],
            [2002, 9271, 92, 111],
            [2002, 9272, 96, 117],
            [2002, 9273, 98, 119],
            [2002, 9274, 90, 86],
            [2002, 9275, 67, 64],
            [2002, 9276, 91, 85],
            [2002, 9277, 88, 73],
            [2002, 9278, 85, 86],
            [2002, 9279, 83, 79],
            [2002, 9280, 67, 66],
            [2002, 9281, 87, 79],
            [2002, 9282, 100, 91],
            [2002, 9283, 93, 102],
            [2002, 9284, 110, 130],
            [2002, 9285, 81, 98],
            [2002, 9286, 104, 126],
            [2002, 9287, 107, 124],
            [2002, 9288, 59, 46],
            [2002, 9289, 105, 122],
            [2002, 9290, 83, 97],
            [2002, 9291, 100, 114],
            [2002, 9292, 99, 114],
            [2002, 9293, 67, 48],
            [2002, 9294, 68, 67],
            [2002, 9295, 83, 79],
            [2002, 9296, 63, 46],
            [2002, 9297, 80, 56],
            [2002, 9298, 82, 103],
            [2002, 9299, 95, 116],
            [2002, 9300, 102, 119],
            [2002, 9301, 87, 106],
            [2002, 9302, 107, 124],
            [2002, 9303, 97, 120],
            [2002, 9304, 60, 81],
            [2002, 9305, 90, 111],
            [2002, 9306, 108, 133],
            [2002, 9307, 47, 68],
            [2002, 9308, 56, 77],
          