# Copyright (C) 2011 Oren Zomer <oren.zomer@gmail.com>

#                          *** MIT License ***
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
# of the Software, and to permit persons to whom the Software is furnished to do
# so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
Psifas

author: Oren Zomer <oren.zomer@gmail.com>

homepage: http://pypsifas.sf.net
"""

__author__ = "Oren Zomer <oren.zomer@gmail.com>"

# Required due to deepcopy DFS algorithm. Using shallow (BFS) algorithm
# may be possible in the future.
import sys
sys.setrecursionlimit(max(sys.getrecursionlimit(), 10000))

import datatypes

from psifas_exceptions import *
from utils import *
from multifield import *
from arithmetic import *
from repeater import *
from switch import *
from base import *

try:
    from scapy_wrapper import *
except ImportWarning, w:
    import warnings
    warnings.warn(w)
