from __future__ import absolute_import
__version__='4.1.2'
__gitrevision__ ="6396c4e238c39f1d449e1d36d8ed18ae89212b84"
from . import CoolProp
from . import HumidAirProp
from . import State
from .unit_systems_constants import *
from .param_constants import *
from .phase_constants import *
__fluids__ = CoolProp.FluidsList()
def test():
    """
    Run the tests in the test folder
    """
    from .tests import runner
    runner.run()
def get_include_directory():
    """
    Get the include directory for CoolProp header files that are needed if you want
    to compile anything else that uses the CoolProp Cython extension type
    Returns
    -------
    include_directory: The path to the include folder for CoolProp
    """
    import os
    head,file = os.path.split(__file__)
    return os.path.join(head,'include')
def copy_BibTeX_library(file = None, folder = None):
    """
    Copy the CoolProp BibTeX library file to the file given by ``file``, or the folder given by ``folder``
    If no inputs are provided, the file will be copied to the current working 
    directory
    Parameters
    ----------
    file : string
        Provide if you want to put the file into a given file
    folder : string
        Provide if you want to put the CoolPropBibTeXLibrary.bib file into the given folder
    """
    import os, shutil
    path_to_bib = os.path.join(os.path.split(__file__)[0],'CoolPropBibTeXLibrary.bib')
    if file is None and folder is None:
        shutil.copy2(path_to_bib,os.path.abspath(os.curdir))
    elif file and folder is None:
        shutil.copy2(path_to_bib,file)
    elif folder and file is None:
        shutil.copy2(path_to_bib,os.path.join(folder,file))
    else:
        raise ValueError('can only provide one of file or folder')
