
from matplotlib.colors import ListedColormap
from numpy import nan, inf

# Used to reconstruct the colormap in viscm
parameters = {'xp': [1.2291944322885904, 15.686577994354849, 30.928398202273232, 36.957902166964374, 39.352619720280053, 37.854922859529893],
              'yp': [-17.104696078108354, -28.200058582308117, -14.15860623697381, 0.48569724700903905, 13.595593405835402, 23.29120992542855],
              'min_Jp': 9.74051896208,
              'max_Jp': 59.6407185629}

cm_data = [[ 0.06334758, 0.04767714, 0.20764926],
           [ 0.0668604 , 0.04840216, 0.21191903],
           [ 0.07037658, 0.0490898 , 0.21617819],
           [ 0.07389749, 0.04973982, 0.22042582],
           [ 0.07742434, 0.05035199, 0.22466091],
           [ 0.08096457, 0.05091956, 0.22889053],
           [ 0.08451233, 0.05144902, 0.23310476],
           [ 0.08806829, 0.05194035, 0.23730226],
           [ 0.09163313, 0.05239343, 0.24148177],
           [ 0.09520958, 0.0528058 , 0.24564459],
           [ 0.09879869, 0.05317664, 0.24978991],
           [ 0.10239764, 0.05350941, 0.25391239],
           [ 0.10600672, 0.05380415, 0.25801055],
           [ 0.10962615, 0.05406096, 0.26208286],
           [ 0.11325606, 0.05427998, 0.26612774],
           [ 0.11690003, 0.05445719, 0.27014746],
           [ 0.1205542 , 0.05459734, 0.27413598],
           [ 0.12421844, 0.05470086, 0.27809157],
           [ 0.12789261, 0.05476814, 0.28201255],
           [ 0.13157654, 0.05479966, 0.28589722],
           [ 0.13526997, 0.05479595, 0.28974386],
           [ 0.13897261, 0.05475763, 0.29355076],
           [ 0.14268604, 0.05468282, 0.29731803],
           [ 0.14640781, 0.05457496, 0.30104191],
           [ 0.15013739, 0.05443505, 0.30472063],
           [ 0.15387432, 0.05426399, 0.30835258],
           [ 0.15761816, 0.05406275, 0.31193617],
           [ 0.16136839, 0.05383237, 0.31546987],
           [ 0.1651245 , 0.05357394, 0.31895217],
           [ 0.16888596, 0.05328865, 0.32238164],
           [ 0.1726522 , 0.05297774, 0.32575692],
           [ 0.17642268, 0.05264248, 0.3290767 ],
           [ 0.18019683, 0.05228424, 0.33233977],
           [ 0.18397441, 0.05190387, 0.3355452 ],
           [ 0.18775467, 0.05150312, 0.33869179],
           [ 0.19153678, 0.05108387, 0.34177839],
           [ 0.19532021, 0.05064763, 0.34480416],
           [ 0.19910443, 0.05019595, 0.34776833],
           [ 0.20288891, 0.04973039, 0.35067022],
           [ 0.20667315, 0.04925253, 0.35350927],
           [ 0.21045667, 0.04876397, 0.35628499],
           [ 0.21423901, 0.04826632, 0.358997  ],
           [ 0.21801972, 0.04776117, 0.36164501],
           [ 0.22179838, 0.04725013, 0.36422884],
           [ 0.22557459, 0.04673477, 0.36674838],
           [ 0.229348  , 0.04621667, 0.36920361],
           [ 0.23311825, 0.04569736, 0.3715946 ],
           [ 0.23688503, 0.04517836, 0.37392151],
           [ 0.24064806, 0.04466115, 0.37618456],
           [ 0.24440706, 0.04414717, 0.37838406],
           [ 0.24816181, 0.0436378 , 0.38052038],
           [ 0.25191208, 0.0431344 , 0.38259396],
           [ 0.25565771, 0.04263825, 0.38460528],
           [ 0.25939854, 0.04215059, 0.3865549 ],
           [ 0.26313442, 0.04167259, 0.38844342],
           [ 0.26686525, 0.04120537, 0.39027148],
           [ 0.27059094, 0.04074996, 0.39203976],
           [ 0.27431143, 0.04030508, 0.39374899],
           [ 0.27802666, 0.0398711 , 0.39539992],
           [ 0.28173662, 0.03945441, 0.39699332],
           [ 0.2854413 , 0.0390555 , 0.39852999],
           [ 0.2891407 , 0.03867475, 0.40001076],
           [ 0.29283486, 0.03831249, 0.40143645],
           [ 0.2965238 , 0.03796897, 0.40280792],
           [ 0.30020759, 0.03764436, 0.404126  ],
           [ 0.30388629, 0.03733877, 0.40539157],
           [ 0.30755997, 0.03705225, 0.40660548],
           [ 0.31122873, 0.03678479, 0.40776859],
           [ 0.31489267, 0.03653631, 0.40888175],
           [ 0.31855185, 0.03630675, 0.40994582],
           [ 0.3222064 , 0.03609595, 0.41096166],
           [ 0.32585645, 0.03590364, 0.41193007],
           [ 0.32950214, 0.03572956, 0.41285189],
           [ 0.33314359, 0.03557341, 0.41372793],
           [ 0.33678094, 0.03543485, 0.41455897],
           [ 0.34041433, 0.03531353, 0.41534579],
           [ 0.34404389, 0.03520905, 0.41608917],
           [ 0.34766978, 0.03512098, 0.41678985],
           [ 0.35129214, 0.0350489 , 0.41744855],
           [ 0.35491111, 0.03499232, 0.418066  ],
           [ 0.35852685, 0.03495077, 0.41864287],
           [ 0.3621395 , 0.03492374, 0.41917986],
           [ 0.3657492 , 0.03491073, 0.4196776 ],
           [ 0.36935611, 0.03491119, 0.42013675],
           [ 0.37296037, 0.0349246 , 0.42055792],
           [ 0.37656213, 0.03495041, 0.4209417 ],
           [ 0.38016152, 0.03498806, 0.42128867],
           [ 0.3837587 , 0.03503698, 0.4215994 ],
           [ 0.38735379, 0.03509663, 0.42187443],
           [ 0.39094694, 0.03516642, 0.42211427],
           [ 0.39453828, 0.0352458 , 0.42231944],
           [ 0.39812795, 0.03533418, 0.42249041],
           [ 0.40171607, 0.035431  , 0.42262766],
           [ 0.40530277, 0.0355357 , 0.42273165],
           [ 0.40888809, 0.0356479 , 0.4228029 ],
           [ 0.41247224, 0.03576683, 0.42284173],
           [ 0.41605535, 0.03589193, 0.42284854],
           [ 0.41963751, 0.03602264, 0.42282371],
           [ 0.42321886, 0.0361584 , 0.42276761],
           [ 0.42679949, 0.03629868, 0.42268061],
           [ 0.43037952, 0.03644293, 0.42256303],
           [ 0.43395904, 0.03659062, 0.4224152 ],
           [ 0.43753815, 0.03674122, 0.42223744],
           [ 0.44111695, 0.03689422, 0.42203005],
           [ 0.44469553, 0.03704909, 0.42179331],
           [ 0.44827399, 0.03720534, 0.4215275 ],
           [ 0.4518524 , 0.03736247, 0.42123288],
           [ 0.45543084, 0.03752   , 0.4209097 ],
           [ 0.45900941, 0.03767745, 0.4205582 ],
           [ 0.46258817, 0.03783434, 0.42017862],
           [ 0.46616718, 0.03799028, 0.4197712 ],
           [ 0.46974651, 0.03814479, 0.41933615],
           [ 0.47332626, 0.03829737, 0.41887362],
           [ 0.47690648, 0.03844759, 0.41838382],
           [ 0.48048724, 0.03859504, 0.41786692],
           [ 0.48406859, 0.0387393 , 0.4173231 ],
           [ 0.48765059, 0.03887996, 0.41675252],
           [ 0.49123329, 0.03901664, 0.41615535],
           [ 0.49481674, 0.03914896, 0.41553173],
           [ 0.49840098, 0.03927654, 0.41488182],
           [ 0.50198607, 0.03939903, 0.41420574],
           [ 0.50557203, 0.03951606, 0.41350363],
           [ 0.5091589 , 0.03962732, 0.41277563],
           [ 0.51274673, 0.03973246, 0.41202183],
           [ 0.51633554, 0.03983116, 0.41124237],
           [ 0.51992537, 0.0399231 , 0.41043733],
           [ 0.52351627, 0.04000795, 0.40960679],
           [ 0.52710824, 0.04008545, 0.40875088],
           [ 0.53070131, 0.04015532, 0.40786969],
           [ 0.53429549, 0.04021731, 0.40696332],
           [ 0.53789081, 0.04027117, 0.40603183],
           [ 0.54148728, 0.04031665, 0.40507533],
           [ 0.54508492, 0.04035352, 0.40409389],
           [ 0.54868373, 0.04038156, 0.40308758],
           [ 0.55228372, 0.04040058, 0.40205647],
           [ 0.5558849 , 0.04041036, 0.40100064],
           [ 0.55948729, 0.04041074, 0.39992014],
           [ 0.56309087, 0.04040153, 0.39881503],
           [ 0.56669565, 0.04038259, 0.39768539],
           [ 0.57030163, 0.04035375, 0.39653126],
           [ 0.57390881, 0.04031489, 0.39535269],
           [ 0.57751722, 0.04026573, 0.39414962],
           [ 0.58112686, 0.0402062 , 0.39292215],
           [ 0.58473768, 0.0401363 , 0.39167036],
           [ 0.58834967, 0.04005594, 0.39039431],
           [ 0.59196282, 0.03996504, 0.38909403],
           [ 0.59557712, 0.03986355, 0.38776957],
           [ 0.59919256, 0.03975142, 0.38642097],
           [ 0.60280911, 0.03962862, 0.38504824],
           [ 0.60642675, 0.03949512, 0.38365143],
           [ 0.61004548, 0.03935093, 0.38223057],
           [ 0.61366525, 0.03919605, 0.38078568],
           [ 0.61728607, 0.03903051, 0.37931679],
           [ 0.62090789, 0.03885434, 0.37782392],
           [ 0.62453069, 0.03866759, 0.37630709],
           [ 0.62815445, 0.03847033, 0.37476633],
           [ 0.63177914, 0.03826264, 0.37320164],
           [ 0.63540472, 0.03804462, 0.37161305],
           [ 0.63903116, 0.03781638, 0.37000055],
           [ 0.64265844, 0.03757805, 0.36836417],
           [ 0.64628652, 0.03732977, 0.36670392],
           [ 0.64991535, 0.03707171, 0.36501978],
           [ 0.65354494, 0.03680393, 0.36331169],
           [ 0.65717526, 0.03652658, 0.36157961],
           [ 0.66080623, 0.03624002, 0.35982365],
           [ 0.66443779, 0.03594451, 0.35804381],
           [ 0.66806992, 0.03564027, 0.35624009],
           [ 0.67170256, 0.03532758, 0.35441247],
           [ 0.67533568, 0.03500673, 0.35256094],
           [ 0.67896921, 0.03467803, 0.35068548],
           [ 0.68260313, 0.0343418 , 0.34878608],
           [ 0.68623737, 0.03399838, 0.3468627 ],
           [ 0.68987188, 0.03364815, 0.34491533],
           [ 0.69350662, 0.03329149, 0.34294394],
           [ 0.69714152, 0.03292882, 0.34094848],
           [ 0.70077654, 0.03256056, 0.33892892],
           [ 0.70441162, 0.03218717, 0.33688522],
           [ 0.7080467 , 0.03180913, 0.33481734],
           [ 0.71168172, 0.03142694, 0.3327252 ],
           [ 0.71531661, 0.03104113, 0.33060877],
           [ 0.71895133, 0.03065224, 0.32846798],
           [ 0.72258579, 0.03026085, 0.32630275],
           [ 0.72621995, 0.02986757, 0.32411302],
           [ 0.72985373, 0.02947302, 0.32189871],
           [ 0.73348706, 0.02907787, 0.31965972],
           [ 0.73711987, 0.02868279, 0.31739597],
           [ 0.7407521 , 0.02828849, 0.31510735],
           [ 0.74438366, 0.02789574, 0.31279376],
           [ 0.74801449, 0.02750528, 0.31045508],
           [ 0.7516445 , 0.02711795, 0.30809118],
           [ 0.75527362, 0.02673455, 0.30570194],
           [ 0.75890177, 0.02635598, 0.3032872 ],
           [ 0.76252886, 0.02598314, 0.30084681],
           [ 0.76615481, 0.02561695, 0.29838061],
           [ 0.76977964, 0.02525791, 0.29588802],
           [ 0.77340318, 0.02490739, 0.29336914],
           [ 0.77702532, 0.0245665 , 0.29082383],
           [ 0.78064598, 0.02423635, 0.28825188],
           [ 0.78426506, 0.02391805, 0.28565305],
           [ 0.78788245, 0.02361278, 0.2830271 ],
           [ 0.79149806, 0.02332175, 0.28037377],
           [ 0.7951118 , 0.02304622, 0.27769277],
           [ 0.79872355, 0.02278747, 0.27498381],
           [ 0.8023332 , 0.02254687, 0.27224656],
           [ 0.80594065, 0.0223258 , 0.26948069],
           [ 0.80954578, 0.02212571, 0.26668583],
           [ 0.81314848, 0.02194809, 0.2638616 ],
           [ 0.81674864, 0.02179449, 0.26100757],
           [ 0.82034612, 0.02166651, 0.2581233 ],
           [ 0.82394098, 0.02156487, 0.25520748],
           [ 0.82753303, 0.02149164, 0.25225992],
           [ 0.83112203, 0.02144911, 0.24928052],
           [ 0.83470785, 0.02143911, 0.24626869],
           [ 0.83829034, 0.02146355, 0.24322381],
           [ 0.84186938, 0.02152438, 0.24014521],
           [ 0.8454448 , 0.02162365, 0.23703217],
           [ 0.84901646, 0.02176345, 0.23388393],
           [ 0.85258421, 0.02194596, 0.23069966],
           [ 0.85614815, 0.02217192, 0.22747701],
           [ 0.85970797, 0.02244453, 0.22421582],
           [ 0.86326339, 0.02276678, 0.22091562],
           [ 0.86681423, 0.02314115, 0.21757527],
           [ 0.87036031, 0.02357023, 0.21419359],
           [ 0.87390146, 0.02405668, 0.21076926],
           [ 0.87743748, 0.02460327, 0.20730089],
           [ 0.8809686 , 0.02521042, 0.20378433],
           [ 0.88449422, 0.02588333, 0.20022025],
           [ 0.88801412, 0.0266252 , 0.19660697],
           [ 0.89152806, 0.02743921, 0.19294251],
           [ 0.89503584, 0.02832862, 0.18922472],
           [ 0.89853741, 0.02929578, 0.18544999],
           [ 0.90203267, 0.03034339, 0.18161467],
           [ 0.90552105, 0.03147694, 0.177718  ],
           [ 0.9090023 , 0.03270019, 0.17375685],
           [ 0.91247616, 0.03401705, 0.1697277 ],
           [ 0.91594267, 0.03542982, 0.16562435],
           [ 0.91940148, 0.03694304, 0.16144277],
           [ 0.92285205, 0.03856246, 0.15717991],
           [ 0.92629411, 0.04029256, 0.15283036],
           [ 0.9297275 , 0.04208891, 0.14838643],
           [ 0.93315213, 0.04394793, 0.14383905],
           [ 0.93656726, 0.04587337, 0.13918364],
           [ 0.93997257, 0.04786426, 0.1344111 ],
           [ 0.94336796, 0.04991831, 0.12950803],
           [ 0.94675308, 0.05203472, 0.12446169],
           [ 0.95012726, 0.05421413, 0.11926072],
           [ 0.95349009, 0.05645569, 0.11388811],
           [ 0.95684173, 0.05875624, 0.10831624],
           [ 0.96018119, 0.06111767, 0.10252706],
           [ 0.96350801, 0.06353929, 0.09649019],
           [ 0.96682217, 0.06601885, 0.09016074],
           [ 0.97012287, 0.06855717, 0.08349422],
           [ 0.97340949, 0.07115419, 0.07642881],
           [ 0.97668194, 0.07380809, 0.06886982],
           [ 0.97993936, 0.07651969, 0.06070177],
           [ 0.98318108, 0.07928898, 0.05174878]]

test_cm = ListedColormap(cm_data, name=__file__)


if __name__ == "__main__":
    import matplotlib.pyplot as plt
    import numpy as np

    try:
        from viscm import viscm
        viscm(test_cm)
    except ImportError:
        print("viscm not found, falling back on simple display")
        plt.imshow(np.linspace(0, 100, 256)[None, :], aspect='auto',
                   cmap=test_cm)
    plt.show()
