# -*- coding: utf-8 -*-
from 臺灣言語工具.語音合成.決策樹仔問題.公家決策樹仔 import 公家決策樹仔
from 臺灣言語工具.語音合成.生決策樹仔問題 import 生決策樹仔問題
import itertools
import os
import sys


from 臺灣言語工具.音標系統.官話.官話注音符號轉音值模組 import 官話注音符號對照音值聲母表
from 臺灣言語工具.音標系統.官話.官話注音符號轉音值模組 import 官話韻母實際音值表
from 臺灣言語工具.音標系統.官話.官話注音符號 import 官話注音符號調


class 官話決策樹仔(公家決策樹仔):
    _生問題 = 生決策樹仔問題()
    聲韻符號 = ('', '-', '+', '/調:')
    調符號 = ('/調:', '<', '>', '/詞:')
    詞符號 = ('/詞:', '!', '@', '/句:')
    句符號 = ('/句:', '^', '_', '')

    @classmethod
    def 生(cls, 輸出目的=open(os.devnull, 'w')):
        問題 = set()
        問題 |= cls.孤聲韻()
        print(len(問題), file=輸出目的)
        問題 |= cls.元音分韻()
        print(len(問題), file=輸出目的)
        問題 |= cls.孤元音()
        print(len(問題), file=輸出目的)
        問題 |= cls.陰聲韻()
        print(len(問題), file=輸出目的)
        問題 |= cls.韻尾()
        print(len(問題), file=輸出目的)
        問題 |= cls.輔音()
        print(len(問題), file=輸出目的)
        問題 |= cls.全部調()
        print(len(問題), file=輸出目的)
        問題 |= cls.詞句長度(10, 20)
        print(len(問題), file=輸出目的)

        cls._生問題.檢查(問題)
        return 問題

    @classmethod
    def 孤聲韻(cls):
        '''
        孤聲韻
        '''
        聲韻 = []
        for 實際音 in itertools.chain(
                ['sil', 'sp'],
                官話注音符號對照音值聲母表.values(),
                官話韻母實際音值表.values()):
            聲韻.append(('{0}'.format(實際音), [實際音]))
        return cls._生問題.問題集(聲韻, cls.聲韻符號, '孤條')

    @classmethod
    def 元音分韻(cls):
        全部元音題目 = [
            ('全部韻', ['*i*', '*u*', '*e*', '*ə*', '*ɤ*', '*ɚ*', '*o*', '*a*', ])]
        元音 = cls._生問題.問題集(全部元音題目, cls.聲韻符號, '孤條')
        懸低元音題目 = [
            ('懸元音韻', ['*i*', '*u*']),
            ('中元音韻', ['*e*', '*ə*', 'ɤ', 'ɚ', '*o*', ]),
            ('低元音韻', ['*a*', ])
        ]
        元音 |= cls._生問題.問題集(懸低元音題目, cls.聲韻符號, '孤條')
        前後元音題目 = [
            ('前元音韻', ['*i*', '*e*', ]),
            ('央元音韻', ['*ə*', 'ɤ', 'ɚ', '*a*', ]),
            ('後元音韻', ['*o*', '*u*'])
        ]
        元音 |= cls._生問題.問題集(前後元音題目, cls.聲韻符號, '孤條')
        孤元音題目 = [	]
        for 元音韻種類 in 全部元音題目[0][1]:
            孤元音題目.append(
                ('{}元音韻'.format(元音韻種類[1:-1]), [元音韻種類]))
        元音 |= cls._生問題.問題集(孤元音題目, cls.聲韻符號, '孤條')
        return 元音

    @classmethod
    def 孤元音(cls):
        全部元音題目 = [('全部孤元音', ['i', 'u', 'e', 'ə', 'ɤ', 'ɚ', 'o', 'a', ])]
        元音 = cls._生問題.問題集(全部元音題目, cls.聲韻符號, '孤條')
        懸低元音題目 = [
            ('懸孤元音', ['i', 'u']),
            ('中孤元音', ['e', 'ə', 'ɤ', 'ɚ', 'o', ]),
            ('低孤元音', ['a', ])
        ]
        元音 |= cls._生問題.問題集(懸低元音題目, cls.聲韻符號, '孤條')
        前後元音題目 = [
            ('前孤元音', ['i', 'e', ]),
            ('央孤元音', ['ə', 'ɤ', 'ɚ', 'a', ]),
            ('後孤元音', ['o', 'u'])
        ]
        元音 |= cls._生問題.問題集(前後元音題目, cls.聲韻符號, '孤條')
        孤元音題目 = [	]
        for 元音韻種類 in 全部元音題目[0][1]:
            孤元音題目.append(
                ('孤{}元音'.format(元音韻種類), [元音韻種類]))
        元音 |= cls._生問題.問題集(孤元音題目, cls.聲韻符號, '孤條')
        return 元音

    @classmethod
    def 陰聲韻(cls):
        全部元音題目 = [
            ('全部陰聲韻', ['*i', '*u', '*e', '*ə', '*ɤ', '*ɚ', '*o', '*a', ])]
        陰聲韻 = cls._生問題.問題集(全部元音題目, cls.聲韻符號, '孤條')
        尾懸低元音題目 = [
            ('尾懸陰聲韻', ['*i', '*u']),
            ('尾中陰聲韻', ['*e', '*ə', 'ɤ', 'ɚ', '*o', ]),
            ('尾低陰聲韻', ['*a', ])
        ]
        陰聲韻 |= cls._生問題.問題集(尾懸低元音題目, cls.聲韻符號, '孤條')
        尾前後元音題目 = [
            ('尾前陰聲韻', ['*i', '*e', ]),
            ('尾央陰聲韻', ['*ə', 'ɤ', 'ɚ', '*a', ]),
            ('尾後陰聲韻', ['*o', '*u'])
        ]
        陰聲韻 |= cls._生問題.問題集(尾前後元音題目, cls.聲韻符號, '孤條')
        孤元音題目 = [	]
        for 元音韻種類 in 全部元音題目[0][1]:
            孤元音題目.append(
                ('尾{}陰聲韻'.format(元音韻種類[1:]), [元音韻種類]))
        陰聲韻 |= cls._生問題.問題集(孤元音題目, cls.聲韻符號, '孤條')

        頭懸低元音題目 = [
            ('頭懸陰聲韻', ['i*', 'u*']),
            ('頭中陰聲韻', ['e*', 'ə*', 'ɤ', 'ɚ', 'o*', ]),
            ('頭低陰聲韻', ['a*', ])
        ]
        陰聲韻 |= cls._生問題.問題集(頭懸低元音題目, cls.聲韻符號, '孤條')
        頭前後元音題目 = [
            ('頭前陰聲韻', ['i*', 'e*', ]),
            ('頭央陰聲韻', ['ə*', 'ɤ', 'ɚ', 'a*', ]),
            ('頭後陰聲韻', ['o*', 'u*'])
        ]
        陰聲韻 |= cls._生問題.問題集(頭前後元音題目, cls.聲韻符號, '孤條')
        孤元音題目 = [	]
        for 元音韻種類 in 全部元音題目[0][1]:
            孤元音題目.append(
                ('頭{}陰聲韻'.format(元音韻種類[1:]), [元音韻種類]))
        陰聲韻 |= cls._生問題.問題集(孤元音題目, cls.聲韻符號, '孤條')
        return 陰聲韻

    @classmethod
    def 韻尾(cls):
        韻尾題目 = [
            ('陽聲韻', ['*?m', '*?n', '*?ŋ', ]),
        ]
        韻尾 = cls._生問題.問題集(韻尾題目, cls.聲韻符號, '孤條')
        孤韻 = []
        for 非陰聲 in 韻尾題目[0][1]:
            孤韻.append(('是{}韻尾'.format(非陰聲[2:]), [非陰聲]))
        韻尾 |= cls._生問題.問題集(孤韻, cls.聲韻符號, '孤條')
        return 韻尾

    @classmethod
    def 輔音(cls):
        塞擦題目 = [
            ('塞音', ['p', 'pʰ', 't', 'tʰ', 'k', 'kʰ', 'ʔ', ]),
            ('塞擦音', ['ts', 'tsʰ', 'tɕ', 'tɕʰ', 'tʂ', 'tʂʰ']),
            ('擦音', ['f', 's', 'ɕ', 'ʂ', 'ʐ', 'h', ]),
        ]
        發音方法 = [
            ('鼻音', ['m', 'n', ]),
            ('清塞音', ['p', 't', 'k', 'ts', 'tɕ', 'tʂ', 'ʔ', ]),
            ('送氣音', ['pʰ', 'tʰ', 'kʰ', 'tɕʰ', 'tʂʰ']),
            ('濁輔音', ['ʐ', 'l']),
            ('濁非元音', ['m', 'n', 'ʐ', 'l']),
        ]
        發音所在 = [
            ('唇輔音', ['p', 'pʰ', 'm', 'f']),
            ('齒輔音', ['t', 'tʰ', 'n', 'l', ]),
            ('舌尖前輔音', ['ts', 'tsʰ', 's', ]),
            ('舌尖後輔音', ['tʂ', 'tʂʰ', 'ʂ', ]),
            ('舌團輔音', ['tɕ', 'tɕʰ', 'ɕ', ]),
            ('根輔音', ['k', 'kʰ', ]),
            ('喉輔音', ['h', 'ʔ', ]),
        ]
        return cls._生問題.問題集(塞擦題目, cls.聲韻符號, '連紲') | \
            cls._生問題.問題集(發音方法, cls.聲韻符號, '孤條') | \
            cls._生問題.問題集(發音所在, cls.聲韻符號, '孤條')

    @classmethod
    def 全部調(cls):
        '''組合'''
        題目 = []
        for 調號 in 官話注音符號調:
            題目.append(('第{}調'.format(調號), ['{}'.format(調號)]))
        return cls._生問題.問題集(題目, cls.調符號, '組合')

if __name__ == '__main__':
    問題 = 官話決策樹仔().生(sys.stdout)
    檔案 = open('questions_qst001.hed', 'w')
    print('\n'.join(問題), file=檔案)
    檔案.close()
