/*
 * Copyright (C) 2013-  Qiming Sun <osirpt.sun@gmail.com>
 * Description: code generated by  gen-code.cl
 */
#include <stdlib.h>
#include "cint_bas.h"
#include "cart2sph.h"
#include "g1e.h"
#include "g2e.h"
#include "optimizer.h"
#include "cint1e.h"
#include "misc.h"
#include "c2f.h"

/* based on
 * '("int3c1e_r2_origk" ( \, \, r dot r))
 */
static void CINTgout1e_int3c1e_r2_origk(double *gout,
                double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
        int nf = envs->nf;
        int ix, iy, iz, n;
        double *g0 = g;
        double *g1 = g0 + envs->g_size * 3;
        double *g2 = g1 + envs->g_size * 3;
        double *g3 = g2 + envs->g_size * 3;
        double s;
        G1E_R_K(g1, g0, envs->i_l+0, envs->j_l+0, envs->k_l+1);
        G1E_R_K(g3, g1, envs->i_l+0, envs->j_l+0, envs->k_l+0);
        for (n = 0; n < nf; n++) {
                ix = idx[0+n*3];
                iy = idx[1+n*3];
                iz = idx[2+n*3];
                s = g3[ix+0]*g0[iy+0]*g0[iz+0];
                s+= g0[ix+0]*g3[iy+0]*g0[iz+0];
                s+= g0[ix+0]*g0[iy+0]*g3[iz+0];
                if (gout_empty) {
                        gout[n] = s;
                } else {
                        gout[n]+= s;
                }
        }
}
void int3c1e_r2_origk_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
        int ng[] = {0, 0, 2, 0, 2, 1, 1, 1};
        CINTall_3c1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int3c1e_r2_origk_cart(double *out, int *dims, int *shls,
                int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
        int ng[] = {0, 0, 2, 0, 2, 1, 1, 1};
        CINTEnvVars envs;
        CINTinit_int3c1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
        envs.f_gout = &CINTgout1e_int3c1e_r2_origk;
        return CINT3c1e_cart_drv(out, dims, &envs, opt, cache, 0);
} // int3c1e_r2_origk_cart
int int3c1e_r2_origk_sph(double *out, int *dims, int *shls,
                int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
        int ng[] = {0, 0, 2, 0, 2, 1, 1, 1};
        CINTEnvVars envs;
        CINTinit_int3c1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
        envs.f_gout = &CINTgout1e_int3c1e_r2_origk;
        return CINT3c1e_spheric_drv(out, dims, &envs, opt, cache, &c2s_sph_3c1e, 0, 0);
} // int3c1e_r2_origk_sph
int int3c1e_r2_origk_spinor(double complex *out, int *dims, int *shls,
                int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
        int ng[] = {0, 0, 2, 0, 2, 1, 1, 1};
        CINTEnvVars envs;
        CINTinit_int3c1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
        envs.f_gout = &CINTgout1e_int3c1e_r2_origk;
        return CINT3c1e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_3c2e1, 0, 0);
} // int3c1e_r2_origk_spinor
ALL_CINT(int3c1e_r2_origk)
ALL_CINT_FORTRAN_(int3c1e_r2_origk)

/* based on
 * '("int3c1e_r4_origk" ( \, \, r dot r r dot r))
 */
static void CINTgout1e_int3c1e_r4_origk(double *gout,
                double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
        int nf = envs->nf;
        int ix, iy, iz, n;
        double *g0 = g;
        double *g1 = g0 + envs->g_size * 3;
        double *g2 = g1 + envs->g_size * 3;
        double *g3 = g2 + envs->g_size * 3;
        double *g4 = g3 + envs->g_size * 3;
        double *g5 = g4 + envs->g_size * 3;
        double *g6 = g5 + envs->g_size * 3;
        double *g7 = g6 + envs->g_size * 3;
        double *g8 = g7 + envs->g_size * 3;
        double *g9 = g8 + envs->g_size * 3;
        double *g10 = g9 + envs->g_size * 3;
        double *g11 = g10 + envs->g_size * 3;
        double *g12 = g11 + envs->g_size * 3;
        double *g13 = g12 + envs->g_size * 3;
        double *g14 = g13 + envs->g_size * 3;
        double *g15 = g14 + envs->g_size * 3;
        double s;
        G1E_R_K(g1, g0, envs->i_l+0, envs->j_l+0, envs->k_l+3);
        G1E_R_K(g3, g1, envs->i_l+0, envs->j_l+0, envs->k_l+2);
        G1E_R_K(g4, g0, envs->i_l+0, envs->j_l+0, envs->k_l+1);
        G1E_R_K(g7, g3, envs->i_l+0, envs->j_l+0, envs->k_l+1);
        G1E_R_K(g12, g4, envs->i_l+0, envs->j_l+0, envs->k_l+0);
        G1E_R_K(g15, g7, envs->i_l+0, envs->j_l+0, envs->k_l+0);
        for (n = 0; n < nf; n++) {
                ix = idx[0+n*3];
                iy = idx[1+n*3];
                iz = idx[2+n*3];
                s = g15[ix+0]*g0[iy+0]*g0[iz+0];
                s+= g12[ix+0]*g3[iy+0]*g0[iz+0] * 2;
                s+= g12[ix+0]*g0[iy+0]*g3[iz+0] * 2;
                s+= g0[ix+0]*g15[iy+0]*g0[iz+0];
                s+= g0[ix+0]*g12[iy+0]*g3[iz+0] * 2;
                s+= g0[ix+0]*g0[iy+0]*g15[iz+0];
                if (gout_empty) {
                        gout[n] = s;
                } else {
                        gout[n]+= s;
                }
        }
}
void int3c1e_r4_origk_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
        int ng[] = {0, 0, 4, 0, 4, 1, 1, 1};
        CINTall_3c1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int3c1e_r4_origk_cart(double *out, int *dims, int *shls,
                int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
        int ng[] = {0, 0, 4, 0, 4, 1, 1, 1};
        CINTEnvVars envs;
        CINTinit_int3c1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
        envs.f_gout = &CINTgout1e_int3c1e_r4_origk;
        return CINT3c1e_cart_drv(out, dims, &envs, opt, cache, 0);
} // int3c1e_r4_origk_cart
int int3c1e_r4_origk_sph(double *out, int *dims, int *shls,
                int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
        int ng[] = {0, 0, 4, 0, 4, 1, 1, 1};
        CINTEnvVars envs;
        CINTinit_int3c1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
        envs.f_gout = &CINTgout1e_int3c1e_r4_origk;
        return CINT3c1e_spheric_drv(out, dims, &envs, opt, cache, &c2s_sph_3c1e, 0, 0);
} // int3c1e_r4_origk_sph
int int3c1e_r4_origk_spinor(double complex *out, int *dims, int *shls,
                int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
        int ng[] = {0, 0, 4, 0, 4, 1, 1, 1};
        CINTEnvVars envs;
        CINTinit_int3c1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
        envs.f_gout = &CINTgout1e_int3c1e_r4_origk;
        return CINT3c1e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_3c2e1, 0, 0);
} // int3c1e_r4_origk_spinor
ALL_CINT(int3c1e_r4_origk)
ALL_CINT_FORTRAN_(int3c1e_r4_origk)

/* based on
 * '("int3c1e_r6_origk" ( \, \, r dot r r dot r r dot r))
 */
static void CINTgout1e_int3c1e_r6_origk(double *gout,
                double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
        int nf = envs->nf;
        int ix, iy, iz, n;
        double *g0 = g;
        double *g1 = g0 + envs->g_size * 3;
        double *g2 = g1 + envs->g_size * 3;
        double *g3 = g2 + envs->g_size * 3;
        double *g4 = g3 + envs->g_size * 3;
        double *g5 = g4 + envs->g_size * 3;
        double *g6 = g5 + envs->g_size * 3;
        double *g7 = g6 + envs->g_size * 3;
        double *g8 = g7 + envs->g_size * 3;
        double *g9 = g8 + envs->g_size * 3;
        double *g10 = g9 + envs->g_size * 3;
        double *g11 = g10 + envs->g_size * 3;
        double *g12 = g11 + envs->g_size * 3;
        double *g13 = g12 + envs->g_size * 3;
        double *g14 = g13 + envs->g_size * 3;
        double *g15 = g14 + envs->g_size * 3;
        double *g16 = g15 + envs->g_size * 3;
        double *g17 = g16 + envs->g_size * 3;
        double *g18 = g17 + envs->g_size * 3;
        double *g19 = g18 + envs->g_size * 3;
        double *g20 = g19 + envs->g_size * 3;
        double *g21 = g20 + envs->g_size * 3;
        double *g22 = g21 + envs->g_size * 3;
        double *g23 = g22 + envs->g_size * 3;
        double *g24 = g23 + envs->g_size * 3;
        double *g25 = g24 + envs->g_size * 3;
        double *g26 = g25 + envs->g_size * 3;
        double *g27 = g26 + envs->g_size * 3;
        double *g28 = g27 + envs->g_size * 3;
        double *g29 = g28 + envs->g_size * 3;
        double *g30 = g29 + envs->g_size * 3;
        double *g31 = g30 + envs->g_size * 3;
        double *g32 = g31 + envs->g_size * 3;
        double *g33 = g32 + envs->g_size * 3;
        double *g34 = g33 + envs->g_size * 3;
        double *g35 = g34 + envs->g_size * 3;
        double *g36 = g35 + envs->g_size * 3;
        double *g37 = g36 + envs->g_size * 3;
        double *g38 = g37 + envs->g_size * 3;
        double *g39 = g38 + envs->g_size * 3;
        double *g40 = g39 + envs->g_size * 3;
        double *g41 = g40 + envs->g_size * 3;
        double *g42 = g41 + envs->g_size * 3;
        double *g43 = g42 + envs->g_size * 3;
        double *g44 = g43 + envs->g_size * 3;
        double *g45 = g44 + envs->g_size * 3;
        double *g46 = g45 + envs->g_size * 3;
        double *g47 = g46 + envs->g_size * 3;
        double *g48 = g47 + envs->g_size * 3;
        double *g49 = g48 + envs->g_size * 3;
        double *g50 = g49 + envs->g_size * 3;
        double *g51 = g50 + envs->g_size * 3;
        double *g52 = g51 + envs->g_size * 3;
        double *g53 = g52 + envs->g_size * 3;
        double *g54 = g53 + envs->g_size * 3;
        double *g55 = g54 + envs->g_size * 3;
        double *g56 = g55 + envs->g_size * 3;
        double *g57 = g56 + envs->g_size * 3;
        double *g58 = g57 + envs->g_size * 3;
        double *g59 = g58 + envs->g_size * 3;
        double *g60 = g59 + envs->g_size * 3;
        double *g61 = g60 + envs->g_size * 3;
        double *g62 = g61 + envs->g_size * 3;
        double *g63 = g62 + envs->g_size * 3;
        double s;
        G1E_R_K(g1, g0, envs->i_l+0, envs->j_l+0, envs->k_l+5);
        G1E_R_K(g3, g1, envs->i_l+0, envs->j_l+0, envs->k_l+4);
        G1E_R_K(g4, g0, envs->i_l+0, envs->j_l+0, envs->k_l+3);
        G1E_R_K(g7, g3, envs->i_l+0, envs->j_l+0, envs->k_l+3);
        G1E_R_K(g12, g4, envs->i_l+0, envs->j_l+0, envs->k_l+2);
        G1E_R_K(g15, g7, envs->i_l+0, envs->j_l+0, envs->k_l+2);
        G1E_R_K(g16, g0, envs->i_l+0, envs->j_l+0, envs->k_l+1);
        G1E_R_K(g28, g12, envs->i_l+0, envs->j_l+0, envs->k_l+1);
        G1E_R_K(g31, g15, envs->i_l+0, envs->j_l+0, envs->k_l+1);
        G1E_R_K(g48, g16, envs->i_l+0, envs->j_l+0, envs->k_l+0);
        G1E_R_K(g60, g28, envs->i_l+0, envs->j_l+0, envs->k_l+0);
        G1E_R_K(g63, g31, envs->i_l+0, envs->j_l+0, envs->k_l+0);
        for (n = 0; n < nf; n++) {
                ix = idx[0+n*3];
                iy = idx[1+n*3];
                iz = idx[2+n*3];
                s = g63[ix+0]*g0[iy+0]*g0[iz+0];
                s+= g60[ix+0]*g3[iy+0]*g0[iz+0] * 3;
                s+= g60[ix+0]*g0[iy+0]*g3[iz+0] * 3;
                s+= g48[ix+0]*g15[iy+0]*g0[iz+0] * 3;
                s+= g48[ix+0]*g12[iy+0]*g3[iz+0] * 6;
                s+= g48[ix+0]*g0[iy+0]*g15[iz+0] * 3;
                s+= g0[ix+0]*g63[iy+0]*g0[iz+0];
                s+= g0[ix+0]*g60[iy+0]*g3[iz+0] * 3;
                s+= g0[ix+0]*g48[iy+0]*g15[iz+0] * 3;
                s+= g0[ix+0]*g0[iy+0]*g63[iz+0];
                if (gout_empty) {
                        gout[n] = s;
                } else {
                        gout[n]+= s;
                }
        }
}
void int3c1e_r6_origk_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
        int ng[] = {0, 0, 6, 0, 6, 1, 1, 1};
        CINTall_3c1e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int3c1e_r6_origk_cart(double *out, int *dims, int *shls,
                int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
        int ng[] = {0, 0, 6, 0, 6, 1, 1, 1};
        CINTEnvVars envs;
        CINTinit_int3c1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
        envs.f_gout = &CINTgout1e_int3c1e_r6_origk;
        return CINT3c1e_cart_drv(out, dims, &envs, opt, cache, 0);
} // int3c1e_r6_origk_cart
int int3c1e_r6_origk_sph(double *out, int *dims, int *shls,
                int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
        int ng[] = {0, 0, 6, 0, 6, 1, 1, 1};
        CINTEnvVars envs;
        CINTinit_int3c1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
        envs.f_gout = &CINTgout1e_int3c1e_r6_origk;
        return CINT3c1e_spheric_drv(out, dims, &envs, opt, cache, &c2s_sph_3c1e, 0, 0);
} // int3c1e_r6_origk_sph
int int3c1e_r6_origk_spinor(double complex *out, int *dims, int *shls,
                int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
        int ng[] = {0, 0, 6, 0, 6, 1, 1, 1};
        CINTEnvVars envs;
        CINTinit_int3c1e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
        envs.f_gout = &CINTgout1e_int3c1e_r6_origk;
        return CINT3c1e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_3c2e1, 0, 0);
} // int3c1e_r6_origk_spinor
ALL_CINT(int3c1e_r6_origk)
ALL_CINT_FORTRAN_(int3c1e_r6_origk)

