/*
 * Copyright (C) 2013-  Qiming Sun <osirpt.sun@gmail.com>
 * Description: code generated by  gen-code.cl
 */
#include <stdlib.h>
#include "cint_bas.h"
#include "cart2sph.h"
#include "g1e.h"
#include "g2e.h"
#include "optimizer.h"
#include "cint1e.h"
#include "cint2e.h"
#include "misc.h"
#include "c2f.h"
/* <k SIGMA DOT P i|R12 |SIGMA DOT P j l> : i,j \in electron 1; k,l \in electron 2
 * = (SIGMA DOT P i SIGMA DOT P j|R12 |k l) */
static void CINTgout2e_int2e_spsp1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
G2E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g2, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g3, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*4+0] = + s[5] - s[7];
gout[n*4+1] = + s[6] - s[2];
gout[n*4+2] = + s[1] - s[3];
gout[n*4+3] = + s[0] + s[4] + s[8];
} else {
gout[n*4+0] += + s[5] - s[7];
gout[n*4+1] += + s[6] - s[2];
gout[n*4+2] += + s[1] - s[3];
gout[n*4+3] += + s[0] + s[4] + s[8];
}}}
void int2e_spsp1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_spsp1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_spsp1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_spsp1_cart
int int2e_spsp1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_spsp1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_spsp1_sph
int int2e_spsp1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_spsp1;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1, &c2s_sf_2e2);
} // int2e_spsp1_spinor
ALL_CINT(int2e_spsp1)
ALL_CINT_FORTRAN_(int2e_spsp1)
/* <SIGMA DOT P k SIGMA DOT P i|R12 |SIGMA DOT P j SIGMA DOT P l> : i,j \in electron 1; k,l \in electron 2
 * = (SIGMA DOT P i SIGMA DOT P j|R12 |SIGMA DOT P k SIGMA DOT P l) */
static void CINTgout2e_int2e_spsp1spsp2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
G2E_D_L(g1, g0, envs->i_l+1, envs->j_l+1, envs->k_l+1, envs->l_l+0);
G2E_D_K(g2, g0, envs->i_l+1, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_K(g3, g1, envs->i_l+1, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_J(g4, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g5, g1, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g6, g2, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g7, g3, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g8, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g9, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g10, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g11, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g12, g4, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g13, g5, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g14, g6, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g15, g7, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[81];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 81; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g15[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g14[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g14[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g13[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g12[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g12[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g13[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g12[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g12[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g11[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g10[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g10[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g9[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g8[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g8[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g9[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g8[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g8[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g11[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g10[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g10[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g9[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g8[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g8[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g9[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g8[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g8[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g7[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g6[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g6[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g5[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g4[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g4[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g5[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g4[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g4[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g3[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g2[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g2[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g1[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g0[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g0[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g1[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g0[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g0[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g3[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g2[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g2[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g1[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g0[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g0[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g1[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g0[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g0[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g7[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g6[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g6[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g5[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g4[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g4[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g5[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g4[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g4[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g3[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g2[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g2[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g1[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g0[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g0[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g1[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g0[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g0[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g3[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g2[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g2[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g1[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g0[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g0[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g1[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g0[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g0[ix+i] * g0[iy+i] * g15[iz+i];
}
if (gout_empty) {
gout[n*16+0] = + s[50] - s[68] - s[52] + s[70];
gout[n*16+1] = + s[59] - s[23] - s[61] + s[25];
gout[n*16+2] = + s[14] - s[32] - s[16] + s[34];
gout[n*16+3] = + s[5] + s[41] + s[77] - s[7] - s[43] - s[79];
gout[n*16+4] = + s[51] - s[69] - s[47] + s[65];
gout[n*16+5] = + s[60] - s[24] - s[56] + s[20];
gout[n*16+6] = + s[15] - s[33] - s[11] + s[29];
gout[n*16+7] = + s[6] + s[42] + s[78] - s[2] - s[38] - s[74];
gout[n*16+8] = + s[46] - s[64] - s[48] + s[66];
gout[n*16+9] = + s[55] - s[19] - s[57] + s[21];
gout[n*16+10] = + s[10] - s[28] - s[12] + s[30];
gout[n*16+11] = + s[1] + s[37] + s[73] - s[3] - s[39] - s[75];
gout[n*16+12] = + s[45] - s[63] + s[49] - s[67] + s[53] - s[71];
gout[n*16+13] = + s[54] - s[18] + s[58] - s[22] + s[62] - s[26];
gout[n*16+14] = + s[9] - s[27] + s[13] - s[31] + s[17] - s[35];
gout[n*16+15] = + s[0] + s[36] + s[72] + s[4] + s[40] + s[76] + s[8] + s[44] + s[80];
} else {
gout[n*16+0] += + s[50] - s[68] - s[52] + s[70];
gout[n*16+1] += + s[59] - s[23] - s[61] + s[25];
gout[n*16+2] += + s[14] - s[32] - s[16] + s[34];
gout[n*16+3] += + s[5] + s[41] + s[77] - s[7] - s[43] - s[79];
gout[n*16+4] += + s[51] - s[69] - s[47] + s[65];
gout[n*16+5] += + s[60] - s[24] - s[56] + s[20];
gout[n*16+6] += + s[15] - s[33] - s[11] + s[29];
gout[n*16+7] += + s[6] + s[42] + s[78] - s[2] - s[38] - s[74];
gout[n*16+8] += + s[46] - s[64] - s[48] + s[66];
gout[n*16+9] += + s[55] - s[19] - s[57] + s[21];
gout[n*16+10] += + s[10] - s[28] - s[12] + s[30];
gout[n*16+11] += + s[1] + s[37] + s[73] - s[3] - s[39] - s[75];
gout[n*16+12] += + s[45] - s[63] + s[49] - s[67] + s[53] - s[71];
gout[n*16+13] += + s[54] - s[18] + s[58] - s[22] + s[62] - s[26];
gout[n*16+14] += + s[9] - s[27] + s[13] - s[31] + s[17] - s[35];
gout[n*16+15] += + s[0] + s[36] + s[72] + s[4] + s[40] + s[76] + s[8] + s[44] + s[80];
}}}
void int2e_spsp1spsp2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_spsp1spsp2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_spsp1spsp2;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_spsp1spsp2_cart
int int2e_spsp1spsp2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_spsp1spsp2;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_spsp1spsp2_sph
int int2e_spsp1spsp2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_spsp1spsp2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1, &c2s_si_2e2);
} // int2e_spsp1spsp2_spinor
ALL_CINT(int2e_spsp1spsp2)
ALL_CINT_FORTRAN_(int2e_spsp1spsp2)
/* <k SIGMA DOT R i|R12 |SIGMA DOT R j l> : i,j \in electron 1; k,l \in electron 2
 * = (SIGMA DOT R i SIGMA DOT R j|R12 |k l) */
static void CINTgout2e_int2e_srsr1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
G2E_R_J(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R_I(g2, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g3, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*4+0] = + s[5] - s[7];
gout[n*4+1] = + s[6] - s[2];
gout[n*4+2] = + s[1] - s[3];
gout[n*4+3] = + s[0] + s[4] + s[8];
} else {
gout[n*4+0] += + s[5] - s[7];
gout[n*4+1] += + s[6] - s[2];
gout[n*4+2] += + s[1] - s[3];
gout[n*4+3] += + s[0] + s[4] + s[8];
}}}
void int2e_srsr1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_srsr1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_srsr1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_srsr1_cart
int int2e_srsr1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_srsr1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_srsr1_sph
int int2e_srsr1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_srsr1;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1, &c2s_sf_2e2);
} // int2e_srsr1_spinor
ALL_CINT(int2e_srsr1)
ALL_CINT_FORTRAN_(int2e_srsr1)
/* <SIGMA DOT R k SIGMA DOT R i|R12 |SIGMA DOT R j SIGMA DOT R l> : i,j \in electron 1; k,l \in electron 2
 * = (SIGMA DOT R i SIGMA DOT R j|R12 |SIGMA DOT R k SIGMA DOT R l) */
static void CINTgout2e_int2e_srsr1srsr2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
G2E_R_L(g1, g0, envs->i_l+1, envs->j_l+1, envs->k_l+1, envs->l_l+0);
G2E_R_K(g2, g0, envs->i_l+1, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_R_K(g3, g1, envs->i_l+1, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_R_J(g4, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R_J(g5, g1, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R_J(g6, g2, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R_J(g7, g3, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R_I(g8, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g9, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g10, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g11, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g12, g4, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g13, g5, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g14, g6, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g15, g7, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[81];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 81; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g15[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g14[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g14[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g13[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g12[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g12[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g13[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g12[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g12[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g11[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g10[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g10[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g9[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g8[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g8[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g9[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g8[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g8[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g11[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g10[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g10[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g9[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g8[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g8[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g9[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g8[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g8[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g7[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g6[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g6[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g5[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g4[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g4[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g5[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g4[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g4[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g3[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g2[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g2[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g1[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g0[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g0[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g1[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g0[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g0[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g3[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g2[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g2[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g1[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g0[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g0[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g1[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g0[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g0[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g7[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g6[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g6[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g5[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g4[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g4[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g5[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g4[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g4[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g3[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g2[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g2[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g1[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g0[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g0[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g1[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g0[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g0[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g3[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g2[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g2[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g1[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g0[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g0[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g1[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g0[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g0[ix+i] * g0[iy+i] * g15[iz+i];
}
if (gout_empty) {
gout[n*16+0] = + s[50] - s[68] - s[52] + s[70];
gout[n*16+1] = + s[59] - s[23] - s[61] + s[25];
gout[n*16+2] = + s[14] - s[32] - s[16] + s[34];
gout[n*16+3] = + s[5] + s[41] + s[77] - s[7] - s[43] - s[79];
gout[n*16+4] = + s[51] - s[69] - s[47] + s[65];
gout[n*16+5] = + s[60] - s[24] - s[56] + s[20];
gout[n*16+6] = + s[15] - s[33] - s[11] + s[29];
gout[n*16+7] = + s[6] + s[42] + s[78] - s[2] - s[38] - s[74];
gout[n*16+8] = + s[46] - s[64] - s[48] + s[66];
gout[n*16+9] = + s[55] - s[19] - s[57] + s[21];
gout[n*16+10] = + s[10] - s[28] - s[12] + s[30];
gout[n*16+11] = + s[1] + s[37] + s[73] - s[3] - s[39] - s[75];
gout[n*16+12] = + s[45] - s[63] + s[49] - s[67] + s[53] - s[71];
gout[n*16+13] = + s[54] - s[18] + s[58] - s[22] + s[62] - s[26];
gout[n*16+14] = + s[9] - s[27] + s[13] - s[31] + s[17] - s[35];
gout[n*16+15] = + s[0] + s[36] + s[72] + s[4] + s[40] + s[76] + s[8] + s[44] + s[80];
} else {
gout[n*16+0] += + s[50] - s[68] - s[52] + s[70];
gout[n*16+1] += + s[59] - s[23] - s[61] + s[25];
gout[n*16+2] += + s[14] - s[32] - s[16] + s[34];
gout[n*16+3] += + s[5] + s[41] + s[77] - s[7] - s[43] - s[79];
gout[n*16+4] += + s[51] - s[69] - s[47] + s[65];
gout[n*16+5] += + s[60] - s[24] - s[56] + s[20];
gout[n*16+6] += + s[15] - s[33] - s[11] + s[29];
gout[n*16+7] += + s[6] + s[42] + s[78] - s[2] - s[38] - s[74];
gout[n*16+8] += + s[46] - s[64] - s[48] + s[66];
gout[n*16+9] += + s[55] - s[19] - s[57] + s[21];
gout[n*16+10] += + s[10] - s[28] - s[12] + s[30];
gout[n*16+11] += + s[1] + s[37] + s[73] - s[3] - s[39] - s[75];
gout[n*16+12] += + s[45] - s[63] + s[49] - s[67] + s[53] - s[71];
gout[n*16+13] += + s[54] - s[18] + s[58] - s[22] + s[62] - s[26];
gout[n*16+14] += + s[9] - s[27] + s[13] - s[31] + s[17] - s[35];
gout[n*16+15] += + s[0] + s[36] + s[72] + s[4] + s[40] + s[76] + s[8] + s[44] + s[80];
}}}
void int2e_srsr1srsr2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_srsr1srsr2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_srsr1srsr2;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_srsr1srsr2_cart
int int2e_srsr1srsr2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_srsr1srsr2;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_srsr1srsr2_sph
int int2e_srsr1srsr2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_srsr1srsr2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1, &c2s_si_2e2);
} // int2e_srsr1srsr2_spinor
ALL_CINT(int2e_srsr1srsr2)
ALL_CINT_FORTRAN_(int2e_srsr1srsr2)
/* <k RC CROSS SIGMA i|R12 |SIGMA DOT P j l> : i,j \in electron 1; k,l \in electron 2
 * = (RC CROSS SIGMA i SIGMA DOT P j|R12 |k l) */
static void CINTgout2e_int2e_cg_sa10sp1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double dri[3];
dri[0] = envs->ri[0] - envs->env[PTR_COMMON_ORIG+0];
dri[1] = envs->ri[1] - envs->env[PTR_COMMON_ORIG+1];
dri[2] = envs->ri[2] - envs->env[PTR_COMMON_ORIG+2];
G2E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_RCI(g2, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_RCI(g3, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*12+0] = + s[8] + s[4];
gout[n*12+1] = - s[3];
gout[n*12+2] = - s[6];
gout[n*12+3] = + s[7] - s[5];
gout[n*12+4] = - s[1];
gout[n*12+5] = + s[0] + s[8];
gout[n*12+6] = - s[7];
gout[n*12+7] = - s[6] + s[2];
gout[n*12+8] = - s[2];
gout[n*12+9] = - s[5];
gout[n*12+10] = + s[4] + s[0];
gout[n*12+11] = + s[3] - s[1];
} else {
gout[n*12+0] += + s[8] + s[4];
gout[n*12+1] += - s[3];
gout[n*12+2] += - s[6];
gout[n*12+3] += + s[7] - s[5];
gout[n*12+4] += - s[1];
gout[n*12+5] += + s[0] + s[8];
gout[n*12+6] += - s[7];
gout[n*12+7] += - s[6] + s[2];
gout[n*12+8] += - s[2];
gout[n*12+9] += - s[5];
gout[n*12+10] += + s[4] + s[0];
gout[n*12+11] += + s[3] - s[1];
}}}
void int2e_cg_sa10sp1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_cg_sa10sp1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_cg_sa10sp1;
envs.common_factor *= 0.5;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_cg_sa10sp1_cart
int int2e_cg_sa10sp1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_cg_sa10sp1;
envs.common_factor *= 0.5;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_cg_sa10sp1_sph
int int2e_cg_sa10sp1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_cg_sa10sp1;
envs.common_factor *= 0.5;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_sf_2e2);
} // int2e_cg_sa10sp1_spinor
ALL_CINT(int2e_cg_sa10sp1)
ALL_CINT_FORTRAN_(int2e_cg_sa10sp1)
/* <SIGMA DOT P k RC CROSS SIGMA i|R12 |SIGMA DOT P j SIGMA DOT P l> : i,j \in electron 1; k,l \in electron 2
 * = (RC CROSS SIGMA i SIGMA DOT P j|R12 |SIGMA DOT P k SIGMA DOT P l) */
static void CINTgout2e_int2e_cg_sa10sp1spsp2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
double dri[3];
dri[0] = envs->ri[0] - envs->env[PTR_COMMON_ORIG+0];
dri[1] = envs->ri[1] - envs->env[PTR_COMMON_ORIG+1];
dri[2] = envs->ri[2] - envs->env[PTR_COMMON_ORIG+2];
G2E_D_L(g1, g0, envs->i_l+1, envs->j_l+1, envs->k_l+1, envs->l_l+0);
G2E_D_K(g2, g0, envs->i_l+1, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_K(g3, g1, envs->i_l+1, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_J(g4, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g5, g1, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g6, g2, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g7, g3, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_RCI(g8, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_RCI(g9, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_RCI(g10, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_RCI(g11, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_RCI(g12, g4, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_RCI(g13, g5, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_RCI(g14, g6, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_RCI(g15, g7, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[81];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 81; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g15[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g14[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g14[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g13[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g12[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g12[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g13[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g12[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g12[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g11[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g10[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g10[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g9[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g8[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g8[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g9[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g8[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g8[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g11[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g10[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g10[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g9[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g8[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g8[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g9[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g8[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g8[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g7[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g6[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g6[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g5[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g4[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g4[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g5[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g4[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g4[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g3[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g2[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g2[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g1[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g0[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g0[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g1[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g0[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g0[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g3[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g2[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g2[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g1[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g0[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g0[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g1[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g0[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g0[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g7[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g6[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g6[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g5[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g4[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g4[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g5[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g4[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g4[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g3[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g2[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g2[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g1[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g0[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g0[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g1[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g0[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g0[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g3[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g2[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g2[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g1[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g0[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g0[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g1[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g0[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g0[ix+i] * g0[iy+i] * g15[iz+i];
}
if (gout_empty) {
gout[n*48+0] = + s[77] + s[41] - s[79] - s[43];
gout[n*48+1] = - s[32] + s[34];
gout[n*48+2] = - s[59] + s[61];
gout[n*48+3] = + s[68] - s[50] - s[70] + s[52];
gout[n*48+4] = + s[78] + s[42] - s[74] - s[38];
gout[n*48+5] = - s[33] + s[29];
gout[n*48+6] = - s[60] + s[56];
gout[n*48+7] = + s[69] - s[51] - s[65] + s[47];
gout[n*48+8] = + s[73] + s[37] - s[75] - s[39];
gout[n*48+9] = - s[28] + s[30];
gout[n*48+10] = - s[55] + s[57];
gout[n*48+11] = + s[64] - s[46] - s[66] + s[48];
gout[n*48+12] = + s[72] + s[36] + s[76] + s[40] + s[80] + s[44];
gout[n*48+13] = - s[27] - s[31] - s[35];
gout[n*48+14] = - s[54] - s[58] - s[62];
gout[n*48+15] = + s[63] - s[45] + s[67] - s[49] + s[71] - s[53];
gout[n*48+16] = - s[14] + s[16];
gout[n*48+17] = + s[5] + s[77] - s[7] - s[79];
gout[n*48+18] = - s[68] + s[70];
gout[n*48+19] = - s[59] + s[23] + s[61] - s[25];
gout[n*48+20] = - s[15] + s[11];
gout[n*48+21] = + s[6] + s[78] - s[2] - s[74];
gout[n*48+22] = - s[69] + s[65];
gout[n*48+23] = - s[60] + s[24] + s[56] - s[20];
gout[n*48+24] = - s[10] + s[12];
gout[n*48+25] = + s[1] + s[73] - s[3] - s[75];
gout[n*48+26] = - s[64] + s[66];
gout[n*48+27] = - s[55] + s[19] + s[57] - s[21];
gout[n*48+28] = - s[9] - s[13] - s[17];
gout[n*48+29] = + s[0] + s[72] + s[4] + s[76] + s[8] + s[80];
gout[n*48+30] = - s[63] - s[67] - s[71];
gout[n*48+31] = - s[54] + s[18] - s[58] + s[22] - s[62] + s[26];
gout[n*48+32] = - s[23] + s[25];
gout[n*48+33] = - s[50] + s[52];
gout[n*48+34] = + s[41] + s[5] - s[43] - s[7];
gout[n*48+35] = + s[32] - s[14] - s[34] + s[16];
gout[n*48+36] = - s[24] + s[20];
gout[n*48+37] = - s[51] + s[47];
gout[n*48+38] = + s[42] + s[6] - s[38] - s[2];
gout[n*48+39] = + s[33] - s[15] - s[29] + s[11];
gout[n*48+40] = - s[19] + s[21];
gout[n*48+41] = - s[46] + s[48];
gout[n*48+42] = + s[37] + s[1] - s[39] - s[3];
gout[n*48+43] = + s[28] - s[10] - s[30] + s[12];
gout[n*48+44] = - s[18] - s[22] - s[26];
gout[n*48+45] = - s[45] - s[49] - s[53];
gout[n*48+46] = + s[36] + s[0] + s[40] + s[4] + s[44] + s[8];
gout[n*48+47] = + s[27] - s[9] + s[31] - s[13] + s[35] - s[17];
} else {
gout[n*48+0] += + s[77] + s[41] - s[79] - s[43];
gout[n*48+1] += - s[32] + s[34];
gout[n*48+2] += - s[59] + s[61];
gout[n*48+3] += + s[68] - s[50] - s[70] + s[52];
gout[n*48+4] += + s[78] + s[42] - s[74] - s[38];
gout[n*48+5] += - s[33] + s[29];
gout[n*48+6] += - s[60] + s[56];
gout[n*48+7] += + s[69] - s[51] - s[65] + s[47];
gout[n*48+8] += + s[73] + s[37] - s[75] - s[39];
gout[n*48+9] += - s[28] + s[30];
gout[n*48+10] += - s[55] + s[57];
gout[n*48+11] += + s[64] - s[46] - s[66] + s[48];
gout[n*48+12] += + s[72] + s[36] + s[76] + s[40] + s[80] + s[44];
gout[n*48+13] += - s[27] - s[31] - s[35];
gout[n*48+14] += - s[54] - s[58] - s[62];
gout[n*48+15] += + s[63] - s[45] + s[67] - s[49] + s[71] - s[53];
gout[n*48+16] += - s[14] + s[16];
gout[n*48+17] += + s[5] + s[77] - s[7] - s[79];
gout[n*48+18] += - s[68] + s[70];
gout[n*48+19] += - s[59] + s[23] + s[61] - s[25];
gout[n*48+20] += - s[15] + s[11];
gout[n*48+21] += + s[6] + s[78] - s[2] - s[74];
gout[n*48+22] += - s[69] + s[65];
gout[n*48+23] += - s[60] + s[24] + s[56] - s[20];
gout[n*48+24] += - s[10] + s[12];
gout[n*48+25] += + s[1] + s[73] - s[3] - s[75];
gout[n*48+26] += - s[64] + s[66];
gout[n*48+27] += - s[55] + s[19] + s[57] - s[21];
gout[n*48+28] += - s[9] - s[13] - s[17];
gout[n*48+29] += + s[0] + s[72] + s[4] + s[76] + s[8] + s[80];
gout[n*48+30] += - s[63] - s[67] - s[71];
gout[n*48+31] += - s[54] + s[18] - s[58] + s[22] - s[62] + s[26];
gout[n*48+32] += - s[23] + s[25];
gout[n*48+33] += - s[50] + s[52];
gout[n*48+34] += + s[41] + s[5] - s[43] - s[7];
gout[n*48+35] += + s[32] - s[14] - s[34] + s[16];
gout[n*48+36] += - s[24] + s[20];
gout[n*48+37] += - s[51] + s[47];
gout[n*48+38] += + s[42] + s[6] - s[38] - s[2];
gout[n*48+39] += + s[33] - s[15] - s[29] + s[11];
gout[n*48+40] += - s[19] + s[21];
gout[n*48+41] += - s[46] + s[48];
gout[n*48+42] += + s[37] + s[1] - s[39] - s[3];
gout[n*48+43] += + s[28] - s[10] - s[30] + s[12];
gout[n*48+44] += - s[18] - s[22] - s[26];
gout[n*48+45] += - s[45] - s[49] - s[53];
gout[n*48+46] += + s[36] + s[0] + s[40] + s[4] + s[44] + s[8];
gout[n*48+47] += + s[27] - s[9] + s[31] - s[13] + s[35] - s[17];
}}}
void int2e_cg_sa10sp1spsp2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_cg_sa10sp1spsp2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_cg_sa10sp1spsp2;
envs.common_factor *= 0.5;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_cg_sa10sp1spsp2_cart
int int2e_cg_sa10sp1spsp2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_cg_sa10sp1spsp2;
envs.common_factor *= 0.5;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_cg_sa10sp1spsp2_sph
int int2e_cg_sa10sp1spsp2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_cg_sa10sp1spsp2;
envs.common_factor *= 0.5;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_si_2e2);
} // int2e_cg_sa10sp1spsp2_spinor
ALL_CINT(int2e_cg_sa10sp1spsp2)
ALL_CINT_FORTRAN_(int2e_cg_sa10sp1spsp2)
/* <k R CROSS SIGMA i|R12 |SIGMA DOT P j l> : i,j \in electron 1; k,l \in electron 2
 * = (R CROSS SIGMA i SIGMA DOT P j|R12 |k l) */
static void CINTgout2e_int2e_giao_sa10sp1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
G2E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R_I(g2, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g3, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*12+0] = + s[8] + s[4];
gout[n*12+1] = - s[3];
gout[n*12+2] = - s[6];
gout[n*12+3] = + s[7] - s[5];
gout[n*12+4] = - s[1];
gout[n*12+5] = + s[0] + s[8];
gout[n*12+6] = - s[7];
gout[n*12+7] = - s[6] + s[2];
gout[n*12+8] = - s[2];
gout[n*12+9] = - s[5];
gout[n*12+10] = + s[4] + s[0];
gout[n*12+11] = + s[3] - s[1];
} else {
gout[n*12+0] += + s[8] + s[4];
gout[n*12+1] += - s[3];
gout[n*12+2] += - s[6];
gout[n*12+3] += + s[7] - s[5];
gout[n*12+4] += - s[1];
gout[n*12+5] += + s[0] + s[8];
gout[n*12+6] += - s[7];
gout[n*12+7] += - s[6] + s[2];
gout[n*12+8] += - s[2];
gout[n*12+9] += - s[5];
gout[n*12+10] += + s[4] + s[0];
gout[n*12+11] += + s[3] - s[1];
}}}
void int2e_giao_sa10sp1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_giao_sa10sp1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_giao_sa10sp1;
envs.common_factor *= 0.5;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_giao_sa10sp1_cart
int int2e_giao_sa10sp1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_giao_sa10sp1;
envs.common_factor *= 0.5;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_giao_sa10sp1_sph
int int2e_giao_sa10sp1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_giao_sa10sp1;
envs.common_factor *= 0.5;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_sf_2e2);
} // int2e_giao_sa10sp1_spinor
ALL_CINT(int2e_giao_sa10sp1)
ALL_CINT_FORTRAN_(int2e_giao_sa10sp1)
/* <SIGMA DOT P k R CROSS SIGMA i|R12 |SIGMA DOT P j SIGMA DOT P l> : i,j \in electron 1; k,l \in electron 2
 * = (R CROSS SIGMA i SIGMA DOT P j|R12 |SIGMA DOT P k SIGMA DOT P l) */
static void CINTgout2e_int2e_giao_sa10sp1spsp2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
G2E_D_L(g1, g0, envs->i_l+1, envs->j_l+1, envs->k_l+1, envs->l_l+0);
G2E_D_K(g2, g0, envs->i_l+1, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_K(g3, g1, envs->i_l+1, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_J(g4, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g5, g1, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g6, g2, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g7, g3, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R_I(g8, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g9, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g10, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g11, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g12, g4, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g13, g5, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g14, g6, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R_I(g15, g7, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[81];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 81; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g15[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g14[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g14[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g13[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g12[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g12[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g13[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g12[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g12[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g11[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g10[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g10[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g9[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g8[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g8[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g9[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g8[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g8[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g11[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g10[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g10[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g9[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g8[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g8[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g9[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g8[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g8[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g7[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g6[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g6[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g5[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g4[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g4[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g5[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g4[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g4[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g3[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g2[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g2[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g1[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g0[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g0[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g1[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g0[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g0[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g3[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g2[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g2[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g1[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g0[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g0[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g1[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g0[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g0[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g7[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g6[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g6[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g5[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g4[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g4[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g5[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g4[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g4[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g3[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g2[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g2[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g1[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g0[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g0[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g1[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g0[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g0[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g3[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g2[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g2[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g1[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g0[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g0[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g1[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g0[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g0[ix+i] * g0[iy+i] * g15[iz+i];
}
if (gout_empty) {
gout[n*48+0] = + s[77] + s[41] - s[79] - s[43];
gout[n*48+1] = - s[32] + s[34];
gout[n*48+2] = - s[59] + s[61];
gout[n*48+3] = + s[68] - s[50] - s[70] + s[52];
gout[n*48+4] = + s[78] + s[42] - s[74] - s[38];
gout[n*48+5] = - s[33] + s[29];
gout[n*48+6] = - s[60] + s[56];
gout[n*48+7] = + s[69] - s[51] - s[65] + s[47];
gout[n*48+8] = + s[73] + s[37] - s[75] - s[39];
gout[n*48+9] = - s[28] + s[30];
gout[n*48+10] = - s[55] + s[57];
gout[n*48+11] = + s[64] - s[46] - s[66] + s[48];
gout[n*48+12] = + s[72] + s[36] + s[76] + s[40] + s[80] + s[44];
gout[n*48+13] = - s[27] - s[31] - s[35];
gout[n*48+14] = - s[54] - s[58] - s[62];
gout[n*48+15] = + s[63] - s[45] + s[67] - s[49] + s[71] - s[53];
gout[n*48+16] = - s[14] + s[16];
gout[n*48+17] = + s[5] + s[77] - s[7] - s[79];
gout[n*48+18] = - s[68] + s[70];
gout[n*48+19] = - s[59] + s[23] + s[61] - s[25];
gout[n*48+20] = - s[15] + s[11];
gout[n*48+21] = + s[6] + s[78] - s[2] - s[74];
gout[n*48+22] = - s[69] + s[65];
gout[n*48+23] = - s[60] + s[24] + s[56] - s[20];
gout[n*48+24] = - s[10] + s[12];
gout[n*48+25] = + s[1] + s[73] - s[3] - s[75];
gout[n*48+26] = - s[64] + s[66];
gout[n*48+27] = - s[55] + s[19] + s[57] - s[21];
gout[n*48+28] = - s[9] - s[13] - s[17];
gout[n*48+29] = + s[0] + s[72] + s[4] + s[76] + s[8] + s[80];
gout[n*48+30] = - s[63] - s[67] - s[71];
gout[n*48+31] = - s[54] + s[18] - s[58] + s[22] - s[62] + s[26];
gout[n*48+32] = - s[23] + s[25];
gout[n*48+33] = - s[50] + s[52];
gout[n*48+34] = + s[41] + s[5] - s[43] - s[7];
gout[n*48+35] = + s[32] - s[14] - s[34] + s[16];
gout[n*48+36] = - s[24] + s[20];
gout[n*48+37] = - s[51] + s[47];
gout[n*48+38] = + s[42] + s[6] - s[38] - s[2];
gout[n*48+39] = + s[33] - s[15] - s[29] + s[11];
gout[n*48+40] = - s[19] + s[21];
gout[n*48+41] = - s[46] + s[48];
gout[n*48+42] = + s[37] + s[1] - s[39] - s[3];
gout[n*48+43] = + s[28] - s[10] - s[30] + s[12];
gout[n*48+44] = - s[18] - s[22] - s[26];
gout[n*48+45] = - s[45] - s[49] - s[53];
gout[n*48+46] = + s[36] + s[0] + s[40] + s[4] + s[44] + s[8];
gout[n*48+47] = + s[27] - s[9] + s[31] - s[13] + s[35] - s[17];
} else {
gout[n*48+0] += + s[77] + s[41] - s[79] - s[43];
gout[n*48+1] += - s[32] + s[34];
gout[n*48+2] += - s[59] + s[61];
gout[n*48+3] += + s[68] - s[50] - s[70] + s[52];
gout[n*48+4] += + s[78] + s[42] - s[74] - s[38];
gout[n*48+5] += - s[33] + s[29];
gout[n*48+6] += - s[60] + s[56];
gout[n*48+7] += + s[69] - s[51] - s[65] + s[47];
gout[n*48+8] += + s[73] + s[37] - s[75] - s[39];
gout[n*48+9] += - s[28] + s[30];
gout[n*48+10] += - s[55] + s[57];
gout[n*48+11] += + s[64] - s[46] - s[66] + s[48];
gout[n*48+12] += + s[72] + s[36] + s[76] + s[40] + s[80] + s[44];
gout[n*48+13] += - s[27] - s[31] - s[35];
gout[n*48+14] += - s[54] - s[58] - s[62];
gout[n*48+15] += + s[63] - s[45] + s[67] - s[49] + s[71] - s[53];
gout[n*48+16] += - s[14] + s[16];
gout[n*48+17] += + s[5] + s[77] - s[7] - s[79];
gout[n*48+18] += - s[68] + s[70];
gout[n*48+19] += - s[59] + s[23] + s[61] - s[25];
gout[n*48+20] += - s[15] + s[11];
gout[n*48+21] += + s[6] + s[78] - s[2] - s[74];
gout[n*48+22] += - s[69] + s[65];
gout[n*48+23] += - s[60] + s[24] + s[56] - s[20];
gout[n*48+24] += - s[10] + s[12];
gout[n*48+25] += + s[1] + s[73] - s[3] - s[75];
gout[n*48+26] += - s[64] + s[66];
gout[n*48+27] += - s[55] + s[19] + s[57] - s[21];
gout[n*48+28] += - s[9] - s[13] - s[17];
gout[n*48+29] += + s[0] + s[72] + s[4] + s[76] + s[8] + s[80];
gout[n*48+30] += - s[63] - s[67] - s[71];
gout[n*48+31] += - s[54] + s[18] - s[58] + s[22] - s[62] + s[26];
gout[n*48+32] += - s[23] + s[25];
gout[n*48+33] += - s[50] + s[52];
gout[n*48+34] += + s[41] + s[5] - s[43] - s[7];
gout[n*48+35] += + s[32] - s[14] - s[34] + s[16];
gout[n*48+36] += - s[24] + s[20];
gout[n*48+37] += - s[51] + s[47];
gout[n*48+38] += + s[42] + s[6] - s[38] - s[2];
gout[n*48+39] += + s[33] - s[15] - s[29] + s[11];
gout[n*48+40] += - s[19] + s[21];
gout[n*48+41] += - s[46] + s[48];
gout[n*48+42] += + s[37] + s[1] - s[39] - s[3];
gout[n*48+43] += + s[28] - s[10] - s[30] + s[12];
gout[n*48+44] += - s[18] - s[22] - s[26];
gout[n*48+45] += - s[45] - s[49] - s[53];
gout[n*48+46] += + s[36] + s[0] + s[40] + s[4] + s[44] + s[8];
gout[n*48+47] += + s[27] - s[9] + s[31] - s[13] + s[35] - s[17];
}}}
void int2e_giao_sa10sp1spsp2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_giao_sa10sp1spsp2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_giao_sa10sp1spsp2;
envs.common_factor *= 0.5;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_giao_sa10sp1spsp2_cart
int int2e_giao_sa10sp1spsp2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_giao_sa10sp1spsp2;
envs.common_factor *= 0.5;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_giao_sa10sp1spsp2_sph
int int2e_giao_sa10sp1spsp2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_giao_sa10sp1spsp2;
envs.common_factor *= 0.5;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_si_2e2);
} // int2e_giao_sa10sp1spsp2_spinor
ALL_CINT(int2e_giao_sa10sp1spsp2)
ALL_CINT_FORTRAN_(int2e_giao_sa10sp1spsp2)
/* <k G i|R12 |j l> : i,j \in electron 1; k,l \in electron 2
 * = (G i j|R12 |k l) */
static void CINTgout2e_int2e_g1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double rirj[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
double c[3];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
G2E_R0I(g1, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[3];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
switch (nrys_roots) {
case 1:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0];
break;
case 2:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1];
break;
case 3:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2];
break;
case 4:
s[0] = + g1[ix+0]*g0[iy+0]*g0[iz+0]+ g1[ix+1]*g0[iy+1]*g0[iz+1]+ g1[ix+2]*g0[iy+2]*g0[iz+2]+ g1[ix+3]*g0[iy+3]*g0[iz+3];
s[1] = + g0[ix+0]*g1[iy+0]*g0[iz+0]+ g0[ix+1]*g1[iy+1]*g0[iz+1]+ g0[ix+2]*g1[iy+2]*g0[iz+2]+ g0[ix+3]*g1[iy+3]*g0[iz+3];
s[2] = + g0[ix+0]*g0[iy+0]*g1[iz+0]+ g0[ix+1]*g0[iy+1]*g1[iz+1]+ g0[ix+2]*g0[iy+2]*g1[iz+2]+ g0[ix+3]*g0[iy+3]*g1[iz+3];
break;
default:
for (i = 0; i < 3; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g1[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g0[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g0[ix+i] * g0[iy+i] * g1[iz+i];
} break;}
if (gout_empty) {
gout[n*3+0] = + c[1]*s[2] - c[2]*s[1];
gout[n*3+1] = + c[2]*s[0] - c[0]*s[2];
gout[n*3+2] = + c[0]*s[1] - c[1]*s[0];
} else {
gout[n*3+0] += + c[1]*s[2] - c[2]*s[1];
gout[n*3+1] += + c[2]*s[0] - c[0]*s[2];
gout[n*3+2] += + c[0]*s[1] - c[1]*s[0];
}}}
void int2e_g1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_g1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_g1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = envs.nfk * envs.x_ctr[2];
counts[3] = envs.nfl * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_g1_cart
int int2e_g1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_g1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = (envs.k_l*2+1) * envs.x_ctr[2];
counts[3] = (envs.l_l*2+1) * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_g1_sph
int int2e_g1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 0, 0, 1, 1, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_g1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = CINTcgto_spinor(envs.shls[2], envs.bas);
counts[3] = CINTcgto_spinor(envs.shls[3], envs.bas);
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1i, &c2s_sf_2e2);
} // int2e_g1_spinor
ALL_CINT(int2e_g1)
ALL_CINT_FORTRAN_(int2e_g1)
/* <k G SIGMA DOT P i|R12 |SIGMA DOT P j l> : i,j \in electron 1; k,l \in electron 2
 * = (G SIGMA DOT P i SIGMA DOT P j|R12 |k l) */
static void CINTgout2e_int2e_spgsp1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double rirj[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
double c[3];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
G2E_D_J(g1, g0, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R0I(g2, g0, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g3, g1, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g4, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g5, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g6, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g7, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[27];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 27; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g7[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g6[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g6[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g5[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g4[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g4[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g5[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g4[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g4[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g3[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g2[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g2[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g1[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g0[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g0[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g1[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g0[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g0[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g3[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g2[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g2[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g1[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g0[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g0[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g1[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g0[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g0[ix+i] * g0[iy+i] * g7[iz+i];
}
if (gout_empty) {
gout[n*12+0] = + c[1]*s[17] - c[2]*s[14] - c[1]*s[25] + c[2]*s[22];
gout[n*12+1] = + c[1]*s[24] - c[2]*s[21] - c[1]*s[8] + c[2]*s[5];
gout[n*12+2] = + c[1]*s[7] - c[2]*s[4] - c[1]*s[15] + c[2]*s[12];
gout[n*12+3] = + c[1]*s[6] - c[2]*s[3] + c[1]*s[16] - c[2]*s[13] + c[1]*s[26] - c[2]*s[23];
gout[n*12+4] = + c[2]*s[11] - c[0]*s[17] - c[2]*s[19] + c[0]*s[25];
gout[n*12+5] = + c[2]*s[18] - c[0]*s[24] - c[2]*s[2] + c[0]*s[8];
gout[n*12+6] = + c[2]*s[1] - c[0]*s[7] - c[2]*s[9] + c[0]*s[15];
gout[n*12+7] = + c[2]*s[0] - c[0]*s[6] + c[2]*s[10] - c[0]*s[16] + c[2]*s[20] - c[0]*s[26];
gout[n*12+8] = + c[0]*s[14] - c[1]*s[11] - c[0]*s[22] + c[1]*s[19];
gout[n*12+9] = + c[0]*s[21] - c[1]*s[18] - c[0]*s[5] + c[1]*s[2];
gout[n*12+10] = + c[0]*s[4] - c[1]*s[1] - c[0]*s[12] + c[1]*s[9];
gout[n*12+11] = + c[0]*s[3] - c[1]*s[0] + c[0]*s[13] - c[1]*s[10] + c[0]*s[23] - c[1]*s[20];
} else {
gout[n*12+0] += + c[1]*s[17] - c[2]*s[14] - c[1]*s[25] + c[2]*s[22];
gout[n*12+1] += + c[1]*s[24] - c[2]*s[21] - c[1]*s[8] + c[2]*s[5];
gout[n*12+2] += + c[1]*s[7] - c[2]*s[4] - c[1]*s[15] + c[2]*s[12];
gout[n*12+3] += + c[1]*s[6] - c[2]*s[3] + c[1]*s[16] - c[2]*s[13] + c[1]*s[26] - c[2]*s[23];
gout[n*12+4] += + c[2]*s[11] - c[0]*s[17] - c[2]*s[19] + c[0]*s[25];
gout[n*12+5] += + c[2]*s[18] - c[0]*s[24] - c[2]*s[2] + c[0]*s[8];
gout[n*12+6] += + c[2]*s[1] - c[0]*s[7] - c[2]*s[9] + c[0]*s[15];
gout[n*12+7] += + c[2]*s[0] - c[0]*s[6] + c[2]*s[10] - c[0]*s[16] + c[2]*s[20] - c[0]*s[26];
gout[n*12+8] += + c[0]*s[14] - c[1]*s[11] - c[0]*s[22] + c[1]*s[19];
gout[n*12+9] += + c[0]*s[21] - c[1]*s[18] - c[0]*s[5] + c[1]*s[2];
gout[n*12+10] += + c[0]*s[4] - c[1]*s[1] - c[0]*s[12] + c[1]*s[9];
gout[n*12+11] += + c[0]*s[3] - c[1]*s[0] + c[0]*s[13] - c[1]*s[10] + c[0]*s[23] - c[1]*s[20];
}}}
void int2e_spgsp1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_spgsp1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_spgsp1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = envs.nfk * envs.x_ctr[2];
counts[3] = envs.nfl * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_spgsp1_cart
int int2e_spgsp1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_spgsp1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = (envs.k_l*2+1) * envs.x_ctr[2];
counts[3] = (envs.l_l*2+1) * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_spgsp1_sph
int int2e_spgsp1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 0, 3, 4, 1, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_spgsp1;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = CINTcgto_spinor(envs.shls[2], envs.bas);
counts[3] = CINTcgto_spinor(envs.shls[3], envs.bas);
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_sf_2e2);
} // int2e_spgsp1_spinor
ALL_CINT(int2e_spgsp1)
ALL_CINT_FORTRAN_(int2e_spgsp1)
/* <SIGMA DOT P k G i|R12 |j SIGMA DOT P l> : i,j \in electron 1; k,l \in electron 2
 * = (G i j|R12 |SIGMA DOT P k SIGMA DOT P l) */
static void CINTgout2e_int2e_g1spsp2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double rirj[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
double c[3];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
G2E_D_L(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l+1, envs->l_l+0);
G2E_D_K(g2, g0, envs->i_l+1, envs->j_l+0, envs->k_l+0, envs->l_l);
G2E_D_K(g3, g1, envs->i_l+1, envs->j_l+0, envs->k_l+0, envs->l_l);
G2E_R0I(g4, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g5, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g6, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g7, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[27];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 27; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g7[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g6[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g6[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g5[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g4[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g4[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g5[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g4[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g4[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g3[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g2[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g2[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g1[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g0[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g0[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g1[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g0[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g0[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g3[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g2[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g2[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g1[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g0[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g0[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g1[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g0[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g0[ix+i] * g0[iy+i] * g7[iz+i];
}
if (gout_empty) {
gout[n*12+0] = + c[1]*s[23] - c[2]*s[14] - c[1]*s[25] + c[2]*s[16];
gout[n*12+1] = + c[1]*s[24] - c[2]*s[15] - c[1]*s[20] + c[2]*s[11];
gout[n*12+2] = + c[1]*s[19] - c[2]*s[10] - c[1]*s[21] + c[2]*s[12];
gout[n*12+3] = + c[1]*s[18] - c[2]*s[9] + c[1]*s[22] - c[2]*s[13] + c[1]*s[26] - c[2]*s[17];
gout[n*12+4] = + c[2]*s[5] - c[0]*s[23] - c[2]*s[7] + c[0]*s[25];
gout[n*12+5] = + c[2]*s[6] - c[0]*s[24] - c[2]*s[2] + c[0]*s[20];
gout[n*12+6] = + c[2]*s[1] - c[0]*s[19] - c[2]*s[3] + c[0]*s[21];
gout[n*12+7] = + c[2]*s[0] - c[0]*s[18] + c[2]*s[4] - c[0]*s[22] + c[2]*s[8] - c[0]*s[26];
gout[n*12+8] = + c[0]*s[14] - c[1]*s[5] - c[0]*s[16] + c[1]*s[7];
gout[n*12+9] = + c[0]*s[15] - c[1]*s[6] - c[0]*s[11] + c[1]*s[2];
gout[n*12+10] = + c[0]*s[10] - c[1]*s[1] - c[0]*s[12] + c[1]*s[3];
gout[n*12+11] = + c[0]*s[9] - c[1]*s[0] + c[0]*s[13] - c[1]*s[4] + c[0]*s[17] - c[1]*s[8];
} else {
gout[n*12+0] += + c[1]*s[23] - c[2]*s[14] - c[1]*s[25] + c[2]*s[16];
gout[n*12+1] += + c[1]*s[24] - c[2]*s[15] - c[1]*s[20] + c[2]*s[11];
gout[n*12+2] += + c[1]*s[19] - c[2]*s[10] - c[1]*s[21] + c[2]*s[12];
gout[n*12+3] += + c[1]*s[18] - c[2]*s[9] + c[1]*s[22] - c[2]*s[13] + c[1]*s[26] - c[2]*s[17];
gout[n*12+4] += + c[2]*s[5] - c[0]*s[23] - c[2]*s[7] + c[0]*s[25];
gout[n*12+5] += + c[2]*s[6] - c[0]*s[24] - c[2]*s[2] + c[0]*s[20];
gout[n*12+6] += + c[2]*s[1] - c[0]*s[19] - c[2]*s[3] + c[0]*s[21];
gout[n*12+7] += + c[2]*s[0] - c[0]*s[18] + c[2]*s[4] - c[0]*s[22] + c[2]*s[8] - c[0]*s[26];
gout[n*12+8] += + c[0]*s[14] - c[1]*s[5] - c[0]*s[16] + c[1]*s[7];
gout[n*12+9] += + c[0]*s[15] - c[1]*s[6] - c[0]*s[11] + c[1]*s[2];
gout[n*12+10] += + c[0]*s[10] - c[1]*s[1] - c[0]*s[12] + c[1]*s[3];
gout[n*12+11] += + c[0]*s[9] - c[1]*s[0] + c[0]*s[13] - c[1]*s[4] + c[0]*s[17] - c[1]*s[8];
}}}
void int2e_g1spsp2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 0, 1, 1, 3, 1, 4, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_g1spsp2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 1, 3, 1, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_g1spsp2;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = envs.nfk * envs.x_ctr[2];
counts[3] = envs.nfl * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_g1spsp2_cart
int int2e_g1spsp2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 1, 3, 1, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_g1spsp2;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = (envs.k_l*2+1) * envs.x_ctr[2];
counts[3] = (envs.l_l*2+1) * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_g1spsp2_sph
int int2e_g1spsp2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 0, 1, 1, 3, 1, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_g1spsp2;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = CINTcgto_spinor(envs.shls[2], envs.bas);
counts[3] = CINTcgto_spinor(envs.shls[3], envs.bas);
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1i, &c2s_si_2e2);
} // int2e_g1spsp2_spinor
ALL_CINT(int2e_g1spsp2)
ALL_CINT_FORTRAN_(int2e_g1spsp2)
/* <SIGMA DOT P k G SIGMA DOT P i|R12 |SIGMA DOT P j SIGMA DOT P l> : i,j \in electron 1; k,l \in electron 2
 * = (G SIGMA DOT P i SIGMA DOT P j|R12 |SIGMA DOT P k SIGMA DOT P l) */
static void CINTgout2e_int2e_spgsp1spsp2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
double *g16 = g15 + envs->g_size * 3;
double *g17 = g16 + envs->g_size * 3;
double *g18 = g17 + envs->g_size * 3;
double *g19 = g18 + envs->g_size * 3;
double *g20 = g19 + envs->g_size * 3;
double *g21 = g20 + envs->g_size * 3;
double *g22 = g21 + envs->g_size * 3;
double *g23 = g22 + envs->g_size * 3;
double *g24 = g23 + envs->g_size * 3;
double *g25 = g24 + envs->g_size * 3;
double *g26 = g25 + envs->g_size * 3;
double *g27 = g26 + envs->g_size * 3;
double *g28 = g27 + envs->g_size * 3;
double *g29 = g28 + envs->g_size * 3;
double *g30 = g29 + envs->g_size * 3;
double *g31 = g30 + envs->g_size * 3;
double rirj[3];
rirj[0] = envs->ri[0] - envs->rj[0];
rirj[1] = envs->ri[1] - envs->rj[1];
rirj[2] = envs->ri[2] - envs->rj[2];
double c[3];
c[0] = 1 * rirj[0];
c[1] = 1 * rirj[1];
c[2] = 1 * rirj[2];
G2E_D_L(g1, g0, envs->i_l+2, envs->j_l+1, envs->k_l+1, envs->l_l+0);
G2E_D_K(g2, g0, envs->i_l+2, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_K(g3, g1, envs->i_l+2, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_J(g4, g0, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g5, g1, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g6, g2, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g7, g3, envs->i_l+2, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R0I(g8, g0, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g9, g1, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g10, g2, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g11, g3, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g12, g4, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g13, g5, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g14, g6, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_R0I(g15, g7, envs->i_l+1, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g16, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g17, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g18, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g19, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g20, g4, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g21, g5, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g22, g6, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g23, g7, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g24, g8, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g25, g9, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g26, g10, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g27, g11, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g28, g12, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g29, g13, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g30, g14, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g31, g15, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[243];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 243; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g31[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g30[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g30[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g29[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g28[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g28[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g29[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g28[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g28[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g27[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g26[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g26[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g25[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g24[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g24[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g25[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g24[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g24[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g27[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g26[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g26[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g25[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g24[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g24[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g25[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g24[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g24[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g23[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g22[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g22[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g21[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g20[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g20[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g21[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g20[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g20[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g19[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g18[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g18[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g17[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g16[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g16[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g17[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g16[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g16[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g19[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g18[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g18[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g17[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g16[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g16[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g17[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g16[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g16[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g23[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g22[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g22[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g21[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g20[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g20[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g21[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g20[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g20[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g19[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g18[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g18[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g17[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g16[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g16[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g17[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g16[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g16[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g19[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g18[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g18[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g17[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g16[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g16[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g17[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g16[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g16[ix+i] * g0[iy+i] * g15[iz+i];
s[81] += g15[ix+i] * g16[iy+i] * g0[iz+i];
s[82] += g14[ix+i] * g17[iy+i] * g0[iz+i];
s[83] += g14[ix+i] * g16[iy+i] * g1[iz+i];
s[84] += g13[ix+i] * g18[iy+i] * g0[iz+i];
s[85] += g12[ix+i] * g19[iy+i] * g0[iz+i];
s[86] += g12[ix+i] * g18[iy+i] * g1[iz+i];
s[87] += g13[ix+i] * g16[iy+i] * g2[iz+i];
s[88] += g12[ix+i] * g17[iy+i] * g2[iz+i];
s[89] += g12[ix+i] * g16[iy+i] * g3[iz+i];
s[90] += g11[ix+i] * g20[iy+i] * g0[iz+i];
s[91] += g10[ix+i] * g21[iy+i] * g0[iz+i];
s[92] += g10[ix+i] * g20[iy+i] * g1[iz+i];
s[93] += g9[ix+i] * g22[iy+i] * g0[iz+i];
s[94] += g8[ix+i] * g23[iy+i] * g0[iz+i];
s[95] += g8[ix+i] * g22[iy+i] * g1[iz+i];
s[96] += g9[ix+i] * g20[iy+i] * g2[iz+i];
s[97] += g8[ix+i] * g21[iy+i] * g2[iz+i];
s[98] += g8[ix+i] * g20[iy+i] * g3[iz+i];
s[99] += g11[ix+i] * g16[iy+i] * g4[iz+i];
s[100] += g10[ix+i] * g17[iy+i] * g4[iz+i];
s[101] += g10[ix+i] * g16[iy+i] * g5[iz+i];
s[102] += g9[ix+i] * g18[iy+i] * g4[iz+i];
s[103] += g8[ix+i] * g19[iy+i] * g4[iz+i];
s[104] += g8[ix+i] * g18[iy+i] * g5[iz+i];
s[105] += g9[ix+i] * g16[iy+i] * g6[iz+i];
s[106] += g8[ix+i] * g17[iy+i] * g6[iz+i];
s[107] += g8[ix+i] * g16[iy+i] * g7[iz+i];
s[108] += g7[ix+i] * g24[iy+i] * g0[iz+i];
s[109] += g6[ix+i] * g25[iy+i] * g0[iz+i];
s[110] += g6[ix+i] * g24[iy+i] * g1[iz+i];
s[111] += g5[ix+i] * g26[iy+i] * g0[iz+i];
s[112] += g4[ix+i] * g27[iy+i] * g0[iz+i];
s[113] += g4[ix+i] * g26[iy+i] * g1[iz+i];
s[114] += g5[ix+i] * g24[iy+i] * g2[iz+i];
s[115] += g4[ix+i] * g25[iy+i] * g2[iz+i];
s[116] += g4[ix+i] * g24[iy+i] * g3[iz+i];
s[117] += g3[ix+i] * g28[iy+i] * g0[iz+i];
s[118] += g2[ix+i] * g29[iy+i] * g0[iz+i];
s[119] += g2[ix+i] * g28[iy+i] * g1[iz+i];
s[120] += g1[ix+i] * g30[iy+i] * g0[iz+i];
s[121] += g0[ix+i] * g31[iy+i] * g0[iz+i];
s[122] += g0[ix+i] * g30[iy+i] * g1[iz+i];
s[123] += g1[ix+i] * g28[iy+i] * g2[iz+i];
s[124] += g0[ix+i] * g29[iy+i] * g2[iz+i];
s[125] += g0[ix+i] * g28[iy+i] * g3[iz+i];
s[126] += g3[ix+i] * g24[iy+i] * g4[iz+i];
s[127] += g2[ix+i] * g25[iy+i] * g4[iz+i];
s[128] += g2[ix+i] * g24[iy+i] * g5[iz+i];
s[129] += g1[ix+i] * g26[iy+i] * g4[iz+i];
s[130] += g0[ix+i] * g27[iy+i] * g4[iz+i];
s[131] += g0[ix+i] * g26[iy+i] * g5[iz+i];
s[132] += g1[ix+i] * g24[iy+i] * g6[iz+i];
s[133] += g0[ix+i] * g25[iy+i] * g6[iz+i];
s[134] += g0[ix+i] * g24[iy+i] * g7[iz+i];
s[135] += g7[ix+i] * g16[iy+i] * g8[iz+i];
s[136] += g6[ix+i] * g17[iy+i] * g8[iz+i];
s[137] += g6[ix+i] * g16[iy+i] * g9[iz+i];
s[138] += g5[ix+i] * g18[iy+i] * g8[iz+i];
s[139] += g4[ix+i] * g19[iy+i] * g8[iz+i];
s[140] += g4[ix+i] * g18[iy+i] * g9[iz+i];
s[141] += g5[ix+i] * g16[iy+i] * g10[iz+i];
s[142] += g4[ix+i] * g17[iy+i] * g10[iz+i];
s[143] += g4[ix+i] * g16[iy+i] * g11[iz+i];
s[144] += g3[ix+i] * g20[iy+i] * g8[iz+i];
s[145] += g2[ix+i] * g21[iy+i] * g8[iz+i];
s[146] += g2[ix+i] * g20[iy+i] * g9[iz+i];
s[147] += g1[ix+i] * g22[iy+i] * g8[iz+i];
s[148] += g0[ix+i] * g23[iy+i] * g8[iz+i];
s[149] += g0[ix+i] * g22[iy+i] * g9[iz+i];
s[150] += g1[ix+i] * g20[iy+i] * g10[iz+i];
s[151] += g0[ix+i] * g21[iy+i] * g10[iz+i];
s[152] += g0[ix+i] * g20[iy+i] * g11[iz+i];
s[153] += g3[ix+i] * g16[iy+i] * g12[iz+i];
s[154] += g2[ix+i] * g17[iy+i] * g12[iz+i];
s[155] += g2[ix+i] * g16[iy+i] * g13[iz+i];
s[156] += g1[ix+i] * g18[iy+i] * g12[iz+i];
s[157] += g0[ix+i] * g19[iy+i] * g12[iz+i];
s[158] += g0[ix+i] * g18[iy+i] * g13[iz+i];
s[159] += g1[ix+i] * g16[iy+i] * g14[iz+i];
s[160] += g0[ix+i] * g17[iy+i] * g14[iz+i];
s[161] += g0[ix+i] * g16[iy+i] * g15[iz+i];
s[162] += g15[ix+i] * g0[iy+i] * g16[iz+i];
s[163] += g14[ix+i] * g1[iy+i] * g16[iz+i];
s[164] += g14[ix+i] * g0[iy+i] * g17[iz+i];
s[165] += g13[ix+i] * g2[iy+i] * g16[iz+i];
s[166] += g12[ix+i] * g3[iy+i] * g16[iz+i];
s[167] += g12[ix+i] * g2[iy+i] * g17[iz+i];
s[168] += g13[ix+i] * g0[iy+i] * g18[iz+i];
s[169] += g12[ix+i] * g1[iy+i] * g18[iz+i];
s[170] += g12[ix+i] * g0[iy+i] * g19[iz+i];
s[171] += g11[ix+i] * g4[iy+i] * g16[iz+i];
s[172] += g10[ix+i] * g5[iy+i] * g16[iz+i];
s[173] += g10[ix+i] * g4[iy+i] * g17[iz+i];
s[174] += g9[ix+i] * g6[iy+i] * g16[iz+i];
s[175] += g8[ix+i] * g7[iy+i] * g16[iz+i];
s[176] += g8[ix+i] * g6[iy+i] * g17[iz+i];
s[177] += g9[ix+i] * g4[iy+i] * g18[iz+i];
s[178] += g8[ix+i] * g5[iy+i] * g18[iz+i];
s[179] += g8[ix+i] * g4[iy+i] * g19[iz+i];
s[180] += g11[ix+i] * g0[iy+i] * g20[iz+i];
s[181] += g10[ix+i] * g1[iy+i] * g20[iz+i];
s[182] += g10[ix+i] * g0[iy+i] * g21[iz+i];
s[183] += g9[ix+i] * g2[iy+i] * g20[iz+i];
s[184] += g8[ix+i] * g3[iy+i] * g20[iz+i];
s[185] += g8[ix+i] * g2[iy+i] * g21[iz+i];
s[186] += g9[ix+i] * g0[iy+i] * g22[iz+i];
s[187] += g8[ix+i] * g1[iy+i] * g22[iz+i];
s[188] += g8[ix+i] * g0[iy+i] * g23[iz+i];
s[189] += g7[ix+i] * g8[iy+i] * g16[iz+i];
s[190] += g6[ix+i] * g9[iy+i] * g16[iz+i];
s[191] += g6[ix+i] * g8[iy+i] * g17[iz+i];
s[192] += g5[ix+i] * g10[iy+i] * g16[iz+i];
s[193] += g4[ix+i] * g11[iy+i] * g16[iz+i];
s[194] += g4[ix+i] * g10[iy+i] * g17[iz+i];
s[195] += g5[ix+i] * g8[iy+i] * g18[iz+i];
s[196] += g4[ix+i] * g9[iy+i] * g18[iz+i];
s[197] += g4[ix+i] * g8[iy+i] * g19[iz+i];
s[198] += g3[ix+i] * g12[iy+i] * g16[iz+i];
s[199] += g2[ix+i] * g13[iy+i] * g16[iz+i];
s[200] += g2[ix+i] * g12[iy+i] * g17[iz+i];
s[201] += g1[ix+i] * g14[iy+i] * g16[iz+i];
s[202] += g0[ix+i] * g15[iy+i] * g16[iz+i];
s[203] += g0[ix+i] * g14[iy+i] * g17[iz+i];
s[204] += g1[ix+i] * g12[iy+i] * g18[iz+i];
s[205] += g0[ix+i] * g13[iy+i] * g18[iz+i];
s[206] += g0[ix+i] * g12[iy+i] * g19[iz+i];
s[207] += g3[ix+i] * g8[iy+i] * g20[iz+i];
s[208] += g2[ix+i] * g9[iy+i] * g20[iz+i];
s[209] += g2[ix+i] * g8[iy+i] * g21[iz+i];
s[210] += g1[ix+i] * g10[iy+i] * g20[iz+i];
s[211] += g0[ix+i] * g11[iy+i] * g20[iz+i];
s[212] += g0[ix+i] * g10[iy+i] * g21[iz+i];
s[213] += g1[ix+i] * g8[iy+i] * g22[iz+i];
s[214] += g0[ix+i] * g9[iy+i] * g22[iz+i];
s[215] += g0[ix+i] * g8[iy+i] * g23[iz+i];
s[216] += g7[ix+i] * g0[iy+i] * g24[iz+i];
s[217] += g6[ix+i] * g1[iy+i] * g24[iz+i];
s[218] += g6[ix+i] * g0[iy+i] * g25[iz+i];
s[219] += g5[ix+i] * g2[iy+i] * g24[iz+i];
s[220] += g4[ix+i] * g3[iy+i] * g24[iz+i];
s[221] += g4[ix+i] * g2[iy+i] * g25[iz+i];
s[222] += g5[ix+i] * g0[iy+i] * g26[iz+i];
s[223] += g4[ix+i] * g1[iy+i] * g26[iz+i];
s[224] += g4[ix+i] * g0[iy+i] * g27[iz+i];
s[225] += g3[ix+i] * g4[iy+i] * g24[iz+i];
s[226] += g2[ix+i] * g5[iy+i] * g24[iz+i];
s[227] += g2[ix+i] * g4[iy+i] * g25[iz+i];
s[228] += g1[ix+i] * g6[iy+i] * g24[iz+i];
s[229] += g0[ix+i] * g7[iy+i] * g24[iz+i];
s[230] += g0[ix+i] * g6[iy+i] * g25[iz+i];
s[231] += g1[ix+i] * g4[iy+i] * g26[iz+i];
s[232] += g0[ix+i] * g5[iy+i] * g26[iz+i];
s[233] += g0[ix+i] * g4[iy+i] * g27[iz+i];
s[234] += g3[ix+i] * g0[iy+i] * g28[iz+i];
s[235] += g2[ix+i] * g1[iy+i] * g28[iz+i];
s[236] += g2[ix+i] * g0[iy+i] * g29[iz+i];
s[237] += g1[ix+i] * g2[iy+i] * g28[iz+i];
s[238] += g0[ix+i] * g3[iy+i] * g28[iz+i];
s[239] += g0[ix+i] * g2[iy+i] * g29[iz+i];
s[240] += g1[ix+i] * g0[iy+i] * g30[iz+i];
s[241] += g0[ix+i] * g1[iy+i] * g30[iz+i];
s[242] += g0[ix+i] * g0[iy+i] * g31[iz+i];
}
if (gout_empty) {
gout[n*48+0] = + c[1]*s[158] - c[2]*s[131] - c[1]*s[230] + c[2]*s[203] - c[1]*s[160] + c[2]*s[133] + c[1]*s[232] - c[2]*s[205];
gout[n*48+1] = + c[1]*s[221] - c[2]*s[194] - c[1]*s[77] + c[2]*s[50] - c[1]*s[223] + c[2]*s[196] + c[1]*s[79] - c[2]*s[52];
gout[n*48+2] = + c[1]*s[68] - c[2]*s[41] - c[1]*s[140] + c[2]*s[113] - c[1]*s[70] + c[2]*s[43] + c[1]*s[142] - c[2]*s[115];
gout[n*48+3] = + c[1]*s[59] - c[2]*s[32] + c[1]*s[149] - c[2]*s[122] + c[1]*s[239] - c[2]*s[212] - c[1]*s[61] + c[2]*s[34] - c[1]*s[151] + c[2]*s[124] - c[1]*s[241] + c[2]*s[214];
gout[n*48+4] = + c[1]*s[159] - c[2]*s[132] - c[1]*s[231] + c[2]*s[204] - c[1]*s[155] + c[2]*s[128] + c[1]*s[227] - c[2]*s[200];
gout[n*48+5] = + c[1]*s[222] - c[2]*s[195] - c[1]*s[78] + c[2]*s[51] - c[1]*s[218] + c[2]*s[191] + c[1]*s[74] - c[2]*s[47];
gout[n*48+6] = + c[1]*s[69] - c[2]*s[42] - c[1]*s[141] + c[2]*s[114] - c[1]*s[65] + c[2]*s[38] + c[1]*s[137] - c[2]*s[110];
gout[n*48+7] = + c[1]*s[60] - c[2]*s[33] + c[1]*s[150] - c[2]*s[123] + c[1]*s[240] - c[2]*s[213] - c[1]*s[56] + c[2]*s[29] - c[1]*s[146] + c[2]*s[119] - c[1]*s[236] + c[2]*s[209];
gout[n*48+8] = + c[1]*s[154] - c[2]*s[127] - c[1]*s[226] + c[2]*s[199] - c[1]*s[156] + c[2]*s[129] + c[1]*s[228] - c[2]*s[201];
gout[n*48+9] = + c[1]*s[217] - c[2]*s[190] - c[1]*s[73] + c[2]*s[46] - c[1]*s[219] + c[2]*s[192] + c[1]*s[75] - c[2]*s[48];
gout[n*48+10] = + c[1]*s[64] - c[2]*s[37] - c[1]*s[136] + c[2]*s[109] - c[1]*s[66] + c[2]*s[39] + c[1]*s[138] - c[2]*s[111];
gout[n*48+11] = + c[1]*s[55] - c[2]*s[28] + c[1]*s[145] - c[2]*s[118] + c[1]*s[235] - c[2]*s[208] - c[1]*s[57] + c[2]*s[30] - c[1]*s[147] + c[2]*s[120] - c[1]*s[237] + c[2]*s[210];
gout[n*48+12] = + c[1]*s[153] - c[2]*s[126] - c[1]*s[225] + c[2]*s[198] + c[1]*s[157] - c[2]*s[130] - c[1]*s[229] + c[2]*s[202] + c[1]*s[161] - c[2]*s[134] - c[1]*s[233] + c[2]*s[206];
gout[n*48+13] = + c[1]*s[216] - c[2]*s[189] - c[1]*s[72] + c[2]*s[45] + c[1]*s[220] - c[2]*s[193] - c[1]*s[76] + c[2]*s[49] + c[1]*s[224] - c[2]*s[197] - c[1]*s[80] + c[2]*s[53];
gout[n*48+14] = + c[1]*s[63] - c[2]*s[36] - c[1]*s[135] + c[2]*s[108] + c[1]*s[67] - c[2]*s[40] - c[1]*s[139] + c[2]*s[112] + c[1]*s[71] - c[2]*s[44] - c[1]*s[143] + c[2]*s[116];
gout[n*48+15] = + c[1]*s[54] - c[2]*s[27] + c[1]*s[144] - c[2]*s[117] + c[1]*s[234] - c[2]*s[207] + c[1]*s[58] - c[2]*s[31] + c[1]*s[148] - c[2]*s[121] + c[1]*s[238] - c[2]*s[211] + c[1]*s[62] - c[2]*s[35] + c[1]*s[152] - c[2]*s[125] + c[1]*s[242] - c[2]*s[215];
gout[n*48+16] = + c[2]*s[104] - c[0]*s[158] - c[2]*s[176] + c[0]*s[230] - c[2]*s[106] + c[0]*s[160] + c[2]*s[178] - c[0]*s[232];
gout[n*48+17] = + c[2]*s[167] - c[0]*s[221] - c[2]*s[23] + c[0]*s[77] - c[2]*s[169] + c[0]*s[223] + c[2]*s[25] - c[0]*s[79];
gout[n*48+18] = + c[2]*s[14] - c[0]*s[68] - c[2]*s[86] + c[0]*s[140] - c[2]*s[16] + c[0]*s[70] + c[2]*s[88] - c[0]*s[142];
gout[n*48+19] = + c[2]*s[5] - c[0]*s[59] + c[2]*s[95] - c[0]*s[149] + c[2]*s[185] - c[0]*s[239] - c[2]*s[7] + c[0]*s[61] - c[2]*s[97] + c[0]*s[151] - c[2]*s[187] + c[0]*s[241];
gout[n*48+20] = + c[2]*s[105] - c[0]*s[159] - c[2]*s[177] + c[0]*s[231] - c[2]*s[101] + c[0]*s[155] + c[2]*s[173] - c[0]*s[227];
gout[n*48+21] = + c[2]*s[168] - c[0]*s[222] - c[2]*s[24] + c[0]*s[78] - c[2]*s[164] + c[0]*s[218] + c[2]*s[20] - c[0]*s[74];
gout[n*48+22] = + c[2]*s[15] - c[0]*s[69] - c[2]*s[87] + c[0]*s[141] - c[2]*s[11] + c[0]*s[65] + c[2]*s[83] - c[0]*s[137];
gout[n*48+23] = + c[2]*s[6] - c[0]*s[60] + c[2]*s[96] - c[0]*s[150] + c[2]*s[186] - c[0]*s[240] - c[2]*s[2] + c[0]*s[56] - c[2]*s[92] + c[0]*s[146] - c[2]*s[182] + c[0]*s[236];
gout[n*48+24] = + c[2]*s[100] - c[0]*s[154] - c[2]*s[172] + c[0]*s[226] - c[2]*s[102] + c[0]*s[156] + c[2]*s[174] - c[0]*s[228];
gout[n*48+25] = + c[2]*s[163] - c[0]*s[217] - c[2]*s[19] + c[0]*s[73] - c[2]*s[165] + c[0]*s[219] + c[2]*s[21] - c[0]*s[75];
gout[n*48+26] = + c[2]*s[10] - c[0]*s[64] - c[2]*s[82] + c[0]*s[136] - c[2]*s[12] + c[0]*s[66] + c[2]*s[84] - c[0]*s[138];
gout[n*48+27] = + c[2]*s[1] - c[0]*s[55] + c[2]*s[91] - c[0]*s[145] + c[2]*s[181] - c[0]*s[235] - c[2]*s[3] + c[0]*s[57] - c[2]*s[93] + c[0]*s[147] - c[2]*s[183] + c[0]*s[237];
gout[n*48+28] = + c[2]*s[99] - c[0]*s[153] - c[2]*s[171] + c[0]*s[225] + c[2]*s[103] - c[0]*s[157] - c[2]*s[175] + c[0]*s[229] + c[2]*s[107] - c[0]*s[161] - c[2]*s[179] + c[0]*s[233];
gout[n*48+29] = + c[2]*s[162] - c[0]*s[216] - c[2]*s[18] + c[0]*s[72] + c[2]*s[166] - c[0]*s[220] - c[2]*s[22] + c[0]*s[76] + c[2]*s[170] - c[0]*s[224] - c[2]*s[26] + c[0]*s[80];
gout[n*48+30] = + c[2]*s[9] - c[0]*s[63] - c[2]*s[81] + c[0]*s[135] + c[2]*s[13] - c[0]*s[67] - c[2]*s[85] + c[0]*s[139] + c[2]*s[17] - c[0]*s[71] - c[2]*s[89] + c[0]*s[143];
gout[n*48+31] = + c[2]*s[0] - c[0]*s[54] + c[2]*s[90] - c[0]*s[144] + c[2]*s[180] - c[0]*s[234] + c[2]*s[4] - c[0]*s[58] + c[2]*s[94] - c[0]*s[148] + c[2]*s[184] - c[0]*s[238] + c[2]*s[8] - c[0]*s[62] + c[2]*s[98] - c[0]*s[152] + c[2]*s[188] - c[0]*s[242];
gout[n*48+32] = + c[0]*s[131] - c[1]*s[104] - c[0]*s[203] + c[1]*s[176] - c[0]*s[133] + c[1]*s[106] + c[0]*s[205] - c[1]*s[178];
gout[n*48+33] = + c[0]*s[194] - c[1]*s[167] - c[0]*s[50] + c[1]*s[23] - c[0]*s[196] + c[1]*s[169] + c[0]*s[52] - c[1]*s[25];
gout[n*48+34] = + c[0]*s[41] - c[1]*s[14] - c[0]*s[113] + c[1]*s[86] - c[0]*s[43] + c[1]*s[16] + c[0]*s[115] - c[1]*s[88];
gout[n*48+35] = + c[0]*s[32] - c[1]*s[5] + c[0]*s[122] - c[1]*s[95] + c[0]*s[212] - c[1]*s[185] - c[0]*s[34] + c[1]*s[7] - c[0]*s[124] + c[1]*s[97] - c[0]*s[214] + c[1]*s[187];
gout[n*48+36] = + c[0]*s[132] - c[1]*s[105] - c[0]*s[204] + c[1]*s[177] - c[0]*s[128] + c[1]*s[101] + c[0]*s[200] - c[1]*s[173];
gout[n*48+37] = + c[0]*s[195] - c[1]*s[168] - c[0]*s[51] + c[1]*s[24] - c[0]*s[191] + c[1]*s[164] + c[0]*s[47] - c[1]*s[20];
gout[n*48+38] = + c[0]*s[42] - c[1]*s[15] - c[0]*s[114] + c[1]*s[87] - c[0]*s[38] + c[1]*s[11] + c[0]*s[110] - c[1]*s[83];
gout[n*48+39] = + c[0]*s[33] - c[1]*s[6] + c[0]*s[123] - c[1]*s[96] + c[0]*s[213] - c[1]*s[186] - c[0]*s[29] + c[1]*s[2] - c[0]*s[119] + c[1]*s[92] - c[0]*s[209] + c[1]*s[182];
gout[n*48+40] = + c[0]*s[127] - c[1]*s[100] - c[0]*s[199] + c[1]*s[172] - c[0]*s[129] + c[1]*s[102] + c[0]*s[201] - c[1]*s[174];
gout[n*48+41] = + c[0]*s[190] - c[1]*s[163] - c[0]*s[46] + c[1]*s[19] - c[0]*s[192] + c[1]*s[165] + c[0]*s[48] - c[1]*s[21];
gout[n*48+42] = + c[0]*s[37] - c[1]*s[10] - c[0]*s[109] + c[1]*s[82] - c[0]*s[39] + c[1]*s[12] + c[0]*s[111] - c[1]*s[84];
gout[n*48+43] = + c[0]*s[28] - c[1]*s[1] + c[0]*s[118] - c[1]*s[91] + c[0]*s[208] - c[1]*s[181] - c[0]*s[30] + c[1]*s[3] - c[0]*s[120] + c[1]*s[93] - c[0]*s[210] + c[1]*s[183];
gout[n*48+44] = + c[0]*s[126] - c[1]*s[99] - c[0]*s[198] + c[1]*s[171] + c[0]*s[130] - c[1]*s[103] - c[0]*s[202] + c[1]*s[175] + c[0]*s[134] - c[1]*s[107] - c[0]*s[206] + c[1]*s[179];
gout[n*48+45] = + c[0]*s[189] - c[1]*s[162] - c[0]*s[45] + c[1]*s[18] + c[0]*s[193] - c[1]*s[166] - c[0]*s[49] + c[1]*s[22] + c[0]*s[197] - c[1]*s[170] - c[0]*s[53] + c[1]*s[26];
gout[n*48+46] = + c[0]*s[36] - c[1]*s[9] - c[0]*s[108] + c[1]*s[81] + c[0]*s[40] - c[1]*s[13] - c[0]*s[112] + c[1]*s[85] + c[0]*s[44] - c[1]*s[17] - c[0]*s[116] + c[1]*s[89];
gout[n*48+47] = + c[0]*s[27] - c[1]*s[0] + c[0]*s[117] - c[1]*s[90] + c[0]*s[207] - c[1]*s[180] + c[0]*s[31] - c[1]*s[4] + c[0]*s[121] - c[1]*s[94] + c[0]*s[211] - c[1]*s[184] + c[0]*s[35] - c[1]*s[8] + c[0]*s[125] - c[1]*s[98] + c[0]*s[215] - c[1]*s[188];
} else {
gout[n*48+0] += + c[1]*s[158] - c[2]*s[131] - c[1]*s[230] + c[2]*s[203] - c[1]*s[160] + c[2]*s[133] + c[1]*s[232] - c[2]*s[205];
gout[n*48+1] += + c[1]*s[221] - c[2]*s[194] - c[1]*s[77] + c[2]*s[50] - c[1]*s[223] + c[2]*s[196] + c[1]*s[79] - c[2]*s[52];
gout[n*48+2] += + c[1]*s[68] - c[2]*s[41] - c[1]*s[140] + c[2]*s[113] - c[1]*s[70] + c[2]*s[43] + c[1]*s[142] - c[2]*s[115];
gout[n*48+3] += + c[1]*s[59] - c[2]*s[32] + c[1]*s[149] - c[2]*s[122] + c[1]*s[239] - c[2]*s[212] - c[1]*s[61] + c[2]*s[34] - c[1]*s[151] + c[2]*s[124] - c[1]*s[241] + c[2]*s[214];
gout[n*48+4] += + c[1]*s[159] - c[2]*s[132] - c[1]*s[231] + c[2]*s[204] - c[1]*s[155] + c[2]*s[128] + c[1]*s[227] - c[2]*s[200];
gout[n*48+5] += + c[1]*s[222] - c[2]*s[195] - c[1]*s[78] + c[2]*s[51] - c[1]*s[218] + c[2]*s[191] + c[1]*s[74] - c[2]*s[47];
gout[n*48+6] += + c[1]*s[69] - c[2]*s[42] - c[1]*s[141] + c[2]*s[114] - c[1]*s[65] + c[2]*s[38] + c[1]*s[137] - c[2]*s[110];
gout[n*48+7] += + c[1]*s[60] - c[2]*s[33] + c[1]*s[150] - c[2]*s[123] + c[1]*s[240] - c[2]*s[213] - c[1]*s[56] + c[2]*s[29] - c[1]*s[146] + c[2]*s[119] - c[1]*s[236] + c[2]*s[209];
gout[n*48+8] += + c[1]*s[154] - c[2]*s[127] - c[1]*s[226] + c[2]*s[199] - c[1]*s[156] + c[2]*s[129] + c[1]*s[228] - c[2]*s[201];
gout[n*48+9] += + c[1]*s[217] - c[2]*s[190] - c[1]*s[73] + c[2]*s[46] - c[1]*s[219] + c[2]*s[192] + c[1]*s[75] - c[2]*s[48];
gout[n*48+10] += + c[1]*s[64] - c[2]*s[37] - c[1]*s[136] + c[2]*s[109] - c[1]*s[66] + c[2]*s[39] + c[1]*s[138] - c[2]*s[111];
gout[n*48+11] += + c[1]*s[55] - c[2]*s[28] + c[1]*s[145] - c[2]*s[118] + c[1]*s[235] - c[2]*s[208] - c[1]*s[57] + c[2]*s[30] - c[1]*s[147] + c[2]*s[120] - c[1]*s[237] + c[2]*s[210];
gout[n*48+12] += + c[1]*s[153] - c[2]*s[126] - c[1]*s[225] + c[2]*s[198] + c[1]*s[157] - c[2]*s[130] - c[1]*s[229] + c[2]*s[202] + c[1]*s[161] - c[2]*s[134] - c[1]*s[233] + c[2]*s[206];
gout[n*48+13] += + c[1]*s[216] - c[2]*s[189] - c[1]*s[72] + c[2]*s[45] + c[1]*s[220] - c[2]*s[193] - c[1]*s[76] + c[2]*s[49] + c[1]*s[224] - c[2]*s[197] - c[1]*s[80] + c[2]*s[53];
gout[n*48+14] += + c[1]*s[63] - c[2]*s[36] - c[1]*s[135] + c[2]*s[108] + c[1]*s[67] - c[2]*s[40] - c[1]*s[139] + c[2]*s[112] + c[1]*s[71] - c[2]*s[44] - c[1]*s[143] + c[2]*s[116];
gout[n*48+15] += + c[1]*s[54] - c[2]*s[27] + c[1]*s[144] - c[2]*s[117] + c[1]*s[234] - c[2]*s[207] + c[1]*s[58] - c[2]*s[31] + c[1]*s[148] - c[2]*s[121] + c[1]*s[238] - c[2]*s[211] + c[1]*s[62] - c[2]*s[35] + c[1]*s[152] - c[2]*s[125] + c[1]*s[242] - c[2]*s[215];
gout[n*48+16] += + c[2]*s[104] - c[0]*s[158] - c[2]*s[176] + c[0]*s[230] - c[2]*s[106] + c[0]*s[160] + c[2]*s[178] - c[0]*s[232];
gout[n*48+17] += + c[2]*s[167] - c[0]*s[221] - c[2]*s[23] + c[0]*s[77] - c[2]*s[169] + c[0]*s[223] + c[2]*s[25] - c[0]*s[79];
gout[n*48+18] += + c[2]*s[14] - c[0]*s[68] - c[2]*s[86] + c[0]*s[140] - c[2]*s[16] + c[0]*s[70] + c[2]*s[88] - c[0]*s[142];
gout[n*48+19] += + c[2]*s[5] - c[0]*s[59] + c[2]*s[95] - c[0]*s[149] + c[2]*s[185] - c[0]*s[239] - c[2]*s[7] + c[0]*s[61] - c[2]*s[97] + c[0]*s[151] - c[2]*s[187] + c[0]*s[241];
gout[n*48+20] += + c[2]*s[105] - c[0]*s[159] - c[2]*s[177] + c[0]*s[231] - c[2]*s[101] + c[0]*s[155] + c[2]*s[173] - c[0]*s[227];
gout[n*48+21] += + c[2]*s[168] - c[0]*s[222] - c[2]*s[24] + c[0]*s[78] - c[2]*s[164] + c[0]*s[218] + c[2]*s[20] - c[0]*s[74];
gout[n*48+22] += + c[2]*s[15] - c[0]*s[69] - c[2]*s[87] + c[0]*s[141] - c[2]*s[11] + c[0]*s[65] + c[2]*s[83] - c[0]*s[137];
gout[n*48+23] += + c[2]*s[6] - c[0]*s[60] + c[2]*s[96] - c[0]*s[150] + c[2]*s[186] - c[0]*s[240] - c[2]*s[2] + c[0]*s[56] - c[2]*s[92] + c[0]*s[146] - c[2]*s[182] + c[0]*s[236];
gout[n*48+24] += + c[2]*s[100] - c[0]*s[154] - c[2]*s[172] + c[0]*s[226] - c[2]*s[102] + c[0]*s[156] + c[2]*s[174] - c[0]*s[228];
gout[n*48+25] += + c[2]*s[163] - c[0]*s[217] - c[2]*s[19] + c[0]*s[73] - c[2]*s[165] + c[0]*s[219] + c[2]*s[21] - c[0]*s[75];
gout[n*48+26] += + c[2]*s[10] - c[0]*s[64] - c[2]*s[82] + c[0]*s[136] - c[2]*s[12] + c[0]*s[66] + c[2]*s[84] - c[0]*s[138];
gout[n*48+27] += + c[2]*s[1] - c[0]*s[55] + c[2]*s[91] - c[0]*s[145] + c[2]*s[181] - c[0]*s[235] - c[2]*s[3] + c[0]*s[57] - c[2]*s[93] + c[0]*s[147] - c[2]*s[183] + c[0]*s[237];
gout[n*48+28] += + c[2]*s[99] - c[0]*s[153] - c[2]*s[171] + c[0]*s[225] + c[2]*s[103] - c[0]*s[157] - c[2]*s[175] + c[0]*s[229] + c[2]*s[107] - c[0]*s[161] - c[2]*s[179] + c[0]*s[233];
gout[n*48+29] += + c[2]*s[162] - c[0]*s[216] - c[2]*s[18] + c[0]*s[72] + c[2]*s[166] - c[0]*s[220] - c[2]*s[22] + c[0]*s[76] + c[2]*s[170] - c[0]*s[224] - c[2]*s[26] + c[0]*s[80];
gout[n*48+30] += + c[2]*s[9] - c[0]*s[63] - c[2]*s[81] + c[0]*s[135] + c[2]*s[13] - c[0]*s[67] - c[2]*s[85] + c[0]*s[139] + c[2]*s[17] - c[0]*s[71] - c[2]*s[89] + c[0]*s[143];
gout[n*48+31] += + c[2]*s[0] - c[0]*s[54] + c[2]*s[90] - c[0]*s[144] + c[2]*s[180] - c[0]*s[234] + c[2]*s[4] - c[0]*s[58] + c[2]*s[94] - c[0]*s[148] + c[2]*s[184] - c[0]*s[238] + c[2]*s[8] - c[0]*s[62] + c[2]*s[98] - c[0]*s[152] + c[2]*s[188] - c[0]*s[242];
gout[n*48+32] += + c[0]*s[131] - c[1]*s[104] - c[0]*s[203] + c[1]*s[176] - c[0]*s[133] + c[1]*s[106] + c[0]*s[205] - c[1]*s[178];
gout[n*48+33] += + c[0]*s[194] - c[1]*s[167] - c[0]*s[50] + c[1]*s[23] - c[0]*s[196] + c[1]*s[169] + c[0]*s[52] - c[1]*s[25];
gout[n*48+34] += + c[0]*s[41] - c[1]*s[14] - c[0]*s[113] + c[1]*s[86] - c[0]*s[43] + c[1]*s[16] + c[0]*s[115] - c[1]*s[88];
gout[n*48+35] += + c[0]*s[32] - c[1]*s[5] + c[0]*s[122] - c[1]*s[95] + c[0]*s[212] - c[1]*s[185] - c[0]*s[34] + c[1]*s[7] - c[0]*s[124] + c[1]*s[97] - c[0]*s[214] + c[1]*s[187];
gout[n*48+36] += + c[0]*s[132] - c[1]*s[105] - c[0]*s[204] + c[1]*s[177] - c[0]*s[128] + c[1]*s[101] + c[0]*s[200] - c[1]*s[173];
gout[n*48+37] += + c[0]*s[195] - c[1]*s[168] - c[0]*s[51] + c[1]*s[24] - c[0]*s[191] + c[1]*s[164] + c[0]*s[47] - c[1]*s[20];
gout[n*48+38] += + c[0]*s[42] - c[1]*s[15] - c[0]*s[114] + c[1]*s[87] - c[0]*s[38] + c[1]*s[11] + c[0]*s[110] - c[1]*s[83];
gout[n*48+39] += + c[0]*s[33] - c[1]*s[6] + c[0]*s[123] - c[1]*s[96] + c[0]*s[213] - c[1]*s[186] - c[0]*s[29] + c[1]*s[2] - c[0]*s[119] + c[1]*s[92] - c[0]*s[209] + c[1]*s[182];
gout[n*48+40] += + c[0]*s[127] - c[1]*s[100] - c[0]*s[199] + c[1]*s[172] - c[0]*s[129] + c[1]*s[102] + c[0]*s[201] - c[1]*s[174];
gout[n*48+41] += + c[0]*s[190] - c[1]*s[163] - c[0]*s[46] + c[1]*s[19] - c[0]*s[192] + c[1]*s[165] + c[0]*s[48] - c[1]*s[21];
gout[n*48+42] += + c[0]*s[37] - c[1]*s[10] - c[0]*s[109] + c[1]*s[82] - c[0]*s[39] + c[1]*s[12] + c[0]*s[111] - c[1]*s[84];
gout[n*48+43] += + c[0]*s[28] - c[1]*s[1] + c[0]*s[118] - c[1]*s[91] + c[0]*s[208] - c[1]*s[181] - c[0]*s[30] + c[1]*s[3] - c[0]*s[120] + c[1]*s[93] - c[0]*s[210] + c[1]*s[183];
gout[n*48+44] += + c[0]*s[126] - c[1]*s[99] - c[0]*s[198] + c[1]*s[171] + c[0]*s[130] - c[1]*s[103] - c[0]*s[202] + c[1]*s[175] + c[0]*s[134] - c[1]*s[107] - c[0]*s[206] + c[1]*s[179];
gout[n*48+45] += + c[0]*s[189] - c[1]*s[162] - c[0]*s[45] + c[1]*s[18] + c[0]*s[193] - c[1]*s[166] - c[0]*s[49] + c[1]*s[22] + c[0]*s[197] - c[1]*s[170] - c[0]*s[53] + c[1]*s[26];
gout[n*48+46] += + c[0]*s[36] - c[1]*s[9] - c[0]*s[108] + c[1]*s[81] + c[0]*s[40] - c[1]*s[13] - c[0]*s[112] + c[1]*s[85] + c[0]*s[44] - c[1]*s[17] - c[0]*s[116] + c[1]*s[89];
gout[n*48+47] += + c[0]*s[27] - c[1]*s[0] + c[0]*s[117] - c[1]*s[90] + c[0]*s[207] - c[1]*s[180] + c[0]*s[31] - c[1]*s[4] + c[0]*s[121] - c[1]*s[94] + c[0]*s[211] - c[1]*s[184] + c[0]*s[35] - c[1]*s[8] + c[0]*s[125] - c[1]*s[98] + c[0]*s[215] - c[1]*s[188];
}}}
void int2e_spgsp1spsp2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 1, 1, 1, 5, 4, 4, 3};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_spgsp1spsp2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 1, 1, 5, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_spgsp1spsp2;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = envs.nfi * envs.x_ctr[0];
counts[1] = envs.nfj * envs.x_ctr[1];
counts[2] = envs.nfk * envs.x_ctr[2];
counts[3] = envs.nfl * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_spgsp1spsp2_cart
int int2e_spgsp1spsp2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 1, 1, 5, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_spgsp1spsp2;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = (envs.i_l*2+1) * envs.x_ctr[0];
counts[1] = (envs.j_l*2+1) * envs.x_ctr[1];
counts[2] = (envs.k_l*2+1) * envs.x_ctr[2];
counts[3] = (envs.l_l*2+1) * envs.x_ctr[3];
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_e1 * envs.ncomp_e2 * envs.ncomp_tensor; i++) {
c2s_dset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_spgsp1spsp2_sph
int int2e_spgsp1spsp2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 1, 1, 5, 4, 4, 3};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_spgsp1spsp2;
envs.common_factor *= 0.5;
int i, nout;
int counts[4];
if (out != NULL && envs.shls[0] == envs.shls[1]) {
counts[0] = CINTcgto_spinor(envs.shls[0], envs.bas);
counts[1] = CINTcgto_spinor(envs.shls[1], envs.bas);
counts[2] = CINTcgto_spinor(envs.shls[2], envs.bas);
counts[3] = CINTcgto_spinor(envs.shls[3], envs.bas);
if (dims == NULL) { dims = counts; }
nout = dims[0] * dims[1] * dims[2] * dims[3];
for (i = 0; i < envs.ncomp_tensor; i++) {
c2s_zset0(out+nout*i, dims, counts); }
return 0; }
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_si_2e2);
} // int2e_spgsp1spsp2_spinor
ALL_CINT(int2e_spgsp1spsp2)
ALL_CINT_FORTRAN_(int2e_spgsp1spsp2)
/* <k P* i|R12 |DOT P j l> : i,j \in electron 1; k,l \in electron 2
 * = (P* i DOT P j|R12 |k l) */
static void CINTgout2e_int2e_pp1(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
G2E_D_J(g1, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g2, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g3, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*1+0] = + s[0] + s[4] + s[8];
} else {
gout[n*1+0] += + s[0] + s[4] + s[8];
}}}
void int2e_pp1_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_pp1_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_pp1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_pp1_cart
int int2e_pp1_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_pp1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_pp1_sph
int int2e_pp1_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 0, 0, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_pp1;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1, &c2s_sf_2e2);
} // int2e_pp1_spinor
ALL_CINT(int2e_pp1)
ALL_CINT_FORTRAN_(int2e_pp1)
/* <P* k i|R12 |j DOT P l> : i,j \in electron 1; k,l \in electron 2
 * = (i j|R12 |P* k DOT P l) */
static void CINTgout2e_int2e_pp2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
G2E_D_L(g1, g0, envs->i_l+0, envs->j_l+0, envs->k_l+1, envs->l_l+0);
G2E_D_K(g2, g0, envs->i_l+0, envs->j_l+0, envs->k_l+0, envs->l_l);
G2E_D_K(g3, g1, envs->i_l+0, envs->j_l+0, envs->k_l+0, envs->l_l);
double s[9];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 9; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g3[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g2[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g2[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g1[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g0[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g0[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g1[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g0[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g0[ix+i] * g0[iy+i] * g3[iz+i];
}
if (gout_empty) {
gout[n*1+0] = + s[0] + s[4] + s[8];
} else {
gout[n*1+0] += + s[0] + s[4] + s[8];
}}}
void int2e_pp2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {0, 0, 1, 1, 2, 1, 1, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_pp2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 1, 1, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_pp2;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_pp2_cart
int int2e_pp2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 1, 1, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_pp2;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_pp2_sph
int int2e_pp2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {0, 0, 1, 1, 2, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_pp2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1, &c2s_sf_2e2);
} // int2e_pp2_spinor
ALL_CINT(int2e_pp2)
ALL_CINT_FORTRAN_(int2e_pp2)
/* <P* k P* i|R12 |DOT P j DOT P l> : i,j \in electron 1; k,l \in electron 2
 * = (P* i DOT P j|R12 |P* k DOT P l) */
static void CINTgout2e_int2e_pp1pp2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
G2E_D_L(g1, g0, envs->i_l+1, envs->j_l+1, envs->k_l+1, envs->l_l+0);
G2E_D_K(g2, g0, envs->i_l+1, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_K(g3, g1, envs->i_l+1, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_J(g4, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g5, g1, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g6, g2, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g7, g3, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g8, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g9, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g10, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g11, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g12, g4, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g13, g5, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g14, g6, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g15, g7, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[81];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 81; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g15[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g14[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g14[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g13[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g12[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g12[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g13[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g12[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g12[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g11[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g10[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g10[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g9[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g8[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g8[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g9[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g8[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g8[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g11[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g10[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g10[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g9[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g8[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g8[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g9[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g8[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g8[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g7[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g6[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g6[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g5[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g4[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g4[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g5[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g4[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g4[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g3[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g2[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g2[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g1[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g0[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g0[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g1[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g0[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g0[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g3[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g2[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g2[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g1[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g0[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g0[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g1[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g0[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g0[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g7[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g6[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g6[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g5[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g4[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g4[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g5[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g4[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g4[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g3[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g2[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g2[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g1[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g0[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g0[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g1[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g0[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g0[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g3[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g2[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g2[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g1[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g0[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g0[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g1[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g0[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g0[ix+i] * g0[iy+i] * g15[iz+i];
}
if (gout_empty) {
gout[n*1+0] = + s[0] + s[36] + s[72] + s[4] + s[40] + s[76] + s[8] + s[44] + s[80];
} else {
gout[n*1+0] += + s[0] + s[36] + s[72] + s[4] + s[40] + s[76] + s[8] + s[44] + s[80];
}}}
void int2e_pp1pp2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 1, 1, 1, 4, 1, 1, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_pp1pp2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_pp1pp2;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_pp1pp2_cart
int int2e_pp1pp2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_pp1pp2;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_pp1pp2_sph
int int2e_pp1pp2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 1, 1, 1, 4, 1, 1, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_pp1pp2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_sf_2e1, &c2s_sf_2e2);
} // int2e_pp1pp2_spinor
ALL_CINT(int2e_pp1pp2)
ALL_CINT_FORTRAN_(int2e_pp1pp2)
