/*
 * Copyright (C) 2013-  Qiming Sun <osirpt.sun@gmail.com>
 * Description: code generated by  gen-code.cl
 */
#include <stdlib.h>
#include "cint_bas.h"
#include "cart2sph.h"
#include "g1e.h"
#include "g2e.h"
#include "optimizer.h"
#include "cint1e.h"
#include "cint2e.h"
#include "misc.h"
#include "c2f.h"
/* <k i|BREIT-R1 |R0 SIGMA DOT P j SIGMA DOT P l> : i,j \in electron 1; k,l \in electron 2
 * = (i R0 SIGMA DOT P j|BREIT-R1 |k SIGMA DOT P l) */
static void CINTgout2e_int2e_gauge_r1_ssp1ssp2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
double *g16 = g15 + envs->g_size * 3;
G2E_D_L(g1, g0, envs->i_l+1, envs->j_l+3, envs->k_l+0, envs->l_l+0);
G2E_D_J(g2, g0, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g3, g1, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R0J(g4, g0, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_R0J(g5, g1, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_J(g6, g4, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g7, g5, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g8, g0, envs->i_l+0, envs->j_l+2, envs->k_l, envs->l_l);
G2E_D_I(g9, g0, envs->i_l+0, envs->j_l+2, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g8[ix] += g9[ix];}
G2E_D_J(g9, g1, envs->i_l+0, envs->j_l+2, envs->k_l, envs->l_l);
G2E_D_I(g10, g1, envs->i_l+0, envs->j_l+2, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g9[ix] += g10[ix];}
G2E_D_J(g10, g8, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g11, g9, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R0J(g12, g8, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_R0J(g13, g9, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_J(g14, g12, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g15, g13, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
double s[81];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 81; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g15[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g14[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g14[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g13[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g12[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g12[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g13[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g12[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g12[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g11[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g10[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g10[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g9[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g8[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g8[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g9[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g8[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g8[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g11[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g10[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g10[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g9[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g8[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g8[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g9[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g8[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g8[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g7[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g6[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g6[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g5[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g4[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g4[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g5[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g4[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g4[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g3[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g2[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g2[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g1[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g0[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g0[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g1[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g0[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g0[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g3[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g2[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g2[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g1[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g0[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g0[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g1[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g0[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g0[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g7[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g6[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g6[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g5[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g4[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g4[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g5[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g4[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g4[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g3[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g2[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g2[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g1[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g0[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g0[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g1[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g0[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g0[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g3[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g2[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g2[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g1[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g0[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g0[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g1[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g0[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g0[ix+i] * g0[iy+i] * g15[iz+i];
}
if (gout_empty) {
gout[n*16+0] = + s[44] - s[68] - s[52] + s[76];
gout[n*16+1] = + s[65] - s[17] - s[73] + s[25];
gout[n*16+2] = + s[14] - s[38] - s[22] + s[46];
gout[n*16+3] = + s[11] + s[41] + s[71] - s[19] - s[49] - s[79];
gout[n*16+4] = - s[35] + s[59] + s[51] - s[75];
gout[n*16+5] = - s[56] + s[8] + s[72] - s[24];
gout[n*16+6] = - s[5] + s[29] + s[21] - s[45];
gout[n*16+7] = - s[2] - s[32] - s[62] + s[18] + s[48] + s[78];
gout[n*16+8] = + s[34] - s[58] - s[42] + s[66];
gout[n*16+9] = + s[55] - s[7] - s[63] + s[15];
gout[n*16+10] = + s[4] - s[28] - s[12] + s[36];
gout[n*16+11] = + s[1] + s[31] + s[61] - s[9] - s[39] - s[69];
gout[n*16+12] = + s[33] - s[57] + s[43] - s[67] + s[53] - s[77];
gout[n*16+13] = + s[54] - s[6] + s[64] - s[16] + s[74] - s[26];
gout[n*16+14] = + s[3] - s[27] + s[13] - s[37] + s[23] - s[47];
gout[n*16+15] = + s[0] + s[30] + s[60] + s[10] + s[40] + s[70] + s[20] + s[50] + s[80];
} else {
gout[n*16+0] += + s[44] - s[68] - s[52] + s[76];
gout[n*16+1] += + s[65] - s[17] - s[73] + s[25];
gout[n*16+2] += + s[14] - s[38] - s[22] + s[46];
gout[n*16+3] += + s[11] + s[41] + s[71] - s[19] - s[49] - s[79];
gout[n*16+4] += - s[35] + s[59] + s[51] - s[75];
gout[n*16+5] += - s[56] + s[8] + s[72] - s[24];
gout[n*16+6] += - s[5] + s[29] + s[21] - s[45];
gout[n*16+7] += - s[2] - s[32] - s[62] + s[18] + s[48] + s[78];
gout[n*16+8] += + s[34] - s[58] - s[42] + s[66];
gout[n*16+9] += + s[55] - s[7] - s[63] + s[15];
gout[n*16+10] += + s[4] - s[28] - s[12] + s[36];
gout[n*16+11] += + s[1] + s[31] + s[61] - s[9] - s[39] - s[69];
gout[n*16+12] += + s[33] - s[57] + s[43] - s[67] + s[53] - s[77];
gout[n*16+13] += + s[54] - s[6] + s[64] - s[16] + s[74] - s[26];
gout[n*16+14] += + s[3] - s[27] + s[13] - s[37] + s[23] - s[47];
gout[n*16+15] += + s[0] + s[30] + s[60] + s[10] + s[40] + s[70] + s[20] + s[50] + s[80];
}}}
void int2e_gauge_r1_ssp1ssp2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 3, 0, 1, 4, 4, 4, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_gauge_r1_ssp1ssp2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 3, 0, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r1_ssp1ssp2;
envs.common_factor *= -1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r1_ssp1ssp2_cart
int int2e_gauge_r1_ssp1ssp2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 3, 0, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r1_ssp1ssp2;
envs.common_factor *= -1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r1_ssp1ssp2_sph
int int2e_gauge_r1_ssp1ssp2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 3, 0, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r1_ssp1ssp2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_si_2e2i);
} // int2e_gauge_r1_ssp1ssp2_spinor
ALL_CINT(int2e_gauge_r1_ssp1ssp2)
ALL_CINT_FORTRAN_(int2e_gauge_r1_ssp1ssp2)
/* <SIGMA DOT P k i|BREIT-R1 |R0 SIGMA DOT P j l> : i,j \in electron 1; k,l \in electron 2
 * = (i R0 SIGMA DOT P j|BREIT-R1 |SIGMA DOT P k l) */
static void CINTgout2e_int2e_gauge_r1_ssp1sps2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
double *g16 = g15 + envs->g_size * 3;
G2E_D_K(g1, g0, envs->i_l+1, envs->j_l+3, envs->k_l+0, envs->l_l);
G2E_D_J(g2, g0, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g3, g1, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R0J(g4, g0, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_R0J(g5, g1, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_J(g6, g4, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g7, g5, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g8, g0, envs->i_l+0, envs->j_l+2, envs->k_l, envs->l_l);
G2E_D_I(g9, g0, envs->i_l+0, envs->j_l+2, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g8[ix] += g9[ix];}
G2E_D_J(g9, g1, envs->i_l+0, envs->j_l+2, envs->k_l, envs->l_l);
G2E_D_I(g10, g1, envs->i_l+0, envs->j_l+2, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g9[ix] += g10[ix];}
G2E_D_J(g10, g8, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g11, g9, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R0J(g12, g8, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_R0J(g13, g9, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_J(g14, g12, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g15, g13, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
double s[81];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 81; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g15[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g14[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g14[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g13[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g12[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g12[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g13[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g12[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g12[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g11[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g10[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g10[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g9[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g8[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g8[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g9[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g8[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g8[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g11[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g10[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g10[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g9[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g8[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g8[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g9[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g8[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g8[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g7[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g6[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g6[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g5[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g4[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g4[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g5[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g4[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g4[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g3[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g2[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g2[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g1[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g0[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g0[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g1[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g0[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g0[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g3[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g2[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g2[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g1[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g0[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g0[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g1[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g0[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g0[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g7[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g6[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g6[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g5[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g4[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g4[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g5[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g4[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g4[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g3[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g2[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g2[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g1[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g0[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g0[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g1[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g0[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g0[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g3[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g2[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g2[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g1[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g0[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g0[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g1[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g0[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g0[ix+i] * g0[iy+i] * g15[iz+i];
}
if (gout_empty) {
gout[n*16+0] = + s[44] - s[68] - s[52] + s[76];
gout[n*16+1] = + s[65] - s[17] - s[73] + s[25];
gout[n*16+2] = + s[14] - s[38] - s[22] + s[46];
gout[n*16+3] = + s[11] + s[41] + s[71] - s[19] - s[49] - s[79];
gout[n*16+4] = - s[35] + s[59] + s[51] - s[75];
gout[n*16+5] = - s[56] + s[8] + s[72] - s[24];
gout[n*16+6] = - s[5] + s[29] + s[21] - s[45];
gout[n*16+7] = - s[2] - s[32] - s[62] + s[18] + s[48] + s[78];
gout[n*16+8] = + s[34] - s[58] - s[42] + s[66];
gout[n*16+9] = + s[55] - s[7] - s[63] + s[15];
gout[n*16+10] = + s[4] - s[28] - s[12] + s[36];
gout[n*16+11] = + s[1] + s[31] + s[61] - s[9] - s[39] - s[69];
gout[n*16+12] = - s[33] + s[57] - s[43] + s[67] - s[53] + s[77];
gout[n*16+13] = - s[54] + s[6] - s[64] + s[16] - s[74] + s[26];
gout[n*16+14] = - s[3] + s[27] - s[13] + s[37] - s[23] + s[47];
gout[n*16+15] = - s[0] - s[30] - s[60] - s[10] - s[40] - s[70] - s[20] - s[50] - s[80];
} else {
gout[n*16+0] += + s[44] - s[68] - s[52] + s[76];
gout[n*16+1] += + s[65] - s[17] - s[73] + s[25];
gout[n*16+2] += + s[14] - s[38] - s[22] + s[46];
gout[n*16+3] += + s[11] + s[41] + s[71] - s[19] - s[49] - s[79];
gout[n*16+4] += - s[35] + s[59] + s[51] - s[75];
gout[n*16+5] += - s[56] + s[8] + s[72] - s[24];
gout[n*16+6] += - s[5] + s[29] + s[21] - s[45];
gout[n*16+7] += - s[2] - s[32] - s[62] + s[18] + s[48] + s[78];
gout[n*16+8] += + s[34] - s[58] - s[42] + s[66];
gout[n*16+9] += + s[55] - s[7] - s[63] + s[15];
gout[n*16+10] += + s[4] - s[28] - s[12] + s[36];
gout[n*16+11] += + s[1] + s[31] + s[61] - s[9] - s[39] - s[69];
gout[n*16+12] += - s[33] + s[57] - s[43] + s[67] - s[53] + s[77];
gout[n*16+13] += - s[54] + s[6] - s[64] + s[16] - s[74] + s[26];
gout[n*16+14] += - s[3] + s[27] - s[13] + s[37] - s[23] + s[47];
gout[n*16+15] += - s[0] - s[30] - s[60] - s[10] - s[40] - s[70] - s[20] - s[50] - s[80];
}}}
void int2e_gauge_r1_ssp1sps2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 3, 1, 0, 4, 4, 4, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_gauge_r1_ssp1sps2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 3, 1, 0, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r1_ssp1sps2;
envs.common_factor *= -1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r1_ssp1sps2_cart
int int2e_gauge_r1_ssp1sps2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 3, 1, 0, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r1_ssp1sps2;
envs.common_factor *= -1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r1_ssp1sps2_sph
int int2e_gauge_r1_ssp1sps2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 3, 1, 0, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r1_ssp1sps2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_si_2e2i);
} // int2e_gauge_r1_ssp1sps2_spinor
ALL_CINT(int2e_gauge_r1_ssp1sps2)
ALL_CINT_FORTRAN_(int2e_gauge_r1_ssp1sps2)
/* <k SIGMA DOT P i|BREIT-R1 |R0 j SIGMA DOT P l> : i,j \in electron 1; k,l \in electron 2
 * = (SIGMA DOT P i R0 j|BREIT-R1 |k SIGMA DOT P l) */
static void CINTgout2e_int2e_gauge_r1_sps1ssp2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
double *g16 = g15 + envs->g_size * 3;
G2E_D_L(g1, g0, envs->i_l+2, envs->j_l+2, envs->k_l+0, envs->l_l+0);
G2E_R0J(g2, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R0J(g3, g1, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g4, g0, envs->i_l+1, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g5, g0, envs->i_l+1, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g4[ix] += g5[ix];}
G2E_D_J(g5, g1, envs->i_l+1, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g6, g1, envs->i_l+1, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g5[ix] += g6[ix];}
G2E_R0J(g6, g4, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R0J(g7, g5, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g8, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g9, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g10, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g11, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g12, g4, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g13, g5, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g14, g6, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g15, g7, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[81];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 81; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g15[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g14[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g14[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g13[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g12[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g12[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g13[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g12[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g12[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g11[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g10[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g10[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g9[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g8[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g8[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g9[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g8[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g8[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g11[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g10[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g10[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g9[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g8[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g8[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g9[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g8[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g8[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g7[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g6[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g6[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g5[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g4[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g4[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g5[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g4[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g4[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g3[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g2[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g2[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g1[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g0[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g0[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g1[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g0[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g0[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g3[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g2[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g2[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g1[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g0[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g0[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g1[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g0[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g0[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g7[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g6[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g6[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g5[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g4[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g4[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g5[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g4[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g4[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g3[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g2[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g2[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g1[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g0[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g0[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g1[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g0[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g0[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g3[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g2[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g2[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g1[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g0[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g0[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g1[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g0[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g0[ix+i] * g0[iy+i] * g15[iz+i];
}
if (gout_empty) {
gout[n*16+0] = - s[50] + s[68] + s[52] - s[70];
gout[n*16+1] = - s[59] + s[23] + s[61] - s[25];
gout[n*16+2] = - s[14] + s[32] + s[16] - s[34];
gout[n*16+3] = - s[5] - s[41] - s[77] + s[7] + s[43] + s[79];
gout[n*16+4] = + s[47] - s[65] - s[51] + s[69];
gout[n*16+5] = + s[56] - s[20] - s[60] + s[24];
gout[n*16+6] = + s[11] - s[29] - s[15] + s[33];
gout[n*16+7] = + s[2] + s[38] + s[74] - s[6] - s[42] - s[78];
gout[n*16+8] = - s[46] + s[64] + s[48] - s[66];
gout[n*16+9] = - s[55] + s[19] + s[57] - s[21];
gout[n*16+10] = - s[10] + s[28] + s[12] - s[30];
gout[n*16+11] = - s[1] - s[37] - s[73] + s[3] + s[39] + s[75];
gout[n*16+12] = - s[45] + s[63] - s[49] + s[67] - s[53] + s[71];
gout[n*16+13] = - s[54] + s[18] - s[58] + s[22] - s[62] + s[26];
gout[n*16+14] = - s[9] + s[27] - s[13] + s[31] - s[17] + s[35];
gout[n*16+15] = - s[0] - s[36] - s[72] - s[4] - s[40] - s[76] - s[8] - s[44] - s[80];
} else {
gout[n*16+0] += - s[50] + s[68] + s[52] - s[70];
gout[n*16+1] += - s[59] + s[23] + s[61] - s[25];
gout[n*16+2] += - s[14] + s[32] + s[16] - s[34];
gout[n*16+3] += - s[5] - s[41] - s[77] + s[7] + s[43] + s[79];
gout[n*16+4] += + s[47] - s[65] - s[51] + s[69];
gout[n*16+5] += + s[56] - s[20] - s[60] + s[24];
gout[n*16+6] += + s[11] - s[29] - s[15] + s[33];
gout[n*16+7] += + s[2] + s[38] + s[74] - s[6] - s[42] - s[78];
gout[n*16+8] += - s[46] + s[64] + s[48] - s[66];
gout[n*16+9] += - s[55] + s[19] + s[57] - s[21];
gout[n*16+10] += - s[10] + s[28] + s[12] - s[30];
gout[n*16+11] += - s[1] - s[37] - s[73] + s[3] + s[39] + s[75];
gout[n*16+12] += - s[45] + s[63] - s[49] + s[67] - s[53] + s[71];
gout[n*16+13] += - s[54] + s[18] - s[58] + s[22] - s[62] + s[26];
gout[n*16+14] += - s[9] + s[27] - s[13] + s[31] - s[17] + s[35];
gout[n*16+15] += - s[0] - s[36] - s[72] - s[4] - s[40] - s[76] - s[8] - s[44] - s[80];
}}}
void int2e_gauge_r1_sps1ssp2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 2, 0, 1, 4, 4, 4, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_gauge_r1_sps1ssp2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 2, 0, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r1_sps1ssp2;
envs.common_factor *= -1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r1_sps1ssp2_cart
int int2e_gauge_r1_sps1ssp2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 2, 0, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r1_sps1ssp2;
envs.common_factor *= -1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r1_sps1ssp2_sph
int int2e_gauge_r1_sps1ssp2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 2, 0, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r1_sps1ssp2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_si_2e2i);
} // int2e_gauge_r1_sps1ssp2_spinor
ALL_CINT(int2e_gauge_r1_sps1ssp2)
ALL_CINT_FORTRAN_(int2e_gauge_r1_sps1ssp2)
/* <SIGMA DOT P k SIGMA DOT P i|BREIT-R1 |R0 j l> : i,j \in electron 1; k,l \in electron 2
 * = (SIGMA DOT P i R0 j|BREIT-R1 |SIGMA DOT P k l) */
static void CINTgout2e_int2e_gauge_r1_sps1sps2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
double *g16 = g15 + envs->g_size * 3;
G2E_D_K(g1, g0, envs->i_l+2, envs->j_l+2, envs->k_l+0, envs->l_l);
G2E_R0J(g2, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R0J(g3, g1, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g4, g0, envs->i_l+1, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g5, g0, envs->i_l+1, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g4[ix] += g5[ix];}
G2E_D_J(g5, g1, envs->i_l+1, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g6, g1, envs->i_l+1, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g5[ix] += g6[ix];}
G2E_R0J(g6, g4, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_R0J(g7, g5, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g8, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g9, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g10, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g11, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g12, g4, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g13, g5, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g14, g6, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g15, g7, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[81];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 81; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g15[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g14[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g14[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g13[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g12[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g12[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g13[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g12[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g12[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g11[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g10[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g10[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g9[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g8[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g8[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g9[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g8[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g8[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g11[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g10[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g10[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g9[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g8[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g8[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g9[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g8[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g8[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g7[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g6[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g6[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g5[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g4[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g4[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g5[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g4[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g4[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g3[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g2[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g2[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g1[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g0[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g0[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g1[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g0[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g0[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g3[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g2[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g2[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g1[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g0[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g0[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g1[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g0[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g0[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g7[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g6[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g6[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g5[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g4[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g4[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g5[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g4[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g4[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g3[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g2[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g2[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g1[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g0[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g0[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g1[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g0[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g0[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g3[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g2[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g2[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g1[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g0[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g0[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g1[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g0[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g0[ix+i] * g0[iy+i] * g15[iz+i];
}
if (gout_empty) {
gout[n*16+0] = - s[50] + s[68] + s[52] - s[70];
gout[n*16+1] = - s[59] + s[23] + s[61] - s[25];
gout[n*16+2] = - s[14] + s[32] + s[16] - s[34];
gout[n*16+3] = - s[5] - s[41] - s[77] + s[7] + s[43] + s[79];
gout[n*16+4] = + s[47] - s[65] - s[51] + s[69];
gout[n*16+5] = + s[56] - s[20] - s[60] + s[24];
gout[n*16+6] = + s[11] - s[29] - s[15] + s[33];
gout[n*16+7] = + s[2] + s[38] + s[74] - s[6] - s[42] - s[78];
gout[n*16+8] = - s[46] + s[64] + s[48] - s[66];
gout[n*16+9] = - s[55] + s[19] + s[57] - s[21];
gout[n*16+10] = - s[10] + s[28] + s[12] - s[30];
gout[n*16+11] = - s[1] - s[37] - s[73] + s[3] + s[39] + s[75];
gout[n*16+12] = + s[45] - s[63] + s[49] - s[67] + s[53] - s[71];
gout[n*16+13] = + s[54] - s[18] + s[58] - s[22] + s[62] - s[26];
gout[n*16+14] = + s[9] - s[27] + s[13] - s[31] + s[17] - s[35];
gout[n*16+15] = + s[0] + s[36] + s[72] + s[4] + s[40] + s[76] + s[8] + s[44] + s[80];
} else {
gout[n*16+0] += - s[50] + s[68] + s[52] - s[70];
gout[n*16+1] += - s[59] + s[23] + s[61] - s[25];
gout[n*16+2] += - s[14] + s[32] + s[16] - s[34];
gout[n*16+3] += - s[5] - s[41] - s[77] + s[7] + s[43] + s[79];
gout[n*16+4] += + s[47] - s[65] - s[51] + s[69];
gout[n*16+5] += + s[56] - s[20] - s[60] + s[24];
gout[n*16+6] += + s[11] - s[29] - s[15] + s[33];
gout[n*16+7] += + s[2] + s[38] + s[74] - s[6] - s[42] - s[78];
gout[n*16+8] += - s[46] + s[64] + s[48] - s[66];
gout[n*16+9] += - s[55] + s[19] + s[57] - s[21];
gout[n*16+10] += - s[10] + s[28] + s[12] - s[30];
gout[n*16+11] += - s[1] - s[37] - s[73] + s[3] + s[39] + s[75];
gout[n*16+12] += + s[45] - s[63] + s[49] - s[67] + s[53] - s[71];
gout[n*16+13] += + s[54] - s[18] + s[58] - s[22] + s[62] - s[26];
gout[n*16+14] += + s[9] - s[27] + s[13] - s[31] + s[17] - s[35];
gout[n*16+15] += + s[0] + s[36] + s[72] + s[4] + s[40] + s[76] + s[8] + s[44] + s[80];
}}}
void int2e_gauge_r1_sps1sps2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 2, 1, 0, 4, 4, 4, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_gauge_r1_sps1sps2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 2, 1, 0, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r1_sps1sps2;
envs.common_factor *= -1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r1_sps1sps2_cart
int int2e_gauge_r1_sps1sps2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 2, 1, 0, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r1_sps1sps2;
envs.common_factor *= -1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r1_sps1sps2_sph
int int2e_gauge_r1_sps1sps2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 2, 1, 0, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r1_sps1sps2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_si_2e2i);
} // int2e_gauge_r1_sps1sps2_spinor
ALL_CINT(int2e_gauge_r1_sps1sps2)
ALL_CINT_FORTRAN_(int2e_gauge_r1_sps1sps2)
/* <k i|BREIT-R2 |SIGMA DOT P j R0 SIGMA DOT P l> : i,j \in electron 1; k,l \in electron 2
 * = (i SIGMA DOT P j|BREIT-R2 |k R0 SIGMA DOT P l) */
static void CINTgout2e_int2e_gauge_r2_ssp1ssp2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
double *g16 = g15 + envs->g_size * 3;
G2E_D_L(g1, g0, envs->i_l+1, envs->j_l+2, envs->k_l+0, envs->l_l+0);
G2E_R0L(g2, g0, envs->i_l+1, envs->j_l+2, envs->k_l+0, envs->l_l+1);
G2E_D_L(g3, g2, envs->i_l+1, envs->j_l+2, envs->k_l+0, envs->l_l+0);
G2E_D_J(g4, g0, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g5, g1, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g6, g2, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g7, g3, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g8, g0, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g9, g0, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g8[ix] += g9[ix];}
G2E_D_J(g9, g1, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g10, g1, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g9[ix] += g10[ix];}
G2E_D_J(g10, g2, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g11, g2, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g10[ix] += g11[ix];}
G2E_D_J(g11, g3, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g12, g3, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g11[ix] += g12[ix];}
G2E_D_J(g12, g8, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g13, g9, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g14, g10, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g15, g11, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
double s[81];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 81; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g15[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g14[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g14[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g13[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g12[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g12[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g13[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g12[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g12[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g11[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g10[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g10[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g9[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g8[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g8[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g9[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g8[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g8[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g11[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g10[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g10[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g9[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g8[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g8[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g9[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g8[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g8[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g7[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g6[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g6[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g5[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g4[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g4[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g5[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g4[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g4[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g3[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g2[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g2[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g1[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g0[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g0[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g1[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g0[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g0[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g3[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g2[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g2[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g1[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g0[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g0[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g1[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g0[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g0[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g7[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g6[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g6[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g5[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g4[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g4[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g5[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g4[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g4[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g3[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g2[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g2[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g1[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g0[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g0[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g1[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g0[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g0[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g3[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g2[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g2[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g1[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g0[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g0[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g1[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g0[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g0[ix+i] * g0[iy+i] * g15[iz+i];
}
if (gout_empty) {
gout[n*16+0] = + s[50] - s[68] - s[52] + s[70];
gout[n*16+1] = + s[59] - s[23] - s[61] + s[25];
gout[n*16+2] = + s[14] - s[32] - s[16] + s[34];
gout[n*16+3] = + s[5] + s[41] + s[77] - s[7] - s[43] - s[79];
gout[n*16+4] = + s[51] - s[69] - s[47] + s[65];
gout[n*16+5] = + s[60] - s[24] - s[56] + s[20];
gout[n*16+6] = + s[15] - s[33] - s[11] + s[29];
gout[n*16+7] = + s[6] + s[42] + s[78] - s[2] - s[38] - s[74];
gout[n*16+8] = + s[46] - s[64] - s[48] + s[66];
gout[n*16+9] = + s[55] - s[19] - s[57] + s[21];
gout[n*16+10] = + s[10] - s[28] - s[12] + s[30];
gout[n*16+11] = + s[1] + s[37] + s[73] - s[3] - s[39] - s[75];
gout[n*16+12] = + s[45] - s[63] + s[49] - s[67] + s[53] - s[71];
gout[n*16+13] = + s[54] - s[18] + s[58] - s[22] + s[62] - s[26];
gout[n*16+14] = + s[9] - s[27] + s[13] - s[31] + s[17] - s[35];
gout[n*16+15] = + s[0] + s[36] + s[72] + s[4] + s[40] + s[76] + s[8] + s[44] + s[80];
} else {
gout[n*16+0] += + s[50] - s[68] - s[52] + s[70];
gout[n*16+1] += + s[59] - s[23] - s[61] + s[25];
gout[n*16+2] += + s[14] - s[32] - s[16] + s[34];
gout[n*16+3] += + s[5] + s[41] + s[77] - s[7] - s[43] - s[79];
gout[n*16+4] += + s[51] - s[69] - s[47] + s[65];
gout[n*16+5] += + s[60] - s[24] - s[56] + s[20];
gout[n*16+6] += + s[15] - s[33] - s[11] + s[29];
gout[n*16+7] += + s[6] + s[42] + s[78] - s[2] - s[38] - s[74];
gout[n*16+8] += + s[46] - s[64] - s[48] + s[66];
gout[n*16+9] += + s[55] - s[19] - s[57] + s[21];
gout[n*16+10] += + s[10] - s[28] - s[12] + s[30];
gout[n*16+11] += + s[1] + s[37] + s[73] - s[3] - s[39] - s[75];
gout[n*16+12] += + s[45] - s[63] + s[49] - s[67] + s[53] - s[71];
gout[n*16+13] += + s[54] - s[18] + s[58] - s[22] + s[62] - s[26];
gout[n*16+14] += + s[9] - s[27] + s[13] - s[31] + s[17] - s[35];
gout[n*16+15] += + s[0] + s[36] + s[72] + s[4] + s[40] + s[76] + s[8] + s[44] + s[80];
}}}
void int2e_gauge_r2_ssp1ssp2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 2, 0, 2, 4, 4, 4, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_gauge_r2_ssp1ssp2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 2, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r2_ssp1ssp2;
envs.common_factor *= -1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r2_ssp1ssp2_cart
int int2e_gauge_r2_ssp1ssp2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 2, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r2_ssp1ssp2;
envs.common_factor *= -1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r2_ssp1ssp2_sph
int int2e_gauge_r2_ssp1ssp2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 0, 2, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r2_ssp1ssp2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_si_2e2i);
} // int2e_gauge_r2_ssp1ssp2_spinor
ALL_CINT(int2e_gauge_r2_ssp1ssp2)
ALL_CINT_FORTRAN_(int2e_gauge_r2_ssp1ssp2)
/* <SIGMA DOT P k i|BREIT-R2 |SIGMA DOT P j R0 l> : i,j \in electron 1; k,l \in electron 2
 * = (i SIGMA DOT P j|BREIT-R2 |SIGMA DOT P k R0 l) */
static void CINTgout2e_int2e_gauge_r2_ssp1sps2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
double *g16 = g15 + envs->g_size * 3;
G2E_R0L(g1, g0, envs->i_l+1, envs->j_l+2, envs->k_l+1, envs->l_l+0);
G2E_D_K(g2, g0, envs->i_l+1, envs->j_l+2, envs->k_l+0, envs->l_l);
G2E_D_K(g3, g1, envs->i_l+1, envs->j_l+2, envs->k_l+0, envs->l_l);
G2E_D_J(g4, g0, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g5, g1, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g6, g2, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g7, g3, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g8, g0, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g9, g0, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g8[ix] += g9[ix];}
G2E_D_J(g9, g1, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g10, g1, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g9[ix] += g10[ix];}
G2E_D_J(g10, g2, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g11, g2, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g10[ix] += g11[ix];}
G2E_D_J(g11, g3, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
G2E_D_I(g12, g3, envs->i_l+0, envs->j_l+1, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g11[ix] += g12[ix];}
G2E_D_J(g12, g8, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g13, g9, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g14, g10, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_J(g15, g11, envs->i_l+0, envs->j_l+0, envs->k_l, envs->l_l);
double s[81];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 81; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g15[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g14[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g14[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g13[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g12[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g12[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g13[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g12[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g12[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g11[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g10[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g10[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g9[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g8[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g8[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g9[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g8[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g8[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g11[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g10[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g10[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g9[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g8[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g8[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g9[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g8[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g8[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g7[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g6[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g6[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g5[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g4[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g4[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g5[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g4[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g4[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g3[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g2[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g2[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g1[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g0[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g0[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g1[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g0[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g0[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g3[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g2[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g2[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g1[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g0[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g0[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g1[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g0[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g0[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g7[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g6[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g6[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g5[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g4[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g4[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g5[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g4[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g4[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g3[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g2[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g2[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g1[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g0[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g0[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g1[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g0[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g0[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g3[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g2[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g2[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g1[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g0[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g0[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g1[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g0[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g0[ix+i] * g0[iy+i] * g15[iz+i];
}
if (gout_empty) {
gout[n*16+0] = - s[50] + s[68] + s[52] - s[70];
gout[n*16+1] = - s[59] + s[23] + s[61] - s[25];
gout[n*16+2] = - s[14] + s[32] + s[16] - s[34];
gout[n*16+3] = - s[5] - s[41] - s[77] + s[7] + s[43] + s[79];
gout[n*16+4] = - s[51] + s[69] + s[47] - s[65];
gout[n*16+5] = - s[60] + s[24] + s[56] - s[20];
gout[n*16+6] = - s[15] + s[33] + s[11] - s[29];
gout[n*16+7] = - s[6] - s[42] - s[78] + s[2] + s[38] + s[74];
gout[n*16+8] = - s[46] + s[64] + s[48] - s[66];
gout[n*16+9] = - s[55] + s[19] + s[57] - s[21];
gout[n*16+10] = - s[10] + s[28] + s[12] - s[30];
gout[n*16+11] = - s[1] - s[37] - s[73] + s[3] + s[39] + s[75];
gout[n*16+12] = - s[45] + s[63] - s[49] + s[67] - s[53] + s[71];
gout[n*16+13] = - s[54] + s[18] - s[58] + s[22] - s[62] + s[26];
gout[n*16+14] = - s[9] + s[27] - s[13] + s[31] - s[17] + s[35];
gout[n*16+15] = - s[0] - s[36] - s[72] - s[4] - s[40] - s[76] - s[8] - s[44] - s[80];
} else {
gout[n*16+0] += - s[50] + s[68] + s[52] - s[70];
gout[n*16+1] += - s[59] + s[23] + s[61] - s[25];
gout[n*16+2] += - s[14] + s[32] + s[16] - s[34];
gout[n*16+3] += - s[5] - s[41] - s[77] + s[7] + s[43] + s[79];
gout[n*16+4] += - s[51] + s[69] + s[47] - s[65];
gout[n*16+5] += - s[60] + s[24] + s[56] - s[20];
gout[n*16+6] += - s[15] + s[33] + s[11] - s[29];
gout[n*16+7] += - s[6] - s[42] - s[78] + s[2] + s[38] + s[74];
gout[n*16+8] += - s[46] + s[64] + s[48] - s[66];
gout[n*16+9] += - s[55] + s[19] + s[57] - s[21];
gout[n*16+10] += - s[10] + s[28] + s[12] - s[30];
gout[n*16+11] += - s[1] - s[37] - s[73] + s[3] + s[39] + s[75];
gout[n*16+12] += - s[45] + s[63] - s[49] + s[67] - s[53] + s[71];
gout[n*16+13] += - s[54] + s[18] - s[58] + s[22] - s[62] + s[26];
gout[n*16+14] += - s[9] + s[27] - s[13] + s[31] - s[17] + s[35];
gout[n*16+15] += - s[0] - s[36] - s[72] - s[4] - s[40] - s[76] - s[8] - s[44] - s[80];
}}}
void int2e_gauge_r2_ssp1sps2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {1, 2, 1, 1, 4, 4, 4, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_gauge_r2_ssp1sps2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 1, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r2_ssp1sps2;
envs.common_factor *= -1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r2_ssp1sps2_cart
int int2e_gauge_r2_ssp1sps2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 1, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r2_ssp1sps2;
envs.common_factor *= -1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r2_ssp1sps2_sph
int int2e_gauge_r2_ssp1sps2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {1, 2, 1, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r2_ssp1sps2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_si_2e2i);
} // int2e_gauge_r2_ssp1sps2_spinor
ALL_CINT(int2e_gauge_r2_ssp1sps2)
ALL_CINT_FORTRAN_(int2e_gauge_r2_ssp1sps2)
/* <k SIGMA DOT P i|BREIT-R2 |j R0 SIGMA DOT P l> : i,j \in electron 1; k,l \in electron 2
 * = (SIGMA DOT P i j|BREIT-R2 |k R0 SIGMA DOT P l) */
static void CINTgout2e_int2e_gauge_r2_sps1ssp2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
double *g16 = g15 + envs->g_size * 3;
G2E_D_L(g1, g0, envs->i_l+2, envs->j_l+1, envs->k_l+0, envs->l_l+0);
G2E_R0L(g2, g0, envs->i_l+2, envs->j_l+1, envs->k_l+0, envs->l_l+1);
G2E_D_L(g3, g2, envs->i_l+2, envs->j_l+1, envs->k_l+0, envs->l_l+0);
G2E_D_J(g4, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g5, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g4[ix] += g5[ix];}
G2E_D_J(g5, g1, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g6, g1, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g5[ix] += g6[ix];}
G2E_D_J(g6, g2, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g7, g2, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g6[ix] += g7[ix];}
G2E_D_J(g7, g3, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g8, g3, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g7[ix] += g8[ix];}
G2E_D_I(g8, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g9, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g10, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g11, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g12, g4, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g13, g5, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g14, g6, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g15, g7, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[81];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 81; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g15[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g14[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g14[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g13[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g12[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g12[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g13[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g12[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g12[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g11[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g10[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g10[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g9[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g8[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g8[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g9[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g8[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g8[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g11[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g10[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g10[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g9[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g8[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g8[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g9[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g8[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g8[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g7[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g6[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g6[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g5[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g4[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g4[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g5[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g4[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g4[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g3[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g2[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g2[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g1[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g0[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g0[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g1[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g0[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g0[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g3[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g2[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g2[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g1[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g0[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g0[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g1[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g0[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g0[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g7[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g6[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g6[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g5[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g4[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g4[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g5[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g4[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g4[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g3[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g2[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g2[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g1[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g0[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g0[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g1[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g0[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g0[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g3[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g2[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g2[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g1[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g0[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g0[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g1[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g0[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g0[ix+i] * g0[iy+i] * g15[iz+i];
}
if (gout_empty) {
gout[n*16+0] = - s[50] + s[68] + s[52] - s[70];
gout[n*16+1] = - s[59] + s[23] + s[61] - s[25];
gout[n*16+2] = - s[14] + s[32] + s[16] - s[34];
gout[n*16+3] = - s[5] - s[41] - s[77] + s[7] + s[43] + s[79];
gout[n*16+4] = - s[51] + s[69] + s[47] - s[65];
gout[n*16+5] = - s[60] + s[24] + s[56] - s[20];
gout[n*16+6] = - s[15] + s[33] + s[11] - s[29];
gout[n*16+7] = - s[6] - s[42] - s[78] + s[2] + s[38] + s[74];
gout[n*16+8] = - s[46] + s[64] + s[48] - s[66];
gout[n*16+9] = - s[55] + s[19] + s[57] - s[21];
gout[n*16+10] = - s[10] + s[28] + s[12] - s[30];
gout[n*16+11] = - s[1] - s[37] - s[73] + s[3] + s[39] + s[75];
gout[n*16+12] = - s[45] + s[63] - s[49] + s[67] - s[53] + s[71];
gout[n*16+13] = - s[54] + s[18] - s[58] + s[22] - s[62] + s[26];
gout[n*16+14] = - s[9] + s[27] - s[13] + s[31] - s[17] + s[35];
gout[n*16+15] = - s[0] - s[36] - s[72] - s[4] - s[40] - s[76] - s[8] - s[44] - s[80];
} else {
gout[n*16+0] += - s[50] + s[68] + s[52] - s[70];
gout[n*16+1] += - s[59] + s[23] + s[61] - s[25];
gout[n*16+2] += - s[14] + s[32] + s[16] - s[34];
gout[n*16+3] += - s[5] - s[41] - s[77] + s[7] + s[43] + s[79];
gout[n*16+4] += - s[51] + s[69] + s[47] - s[65];
gout[n*16+5] += - s[60] + s[24] + s[56] - s[20];
gout[n*16+6] += - s[15] + s[33] + s[11] - s[29];
gout[n*16+7] += - s[6] - s[42] - s[78] + s[2] + s[38] + s[74];
gout[n*16+8] += - s[46] + s[64] + s[48] - s[66];
gout[n*16+9] += - s[55] + s[19] + s[57] - s[21];
gout[n*16+10] += - s[10] + s[28] + s[12] - s[30];
gout[n*16+11] += - s[1] - s[37] - s[73] + s[3] + s[39] + s[75];
gout[n*16+12] += - s[45] + s[63] - s[49] + s[67] - s[53] + s[71];
gout[n*16+13] += - s[54] + s[18] - s[58] + s[22] - s[62] + s[26];
gout[n*16+14] += - s[9] + s[27] - s[13] + s[31] - s[17] + s[35];
gout[n*16+15] += - s[0] - s[36] - s[72] - s[4] - s[40] - s[76] - s[8] - s[44] - s[80];
}}}
void int2e_gauge_r2_sps1ssp2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 1, 0, 2, 4, 4, 4, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_gauge_r2_sps1ssp2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 2, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r2_sps1ssp2;
envs.common_factor *= -1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r2_sps1ssp2_cart
int int2e_gauge_r2_sps1ssp2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 2, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r2_sps1ssp2;
envs.common_factor *= -1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r2_sps1ssp2_sph
int int2e_gauge_r2_sps1ssp2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 0, 2, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r2_sps1ssp2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_si_2e2i);
} // int2e_gauge_r2_sps1ssp2_spinor
ALL_CINT(int2e_gauge_r2_sps1ssp2)
ALL_CINT_FORTRAN_(int2e_gauge_r2_sps1ssp2)
/* <SIGMA DOT P k SIGMA DOT P i|BREIT-R2 |j R0 l> : i,j \in electron 1; k,l \in electron 2
 * = (SIGMA DOT P i j|BREIT-R2 |SIGMA DOT P k R0 l) */
static void CINTgout2e_int2e_gauge_r2_sps1sps2(double *gout,
double *g, int *idx, CINTEnvVars *envs, int gout_empty) {
int nf = envs->nf;
int nrys_roots = envs->nrys_roots;
int ix, iy, iz, i, n;
double *g0 = g;
double *g1 = g0 + envs->g_size * 3;
double *g2 = g1 + envs->g_size * 3;
double *g3 = g2 + envs->g_size * 3;
double *g4 = g3 + envs->g_size * 3;
double *g5 = g4 + envs->g_size * 3;
double *g6 = g5 + envs->g_size * 3;
double *g7 = g6 + envs->g_size * 3;
double *g8 = g7 + envs->g_size * 3;
double *g9 = g8 + envs->g_size * 3;
double *g10 = g9 + envs->g_size * 3;
double *g11 = g10 + envs->g_size * 3;
double *g12 = g11 + envs->g_size * 3;
double *g13 = g12 + envs->g_size * 3;
double *g14 = g13 + envs->g_size * 3;
double *g15 = g14 + envs->g_size * 3;
double *g16 = g15 + envs->g_size * 3;
G2E_R0L(g1, g0, envs->i_l+2, envs->j_l+1, envs->k_l+1, envs->l_l+0);
G2E_D_K(g2, g0, envs->i_l+2, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_K(g3, g1, envs->i_l+2, envs->j_l+1, envs->k_l+0, envs->l_l);
G2E_D_J(g4, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g5, g0, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g4[ix] += g5[ix];}
G2E_D_J(g5, g1, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g6, g1, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g5[ix] += g6[ix];}
G2E_D_J(g6, g2, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g7, g2, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g6[ix] += g7[ix];}
G2E_D_J(g7, g3, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
G2E_D_I(g8, g3, envs->i_l+1, envs->j_l+0, envs->k_l, envs->l_l);
for (ix = 0; ix < envs->g_size * 3; ix++) {g7[ix] += g8[ix];}
G2E_D_I(g8, g0, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g9, g1, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g10, g2, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g11, g3, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g12, g4, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g13, g5, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g14, g6, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
G2E_D_I(g15, g7, envs->i_l+0, envs->j_l, envs->k_l, envs->l_l);
double s[81];
for (n = 0; n < nf; n++) {
ix = idx[0+n*3];
iy = idx[1+n*3];
iz = idx[2+n*3];
for (i = 0; i < 81; i++) { s[i] = 0; }
for (i = 0; i < nrys_roots; i++) {
s[0] += g15[ix+i] * g0[iy+i] * g0[iz+i];
s[1] += g14[ix+i] * g1[iy+i] * g0[iz+i];
s[2] += g14[ix+i] * g0[iy+i] * g1[iz+i];
s[3] += g13[ix+i] * g2[iy+i] * g0[iz+i];
s[4] += g12[ix+i] * g3[iy+i] * g0[iz+i];
s[5] += g12[ix+i] * g2[iy+i] * g1[iz+i];
s[6] += g13[ix+i] * g0[iy+i] * g2[iz+i];
s[7] += g12[ix+i] * g1[iy+i] * g2[iz+i];
s[8] += g12[ix+i] * g0[iy+i] * g3[iz+i];
s[9] += g11[ix+i] * g4[iy+i] * g0[iz+i];
s[10] += g10[ix+i] * g5[iy+i] * g0[iz+i];
s[11] += g10[ix+i] * g4[iy+i] * g1[iz+i];
s[12] += g9[ix+i] * g6[iy+i] * g0[iz+i];
s[13] += g8[ix+i] * g7[iy+i] * g0[iz+i];
s[14] += g8[ix+i] * g6[iy+i] * g1[iz+i];
s[15] += g9[ix+i] * g4[iy+i] * g2[iz+i];
s[16] += g8[ix+i] * g5[iy+i] * g2[iz+i];
s[17] += g8[ix+i] * g4[iy+i] * g3[iz+i];
s[18] += g11[ix+i] * g0[iy+i] * g4[iz+i];
s[19] += g10[ix+i] * g1[iy+i] * g4[iz+i];
s[20] += g10[ix+i] * g0[iy+i] * g5[iz+i];
s[21] += g9[ix+i] * g2[iy+i] * g4[iz+i];
s[22] += g8[ix+i] * g3[iy+i] * g4[iz+i];
s[23] += g8[ix+i] * g2[iy+i] * g5[iz+i];
s[24] += g9[ix+i] * g0[iy+i] * g6[iz+i];
s[25] += g8[ix+i] * g1[iy+i] * g6[iz+i];
s[26] += g8[ix+i] * g0[iy+i] * g7[iz+i];
s[27] += g7[ix+i] * g8[iy+i] * g0[iz+i];
s[28] += g6[ix+i] * g9[iy+i] * g0[iz+i];
s[29] += g6[ix+i] * g8[iy+i] * g1[iz+i];
s[30] += g5[ix+i] * g10[iy+i] * g0[iz+i];
s[31] += g4[ix+i] * g11[iy+i] * g0[iz+i];
s[32] += g4[ix+i] * g10[iy+i] * g1[iz+i];
s[33] += g5[ix+i] * g8[iy+i] * g2[iz+i];
s[34] += g4[ix+i] * g9[iy+i] * g2[iz+i];
s[35] += g4[ix+i] * g8[iy+i] * g3[iz+i];
s[36] += g3[ix+i] * g12[iy+i] * g0[iz+i];
s[37] += g2[ix+i] * g13[iy+i] * g0[iz+i];
s[38] += g2[ix+i] * g12[iy+i] * g1[iz+i];
s[39] += g1[ix+i] * g14[iy+i] * g0[iz+i];
s[40] += g0[ix+i] * g15[iy+i] * g0[iz+i];
s[41] += g0[ix+i] * g14[iy+i] * g1[iz+i];
s[42] += g1[ix+i] * g12[iy+i] * g2[iz+i];
s[43] += g0[ix+i] * g13[iy+i] * g2[iz+i];
s[44] += g0[ix+i] * g12[iy+i] * g3[iz+i];
s[45] += g3[ix+i] * g8[iy+i] * g4[iz+i];
s[46] += g2[ix+i] * g9[iy+i] * g4[iz+i];
s[47] += g2[ix+i] * g8[iy+i] * g5[iz+i];
s[48] += g1[ix+i] * g10[iy+i] * g4[iz+i];
s[49] += g0[ix+i] * g11[iy+i] * g4[iz+i];
s[50] += g0[ix+i] * g10[iy+i] * g5[iz+i];
s[51] += g1[ix+i] * g8[iy+i] * g6[iz+i];
s[52] += g0[ix+i] * g9[iy+i] * g6[iz+i];
s[53] += g0[ix+i] * g8[iy+i] * g7[iz+i];
s[54] += g7[ix+i] * g0[iy+i] * g8[iz+i];
s[55] += g6[ix+i] * g1[iy+i] * g8[iz+i];
s[56] += g6[ix+i] * g0[iy+i] * g9[iz+i];
s[57] += g5[ix+i] * g2[iy+i] * g8[iz+i];
s[58] += g4[ix+i] * g3[iy+i] * g8[iz+i];
s[59] += g4[ix+i] * g2[iy+i] * g9[iz+i];
s[60] += g5[ix+i] * g0[iy+i] * g10[iz+i];
s[61] += g4[ix+i] * g1[iy+i] * g10[iz+i];
s[62] += g4[ix+i] * g0[iy+i] * g11[iz+i];
s[63] += g3[ix+i] * g4[iy+i] * g8[iz+i];
s[64] += g2[ix+i] * g5[iy+i] * g8[iz+i];
s[65] += g2[ix+i] * g4[iy+i] * g9[iz+i];
s[66] += g1[ix+i] * g6[iy+i] * g8[iz+i];
s[67] += g0[ix+i] * g7[iy+i] * g8[iz+i];
s[68] += g0[ix+i] * g6[iy+i] * g9[iz+i];
s[69] += g1[ix+i] * g4[iy+i] * g10[iz+i];
s[70] += g0[ix+i] * g5[iy+i] * g10[iz+i];
s[71] += g0[ix+i] * g4[iy+i] * g11[iz+i];
s[72] += g3[ix+i] * g0[iy+i] * g12[iz+i];
s[73] += g2[ix+i] * g1[iy+i] * g12[iz+i];
s[74] += g2[ix+i] * g0[iy+i] * g13[iz+i];
s[75] += g1[ix+i] * g2[iy+i] * g12[iz+i];
s[76] += g0[ix+i] * g3[iy+i] * g12[iz+i];
s[77] += g0[ix+i] * g2[iy+i] * g13[iz+i];
s[78] += g1[ix+i] * g0[iy+i] * g14[iz+i];
s[79] += g0[ix+i] * g1[iy+i] * g14[iz+i];
s[80] += g0[ix+i] * g0[iy+i] * g15[iz+i];
}
if (gout_empty) {
gout[n*16+0] = + s[50] - s[68] - s[52] + s[70];
gout[n*16+1] = + s[59] - s[23] - s[61] + s[25];
gout[n*16+2] = + s[14] - s[32] - s[16] + s[34];
gout[n*16+3] = + s[5] + s[41] + s[77] - s[7] - s[43] - s[79];
gout[n*16+4] = + s[51] - s[69] - s[47] + s[65];
gout[n*16+5] = + s[60] - s[24] - s[56] + s[20];
gout[n*16+6] = + s[15] - s[33] - s[11] + s[29];
gout[n*16+7] = + s[6] + s[42] + s[78] - s[2] - s[38] - s[74];
gout[n*16+8] = + s[46] - s[64] - s[48] + s[66];
gout[n*16+9] = + s[55] - s[19] - s[57] + s[21];
gout[n*16+10] = + s[10] - s[28] - s[12] + s[30];
gout[n*16+11] = + s[1] + s[37] + s[73] - s[3] - s[39] - s[75];
gout[n*16+12] = + s[45] - s[63] + s[49] - s[67] + s[53] - s[71];
gout[n*16+13] = + s[54] - s[18] + s[58] - s[22] + s[62] - s[26];
gout[n*16+14] = + s[9] - s[27] + s[13] - s[31] + s[17] - s[35];
gout[n*16+15] = + s[0] + s[36] + s[72] + s[4] + s[40] + s[76] + s[8] + s[44] + s[80];
} else {
gout[n*16+0] += + s[50] - s[68] - s[52] + s[70];
gout[n*16+1] += + s[59] - s[23] - s[61] + s[25];
gout[n*16+2] += + s[14] - s[32] - s[16] + s[34];
gout[n*16+3] += + s[5] + s[41] + s[77] - s[7] - s[43] - s[79];
gout[n*16+4] += + s[51] - s[69] - s[47] + s[65];
gout[n*16+5] += + s[60] - s[24] - s[56] + s[20];
gout[n*16+6] += + s[15] - s[33] - s[11] + s[29];
gout[n*16+7] += + s[6] + s[42] + s[78] - s[2] - s[38] - s[74];
gout[n*16+8] += + s[46] - s[64] - s[48] + s[66];
gout[n*16+9] += + s[55] - s[19] - s[57] + s[21];
gout[n*16+10] += + s[10] - s[28] - s[12] + s[30];
gout[n*16+11] += + s[1] + s[37] + s[73] - s[3] - s[39] - s[75];
gout[n*16+12] += + s[45] - s[63] + s[49] - s[67] + s[53] - s[71];
gout[n*16+13] += + s[54] - s[18] + s[58] - s[22] + s[62] - s[26];
gout[n*16+14] += + s[9] - s[27] + s[13] - s[31] + s[17] - s[35];
gout[n*16+15] += + s[0] + s[36] + s[72] + s[4] + s[40] + s[76] + s[8] + s[44] + s[80];
}}}
void int2e_gauge_r2_sps1sps2_optimizer(CINTOpt **opt, int *atm, int natm, int *bas, int nbas, double *env) {
int ng[] = {2, 1, 1, 1, 4, 4, 4, 1};
CINTall_2e_optimizer(opt, ng, atm, natm, bas, nbas, env);
}
int int2e_gauge_r2_sps1sps2_cart(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 1, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r2_sps1sps2;
envs.common_factor *= -1;
return CINT2e_cart_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r2_sps1sps2_cart
int int2e_gauge_r2_sps1sps2_sph(double *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 1, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r2_sps1sps2;
envs.common_factor *= -1;
return CINT2e_spheric_drv(out, dims, &envs, opt, cache);
} // int2e_gauge_r2_sps1sps2_sph
int int2e_gauge_r2_sps1sps2_spinor(double complex *out, int *dims, int *shls,
int *atm, int natm, int *bas, int nbas, double *env, CINTOpt *opt, double *cache) {
int ng[] = {2, 1, 1, 1, 4, 4, 4, 1};
CINTEnvVars envs;
CINTinit_int2e_EnvVars(&envs, ng, shls, atm, natm, bas, nbas, env);
envs.f_gout = &CINTgout2e_int2e_gauge_r2_sps1sps2;
return CINT2e_spinor_drv(out, dims, &envs, opt, cache, &c2s_si_2e1i, &c2s_si_2e2i);
} // int2e_gauge_r2_sps1sps2_spinor
ALL_CINT(int2e_gauge_r2_sps1sps2)
ALL_CINT_FORTRAN_(int2e_gauge_r2_sps1sps2)
