# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SBSku(Model):
    """SKU of the namespace.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of this SKU. Possible values include: 'Basic',
     'Standard', 'Premium'
    :type name: str or ~azure.mgmt.servicebus.models.SkuName
    :param tier: The billing tier of this particular SKU. Possible values
     include: 'Basic', 'Standard', 'Premium'
    :type tier: str or ~azure.mgmt.servicebus.models.SkuTier
    :param capacity: The specified messaging units for the tier. For Premium
     tier, capacity are 1,2 and 4.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'SkuName'},
        'tier': {'key': 'tier', 'type': 'SkuTier'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, *, name, tier=None, capacity: int=None, **kwargs) -> None:
        super(SBSku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity
