import psycopg2
from psycopg2.extras import DictCursor

class Database:

    def __init__(self):

        self.__connection = None
        self.__cursor = None

    def connect(self, user = None, password = None, database = None, host = 'localhost', port = 5432):

        self.__connection = psycopg2.connect(

            host = host,
            port = port,

            user = user,
            password = password,

            database = database
        )

        self.__cursor = self.__connection.cursor(cursor_factory = DictCursor)

        return self

    def commit(self):

        self.__connection.commit()

    def execute(self, query):

        self.__cursor.execute(query)

    def fetch_one(self):

        return self.__cursor.fetchone()

    def fetch_all(self):

        return self.__cursor.fetchall()

    def select(self, table, fields):

        counter, query = 0, 'SELECT * FROM %s WHERE ' % table

        for field in fields:

            counter += 1

            query += '%s = \'%s\'%s' % (field, fields[field], ' AND ' if counter < len(fields) else ' ')

        self.execute(query)

        response = self.fetch_all()

        if response:

            for i in range(0, len(response)):

                response[i] = dict(response[i])

        return response

    def insert(self, table, fields):

        counter, query = 0, 'INSERT INTO %s (' % table

        for field in fields:

            counter += 1

            query += '%s%s' % (field, ', ' if counter < len(fields) else '')

        query += ') VALUES ('

        counter = 0

        for field in fields:

            counter += 1

            query += '\'%s\'%s' % (fields[field], ', ' if counter < len(fields) else '')

        query += ')'

        self.execute(query)

        self.commit()

    def update(self, table, fields, keys):

        counter, _query = 0, ' WHERE '

        for key in keys:

            counter += 1

            _query += '%s = \'%s\'%s' % (key, fields[key], ' AND ' if counter < len(keys) else '')

            del fields[key]

        counter, query = 0, 'UPDATE %s SET ' % table

        for field in fields:

            counter += 1

            query += '%s = \'%s\'%s' % (field, fields[field], ', ' if counter < len(fields) else '')

        self.execute(query + _query)

        self.commit()

    def delete(self, table, fields):

        counter, query = 0, 'DELETE FROM %s WHERE ' % table

        for field in fields:

            counter += 1

            query += '%s = \'%s\'%s' % (field, fields[field], ' AND ' if counter < len(fields) else '')

        self.execute(query)

        self.commit()