# -*- coding: utf-8 -*-
from BeautifulSoup import Tag
from parser import *

class Goal:
    def __init__(self, soup):
        self._id = soup['id']
        self._level = soup.level.text
        self._start_time = parse_datetime(soup.starttime.text)
        self._end_time = soup.endtime.text
        self._completed_time = soup.completedtime.text
        self._type = soup.definition.type.text
        
        self._run_monday = soup.schedule.runmonday.text
        self._run_tuesday = soup.schedule.runtuesday.text
        self._run_wednesday = soup.schedule.runwednesday.text
        self._run_thursday = soup.schedule.runthursday.text
        self._run_friday = soup.schedule.runfriday.text
        self._run_saturday = soup.schedule.runsaturday.text
        self._run_sunday = soup.schedule.runsunday.text
        self._original_daily_amount = soup.schedule.originaldailyamount.text
        self._extended_daily_amount = soup.schedule.extendeddailyamount.text
        
        #i don't know contents in definition-tag...
        for c1 in soup.definition.contents:
            for c2 in c1.contents:
                if isinstance(c2, Tag):
                    setattr(self, c2.name, c2.text)
        
    @property
    def id(self):
        return self._id
    
    @property
    def level(self):
        return self._level
    
    @property
    def start_time(self):
        return self._start_time
    
    @property
    def end_time(self):
        return self._end_time
    
    @property
    def completed_time(self):
        return self._completed_time
    
    @property
    def type(self):
        return self._type
    
    @property
    def run_monday(self):
        return self._run_monday
    
    @property
    def run_tuesday(self):
        return self._run_tuesday
    @property
    def run_wednesday(self):
        return self._run_wednesday
    
    @property
    def run_thursday(self):
        return self._run_thursday
    
    @property
    def run_friday(self):
        return self._run_friday
    
    @property
    def run_saturday(self):
        return self._run_saturday
    
    @property
    def run_sunday(self):
        return self._run_sunay
    
    @property
    def original_daily_amount(self):
        return self._original_daily_amount
    
    @property
    def extended_daily_amount(self):
        return self._extended_daily_amount
        
