# -*- coding: utf-8 -*-
"""
NikePlus library for python
"""
__version__ = '0.21'
__author__ = 'Niseki Manabu'
__license__ = 'MIT'

from base import Base
from run import Run
from singlerun import SingleRun
from userdata import UserData
from record import PersonalRecord
from goal import Goal
from error import NikePlusError

import urllib, urllib2
import cookielib
from BeautifulSoup import BeautifulStoneSoup

class API:
    def __init__(self, login, password, locale = 'ja_JP'):
        self.opener = None

        self.auth(login, password, locale)

    def auth(self, login, password, locale):
        postdata = {}
        postdata['login'] = login
        postdata['password'] = password
        postdata['locale'] = locale
        params = urllib.urlencode(postdata)
        cj = cookielib.CookieJar()
        cjhdr = urllib2.HTTPCookieProcessor(cj)
        opener = urllib2.build_opener(cjhdr)
        soup = BeautifulStoneSoup(opener.open(Base().auth_url, params).read())
        if soup.status.string == 'success':
            self.opener = opener
        else:
            raise NikePlusError("invalid loginname or password")

    def get_run_list(self):
        uri = Base().run_list_url
        data = self.opener.open(uri).read()
        list = []
        soup = BeautifulStoneSoup(data)
        for node in soup.findAll('run'):
            list.append(Run(node))
        return list
    
    def get_run(self, id):
        uri = Base().run_url + '?id=' + str(id)
        data = self.opener.open(uri).read()
        soup = BeautifulStoneSoup(data)
        return SingleRun(soup)

    def get_user_data(self):
        uri = Base().user_data_url
        data = self.opener.open(uri).read()
        soup = BeautifulStoneSoup(data)
        return UserData(soup)

    def get_record_list(self):
        uri = Base().personal_records_url
        data = self.opener.open(uri).read()
        soup = BeautifulStoneSoup(data)
        list = []
        for node in soup.findAll('personalrecord'):
            list.append(PersonalRecord(node))
        return list

    def get_goal_list(self):
        uri = Base().goal_list_url
        data = self.opener.open(uri).read()
        soup = BeautifulStoneSoup(data)
        list = []
        for node in soup.findAll('goal'):
            goal = Goal(node)
            list.append(goal)
        return list
