# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .execution_activity import ExecutionActivity


class SqlServerStoredProcedureActivity(ExecutionActivity):
    """SQL stored procedure activity type.

    :param name: Activity name.
    :type name: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list of :class:`ActivityDependency
     <azure.mgmt.datafactory.models.ActivityDependency>`
    :param type: Polymorphic Discriminator
    :type type: str
    :param linked_service_name: Linked service reference.
    :type linked_service_name: :class:`LinkedServiceReference
     <azure.mgmt.datafactory.models.LinkedServiceReference>`
    :param policy: Activity policy.
    :type policy: :class:`ActivityPolicy
     <azure.mgmt.datafactory.models.ActivityPolicy>`
    :param stored_procedure_name: Stored procedure name. Type: string (or
     Expression with resultType string).
    :type stored_procedure_name: object
    :param stored_procedure_parameters: Value and type setting for stored
     procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
    :type stored_procedure_parameters: dict
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'stored_procedure_name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'type': {'key': 'type', 'type': 'str'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'stored_procedure_name': {'key': 'typeProperties.storedProcedureName', 'type': 'object'},
        'stored_procedure_parameters': {'key': 'typeProperties.storedProcedureParameters', 'type': '{StoredProcedureParameter}'},
    }

    def __init__(self, name, stored_procedure_name, description=None, depends_on=None, linked_service_name=None, policy=None, stored_procedure_parameters=None):
        super(SqlServerStoredProcedureActivity, self).__init__(name=name, description=description, depends_on=depends_on, linked_service_name=linked_service_name, policy=policy)
        self.stored_procedure_name = stored_procedure_name
        self.stored_procedure_parameters = stored_procedure_parameters
        self.type = 'SqlServerStoredProcedure'
