# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .linked_service import LinkedService


class HDInsightLinkedService(LinkedService):
    """HDInsight linked service.

    :param connect_via: The integration runtime reference.
    :type connect_via: :class:`IntegrationRuntimeReference
     <azure.mgmt.datafactory.models.IntegrationRuntimeReference>`
    :param description: Linked service description.
    :type description: str
    :param type: Polymorphic Discriminator
    :type type: str
    :param cluster_uri: HDInsight cluster URI. Type: string (or Expression
     with resultType string).
    :type cluster_uri: object
    :param user_name: HDInsight cluster user name. Type: string (or Expression
     with resultType string).
    :type user_name: object
    :param password: HDInsight cluster password.
    :type password: :class:`SecureString
     <azure.mgmt.datafactory.models.SecureString>`
    :param linked_service_name: The Azure Storage linked service reference.
    :type linked_service_name: :class:`LinkedServiceReference
     <azure.mgmt.datafactory.models.LinkedServiceReference>`
    :param hcatalog_linked_service_name: A reference to the Azure SQL linked
     service that points to the HCatalog database.
    :type hcatalog_linked_service_name: :class:`LinkedServiceReference
     <azure.mgmt.datafactory.models.LinkedServiceReference>`
    :param encrypted_credential: The encrypted credential used for
     authentication. Credentials are encrypted using the integration runtime
     credential manager. Type: string (or Expression with resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'cluster_uri': {'required': True},
    }

    _attribute_map = {
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'cluster_uri': {'key': 'typeProperties.clusterUri', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecureString'},
        'linked_service_name': {'key': 'typeProperties.linkedServiceName', 'type': 'LinkedServiceReference'},
        'hcatalog_linked_service_name': {'key': 'typeProperties.hcatalogLinkedServiceName', 'type': 'LinkedServiceReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(self, cluster_uri, connect_via=None, description=None, user_name=None, password=None, linked_service_name=None, hcatalog_linked_service_name=None, encrypted_credential=None):
        super(HDInsightLinkedService, self).__init__(connect_via=connect_via, description=description)
        self.cluster_uri = cluster_uri
        self.user_name = user_name
        self.password = password
        self.linked_service_name = linked_service_name
        self.hcatalog_linked_service_name = hcatalog_linked_service_name
        self.encrypted_credential = encrypted_credential
        self.type = 'HDInsight'
