# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .dataset_compression import DatasetCompression


class DatasetGZipCompression(DatasetCompression):
    """The GZip compression method used on a dataset.

    :param type: Polymorphic Discriminator
    :type type: str
    :param level: The GZip compression level. Possible values include:
     'Optimal', 'Fastest'
    :type level: str or :class:`DatasetCompressionLevel
     <azure.mgmt.datafactory.models.DatasetCompressionLevel>`
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(self, level=None):
        super(DatasetGZipCompression, self).__init__()
        self.level = level
        self.type = 'GZip'
