# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .dataset import Dataset


class AmazonS3Dataset(Dataset):
    """A single Amazon Simple Storage Service (S3) object or a set of S3 objects.

    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type:
     array (or Expression with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param linked_service_name: Linked service reference.
    :type linked_service_name: :class:`LinkedServiceReference
     <azure.mgmt.datafactory.models.LinkedServiceReference>`
    :param parameters: Parameters for dataset.
    :type parameters: dict
    :param type: Polymorphic Discriminator
    :type type: str
    :param bucket_name: The name of the Amazon S3 bucket. Type: string (or
     Expression with resultType string).
    :type bucket_name: object
    :param key: The key of the Amazon S3 object. Type: string (or Expression
     with resultType string).
    :type key: object
    :param prefix: The prefix filter for the S3 object name. Type: string (or
     Expression with resultType string).
    :type prefix: object
    :param version: The version for the S3 object. Type: string (or Expression
     with resultType string).
    :type version: object
    :param format: The format of files.
    :type format: :class:`DatasetStorageFormat
     <azure.mgmt.datafactory.models.DatasetStorageFormat>`
    :param compression: The data compression method used for the Amazon S3
     object.
    :type compression: :class:`DatasetCompression
     <azure.mgmt.datafactory.models.DatasetCompression>`
    """

    _validation = {
        'linked_service_name': {'required': True},
        'type': {'required': True},
        'bucket_name': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'type': {'key': 'type', 'type': 'str'},
        'bucket_name': {'key': 'typeProperties.bucketName', 'type': 'object'},
        'key': {'key': 'typeProperties.key', 'type': 'object'},
        'prefix': {'key': 'typeProperties.prefix', 'type': 'object'},
        'version': {'key': 'typeProperties.version', 'type': 'object'},
        'format': {'key': 'typeProperties.format', 'type': 'DatasetStorageFormat'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(self, linked_service_name, bucket_name, description=None, structure=None, parameters=None, key=None, prefix=None, version=None, format=None, compression=None):
        super(AmazonS3Dataset, self).__init__(description=description, structure=structure, linked_service_name=linked_service_name, parameters=parameters)
        self.bucket_name = bucket_name
        self.key = key
        self.prefix = prefix
        self.version = version
        self.format = format
        self.compression = compression
        self.type = 'AmazonS3Object'
