#This file is part of Higgins. The COPYRIGHT file at the top level of
#this repository contains the full copyright notices and license
#terms.

import errno
import logging
import os
import subprocess

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger('higgins')


class UserException(Exception):
    pass

def call(command, cwd=None, log_err=False):
    logger.debug('Call command "%s" inside path "%s"' % (
        command, cwd or '.'))
    process = subprocess.Popen(
        command, shell=True, cwd=cwd, stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
    )
    process.wait()
    if process.returncode != 0:
        log = logger.error if log_err else logger.debug
        log('Command "%s" failed inside path "%s"' % (
            command, cwd or '.'))
    return process


def mkdir(path):
    if os.path.exists(path) and os.path.isdir(path):
        return
    try:
        os.makedirs(path)
    except OSError as exc:
        if exc.errno != errno.EEXIST:
            raise
