from distutils.core import setup

try:
    from pypandoc import convert
    read_md = lambda f: convert(f, 'rst')
except ImportError:
    print("warning: pypandoc module not found, could not convert Markdown to RST")
    read_md = lambda f: open(f, 'r').read()

setup(
    name='nocase',
    version='1.0.5',
    packages=['nocase'],
    url='https://github.com/Code-ReaQtor/NoCase',
    download_url='https://github.com/Code-ReaQtor/NoCase/tarball/1.0.5',
    license='GNU Lesser General Public License v2.1',
    author='Ronie Martinez',
    author_email='ronmarti18@gmail.com',
    description='Freely use your coding style',
    long_description=read_md('README.md'),
    keywords = [],
    classifiers = ['Development Status :: 3 - Alpha',
                   'License :: OSI Approved :: GNU Lesser General Public License v2 or later (LGPLv2+)',
                   'Topic :: Software Development :: Libraries :: Python Modules'],
)
