/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;

public abstract class AbstractBrowserLauncher
implements BrowserLauncher {
    protected String sessionId;
    private RemoteControlConfiguration configuration;

    public AbstractBrowserLauncher(String sessionId, RemoteControlConfiguration configuration) {
        this.sessionId = sessionId;
        this.configuration = configuration;
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL, boolean multiWindow, String defaultLogLevel) {
        this.launch(LauncherUtils.getDefaultHTMLSuiteUrl(browserURL, suiteUrl, multiWindow, 0, defaultLogLevel));
    }

    public void launchRemoteSession(String browserURL, boolean multiWindow, BrowserConfigurationOptions browserConfigurationOptions) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl(browserURL, this.sessionId, multiWindow, 0), browserConfigurationOptions);
    }

    public void launchRemoteSession(String browserURL, boolean multiWindow) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl(browserURL, this.sessionId, multiWindow, 0));
    }

    protected abstract void launch(String var1);

    protected void launch(String url, BrowserConfigurationOptions browserConfigurationOptions) {
        if (browserConfigurationOptions.hasOptions()) {
            throw new IllegalArgumentException("This browser does not support overriding the default browser configuration");
        }
        this.launch(url);
    }

    public RemoteControlConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getPort() {
        return this.configuration.getPortDriversShouldContact();
    }
}

