/**
  * Class definition for a MicrobitFont
  * It represents a font that can be used by the display to render text.
  */

#include "MicroBit.h"

/**
  * The original MicroBit font.
  * The font is 5x5.
  * Each Row is represented by a byte in the array.
  * 
  * Row Format:|  N/A  |  N/A  |  N/A  | Col 1 | Col 2 | Col 3 | Col 4 | Col 5 |
  *            |  0x80 |  0x40 |  0x20 | 0x10  | 0x08  | 0x04  | 0x02  | 0x01  |
  *
  * Example: { 0x08, 0x08, 0x08, 0x0, 0x08 }
  *
  * The above will produce an exclaimation mark on the second column in form the left.
  *
  * We could compress further, but the complexity of decode would likely outweigh the gains.
  */

/*
const unsigned char bpdotunicase[475] = {0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x8, 0x8, 0x0, 0x8, 0xa, 0x4a, 0x40, 0x0, 0x0, 0xa, 0x5f, 0xea, 0x5f, 0xea, 0xe, 0xd9, 0x2e, 0xd3, 0x6e, 0x19, 0x32, 0x44, 0x89, 0x33, 0xc, 0x92, 0x4c, 0x92, 0x4d, 0x8, 0x8, 0x0, 0x0, 0x0, 0x4, 0x88, 0x8, 0x8, 0x4, 0x8, 0x4, 0x84, 0x84, 0x88, 0x0, 0xa, 0x44, 0x8a, 0x40, 0x0, 0x4, 0x8e, 0xc4, 0x80, 0x0, 0x0, 0x0, 0x4, 0x88, 0x0, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x1, 0x22, 0x44, 0x88, 0x10, 0xe, 0xd3, 0x75, 0xb9, 0x2e, 0x1c, 0x84, 0x84, 0x84, 0x9f, 0xe, 0xd1, 0x26, 0xd0, 0x1f, 0x1e, 0xc1, 0x2e, 0xc1, 0x3e, 0x2, 0x46, 0xca, 0x5f, 0xe2, 0x1f, 0xf0, 0x1e, 0xc1, 0x3e, 0xe, 0xd0, 0x1e, 0xd1, 0x2e, 0x1f, 0xe1, 0x22, 0x44, 0x88, 0xe, 0xd1, 0x2e, 0xd1, 0x2e, 0xe, 0xd1, 0x2f, 0xe1, 0x2e, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x4, 0x80, 0x4, 0x88, 0x2, 0x44, 0x88, 0x4, 0x82, 0x0, 0xe, 0xc0, 0xe, 0xc0, 0x8, 0x4, 0x82, 0x44, 0x88, 0xe, 0xd1, 0x26, 0xc0, 0x4, 0xe, 0xd1, 0x35, 0xb3, 0x6c, 0xe, 0xd1, 0x3f, 0xf1, 0x31, 0x1e, 0xd1, 0x3e, 0xd1, 0x3e, 0xf, 0xf0, 0x10, 0x10, 0xf, 0x1e, 0xd1, 0x31, 0x31, 0x3e, 0x1f, 0xf0, 0x1e, 0xd0, 0x1f, 0x1f, 0xf0, 0x1e, 0xd0, 0x10, 0xf, 0xf0, 0x13, 0x71, 0x2f, 0x11, 0x31, 0x3f, 0xf1, 0x31, 0x1f, 0xe4, 0x84, 0x84, 0x9f, 0x1f, 0xe1, 0x21, 0x31, 0x2e, 0x11, 0x31, 0x3e, 0xd1, 0x31, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x11, 0x3b, 0x75, 0xb5, 0xb1, 0x11, 0x39, 0x35, 0xb3, 0x71, 0xe, 0xd1, 0x31, 0x31, 0x2e, 0x1e, 0xd1, 0x3e, 0xd0, 0x10, 0xe, 0xd1, 0x35, 0xae, 0xc4, 0x1e, 0xd1, 0x3e, 0xd2, 0x51, 0xf, 0xf0, 0xe, 0xc1, 0x3e, 0x1f, 0xe4, 0x84, 0x84, 0x84, 0x11, 0x31, 0x31, 0x31, 0x2e, 0x11, 0x31, 0x31, 0x2a, 0x44, 0x11, 0x35, 0xb5, 0xb5, 0xaa, 0x11, 0x31, 0x2e, 0xd1, 0x31, 0x11, 0x31, 0x2a, 0x44, 0x84, 0x1f, 0xe2, 0x44, 0x88, 0x1f, 0xe, 0xc8, 0x8, 0x8, 0xe, 0x10, 0x8, 0x4, 0x82, 0x41, 0xe, 0xc2, 0x42, 0x42, 0x4e, 0x4, 0x8a, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x8, 0x4, 0x80, 0x0, 0x0, 0xe, 0xd1, 0x2f, 0xf1, 0x2f, 0x1e, 0xd1, 0x3e, 0xd1, 0x3e, 0xe, 0xd1, 0x30, 0x11, 0x2e, 0x1e, 0xd1, 0x31, 0x31, 0x3e, 0xe, 0xd1, 0x3f, 0xf0, 0xf, 0x1f, 0xf0, 0x1e, 0xd0, 0x10, 0xf, 0xf0, 0x13, 0x71, 0x2f, 0x11, 0x31, 0x3f, 0xf1, 0x31, 0x1c, 0x84, 0x84, 0x84, 0x9f, 0x1e, 0xc2, 0x42, 0x52, 0x4c, 0x11, 0x31, 0x3e, 0xd1, 0x31, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x15, 0xbf, 0xf5, 0xb5, 0xb5, 0x16, 0xd9, 0x31, 0x31, 0x31, 0xe, 0xd1, 0x31, 0x31, 0x2e, 0x1e, 0xd1, 0x3e, 0xd0, 0x10, 0xe, 0xd1, 0x35, 0xae, 0xc4, 0x1b, 0x6c, 0x88, 0x8, 0x1e, 0xf, 0xf0, 0xe, 0xc1, 0x3e, 0x1f, 0xe4, 0x84, 0x84, 0x84, 0x11, 0x31, 0x31, 0x33, 0x6d, 0x11, 0x31, 0x2a, 0x4a, 0x44, 0x11, 0x35, 0xb5, 0xaa, 0x4a, 0x11, 0x31, 0x2e, 0xd1, 0x31, 0x11, 0x31, 0x2a, 0x44, 0x84, 0x1f, 0xe2, 0x44, 0x88, 0x1f, 0x6, 0xc4, 0x8c, 0x84, 0x86, 0x8, 0x8, 0x8, 0x8, 0x8, 0x18, 0x8, 0xc, 0x88, 0x18, 0x0, 0x0, 0xc, 0x83, 0x60};
*/

const unsigned char pendolino3[475] = {
0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x8, 0x8, 0x0, 0x8, 0xa, 0x4a, 0x40, 0x0, 0x0, 0xa, 0x5f, 0xea, 0x5f, 0xea, 0xe, 0xd9, 0x2e, 0xd3, 0x6e, 0x19, 0x32, 0x44, 0x89, 0x33, 0xc, 0x92, 0x4c, 0x92, 0x4d, 0x8, 0x8, 0x0, 0x0, 0x0, 0x4, 0x88, 0x8, 0x8, 0x4, 0x8, 0x4, 0x84, 0x84, 0x88, 0x0, 0xa, 0x44, 0x8a, 0x40, 0x0, 0x4, 0x8e, 0xc4, 0x80, 0x0, 0x0, 0x0, 0x4, 0x88, 0x0, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x1, 0x22, 0x44, 0x88, 0x10, 0xc, 0x92, 0x52, 0x52, 0x4c, 0x4, 0x8c, 0x84, 0x84, 0x8e, 0x1c, 0x82, 0x4c, 0x90, 0x1e, 0x1e, 0xc2, 0x44, 0x92, 0x4c, 0x6, 0xca, 0x52, 0x5f, 0xe2, 0x1f, 0xf0, 0x1e, 0xc1, 0x3e, 0x2, 0x44, 0x8e, 0xd1, 0x2e, 0x1f, 0xe2, 0x44, 0x88, 0x10, 0xe, 0xd1, 0x2e, 0xd1, 0x2e, 0xe, 0xd1, 0x2e, 0xc4, 0x88, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x4, 0x80, 0x4, 0x88, 0x2, 0x44, 0x88, 0x4, 0x82, 0x0, 0xe, 0xc0, 0xe, 0xc0, 0x8, 0x4, 0x82, 0x44, 0x88, 0xe, 0xd1, 0x26, 0xc0, 0x4, 0xe, 0xd1, 0x35, 0xb3, 0x6c, 0xc, 0x92, 0x5e, 0xd2, 0x52, 0x1c, 0x92, 0x5c, 0x92, 0x5c, 0xe, 0xd0, 0x10, 0x10, 0xe, 0x1c, 0x92, 0x52, 0x52, 0x5c, 0x1e, 0xd0, 0x1c, 0x90, 0x1e, 0x1e, 0xd0, 0x1c, 0x90, 0x10, 0xe, 0xd0, 0x13, 0x71, 0x2e, 0x12, 0x52, 0x5e, 0xd2, 0x52, 0x1c, 0x88, 0x8, 0x8, 0x1c, 0x1f, 0xe2, 0x42, 0x52, 0x4c, 0x12, 0x54, 0x98, 0x14, 0x92, 0x10, 0x10, 0x10, 0x10, 0x1e, 0x11, 0x3b, 0x75, 0xb1, 0x31, 0x11, 0x39, 0x35, 0xb3, 0x71, 0xc, 0x92, 0x52, 0x52, 0x4c, 0x1c, 0x92, 0x5c, 0x90, 0x10, 0xc, 0x92, 0x52, 0x4c, 0x86, 0x1c, 0x92, 0x5c, 0x92, 0x51, 0xe, 0xd0, 0xc, 0x82, 0x5c, 0x1f, 0xe4, 0x84, 0x84, 0x84, 0x12, 0x52, 0x52, 0x52, 0x4c, 0x11, 0x31, 0x31, 0x2a, 0x44, 0x11, 0x31, 0x35, 0xbb, 0x71, 0x12, 0x52, 0x4c, 0x92, 0x52, 0x11, 0x2a, 0x44, 0x84, 0x84, 0x1e, 0xc4, 0x88, 0x10, 0x1e, 0xe, 0xc8, 0x8, 0x8, 0xe, 0x10, 0x8, 0x4, 0x82, 0x41, 0xe, 0xc2, 0x42, 0x42, 0x4e, 0x4, 0x8a, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x8, 0x4, 0x80, 0x0, 0x0, 0x0, 0xe, 0xd2, 0x52, 0x4f, 0x10, 0x10, 0x1c, 0x92, 0x5c, 0x0, 0xe, 0xd0, 0x10, 0xe, 0x2, 0x42, 0x4e, 0xd2, 0x4e, 0xc, 0x92, 0x5c, 0x90, 0xe, 0x6, 0xc8, 0x1c, 0x88, 0x8, 0xe, 0xd2, 0x4e, 0xc2, 0x4c, 0x10, 0x10, 0x1c, 0x92, 0x52, 0x8, 0x0, 0x8, 0x8, 0x8, 0x2, 0x40, 0x2, 0x42, 0x4c, 0x10, 0x14, 0x98, 0x14, 0x92, 0x8, 0x8, 0x8, 0x8, 0x6, 0x0, 0x1b, 0x75, 0xb1, 0x31, 0x0, 0x1c, 0x92, 0x52, 0x52, 0x0, 0xc, 0x92, 0x52, 0x4c, 0x0, 0x1c, 0x92, 0x5c, 0x90, 0x0, 0xe, 0xd2, 0x4e, 0xc2, 0x0, 0xe, 0xd0, 0x10, 0x10, 0x0, 0x6, 0xc8, 0x4, 0x98, 0x8, 0x8, 0xe, 0xc8, 0x7, 0x0, 0x12, 0x52, 0x52, 0x4f, 0x0, 0x11, 0x31, 0x2a, 0x44, 0x0, 0x11, 0x31, 0x35, 0xbb, 0x0, 0x12, 0x4c, 0x8c, 0x92, 0x0, 0x11, 0x2a, 0x44, 0x98, 0x0, 0x1e, 0xc4, 0x88, 0x1e, 0x6, 0xc4, 0x8c, 0x84, 0x86, 0x8, 0x8, 0x8, 0x8, 0x8, 0x18, 0x8, 0xc, 0x88, 0x18, 0x0, 0x0, 0xc, 0x83, 0x60};


const unsigned char* MicroBitFont::defaultFont = pendolino3;

/**
  * Constructor.
  * Sets the font represented by this font object.
  * @param characters A pointer to the beginning of the new character values for this font.
  * @param asciiEnd the char value at which this font finishes.
  *
  * @note see main_font_test.cpp in the test folder for an example.
  */
MicroBitFont::MicroBitFont(const unsigned char* characters, int asciiEnd)
{
    this->characters = characters;   
    this->asciiEnd = asciiEnd;   
}

/**
  * Default Constructor.
  * Sets the characters to defaultFont characters and asciiEnd to MICROBIT_FONT_ASCII_END.
  */
MicroBitFont::MicroBitFont()
{
    this->characters = defaultFont;   
    this->asciiEnd = MICROBIT_FONT_ASCII_END;   
}    
