#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# C++ version Copyright (c) 2006-2007 Erin Catto http://www.box2d.org
# Python version Copyright (c) 2010 Ken Lauer / sirkne at gmail dot com
# 
# This software is provided 'as-is', without any express or implied
# warranty.  In no event will the authors be held liable for any damages
# arising from the use of this software.
# Permission is granted to anyone to use this software for any purpose,
# including commercial applications, and to alter it and redistribute it
# freely, subject to the following restrictions:
# 1. The origin of this software must not be misrepresented; you must not
# claim that you wrote the original software. If you use this software
# in a product, an acknowledgment in the product documentation would be
# appreciated but is not required.
# 2. Altered source versions must be plainly marked as such, and must not be
# misrepresented as being the original software.
# 3. This notice may not be removed or altered from any source distribution.

__version__ = "$Revision: 337 $"
__date__ = "$Date: 2011-05-19 16:44:08 -0400 (Thu, 19 May 2011) $"
# $Source$

from framework import *

class BodyTypes(Framework):
    name="Body Types"
    description="Change body type keys: (d) dynamic, (s) static, (k) kinematic"
    speed = 3 # platform speed
    def __init__(self):
        super(BodyTypes, self).__init__()

        # The ground
        ground = self.world.create_static_body(shapes=shapes.Edge((-20,0),(20,0)))

        # The attachment
        self.attachment=self.world.create_dynamic_body(
                    position=(0,3), 
                    fixtures=b2.Fixture(shape=b2.Polygon(box=(0.5,2)), density=2.0),
                )

        # The platform
        fixture=b2.Fixture(
                shape=b2.Polygon(box=(4,0.5)), 
                density=2,
                friction=0.6,
                )
               
        self.platform=self.world.create_dynamic_body(
                    position=(0,5), 
                    fixtures=fixture,
                )
        
        # The joints joining the attachment/platform and ground/platform
        self.world.create_revolute_joint(
                self.attachment, self.platform,
                anchor=(0,5),
                max_motor_torque=50,
                motor_enabled=True
            )

        self.world.create_prismatic_joint(
                ground, self.platform,
                anchor=(0,5),
                axis=(1,0),
                max_motor_force = 1000,
                motor_enabled = True,
                lower_limit = -10,
                upper_limit = 10,
                limit_enabled = True 
            )

        # And the payload that initially sits upon the platform
        # Reusing the fixture we previously defined above
        fixture.shape.set_as_box(0.75, 0.75)
        self.payload=self.world.create_dynamic_body(
                    position=(0,8), 
                    fixtures=fixture,
                )

    def key_down(self, key):
        if key==Keys.K_d:
            self.platform.type=b2.Body.DYNAMIC
        elif key==Keys.K_s:
            self.platform.type=b2.Body.STATIC
        elif key==Keys.K_k:
            self.platform.type=b2.Body.KINEMATIC
            self.platform.linear_velocity=(-self.speed, 0)
            self.platform.angular_velocity=0

    def post_step(self):
        if self.platform.type==b2.Body.KINEMATIC:
            p = self.platform.transform.position
            v = self.platform.linear_velocity
            if ((p.x < -10 and v.x < 0) or (p.x > 10 and v.x > 0)):
                v.x = -v.x
                self.platform.linear_velocity = v

if __name__=="__main__":
     main(BodyTypes)

