# -*- coding: utf-8 -*-
import datetime
from django.utils.translation import ugettext_lazy as _


_COUNTRY_LIST = (
    'NONE',
    'AFGHANISTAN',
    'ALBANIA',
    'ALGERIA',
    'AMERICAN SAMOA',
    'ANDORRA',
    'ANGOLA',
    'ANGUILLA',
    'ANTARTICA',
    'ANTIGUA & BARBUDA',
    'ARGENTINA',
    'ARMENIA',
    'ARUBA',
    'AUSTRALIA',
    'AUSTRIA',
    'AZERBAIJAN',
    'BAHAMAS',
    'BAHRAIN',
    'BANGLADESH',
    'BARBADOS',
    'BELARUS',
    'BELGIUM',
    'BELIZE',
    'BENIN',
    'BERMUDA',
    'BHUTAN',
    'BOSNIA & HERZEGOWINA',
    'BOTSWANA',
    'BOUVET ISLAND',
    'BRAZIL',
    'BRITISH INDIAN OCEAN TERRITORY',
    'BRUNEI',
    'BULGARIA',
    'BURKINA FASO',
    'BURUNDI',
    'CAMAROON',
    'CAMBODIA',
    'CANADA',
    'CAPE VERDE',
    'CAYMAN ISLANDS',
    'CENTRAL AFICA REPUBLIC',
    'CHAD',
    'CHANNEL ISLANDS, GUERNSEY',
    'CHANNEL ISLANDS, JERSEY',
    'CHILE',
    'CHINA',
    'CHRISTMAS ISLAND',
    'COCO ISLANDS',
    'COLUMBIA',
    'COMOROS',
    'CONGO',
    'COOK ISLANDS',
    'COSTA RICA',
    'COTE DE IVOIRE',
    'CROATIA',
    'CUBA',
    'CYPRUS',
    'CZECH REPUBLIC',
    'DENMARK',
    'DJIBOUTI',
    'DOMINICA',
    'DOMINICAN REPUBLIC',
    'EAST TIMOR',
    'ECUADOR',
    'EGYPT',
    'EL SALVADOR',
    'EQUATORIAL GUINEA',
    'ERITREA',
    'ESTONIA',
    'ETHIOPIA',
    'FALKLAND ISLANDS',
    'FAROE ISLANDS',
    'FIJI',
    'FINLAND',
    'FRANCE',
    'FRENCH GUIANA',
    'FRENCH METROPOLITAN',
    'FRENCH POLYNESIA',
    'FRENCH SOUTHERN TERRITORIES',
    'GABON',
    'GAMBIA',
    'GEORGIA',
    'GERMANY',
    'GHANA',
    'GIBRALTAR',
    'GREECE',
    'GREENLAND',
    'GRENADA',
    'GUADELOPE',
    'GUAM',
    'GUATEMALA',
    'GUINEA',
    'GUYANA',
    'HAITI',
    'HEARD & MCDONALD ISLANDS',
    'HONDURAS',
    'HONGKONG',
    'HUNGARY',
    'ICELAND',
    'INDIA',
    'INDONESIA',
    'IRAN',
    'IRAQ',
    'IRELAND',
    'ISLE OF MAN',
    'ISRAEL',
    'ITALY',
    'JAMAICA',
    'JAPAN',
    'JORDAN',
    'KAZAKHSTAN',
    'KENYA',
    'KIRIBATI',
    'KOREA, REPUBLIC',
    'KUWAIT',
    'KYRGYZSTAN',
    'LAOS',
    'LATVIA',
    'LEBANON',
    'LESOTHO',
    'LIBERIA',
    'LIBYAN ARAB JAMAHIRIYA',
    'LIECHTENSTEIN',
    'LITHUANIA',
    'LUXEMBOURG',
    'MACAO',
    'MACEDONIA',
    'MADAGASCAR',
    'MALAWI',
    'MALAYSIA',
    'MALI',
    'MALTA',
    'MARSHALL ISLANDS',
    'MARTINIQUE',
    'MAURITANIA',
    'MAURITIUS',
    'MAYOTTE',
    'MEXICO',
    'MICRONESIA',
    'MOLDOVA',
    'MONACO',
    'MONGOLIA',
    'MONTSERRAT',
    'MOROCCO',
    'MOZAMBIQUE',
    'MYANMAR',
    'NAMIBIA',
    'NAURU',
    'NEPAL',
    'NETHERLANDS',
    'NETHERLANDS ANTILLES',
    'NEW CALEDONIA',
    'NEW ZEALAND',
    'NICARAGUA',
    'NIGER',
    'NIGERIA',
    'NIUE',
    'NORFOLK ISLAND',
    'NORTH KOREA',
    'NORTH MARIANA ISLANDS',
    'NORWAY',
    'OMAN',
    'PAKISTAN',
    'PALAU',
    'PALESTINE',
    'PANAMA',
    'PAPUA NEW GUINEA',
    'PARAGUAY',
    'PERU',
    'PHILIPPINES',
    'PITCAIRN',
    'POLAND',
    'PORTUGAL',
    'PUERTO RICO',
    'QATAR',
    'REUNION',
    'ROMANIA',
    'RUSSIA',
    'RWANDA',
    'SAMOA',
    'SAN MARINO',
    'SAO TOME & PRINCIPE',
    'SAUDI ARABIA',
    'SENEGAL',
    'SEYCHELLES',
    'SIERRA LEONE',
    'SINGAPORE',
    'SLOVAKIA',
    'SLOVENIA',
    'SOLOMON ISLANDS',
    'SOMALIA',
    'SOUTH AFRICA',
    'SOUTH GEORGIA & SANDWICH IS.',
    'SPAIN',
    'SRI LANKA',
    'ST HELENA',
    'ST KITTS & NEVIS',
    'ST LUCIA',
    'ST PIERRE & MIQUELON',
    'ST VINCENT & THE GRENADINES',
    'SUDAN',
    'SURINAM',
    'SVALBARD & JAN MAYEN ISLANDS',
    'SWAZILAND',
    'SWEDEN',
    'SWITZERLAND',
    'SYRIA',
    'TAIWAN',
    'TAJIKISTAN',
    'TANZANIA',
    'THAILAND',
    'TONGA',
    'TRINIDAD & TOBAGO',
    'TUNISIA',
    'TURKEY',
    'TURKMENISTAN',
    'TURKS & CAICOS ISLANDS',
    'TUVALU',
    'UGANDA',
    'UKRAINE',
    'UNITED ARAB EMIRATES',
    'UNITED KINGDOM',
    'UNITED STATES',
    'URUGUAY',
    'US MINOR OUTLYING ISLANDS',
    'UZBEKISTAN',
    'VANUATU',
    'VATICAN CITY STATE',
    'VENEZUELA',
    'VIETNAM',
    'VIRGIN ISLANDS (BRITISH)',
    'VIRGIN ISLANDS (US)',
    'WALLIS & FUTUNA ISLANDS',
    'WESTERN SAHARA',
    'YEMEN',
    'YUGOSLAVIA',
    'ZAIRE',
    'ZAMBIA',
    'ZIMBABWE',
)

_ZODIAC_WEST_LIST = [
    {'name': _('Aquarius'), 'start_date': {'month': 1, 'day': 20}, 'end_date': {'month': 2, 'day': 18}},
    {'name': 'Pisces', 'start_date': {'month': 2, 'day': 19}, 'end_date': {'month': 3, 'day': 20}},
    {'name': 'Aries', 'start_date': {'month': 3, 'day': 21}, 'end_date': {'month': 4, 'day': 19}},
    {'name': 'Taurus', 'start_date': {'month': 4, 'day': 20}, 'end_date': {'month': 5, 'day': 20}},
    {'name': 'Gemini', 'start_date': {'month': 5, 'day': 21}, 'end_date': {'month': 6, 'day': 21}},
    {'name': 'Cancer', 'start_date': {'month': 6, 'day': 22}, 'end_date': {'month': 7, 'day': 22}},
    {'name': 'Leo', 'start_date': {'month': 7, 'day': 23}, 'end_date': {'month': 8, 'day': 22}},
    {'name': 'Virgo', 'start_date': {'month': 8, 'day': 23}, 'end_date': {'month': 9, 'day': 22}},
    {'name': 'Libra', 'start_date': {'month': 9, 'day': 23}, 'end_date': {'month': 10, 'day': 23}},
    {'name': 'Scorpio', 'start_date': {'month': 10, 'day': 24}, 'end_date': {'month': 11, 'day': 21}},
    {'name': 'Sagittarius', 'start_date': {'month': 11, 'day': 22}, 'end_date': {'month': 12, 'day': 21}},
    {'name': 'Capricorn', 'start_date': {'month': 12, 'day': 22}, 'end_date': {'month': 1, 'day': 19}},
]

_BMI_LIST = [
    {'start_value': 0.1, 'end_value': 18.4, 'description': 'underweight'},
    {'start_value': 18.5, 'end_value': 24.9, 'description': 'heath weigh'},
    {'start_value': 25.0, 'end_value': 29.9, 'description': 'overweight'},
    {'start_value': 30.0, 'end_value': 99.0, 'description': 'obese'},
]


_BLOOD_GROUP = (
    {'name': 'A', 'donate': ['A', 'AB'], 'accept': ['A', 'O']},
    {'name': 'B', 'donate': ['B', 'AB'], 'accept': ['B', 'O']},
    {'name': 'AB', 'donate': ['AB'], 'accept': ['A', 'B', 'AB', 'O']},
    {'name': 'O', 'donate': ['A', 'B', 'AB', 'O'], 'accept': ['O']},
    {'name': 'A+', 'donate': ['A+', 'AB+'], 'accept': ['A+', 'A-', 'O+', 'O-']},
    {'name': 'B+', 'donate': ['B+', 'AB+'], 'accept': ['B+', 'B-', 'O+', 'O-']},
    {'name': 'AB+', 'donate': ['AB+'], 'accept': ['A+', 'A-', 'B+', 'B-', 'AB+', 'AB-', 'O+', 'O-']},
    {'name': 'O+', 'donate': ['A+', 'B+', 'AB+', 'O+'], 'accept': ['O+', 'O-']},
    {'name': 'A-', 'donate': ['A-', 'AB-'], 'accept': ['A-', 'O-']},
    {'name': 'B-', 'donate': ['B-', 'AB-'], 'accept': ['B-', 'O-']},
    {'name': 'AB-', 'donate': ['AB+', 'AB-'], 'accept': ['A-', 'B-', 'AB-', 'O-']},
    {'name': 'O-', 'donate': ['A+', 'A-', 'B+', 'B-', 'AB+', 'AB-', 'O+', 'O-'], 'accept': ['O-']},
)


_MONTH_LIST = {
    'January': '01',
    'February': '02',
    'March': '03',
    'April': '04',
    'May': '05',
    'June': '06',
    'July': '07',
    'August': '08',
    'September': '09',
    'October': '10',
    'November': '11',
    'December': '12',
}