# -*- coding: utf-8 -*-
# Generated by Django 1.10 on 2017-09-04 21:51
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Birthday',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True)),
                ('modified_time', models.DateTimeField(auto_now=True)),
                ('active_status', models.BooleanField(default=True)),
                ('comment', models.TextField(blank=True, null=True, verbose_name=b'Comments')),
                ('date', models.DateField(blank=True, null=True)),
                ('horoscope', models.CharField(blank=True, choices=[(b'AQU', b'Aquarius'), (b'PIS', b'Pisces'), (b'ARI', b'Aries'), (b'TAU', b'Taurus'), (b'GEM', b'Gemini'), (b'CAN', b'Cancer'), (b'LEO', b'Leo'), (b'VIR', b'Virgo'), (b'LIB', b'Libra'), (b'SCO', b'Scorpio'), (b'SAG', b'Sagittarius'), (b'CAP', b'Capricorn')], max_length=5, null=True)),
                ('user', models.ForeignKey(blank=True, default=b'', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Birthday',
            },
        ),
        migrations.CreateModel(
            name='BloodGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True)),
                ('modified_time', models.DateTimeField(auto_now=True)),
                ('active_status', models.BooleanField(default=True)),
                ('comment', models.TextField(blank=True, null=True, verbose_name=b'Comments')),
                ('name', models.CharField(blank=True, max_length=4, null=True)),
                ('user', models.ForeignKey(blank=True, default=b'', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'BloodGroup',
            },
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True)),
                ('modified_time', models.DateTimeField(auto_now=True)),
                ('active_status', models.BooleanField(default=True)),
                ('comment', models.TextField(blank=True, null=True, verbose_name=b'Comments')),
                ('name', models.CharField(db_index=True, help_text='country_help_text', max_length=128, unique=True, verbose_name='country')),
                ('country_code', models.CharField(blank=True, default=b'', max_length=12, null=True)),
                ('flag_pic', models.ImageField(blank=True, default=b'', null=True, upload_to=b'django_common_feature/location/country/')),
                ('user', models.ForeignKey(blank=True, default=b'', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Country',
                'verbose_name_plural': 'Countries',
            },
        ),
        migrations.CreateModel(
            name='Gender',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True)),
                ('modified_time', models.DateTimeField(auto_now=True)),
                ('active_status', models.BooleanField(default=True)),
                ('comment', models.TextField(blank=True, null=True, verbose_name=b'Comments')),
                ('name', models.CharField(blank=True, choices=[(b'N/A', 'None'), (b'M', 'Male'), (b'F', 'Female')], max_length=2, null=True)),
                ('user', models.ForeignKey(blank=True, default=b'', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Gender',
            },
        ),
        migrations.CreateModel(
            name='Holiday',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True)),
                ('modified_time', models.DateTimeField(auto_now=True)),
                ('active_status', models.BooleanField(default=True)),
                ('comment', models.TextField(blank=True, null=True, verbose_name=b'Comments')),
                ('date', models.DateField()),
                ('name', models.CharField(max_length=32)),
                ('description', models.TextField(blank=True, default=None, null=True)),
                ('country', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='common_feature.Country')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Lock',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True)),
                ('modified_time', models.DateTimeField(auto_now=True)),
                ('active_status', models.BooleanField(default=True)),
                ('comment', models.TextField(blank=True, null=True, verbose_name=b'Comments')),
                ('name', models.CharField(db_index=True, max_length=32, unique=True)),
                ('counter', models.BigIntegerField(default=0)),
                ('user', models.ForeignKey(blank=True, default=b'', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Lock',
            },
        ),
        migrations.CreateModel(
            name='PhysicalBody',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True)),
                ('modified_time', models.DateTimeField(auto_now=True)),
                ('active_status', models.BooleanField(default=True)),
                ('comment', models.TextField(blank=True, null=True, verbose_name=b'Comments')),
                ('height', models.DecimalField(blank=True, decimal_places=3, max_digits=16, null=True)),
                ('height_unit', models.CharField(blank=True, choices=[(b'cm', b'centimeter'), (b'm', b'meter')], default=b'm', max_length=5, null=True)),
                ('weight', models.DecimalField(blank=True, decimal_places=3, max_digits=16, null=True)),
                ('weight_unit', models.CharField(blank=True, choices=[(b'g', b'gram'), (b'kg', b'kilogram')], default=b'kg', max_length=5, null=True)),
                ('BMI', models.DecimalField(blank=True, decimal_places=3, max_digits=16, null=True)),
                ('user', models.ForeignKey(blank=True, default=b'', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Sqlcode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True)),
                ('modified_time', models.DateTimeField(auto_now=True)),
                ('active_status', models.BooleanField(default=True)),
                ('comment', models.TextField(blank=True, null=True, verbose_name=b'Comments')),
                ('name', models.CharField(max_length=100)),
                ('code', models.TextField(blank=True, default=b'', null=True)),
                ('user', models.ForeignKey(blank=True, default=b'', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'SQL code',
                'verbose_name_plural': 'SQL codes',
            },
        ),
        migrations.CreateModel(
            name='State',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True)),
                ('modified_time', models.DateTimeField(auto_now=True)),
                ('active_status', models.BooleanField(default=True)),
                ('comment', models.TextField(blank=True, null=True, verbose_name=b'Comments')),
                ('name', models.CharField(db_index=True, help_text='state_help_text', max_length=128, unique=True, verbose_name='state')),
                ('country', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='common_feature.Country')),
                ('user', models.ForeignKey(blank=True, default=b'', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'State',
                'verbose_name_plural': 'States',
            },
        ),
        migrations.AddField(
            model_name='holiday',
            name='state',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='common_feature.State'),
        ),
        migrations.AddField(
            model_name='holiday',
            name='user',
            field=models.ForeignKey(blank=True, default=b'', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
    ]
